/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.internal;

import com.amazonaws.Request;
import com.amazonaws.handlers.AbstractRequestHandler;
import com.amazonaws.services.route53.model.AliasTarget;
import com.amazonaws.services.route53.model.ChangeInfo;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsResult;
import com.amazonaws.services.route53.model.CreateHostedZoneResult;
import com.amazonaws.services.route53.model.DeleteHostedZoneResult;
import com.amazonaws.services.route53.model.GetChangeResult;
import com.amazonaws.services.route53.model.GetHostedZoneResult;
import com.amazonaws.services.route53.model.HostedZone;
import com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import com.amazonaws.util.TimingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Route53IdRequestHandler
extends AbstractRequestHandler {
    @Override
    public void afterResponse(Request<?> request, Object obj, TimingInfo timingInfo) {
        block3: {
            block8: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    if (!(obj instanceof ChangeResourceRecordSetsResult)) break block2;
                                    ChangeResourceRecordSetsResult result = (ChangeResourceRecordSetsResult)obj;
                                    this.removePrefix(result.getChangeInfo());
                                    break block3;
                                }
                                if (!(obj instanceof CreateHostedZoneResult)) break block4;
                                CreateHostedZoneResult result = (CreateHostedZoneResult)obj;
                                this.removePrefix(result.getChangeInfo());
                                this.removePrefix(result.getHostedZone());
                                break block3;
                            }
                            if (!(obj instanceof DeleteHostedZoneResult)) break block5;
                            DeleteHostedZoneResult result = (DeleteHostedZoneResult)obj;
                            this.removePrefix(result.getChangeInfo());
                            break block3;
                        }
                        if (!(obj instanceof GetChangeResult)) break block6;
                        GetChangeResult result = (GetChangeResult)obj;
                        this.removePrefix(result.getChangeInfo());
                        break block3;
                    }
                    if (!(obj instanceof GetHostedZoneResult)) break block7;
                    GetHostedZoneResult result = (GetHostedZoneResult)obj;
                    this.removePrefix(result.getHostedZone());
                    break block3;
                }
                if (!(obj instanceof ListHostedZonesResult)) break block8;
                ListHostedZonesResult result = (ListHostedZonesResult)obj;
                for (HostedZone zone : result.getHostedZones()) {
                    this.removePrefix(zone);
                }
                break block3;
            }
            if (!(obj instanceof ListResourceRecordSetsResult)) break block3;
            ListResourceRecordSetsResult result = (ListResourceRecordSetsResult)obj;
            for (ResourceRecordSet rrset : result.getResourceRecordSets()) {
                this.removePrefix(rrset);
            }
        }
    }

    private void removePrefix(ResourceRecordSet rrset) {
        if (rrset == null) {
            return;
        }
        this.removePrefix(rrset.getAliasTarget());
        rrset.setSetIdentifier(this.removePrefix(rrset.getSetIdentifier()));
    }

    private void removePrefix(AliasTarget aliasTarget) {
        if (aliasTarget == null) {
            return;
        }
        aliasTarget.setHostedZoneId(this.removePrefix(aliasTarget.getHostedZoneId()));
    }

    private void removePrefix(ChangeInfo changeInfo) {
        if (changeInfo == null) {
            return;
        }
        if (changeInfo.getId() != null) {
            changeInfo.setId(this.removePrefix(changeInfo.getId()));
        }
    }

    private void removePrefix(HostedZone hostedZone) {
        if (hostedZone == null) {
            return;
        }
        if (hostedZone.getId() != null) {
            hostedZone.setId(this.removePrefix(hostedZone.getId()));
        }
    }

    private String removePrefix(String s) {
        if (s == null) {
            return null;
        }
        int lastIndex = s.lastIndexOf("/");
        if (lastIndex > 0) {
            return s.substring(lastIndex + 1);
        }
        return s;
    }
}

