/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.datamodeling;

import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodb.datamodeling.PaginatedList;
import com.amazonaws.services.dynamodb.model.ScanRequest;
import com.amazonaws.services.dynamodb.model.ScanResult;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginatedScanList<T>
extends PaginatedList<T> {
    private final ScanRequest scanRequest;
    private ScanResult scanResult;

    public PaginatedScanList(DynamoDBMapper mapper, Class<T> clazz, AmazonDynamoDB dynamo, ScanRequest scanRequest, ScanResult scanResult) {
        super(mapper, clazz, dynamo);
        this.scanRequest = scanRequest;
        this.scanResult = scanResult;
        this.allResults.addAll(mapper.marshallIntoObjects(clazz, scanResult.getItems()));
    }

    @Override
    protected boolean atEndOfResults() {
        return this.scanResult.getLastEvaluatedKey() == null;
    }

    @Override
    protected synchronized List<T> fetchNextPage() {
        this.scanRequest.setExclusiveStartKey(this.scanResult.getLastEvaluatedKey());
        this.scanResult = this.dynamo.scan(DynamoDBMapper.applyUserAgent(this.scanRequest));
        return this.mapper.marshallIntoObjects(this.clazz, this.scanResult.getItems());
    }
}

