/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.norbl.cbp.ppe.Ec2Wrangler;
import com.norbl.cbp.ppe.InstanceStatus;
import com.norbl.cbp.ppe.NoSuchNetworkException;
import com.norbl.cbp.ppe.NodeType;
import com.norbl.cbp.ppe.Pinger;
import com.norbl.util.ExceptionHandler;
import com.norbl.util.gui.GuiUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class NetworkPinger {
    Ec2Wrangler ec2w;

    public NetworkPinger(Ec2Wrangler ec2w) {
        this.ec2w = ec2w;
    }

    protected boolean pingNetwork(String networkID) {
        while (true) {
            try {
                Pinger pinger;
                PingFailedResponse r;
                do {
                    if ((pinger = Pinger.pingNetwork(networkID, 600000L)).allSucceeded()) {
                        return true;
                    }
                    r = this.getPingFailedResponse(pinger);
                    if (!PingFailedResponse.proceed.equals((Object)r)) continue;
                    return this.pingFailedRetag(pinger);
                } while (!PingFailedResponse.terminate.equals((Object)r));
                return this.terminatePingFailures(pinger);
            }
            catch (NoSuchNetworkException nx) {
                ExceptionHandler.gui(nx);
                GuiUtil.warning(new String[]{"   Ompi may not have been configured"}, "Warning");
                continue;
            }
            break;
        }
    }

    PingFailedResponse getPingFailedResponse(Pinger pinger) {
        Object[] options = new Object[]{PingFailedResponse.wait.title, PingFailedResponse.terminate.title, PingFailedResponse.proceed.title};
        int rn = JOptionPane.showOptionDialog(null, this.buildPingFailedMessage(pinger), "Unresponsive instance", 1, 2, null, options, options[0]);
        String r = (String)options[rn];
        if (PingFailedResponse.wait.title.equals(r)) {
            return PingFailedResponse.wait;
        }
        if (PingFailedResponse.proceed.title.equals(r)) {
            return PingFailedResponse.proceed;
        }
        if (PingFailedResponse.terminate.title.equals(r)) {
            return PingFailedResponse.terminate;
        }
        throw new RuntimeException("Undefined reponse=" + rn + " " + r);
    }

    String buildPingFailedMessage(Pinger pinger) {
        StringBuilder s = new StringBuilder("<html>");
        s.append("The following instances are <i>not</i> responding: <blockquote>");
        s.append(pinger.failureNamesToHtmlLines());
        s.append("</blockquote>");
        s.append("<br>You have three choices.<ul>");
        s.append("<li>Continue to wait for the instances to respond.  if there's no response for 10 minutes, you'll be  given this choice again.</li>");
        s.append("<li>Terminate the unresponsive instances and proceed.</li>");
        s.append("<li>Proceed but do not terminate the unresponsive  instances. They will be omitted from the network but they will continue to run.</li>");
        s.append("</ul><br>");
        s.append("</html>");
        return s.toString();
    }

    private boolean pingFailedRetag(Pinger pinger) {
        if (pinger.failures == null || pinger.failures.size() < 1) {
            if (pinger.successes != null) {
                return pinger.successes.size() > 0;
            }
            return false;
        }
        boolean masterFailed = false;
        for (InstanceStatus f : pinger.failures) {
            if (f.isMaster()) {
                masterFailed = true;
            }
            String ID = f.instance.getInstanceId();
            this.ec2w.setTags(ID, "nil", "nil - unresponsive instance", NodeType.slave);
        }
        if (masterFailed) {
            if (pinger.successes == null || pinger.successes.size() < 1) {
                ExceptionHandler.display(new RuntimeException("There are  no usable instances."));
                return false;
            }
            InstanceStatus m = pinger.successes.get(0);
            this.ec2w.setTags(m.instance.getInstanceId(), m.getNetworkID(), m.getNetworkName(), NodeType.master);
        }
        return true;
    }

    private boolean terminatePingFailures(Pinger pinger) {
        this.pingFailedRetag(pinger);
        if (pinger.failures == null || pinger.failures.size() < 1) {
            if (pinger.successes != null) {
                return pinger.successes.size() > 0;
            }
            return false;
        }
        ArrayList<String> failedIDs = new ArrayList<String>();
        for (InstanceStatus f : pinger.failures) {
            failedIDs.add(f.instance.getInstanceId());
        }
        this.ec2w.terminateInstances(failedIDs);
        GuiUtil.warning(this.buildTermMessage(pinger.failures), "Terminated instances");
        return true;
    }

    private String[] buildTermMessage(List<InstanceStatus> failures) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("The following instances were terminated:");
        lines.add(" ");
        for (InstanceStatus f : failures) {
            lines.add("    " + f.getPublicDnsName());
        }
        return lines.toArray(new String[lines.size()]);
    }

    static enum PingFailedResponse {
        wait("Continue to wait"),
        proceed("Proceed"),
        terminate("Terminate and proceed");

        String title;

        private PingFailedResponse(String title) {
            this.title = title;
        }
    }
}

