/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui.networkspec;

import ppe.gui.networkspec.Choice;
import ppe.gui.networkspec.LabeledTextFieldCC;

public class SlotsPerHostChoice
extends Choice {
    static String LABEL = "Slots per host: ";
    int nSlots;

    public SlotsPerHostChoice(int nSlots) {
        this.nSlots = nSlots;
    }

    public SlotsPerHostChoice() {
        this.nSlots = -1;
    }

    @Override
    public void createCC() {
        this.cc = new LabeledTextFieldCC(LABEL);
        this.cc.setEnabled(this.enabled);
        this.cc.setSelected(this.selected);
        if (this.nSlots > 0) {
            ((LabeledTextFieldCC)this.cc).textField.setText(Integer.toString(this.nSlots));
        } else {
            ((LabeledTextFieldCC)this.cc).textField.setText("");
        }
    }

    @Override
    public Object getValue() {
        try {
            String s = ((LabeledTextFieldCC)this.cc).textField.getText();
            this.nSlots = Integer.parseInt(s);
            if (this.nSlots > 0) {
                return new Integer(this.nSlots);
            }
            return null;
        }
        catch (NumberFormatException nfx) {
            return null;
        }
    }

    public int getNSlots() {
        return this.nSlots;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public String getChoiceType() {
        return this.getClass().getSimpleName();
    }

    public void setNSlots(int nSlots) {
        this.nSlots = nSlots;
        if (nSlots > 0) {
            ((LabeledTextFieldCC)this.cc).textField.setText(Integer.toString(nSlots));
        } else {
            ((LabeledTextFieldCC)this.cc).textField.setText("");
        }
    }
}

