% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarterly-year-quarter-day.R
\name{year-quarter-day-group}
\alias{year-quarter-day-group}
\alias{calendar_group.clock_year_quarter_day}
\title{Grouping: year-quarter-day}
\usage{
\method{calendar_group}{clock_year_quarter_day}(x, precision, ..., n = 1L)
}
\arguments{
\item{x}{\verb{[clock_year_quarter_day]}

A year-quarter-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"quarter"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
\code{x} grouped at the specified \code{precision}.
}
\description{
This is a year-quarter-day method for the \code{\link[=calendar_group]{calendar_group()}} generic.

Grouping for a year-quarter-day object can be done at any precision, as
long as \code{x} is at least as precise as \code{precision}.
}
\examples{
x <- year_quarter_day(2019, 1:4)
x <- c(x, set_year(x, 2020))

# Group by 3 quarters
# Note that this is a grouping of 3 quarters of the current year
# (i.e. the count resets at the beginning of the next year)
calendar_group(x, "quarter", n = 3)

# Group by 5 days of the current quarter
y <- year_quarter_day(2019, 1, 1:90)
calendar_group(y, "day", n = 5)
}
