% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date_month_factor}
\alias{date_month_factor}
\title{Convert a date or date-time to an ordered factor of month names}
\usage{
date_month_factor(x, ..., labels = "en", abbreviate = FALSE)
}
\arguments{
\item{x}{\verb{[Date / POSIXct / POSIXlt]}

A date or date-time vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{labels}{\verb{[clock_labels / character(1)]}

Character representations of localized weekday names, month names, and
AM/PM names. Either the language code as string (passed on to
\code{\link[=clock_labels_lookup]{clock_labels_lookup()}}), or an object created by \code{\link[=clock_labels]{clock_labels()}}.}

\item{abbreviate}{\verb{[logical(1)]}

If \code{TRUE}, the abbreviated month names from \code{labels} will be used.

If \code{FALSE}, the full month names from \code{labels} will be used.}
}
\value{
An ordered factor representing the months.
}
\description{
\code{date_month_factor()} extracts the month values from a date or date-time and
converts them to an ordered factor of month names. This can be useful in
combination with ggplot2, or for modeling.
}
\examples{
x <- add_months(as.Date("2019-01-01"), 0:11)

date_month_factor(x)
date_month_factor(x, abbreviate = TRUE)
date_month_factor(x, labels = "fr")
}
