% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weekday.R
\name{weekday-arithmetic}
\alias{weekday-arithmetic}
\alias{add_days.clock_weekday}
\title{Arithmetic: weekday}
\usage{
\method{add_days}{clock_weekday}(x, n, ...)
}
\arguments{
\item{x}{\verb{[clock_weekday]}

A weekday vector.}

\item{n}{\verb{[integer / clock_duration]}

An integer vector to be converted to a duration, or a duration
corresponding to the arithmetic function being used. This corresponds
to the number of duration units to add. \code{n} may be negative to subtract
units of duration.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{x} after performing the arithmetic.
}
\description{
These are weekday methods for the
\link[=clock-arithmetic]{arithmetic generics}.
\itemize{
\item \code{add_days()}
}

Also check out the examples on the \code{\link[=weekday]{weekday()}} page for more advanced
usage.
}
\details{
\code{x} and \code{n} are recycled against each other.
}
\examples{
saturday <- weekday(clock_weekdays$saturday)
saturday

add_days(saturday, 1)
add_days(saturday, 2)
}
