% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clmplusRtTriangle.R
\name{clmplus}
\alias{clmplus}
\title{Fit chain-ladder+ to reverse time triangles.}
\usage{
clmplus(RtTriangle, hazard.model = NULL, ...)
}
\arguments{
\item{RtTriangle}{RtTriangle object to be fitted.}

\item{hazard.model}{hazard model supported from our package, must be provided as a string. The model can be choosen from:
\itemize{
\item{'a': Age model, this is equivalent to the Mack chain-ladder.}
\item{'ac': Age and cohort effects.}
\item{'ap': Age and cohort effects.}
\item{'apc': Age cohort and period effects.}
\item{'cbd': Cairns-Blake-Dowd mortality model (CBD).}
\item{'m6': CBD with cohorts.}
\item{'m7': CBD m7 extension.}
\item{'m8': CBD m7 extension.}
}}

\item{...}{arguments to be passed to or from other methods.}
}
\value{
No return value, called to pass method clmplus.
}
\description{
Generic method to fit the chain ladder +.
}
\examples{
data(sifa.mtpl)
sifa.mtpl.rtt <- RtTriangle(cumulative.payments.triangle=sifa.mtpl)
hz.chl=clmplus(sifa.mtpl.rtt, 'a')

}
\references{
Hiabu, Munir. “On the relationship between classical chain ladder and granular reserving.” 
Scandinavian Actuarial Journal 2017 (2017): 708 - 729.
}
