% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dilations.R
\name{dilations}
\alias{dilations}
\title{Assess dilations from \code{PLR3000}-output.}
\usage{
dilations(pupils, markers,
  remove_markers = NULL, add_markers = NULL,
  not_assess = NULL, artefacts_static = c(0.55,9.95),
  artefacts_dynamic = c(`1` = 1.5, `0.66` = 1, `0.33` = 0.5),
  time_assess = c(`1` = 10, `3` = 5),
  sig.level = 0.05, min_change = NULL,
  resting_delay = c(`3` = 0))
}
\arguments{
\item{pupils}{recording of pupillary function. long format dataframe with at least three columns: record_id, time, and size.}

\item{markers}{time of markers. long format dataframe with at least two columns: record_id and time.}

\item{remove_markers}{markers which should be removed. long format dataframe with at least two columns: record_id and time. The time column need one decimal.}

\item{add_markers}{markers which should be added. long format dataframe with at least two columns: record_id and time. The time column need one decimal.}

\item{not_assess}{a list of record ids which should no be assessed.}

\item{artefacts_static}{a list of the limits of the artefacts. The first number in the list is the minimum size to be assessed and the second is the maximum size to be assessed}

\item{artefacts_dynamic}{a named list where max change in millimeter within the duration (name in list) is removed. Will use the first 1 second of the recording to create a baseline, thus suspectible to artefacts in the start of the recording.}

\item{time_assess}{This named list define the number of seconds which should be used in the assessment of dilatios. The name is the number of periods-of-interest and the value is the seconds.}

\item{sig.level}{This is the significance level to be used when comparing the size of the period-of-interest. The significance level corresponds to the Wilcox.test used.}

\item{min_change}{This is the minimum size of mm which needs to change before a dilation can be identified. Default is no minimum requirement.}

\item{resting_delay}{This can be used if the subsequent resting period to compare should be delayed, i.e. if we should wait 5 second for those investigations with three periods of interest create a named list with periods of interest as names and seconds to delay as input.}
}
\value{
Returns a nested list one dataframe of the results ($dilations), plot ($plot$id[record id]), and a markdown output ($plot$markdown$id[record_id]). The dilations dataframe include the following columns: Record ID (record_id); Patient ID (pt_id); Date (date); pupil side (side); start of the period (min); end of the period (max); length of period (rec_length); number of measurements (n); median size (median); P value when comparing with the previous period (p_before); P value when comparing with the following period (p_after); and if dilation is identified (dilation, 1 is successful dilation and 0 is no dilation).
}
\description{
\code{dilations()} is a function which converts longformat recording of pupillary size and uses markers to generate a dataframe, plot, and markdown output to inspect the results.
}
\examples{
 \dontrun{
   recordings <- PLR3000("C:/PLR3000/R_20200105_205901.xls")
   dilations <- dilations(recordings$pupils,recordings$markers)

   # The dataframe of the results
   dilations$dilations

   # The plot of one of the recordings
   dilations$plot$id833

   # The markdown output of one of the recordings
   dilations$markdown$id833

 }

}
