% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparerel.R
\name{comparerel}
\alias{comparerel}
\title{Compare measures of reliability (comparerel)}
\usage{
comparerel(d1,d2,d3,d4,n_boot,seedno)
}
\arguments{
\item{d1}{list of numbers from measurement one of sample 1}

\item{d2}{list of numbers from measurement two of sample 1 (same order as for d1)}

\item{d3}{list of numbers from measurement one of sample 2}

\item{d4}{list of numbers from measurement two of sample 2 (same order as for d2)}

\item{n_boot}{numbers of iterations (default is 1000)}

\item{seedno}{the seed number used for bootstrapping (default is)}
}
\value{
Returns a nested list of difference between reliability measures using bootstrapping.
}
\description{
\code{comparerel()} is a function which compares measures from calcrel using bootstrapping.
}
\examples{
\dontrun{
   d1 <- rnorm(15,10,1)
   d2 <- rnorm(15,10,1)
   d3 <- rnorm(15,10,1)
   d4 <- rnorm(15,10,1)
   comparerel(d1,d2,d3,d4)
}
}
