% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdm.miss.R
\name{cdm.miss}
\alias{cdm.miss}
\title{Quiet any output (cdm.miss)}
\usage{
cdm.miss(df, id, cols, date, lostFU, filter)
}
\arguments{
\item{df}{dateframe to be assessed for missing data}

\item{id}{column-name for unique id's}

\item{cols}{columns to be assessed for missing data}

\item{date}{column with the date of follow-up, i.e. when data is missing}

\item{lostFU}{column for patients lost to follow up, TRUE/FALSE in the column}

\item{filter}{how many should be shown in figures - 'all' for all, 'waiting'
for those with missing or waiting for data, and 'missing' for only those
with missing data}
}
\value{
Returns a full markdown output.
}
\description{
\code{cdm.miss()} is a small function which suppresses any output
}
\examples{
\dontrun{
   cdm.miss(data,id=idcols[[1]],cols=missing.cols,lostFU="lostFU",
   date = "follow_up_date", filter="missing")
}

}
