% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinmon.R
\name{clinmon}
\alias{clinmon}
\title{Hemodynamic Indices Calculated From Clinical Monitoring (clinmon)}
\usage{
clinmon(df, variables,
trigger = NULL, deleter = NULL,
blocksize = 3, epochsize = 20,
overlapping = FALSE, freq = 1000,
blockmin = 0.5, epochmin = 0.5,
output = "period", fast = FALSE)
}
\arguments{
\item{df}{Raw \emph{continuous} recording with all numeric data and first column has to be time in seconds. (\code{dataframe})}

\item{variables}{Defining the type and order of the recorded variables as a list. Middle cerebral artery blood velocity (\code{'mcav'}), Arterial blood pressure (\code{'abp'}), cerebral perfusion pressure (\code{'cpp'}), intracranial pressure (\code{'icp'}), and heart rate (\code{'hr'}) is currently supported. (\code{list})}

\item{trigger}{Trigger with two columns: first is start, and second is end of periods to be analyzed. Every row corresponds to a period. Default is \code{NULL}, which results in analysis of the full dataframe. (\code{dataframe})}

\item{deleter}{Deleter with two columns: first is start and second is end of period with artefacts, which need to be deleted. Every row is a period with artefacts. Default is \code{NULL}. (\code{dataframe})}

\item{blocksize}{Length of a block, in seconds. Default is \code{3}. (\code{numeric})}

\item{epochsize}{Size of epochs in number of blocks. Default is \code{20}. (\code{numeric})}

\item{overlapping}{The number of block which should overlap when calculating correlation based indices, and remain blank if overlapping calculations should not be utilized. Default is \code{FALSE}. (\code{numeric})}

\item{freq}{Frequency of recorded data, in Hz. Default is \code{1000}. (\code{numeric})}

\item{blockmin}{Minimum measurements required to create a block in ratio. Default is \code{0.5} corresponding to 50\%. If the block holds less than the defined ratio the block will be omitted. (\code{numeric})}

\item{epochmin}{Minimum number of blocks required to create an epoch in ratio. Default is \code{0.5} corresponding to 50\%. If the epoch holds less than the defined ration the epoch will be omitted. (\code{numeric})}

\item{output}{Select what each row should represent in the output. Correlation based indices are not presented when selecting blocks for every row. Currently \code{'block'}, \code{'epoch'}, \code{'period'} or \code{'cppopt'} is supported. Default is \code{'period'}. (\code{string})}

\item{fast}{Select if you want the data to aggregated before analysis resulting in a faster, but perhaps more imprecise run, in Hz. Default is \code{FALSE.} (\code{numeric})}
}
\value{
Returns a dataframe with the results, with either
every blocks, epochs or periods as rows, depending on the chosen output.\tabular{ll}{
   \strong{Column} \tab \strong{Description} \cr
   \code{period} \tab The period number corresponding to the row-number in the trigger file. \cr
   \code{epoch} \tab The epoch number, or if \code{period} is chosen as output it reflects the number of epochs in the period. \cr
   \code{block} \tab The block number, or if \code{period} or \code{epoch} is chosen as output it reflects the number of blocks in the \code{period} or \code{epoch}. \cr
   \code{time_min} \tab The minimum time value or the \code{period}, \code{epoch} or \code{block}. \cr
   \code{time_max} \tab The maximum time value or the \code{period}, \code{epoch} or \code{block}. \cr
   \code{missing_percent} \tab The percentage of missing data in the \code{period}, \code{epoch} or \code{block}. \cr
   \verb{*_mean} \tab The mean value of each variable for the \code{period}, \code{epoch} or \code{block}. \cr
   \verb{*_min} \tab The minimum value of each variable for the \code{period}, \code{epoch} or \code{block}. \cr
   \verb{*_max} \tab The maximum value of each variable for the \code{period}, \code{epoch} or \code{block}. \cr
   \code{*} \tab The indices in each column. \cr
}
}
\description{
\code{clinmon()} uses a \emph{continuous} recording and returns a dataframe with hemodynamic indices for every period, epoch or block depending on the chosen output. Calculates \code{COest}, \code{CPPopt}, \code{CVRi}, \code{Dx}, \code{Mx}, \code{PI}, \code{PRx}, \code{PWA}, \code{RI}, and \code{Sx} (see \emph{Hemodynamic indices}).
}
\details{
Using a \emph{continuous} raw recording, \code{clinmon()} calculates hemodynamic indices for every period, epoch or block depending on the chosen output.\preformatted{View(data)
}\tabular{rrr}{
   \code{time} \tab \code{abp} \tab \code{mcav} \cr
   \code{7.00} \tab \code{78} \tab \code{45} \cr
   \code{7.01} \tab \code{78} \tab \code{46} \cr
   \code{...} \tab \code{...} \tab \code{...} \cr
   \code{301.82} \tab \code{82} \tab \code{70} \cr
   \code{301.83} \tab \code{81} \tab \code{69} \cr
}


To calculate the indices insert the data and select the relevant variables.\preformatted{clinmon(df=data, variables=c("abp","mcav"))
}

See \strong{Value} for output description.
}
\section{Hemodynamic indices}{

\subsection{\code{COest} | Estimated cardiac output}{

\emph{Required variables:} \code{abp}, \code{hr}; \emph{Required output:} \code{-}.

Estimated cardiac output (\code{COest}) is calculated by utilizing the method described by Koenig et al. [1]:
\deqn{COest = PP / (SBP+DBP) * HR}
PP: Pulse pressure; SBP: systolic blood pressure; DBP: diastolic blood pressure; HR: heart rate.
}

\subsection{\code{CPPopt} | Optimal cerebral perfusion pressure}{

\emph{Required variables:} \code{abp}, \code{icp}; \emph{Required output:} \code{period}.

Optimal cerebral perfusion pressure (\code{CPPopt}) is calculated utilizing the method described by Steiner et al. [2]. The CPPopt return \code{NA} if CPPopt is the maximum or minimum CPP investigated. CPPopt is recommended to only be calculated after 'several hours' of recording:
\deqn{CPPopt = 5 mmHg_CPP_interval_with_lowest_mean_PRx ) }
CPP: cerebral perfusion pressure; PRx: Pressure reactivity index.
}

\subsection{\code{CVRi} | Cardiovascular resistance index}{

\emph{Required variables:} \code{abp}, \code{mcav}; \emph{Required output:} \code{-}.

Cardiovascular resistance index (\code{CVRi}) is calculated utilizing the method described by Fan et al. [3]:
\deqn{CVRi = mean ABP / mean MCAv }
ABP: arterial blood pressure; MCAv: middle cerebral artery blood velocity.
}

\subsection{\code{Dx} | Diastolic flow index}{

\emph{Required variables:} \code{cpp}/\code{abp}, \code{mcav}; \emph{Required output:} \code{epoch}, \code{period}.

Diastolic flow index (\code{Dx}) is calculated utilizing the method described by Reinhard et al. [4]:
\deqn{Dx = cor( mean CPP / min MCAv ) }
\deqn{Dxa = cor( mean ABP / min MCAv ) }
cor: correlation coefficient; CPP: cerebral perfusion pressure; ABP: arterial blood pressure; MCAv: middle cerebral artery blood velocity.
}

\subsection{\code{Mx} | Mean flow index}{

\emph{Required variables:} \code{cpp}/\code{abp}, \code{mcav}; \emph{Required output:} \code{epoch}, \code{period}.

Mean flow index (\code{Mx}) is calculated utilizing the method described by Czosnyka et al. [5]:
\deqn{Mx = cor( mean CPP / mean MCAv ) }
\deqn{Mxa = cor( mean ABP / mean MCAv ) }
cor: correlation coefficient; CPP: cerebral perfusion pressure; ABP: arterial blood pressure; MCAv: middle cerebral artery blood velocity.
}

\subsection{\code{PI} | Gosling index of pulsatility}{

\emph{Required variables:} \code{mcav}; \emph{Required output:} \code{-}.

Gosling index of pulsatility (\code{PI}) is calculated utilizing the method described by Michel et al. [6]:
\deqn{PI = (systolic MCAv - diastolic MCAv) / mean MCAv  }
MCAv: middle cerebral artery blood velocity.
}

\subsection{\code{PRx} | Pressure reactivity index}{

\emph{Required variables:} \code{abp}, \code{icp}; \emph{Required output:} \code{epoch}, \code{period}.

Pressure reactivity index (\code{PRx}) is calculated utilizing the method described by Czosnyka et al. [7]:
\deqn{PRx = cor( mean ABP / mean ICP ) }
cor: correlation coefficient; CPP: cerebral perfusion pressure; ICP: intracranial pressure.
}

\subsection{\code{PWA} | Pulse wave amplitude}{

\emph{Required variables:} \code{cpp}/\code{icp}/\code{abp}/\code{mcav}; \emph{Required output:} \code{-}.

Pulse wave amplitude (\code{PWA}) is calculated utilizing the method described by Norager et al. [8]:
\deqn{PWA = systolic - diastolic }
}

\subsection{\code{RI} | Pourcelots resistive (resistance) index}{

\emph{Required variables:} \code{mcav}; \emph{Required output:} \code{-}.

Pourcelots resistive (resistance) index (\code{RI}) is calculated utilizing the method described by Forster et al. [9]:
\deqn{RI = (systolic MCAv - diastolic MCAv) / systolic MCAv  }
MCAv: middle cerebral artery blood velocity.
}

\subsection{\code{Sx} | Systolic flow index}{

\emph{Required variables:} \code{cpp}/\code{abp}, \code{mcav}; \emph{Required output:} \code{epoch}, \code{period}.

Systolic flow index (\code{Sx}) is calculated utilizing the method described by Czosnyka et al. [5]:
\deqn{Sx = cor( mean CPP / systolic MCAv ) }
\deqn{Sxa = cor( mean ABP / systolic MCAv ) }
cor: correlation coefficient; CPP: cerebral perfusion pressure; ABP: arterial blood pressure; MCAv: middle cerebral artery blood velocity.
}
}

\examples{

data(testdata)
clinmon(df.data10, variables=c('abp','mcav','hr'), freq=10)

}
\references{
\enumerate{
\item Koenig et al. (2015) Biomed Sci Instrum. 2015;51:85-90. (\href{https://pubmed.ncbi.nlm.nih.gov/25996703/}{PubMed})
\item Steiner et al. (2002) Crit Care Med. 2002 Apr;30(4):733-8. (\href{https://pubmed.ncbi.nlm.nih.gov/11940737/}{PubMed})
\item Fan et al. (2018) Front Physiol. 2018 Jul 16;9:869. (\href{https://pubmed.ncbi.nlm.nih.gov/30061839/}{PubMed})
\item Reinhard et al. (2003) Stroke. 2003 Sep;34(9):2138-44. (\href{https://pubmed.ncbi.nlm.nih.gov/12920261/}{PubMed})
\item Czosnyka et al. (1996) Stroke. 1996 Oct;27(10):1829-34. (\href{https://pubmed.ncbi.nlm.nih.gov/8841340/}{PubMed})
\item Michel et al. (1998) Ultrasound Med Biol. 1998 May;24(4):597-9. (\href{https://pubmed.ncbi.nlm.nih.gov/9651969/}{PubMed})
\item Czosnyka et al. (1997) Neurosurgery. 1997 Jul;41(1):11-7; discussion 17-9. (\href{https://pubmed.ncbi.nlm.nih.gov/9218290/}{PubMed})
\item Norager et al. (2020) Acta Neurochir (Wien). 2020 Dec;162(12):2983-2989. (\href{https://pubmed.ncbi.nlm.nih.gov/32886224/}{PubMed})
\item Forster et al. (2017) J Paediatr Child Health. 2018 Jan;54(1):61-68. (\href{https://pubmed.ncbi.nlm.nih.gov/28845537/}{PubMed})
}
}
