% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-boxplotClinData.R
\name{addFacetPanel}
\alias{addFacetPanel}
\title{Add facet-panel to single plotly plot.}
\usage{
addFacetPanel(
  pl,
  panelLab,
  panelWidth = 20,
  fontSize = 15,
  side = c("top", "right")
)
}
\arguments{
\item{pl}{\code{plotly} object.}

\item{panelLab}{text to be shown in the facet panel}

\item{panelWidth}{thickness of the panel in pixels.}

\item{fontSize}{fontsize of \code{facetText}}

\item{side}{the side of the plot to show the panel 
(currently only right panels are implemented.)}
}
\value{
plotly object with the facet panel added.
}
\description{
Add facet-panel to single plotly plot.
}
\details{
plot title clipping.

In case side = 'top', the plot title (eg. layout(title = "title"))
will clip with the top panel. 

Resolve this with the following configurations: 
(once all the subplots have already been combined)
\code{
layout(
   # place the title at absolute top of the page
		title = list(text = "title", yref = "container", y = 1)) 
		# If font size = 15 roughly equal to 20 pixels. 
		margin = list(t = panelWidth + heightTitleTextInPixels) 
}
}
\author{
lennart tuijnder
}
