% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-utility-formatPlotlyClinData.R
\name{addSelectBtn}
\alias{addSelectBtn}
\title{Add selection box(es) to a plotly plot.}
\usage{
addSelectBtn(
  data,
  pl,
  selectVars = NULL,
  selectLab = NULL,
  labelVars = NULL,
  id = paste0("plotClinData", sample.int(n = 1000, size = 1)),
  keyVar
)
}
\arguments{
\item{data}{\code{\link[crosstalk]{SharedData}} object used for the plot.}

\item{pl}{\code{plotly} object.}

\item{selectVars}{(optional) Character vector with variable(s) from \code{data}
for which a selection box should be included. This enables to select the data
displayed in the plot (and associated table).}

\item{selectLab}{(Named) character vector with label for \code{selectVars}.}

\item{labelVars}{Named character vector containing variable labels.}

\item{id}{String with general id for the plot:
\itemize{
\item{'id' is used as \code{group} for the \code{\link[crosstalk]{SharedData}}}
\item{'button:[id]' is used as button ID if \code{table} is TRUE}
}
If not specified, a random id, as 'plotClinData[X]' is used.}

\item{keyVar}{String with unique key variable, identifying unique
group for which the link between the table and the plot should be done.}
}
\value{
if \code{selectVars} is specified: a \code{\link[htmltools]{browsable}}
object combining the select buttons and the \code{plotly} object.\cr
Otherwise, the input \code{plotly} object.
}
\description{
Add selection box(es) to a plotly plot.
}
