% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotwin.R
\name{plotwin}
\alias{plotwin}
\title{Plot the opening and closing point of best climate windows}
\usage{
plotwin(Dataset, CW = 0.95)
}
\arguments{
\item{Dataset}{A dataframe containing information on all fitted climate
windows. Output from \code{\link{climatewin}}.}

\item{CW}{Cumulative model weight used to subset the group of best models}
}
\value{
Creates two boxplots showing the opening and closing point for a subset
 of best climate windows. Best climate windows make up the
 cumulative model weight equivalent to the largest value of CW1, CW2 and CW3.
}
\description{
Visualise the opening and closing point for a subset of best climate windows.
}
\examples{
# View window limits for climate windows in the top 95\% of model weights.

data(MassOutput)

plotwin(Dataset = MassOutput, CW = 0.95)
}
\author{
Liam D. Bailey and Martijn van de Pol
}

