% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteo_noaa_hourly.R
\name{meteo_noaa_hourly}
\alias{meteo_noaa_hourly}
\title{Hourly NOAA Integrated Surface Hourly (ISH) meteorological data}
\usage{
meteo_noaa_hourly(station = NULL, year, fm12 = TRUE)
}
\arguments{
\item{station}{ID of meteorological station(s) (characters). Find your station's ID at: https://www1.ncdc.noaa.gov/pub/data/noaa/isd-history.txt}

\item{year}{vector of years (e.g., 1966:2000)}

\item{fm12}{use only FM-12 (SYNOP) records (TRUE by default)}
}
\description{
Downloading hourly (meteorological) data from the SYNOP stations available in the NOAA ISD collection.
Some stations in the dataset are dated back even up to 1900.
By default only records that follow FM-12 (SYNOP) convention are processed.
Further details available at: https://www1.ncdc.noaa.gov/pub/data/noaa/readme.txt
}
\examples{
\donttest{
  noaa = meteo_noaa_hourly(station = "123300-99999", 
                           year = 2019) # poznan, poland
  head(noaa)
}

}
