% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{builtin_theme}
\alias{builtin_theme}
\title{The built-in CLI theme}
\usage{
builtin_theme(dark = getOption("cli.theme_dark", "auto"))
}
\arguments{
\item{dark}{Whether to use a dark theme. The \code{cli.theme_dark} option
can be used to request a dark theme explicitly. If this is not set,
or set to \code{"auto"}, then cli tries to detect a dark theme, this
works in recent RStudio versions and in iTerm on macOS.}
}
\value{
A named list, a CLI theme.
}
\description{
This theme is always active, and it is at the bottom of the theme
stack. See \link{themes}.
}
\section{Showcase}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_h1("Heading 1")
cli_h2("Heading 2")
cli_h3("Heading 3")

cli_par()
cli_alert_danger("Danger alert")
cli_alert_warning("Warning alert")
cli_alert_info("Info alert")
cli_alert_success("Success alert")
cli_alert("Alert for starting a process or computation",
  class = "alert-start")
cli_end()

cli_text("Packages and versions: \{.pkg cli\} \{.version 1.0.0\}.")
cli_text("Time intervals: \{.timestamp 3.4s\}")

cli_text("\{.emph Emphasis\} and  \{.strong strong emphasis\}")

cli_text("This is a piece of code: \{.code sum(x) / length(x)\}")
cli_text("Function names: \{.fn cli::simple_theme\}")

cli_text("Files: \{.file /usr/bin/env\}")
cli_text("URLs: \{.url https://r-project.org\}")

cli_h2("Longer code chunk")
cli_par(class = "code R")
cli_verbatim(
  '# window functions are useful for grouped mutates',
  'mtcars \%>\%',
  '  group_by(cyl) \%>\%',
  '  mutate(rank = min_rank(desc(mpg)))')
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #2AA198;">──</span> <span style="font-weight: bold;">Heading 1</span> <span style="color: #2AA198;">─────────────────────────────────────────────────────────</span>          
#>                                                                                 
#> ── <span style="font-weight: bold;">Heading 2</span> ──                                                                 
#>                                                                                 
#> ── Heading 3                                                                    
#> <span style="color: #DC322F;">✖</span> Danger alert                                                                  
#> <span style="color: #B58900;">!</span> Warning alert                                                                 
#> <span style="color: #2AA198;">ℹ</span> Info alert                                                                    
#> <span style="color: #859900;">✔</span> Success alert                                                                 
#> → Alert for starting a process or computation                                   
#>                                                                                 
#> Packages and versions: <span style="color: #268BD2;">cli</span> 1.0.0.                                               
#> Time intervals: <span style="color: #b8b8b8;">[3.4s]</span>                                                          
#> <span style="font-style: italic;">Emphasis</span> and <span style="font-weight: bold;">strong emphasis</span>                                                    
#> This is a piece of code: `sum(x) / length(x)`                                   
#> Function names: `cli::simple_theme()`                                           
#> Files: <span style="color: #268BD2;">/usr/bin/env</span>                                                             
#> URLs: <span style="font-style: italic;color: #268BD2;">&lt;https://r-project.org&gt;</span>                                                   
#>                                                                                 
#> ── <span style="font-weight: bold;">Longer code chunk</span> ──                                                         
#>                                                                                 
#> <span style="font-style: italic;color: #a3a3a3;"># window functions are useful for grouped mutates</span>                               
#> mtcars <span style="color: #859900;">&#37;&gt;&#37;</span>                                                                      
#>   <span style="color: #2AA198;">group_by</span><span style="color: #B58900;">(</span>cyl<span style="color: #B58900;">)</span> <span style="color: #859900;">&#37;&gt;&#37;</span>                                                             
#>   <span style="color: #2AA198;">mutate</span><span style="color: #B58900;">(</span>rank = <span style="color: #2AA198;">min_rank</span><span style="color: #268BD2;">(</span><span style="color: #2AA198;">desc(</span>mpg<span style="color: #2AA198;">)</span><span style="color: #268BD2;">)</span><span style="color: #B58900;">)</span>                                            
</pre></div>
}}
}

\seealso{
\link{themes}, \code{\link[=simple_theme]{simple_theme()}}.
}
