% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress-client.R
\name{cli_progress_message}
\alias{cli_progress_message}
\title{Simplified cli progress messages}
\usage{
cli_progress_message(
  msg,
  current = TRUE,
  .auto_close = TRUE,
  .envir = parent.frame(),
  ...
)
}
\arguments{
\item{msg}{Message to show. It may contain glue substitution and cli
styling. It can be updated via \code{\link[=cli_progress_update]{cli_progress_update()}}, as usual.}

\item{current}{Passed to \code{\link[=cli_progress_bar]{cli_progress_bar()}}.}

\item{.auto_close}{Passed to \code{\link[=cli_progress_bar]{cli_progress_bar()}}.}

\item{.envir}{Passed to \code{\link[=cli_progress_bar]{cli_progress_bar()}}.}

\item{...}{Passed to \code{\link[=cli_progress_bar]{cli_progress_bar()}}.}
}
\value{
The id of the new progress bar.
}
\description{
This is a simplified progress bar, a single (dynamic)
message, without progress units.
}
\details{
\code{cli_progress_message()} always shows the message, even if no
update is due. When the progress message is terminated, it is removed
from the screen by default.
}
\seealso{
\code{\link[=cli_progress_bar]{cli_progress_bar()}} for the complete progress bar API.
\code{\link[=cli_progress_step]{cli_progress_step()}} for a similar display that is styled by default.
}
