% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{similarity_buffer}
\alias{similarity_buffer}
\title{Gower similarity analysis}
\usage{
similarity_buffer(covs, pts, buffer, fac = NA, metric = "gower",
  stand = FALSE, ...)
}
\arguments{
\item{covs}{raster stack of environmental covariates}

\item{pts}{sampling points, object of class SpatialPointsDataframe}

\item{buffer}{Radius of the disk around each point that similarity will be calculated}

\item{fac}{numeric, can be > 1, (e.g., fac = c(2,3)). Raster layer(s) which are categorical variables. Set to NA if no factor is present}

\item{metric}{character string specifying the similarity metric to be used. The currently available options are "euclidean", "manhattan" and "gower" (the default).  See \code{daisy} from the \code{cluster} package for more details}

\item{stand}{logical flag: if TRUE, then the measurements in x are standardized before calculating the dissimilarities.}

\item{...}{passed to plyr::alply}
}
\value{
a RasterStack
}
\description{
Calculates Gower's similarity index for every pixel within an given radius buffer of each sampling point
}
\examples{
library(raster)
library(sp)

data(meuse.grid)
coordinates(meuse.grid) = ~x+y
proj4string(meuse.grid) <- CRS("+init=epsg:28992")
gridded(meuse.grid) = TRUE
ms <- stack(meuse.grid)
set.seed(1)
pts <- clhs(ms, size = 3, iter = 100, progress = FALSE, simple = TRUE)
gw <- similarity_buffer(ms, pts, buffer = 500)
plot(gw)

}
\references{
Brungard, C. and Johanson, J. 2015. The gate's locked! I can't get to the exact 
sampling spot... can I sample nearby? Pedometron, 37:8--10.
}
\author{
Colby Brungard
}
