% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_clusterings.R
\name{contingency_table_clusters}
\alias{contingency_table_clusters}
\title{Contingency Table for Clusterings}
\usage{
contingency_table_clusters(true, pred)
}
\arguments{
\item{true}{ground truth clustering represented as a membership
vector. Each entry corresponds to an element and the value identifies
the assigned cluster. The specific values of the cluster identifiers
are arbitrary.}

\item{pred}{predicted clustering represented as a membership
vector.}
}
\value{
Returns a table \eqn{C} (stored as a sparse matrix) such that
\eqn{C_{ij}}{C_ij} counts the number of elements assigned to
cluster \eqn{i} in \code{pred} and cluster \eqn{j} in \code{true}.
}
\description{
Compute the contingency table for a \emph{predicted} clustering
given a \emph{ground truth} clustering.
}
\examples{
true <- c(1,1,1,2,2)  # ground truth clustering
pred <- c(1,1,2,2,2)  # predicted clustering
contingency_table_clusters(true, pred)

}
\seealso{
\code{\link{eval_report_clusters}} computes common evaluation measures derived
from the output of this function.
}
