% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend_spaCy.R
\name{init_spaCy}
\alias{init_spaCy}
\title{Interface for initializing up the spaCy backend}
\usage{
init_spaCy(entity_flag = TRUE, vector_flag = FALSE, model_name = NULL)
}
\arguments{
\item{entity_flag}{boolean. Should named entities be identified.}

\item{vector_flag}{boolean. Should word vectors be computed and saved.}

\item{model_name}{string giving the model name for the Python/spaCy
backend. Defaults to "en" (English) if NULL.}
}
\description{
This function must be run before annotating text with
the tokenizers backend. It sets the properties for the
spaCy engine and loads the file using the R to Python
interface provided by reticulate.
}
\examples{
\dontrun{
init_spaCy(vector_flag = TRUE)
}

}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
