// Copyright 2014 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Created by postproc-cld2 4.0 on 2014-10-16 15:46:15
// From command line:
//  --nearby_probs=0.5 --extra_entries=be-Cyrl bh-Deva bs-Latn hr-Latn 
//  sr-Latn gl-Latn es-Latn id-Latn ms-Latn sv-Latn  --cld2 --cc 
//  --just_read_raw --quad --standard --minchars=2 --mincount=2 
//  --max_items_per_langscript=6000 --flatmap --rr_alloc --freq_alloc 
//  --boostcloseweakerpercent=00 --indirectbits=16 --thresh=224 --v25 
//  --kentries=256 --tablename=QuadChrome1015_2 --remap=xxx-Latn=>ut-Latn 
//  tw-Latn=>ak-Latn nd-Latn=>nr-Latn blu-Latn=>hmn-Latn nn-Latn=>no-Latn  
//  --include=af-Latn ar-Arab be-Cyrl bg-Cyrl bs-Latn ca-Latn cs-Latn 
//  cy-Latn   da-Latn de-Latn el-Grek en-Latn es-Latn et-Latn fa-Arab 
//  fi-Latn fr-Latn   ga-Latn gd-Latn hi-Deva hr-Latn hu-Latn id-Latn 
//  is-Latn it-Latn iw-Hebr   ja-Hani ko-Hani lg-Latn lt-Latn lv-Latn 
//  mk-Cyrl ms-Latn nl-Latn no-Latn   pl-Latn pt-Latn ro-Latn ro-Cyrl 
//  ru-Cyrl rw-Latn sh-Cyrl sh-Latn sk-Latn sl-Latn sr-Cyrl   sv-Latn 
//  sw-Latn th-Thai tl-Latn tr-Latn uk-Cyrl vi-Latn yi-Hebr   zh-Hani zh-TW 
//  zhT-Hani   sq-Latn az-Latn eu-Latn bn-Beng gl-Latn ht-Latn mt-Latn 
//  sr-Latn ur-Arab   bh-Deva mr-Deva ne-Deva lg-Latn rw-Latn gd-Latn   
//  ut-Latn ut-Deva   ceb-Latn blu-Latn hmn-Latn jw-Latn   kk-Cyrl ku-Latn 
//  ky-Cyrl mg-Latn ny-Latn st-Latn su-Latn tg-Cyrl uz-Latn uz-Cyrl  
//  --ko_english --force_to_lang_soft --nosoft_cram2 --nomsidlevel 
//  --shapeflatprob --langpriorpercent=10 --skipnuc --noshapeforcetop 
//  --noshapeeventop --noshapesteep2 --langcounts --writebin 
//  --list_items=120 --max_langs_per_item=3 
//  /hdb1/cld2/probs/p90_raw_quadgrams_2014b.utf8 
// 
// CLD2_pslangs
// 
// See compact_lang_det.cc for usage
// 
#include "cld2tablesummary.h"
namespace CLD2 {

// For this build date, looking up 'qpdbmrmxyzptlkuuddlrlrbas' gives TURKISH
static const uint32 kQuadChrome1015_2BuildDate = 20141016;    // yyyymmdd


// Of 416959 offered items into 262144 table entries:
// 248448 filled (59%), 781 merged (0%), 167730 dropped (40%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI 
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE 
//     SYRIAC LIMBU ORIYA INUKTITUT 

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT 

// Words/Quads: 71 languages in range ENGLISH..NYANJA:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN 
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH 
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN 
//     BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG TURKISH 
//     UKRAINIAN HINDI MACEDONIAN BENGALI INDONESIAN MALAY WELSH 
//     NEPALI ALBANIAN BELARUSIAN JAVANESE URDU BIHARI ARABIC CATALAN 
//     BASQUE SCOTS_GAELIC SWAHILI SLOVENIAN MARATHI MALTESE 
//     VIETNAMESE SLOVAK SUNDANESE UZBEK AZERBAIJANI PERSIAN BOSNIAN 
//     SESOTHO KYRGYZ YIDDISH KURDISH MONGOLIAN AFRIKAANS KAZAKH 
//     TAJIK HAITIAN_CREOLE KINYARWANDA MALAGASY GANDA CEBUANO HMONG 
//     NYANJA 

// TopLanguage  TokenCount
//  ENGLISH 3337
//  DANISH 3306
//  DUTCH 3254
//  FINNISH 3352
//  FRENCH 3320
//  GERMAN 3313
//  HEBREW 3373
//  ITALIAN 2642
//  NORWEGIAN 3347
//  POLISH 3358
//  PORTUGUESE 3389
//  RUSSIAN 3379
//  SPANISH 3645
//  SWEDISH 4407
//  CZECH 6748
//  ICELANDIC 3324
//  LATVIAN 3389
//  LITHUANIAN 3297
//  ROMANIAN 6717
//  HUNGARIAN 3376
//  ESTONIAN 3297
//  BULGARIAN 3344
//  CROATIAN 4249
//  SERBIAN 6924
//  IRISH 3389
//  GALICIAN 3668
//  TAGALOG 2444
//  TURKISH 3364
//  UKRAINIAN 3375
//  HINDI 6631
//  MACEDONIAN 3331
//  BENGALI 3389
//  INDONESIAN 3596
//  MALAY 2798
//  WELSH 3342
//  NEPALI 3339
//  ALBANIAN 3344
//  BELARUSIAN 4370
//  JAVANESE 3355
//  URDU 3393
//  BIHARI 4716
//  ARABIC 3371
//  CATALAN 3326
//  BASQUE 3277
//  SCOTS_GAELIC 3309
//  SWAHILI 3315
//  SLOVENIAN 3349
//  MARATHI 3239
//  MALTESE 3347
//  VIETNAMESE 3370
//  SLOVAK 3315
//  SUNDANESE 3317
//  UZBEK 6560
//  AZERBAIJANI 3352
//  PERSIAN 3394
//  BOSNIAN 2847
//  SESOTHO 2697
//  KYRGYZ 3268
//  YIDDISH 3270
//  KURDISH 3391
//  MONGOLIAN 13
//  AFRIKAANS 3319
//  KAZAKH 3303
//  TAJIK 3296
//  HAITIAN_CREOLE 3343
//  KINYARWANDA 3248
//  MALAGASY 2987
//  GANDA 3298
//  CEBUANO 2216
//  HMONG 2131
//  NYANJA 2830



// Recognized language-script combinations [74]:
static const char* const kQuadChrome1015_2RecognizedLangScripts = 
  "af-Latn ar-Arab az-Latn be-Cyrl bg-Cyrl bh-Deva bn-Beng bs-Latn "
  "ca-Latn ceb-Latn cs-Latn cy-Latn da-Latn de-Latn en-Latn es-Latn "
  "et-Latn eu-Latn fa-Arab fi-Latn fr-Latn ga-Latn gd-Latn gl-Latn "
  "hi-Deva hmn-Latn hr-Latn ht-Latn hu-Latn id-Latn is-Latn it-Latn "
  "iw-Hebr jw-Latn kk-Cyrl ku-Latn ky-Cyrl lg-Latn lt-Latn lv-Latn "
  "mg-Latn mk-Cyrl mn-Latn mr-Deva ms-Latn mt-Latn ne-Deva nl-Latn "
  "no-Latn ny-Latn pl-Latn pt-Latn ro-Cyrl ro-Latn ru-Cyrl rw-Latn "
  "sk-Latn sl-Latn sq-Latn sr-Cyrl sr-Latn st-Latn su-Latn sv-Latn "
  "sw-Latn tg-Cyrl tl-Latn tr-Latn uk-Cyrl ur-Arab uz-Cyrl uz-Latn "
  "vi-Latn yi-Hebr ";

static const uint32 kQuadChrome1015_2Size = 65536;    // Bucket count
static const uint32 kQuadChrome1015_2KeyMask = 0xffff0000;    // Mask hash key

static const IndirectProbBucket4 kQuadChrome1015_2[kQuadChrome1015_2Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0xe9da0002,0x7c2e0003,0x20070004,0x65630005}},	// [000] вка_, ssbr, _huni_, kenh, 
   {{0x20070006,0xbddb0007,0x63bb0008,0x7bc40009}},	//   _kuni_, stèr, hiun, sniu, 
   {{0xddc4000a,0x6563000b,0x52e2000c,0x02e2000d}},	//   _križ, denh, _पर्स, _पर्न, 
   {{0x6443000e,0x4916000f,0x63bb0010,0x20070011}},	//   duni, _प्रो_, jiun, _muni_, 
   {{0x20070012,0xdb810013,0x27ed0014,0x63a90015}},	//   _luni_, _эҳти, _dhen_, dhen, 
   {{0x65630016,0x64430017,0x6fdd0018,0xef1f0019}},	//   genh, funi, léct, tjük_, 
   {{0x6443001a,0x2451001b,0x9486001c,0x26cd001d}},	//   guni, _cơm_, рылд, _exeo_, 
   {{0x63bb001e,0xef1f0019,0x63a9001f,0xf7430020}},	//   giun, rjük_, ghen, _месо, 
   {{0x36670021,0x65630022,0x21270023,0x06070024}},	//   _като_, benh, _benh_, _внук_, 
   {{0x20070025,0x63a90026,0x6f040027,0x68050028}},	//   _buni_, ahen, _agic, _sėdi, 
   {{0x2b9c0029,0x7528002a,0x6aad002b,0x63bb002c}},	//   _tích_, _iedz, zzaf, biun, 
   {{0x63a9002d,0x63bb002e,0x4ea7002f,0x20070030}},	//   chen, ciun, арга, _duni_, 
   {{0x69dc0031,0x75280032,0xc6080033,0x6d470034}},	//   _okre, _kedz, রীরা_, tgja, 
   {{0x75280035,0x20070036,0x6e240037,0x71730038}},	//   _jedz, _funi_, _dwib, _وهنا, 
   {{0x75280039,0xddc4003a,0x212c0014,0x2007003b}},	//   _medz, _friž, madh_, _guni_, 
   {{0x212c003c,0x69c5003d,0x6d41003e,0x7e99003f}},	//   ladh_, wnhe, ólab, _منبر_, 
   {{0xafb80040,0x6b8d0041,0x69d70042,0x64430043}},	// [010] _خطوط_, rjag, toxe, zuni, 
   {{0x212c003c,0x63bb0044,0x20070045,0x64430046}},	//   nadh_, ziun, _yuni_, yuni, 
   {{0x65630047,0x27ed0048,0x69d70049,0x69c5004a}},	//   venh, _phen_, roxe, rnhe, 
   {{0x69dc004b,0x212c004c,0xc7c4004d,0xa804004e}},	//   _ekre, hadh_, осчи, ізіл, 
   {{0x75280035,0x63a9004f,0x64430050,0x672b0051}},	//   _bedz, vhen, wuni, ragj, 
   {{0x27ed0052,0x26df0053,0xdb1d0054,0x672b0034}},	//   _when_, _vyuo_, _eksô, sagj, 
   {{0x65630055,0x63bb0012,0x27ed0056,0x212c0057}},	//   renh, tiun, _then_, dadh_, 
   {{0x65630058,0x7e6d0059,0x2007005a,0xb385005b}},	//   senh, _osap, _runi_, слил, 
   {{0x63a9005c,0x6443005d,0xe299005e,0x63bb005f}},	//   rhen, suni, уап_, riun, 
   {{0x63a90060,0x212c003c,0x63bb0061,0x20070062}},	//   shen, gadh_, siun, _puni_, 
   {{0x63a90063,0x7e6d0064,0x2ee00065,0xddc40066}},	//   phen, _asap, _syif_, _priž, 
   {{0x66010067,0x6fdd0068,0x63a90026,0x66090069}},	//   _hilk, xéct, qhen, _kuek, 
   {{0x6601006a,0x7e6d006b,0x212c006c,0x6729006d}},	//   _kilk, _csap, badh_, _meej, 
   {{0x212c006e,0x6729006f,0xb2760070,0x7e6d0054}},	//   cadh_, _leej, _לענג_, _dsap, 
   {{0x10150071,0x66010072,0xfce60073,0x7e6d0074}},	//   _ابتد, _milk, сово, _esap, 
   {{0x69dc0075,0xee3f0076,0x260a0077,0x67290078}},	//   _skre, brý_, ादमी_, _neej, 
   {{0x0aea0079,0x6d41007a,0xddc4007b,0x6e24007c}},	// [020] удай_, ólac, _kriż, _uwib, 
   {{0x4425007d,0x46db007e,0x7995007f,0x66010080}},	//   _owl_, _बड़ह, _cozw, _nilk, 
   {{0xaad80081,0x7528002a,0xdceb0082,0x79950083}},	//   _भुरक, _redz, _ćiće, _dozw, 
   {{0xbb860084,0xa3e7000f,0xf7460085,0x06d10086}},	//   _الحي, _मील_, седо, ়েছি, 
   {{0x66010087,0x65940088,0x66090089,0x4425008a}},	//   _bilk, жалу, _cuek, _awl_, 
   {{0x69dc008b,0xdb16008c,0x8e57008d,0x5d7a0070}},	//   _ukre, ábær, מינג_, ראַק, 
   {{0x6601008e,0xe644008f,0xb8960038,0x44250090}},	//   _dilk, ğlığ, _الزع, _cwl_, 
   {{0x52140091,0xe6440092,0x53980093,0xddc4008a}},	//   одит, şlığ, рвия_, _ariż, 
   {{0x212c0094,0x6fc80095,0x6601008a,0x6fdd0096}},	//   tadh_, rıcl, _filk, kécr, 
   {{0x20090097,0xddcd0098,0xb0340099,0x26f6009a}},	//   _čair_, _krať, онош, ेशीर_, 
   {{0x212c003c,0x6729009b,0xdb0d003e,0x7413009c}},	//   radh_, _yeej, knað, _فولا, 
   {{0x6601009d,0xbb1b009e,0x212c009f,0x7f9f0034}},	//   _zilk, _anîn, sadh_, _këqi, 
   {{0x4ad80081,0x212c00a0,0xeabf00a1,0x27fc0032}},	//   _भुलव, padh_, _ceùl_, ívny_, 
   {{0xa2c500a2,0xfee700a3,0xddc400a4,0x491a00a5}},	//   ापर्, _қўйм, _griż, मुमो_, 
   {{0x7995006a,0x5ba700a6,0x71bb00a7,0x7c84002e}},	//   _rozw, браз, _תצוג, путе, 
   {{0xdb0d008c,0x2d8c00a8,0x7e6d00a9,0x48ef00aa}},	//   gnað, öder_, _tsap, _अरबो_, 
   {{0x799500ab,0x7e6d00ac,0x681500ad,0x74df00ae}},	// [030] _pozw, _usap, _işdə, _पुनः, 
   {{0x5a3400af,0x672900b0,0xaa7b0098,0x00000000}},	//   янут, _seej, _ozýv, --, 
   {{0xe71900b1,0x98b800b2,0x9b9500b3,0x660900b4}},	//   ليات_, _barı_, _динц, _suek, 
   {{0xe00b00b5,0x00000000,0x00000000,0x00000000}},	//   _संसद_, --, --, --, 
   {{0x660100b6,0x442500b7,0xd24600b8,0xbddb00b9}},	//   _pilk, _swl_, _تن_, crèc, 
   {{0xcfcf0086,0x441500ba,0x00000000,0x00000000}},	//   রতিন, офит, --, --, 
   {{0x660100bb,0x70d700bc,0x672900bd,0xddc400a4}},	//   _vilk, _डडेल, _teej, _rriż, 
   {{0x36d500be,0x9487004e,0x57a400bf,0x660100c0}},	//   _добр, _қызд, _ешуа, _wilk, 
   {{0x660100c1,0x660900c2,0xddc400c3,0x00000000}},	//   _tilk, _uuek, _priż, --, 
   {{0x869800c4,0x11d60038,0xd19900b3,0x00000000}},	//   _укус_, يوية_, ртич_, --, 
   {{0xe2a800c5,0xfbd900c6,0x98b8008f,0x00000000}},	//   لاین_, भकाम, _yarı_, --, 
   {{0x14d600c7,0x225900c8,0x63b90027,0x00000000}},	//   _וועל_, _виды_, _umwn, --, 
   {{0xc8e600c9,0xddc400ca,0x00000000,0x00000000}},	//   _कर्म_, _asiš, --, --, 
   {{0xa0a500cb,0x853c0028,0x00000000,0x00000000}},	//   _малд, _alėj, --, --, 
   {{0x09c400cc,0x8b9600cd,0x3b9600ce,0xdb0d003e}},	//   ্তমা, орач, ојат, tnað, 
   {{0xeb9a00cf,0x7c3a00d0,0xc05200d1,0x00000000}},	//   шиб_, štro, _חזה_, --, 
   {{0x7c2900d2,0xdb0d003e,0x00000000,0x00000000}},	// [040] ćera, rnað, --, --, 
   {{0xed5a00d3,0x2b5800d4,0x98b8008f,0xbc6600d5}},	//   _тоо_, _گیرد_, _sarı_, _двок, 
   {{0xc8ca00d6,0xd90d00d7,0x00000000,0x00000000}},	//   جوان_, ایف_, --, --, 
   {{0xddcd00d8,0x00000000,0x00000000,0x00000000}},	//   _vrať, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe5a300d9,0xddcd00da,0x00000000,0x00000000}},	//   мичи, _trať, --, --, 
   {{0x07a600db,0xdb06002c,0x83aa00a3,0x533400dc}},	//   _давн, _alké, итиб_, пейт, 
   {{0xd32600dd,0x81e70086,0xaa7b00de,0x68b700df}},	//   цьки, _মূল_, _vzýv, _וללא_, 
   {{0xdcfe00e0,0x9f4000e1,0x00000000,0x00000000}},	//   _kopē, _fhiú_, --, --, 
   {{0x2a6200e2,0x27e600e3,0xd25700e4,0xa69700d1}},	//   _mpkb_, llon_, іцы_, _וכמה_, 
   {{0x201800e5,0xdb060019,0x6ac600e6,0x261000e7}},	//   ëri_, _elké, लपुर, _hào_, 
   {{0x27e600e8,0x75ed00e9,0x45220033,0x28bd00ea}},	//   nlon_, púzc, _নাটক_, ्पति, 
   {{0xd25000eb,0xa2d6009c,0x201800ec,0x5f9400ed}},	//   _أنت_, _بيشت, ūri_, фият, 
   {{0x27e600ee,0x2a7f00ef,0x26100023,0xdd8400f0}},	//   hlon_, _šubo_, _mào_, мысп, 
   {{0x27e600f1,0x261000e7,0x2ca500f2,0x6f1600f3}},	//   klon_, _lào_, áld_, _ffyc, 
   {{0x2a6200f4,0xdb1f0034,0x764200f5,0x248e00f6}},	//   _bpkb_, miqë, kroy, ixfm_, 
   {{0x261000f7,0x291c00ad,0x27e600f8,0x672200f9}},	// [050] _nào_, ıvan_, dlon_, dboj, 
   {{0x764200fa,0xceb20070,0x3ea400fb,0x290700fc}},	//   droy, _ניי_, ømte_, øna_, 
   {{0x984b00fd,0x00000000,0x00000000,0x00000000}},	//   ряза_, --, --, --, 
   {{0xf09300fe,0x261000e7,0x27e600f8,0x201e0028}},	//   ונע_, _bào_, glon_, ipti_, 
   {{0x26100023,0x79a700ff,0xff7c0070,0x4ae400a3}},	//   _cào_, _дрве, יטאמ, _жўра, 
   {{0x5a340100,0x99640101,0xbafa00d1,0x27e60102}},	//   _інст, _отсл, _להרש, alon_, 
   {{0x27e60103,0x185400a3,0x27220104,0x00000000}},	//   blon_, _оврў, _fаn_, --, 
   {{0xd90e0105,0x9f4000a1,0x76420106,0x00000000}},	//   _لیے_, _fhiù_, broy, --, 
   {{0x76420107,0x35b500d9,0x26100108,0x00000000}},	//   croy, _ебар, _gào_, --, 
   {{0xd6c60109,0x661b010a,0x14190038,0x00000000}},	//   _عملی, _ituk, _هيئة_, --, 
   {{0x3cdb010b,0xbb1b010c,0xc8bd00bc,0x00000000}},	//   _खुले_, _anîm, ्पिट, --, 
   {{0x6d41010d,0xe3b3010e,0x00000000,0x00000000}},	//   ólan, _غرض_, --, --, 
   {{0xa3ca010f,0x26100023,0xb2c7010e,0x64df0110}},	//   ोवर_, _xào_, _بغاو, _पुतळ, 
   {{0xdd9200c5,0x427a0111,0x6722003a,0x7c290112}},	//   روز_, _לאנג, zboj, ćern, 
   {{0x27e60113,0x0c790114,0xa0a50115,0xc0e2004f}},	//   ylon_, осты_, _хайд, _пошк, 
   {{0x5f760116,0x661b0117,0xbebb0034,0x3c180118}},	//   _رابر, _otuk, mbën, _nčve_, 
   {{0xeb970119,0x27e60104,0x6722011a,0x661b011b}},	// [060] чит_, vlon_, vboj, _ntuk, 
   {{0x673b011c,0x261000e7,0x7e64011d,0xfa490038}},	//   _aduj, _rào_, _ipip, تشفى_, 
   {{0x661b011e,0x478600d3,0x26100108,0x6843011f}},	//   _atuk, зылб, _sào_, енха, 
   {{0x2d9a00a7,0x76420120,0x64430121,0xa2dc009a}},	//   _hope_, troy, drni, _पडल्, 
   {{0x672200e0,0x2d9a0122,0x6d5c0036,0xa613004f}},	//   rboj, _kope_, ofra, еміч, 
   {{0x6d4e0123,0x26100124,0x6d5c0125,0x76420126}},	//   ngba, _vào_, nfra, rroy, 
   {{0x27e60127,0x2d9a0026,0x661b0128,0x290a011c}},	//   plon_, _mope_, _etuk, _igba_, 
   {{0x69de0129,0x7e6400d2,0x7642012a,0x9734009c}},	//   lope, _opip, proy, _آکاا, 
   {{0x321f012b,0x6d5c012c,0x04fe0033,0x41e6012d}},	//   gpuy_, kfra, ুরের_, зіна, 
   {{0x6d4e012e,0x69de012f,0x30140130,0x56370070}},	//   jgba, nope, мдор, _מאמע_, 
   {{0xe8df00e7,0x7ae60131,0xf99300d1,0x6d5c0132}},	//   _trục_, _lykt, תרת_, dfra, 
   {{0xd36f0133,0x69de0134,0x4f0900d3,0xbddb011c}},	//   _مهم_, hope, өнүн_, grèn, 
   {{0x6d5c0135,0x644a003a,0x69de0136,0xe3b30137}},	//   ffra, lufi, kope, _אױף_, 
   {{0x72eb0138,0x2d9a0139,0x00000000,0x00000000}},	//   _פֿאַ, _cope_, --, --, 
   {{0xd5c800f7,0x6458013a,0x7c290112,0x5ba7013b}},	//   yền_, ntvi, ćero, праз, 
   {{0x6d4e013c,0xc1780009,0x399f009e,0x00000000}},	//   agba, ldė_, _lîst_, --, 
   {{0xb999013d,0xdd95013e,0x6d5c013f,0x99990140}},	// [070] овах_, _жапы, bfra, окат_, 
   {{0x5c070141,0xc178012d,0x64430142,0x7ae6004f}},	//   _няма, ndė_, yrni, _dykt, 
   {{0x3ea6002a,0x661b0143,0x75ed00da,0x661c0144}},	//   _ļoti_, _stuk, fúzn, _črka, 
   {{0x64430145,0x2d9a0146,0xdc360147,0x98c40148}},	//   vrni, _zope_, _קארט_, хсул, 
   {{0x7bdf001d,0x399f009e,0x69de0149,0x4b7a00d1}},	//   moqu, _bîst_, bope, _וארו, 
   {{0x7bdf014a,0xddd6014b,0x6443014c,0x7bcd014d}},	//   loqu, _kryš, trni, lnau, 
   {{0x6458014e,0x33f5014f,0x64430150,0xbddb0151}},	//   gtvi, мчис, urni, yrèn, 
   {{0x22150152,0x7bcd0153,0x260a0154,0x64430155}},	//   мфор, nnau, ादशी_, rrni, 
   {{0x6d5c0156,0x661b0157,0x42540158,0xd24e007a}},	//   yfra, _utuk, нтэт, لني_, 
   {{0xa2e300cf,0x7bcd0159,0x10a5015a,0x23c30118}},	//   моқд, hnau, дион, _bèjè_, 
   {{0x5455015b,0x2d9a015c,0x00000000,0x00000000}},	//   _цвет, _rope_, --, --, 
   {{0xd24e015d,0x7c3a015e,0xe291015f,0x69de0160}},	//   دنی_, štrk, _لذت_, zope, 
   {{0xd1750161,0x69de0053,0x6d5c0162,0x7bcd0106}},	//   _жыйы, yope, tfra, dnau, 
   {{0x90c50163,0x7ae60164,0x69de0165,0x3f890090}},	//   _обле, _rykt, xope, _enau_, 
   {{0xfce30166,0x6d5c0167,0x1d070168,0x7bdf0169}},	//   воро, rfra, дери_, foqu, 
   {{0x8ffa00d4,0x320f016a,0x764b016b,0x32070054}},	//   _برتر_, _kugy_, kugy, _hiny_, 
   {{0x2fc0016c,0x3207007c,0x00000000,0x00000000}},	// [080] _imig_, _kiny_, --, --, 
   {{0x3207016d,0x320f011c,0x7ae60028,0x00000000}},	//   _jiny_, _mugy_, _vykt, --, 
   {{0xeb9a016e,0x69de016f,0x8b260170,0x7bdf0171}},	//   _дин_, rope, _одне, boqu, 
   {{0xfaa600cf,0x46ea0172,0x7bdf0173,0xdb1f010c}},	//   _жамо, оден_, coqu, liqî, 
   {{0x69de0174,0x9f520175,0x6a8600a3,0x35c40176}},	//   pope, _chyé_, _ўлга, надҳ, 
   {{0x64580177,0x644a0178,0x32070054,0x28d90179}},	//   ttvi, tufi, _niny_, _बुकि, 
   {{0xd90d017a,0x6458017b,0x799c017c,0x00000000}},	//   _ایم_, utvi, _iorw, --, 
   {{0x28bd017d,0x6458017e,0x02a6017f,0x32070180}},	//   ्परि, rtvi, дром, _ainy_, 
   {{0x200e0181,0x96180086,0x6aa40182,0x6f09014b}},	//   _sufi_, _ডটকম_, nyif, žeck, 
   {{0xb5aa0038,0x7bdf0183,0xc1780028,0x00000000}},	//   _بارك_, zoqu, udė_, --, 
   {{0x26ee0184,0x799c0185,0x61e80186,0xc1780028}},	//   _जरुर_, _morw, rldl, rdė_, 
   {{0xdce50187,0x64a30188,0x73360189,0x3383018a}},	//   _pohľ, _шаха, _آرائ, _аушв, 
   {{0xa3e7018b,0x799c018c,0x7bdf018d,0x442c010c}},	//   _मीट_, _oorw, voqu, _hwd_, 
   {{0x2907012d,0x320700b9,0xd0d400fd,0x442c018e}},	//   žnai_, _giny_, _полъ, _kwd_, 
   {{0x7bdf00ce,0xd139018f,0x00000000,0x00000000}},	//   toqu, _ххі_, --, --, 
   {{0x26ee0190,0x62820191,0x53de00a2,0x66080192}},	//   _जरूर_, _kroo, मविश, _lidk, 
   {{0x7bcd0193,0x799c0194,0xdee70195,0x6f0d0196}},	// [090] rnau, _borw, _تأثي, _igac, 
   {{0x5c750197,0xf9930198,0x6e2d0199,0xdb0d0107}},	//   _злот, خبر_, _iwab, chaî, 
   {{0x2009019a,0xa37d019b,0x7bdf019c,0x00000000}},	//   _kiai_, loŵe, poqu, --, 
   {{0x6e2d019d,0xa635019e,0x68e7014b,0x764b019f}},	//   _kwab, енді, _vyjd, tugy, 
   {{0x628201a0,0x6e2d016a,0x799c00d1,0x68e70083}},	//   _nroo, _jwab, _forw, _wyjd, 
   {{0x6e2d01a1,0xba430009,0xe29901a2,0xc58b0080}},	//   _mwab, žįst, ҷаи_, ющее_, 
   {{0x69c50180,0x76590156,0x6e2d01a3,0x628201a4}},	//   mihe, stwy, _lwab, _aroo, 
   {{0x6f0d01a5,0xe29901a2,0x628201a6,0x320701a7}},	//   _ngac, заи_, _broo, _siny_, 
   {{0x09c40033,0x62820139,0x6b9d01a8,0x00000000}},	//   ্তরা, _croo, _mosg, --, 
   {{0x628201a9,0x6b9d01aa,0x7c3a015e,0x6f0d0199}},	//   _droo, _losg, štri, _agac, 
   {{0xa0a501ab,0x6e2d01ac,0x628201ad,0x853c0009}},	//   ханд, _awab, _eroo, _plėv, 
   {{0x7ddb009e,0x6e2d01ae,0x69c501af,0x828301b0}},	//   mîsy, _bwab, hihe, _ақид, 
   {{0xee3701b1,0x628201b2,0x63a901b3,0x320700df}},	//   ння_, _groo, mken, _tiny_, 
   {{0x7c2201b4,0x236d006d,0x4cc10033,0x69c501b5}},	//   _čorb, leej_, _শুধু, jihe, 
   {{0x3074004e,0x6b9d01b6,0x61e101b7,0x6e2d01b8}},	//   _ауыс, _bosg, moll, _ewab, 
   {{0xddcd00e4,0x63a901b9,0x2009001b,0xeb9701ba}},	//   _graž, nken, _giai_, нис_, 
   {{0x6b6301bb,0x799c01bc,0x63a901bd,0x6b9d01be}},	// [0a0] ыкта, _porw, iken, _dosg, 
   {{0x61e101bf,0x63a901c0,0x236d01c1,0x69c501c2}},	//   noll, hken, heej_, gihe, 
   {{0x63a901c3,0x799c01c4,0x6b9d01c5,0x574601c6}},	//   kken, _vorw, _fosg, енеб, 
   {{0x61e101c7,0x63a901c8,0x1bba01c9,0x224d01ca}},	//   holl, jken, _راجع_, kuek_, 
   {{0x61e101cb,0x63a901cc,0x9980012d,0x69c501cd}},	//   koll, dken, usių_, bihe, 
   {{0x63a901ce,0x224d01cf,0x99800028,0x00000000}},	//   eken, duek_, rsių_, --, 
   {{0x186701d0,0x316c0187,0x61e101d1,0x63a901d2}},	//   _пари_, vedz_, doll, fken, 
   {{0x63a901d3,0x628201d4,0x645c00c2,0x6f0900ca}},	//   gken, _proo, _ärim, žeci, 
   {{0x6d4101d5,0x224d01d6,0xd25701d7,0x81c601d8}},	//   ólak, guek_, нцэ_, ещне, 
   {{0xbddb01d9,0x6e2d0199,0x628201da,0x7abb00d1}},	//   trèm, _rwab, _vroo, פציו, 
   {{0xddcd01db,0x6e2d01dc,0x20090065,0x316c01dd}},	//   _praž, _swab, _piai_, redz_, 
   {{0x645a01de,0x63a901df,0x657a01e0,0xd46900eb}},	//   _iqti, cken, _hath, _تحكم_, 
   {{0x657a01e1,0xddcd01e2,0x71a600e4,0x69c501e3}},	//   _kath, _vraž, _падз, yihe, 
   {{0x61e101e4,0xd12f00c5,0x657a01e5,0x40940038}},	//   coll, _همه_, _jath, _للتر, 
   {{0xddcd01e6,0x6b9d01e7,0x628001e8,0x657a01e9}},	//   _traž, _posg, lvmo, _math, 
   {{0x657a01ea,0x6e2d01eb,0x25dc01ec,0x6f0d01ed}},	//   _lath, _twab, मकुण, _ugac, 
   {{0x245a01ee,0x3df50141,0xef640093,0x6b9d01ef}},	// [0b0] hëm_, _изис, _също, _vosg, 
   {{0xdb0d00eb,0x3eb301f0,0x63a901f1,0xddcd01f2}},	//   mhaí, ıntı_, zken, _jraż, 
   {{0x69c501f3,0x63a901f4,0x6b9d01f5,0x00000000}},	//   rihe, yken, _tosg, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe618005e,0x8b9a00a7,0x69c501f6,0x8a1801f7}},	//   еді_, _חברת, pihe, _пояс_, 
   {{0xb6a200cf,0x657a01f8,0x61e101f9,0xd24300a3}},	//   ришл, _cath, xoll, қмоқ, 
   {{0x61e101fa,0x657a01fb,0x69d501c8,0xa71501fc}},	//   voll, _dath, _ijze, _амбі, 
   {{0xc178012d,0x657a01fd,0x68e301c4,0x224d01f1}},	//   klės_, _eath, ündu, tuek_, 
   {{0x61e101fe,0x853c0009,0xddcd007b,0xe1f901ff}},	//   toll, _plėt, _braż, мги_, 
   {{0x926400eb,0x67d30200,0x236d0201,0x777b01f1}},	//   اديم, _роғу, seej_, _haux, 
   {{0x63a90202,0x224d01cf,0x00000000,0x00000000}},	//   pken, suek_, --, --, 
   {{0x61e10203,0x657a0204,0x224d00b4,0x43740205}},	//   soll, _zath, puek_, _бушт, 
   {{0x61e10206,0x657a0204,0xddcd00a4,0x00000000}},	//   poll, _yath, _fraż, --, 
   {{0x61450207,0x777b0108,0x61e10208,0x7e7600de}},	//   _река, _laux, qoll, _vsyp, 
   {{0xb02400f7,0xfce60073,0x1fb60209,0x2b3a00b3}},	//   _trườ, тово, _аспр, дязэ_, 
   {{0x1e86020a,0xf4130086,0x8e4a0038,0x9f42020b}},	//   _алим, _সবার_, _قلبك_, blká_, 
   {{0xc3320052,0x245a00e5,0xdcfe01dd,0x00000000}},	// [0c0] יון_, zëm_, _kopī, --, 
   {{0xe9d7020c,0x9f4000b9,0xa923020d,0x00000000}},	//   вку_, _thió_, идул, --, 
   {{0x657a020e,0x9f42010c,0xdd05020f,0x777b0210}},	//   _rath, vokê_, ăsăt, _baux, 
   {{0x657a0211,0x7bda0212,0xe3b80213,0x46a6011f}},	//   _sath, étud, _atın_, каев, 
   {{0xeb970214,0x657a0215,0x4991010e,0x9f420216}},	//   _рия_, _path, _گیلر, tokê_, 
   {{0x245a01ee,0x7c3a0217,0x645c00c2,0xceb30147}},	//   tëm_, štru, _ärik, סיג_, 
   {{0x9f420218,0x629d0219,0x02ca021a,0x7414021b}},	//   rokê_, äson, ाप्न, دوبا, 
   {{0x657a0204,0x07a3021c,0xe8f7021d,0x245a021e}},	//   _wath, _касн, _рлс_, rëm_, 
   {{0xc606021f,0xa6650198,0xe737004e,0x245a0034}},	//   _азай, _مطلو, _шет_, sëm_, 
   {{0x657a00eb,0x601e00e0,0xd5fb0210,0x00000000}},	//   _uath, _līme, _trú, --, 
   {{0x7f590220,0x9f350221,0x8f350222,0x255a0118}},	//   нанс_, лені, ленц, _vņlč_, 
   {{0x1fa70223,0xdb0d00eb,0x67f800bc,0xddcd0035}},	//   трог, thaí, bíje, _wraż, 
   {{0xecdb000f,0x443e0224,0x7c220032,0x798e0118}},	//   _मुजफ, _hvt_, _čora, _onbw, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa3d600c9,0x443c0183,0x443e0054,0xc1780028}},	//   _सदा_, nsv_, _jvt_, slės_, 
   {{0x644a0038,0x7d08010e,0x547b0225,0xbddb0151}},	//   irfi, _sérü, וטלו, guèr, 
   {{0x39580226,0x62840009,0x443c0097,0x777b0227}},	// [0d0] _bcrs_, _šioj, hsv_, _raux, 
   {{0x23b10228,0x4c950229,0x395801be,0x9935022a}},	//   _mája_, _биос, _ccrs_, افات, 
   {{0x2907022b,0x98140038,0x4cc10033,0xf8b6022c}},	//   äna_, لبنا, _শুরু, гөт_, 
   {{0x9b9500d9,0x2cac017b,0xdb0d00b4,0xc864022d}},	//   _симц, ødde_, piañ, ртфи, 
   {{0x75ed022e,0x9f440212,0x7bda0212,0x4993010e}},	//   lúzi, ômé_, étue, _پیار, 
   {{0x248500f4,0x2b5900ef,0x6d55022f,0xf48300d4}},	//   _prlm_, _hcsc_, ngza, لاعی, 
   {{0xe8940230,0x69d8009a,0x00000000,0x00000000}},	//   _карь, _मदती, --, --, 
   {{0x29070028,0x443e0231,0xf1d1022c,0x00000000}},	//   žnas_, _dvt_, өөлө, --, 
   {{0x443e0232,0x36d5002e,0x11e50233,0xddcf020b}},	//   _evt_, _соар, лжим, pucň, 
   {{0xdb040038,0x67f8020b,0x00000000,0x00000000}},	//   thiú, ríje, --, --, 
   {{0xcea90137,0x8fa60234,0x90c50235,0x443e0236}},	//   _צי_, гане, убне, _gvt_, 
   {{0x26190108,0xdb0f0151,0x3c180237,0x00000000}},	//   _kèo_, _ulcè, _sčvo_, --, 
   {{0xe1ee0238,0x2bc60239,0x443e023a,0x00000000}},	//   _гг_, रोफा, _zvt_, --, 
   {{0x237d023b,0x261900e7,0x5fc600b0,0x00000000}},	//   _hawj_, _mèo_, _लगवल, --, 
   {{0xbb46023c,0x225f023d,0x26190210,0x00000000}},	//   левк, ltuk_, _lèo_, --, 
   {{0xc0520056,0x3a22016a,0x6d5501d2,0x9f42023e}},	//   _הזה_, _ptkp_, agza, koké_, 
   {{0x225f023f,0x198a0240,0xdd040241,0x00000000}},	// [0e0] ntuk_, нбаи_, ırıs, --, 
   {{0x237d0201,0x6e2401f0,0x7c3e0242,0x4427016a}},	//   _lawj_, _itib, _tvpr, kpn_, 
   {{0x601e0243,0x00000000,0x00000000,0x00000000}},	//   _tīme, --, --, --, 
   {{0x237d023b,0x26190023,0xfaff0034,0x6e2400a4}},	//   _nawj_, _bèo_, _ibën_, _ktib, 
   {{0x569400b3,0x443e014e,0xe5a60244,0xe5c60245}},	//   ралт, _svt_, лиди, лско, 
   {{0x443e0246,0x281600d4,0x644a0097,0x6e240247}},	//   _pvt_, _موسس, trfi, _mtib, 
   {{0xdd320248,0x8cca0249,0x00000000,0x00000000}},	//   zəşt, _हेमो, --, --, 
   {{0x7f44024a,0x644a024b,0x9f42024c,0xbebb021e}},	//   _ndiq, rrfi, boké_, mbëv, 
   {{0x237d006d,0x6e24024d,0x27e6024e,0x85560071}},	//   _dawj_, _ntib, moon_, _مخاط, 
   {{0xd6cf024f,0x27e60250,0x104a0251,0x237f0082}},	//   _عقل_, loon_, нями_, aduj_, 
   {{0x6e240252,0x94260253,0xb6030254,0x7bc60255}},	//   _atib, _смее, íšen, _omku, 
   {{0x27e60256,0x2a600257,0x1fc50258,0x23660144}},	//   noon_, ktib_, рроҳ, _uboj_, 
   {{0x623400d9,0x44ce00ad,0x20670259,0x26190108}},	//   _телу, _hə_, _ұшып_, _xèo_, 
   {{0x27e6025a,0x63a2007e,0x7bc6025b,0x2a79016c}},	//   hoon_, _hoon, _amku, _rssb_, 
   {{0x63a2025c,0x27e6025d,0x6e24025e,0xef1100d3}},	//   _koon, koon_, _etib, _мүнө, 
   {{0x764b017c,0x63a2025f,0x7dea010c,0x27e60260}},	//   yrgy, _joon, _pêsî, joon_, 
   {{0x27e6011d,0x38c90019,0x68ee01ff,0x44ce00ad}},	// [0f0] doon_, ھائی_, _aybd, _lə_, 
   {{0x63a20261,0x26180262,0x2bc60263,0x60d300e0}},	//   _loon, _पढ़ी_, रोबा, ņemš, 
   {{0x44ce0264,0x27e60265,0x6d450266,0xbc950267}},	//   _nə_, foon_, _idha, _танј, 
   {{0x63a20268,0x27e60269,0xbddb026a,0x68ee01e8}},	//   _noon, goon_, ssèd, _dybd, 
   {{0x9f42010c,0x69cb010e,0x00000000,0x00000000}},	//   kokî_, éges, --, --, 
   {{0x9f42026b,0x3a2900e2,0xce3800d1,0x320e01a7}},	//   roké_, mpap_, נאות_, _nify_, 
   {{0x63a2026c,0x2905026d,0x9f42026e,0x6d45026f}},	//   _boon, _àla_, soké_, _mdha, 
   {{0x44ce0270,0xc2450271,0x225f010e,0x67d50272}},	//   _də_, аник, ttuk_, _тобу, 
   {{0x63a201a4,0x6d450273,0x7e6d0102,0xa3d6009a}},	//   _doon, _odha, _npap, _सदर_, 
   {{0xb5fd00f1,0x6d45009c,0xf4850274,0x7dc90097}},	//   _opši, _ndha, _پائی, džso, 
   {{0x7e6d0275,0x225f0276,0x7c2200ef,0x237d006f}},	//   _apap, stuk_, _čoro, _tawj_, 
   {{0x6d450277,0x8e860278,0x63a20279,0xc49a027a}},	//   _adha, агме, _goon, _בשעת, 
   {{0x7c25027b,0x69c7027c,0x44250097,0x20020097}},	//   _athr, _omje, _htl_, rmki_, 
   {{0x63a2027d,0x44ce00ad,0x291f027e,0x27e6027f}},	//   _zoon, _yə_, _şuan_, zoon_, 
   {{0x63a20280,0x417400d4,0x30790070,0x7e6d0281}},	//   _yoon, _دانس, _יאַנ, _epap, 
   {{0x44250282,0x8b260283,0x63a20210,0x00000000}},	//   _mtl_, рдае, _xoon, --, 
   {{0x6a830284,0x3f92011d,0x19c6011f,0x98b10237}},	// [100] олта, _inyu_, абам, _dezč_, 
   {{0x27e60285,0xd9460286,0x2a600287,0x644100bc}},	//   woon_, режи, rtib_, _ovli, 
   {{0xe73a0288,0x27e60289,0xb60700e0,0xa3c600c9}},	//   вее_, toon_, _mašī, _उगल_, 
   {{0x0686028a,0xd62a028b,0xc6a6028c,0xb6cb0019}},	//   иген, воде_, ирли, ھانے_, 
   {{0x27e6028d,0x6441028e,0x2bc6028f,0x88840290}},	//   roon_, _avli, रोणा, _گیان, 
   {{0xbebb01ee,0x27e60291,0x44250292,0x224d00b0}},	//   mbët, soon_, _btl_, drek_, 
   {{0x44250293,0x63a20294,0x27e60295,0x88840296}},	//   _ctl_, _poon, poon_, _دیان, 
   {{0x44ce0297,0x7bd60298,0x67f80228,0x66030201}},	//   _və_, nnyu, bíja, amnk, 
   {{0x6441008f,0xe57a0267,0x0ec50299,0xf669029a}},	//   _evli, _иза_, _लेंड, _محله_, 
   {{0x63a2029b,0xd5aa00b0,0x2ade007e,0x2bc6029c}},	//   _woon, _कविज, _कुछु_, रोता, 
   {{0x63a2029d,0x9f42010c,0x4185004e,0x09f7029e}},	//   _toon, rokî_, стығ, שמים_, 
   {{0xc4770056,0x224d029f,0x3f8002a0,0x232a01ba}},	//   _כתבו_, brek_, _caiu_, _роди_, 
   {{0x539b02a1,0x6d4502a2,0x442502a3,0xef1f02a4}},	//   _שידו, _pdha, _ztl_, rcü_, 
   {{0xdb0d0165,0x4425027e,0x7de700f0,0x3f9202a5}},	//   lhaç, _ytl_, рімд, _enyu_, 
   {{0xab9502a6,0x8bc702a7,0xd1380083,0x00000000}},	//   бављ, асад, ając_, --, 
   {{0x69c702a8,0x5b1502a9,0xdb0d02aa,0xbf3500fd}},	//   _smje, смат, nhaç, _унищ, 
   {{0x2fc901fd,0x6d41008c,0x2bc602ab,0x7e6d02ac}},	// [110] _imag_, ólas, रोधा, _upap, 
   {{0x6d4502ad,0x61e802ae,0x67f80032,0x48ab00f0}},	//   _udha, nodl, víja, ктем_, 
   {{0x4dda00d1,0x00000000,0x00000000,0x00000000}},	//   _תחתו, --, --, --, 
   {{0x442502af,0x61e80076,0x93bc020f,0x224d0241}},	//   _rtl_, hodl, _stăn, yrek_, 
   {{0x7bcd012d,0x2d81007e,0x2d8302b0,0x5a440158}},	//   miau, _kahe_, odje_, _мэра, 
   {{0x69c702b1,0x2d8302b2,0x7bcd00e4,0x2d8102b3}},	//   _umje, ndje_, liau, _jahe_, 
   {{0xf77302b4,0x2d8102b5,0x61e800a3,0x776901f2}},	//   _وار_, _mahe_, dodl, _tbex, 
   {{0x86b3005e,0x224d02b6,0x7bcd012d,0x2d8100b0}},	//   _мәлі, trek_, niau, _lahe_, 
   {{0x27ed02b7,0x6aad02b8,0x11390028,0x130900d9}},	//   _iken_, nyaf, ляны_, ыний_, 
   {{0x527502b9,0x224d02ba,0x3f8002bb,0x2d83012e}},	//   _ҳуку, rrek_, _saiu_, jdje_, 
   {{0x600a02bc,0x7bcd02bd,0xbf9b02be,0x25a500a1}},	//   лном_, kiau, rmên, _ioll_, 
   {{0x25a502bf,0x439402c0,0x224d02c1,0xdb0d0165}},	//   _holl_, _махс, prek_, chaç, 
   {{0x216902c2,0x25a5014e,0x4ac702c3,0x41b60161}},	//   _били_, _koll_, _रेलव, рсөт, 
   {{0x2d8302a8,0x2fc900b3,0x412602c4,0x63bb02c5}},	//   gdje_, _emag_, _лошо_, lhun, 
   {{0x27ed02c6,0x628b02c7,0x7055010e,0x645c00c2}},	//   _oken_, _hrgo, _انعا, _ärit, 
   {{0x7bcd012d,0x3f9200f4,0x69d70183,0x2d8302b0}},	//   giau, _unyu_, enxe, adje_, 
   {{0xe9da02c8,0xdb1d02c9,0x394602ca,0x63bb02cb}},	// [120] гка_, _omsæ, йнаг, ihun, 
   {{0x645c02cc,0x27ff02cd,0x25a502ce,0x27ed02cf}},	//   _årig, _ahun_, _noll_, _aken_, 
   {{0x6c860084,0x27ff02d0,0x63bb02d1,0x7bcd012d}},	//   _الجم, _bhun_, khun, biau, 
   {{0x27ff02d2,0x7bcd02d3,0x628b02d4,0xb73a00eb}},	//   _chun_, ciau, _orgo, اثاء_, 
   {{0x63bb02d5,0x95ca02d6,0x25a502d7,0x27ff01fd}},	//   dhun, лука_, _boll_, _dhun_, 
   {{0x6b8402ae,0x27ed02d8,0x27ff01f1,0x7a4102d9}},	//   ldig, _eken_, _ehun_, sátý, 
   {{0x31cd00cc,0x628b02da,0x61e802db,0x6d5e00b4}},	//   রকাশ, _argo, vodl, _mcpa, 
   {{0x63bb02dc,0x2d8302dd,0x2012016c,0x78a100f6}},	//   ghun, zdje_, _niyi_, _àlva, 
   {{0xd13000eb,0x1a9a00c7,0x6b8402de,0x25a502df}},	//   ومة_, ריִע, idig, _foll_, 
   {{0x361b00a7,0x2fc902e0,0x154302e1,0x25a500f8}},	//   _עובד, _smag_, _неум, _goll_, 
   {{0x2d8300ef,0x63bb007a,0x20120027,0x61e802e2}},	//   vdje_, bhun, _biyi_, rodl, 
   {{0x63bb02e3,0x753a012e,0xf8b300a7,0x200002e4}},	//   chun, _hetz, פשר_, _chii_, 
   {{0x6b8402e5,0xa3e502e6,0xddc40228,0x200001be}},	//   ddig, पकर_, _spiš, _dhii_, 
   {{0x753a02e7,0x75ff010c,0x6b8402e8,0x6d5e00b9}},	//   _jetz, rêzg, edig, _ccpa, 
   {{0x7bcd02e9,0x2d8302ea,0x19ab004e,0x753a02eb}},	//   tiau, rdje_, қтап_, _metz, 
   {{0x753a02ec,0x5c0702ed,0xddc402ee,0x2fc902ef}},	//   _letz, сяга, _vpiš, _umag_, 
   {{0x7bcd00e4,0x6e3602f0,0x0dcb02f1,0x2d8101a4}},	// [130] riau, _gwyb, _буни_, _tahe_, 
   {{0x753a02f2,0x213e01fd,0x7bcd02f3,0x6b8402f4}},	//   _netz, nath_, siau, adig, 
   {{0xddc402f5,0x6aad02f6,0x27ff00e7,0x25a502f7}},	//   _upiš, syaf, _phun_, _roll_, 
   {{0x25a502ec,0x64c302f8,0xbddb023e,0x00000000}},	//   _soll_, _वेगळ, près, --, 
   {{0xb5fd02f9,0x25a502fa,0x959902fb,0x1c1f02fc}},	//   _opšt, _poll_, итку_, _मंडल_, 
   {{0x7afd02fd,0x7dc902fe,0x59dd02ff,0x3c180300}},	//   _izst, džsk, _मदिर, _sčvi_, 
   {{0x63bb0301,0x25a501c4,0x27ff0302,0x799501c4}},	//   thun, _voll_, _thun_, _inzw, 
   {{0xb2250303,0x27ed004f,0x628b0304,0x31bb0218}},	//   омил, _uken_, _prgo, _mêze_, 
   {{0x25a50305,0x753a0306,0x00000000,0x00000000}},	//   _toll_, _fetz, --, --, 
   {{0x63bb00cf,0x81c90307,0x628b0308,0x673b0175}},	//   shun, ргов_, _vrgo, _heuj, 
   {{0xc9520309,0x6b84030a,0x63bb030b,0x673b030c}},	//   ומי_, ydig, phun, _keuj, 
   {{0x628b030d,0xe3b3030e,0x661b030f,0x64430310}},	//   _trgo, _عرض_, _kuuk, msni, 
   {{0x61450311,0x333f026d,0x64430312,0x661b00b0}},	//   _дела, maux_, lsni, _juuk, 
   {{0x6d410313,0x41290314,0x661b0315,0x00000000}},	//   ólap, _токо_, _muuk, --, 
   {{0x8fa60316,0xdb1d014e,0x64430317,0x70520038}},	//   _маке, _omsä, nsni, _قنوا, 
   {{0x6b840318,0x333f026a,0xbebb024a,0x64430319}},	//   udig, naux_, rbër, isni, 
   {{0x49ca031a,0x37cf0033,0xba29031b,0x00000000}},	// [140] алан_, িকার, مسلم_, --, 
   {{0x6b84031c,0x23b8031d,0xf783008a,0x75ff010c}},	//   sdig, _méja_, _leħħ_, hêzb, 
   {{0xdb06024a,0xa2cb031e,0x2d95012d,0x3e64031f}},	//   _kokë, _तेस्, _хрыс, löt_, 
   {{0x6d5c0320,0x753a0321,0xbddb0322,0x661b0323}},	//   lgra, _setz, nsèn, _buuk, 
   {{0x25e60081,0x3e640324,0x2b400325,0x7c2e0326}},	//   टवली_, nöt_, maic_, lpbr, 
   {{0x27380029,0x67220327,0xc7b9010e,0xd639004f}},	//   ẩn_, scoj, _elő_, сяці_, 
   {{0xe73a0328,0x263600ab,0x6d5c0329,0x753a032a}},	//   _веб_, sło_, igra, _vetz, 
   {{0x66e6032b,0x938a032c,0x2b400038,0x6d5c032d}},	//   _доба, рска_, naic_, hgra, 
   {{0x4392032e,0x386d032f,0x00000000,0x00000000}},	//   зақс, _ćeri_, --, --, 
   {{0x6d5c0330,0x23b80107,0x62840028,0x201a011c}},	//   jgra, _déja_, _šios, _épik_, 
   {{0x213e0331,0x6d5c0332,0xc4860333,0xdfd1007a}},	//   rath_, dgra, _флек, فيد_, 
   {{0xa2cb02f8,0x333f026a,0x442e0334,0x75ff010c}},	//   _तेव्, caux_, mpf_, rêze, 
   {{0xdefb0335,0x22940093,0x64580336,0xdcfe0337}},	//   рын_, _хиля, luvi, _dapč, 
   {{0x6d5c0338,0x291800a3,0xe2a9015f,0xdce50339}},	//   ggra, _ngra_, _دامن_, _abhā, 
   {{0x5ba7033a,0xe0d400c7,0x602101dd,0x6458033b}},	//   ораз, _מײַ_, _tēma, nuvi, 
   {{0xdeb3032e,0x6d5c0084,0xdb0f033c,0x2d9e0219}},	//   _жұмы, agra, _alcá, öter_, 
   {{0x2bbc0081,0x201c00b0,0x6458033d,0x673b033e}},	// [150] _ईतरा, _huvi_, huvi, _reuj, 
   {{0x64430310,0x6458033f,0x661b0340,0xdce70083}},	//   ysni, kuvi, _ruuk, zeję, 
   {{0xe7190038,0x333f0107,0xf8b10296,0x673b002c}},	//   ميات_, yaux_, رکس_, _peuj, 
   {{0x8699005e,0x2cac0219,0x6c7a00c7,0x661b0341}},	//   йкес_, ädde_, _פארפ, _puuk, 
   {{0x333f026d,0x7afd00e0,0xa5f90342,0xcb9a00a7}},	//   vaux_, _uzst, беду_, _הסרט, 
   {{0x64430343,0x201c02a0,0xdb040042,0x3d190083}},	//   tsni, _ouvi_, chiñ, _दलों_, 
   {{0x333f026a,0x22460344,0x201c0345,0x64580346}},	//   taux_, _avok_, _nuvi_, guvi, 
   {{0x64430347,0x3a390348,0x661b0349,0x3e640080}},	//   rsni, _kwsp_, _tuuk, yöt_, 
   {{0x76b900cf,0x6443034a,0x6d5c034b,0x333f026a}},	//   _улар_, ssni, ygra, raux_, 
   {{0x644300e4,0x2b40020f,0x23b1020b,0x65780241}},	//   psni, zaic_, _máji_, cevh, 
   {{0x6d5c034c,0x645c007e,0x4fea0240,0x333f0107}},	//   vgra, _ärip, ймон_, paux_, 
   {{0xbebb024a,0x201c0068,0xdee60200,0x3e6400c8}},	//   rcën, _duvi_, зоми, töt_, 
   {{0xcaea034d,0x5ec5004e,0x3fc9009c,0x6d5c034e}},	//   _झुंड_, дияғ, تگوی_, tgra, 
   {{0xda1f0262,0x6d5c034f,0x3e640350,0x00000000}},	//   _बढ़त_, ugra, röt_, --, 
   {{0x9f920351,0xdb06024a,0x22460352,0xeb9a0353}},	//   lší_, _tokë, _zvok_, бив_, 
   {{0x6561012b,0x9f420098,0x3a2b0354,0x3a260355}},	//   _lclh, boká_, _btcp_, змаг, 
   {{0x6e4600eb,0x9f920356,0x6d5c0357,0x2b400358}},	// [160] _عندم, nší_, pgra, raic_, 
   {{0x2b400359,0xa9670258,0x64580027,0x00000000}},	//   saic_, зифа_, yuvi, --, 
   {{0x9d1b00c7,0x9f920032,0x9856035a,0xdc81035b}},	//   _לויט, hší_, яташ, _иқро, 
   {{0xdc9b035c,0xdb060096,0x6b5a00b3,0x2cbe035d}},	//   _היטל, _loké, _ушор_, ıydı_, 
   {{0x9f92035e,0x656d035f,0x7f8d0070,0xbddb011c}},	//   jší_, đahn, ינאַ, ksèl, 
   {{0x64580360,0x8afb00a7,0x9f920356,0x00000000}},	//   tuvi, _להכי, dší_, --, 
   {{0x80d000cc,0x69ce0361,0xdd570070,0x00000000}},	//   _সুন্, _imbe, לבסט_, --, 
   {{0x64580362,0xdb060036,0x7d070363,0xc8db00df}},	//   ruvi, _pokè, léré, _הקלט, 
   {{0x6b860364,0x201c0365,0xd0460248,0x00000000}},	//   _makg, _suvi_, əmək, --, 
   {{0x7d070107,0xdb060096,0x9f4200da,0x00000000}},	//   néré, _coké, voká_, --, 
   {{0x69ce02cd,0x26150366,0xf99300d1,0x00000000}},	//   _mmbe, _फूटी_, גרת_, --, 
   {{0x09b90367,0x6028031e,0x78fb0070,0x57da0035}},	//   _इत्य, _něme, מפיו, _भदोह, 
   {{0x69ce0368,0x9f4b0369,0x23b8033e,0x5f94036a}},	//   _ombe, nocé_, _héjo_, хият, 
   {{0x9f42014b,0x23b80096,0x442c018e,0x7d070175}},	//   roká_, _kéjo_, _ktd_, jéré, 
   {{0x7d07036b,0x9f42026e,0x6b86036c,0x00000000}},	//   déré, soká_, _bakg, --, 
   {{0x69ce036d,0x23cf036e,0x00000000,0x00000000}},	//   _ambe, तोपद, --, --, 
   {{0x31bb0218,0xdcf200e0,0x6b86036f,0x442c00d1}},	// [170] _hêza_, īgāk, _dakg, _ltd_, 
   {{0x6e2d0370,0xceb200c7,0x7d070371,0x64480372}},	//   _itab, _סיי_, géré, _ovdi, 
   {{0xd7fb0013,0x6e2d0175,0xa3be0035,0xf1b30070}},	//   буд_, _htab, ीफा_, עסע_, 
   {{0x69ce0373,0xff5f0218,0x256f008f,0x68f5014b}},	//   _embe, ngî_, zılı_, _vyzd, 
   {{0xd246006b,0x7d070374,0x64480375,0x442c0376}},	//   _جن_, béré, _avdi, _atd_, 
   {{0xcb120056,0x442c0226,0x9f920377,0x68f50228}},	//   _שלך_, _btd_, vší_, _tyzd, 
   {{0x62820378,0x7dc20379,0xa50601a2,0x2409037a}},	//   _asoo, _fôsf, меша_, онки_, 
   {{0x9f92031e,0xdcfe01dd,0xc2e60033,0x6e2d037b}},	//   tší_, _japā, খেছি_, _otab, 
   {{0x2a69037c,0x6e2d037d,0x6448037e,0xd766010e}},	//   ntab_, _ntab, _evdi, _تنقی, 
   {{0x9f92037f,0xab5b0380,0x27ef0381,0x442c0382}},	//   rší_, _flüg, logn_, _ftd_, 
   {{0xd37100eb,0x6e2d0383,0x256f0384,0xe7c402e6}},	//   _لها_, _atab, rılı_, लोकप, 
   {{0x9f920385,0x2a6902f1,0x672901f2,0x256f0241}},	//   pší_, ktab_, _jfej, sılı_, 
   {{0xee370386,0x6b860026,0x6e2d00a1,0x63ab0387}},	//   мня_, _rakg, _ctab, _iogn, 
   {{0x7987006a,0x6e2d0038,0x6b860388,0x00000000}},	//   _najw, _dtab, _sakg, --, 
   {{0x6e2d0389,0x2c8700bc,0x98ba0339,0x7f4d008a}},	//   _etab, vídá_, kapā_, _fdaq, 
   {{0xeb97038a,0x6729008a,0x00000000,0x00000000}},	//   мис_, _nfej, --, --, 
   {{0x63ab038b,0x63a6022b,0xf1e10249,0x6b86038c}},	// [180] _mogn, ökni, _पदान, _vakg, 
   {{0x63ab038d,0x99e300a3,0x00000000,0x00000000}},	//   _logn, вжуд, --, --, 
   {{0x76490212,0xe786038e,0x6b86011c,0x07a60080}},	//   _avey, дуло, _takg, мажн, 
   {{0x442c038f,0x2a69006d,0xb7be0033,0x61aa0390}},	//   _rtd_, btab_, েক্ট, _चक्ष, 
   {{0x4cd30086,0x442c0391,0x4733004f,0x7d070212}},	//   _দুপু, _std_, тніс, péré, 
   {{0x69ce0392,0x442c0348,0x63ab00a1,0x569300d3}},	//   _umbe, _ptd_, _aogn, ташт, 
   {{0x76490118,0x442c02aa,0x644d01dd,0xbb1b009e}},	//   _evey, _qtd_, ņain, _anîy, 
   {{0x63ab0393,0x31bb009e,0x75ff0216,0xae1e0299}},	//   _cogn, _rêza_, rêza, पदान_, 
   {{0xe7bd0394,0x2d9a0126,0x63ab0395,0x9f55003e}},	//   ्फरप, _onpe_, _dogn, ófíl_, 
   {{0x66e4005e,0x442c016a,0x602802d9,0x6e2d008a}},	//   _жоға, _ttd_, _němc, _rtab, 
   {{0x39570056,0x63ab0396,0x195700d1,0x00000000}},	//   ושים_, _fogn, וביל_, --, 
   {{0x628201a0,0xe29a00e4,0x26c6006d,0x63ab0036}},	//   _tsoo, _мае_, ozoo_, _gogn, 
   {{0xdde20397,0x26c60126,0x31c60398,0x00000000}},	//   _šušk, nzoo_, _оскв, --, 
   {{0xe0cf0399,0x63ab039a,0x69de039b,0x00000000}},	//   ازی_, _zogn, jnpe, --, 
   {{0xdb060019,0x79870237,0x00000000,0x00000000}},	//   _elkü, _rajw, --, --, 
   {{0x2a69039c,0x2cac0219,0x7c220097,0x3eae0034}},	//   ttab_, ädda_, _čort, ëjtë_, 
   {{0x6e2d039d,0x27ef01e8,0xef1f0384,0x26c60201}},	// [190] _utab, vogn_, ndüm_, jzoo_, 
   {{0x2a69039e,0x3df40080,0x6729008a,0x00000000}},	//   rtab_, _изыс, _sfej, --, 
   {{0x2a690077,0x917b0023,0x22510083,0x998f039f}},	//   stab_, _hệ_, ązki_, égű_, 
   {{0x2a6903a0,0xb6c503a1,0xaad003a2,0x00000000}},	//   ptab_, нөзд, _सेवक, --, 
   {{0xcb360056,0x798703a3,0x63ab03a4,0x1fc10033}},	//   _ראשי_, _tajw, _rogn, _উদাস, 
   {{0x63ab03a5,0x659403a6,0x0579007a,0x00000000}},	//   _sogn, качу, سمعة_, --, 
   {{0xc86403a7,0x672901f2,0x917b0210,0x00000000}},	//   _итти, _tfej, _lệ_, --, 
   {{0x26c60201,0x7c2a02be,0xd2a90080,0x00000000}},	//   bzoo_, _éfre, зкие_, --, 
   {{0x645c03a8,0x63ab03a9,0xd24e0195,0xe73903aa}},	//   _årin, _vogn, مني_, _мең_, 
   {{0x63ab039b,0x11e20259,0xd1c60080,0x130203ab}},	//   _wogn, лжым, елье_, ызым, 
   {{0x672403ac,0x63ab03ad,0xddcb0241,0xe0d600b3}},	//   žije, _togn, _şişe, евэ_, 
   {{0x8fa603ae,0x00000000,0x00000000,0x00000000}},	//   хаме, --, --, --, 
   {{0xe29903af,0x7f1900f0,0xfce30176,0xf1a800d7}},	//   _хал_, діру_, ҳоро, سایه_, 
   {{0x92c103b0,0xdd9203b1,0x7bdf03b2,0xd24e03b3}},	//   ığın, دوس_, enqu, _انو_, 
   {{0xfce303b4,0xddcd00d9,0x61e6010e,0xeb9a03b5}},	//   горо, _spaţ, ékle, пив_, 
   {{0xa2d40081,0xfaa603b6,0x7a160237,0x00000000}},	//   _बेड्, набо, _pņto, --, 
   {{0xf41200c7,0x395603b7,0xdb0603a0,0xfbd1031e}},	// [1a0] רפן_, ењет, _alkò, _सगरम, 
   {{0xac8603b7,0x6f04016c,0x26c6006d,0xdcfe00b3}},	//   _згол, _izic, vzoo_, _capă, 
   {{0xa81a03b8,0x2fc000b4,0x5be40259,0xc17200d1}},	//   ستار_, _klig_, _айнұ, רחב_, 
   {{0xfaa603b9,0xe66603ba,0x2fc00175,0x00000000}},	//   _замо, етко, _jlig_, --, 
   {{0x7bd6023e,0x98ac0095,0x91b40035,0x75ff0216}},	//   miyu, ğlıq_, ेसमै, rêzn, 
   {{0xe5a303bb,0x7bd603bc,0x98ac0095,0xa4d403bd}},	//   личи, liyu, şlıq_, колі, 
   {{0x26c6006d,0xa3cc03be,0x3c3e02d9,0x00000000}},	//   szoo_, रफल_, nův_, --, 
   {{0x7bd6016c,0x00000000,0x00000000,0x00000000}},	//   niyu, --, --, --, 
   {{0x6aa40183,0x6f04016c,0x00000000,0x00000000}},	//   nxif, _nzic, --, --, 
   {{0x64a603bf,0xb5ca006b,0xef1f03c0,0xbbad03c1}},	//   _паза, _عوام_, rdüm_, _टक्क, 
   {{0x3f8903c2,0xdb12008c,0x6f0403c3,0x2fc00175}},	//   _paau_, _ágæt, _azic, _blig_, 
   {{0x64580304,0x00000000,0x00000000,0x00000000}},	//   mrvi, --, --, --, 
   {{0x661a03c4,0x644a03c5,0x7bc4023e,0x2e2603c6}},	//   _kitk, lsfi, dhiu, _côf_, 
   {{0x9f4b031e,0x661a03c7,0x917b0108,0x00000000}},	//   mocí_, _jitk, _vệ_, --, 
   {{0x317e03c8,0xb3a400e6,0x661a03c9,0x443e039b}},	//   metz_, _खचाख, _mitk, _jwt_, 
   {{0x7bc403ca,0x7bdf00fd,0xd1380009,0x7b6400b3}},	//   ghiu, unqu, lbą_, лтуе, 
   {{0x66d3006b,0x443e02a2,0x9f4b0327,0x6d5a007a}},	// [1b0] _műkö, _lwt_, nocí_, ótac, 
   {{0x661a03cb,0x317e0380,0x64580304,0x644a03cc}},	//   _nitk, netz_, krvi, ksfi, 
   {{0x6d4703cd,0x20090029,0xa3c003ce,0x201b0151}},	//   maja, _khai_, ँसा_, _épis_, 
   {{0x6d4703cf,0x2009006d,0x7bc403d0,0x661a03d1}},	//   laja, _jhai_, chiu, _aitk, 
   {{0x661a03d2,0x6b9d03d3,0x6b8d03d4,0x46a4004f}},	//   _bitk, _insg, mdag, лаїв, 
   {{0x6d4703d5,0xb90700cc,0x6b8d03d6,0x443e03d7}},	//   naja, _পর_, ldag, _bwt_, 
   {{0xab5b02f2,0x80d00086,0x644a03d8,0x443e03d9}},	//   _glüc, _সুস্, gsfi, _cwt_, 
   {{0x69d703da,0x6d4703db,0xe29903dc,0xe65d01f0}},	//   lixe, haja, даи_, ştığ, 
   {{0xd7e401fc,0xdb0f03dd,0x6b8d01ff,0x248503de}},	//   _сіро, _alcú, idag, _wslm_, 
   {{0x6d4703df,0x27fd00f8,0x93bc020f,0x2fc000a1}},	//   jaja, llwn_, _stăt, _slig_, 
   {{0x6d4703e0,0x2fc001c1,0xf99203e1,0x443e03e2}},	//   daja, _plig_, ברי_, _gwt_, 
   {{0x200903e3,0x6b8d03e4,0xc3cb022a,0x661a039b}},	//   _chai_, jdag, _عظام_, _zitk, 
   {{0x63a902b1,0x6b8d0343,0x93b60056,0xddcd03e5}},	//   mjen, ddag, _שלנו_, _spaš, 
   {{0x6d4703e6,0x63bb03e7,0x1d0a0161,0x7bd60199}},	//   gaja, lkun, деги_, wiyu, 
   {{0x69d70183,0xdc6701a2,0x22510035,0x6da303e8}},	//   dixe, кард_, ązku_, шира, 
   {{0x63a903e9,0x2eb603ea,0x6b8d03eb,0x63bb03ec}},	//   njen, _асос, gdag, nkun, 
   {{0x6d4703ed,0x395100ef,0x4b2300dd,0x63bb03ee}},	// [1c0] baja, _bdzs_, рмув, ikun, 
   {{0x6d4703ef,0x63a903f0,0x2bc60035,0x76590156}},	//   caja, hjen, रोजा, drwy, 
   {{0x63bb03f1,0x63a903f2,0x661a03f3,0x6b8d01ff}},	//   kkun, kjen, _ritk, bdag, 
   {{0x7bd602cd,0x6e240053,0x63a903f4,0xe73a03dc}},	//   qiyu, _kuib, jjen, фед_, 
   {{0x63a903f5,0x661a030f,0x443e03f6,0x765902bf}},	//   djen, _pitk, _swt_, grwy, 
   {{0x69c503f7,0xd49a03f8,0x645803f9,0x644a03fa}},	//   chhe, дри_, trvi, tsfi, 
   {{0x18a303fb,0x98a300d3,0x63bb03fc,0x948603fd}},	//   _карм, _кире, fkun, тылд, 
   {{0x63a903fe,0x63bb03ff,0x6d470400,0x64a302a6}},	//   gjen, gkun, zaja, раћа, 
   {{0xfbd30056,0x200902bf,0x661a0401,0x644a0402}},	//   יתה_, _rhai_, _titk, ssfi, 
   {{0xa3f5000d,0x661a0318,0x6b8d0403,0x8af000ad}},	//   ější_, _uitk, zdag, lgəs, 
   {{0x6d470404,0x63a90405,0xd138012d,0x200900e7}},	//   vaja, bjen, rbą_, _phai_, 
   {{0x317e01c4,0x63bb02f2,0x6d470406,0x63a90407}},	//   setz_, ckun, waja, cjen, 
   {{0x6d470408,0x6e240409,0x00000000,0x00000000}},	//   taja, _cuib, --, --, 
   {{0x69d7040a,0x6e24006c,0xbf9b040b,0x00000000}},	//   xixe, _duib, dlêe, --, 
   {{0x7f95040c,0x6d47040d,0x6b8d040e,0x80a3040f}},	//   _байх, raja, tdag, _نمون, 
   {{0x6d470410,0x5f770411,0x20090053,0x8e270148}},	//   saja, _شاعر, _uhai_, _ифод, 
   {{0x6d470412,0xbf9b0218,0x321c0180,0x49750413}},	// [1d0] paja, rlêd, _kivy_, ллас, 
   {{0x63bb0414,0x6b8d0343,0x7e6d0415,0x68fc0416}},	//   zkun, sdag, _iqap, _byrd, 
   {{0x3eb90417,0x69d70418,0xf7950028,0xa2d40154}},	//   lyst_, rixe, лажэ, _बेस्, 
   {{0x765902bf,0x69c50034,0x6b8d01ff,0xe1150070}},	//   trwy, shhe, qdag, אַנז_, 
   {{0x6d450419,0xe784041a,0x63a9041b,0x61e100f8}},	//   _keha, рухо, vjen, ynll, 
   {{0xa934041c,0xa509041d,0x6d45025b,0x63bb02b0}},	//   _верш, нела_, _jeha, wkun, 
   {{0x6d45041e,0x63a9041f,0x7afd0420,0x63bb0421}},	//   _meha, tjen, _hyst, tkun, 
   {{0x6d450364,0x7afd0422,0x7c250423,0x93bc00b3}},	//   _leha, _kyst, _muhr, _stăr, 
   {{0x63a90424,0x59b70425,0x7c250096,0xd3a400f0}},	//   rjen, _आकार, _luhr, рлық, 
   {{0x63bb0426,0x6d450427,0x9f600042,0x63a90428}},	//   skun, _neha, _ásúa_, sjen, 
   {{0x04670429,0x7afd042a,0x1c1f042b,0x63a901f2}},	//   _штам, _lyst, _मंगल_, pjen, 
   {{0xdb0f03b7,0xc43a042c,0x442500d9,0xdb06042d}},	//   _você, _נתני, _iul_, _loká, 
   {{0x4425042e,0x6d45042f,0x7afd0430,0x69d50431}},	//   _hul_, _beha, _nyst, _omze, 
   {{0x44250432,0x614503b7,0x4ed5004f,0x42520433}},	//   _kul_, _сека, рюют, _انور, 
   {{0x224d0434,0x6d450435,0x44250436,0x30790070}},	//   lsek_, _deha, _jul_, _טאַנ, 
   {{0x7afd0098,0x2d8c0437,0x44250077,0x7dd40095}},	//   _byst, žde_, _mul_, _müsə, 
   {{0x7afd0156,0xdcfc026e,0x44250438,0x6d450126}},	// [1e0] _cyst, merč, _lul_, _feha, 
   {{0x6d450439,0x7afd043a,0x4425043b,0x3f82043c}},	//   _geha, _dyst, _oul_, leku_, 
   {{0xdb060076,0x7afd043d,0x31ba00c7,0x9f4b02aa}},	//   _doká, _eyst, עזענ, locá_, 
   {{0x6d4502ba,0x224d01f0,0x3f82043e,0x46ea043f}},	//   _zeha, ksek_, neku_, нден_, 
   {{0x644102cd,0x7f3b00c7,0x7afd0156,0x7c250440}},	//   _awli, גענו, _gyst, _zuhr, 
   {{0x65940441,0x44250442,0xd5b1001b,0x6d4501d6}},	//   раку, _bul_, _có_, _xeha, 
   {{0x44250443,0xd46702a6,0xe56f021b,0x88840444}},	//   _cul_, гије_, سطو_, _خیان, 
   {{0x44250084,0x3f8203e5,0x53980445,0x93b40446}},	//   _dul_, jeku_, твия_, рбиц, 
   {{0x6441007b,0xbebb024a,0x798e0447,0xdb06010e}},	//   _ewli, ncët, _kabw, _elkö, 
   {{0xc05a0448,0x602100e0,0x44250449,0xdb0f022c}},	//   нім_, _lēmu, _ful_, _docè, 
   {{0x4425044a,0x798e044b,0x09f7029e,0x224d01d6}},	//   _gul_, _mabw, רמים_, asek_, 
   {{0x6d45044c,0x020600f0,0x798e044d,0xddc4008a}},	//   _seha, _өзен, _labw, _epiż, 
   {{0x6d45044e,0x4425044f,0x7c25040c,0x601e0450}},	//   _peha, _zul_, _suhr, _dūma, 
   {{0xbb1b026d,0xa1580451,0x44250452,0x7afd0453}},	//   _maît, _раку_, _yul_, _ryst, 
   {{0x9f35005e,0x442503da,0x6d450454,0x3ebf0455}},	//   _кейі, _xul_, _veha, šut_, 
   {{0xc4c40456,0x7afd0088,0x246e0095,0x798e02a5}},	//   _ہے_, _pyst, _cəmi_, _aabw, 
   {{0x6d450457,0x1dc40161,0x79d5004f,0x798e0458}},	// [1f0] _teha, рөөн, ажає, _babw, 
   {{0x7afd0459,0x2b490183,0xdcf501dd,0x75ff0216}},	//   _vyst, saac_, udzē, rêzk, 
   {{0x7afd006a,0x2d83024d,0x798e045a,0xd7c8009c}},	//   _wyst, meje_, _dabw, گونه_, 
   {{0x31e1045b,0x2d83045c,0x7afd045d,0xe71900eb}},	//   _पद्ध, leje_, _tyst, نيات_, 
   {{0x4425045e,0xb6a5045f,0xa2d4000c,0x98aa01dd}},	//   _sul_, рилл, _बेल्, ējām_, 
   {{0x44250460,0x2d830461,0xf4830274,0xa3d2031e}},	//   _pul_, neje_, ماعی, होस_, 
   {{0x44250462,0xb7770259,0x00000000,0x00000000}},	//   _qul_, _бөлу_, --, --, 
   {{0x44250265,0xddc40463,0xdb1d008c,0x2d830464}},	//   _vul_, _spiż, _umsó, heje_, 
   {{0x6b8f0465,0xae150466,0x64a30467,0x290c00eb}},	//   _macg, णगान_, рақа, _údar_, 
   {{0x2d830468,0x44250469,0x224d046a,0x2d9100ef}},	//   jeje_, _tul_, rsek_, jdze_, 
   {{0x2d83046b,0x66ca0019,0x3fe6046c,0xd49b046d}},	//   deje_, _töké, ижов, _яра_, 
   {{0x224d046e,0xe0d6046f,0x52d90080,0xbddb023e}},	//   psek_, рвю_, _имею_, ksès, 
   {{0x2bc900bd,0x8e760470,0x324500b9,0x00000000}},	//   रसना, шунч, _телг, --, 
   {{0x3f820471,0x6cc60472,0x628b0090,0x2d8302b8}},	//   seku_, айга, _isgo, geje_, 
   {{0xdd0e027e,0x8c460473,0x93bc0474,0x798e0118}},	//   _dışa, ребе, _ouăl, _rabw, 
   {{0xc05200a7,0x798e0475,0xb7b00033,0x00000000}},	//   _וזה_, _sabw, _কষ্ট, --, 
   {{0xeab70161,0x2d830476,0x09c10033,0x798e044d}},	// [200] айт_, beje_, োচনা, _pabw, 
   {{0xdebb0225,0xc8960477,0x00000000,0x00000000}},	//   _סמיל, ирењ, --, --, 
   {{0xdca600cf,0x6e2201d8,0xdb060054,0x87260478}},	//   _тани, _èobb, _alkô, амеж, 
   {{0x6e930116,0x628b0479,0x798e047a,0x00000000}},	//   _الیا, _osgo, _wabw, --, 
   {{0xb8fd047b,0x23a9047c,0x6b84047d,0x672402fe}},	//   _ते_, कानद, meig, žijo, 
   {{0xb8660019,0x6b84047e,0x00000000,0x00000000}},	//   _پاسو, leig, --, --, 
   {{0x92e200cc,0x29270228,0x03c6047f,0x00000000}},	//   _ধরে_, ávať_, исим, --, 
   {{0x0fc10086,0x6b840480,0x290a0481,0x68e30068}},	//   _উদ্ধ, neig, _izba_, únde, 
   {{0x27e60008,0xc1a600ff,0xa3c7042b,0xe61a0482}},	//   mnon_, ајни, _उतर_, _ада_, 
   {{0x22590483,0xda160484,0x629900f3,0x00000000}},	//   áska_, थगित_, _drwo, --, 
   {{0x628b0485,0xd4d500e4,0x5f9500b3,0xc9530486}},	//   _esgo, _ліцэ, бинт, חמת_, 
   {{0x27e60487,0x53a30258,0xa3d2042b,0x03a30488}},	//   nnon_, _махб, होश_, _михо, 
   {{0x63a20489,0x5f94048a,0x2d83048b,0x9258048c}},	//   _inon, цият, teje_, _салт_, 
   {{0x7bc6048d,0xa3d2048e,0x2002048f,0x63a20032}},	//   _alku, होर_, alki_, _hnon, 
   {{0x2d830490,0xf2e80086,0x70540491,0x63a20118}},	//   reje_, _পরিণ, _انبا, _knon, 
   {{0x628b02f0,0xe45700c7,0x75ff010c,0x2d830492}},	//   _ysgo, יילט_, rêzi, seje_, 
   {{0x29050493,0xac180494,0x27e60495,0x290a0118}},	// [210] _šla_, роту_, dnon_, _azba_, 
   {{0x39470496,0x780f0497,0x2d830034,0x00000000}},	//   úns_, िष्क_, qeje_, --, 
   {{0x63a20498,0x6b8401dd,0xbef80499,0x6d5700ad}},	//   _onon, beig, _مریض_, _idxa, 
   {{0x27e6049a,0x201400d3,0xdc9a0070,0x7d0800c2}},	//   gnon_, _èxit_, _עירל, üdse, 
   {{0xc987049b,0x6e2202be,0x1ade049c,0x00000000}},	//   _куви, _éobt, _नेपथ, --, 
   {{0x63a2049d,0x27e6049e,0x5f0a049f,0xdcfe00bc}},	//   _anon, anon_, _सरस्_, _napě, 
   {{0x97a704a0,0x057400d4,0x27e6012b,0x29050369}},	//   _крал, تاند, bnon_, _ála_, 
   {{0x69c704a1,0xc245004f,0xdcfc01dd,0xab5b00b0}},	//   _hlje, бник, nerā, _olüm, 
   {{0xe1f904a2,0x248c04a3,0xe7300019,0xdd2c012d}},	//   лги_, _esdm_, _آصف_, vėži, 
   {{0xa2e504a4,0x6b8402ec,0x79850026,0xbec40028}},	//   _қолд, zeig, nehw, šūki, 
   {{0x69c7027c,0x7dc20228,0xf0760019,0x6e3601d2}},	//   _mlje, _dôsl, میوں_, _styb, 
   {{0x7dc20187,0x6d570068,0x9f420098,0x629904a5}},	//   _pôso, _adxa, boký_, _trwo, 
   {{0x69c704a6,0x6fc60038,0xdcfc01dd,0x6299016c}},	//   _olje, _cóca, derā, _urwo, 
   {{0x6b8404a7,0xb6da0070,0x6feb0083,0x225f04a8}},	//   weig, אַלט, ręca, mruk_, 
   {{0x6b560013,0x6b8404a9,0xdb1d00b9,0xacea00b3}},	//   йтах, teig, _alsà, умва_, 
   {{0x69c704aa,0xdcfe0032,0x6fc6007a,0x00000000}},	//   _alje, _topľ, _fóca, --, 
   {{0x69c704ab,0xfaa304ac,0x6b8404ad,0x7f3b0070}},	// [220] _blje, пато, reig, _געפו, 
   {{0x6b8404ae,0x5d8600eb,0x3f92005f,0xdb0f04af}},	//   seig, _الدل, _hayu_, _alcó, 
   {{0x3f9204b0,0x6d4e04b1,0x291c04b2,0x6fc604b3}},	//   _kayu_, maba, äva_, _zóca, 
   {{0x6d4e04b4,0x7bc604b5,0x78a302ae,0xd62a04b6}},	//   laba, _ulku, ånva, годе_, 
   {{0xa3ab04b7,0x2b4004b8,0x3f9202a5,0x248c0065}},	//   खान_, mbic_, _mayu_, _ssdm_, 
   {{0x6d4e04b9,0x225f04ba,0x3f9204bb,0xe1e704bc}},	//   naba, druk_, _layu_, _رس_, 
   {{0x2bbf04bd,0xef1f04be,0x6d4e0183,0x69de04bf}},	//   _एकमा, ndür_, iaba, mipe, 
   {{0x69de04c0,0x6d4e04c1,0xa85700a7,0x69c700ef}},	//   lipe, haba, _לילה_, _zlje, 
   {{0x6d4e04c2,0x7dcb0092,0xaade009a,0x36c603a1}},	//   kaba, _hüse, _नेमक, _убаг, 
   {{0x8c000086,0x69de04c3,0x9f42014b,0x905404c4}},	//   ্দিন_, nipe, roký_, овоц, 
   {{0x64a304c5,0x672d00d0,0x3f9204c6,0x9f42014b}},	//   _нафа, žaje, _bayu_, soký_, 
   {{0x69de04c7,0x225f04c8,0x63a204c9,0x00000000}},	//   hipe, bruk_, _unon, --, 
   {{0x69de04ca,0x3f9202a2,0x394a04cb,0x2bbf04cc}},	//   kipe, _dayu_, _oebs_, _एकबा, 
   {{0x6d4e04cd,0x30a604ce,0x3fc900d4,0x7de700f0}},	//   gaba, _грив, ادگی_, сімд, 
   {{0x69de04cf,0x61fa00cf,0xc05a0451,0x2a6000b0}},	//   dipe, motl, _сіл_, erib_, 
   {{0x69c702a8,0x61fa00cf,0xa3ab00c2,0x2246023e}},	//   _slje, lotl, खाय_, _kwok_, 
   {{0x6d4e04d0,0x69c704d1,0x2a6004d2,0x8d8700b3}},	// [230] baba, _plje, grib_, _лунд, 
   {{0x6f0d04d3,0x7f4f02a3,0x24890035,0x69de04d4}},	//   _izac, lacq, łami_, gipe, 
   {{0x2fc904d5,0x66030098,0x6d4104d6,0x3f9200d7}},	//   _klag_, vlnk, ılad, _yayu_, 
   {{0x1da704d7,0x61fa04d8,0x7f4f0036,0x6e22019c}},	//   खावत, hotl, nacq, _éobr, 
   {{0x7bdf04d9,0x7bcd04da,0x61fa04db,0x966500f0}},	//   miqu, mhau, kotl, ікке, 
   {{0x7bdf04dc,0x6f0d019b,0x69de04dd,0x7bcd04de}},	//   liqu, _mzac, cipe, lhau, 
   {{0xddcc00e4,0x224600e2,0x996502d9,0x61fa04df}},	//   _žiūr, _awok_, _kůži_, dotl, 
   {{0x7bdf04e0,0x6d4e04e1,0x2d930496,0x7bcd04e2}},	//   niqu, zaba, _laxe_, nhau, 
   {{0x66030187,0x6d4e04e3,0x3f9204e4,0x27ff0405}},	//   plnk, yaba, _rayu_, _ikun_, 
   {{0x3f9204e5,0x2fc9012b,0x7bdf0107,0x6d4e04e6}},	//   _sayu_, _alag_, hiqu, xaba, 
   {{0x3f9204e7,0x2fc904e8,0x7bdf023e,0xe10904e9}},	//   _payu_, _blag_, kiqu, ренд_, 
   {{0x6d4e04ea,0x27ff0405,0x69de04eb,0x7e66016a}},	//   waba, _jkun_, zipe, tukp, 
   {{0x6d4e04ec,0x7bdf04ed,0x7bcd04ee,0xf8a600a2}},	//   taba, diqu, dhau, _गप्प, 
   {{0xdb0f0068,0x2b4b04ef,0x3f92011c,0x112b017b}},	//   _cocí, _aecc_, _wayu_, _сюди_, 
   {{0x6d4e04f0,0x7bdf04f1,0x7f4f01d8,0xcfaa04f2}},	//   raba, fiqu, bacq, _ناظم_, 
   {{0x7bdf04f3,0x7e66011d,0x6d4104f4,0x2fc901be}},	//   giqu, pukp, ðlar, _glag_, 
   {{0xe9da04f5,0x6d4e04f6,0xed5a04f7,0x4aaa0161}},	// [240] ака_, paba, _коп_, шкан_, 
   {{0x27ff04f8,0x6d4e04f9,0xdcf50384,0x27ed033e}},	//   _akun_, qaba, _çağr, _ajen_, 
   {{0x7bcd04fa,0xe8f704fb,0x320504fc,0x7bdf0173}},	//   bhau, олф_, illy_, biqu, 
   {{0xeb9a04fd,0x7bdf04fe,0x394a04ff,0x7bcd0500}},	//   _тим_, ciqu, _webs_, chau, 
   {{0x2a6002cd,0x61fa02f1,0xacf6009c,0x2bbf0501}},	//   qrib_, yotl, _دسکت, _एकता, 
   {{0x69de01ee,0x27ed0348,0xfe9b008d,0x75d30038}},	//   qipe, _ejen_, יינמ, وينا, 
   {{0x69dc00eb,0x6fc60183,0xab5b0502,0x602802d9}},	//   _imre, _nóco, _blüh, _těmi, 
   {{0x78a10503,0xa3ba00eb,0x27ed024a,0x7bc40504}},	//   _álva, شاعر_, _gjen_, nkiu, 
   {{0x69dc02a2,0x6f040505,0xa3db00a5,0x61fa0506}},	//   _kmre, _nyic, _डगर_, totl, 
   {{0x2fc90507,0x7a450216,0x61e801c4,0x7bdf0508}},	//   _slag_, lîtî, undl, ziqu, 
   {{0xeb070509,0x2fc9050a,0xf1d9050b,0xdb0f050c}},	//   _शर्त_, _plag_, योधन, _rocí, 
   {{0x932500c5,0x4ea7050d,0x320500a7,0x7bdf050e}},	//   _فرهن, орга, ally_, xiqu, 
   {{0x442c050f,0x69dc0510,0x6b960156,0x2fc90511}},	//   _hud_, _omre, ddyg, _vlag_, 
   {{0x442c0062,0x72e900c7,0x61fa00a3,0x6e3d0512}},	//   _kud_, _פֿײַ, qotl, rpsb, 
   {{0x7bdf0513,0x442c00b3,0x7bcd0514,0x3a2302b0}},	//   tiqu, _jud_, thau, _rijp_, 
   {{0x5a350515,0x3a3902c7,0x69dc0516,0x7bcd0517}},	//   знат, _ptsp_, _amre, uhau, 
   {{0x7bdf0518,0x442c0519,0x7bcd051a,0x2d93051b}},	// [250] riqu, _lud_, rhau, _taxe_, 
   {{0x7bdf051c,0x7bcd051d,0x442c051e,0x683300a4}},	//   siqu, shau, _oud_, _aħda, 
   {{0x6e2d0201,0x20ca051f,0x7bdf0520,0x48ab0521}},	//   _huab, ानिध, piqu, штам_, 
   {{0x6e2d0522,0x6282011c,0x69dc0241,0xbddb023e}},	//   _kuab, _opoo, _emre, spèd, 
   {{0xf7700523,0x27ed00e5,0xd6db0524,0xe5a502f1}},	//   ضان_, _vjen_, јте_, зили, 
   {{0x442c0525,0x6e2d0526,0x644800f3,0x20ca0527}},	//   _bud_, _muab, _bwdi, ानाध, 
   {{0xd8380528,0x27ff0529,0xddcd052a,0x6282052b}},	//   _мэт_, _tkun_, _opaž, _apoo, 
   {{0x442c052c,0x69c503c5,0xc245052d,0x7995052e}},	//   _dud_, lkhe, пник, _hazw, 
   {{0x7995016c,0x6448008a,0x442c052f,0x6729016c}},	//   _kazw, _ewdi, _eud_, _igej, 
   {{0x442c00eb,0x69c50530,0x34950531,0x76490532}},	//   _fud_, nkhe, _назр, _iwey, 
   {{0x442c0533,0x7995045a,0x2a6901a0,0x6e2d00a1}},	//   _gud_, _mazw, huab_, _auab, 
   {{0x764901a3,0xbf9b0106,0x60330474,0x6e2d0534}},	//   _kwey, blêm, _căma, _buab, 
   {{0x6e2d00b9,0x69c5010e,0x6729018e,0xd1bb0535}},	//   _cuab, kkhe, _mgej, _پاشا_, 
   {{0x69c50536,0x7995006a,0x6e2d0537,0xa2d400b0}},	//   jkhe, _nazw, _duab, _बेट्, 
   {{0x61e10538,0x76490539,0x00000000,0x00000000}},	//   mill, _lwey, --, --, 
   {{0x61e1053a,0x6729053b,0x69dc053c,0x6724053d}},	//   lill, _ngej, _smre, žiji, 
   {{0x61e1053e,0x37e10086,0x629b00c8,0x3c19012d}},	// [260] oill, যকার, nvuo, іўся_, 
   {{0x3ea0053f,0x6d410540,0xa96a0038,0x61e10541}},	//   _irit_, ılac, إمام_, nill, 
   {{0x7649025b,0x79950502,0x61e10542,0x77860543}},	//   _awey, _dazw, iill, злез, 
   {{0x442c0544,0x2d980545,0x2d8a0546,0x76490547}},	//   _rud_, ldre_, lebe_, _bwey, 
   {{0xc61500cc,0x2a69023b,0x3f800548,0x6594013e}},	//   াদনা_, cuab_, _mbiu_, далу, 
   {{0x2d980549,0x61e1054a,0x2d8a0216,0x95f60083}},	//   ndre_, jill, nebe_, इवेट_, 
   {{0xf746054b,0x6282054c,0xb4c6000d,0x764902a5}},	//   _нево, _spoo, उने_, _ewey, 
   {{0x7dcb054d,0x9f59026a,0x2d8a054e,0x61e10080}},	//   _müsa, posé_, hebe_, eill, 
   {{0x63b9054f,0x61e10550,0x603300d9,0x2bbf0551}},	//   _down, fill, _răma, _एकसा, 
   {{0x442c0552,0x7f4d0065,0x7c260553,0x2d8a0372}},	//   _tud_, _seaq, _likr, jebe_, 
   {{0x442c0554,0xdcf500e0,0x2d8a0555,0x3ea00556}},	//   _uud_, rdzī, debe_, _arit_, 
   {{0x61e10557,0x7f4d0415,0x9f420216,0x7c260558}},	//   aill, _qeaq, likê_, _nikr, 
   {{0xdefb0335,0x71a60559,0x7649055a,0x1ee70274}},	//   сын_, _надз, _xwey, سوسی_, 
   {{0x61e1055b,0x217603dc,0x4426055c,0x57b9055d}},	//   cill, _худр, _hio_, _आव्ह, 
   {{0x3ea00118,0x48dc00a2,0x7c26055e,0x717b00d1}},	//   _erit_, _गेलो_, _bikr, _הנוס, 
   {{0xcf2700eb,0x3ea0055f,0x2d980560,0x6e2d0561}},	//   _عربي, _frit_, adre_, _tuab, 
   {{0x44260562,0x7c260563,0x61eb0019,0x2d8a0564}},	// [270] _mio_, _dikr, _állí, bebe_, 
   {{0x2d8a02a0,0x44260565,0xeb9f0566,0xdb0f00b9}},	//   cebe_, _lio_, _skød_, _vocà, 
   {{0x7c260567,0x69c50568,0x2a69006f,0xc1780009}},	//   _fikr, rkhe, suab_, lnės_, 
   {{0x61e10569,0x4426056a,0xb8d502e6,0xf6f5009c}},	//   zill, _nio_, _जप_, وزشگ, 
   {{0xcb9a00a7,0x63b9056b,0x61e1056c,0x920c00a5}},	//   _וסרט, _rown, yill, हताज_, 
   {{0xd1260084,0x06f400d4,0xb6a200a3,0x00000000}},	//   _لم_, رسنج, тишл, --, 
   {{0x442603ef,0xdb060300,0x6fc6007a,0x63b901d2}},	//   _bio_, _ankè, _sócm, _pown, 
   {{0x4426056d,0x3f8b056e,0x2911056f,0x2d8a0532}},	//   _cio_, jecu_, _izza_, zebe_, 
   {{0x44260570,0x3f8b0571,0x2d8a0572,0x2489020b}},	//   _dio_, decu_, yebe_, ňam_, 
   {{0x61e1026a,0x63b902a2,0x555500d4,0x3ea00034}},	//   uill, _wown, _آپار, _rrit_, 
   {{0x61e10573,0x7dd00088,0x442602a0,0x9fa00574}},	//   rill, _jäse, _fio_, _héés_, 
   {{0x61e10575,0x44260576,0xdee60577,0x3ea00578}},	//   sill, _gio_, доми, _prit_, 
   {{0x7dd0014e,0x6fc60068,0x2d8a0579,0x7c26057a}},	//   _läse, _hóck, tebe_, _rikr, 
   {{0x7c26057b,0x61e102f1,0x4426057c,0x3e7602c9}},	//   _sikr, qill, _zio_, ræt_, 
   {{0x2d98057d,0x3e76055f,0x3b9603b7,0x2d8a057e}},	//   rdre_, sæt_, мјат, rebe_, 
   {{0x6ff6057f,0x3ea00580,0xea01001b,0x2d8a0581}},	//   _تستط, _trit_, _đạp_, sebe_, 
   {{0x2bbf0582,0x3b070141,0x7c260583,0x29110584}},	// [280] _एकरा, дето_, _vikr, _azza_, 
   {{0xc9860038,0x7dcb0585,0x7c2604c6,0x602802d9}},	//   بشري, _hüsn, _wikr, _těmt, 
   {{0x8cb50586,0x7c2600e4,0xdb0f0587,0x19b9004f}},	//   _उपयो, _tikr, _vocá, чуть_, 
   {{0x672d0588,0xb0b60070,0xf0b60147,0x00000000}},	//   žajn, ופעס_, ולער_, --, 
   {{0x442600ce,0xdb0f001d,0x12e80033,0x29110589}},	//   _rio_, _tocá, _পর্দ, _ezza_, 
   {{0x44260010,0x3f8b015e,0xe5a3058a,0x645e019c}},	//   _sio_, zecu_, кичи, ápio, 
   {{0xd497058b,0x9f42010c,0x52b8058c,0x69ce058d}},	//   дры_, rikê_, ेन्स, _ilbe, 
   {{0xf2c6058e,0xc1780028,0x29180083,0x7c2a02be}},	//   дсон, ynės_, ągać_, _éfru, 
   {{0x8cb5058f,0x44260590,0xd16600fd,0x3f8b00ca}},	//   _उपभो, _vio_, мъни, vecu_, 
   {{0xe29f008c,0x00000000,0x00000000,0x00000000}},	//   æða_, --, --, --, 
   {{0x44260591,0x3f8b00ef,0xd36f0592,0xf99300d1}},	//   _tio_, tecu_, _ич_, דרת_, 
   {{0x443e006b,0x72c60593,0xdb0d003e,0x44260594}},	//   _itt_, _обез, kkað, _uio_, 
   {{0x441b0137,0xa3ab0262,0xff040595,0x3f8b015e}},	//   _וואס, खार_, вярн, recu_, 
   {{0x443e016a,0x9f5900b9,0x6fc60534,0x00000000}},	//   _ktt_, mosí_, _lóch, --, 
   {{0xc1780009,0xc04f004e,0x443e025b,0xac190596}},	//   snės_, _ші_, _jtt_, зову_, 
   {{0x69ce0597,0xcbcd0086,0x7dd003c5,0x5f9500fd}},	//   _albe, রচ্ছ, _räse, _чиит, 
   {{0x6feb006a,0xbbbf0598,0x9f42024a,0xda780599}},	// [290] jęci, _एकीक, zikë_, дях_, 
   {{0x443e059a,0x6458059b,0x62770486,0x00000000}},	//   _ott_, ksvi, וגמא_, --, 
   {{0x443e059c,0x6d47059d,0xab5b0380,0xa3c0059e}},	//   _ntt_, mbja, _blüt, ुसा_, 
   {{0x6d5501a7,0x69ce059f,0x645805a0,0x7dd00219}},	//   laza, _elbe, dsvi, _väse, 
   {{0x443e05a1,0xb90604b7,0x6fc600eb,0x6b8d05a2}},	//   _att_, _बे_, _dóch, meag, 
   {{0x6d5505a3,0x9f4200e5,0x443e05a4,0xdcee0009}},	//   naza, tikë_, _btt_, gebė, 
   {{0x26c902f5,0x645805a5,0x443e02be,0x83db0083}},	//   šao_, gsvi, _ctt_, यफलआ, 
   {{0x6d5505a6,0x443e0036,0x9f420034,0xa3d90083}},	//   haza, _dtt_, rikë_, डों_, 
   {{0x443e05a7,0x601605a8,0xd175001c,0x644e003d}},	//   _ett_, náme, ныны, _ħbie, 
   {{0xf1b100eb,0x765b007c,0x6b8d05a9,0xf5030176}},	//   اءة_, _ivuy, heag, _иҷло, 
   {{0x6d5505aa,0x9f4205ab,0x672400bc,0x14740038}},	//   daza, liké_, žijt, _لانج, 
   {{0x649a0056,0x644305ac,0x14d8009a,0x7605009e}},	//   _מסעד, mpni, _भेटण, _fîzî, 
   {{0xe1ee0141,0x6d5505ad,0x6d410540,0x3f9e02d9}},	//   _бг_, faza, ılan, ětu_, 
   {{0x7bcf048a,0x200b05ae,0x6833008a,0xdb15010c}},	//   _alcu, alci_, _aħdm, şbûn, 
   {{0xafe605af,0xb042001b,0xdb8605b0,0x1e8300f0}},	//   _покл, _trưở, нгви, _ұлым, 
   {{0x6b8d05b1,0x8b2605b2,0x00000000,0x00000000}},	//   geag, едбе, --, --, 
   {{0x6d5505b3,0xada605b4,0x200205b5,0x7dd002ae}},	// [2a0] baza, _запл, moki_, _väsb, 
   {{0xdb0d010d,0x200205b6,0x7bcf0126,0x673b02a5}},	//   rkað, loki_, _elcu, _afuj, 
   {{0x7dcb05b7,0x6b8d05b8,0x765b02b8,0xdb0d01d5}},	//   _müsl, beag, _avuy, skað, 
   {{0x2d9a0364,0x48c30086,0x601605b9,0x2ca5055f}},	//   _hape_, ্পূর, lámb, ælde_, 
   {{0x2d9a05ba,0x443e05bb,0x56940028,0x69d10243}},	//   _kape_, _stt_, талт, _ūdeņ, 
   {{0x63ab05bc,0x645805bd,0xab5b01c4,0x2002059e}},	//   _angn, tsvi, _flüs, hoki_, 
   {{0x6573009e,0x200201f1,0x2d9a05be,0xa3ab00c2}},	//   _şehî, koki_, _mape_, खां_, 
   {{0x64580343,0x9f5904b3,0x6d5505bf,0x2d9a05c0}},	//   rsvi, tosí_, zaza, _lape_, 
   {{0x6d5505c1,0x645805c2,0x200205c3,0x46b70035}},	//   yaza, ssvi, doki_, _आपयह, 
   {{0x27e605c4,0x2d9a05c5,0x6b8d01f1,0x31c5009e}},	//   lion_, _nape_, zeag, _rêzê_, 
   {{0xc05705c6,0x443e00e0,0x6d5505c7,0x30a300fd}},	//   нія_, _utt_, vaza, гряв, 
   {{0x27e605c8,0x6d5505c9,0x200205ca,0x6306007a}},	//   nion_, waza, goki_, _كوال, 
   {{0x6d5505cb,0x2d9a05cc,0xf8ad0425,0x26c605cd}},	//   taza, _bape_, _टप्प, nyoo_, 
   {{0x7d0305ce,0xbbc905cf,0x2bc905d0,0xa19300d3}},	//   _ønsk, रस्क, रस्थ, _башч, 
   {{0x6d5505d1,0x26ec05d2,0x5ff50141,0x27e605d3}},	//   raza, जपुर_, _изку, kion_, 
   {{0x9f42009e,0x6d5a05d4,0x27e605d5,0x60160183}},	//   likî_, ótar, jion_, táme, 
   {{0x27e605d6,0x6b8d05d7,0x6d5505d8,0x497505d9}},	// [2b0] dion_, reag, paza, клас, 
   {{0x601605da,0x6b8d05db,0x49740283,0x644300fc}},	//   ráme, seag, ллус, ypni, 
   {{0x6fc60165,0x27e60156,0x7e7d05dc,0x7dd00380}},	//   _sóci, fion_, ltsp, _wäsc, 
   {{0x27e605dd,0x765900f8,0xb8d900c2,0x67d405de}},	//   gion_, tswy, _अऊ_, лоху, 
   {{0xa3b403a2,0x7e7d05df,0x2b4900b3,0x9f4b0369}},	//   ञान_, ntsp, mbac_, locó_, 
   {{0xd5bb05e0,0xa50905e1,0x7e7d05e2,0x2a6901ff}},	//   ясе_, мела_, itsp, mrab_, 
   {{0x27e60156,0x02c900d8,0x94ab00a3,0x764002a5}},	//   bion_, िन्न, ятда_, _etmy, 
   {{0x27e605e3,0x25ac0068,0x644305e4,0x261605e5}},	//   cion_, _endl_, rpni, _पीठी_, 
   {{0x7dd0022b,0x2a69006d,0x67d405e6,0x7e6f00ca}},	//   _läsa, nrab_, _соту, jucp, 
   {{0x644305e7,0x9f65009e,0x7e7d05e8,0x00000000}},	//   ppni, îtîk_, dtsp, --, 
   {{0x660301e0,0x200205e9,0x7dd00219,0x2a6905ea}},	//   monk, toki_, _näsa, hrab_, 
   {{0xb4bf0081,0x2d9a05eb,0x7e7d05ec,0x23e9009c}},	//   ुनी_, _sape_, ftsp, _غذای_, 
   {{0x200205ed,0x3f9b008a,0x7e7d05ee,0x9f420216}},	//   roki_, _daqu_, gtsp, bikî_, 
   {{0x008505ef,0x660305f0,0x27e605f1,0xd65600d1}},	//   _алко, nonk, zion_, כישת_, 
   {{0x7e7d05f2,0x1d0705f3,0x200205f4,0x8d760535}},	//   atsp, вери_, poki_, _یادا, 
   {{0x27e6026d,0x660305f5,0x225900da,0x2d9a025b}},	//   xion_, honk, šsku_, _wape_, 
   {{0x3ae800c5,0xf1b505f6,0x501b00a7,0x7e7d05f7}},	// [2c0] ربری_, _अचान, _קופו, ctsp, 
   {{0x26160366,0xdcfc00e0,0xd94605f8,0x9f89009e}},	//   _पीढी_, ndrī, тежи, _pûç_, 
   {{0x27e605f9,0x8e3a05fa,0xdb060035,0xdcfc01dd}},	//   tion_, _عسکر_, _pokó, idrī, 
   {{0x46ea01bb,0x81ca0033,0x7e6905fb,0x5b1603a1}},	//   мден_, রোপ_, šepe, _үмүт, 
   {{0x27e605fc,0xa3ab05fd,0x644105fe,0xb4aa05ff}},	//   rion_, खाई_, _atli, खम्_, 
   {{0x27e60600,0xd9430601,0xe4e3031e,0xdb060035}},	//   sion_, _вери, _केहि_, _wokó, 
   {{0x09e30602,0x27e60603,0x64410604,0x9f59010e}},	//   _торн, pion_, _ctli, őzés_, 
   {{0x7bd60605,0x799c0606,0xdb1d011c,0xc2740165}},	//   nhyu, _harw, _bosè, глиј, 
   {{0x64410607,0x66030608,0x877b00c7,0x31340609}},	//   _etli, bonk, _קאמי, лепр, 
   {{0xf1a6060a,0x2fc001be,0xdb1d011c,0x799c060b}},	//   трин, _aoig_, _dosè, _jarw, 
   {{0x7bd6060c,0x799c060d,0x2fc003dd,0x9f420216}},	//   khyu, _marw, _boig_, rikî_, 
   {{0x7e7d060e,0x9f4b060f,0x6d41008f,0x2fc001fd}},	//   ttsp, vocó_, ılam, _coig_, 
   {{0xdbdc003e,0x00000000,0x00000000,0x00000000}},	//   _ráðn, --, --, --, 
   {{0xdd11026e,0x2d85014b,0x799c0610,0x644102ae}},	//   _výži, ýle_, _narw, _ytli, 
   {{0x61e803a9,0x2fd20611,0xf41400c7,0x7e7d02eb}},	//   midl, _flyg_, ָפּ_, stsp, 
   {{0xef670141,0x3ec700e4,0xdb1d01e5,0x2fc003dd}},	//   _ръко, _асоб, _hosé, _goig_, 
   {{0x799c0612,0x2009011c,0x2b490613,0x5b150614}},	// [2d0] _barw, _ikai_, rbac_, умат, 
   {{0x799c0615,0x6f0d016c,0xdb1d0616,0xc27b0486}},	//   _carw, _iyac, _josé, ורמי, 
   {{0x2d910199,0x48c30086,0xd2460116,0x7bd6011c}},	//   meze_, ্প্র, _گن_, bhyu, 
   {{0x2d910617,0x66030618,0x61e80619,0x2d8302b0}},	//   leze_, wonk, hidl, lfje_, 
   {{0xd246006b,0x799c00f8,0x644100a3,0x6603061a}},	//   _دن_, _farw, _stli, tonk, 
   {{0x799c061b,0x2d91061c,0x09ad0033,0xca7a0070}},	//   _garw, neze_, _গতকা, _אנשט, 
   {{0x6603061d,0x6b9d012b,0x61e8061e,0xb4bf061f}},	//   ronk, _kasg, didl, ुने_, 
   {{0x7bcd0620,0x66030621,0x799c007c,0x2d910622}},	//   nkau, sonk, _zarw, heze_, 
   {{0x56940623,0x6603008b,0x2d910624,0x2fc003a1}},	//   _катт, ponk, keze_, _roig_, 
   {{0xe5730625,0x61e80626,0x2d910627,0x2d8302b0}},	//   _خطر_, gidl, jeze_, jfje_, 
   {{0x7bcd030f,0x80ad047c,0x6f0d0628,0x43750629}},	//   kkau, टमें, _ayac, _مهار, 
   {{0x5275062a,0xeb9f055f,0x7bcd006d,0x6f0d02b8}},	//   _буку, _skøn_, jkau, _byac, 
   {{0x6f0d0199,0xee3700fd,0x61e8062b,0x6033020f}},	//   _cyac, лня_, bidl, _mămi, 
   {{0x63bb062c,0x2d91024d,0xfce6062d,0xdb1d00b9}},	//   ljun, geze_, гого, _gosé, 
   {{0x6b9d062e,0x8fa6062f,0x6f0d0327,0x3205010e}},	//   _basg, _байе, _eyac, moly_, 
   {{0x63bb0630,0xeb970631,0x7bcd0632,0x799c0633}},	//   njun, лис_, gkau, _sarw, 
   {{0xc3320309,0x799c04c6,0x60160634,0x2d910539}},	// [2e0] מון_, _parw, cáma, beze_, 
   {{0x7bd6024d,0x4d4a0635,0xfd4a004f,0x6b9d0387}},	//   shyu, _япон_, _язок_, _easg, 
   {{0x63bb003e,0x6b9d0636,0x07a60637,0x7d7b0225}},	//   kjun, _fasg, лажн, _אריג, 
   {{0x61e8026e,0x799c0638,0x32050639,0x6b9d00f8}},	//   zidl, _warw, holy_, _gasg, 
   {{0x320500a9,0x799c01d2,0x63bb063a,0x00000000}},	//   koly_, _tarw, djun, --, 
   {{0xd49a022c,0x7dd00032,0x00000000,0x00000000}},	//   ери_, _mäso, --, --, 
   {{0x61e8063b,0x395a0626,0xd56500f0,0x487900b3}},	//   vidl, maps_, ртіп, _истя_, 
   {{0x2d91063c,0x6f090035,0x63bb063d,0x83340176}},	//   zeze_, żeci, gjun, шних, 
   {{0xd13000eb,0x46a3063e,0xdb1d04ed,0x1546063f}},	//   يمة_, _латв, _posé, _безм, 
   {{0x6f0d0610,0x2d910474,0x7a7b0147,0x00000000}},	//   _ryac, xeze_, עריס, --, 
   {{0x2d91044e,0x20090640,0x63bb0641,0x61e80642}},	//   veze_, _pkai_, bjun, ridl, 
   {{0x09c100a2,0x2d910643,0x61e80644,0x8f47012d}},	//   _शक्य, weze_, sidl, ыход, 
   {{0x61e80645,0x320505f0,0x2d910646,0x6b9d0647}},	//   pidl, boly_, teze_, _rasg, 
   {{0x7dcb0077,0x23270648,0x6aa9034c,0x6f0d0649}},	//   _küsi, _сочи_, _šefo, _vyac, 
   {{0x2d91064a,0x6b84064b,0x6b9d064c,0xd13f00ab}},	//   reze_, ffig, _pasg, łącz_, 
   {{0x672d053d,0x2d91064d,0x6280064e,0x6b84039f}},	//   žaji, seze_, otmo, gfig, 
   {{0xf96b064f,0x99550650,0x7bcd0651,0x29180652}},	// [2f0] ерей_, икац, rkau, _azra_, 
   {{0x7bcd0653,0x6b9d0654,0xdb1d009e,0x995400b3}},	//   skau, _wasg, _fosî, йкуц, 
   {{0x6b9d0014,0x4735011f,0x3e7f0216,0x3ea90098}},	//   _tasg, анес, lît_, _hrat_, 
   {{0x3ea90655,0x6b9d007a,0x6d570656,0x62800657}},	//   _krat_, _uasg, _hexa, ktmo, 
   {{0x29180658,0x248c00e2,0x6d5701ca,0x395a00f6}},	//   _ezra_, _apdm_, _kexa, baps_, 
   {{0x4ade0659,0xb5fd00bc,0xe5a5065a,0x7c2f0585}},	//   _नेटव, _ovše, рики, _hicr, 
   {{0x23d5065b,0xdb060019,0x6d57065c,0x32050180}},	//   ицир, _inká, _mexa, voly_, 
   {{0xea0100f7,0x3ea90096,0x6265065d,0x57b200f0}},	//   _đẹp_, _orat_, авиа, _мұхт, 
   {{0xd7f8065e,0xe3b6065f,0x00000000,0x00000000}},	//   _сур_, рбы_, --, --, 
   {{0x7c2f0660,0x3e7f010c,0x6ff201dd,0x98a10585}},	//   _licr, dît_, māci, lahı_, 
   {{0x7dd0022b,0xf99200a7,0x6ff200e0,0x3ea90661}},	//   _säso, חרי_, lāci, _arat_, 
   {{0xf1d90662,0x7c2f01be,0x6d570354,0x543a0070}},	//   योजन, _nicr, _aexa, _סענא, 
   {{0x6ff200e0,0x2bbf0663,0x442f01c8,0x6d5701ff}},	//   nāci, _एकजा, _iig_, _bexa, 
   {{0x3ea9016a,0x442f0664,0x10a50665,0x7c2f0534}},	//   _drat_, _hig_, _викн, _aicr, 
   {{0x3ea90666,0xa3cc0667,0x2d9e0228,0x442f0668}},	//   _erat_, _रकम_, ľte_, _kig_, 
   {{0x6ff200e0,0x2d9e063b,0x442f0669,0x0b46066a}},	//   kāci, žte_, _jig_, рнан, 
   {{0x442f066b,0x7c2f066c,0x225f016a,0x3e7f00b3}},	// [300] _mig_, _dicr, nsuk_, cît_, 
   {{0x442f066d,0xe9d7066e,0x7c2f01be,0x6ff20243}},	//   _lig_, аку_, _eicr, dāci, 
   {{0xd91000d6,0x60160183,0x6fcd0212,0x2bbf00bd}},	//   سیر_, námo, _bûch, _एकचा, 
   {{0xc60e034d,0x7afd016a,0x225f066f,0x628001ff}},	//   ित्य_, _fxst, ksuk_, ytmo, 
   {{0x7c240670,0x7ae90588,0xeb970093,0x2d85022c}},	//   mmir, _žetv, _тия_, òleg_, 
   {{0x6d5c0671,0x04660672,0x442f0673,0x7c240095}},	//   nara, атим, _aig_, lmir, 
   {{0x442f0674,0x601d026d,0x2bdd00a2,0xdb0f023e}},	//   _big_, léme, नोका, _ancè, 
   {{0x442f0675,0x938a0676,0x60160042,0x62800677}},	//   _cig_, тска_, dámo, ttmo, 
   {{0x442f0678,0x3c3c0679,0x601d067a,0x7c24067b}},	//   _dig_, _lív_, néme, imir, 
   {{0x6d5c067c,0x31c6067d,0x442f067e,0x6033020f}},	//   jara, рсив, _eig_, _lămu, 
   {{0x3958067f,0x62800680,0x442f00a7,0x60160681}},	//   _mers_, stmo, _fig_, gámo, 
   {{0x6d570682,0x41a60081,0x3ea90683,0x6fc60684}},	//   _sexa, _कोरस, _prat_, _sócr, 
   {{0xdefb0335,0x6d5c0685,0x7c240588,0x7c2f00fd}},	//   тын_, fara, dmir, _ricr, 
   {{0x6d5c0686,0x442f0687,0x7c2f02bf,0x3ea90688}},	//   gara, _zig_, _sicr, _vrat_, 
   {{0x6d570689,0x6ff2002a,0x442f068a,0x6016068b}},	//   _vexa, zāci, _yig_, cámo, 
   {{0x7c24068c,0x3ea90502,0xc1780028,0x60290083}},	//   gmir, _trat_, lgė_, _ośmi, 
   {{0x6d5c068d,0x8d87068e,0x69d5031e,0xba550038}},	// [310] bara, _кунд, _plze, صناع, 
   {{0xe29f010d,0xc178012d,0xa8a7068f,0x6ff201dd}},	//   æði_, ngė_, ирек, vāci, 
   {{0x39580690,0x00000000,0x00000000,0x00000000}},	//   _ders_, --, --, --, 
   {{0x39580691,0x22460692,0x6ff200e0,0x7c2400b3}},	//   _eers_, _otok_, tāci, cmir, 
   {{0x9f42014b,0x60160019,0x39580151,0xb6a50693}},	//   niká_, zámo, _fers_, силл, 
   {{0x442f0694,0x6ff2002a,0x39580695,0x601d0696}},	//   _sig_, rāci, _gers_, némb, 
   {{0xe3b100eb,0x22460697,0x60160042,0x442f0698}},	//   كرة_, _atok_, xámo, _pig_, 
   {{0x6d5c0699,0x442f0201,0x6016069a,0xb7bd020f}},	//   zara, _qig_, vámo, _piţu, 
   {{0x36d4004f,0xdcfe01dd,0xc6f9069b,0x64a300f0}},	//   _дотр, _papī, _снах_, сақа, 
   {{0x6d5c069c,0x7c2401dd,0xdb1d0098,0x39410549}},	//   xara, zmir, _nosí, nchs_, 
   {{0x2ed00081,0x442f069d,0x1bf90509,0x2246023e}},	//   हन्त, _tig_, ्काल_, _etok_, 
   {{0x6d5c069e,0xcdc90056,0x6016069f,0xdb0f06a0}},	//   wara, _אך_, rámo, _encé, 
   {{0x6d5c06a1,0x539a00a7,0xdb2406a2,0x1e830028}},	//   tara, _תינו, üsün, плям, 
   {{0x32b80038,0x60160042,0xddd40032,0x7dd00080}},	//   _خدمة_, pámo, ťažo, _täsm, 
   {{0xc88500ad,0xcb6a06a3,0x8c4602a0,0x7c2406a4}},	//   naşı_, лаве_, себе, tmir, 
   {{0x9f82008c,0x2b5906a5,0x7dd006a6,0xa3ca02e6}},	//   _góð_, _cesc_, _käsk, रॉप_, 
   {{0x2b40032f,0x093606a7,0x00000000,0x00000000}},	// [320] rcic_, مراج, --, --, 
   {{0x2a6006a8,0x6d5c06a9,0x601d06aa,0x2b59008a}},	//   rsib_, qara, réme, _eesc_, 
   {{0xfbd206ab,0x395806ac,0x2a6006ad,0x601d0107}},	//   _فتح_, _vers_, ssib_, séme, 
   {{0xc88504be,0x9f4b0034,0x395806ae,0xdb0f010c}},	//   daşı_, vicë_, _wers_, _incî, 
   {{0xe5c606af,0x39580241,0xada90296,0xe77500ad}},	//   йско, _ters_, _صدیق_, zıçı, 
   {{0x6b9606b0,0x00000000,0x00000000,0x00000000}},	//   leyg, --, --, --, 
   {{0x224606b1,0x7bc606b2,0xe9d706b3,0x66d1039f}},	//   _stok_, _koku, _укр_, tókö, 
   {{0x6b9606b4,0x644a0036,0x2b5900b9,0x7bc606b5}},	//   neyg, rpfi, _xesc_, _joku, 
   {{0x7ae906b6,0x7bc606b7,0x7f5d0183,0x7dcb06b8}},	//   _þett, _moku, vasq, _küst, 
   {{0x7bc606b9,0x7f440065,0x6aa900ef,0x104a06ba}},	//   _loku, _afiq, _šefk, лями_, 
   {{0x7dcb06bb,0xe45206bc,0x442400e2,0x9f4b0369}},	//   _xüsu, _رضا_, pmm_, licé_, 
   {{0x7bc606bd,0xdb1d0183,0x4e1100aa,0x942606be}},	//   _noku, _sosí, _दीजै_, _умее, 
   {{0x7f5d0068,0xdb1d06bf,0x22460495,0xe18800f0}},	//   rasq, _posí, _utok_, _көне_, 
   {{0x270700f7,0xe9df033c,0x63a206c0,0xdb110107}},	//   ống_, _atún_, _haon, _âgée, 
   {{0x7bc606c1,0x63a206c2,0x7a290009,0x7f5d0036}},	//   _boku, _kaon, _užti, pasq, 
   {{0x63a200a9,0xdb1d02be,0x1b020033,0x660a040b}},	//   _jaon, _rosâ, লেছে_, hofk, 
   {{0x63a206c3,0x200b06c4,0x39410107,0x601d033e}},	// [330] _maon, moci_, tchs_, pémb, 
   {{0x2ba904d7,0x200b06c5,0x63a206c6,0x394102eb}},	//   _चोरा, loci_, _laon, uchs_, 
   {{0xa89900f0,0x8a7701a2,0x394106c7,0x7dcb06c8}},	//   ркеу_, риҷӣ_, rchs_, _düst, 
   {{0x61c506c9,0x63a206ca,0x39410382,0xc8850213}},	//   _लक्ष, _naon, schs_, vaşı_, 
   {{0x25ed02f8,0xb5fd014b,0x4ae4012d,0x7dcb039f}},	//   _अगदी_, _avša, _еўра, _füst, 
   {{0x7bc6044d,0xdcfc01dd,0x3e5c0070,0x00000000}},	//   _zoku, cerē, נדוס, --, 
   {{0x7bc606cb,0x63a206cc,0xdb060219,0x6d4500a1}},	//   _yoku, _baon, _enkä, _mfha, 
   {{0x69c706cd,0x7dcb06ce,0x77d7007a,0x63a206cf}},	//   _hoje, _küss, _اغسط, _caon, 
   {{0x69c702f5,0x644806d0,0x200b04d1,0x85b906d1}},	//   _koje, _etdi, doci_, _клас_, 
   {{0x7dcb02ec,0x7dd0014e,0x672d02fe,0x806506d2}},	//   _müss, _väsk, žajs, овож, 
   {{0x69c706d3,0xd5b806d4,0x645e0228,0x7e64008c}},	//   _moje, _уст_, špir, _svip, 
   {{0x6d450265,0x200b03a1,0x246501dd,0xd00a06d5}},	//   _afha, goci_, mēm_, реме_, 
   {{0xa2940100,0xd9fb00a2,0x6d450387,0x246501dd}},	//   _наці, ्वात_, _bfha, lēm_, 
   {{0x7dd006d6,0x224d06d7,0x69c706d8,0xed5700d9}},	//   _käsi, mpek_, _noje, жор_, 
   {{0x7bc606d9,0x63a206da,0x7dcb06db,0x8c43005b}},	//   _poku, _yaon, _rüst, десе, 
   {{0xb06800d6,0x7dcb007e,0x200b06dc,0x3d1a00b0}},	//   _اصول_, _süst, coci_, _धरीं_, 
   {{0x7dcb00b0,0x224d0097,0xed360158,0x19c606dd}},	// [340] _püst, npek_, _мэнэ, обам, 
   {{0x7bc6044d,0x69c706de,0x3ea006df,0x7dcb01c4}},	//   _woku, _coje, _isit_, _düss, 
   {{0x69c706e0,0x5faf00a2,0x601d06e1,0x4d1506e2}},	//   _doje, _जोडल, léma, _ньют, 
   {{0x2d9806e3,0x510c0137,0x224d06e4,0x246501dd}},	//   lere_, נהאַ, kpek_, dēm_, 
   {{0xd5ba0088,0x63a206e5,0x601d06e6,0x69c701ff}},	//   иск_, _raon, néma, _foje, 
   {{0x2d9806e7,0x63a206e8,0x69c706e9,0xe4520038}},	//   nere_, _saon, _goje, وضع_, 
   {{0xb4d406ea,0x2d9806eb,0x63a20036,0x601d06ec}},	//   हने_, iere_, _paon, héma, 
   {{0x2d9806ed,0x326606ee,0x9faf031e,0x6aa90112}},	//   here_, отов, tří_, _šefi, 
   {{0x2d9806ef,0xdb1d0019,0x200b06f0,0x63a20054}},	//   kere_, _kosá, voci_, _vaon, 
   {{0x2d9806f1,0x63a206f2,0x601d0212,0x3f800009}},	//   jere_, _waon, déma, _aciu_, 
   {{0x2d9806f3,0x63a206f4,0x246501dd,0x78450028}},	//   dere_, _taon, cēm_, _tėve, 
   {{0x7a290028,0x2d98052b,0x00000000,0x00000000}},	//   _užtv, eere_, --, --, 
   {{0x2d9806f5,0x200b06f6,0x00000000,0x00000000}},	//   fere_, roci_, --, --, 
   {{0x2d9806f7,0xddcf00b3,0x61ea00b3,0x2b5f00ca}},	//   gere_, ducţ, _umfl, _žuc_, 
   {{0xfbd30084,0xa1770056,0x69c706f8,0xc05a004e}},	//   وتر_, _ועוד_, _roje, _тіл_, 
   {{0x69c70121,0xdb1d00b9,0x7dcb00c2,0x80d7017d}},	//   _soje, _posà, _püss, मनरे, 
   {{0x2d9806f9,0x69c706fa,0x3a7506fb,0x246501dd}},	// [350] bere_, _poje, ялар, zēm_, 
   {{0x2d9806fc,0x3f9906fd,0xdb1d007a,0xdb0f00b9}},	//   cere_, lesu_, _cosá, _socó, 
   {{0xe7f70081,0x69c7026e,0x764906fe,0x2d8100a1}},	//   ंचला_, _voje, _stey, _iche_, 
   {{0x320c06ff,0x69c700ab,0x4c9a042c,0x76b90700}},	//   hody_, _woje, _פברו, йлер_, 
   {{0x320c0083,0x00000000,0x00000000,0x00000000}},	//   kody_, --, --, --, 
   {{0x27ef00df,0x246500e0,0x64a50701,0x69de0702}},	//   sign_, tēm_, зака, chpe, 
   {{0x2d81025b,0xc8640703,0x7ce301ff,0x00000000}},	//   _mche_, _отти, _bеri, --, 
   {{0x3cfc0111,0x3f990704,0x2d980705,0xe3b90706}},	//   ילונ, jesu_, zere_, сби_, 
   {{0x27ed0707,0x2d98004f,0x37da0070,0x246501dd}},	//   _imen_, yere_, _פֿלע, sēm_, 
   {{0x320c0035,0x2d980708,0x6d480585,0x24650243}},	//   gody_, xere_, ıdak, pēm_, 
   {{0x2d980709,0x224d070a,0x6016070b,0x2fc901f5}},	//   vere_, spek_, lámi, _boag_, 
   {{0x2d98070c,0x2fc90068,0x601d009c,0xd8d600d1}},	//   were_, _coag_, téma, פורט_, 
   {{0x25a5070d,0x320c070e,0xc3290038,0x27ed0118}},	//   _kall_, body_, _اكشن_, _mmen_, 
   {{0x7dd002ae,0xd1bb070f,0x27ff0710,0x7bcb003e}},	//   _läsv, _خاصا_, _ljun_, ögun, 
   {{0x2d980711,0x27ed0712,0xdb1d0713,0xed5a0188}},	//   rere_, _omen_, _rosá, _қон_, 
   {{0x2d980714,0x4a460715,0x9e660716,0x2d81001d}},	//   sere_, знав, _евид, _eche_, 
   {{0x2d980717,0x6d410718,0xe9da0719,0xdb1d014b}},	// [360] pere_, ılar, бка_, _posá, 
   {{0xdb04071a,0x27ff071b,0xddcf020f,0x8af000ad}},	//   ndié, _ajun_, rucţ, vbəd, 
   {{0x6d5e00e0,0x63760585,0x6d3b00d1,0xbddb03dd}},	//   _iepa, nünü, _לתינ, rpèt, 
   {{0x7bdf071c,0xf1ba0023,0x69de021e,0x25a5071d}},	//   chqu, _nhơn_, shpe, _aall_, 
   {{0x6d5e071e,0xb4e400a5,0x27ff00a4,0x25a5071f}},	//   _kepa, _पेड़_, _djun_, _ball_, 
   {{0x6d5e0720,0x25a50721,0x7c3e0722,0x3f9901f1}},	//   _jepa, _call_, _kupr, zesu_, 
   {{0x25a5048a,0x320c037f,0x7ae400b3,0x3f990723}},	//   _dall_, vody_, lzit, yesu_, 
   {{0x6d5e0724,0x7bd60725,0x07a30726,0x320c0035}},	//   _lepa, nkyu, _пасн, wody_, 
   {{0x7ae40727,0x320c0728,0xdb040107,0x25a50729}},	//   nzit, tody_, udiè, _fall_, 
   {{0x64a6072a,0x200303ef,0x672002a8,0x6d5e06dd}},	//   _наза, čkim_, _izmj, _nepa, 
   {{0x320c072b,0x9316010e,0x9f99072c,0x63760213}},	//   rody_, _کوشش, овну_, günü, 
   {{0x2d8102eb,0x443e0212,0x320c0054,0x6720072d}},	//   _sche_, _iut_, sody_, _बराक_, 
   {{0x6d5e051e,0xe80d072e,0xb80d072f,0x7c3e026a}},	//   _bepa, िकता_, िकतम_, _aupr, 
   {{0x6d5e0730,0x443e0731,0x224b0228,0x3f9900f8}},	//   _cepa, _kut_, ícke_, sesu_, 
   {{0x7c3e002e,0x3f99033d,0x443e010e,0x9f4b02d9}},	//   _cupr, pesu_, _jut_, licí_, 
   {{0x443e0732,0x69dc0733,0xd1170070,0x6d5e0102}},	//   _mut_, _alre, _מקוה_, _eepa, 
   {{0x5a350172,0x601d0734,0x443e0735,0x6d5e0736}},	// [370] днат, lémo, _lut_, _fepa, 
   {{0x443e0052,0x6d5e0737,0x7bdf0738,0x20190739}},	//   _out_, _gepa, shqu, llsi_, 
   {{0x7c3e04c6,0x69dc01be,0x7ae402a5,0x443e073a}},	//   _gupr, _dlre, azit, _nut_, 
   {{0x60160183,0x25a5073b,0x69dc010e,0x00000000}},	//   támi, _sall_, _elre, --, 
   {{0xf770073c,0x35a500d3,0x443e073d,0xe5a5073e}},	//   طان_, далг, _aut_, дили, 
   {{0x443e0052,0x6016073f,0xf6500740,0x6d470035}},	//   _but_, rámi, ائن_, ncja, 
   {{0x25a503a1,0x27ed02a2,0x98170038,0x64a20093}},	//   _vall_, _tmen_, _فبرا, ваща, 
   {{0x7dd00741,0x443e02ba,0x601d0742,0x25a50743}},	//   _häst, _dut_, démo, _wall_, 
   {{0x91e50744,0x64490745,0xd175013e,0x443e0107}},	//   допе, _žlič, мыны, _eut_, 
   {{0x443e0746,0x5ef1031e,0xdb040380,0x7dd00747}},	//   _fut_, ँछन्_, heiß, _jäst, 
   {{0x65630748,0x7bdd0749,0x7dd0014e,0x443e074a}},	//   manh, _olsu, _mäst, _gut_, 
   {{0x7dd0074b,0x637603c0,0x5ec60086,0x27fd00f8}},	//   _läst, rünü, _লেগে, nnwn_, 
   {{0x6d5e074c,0x7c3e074d,0x63a9074e,0x2169074f}},	//   _pepa, _supr, mden, _дили_, 
   {{0x518703dc,0x7dd00750,0x63a90751,0x601d0183}},	//   _худа, _näst, lden, bémo, 
   {{0x601d0042,0x62890752,0x6b8d0753,0x443e00f6}},	//   cémo, lteo, ffag, _xut_, 
   {{0x63a90754,0x673b0755,0x7ae401f1,0x65630756}},	//   nden, _nguj, tzit, hanh, 
   {{0x7dd00750,0x6d5e0757,0x62890758,0x65630759}},	// [380] _bäst, _tepa, nteo, kanh, 
   {{0x673b04b3,0x63a900c8,0x2259014b,0x62890038}},	//   _aguj, hden, ásky_, iteo, 
   {{0x0c2600a3,0xdb0f022c,0xd910009c,0x59c4075a}},	//   _омон, _encà, ایز_, लॉगर, 
   {{0x63a9075b,0x3eb2014b,0xdb1d02ae,0x00000000}},	//   jden, _kryt_, _bosä, --, 
   {{0x443e02bf,0x7dd0014e,0xd76500d4,0x6563019c}},	//   _sut_, _fäst, رنوی, fanh, 
   {{0x7dd0075c,0x63a9075d,0x443e075e,0x6563075f}},	//   _gäst, eden, _put_, ganh, 
   {{0x7dd00760,0x7845012d,0x443e0104,0x601d0068}},	//   _häss, _tėva, _qut_, xémo, 
   {{0xd7640019,0x601d0183,0x60080761,0x63a90762}},	//   _سنئی, vémo, nımd, gden, 
   {{0x29180763,0xa80203c0,0x65630764,0x443e0765}},	//   _hyra_, ğıda, banh, _wut_, 
   {{0x7abb00a7,0x7dd00766,0x601d0767,0x63a90768}},	//   קציו, _mäss, témo, aden, 
   {{0x7dd002f2,0xc0570769,0x443e007e,0x3eb20054}},	//   _läss, мія_, _uut_, _aryt_, 
   {{0x601d076a,0x2918076b,0x7640076c,0x3eb2076d}},	//   rémo, _myra_, _kumy, _bryt_, 
   {{0x6289076e,0x4426076f,0x7dd00770,0x15f200bd}},	//   cteo, _iho_, _näss, _अगार_, 
   {{0x76400771,0xdb040502,0xdb060216,0x00000000}},	//   _mumy, weiß, _takê, --, 
   {{0x44260772,0xa0a3004e,0x9e3400b3,0x2bbb0038}},	//   _kho_, _ашыл, терч, يارة_, 
   {{0x2ba90773,0xdb0601e5,0x3eb2021e,0x00000000}},	//   _चोखा, _kakè, _fryt_, --, 
   {{0xa3d60394,0x656302dc,0x6b8d0774,0x69c50364}},	// [390] _हवन_, yanh, rfag, tjhe, 
   {{0x44260775,0x63a90776,0x49740777,0x7e7d033d}},	//   _lho_, zden, клус, musp, 
   {{0x7dd0022b,0x44260778,0x63a90779,0x6563077a}},	//   _väst, _oho_, yden, vanh, 
   {{0x65630065,0xdb0f0042,0x4426077b,0xddcd014b}},	//   wanh, _encá, _nho_, _staň, 
   {{0x200303ef,0x7c2d05a1,0x7dd0030f,0x6563075f}},	//   čkih_, mmar, _täst, tanh, 
   {{0x4426077c,0x2918022b,0x00000000,0x00000000}},	//   _aho_, _fyra_, --, --, 
   {{0x4426004c,0x6563077d,0x28680161,0xfc460228}},	//   _bho_, ranh, _орто_, žíva_, 
   {{0x4426077e,0x7c2d077f,0x7e7d0780,0x65630781}},	//   _cho_, nmar, kusp, sanh, 
   {{0x66f3075a,0x65630782,0x2a690783,0x44260784}},	//   _अधिक_, panh, nsab_, _dho_, 
   {{0x60080785,0x62890786,0x60e90787,0x44260026}},	//   zımd, rteo, змом_, _eho_, 
   {{0x62890788,0x7c2d0789,0xdb06024a,0x9f4b00f6}},	//   steo, kmar, _pakë, ficà_, 
   {{0x64410012,0x7c2d078a,0x6561017e,0x776000a4}},	//   _iuli, jmar, _helh, _xemx, 
   {{0x442d078b,0x81d5078c,0x6441078d,0x213c00e2}},	//   mme_, _подх, _huli, _fgvh_, 
   {{0x7c26078e,0x3f84003d,0x270e00e7,0xfbdf02be}},	//   _shkr, żmu_, ộng_, _alê_, 
   {{0x65610316,0xfce6078f,0xa3b40790,0x64410791}},	//   _melh, хово, _छोड_, _juli, 
   {{0x442d0792,0x64410793,0x7c2d0794,0xf0620093}},	//   nme_, _muli, gmar, _скъп, 
   {{0x291e03ef,0xe9da0795,0x160f0796,0x64410797}},	// [3a0] _šta_, пка_, िवार_, _luli, 
   {{0x442d0798,0x7c2d0799,0xdb06031e,0x3d1100a2}},	//   hme_, amar, _jaké, _दुवे_, 
   {{0x6441079a,0x442d079b,0xdb06079c,0x2ca50566}},	//   _nuli, kme_, _maké, ældt_, 
   {{0x442d079d,0x7dd0030f,0x3f82079e,0xe85300d4}},	//   jme_, _täss, ngku_, انند, 
   {{0x4426079f,0x442d07a0,0x656107a1,0x9f4b019c}},	//   _rho_, dme_, _belh, nicá_, 
   {{0x644107a2,0x442d07a3,0x442600a3,0xe4a607a4}},	//   _buli, eme_, _sho_, ерио, 
   {{0xd49707a5,0xdcfc00e0,0x442d01d2,0xdb0600d7}},	//   еры_, derī, fme_, _sakè, 
   {{0x442601c1,0x69ce02ba,0x644107a6,0xdb060300}},	//   _qho_, _hobe, _duli, _pakè, 
   {{0x6561006b,0x69ce07a7,0x644107a8,0xf5ea00b3}},	//   _felh, _kobe, _euli, _емал_, 
   {{0x44260056,0xef1f07a9,0x442d07aa,0xf1ba00e7}},	//   _who_, ngüe_, ame_, _thơm_, 
   {{0x644107ab,0x33d602fb,0x442d07ac,0x442607ad}},	//   _guli, _підт, bme_, _tho_, 
   {{0x7e7d03f0,0xa2e607ae,0x442d07af,0x04db00a7}},	//   tusp, _поед, cme_, _מקבל, 
   {{0x0cc903a2,0x644107b0,0xa3d50077,0x9f4b03a1}},	//   रह्म, _zuli, _सकत_, ricà_, 
   {{0x644107b1,0x7afb0112,0x7c2d07b2,0x2d8507b3}},	//   _yuli, _žuto, wmar, üle_, 
   {{0x7e7d07b4,0x644107b5,0xac1907b6,0x00000000}},	//   susp, _xuli, дову_, --, 
   {{0x7e7d07b7,0x9d180176,0x00000000,0x00000000}},	//   pusp, хост_, --, --, 
   {{0x69ce07b8,0x2ec2004e,0xda7807b9,0x7f490369}},	// [3b0] _bobe, _көрм, еях_, ñequ, 
   {{0x9f59007a,0x7e6d01d6,0x5b1400b3,0x00000000}},	//   insí_, _ivap, умут, --, 
   {{0xd36601e5,0x69ce07ba,0x2a69045a,0xe3c30241}},	//   _په_, _dobe, ssab_, ngıç_, 
   {{0x7e6d07bb,0x442d07bc,0x2d8300fc,0x7f4d01f2}},	//   _kvap, xme_, lgje_, _jfaq, 
   {{0xe7e207bd,0xb6a507be,0x442d07bf,0x656107c0}},	//   _खतरा_, тилл, vme_, _pelh, 
   {{0x69ce07c1,0x442d052b,0x2d8307c2,0x8882010e}},	//   _gobe, wme_, ngje_, _چیلن, 
   {{0x442d07c3,0x656107c4,0xdb0607c5,0x644107c6}},	//   tme_, _velh, _raké, _quli, 
   {{0x7bcf0012,0x644107c7,0x69ce07c8,0xdb0607c9}},	//   _jocu, _vuli, _zobe, _makî, 
   {{0x130902fb,0x9f4200e5,0x122902f1,0x656107ca}},	//   ьний_, shkë_, моий_, _telh, 
   {{0x7bcf0012,0xb63507cb,0xb14500a3,0x00000000}},	//   _locu, _شفاع, ънол, --, 
   {{0xf8e107cc,0x442d07cd,0x644107ce,0xdb1d00eb}},	//   पनिय, pme_, _uuli, _cosú, 
   {{0x13a700d4,0x2d8301d2,0x9f4b02be,0x00000000}},	//   _سنتی_, egje_, ticá_, --, 
   {{0x69c40497,0x3f8c00ab,0xdb060228,0x15e500c6}},	//   रामी, ędu_, _také, _कतार_, 
   {{0x7e6d0112,0x827600c7,0x63ab003e,0xd24e07cf}},	//   _dvap, _יענע_, _hagn, _بنو_, 
   {{0x0d220161,0x8c4603a1,0xa0a507d0,0xa3d50083}},	//   рүнү, тебе, _райд, _सका_, 
   {{0x63ab07d1,0xeb9707d2,0x2d8301c8,0xd00f0038}},	//   _jagn, кис_, agje_, _ولو_, 
   {{0x69ce07d3,0x7bcf07d4,0xe7f707d5,0x2907009e}},	// [3c0] _pobe, _docu, ूचना_, ûnan_, 
   {{0xdb0d003e,0x63ab07d6,0x69ce07d7,0x1c4607d8}},	//   rjað, _lagn, _qobe, _ином, 
   {{0x1d0a07d9,0x7bcf07da,0x69ce07db,0xa9a301ff}},	//   _цени_, _focu, _vobe, рихд, 
   {{0x69ce07dc,0x63ab07dd,0x78b500ef,0x27e00038}},	//   _wobe, _nagn, _drzv, óin_, 
   {{0x69ce07d7,0xe7f300ab,0xe73707de,0x34da00bc}},	//   _tobe, _आगरा_, вец_, बन्द, 
   {{0x557307df,0xa613012d,0x6b8407e0,0x6aa40610}},	//   агшт, аміч, lgig, mwif, 
   {{0x63ab0141,0x629906df,0xbf000035,0x046307e1}},	//   _bagn, _apwo, ैथुन_, атым, 
   {{0x63ab07e2,0x00000000,0x00000000,0x00000000}},	//   _cagn, --, --, --, 
   {{0x63ab07e3,0x6f090083,0x41e6012d,0x8c1b07e4}},	//   _dagn, żecz, віна, ווקי, 
   {{0xdb1d07e5,0x27e607e6,0xf1ba0023,0x7d090241}},	//   _posú, lhon_, _khơi_, şesi, 
   {{0x601d07e7,0xb97b00a7,0x25be07e8,0x7e6d02a3}},	//   lémi, וניי, _intl_, _svap, 
   {{0x63ab07e9,0xb4c00081,0x7ec900e5,0x27e602dc}},	//   _gagn, ुही_, _nëpë, nhon_, 
   {{0xd25000eb,0xf8bf0586,0xa19407ea,0x00000000}},	//   _انت_, _एप्प, _балч, --, 
   {{0x6aa407eb,0x63ab00f9,0x7bcf020f,0x62800243}},	//   dwif, _zagn, _socu, mumo, 
   {{0xa3d603c1,0x628007ec,0x2d8307ed,0x7bcf07ee}},	//   _हवा_, lumo, rgje_, _pocu, 
   {{0x6008027e,0x6aa4019b,0x6b8407ef,0x63a000fc}},	//   rımc, fwif, ggig, nemn, 
   {{0x27e607f0,0x62800626,0x41a90790,0x683a00d8}},	// [3d0] dhon_, numo, _कसमस, _půdn, 
   {{0x601d07f1,0x3ea907f2,0x9f40022c,0x3f8901be}},	//   démi, _isat_, _aliè_, _hcau_, 
   {{0xf1ba00f7,0x628007f3,0xf77507f4,0x7bcf020f}},	//   _chơi_, humo, гулю, _tocu, 
   {{0xf09307f5,0x63a007f6,0x628007f7,0x1a65006b}},	//   ינע_, jemn, kumo, _میری_, 
   {{0x63ab07f8,0xe94707f9,0x628000e0,0x600807fa}},	//   _ragn, _ахбо, jumo, nıma, 
   {{0x63ab07fb,0x27e607fc,0x7c3d03c6,0x628007fd}},	//   _sagn, ahon_, _hisr, dumo, 
   {{0x63ab07fe,0x20020035,0x7dcb039f,0x478b0267}},	//   _pagn, ynki_, _büsz, _осам_, 
   {{0x27e607ff,0x3f890201,0x3d3c042c,0x63a00800}},	//   chon_, _ncau_, וגוס, gemn, 
   {{0x63ab0801,0x23c507d5,0x67d40802,0x62800803}},	//   _vagn, वाबद, _тоту, gumo, 
   {{0x79850089,0x228b017b,0xa3b500f0,0x3f8900f3}},	//   nghw, røk_, _әбді, _acau_, 
   {{0x54550804,0x63ab0805,0x69c400a2,0x228b00dd}},	//   _свет, _tagn, राती, søk_, 
   {{0x7c3d007b,0x92b50198,0xdb0d00c2,0x62800806}},	//   _nisr, _محتا, ljaõ, bumo, 
   {{0xe2990807,0x3ea90808,0x62c7007a,0xfeba00d7}},	//   _чал_, _csat_, _جزاك, راحت_, 
   {{0x200200ef,0x7c3d0809,0xc33200d1,0x27e6080a}},	//   snki_, _aisr, _הוד_, zhon_, 
   {{0xfce3080b,0x1d07080c,0x3ea9080d,0xd1b80019}},	//   боро, гери_, _esat_, _جانا_, 
   {{0xfaa6080e,0x81bc01dd,0xd0120038,0x60dc00fc}},	//   лабо, smēt, _دلع_, ørme, 
   {{0xfe7200d6,0xdb0603a0,0x6b84080f,0xac070810}},	// [3e0] _ادب_, _ankò, rgig, унта_, 
   {{0x63a00811,0xf1ba0023,0x7a220032,0xd6c4009c}},	//   zemn, _phơi_, rôto, یمای, 
   {{0x81bc002a,0x27e60812,0xcb6a01fc,0x443d02a5}},	//   slēg, thon_, _пане_, _oiw_, 
   {{0x4b550093,0x443d02be,0xdb1d0237,0xd70a0080}},	//   _върт, _niw_, _onsè, ннее_, 
   {{0x6d5c0813,0xcc3b00c7,0xddc40352,0xdb0605d5}},	//   obra, _רעכט, _zviš, _enkò, 
   {{0x601d0814,0xe9df00eb,0x27e60815,0xb8660816}},	//   rémi, _dtús_, shon_, _مارو, 
   {{0xe0c70817,0xdb1d0300,0x63a00818,0x09890148}},	//   _از_, _ansè, temn, _шарқ_, 
   {{0x02a60819,0xb274081a,0xc274081b,0x6e3e081c}},	//   гром, алиш, алиј, _lipb, 
   {{0x060a081d,0x248e0626,0x3706081e,0x443d0300}},	//   _знак_, stfm_, _спаг, _diw_, 
   {{0x63a0081f,0x62800820,0xf1a60821,0xb6a400a3}},	//   semn, rumo, урин, _йиғл, 
   {{0x438600d6,0x62800822,0xb97b00c7,0x6d5c0823}},	//   _ملاق, sumo, ענטי, dbra, 
   {{0x273a0824,0x9f59024a,0x6280001d,0x752801dd}},	//   _günü_, misë_, pumo, _izdz, 
   {{0x9f59024a,0x98b8007b,0x244a0108,0x6458040b}},	//   lisë_, _ferħ_, _hùm_, lpvi, 
   {{0x2fc00825,0x6d5c0826,0x60080585,0xc3330147}},	//   _enig_, gbra, rıma, _פוס_, 
   {{0x9f5900e5,0xfaff00e5,0xa2ac0827,0xdb1d0828}},	//   nisë_, _ndër_, जिक्, _insé, 
   {{0x61fa0829,0x81bc00e0,0xdb0f0183,0x6d5c0387}},	//   litl, slēd, _incú, abra, 
   {{0x6d5c0141,0x3ea903dd,0xe51b034d,0x9f49027e}},	// [3f0] bbra, _usat_, _पुनि_, _amaç_, 
   {{0x6d5c00a1,0x61fa082a,0x9f59024a,0xdcfc01dd}},	//   cbra, nitl, kisë_, sgrā, 
   {{0xa3d50077,0xdb04001d,0x9f59024a,0xf9880038}},	//   _सकल_, rdiá, jisë_, انمي_, 
   {{0x9f590034,0x61fa082b,0x7e7d000b,0xa8020761}},	//   disë_, hitl, orsp, şına, 
   {{0xd90f082c,0x61fa082d,0xa764082e,0x224605d5}},	//   _کیا_, kitl, скід, _nuok_, 
   {{0x443d082f,0xaaa80093,0x9f590034,0xab5b0502}},	//   _siw_, _съюз_, fisë_, _unüb, 
   {{0x7aed00fd,0x244a0830,0x61fa065c,0x780501a2}},	//   lzat, _cùm_, ditl, _кӯда, 
   {{0x7bcd0831,0x2246012b,0x6d5c0832,0x244a00e7}},	//   njau, _buok_, zbra, _dùm_, 
   {{0x7aed0833,0x11e50834,0x6d5c0835,0xdb060054}},	//   nzat, ижим, ybra, _zakâ, 
   {{0x437500c5,0x84670141,0x20090836,0x61fa00a3}},	//   _چهار, _бъде, _ajai_, gitl, 
   {{0xe5c40837,0x23c50838,0x53c507d5,0x9f5900e5}},	//   _усто, वादद, वादश, cisë_, 
   {{0x22950839,0x6d5c083a,0xb4b1083b,0xdb1d0126}},	//   _видя, wbra, टटी_, _ensé, 
   {{0x6d5c083c,0x61fa083d,0x5f1900bd,0xda150110}},	//   tbra, bitl, _युद्_, तकात_, 
   {{0x20090065,0x7aed0204,0xdb0402aa,0x7bcd0028}},	//   _ejai_, dzat, ldiç, ejau, 
   {{0x6d5c083e,0x6f0d083f,0xdca60840,0x7f760841}},	//   rbra, _exac, шави, _купц, 
   {{0x35c7000f,0xdb0400ce,0xac070842,0x2fc002bf}},	//   लाड़, ndiç, анса_, _unig_, 
  
   {{0x89660843,0xbea603a1,0x9f590034,0x68e100c2}},	// [400] икаж, _тапк, zisë_, _üldj, 
   {{0x48b60093,0x692603fd,0x7d1e0844,0x27e400a1}},	//   ищет, амза, _typs, _slmn_, 
   {{0x18a60845,0xac0a0846,0x987402d9,0x320500d1}},	//   раем, _анна_, _týče_, inly_, 
   {{0x7bdf0847,0x244a0014,0x7e640610,0x61fa0848}},	//   ckqu, _rùm_, _kwip, zitl, 
   {{0xe5c60849,0x7e64018e,0xdcfe020b,0x7aed0083}},	//   иско, _jwip, _napĺ, czat, 
   {{0xd49a084a,0x5d7a0137,0x672901dd,0x9f590034}},	//   ври_, דאַק, _dzej, tisë_, 
   {{0x53e6084b,0xdb060054,0x672902a5,0x00000000}},	//   ициа, _hakà, _ezej, --, 
   {{0x9f59078e,0x7afb034c,0x6458084c,0x7a2b04a8}},	//   risë_, _žuti, rpvi, rüte, 
   {{0x9f5900e5,0x66e3084d,0x6729008a,0x61fa084e}},	//   sisë_, _дота, _gzej, titl, 
   {{0x9f59084f,0xeb0400b0,0x64580850,0x244a0108}},	//   pisë_, _रखैत_, ppvi, _tùm_, 
   {{0x7aed0851,0x9f590852,0x31670175,0x661800da}},	//   zzat, lisé_, _denz_, movk, 
   {{0x65680853,0x61fa0854,0x6618014b,0x7aed0855}},	//   _hedh, sitl, lovk, yzat, 
   {{0x61fa0856,0x64480857,0x9f590858,0x656800d4}},	//   pitl, _hudi, nisé_, _kedh, 
   {{0x64480859,0x6568023e,0x249e085a,0x7e64085b}},	//   _kudi, _jedh, _kptm_, _dwip, 
   {{0x4035085c,0x315700a7,0x6568085d,0x7b670088}},	//   _лекс, _דיון_, _medh, итае, 
   {{0x81e800cc,0x6448085e,0x2cba085f,0x7aed0860}},	//   _যদি_, _mudi, _drpd_, tzat, 
   {{0x6e95057f,0x7bcd030f,0x5e9500eb,0x15f80662}},	// [410] _الخا, rjau, _الخط, ्चार_, 
   {{0x7bcd0861,0x20190862,0xa8020384,0x64480863}},	//   sjau, losi_, şıla, _oudi, 
   {{0x6618026e,0x6d45012b,0x6008027e,0x57a700a3}},	//   dovk, _igha, kıml, ишда, 
   {{0xdce70864,0xdb06023a,0x6568052b,0xb8ff0865}},	//   najč, _fakà, _aedh, _तथ_, 
   {{0xef1f07fa,0x6568009c,0x60080248,0x79a70165}},	//   zgün_, _bedh, dıml, _крве, 
   {{0xc9840866,0x20190867,0x6568009c,0xbb3a00d1}},	//   _муси, hosi_, _cedh, _תעשי, 
   {{0x20190868,0x6d450869,0x656801e5,0x6448086a}},	//   kosi_, _mgha, _dedh, _cudi, 
   {{0xd774086b,0x316701d8,0x6448010c,0x2019086c}},	//   _واقع, _senz_, _dudi, josi_, 
   {{0x6568086d,0x2019086e,0x69d5086f,0x316c0870}},	//   _fedh, dosi_, _koze, fadz_, 
   {{0x656800c5,0x6d4502bf,0x69d50871,0x64480872}},	//   _gedh, _ngha, _joze, _fudi, 
   {{0x273300f7,0xd175005e,0x7e640873,0x201900fd}},	//   _ảnh_, _ғылы, _swip, fosi_, 
   {{0x6d450874,0xdb060875,0xfaff0876,0xef1f0384}},	//   _agha, _laká, _reën_, rgün_, 
   {{0x6d45008a,0xfaff0876,0xdb1d010e,0xfe7800d3}},	//   _bgha, _seën_, _mosó, шүп_, 
   {{0xc5f20137,0x9f590088,0x64480877,0x2be0031e}},	//   ִדן_, ensä_, _yudi, नस्थ, 
   {{0x76410878,0xdcf706d0,0xed570879,0x6448087a}},	//   _mily, _baxı, сос_, _xudi, 
   {{0x6a8600b9,0x6618026e,0x7769087b,0x2019087c}},	//   йлба, zovk, _neex, cosi_, 
   {{0x69d5087d,0x6b630161,0xef1f087e,0xdd110098}},	// [420] _boze, якта, ngül_, _výši, 
   {{0x3ea0011d,0xe9d705d9,0x9f590212,0x0d76009c}},	//   _ipit_, бку_, visé_, _دیسک_, 
   {{0x6568087f,0x442f0880,0x600807fa,0xb8650881}},	//   _redh, _ohg_, yıml, قانو, 
   {{0x6568009c,0x64480882,0x76490126,0x9f590883}},	//   _sedh, _rudi, _buey, tisé_, 
   {{0x6448034c,0xc5f8004e,0x76410884,0x6618014b}},	//   _sudi, аға_, _bily, tovk, 
   {{0x64480767,0x7c240885,0x9f59026d,0x69d500ad}},	//   _pudi, llir, risé_, _goze, 
   {{0xdcf706d0,0xd4670886,0x442f0887,0x66180888}},	//   _yaxı, бије_, _bhg_, rovk, 
   {{0xdb060076,0x656800c5,0x938a0889,0x3254088a}},	//   _zaká, _wedh, уска_, овир, 
   {{0x316c0757,0x60080384,0x2019088b,0xaac8088c}},	//   tadz_, rıml, vosi_, रमिक, 
   {{0xc05a032e,0x76410156,0x31c6088d,0x9098088e}},	//   лім_, _gily, ссив, авот_, 
   {{0x6448088f,0x20190890,0x3ea00891,0x40350892}},	//   _uudi, tosi_, _apit_, женс, 
   {{0x442f0102,0x7c29003d,0x1ac8031e,0x20190028}},	//   _ghg_, ċerk, रमाथ, uosi_, 
   {{0x2d980893,0xdefb004e,0x44240065,0x8af000ad}},	//   ffre_, уын_, mlm_, ncəd, 
   {{0x6d48003a,0xddcd00ab,0x10f90019,0xa158004f}},	//   ždan, _stał, ابیں_, _таку_, 
   {{0x69d50894,0x7c24008a,0x3ea00118,0x20190895}},	//   _roze, flir, _epit_, posi_, 
   {{0x68e1007e,0xdb0f0369,0x9b590896,0x69d50216}},	//   _üldi, _hacé, риат_, _soze, 
   {{0x69d50897,0xdd9100eb,0x4424007e,0x3a750898}},	// [430] _poze, _قوة_, ilm_, юлар, 
   {{0x44240219,0x6d450548,0x7c2401a3,0x00000000}},	//   hlm_, _ugha, alir, --, 
   {{0x7c240899,0x69d5089a,0xdb1d089b,0xdcf700ad}},	//   blir, _voze, _insí, _taxı, 
   {{0x7641089c,0x69d5089d,0x7649089e,0x76b900d3}},	//   _sily, _woze, _puey, илер_, 
   {{0x442402cd,0x9a84089f,0xdb23009c,0xdb0608a0}},	//   dlm_, _нурл, _روسی, _taká, 
   {{0x442f08a1,0x27fd0156,0x4efc0486,0x764101ff}},	//   _shg_, siwn_, נהגו, _qily, 
   {{0x644208a2,0x36230019,0x628008a3,0x00000000}},	//   _bioi, _ہورہ, ermo, --, 
   {{0x84360038,0xd79400fd,0x00000000,0x00000000}},	//   يكور_, _нисъ, --, --, 
   {{0x64420068,0xdb0f0096,0x7641040c,0x00000000}},	//   _dioi, _bacé, _tily, --, 
   {{0xe1f908a4,0x113908a5,0xfaff0876,0x56940258}},	//   рго_, ияны_, _reël_, _хафт, 
   {{0xe5c408a6,0x600a08a7,0x3ea008a8,0x628001f5}},	//   _эсто, ином_, _spit_, armo, 
   {{0xd9a608a9,0x64420093,0x7a30014e,0xdb1d001d}},	//   _ऑस्ट, _gioi, mäte, _ansí, 
   {{0xdb0f08aa,0x8db6004f,0x11d508ab,0x51f5029a}},	//   _facé, осві, _мікр, _وستر, 
   {{0xacea08ac,0x2cb800ca,0x00000000,0x00000000}},	//   амга_, tvrd_, --, --, 
   {{0x9d4308ad,0x7a3008ae,0x51840176,0x00000000}},	//   дерд, näte, _хуча, --, 
   {{0xdb0d0038,0x0c2608af,0xfaff08b0,0xec1600d7}},	//   adaí, іман, _teël_, آورد, 
   {{0x3ea008b1,0x53360137,0xeab70161,0x2d9808b2}},	// [440] _upit_, ַנען_, ойт_, pfre_, 
   {{0xa2b108b3,0xa2cc08b4,0x7a3008b5,0xa6ca08b6}},	//   _अनन्, _तपस्, käte, یوال_, 
   {{0xeb9a00d9,0x0d230161,0x7c2408b7,0x44240679}},	//   _кин_, _жүрү, plir, ylm_, 
   {{0xdb04007a,0x7a3000c8,0xc72608b8,0xb09a0070}},	//   idiú, däte, одей, ייער, 
   {{0x7bc608b9,0xdce701dd,0xc7a30165,0x00000000}},	//   _inku, majā, ќичк, --, 
   {{0x78af00c8,0xdce70243,0xfa6708ba,0x00000000}},	//   äivä, lajā, _фарк_, --, 
   {{0x37e600dd,0xa6d80033,0x00000000,0x00000000}},	//   _довг, _দেশট, --, --, 
   {{0x68e308bb,0x7dd000c8,0xdce701dd,0xdb0f0096}},	//   ønde, _väsy, najā, _sacé, 
   {{0x776208bc,0xc1a608bd,0xdb0f0574,0x6280039b}},	//   mbox, ојни, _pacé, urmo, 
   {{0x68e900bc,0x77620844,0x2be10035,0x64a608be}},	//   _ředi, lbox, _नवभा, _маза, 
   {{0x7bc608bf,0xc95300a7,0xd36f08c0,0xdce701dd}},	//   _onku, ומת_, _оч_, kajā, 
   {{0x645a08c1,0x683108c2,0x776208c3,0x6d480588}},	//   _itti, rådg, nbox, ždal, 
   {{0xf77300a7,0xf1a900d7,0x00000000,0x00000000}},	//   וקר_, _گانه_, --, --, 
   {{0x7bc608c4,0x00000000,0x00000000,0x00000000}},	//   _anku, --, --, --, 
   {{0xdb6b08c5,0xf1a901c9,0xc31c0033,0xdb0d007a}},	//   ирал_, _دانه_, দেশি_, rdaí, 
   {{0x3eb00088,0x3d1a009a,0xdce70243,0xff66009e}},	//   ältä_, _मुळे_, gajā, _çîpa_, 
   {{0x161a08c6,0x2aab021c,0xfd4708c7,0x00000000}},	// [450] धवार_, штво_, _мэнн, --, 
   {{0x645a08c8,0x7bc60298,0x19ab0165,0x39470453}},	//   _otti, _enku, јтап_, øns_, 
   {{0xa89900f0,0x6d550035,0x00000000,0x00000000}},	//   скеу_, mcza, --, --, 
   {{0x59c9031e,0x27e9010e,0x99980009,0x284800f0}},	//   राहर, óan_, _virš_, ізіп_, 
   {{0x645a08c9,0xf1bc0081,0x68e3055f,0xc21a00c9}},	//   _atti, ्ञान, øndb, नकाब_, 
   {{0x7a3001c4,0x6b8d08ca,0x00000000,0x00000000}},	//   täte, lgag, --, --, 
   {{0x69cd009a,0x7d18017b,0x00000000,0x00000000}},	//   साठी, _øvst, --, --, 
   {{0xd7f803dd,0xf77308cb,0x7a3008cc,0x59c90110}},	//   _дуу_, _زار_, räte, रावर, 
   {{0x645a08cd,0xdb0f033c,0x35f508ce,0xc7b20486}},	//   _etti, _incó, _епар, _אבן_, 
   {{0x765b08cf,0x200b0083,0x7a3008d0,0x95c808d1}},	//   _ituy, enci_, päte, _муха_, 
   {{0x6d5500ab,0xc61708d2,0x69c708d3,0x6aad08d4}},	//   dcza, दकीय_, _mnje, hwaf, 
   {{0xdb04007a,0xc48400f0,0x2477020f,0x6d550083}},	//   rdiú, _ілік, măm_, ecza, 
   {{0x63a908d5,0xa3b4007e,0x33f4070f,0x2477020f}},	//   meen, _छोट_, _تسلس, lăm_, 
   {{0xed5708d6,0x63a90326,0x6b8d02a5,0x00000000}},	//   зор_, leen, egag, --, 
   {{0x8af00095,0xdce701dd,0xdb0f0126,0xa3cf02e6}},	//   hbət, tajā, _oncó, शाप_, 
   {{0x245108d7,0x69c708d8,0x60dc08d9,0x63a908da}},	//   _mám_, _anje, ärme, neen, 
   {{0x200208db,0x765b08dc,0xca8600d9,0x225f011c}},	// [460] miki_, _ntuy, ягай, npuk_, 
   {{0x14bd08dd,0x63a900c8,0xe9d708de,0x4efb00d1}},	//   ्माण, heen, пку_, _להפו, 
   {{0x245108df,0x63a908e0,0x02a808e1,0x7a2b0380}},	//   _nám_, keen, _कन्न, mütl, 
   {{0x7bc6007c,0x63a901c8,0x3ce500fc,0x24770474}},	//   _unku, jeen, ølve_, dăm_, 
   {{0x63a908e2,0xdb060219,0x56940515,0xa3cf042b}},	//   deen, _bakå, фалт, शान_, 
   {{0xf1d0001b,0xdb0f0042,0x69c708e3,0x9f59014b}},	//   _mạch_, _encó, _gnje, visí_, 
   {{0x2451001b,0x247700d9,0x18a308e4,0x63a908e5}},	//   _cám_, găm_, _парм, feen, 
   {{0x63a908e6,0x245108e7,0xa6d30086,0x6d5500ab}},	//   geen, _dám_, _দেওয়, zcza, 
   {{0x366708e8,0x200208e9,0x6d5500ab,0xdce501dd}},	//   _нато_, diki_, ycza, _mehā, 
   {{0x68310310,0x2b46020b,0xdce70474,0x24770474}},	//   råde, ľoch_, najă, băm_, 
   {{0x200208ea,0x80df00cc,0x63a908eb,0xf1af0038}},	//   fiki_, _ফেব্, been, اءً_, 
   {{0xf1d0001b,0x27e608ec,0x64a601a2,0x6d550035}},	//   _bạch_, nkon_, _маҷа, wcza, 
   {{0xf19400c8,0xf1d00210,0x00000000,0x00000000}},	//   _жиль, _cạch_, --, --, 
   {{0xdb0f00b9,0x7a2b0241,0x752402d9,0x27e608ed}},	//   _oncò, gütl, řizu, hkon_, 
   {{0x200208ee,0x321e01a7,0x6d550035,0x24510023}},	//   biki_, moty_, rcza, _xám_, 
   {{0x69c7027c,0x1bd408ef,0xe50d017d,0x394a0502}},	//   _snje, нося, िपति_, _agbs_, 
   {{0xf1d000e7,0x2477020f,0x49d908f0,0x00000000}},	// [470] _gạch_, zăm_, одаю_, --, 
   {{0x2fc90201,0x8af00095,0x20b008f1,0xceb40486}},	//   _hnag_, vbət, _जनाध, _טיפ_, 
   {{0x63a908f2,0x67d508f3,0x765b039b,0x2fc90175}},	//   yeen, можу, _stuy, _knag_, 
   {{0xdb0f08f4,0x321e08f5,0x2a60006d,0x27e608f6}},	//   _hací, hoty_, bpib_, gkon_, 
   {{0x2451026e,0x321e08f7,0x63a908e6,0x9f4b0369}},	//   _sám_, koty_, veen, licó_, 
   {{0x200208f8,0x27e608f9,0x247700b3,0x69c70372}},	//   ziki_, akon_, tăm_, _unje, 
   {{0x588408fa,0x63a908fb,0xdb0f001d,0x9f4b0369}},	//   _пыта, teen, _mací, nicó_, 
   {{0x245108fc,0x7a3008fd,0x247700b3,0xf8b200d1}},	//   _vám_, mäta, răm_, _בשל_, 
   {{0x63a901a6,0x765b0199,0x27ed0096,0x2477020f}},	//   reen, _utuy, _ilen_, săm_, 
   {{0x1306030f,0x81bc00e0,0x2451001b,0x63a908fe}},	//   ьный_, blēm, _tám_, seen, 
   {{0x200208ff,0x66030900,0xf1d0001b,0xdb060218}},	//   tiki_, mink, _sạch_, _bakû, 
   {{0x9f4b05b9,0x2fc90901,0x351a0070,0x00000000}},	//   dicó_, _cnag_, _ווענ, --, 
   {{0x20020902,0x62890903,0xddcd08b1,0x8af006d0}},	//   riki_, queo, _svaš, hbər, 
   {{0x66030904,0xc33200a7,0x9f4b05b9,0xdca60307}},	//   nink, _סוג_, ficó_, маги, 
   {{0x27ed0905,0x80160906,0x81bc00e0,0x20020907}},	//   _olen_, _офиц, klēj, piki_, 
   {{0x2d840908,0x66030909,0xbf9b019c,0x22470844}},	//   şme_, hink, liên, _hink_, 
   {{0x6603090a,0xdb0f0496,0x78a9090b,0x2247090c}},	// [480] kink, _fací, _ćeva, _kink_, 
   {{0xceb40264,0x6603090d,0x27ed0588,0x6286090e}},	//   _isə_, jink, _alen_, škog, 
   {{0x6603090f,0x2fc90910,0xe4f4031e,0x27e60911}},	//   dink, _ynag_, ेपछि_, tkon_, 
   {{0xbf9b0023,0xfbdf0023,0x9f4b02a3,0x69d90216}},	//   hiên, _hiên_, licò_, êwer, 
   {{0x27e60912,0x22470913,0xfbdf00e7,0xdb1d055f}},	//   rkon_, _oink_, _kiên_, _ansæ, 
   {{0x27e60914,0x27ed0915,0x27ff0916,0x22470175}},	//   skon_, _elen_, _emun_, _nink_, 
   {{0xdcfe01f0,0xbf9b02a0,0x69dc01a7,0x27ed0917}},	//   _kapı, diên, _iore, _flen_, 
   {{0x69dc0918,0xfbdf00f7,0x21e90126,0x2247002c}},	//   _hore, _liên_, _búho_, _aink_, 
   {{0x51860919,0x12be0033,0x232702a6,0x7ae4091a}},	//   муна, েন্দ, моћи_, nyit, 
   {{0xfbdf001b,0x6603091b,0x958300b3,0x70c9017d}},	//   _niên_, cink, _алфе, िमूल, 
   {{0x69dc091c,0x22470691,0x27ed00c8,0x9f4b02a3}},	//   _more, _dink_, _ylen_, dicò_, 
   {{0xd011091d,0x321e091e,0xdce70083,0x926a0165}},	//   الح_, soty_, nają, _дрка_, 
   {{0xe81f000c,0x3f85091f,0x22470920,0xfbdf001b}},	//   यकता_, ğlu_, _fink_, _biên_, 
   {{0xbf9b02a0,0x69dc00fc,0x9f4b0369,0x06e10086}},	//   ciên, _nore, ticó_, _মেডি, 
   {{0x62860921,0xdb0f08f4,0x76480922,0xdce70035}},	//   škod, _vací, _midy, kają, 
   {{0xdb0d02a0,0x69dc0054,0x683102ae,0x1bb80038}},	//   ndaç, _aore, kåda, واقع_, 
   {{0x66030923,0x63a20924,0x5a350925,0xdce700ab}},	// [490] yink, _mbon, енат, dają, 
   {{0x69dc0926,0xddc40704,0x7e6d0927,0x27ff011c}},	//   _core, _zviž, _iwap, _smun_, 
   {{0x66030928,0x69dc0929,0x27ed06df,0x3d10009a}},	//   vink, _dore, _plen_, णपणे_, 
   {{0xdd0d00ab,0x6603092a,0x7e6d092b,0xdce70035}},	//   półp, wink, _kwap, gają, 
   {{0x69dc092c,0x660300e4,0x3669092d,0xf7700625}},	//   _fore, tink, чало_, شان_, 
   {{0x69dc092e,0x7e6d092f,0xfbdf0108,0x04b500fd}},	//   _gore, _mwap, _xiên_, есия, 
   {{0xdcfe0792,0xa3e3007e,0x66030930,0x76480931}},	//   _yapı, _नकद_, rink, _didy, 
   {{0x66030932,0x69dc0933,0xdb060228,0x7e6d045a}},	//   sink, _zore, _rakú, _owap, 
   {{0x69c4034d,0x3d0604d7,0xc2450934,0x7bdd0935}},	//   राची, _हेने_, нник, _mosu, 
   {{0xdb1d014e,0x69dc0287,0x7bdd0936,0x70e701a2}},	//   _insä, _xore, _losu, дгоҳ_, 
   {{0xbf9b03b7,0x672902a2,0x7e6d0937,0x2000016a}},	//   riên, _hyej, _awap, _pmii_, 
   {{0x6e250938,0x7bdd0939,0x60dc0219,0x34bd093a}},	//   _akhb, _nosu, ärma, ्मीद, 
   {{0x63bb093b,0x6264004f,0xbf9b02be,0x63b9017c}},	//   mdun, _авіа, piên, _iawn, 
   {{0x63bb093c,0xf1d0001b,0x4095093d,0x63b9003d}},	//   ldun, _hạnh_, _зрит, _hawn, 
   {{0xdca3093e,0xfbdf00f7,0x3205093f,0x7bdd0940}},	//   лари, _viên_, mily_, _bosu, 
   {{0x63bb0757,0xc4d20137,0x7bdd00d9,0x6724003d}},	//   ndun, נגן_, _cosu, żiji, 
   {{0x69dc00f1,0x629b08fa,0xfbdf0029,0xf1d00029}},	// [4a0] _pore, ntuo, _tiên_, _mạnh_, 
   {{0xf1d00029,0x81e10086,0x0d220161,0xdce70035}},	//   _lạnh_, নোর_, _бүгү, wają, 
   {{0x69dc0941,0xdcfe0785,0xdce70035,0xdb1d0380}},	//   _vore, _tapı, tają, _ansä, 
   {{0x7648012b,0x629b0009,0x6729052b,0xe73a0942}},	//   _sidy, ktuo, _byej, пее_, 
   {{0x69dc0943,0x63bb0944,0xdce70035,0x7c2600c3}},	//   _tore, ddun, rają, _ikkr, 
   {{0xb90600cc,0x629b012b,0x7bdd0945,0x68310946}},	//   _বই_, dtuo, _zosu, råda, 
   {{0x7bdd0947,0x06d80086,0x76480948,0x68e100b0}},	//   _yosu, _দেখি, _vidy, _üldp, 
   {{0xf1d0001b,0x76480949,0x3266094a,0x63bb0008}},	//   _cạnh_, _widy, нтов, gdun, 
   {{0x63b9094b,0x3205014b,0x7648094c,0x629b02dc}},	//   _dawn, fily_, _tidy, gtuo, 
   {{0xa2b1094d,0x75280035,0x26c401d6,0x51f70080}},	//   _अनर्, _tydz, _irmo_, енью_, 
   {{0x681500ab,0xdb1d0219,0x63b9094e,0xdb0f007a}},	//   ląda, _inså, _fawn, _macá, 
   {{0x63a2094f,0x20d50028,0x26c40144,0x22990950}},	//   _ubon, džią_, _krmo_, bèk_, 
   {{0x91e60951,0x2d850952,0x32050953,0x629b0954}},	//   _поде, óleo_, bily_, ctuo, 
   {{0x92f203c0,0x7bdd0955,0x00000000,0x00000000}},	//   ığım, _sosu, --, --, 
   {{0xe57100c7,0x63b90956,0x23c4017d,0x44260957}},	//   יַן_, _yawn, _वफाद, _kko_, 
   {{0xb5fd0226,0x44260604,0x7e6d0958,0x00000000}},	//   _itše, _jko_, _twap, --, 
   {{0xbbe10586,0x7e6d0959,0x4426095a,0xafdb02c9}},	// [4b0] _नवीक, _uwap, _mko_, rmød, 
   {{0x99990009,0x3ea9011c,0xafdb02c9,0x7bdd0532}},	//   _rusų_, _ipat_, smød, _wosu, 
   {{0x442602f5,0xa775095b,0x78ba0187,0x7bdd095c}},	//   _oko_, влеч, _štvr, _tosu, 
   {{0x4426095d,0xdb1d0219,0x6b670107,0xfbdf0023}},	//   _nko_, _anså, _dégâ, _kiêm_, 
   {{0x7c2d095e,0x212b00e7,0x69c1095f,0x8af000ad}},	//   mlar, ́ch_, _óleo, ncəl, 
   {{0x44260960,0x7c2d0961,0xeb9f02fb,0xe5a50962}},	//   _ako_, llar, _gjør_, тики, 
   {{0x32050963,0x34bd0964,0x97a70965,0xfbdf0023}},	//   vily_, ्मेद, _прал, _liêm_, 
   {{0x7c2d0966,0x3ea9005f,0x629b0967,0xd6d80086}},	//   nlar, _opat_, ttuo, _দেওয, 
   {{0x63bb0968,0x7c2d01f1,0x44260969,0x60dc0219}},	//   rdun, ilar, _dko_, ärmn, 
   {{0x3d1a006a,0x4426096a,0x7c2d096b,0x229200c5}},	//   _मुझे_, _eko_, hlar, گلیس, 
   {{0x7c2d096c,0x3205096d,0x629b096e,0x23e700dd}},	//   klar, rily_, stuo, _підв, 
   {{0x7c2d096f,0xdee602f1,0x32050970,0x442600b4}},	//   jlar, воми, sily_, _gko_, 
   {{0x443f0971,0x7c2d0972,0x442d0973,0x644b0102}},	//   mmu_, dlar, mle_, _iigi, 
   {{0x644b0974,0x3ea90975,0x7c2d0976,0x600b00c8}},	//   _higi, _dpat_, elar, tömä, 
   {{0x442d0977,0xed570978,0x7c2d0979,0x644b097a}},	//   ole_, тос_, flar, _kigi, 
   {{0x2d81097b,0x7c2d097c,0x443f097d,0xb7bc00cc}},	//   _edhe_, glar, nmu_, _অক্ট, 
   {{0x442d006c,0x443f097e,0xdb0f00eb,0x8c43097f}},	// [4c0] ile_, imu_, _pacá, рете, 
   {{0x644b0980,0x442d0981,0x443f0982,0x7c2d0983}},	//   _ligi, hle_, hmu_, alar, 
   {{0x7c2d0984,0x443f0985,0x442d0986,0x81c30033}},	//   blar, kmu_, kle_, _একা_, 
   {{0x443f024c,0x442d0987,0x18670988,0x644b0989}},	//   jmu_, jle_, таци_, _nigi, 
   {{0x442d000d,0x443f098a,0x96960141,0x6d5c098b}},	//   dle_, dmu_, треш, ocra, 
   {{0x442600c1,0x7c240742,0x443f098c,0x6289098d}},	//   _sko_, loir, emu_, dreo, 
   {{0x644b098e,0x69ce098f,0xeb9f00dd,0x44260990}},	//   _bigi, _inbe, _kjøp_, _pko_, 
   {{0x68e30991,0x644b0992,0xe4e300dd,0x53340993}},	//   ände, _cigi, рішн, лейт, 
   {{0x644b0994,0xf7430995,0xb27300d3,0x44260996}},	//   _digi, _вето, алыш, _vko_, 
   {{0x442d0997,0x7c2d0998,0x644b0999,0xdb0403da}},	//   ale_, zlar, _eigi, ndiñ, 
   {{0x442d099a,0x4426099b,0x7c2d099c,0xf99300a7}},	//   ble_, _tko_, ylar, ברת_, 
   {{0x4426099d,0x442d099e,0x644b099f,0x628909a0}},	//   _uko_, cle_, _gigi, breo, 
   {{0x7c2409a1,0x69ce09a2,0x7c2d09a3,0x68380183}},	//   doir, _onbe, vlar, cíde, 
   {{0x82770137,0x644b09a4,0xfbdf001b,0x2458001b}},	//   _יעדע_, _zigi, _viêm_, _kém_, 
   {{0x7c2d09a5,0x2bc40827,0x2d5809a6,0x644b09a7}},	//   tlar, _लोहा, тись_, _yigi, 
   {{0x69ce09a8,0x0a6b0843,0xfbdf00e7,0x6c6a0019}},	//   _anbe, држи_, _tiêm_, علقہ_, 
   {{0x7c2d09a9,0x3b5409aa,0x644000c8,0x3ea902dc}},	// [4d0] rlar, ркур, immi, _upat_, 
   {{0x7c2d0848,0x442409ab,0x442d09ac,0x7e7d09ad}},	//   slar, hom_, zle_, mssp, 
   {{0x442d09ae,0x7c2d096f,0x7c2409af,0x443f09b0}},	//   yle_, plar, boir, ymu_, 
   {{0x7c2d09b1,0x442409b2,0xb8db09b3,0xe679005e}},	//   qlar, jom_, _अन_, ейді_, 
   {{0x442d0343,0xc1780009,0x6d4800ca,0x644b09b4}},	//   vle_, nkės_, ždat, _rigi, 
   {{0x683809b5,0xdb0600bc,0x69d80019,0x1a6800d4}},	//   víde, _jaký, övet, _شیمی_, 
   {{0x442d09b6,0x443f09b7,0x18b80088,0x58d409b8}},	//   tle_, tmu_, _игры_, _корт, 
   {{0x442402f5,0x442d09b9,0x628909ba,0x443f09bb}},	//   gom_, ule_, treo, umu_, 
   {{0x442d09bc,0x644b09bd,0x11d900eb,0xd175001c}},	//   rle_, _vigi, فوظة_, лыны, 
   {{0x442d09be,0x443f09bf,0xe0d90665,0x628909c0}},	//   sle_, smu_, ево_, rreo, 
   {{0x442d09c1,0x443f09c2,0x644b09c3,0x33950019}},	//   ple_, pmu_, _tigi, _ملاز, 
   {{0x442409c4,0x644b09c5,0x683809c6,0x442d09c7}},	//   com_, _uigi, píde, qle_, 
   {{0x21a502f1,0x7c24026a,0x7e7d09c8,0x3f9e0035}},	//   _билм, voir, gssp, ętu_, 
   {{0x7bcf09c9,0x645c02aa,0xdb0409ca,0x86350070}},	//   _ancu, _éric, leiç, טאָג_, 
   {{0x7c24026d,0x0c79058b,0x201909cb,0x6d5c09cc}},	//   toir, ксты_, éric_, rcra, 
   {{0x6d5c09cd,0xf09200d1,0x00000000,0x00000000}},	//   scra, _הנה_, --, --, 
   {{0x7c2409ce,0x00000000,0x00000000,0x00000000}},	// [4e0] roir, --, --, --, 
   {{0x7bcf09cf,0x7c2409d0,0x7a2b00c2,0x00000000}},	//   _encu, soir, kütu, --, 
   {{0xfaa302b9,0x2fd700c5,0xdb0409d1,0x7c2409d2}},	//   _қаро, _شوید_, rdiñ, poir, 
   {{0x78800076,0x27e0010d,0x61e009d3,0x442409d4}},	//   _návš, ðin_, _पक्ष, xom_, 
   {{0x4a7509d5,0x442409d6,0x2bd109d7,0xfbd109d8}},	//   _выст, vom_, हारा, हारम, 
   {{0x69ce02f2,0x442402dc,0x7e64019b,0x490409d9}},	//   _unbe, wom_, _mtip, _күзг, 
   {{0xdb040165,0xa3cf0299,0xb4ce00bd,0x344a00b9}},	//   feiç, शां_, शमे_, нчин_, 
   {{0xd90d00c5,0x644000ef,0x3a2a06d7,0x7e6409da}},	//   _تیم_, ummi, _hkbp_, _otip, 
   {{0x81bc002a,0x644009db,0x659609dc,0x00000000}},	//   klēt, rmmi, _مجار, --, 
   {{0x442409dd,0x506600b9,0x683800bc,0x245809de}},	//   som_, лтма, bídc, _tém_, 
   {{0x442409df,0xf99300a7,0xddcd09e0,0x30a30093}},	//   pom_, זרת_, _ataş, бряв, 
   {{0xde59012d,0x7e7d09e1,0x1e1d09e2,0x442401ff}},	//   камі_, tssp, पक्ष_, qom_, 
   {{0xbb1b0474,0x81e30033,0x00000000,0x00000000}},	//   _adîn, _নগর_, --, --, 
   {{0xdb070019,0x7e7d098d,0xdb06010e,0x52830038}},	//   ámít, rssp, _lakó, _الوك, 
   {{0x403509e3,0x9f520118,0x709409e4,0x00000000}},	//   _кекс, _olyè_, _тайф, --, 
   {{0xf1d209e5,0x3a2a02a2,0x7a300228,0x7a2b0380}},	//   तावन, _akbp_, bätk, hütt, 
   {{0x200b09e6,0x497509e7,0xdb060228,0x397500a3}},	// [4f0] mici_, илас, _taký, илаё, 
   {{0xdd9109e8,0xd91b09e9,0x2c510083,0x00000000}},	//   _بود_, нье_, _sądu_, --, 
   {{0x87e70995,0xd7e703bd,0x00000000,0x00000000}},	//   люде, лідо, --, --, 
   {{0x200b090b,0xff5f010c,0x7bcf09ea,0x69d809eb}},	//   nici_, ncî_, _uncu, över, 
   {{0x7c3a0107,0xb5fd0009,0xdb1d0034,0x6fa709ec}},	//   ître, _atša, _masë, ट्यू, 
   {{0x487709ed,0xdb0e008c,0x7bd70009,0x200b09ee}},	//   _مدرس, _þjál, šbuč, hici_, 
   {{0xdb1d055f,0x200b027e,0x25b60038,0x00000000}},	//   _ansø, kici_, شهيد_, --, 
   {{0x73e5093d,0xd6d8004e,0x69c909ef,0x28e200c2}},	//   роиз, _өту_, _होती, पहरि, 
   {{0x200b09f0,0x221509f1,0x45d500bf,0x628609f2}},	//   dici_, ифор, _коас, škon, 
   {{0x9f5902a3,0x7a3000c8,0x02050176,0xdb060118}},	//   misù_, vätk, рзон, _kakò, 
   {{0x200b09f3,0xa0a509f4,0x7e6409f5,0x3f6a09f6}},	//   fici_, шанд, _stip, кино_, 
   {{0x76430110,0x200b09f7,0xf3f10108,0x2cba0175}},	//   lmny, gici_, _dục_, _rspd_, 
   {{0x32630019,0x32670207,0xdb060300,0xd343009c}},	//   _انتہ, _стев, _lakò, _افشی, 
   {{0x61450623,0x7e64026e,0x3f8c00ad,0x00000000}},	//   _кела, _vtip, şdu_, --, 
   {{0x443d006f,0x7643016a,0x61e309f8,0x1d0709f9}},	//   _khw_, imny, _ionl, аери_, 
   {{0x200b05ae,0x61e30019,0xab6609fa,0x78450028}},	//   cici_, _honl, рвал, _tėvy, 
   {{0x395600ce,0x7a2b0019,0xda650038,0x1a0609fb}},	// [500] ањет, yütt, مالي, апам, 
   {{0xada602f1,0x2fc000f6,0xdb060118,0xdb1d09fc}},	//   _таол, _haig_, _bakò, _masè, 
   {{0x61e300b9,0xd82609fd,0xdb1d0237,0x443d039b}},	//   _monl, аджи, _lasè, _ohw_, 
   {{0xb8ce05fd,0x443d02bf,0xb8fe0790,0x2d9806df}},	//   _कह_, _nhw_, _तप_, lgre_, 
   {{0x2fc00161,0xddd6026e,0x660a02f6,0xb866010e}},	//   _maig_, _zvyš, tifk, _چارو, 
   {{0x2d9809fe,0x200b031e,0x2fc009ff,0x645e0165}},	//   ngre_, zici_, _laig_, ípio, 
   {{0x443d02cd,0x200b0384,0x9f4200c8,0x3ea0008a}},	//   _bhw_, yici_, lkkä_, _lqit_, 
   {{0x25a90112,0xe8d700a7,0x76430a00,0xdb1d0542}},	//   đala_, _דולר_, amny, _basè, 
   {{0x61e30a01,0x78af090e,0x9f4902b7,0x68380183}},	//   _bonl, čivš, _ilaç_, cída, 
   {{0xc05a0a02,0x61e30a03,0x00000000,0x00000000}},	//   кім_, _conl, --, --, 
   {{0x61e30a04,0x3a3700a7,0x39570486,0x2fc002a5}},	//   _donl, שרים_, ישים_, _baig_, 
   {{0x2fc0006d,0xdb1d0118,0xf42700b3,0x00000000}},	//   _caig_, _fasè, _кохл_, --, 
   {{0x200b0a05,0x2fc00a06,0x00000000,0x00000000}},	//   rici_, _daig_, --, --, 
   {{0x62820a07,0x62800844,0x9f490a08,0x2d850212}},	//   _ivoo, msmo, _llaç_, ûle_, 
   {{0x52b60a09,0x02b60827,0x6e270a0a,0x200b0a0b}},	//   _अनुस, _अनुन, rojb, pici_, 
   {{0x3b550a0c,0xd0f700d1,0x2fc000b9,0x61e30a0d}},	//   скар, _כמות_, _gaig_, _zonl, 
   {{0xa3a80a0e,0xdb1d0a0f,0xab390a10,0x61fa01a4}},	// [510] ख्य_, _kasé, упау_, ohtl, 
   {{0xf9930625,0x6838031e,0x98c70a11,0x320c023a}},	//   تبر_, vída, исел, nidy_, 
   {{0xdb1d0a12,0x2fc00201,0xb9c40038,0x00000000}},	//   _masé, _yaig_, تقلي, --, 
   {{0x3f990a13,0x62800a14,0x38c800f6,0x320c01a7}},	//   ngsu_, ksmo, шуун_, hidy_, 
   {{0x6fd800a2,0x443d0226,0x27e4020f,0x320c01a7}},	//   यातू, _rhw_, _domn_, kidy_, 
   {{0x76430870,0xe29901a2,0xdb1d0096,0x96210299}},	//   umny, ҳаи_, _nasé, यवेट_, 
   {{0xfc3f0029,0x7aed0a15,0x764302a2,0x320c0180}},	//   _khí_, lyat, rmny, didy_, 
   {{0x24890a16,0xe3b90a17,0x81c30086,0x61e30a18}},	//   čam_, уби_, _একই_, _sonl, 
   {{0xfc3f00eb,0x320c00a9,0x62800a19,0xf1d200a2}},	//   _mhí_, fidy_, gsmo, तांन, 
   {{0x673b0a1a,0x7a300a1b,0x20090a1c,0x61fa00d1}},	//   _izuj, täti, _amai_, ghtl, 
   {{0x7aed016a,0xdb1d0175,0x62800326,0x61e30a1d}},	//   hyat, _dasé, asmo, _vonl, 
   {{0xfc3f00e7,0xfbdf0023,0x7a300a1e,0xafdb0a1f}},	//   _nhí_, _kiêu_, räti, smøn, 
   {{0x2fc000d3,0x7a300088,0x320c0180,0x0cd00a20}},	//   _vaig_, säti, bidy_, हम्म, 
   {{0x61fa0a21,0xfc3f0a22,0x7aed0a23,0xdb0f0068}},	//   chtl, _ahí_, dyat, _facú, 
   {{0x4095057f,0xfc3f057f,0x2fc00201,0xfbdf0023}},	//   _العر, _bhí_, _taig_, _liêu_, 
   {{0x3ce5022b,0xfc3f0029,0x7ff60a24,0x798703a0}},	//   älva_, _chí_, _دستا, _adjw, 
   {{0x68e30a25,0xbb430a26,0x44c70108,0x7aed039f}},	// [520] ändn, зетк, _lđ_, gyat, 
   {{0xc3320056,0x200e00ab,0x27e400b3,0xddcd014b}},	//   לון_, ślić_, _somn_, _zvaž, 
   {{0xe93a0843,0x224b0228,0x6cc601ff,0x44c70023}},	//   учај_, ícky_, _уйна, _nđ_, 
   {{0xd49a0a27,0x62800a28,0x8b96004f,0x60dc02ae}},	//   ҳри_, ysmo, _уроч, ärmi, 
   {{0x661a016a,0x673b0035,0x7aed007c,0x683800bc}},	//   _pjtk, _czuj, cyat, bídn, 
   {{0x99d6024f,0xd49a0a29,0x600f05d5,0xdb1d010c}},	//   _اتحا, гри_, _kòmè, _kasî, 
   {{0x320c0180,0x7589004f,0x44c700e7,0xdb1d0212}},	//   vidy_, рсів_, _cđ_, _rasé, 
   {{0x7bc40a2a,0xc7a30a2b,0x62800a2c,0x628606a3}},	//   ndiu, _ниск, tsmo, škom, 
   {{0x6aa40a2d,0x200900e2,0x6d43014b,0xdb1d0a2e}},	//   ntif, _rmai_, _únav, _pasé, 
   {{0x60ca02a2,0x62800a2f,0x20090065,0xaac900bc}},	//   _prfm, rsmo, _smai_, रितक, 
   {{0xdb1d009e,0x201902a0,0x320c0a30,0x44c70108}},	//   _nasî, ério_, ridy_, _gđ_, 
   {{0x6aa404bb,0x7aed06d0,0xf53700a7,0xdb0f0042}},	//   ktif, yyat, _פנאי_, _vacú, 
   {{0x657a009c,0x733600d4,0xdef80a31,0x645a0a32}},	//   _keth, _ارائ, быр_, _huti, 
   {{0x329b0a33,0xe7cf0a34,0x7aed0a35,0xacf90a36}},	//   _עבוד, _सोनप, vyat, ангу_, 
   {{0xf1a900c5,0xfc3f0029,0xfbab09d9,0x657a0a37}},	//   _خانه_, _phí_, лтай_, _meth, 
   {{0x645a0a38,0x657a0a39,0x317e01c4,0xdb16078a}},	//   _muti, _leth, latz_, meyê, 
   {{0x645a0a3a,0x1a5b00eb,0xdb16010c,0x7aed0532}},	// [530] _luti, اشرة_, leyê, uyat, 
   {{0x645a026d,0xa3a80586,0x9f4b02d9,0x600f05d5}},	//   _outi, ख्त_, nkcí_, _fòmè, 
   {{0xe8e00124,0x2bc40a3b,0xfbdf0023,0x317800ab}},	//   ười_, _लोका, _siêu_, órzy_, 
   {{0x317e0a3c,0x657a017c,0x47350a3d,0x00000000}},	//   hatz_, _aeth, онес, --, 
   {{0x657a0a3e,0x6aa40a3f,0xe70b00d4,0x3f890548}},	//   _beth, ctif, دتان_, _mdau_, 
   {{0x645a0a40,0x25a90112,0x63ab0065,0x657a009c}},	//   _buti, đalo_, _sbgn, _ceth, 
   {{0x69d50a41,0x645a0a42,0xe7870a43,0x8ccc0a44}},	//   _inze, _cuti, _гузо, हियो, 
   {{0xfbdf0029,0xdb16010c,0x657a01d2,0x61f801d2}},	//   _tiêu_, deyê, _eeth, _alvl, 
   {{0xe1f90a45,0x6fdd00a2,0x657a0a46,0xdb1d0a47}},	//   иги_, यानं, _feth, _insó, 
   {{0x69c50a48,0x26cd0a49,0x657a0a4a,0x645a0a4b}},	//   ndhe, _ireo_, _geth, _futi, 
   {{0xf9920a33,0x69c5004c,0x645a0a4c,0x7a300088}},	//   ורי_, idhe, _guti, mätt, 
   {{0x7a300a4d,0x26cd0a4e,0x777b026a,0x81bc00e0}},	//   lätt, _kreo_, _jeux, slēp, 
   {{0x3f890156,0x69d50a4f,0x645a087d,0x2bc4034d}},	//   _ddau_, _onze, _zuti, _लोगा, 
   {{0x2019046e,0x317e018e,0xdb160216,0xdb1d0216}},	//   ansi_, catz_, beyê, _pasî, 
   {{0x69c503c6,0x68e30380,0xb147009c,0x27150a50}},	//   ddhe, ändl, _دیدم_, तपुर_, 
   {{0x69d50a51,0x7a300a52,0x6aa40a53,0x63a90a54}},	//   _anze, hätt, ttif, nfen, 
   {{0xb4b60351,0xfaa30a55,0x7bc40a56,0x6aa40a57}},	// [540] _छन्_, мато, rdiu, utif, 
   {{0x69c50a58,0xe9d70a59,0x8eb30019,0x99630098}},	//   gdhe, оку_, _کمیش, _píšu_, 
   {{0x02b60239,0xd9100a5a,0x657a0a5b,0x26cd0054}},	//   _अन्न, ریر_, _reth, _areo_, 
   {{0x657a0a5c,0x26cd0183,0x5fdd00a2,0x69c50a5d}},	//   _seth, _breo_, यायल, adhe, 
   {{0xaa46032e,0x26cd0a5e,0x645a0a5f,0x777b026a}},	//   _мемл, _creo_, _suti, _deux, 
   {{0x7c36003e,0x63a90a60,0x26cd0379,0xdb1d023a}},	//   llyr, efen, _dreo_, _masì, 
   {{0x63a90a61,0x5fca09e5,0x26cd0054,0x645a01ff}},	//   ffen, ियाल, _ereo_, _quti, 
   {{0x657a01c8,0x26cd0068,0x442f0065,0x63a90156}},	//   _weth, _freo_, _ckg_, gfen, 
   {{0xdb16009e,0x26cd012b,0x442f0a62,0x7a300844}},	//   weyê, _greo_, _dkg_, bätt, 
   {{0x914a0a63,0x645a0a64,0xdb16010c,0x15460a65}},	//   ична_, _tuti, teyê, _дезм, 
   {{0x645a030f,0x425400d4,0x96c207d5,0x53a60a66}},	//   _uuti, _کنتر, लिकॉ, _мажб, 
   {{0x317e01c4,0xdb160218,0x765b02a5,0x00000000}},	//   satz_, reyê, _yuuy, --, 
   {{0x41e6012d,0x238c0028,0x531600d7,0x386a0354}},	//   _міка, gėjų_, _بذار, _ltbr_, 
   {{0x81f80a67,0xc6930225,0x3f8401d5,0x00000000}},	//   _دفتر_, ואש_, ómur_, --, 
   {{0x271c0029,0x71260038,0x1bd500fd,0x00000000}},	//   ỉnh_, _برشل, повя, --, 
   {{0x602402a6,0xdfd10038,0x929d0083,0x00000000}},	//   _одја, _أية_, szłe, --, 
   {{0x34b70a68,0x64420a69,0xdb1d0237,0x8af000ad}},	// [550] _आन्द, _mhoi, _ansò, dcəs, 
   {{0x78a5010d,0x69c501d2,0x59d20501,0x00000000}},	//   tthv, udhe, सागर, --, 
   {{0x26cd090b,0x69c50a6a,0x62860098,0xd7590a6b}},	//   _sreo_, rdhe, škoh, ملات_, 
   {{0x76410a6c,0x69c50034,0x78a50a6d,0x00000000}},	//   _shly, sdhe, rthv, --, 
   {{0x2bc40081,0x7c2d0074,0x7bda00a7,0x7a300a1b}},	//   _लोटा, moar, _הקרו, tätt, 
   {{0x7c2d0a6e,0x26cd00d9,0x1dcb045b,0x236600ca}},	//   loar, _vreo_, ायित, _afoj_, 
   {{0x7a300a6f,0x644202d0,0x6ab90095,0xdb1d0a70}},	//   rätt, _bhoi, şafı, _masí, 
   {{0x7a300a6f,0x57b40a71,0x64420a72,0x7c2d0a73}},	//   sätt, _обст, _choi, noar, 
   {{0xd5bb0a74,0x64420a75,0x63a90a76,0x7c2d01cf}},	//   _все_, _dhoi, rfen, ioar, 
   {{0x7c2d0a77,0xdb0d0a78,0x63a90a79,0x13060080}},	//   hoar, ndañ, sfen, яный_, 
   {{0xf99207f5,0x64420544,0x7c2d02ba,0x3eb20a7a}},	//   ערט_, _fhoi, koar, _spyt_, 
   {{0xb4d70a7b,0xa3bb0a7c,0x64420a69,0x442f02a2}},	//   ामी_, _خاطر_, _ghoi, _ukg_, 
   {{0x7c2d0a7d,0x64490a7e,0x317c0604,0x00000000}},	//   doar, mmei, _fevz_, --, 
   {{0x442d0149,0x64490a7f,0xfce60a80,0x238c0028}},	//   loe_, lmei, пого, rėjų_, 
   {{0x1fb60a81,0xdb060054,0xe6b80527,0x7c2d0a82}},	//   _еспр, _lakô, _इन्ज, foar, 
   {{0x442d0a83,0x644901c5,0x1e860a84,0x7c2d0a85}},	//   noe_, nmei, _елим, goar, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [560] --, --, --, --, 
   {{0x3f820a86,0x442d0a87,0xff5f010c,0xdcfc0a88}},	//   laku_, hoe_, ndîn_, larč, 
   {{0x23bd0367,0x442d0a89,0x6e2e0a8a,0x9f590327}},	//   ्याद, koe_, mobb, cisó_, 
   {{0x3f820a8b,0x442d07d7,0x7a3001c4,0xdb1d00bc}},	//   naku_, joe_, täts, _zasí, 
   {{0x5fdd00a2,0x442d0a8c,0x644900b0,0xfbb900bc}},	//   यातल, doe_, dmei, उजरम, 
   {{0x7bc60a8d,0xe5340a8e,0x64420a8f,0x3f820a90}},	//   _haku, мель, _shoi, haku_, 
   {{0x7bc60a91,0x64420a92,0x3f82024a,0x75fd05d5}},	//   _kaku, _phoi, kaku_, _bèzb, 
   {{0x293700c7,0x442d07d7,0x7bc60a93,0x00000000}},	//   _זאלן_, goe_, _jaku, --, 
   {{0x3f820a94,0xdb0d003e,0x64a000ca,0xdcfc0a95}},	//   daku_, ndað, dšiš, darč, 
   {{0x7bc60a96,0x7c2d0a97,0x6e2e0a98,0x64420a99}},	//   _laku, zoar, jobb, _whoi, 
   {{0x64420a9a,0x5f950a9b,0x6e2e0a9c,0x3f820a9d}},	//   _thoi, минт, dobb, faku_, 
   {{0x3f820a9e,0x04db00a7,0x442d0026,0x7c2d0a9f}},	//   gaku_, _לקבל, coe_, xoar, 
   {{0x7c2d0aa0,0x63a20139,0xdb0d02aa,0xdb1d0aa1}},	//   voar, _icon, meaç, _pasí, 
   {{0x91e30aa2,0x61140aa3,0x7bc6044d,0x60dc02ae}},	//   _поче, _одлу, _aaku, ärms, 
   {{0x7c2d0aa4,0x7bc60aa5,0x313301a2,0x6fa5009a}},	//   toar, _baku, _пешр, _कापू, 
   {{0x7bc60aa6,0x2c0d00a2,0x61ea0aa7,0x6c540aa8}},	//   _caku, _सगळं_, _hofl, ексу, 
   {{0x4a550aa9,0x7c2d0a9f,0x7bc60aaa,0x645c0036}},	// [570] дкас, roar, _daku, _èrif, 
   {{0x7c2d0aab,0x6838000d,0xa2bf0aac,0x61ea02fe}},	//   soar, bídk, _वनस्, _jofl, 
   {{0x7bc60aad,0x2d830aae,0x63a20aaf,0x7c2d0ab0}},	//   _faku, maje_, _ocon, poar, 
   {{0x2d9c0750,0x27e906b6,0x65680ab1,0x2d830ab2}},	//   _över_, ðan_, _afdh, laje_, 
   {{0x6fa50ab3,0x442d0ab4,0x7e6900d9,0x76ab0ab5}},	//   _कानू, voe_, _împă, стев_, 
   {{0x7bc60ab6,0x2d830ab7,0xdb1d0054,0xdcfc0352}},	//   _zaku, naje_, _iasà, zarč, 
   {{0xb4d70790,0x3f82011c,0x64490ab8,0x00000000}},	//   ामे_, yaku_, tmei, --, 
   {{0x683101e8,0x588500f0,0x3cfc0ab9,0x2d830aba}},	//   råds, _ныға, מלונ, haje_, 
   {{0x69c70abb,0x64490abc,0x26cb06e6,0xdcfc0abd}},	//   _kaje, rmei, _éco_, varč, 
   {{0x63a20abe,0x442d0364,0x64490abf,0x78a10219}},	//   _econ, soe_, smei, _älvs, 
   {{0x3f820ac0,0x7e6d0ac1,0x442d0ac2,0x61ea0a4e}},	//   taku_, _atap, poe_, _dofl, 
   {{0x69c70ac3,0x63a20038,0x683802d9,0x00000000}},	//   _laje, _gcon, vídk, --, 
   {{0x3f820ac4,0x63bb0ac5,0xb5fd00ec,0xcb0c0299}},	//   raku_, meun, _atši, _सेंड_, 
   {{0x7bc60ac6,0x69c70ac7,0x63bb0ac8,0x2d830ac9}},	//   _saku, _naje, leun, gaje_, 
   {{0xed570aca,0x7bc60acb,0xdca30acc,0x6286014b}},	//   дор_, _paku, кари, ákov, 
   {{0x63bb005f,0xaac907d5,0xdb1d0379,0x8c430acd}},	//   neun, रिंक, _basà, весе, 
   {{0x69c70ace,0x7bc60acf,0xf41200a7,0x2d830ad0}},	// [580] _baje, _vaku, דפן_, baje_, 
   {{0x7bc60ad1,0x7c2903ef,0x69c70ad2,0x63bb005f}},	//   _waku, čera, _caje, heun, 
   {{0xb4d700bd,0x63bb005f,0x3f800ad3,0x1c460ad4}},	//   ामो_, keun, _keiu_, _оном, 
   {{0x63bb0ad5,0x00000000,0x00000000,0x00000000}},	//   jeun, --, --, --, 
   {{0xa3e105f6,0x63bb005f,0x6b840ad6,0x56940097}},	//   दान_, deun, maig, халт, 
   {{0x6b840a92,0x69c70ad7,0x63a20ad8,0xe46a0acd}},	//   laig, _gaje, _scon, ошил_, 
   {{0x61ea0ad9,0xdb0f0106,0x628f0ada,0x00000000}},	//   _rofl, _abcè, ácon, --, 
   {{0x69c703ef,0x6b840adb,0x2d830adc,0xd9430add}},	//   _zaje, naig, zaje_, _реси, 
   {{0x83fc0a1a,0x752d0540,0x27e601ff,0x69c70ade}},	//   _nuđe, ğaza, mjon_, _yaje, 
   {{0x27e60adf,0x6b840ae0,0x24f60ae1,0x68380183}},	//   ljon_, haig, _очер, dídi, 
   {{0xdb1d026e,0x2d830ae2,0x63bb005f,0x6b840ae3}},	//   _masá, vaje_, beun, kaig, 
   {{0x68e30ae4,0x27e60ae5,0x83fc0112,0x2d830ae6}},	//   ändi, njon_, _buđe, waje_, 
   {{0x6b840ae7,0x3f800175,0xfe6e010e,0xe46a01d5}},	//   daig, _deiu_, یگی_, blöð_, 
   {{0x61ac0086,0xdb1d0098,0x26c4019c,0x00000000}},	//   _কোরআ, _nasá, _msmo_, --, 
   {{0x2d830ae8,0x69c70ae9,0x6b840038,0x7c8400d9}},	//   raje_, _raje, faig, куте, 
   {{0x2d830aea,0x25a9034c,0x69c70aeb,0xa00800eb}},	//   saje_, đali_, _saje, _يقول_, 
   {{0x69c70aec,0x44ce011f,0x79a70aed,0x2d830aee}},	// [590] _paje, _lę_, дрее, paje_, 
   {{0x2fc90aef,0x1e1400d9,0xdb1d03c6,0x63bb00b4}},	//   _haag_, _амья, _casá, zeun, 
   {{0x6b84012d,0x61e7014e,0x69c70af0,0x63bb002c}},	//   baig, öjli, _vaje, yeun, 
   {{0x69c70af1,0x6b840af2,0x27e60af3,0x2fc90326}},	//   _waje, caig, gjon_, _jaag_, 
   {{0xb4d70af4,0xdb1d0af5,0x2fc90af6,0x69c70af7}},	//   ाम्_, _ansö, _maag_, _taje, 
   {{0x2fc90af8,0x7a2b02f2,0x63bb005f,0xa5940093}},	//   _laag_, hütz, weun, връщ, 
   {{0x63bb0af9,0x97a70afa,0x6fa500a2,0xdb0f0afb}},	//   teun, _орал, _काढू, _tacó, 
   {{0x44ce0afc,0xee3f0228,0x2d810afd,0x75fd0237}},	//   _dę_, dtým_, _lehe_, _dèza, 
   {{0xc6a40afe,0x63bb0aff,0xb06500c8,0x17f80038}},	//   _архи, reun, kyää, _غرفة_, 
   {{0xddc400f1,0xb5fd0b00,0xdb040b01,0x63bb0b02}},	//   _otiš, _buše, nfiá, seun, 
   {{0x83fc00f1,0x63bb005f,0xdcfc0b03,0x27ff0604}},	//   _suđe, peun, karā, _klun_, 
   {{0x2fc90201,0xb5fd0b04,0xaad200bc,0x7985016c}},	//   _caag_, _duše, सिमक, hahw, 
   {{0x79850640,0x2fc90b05,0x2d810b06,0x27ed0b07}},	//   kahw, _daag_, _behe_, _moen_, 
   {{0x27ff0156,0x20020b08,0x11d90038,0x27ed0b09}},	//   _llun_, shki_, _روعة_, _loen_, 
   {{0x62860b0a,0xb5fd090e,0x6b840b0b,0x7c290397}},	//   škot, _guše, taig, čern, 
   {{0x27ed0b0c,0x8b950b0d,0x83fc00d2,0x2d81045a}},	//   _noen_, круч, _tuđe, _eehe_, 
   {{0x64590b0e,0xdb1d0b0f,0x4a460b10,0x499600b3}},	// [5a0] _miwi, _pasá, енав, ешет, 
   {{0x27ff0b11,0x6b84009f,0x2d8102f2,0x64590b12}},	//   _alun_, saig, _gehe_, _liwi, 
   {{0x7d7b00a7,0xdb1d0019,0x6d5e02dc,0x6b840b13}},	//   _מניו, _vasá, _igpa, paig, 
   {{0xc6a60b14,0x64590b15,0x25a500f3,0x27ff00f3}},	//   ерки, _niwi, _acll_, _clun_, 
   {{0x27ed01b2,0x79850199,0xf9840176,0x27e60b16}},	//   _doen_, bahw, _аҳзо, rjon_, 
   {{0x27e60b0c,0x2d8101d6,0x6d5e019c,0x3e660108}},	//   sjon_, _xehe_, _jgpa, _môt_, 
   {{0xd9430b17,0x69dc0b18,0x8cd30964,0xb4bc00c9}},	//   _бери, _inre, डियो, ेटे_, 
   {{0x44ce011f,0xb4b0007e,0x64590b19,0x27ff0b1a}},	//   _vę_, _ओही_, _ciwi, _glun_, 
   {{0x7ae40496,0x64590b1b,0xaac9031e,0xf1db009a}},	//   nxit, _diwi, रिएक, बांन, 
   {{0xb5fd044e,0x44ce00ab,0x645901c8,0x2fc90b1c}},	//   _puše, _tę_, _eiwi, _saag_, 
   {{0x7a2b02f2,0x98b30b1d,0x2d810b1e,0x200001f5}},	//   tütz, čeće_, _rehe_, _blii_, 
   {{0x2d8101c4,0x6d5e0102,0x200001be,0x7af60080}},	//   _sehe_, _agpa, _clii_, kyyt, 
   {{0x69dc0b1f,0xddc4090e,0xee3f014b,0x200001be}},	//   _onre, _stiš, stým_, _dlii_, 
   {{0x2ee10b20,0x84e402e6,0xb5fd0b21,0x2fc90b22}},	//   _पपीत, _कपाट_, _tuše, _waag_, 
   {{0x2fc9006d,0x765a0b23,0x9c470b24,0x61f5039f}},	//   _taag_, _mity, ехал, özle, 
   {{0x69dc0b25,0xd7cf0b26,0x765a0b27,0xc1780009}},	//   _anre, _सोंच, _lity, lbė_, 
   {{0x5a350172,0x27ed0b28,0x3b5500d3,0x2d810b29}},	// [5b0] внат, _roen_, ткар, _tehe_, 
   {{0x27ed0b2a,0x61fa0b2b,0xb4b000b0,0xfe70007a}},	//   _soen_, nktl, _ओहू_, _ادي_, 
   {{0xdcfc01dd,0x27ed0b2c,0xe611010e,0x2e360566}},	//   parā, _poen_, یشت_, ræft_, 
   {{0x69dc051c,0x87e40b2d,0xe71900eb,0x6d450b2e}},	//   _enre, люче, ويات_, _izha, 
   {{0xf77003b1,0xe5a50b2f,0x7bdd0b30,0x765a0b31}},	//   صان_, вили, _insu, _bity, 
   {{0x0c7400c5,0x6aad0548,0x04b50258,0xdb04003e}},	//   _جدید, mtaf, всия, meið, 
   {{0x27ed0b32,0xdb04008c,0x765a00d7,0xb7c500f0}},	//   _toen_, leið, _dity, _ирақ, 
   {{0x7bcd0b33,0x19580b34,0xc4470019,0x765a0028}},	//   ndau, _часы_, ریشن_, _eity, 
   {{0x248003ef,0x7c3a026a,0x64590548,0x3863019b}},	//   ćima_, îtri, _viwi, _hujr_, 
   {{0x62890b35,0x64590ac3,0x33f10042,0x765a0b36}},	//   rseo, _wiwi, _páxs_, _gity, 
   {{0x7bdd0b37,0xbf9b078a,0x34940b38,0x62890b39}},	//   _onsu, rhên, _бахр, sseo, 
   {{0xdb04003e,0xb4bd00b0,0x765a0b3a,0xbbe00249}},	//   keið, इबी_, _zity, _पचेक, 
   {{0x6d450b3b,0x76480088,0x62860b3c,0x6729008a}},	//   _azha, _yhdy, škor, _jxej, 
   {{0x7bdd0b3d,0x518703b7,0x645c02a3,0x7af60080}},	//   _ansu, _чуда, _èric, vyyt, 
   {{0x6e3c04a8,0x15f40b3e,0x75fd0237,0x645c0574}},	//   rlrb, _अवसर_, _lèzo, _érit, 
   {{0x3e660b3f,0x7ae401f1,0x7bcd0495,0x6aad0a6d}},	//   _tôt_, txit, gdau, ftaf, 
   {{0xdfd2006b,0xafdb00fc,0xa9a60b40,0x6aad0b41}},	// [5c0] _ميں_, rmøt, киад, gtaf, 
   {{0xfe9b042c,0x6d5e012b,0x7bdd0b42,0xafdb004f}},	//   _קיימ, _ugpa, _ensu, smøt, 
   {{0x7e640088,0x83fc0b43,0x7af600c8,0xeb9f02c9}},	//   _huip, _luđa, syyt, _blød_, 
   {{0xdb0401d5,0x59e0000d,0x7e640b44,0x765a0300}},	//   beið, नाहर, _kuip, _sity, 
   {{0x779100d6,0x765a0b45,0xc7a30b46,0xc178012d}},	//   صیلا, _pity, ричк, ybė_, 
   {{0x68380165,0x69dc0b47,0x86430314,0x00000000}},	//   vídu, _unre, анчж, --, 
   {{0xf483004e,0x3863011c,0x48e30176,0x7e640b22}},	//   ауын, _gujr_, _корв, _luip, 
   {{0x83fc0ab4,0xb0d500b0,0x765a05d5,0xeb9f0b48}},	//   _buđa, धिनग, _wity, _glød_, 
   {{0x2a66007a,0xd4030b49,0x765a052b,0xfe130249}},	//   íobh_, рящи, _tity, _डगलस_, 
   {{0x320500d1,0x2cba01f2,0x765a05d5,0x7bcd0528}},	//   ghly_, _oppd_, _uity, zdau, 
   {{0x3b0902cd,0x68380165,0xa99b00c7,0xbb1b00b3}},	//   zzaq_, sídu, וביר, _neîn, 
   {{0xc05800e4,0x80a30b4a,0xeb9f00fb,0x66180b04}},	//   кія_, _कमरे, _kløe_, livk, 
   {{0x44260b4b,0x7e64011c,0xa294012d,0x6601021e}},	//   _ijo_, _cuip, _салі, _yllk, 
   {{0x27310029,0xb5fd0397,0xdb04003e,0x32050b4c}},	//   ỡng_, _kuša, veið, chly_, 
   {{0x4426078e,0xdfd5032e,0xdeb2005e,0x7bcd0b4d}},	//   _kjo_, _бойы, _құры, tdau, 
   {{0x6aad0b4e,0x44260539,0xa4b700d1,0xb5fd0b4f}},	//   ttaf, _jjo_, כללה_, _muša, 
   {{0x20190b50,0xab840b51,0x7e640a78,0x7bcd0b52}},	// [5d0] misi_, руск, _guip, rdau, 
   {{0xdb04008c,0x7bcd0b53,0x66180121,0xd91b0080}},	//   reið, sdau, jivk, мье_, 
   {{0x44260b54,0x67d502a0,0x7e6401d2,0x99640b55}},	//   _ojo_, ложу, _zuip, ртул, 
   {{0x20190b56,0xc7940b57,0xe8940965,0x6e35032f}},	//   nisi_, аршы, раць, lozb, 
   {{0x4b7a0a33,0x3a840b58,0xa3e102e6,0x4ae402f1}},	//   _ראשו, _высв, दास_, _кўра, 
   {{0xd1260b59,0x4426078e,0xa2b800c6,0x20190b5a}},	//   _هم_, _ajo_, ्बन्, hisi_, 
   {{0x37ab004e,0x2baa00d8,0xb4bd00b0,0x44260b5b}},	//   _отан_, ङ्का, इबे_, _bjo_, 
   {{0x20190b5c,0x42c90b5d,0x6e3501d6,0x00000000}},	//   jisi_, егин_, hozb, --, 
   {{0x20190b5e,0xe3b60b5f,0x44260237,0x55a5010e}},	//   disi_, убы_, _djo_, _مجاہ, 
   {{0x44260199,0x6e35044e,0xb5fd0604,0x964700b3}},	//   _ejo_, jozb, _fuša, _рэбд, 
   {{0x20190b60,0x7c29008b,0x7e640387,0x00000000}},	//   fisi_, čerj, _suip, --, 
   {{0xc50c0070,0xbb1b00b3,0x20190b61,0x7e640534}},	//   _קלאָ, _reîn, gisi_, _puip, 
   {{0x443f0b62,0xd24e00d4,0x00000000,0x00000000}},	//   mlu_, تنی_, --, --, 
   {{0x443f0b63,0xdca60258,0x831a00c7,0x229200eb}},	//   llu_, лаги, _אונז, _الوس, 
   {{0x20190b64,0x443f00c2,0x5bb60148,0xafdb00fb}},	//   bisi_, olu_, лсаф, rmør, 
   {{0x6618044e,0xeb9f03a9,0x443f008f,0x20190b65}},	//   zivk, _smør_, nlu_, cisi_, 
   {{0x9e5a0b66,0x443f0b67,0x2baa00bc,0x8c430b68}},	// [5e0] _проф_, ilu_, ङ्गा, сете, 
   {{0xd8390118,0x7a300380,0x00000000,0x00000000}},	//   _akō_, lätz, --, --, 
   {{0x443f0b69,0x3ea20b6a,0x2d8a0b6b,0x3ce502ae}},	//   klu_, lukt_, mabe_, älvt_, 
   {{0x2bab0b6c,0x2d8a0b6d,0xdc9b0486,0x2a69006d}},	//   _छाया, labe_, _איטל, bqab_, 
   {{0xa3d7034d,0x443f0b6e,0x60060b6f,0x68e30219}},	//   ायन_, dlu_, _góme, ändr, 
   {{0xb5fd0112,0x7c2400d9,0x45d40a10,0x7a3001c4}},	//   _puša, lnir, рокс, hätz, 
   {{0x20190b70,0x5faa00a2,0x29550141,0x442602fe}},	//   yisi_, _काढल, _вътр, _pjo_, 
   {{0x69ce0b71,0x68e308c2,0x7c240b72,0x2d8a0b73}},	//   _habe, ånde, nnir, habe_, 
   {{0x69ce0b74,0x6b860364,0x2d8a0b75,0xf74300d9}},	//   _kabe, _mekg, kabe_, _гето, 
   {{0x6b860194,0x20190b76,0x69ce0a9f,0x32b700eb}},	//   _lekg, wisi_, _jabe, ادية_, 
   {{0x69ce0b77,0x443f0b78,0x03140b79,0xb5fd0372}},	//   _mabe, blu_, _तेरह_, _kušn, 
   {{0x7c24003a,0x443f0b7a,0x69ce0b7b,0xb5fd06e0}},	//   jnir, clu_, _labe, _jušn, 
   {{0xa3e106c9,0x20190b7c,0x26c602a2,0xdefb013e}},	//   दार_, risi_, nwoo_, хын_, 
   {{0x20190b7d,0xd2500b7e,0x2fcd0062,0x64400b7f}},	//   sisi_, _بنت_, žeg_, llmi, 
   {{0x6e350b80,0x021700a7,0x5ce40b81,0xafdb02c9}},	//   rozb, _תחום_, бюта, rløb, 
   {{0xfbdf00f7,0x69a70077,0x6b860065,0x69ce0b82}},	//   _thêm_, _चाही, _cekg, _aabe, 
   {{0x3f8b0ab1,0x2d8a0b83,0x3d950b84,0x7a3000c8}},	// [5f0] macu_, babe_, _кипр, läty, 
   {{0x69ce0b85,0x443f0b86,0xd9990189,0x5fd90586}},	//   _cabe, zlu_, ئنات_, _बोतल, 
   {{0x69ce0b87,0x443f0b88,0x7a3000c8,0xf773029a}},	//   _dabe, ylu_, näty, ماش_, 
   {{0x8d7400d4,0x3f8b0b89,0x60060126,0x443f00ad}},	//   _پایا, nacu_, _tóme, xlu_, 
   {{0x66e50b8a,0x443f0b8b,0x68e30b48,0x00000000}},	//   рола, vlu_, åndb, --, 
   {{0x69ce0b8c,0x3f8b0b8d,0x7bcf016c,0x00000000}},	//   _gabe, hacu_, _hacu, --, 
   {{0x62820b8e,0x6b86009e,0x7bcf0b8f,0x3dd70086}},	//   _awoo, _yekg, _kacu, _সকাল, 
   {{0x629b0b90,0x3f8b0b91,0x33d5004e,0x628201b8}},	//   truo, jacu_, рікт, _bwoo, 
   {{0x443f0b92,0x491900a2,0x02050b93,0x69ce0b94}},	//   rlu_, _येतो_, изин, _yabe, 
   {{0x443f01d5,0xd24e00b1,0x7bcf0b95,0x91f500d9}},	//   slu_, وني_, _lacu, рчич, 
   {{0x443f0b96,0x61450b97,0x2d8a0b98,0x6faa009a}},	//   plu_, рена, vabe_, _कादं, 
   {{0xdcfe01dd,0x79870026,0x7bcf0027,0x2d8a0b99}},	//   _nepā, _lejw, _nacu, wabe_, 
   {{0x91e50b9a,0x2d8a0b9b,0xd17500d3,0xf38c0070}},	//   _воле, tabe_, _кыйы, _טראָ, 
   {{0x44d50b9c,0xee370b9d,0x7a3002f2,0x21660623}},	//   _kā_, иня_, sätz, _киши_, 
   {{0x2d8a0b9e,0x69ce0b9f,0x44d500e0,0x7bcf0ba0}},	//   rabe_, _rabe, _jā_, _bacu, 
   {{0x44d50b03,0x2d8a0ba1,0x8b260ba2,0x31c50ba3}},	//   _mā_, sabe_, адбе, _वसुध, 
   {{0xfaa60ba4,0x69ce0ba5,0xcb0000ab,0x25db00b0}},	// [600] разо, _pabe, लैंड_, _गोभी_, 
   {{0x69ce0405,0x2d960ba6,0x7bcf0ba7,0x9976004e}},	//   _qabe, _трис, _eacu, руаш, 
   {{0x44d50339,0xfce60ba8,0x44c70019,0x7bcf0ba9}},	//   _nā_, _тоно, _nő_, _facu, 
   {{0x69ce0baa,0x7bcf0bab,0xb5fd090e,0xfaa60bac}},	//   _wabe, _gacu, _bušo, _камо, 
   {{0x7bc400b3,0x41a602e6,0x671601ec,0x16a70bad}},	//   meiu, _खालस, _देशक_, ивци_, 
   {{0xa61300dd,0x28880274,0x96f70bae,0x7bc40baf}},	//   оміч, _مصری_, решт_, leiu, 
   {{0x291e022b,0x7bcf007c,0xb5fd0372,0xb4e00790}},	//   _äta_, _yacu, _tušn, दमे_, 
   {{0x07a30bb0,0x75f400f6,0x7bcf0096,0xf3f80243}},	//   _масн, _vàzq, _xacu, _kuģi_, 
   {{0xe5a60bb1,0xb5fd00ef,0x3f8b044e,0x521400c8}},	//   _визи, _kušl, vacu_, йдит, 
   {{0x44c70019,0xe2140235,0x83fc090e,0x7c290bb2}},	//   _fő_, ёмны, _tuđo, čeri, 
   {{0x7e760bb3,0x6aa401c8,0xf99300d1,0x69d90070}},	//   _atyp, huif, חרת_, אַרו, 
   {{0xa3d70790,0x24f501bb,0xb5fc00c3,0xdb1d010e}},	//   ायण_, _учур, _diġe, _vasú, 
   {{0xc7b30056,0x69a70190,0x3f8b0ab4,0x44d50054}},	//   חבר_, _चाली, racu_, _zā_, 
   {{0x2723001b,0x3f8b0b91,0x00000000,0x00000000}},	//   ằng_, sacu_, --, --, 
   {{0x40940bb4,0x7bcf0bb5,0x3f8b02cd,0x6adf00aa}},	//   _البر, _pacu, pacu_, नम्र, 
   {{0x3ced003a,0x41a60bb6,0x79870415,0x95fe0033}},	//   ćev_, _खाँस, _sejw, ্চিম_, 
   {{0x99670bb7,0x7bcf0bb8,0x798700f4,0xa3d70bb9}},	// [610] ател, _vacu, _pejw, ायत_, 
   {{0x2aaf00ad,0x7bcf0bba,0x2b850108,0xd3570225}},	//   rüb_, _wacu, ặc_, שימי_, 
   {{0x7bcf0bbb,0xdcfc0242,0x60060bbc,0x00000000}},	//   _tacu, varć, _hóma, --, 
   {{0x44d50339,0x7bc400b3,0xf7f4009c,0x60060bbd}},	//   _rā_, ceiu, يسند, _kóma, 
   {{0xa3ea0ba3,0x6b8d0bbe,0xd6d900ab,0x09cf0086}},	//   मान_, maag, _była_, রাবা, 
   {{0x44d50339,0x6b8d0bbf,0x80af0086,0x3f890027}},	//   _pā_, laag, য়িত্, _leau_, 
   {{0x69c50bc0,0xcd9800d1,0x00000000,0x00000000}},	//   mehe, בדות_, --, --, 
   {{0x6b8d0bc1,0x69c50bc2,0x53c902bc,0x44d50b03}},	//   naag, lehe, угим_, _vā_, 
   {{0x6006033c,0x659500b3,0xe5c70002,0x00000000}},	//   _nóma, _газу, _всео, --, 
   {{0x44d50bc3,0xa2050bc4,0x69c50bc5,0x26cd02a3}},	//   _tā_, спод, nehe, _iseo_, 
   {{0x3f890bc6,0x6b8d0bc7,0x629d014b,0x7e760083}},	//   _beau_, kaag, ásob, _styp, 
   {{0x69c50bc8,0x76430bc9,0x6b8d0bca,0xdb04007a}},	//   hehe, llny, jaag, rfiú, 
   {{0x69c50bcb,0x6b8d0511,0xaac60262,0x60060183}},	//   kehe, daag, _रैंक, _cóma, 
   {{0x63a90bcc,0x3f9e01f0,0x6006003e,0x69c5024a}},	//   lgen, ştu_, _dóma, jehe, 
   {{0x61e30bcd,0xeb9a0bce,0x63a90bcf,0x764302a2}},	//   _innl, лив_, ogen, ilny, 
   {{0x6b8d0b8e,0x78a503f5,0x60dc01e8,0x06f90035}},	//   gaag, duhv, ærme, ्नाव_, 
   {{0x63a90bd0,0x69c501a7,0xfe720038,0xed5700f0}},	// [620] igen, fehe, _عدة_, _қою_, 
   {{0x69c50bd1,0xb5fd00ef,0x443d0380,0x0dca0bd2}},	//   gehe, _bušm, _lkw_, _слой_, 
   {{0xa3d70bd3,0x395c014e,0x26cd04b3,0x63a907d7}},	//   ाया_, ävs_, _aseo_, kgen, 
   {{0x20020088,0xb5fd08e3,0x9f40023a,0x63a90bd4}},	//   nkki_, _dušm, _anié_, jgen, 
   {{0xadec0bd5,0xa3e105fd,0x69c50bd6,0xb4e00299}},	//   ञापन_, दाई_, behe, दम्_, 
   {{0x63a90bd7,0x25db083b,0x78a50ab4,0x48e60726}},	//   egen, _गोदी_, buhv, _логв, 
   {{0x63a90bd8,0x7c29014b,0x18a30bd9,0x7d7b0070}},	//   fgen, červ, _нарм, אנצו, 
   {{0x6815006a,0x63a90bda,0x83fc0062,0x3a3a014e}},	//   ządz, ggen, _tuđm, lopp_, 
   {{0x645c02a3,0xfbd300df,0x00000000,0x00000000}},	//   _èrim, לתה_, --, --, 
   {{0x60060bdb,0xd9cf0086,0xddcd0082,0x3a3a0bdc}},	//   _róma, রাথম, _otaš, nopp_, 
   {{0x3f89026a,0xb5fc00a4,0x4546007a,0x00000000}},	//   _peau_, _tiġb, _اناق, --, 
   {{0x82a60bdd,0x3a3a0611,0x63a90bde,0xc4d300df}},	//   _гадж, hopp_, cgen, _מגע_, 
   {{0x69c50bdf,0x3f890212,0x3a3a0be0,0x00000000}},	//   yehe, _veau_, kopp_, --, 
   {{0xddcd00ab,0x6b8d0be1,0x387800a1,0x00000000}},	//   _uważ, waag, _otrr_, --, 
   {{0x321e0be2,0x6b8d0298,0x69c5039f,0x00000000}},	//   mity_, taag, vehe, --, 
   {{0x321e0be3,0x69c50be4,0x27e40102,0x6006003e}},	//   lity_, wehe, _nnmn_, _tóma, 
   {{0x6b8d0be5,0x69c502f2,0xfaff024a,0x15fa00bc}},	// [630] raag, tehe, _afër_, ्सार_, 
   {{0x321e0be6,0xddab0be7,0x6b8d0be8,0x7e7d0be9}},	//   nity_, _стил_, saag, mpsp, 
   {{0x094b0bea,0x6b8d0beb,0x69c50bec,0x237f0083}},	//   учаи_, paag, rehe, ybuj_, 
   {{0x69c502ec,0xb8f10bed,0xad1a00a7,0x167300f0}},	//   sehe, _वन_, _כותר, зқар, 
   {{0x69c50364,0x00000000,0x00000000,0x00000000}},	//   pehe, --, --, --, 
   {{0x20090156,0xb5fd0121,0x443d08b0,0x00000000}},	//   _llai_, _tušm, _skw_, --, 
   {{0x63a90bee,0xb5fd00d2,0x443d0bef,0x2002003e}},	//   tgen, _hušk, _pkw_, ykki_, 
   {{0x5fd90bf0,0xdb0d0bf1,0x6683006b,0x26cd0194}},	//   _बोलल, leañ, _فیصل, _tseo_, 
   {{0x23290bf2,0xe29900d3,0x66f400d9,0x320700da}},	//   ропи_, шап_, _епту, _plny_, 
   {{0xb5fd00f1,0x63a90bf3,0x312500c8,0x200901ca}},	//   _mušk, sgen, ждог, _alai_, 
   {{0x443d0bf4,0x2fd200a3,0x3207014b,0xafdb00fb}},	//   _tkw_, _payg_, _vlny_, rløn, 
   {{0xa3ea00d8,0xb4d50bf5,0x443d0bf6,0xafdb0bf7}},	//   माण_, िटी_, _ukw_, sløn, 
   {{0x20020088,0xe2da0019,0x1e830bf8,0xb5fd0604}},	//   rkki_, _پانچ_, млям, _nušk, 
   {{0x27380029,0x321e0bf9,0x27e001dd,0x20090bfa}},	//   ứng_, city_, ķini_, _elai_, 
   {{0xed5a0bfb,0xdbc7008c,0x00000000,0x00000000}},	//   ров_, töðu, --, --, 
   {{0xb5fd0bfc,0xc4d20486,0x20040243,0x1c460bfd}},	//   _bušk, וגל_, ījis_, інам, 
   {{0xa3ea00a2,0x3a3a0bfe,0x198a0176,0x00000000}},	// [640] मात_, topp_, ибаи_, --, 
   {{0xb5fd032f,0xc18c0070,0xae370176,0x00000000}},	//   _dušk, ָטאָ, _дӯст_, --, 
   {{0xd6d9006a,0x3a3a0bff,0x2e3f0216,0x00000000}},	//   _było_, ropp_, rîft_, --, 
   {{0x8c460c00,0x321e0a30,0x386d00da,0x3a3a00fc}},	//   _феме, zity_, _čert_, sopp_, 
   {{0x628600bc,0xddde0026,0xa3cd00b0,0x00000000}},	//   škoz, _lipō, शजन_, --, 
   {{0xd49a0c01,0x2ba80c02,0x35f30c03,0x321e0c04}},	//   ари_, गलवा, мпір, xity_, 
   {{0x25a00c05,0x1db20c06,0x321e0c07,0xd5ad0019}},	//   ğil_, _जानत, vity_, اہم_, 
   {{0x2d9a0026,0x25a0027e,0xaa7b00bc,0x18670165}},	//   _ldpe_, şil_, _frýd, _фати_, 
   {{0x248908b1,0x6ab60035,0x6e3c0c08,0x1dca0110}},	//   ćama_, ntyf, korb, ाजात, 
   {{0xff5f0216,0x00000000,0x00000000,0x00000000}},	//   feîn_, --, --, --, 
   {{0xa3b50081,0x60060503,0x321e0056,0x104b0088}},	//   _चॉक_, _cómo, rity_, иями_, 
   {{0xf1ae00bd,0xdb21014b,0x8f350c09,0x320c0c0a}},	//   ज्जन, _štíh, земц, shdy_, 
   {{0x6e3c0c0b,0x21fb0218,0xa3d703a2,0x185b0147}},	//   forb, _pêht_, ायर_, יכטע, 
   {{0x60060183,0xf2870019,0x7e7d0c0c,0x6e3c01d6}},	//   _fómo, _بھٹو_, rpsp, gorb, 
   {{0x48c500cc,0x3f8202cd,0x00000000,0x00000000}},	//   _এপ্র, bbku_, --, --, 
   {{0x3a7500cf,0x7aed0c0d,0x7e7d0c0e,0x83fc0082}},	//   злар, txat, ppsp, _buđi, 
   {{0xf96b0c0f,0x7f4d00ad,0x671f00aa,0x09cf0033}},	// [650] арей_, _uzaq, _मेढक_, রাসা, 
   {{0x527b0137,0x600d0151,0xc9840c10,0x7aed00b9}},	//   ינמא, _dûme, дуци, rxat, 
   {{0x2d910c11,0x2d83024a,0x81bc01dd,0x7e6d0175}},	//   maze_, mbje_, tnēj, _huap, 
   {{0x2d910112,0x61f80c12,0x7c29014b,0xb5fd0242}},	//   laze_, _lovl, čers, _tušk, 
   {{0xeb7600c7,0x76c701c9,0xb5fc007b,0x00000000}},	//   _מערץ_, تغال, _siġa, --, 
   {{0xe61800dd,0x2d910c13,0xb5fc008a,0x00000000}},	//   оді_, naze_, _piġa, --, 
   {{0xa3d70c14,0x7e6d02a2,0xf505012d,0xb5fd00ca}},	//   ायल_, _luap, язко, _juši, 
   {{0xb5fd053d,0x25db0c15,0x13e90c16,0xfbdf00e7}},	//   _muši, _गोरी_, смий_, _thêu_, 
   {{0x26d9001d,0x38b50c17,0x29ff0083,0xddde0118}},	//   _éso_, lår_, ałań_, _sipō, 
   {{0xddc400f1,0x69d50c18,0x11d50038,0x10a50c19}},	//   _stiž, _jaze, ستخد, пион, 
   {{0x6d450c1a,0xb5fd0c1b,0x61f80c1c,0x2901010e}},	//   _nyha, _nuši, _dovl, nyha_, 
   {{0x6e3c0380,0xd4c40c1d,0x00000000,0x00000000}},	//   worb, _юсуп, --, --, 
   {{0x63bb05ce,0xa2e509e3,0xdb1d001d,0x2d910c1e}},	//   mfun, _холд, _masó, faze_, 
   {{0x2d8c0c1f,0x63bb0c20,0x600d010c,0x2d91011b}},	//   úde_, lfun, _rûme, gaze_, 
   {{0xe16600c5,0x61420c21,0x63bb0c22,0x59df00c9}},	//   _عضوی, _пеша, ofun, _नफ़र, 
   {{0xc4d207f5,0xbc630c23,0x80b10086,0x77690175}},	//   עגן_, евск, _জনপ্, _ngex, 
   {{0x7e6d0c24,0x2fc00268,0x2d910c25,0x63bb0c26}},	// [660] _guap, _ibig_, baze_, ifun, 
   {{0xa3e200ea,0x4a430c27,0x2d910c28,0x25db0a09}},	//   _फोन_, енув, caze_, _गोली_, 
   {{0x38b50c29,0xdb1d0c2a,0x63bb0c2b,0xb5fd090e}},	//   går_, _basó, kfun, _guši, 
   {{0xdb1d0c2c,0x83fc090b,0xde6d001b,0x69d50036}},	//   _obsè, _tuđi, _hươn, _eaze, 
   {{0x69d50316,0x6b840c2d,0x63bb008a,0x6d40008f}},	//   _faze, mbig, dfun, şmad, 
   {{0x69d50c2e,0x6b840c2f,0x7c3b0b91,0x28160c30}},	//   _gaze, lbig, čure, _کورس, 
   {{0xdb0f026d,0x63bb0c31,0xdb1d0c32,0x2d85010e}},	//   _accè, ffun, _absè, űleg_, 
   {{0xde6d001b,0x6b840c33,0x02a60c34,0x320502c9}},	//   _lươn, nbig, пром, ekly_, 
   {{0xa3e10c35,0x6b840c36,0x81d50033,0x798e052b}},	//   दाज_, ibig, হান_, _kebw, 
   {{0xdb0d02a0,0xde6d00e7,0x8afb027a,0x6faa09ec}},	//   sfaç, _nươn, צהיי, _काउं, 
   {{0x6aa40c37,0x7e6d0938,0x403505ef,0xd2500019}},	//   hrif, _suap, денс, ٹنگ_, 
   {{0x6aa40c38,0xe45a0c39,0xa3d70c3a,0x2ee00156}},	//   krif, _уже_, ायः_, _brif_, 
   {{0xf2060021,0x64420379,0x7e6d039b,0xeb9f0566}},	//   _няко, _ikoi, _quap, _fløj_, 
   {{0x6aa402fb,0xde6d00e7,0x9c830228,0x32050c3b}},	//   drif, _cươn, účov, ckly_, 
   {{0xde6d0029,0x69d50c3c,0xc1bb00a7,0x38a000b3}},	//   _dươn, _raze, _המוש, nără_, 
   {{0x6aa402bf,0x6b840c3d,0x2d9105b3,0x6d450098}},	//   frif, gbig, saze_, _vyha, 
   {{0x6aa40c3e,0x2ee00c3f,0xb038035c,0x8f9c00a7}},	// [670] grif, _grif_, _מנהג_, _היחי, 
   {{0x38b50a40,0xde6d001b,0x3ea4020b,0x6b840c40}},	//   tår_, _gươn, ámte_, abig, 
   {{0x6b84014e,0x29070c41,0xf8b600d3,0xee780116}},	//   bbig, ána_, мөт_, _وصیت_, 
   {{0x29070405,0x69d50053,0x6aa40c42,0x76410009}},	//   ġna_, _waze, brif, _skly, 
   {{0xdb1d04fe,0x38b50c43,0x7c2d0c44,0x7c3f0c45}},	//   _obsé, sår_, mnar, moqr, 
   {{0xde6d001b,0x64420054,0x68e1010e,0x38b50219}},	//   _xươn, _akoi, _áldo, pår_, 
   {{0x24890062,0x442f02cd,0xf8d10c46,0xd7fb00b3}},	//   ćamo_, _pjg_, _सनिय, _луа_, 
   {{0x7c2d0c47,0xdb0f0c48,0x67d40a43,0x130900af}},	//   nnar, _accé, _посу, жний_, 
   {{0x63bb0c49,0x7c2d0c4a,0x7c280183,0x98b80028}},	//   rfun, inar, édri, _vyrą_, 
   {{0x3eab0c4b,0xb5fd0c4c,0x644201f1,0x2ee000ca}},	//   duct_, _aušv, _ekoi, _rrif_, 
   {{0x63bb0c4d,0x7c2d008c,0x32050c4e,0xc6090551}},	//   pfun, knar, rkly_, वसीय_, 
   {{0x2ee002bf,0x81b50086,0xe3b00038,0xde6d00e7}},	//   _prif_, _চোখ_, _مره_, _sươn, 
   {{0xa3ea0796,0x7c2d02ee,0xe28e0c4f,0x443f0c50}},	//   मार_, dnar, _ша_, mou_, 
   {{0x64490c51,0x7c2d0c52,0x645b0c53,0xacea0c54}},	//   llei, enar, lmui, омга_, 
   {{0x442d0021,0xe1f00c55,0x3eb90536,0x9d4306b3}},	//   one_, _حسن_, atst_, верд, 
   {{0x443f0c56,0x7c2d0c57,0x64490c58,0xa3b10c59}},	//   nou_, gnar, nlei, ञ्च_, 
   {{0x442d0c5a,0xde6d0029,0x6b840c5b,0x644901fd}},	// [680] ine_, _tươn, rbig, ilei, 
   {{0x6aa40c5c,0x443f0c5d,0x6b840104,0x2b8c0029}},	//   rrif, hou_, sbig, ếc_, 
   {{0x443f0c5e,0x442d076b,0x851c0262,0x64490c5f}},	//   kou_, kne_, _भेंट_, klei, 
   {{0x442d0c60,0x798e01a9,0x443f0c61,0xc3140086}},	//   jne_, _webw, jou_, াপতি_, 
   {{0x442d0032,0x443f0c62,0x7c240539,0xb865015f}},	//   dne_, dou_, miir, رامو, 
   {{0x64490bf3,0x3e7402ae,0x44ce02d9,0xafdb00fc}},	//   elei, _mät_, _př_, tløk, 
   {{0x443f0c63,0xa3ea0c64,0x3e740219,0x1dc00c65}},	//   fou_, माल_, _lät_, श्यत, 
   {{0x442d0c66,0xe73a0c67,0x443f0c1f,0x68e301cc}},	//   gne_, _деб_, gou_, ænde, 
   {{0x3e740219,0x00000000,0x00000000,0x00000000}},	//   _nät_, --, --, --, 
   {{0x442d0c68,0x64490080,0x7c240c69,0x00000000}},	//   ane_, alei, hiir, --, 
   {{0x443f0c6a,0x8506040f,0x442d0c6b,0x25eb0527}},	//   bou_, _توان, bne_, चारी_, 
   {{0x443f0c6c,0x62800c6d,0x60320243,0x64490c6e}},	//   cou_, ppmo, tāma, clei, 
   {{0x64400c6f,0x2bdf07d5,0x7c2d0218,0x44b000f0}},	//   momi, _पोषा, vnar, _рұқс, 
   {{0x603201dd,0x600d0216,0x14c2009a,0xddc40243}},	//   rāma, _dûma, _शहाण, _puiš, 
   {{0x7c240c70,0x7c2d0c71,0x623300f0,0xb5fc00a4}},	//   fiir, tnar, _шешу, _riġl, 
   {{0xfc300c72,0x80c40033,0x2bdf0c73,0x00000000}},	//   لحق_, ষিদ্, _पोशा, --, 
   {{0xa3b60509,0xcd0400bc,0xb5fd0455,0x645c02a3}},	// [690] _जान_, vněž_, _kušt, _èriu, 
   {{0x443f0c74,0x442d0c75,0x64400c76,0x7c2d0c77}},	//   zou_, zne_, homi, snar, 
   {{0x442d0c78,0x64400c79,0xdb04010e,0x7c240c7a}},	//   yne_, komi, rgiá, biir, 
   {{0x442404d1,0x27e90c7b,0x443f0c7c,0x442d0c7d}},	//   jim_, ñan_, xou_, xne_, 
   {{0x442d0c7e,0x443f0c7f,0x64490876,0x7bcd0c80}},	//   vne_, vou_, vlei, meau, 
   {{0x442d006a,0x443f03a0,0x6aad0065,0xb5fd00ca}},	//   wne_, wou_, muaf, _nušt, 
   {{0x443f0c81,0x442d0c7e,0x60060084,0x44240c82}},	//   tou_, tne_, _fómh, fim_, 
   {{0x442d0012,0x61ea0c83,0x64400c84,0x248c0183}},	//   une_, _anfl, gomi, _dwdm_, 
   {{0x442d0c85,0x64490c86,0x63a60c87,0x963507a4}},	//   rne_, rlei, ókna, _знац, 
   {{0x443f0042,0x442d0c88,0xe1f10084,0x7c240c89}},	//   sou_, sne_, اسة_, ziir, 
   {{0x60260c8a,0x65940c8b,0x64490c8c,0x443f0c8d}},	//   една, _раху, plei, pou_, 
   {{0x64400c8e,0xa3b60c8f,0x61ea0c90,0x44240c88}},	//   comi, _जाय_, _enfl, cim_, 
   {{0x7bcd0c91,0x7c240c92,0x2ac301dd,0x4f070c93}},	//   deau, viir, nībā_, енян_, 
   {{0xa3d70c94,0xb5fd04ab,0x2d9e0107,0x2c75055f}},	//   ायक_, _gušt, ûte_, _båd_, 
   {{0x7c240c95,0x1b1d0086,0xd00a0c96,0xa3b60c97}},	//   tiir, _ভুলে_, _неке_, _जाम_, 
   {{0x7bcd011c,0x3e740c98,0xb5fc00c3,0x00000000}},	//   geau, _tät_, _riġm, --, 
   {{0x7c240c99,0xf41200c7,0x60060c9a,0x1f66004f}},	// [6a0] riir, אפן_, _nómi, _яким, 
   {{0xe9d70c9b,0x7c3b0bad,0x5fc1031e,0x0b430161}},	//   нку_, čura, ष्ठल, унун, 
   {{0x7c240c9c,0x44240c9d,0x1bea02c4,0x7bcd0c9e}},	//   piir, yim_, _едни_, beau, 
   {{0x44240c9f,0x95fa0ca0,0x7bcd0106,0x929d0083}},	//   xim_, ्स्ट_, ceau, zyła, 
   {{0xa3b604d7,0x644000cf,0x60060503,0x00000000}},	//   _जाब_, vomi, _cómi, --, 
   {{0x44240ca1,0x6b960ca2,0x600604f4,0x64400083}},	//   wim_, layg, _dómi, womi, 
   {{0x7c2f00eb,0x39e70ca3,0xb5fd0098,0xc7a60ca4}},	//   _áirí, _ядро_, _rušt, _пивк, 
   {{0xb5fd0ca5,0xd9430ca6,0xccf3042c,0xd4670886}},	//   _sušt, _сеси, רכה_, није_, 
   {{0x44240ca7,0xb5fd02f5,0x64400ca8,0x2ac300e0}},	//   rim_, _pušt, romi, cībā_, 
   {{0x64400ca9,0x6b96040c,0x00000000,0x00000000}},	//   somi, hayg, --, --, 
   {{0x64a30caa,0x64400cab,0x91f10366,0x2a6a0036}},	//   _баха, pomi, _अचरज_, _mibb_, 
   {{0x2c750cac,0x929d0035,0x44240cad,0xdcfc020f}},	//   _råd_, syła, qim_, zbră, 
   {{0x7bcd0cae,0x93fb00d1,0xb5fd0028,0xdcfc0caf}},	//   veau, _מלאי, _tušt, karē, 
   {{0x61ea0118,0x81bc0243,0xa3b60110,0x91e30bad}},	//   _unfl, gnēt, _जाड_, _боље, 
   {{0x7bcd0cb0,0x645c02a3,0x71f7010e,0x2ac30243}},	//   teau, _èris, _سروس_, zībā_, 
   {{0x59c607d5,0x6b96011d,0x2c750566,0x7c840165}},	//   _रॉबर, gayg, _våd_, ѓусе, 
   {{0x7bcd0cb1,0x7b7400eb,0xb5fd0bfc,0x39a70cb2}},	// [6b0] reau, اطفا, _mušr, ешев, 
   {{0x7bcd0cb3,0x2bcf0035,0x13d90033,0x49d80cb4}},	//   seau, हजहा, থায়, ндую_, 
   {{0x6b96040c,0x7bcd0cb5,0x48ab0cb6,0x5d5505b2}},	//   bayg, peau, ятам_, _шкот, 
   {{0xfbab0088,0x9f49011c,0x629d010e,0x38690219}},	//   _этой_, _anaé_, ások, öar_, 
   {{0x79a708bd,0x6aad02a3,0xc66b00c8,0xa3ea02ff}},	//   _прве, quaf, чшее_, माई_, 
   {{0x60060169,0xd54900b3,0x2ac301dd,0x64a50cb7}},	//   _vómi, мпле_, rībā_, вака, 
   {{0xda34058b,0x70af04cc,0x2d9302aa,0x2ac301dd}},	//   _серы, _झमेल, _mexe_, sībā_, 
   {{0x73e50488,0xa3b60110,0x00000000,0x00000000}},	//   тоиз, _जाण_, --, --, 
   {{0x65c3004e,0x69c10cb8,0x425500d3,0x961d0243}},	//   _бұла, र्थी, ктот, _atņe, 
   {{0x2d9300f6,0x85b80cb9,0x27ff0cba,0x00000000}},	//   _nexe_, _плус_, _houn_, --, 
   {{0x76430cbb,0x3f9200b9,0x27ff0237,0x00000000}},	//   mony, _peyu_, _koun_, --, 
   {{0x76430cbc,0x27ff0118,0x69c10cbd,0xe1f10535}},	//   lony, _joun_, र्ती, اسک_, 
   {{0xa3b60cbe,0x27ff0cbf,0x20190034,0x7643095a}},	//   _जात_, _moun_, ëria_, oony, 
   {{0xed5a0229,0xaae000bc,0x76430cc0,0x00000000}},	//   дог_, निसक, nony, --, 
   {{0xdcfc00e0,0x27ed0cc1,0x629b0009,0xef1f04d6}},	//   varē, _onen_, lsuo, lbül_, 
   {{0x7ae90062,0x76430204,0x2a6a00a1,0x20d30474}},	//   _šeta, hony, _sibb_, _iţi_, 
   {{0xee3a0cc2,0xab2702c2,0xe9da05d9,0x76430cc3}},	// [6c0] _они_, вота_, мка_, kony, 
   {{0x5ac707f9,0x2000011c,0x27ed0cc4,0x48e60bad}},	//   ълум_, _hoii_, _anen_, козв, 
   {{0x2d980cc5,0x76430cc6,0x27ff0118,0x940c00ad}},	//   mare_, dony, _boun_, _evdə_, 
   {{0x2d980cc7,0x629b0009,0x09cf0033,0x661d0009}},	//   lare_, ksuo, রাগা, _įska, 
   {{0x76430cc8,0x2a6a00ad,0x27ff00b4,0x20000cc9}},	//   fony, _tibb_, _doun_, _moii_, 
   {{0x2d980cca,0xe5340ccb,0x00000000,0x00000000}},	//   nare_, лель, --, --, 
   {{0x69dc0ccc,0xb5fc003d,0x6846035b,0x00000000}},	//   _iare, _jiġi, _анва, --, 
   {{0x64590ccd,0x69dc0cce,0x2d980ccf,0x34c2000f}},	//   _chwi, _hare, hare_, _शहीद, 
   {{0x69dc0cd0,0x2d980cd1,0x51860a43,0x76430cd2}},	//   _kare, kare_, куна, bony, 
   {{0x69dc0cd3,0x2d980cd4,0x69de0cd5,0xa3e20cd6}},	//   _jare, jare_, ndpe, _फोर_, 
   {{0x25db0081,0x2d980be0,0x27ff0cd7,0x2d930068}},	//   _गोटी_, dare_, _youn_, _rexe_, 
   {{0x2d930cd8,0x03260cd9,0xaa7b00bc,0x03a30cda}},	//   _sexe_, _иден, _brýl, _вицо, 
   {{0xa2c4005e,0x2d9802a3,0x63a20cdb,0xdcf500e0}},	//   _сәйк, fare_, _idon, pazī, 
   {{0x69dc0cdc,0x2d9805a1,0xc0aa0399,0xa3ea01a4}},	//   _nare, gare_, _قابل_, माक_, 
   {{0x6d400cdd,0xdd940cde,0x5a350cdf,0x20d30ce0}},	//   şman, расы, ҳнат, _نتيج, 
   {{0x76430ce1,0xec340ce2,0xb5fc007b,0x2d980ce3}},	//   zony, ансь, _diġi, aare_, 
   {{0x2d980ce4,0x81d500cc,0x6b7400b9,0x5a350ce5}},	// [6d0] bare_, হার_, рлуу, гнат, 
   {{0x2d980ce6,0x69dc0ce7,0x25e2000d,0x628202be}},	//   care_, _care, _टोली_, _mtoo, 
   {{0x69dc0ce8,0x99670ce9,0x63a20b81,0x27ff03a0}},	//   _dare, ттал, _odon, _poun_, 
   {{0x63a20cea,0x3f990ceb,0xac1900dd,0xb8cb0c14}},	//   _ndon, nasu_, _чому_, _खि_, 
   {{0x501c0cec,0xf7700625,0xe5a50623,0x1dc007d5}},	//   וואו, زان_, гили, श्वत, 
   {{0x69dc0ced,0x627200ab,0x7bdd0cee,0xfb1a0070}},	//   _gare, _młod, _hasu, _טורמ, 
   {{0x7bdd0cef,0x25a903c0,0x5e5800c7,0x3f990cf0}},	//   _kasu, ğal_, דיגע_, kasu_, 
   {{0x2d980012,0xa3ea000f,0x27ed0cf1,0x629b0cf2}},	//   zare_, माग_, _unen_, tsuo, 
   {{0x7bdd0cf3,0x2d980cf4,0x76430cf5,0x69dc02b8}},	//   _masu, yare_, pony, _yare, 
   {{0x386d0cf6,0x611306d0,0x63a201f1,0x69dc00b9}},	//   _hier_, lələ, _edon, _xare, 
   {{0x2d980cf7,0x629b0cf8,0x7f4d00ad,0x69c70034}},	//   vare_, ssuo, _ayaq, _mbje, 
   {{0x7bdd0cf9,0x43740cfa,0x66010cfb,0x3f990304}},	//   _nasu, _кушт, _holk, gasu_, 
   {{0x2d980cfc,0x7ae90062,0x386d0cfd,0x0eb90cfe}},	//   tare_, _šetn, _mier_, куры_, 
   {{0x61130095,0xddcd0cff,0x60060d00,0x51870d01}},	//   hələ, _etaž, _rómu, _руда, 
   {{0x2d980cca,0x611306d0,0x44e309c7,0x3f990d02}},	//   rare_, kələ, _jı_, basu_, 
   {{0x69dc0d03,0x2d980d04,0x44e30c05,0x66010d05}},	//   _sare, sare_, _mı_, _lolk, 
   {{0x79950cd7,0x2d980d06,0x7bdd0d07,0x61130095}},	// [6e0] _bezw, pare_, _dasu, dələ, 
   {{0x69dc0d08,0x7bdd0354,0x2d980034,0xafdb0d09}},	//   _qare, _easu, qare_, bløs, 
   {{0x69dc0d0a,0x386d0d0b,0x61130095,0x77860d0c}},	//   _vare, _bier_, fələ, глез, 
   {{0xe73a030f,0x765a00e5,0xb8dc0d0d,0x69dc0d0e}},	//   нее_, _shty, _आम_, _ware, 
   {{0x69dc0d0f,0x386d0d10,0xc7a30d11,0x86260afc}},	//   _tare, _dier_, сичк, льке, 
   {{0x38bc0d12,0x44e3035d,0x386d0d13,0x7ae401e8}},	//   pír_, _bı_, _eier_, mvit, 
   {{0x386d0d14,0x44e30095,0x7ae40d15,0x7bdd0c25}},	//   _fier_, _cı_, lvit, _yasu, 
   {{0x611306d0,0x33740176,0x44e30d16,0x7bc400e2}},	//   cələ, шгир, _dı_, nfiu, 
   {{0x66010d17,0x52140aed,0xe7370d18,0x7ae40d19}},	//   _folk, идит, _бет_, nvit, 
   {{0xddcd0d1a,0x66010d1b,0xa3b60077,0x3f99019b}},	//   _staž, _golk, _जाव_, wasu_, 
   {{0x7c260d1c,0x7f4d02cd,0x59c60d1d,0x3f9900b0}},	//   _omkr, _syaq, र्यर, tasu_, 
   {{0x66010065,0x63a20d1e,0x7e76040b,0x628201b8}},	//   _zolk, _udon, _buyp, _ttoo, 
   {{0x7bdd0d1f,0x44260d20,0x6d4003c0,0xa29401fc}},	//   _rasu, _imo_, şmal, _талі, 
   {{0x442601a0,0x7bdd0d21,0x2731001b,0x44e3027e}},	//   _hmo_, _sasu, ạng_, _yı_, 
   {{0x317b00fe,0x3ea00d22,0xdb0d00eb,0x3f99014b}},	//   _ארומ, _evit_, rgaí, pasu_, 
   {{0x3a380054,0x6006003e,0xafdb01e8,0x4426025b}},	//   _ajrp_, _dóms, rløs, _jmo_, 
   {{0x59c60586,0xaed502f1,0xafdb01e8,0x7bdf0d23}},	// [6f0] र्भर, _топш, sløs, rdqu, 
   {{0x386d02fb,0x7bdd0d24,0xafdb0a1f,0xe29f003e}},	//   _sier_, _wasu, pløs, áði_, 
   {{0x7bdd0077,0x61130095,0xc795013e,0x7ae40d25}},	//   _tasu, tələ, арлы, avit, 
   {{0x20da0d26,0x2ee90348,0x4773004e,0x99640d27}},	//   mšić_, _kraf_, сқау, стул, 
   {{0x6b8d0d28,0x386d0439,0x2d940187,0x66010d29}},	//   mbag, _vier_, ždeň_, _polk, 
   {{0x6b8d0d2a,0x611306d0,0x69c704a1,0x386d01d2}},	//   lbag, sələ, _ubje, _wier_, 
   {{0x66010bf3,0x20190379,0xf8c9034d,0x22450326}},	//   _volk, khsi_, _रहिय, volk_, 
   {{0x66010d2b,0x61130095,0x6b8d0d2c,0x22450d2d}},	//   _wolk, qələ, nbag, wolk_, 
   {{0x2bc700a2,0xa3b60d2e,0x21f5004f,0x62590240}},	//   ऱ्या, _जार_, аїнс, крор_, 
   {{0x20da0112,0x42250d2f,0x20c5004f,0x69c5007a}},	//   kšić_, рдов, айом, nfhe, 
   {{0x3ea00d30,0x2ee9017c,0x6aad0d31,0x00000000}},	//   _svit_, _araf_, hraf, --, 
   {{0x44260d32,0xa4fa00c7,0x6aad0d33,0x504600b3}},	//   _gmo_, _בלעט, kraf, ремб, 
   {{0x1f56058b,0x636b03c0,0x7d010219,0xc7d600d1}},	//   ртнё, _dönü, älsn, בורי_, 
   {{0x91fc0bc3,0x62890d34,0x6aad0d35,0x2ee90d36}},	//   rmāc, mpeo, draf, _draf_, 
   {{0x3b960d37,0xdca302f1,0x8b960d38,0x2ee90d39}},	//   ијат, жаси, ирач, _eraf_, 
   {{0xafdb03a9,0x6b8d0d3a,0xe8e0001b,0x636b027e}},	//   slør, gbag, _hiệp_, _gönü, 
   {{0xada60d3b,0xa3d6072f,0x3a260d3c,0x6da60d3d}},	// [700] _капл, ाजत_, амаг, _кипа, 
   {{0x7ae40d3e,0xa9a60d3f,0xac76009c,0x600601d5}},	//   rvit, рижд, _پادش, _tóms, 
   {{0xdb0d014b,0x7ae40d40,0xc7ba0009,0x636b008f}},	//   čkác, svit, вёл_, _yönü, 
   {{0xbc7b00a7,0xebe60d41,0xdb20010e,0x7c260d42}},	//   _שנכת, _томп, ítóg, _umkr, 
   {{0x2bdf009a,0xdcfc0028,0x9f400354,0x68e500a1}},	//   _पोटा, tarė, _aniú_, avhd, 
   {{0x7aeb055f,0xe4a60d43,0x25a50090,0x69c50d44}},	//   ægte, арио, _cdll_, cfhe, 
   {{0xd49700cb,0x18a30d45,0x44260d46,0x98a30d47}},	//   ары_, _марм, _pmo_, _мире, 
   {{0xa6860d48,0x7c360156,0xf2c60d49,0xddcd0083}},	//   _влад, nnyr, асон, _staż, 
   {{0x20190034,0x75fd0118,0xb5fc008a,0x00000000}},	//   ërim_, _lèzy, _siġu, --, 
   {{0x1db200a2,0x64a60d4a,0x3878024a,0x442602b0}},	//   _जागत, _важа, _kurr_, _wmo_, 
   {{0xe3ba04a0,0x2ee90082,0xe8e00023,0x80270d4b}},	//   _абе_, _sraf_, _diệp_, لرحم, 
   {{0x7c3b0d4c,0x2ee900d9,0x6f1d0d4d,0x44260d4e}},	//   čurk, _praf_, tzsc, _umo_, 
   {{0xa18603a1,0x00000000,0x00000000,0x00000000}},	//   _кыйл, --, --, --, 
   {{0xa3b60d4f,0x6aad02a3,0x6f1d0502,0x9f4902be}},	//   _जाँ_, vraf, rzsc, _unaí_, 
   {{0x61fc02ae,0x6b8d0d50,0xac190d51,0xdd9500f0}},	//   örlu, tbag, гову_, _қаны, 
   {{0x6aad0d52,0xa3b60d53,0x20da0372,0x2ee90d54}},	//   traf, जलि_, ršić_, _traf_, 
   {{0x6b8d0d55,0xda780d56,0xf9930038,0x8c3a0176}},	// [710] rbag, аях_, قبض_, уотӣ_, 
   {{0xd999003f,0x80da0964,0x3da7005b,0x6aad0d57}},	//   انات_, _बनाइ, _триб, rraf, 
   {{0x290700b3,0xa3d602e6,0x69c5007a,0xa3b609d7}},	//   âna_, ाजा_, rfhe, जला_, 
   {{0x6aad002e,0x62890626,0x248508dc,0x7d0802ae}},	//   praf, ypeo, _rtlm_, ädse, 
   {{0x7c2d0d58,0x66e50258,0xa6c90d59,0x6aad00ad}},	//   miar, сола, улла_, qraf, 
   {{0x929d00ab,0x4aac0d5a,0xb0b602e6,0x59c60299}},	//   syłk, _चितव, _अमंग, र्दर, 
   {{0x38780226,0x649803a1,0x610a0248,0x53a503a1}},	//   _gurr_, атыр_, nəld, байб, 
   {{0xf77f091f,0xa954004f,0x2a710d5b,0xd83b011f}},	//   _üç_, _єкті, _hizb_, _рэг_, 
   {{0xd17508a5,0x26cd0548,0xa3d60d53,0xa3c800b0}},	//   йыны, _upeo_, ाज़_, _लउर_, 
   {{0xe1f90d5c,0x7c2d0d5d,0xe6130071,0x00000000}},	//   уго_, hiar, _بشر_, --, 
   {{0x7c2d0a9f,0xd24e00d4,0x7c360d5e,0x91e50176}},	//   kiar, رچه_, ynyr, _ҳоле, 
   {{0x60060d5f,0x9f060038,0x6d400d60,0xc50c0070}},	//   _cómp, موجو, şmak, _שלאָ, 
   {{0x91e50d61,0x201e00e4,0x528500eb,0x64490d62}},	//   _голе, ėti_, _التك, moei, 
   {{0x442d0d63,0x64490d64,0xe29f003e,0x62720035}},	//   lie_, loei, áðu_, _włoc, 
   {{0xf004005e,0x442d0b22,0x7c2d0d65,0x0c7900c8}},	//   _дүни, oie_, fiar, исты_, 
   {{0x442d0d66,0x7c2d0d67,0xb5fc007b,0x75fd0118}},	//   nie_, giar, _jiġr, _vèzy, 
   {{0x63a60d68,0x7c360009,0x0aea0a31,0x442d0d69}},	// [720] ókni, rnyr, ыдай_, iie_, 
   {{0x442d0d6a,0xc3010086,0x3ea20d6b,0x644901d2}},	//   hie_, এনপি_, mskt_, hoei, 
   {{0x442d0d6c,0x7c2d0d6d,0x3ea20d6e,0x1d0a08ac}},	//   kie_, biar, lskt_, _сени_, 
   {{0x442d0d6f,0x2d9a0d70,0xa3b600b0,0x6e2e0d71}},	//   jie_, _hepe_, _जाइ_, libb, 
   {{0x442d0d72,0x3ea20d73,0xdcfc00e0,0xe737021d}},	//   die_, nskt_, karī, бец_, 
   {{0x6e2e0405,0x27e00d74,0x9e7b0070,0x19fa00b3}},	//   nibb, žin_, אנספ, _сэмь_, 
   {{0xdcfc00e0,0x344a0d75,0x291e004f,0x2d9a023e}},	//   darī, лчин_, _åta_, _mepe_, 
   {{0x442d0d76,0x2d9a0d77,0x64490068,0x6e2e0d78}},	//   gie_, _lepe_, goei, hibb, 
   {{0x3866014e,0xe73a02a0,0x610a00ad,0x00000000}},	//   mmor_, _сеа_, zəld, --, 
   {{0x7c2d0d79,0x442d0d7a,0x2d9a03a0,0x3f820083}},	//   ziar, aie_, _nepe_, ecku_, 
   {{0x442d0d7b,0xa1580849,0xa3b60d7c,0xf99300d1}},	//   bie_, рану_, _जाऊ_, הרת_, 
   {{0x442d0d7d,0x395700a7,0xe29a01a2,0x7c2d0d7e}},	//   cie_, משים_, _бад_, xiar, 
   {{0x7c2d0d7f,0x799e0d80,0x6e2e0036,0xa2b20110}},	//   viar, kapw, fibb, _आमट्, 
   {{0xdb0d02a0,0x2d9a0d81,0x6e2e052b,0x7c2d0083}},	//   lgaç, _cepe_, gibb, wiar, 
   {{0x7c2d0d82,0x2d9a0089,0x6c850038,0x6a690009}},	//   tiar, _depe_, تلزم, _užfi, 
   {{0x388100e4,0x9f3500f0,0x7bd6011c,0x00000000}},	//   _nėra_, _мейі, geyu, --, 
   {{0x7c2d02ba,0x99990d83,0xa3b605d2,0x2d9a0415}},	// [730] riar, икат_, _जाई_, _fepe_, 
   {{0x442d0d84,0x6fb50399,0x7c2d0d85,0xff1800d1}},	//   zie_, _امکا, siar, _לקחת_, 
   {{0x442d0237,0x9f5203a0,0x3c5900d9,0x7bd60027}},	//   yie_, _anyè_, _винэ_, beyu, 
   {{0x28ba034d,0x64490183,0x38660d86,0x00000000}},	//   _उमरि, xoei, gmor_, --, 
   {{0x442d0d87,0xc9870d88,0xb6c70d89,0x6605069b}},	//   vie_, _губи, ссей, жпла, 
   {{0x442d0d8a,0xd9fd0509,0xa3b60d8b,0x853c012d}},	//   wie_, _उचित_, _जाउ_, _idėj, 
   {{0x442d0d8c,0x69d70d8d,0x64490d8e,0x00000000}},	//   tie_, mexe, toei, --, 
   {{0x52a90d8f,0xd7f800f6,0x3ea203c5,0x69d70d90}},	//   авим_, _луу_, yskt_, lexe, 
   {{0x28e10081,0x2d8300ab,0x64490511,0x130600c8}},	//   फिकि, kcje_, roei, жный_, 
   {{0x442d0d91,0x69d70151,0x7d080bf7,0x7bd60027}},	//   sie_, nexe, ødsk, zeyu, 
   {{0x442d0d92,0x64490d93,0x7bd60d94,0xdbc600c2}},	//   pie_, poei, yeyu, mööd, 
   {{0xa3b60d95,0xa2b202f8,0x62860032,0x245800b3}},	//   _जाए_, _आमच्, íkoc, _лахь_, 
   {{0x2d9a0d96,0xe2990d97,0xb7da00d1,0x6d5802d9}},	//   _pepe_, _тал_, בקרי, _úvaz, 
   {{0x63bb0d98,0x5fdc0d99,0x3ea20d9a,0x712508b6}},	//   lgun, _बसवल, rskt_, _ورغل, 
   {{0xc5f200a7,0x7c3a0d9b,0x69d70d9c,0x3866017c}},	//   ודם_, étro, dexe, ymor_, 
   {{0x3ead0d9d,0x26df0082,0x6e2e0d9e,0x799e095a}},	//   šeta_, _osuo_, sibb, wapw, 
   {{0x61e30d9f,0x81dc0086,0x32070da0,0x799e0da1}},	// [740] _kanl, ডার_, _kony_, tapw, 
   {{0x63bb0da2,0x00000000,0x00000000,0x00000000}},	//   hgun, --, --, --, 
   {{0x32070379,0x61e30da3,0x63bb0da4,0x5fc10da5}},	//   _mony_, _manl, kgun, ष्कल, 
   {{0xb8f20da6,0x46ea0da7,0x6d5e0da8,0x61e303c6}},	//   _वह_, иден_, _izpa, _lanl, 
   {{0x38660c43,0x0aa3004e,0xe6660da9,0x4e0e0bb9}},	//   rmor_, _оңтү, отко, _हवाई_, 
   {{0xb0a9047c,0x320700a9,0x61e30daa,0x63bb0dab}},	//   _किंग, _nony_, _nanl, egun, 
   {{0xa3d600a5,0x9f4500bc,0x69ce0dac,0xf8b0010e}},	//   ाजल_, ělé_, _ibbe, _سکا_, 
   {{0x799c0dad,0x61e301a9,0x87b903dc,0x2fc001a0}},	//   _herw, _aanl, _гуфт_, _ncig_, 
   {{0x61e30dae,0x2d830035,0x69c109d8,0x764a0daf}},	//   _banl, ycje_, र्की, pofy, 
   {{0x61e30db0,0x3218006a,0x799c0026,0x320700f6}},	//   _canl, óry_, _jerw, _cony_, 
   {{0x63bb0a9f,0x32070db1,0x799c0876,0xb97b042c}},	//   bgun, _dony_, _merw, יניי, 
   {{0x68e301cc,0x27e60db2,0x69ca0db3,0x799c0db4}},	//   ændi, ndon_, स्ती, _lerw, 
   {{0x26c60db5,0x73360019,0x2ee00183,0x61e302f1}},	//   ntoo_, _برائ, _csif_, _fanl, 
   {{0xd34400c5,0x63a00db6,0x61e30156,0x32070d35}},	//   _ویژه_, lamn, _ganl, _gony_, 
   {{0x27e6012b,0x64b802e6,0x6b84032f,0x0b270033}},	//   kdon_, _इमोश, fcig, _মডেল_, 
   {{0x27e405a1,0x32070db7,0xe3ac0086,0x27e60db8}},	//   _namn_, _zony_, ক্রব, jdon_, 
   {{0x799c0db9,0xa3cc0239,0x0dcb00cf,0x69d703da}},	// [750] _berw, श्य_, _куни_, texe, 
   {{0x3eb90dba,0xaaac0466,0x63a00dbb,0x61e30248}},	//   must_, _चिरक, hamn, _xanl, 
   {{0x799c0dbc,0x69d7040a,0x3eb9007e,0xa3ab007e}},	//   _derw, rexe, lust_, _कएल_, 
   {{0x69d70dbd,0x69ce0dbe,0x6b8402a3,0x661a0dbf}},	//   sexe, _ebbe, ccig, _altk, 
   {{0xd6db0dc0,0x799c0dc1,0x69d70dc2,0x3eb900b0}},	//   рте_, _ferw, pexe, nust_, 
   {{0x95cb0dc3,0x62720035,0x20090023,0xd5b10038}},	//   руда_, _słon, _loai_, رفع_, 
   {{0x1c0f0dc4,0x91fc00e0,0x63bb0dc5,0x6b9d040c}},	//   _सवाल_, rmāl, tgun, _kesg, 
   {{0xd7c900d4,0x61e30dc6,0x3eb9007e,0xe2990dc7}},	//   _دوره_, _sanl, kust_, баи_, 
   {{0x63bb0dc8,0x61e30dc9,0x799c052b,0x32070dca}},	//   rgun, _panl, _yerw, _pony_, 
   {{0x2ea8072f,0x66080dcb,0x3eb90dba,0x63bb0dcc}},	//   _कटौत, _godk, dust_, sgun, 
   {{0x61e30dcd,0xa3bb0116,0x610a00ad,0x3207023a}},	//   _vanl, _ناشر_, vəlc, _vony_, 
   {{0x63a00dce,0xb4e7047c,0x22800cd7,0x54370116}},	//   camn, यटी_, _fòk_, _برطر, 
   {{0xe8030dcf,0x61e300cf,0x3eb90dd0,0xe2850dd1}},	//   _रचना_, _tanl, gust_, _элли, 
   {{0x321e0dd2,0xfc3f0369,0x27380108,0xc4bf00bc}},	//   chty_, _ají_, ẩng_, _एमाओ, 
   {{0xed5a0dd3,0x7aef0dd4,0x27e60dd5,0xdbd9008c}},	//   сов_, _arct, ydon_, tæðu, 
   {{0x799c0da6,0x6b9d0dd6,0x6aa40dd7,0x3eb90dd8}},	//   _serw, _cesg, tsif, bust_, 
   {{0x0b430dd9,0x799c0dda,0x6b840ddb,0xdbd9008c}},	// [760] ентн, _perw, rcig, ræðu, 
   {{0x6aa4005c,0x6b840ddc,0x09e30ddd,0x63a00248}},	//   rsif, scig, ноун, zamn, 
   {{0x799c0dde,0x63a00ddf,0x6b9d0068,0x1b040086}},	//   _verw, yamn, _fesg, _রেখে_, 
   {{0xdcf500ab,0x799c0de0,0x79850de1,0x26c60de2}},	//   jczę, _werw, achw, ttoo_, 
   {{0x799c0de3,0x66080de4,0x27e60de5,0xe3c30033}},	//   _terw, _podk, rdon_, ্যাব, 
   {{0xd49a0de6,0x26c60088,0x98a60de7,0xa96a0ca4}},	//   бри_, rtoo_, _ниге, _гига_, 
   {{0x628b00f8,0x27e60de8,0x80da0035,0x26c60de9}},	//   _atgo, pdon_, _बनें, stoo_, 
   {{0xb60300e0,0xa3b6010b,0x04630dea,0x94dc00c2}},	//   īšan, _जाओ_, нтым, _मनीआ, 
   {{0x27f7000d,0x2bce00a2,0x186703b9,0xf2c30009}},	//   šení_, ह्या, _хати_, нсэн, 
   {{0x59cf00a2,0xe8e000e7,0x3eb9007e,0x63a0008c}},	//   स्पर, _nhịp_, vust_, samn, 
   {{0x69c10cb8,0x3eb9012e,0x00000000,0x00000000}},	//   र्टी, wust_, --, --, 
   {{0x3eb90077,0x5ed60033,0x8fa405b2,0xa3b6072d}},	//   tust_, দিনে, наџе, _जाट_, 
   {{0x6b9d0deb,0x798500f8,0x24490dec,0x3f1401d8}},	//   _resg, ychw, _بجلي_, едяс, 
   {{0x99ce00cc,0x6b9d001d,0x3eb90ded,0x00000000}},	//   রযুক, _sesg, rust_, --, 
   {{0x61f80318,0x3eb9007e,0x248c0036,0xddde010e}},	//   _invl, sust_, _jtdm_, _cipő, 
   {{0x3eb90dee,0x5c740def,0x315700d1,0x25fe058c}},	//   pust_, елст, _מיון_, लाडी_, 
   {{0x3eb90df0,0x3a7502f1,0x00000000,0x00000000}},	// [770] qust_, длар, --, --, 
   {{0xdce701f0,0xa3cc0262,0xdcf50035,0x9967048c}},	//   sajı, श्त_, zczę, птел, 
   {{0x02d90351,0x79850df1,0xb4d601a4,0x52d900bc}},	//   _भन्न, rchw, िबो_, _भन्स, 
   {{0x798502f2,0x69c8027e,0x69c10df2,0x00000000}},	//   schw, _öden, र्जी, --, 
   {{0x601f00e5,0x55e50df3,0x068400f0,0x61f8040b}},	//   _këmb, долб, егін, _onvl, 
   {{0x7bcd0df4,0x7aed0df5,0x8afa00d1,0x7e77008a}},	//   lfau, mvat, _והשי, _jixp, 
   {{0x20f007c7,0x04450df6,0x7aed0df7,0xa50600fd}},	//   nđić_, мекн, lvat, деща_, 
   {{0x3ea90df8,0xfcaa07f5,0x61f805d5,0x3e640219}},	//   _ovat_, קיפּ, _anvl, möte_, 
   {{0x7aed0df9,0x6612039f,0xf1a503a1,0x00000000}},	//   nvat, ükkö, үрүн, --, 
   {{0xbebb024a,0x7aed0dfa,0x6d45021e,0x00000000}},	//   tzën, ivat, _oxha, --, 
   {{0x7aed090b,0x6d45006d,0xa06a0dfb,0xa3c807d5}},	//   hvat, _nxha, жана_, _लॉक_, 
   {{0x7aed00d2,0xe4d40019,0x00000000,0x00000000}},	//   kvat, _ستمب, --, --, 
   {{0x7aed0a1a,0x6d49020f,0x00000000,0x00000000}},	//   jvat, şeal, --, --, 
   {{0x7a200019,0x59cf0c64,0x7aed0dfc,0x00000000}},	//   _köte, स्मर, dvat, --, 
   {{0xafe600cf,0x42520019,0x7bcd0dfd,0x7aed0dfe}},	//   _жойл, _جنور, ffau, evat, 
   {{0x7a20014e,0xc17200a7,0x442f0dff,0x2019024a}},	//   _möte, _בחו_, _jmg_, ërit_, 
   {{0xfaa30e00,0x442f0e01,0x7989010c,0x2eff0380}},	// [780] като, _mmg_, _şewa, äuft_, 
   {{0xee37005e,0xe9d70e02,0x601f024a,0x4a430b97}},	//   _оны_, мку_, _vëme, внув, 
   {{0xb4ac00a5,0xd7e6004f,0x3ea9035f,0x6d400e03}},	//   _कटे_, діло, _zvat_, ğmas, 
   {{0x9f400e04,0x6a8600cf,0x6d40091f,0xafdb0a1f}},	//   _unió_, _олма, şmas, rnøg, 
   {{0xa3c800ab,0xc7a30aa3,0xd6d00e05,0x7aed00b3}},	//   _लॉग_, тичк, اقت_, cvat, 
   {{0x7a200219,0x3eaf02c9,0x6b96050f,0xe8df0023}},	//   _böte, _ægte_, lbyg, _luộc_, 
   {{0xf8d20c46,0x68e302c9,0xa5c40083,0x00000000}},	//   _सहिय, ændt, _राठौ, --, 
   {{0x6b9600dd,0xd4670267,0x00000000,0x00000000}},	//   nbyg, мије_, --, --, 
   {{0x427400cf,0xd4030e06,0x00000000,0x00000000}},	//   нгис, тящи, --, --, 
   {{0x61e804a8,0xf8d20e07,0xdb150107,0x00000000}},	//   uddl, _सहाय, ébéc, --, 
   {{0xd130057f,0x7a20022b,0x7aed08b1,0xe8df001b}},	//   امج_, _göte, zvat, _buộc_, 
   {{0xe8df0029,0x7aed026e,0x442f0036,0x4de70790}},	//   _cuộc_, yvat, _gmg_, _छोड़े_, 
   {{0xd6d900ab,0x6b960e08,0x2ef200f8,0x00000000}},	//   _były_, dbyg, _cryf_, --, 
   {{0x7aed02f1,0x2ef20326,0x6ab60326,0x00000000}},	//   vvat, _dryf_, dryf, --, 
   {{0x1bd50141,0xfe240e09,0x645c01dd,0x00000000}},	//   новя, тьян, _īrij, --, 
   {{0x506700cf,0x20f00097,0x5fc602e6,0xec6807f4}},	//   _ўтка, rđić_, _वायल, друк_, 
   {{0x2ef20e0a,0x20190e0b,0xafdb0d09,0x625d011c}},	// [790] _gryf_, ūris_, rnød, kèol, 
   {{0x6d450e0c,0xe9d30038,0x69ca0e0d,0x9e670e0e}},	//   _txha, ضغط_, स्ली, _تابن, 
   {{0x5884058b,0x7aed0e0f,0x5c750e10,0x47c70033}},	//   выча, svat, _плот, _রোগী, 
   {{0x20190e11,0x99640e12,0x39580b48,0x00000000}},	//   nksi_, ттул, _dyrs_, --, 
   {{0x201900c8,0x59c70d0d,0x97350e13,0x00000000}},	//   iksi_, _लापर, رکرا, --, 
   {{0x68e3055f,0x644200c8,0x2ba7009a,0x649903a1}},	//   ænds, _ajoi, गणका, птир_, 
   {{0x19580e14,0xafdb017b,0x00000000,0x00000000}},	//   _жары_, sløy, --, --, 
   {{0xe73900f8,0x1309004f,0x58d40bfd,0xafdb00fc}},	//   _ddŵr_, зний_, _шост, pløy, 
   {{0x7c3a03b7,0x9f9d008c,0xf6b50019,0x95cb0e15}},	//   étri, væði_, _سماج, _мужа_, 
   {{0x569403dc,0x20190088,0xc879010c,0x7a200380}},	//   _рафт, eksi_, _hiş_, _töte, 
   {{0x6e3504d1,0xf8df00bd,0x442f0e16,0x69c20083}},	//   dizb, नबिय, _tmg_, _लासी, 
   {{0xcdc90056,0x80a000ab,0x59cf0e17,0x3cf900c9}},	//   _לך_, _खबरे, स्तर, _उपजे_, 
   {{0xef170e18,0x9f9d008c,0x6e3503c8,0x00000000}},	//   емя_, ræði_, fizb, --, 
   {{0xfce60e19,0x645b0e1a,0x91e201a2,0xc6920070}},	//   ного, llui, _боше, ראם_, 
   {{0xa3cc08b3,0xeb9a02f1,0x81c80086,0x1d0a0e1b}},	//   श्व_, зиб_, _লোক_, чеви_, 
   {{0x443f0e1c,0x645b0e1d,0xa0a20240,0x0eaa00b3}},	//   nnu_, nlui, _саъд, _екий_, 
   {{0x34dc03be,0x443f0e1e,0x6b960e1f,0x7ae9014b}},	// [7a0] _मन्द, inu_, rbyg, _šetr, 
   {{0x6b960e20,0x8e9700d1,0x443f0e21,0x6d400248}},	//   sbyg, _רדיו_, hnu_, şmaq, 
   {{0x2d980e22,0xf1c20e23,0x69c801f0,0x6b9604f4}},	//   mbre_, _शासन, _ödem, pbyg, 
   {{0x443f0e24,0x7afb0a1a,0xcfb20033,0x41cf0110}},	//   jnu_, _šute, ট্রন, त्तस, 
   {{0x443f0e25,0xc8790384,0x68e30566,0x2caa00b9}},	//   dnu_, _diş_, ændr, lsbd_, 
   {{0x443f0e26,0x45d40e27,0xa3c802e6,0x9f4000b9}},	//   enu_, токс, _लॉज_, _maià_, 
   {{0x443f0e28,0x69de0548,0x5fc600a2,0x1dd20c73}},	//   fnu_, mepe, _वाढल, द्यत, 
   {{0x66e60e29,0x6b7b00c7,0x25fe00a2,0x645b0e2a}},	//   _поба, ּרינ, लाही_, glui, 
   {{0xe7d503c0,0x66b200f0,0x00000000,0x00000000}},	//   lığı, _сұлу, --, --, 
   {{0x443f00d9,0x9fd00086,0x69de0e2b,0xe5a30e2c}},	//   anu_, িযোগ, nepe, _бифи, 
   {{0x7c240e2d,0x443f0e24,0x3a3700d1,0x610a00ad}},	//   khir, bnu_, תרים_, cəll, 
   {{0x645b0e2e,0x351b00a7,0x2d980126,0x25fe0110}},	//   clui, _מובנ, ebre_, लावी_, 
   {{0x69de0e2f,0x20190e30,0x6e350502,0xdefb0e31}},	//   kepe, rksi_, tizb, чын_, 
   {{0xa3cc034d,0x9325010e,0x63a20175,0x127b0070}},	//   श्र_, _جرمن, _heon, _זאגע, 
   {{0x63a20e32,0x69de0e33,0x6282011c,0xc0e30477}},	//   _keon, depe, _huoo, _бојк, 
   {{0xe7d50749,0x63a20e34,0x61ea0e35,0x6282018e}},	//   dığı, _jeon, _hafl, _kuoo, 
   {{0xf1a40e36,0x61ea0d68,0x63a20e37,0x320e0054}},	// [7b0] _खजान, _kafl, _meon, _kofy_, 
   {{0x63a20e38,0x443f0e39,0x69de0e3a,0x5a340e3b}},	//   _leon, znu_, gepe, гнут, 
   {{0x443f0e3c,0x7c240e3d,0x47bc0033,0xdb16039f}},	//   ynu_, bhir, োজনী, rgyá, 
   {{0x7c240e3e,0x61ea0e3f,0x610a00ad,0x28d200c2}},	//   chir, _lafl, vəll, _सहरि, 
   {{0x443f02f5,0x44240084,0x69de0a58,0x66e50e40}},	//   vnu_, dhm_, bepe, тола, 
   {{0x27e900f1,0xe6180e41,0x69de0e42,0x7bdf0e43}},	//   žan_, нді_, cepe, lequ, 
   {{0x443f0112,0x645b0e44,0x6e200034,0x3eb90502}},	//   tnu_, tlui, ëmbi, hrst_, 
   {{0x7bdf02aa,0x33d500f0,0x00000000,0x00000000}},	//   nequ, тікт, --, --, 
   {{0x63a20e45,0x645b0e46,0x045600eb,0x320e0054}},	//   _deon, rlui, خلية_, _bofy_, 
   {{0x443f090b,0x645b0e47,0xd24e00b1,0x7bdf0e48}},	//   snu_, slui, يني_, hequ, 
   {{0x25fe0e49,0x61450e4a,0x63a201a7,0x61ea00f8}},	//   लारी_, тена, _feon, _dafl, 
   {{0x69de0e4b,0x7a2002ae,0x6d5a01a4,0x00000000}},	//   zepe, _möta, ütam, --, 
   {{0x69c702a8,0xf1d100f6,0x69de0e4c,0xdb060098}},	//   _ocje, _көнө, yepe, _odká, 
   {{0xdd920040,0x61ea0e4d,0x69de00b4,0x00000000}},	//   شور_, _gafl, xepe, --, 
   {{0xed570e4e,0xada30e4f,0x7c240e50,0x63a20089}},	//   вор_, расл, thir, _yeon, 
   {{0x1c430e51,0x63a20042,0x60d607e4,0x69de018e}},	//   ансм, _xeon, _יוצא_, wepe, 
   {{0x6a830e52,0xeab1006b,0x7c2403c6,0xc1e50e53}},	// [7c0] илта, یعے_, rhir, _कसाब_, 
   {{0x7c240e54,0xceb9000d,0x68f5026e,0x61ea01cf}},	//   shir, áře_, _brzd, _xafl, 
   {{0x291c0c7f,0x7c240364,0x69de0e55,0x7bdf0e56}},	//   áva_, phir, repe, bequ, 
   {{0x69de0e57,0x7bc600ef,0xe73a0209,0x7ae60102}},	//   sepe, _ucku, мее_, _tskt, 
   {{0x63a200ef,0xc5f8004e,0x69de0e58,0x627200ab}},	//   _reon, нға_, pepe, _głow, 
   {{0x4a750088,0x63a20e59,0x7bc40e5a,0x7ae40e5b}},	//   _быст, _seon, lgiu, mwit, 
   {{0x63a20e5c,0x98a30e5d,0x7a200219,0x7ae40326}},	//   _peon, _висе, _göta, lwit, 
   {{0x61ea02bf,0x7bc40e5e,0xa78500eb,0xf1cf0249}},	//   _safl, ngiu, _مشكو, त्सन, 
   {{0x7c23002e,0x59cf000c,0x7ae401f2,0x32540e5f}},	//   _înre, स्वर, nwit, лвир, 
   {{0x610a0095,0x63a20126,0x05c90035,0x7aeb02c9}},	//   səlm, _weon, _रायब, ægti, 
   {{0x859b02a1,0x9f4e026e,0x3ea00e60,0x85060e61}},	//   _חשבו, čným_, _awit_, _جوان, 
   {{0xc9530056,0x7ae40e62,0xe7b400b0,0x7d0300f6}},	//   ימת_, kwit, ुलिप, _ànsi, 
   {{0xd5c9007e,0x05c90c59,0x61ea0e63,0x81d40165}},	//   _रामज, _रामब, _tafl, _болх, 
   {{0x6e940088,0x7ae4044d,0x7bc400c2,0x00000000}},	//   риру, dwit, egiu, --, 
   {{0x6272006a,0x7bdf0e64,0x1dd205d0,0xc27b035c}},	//   _słow, tequ, द्धत, _קרוי, 
   {{0xd10f034d,0x7bc40141,0xe3c90183,0xa17700d1}},	//   ाहरण_, ggiu, mañá_, _בעוד_, 
   {{0xdb1d05d5,0x41cf021a,0x7a2002ae,0x3e6b03a1}},	// [7d0] _absò, त्वस, _söta, _ошон_, 
   {{0x7bdf06a5,0x200b044e,0xf7f400c5,0x2ee900f8}},	//   sequ, ljci_, یسند, _isaf_, 
   {{0x2d81016c,0xf8b600d3,0xac190596,0xa7b900f0}},	//   _ighe_, лөт_, _зону_, елеу_, 
   {{0x787a031e,0xc8640e65,0x7ae40e66,0x3ea00118}},	//   _důvo, атчи, bwit, _ywit_, 
   {{0xdb0d00c2,0x601f021e,0x00000000,0x00000000}},	//   ngaü, _lëmo, --, --, 
   {{0x69c70e67,0x65c50e68,0x6b8d0e69,0x26360035}},	//   _ucje, убка, lcag, słon_, 
   {{0x6aad0a04,0x00000000,0x00000000,0x00000000}},	//   lsaf, --, --, --, 
   {{0x6b8d0e6a,0x2fc9006d,0x69c50e6b,0x32cb00dd}},	//   ncag, _ncag_, lghe, tøy_, 
   {{0x2bd50e6c,0x65950e6d,0x69ca0e6e,0x00000000}},	//   ड्या, _базу, स्की, --, 
   {{0x2d810029,0x27ed0e6f,0xb22200d3,0x32cb004f}},	//   _nghe_, _haen_, ймыл, røy_, 
   {{0xe4cb0e70,0x69c50094,0x1acf0086,0x2ee90e71}},	//   _زبان_, ighe, রিয়া, _asaf_, 
   {{0x27ed0e72,0x7643016a,0xf3f00038,0x6aad0e73}},	//   _jaen_, lnny, _وأن_, ksaf, 
   {{0x25a50e74,0x27ed0e75,0x63a90e76,0xdcee04be}},	//   _kell_, _maen_, maen, vabı, 
   {{0x27ed0e77,0x63a90e78,0x3d28009c,0x6aad0e79}},	//   _laen_, laen, نتزی_, dsaf, 
   {{0x61e10e7a,0x27ff0e7b,0x03e600cc,0xdcee07fa}},	//   mell, _onun_, কারী_, tabı, 
   {{0x61e10e7c,0x6b8d0574,0xf1cf0e7d,0x63a90e7e}},	//   lell, gcag, त्रन, naen, 
   {{0xab660353,0x200002cd,0x764302cd,0x6459044d}},	// [7e0] увал, _inii_, knny, _mkwi, 
   {{0x25a5048a,0xdcee07fa,0x787a031e,0x63a907d7}},	//   _nell_, sabı, _půvo, haen, 
   {{0x7ae40e7f,0x61e10093,0x610a0095,0x60c10e80}},	//   swit, iell, vəlk, nulm, 
   {{0x61e10e81,0x6b8d0e82,0x27ed0e83,0x201200a3}},	//   hell, ccag, _caen_, _joyi_, 
   {{0x61e10e84,0x7e7e0e85,0x63a90e86,0x25a500df}},	//   kell, _kipp, daen, _bell_, 
   {{0x7e7e0405,0x61e10e87,0x25a50e88,0x64590e89}},	//   _jipp, jell, _cell_, _akwi, 
   {{0x61e10e8a,0x25a50e8b,0x83fd0019,0x63a900b9}},	//   dell, _dell_, klőd, faen, 
   {{0x76430730,0x3a3a0e8c,0x44220019,0x7e7e0e8d}},	//   anny, lipp_, ók_, _lipp, 
   {{0x61e10e8e,0x57460e8f,0x610a0095,0xe3af0e90}},	//   fell, _снаб, məli, سري_, 
   {{0x61e10e91,0x64590e92,0xf1c6031e,0x200000d9}},	//   gell, _ekwi, _část_, _anii_, 
   {{0x63a90c36,0x20120e93,0x2bd50299,0xca570147}},	//   baen, _boyi_, ड्डा, רייז_, 
   {{0x0eeb0088,0x25a50e94,0x69c50474,0x610a0248}},	//   ньги_, _zell_, zghe, nəli, 
   {{0x9f42010c,0xe29603b7,0x248501ff,0x69c502c9}},	//   lekê_, _среќ, _zulm_, yghe, 
   {{0x61e10e95,0x7e7e02a3,0x7a2002ae,0x25a500b9}},	//   cell, _cipp, _sötn, _xell_, 
   {{0x9f42010c,0x23b800b0,0xdd940e96,0x9ed80259}},	//   nekê_, _इयाद, сасы, _ұмыт_, 
   {{0x60df006b,0x7c8400f0,0xc0c704b6,0x6d5e021e}},	//   őzmé, суре, _суше_, _dypa, 
   {{0x5a350e97,0x765a0e98,0x76430e99,0xc88000ad}},	// [7f0] анат, _okty, ynny, əşir_, 
   {{0x27ed03da,0x321e00ab,0x6b8d0e9a,0x6aad0e9b}},	//   _saen_, nkty_, scag, rsaf, 
   {{0xa3e50262,0x69c50e9c,0x6aad0e9d,0x99670e8f}},	//   _फसल_, rghe, ssaf, утал, 
   {{0x61e10e9e,0x765a0e9f,0x627200ab,0x67d50ea0}},	//   zell, _akty, _złot, роду, 
   {{0x25a50ea1,0x60c10ea2,0x7643016a,0x35a5022c}},	//   _pell_, zulm, tnny, аалг, 
   {{0xf7700ea3,0x61e10a3f,0x60c104be,0xbb3a035c}},	//   سان_, xell, yulm, _יערי, 
   {{0x25a50ea4,0x61e10ea5,0x63a90ea6,0x7643016a}},	//   _vell_, vell, taen, rnny, 
   {{0x61e10ea7,0x25a50056,0x7643016a,0x321e0083}},	//   well, _well_, snny, ekty_, 
   {{0x61e1074a,0xcb1200c7,0x25a500a7,0x52a60009}},	//   tell, ַלט_, _tell_, авым_, 
   {{0x63a90ea8,0x60c10540,0x22150ea9,0x046700f0}},	//   saen, tulm, рфир, _өтем, 
   {{0xc5fa00c7,0x63a90eaa,0x386d0118,0xb5fa00c7}},	//   _שפעט, paen, _kher_, _שלעכ, 
   {{0x61e10eab,0x43750593,0x60c1091f,0x64590199}},	//   sell, _култ, rulm, _ukwi, 
   {{0x60c10eac,0xe7d70ead,0x7afb0eae,0x7e7e0eaf}},	//   sulm, ण्यप, _šutn, _pipp, 
   {{0x387f085f,0x6da30eb0,0x60c10eb1,0x610a00ad}},	//   _liur_, жира, pulm, zəli, 
   {{0xed5a0eb2,0xe8160081,0x6286026e,0xdca60eb3}},	//   тов_, _थकला_, íkov, раби, 
   {{0x20000eb4,0x6d5e037f,0xff5f009e,0x387f00a1}},	//   _unii_, _vypa, mgîn_, _niur_, 
  
   {{0x7e7e0eb5,0xdee600cf,0x627200ab,0x6d5e00ab}},	// [800] _tipp, _топи, _głos, _wypa, 
   {{0x9f420216,0x386d016a,0x6d4100eb,0x3c3f00c8}},	//   yekê_, _aher_, úlac, tävä_, 
   {{0xff5f010c,0x78a200ef,0x6e3c0eb6,0x57a600a3}},	//   ngîn_, ćovo, mirb, ашла, 
   {{0x386d026d,0xd7f900f0,0xe8df0108,0xd90d0eb7}},	//   _cher_, луі_, _cuốc_, ریق_, 
   {{0x66f40eb8,0x386d01be,0x387f0eb9,0xc6a30eba}},	//   сплу, _dher_, _diur_, орщи, 
   {{0xfaa30ebb,0x386d02f2,0x9f42009e,0xdb060034}},	//   _фаро, _eher_, tekê_, _lekë, 
   {{0x29070219,0x7589004f,0x00000000,0x00000000}},	//   änat_, усів_, --, --, 
   {{0x9f42009e,0x6a6b0380,0x986a00b3,0x68e20083}},	//   rekê_, rüfe, _рибб_, łods, 
   {{0xf5ea04a0,0x7989010c,0x6e3c0104,0xdb0d003e}},	//   _имал_, _şewi, kirb, ngað, 
   {{0xd4d600e4,0x387f01ca,0xe8040110,0x00000000}},	//   _відэ, _ziur_, ळावा_, --, 
   {{0x6e3c0ebc,0x7416009c,0x60190009,0x506701ff}},	//   dirb, _پوشا, гоня_, итма, 
   {{0xdb060ebd,0x76580ebe,0x7d1c0ebf,0x91fc0243}},	//   _vekê, lovy, dyrs, flāc, 
   {{0x22940ec0,0x44260ec1,0x329400eb,0xd0420095}},	//   _التس, _ilo_, _التأ, ntlə, 
   {{0x4426006f,0x7c26052b,0x765800da,0x91e30080}},	//   _hlo_, _alkr, novy, _моче, 
   {{0x44260ec2,0xda05000f,0x2ba70aa3,0x627200ab}},	//   _klo_, रासत_, ијав, _włos, 
   {{0xf21c0262,0x5bb80088,0x717b00a7,0xd04200ad}},	//   _पकड़_, ился_, _בנוס, ktlə, 
   {{0xb06600b0,0x32d00023,0x44260548,0x3cfa00b9}},	// [810] svää, này_, _mlo_, _erpv_, 
   {{0x44260ec3,0xb98502c0,0x6e3c00ef,0x386d0dc5}},	//   _llo_, стақ, cirb, _sher_, 
   {{0xda780ec4,0x44260ec5,0x4f580a24,0xfb870b58}},	//   рят_, _olo_, _مجید_, _выгн, 
   {{0xe8df00f7,0xd1260105,0xa7750ec6,0x7aeb02c9}},	//   _quốc_, _ہم_, блеч, ægts, 
   {{0xff5f009e,0x6eaa0d53,0x6f1d0ec7,0x610a0248}},	//   zgîn_, जीपु, nysc, məlu, 
   {{0xe5a20ec8,0xcb120486,0x2d910ec9,0x00000000}},	//   пиши, _צלם_, ncze_, --, 
   {{0x4426008b,0x29070eca,0xb4e1009a,0x00000000}},	//   _blo_, ånad_, धबे_, --, 
   {{0x43690ecb,0x44260ecc,0x13e902f1,0xd5c902e6}},	//   лайн_, _clo_, умий_, _रावज, 
   {{0x44260cd7,0x56940ecd,0x765800de,0x00000000}},	//   _dlo_, _матт, bovy, --, 
   {{0x44260ece,0xb2250ecf,0xaac80299,0x786a00da}},	//   _elo_, смол, िंतक, mýva, 
   {{0x6d4006a2,0x7afb0372,0x1b1b0033,0x786a0ed0}},	//   şmaz, _šutl, _নেমে_, lýva, 
   {{0x44260ed1,0xdee60ed2,0x92d60033,0x6e3c0502}},	//   _glo_, боми, ায়ে_, wirb, 
   {{0x28c902e6,0x2bcb0ed3,0x6e3c0a6d,0x527502aa}},	//   ांडि, िलना, tirb, _луку, 
   {{0xe29c00c7,0x216902f1,0x7d1c0034,0x51950038}},	//   _ישׂר, _йили_, tyrs, _الغذ, 
   {{0x82340ed4,0x1d1902fb,0x6fc1009a,0x50db0ed5}},	//   _برنا, ають_, _वाचू, _बहिष, 
   {{0x61b700a2,0x3b860ed6,0x6f1d0ed7,0x2d910083}},	//   _आयुष, слаг, bysc, acze_, 
   {{0xe9da0ed8,0xc05300a7,0x3b0702c4,0x62720083}},	// [820] лка_, _מזה_, бето_, _kłop, 
   {{0x7dea0080,0xdb0d01d5,0xf9c40e0e,0x00000000}},	//   _смог_, rgað, تحری, --, 
   {{0xe804009a,0xd23a0070,0x76580ed9,0x00000000}},	//   ळाला_, נגעל, vovy, --, 
   {{0xa96700fd,0xa2aa0eda,0xbb7601d8,0x00000000}},	//   щиха_, _फ़िल्, _гугъ, --, 
   {{0x2907014e,0x628f0edb,0x442600ca,0x765800da}},	//   änar_, ícol, _rlo_, tovy, 
   {{0x44260edc,0xd0420095,0xe4a60edd,0x644b00b9}},	//   _slo_, rtlə, брио, _ajgi, 
   {{0x26190ede,0xd497012d,0xd0420095,0x6f1d0035}},	//   _बकरी_, бры_, stlə, zysc, 
   {{0x290500d0,0x786a0edf,0x941800c8,0x3c2700c2}},	//   _šlag_, býva, ржит_, _kõva_, 
   {{0x59cf0ee0,0x27e60ee1,0x6a700219,0x69c80ee2}},	//   स्कर, meon_, räff, _ödes, 
   {{0x6d4003c0,0xdb060574,0x20f700b3,0x09e60033}},	//   şmay, _ceké, _băi_, নাকা, 
   {{0x69dc0ee3,0x44260ee4,0x69ce0118,0x20f7020f}},	//   _mbre, _tlo_, _mcbe, _căi_, 
   {{0x438600eb,0x44260ee5,0x2d9100ab,0x442000e7}},	//   _الإق, _ulo_, wcze_, _ôi_, 
   {{0x69dc0ee6,0x00000000,0x00000000,0x00000000}},	//   _obre, --, --, --, 
   {{0x44f800e7,0xdd9403fd,0x2d85017b,0x25fe0299}},	//   _kĩ_, зары, øle_, लाटी_, 
   {{0x786a0377,0x2d910035,0xb4250083,0xceb400ad}},	//   zýva, rcze_, łżeń, _evə_, 
   {{0x9f42009e,0xa3cc0ee7,0x44f80023,0x00000000}},	//   mekî_, श्च_, _mĩ_, --, 
   {{0x7b670ee8,0x9f42010c,0x9f52009e,0x69dc008a}},	// [830] стве, lekî_, _layê_, _bbre, 
   {{0x69dc00a1,0x6495007b,0x00000000,0x00000000}},	//   _cbre, _uġig, --, --, 
   {{0x9f42010c,0x9f520218,0xf96b0ee9,0xa3e800bd}},	//   nekî_, _nayê_, урай_, मजा_, 
   {{0x7c670eea,0x69dc0eeb,0x7aee00c8,0x7d1a0eec}},	//   _داخل, _ebre, äntä, ätse, 
   {{0x7c2d0eed,0x9f420eee,0xdcf506a2,0x6a620379}},	//   mhar, hekî_, mazı, zôfi, 
   {{0x7c2d0eef,0x69d80ef0,0x9f52010c,0x786a014b}},	//   lhar, न्दी, _bayê_, rýva, 
   {{0x24090152,0xafdb055f,0xdb060175,0x25fe0ef1}},	//   инки_, rnøj, _reké, लाजी_, 
   {{0x7afd0571,0x7c2d0ef2,0x601f01ee,0x44f800e7}},	//   _krst, nhar, _fëmi, _dĩ_, 
   {{0xc7b90019,0x20f700b3,0x7afb02c7,0x20d10126}},	//   _idő_, _săi_, _šutj, wái_, 
   {{0x1ddb0827,0xdcf50ef3,0x82350e90,0x20f7020f}},	//   म्मत, hazı, تربا, _păi_, 
   {{0x21690c67,0x7c2d0ef4,0x7bcf0ef5,0x71690148}},	//   рини_, khar, _occu, ранг_, 
   {{0x7c2d0026,0xe8e00108,0x20d10ef6,0x7afd0ef7}},	//   jhar, _chộp_, rái_, _orst, 
   {{0x7c2d0ef8,0x442d006e,0x6d410ef9,0xc7d600d1}},	//   dhar, mhe_, úlan, חורי_, 
   {{0x443f0efa,0x442d03b7,0x7bcf0efb,0x628b0efc}},	//   liu_, lhe_, _accu, _iugo, 
   {{0x27e60605,0x7afd0efd,0x628307fc,0x6495008a}},	//   yeon_, _arst, _iino, _fġie, 
   {{0x443f0efe,0x64490eff,0x442d03b7,0x628b0f00}},	//   niu_, nnei, nhe_, _kugo, 
   {{0xda050f01,0x63ab0019,0x64490f02,0x6a700f03}},	// [840] रांत_, _megn, inei, häfe, 
   {{0x63ab0f04,0x64490f05,0x628b0f06,0x62830f07}},	//   _legn, hnei, _mugo, _jino, 
   {{0x7afd0f08,0x7c2d0f09,0x442d0204,0x443f012d}},	//   _erst, bhar, khe_, kiu_, 
   {{0x7c2d0f0a,0x442d0f0b,0x62990035,0x645b0107}},	//   char, jhe_, _otwo, joui, 
   {{0x442d0f0c,0x443f0f0d,0x44f80029,0x7c240f0e}},	//   dhe_, diu_, _sĩ_, mkir, 
   {{0x9f42009e,0x7c240f0f,0xdb06010c,0x8c1f00cc}},	//   yekî_, lkir, _yekî, নোদন_, 
   {{0x7a2001c4,0x291c00b0,0x443f0f10,0x628b01dd}},	//   _nöti, ävad_, fiu_, _augo, 
   {{0x442d0f11,0x443f0f12,0x7c240f13,0x62830088}},	//   ghe_, giu_, nkir, _aino, 
   {{0x62830f14,0x63ab0f15,0x628b00ca,0x63b90090}},	//   _bino, _degn, _cugo, _ddwn, 
   {{0x38660f16,0x628b02f5,0x7c240218,0x442d0102}},	//   llor_, _dugo, hkir, ahe_, 
   {{0xf9930056,0x7c240f17,0x443f0f18,0x69fb00fe}},	//   ורת_, kkir, biu_, בליק, 
   {{0x443f0f19,0x9f420218,0x63ab0f1a,0x628b0f1b}},	//   ciu_, rekî_, _gegn, _fugo, 
   {{0xe1ef0f1c,0x62830f1d,0xc7b30056,0x386600d9}},	//   رسی_, _fino, ובר_, ilor_, 
   {{0x7c2d0f1e,0x62830f1f,0x63ab0054,0x7c2408e5}},	//   whar, _gino, _zegn, ekir, 
   {{0x7c2d0f20,0x61e80c43,0xfe6e015f,0x7c240f21}},	//   thar, medl, دگي_, fkir, 
   {{0x62830f22,0x38660f23,0x60c8011d,0xdd9a0176}},	//   _zino, jlor_, mudm, ишӣ_, 
   {{0x7c2d0f24,0x8d870f25,0xdceb03c0,0x628b0183}},	// [850] rhar, _мунд, ınız, _xugo, 
   {{0x7c2d0f26,0x61e802bf,0x64400f27,0x443f0f28}},	//   shar, nedl, himi, ziu_, 
   {{0x64400f29,0x7c2d0f2a,0xf8b10274,0x44240065}},	//   kimi, phar, عکس_, kkm_, 
   {{0xdce50029,0x443f0f2b,0x64400f2c,0x25ac0068}},	//   _nghĩ, xiu_, jimi, _aedl_, 
   {{0x63ab0f2d,0x66050f2e,0x443f0f2f,0xe8e000e7}},	//   _regn, зпла, viu_, _khớp_, 
   {{0x63ab048a,0x61e80f30,0x628b0f31,0x7aed0f32}},	//   _segn, jedl, _rugo, mwat, 
   {{0x442d0f33,0x443f0f34,0x64400f35,0x628b0f36}},	//   the_, tiu_, fimi, _sugo, 
   {{0x7bcd0f37,0x64400f38,0x3f890f39,0x628b0f3a}},	//   ngau, gimi, _ngau_, _pugo, 
   {{0x443f0f3b,0x63ab010d,0x62830f3c,0x442d0f3d}},	//   riu_, _vegn, _pino, rhe_, 
   {{0x442d0f3e,0x443f0f3f,0x7c240f40,0x63ab0f41}},	//   she_, siu_, zkir, _wegn, 
   {{0x442d0f42,0x63ab0f43,0x64400f44,0x3ea90f45}},	//   phe_, _tegn, bimi, _awat_, 
   {{0x64400f46,0x7aed0f47,0x628b0f48,0x3ea906df}},	//   cimi, kwat, _tugo, _bwat_, 
   {{0x62830f49,0x7c24078a,0xd5d200bd,0x62990035}},	//   _tino, vkir, _सामज, _utwo, 
   {{0x7aed0f4a,0x3ea906df,0xe80200a5,0xe8e00023}},	//   dwat, _dwat_, _रोना_, _chớp_, 
   {{0x7c240f4b,0x32070035,0x00000000,0x00000000}},	//   tkir, _inny_, --, --, 
   {{0x5fc602f8,0x3ebf0f4c,0x7bcd002c,0xdddc014b}},	//   _वाटल, šuta_, ggau, zorň, 
   {{0x7c240f4d,0x6e460f4e,0x6fa2058f,0x7aed0f4f}},	// [860] rkir, _неиз, _क्यू, gwat, 
   {{0x7c240f50,0x64400f51,0x4efb0070,0x1efb0070}},	//   skir, zimi, _פליג, _פליע, 
   {{0x64400f52,0xae1b00c7,0x7aed085b,0x7c24010c}},	//   yimi, _הויכ, awat, pkir, 
   {{0x7aed0f53,0x7c240216,0x00000000,0x00000000}},	//   bwat, qkir, --, --, 
   {{0x64400f54,0x38660f55,0xa2bd0367,0x00000000}},	//   vimi, rlor_, _शिष्, --, 
   {{0x97c3004e,0x442400e2,0x160300a5,0x64400f56}},	//   _үйре, wkm_, लागर_, wimi, 
   {{0xf8e00081,0x443d0f57,0x61e80f58,0x64400f59}},	//   _नहिय, _bmw_, vedl, timi, 
   {{0x7afb01b4,0x18a60f5a,0x60c80f5b,0x329802a0}},	//   _šuti, _маҳм, vudm, овиќ_, 
   {{0x5fc6009a,0x61e8015c,0x00000000,0x00000000}},	//   _वाजल, tedl, --, --, 
   {{0x64400f5c,0x80c00b3e,0xa2bd0e17,0x248c00e2}},	//   simi, _विदे, _शिर्, _tudm_, 
   {{0x64a30f5d,0x660801cc,0x859b00a7,0xb38600b3}},	//   _заха, _indk, _השבו, _елел, 
   {{0x7aed006a,0x35d20262,0x61e80f5e,0x64400f5f}},	//   ywat, _साड़, sedl, qimi, 
   {{0x82fa0116,0x661a0f60,0x22a5010c,0xd5b10210}},	//   _دراز_, _kotk, rêkî_, _món_, 
   {{0x661a030f,0xe3b00499,0xf2c500f0,0x00000000}},	//   _jotk, _سرچ_, _ісін, --, 
   {{0x601f00e5,0x61db02a1,0x5fc600a2,0x7bcd0f61}},	//   _sëmu, _הקוד, _वाचल, tgau, 
   {{0x7aed0f62,0x8c6400f0,0x7bcd0028,0x00000000}},	//   twat, етуд, ugau, --, 
   {{0xa3de0239,0x35d20f63,0x20090640,0x601f024a}},	// [870] द्य_, _साढ़, _inai_, _dëmt, 
   {{0x24860084,0x91fc002a,0x7c8701d7,0x661a008c}},	//   _liom_, klām, _нуме, _notk, 
   {{0x7aed0149,0xf9880038,0x3e64003e,0x9f520151}},	//   swat, أنمي_, götu_, _rayé_, 
   {{0xa2bd0f64,0x9f52009e,0xa3de00bd,0x5fbf0f65}},	//   _शिल्, _mayî_, द्म_, ्लिल, 
   {{0xd6db0f66,0x2366006d,0x9f520107,0x200900a1}},	//   сте_, _nyoj_, _payé_, _mnai_, 
   {{0x443d016a,0x992b0f67,0x661a009e,0x95cb0f68}},	//   _smw_, _люба_, _cotk, суда_, 
   {{0x80db00aa,0x649803a1,0x661a0f69,0xf8ae00d7}},	//   _बहें, птыр_, _dotk, _نکن_, 
   {{0x3e64039f,0x00000000,0x00000000,0x00000000}},	//   lött_, --, --, --, 
   {{0x661a0f6a,0x65950f6b,0xe1f2010e,0x00000000}},	//   _fotk, _жазу, چسپ_, --, 
   {{0x20090f6c,0x80d9004f,0x45d409f9,0x7a2001d5}},	//   _anai_, оєму_, _поус, _fötu, 
   {{0x76430f6d,0x248602a3,0xb7bd00b3,0x443d0036}},	//   miny, _fiom_, _alţi, _tmw_, 
   {{0xa3ae08c6,0x59dd0f6e,0xeb0d0f6f,0x9f52009e}},	//   करण_, न्तर, _सपूत_, _dayî_, 
   {{0x7a200f70,0xd09206d0,0xdb06033c,0x3e640f71}},	//   _kött, _müəy, _pekí, kött_, 
   {{0xfce600dd,0x3e64010e,0x7a20039f,0x00000000}},	//   мого, jött_, _jött, --, 
   {{0x91fc00e0,0x7a200f72,0x3e64010e,0x00000000}},	//   klāj, _mött, dött_, --, 
   {{0x76430f73,0x601f024a,0x00000000,0x00000000}},	//   hiny, _dëms, --, --, 
   {{0x76430f74,0xcb670f75,0xdd8f006b,0xbb430f76}},	// [880] kiny, дате_, اوہ_, ветк, 
   {{0x76430f77,0x67220548,0x7a2002ae,0x3e64010e}},	//   jiny, vyoj, _nött, gött_, 
   {{0x76430f78,0x6ab603c5,0x00000000,0x00000000}},	//   diny, ssyf, --, --, 
   {{0x3b0a0f79,0x50c50f7a,0x80c001a4,0x27e00a6d}},	//   _демо_, _विनष, _विसे, ýin_, 
   {{0x76430f7b,0x24860f7c,0x00000000,0x00000000}},	//   finy, _riom_, --, --, 
   {{0xd49a0f7d,0x59dd0a50,0x9d450019,0xceb902d9}},	//   ори_, न्दर, _آئین, áři_, 
   {{0xa96700c8,0x7a2002ae,0x00000000,0x00000000}},	//   _жира_, _dött, --, --, 
   {{0xa8030141,0xb7fb031e,0xf3180176,0x9f520216}},	//   _изсл, _एफएम_, зоиш_, _rayî_, 
   {{0x7a20014e,0x76430f7e,0x02a300b3,0x9f520216}},	//   _fött, biny, крэм, _sayî_, 
   {{0x7a200f7f,0x76430f80,0x20090036,0x9f520216}},	//   _gött, ciny, _snai_, _payî_, 
   {{0x248601be,0x00000000,0x00000000,0x00000000}},	//   _tiom_, --, --, --, 
   {{0x3e64006b,0x5346093d,0x03260f81,0xdb0f02be}},	//   zött_, _охла, _оден, _decê, 
   {{0xdef80f82,0x00000000,0x00000000,0x00000000}},	//   мыр_, --, --, --, 
   {{0xdb040151,0x00000000,0x00000000,0x00000000}},	//   mbiè, --, --, --, 
   {{0xdd9408ad,0x00000000,0x00000000,0x00000000}},	//   тасы, --, --, --, 
   {{0x76430f83,0x61f80f84,0x20090f85,0x9f420379}},	//   ziny, _havl, _unai_, bekà_, 
   {{0x61f80f86,0x76430f87,0x3a750f88,0x2ef40161}},	// [890] _kavl, yiny, елар, _азыр, 
   {{0x61f803ef,0x61fa00fb,0x4a540edd,0x998700d8}},	//   _javl, ndtl, вкус, ónů_, 
   {{0xa3ae0077,0x64dd0f65,0x7a200760,0x76430f89}},	//   करा_, _महेश, _rött, viny, 
   {{0x2c2702fb,0xfc3f00bc,0x6d5701f2,0x76430090}},	//   _цьог, _umí_, _ixxa, winy, 
   {{0x76430f8a,0x6b9a00d1,0x787102ae,0xd5e509f9}},	//   tiny, _משרד, gåva, ежли, 
   {{0xf7700399,0xe618005e,0x321c014b,0x00000000}},	//   جام_, мді_, _novy_, --, 
   {{0x76430f8b,0x80c00f8c,0x9f4e02d9,0x00000000}},	//   riny, _विषे, čném_, --, 
   {{0x76430f8d,0xc7c400b3,0x9f4b02be,0x00000000}},	//   siny, _асфи, recê_, --, 
   {{0xa3de0f8e,0x76430f8f,0x61f80f90,0xe8df00e7}},	//   द्ध_, piny, _bavl, _khỏa_, 
   {{0x80c009d3,0x3eb9004f,0xf52700b3,0x00000000}},	//   _विशे, dsst_, _офен, --, 
   {{0x61f80c67,0xe0460f91,0x9046009c,0x64450f92}},	//   _davl, енни, فنده, éhis, 
   {{0x44f10904,0xdb060187,0xb4fa00d1,0xa3de0f93}},	//   _iš_, _leká, _מפעי, द्द_, 
   {{0xc2c8024f,0x93270491,0xd12e0f94,0x69d50035}},	//   _قبول_, _تران, لمی_, _ocze, 
   {{0x2d8c0f95,0x32d903a0,0x61f80f96,0x8f810259}},	//   øde_, mèy_, _gavl, шқыл, 
   {{0xdb040f97,0x1d070f98,0xb4ad0077,0x32d906df}},	//   mbié, нери_, _कबो_, lèy_, 
   {{0x44f1014b,0x3c2e0032,0xdb0f011c,0x321c01a7}},	//   _mš_, _býva_, _kecè, _zovy_, 
   {{0x32d905d5,0x44f10df4,0x2903003d,0x442f0f99}},	// [8a0] nèy_, _lš_, _arja_, _mlg_, 
   {{0x4a430f9a,0xdb0f011c,0x6f040f9b,0x2d9a02be}},	//   гнув, _mecè, _iric, _ufpe_, 
   {{0x4c860f9c,0xd8260f9d,0x442f0f9e,0x7a2002ae}},	//   _плов, нджи, _olg_, _söts, 
   {{0x6f040f9f,0xa01b0fa0,0x69d50fa1,0xdc9b0070}},	//   _kric, rmög, _ecze, _מיטל, 
   {{0xdcfc06d0,0x44f100e4,0xc5f8004e,0x45d40fa2}},	//   marı, _aš_, мға_, волс, 
   {{0xdcfc0fa3,0xceb3035c,0x6aa40180,0x6f0401e5}},	//   ları, ריג_, mpif, _mric, 
   {{0x442f0fa4,0xdb1d0118,0x6e200034,0x00000000}},	//   _blg_, _adsè, ëmby, --, 
   {{0x6f040012,0x61f80fa5,0xdcfc0761,0x442f007a}},	//   _oric, _savl, narı, _clg_, 
   {{0x44f102fe,0x53340fa6,0xe7370fa7,0x99610243}},	//   _eš_, тепт, _зет_, _cīņa_, 
   {{0x2d8c0377,0xdb0f00b9,0x442f0fa8,0x44f10604}},	//   ždej_, _decè, _elg_, _fš_, 
   {{0x40350fa9,0xdcfc01f0,0x6f040faa,0x44f102fe}},	//   венс, karı, _aric, _gš_, 
   {{0x6f040c04,0x32d90237,0x00000000,0x00000000}},	//   _bric, bèy_, --, --, 
   {{0x61f80fab,0x6d480634,0x44f1014b,0x93460fac}},	//   _tavl, údan, _zš_, _янде, 
   {{0x6f04014e,0xbe880fad,0xeda7021d,0x00000000}},	//   _dric, ессе_, эшмо, --, 
   {{0xf1b30056,0xcfb00033,0x2d850fae,0xd12f004f}},	//   _עסק_, _কারন, äle_, _сх_, 
   {{0x6f040faf,0x3ea00405,0x628a01a7,0xac180267}},	//   _fric, _ftit_, _hifo, носу_, 
   {{0x6c540fb0,0xf9c70fb1,0x06e80086,0xdb16009e}},	// [8b0] укту, ещен, পিডি, layê, 
   {{0xddde0082,0x8b0800d8,0x00000000,0x00000000}},	//   _tipš, _spřá, --, --, 
   {{0xe8020081,0x628a0fb2,0xdcfc06a2,0x6c5501a2}},	//   _रोहा_, _mifo, barı, _акну, 
   {{0x69d500ab,0x628a0fb3,0xdcfc00ad,0x99640fb4}},	//   _wcze, _lifo, carı, утул, 
   {{0xe8df001b,0x799c0156,0x44f10fb5,0x80380070}},	//   _thỏa_, _ffrw, _sš_, ענדע_, 
   {{0xb5c20fb6,0x442f0068,0x69d500ab,0x628a0180}},	//   айшл, _slg_, _ucze, _nifo, 
   {{0x442f0fb7,0x22450352,0xaa540d3d,0x00000000}},	//   _plg_, vilk_, _сврш, --, 
   {{0x13090934,0xd13800ab,0x44f10098,0x7d05008a}},	//   дний_, dzą_, _vš_, _mrhs, 
   {{0x628a014e,0x56950093,0x95d90fb8,0x35f50fb9}},	//   _bifo, _разт, _одат_, _ипар, 
   {{0xdcfc0092,0x32d906df,0x644201f1,0xdb160216}},	//   zarı, rèy_, _emoi, fayê, 
   {{0xa2bd08dd,0x442f0fba,0xf99200a7,0x26cf0fbb}},	//   _शिक्, _tlg_, ירי_, lugo_, 
   {{0x6f040fbc,0xdcfc0095,0x442f0fbd,0x3ea00fbe}},	//   _pric, xarı, _ulg_, _ptit_, 
   {{0x539a02a1,0x628a0180,0xdcfc008f,0x26cf06e4}},	//   _חינו, _fifo, varı, nugo_, 
   {{0x628a0fbf,0x4df508af,0x6fa20fc0,0x7878019c}},	//   _gifo, ляст, _क्रू, míve, 
   {{0xdcfc0fc1,0xd1380035,0x2ee900b9,0xd7b30ef1}},	//   tarı, czą_, _epaf_, ुणाच, 
   {{0x5184013d,0x21880137,0x63a90fc2,0x26cf0fc3}},	//   _суча, _אָפּ, nben, kugo_, 
   {{0x787800ce,0x27fd02bf,0xa3c400a5,0x3b860fc4}},	// [8c0] níve, ddwn_, ौलत_, тлаг, 
   {{0xdcfc01f0,0x00000000,0x00000000,0x00000000}},	//   sarı, --, --, --, 
   {{0xd7fa0fc5,0x63a90fc6,0x28c90c14,0xdcfc0761}},	//   дул_, kben, ांगि, parı, 
   {{0x63a90e67,0x26cf0053,0x3ead020f,0xb6a602aa}},	//   jben, fugo_, ţete_, видл, 
   {{0x63a906e0,0xdb16009e,0xfaa600ff,0x00000000}},	//   dben, zayê, _јаго, --, 
   {{0x63a90fc7,0xdb16009e,0x787800bc,0xa4d80fc8}},	//   eben, yayê, díve, едку_, 
   {{0x628a0fc9,0xd9460fca,0xdb0f0fcb,0x9f5b0216}},	//   _rifo, _реви, _recé, _caqê_, 
   {{0xd7060fcc,0x63a90fcd,0x7c3602bf,0x13f40472}},	//   _изби, gben, nhyr, узия, 
   {{0x97ea0095,0xa686004e,0x26dd00ab,0x9f4b04b3}},	//   ışdı, _алад, ctwo_, pecé_, 
   {{0x6206004f,0x06760cfe,0xdb16009e,0x00000000}},	//   тчиз, _рубя, tayê, --, 
   {{0xc4c50fce,0x1be20fcf,0x6457001d,0x6d48001d}},	//   _متنو, खभाल_, éxic, údal, 
   {{0x23ba0fd0,0xdb16010c,0x200d0068,0x14d70486}},	//   _آداب_, rayê, ñei_, _יובל_, 
   {{0xd13800ab,0x628a0fd1,0x7878019c,0x00000000}},	//   szą_, _tifo, cíve, --, 
   {{0x324300a3,0x00000000,0x00000000,0x00000000}},	//   _кечг, --, --, --, 
   {{0x69c80241,0x00000000,0x00000000,0x00000000}},	//   _ödey, --, --, --, 
   {{0xdb0f020f,0xc61f0fd2,0x00000000,0x00000000}},	//   _decî, _भव्य_, --, --, 
   {{0x06d70033,0xeb0d00bc,0x26cf09c6,0x00000000}},	// [8d0] _দৈনি, समेत_, xugo_, --, 
   {{0x63a90fd3,0x394b00d4,0x26cf0199,0x6abd017b}},	//   zben, وشاپ_, vugo_, _vvsf, 
   {{0x27ef01e8,0xaab500f0,0x98480d16,0x00000000}},	//   tegn_, _әйгі, _ağı_, --, 
   {{0xdb060fd4,0xdcb10210,0x26cf0027,0x00000000}},	//   _bekä, ẩu_, tugo_, --, 
   {{0x7c2d0fd5,0x78780165,0x63a90844,0x27ef0fd6}},	//   mkar, xíve, vben, regn_, 
   {{0xd77400eb,0x26cf0fd7,0x78780165,0xbb3a0070}},	//   جامع, rugo_, víve, _טערי, 
   {{0xd4690fd8,0xa89801a2,0x26dd0035,0x5edf0033}},	//   нике_, _аксу_, stwo_, মিটে, 
   {{0x78780fd9,0x63a90fda,0xa3e302e6,0xc6a700d9}},	//   tíve, uben, _पॉश_, _аржи, 
   {{0xc7b200a7,0x7c2d0fdb,0x17550009,0x069b0499}},	//   _לבן_, ikar, _свая, _آخرت_, 
   {{0x96f80fdc,0x63a90fdd,0xd24302f1,0x7c2d0fde}},	//   _جعفر_, sben, рмоқ, hkar, 
   {{0x7c2d0fdf,0x78780165,0x9f4e031e,0x9f5b0034}},	//   kkar, síve, čním_, _faqë_, 
   {{0xddd5031e,0xdb0a014b,0x7c2d0fe0,0x2ba508f1}},	//   mozř, šnéh, jkar, गुमा, 
   {{0x91e50fe1,0x7c2d0fe2,0xed570f5a,0x64490068}},	//   _боле, dkar, ҳор_, miei, 
   {{0x442d0fe3,0xdd92003f,0xf7760070,0x7c2d0fe4}},	//   lke_, صور_, טערי_, ekar, 
   {{0x442d0fe5,0x7c360fe6,0xed570fe7,0x09b20086}},	//   oke_, thyr, гор_, _চালা, 
   {{0x7c2d0fe8,0x8c430fe9,0x09cc009a,0xaca90019}},	//   gkar, бесе, ाल्य, کھیے_, 
   {{0x9b9300eb,0x442d0fea,0x7c360feb,0x5a4400f0}},	// [8e0] إلكت, ike_, rhyr, амағ, 
   {{0xe9d70316,0x05d20fec,0x3b830fed,0x442d0fee}},	//   лку_, _साइब, слуг, hke_, 
   {{0x442d0fef,0x7c2d00ad,0xf4be0033,0x068600f0}},	//   kke_, bkar, _আহ্ব, ңген, 
   {{0x442d0ff0,0x7c2d0ff1,0xdbd70380,0x3eb20ff2}},	//   jke_, ckar, mäßi, _kwyt_, 
   {{0x442d0ff3,0xe5b409d9,0x64490090,0xd7070080}},	//   dke_, айлы, diei, лнце_, 
   {{0x442d09a2,0x9f5b0034,0x00000000,0x00000000}},	//   eke_, _saqë_, --, --, 
   {{0x04660ff4,0x64490156,0x7af600f8,0x629d001d}},	//   лтим, fiei, lwyt, íson, 
   {{0x25f000ab,0x7bd60ff5,0x442d005f,0xd4670267}},	//   _इसकी_, ngyu, gke_, лије_, 
   {{0xa6ca086b,0x91fc00e0,0xd5d60019,0x386608b0}},	//   _سوال_, klāt, _متاث, moor_, 
   {{0xd6cf003f,0xe29f010d,0x7c2d02ba,0xdb160cd7}},	//   _رقم_, íða_, zkar, rayè, 
   {{0xf5930084,0x05560ff6,0xa1580ff7,0x7af60083}},	//   _المج, _стая, тану_, hwyt, 
   {{0x764a0ff8,0x557700c7,0x64490ff9,0xe29a0ffa}},	//   lify, _געבן_, ciei, _зад_, 
   {{0x09cc00cc,0x7c2d0ffb,0x80c00ffc,0xe80b0a34}},	//   র্যা, vkar, _विके, _सोफा_, 
   {{0xe80b000f,0x7c2d0ffd,0x3866018c,0xb80b0ffe}},	//   _सोना_, wkar, hoor_, _सोनम_, 
   {{0x16d10fff,0x7c2d1000,0x38661001,0x00000000}},	//   _सम्ब, tkar, koor_, --, 
   {{0x09cc00cc,0x7c2d0026,0x3866000b,0xa3e70fc0}},	//   র্মা, ukar, joor_, म्प_, 
   {{0x5b151002,0xead51003,0x38661004,0x3c5800d9}},	// [8f0] шмат, розь, door_, уитэ_, 
   {{0x7c2d0414,0x442d1005,0x7f3c0070,0x6d411006}},	//   skar, zke_, _רעזו, úlas, 
   {{0x764a1007,0x442d1008,0x1c000e17,0x38661009}},	//   dify, yke_, _लोकल_, foor_, 
   {{0x38660326,0xdb16009e,0x00000000,0x00000000}},	//   goor_, mayî, --, --, 
   {{0x6449100a,0x6f1b0380,0x76ab02a6,0xb6c2009e}},	//   viei, äuch, хтев_, _şûrê, 
   {{0x09cc100b,0x80aa100b,0xa3e709e5,0x1994004f}},	//   র্বা, _কিন্, म्न_, _гаря, 
   {{0x442d100c,0x64490183,0x3d08100d,0x84590093}},	//   tke_, tiei, हिये_, крит_, 
   {{0x442d100e,0x6a6b0380,0x1425100f,0x72c51010}},	//   uke_, rüfu, рдим, абиз, 
   {{0x7cec010e,0xe80b1011,0x00000000,0x00000000}},	//   _körö, _सोया_, --, --, 
   {{0x442d1012,0xc2450d2f,0xdb0f0098,0x9f40019c}},	//   ske_, рнок, _necí, _maiô_, 
   {{0x69dd07cc,0xc32300cc,0x78780327,0x62811013}},	//   _पानी, _বেশি_, líva, rmlo, 
   {{0xdb0f02a0,0xd71c0086,0xdb16010c,0x5f061014}},	//   _mecâ, _দেয়া_, dayî, азма, 
   {{0x92b70084,0x63bb1015,0x939408cb,0x02a70267}},	//   _إحصا, maun, _اجما, _срем, 
   {{0x63bb1016,0xed5a0886,0xdb0f1017,0x27ff1018}},	//   laun, вог_, _cecí, _laun_, 
   {{0x61420a43,0xdb0f0503,0x229b0216,0xa01b0080}},	//   _меша, _decí, _hêk_, mmön, 
   {{0x63bb1019,0xbb7600fd,0x27ff101a,0x3ead020f}},	//   naun, аузъ, _naun_, ţeta_, 
   {{0xe9da101b,0xeb97049b,0x3866012e,0x4a46101c}},	// [900] кка_, риу_, voor_, анав, 
   {{0x63bb101d,0x7af60156,0x787800bc,0xab5b101e}},	//   haun, rwyt, díva, _idül, 
   {{0xf1dd0586,0x41dd101f,0x63bb001a,0x26190964}},	//   _मानन, _मानस, kaun, पानी_, 
   {{0xa3e7000d,0xdb0f002e,0x63bb00e0,0xc6a61020}},	//   म्म_, _decâ, jaun, арки, 
   {{0x27ff1021,0x764a1022,0x63bb1023,0x3866018c}},	//   _daun_, tify, daun, roor_, 
   {{0x69dd0081,0x20c502e6,0x7cec010e,0xb8dc0033}},	//   _पायी, _विंध, _görö, _আম_, 
   {{0x01bb100b,0x764a1024,0x38661025,0x26df1026}},	//   ংলাদ, rify, poor_, _equo_, 
   {{0x27ff1027,0x290a011c,0x63bb1028,0x9486013e}},	//   _gaun_, _irba_, gaun, шылд, 
   {{0xd3771029,0xdb160216,0x09cc0033,0x46a3102a}},	//   ичь_, zayî, র্ণা, _матв, 
   {{0x27e6102b,0xa3e7102c,0x2012102d,0x27ff0502}},	//   lfon_, म्ब_, _anyi_, _zaun_, 
   {{0x7bc6102e,0x63bb102f,0x9f400054,0x64a31030}},	//   _odku, baun, _abià_, _даха, 
   {{0x4ea700cf,0x78a1010e,0x920201dd,0x27e600f8}},	//   ирга, _élve, _šāda, nfon_, 
   {{0xdb0f0183,0x63a21031,0x200500bc,0x44f80108}},	//   _pecí, _ifon, ěli_, _hũ_, 
   {{0x2005006a,0x7a32055f,0x290a1032,0x20120d94}},	//   śli_, _sætn, _orba_, _enyi_, 
   {{0x9c470cfe,0x7e67011c,0x00000000,0x00000000}},	//   ахал, rojp, --, --, 
   {{0x8f471033,0x705500d4,0x1dd30262,0x44f800e7}},	//   _вход, _دنبا, _ताकत, _mũ_, 
   {{0x290a00e4,0xfb870c0f,0xaa7b0228,0xdb0f0183}},	// [910] _arba_, рывн, _opýt, _tecí, 
   {{0x39a71034,0x63bb087d,0x27ff1035,0x00000000}},	//   ршав, zaun, _saun_, --, 
   {{0x27ff0926,0x7cec010e,0x69dd009a,0xa3e702e6}},	//   _paun_, _vörö, _पाठी, म्ड_, 
   {{0xdd1c00bc,0x765a024a,0x63a200b9,0xd7c81036}},	//   _nářa, _ajty, _nfon, لومه_, 
   {{0xd6db1037,0x290a1038,0x8c1a00a7,0x7cec0019}},	//   тте_, _erba_, _עושי, _törö, 
   {{0x63a21039,0x95cb103a,0x78780183,0x63bb0247}},	//   _afon, туда_, ríva, waun, 
   {{0x27ff103b,0x44f80029,0x63bb103c,0xe802103d}},	//   _taun_, _cũ_, taun, _रोका_, 
   {{0x229b078a,0xed5800a7,0x80c0101f,0x6d480038}},	//   _pêk_, יבור_, _विजे, údai, 
   {{0x86980c8a,0x63bb103e,0x386d103f,0xdb061040}},	//   _вкус_, raun, _iker_, _sekú, 
   {{0x629b026d,0xe4e702fb,0xdb0f022c,0xb06300c8}},	//   rquo, _відн, _mecà, äänt, 
   {{0x92d700cc,0x26190dc4,0x9f5e000d,0x63bb1041}},	//   াবে_, पाठी_, ětí_, paun, 
   {{0x66011042,0xaac70c64,0x229b009e,0x6e2500a1}},	//   _halk, _लिंक, _têk_, _aohb, 
   {{0x69c70eae,0x44e10019,0x539a00a7,0x43850038}},	//   _odje, ló_, _עיסו, _الشق, 
   {{0x69c701ee,0x6da31043,0x66010088,0x7bdd0183}},	//   _ndje, зира, _jalk, _acsu, 
   {{0x44e11044,0x2d8c0219,0xdca600d9,0x386d01ca}},	//   nó_, äde_, саби, _oker_, 
   {{0x69dc1045,0x62991046,0x7aef1047,0x44e10126}},	//   _scre, _kuwo, _bpct, ió_, 
   {{0x290a00f1,0xa3df0262,0x63b90156,0x69c70372}},	// [920] _srba_, _तान_, _mewn, _bdje, 
   {{0xbf9b03b7,0xdb0f03dd,0xa3e7059e,0x387f00b4}},	//   ndên, _decà, म्त_, _ahur_, 
   {{0x31ba0137,0x44e11048,0x93f900a2,0x5fbe0a34}},	//   רזענ, jó_, ्याच_, _्याल, 
   {{0x387f1049,0x44e1104a,0xe73a030f,0x44f800e7}},	//   _chur_, dó_, лее_, _rũ_, 
   {{0x27e6104b,0x44e10183,0x6299104c,0x387f01be}},	//   rfon_, eó_, _nuwo, _dhur_, 
   {{0x63a2104d,0xceb3035c,0xfaa3104e,0x290a0082}},	//   _sfon, ליד_, _харо, _trba_, 
   {{0x44e1104f,0x96c40035,0x68fc00ca,0x7c261050}},	//   gó_, _रिकॉ, _usrd, _kokr, 
   {{0x44f80029,0x62991051,0x69c71052,0x7c26008a}},	//   _vũ_, _buwo, _zdje, _jokr, 
   {{0x8c1b0052,0x82381053,0x32661054,0x2b4000ca}},	//   רופי, изис_, йтов, nzic_, 
   {{0x41dd02f8,0x8afb00c7,0x11d800eb,0x66011055}},	//   _माणस, נהיי, جودة_, _galk, 
   {{0x04960084,0x44e108f4,0xdb0f1056,0xdfd11057}},	//   _الصح, có_, _mecá, ويد_, 
   {{0x6e2501f0,0x7ae41058,0x7c2600fc,0x78780228}},	//   _sohb, ktit, _nokr, zívn, 
   {{0x447b0137,0xdb1d014b,0x62990539,0xbf9b02be}},	//   _ענדע, _odsá, _guwo, bdên, 
   {{0x44260364,0x7ae404c6,0x63b900ab,0x66010508}},	//   _hoo_, dtit, _zewn, _xalk, 
   {{0x7c261059,0x90a6105a,0x63b9010c,0x8bc700b3}},	//   _bokr, _احتم, _yewn, йсад, 
   {{0x63b9010c,0x7c26105b,0x4426105c,0x6299016a}},	//   _xewn, _cokr, _joo_, _yuwo, 
   {{0x2fc9105d,0x44e1006b,0x78780039,0x4426105e}},	// [930] _idag_, zó_, tívn, _moo_, 
   {{0x4426105f,0x386d02cc,0x44e105b9,0x6f0d1060}},	//   _loo_, _sker_, yó_, _irac, 
   {{0xda781061,0x7d081062,0x6f0d026e,0xc795004e}},	//   сят_, ådst, _hrac, орлы, 
   {{0x44261063,0x44e11064,0x6f0d1065,0x78780228}},	//   _noo_, vó_, _krac, sívn, 
   {{0x66011066,0xe6100274,0x7d031067,0xfaff01dd}},	//   _palk, کشن_, bírá, šību_, 
   {{0x44e10105,0xd1260133,0x44260026,0x6aad0054}},	//   tó_, _قم_, _aoo_, mpaf, 
   {{0x63b9006a,0x44261068,0xe3b10084,0x66011069}},	//   _pewn, _boo_, ورة_, _valk, 
   {{0x44e1106a,0xf4290e65,0x386d00dd,0x6601106b}},	//   ró_, роил_, _uker_, _walk, 
   {{0x44e1106c,0xe81600a2,0x27ed106d,0x6601106e}},	//   só_, णारा_, _iben_, _talk, 
   {{0x44e11048,0x63b900ab,0x317c0397,0x60e90849}},	//   pó_, _wewn, _bzvz_, амом_, 
   {{0x3ea9002e,0x6f0d106f,0xbf9b02be,0x7a3b0107}},	//   _atat_, _arac, rdên, _gîte, 
   {{0x44c501dd,0x68e500f8,0xa01b1070,0x62991071}},	//   mē_, ithd, lmöj, _tuwo, 
   {{0x44c500e0,0x7c261072,0x6f0d1073,0x6495007b}},	//   lē_, _rokr, _crac, _eġit, 
   {{0x7ae41074,0x5bb200a5,0x64a300ca,0x44261075}},	//   vtit, जर्व, _gđic, _zoo_, 
   {{0x44261076,0x27ed02ec,0x8c0100cc,0x3ea91077}},	//   _yoo_, _oben_, _একজন_, _etat_, 
   {{0x6a7002f2,0x4426006d,0xeb971078,0x27ed00b4}},	//   häft, _xoo_, жит_, _nben_, 
   {{0x3b070172,0x7ae40369,0x6f0d1079,0x3a26107a}},	// [940] оето_, utit, _grac, омаг, 
   {{0x7ae40df7,0x7878107b,0x320500df,0x2b40107c}},	//   rtit, tívo, ndly_, rzic_, 
   {{0x7ae4107d,0x644b0310,0x6f0d034c,0x7c26008b}},	//   stit, _omgi, _zrac, _tokr, 
   {{0x7ae4107e,0x44c501dd,0x6bd60816,0xdb24010e}},	//   ptit, dē_, _بتدر, _فوجی, 
   {{0xdb0f0126,0xaac7031e,0x7a3b010c,0x6f0d02be}},	//   _tecá, _लिएक, _dîtb, _xrac, 
   {{0x2d4e01f1,0x4426107f,0xa3e71080,0x27ed1081}},	//   _eнee_, _soo_, म्स_, _eben_, 
   {{0xd4971082,0x44261083,0xd5b91084,0xd0b100ad}},	//   оры_, _poo_, ссі_, _təəs, 
   {{0x442602a2,0x68e3022c,0xf2c61085,0xa3df0110}},	//   _qoo_, ànde, осон, _ताण_, 
   {{0x44261086,0x69da0241,0xe7371087,0x00000000}},	//   _voo_, _ötes, _дет_, --, 
   {{0x81d200cc,0x26c00028,0x6f0d0034,0x00000000}},	//   হ্ন_, šios_, _rrac, --, 
   {{0x4a7b0137,0x442600a7,0x649500bc,0xa3e70c46}},	//   שריב, _too_, _všic, म्ह_, 
   {{0x6f0d0f69,0x35e000c9,0x40340080,0x00000000}},	//   _prac, _नाड़, деюс, --, 
   {{0xa3e302e6,0x64950604,0x3d9505f3,0xe67b0210}},	//   _पॉट_, _išia, зигр, _hưở, 
   {{0xdef800e4,0xafdb0566,0xa2f80299,0x00000000}},	//   цыю_, tiøs, ्टीज_, --, 
   {{0xdd941088,0x6ce4004f,0x6f0d1089,0x4035108a}},	//   дары, міте, _wrac, _некс, 
   {{0x6f0d108b,0xafdb03a9,0x261100ab,0x69dd009a}},	//   _trac, riøs, _धोनी_, _पाही, 
   {{0x6f0d108c,0x44c501dd,0x5a35108d,0x97ea0384}},	// [950] _urac, zē_, пнат, ışlı, 
   {{0x78a3039f,0xda78108e,0x00000000,0x00000000}},	//   ínvo, оях_, --, --, 
   {{0xa3da00c2,0x00000000,0x00000000,0x00000000}},	//   ़ला_, --, --, --, 
   {{0xdb1f024a,0xae190035,0xa8020241,0x3d080c46}},	//   naqë, दावन_, _çılg, हिरे_, 
   {{0x8c1a00a7,0xe5a5108f,0x628801ff,0x00000000}},	//   _הורי, пили, kmdo, --, 
   {{0xe5a503dc,0xafdb00dd,0x38660082,0x59e2009a}},	//   чики, rnøy, čora_, _पायर, 
   {{0x19581090,0x6a701091,0x25ec00b0,0x7af9035d}},	//   _дары_, räft, _आउरी_, şatı, 
   {{0x44391092,0xa01b02ae,0x44c501dd,0x57f400ff}},	//   ós_, smöj, rē_, _опст, 
   {{0xf7490084,0x44c501dd,0xdb041093,0x051b0033}},	//   _الذي_, sē_, rbiç, তনের_, 
   {{0x363700c5,0x29050126,0xc2421094,0xd5b10210}},	//   _بررس, _álas_, еньк, _góp_, 
   {{0x216900cf,0xd00a1095,0xdb1d02c9,0x86220296}},	//   сини_, бене_, _udsæ, _سکول, 
   {{0x293600c7,0x644b1096,0xc2f30033,0x3e7601d5}},	//   פארן_, _umgi, জিবি_, mæti_, 
   {{0x20040039,0x3e7601d5,0x00000000,0x00000000}},	//   ľmi_, læti_, --, --, 
   {{0x443f1097,0x3d080d7c,0xf3f90474,0x61451098}},	//   lhu_, हिले_, leţ_, _нела, 
   {{0xc69200a7,0x91ba00d1,0xafdb0a1f,0xed52010e}},	//   תאם_, _המצי, riør, رپر_, 
   {{0x2055032e,0xaac700ab,0x4ac70b79,0xf3f90474}},	//   _отыр, _लिखक, _लिखव, neţ_, 
   {{0x6b631099,0x49ca109a,0xf09300df,0x00000000}},	// [960] екта, йлан_, _אנה_, --, 
   {{0xdb1d078a,0x499a0b24,0xd0420248,0x00000000}},	//   _kesê, стая_, vrlə, --, 
   {{0x443f109b,0xa96a0038,0x290e003e,0xd88a010e}},	//   khu_, حمام_, ífa_, مپئن_, 
   {{0xfc3200eb,0xdb04012e,0x26110790,0x3e7f0216}},	//   _أحد_, ncië, _धोबी_, mîta_, 
   {{0xfbd30056,0xf3f900b3,0x4cb10033,0x3e7f0216}},	//   _אתר_, deţ_, _জয়পু, lîta_, 
   {{0xe8df0029,0x7c2400d2,0x4b7b00d1,0xdb0f02aa}},	//   _giữa_, ljir, _לאכו, _secç, 
   {{0xb509009a,0x5fbe00bc,0x344a01d8,0x645b109c}},	//   विषय_, ्णाल, йчин_, fnui, 
   {{0x7c240705,0x443f003d,0x4394109d,0xb3c609e2}},	//   njir, ghu_, майс, रृंख, 
   {{0xdb06010e,0x6fd60110,0x7a3304a8,0x26190110}},	//   _nekü, _भाजू, _fıtı, पाशी_, 
   {{0x443f109e,0x69de005f,0x6283006c,0x55e302a0}},	//   ahu_, ngpe, _chno, _поуб, 
   {{0x64950082,0xf1dd093a,0x00000000,0x00000000}},	//   _išin, _मारन, --, --, 
   {{0x395700a7,0xdb06010e,0x7c2401a3,0xe1ef010e}},	//   לשים_, _bekü, jjir, پسی_, 
   {{0xee8700c8,0x4ea70cfe,0x26c6109f,0x00000000}},	//   зыво, ярна, nsoo_, --, 
   {{0xd2500499,0x6ca70995,0x62830465,0x9f59021e}},	//   _جنت_, зраж, _ghno, lesë_, 
   {{0xa15710a0,0xe9ff00e7,0xda0a00b0,0x61fa10a1}},	//   _нашу_, _ngạc_, _होइत_, metl, 
   {{0x31c6031e,0x61fa10a2,0x442400ef,0x415b00d1}},	//   bízí_, letl, njm_, _לדוג, 
   {{0x60da02cd,0xdb04026a,0xa3df00a2,0xdb060380}},	// [970] lutm, nciè, _तास_, _gekü, 
   {{0x61fa10a3,0x7c24095a,0xe29f003e,0x02d400c6}},	//   netl, ajir, íði_, _दिनभ, 
   {{0x6ca410a4,0x7c38033c,0x24890032,0xa3bc00b0}},	//   _пряж, ñará, ňami_, अरा_, 
   {{0x61fa10a5,0xf77000d4,0xdb0d001d,0x9f590034}},	//   hetl, گام_, lbaí, jesë_, 
   {{0x261910a6,0x61fa10a7,0x644000eb,0xdb160369}},	//   पाली_, ketl, dhmi, payá, 
   {{0xf7700625,0x61fa02a8,0xa3df00a5,0xf3f9020f}},	//   دام_, jetl, _ताह_, inţe_, 
   {{0x443f10a8,0x7a3b010c,0x00000000,0x00000000}},	//   thu_, _gîta, --, --, 
   {{0xc9520056,0x7bdf10a9,0xdb1d024a,0x52a910aa}},	//   _סמן_, ngqu, _nesë, овим_, 
   {{0x130610ab,0xd83803dd,0x645b10ac,0x61fa027e}},	//   дный_, _ээр_, rnui, fetl, 
   {{0x443f10ad,0xa3df10ae,0x645b00d9,0x68e10219}},	//   shu_, _ताव_, snui, _älds, 
   {{0x443f10af,0xa2cf10b0,0x3de30033,0xdb1d0034}},	//   phu_, _दिव्, য়াল, _besë, 
   {{0xcdc90056,0x644010b1,0x78a910b2,0x291100ef}},	//   _כך_, chmi, _čevl, _mrza_, 
   {{0xdb060cd7,0x437410b3,0xdb0401c8,0x09d50086}},	//   _lekò, _пушт, rcië, স্যা, 
   {{0x291110b4,0x443d00c3,0xa294017b,0x999800de}},	//   _orza_, _hlw_, _зачі, _smrž_, 
   {{0x1d070a63,0xfce310b5,0x443d10b6,0x6da310b7}},	//   мери_, коро, _klw_, тиса, 
   {{0x320700a9,0xdb1d10b8,0x6e21003e,0x3e7f010c}},	//   _hany_, _kesè, ölbr, rîta_, 
   {{0x7c240926,0x1a060701,0x290310b9,0xfaff00e0}},	// [980] rjir, мпам, _asja_, šīnu_, 
   {{0x291110ba,0x6f0410bb,0x7c36012d,0x64850038}},	//   _brza_, _isic, skyr, lóid, 
   {{0xeb9a0906,0x8c4610bc,0x32070056,0xae1b00c7}},	//   _мин_, _жене, _many_, _וויכ, 
   {{0x320700a9,0x3ea010bd,0x61fa10be,0x9f5906df}},	//   _lany_, _kuit_, zetl, fesè_, 
   {{0x61fa10bf,0x41dd0367,0x787802be,0x00000000}},	//   yetl, _मांस, nívi, --, 
   {{0x28db0586,0x6f040053,0x3207023a,0x443d00f8}},	//   मूहि, _msic, _nany_, _alw_, 
   {{0x61fa10c0,0x5e570137,0x644010c1,0x9f59024a}},	//   vetl, ויסע_, thmi, tesë_, 
   {{0x7bc410c2,0x32070054,0xdb1d011c,0xda1c00c2}},	//   naiu, _aany_, _besè, नावत_, 
   {{0xa3df083b,0x68e1022b,0x3ea0026d,0x61fa10c3}},	//   _तार_, _äldr, _nuit_, tetl, 
   {{0x644010c4,0x2fc000b9,0xa68300f0,0xdb1d10c5}},	//   shmi, _aeig_, _алуд, _desè, 
   {{0x61fa10c6,0xae220b79,0x443d019c,0x320710c7}},	//   retl, मानन_, _flw_, _dany_, 
   {{0x68e1022b,0x61fa10c8,0xf99300a7,0x660810c9}},	//   _ålde, setl, כרת_, _hadk, 
   {{0x32070e34,0x69ce0187,0x61fa07d7,0x27e40065}},	//   _fany_, _odbe, petl, _mcmn_, 
   {{0x3ea010ca,0x2e260054,0x32070118,0x683a00b9}},	//   _duit_, _kôfy_, _gany_, _oïdo, 
   {{0xd30800f7,0x2bd00077,0x2486023b,0x6e9410cb}},	//   _hệ_, तृभा, _khom_, тиру, 
   {{0x320705f0,0x69ce0ae3,0x3ea010cc,0x629810cd}},	//   _zany_, _adbe, _fuit_, _hivo, 
   {{0x661a0b1f,0x629810ce,0xae0c0ca0,0xb4bb00c9}},	// [990] _ontk, _kivo, िएशन_, _अब्_, 
   {{0x20090b22,0x2486008a,0xdb060118,0x2fc00502}},	//   _haai_, _lhom_, _pekò, _zeig_, 
   {{0xd308001b,0x629800a9,0xa3df0d1d,0xdb1d010e}},	//   _lệ_, _mivo, _ताल_, _mesé, 
   {{0xa2cf10cf,0xec350137,0x629810d0,0x315700c7}},	//   _दिल्, _נאָר_, _livo, ויבן_, 
   {{0x660810d1,0x2ee90065,0x20090ff2,0x9958020b}},	//   _badk, _jqaf_, _maai_, háňa_, 
   {{0x629810d2,0x20090876,0xdb1d10d3,0xfb160070}},	//   _nivo, _laai_, _odsú, _אַלט_, 
   {{0x660810d4,0x6d470405,0x320710d5,0x69c510d6}},	//   _dadk, nzja, _rany_, mahe, 
   {{0xcd980a33,0x69c510d7,0x248610d8,0x588710d9}},	//   ודות_, lahe, _chom_, _цыга, 
   {{0xfe0f10da,0x629810db,0x443d0165,0x320700f6}},	//   ायास_, _bivo, _vlw_, _pany_, 
   {{0x69c510dc,0x44e8010c,0x660810dd,0x3ea010de}},	//   nahe, bû_, _gadk, _ruit_, 
   {{0x09d500cc,0xd00a10df,0xdb1d0068,0xdb0410e0}},	//   স্থা, пене_, _desé, rcié, 
   {{0x7a32010d,0x7878026e,0x764302cd,0x2360014b}},	//   _hætt, tívi, lhny, _žije_, 
   {{0x32070489,0x69c510e1,0x2009018c,0x629800a9}},	//   _tany_, kahe, _daai_, _fivo, 
   {{0x09d5100b,0xfc3f09a1,0x63a910e2,0x3ea003a1}},	//   স্তা, _alí_, lcen, _vuit_, 
   {{0x75f30092,0x69c510e3,0x7a32008c,0x2fc010e4}},	//   mızı, dahe, _mætt, _teig_, 
   {{0x98a700bc,0x3ea0083a,0x26dd044d,0x2009040b}},	//   šně_, _tuit_, kuwo_, _gaai_, 
   {{0x1e960099,0xfc3f00eb,0xab6610e5,0x2be1031e}},	// [9a0] _прор, _dlí_, хвал, _फारा, 
   {{0x75f305b7,0x69c510e6,0x19b9012d,0x7a320566}},	//   nızı, gahe, дуць_, _nætt, 
   {{0xa3df10e7,0x660810e8,0xba3b022c,0x63a910e9}},	//   तला_, _radk, _suïc, kcen, 
   {{0x63a910ea,0xc18c00c7,0xe786004f,0x248d10eb}},	//   jcen, קטאָ, нуло, jmem_, 
   {{0xe73710ec,0x69c510ed,0x26dd105b,0x660810ee}},	//   нец_, bahe, guwo_, _padk, 
   {{0x63a910ef,0x69ce055f,0x69c51032,0x200b0098}},	//   ecen, _udbe, cahe, zdci_, 
   {{0x629810f0,0x2486006f,0x64950304,0x614610f1}},	//   _rivo, _phom_, _išij, _mélé, 
   {{0xdb0f0183,0x7643030c,0xdb1d009e,0x44e80218}},	//   _recú, ahny, _mesî, rû_, 
   {{0xa01b008c,0x6d47003d,0xdb080212,0x20090326}},	//   llög, zzja, élèv, _raai_, 
   {{0xd3080029,0x63a910f2,0x200910f3,0xddc70352}},	//   _vệ_, acen, _saai_, kojš, 
   {{0xa3e80190,0x63a910f4,0xb7bd00d9,0x200908b0}},	//   _बाप_, bcen, _soţi, _paai_, 
   {{0x23660e0c,0x63a910f5,0x44cc031e,0xd30800e7}},	//   _txoj_, ccen, mě_, _tệ_, 
   {{0x69c510f6,0xbb1b010c,0x00000000,0x00000000}},	//   yahe, _azîn, --, --, 
   {{0x6146026a,0x20090876,0xfc3f0038,0x28d100bd}},	//   _célé, _waai_, _slí_, _हिलि, 
   {{0x69c510f7,0xbd6810f8,0x44cc031e,0x61460107}},	//   vahe, ерте_, ně_, _délé, 
   {{0x9f520bf1,0x3f1500d3,0x69c510f9,0xb7bd020f}},	//   _cayó_, _адис, wahe, _toţi, 
   {{0x69c510fa,0x3a7502f1,0x657a017c,0x6146039f}},	// [9b0] tahe, влар, _lyth, _félé, 
   {{0x996710fb,0xddc710fc,0xbbeb00d4,0x614610fd}},	//   нтел, bojš, _کردم_, _gélé, 
   {{0x69c510fe,0x7a320a6d,0xe61f001b,0x99670cdf}},	//   rahe, _rætt, _đô_, хтал, 
   {{0x7a3210ff,0x44cc000d,0x69c51100,0xd759091d}},	//   _sætt, dě_, sahe, ولات_, 
   {{0xd90f0105,0x764302cd,0x69c50149,0x00000000}},	//   _گیا_, thny, pahe, --, 
   {{0x7aed0019,0x657a1101,0x64951102,0x46d200bc}},	//   mtat, _byth, _všim, _सिरह, 
   {{0xd90f0105,0xd4691103,0x657a017c,0xae2200b0}},	//   _دیا_, мике_, _cyth, मातन_, 
   {{0x7643016a,0x7aed02a3,0x6d581104,0x26dd019b}},	//   shny, otat, _žvak, puwo_, 
   {{0x248d1105,0x7a3202c9,0x48640093,0x7c2f1106}},	//   rmem_, _tætt, _сърб, _mocr, 
   {{0x63a91107,0x7aed1108,0x7c2f02a3,0x44cc02d9}},	//   scen, itat, _locr, bě_, 
   {{0x7aed024a,0x63a90844,0xe816009a,0x387d00f8}},	//   htat, pcen, णाचा_, olwr_, 
   {{0x61461109,0x7c2f0d07,0xa3e8075a,0x00000000}},	//   _sélé, _nocr, _बाय_, --, 
   {{0xe28e110a,0x09cc0086,0x61460096,0xa2e5022c}},	//   _ва_, র্টা, _pélé, _ролд, 
   {{0xc0a809e8,0xda110081,0x7aed110b,0x2d9e004f}},	//   بایل_, _डोलत_, dtat, øte_, 
   {{0x442f0df4,0x1fb6110c,0xed5a110d,0x7aed110e}},	//   _kog_, _испр, фов_, etat, 
   {{0x442f110f,0xe8df00e7,0xbc631110,0x7aed1111}},	//   _jog_, _nhựa_, авск, ftat, 
   {{0x61460518,0x442f0201,0x7aed0268,0x4f0701bb}},	// [9c0] _télé, _mog_, gtat, _анын_, 
   {{0x4a431112,0x442f00a7,0xd5e00586,0xa01b0219}},	//   анув, _log_, _नाइज, smöt, 
   {{0x442f0318,0x2dd900c7,0x26cd1113,0x77690183}},	//   _oog_, _אַרב, _aveo_, _axex, 
   {{0x442f1114,0x44cc000d,0x76411115,0x657a026a}},	//   _nog_, vě_, _ally, _ryth, 
   {{0x7aed1116,0xb8651117,0x17840240,0x657a1118}},	//   ctat, دالو, уҳам, _syth, 
   {{0x09cc00cc,0x649500d2,0x44cc031e,0x98a700d9}},	//   র্জা, _ušij, tě_, ână_, 
   {{0x442f1119,0x77690183,0xe97600d4,0x0466111a}},	//   _bog_, _exex, _شهرد, ктим, 
   {{0x442f01a0,0x00000000,0x00000000,0x00000000}},	//   _cog_, --, --, --, 
   {{0x657a02bf,0x65c6111b,0x4274111c,0x442f00d1}},	//   _wyth, _абза, лгис, _dog_, 
   {{0x44cc02d9,0x442f0090,0xb355009c,0x00000000}},	//   pě_, _eog_, دیها_, --, 
   {{0x7aed111d,0xd48f111e,0x442f0019,0xd3e400d4}},	//   ztat, _вр_, _fog_, _مقای, 
   {{0x320a08fc,0x76580010,0xe53700c7,0x442f111f}},	//   žby_, livy, _שטאט_, _gog_, 
   {{0x64421120,0xdb0d019c,0x6f161121,0xdd3b107c}},	//   _iloi, mbaç, _cryc, _băşt, 
   {{0x442f01c1,0x7c2f1122,0x6f161123,0x6442084c}},	//   _zog_, _socr, _dryc, _hloi, 
   {{0x442f1124,0x16df0a09,0x2d8501e8,0xe80b007e}},	//   _yog_, _नम्ब, åle_, _सोझा_, 
   {{0x7aed1125,0x3d0802f8,0x46d21126,0x09cb00a2}},	//   ttat, हिजे_, _सिंह, ाण्य, 
   {{0x7aed00d9,0x5b150161,0x4c941127,0xc4c4010e}},	// [9d0] utat, ымат, ритс, _ڈے_, 
   {{0x7aed1128,0x9f59001d,0x5fb60035,0x850200bc}},	//   rtat, nesí_, ूरथल, लबाट_, 
   {{0x7aed1129,0xda780ec4,0x26cd015e,0x6f16112a}},	//   stat, тят_, _sveo_, _zryc, 
   {{0x7aed112b,0xdb1d0183,0x7a3b009e,0x00000000}},	//   ptat, _hesí, _kîtk, --, 
   {{0x442f112c,0x4421001b,0xe5a300a3,0xf6e7112d}},	//   _rog_, _đh_, қиқи, тцен, 
   {{0x6442030f,0x442f02f1,0x6d58012d,0x69dd00a2}},	//   _aloi, _sog_, _žvai, _पाटी, 
   {{0x442f112e,0x6442112f,0xdb1d001d,0xb7bd00b3}},	//   _pog_, _bloi, _mesí, _soţu, 
   {{0x13091130,0x64421131,0x442f1132,0x845800c8}},	//   ений_, _cloi, _qog_, крыт_, 
   {{0x628a0084,0x97ea0c05,0x442f1133,0x26cd034c}},	//   _bhfo, ıştı, _vog_, _uveo_, 
   {{0x42251134,0x64421135,0x442f1136,0x649a00d3}},	//   удов, _eloi, _wog_, мтөр_, 
   {{0xa2cf05f6,0x56940200,0xe4e4004f,0x95c81137}},	//   _दिक्, _тафт, _вічн, _шута_, 
   {{0x64421138,0x00000000,0x00000000,0x00000000}},	//   _gloi, --, --, --, 
   {{0x63bb09c2,0xa3e81139,0xbec5004e,0xba3b113a}},	//   mbun, _बात_, аңыз_, _ruïn, 
   {{0xa2d809ec,0x63bb0c98,0xfce6113b,0xc0e5113c}},	//   _मित्, lbun, лого, _бокк, 
   {{0xdb1d00bc,0x9d43113d,0x27200083,0x63bb018e}},	//   _desí, берд, _मप्र_, obun, 
   {{0x6f16113e,0x6e3c113f,0x4095012d,0x2a781140}},	//   _tryc, skrb, _крыт, _skrb_, 
   {{0x63bb02f2,0x3b8600f6,0x20021141,0xc05300d1}},	// [9e0] ibun, улаг, meki_, _לזה_, 
   {{0x2002074c,0x01d50033,0xd9ae0299,0x00000000}},	//   leki_, ত্রদ, टडेट, --, 
   {{0x291e0f23,0x38cb0116,0x46c602e6,0x9c66009c}},	//   _štab_, فانی_, रीनह, _مهدو, 
   {{0x649500a4,0xa3df0c46,0xdb1d1142,0x81760147}},	//   _eġiz, _ताग_, _desâ, אגעס_, 
   {{0xa2cf10b0,0x601b0080,0x63bb1143,0xbf9b0216}},	//   _दिग्, _hämä, dbun, ldêr, 
   {{0x64420557,0x7bc6024a,0xa5f81144,0xe9a30701}},	//   _sloi, _heku, теку_, _гарп, 
   {{0xa3e81145,0x7bc61146,0x644200d9,0x76580300}},	//   _बाद_, _keku, _ploi, rivy, 
   {{0x20021147,0x63bb1148,0x76581149,0x7bc6018e}},	//   jeki_, gbun, sivy, _jeku, 
   {{0x3855048a,0xdb04114a,0x200201f0,0x05240086}},	//   _търс, mbió, deki_, বনের_, 
   {{0x7bc6114b,0x64a6114c,0x27e6114d,0x00000000}},	//   _leku, _бажа, lgon_, --, 
   {{0xdb1d114e,0x601b0080,0x00000000,0x00000000}},	//   _resí, _nämä, --, --, 
   {{0x27e60bc1,0x7bc6114f,0x648506a7,0x71f7006b}},	//   ngon_, _neku, lóin, پریس_, 
   {{0xdef8109a,0x63a21150,0xa85700d1,0x27e60108}},	//   лыр_, _igon, ריכה_, igon_, 
   {{0x539b0111,0x291801c5,0x25e810da,0xdb1d02aa}},	//   _ניגו, _orra_, च्ची_, _lesã, 
   {{0xdb1d0068,0x63a20364,0xdd950009,0x7e751151}},	//   _vesí, _kgon, равы, rozp, 
   {{0x200201f0,0x63a202be,0x5b271152,0xade900bc}},	//   ceki_, _jgon, льза, ञ्जन_, 
   {{0x29180019,0x63a20927,0x7bc61153,0xba55021c}},	// [9f0] _arra_, _mgon, _deku, авај, 
   {{0x320e0379,0x63bb00b3,0x00000000,0x00000000}},	//   _jafy_, zbun, --, --, 
   {{0x63a21154,0x320e05f0,0x648503b3,0x3eb90243}},	//   _ogon, _mafy_, dóin, lpst_, 
   {{0x63a21155,0x7bc61156,0x27e60b74,0x64b101dd}},	//   _ngon, _geku, ggon_, _jāie, 
   {{0x29181157,0x61f80352,0x65c502f1,0x7c2d1158}},	//   _erra_, _obvl, абла, mjar, 
   {{0xe618005e,0x63a21159,0x20020938,0x27e9115a}},	//   лді_, _agon, zeki_, żan_, 
   {{0xce3800a7,0x7bc60095,0x290500fd,0x63bb0aa7}},	//   ראות_, _yeku, _èla_, tbun, 
   {{0x7afd012b,0xa3df017d,0xafdb0566,0x00000000}},	//   _kpst, _ताओ_, shøj, --, 
   {{0x42c603a1,0x63bb115b,0xa3b4034d,0x3aef0241}},	//   агын_, rbun, झड़_, nüp_, 
   {{0x69c7115c,0xdb04115d,0x63a20a9f,0x63bb115e}},	//   _jeje, nciá, _egon, sbun, 
   {{0x2169115f,0x60261160,0x7c2d1161,0xafdb055f}},	//   тини_, адна, kjar, dkøb, 
   {{0x7afd1162,0x7a3b078a,0x69c71163,0x20560aed}},	//   _opst, _dîti, _leje, ртор, 
   {{0x387e1164,0x20021165,0x442d1166,0x320e0054}},	//   _être_, reki_, mje_, _fafy_, 
   {{0x443f0527,0x64491167,0x69c7031e,0x66031168}},	//   lku_, lhei, _neje, nenk, 
   {{0x7afd002a,0x442d012d,0xdd921169,0x7c2d008c}},	//   _apst, oje_, زور_, fjar, 
   {{0x6449116a,0x6603116b,0x44f1001b,0xfce60f5a}},	//   nhei, henk, _mơ_, лоҳо, 
   {{0x69c7006b,0x207b00c7,0x68fc0112,0x443f116c}},	// [a00] _beje, _באקא, _sprd, iku_, 
   {{0xba23116d,0x601b030f,0x442d116e,0x7bc6116f}},	//   одук, _tämä, hje_, _weku, 
   {{0x443f033d,0x442d00fc,0x7bc61170,0x69c71171}},	//   kku_, kje_, _teku, _deje, 
   {{0x1ae61172,0x443f00f1,0x6449012e,0xf09300c7}},	//   _комм, jku_, jhei, ַנג_, 
   {{0x27e61173,0x442d1174,0x443f1175,0xc5f8005e}},	//   rgon_, dje_, dku_, лға_, 
   {{0x443f002a,0x66031176,0x442d00ab,0xaa461177}},	//   eku_, genk, eje_, _тегл, 
   {{0x44f100f7,0x7ae41178,0x644900eb,0xdb1d02a0}},	//   _cơ_, luit, fhei, _tesã, 
   {{0x442d1179,0x6449117a,0x6281117b,0x443f00e2}},	//   gje_, ghei, ello, gku_, 
   {{0x32660849,0x23380088,0x779400d4,0xf743117c}},	//   итов, уппы_, _ایشا, _дето, 
   {{0x442d117d,0x443f0584,0x7c2d117e,0xe5a300d9}},	//   aje_, aku_, zjar, _дифи, 
   {{0x8506040f,0x443f0098,0x442d02ee,0x64490465}},	//   _خوان, bku_, bje_, bhei, 
   {{0x6449117f,0x442d0da6,0x38661180,0x443f06c4}},	//   chei, cje_, nnor_, cku_, 
   {{0xfe221181,0x7c2d1182,0xfe7f022c,0x62810034}},	//   मांस_, vjar, juïc_, bllo, 
   {{0x7ae41183,0x30a61184,0x6e950b68,0x78a0045a}},	//   duit, _крив, сигу, _limv, 
   {{0x69c71185,0x0ed3009a,0x44f10023,0xb0f81186}},	//   _reje, _तिकड, _xơ_, _сейф_, 
   {{0xe5170509,0x69c71187,0x66031188,0x64401189}},	//   थिति_, _seje, zenk, nkmi, 
   {{0x7ae4118a,0x7c2d118b,0x66fa00e0,0xdb0f118c}},	// [a10] guit, rjar, nākā, _recó, 
   {{0x443f063b,0xdb1d118d,0x442d118e,0x656d0095}},	//   zku_, _cesá, zje_, şahi, 
   {{0x442d118f,0x69c71190,0x6449018c,0x3ea900e2}},	//   yje_, _veje, yhei, _huat_, 
   {{0x3ea91191,0x7ae41192,0x386601d8,0x660301a3}},	//   _kuat_, buit, gnor_, wenk, 
   {{0x66031193,0x443f1194,0x44f10029,0x442d1195}},	//   tenk, vku_, _sơ_, vje_, 
   {{0x3ea91196,0x64a501a2,0x2fc91197,0x6f0d018e}},	//   _muat_, бака, _leag_, _msac, 
   {{0x442d1198,0x3ea91199,0x6449119a,0x58d404fb}},	//   tje_, _luat_, thei, _морт, 
   {{0xa2d8119b,0x442d00e4,0x6603119c,0x443f119d}},	//   _मिश्, uje_, senk, uku_, 
   {{0x6449119e,0xa3e8119f,0x6603090f,0xc322021d}},	//   rhei, _बार_, penk, змык, 
   {{0x442d11a0,0x644903fc,0xa2d80a20,0x44f10023}},	//   sje_, shei, _मिर्, _tơ_, 
   {{0x2fc911a1,0x442d11a2,0x84670141,0x3f8611a3}},	//   _beag_, pje_, _къде, _šou_, 
   {{0x3ea911a4,0x644011a5,0x442d024a,0x66fa0243}},	//   _buat_, ckmi, qje_, bākā, 
   {{0x02a70b0d,0x6f630b58,0x147400eb,0x9f590042}},	//   _трем, звяз, _بالج, tesá_, 
   {{0x6d4e0380,0x7ae411a6,0xccf800a3,0x00000000}},	//   tzba, vuit, ақо_, --, 
   {{0x320511a7,0x50b511a8,0x386611a9,0x6efd0219}},	//   mely_, _услу, ynor_, _påbö, 
   {{0x7ae411aa,0xb603063b,0x68e5012b,0x27ed01e5}},	//   tuit, _hráč, duhd, _ncen_, 
   {{0xab2711ab,0x9ce80033,0xb6030098,0x7ae4019c}},	// [a20] бота_, খবেন_, _kráč, uuit, 
   {{0x78a90bfc,0xac08004e,0x3ea10304,0x78a011ac}},	//   _čevr, ынға_, _giht_, _simv, 
   {{0xa3e80bf5,0x7ae411ad,0x645902b0,0xb60300de}},	//   _बाल_, suit, _omwi, _mráč, 
   {{0xa2d8000c,0x320511ae,0x69c6109f,0x201205d5}},	//   _मिल्, hely_, िरही, _jayi_, 
   {{0x320511af,0x386611b0,0x78bb11b1,0x6ecb05e5}},	//   kely_, rnor_, _čuve, तीपु, 
   {{0x32050180,0xdb1d02c9,0x645911b2,0x91fc0243}},	//   jely_, _besæ, _amwi, gnāl, 
   {{0x78a011b3,0x186a0267,0x320511b4,0xaa470082}},	//   _timv, _бави_, dely_, _упра_, 
   {{0xe8e0001b,0xa2b411b5,0x66fa01dd,0xa3e8009a}},	//   _chụp_, обич, tākā, _बाळ_, 
   {{0x6440008c,0x661100c8,0x2fc90036,0x239b0028}},	//   rkmi, ökkä, _reag_, jąjį_, 
   {{0x6440007e,0x66fa01dd,0x60cd0083,0xc50a11b6}},	//   skmi, rākā, _łama, _متصل_, 
   {{0x20121146,0x531611b7,0x09d50033,0x3ea911b8}},	//   _bayi_, _گذار, স্কা, _suat_, 
   {{0x9f9911b9,0x3ea9011c,0x6f0d036e,0xfe7f00f6}},	//   ивну_, _puat_, _psac, duïa_, 
   {{0x3ea911ba,0x320511bb,0x28af103d,0x649511bc}},	//   _quat_, bely_, _जूनि, _všit, 
   {{0x6d1411bd,0xfbdf03c6,0x32050de2,0x00000000}},	//   डिंग_, _clên_, cely_, --, 
   {{0x64a3015e,0x64950026,0x20120027,0x2fc901be}},	//   _uđit, _tšit, _fayi_, _teag_, 
   {{0x0ca811be,0x6f0d11bf,0x649500da,0x00000000}},	//   стри_, _tsac, _ušit, --, 
   {{0x6f0d045a,0xe7cc0035,0xdefb09d9,0x6a3502a6}},	// [a30] _usac, ारनप, _сый_, онађ, 
   {{0x27ed11c0,0x6aad0034,0xfe7f00b9,0xfbdf03c6}},	//   _scen_, rqaf, buïa_, _glên_, 
   {{0x2012044d,0x6e250054,0xa3e811c1,0x27ed00fc}},	//   _yayi_, _inhb, बला_, _pcen_, 
   {{0xac1911c2,0x76480175,0xb9010367,0xc0b20023}},	//   _тому_, _aldy, _दि_, _sưởi_, 
   {{0xd6db11c3,0xd7f803dc,0x6675009c,0xb06600c8}},	//   уте_, сух_, يدتر, ltää, 
   {{0xf7700a7c,0x95cb00d3,0x00000000,0x00000000}},	//   ران_, ууда_, --, --, 
   {{0xb0660088,0x91fc00e0,0x320511c4,0x27ed0036}},	//   ntää, rnāl, vely_, _tcen_, 
   {{0x99540235,0x00000000,0x00000000,0x00000000}},	//   _эксц, --, --, --, 
   {{0x52a611c5,0x32050bf9,0xe7330e61,0x201211c6}},	//   овым_, tely_, _عصر_, _rayi_, 
   {{0xf1a500d3,0x5f1d05ff,0x201211c7,0xe4e7017b}},	//   өрүн, मिन्_, _sayi_, _гідн, 
   {{0x386d11c8,0x69d803b7,0xe3b30625,0x320500d1}},	//   _kjer_, óvei, _فرش_, rely_, 
   {{0xdb1d030f,0x764303a9,0x64590199,0x44f311c9}},	//   _kesä, lkny, _umwi, mã_, 
   {{0x7643016a,0x3205014b,0x44f302aa,0x2d8511ca}},	//   okny, pely_, lã_, ülen_, 
   {{0x764311cb,0xe8df0108,0xa01b11cc,0xdca611cd}},	//   nkny, _chừa_, llöl, жави, 
   {{0x2d8c0310,0x6da311ce,0x764310b6,0xf3f900d9}},	//   åde_, дира, ikny, enţi_, 
   {{0xed5a0200,0x00000000,0x00000000,0x00000000}},	//   гоҳ_, --, --, --, 
   {{0xe7ff0964,0x764302cd,0xd0420095,0xa09b027a}},	// [a40] ोजना_, kkny, xslə, _דיקט, 
   {{0x25fb0a09,0x386d11cf,0x387f11d0,0x5e570038}},	//   ल्मी_, _ajer_, _akur_, _وليس_, 
   {{0xda1b0262,0x57a602f1,0x291c11d1,0xe7aa11d2}},	//   _नफरत_, ошла, íva_, авел_, 
   {{0xdb1d0c98,0x778611d3,0xfe7f00f6,0x00000000}},	//   _besä, олез, nuïn_, --, 
   {{0x7c2611d4,0x386d023e,0x00000000,0x00000000}},	//   _inkr, _djer_, --, --, 
   {{0x386d01cc,0xd04200ad,0x1dbf021a,0xc4da0bad}},	//   _ejer_, rslə, ्रयत, ађи_, 
   {{0x3af403c5,0x344a00af,0x8675012d,0xd04200ad}},	//   läp_, ичин_, чыцц, sslə, 
   {{0x386d00fc,0x7643016a,0x7e7c11d5,0xf48300f0}},	//   _gjer_, akny, horp, муын, 
   {{0x7e7c11d6,0x16660141,0x213e0156,0x3a38007b}},	//   korp, _двам, wyth_, _korp_, 
   {{0x7af600e4,0x764311d7,0x518600a3,0xb06600c8}},	//   ityt, ckny, жума, ytää, 
   {{0x7c2611d8,0x6e3711d9,0x3a380065,0x7e7c11da}},	//   _onkr, _roxb, _morp_, dorp, 
   {{0x8cb10110,0x00000000,0x00000000,0x00000000}},	//   _आंबो, --, --, --, 
   {{0xdefb11db,0x442611dc,0x09d50086,0x289b0070}},	//   шын_, _ino_, স্টা, ייטא, 
   {{0x442611dd,0x3f85002a,0x7c2611de,0x2057004e}},	//   _hno_, ālu_, _ankr, стүр, 
   {{0x25b900ad,0xf3f90474,0x91bb00df,0x00000000}},	//   _əsl_, liţa_, _דמוי, --, 
   {{0x4426016a,0x8cdc0fcf,0x1bbb0038,0x7a3b0216}},	//   _jno_, _फिरो, شارع_, _nîtr, 
   {{0xa3e811df,0xb0660088,0x442611e0,0xe8df001b}},	// [a50] _बाई_, stää, _mno_, _thừa_, 
   {{0x7c2602ee,0x09e30086,0x387f11e1,0x9f5902c9}},	//   _enkr, ন্না, _skur_, geså_, 
   {{0x3a380318,0x999102d9,0x386d11e2,0x7a3b0216}},	//   _dorp_, _vozů_, _pjer_, _bîtr, 
   {{0x44260547,0x3a3801be,0xdb1d0080,0xf77311e3}},	//   _nno_, _eorp_, _pesä, واش_, 
   {{0x8707009c,0x2b520083,0x6d5a11e4,0xab84022d}},	//   تبال, czyc_, útav, _журк, 
   {{0x442611e5,0xd12600eb,0x64a511e6,0x58d500c8}},	//   _ano_, _كم_, пака, _ногт, 
   {{0x044511e7,0x764311e8,0xe5a20e65,0x386d021e}},	//   зейн, rkny, ниши, _tjer_, 
   {{0x387f11e9,0x7643016a,0x44f302be,0x442601be}},	//   _ukur_, skny, rã_, _cno_, 
   {{0xa01b02ae,0x27ff11ea,0x28af00aa,0x44f302be}},	//   glöm, _ibun_, _जूति, sã_, 
   {{0x442611eb,0xd17511ec,0x00000000,0x00000000}},	//   _eno_, зымы, --, --, 
   {{0xf8cb00a5,0x0519007a,0x44260664,0xfe7f00b9}},	//   ाठिय, _دياب_, _fno_, tuïn_, 
   {{0x44d7002e,0xe8df001b,0xbbaa072d,0xafdb0a1f}},	//   mă_, _chứa_, _कलेक, skøn, 
   {{0x7d1e11ed,0x644b11ee,0x44d7002e,0x09e30086}},	//   _srps, _ilgi, lă_, ন্যা, 
   {{0x629d031e,0x00000000,0x00000000,0x00000000}},	//   ůsob, --, --, --, 
   {{0x44d70012,0x44260156,0x00000000,0x00000000}},	//   nă_, _yno_, --, --, 
   {{0x5baa11ef,0x09e30086,0x7af6076b,0x00000000}},	//   скам_, ন্মা, ttyt, --, 
   {{0x78bb00f1,0xe9da0ed8,0xab2711f0,0xa2bf009a}},	// [a60] _čuva, йка_, пота_, लीच्, 
   {{0x3af402ae,0x6a8300d9,0x9e0a007a,0x00000000}},	//   räp_, елуа, _ايدك_, --, 
   {{0xe8fa0fe1,0x7af611f1,0x44d700d9,0x644b11f2}},	//   сле_, styt, jă_, _olgi, 
   {{0xa3ea000c,0xfaa604c5,0xafdb08bb,0x44d700d9}},	//   _टाइप_, _намо, lhør, dă_, 
   {{0x7bc411f3,0x3a380343,0xf74311f4,0x44260604}},	//   mbiu, _torp_, нецо, _rno_, 
   {{0x644b0009,0x4426098d,0x27ff0d07,0x7ae411f5}},	//   _algi, _sno_, _ebun_, mrit, 
   {{0x69dc00dd,0x44d700d9,0x290c02a3,0xf8e00035}},	//   _idre, gă_, _èda_, _पटिय, 
   {{0xb603002a,0x69ce11f6,0x68e31056,0xdb0d001d}},	//   ēšan, _hebe, ánde, zcaí, 
   {{0x69ce11f7,0x66e311f8,0x228611f9,0x7ae40a6d}},	//   _kebe, _пота, зунг, nrit, 
   {{0x64aa000d,0x69ce08e3,0x78ae045a,0x25fb07d5}},	//   _přid, _jebe, _kubv, ल्दी_, 
   {{0x44d70012,0x69ce11fa,0x7ae402f2,0x55bb00d1}},	//   că_, _mebe, hrit, _המבו, 
   {{0x442611fb,0x69ce11fc,0x6f0400e1,0x00000000}},	//   _uno_, _lebe, _bpic, --, 
   {{0x69dc03ef,0xa8570486,0x69ce011c,0x00000000}},	//   _odre, ליטה_, _oebe, --, 
   {{0x8cb10f01,0x69ce11fd,0x626611fe,0xbeed11ff}},	//   _आंदो, _nebe, _عاشق, _जमीन_, 
   {{0x7ae4007e,0xd7cc00a2,0x09e30086,0x01fb00d1}},	//   erit, ाराच, ন্ডা, _הפול, 
   {{0x69dc1200,0x7ae41201,0x69ce01f1,0x3cfe1202}},	//   _adre, frit, _aebe, _लहरे_, 
   {{0x69ce1203,0x44d70012,0x6fc31204,0x91fc01dd}},	// [a70] _bebe, ză_, _व्यं, ciāc, 
   {{0x19ab1205,0x200b1206,0x69da0379,0x69ce1207}},	//   стап_, leci_, _ôtel, _cebe, 
   {{0x69ce1208,0x39471209,0x7ae402a3,0x5eed00c9}},	//   _debe, áns_, arit, _जमुई_, 
   {{0x44d700d9,0x9cd600d1,0xf9900038,0x200b120a}},	//   vă_, _קורה_, ابك_, neci_, 
   {{0xa2d80299,0x00000000,0x00000000,0x00000000}},	//   _मिग्, --, --, --, 
   {{0x69ce120b,0x44d70012,0x19590161,0x1dbf0d1d}},	//   _gebe, tă_, _дагы_, ्रित, 
   {{0x7bcf04bb,0x78a2026e,0x200b0228,0xdb1d0228}},	//   _kecu, ňova, keci_, _nesú, 
   {{0x44d70012,0x200b0f30,0x27ff120c,0xa01b014e}},	//   ră_, jeci_, _ubun_, slöj, 
   {{0x44d7002e,0x7bcf120d,0x1dbf00a2,0xd5b100e7}},	//   să_, _mecu, ्रात, _các_, 
   {{0xe0d9120e,0x69ce00ad,0x44d700d9,0x6ed7120f}},	//   ово_, _xebe, pă_, _बिजु, 
   {{0x69c501c5,0x7ae40187,0xafe602f1,0x741200d7}},	//   ibhe, zrit, монл, رویا, 
   {{0x7bcf00d9,0x7ae400c8,0x6aa702b0,0xdb1d00f6}},	//   _necu, yrit, _lijf, _desú, 
   {{0x99830028,0x00000000,0x00000000,0x00000000}},	//   _kojų_, --, --, --, 
   {{0x09e30086,0x7ae41210,0x3d0a017d,0x62341211}},	//   ন্তা, vrit, ाबले_, _печу, 
   {{0xbea31212,0x7bcf1213,0x3ea30470,0xafdb00fb}},	//   тарк, _becu, тирг, rhør, 
   {{0x69ce1214,0xd9f01215,0xdd8f0ce0,0xb5fc01f2}},	//   _sebe, _चाहत_, شوق_, _imġe, 
   {{0x78ae1216,0x78bc00ef,0x7bcf1217,0xd91011b7}},	// [a80] _subv, _strv, _decu, گیز_, 
   {{0x7ae41218,0x1cba0040,0xe8df001b,0x6aa7012e}},	//   rrit, _واجب_, _chữa_, _cijf, 
   {{0xfbc61219,0xdb1d03da,0x7bcf04ef,0x2618121a}},	//   _обно, _xesú, _fecu, _योगी_, 
   {{0xab2a121b,0x31360137,0x66e6121c,0x7bcf121d}},	//   _дома_, ונעם_, дода, _gecu, 
   {{0x69ce121e,0x09e30086,0x394601dd,0xe737121f}},	//   _tebe, ন্ধা, ņos_, мец_, 
   {{0x69dc1220,0x69ce0380,0xa01b02ae,0x22900054}},	//   _udre, _uebe, tlök, kàka_, 
   {{0x693502d9,0xdb060566,0x3e890216,0x00000000}},	//   _přeš, _afkø, lîtê_, --, 
   {{0xdb1d0634,0x64aa031e,0x09e30033,0xd7061221}},	//   _resú, _přib, ন্দা, _озби, 
   {{0x41e61222,0x25fb1223,0x200b1224,0x64aa02d9}},	//   міна, ल्ही_, veci_, _břic, 
   {{0xd2501225,0xd6260195,0x51f8004f,0xf5e700d9}},	//   اند_, _تعري, чною_, _омул_, 
   {{0xa01b00c8,0x66e60176,0x629a1226,0x6283018e}},	//   llöi, _хоҷа, rmto, _dkno, 
   {{0xa3e8000d,0xc32a00eb,0xd5b10108,0x00000000}},	//   _बाट_, _وكان_, _tác_, --, 
   {{0xa2d80262,0x7bcf1227,0x200b1228,0x67000299}},	//   _मिट्, _recu, reci_, ोबिक_, 
   {{0x200b03ef,0x7bcf1229,0x1e720259,0x00000000}},	//   seci_, _secu, лғыс, --, 
   {{0x38b70529,0x6d550036,0x320c122a,0x6ca7122b}},	//   _oħra_, uzza, medy_, драж, 
   {{0xfc150afc,0x28d8122c,0x320c122d,0xa3c3122e}},	//   эмбэ, _डिजि, ledy_, ्रय_, 
   {{0x7bcf00e0,0x4ba800d3,0x7b67122f,0xfe1a1230}},	// [a90] _vecu, дөрү_, фтве, _फोकस_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa3c309d3,0x1bd51231,0x69c51232,0x6aa7012e}},	//   ्रम_, _поня, rbhe, _vijf, 
   {{0x779903fd,0x78a20032,0x6aa701d2,0x00000000}},	//   пкер_, ňovn, _wijf, --, 
   {{0xa3e80d2e,0x320c0187,0x7d020571,0x7c3d0358}},	//   _बाज_, kedy_, _ćosi, _iosr, 
   {{0x2451063b,0x7aed1233,0x46e000b0,0xf1c70ed0}},	//   _máme_, muat, _निरह, ďáky_, 
   {{0x7aed0a2d,0xc9841234,0x7c3d040b,0x245100de}},	//   luat, _аути, _kosr, _láme_, 
   {{0xe7f9000d,0xdb1d09a8,0xe8cb009a,0x00000000}},	//   _एउटा_, _besø, ाठीच, --, 
   {{0x25a900d4,0x64aa00bc,0x3f891235,0x7c3d021e}},	//   _فضای_, _přic, _nyau_, _mosr, 
   {{0x291e0009,0xd24302f1,0x78a90054,0x4ae200bd}},	//   _štai_, тмоқ, _hiev, _पिसव, 
   {{0x7aed1236,0x7c3d08b0,0x00000000,0x00000000}},	//   huat, _oosr, --, --, 
   {{0x7aed1237,0x717900f0,0x1b060033,0x22900379}},	//   kuat, жбүр_, রিতে_, ràka_, 
   {{0xe80102f8,0x7aed1238,0x64490380,0x23290258}},	//   ळ्या_, juat, mkei, _холи_, 
   {{0x443d0056,0x78a91239,0x644900c8,0x2451014b}},	//   _how_, _liev, lkei, _dáme_, 
   {{0x443d123a,0xda020f8c,0x7c3d123b,0x644602ae}},	//   _kow_, र्फत_, _bosr, ökig, 
   {{0x7aed086d,0x78a9123c,0x6449123d,0x64850183}},	//   fuat, _niev, nkei, cóit, 
   {{0x3b07048a,0xfe72006b,0x7aed123e,0xadee00a2}},	// [aa0] нето_, _مدد_, guat, _जाऊन_, 
   {{0x9b9300eb,0x443d00a7,0x7c36017b,0x09e30033}},	//   الكت, _low_, sjyr, ন্সা, 
   {{0x6449048d,0xd943123f,0xeabf01be,0xef180243}},	//   kkei, лефи, _crùb_, āļu_, 
   {{0x443d0056,0x7aed1191,0x78a90032,0x3eb21240}},	//   _now_, buat, _ciev, _kuyt_, 
   {{0x62811241,0x78a91242,0x91fc00e0,0x7bd61243}},	//   kolo, _diev, onāt, mayu, 
   {{0x25fb0d95,0x62811244,0x7bd61245,0x443d1246}},	//   ल्ली_, jolo, layu, _aow_, 
   {{0x291e11e9,0x7c3d0640,0x3eb20ff2,0x443d1247}},	//   _éta_, _yosr, _luyt_, _bow_, 
   {{0x98a31248,0x644902ec,0xd4971249,0x78a9124a}},	//   _бисе, gkei, нры_, _giev, 
   {{0x0edc0f63,0x6281124b,0x68e10219,0x57cc031e}},	//   _बिगड, folo, _åldr, ारीह, 
   {{0x6281124c,0x7bd6124d,0xa683124e,0x427303a1}},	//   golo, hayu, _блуд, лгыс, 
   {{0x320c124f,0xa3b3031e,0x75d3007a,0x00000000}},	//   redy_, जुङ_, _إيما, --, 
   {{0x44fa078e,0x661a00ef,0xa3c30f8c,0x38661250}},	//   më_, _hatk, ्रण_, nior_, 
   {{0x62811251,0xff041252,0x44fa00e5,0x661a1253}},	//   bolo, лярн, lë_, _katk, 
   {{0x661a030f,0x3866007c,0x7bc20068,0x7c3d1254}},	//   _jatk, hior_, ñoun, _sosr, 
   {{0x44fa078e,0x661a1255,0x7c3d06e0,0x5ce41256}},	//   në_, _matk, _posr, люта, 
   {{0x7aed1257,0x661a1258,0x64851259,0xdc880a10}},	//   tuat, _latk, lóir, есул_, 
   {{0x44fa00e5,0x78a9125a,0xeab30038,0x4ea7125b}},	// [ab0] hë_, _riev, اعر_, _проа, 
   {{0x78a9002a,0xda78125c,0x44fa00e5,0x661a125d}},	//   _siev, нях_, kë_, _natk, 
   {{0xdd91125e,0x78a9002a,0x7aed0730,0x44fa01ee}},	//   _خود_, _piev, suat, jë_, 
   {{0x6281125f,0x648500eb,0x7aed1260,0x44fa0034}},	//   zolo, hóir, puat, dë_, 
   {{0x661a02fe,0xdb070088,0x44fa018c,0xd8740816}},	//   _batk, ämäs, eë_, دالب, 
   {{0x443d00e2,0x62811261,0x99d40133,0xa50900ce}},	//   _sow_, xolo, _متفا, дека_, 
   {{0x62811262,0x648500eb,0x44fa00e5,0x443d1263}},	//   volo, dóir, gë_, _pow_, 
   {{0x588701bb,0x386600d9,0x629802f1,0xed640098}},	//   _чыга, cior_, _ahvo, loží_, 
   {{0xe2990a43,0x64491264,0x661a024a,0x2486023e}},	//   маи_, rkei, _fatk, _dkom_, 
   {{0x69d70496,0x64491265,0x648500eb,0x7bd60053}},	//   naxe, skei, góir, zayu, 
   {{0x201b0065,0xa3c300c9,0x7bd60626,0x44fa0034}},	//   _baqi_, ्रद_, yayu, cë_, 
   {{0x200408d7,0xd5640559,0xa3d20c64,0x62811266}},	//   ými_, _ступ, वरण_, solo, 
   {{0x62811267,0x6e3e0082,0x60c40352,0x2374020b}},	//   polo, _popb, _čime, čajú_, 
   {{0x248d1268,0x63bb0141,0xfce61269,0x9f61010e}},	//   llem_, lcun, кого, ását_, 
   {{0x7bd6126a,0xfc3f00f6,0x8d63126b,0x6d47126c}},	//   tayu, _boí_, авре, gyja, 
   {{0x63bb126d,0x998d0218,0xa3c3126e,0x4f260240}},	//   ncun, _şeş_, ्रि_, _адиб, 
   {{0x6e3e126f,0xcb671270,0x0b431271,0x44fa024a}},	// [ac0] _topb, вате_, антн, zë_, 
   {{0x7bd61272,0xbea61273,0x248d09c7,0x6fa71274}},	//   sayu, _шапк, hlem_, _गणतं, 
   {{0x661a0088,0xfe3700a7,0xa3c305f6,0x249f1275}},	//   _ratk, _סרטי_, ्रा_, kmum_, 
   {{0x44fa024a,0x076a1117,0x5ee900c9,0xb90a1276}},	//   vë_, وماً_, _जिम्_, _मि_, 
   {{0x248d1277,0x69d70183,0x69ca003e,0x38661278}},	//   dlem_, baxe, ðfes, rior_, 
   {{0x44fa078e,0x629d10de,0x2ca000b0,0x22900054}},	//   të_, ïsol, lmid_, vàko_, 
   {{0x81d70086,0x38660219,0x661a1279,0x00000000}},	//   িলা_, pior_, _vatk, --, 
   {{0x44fa078e,0x4394127a,0xe4e30586,0x6298011c}},	//   rë_, лайс, _गिरि_, _shvo, 
   {{0x44fa078e,0x661a0ab1,0x6d4700ab,0x648500eb}},	//   së_, _tatk, zyja, tóir, 
   {{0x91fc002a,0x60c4127b,0x44fa024a,0xd05d0095}},	//   ciāl, _čimb, pë_, əyəc, 
   {{0x6722127c,0x248d127d,0x648500eb,0x38640054}},	//   lvoj, blem_, róir, _kmmr_, 
   {{0xdb04127e,0x64850038,0xf365004e,0x60da127f}},	//   nció, sóir, _өтін, rstm, 
   {{0x733603b1,0xf09f022c,0xdb04033c,0x657a00a1}},	//   _جرائ, rmà_, ició, _hxth, 
   {{0x52d700a7,0x201b02cd,0x2ca000b0,0xc6940070}},	//   _יודע_, _waqi_, emid_, טאָ_, 
   {{0x201b0165,0xdb040019,0x3a7502f1,0x7e6702b0}},	//   _taqi_, kció, ҳлар, rijp, 
   {{0x5c740ec6,0x57cc1280,0x09cb1281,0x3f8500ad}},	//   алст, ारोह, िर्य, ğlub_, 
   {{0x3a751282,0x29181283,0x6e45007a,0x2de71284}},	// [ad0] глар, _asra_, _منظم, _июнг, 
   {{0x672202f5,0x68e31056,0x99d51117,0x4a541285}},	//   dvoj, ándo, اقات, акус, 
   {{0x69d71286,0xa3d20081,0x248d058c,0x8af000ad}},	//   raxe, वरा_, ylem_, lzəl, 
   {{0x69d703da,0x69ca008c,0xa01b00a8,0x00000000}},	//   saxe, ðfer, mlös, --, 
   {{0x29181287,0x7c2f1288,0x64aa031e,0xd6db1289}},	//   _esra_, _incr, _přin, фте_, 
   {{0xe29a00f7,0xdb04128a,0xf3f900b3,0x0684128b}},	//   _như_, ació, miţi_, агін, 
   {{0x91fc002a,0xa8a70161,0x58d4128c,0xa01b128d}},	//   riāl, _арак, _вост, nlös, 
   {{0xdb04128e,0x69d5128f,0x33261290,0xafdb00fb}},	//   cció, _heze, _brox_, ljøf, 
   {{0x69d51291,0x248d1292,0x569500d3,0xa3e4031e}},	//   _keze, rlem_, _баат, _भएर_, 
   {{0x69d51293,0x63bb1294,0xa3c31295,0x248d1296}},	//   _jeze, scun, ्रह_, slem_, 
   {{0x10a61297,0x69d51298,0xa06a1299,0x248d129a}},	//   лион, _meze, еана_, plem_, 
   {{0xcea907f5,0x69d50b32,0xf992042c,0xa01b02ae}},	//   _זי_, _leze, מרי_, dlös, 
   {{0x442f0817,0xe28e129b,0x643a00d1,0xdb1d001d}},	//   _ing_, _га_, _רעננ, _mesó, 
   {{0x442f0175,0xa01b01c4,0x7c2f129c,0x7641040b}},	//   _hng_, flös, _ancr, _joly, 
   {{0xed5a129d,0x1d07129e,0x2d8c01cc,0x442f129f}},	//   хов_, лери_, æde_, _kng_, 
   {{0x442f12a0,0xfe7f022c,0x09cd0033,0x61f1020f}},	//   _jng_, duïu_, _লাগা, şelă, 
   {{0x69d512a1,0xdd9600f0,0x2ca000b0,0x442f12a2}},	// [ae0] _beze, таңы, rmid_, _mng_, 
   {{0x442f12a3,0xa9a608ac,0x2ca012a4,0x00000000}},	//   _lng_, гизд, smid_, --, 
   {{0x442f12a5,0x69d512a6,0x499612a7,0x9d4612a8}},	//   _ong_, _deze, ушат, _сенд, 
   {{0xd7f712a9,0x442f02a5,0xf3f9020f,0x00000000}},	//   гуш_, _nng_, biţi_, --, 
   {{0xdb040a5e,0xdb1d0126,0x69d512aa,0x5b35002e}},	//   rció, _desó, _feze, _кэру, 
   {{0x442f12ab,0x69d512ac,0x20d1032f,0x672212ad}},	//   _ang_, _geze, kši_, rvoj, 
   {{0xdb04128a,0x442f09a1,0x20d111c8,0x78b5090b}},	//   pció, _bng_, jši_, _guzv, 
   {{0x332612ae,0x26c612af,0x44de003d,0x69d501f1}},	//   _prox_, ppoo_, rċ_, _zeze, 
   {{0x7641006b,0x442f12b0,0x3254002e,0x78a20036}},	//   _foly, _dng_, ивир, mmov, 
   {{0x442f12b1,0x764102bf,0x78a212b2,0xb6a602f1}},	//   _eng_, _goly, lmov, _сизл, 
   {{0xd48f12b3,0xa19412b4,0x2d8c00ab,0x321c00a9}},	//   _гр_, ранч, żdej_, _vavy_, 
   {{0x78a212b5,0xd0e5000c,0x442f0102,0x4254009c}},	//   nmov, _किरण_, _gng_, انگر, 
   {{0xe29a0029,0xdd2500e0,0x78a202aa,0x9f590126}},	//   _thư_, dīša, imov, vesó_, 
   {{0x98bc031e,0x644212b6,0x20d10352,0xa01b12b7}},	//   ávě_, _hooi, bši_, tlös, 
   {{0x442f02f0,0x78a202ee,0xfe7f03a1,0x644202b0}},	//   _yng_, kmov, duït_, _kooi, 
   {{0x78a200d0,0xa01b128d,0xf3f900b3,0x69d512b8}},	//   jmov, rlös, tiţi_, _seze, 
   {{0x64420285,0x90980a7c,0xa01b0fd4,0x69d501f1}},	// [af0] _mooi, _حضور_, slös, _peze, 
   {{0x69d50c45,0xa01b0219,0xf3f900d9,0xdb1d03dd}},	//   _qeze, plös, riţi_, _besò, 
   {{0x69d512b9,0x391512ba,0x57b512bb,0x985100ab}},	//   _veze, рмер, абет, nąć_, 
   {{0x64420e47,0x69d512bc,0xdddc00b3,0x81b50033}},	//   _nooi, _weze, porţ, _ছড়া_, 
   {{0x7bda03e1,0xf6e70b68,0xfe7f022c,0x2d9c0032}},	//   _בקרו, уцен, buït_, _úver_, 
   {{0xf62512bd,0x7aed12be,0x7bcd12bf,0xb5c2004f}},	//   рдко, mrat, lbau, ойшл, 
   {{0xe3b1057f,0x764112c0,0x7a4100bc,0x98510035}},	//   يرة_, _voly, _vítě, jąć_, 
   {{0x20d100f1,0x130902fb,0x7aed12c1,0x7bcd12c2}},	//   vši_, вний_, orat, nbau, 
   {{0x644212c3,0x2bb81202,0x442f12c4,0x7aed12c5}},	//   _dooi, _अलसा, _vng_, nrat, 
   {{0x248000f1,0x7aed12c6,0x212712c7,0x6aae0201}},	//   čima_, irat, _prnh_, _xibf, 
   {{0x290112c8,0xdddc0571,0x27e0003e,0x7aed12c9}},	//   ntha_, jorš, ðing_, hrat, 
   {{0x672912ca,0x20d112cb,0xff2602f1,0x644201c8}},	//   _krej, rši_, аммо, _gooi, 
   {{0xe3ae12cc,0x99980121,0x00000000,0x00000000}},	//   _фб_, _morš_, --, --, 
   {{0x21a500a3,0x8cb10035,0x78a20098,0x4e19128b}},	//   _килм, _आंखो, zmov, люся_, 
   {{0xada612cd,0xdb1206b6,0x6da612ce,0x7aed0187}},	//   равл, _ágús, рива, erat, 
   {{0x672912cf,0x7aed0821,0x3b0012d0,0x7bcd12d1}},	//   _orej, frat, ttiq_, gbau, 
   {{0x5baa12d2,0xfe7f03a1,0x2d8512d3,0xdd2500e0}},	// [b00] ткам_, tuït_, üler_, rīša, 
   {{0x2bb80081,0x09e612d4,0xdd2501dd,0x9958020b}},	//   _अलवा, рожн, sīša, ráža_, 
   {{0x290100eb,0x78a212d5,0x7aed0093,0xe8fa12d6}},	//   gtha_, tmov, arat, тле_, 
   {{0x672912d7,0x64aa02d9,0xafdb0566,0x00000000}},	//   _brej, _přim, lkør, --, 
   {{0x2bd311bd,0x78a2026e,0x29010094,0x644212d8}},	//   तररा, rmov, atha_, _rooi, 
   {{0x6729078e,0x290112d9,0xd9f00c46,0x24580151}},	//   _drej, btha_, _चाटत_, _méme_, 
   {{0x2508017a,0x75cb005e,0xafdb03a9,0xfa670e65}},	//   ارتی_, ттің_, ljøe, _тарк_, 
   {{0x672911e1,0x249d0090,0x91680108,0x94180080}},	//   _frej, _chwm_, _lực_, ужит_, 
   {{0x672912da,0xa2b300c8,0xd1ca12db,0xe61a12dc}},	//   _grej, обыч, кунд_, _ида_, 
   {{0x166312dd,0x325412de,0x6f0d12df,0x26c00474}},	//   _двум, свор, _rpac, ţios_, 
   {{0x7aed00a3,0x6f0d12e0,0x67290228,0x91a900e7}},	//   zrat, _spac, _zrej, _đã_, 
   {{0xe19300f6,0x7aed01ff,0xa3c30c65,0x50670fa7}},	//   өлөө, yrat, ्रः_, ртоа, 
   {{0x53a612e1,0xfe7f03dd,0x00000000,0x00000000}},	//   _тадб, duïr_, --, --, 
   {{0x7aed12e2,0x9f4002f2,0x2d8401f0,0x69d8008c}},	//   vrat, _weiß_, ğmen_, ðvel, 
   {{0x25fb12e3,0x7aed00c3,0x8c670188,0xa3bd072e}},	//   ल्टी_, wrat, атад, _आलम_, 
   {{0x7aed12e4,0x20090065,0x228b017b,0x00000000}},	//   trat, _ubai_, søkt_, --, 
   {{0x7bcd12e5,0x6f0d12e6,0x64aa031e,0x451c0086}},	// [b10] rbau, _upac, _přij, থমিক_, 
   {{0x62880156,0xe9ab06bc,0xab8412e7,0x29010065}},	//   nodo, ندان_, цуск, ttha_, 
   {{0x15b9005e,0x67290082,0x19ab09d9,0x29010415}},	//   қылы_, _srej, ттап_, utha_, 
   {{0x672912e8,0x628812e9,0x7aed12ea,0x290112eb}},	//   _prej, hodo, prat, rtha_, 
   {{0x290112ec,0x7aed12ed,0x57e800f0,0xdc36027a}},	//   stha_, qrat, рдім_, _הארט_, 
   {{0xb60712ee,0xdd2800e0,0x628802c1,0x29010038}},	//   рядк, lēša, jodo, ptha_, 
   {{0xd46912ef,0x628812f0,0x48ab08a5,0x00000000}},	//   лике_, dodo, _атам_, --, 
   {{0x672912f1,0xdd2801dd,0x00000000,0x00000000}},	//   _trej, nēša, --, --, 
   {{0x672902ee,0x9f4407fa,0x62880156,0x320512f2}},	//   _urej, ümü_, fodo, tfly_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf5950084,0x008600d3,0x00000000,0x00000000}},	//   _الاج, йлоо, --, --, 
   {{0x20560b58,0x237d023b,0xd17500f0,0xb7bd107c}},	//   стор, _txwj_, _қылы, _faţe, 
   {{0x628812f3,0x443f0e26,0x645b0557,0xdd2801dd}},	//   bodo, mju_, mhui, dēša, 
   {{0xb6cc06a2,0x645b12f4,0x00000000,0x00000000}},	//   _şükü, lhui, --, --, 
   {{0xc692035c,0x443f0009,0xdd920625,0xafdb00fb}},	//   פאל_, oju_, سور_, rkør, 
   {{0x645b12f5,0x78a30b1f,0xd5b10023,0x24580032}},	//   nhui, ïnvl, _cái_, _téme_, 
   {{0xbbb800a2,0x3a4401a2,0x8c4312f6,0x09e600d9}},	// [b20] _अलीक, омаҳ, чете, йоан, 
   {{0x443f007e,0x64aa00bc,0xe9d709fa,0x00000000}},	//   hju_, _přik, йку_, --, 
   {{0x499a0b58,0x645b038c,0xafdb004f,0x090603ae}},	//   утая_, khui, sjøe, спен, 
   {{0x443f12f7,0xdd2801dd,0xb8eb0019,0xd5b10108}},	//   jju_, cēša, ابلے_, _gái_, 
   {{0x443f12f8,0xf3ff0086,0x645b12f9,0x7c2412fa}},	//   dju_, ্যার_, dhui, mdir, 
   {{0x7c2412fb,0x443f12fc,0x645b12fd,0x89f5012d}},	//   ldir, eju_, ehui, _мясц, 
   {{0x628809b2,0x69de0727,0x645b12fe,0x89db00d1}},	//   vodo, mape, fhui, _תחלי, 
   {{0x7c2412ff,0x69de1300,0xa3a900c6,0x628800ab}},	//   ndir, lape, _गृह_, wodo, 
   {{0x35fa03b1,0x98a300b3,0x18a30176,0x938a1301}},	//   _مراد_, _хите, _хатм, ыска_, 
   {{0x69de1302,0xdd2801dd,0x05070033,0x443f1303}},	//   nape, zēša, লয়ের_, aju_, 
   {{0x443f1304,0x7c241305,0x81b00033,0x00000000}},	//   bju_, kdir, টুন_, --, 
   {{0x443f05ae,0x645b1306,0x69de1307,0xb27500d3}},	//   cju_, chui, hape, йлөш, 
   {{0x62881308,0x69de05a1,0x7c241309,0x09e30086}},	//   podo, kape, ddir, ন্টা, 
   {{0x3dd900cc,0xdce50228,0x69de130a,0x5eb80033}},	//   _তাহল, _vzhľ, jape, _অবশে, 
   {{0x69de130b,0x64aa000d,0x2600130c,0x44240102}},	//   dape, _přih, _रानी_, odm_, 
   {{0xfe770161,0x7c24130d,0x60c700bc,0x00000000}},	//   рүү_, gdir, íjme, --, 
   {{0xdd2800e0,0x7d1e012b,0xeabf00e7,0xf3fa0033}},	// [b30] rēša, _esps, _trùm_, _আসার_, 
   {{0x443f0405,0x7b7400eb,0x69de0064,0xdd280243}},	//   zju_, أطفا, gape, sēša, 
   {{0x7c24130e,0x984b130f,0xdd280243,0x6d4e0027}},	//   bdir, ляда_, pēša, cyba, 
   {{0x19a81310,0xd9a808ba,0x987c02d9,0x00000000}},	//   ступ_, съуд_, bíč_, --, 
   {{0xe7391311,0x443f1312,0x69de1313,0x00000000}},	//   рел_, vju_, bape, --, 
   {{0xdb1d0750,0x7bdf0068,0xd6291314,0x1b060033}},	//   _besö, laqu, роке_, রিখে_, 
   {{0x443f1315,0xf53200ce,0x845900d9,0x3eb31316}},	//   tju_, дејќ, ирит_, _mixt_, 
   {{0x7bdf1317,0x94790267,0x443f0e0b,0x00000000}},	//   naqu, јску_, uju_, --, 
   {{0x443f1318,0x645b0af8,0xa5f902a6,0x727900b3}},	//   rju_, rhui, _везу_, исос_, 
   {{0x443f1319,0x645b131a,0xdd1c014b,0x7c24131b}},	//   sju_, shui, váže, zdir, 
   {{0x443f131c,0x6145131d,0x9327015f,0x7c24131e}},	//   pju_, цена, _گران, ydir, 
   {{0x69de131f,0x1faa1320,0x60cd02fe,0x80b80033}},	//   zape, икни_, _čamd, _আবশ্, 
   {{0x7bdf1321,0x6f630235,0x93270296,0x69de025b}},	//   daqu, двяз, _دران, yape, 
   {{0xda0b0262,0x64590026,0x6d4e1322,0x02a700d9}},	//   स्मत_, _hlwi, tyba, _урем, 
   {{0xa3bd02f8,0x69de1323,0x7bdf024a,0x7c241324}},	//   _आला_, vape, faqu, tdir, 
   {{0x69de1325,0xdb1d02aa,0x7c240036,0x6d4e0028}},	//   wape, _lesõ, udir, ryba, 
   {{0x69de1326,0x7c241327,0x200506d0,0xf41202a1}},	// [b40] tape, rdir, əli_, ופן_, 
   {{0x22470326,0x7c241328,0x49961329,0xee0a00b3}},	//   _jonk_, sdir, ошет, _теол_, 
   {{0x69de132a,0x8c46132b,0xdd0f01f0,0x1dd0031e}},	//   rape, _дене, mışt, _त्यत, 
   {{0xdd0f01f0,0x7c24132c,0x9f4800e7,0x9f590219}},	//   lışt, qdir, _điêu_, resö_, 
   {{0xcfbc0086,0xfaa6132d,0x64aa02d9,0x60c40144}},	//   _অজান, _мамо, _křiv, _čimm, 
   {{0x7ae4132e,0x6459132f,0xf4ea1330,0xdd0f0241}},	//   msit, _alwi, афий_, nışt, 
   {{0xd90d017a,0x7ae400eb,0x81cf0086,0x261b031e}},	//   _میل_, lsit, ষণা_, _यसरी_, 
   {{0x7bc41331,0x7ae41332,0xdb1d00bd,0x00000000}},	//   nciu, osit, _eesõ, --, 
   {{0x69dc1333,0x7ae41334,0x22470372,0xdd0f0241}},	//   _kere, nsit, _bonk_, kışt, 
   {{0x69dc1335,0x442402a2,0x24510038,0x200000a1}},	//   _jere, sdm_, _lámh_, _acii_, 
   {{0x69dc1336,0x22471337,0xd2570904,0x7bdf1338}},	//   _mere, _donk_, іць_, yaqu, 
   {{0x69dc1339,0x7ae4133a,0xe0cf06bc,0x6618133b}},	//   _lere, ksit, کزی_, levk, 
   {{0x7648016a,0x69dc0226,0xdb1d01a7,0x20050083}},	//   _kody, _oere, _jesô, ęli_, 
   {{0x24890228,0x764803a0,0xe60e0259,0x9f59002c}},	//   čame_, _jody, едi_, ngsé_, 
   {{0x7bdf026a,0x7648133c,0xec6b0b38,0x7ae4133d}},	//   taqu, _mody, арак_, esit, 
   {{0x69dc0093,0x67200eae,0x3ced133e,0x6618010c}},	//   _aere, _osmj, čev_, hevk, 
   {{0x2019133f,0x7ae407fc,0xb6060228,0x06cf0033}},	// [b50] mesi_, gsit, _kráľ, _রিভি, 
   {{0x20191340,0x66180f4c,0x69dc1229,0x7bc401d8}},	//   lesi_, jevk, _cere, aciu, 
   {{0x69dc1341,0x7bdf1342,0x48151343,0x78bc1344}},	//   _dere, paqu, змес, _curv, 
   {{0x765a1345,0x78bc1346,0x7ae41347,0xb17b00c7}},	//   _alty, _durv, bsit, סטאר, 
   {{0x69dc1348,0x27e0008c,0x7bdd00b4,0xf7700499}},	//   _fere, ðina_, _iesu, پان_, 
   {{0x69dc1349,0x7bdd134a,0x2ca900b0,0xc987134b}},	//   _gere, _hesu, lmad_, _дуби, 
   {{0x7bdd134c,0x69c5134d,0x2019134e,0x67d5134f}},	//   _kesu, mche, kesi_, _нову, 
   {{0x69c51350,0x7bdd1351,0x69dc1352,0x7d7c00c7}},	//   lche, _jesu, _zere, ינוו, 
   {{0x2bdc0081,0x7bdd1353,0x69dc1354,0x76d500eb}},	//   बरता, _mesu, _yere, _رياض, 
   {{0x69dc1355,0x7bdd1356,0x69c51357,0x09af0086}},	//   _xere, _lesu, nche, _চ্যা, 
   {{0x69c51358,0x20191359,0x2c0c0790,0x386d011c}},	//   iche, fesi_, ड्डू_, _kmer_, 
   {{0x2458135a,0x7bdd00e4,0x69c5135b,0x2d840241}},	//   _téma_, _nesu, hche, şmek_, 
   {{0x2451135c,0x64aa00bc,0x22470096,0x6e250175}},	//   _námi_, _přiv, _tonk_, _bahb, 
   {{0x68e7035f,0x6e25135d,0x69c5135e,0x248d064e}},	//   _ovjd, _cahb, jche, loem_, 
   {{0x61e1030f,0x386d135f,0xdca6041d,0x7bdd1360}},	//   mall, _omer_, зави, _besu, 
   {{0x7ae41361,0x20191362,0x61e11363,0x248d018c}},	//   tsit, cesi_, lall, noem_, 
   {{0x69dc1364,0x7bdd055f,0x7bc40019,0x2d9e026e}},	// [b60] _pere, _desu, rciu, ťte_, 
   {{0x7bc40141,0xed5a00b9,0xba231365,0x69dc1366}},	//   sciu, _гоо_, ндук, _qere, 
   {{0x7ae41367,0x7648012d,0xda020c64,0x7bc41368}},	//   ssit, _rody, र्गत_, pciu, 
   {{0x61e11369,0x69dc136a,0x7bdd136b,0x7ae4136c}},	//   hall, _were, _gesu, psit, 
   {{0x61e10eaf,0x387f014e,0x69c5136d,0x7648136e}},	//   kall, _djur_, bche, _pody, 
   {{0x69c50141,0x78bc0e0f,0x61e1136f,0x7bdd02a5}},	//   cche, _turv, jall, _zesu, 
   {{0x20c100f7,0x7bdd019a,0xfaa31370,0x20191371}},	//   _nói_, _yesu, _чаро, yesi_, 
   {{0x7bdd0042,0x7648125f,0x6d4100c8,0x06661372}},	//   _xesu, _wody, älai, _کارپ, 
   {{0x66180039,0x61e11373,0x67200f30,0x55c4004e}},	//   pevk, fall, _usmj, _жазғ, 
   {{0x61e11374,0x20191375,0x20c10023,0x3f850241}},	//   gall, wesi_, _bói_, şluk_, 
   {{0x20191376,0x60cd090b,0x6e2500cf,0x69c3008b}},	//   tesi_, _čamc, _rahb, žneg, 
   {{0x7c261377,0xe3a70019,0xb606014b,0x20c102aa}},	//   _nakr, _کشمی, _dráž, _dói_, 
   {{0x61e11378,0x20191379,0xaa7b00bc,0x6d4802ae}},	//   ball, resi_, _svým, ädan, 
   {{0x4426137a,0x7bdd11f7,0x61e1137b,0x8ca20035}},	//   _hao_, _sesu, call, _कीबो, 
   {{0x442602f5,0xe19600b9,0x7c26137c,0x20c1001b}},	//   _kao_, _эрдэ, _bakr, _gói_, 
   {{0x7c26137d,0x6e250065,0x4426023a,0x2019137e}},	//   _cakr, _wahb, _jao_, qesi_, 
   {{0xd6d7100b,0x4426137f,0x69c51380,0x2ca91381}},	// [b70] _সম্প, _mao_, tche, rmad_, 
   {{0x44261382,0x27e0010d,0x69c51383,0x386d1384}},	//   _lao_, ðinn_, uche, _smer_, 
   {{0x69c50600,0x7bdd1385,0x291903b8,0x44260026}},	//   rche, _tesu, تقاد_, _oao_, 
   {{0x69c51386,0x44261387,0xd75900eb,0x77991388}},	//   sche, _nao_, يلات_, окер_, 
   {{0x69c51389,0x61e1138a,0x68e50065,0x7ea0138b}},	//   pche, yall, sshd, löpa, 
   {{0x7c26138c,0x61e1089f,0x660d015e,0xf1ba0023}},	//   _zakr, xall, đako, _ngơ_, 
   {{0x4426138d,0x7c3a007a,0x387f138e,0x00000000}},	//   _bao_, _úcrá, _tjur_, --, 
   {{0x442600f7,0x61e1138f,0x24581390,0x2baa00bd}},	//   _cao_, wall, _démo_, चेवा, 
   {{0x61e11391,0x56950161,0x20c10023,0x248d1392}},	//   tall, _жаат, _sói_, roem_, 
   {{0x81bc01dd,0x7ea00747,0x25a002d9,0x44261393}},	//   ldēj, köpa, řila_, _eao_, 
   {{0x26cd0267,0x61e11394,0x35550740,0x64aa00bc}},	//   _hteo_, rall, _تناز, _přit, 
   {{0xd36e00c5,0x20e70588,0x81bc0243,0x20c10210}},	//   اهی_, rđi_, ndēj, _vói_, 
   {{0x61e11395,0x7c261396,0xfe7803a1,0xafa201ff}},	//   pall, _rakr, зүп_, ъқиқ, 
   {{0x6da60c67,0x44261397,0x644b1398,0xafdb00fb}},	//   дига, _zao_, _hogi, ljøl, 
   {{0x4426086d,0x7c26012d,0xb6060098,0xc692027a}},	//   _yao_, _pakr, _uráž, דאם_, 
   {{0x26cd0571,0x442600e7,0x8af000ad,0x27ed0241}},	//   _oteo_, _xao_, yyəd, _nden_, 
   {{0x644b1399,0xeb97139a,0x7c26004f,0x2012016c}},	// [b80] _mogi, дит_, _vakr, _ibyi_, 
   {{0x7c260053,0x24800352,0x63bc02d9,0xcf9300d1}},	//   _wakr, čimi_, ěrni, _בטח_, 
   {{0x7c26139b,0xa3bd00a2,0xa80600e4,0xafdb017b}},	//   _takr, _आलं_, дзел, kjøl, 
   {{0x9f42010c,0x26c8004e,0x644b139c,0xd7ef0038}},	//   vakê_, зған_, _nogi, لكم_, 
   {{0x44260029,0xdd8f009c,0xdb1d02c9,0x47360038}},	//   _rao_, _موی_, _afsæ, براز, 
   {{0x4426139d,0x27ed139e,0xdd1d0356,0x644b00a1}},	//   _sao_, _eden_, lášt, _aogi, 
   {{0x2299011c,0x7af6139f,0x00000000,0x00000000}},	//   mèkh_, lryt, --, --, 
   {{0xe9a313a0,0x644b13a1,0x7af60035,0xfc3f0108}},	//   _расп, _cogi, oryt, _khía_, 
   {{0x442613a2,0x60cd034c,0xd70313a3,0x84ea0b3e}},	//   _vao_, _čama, _изти, _टिकट_, 
   {{0x4426086d,0x24890062,0x64aa031e,0x4571004e}},	//   _wao_, čama_, _přis, _өңір, 
   {{0x442613a4,0x09f70056,0xd48f13a5,0x55e30176}},	//   _tao_, ומים_, _ар_, _рохб, 
   {{0xdbd603f0,0x644b00f3,0x00000000,0x00000000}},	//   _jääd, _gogi, --, --, 
   {{0xfe730133,0x9f42011c,0xff5f0216,0x00000000}},	//   ندس_, nakè_, tbîq_, --, 
   {{0x63a213a6,0x7af613a7,0x245100da,0x00000000}},	//   _izon, dryt, _dámu_, --, 
   {{0xdd9400e4,0xafdb01e8,0xdc140213,0x00000000}},	//   вары, ljøm, _ağız, --, 
   {{0xaa7b026e,0x7af6024a,0x4ba700d3,0x9f4201e5}},	//   _zvýh, fryt, дөгү_, kakè_, 
   {{0x5a3513a8,0xf09400a7,0xfc3f0369,0x7af613a9}},	// [b90] ннат, _בנק_, _chía_, gryt, 
   {{0x3b09008a,0x00000000,0x00000000,0x00000000}},	//   rtaq_, --, --, --, 
   {{0x29070218,0x80e00086,0xdb0d001d,0x0fe30083}},	//   îna_, পূর্, rcañ, परपढ, 
   {{0x7af613aa,0xdb0d0126,0xc19b00d1,0x00000000}},	//   bryt, scañ, חשבי, --, 
   {{0x6d55010e,0xa3c213ab,0x81bc0243,0x63a2007c}},	//   lyza, ंशन_, rdēj, _nzon, 
   {{0xe5a513ac,0x35a513ad,0x644b13ae,0x00000000}},	//   нили, налг, _sogi, --, 
   {{0x63a213af,0x629a13b0,0x04b513b1,0x00000000}},	//   _azon, dlto, нсия, --, 
   {{0x032513b2,0x27ed0022,0x63a2007b,0x629a13b3}},	//   един, _uden_, _bzon, elto, 
   {{0xe61013b4,0x64aa00bc,0x59b90035,0x200c010e}},	//   _چشم_, _přir, ेडकर, ődik_, 
   {{0x63a213b5,0x60c70228,0x64b101dd,0x24510098}},	//   _dzon, íjmo, _jāiz, _rámu_, 
   {{0x9f4213b6,0x644b052b,0x63a201b8,0x00000000}},	//   maké_, _togi, _ezon, --, 
   {{0xe730006b,0x644b0028,0x2cb901be,0x200413b7}},	//   _حصہ_, _uogi, _nisd_, ümi_, 
   {{0x63880034,0x00000000,0x00000000,0x00000000}},	//   rënë, --, --, --, 
   {{0x2cb901be,0x60c40121,0x2299011c,0x9f4200d4}},	//   _aisd_, _čimv, kèki_, naké_, 
   {{0x40960593,0xdd920491,0x9f42023e,0xe762009e}},	//   _прит, اوز_, iaké_, kêşî, 
   {{0xfc3f001b,0x9f4200c5,0x6da603dc,0x7af613b8}},	//   _phía_, haké_, диҳа, tryt, 
   {{0x9f4209e8,0x7bd60102,0x63a213b9,0xd0060259}},	// [ba0] kaké_, rbyu, _xzon, _жоққ, 
   {{0x9f42026e,0xdbd600c8,0xcfb700d1,0x2cb901f5}},	//   jaké_, _sääd, _אלפי_, _eisd_, 
   {{0xdbd613ba,0x9f4200d7,0x69a513bb,0x00000000}},	//   _pääd, daké_, _करणी, --, 
   {{0x27e013bc,0xe3a703b1,0xfc3f0108,0x2299011c}},	//   úin_, _مر_, _thía_, sèkh_, 
   {{0x81d60033,0x9f4200d7,0xb9070299,0x00000000}},	//   িণত_, faké_, _मौ_, --, 
   {{0xae04009a,0x9f4201e5,0xf526019c,0x00000000}},	//   श्चन_, gaké_, ефин, --, 
   {{0xa9a308ac,0xe9a313bd,0x65930470,0xbf9b010c}},	//   _бирд, _барп, лашу, nfêr, 
   {{0x25a000bc,0xf483004e,0x2bd3031e,0x43940f89}},	//   řilo_, луын, धुपा, кайс, 
   {{0x087700c7,0xb5fc00a4,0x27e613be,0x68fe011f}},	//   _נעמט_, _alġe, maon_, lupd, 
   {{0x27e613bf,0x3eba13c0,0x9f42023e,0x00000000}},	//   laon_, _nipt_, caké_, --, 
   {{0xd5a40c14,0x64a613c1,0x00000000,0x00000000}},	//   _ओरिज, _зажа, --, --, 
   {{0x27e613c2,0xf1a313c3,0x25a10502,0x83860080}},	//   naon_, ырын, ühle_, _пыле, 
   {{0x3ce3009a,0xf1d100bc,0xafdb00fb,0x2cb90027}},	//   टीने_, _द्वन, ljøk, _risd_, 
   {{0x27e613c4,0xfc3f00e7,0x6d550035,0x3eba0175}},	//   haon_, _chín_, tyza, _cipt_, 
   {{0x321e13c5,0x27e60495,0x6ca713c6,0x7e7513c7}},	//   mety_, kaon_, ераж, rizp, 
   {{0x321e1175,0x6d5500ab,0x2d9a00fc,0x00000000}},	//   lety_, ryza, _dype_, --, 
   {{0x200c06d0,0x9f42009e,0x29180036,0x00000000}},	// [bb0] ədi_, lakî_, _apra_, --, 
   {{0x321e13c8,0x19590a31,0x9e670038,0xafdb00fc}},	//   nety_, мазы_, _ساخن, kjøk, 
   {{0xa3e00d4f,0xa3c20497,0x9f420218,0xfe7f00b9}},	//   थरा_, ्डा_, nakî_, duïx_, 
   {{0x2918016a,0x321e023a,0xab5b09c6,0x00000000}},	//   _dpra_, hety_, _agüe, --, 
   {{0x321e026e,0x7c2d13c9,0x58b80038,0xe758004f}},	//   kety_, mdar, رامج_, ниці_, 
   {{0x7c2d13ca,0xe73613cb,0xf6d400d7,0x00000000}},	//   ldar, теш_, ازند, --, 
   {{0x64aa000d,0xc98413cc,0x9f4200d4,0x27e613cd}},	//   _přip, _бути, raké_, baon_, 
   {{0x248906f6,0x3d190083,0x9f4200d4,0x00000000}},	//   čamo_, _पहने_, saké_, --, 
   {{0x56e1004e,0x9f4213ce,0x130600c8,0x588413cf}},	//   _тұлғ, paké_, вный_, _сыра, 
   {{0xa77413d0,0x7c2d13d1,0xd3a4004e,0x68e102c9}},	//   _случ, hdar, ылық, _ælds, 
   {{0x7c2d13d2,0x320b00ab,0x216913d3,0x3eba040c}},	//   kdar, ęcy_, фини_, _ript_, 
   {{0x7c2d13d4,0x205613d5,0x337500f0,0x00000000}},	//   jdar, ттор, _игер, --, 
   {{0x7c2d13d6,0x442d13d7,0xf8b20137,0xe81300a2}},	//   ddar, mde_, ישט_, ण्या_, 
   {{0x644913d8,0x443d039b,0x2d9a0ff2,0x00000000}},	//   ljei, _hnw_, _pype_, --, 
   {{0xfc3f0183,0x1d0713d9,0x2d9a13da,0x67220035}},	//   _chío_, кери_, _qype_, zwoj, 
   {{0x7c2d0c36,0x61e313db,0x645b13dc,0x644912aa}},	//   gdar, _henl, nkui, njei, 
   {{0xc05300a7,0x6281105b,0x3eba01d2,0x27e601a7}},	// [bc0] _כזה_, onlo, _tipt_, vaon_, 
   {{0x442d030f,0x7c2d13dd,0x78a90054,0x628113de}},	//   hde_, adar, _ahev, nnlo, 
   {{0x442d13df,0x27e613e0,0x7c2d13e1,0xbf9b02aa}},	//   kde_, taon_, bdar, ngên, 
   {{0x442d13e2,0x38600084,0x321e0db7,0x68fe02a2}},	//   jde_, óir_, zety_, rupd, 
   {{0x442d13e3,0xe1e7040f,0x27e613e4,0xf11e00c6}},	//   dde_, _پس_, raon_, _बन्द_, 
   {{0x442d13e5,0x27e60495,0x443d039b,0x645b08b0}},	//   ede_, saon_, _anw_, ekui, 
   {{0x442d0e47,0xa80613e6,0x321e0180,0xd94313e7}},	//   fde_, _извл, vety_, _кери, 
   {{0x9f42010c,0xb8b4004e,0x6abb0183,0x78bb107c}},	//   vakî_, _сөзі, _éufr, _giuv, 
   {{0x68e101cc,0x321e0db7,0xd70700d9,0x799c0156}},	//   _ældr, tety_, _инте_, _hyrw, 
   {{0x386600ce,0x442d13e8,0x7c2d13e9,0x443d02bf}},	//   lhor_, ade_, zdar, _enw_, 
   {{0x26c413ea,0x442d01e8,0x7c2d13eb,0xa5d813ec}},	//   _humo_, bde_, ydar, _न्यौ, 
   {{0xf9930056,0x386602a0,0x321e13ed,0x68e31385}},	//   ירת_, nhor_, sety_, ândi, 
   {{0x260907d5,0x321e1175,0x7c2d13ee,0x69ce003e}},	//   _सामी_, pety_, vdar, _ofbe, 
   {{0xdce50039,0x27e4002e,0x61e313ef,0x42560843}},	//   _vyhľ, _lemn_, _genl, _штет, 
   {{0x7c2d13f0,0xac1913f1,0x0d8413f2,0xa3e600a5}},	//   tdar, нову_, алён, _बजा_, 
   {{0xfbd3040f,0x69ce0b32,0x7c2d13f3,0x61e813f4}},	//   شتر_, _afbe, udar, ladl, 
   {{0x386613f5,0x6a1500f0,0x78a90379,0x9be400f0}},	// [bd0] dhor_, лмау, _rhev, ріск, 
   {{0x442d13f6,0xf09f00d3,0x78a913f7,0x7c2d13f8}},	//   zde_, llà_, _shev, sdar, 
   {{0x442d13f9,0x9f4e0019,0x7c2d0339,0x6abc13fa}},	//   yde_, önöm_, pdar, _dirf, 
   {{0x61e813fb,0x248608b1,0x26c4035f,0x7c2d00ad}},	//   hadl, _njom_, _bumo_, qdar, 
   {{0x442d13fc,0x61e813fd,0x3707123f,0xdbd100b0}},	//   vde_, kadl, тчев, _müüd, 
   {{0x442d13fe,0x7aed13ff,0x6abc008a,0x66051400}},	//   wde_, msat, _girf, упка, 
   {{0x260900a2,0x61e81401,0x442d1402,0x26c400b9}},	//   _साठी_, dadl, tde_, _eumo_, 
   {{0x6281054f,0x61e31403,0x29011404,0x26c41405}},	//   wnlo, _senl, muha_, _fumo_, 
   {{0x442d1406,0x7aed0f08,0x645b1407,0x387c0107}},	//   rde_, nsat, rkui, èvre_, 
   {{0x442d1408,0xb7bd002e,0x645b1409,0x6729140a}},	//   sde_, _naţi, skui, _isej, 
   {{0x61e3140b,0x42c803a1,0x26c4140c,0x2901140d}},	//   _venl, нгөн_, _zumo_, nuha_, 
   {{0x44e100e4,0xbf9b03b7,0x8335105a,0x26c4095a}},	//   mų_, rgên, _مرتض, _yumo_, 
   {{0x44e1012d,0x27e00a6d,0x7bcd140e,0x26c4040c}},	//   lų_, ðini_, dcau, _xumo_, 
   {{0x249f140f,0x29011410,0x7aed0d86,0x3f9e00e0}},	//   llum_, kuha_, dsat, ātu_, 
   {{0x44e100e4,0x00000000,0x00000000,0x00000000}},	//   nų_, --, --, --, 
   {{0xa3e60262,0xc0061411,0x29011412,0x8c9601fc}},	//   _बड़ा_, _спик, duha_, ургі, 
   {{0xfc3f0076,0x7aed1413,0xcb671414,0x6a8602be}},	// [be0] _dní_, gsat, гате_, глаа, 
   {{0x44e100e4,0xfeba024f,0x6b9d02bf,0x27e400b3}},	//   kų_, _ثابت_, _dysg, _semn_, 
   {{0x44e100e4,0x7aed1415,0x3e66026a,0x386600a7}},	//   jų_, asat, _côte_, thor_, 
   {{0x8c461416,0x44e1012d,0x6abc1417,0x61e81418}},	//   _семе, dų_, _wirf, zadl, 
   {{0x09e80086,0x6b9d017c,0x81bc01dd,0xd7f9004f}},	//   _পাঠা, _gysg, ldēt, тує_, 
   {{0x2ca01419,0x2901141a,0xa3e600aa,0xfc3f02d9}},	//   llid_, buha_, _बजह_, _zní_, 
   {{0x61e8141b,0x44e1012d,0x2ca000c2,0xa3c2103d}},	//   vadl, gų_, olid_, ्डल_, 
   {{0x2609141c,0x5454141d,0x955300eb,0x26c4141e}},	//   _साथी_, рвит, إخوا, _tumo_, 
   {{0x41e60769,0x61e8141f,0x18670267,0x2ca001a4}},	//   ліна, tadl, _сати_, ilid_, 
   {{0x471b00c7,0xdbd1007e,0x44e10009,0x42741420}},	//   _אומג, _süüd, bų_, ргос, 
   {{0x3de21421,0x26091422,0x249f1423,0x2ca0007e}},	//   _বাংল, _साती_, blum_, klid_, 
   {{0x7aed0a6d,0xfc3f001b,0xa2e60104,0x61e81424}},	//   ysat, _phím_, _бодд, sadl, 
   {{0x543b0137,0x61e81425,0xd9e407d5,0x2901090e}},	//   _רעדא, padl, गरात_, zuha_, 
   {{0x6a60003e,0x2ca01009,0x2901016c,0x00000000}},	//   _söfn, elid_, yuha_, --, 
   {{0x6d4a02be,0xf09f03dd,0x00000000,0x00000000}},	//   _àfal, plà_, --, --, 
   {{0x7aed1426,0x2ca000b0,0xfc3f0023,0x10e31427}},	//   tsat, glid_, _thím_, _уюшм, 
   {{0x3a751428,0x998c0ab4,0x0ca800c8,0x2df401a2}},	// [bf0] алар, _ćoše_, утри_, шҷӯё, 
   {{0x7aed13d7,0x7ed40084,0x7bcd1429,0x2901142a}},	//   rsat, _ازيا, scau, tuha_, 
   {{0x7aed142b,0x667500c5,0xc984142c,0x2ca0142d}},	//   ssat, یدتر, буци, blid_, 
   {{0x2901142e,0x2c2702fb,0x7aed142f,0x2ca01430}},	//   ruha_, _сьог, psat, clid_, 
   {{0xf7451431,0x26001432,0x29011433,0xd6db1434}},	//   рело, _राखी_, suha_, хте_, 
   {{0x44e100e4,0x09df0086,0xa2c303c1,0x2901016c}},	//   tų_, _ঢাকা, रदस्, puha_, 
   {{0x58d4121b,0x249f1435,0x7c2f1436,0xafdb0a1f}},	//   _гост, tlum_, _kacr, ljøu, 
   {{0x99840084,0x44e1012d,0x67290149,0x60c41437}},	//   _الفو, rų_, _tsej, _čimp, 
   {{0x76b90161,0xc8641438,0x09e80086,0x67291439}},	//   _алар_, _утри, _পাতা, _usej, 
   {{0x7c2f143a,0xaa7b143b,0x4255143c,0x81ae0086}},	//   _lacr, _zvýr, ртит, কশন_, 
   {{0xa06a143d,0xc4f800b1,0x249f0b8b,0x2ca000f8}},	//   вана_, _معنا_, plum_, ylid_, 
   {{0xb4c1143e,0x7c2f0062,0x54a7143f,0xcea9042c}},	//   ंदी_, _nacr, _صحاف, _חי_, 
   {{0x2ca01440,0x00000000,0x00000000,0x00000000}},	//   vlid_, --, --, --, 
   {{0x442f1441,0x3ebe0875,0x2ca00ef8,0x00000000}},	//   _hag_, ött_, wlid_, --, 
   {{0xfce60303,0x442f1442,0x00000000,0x00000000}},	//   робо, _kag_, --, --, 
   {{0x442f1443,0xbc631444,0xa3ac03c1,0x2fdf01d5}},	//   _jag_, овск, _गरम_, ðugt_, 
  
   {{0x91fc00e0,0x6b850038,0x2ca01445,0xb4c11446}},	// [c00] bkād, مشكل, rlid_, ंदु_, 
   {{0xe9d71447,0x442f1448,0x7ea0014e,0x4a431449}},	//   ику_, _lag_, köpi, онув, 
   {{0x7e7c02fe,0xa926004e,0x7c2f00a1,0xdca6144a}},	//   mirp, рдел, _facr, _вани, 
   {{0x442f144b,0x7e7c0065,0x4907007e,0x6d5c144c}},	//   _nag_, lirp, _हमरो_, myra, 
   {{0x7c24144d,0xd7070d0c,0x6d5c144e,0x2813144f}},	//   meir, инце_, lyra, تونس, 
   {{0x7c241450,0xb4c11451,0x7c2f0112,0x80db0033}},	//   leir, ंदू_, _zacr, _ভিন্, 
   {{0x3947022b,0x2bd3034d,0x6d5c1452,0x442f1453}},	//   änst_, धुवा, nyra, _bag_, 
   {{0x7c241454,0x442f1455,0x8af00095,0x73d700fd}},	//   neir, _cag_, yyəl, адър_, 
   {{0x27e0008c,0xd5b100e7,0x6d5c00f8,0x8ccd00b0}},	//   ðinu_, _máy_, hyra, _दूनो, 
   {{0x80ca03c1,0x7d1e02fb,0x7c241456,0x442f0387}},	//   _संदे, _opps, heir, _eag_, 
   {{0x3a370056,0xd57500dd,0x51861457,0x442f1458}},	//   ברים_, _луць, рупа, _fag_, 
   {{0x442f1459,0x78a202f1,0x7c24145a,0x1b1d0033}},	//   _gag_, nlov, jeir, নিতে_, 
   {{0x7c24145b,0x4424145c,0x236d00ab,0x78a2026e}},	//   deir, mem_, czej_, ilov, 
   {{0xa2c300a5,0x442f145d,0x78a2145e,0xbe880080}},	//   रदर्, _zag_, hlov, ассе_, 
   {{0x7c2402bf,0x78a2145f,0xd08700c8,0x6d5c1460}},	//   feir, klov, _выпи, gyra, 
   {{0x44241461,0x78a21462,0x7c241463,0x26161464}},	//   nem_, jlov, geir, प्ती_, 
   {{0x78a2026e,0x44241465,0xf9c71231,0x80ca00bd}},	// [c10] dlov, iem_, ащен, _सूते, 
   {{0x44241466,0x24891467,0xae1600b0,0x753a01ca}},	//   hem_, čami_, द्दन_, _ortz, 
   {{0x7c241468,0x7c2f1469,0x78a200da,0x644201f5}},	//   beir, _tacr, flov, _onoi, 
   {{0x7c24146a,0x28f8017b,0x00000000,0x00000000}},	//   ceir, рець_, --, --, 
   {{0x2b470afc,0x442f146b,0x753a01f1,0xafdb01e8}},	//   _тэнг, _rag_, _artz, ljøs, 
   {{0x6442057f,0x442f146c,0x78a2146d,0x00000000}},	//   _anoi, _sag_, alov, --, 
   {{0xe299146e,0x442f146f,0x78a21470,0xb4c109ef}},	//   ған_, _pag_, blov, ंदे_, 
   {{0x44241471,0xf8b91472,0x628a0f23,0x442f0201}},	//   gem_, _сөз_, _ajfo, _qag_, 
   {{0x442f1473,0xe29901a2,0x753a0a9f,0xd8b60019}},	//   _vag_, лаи_, _ertz, _اگلا_, 
   {{0x442f1474,0x7c2402a0,0x9f421102,0x673b01cf}},	//   _wag_, zeir, jaká_, _iruj, 
   {{0x236d006a,0x442f1475,0x44241476,0x291301f1}},	//   szej_, _tag_, bem_, ntxa_, 
   {{0x44241477,0x7c24146a,0x442f050a,0x673b0034}},	//   cem_, xeir, _uag_, _kruj, 
   {{0x7c240c7c,0x43741478,0x6d4105ac,0x6d5c00f8}},	//   veir, _мушт, ålan, wyra, 
   {{0xda0304d7,0x6d5c1479,0x1d0a147a,0x539a00d1}},	//   _लागत_, tyra, леги_, _גינו, 
   {{0x7c24147b,0x78a2147c,0x98a702d9,0x3ce300bc}},	//   teir, ylov, íně_, टीले_, 
   {{0xeb9a147d,0x3fe60843,0x673b147e,0xab2a147f}},	//   гиб_, _ужив, _oruj, лоба_, 
   {{0x7c241480,0x387d0156,0x64aa00bc,0x5baa021d}},	// [c20] reir, diwr_, _přiz, укам_, 
   {{0x7c241481,0x09e80086,0x0f3700d1,0x00000000}},	//   seir, _পাহা, _פריט_, --, 
   {{0x7d1e1482,0xe8fa1483,0x7c241484,0x8bf40033}},	//   _upps, уле_, peir, ঙ্গন_, 
   {{0x44241485,0x673b0ad2,0x16050077,0xafdb00fb}},	//   xem_, _bruj, _राउर_, ljør, 
   {{0x44241486,0x78a20e25,0x7bc6012b,0x673b0369}},	//   vem_, rlov, _igku, _cruj, 
   {{0x78a21487,0xa4d81488,0x442400ab,0x13e002e6}},	//   slov, адку_, wem_, नर्भ, 
   {{0x26091489,0x7bc6012b,0x9ac3003d,0xa96a0fa7}},	//   _सारी_, _kgku, ċċes, _сива_, 
   {{0xafdb00fb,0x4424148a,0x00000000,0x00000000}},	//   hjør, uem_, --, --, 
   {{0xe737030f,0x5334148b,0x9f5e078a,0x673b148c}},	//   _лет_, цепт, ştê_, _gruj, 
   {{0x4424148d,0x3d190da6,0x6f060527,0x00000000}},	//   sem_, _पहले_, dukc, --, 
   {{0x4424073d,0x3a3700a7,0x1a9b00c7,0xe69307cb}},	//   pem_, זרים_, רייע, _علمد, 
   {{0x5edd0033,0xc95300d1,0x9f4b0212,0x518600a3}},	//   _বিবে, למת_, lacé_, _қула, 
   {{0xa3bc148e,0xdef809d9,0xa3ac00bc,0xafdb00fc}},	//   _आणि_, йыр_, _गरि_, fjør, 
   {{0x63a2148f,0xafdb00dd,0x161b109f,0x9f4000f6}},	//   _iyon, gjør, प्पर_, _deià_, 
   {{0x865b1490,0xdd3a00b3,0x63a21032,0x00000000}},	//   נדלי, văţa, _hyon, --, 
   {{0x63a20298,0x4fc700d9,0x8bd91491,0x61ea0679}},	//   _kyon, _уска, рмас_, _hefl, 
   {{0x62881492,0x26091493,0x6d480219,0xafdb1494}},	// [c30] ondo, _साली_, ädar, bjør, 
   {{0x62881495,0x80db0086,0xe9ab00d7,0x00000000}},	//   nndo, _ভিত্, هدان_, --, 
   {{0x63a21496,0x628808a3,0x09e80033,0xac950258}},	//   _lyon, indo, _পাশা, _маош, 
   {{0x629a0a41,0xf77000d6,0x6e271497,0x27e9070b}},	//   hoto, کام_, lejb, úan_, 
   {{0x629a1498,0x65c51499,0x61f8149a,0x387d00f8}},	//   koto, обла, _odvl, riwr_, 
   {{0xe618005e,0x673b0082,0x34b30fcf,0xddc502d9}},	//   йді_, _vruj, ुद्द, _pohř, 
   {{0x69c702fb,0x63a201a3,0xa01b02ae,0x00000000}},	//   _igje, _ayon, rnöj, --, 
   {{0x06d80086,0x63a20a8b,0xe459149b,0x6e2700de}},	//   _সিরি, _byon, ржи_, hejb, 
   {{0x629a149c,0x60ca01c4,0x42c603aa,0x63a202b8}},	//   foto, _aufm, огын_, _cyon, 
   {{0x629a149d,0x63a205d5,0x60d800b9,0xbbc60299}},	//   goto, _dyon, _btvm, _वल्क, 
   {{0x60260504,0x63a20539,0xdddc0009,0x63f9149e}},	//   одна, _eyon, sirū, _نفاس_, 
   {{0x6288149f,0x50460886,0x99580228,0xe45f00b0}},	//   ando, цемб, náša_, ööd_, 
   {{0x629a14a0,0x63a20547,0xe1ee11f0,0x69c3020b}},	//   boto, _gyon, _ог_, žneh, 
   {{0x61ea14a1,0x629a14a2,0x68f50098,0x69c70034}},	//   _gefl, coto, _ovzd, _ngje, 
   {{0xed570161,0x8c7a0093,0xdd9208cb,0x2c6700c2}},	//   оор_, ащат_, ذور_, _sõda_, 
   {{0x69c700e5,0x69d501c8,0x8c4314a3,0x9f4000f6}},	//   _agje, _afze, месе, _teià_, 
   {{0x20e7010e,0xfc3f0108,0x2ea7010e,0x00000000}},	// [c40] lői_, _nhíu_, _ڈپٹی_, --, 
   {{0xafdb14a4,0x67200175,0xa01b039f,0x00000000}},	//   ljøp, _rpmj, ynök, --, 
   {{0x38cb00d6,0xc7c614a5,0xc92a00fd,0x60c414a6}},	//   لانی_, осли, роеж_, _kiim, 
   {{0x69da14a7,0x629a14a8,0x09aa009a,0x186a1329}},	//   _प्री, zoto, _करीय, јади_, 
   {{0x41c9000c,0x3ced003a,0x629a0010,0xc5f30086}},	//   रशास, ćeve_, yoto, চ্ছা_, 
   {{0x473302fb,0xa3dc009a,0x7c3614a9,0x60c414aa}},	//   ьніс, तुन_, ldyr, _liim, 
   {{0x629a14ab,0xafdb017b,0x63a202a5,0x00000000}},	//   voto, kjøp, _syon, --, 
   {{0x69c701ee,0x7c3614ac,0x629a14ad,0x60c414ae}},	//   _zgje, ndyr, woto, _niim, 
   {{0x629a0268,0x9f4b023e,0x00000000,0x00000000}},	//   toto, pacé_, --, --, 
   {{0xd25a1297,0x6288019c,0x7ae904a8,0x63a2016c}},	//   рци_, undo, _çete, _vyon, 
   {{0x6288050f,0x403514af,0xfc3f0108,0x00000000}},	//   rndo, пенс, _khít_, --, 
   {{0x7ea00219,0x629a14b0,0x6a6001d5,0x00000000}},	//   köps, soto, _döfi, --, 
   {{0x63a2012b,0x628f0212,0x06cc0033,0xdfa7007a}},	//   _uyon, écoc, রীরি, تحدي, 
   {{0x5edd0086,0xf8ca00bd,0x69da08e1,0x00000000}},	//   _বিদে, िदाय, _प्ली, --, 
   {{0xa6e90108,0x70590176,0x00000000,0x00000000}},	//   _giươ, _гайр_, --, --, 
   {{0x60c40008,0x3f8c0241,0x00000000,0x00000000}},	//   _giim, ğdur_, --, --, 
   {{0x3f8c0095,0x27ef14b1,0x69c70126,0x00000000}},	// [c50] şdur_, vagn_, _pgje, --, 
   {{0xe80d04d7,0x0b8800dd,0x2451014b,0x60c414b2}},	//   _हाहा_, істи_, _dámy_, _ziim, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb8f314b3,0xfc3f0023,0x88c8017b,0x245100de}},	//   _हं_, _chít_, ілів_, _fámy_, 
   {{0x87270038,0x4907072d,0x09e30033,0x20e7039f}},	//   تعام, _हमको_, মণবা, zői_, 
   {{0x27ef00fb,0xb9010033,0xd62914b4,0x96050249}},	//   sagn_, _দি_, соке_, रलेट_, 
   {{0x224914b5,0x3b090065,0x2fc90102,0xb06600c8}},	//   _đak_, luaq_, _ogag_, nsää, 
   {{0x2fc90008,0x20e7010e,0xd7f0007a,0x00000000}},	//   _ngag_, vői_, _لكِ_, --, 
   {{0xeda8031e,0x66f414b6,0xc6a714b7,0x3b09023e}},	//   _गर्छ, _опту, _држи, nuaq_, 
   {{0x27ed0af8,0xcb1203e1,0x2fc90118,0x20e7010e}},	//   _heen_, עלי_, _agag_, tői_, 
   {{0xa0a614b8,0x60c414b9,0x2d840241,0x61450cda}},	//   занд, _piim, şmez_, чена, 
   {{0x26c5086d,0xc4d200a7,0x24890126,0x00000000}},	//   _hilo_, _נגד_, _ñam_, --, 
   {{0x60c414ba,0x27ed14bb,0x7c360bf7,0x25a514bc}},	//   _viim, _meen_, vdyr, _hyll_, 
   {{0xd356042c,0x27ed14bd,0x2ee90226,0x645914be}},	//   _מיני_, _leen_, _dwaf_, _howi, 
   {{0x2fcd14bf,0x60c414c0,0x9d4314c1,0x7c360657}},	//   žega_, _tiim, нерд, tdyr, 
   {{0x628114c2,0x27ed02b0,0x3eb80a1a,0x6b8900ca}},	//   lilo, _neen_, smrt_, _žega, 
   {{0x20120610,0x26c501d6,0x2d850212,0x645914c3}},	// [c60] _icyi_, _oilo_, ûler_, _mowi, 
   {{0x62810012,0x6a6002ae,0xee3700b3,0x64590216}},	//   nilo, _löfv, _ень_, _lowi, 
   {{0x27ed0056,0x2f1601cc,0x7c2a0afc,0x7c36076b}},	//   _been_, læg_, _лонг_, pdyr, 
   {{0x628114c4,0xc18c00c7,0x645914c5,0xa3ac0790}},	//   hilo, סטאָ, _nowi, _गरल_, 
   {{0x628114c6,0x16340445,0xb8f310cf,0xd7ef0038}},	//   kilo, деля, _हू_, اكه_, 
   {{0x6b8906b6,0x98ac07fa,0x26c500ca,0xfe1f1280}},	//   _þega, ılır_, _cilo_, म्पस_, 
   {{0x628114c7,0x26c514c8,0x645914c9,0x3494012d}},	//   dilo, _dilo_, _bowi, макр, 
   {{0x27ed14ca,0x18a314cb,0x48e60176,0x7bd60027}},	//   _geen_, _засм, _моҳв, ncyu, 
   {{0x645900ab,0x26c514cc,0x386614cd,0x00000000}},	//   _dowi, _filo_, mkor_, --, 
   {{0x628114ce,0x25a514cf,0x26c5011c,0xb273069b}},	//   gilo, _fyll_, _gilo_, ельш, 
   {{0x764814d0,0x27ed0065,0xfc3f0038,0xa15800b3}},	//   _indy, _yeen_, _mhír_, цану_, 
   {{0xa3e6000f,0x386614d1,0x7af600c8,0xdfd800fd}},	//   _बजट_, nkor_, ksyt, зър_, 
   {{0x9f5e078a,0x6a60010d,0x765a14d2,0xe29a14d3}},	//   ştî_, _höfu, _koty, _лад_, 
   {{0x628100d9,0x644701dd,0x645914d4,0x386601ff}},	//   cilo, ējie, _zowi, hkor_, 
   {{0x765a14d5,0x386614d6,0x645900d7,0x9f4b02d9}},	//   _moty, kkor_, _yowi, mací_, 
   {{0x4fc70235,0xea0000e7,0x9f4b0356,0x765a14d7}},	//   _эска, _đạn_, lací_, _loty, 
   {{0x5a351130,0xb0660088,0xfbd000eb,0x27ed0326}},	// [c70] мнат, ssää, اتف_, _reen_, 
   {{0x32d2001b,0x765a14d8,0x27ed00a7,0x9f4b02d9}},	//   _mây_, _noty, _seen_, nací_, 
   {{0x80a4040f,0x26c5012b,0x32d20023,0x6dc3008a}},	//   _زمین, _rilo_, _lây_, _qċaċ, 
   {{0x2c0900c5,0x9f4b14d9,0x00000000,0x00000000}},	//   _بعدی_, hací_, --, --, 
   {{0x2ca914da,0xcc5603e1,0x9f4b00bc,0x27ed064e}},	//   mlad_, _חברי_, kací_, _veen_, 
   {{0x2ca914db,0x645914dc,0x62810a9f,0x62790254}},	//   llad_, _sowi, xilo, lňov, 
   {{0x64590da6,0x765a14dd,0x27ed14de,0x628114df}},	//   _powi, _doty, _teen_, vilo, 
   {{0x3866022b,0x61e402a6,0x32d2001b,0x26c514e0}},	//   ckor_, _đila, _bây_, _wilo_, 
   {{0x628114e1,0x32d20029,0x2ca90156,0x386d14e2}},	//   tilo, _cây_, ilad_, _iler_, 
   {{0x32d2001b,0x2ca914e3,0x2f1614e4,0x00000000}},	//   _dây_, hlad_, væg_, --, 
   {{0x62810aa4,0x2ca914e5,0x356b14e6,0x44290042}},	//   rilo, klad_, _уран_, _ºa_, 
   {{0x628114e7,0x1de6102c,0x6279014b,0x6a6014b1}},	//   silo, कर्ष_, jňov, _höft, 
   {{0x32d20029,0x2ca914e8,0x6279014b,0xd3d80038}},	//   _gây_, dlad_, dňov, _ربنا_, 
   {{0x5edd00cc,0x248d14e9,0x7cd5012d,0x386614ea}},	//   _বিশে, lnem_, _sąra, zkor_, 
   {{0x248d14eb,0x6da314ec,0xdca614ed,0x386d0126}},	//   onem_, вира, дави, _oler_, 
   {{0x248d14ee,0x4e1f0d0d,0x2ca914ef,0x6a600219}},	//   nnem_, म्बई_, glad_, _löft, 
   {{0xa5a40509,0x3ced14f0,0x32d20029,0xdca314f1}},	// [c80] _चुनौ, ćeva_, _xây_, тати, 
   {{0x1e8307b9,0x386d00b9,0x2ca901a4,0x7af614f2}},	//   _альм, _aler_, alad_, rsyt, 
   {{0x2ca914f3,0x9f420032,0x249f0151,0x729a0147}},	//   blad_, jakú_, koum_, קסעס, 
   {{0x20d30029,0x248d14f4,0x9f4b00bc,0x315600c7}},	//   _mãi_, jnem_, zací_, ויען_, 
   {{0x248d14f5,0x20d300e7,0x386614f6,0xfc3f007a}},	//   dnem_, _lãi_, rkor_, _thír_, 
   {{0x386614f7,0xa3c1072d,0x387f0175,0xa01b14f8}},	//   skor_, ंधन_, _emur_, lnöt, 
   {{0x386d14f9,0x9f4b035e,0xceb30137,0x656300f8}},	//   _fler_, vací_, דיג_, gynh, 
   {{0x38b50c29,0x29180982,0x60cd00ef,0x684300d3}},	//   gård_, _iqra_, _čamp, _инса, 
   {{0x27e614fa,0xd62600eb,0x41c90b3e,0x765a14fb}},	//   mbon_, _يعطي, रशंस, _toty, 
   {{0x20d300e7,0x27e601f1,0x518614fc,0x32d20023}},	//   _bãi_, lbon_, дума, _vây_, 
   {{0x248d14fd,0x9f4b0356,0x20d300e7,0x1bee0299}},	//   bnem_, rací_, _cãi_, जराल_, 
   {{0x32d20029,0x27e614fe,0x20d30108,0x9f4b00da}},	//   _tây_, nbon_, _dãi_, sací_, 
   {{0x80ca06c9,0x2ca914ff,0x44fa01dd,0x62791102}},	//   _संके, vlad_, lī_, vňov, 
   {{0x2ca9017c,0x20050540,0x8d6b02a0,0x91f20790}},	//   wlad_, şli_, ојба_, _आजिज_, 
   {{0x44fa01dd,0x6279014b,0x20d30108,0x00000000}},	//   nī_, tňov, _gãi_, --, 
   {{0x8af00264,0x2ca00102,0xa3b500c9,0xfc3f0108}},	//   yyət, goid_, छेक_, _chíp_, 
   {{0x7b1800c8,0x2918003d,0x2d9e1500,0x62790098}},	// [c90] мотр_, _aqra_, üter_, rňov, 
   {{0xd5a40105,0x248d1501,0x62790098,0x2ca000a1}},	//   _نہ_, znem_, sňov, aoid_, 
   {{0x6279026e,0x386d011c,0xfbd0010e,0x2ca0011c}},	//   pňov, _pler_, اتہ_, boid_, 
   {{0x44fa0b03,0x2ca01502,0x59df1503,0x765e0080}},	//   dī_, coid_, _प्रर, öpyn, 
   {{0xf6251504,0x248d02ee,0x7c2d1505,0x38b5014e}},	//   едло, vnem_, mear, vård_, 
   {{0x7c2d1506,0x8cb91507,0xb0cf0c64,0x453500fd}},	//   lear, ्दको, _संलग, ехит, 
   {{0xe5a21508,0x248d02ee,0x64a51509,0x35a202f1}},	//   лиши, tnem_, нака, лашг, 
   {{0x7c2d150a,0x20d300e7,0x386d150b,0x27e60108}},	//   near, _rãi_, _uler_, cbon_, 
   {{0x248d150c,0x6d430082,0x27ff150d,0x00000000}},	//   rnem_, _šnal, _idun_, --, 
   {{0x7c2d009f,0x248d150e,0xc0e5150f,0x00000000}},	//   hear, snem_, ноок, --, 
   {{0x00860245,0x7c2d01ca,0x2c0f00bd,0x248d1510}},	//   елно, kear, िलां_, pnem_, 
   {{0x20d30023,0x7c2d1511,0x00000000,0x00000000}},	//   _vãi_, jear, --, --, 
   {{0xe28e1512,0x442d1513,0x7c2d1514,0x270d00a2}},	//   _ба_, mee_, dear, _समोर_, 
   {{0x442d1515,0x877a07e4,0xdca302f1,0x82350296}},	//   lee_, לארי, ҳаси, _سرتا, 
   {{0x6fa01516,0x26170fec,0x8af00095,0x7c2d1517}},	//   _गुरू, _नानी_, yyəs, fear, 
   {{0x442d1518,0x7c2d1519,0xdca60804,0xdca3151a}},	//   nee_, gear, хаби, гаси, 
   {{0x644b02cd,0xab270b81,0xdb1c00ad,0xeb9700b9}},	// [ca0] _mngi, нота_, _özüm, еит_, 
   {{0x442d151b,0x27ff1233,0x7f44151c,0x2ca0011c}},	//   hee_, _adun_, _iriq, soid_, 
   {{0x442d151d,0x7c2d151e,0x644b151f,0x26df02be}},	//   kee_, bear, _ongi, _atuo_, 
   {{0x7c2d1520,0x442d1521,0x27e602b0,0xb05b059e}},	//   cear, jee_, ubon_, rmäg, 
   {{0x3a38012d,0x7d0e1522,0xfe170c46,0xb5fc008a}},	//   _tarp_, lubs, _तामस_, _joġg, 
   {{0x7ae41523,0x6e2e1524,0x200002a2,0x27ff1525}},	//   mpit, nebb, _ldii_, _edun_, 
   {{0x442d1526,0x7ae41527,0x69dc1528,0x2b401529}},	//   fee_, lpit, _ifre, lvic_, 
   {{0x442d0691,0x44fa0caf,0x7ae40053,0x6e2e152a}},	//   gee_, rī_, opit, hebb, 
   {{0x7ae4152b,0x760a00b3,0x96ba152c,0xb05b0080}},	//   npit, _неаг_, _فائز_, nmäe, 
   {{0x644b152d,0x7c2d0a9f,0xda100e07,0x75d60038}},	//   _engi, zear, ालित_, _أيضا, 
   {{0xd48f152e,0xa194152f,0x06d80033,0x7f441530}},	//   _бр_, танч, _সিটি, _ariq, 
   {{0x7ae41531,0x442d1532,0x7f441533,0x7c2d01ca}},	//   kpit, cee_, _briq, xear, 
   {{0x69dc128a,0xbfab13f2,0x7c2d1534,0x7f441535}},	//   _ofre, ятое_, vear, _criq, 
   {{0x2b400121,0x6e2e010e,0x69ce0096,0x78a200c2}},	//   dvic_, gebb, _ngbe, hoov, 
   {{0x7c2d1536,0x3ced034c,0xdd940161,0xac191537}},	//   tear, ćevo_, гары, мову_, 
   {{0x69dc1538,0xa01b0219,0x7f4400b9,0x9f52009e}},	//   _afre, rnös, _friq, _meyê_, 
   {{0x7c2d1539,0xddc50228,0x7ae40daa,0x5f95153a}},	// [cb0] rear, _dlhš, gpit, _шиит, 
   {{0x7c2d153b,0x442d153c,0x6f0f02a3,0x1dd5153d}},	//   sear, zee_, mucc, _दलित, 
   {{0x9f520218,0x6f0f153e,0x7c2d153f,0x6f1d0380}},	//   _neyê_, lucc, pear, ltsc, 
   {{0x442d050a,0xdddc012d,0x69dc1540,0x6f1d01c8}},	//   xee_, mirš, _efre, otsc, 
   {{0xd3661541,0xab8707f9,0x6f1d1542,0xb8d80262}},	//   _ئه_, _чунк, ntsc, _घी_, 
   {{0x442d1543,0x6d4a00eb,0x6f1d0380,0x6d480566}},	//   wee_, _áfac, itsc, ædag, 
   {{0x442d1544,0x78a200ef,0x6f1d127f,0x628f0151}},	//   tee_, boov, htsc, écom, 
   {{0x69ce00ca,0x442d0102,0xc3250033,0x00000000}},	//   _zgbe, uee_, বিসি_, --, 
   {{0x2ba70509,0x36d502fb,0x442d0056,0x9f4b1545}},	//   _कुमा, _розр, ree_, yacá_, 
   {{0x6f0f1546,0x442d1547,0xcb1400c7,0x20000065}},	//   ducc, see_, אלץ_, _sdii_, 
   {{0xd00a1548,0x3555024f,0x6d450201,0x6e2e010e}},	//   мене_, _جناز, _nrha, vebb, 
   {{0x6e2e0539,0x7bcf0226,0x644b1549,0x60dc0068}},	//   webb, _ngcu, _ungi, írma, 
   {{0xa3a800a2,0x6e2e154a,0x547a00d1,0x6f0f0036}},	//   _खुप_, tebb, _קטנו, gucc, 
   {{0xdee3154b,0x6d4502cd,0x7bdd00a3,0x8cd60299}},	//   рори, _brha, _afsu, _मंदो, 
   {{0x7afd154c,0x6da60099,0x6e2e048a,0xada6154d}},	//   _avst, тива, rebb, тавл, 
   {{0x7f44154e,0x6e2e154f,0x69dc1550,0x6f0f1551}},	//   _triq, sebb, _sfre, bucc, 
   {{0x7d0e1552,0x6d4502f2,0x6b631553,0x7d1c02ee}},	// [cc0] subs, _erha, акта, strs, 
   {{0x63ab0102,0x7ae41554,0x2b400604,0xb5fc008a}},	//   _mygn, rpit, rvic_, _koġe, 
   {{0x2ba70081,0x7ae41555,0xa3a81556,0x1bea0080}},	//   _कुठा, spit, _खुन_, _одни_, 
   {{0x66e61557,0xe7861558,0x7ae41559,0xe3a7155a}},	//   вода, куло, ppit, _نر_, 
   {{0x62830032,0x9f520216,0x994f009e,0x78a2059e}},	//   _omno, _seyê_, _tûşa_, roov, 
   {{0xb7d20086,0x20ee00bc,0x78a200b0,0x6594022c}},	//   ারেট, yři_, soov, лалу, 
   {{0x6f0f0036,0x91fc01dd,0xd3e90033,0xf8ad022c}},	//   zucc, skāk, _গাড়ি_, _гө_, 
   {{0x63ab155b,0x6283155c,0xfaa601a2,0x394702c9}},	//   _bygn, _amno, _чаҳо, ænse_, 
   {{0xa7a7155d,0x63ab155e,0x8725155f,0xe61a1560}},	//   _акта_, _cygn, _معلم, _ода_, 
   {{0x63ab014e,0x20ee00d8,0x00000000,0x00000000}},	//   _dygn, tři_, --, --, 
   {{0x26171561,0x60f8012d,0x7c2610ea,0x2b46020b}},	//   _नाती_, эння_, _obkr, ťoch_, 
   {{0xdddc0009,0x6f0f01d8,0x6f1d1562,0x30a400fd}},	//   virš, tucc, ttsc, иряв, 
   {{0x44261563,0x6f1d0380,0xd36f144f,0x2d9a00b4}},	//   _ibo_, utsc, _وهم_, _axpe_, 
   {{0x6f1d1564,0x6f0f1565,0x2c7501cc,0x6d450121}},	//   rtsc, rucc, _måde_, _prha, 
   {{0x26cc1566,0x2bc51567,0x6f1d1568,0x7c2601d6}},	//   _mido_, लेना, stsc, _bbkr, 
   {{0x91f200b0,0x20050028,0x6f1d0502,0x6d4500da}},	//   _आजुओ_, ėlis_, ptsc, _vrha, 
   {{0x201e0264,0x09bd09d8,0x44261569,0x26cc04b3}},	// [cd0] əti_, ्ख्य, _mbo_, _oido_, 
   {{0x6288156a,0x9967156b,0x160e156c,0x2ba7156d}},	//   nido, ктел, _सागर_, _कुणा, 
   {{0x60cd156e,0x7ac4156f,0x67291570,0x49a41571}},	//   _kiam, рсте, _spej, ајца, 
   {{0x2c750cac,0x24580187,0x9f520118,0x60cd1572}},	//   _både_, _témy_, _beyè_, _jiam, 
   {{0x60cd1573,0x26cc02fe,0xb8fa1574,0x160e00a2}},	//   _miam, _bido_, _डू_, _साखर_, 
   {{0x44261575,0x7c3d1576,0xa3e50a34,0x98b3091f}},	//   _abo_, _hasr, बुन_, ıdır_, 
   {{0x62880b85,0x6ed5072f,0x63ab1577,0x442601a3}},	//   dido, _यूसु, _sygn, _bbo_, 
   {{0x60cd1578,0x26cc03da,0x7c3d0065,0x44260026}},	//   _niam, _eido_, _jasr, _cbo_, 
   {{0x26cc1579,0x7c3d157a,0x42c9157b,0x5884082e}},	//   _fido_, _masr, нгин_, _тыра, 
   {{0x6288157c,0x78a2157d,0xe3b6157e,0x60cd00c2}},	//   gido, čove, ыбы_, _aiam, 
   {{0x78bb006d,0x60cd0118,0x44260226,0x64150038}},	//   _khuv, _biam, _fbo_, _مواط, 
   {{0x7c3d157f,0x60cd1580,0xdee61581,0x20560a10}},	//   _nasr, _ciam, ломи, утор, 
   {{0x60cd1582,0xb4c10e07,0x00000000,0x00000000}},	//   _diam, ूदी_, --, --, 
   {{0x62881408,0x443f1583,0x26cc0183,0x6283034c}},	//   cido, ldu_, _xido_, _umno, 
   {{0x443d1584,0x443f012d,0x60cd1585,0xff140086}},	//   _kaw_, odu_, _fiam, িবেশ_, 
   {{0x60cd1586,0x7c3d01be,0x645b1587,0x443d1588}},	//   _giam, _casr, njui, _jaw_, 
   {{0x4bd91589,0x3a2600cf,0x443d0156,0x3b0704a0}},	// [ce0] ться_, лмаг, _maw_, лето_, 
   {{0x443d00a7,0xfaaa009c,0x443f158a,0x2c7500fb}},	//   _law_, رهاي_, hdu_, _råde_, 
   {{0x09060fc8,0x9f52158b,0x26cc158c,0xe8ea0602}},	//   упен, _seyè_, _rido_, хмед_, 
   {{0x26cc158d,0x3860010d,0x443d00f8,0x78bb0c7c}},	//   _sido_, ðir_, _naw_, _chuv, 
   {{0x443f158e,0x26cc158f,0x9f520096,0x5fc700bc}},	//   ddu_, _pido_, _beyé_, रेपल, 
   {{0x0f370056,0x62880042,0x443f1590,0x7c241591}},	//   טרנט_, xido, edu_, lfir, 
   {{0x443d1592,0xaad8009a,0x00000000,0x00000000}},	//   _baw_, _भूतक, --, --, 
   {{0xdd0400e4,0x443d1593,0x7c241594,0x26cb0036}},	//   ūrėt, _caw_, nfir, _ècon_, 
   {{0x443d1595,0xb2741596,0xf7431597,0x26cc1598}},	//   _daw_, илиш, _лето, _tido_, 
   {{0x60cd1599,0x59b80c14,0x443f00f8,0x60dc0068}},	//   _siam, _अरार, adu_, írmo, 
   {{0x7c24159a,0x443f00a4,0x1da41011,0xa055004f}},	//   kfir, bdu_, _खुलत, авні, 
   {{0xf5370056,0x60cd0640,0x6288159b,0x443d159c}},	//   _תנאי_, _qiam, sido, _gaw_, 
   {{0x44240065,0x248600a3,0x7c3d159d,0x9f59021e}},	//   mfm_, _imom_, _rasr, masë_, 
   {{0x35a900a5,0x6440159e,0x6e3e159f,0x7c3d023e}},	//   _चुड़, ldmi, _capb, _sasr, 
   {{0x60cd006f,0x61fa15a0,0x7c2415a1,0x7c3d02b3}},	//   _tiam, matl, ffir, _pasr, 
   {{0x61fa15a2,0x443d006d,0xfe7701bb,0x644015a3}},	//   latl, _xaw_, түү_, ndmi, 
   {{0x3b5515a4,0x9990034c,0x50b80071,0x6e9500dd}},	// [cf0] шкар, _čaša_, _حدود_, _випу, 
   {{0x61fa15a5,0x443f15a6,0xda7815a7,0x78a90844}},	//   natl, zdu_, лях_, _skev, 
   {{0x394715a8,0x443f15a9,0x628f0107,0xa9350a10}},	//   íns_, ydu_, écoi, рееш, 
   {{0x2617148e,0x61fa15aa,0x443f00ad,0x19a800d3}},	//   _नाही_, hatl, xdu_, утуп_, 
   {{0xe73915ab,0x61fa09a3,0x443f15ac,0x07a5081b}},	//   тел_, katl, vdu_, јалн, 
   {{0xa50913f2,0x61fa00a3,0x443d00d1,0xe6450079}},	//   века_, jatl, _saw_, рекп, 
   {{0x443d15ad,0x61fa15ae,0x3e7400b0,0x442400ca}},	//   _paw_, datl, _jäta_, ffm_, 
   {{0x443f15af,0x64980a31,0x3e7415b0,0xc6060086}},	//   udu_, лтыр_, _mäta_, ল্লা_, 
   {{0xa3a805fd,0x443f15b1,0xfc3f06b6,0x645b15b2}},	//   _खुद_, rdu_, _maí_, rjui, 
   {{0xc6a715b3,0x644008f9,0x61fa15b4,0x161c07d5}},	//   _срби, admi, gatl, _नायर_, 
   {{0x443d15b5,0x6e3e0089,0x7c24003e,0xfba700aa}},	//   _taw_, _rapb, yfir, _कुसम, 
   {{0x443f007b,0x10a600a3,0x44f300b3,0xa0a615b6}},	//   qdu_, римн, mţ_, рамд, 
   {{0x61fa132c,0x3cdb00b0,0x6e3e15b7,0xa3c10110}},	//   batl, _खूबे_, _papb, ंधळ_, 
   {{0x200c0095,0x614515b8,0x673b018e,0x00000000}},	//   şdi_, _века, _msuj, --, 
   {{0x44f300d9,0x8d6315b9,0xa3dc15ba,0xb05b0080}},	//   nţ_, овре, तुक_, mmän, 
   {{0xb05b15bb,0x673b0a1a,0xebe60a10,0x2ba70790}},	//   lmän, _osuj, роап, _कुहा, 
   {{0x7c2415bc,0x6a8615bd,0xfc3f0165,0x638801dd}},	// [d00] rfir, алаа, _daí_, cīnī, 
   {{0xab2715be,0x7bdf01d8,0xb05b15bf,0x00000000}},	//   рофа_, acqu, nmän, --, 
   {{0xd00f15c0,0x19b900e4,0x7c2402b8,0x6d430604}},	//   _علی_, гуць_, pfir, _šnav, 
   {{0x8c4615c1,0xa01b0080,0x61fa15c2,0x07ba007a}},	//   _теме, tiöi, zatl, نهضة_, 
   {{0x61fa15c3,0x27e915c4,0xbb4300dd,0xeb9715c5}},	//   yatl, ñana_, _деяк, _вия_, 
   {{0x29130068,0xa01b00c8,0xbb4302a0,0x2486040b}},	//   buxa_, riöi, _ќерк, _smom_, 
   {{0xd49a0020,0x61fa15c6,0x442415c7,0x261715c8}},	//   кри_, vatl, tfm_, _नारी_, 
   {{0x61fa084c,0x186715c9,0x98a315ca,0x493b00df}},	//   watl, _каси_, _дисе, _בגלו, 
   {{0x61fa15cb,0xc178012d,0x3ced0b1d,0x644015cc}},	//   tatl, ybės_, ćevi_, rdmi, 
   {{0x09ca0086,0x672215cd,0xdd1c0032,0xa6ca15ce}},	//   _ল্যা, mtoj, _záťa, _شوال_, 
   {{0x61fa15cf,0xd25702f3,0x27200300,0x2c750219}},	//   ratl, рцы_, lòn_, _låda_, 
   {{0x6722012d,0x61fa15d0,0x44320023,0x23480535}},	//   otoj, satl, _úy_, _مستی_, 
   {{0x6722127c,0x61fa15d1,0x2cb215d2,0xc1a50259}},	//   ntoj, patl, dlyd_, _қышқ, 
   {{0xea0000f7,0x61fa065c,0xfc3f02aa,0x67220b58}},	//   _đến_, qatl, _saí_, itoj, 
   {{0xb2bb0056,0xbd6815d3,0xfc3f0126,0x672215d4}},	//   _שמור, арте_, _paí_, htoj, 
   {{0x2c75022b,0x672215d5,0xdb0f001d,0x5c7415d6}},	//   _båda_, ktoj, _azcá, олст, 
   {{0x3a7500cf,0x6722024a,0xa9e70038,0x9f59011c}},	// [d10] блар, jtoj, لثان, kasé_, 
   {{0x29130183,0x6d430613,0x19590cfe,0x3e7402ae}},	//   tuxa_, _šnau, лазы_, _täta_, 
   {{0x2ba7000d,0xdd9115d7,0x61f815d8,0x672215d9}},	//   _कुरा, _روح_, _mevl, etoj, 
   {{0x201915da,0x31570137,0x272006df,0x6722024a}},	//   ngsi_, ייבן_, fòn_, ftoj, 
   {{0xf74515db,0x272015dc,0x60d800b9,0x9f59023e}},	//   село, gòn_, _luvm, fasé_, 
   {{0x2ca9054f,0x78a20076,0xbb3a00c7,0x29130183}},	//   load_, čova, _געשי, puxa_, 
   {{0xfbdb0081,0x28f815dd,0x2b4b0532,0x195815de}},	//   _भलाम, _весь_, _hrcc_, _кары_, 
   {{0x29010053,0x4adb15df,0x6722006d,0xe78706ba}},	//   msha_, _बढाव, btoj, _кузо, 
   {{0x290115e0,0x61f815e1,0x9f59023e,0x4e1700bc}},	//   lsha_, _bevl, basé_, तलाई_, 
   {{0x38bc00eb,0xb5a715e2,0x6e350372,0x2901095a}},	//   ríre_, _крей, jezb, osha_, 
   {{0x61f815e3,0xa06a15e4,0xb05b15e5,0xc2c8007a}},	//   _devl, гана_, rmän, جبيل_, 
   {{0xf99200a7,0x290115e6,0xb05b15e7,0x00000000}},	//   לרי_, isha_, smän, --, 
   {{0x248d0bc3,0x764115e8,0x720500d4,0x889a035c}},	//   miem_, _kaly, _هوشم, רברי, 
   {{0x248d00e0,0x61f815e9,0xb05b00c8,0x27fd00f8}},	//   liem_, _gevl, lmäl, hawn_, 
   {{0x764115ea,0xfce615eb,0x7643016a,0x01c50033}},	//   _maly, собо, idny, _শ্রদ, 
   {{0x248d15ec,0x672200e4,0xb05b014e,0x6d4a0183}},	//   niem_, ytoj, nmäl, _áfam, 
   {{0xf1bf00bc,0x6e350097,0xd5b10023,0x2901011c}},	// [d20] řád_, bezb, _lý_, esha_, 
   {{0x6f0415ed,0xa9a60161,0x248d15ee,0x290115ef}},	//   _ivic, бизд, hiem_, fsha_, 
   {{0xfe370056,0x248d15f0,0xab2702f1,0xdca615f1}},	//   _פרטי_, kiem_, _қора_, _гани, 
   {{0x248d0bc3,0x91fc00e0,0x17fa00eb,0x6f0415f2}},	//   jiem_, nkār, اراة_, _kvic, 
   {{0x248d002a,0x764115f3,0x501b0a33,0x672202f3}},	//   diem_, _baly, רונו, utoj, 
   {{0x672215f4,0x1ae315f5,0xa3ab00aa,0xa3cb00aa}},	//   rtoj, _хорм, _गड़_, लधन_, 
   {{0x672206fa,0x764100e4,0x394a00b9,0x9f5915f6}},	//   stoj, _daly, _urbs_, rasé_, 
   {{0x248d15f7,0x7c3615f8,0x6722024a,0x6f0400ef}},	//   giem_, neyr, ptoj, _ovic, 
   {{0xa3a8010b,0x76410054,0x00000000,0x00000000}},	//   _खुश_, _faly, --, --, 
   {{0x764115f9,0x066500d4,0xda7b0070,0x7d15018e}},	//   _galy, _والپ, ָנטר, yuzs, 
   {{0xd0110629,0xa3a800bd,0x20190226,0x248d0243}},	//   ولد_, _खुर_, tgsi_, biem_, 
   {{0x248d15fa,0x764102a5,0x00000000,0x00000000}},	//   ciem_, _zaly, --, --, 
   {{0x61f815fb,0x5f9415fc,0x27e40054,0x3e970038}},	//   _tevl, зият, _mfmn_, مؤسس, 
   {{0x6f0402fe,0x64420358,0x539b00d1,0x92570176}},	//   _dvic, _haoi, _גידו, _гашт_, 
   {{0x90e615fd,0x7c36003e,0xb5fc008a,0x2ca915fe}},	//   _استن, feyr, _loġo, toad_, 
   {{0x81df0033,0xdd9403a1,0x764315ff,0x00000000}},	//   তরণ_, часы, zdny, --, 
   {{0x64421600,0x9b951601,0x5eb80086,0xd9f9018a}},	// [d30] _maoi, циац, _ইংরে, инац_, 
   {{0x7f4d1602,0x29011603,0x64420a75,0x248d1604}},	//   _iraq, tsha_, _laoi, ziem_, 
   {{0x6f04024a,0x20090065,0xb05b00c8,0xd9990038}},	//   _zvic, _kdai_, ymäl, جنات_, 
   {{0x6d40002a,0x76411605,0xdb0f1606,0x29011607}},	//   āmat, _saly, _lycé, rsha_, 
   {{0x3ced090b,0x248d1608,0xa3a80262,0x7641012d}},	//   ćevu_, viem_, _खुल_, _paly, 
   {{0xf1c80a09,0x9f59009e,0x248d0035,0x00000000}},	//   रधान, yasî_, wiem_, --, 
   {{0x248d002a,0x9f40008c,0x76411609,0x7643160a}},	//   tiem_, _leið_, _valy, rdny, 
   {{0x1309160b,0x644202d0,0x7b08008c,0x7643016a}},	//   аний_, _caoi, _ástæ, sdny, 
   {{0x6442003c,0x248d1608,0x7641160c,0x7aed160d}},	//   _daoi, riem_, _taly, npat, 
   {{0x248d002a,0x20090053,0x38bc0098,0x2f10003e}},	//   siem_, _adai_, míra_, _lögð_, 
   {{0x6442006e,0x6f04160e,0x7f4d160f,0x645d01c4}},	//   _faoi, _svic, _araq, ösis, 
   {{0x437511c3,0x64420a69,0x2bbe02e6,0x9fca02c4}},	//   _мулт, _gaoi, ्धमा, игна_, 
   {{0xe28e1610,0x9998034c,0x9f5b010c,0x7f4d1611}},	//   _жа_, _marš_, _heqê_, _craq, 
   {{0xacea02f1,0xa3e500c2,0x7aed058c,0x91fc0243}},	//   имга_, बुर_, dpat, skār, 
   {{0x7aed1612,0xa3c1047c,0x9f59009e,0x9d4303a1}},	//   epat, ंधक_, qasî_, мерд, 
   {{0x7f4d1613,0x1bea0176,0x6f040237,0x7ebb009e}},	//   _fraq, рдаи_, _tvic, rîpa, 
   {{0x7aed1614,0x7c36008c,0x68e90352,0x8eba00d9}},	// [d40] gpat, reyr, _čeda, _вынт_, 
   {{0xf22100a5,0x63b6004f,0x7c3601d5,0x6d5a0080}},	//   _माफ़_, _øyne, seyr, ätas, 
   {{0x649700e0,0x05a91615,0x6ee5015f,0x7c2a1616}},	//   rģij, _चुलब, _وسیل, _конг_, 
   {{0xd7ef0038,0x78a20098,0xcfad0033,0x6286039f}},	//   نكم_, čovo, _গণতন, ékoz, 
   {{0xa6ca1617,0xa01b1618,0x64420465,0x8af00248}},	//   алда_, shög, _raoi, yyəy, 
   {{0x6442009f,0x00000000,0x00000000,0x00000000}},	//   _saoi, --, --, --, 
   {{0x692309f9,0x385a1619,0xd8390118,0x00000000}},	//   _омра, _краю_, _djōb_, --, 
   {{0xe8140cd6,0xa3e51126,0x00000000,0x00000000}},	//   _डाटा_, बुल_, --, --, 
   {{0x53340a65,0x00000000,0x00000000,0x00000000}},	//   чепт, --, --, --, 
   {{0x026a00dd,0x3f82161a,0xa50a161b,0x00000000}},	//   рший_, dzku_, _вежа_, --, 
   {{0x3a3703e1,0x6442161c,0x8cd6048e,0x7aed0083}},	//   חרים_, _taoi, _मंगो, zpat, 
   {{0xb05b0080,0x00000000,0x00000000,0x00000000}},	//   mmäk, --, --, --, 
   {{0xe29a0886,0xb05b0080,0x00000000,0x00000000}},	//   _кад_, lmäk, --, --, 
   {{0x29070019,0x63a200b4,0x9f5b021e,0xa01b161d}},	//   ának_, _ixon, _heqë_, tiös, 
   {{0xb05b0080,0xafdb0664,0x00000000,0x00000000}},	//   nmäk, ldøm, --, --, 
   {{0xa01b161e,0xe57100c7,0x2b49035f,0x9b890038}},	//   riös, ײַל_, tvac_, منزل_, 
   {{0x6d5a161f,0x3a7502f1,0x6d4802ae,0x9f5b0034}},	// [d50] ätar, плар, ådar, _meqë_, 
   {{0x68e303da,0x00000000,0x00000000,0x00000000}},	//   índo, --, --, --, 
   {{0x05a9047c,0x629a00c8,0xa3ca009a,0x09070d3b}},	//   _चुंब, into, ळेत_, ючам, 
   {{0x7aed1620,0x63a2016a,0x7c590038,0x6d5800da}},	//   ppat, _oxon, _الحر_, _švag, 
   {{0x78ab1621,0xfc5a00df,0x8cba0083,0x00000000}},	//   rogv, _הכרמ, ्षरो, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2d830035,0x00000000,0x00000000,0x00000000}},	//   nzje_, --, --, --, 
   {{0x629a1622,0x00000000,0x00000000,0x00000000}},	//   ento, --, --, --, 
   {{0x38341623,0x00000000,0x00000000,0x00000000}},	//   _інфр, --, --, --, 
   {{0x629a1341,0xb05b1624,0xaabd0e0d,0x00000000}},	//   gnto, lmäh, ्गिक, --, 
   {{0x27e00412,0x850500d6,0x91fc00e0,0xe45f00c2}},	//   žine_, _روشن, rkāp, öös_, 
   {{0x8fa61625,0x55ba00d1,0x61ee00ad,0x44290210}},	//   заме, _המעו, ıbla, _ùa_, 
   {{0xc31900cc,0x7fd5004e,0xe80c009a,0x442f1626}},	//   _তৈরি_, дірі, हणता_, _ibg_, 
   {{0x68e91627,0x00000000,0x00000000,0x00000000}},	//   _čedn, --, --, --, 
   {{0xbea31628,0xdd921629,0xa01b02ae,0x3f82162a}},	//   харк, رور_, riör, szku_, 
   {{0x442f0d26,0xaf060e1b,0xda1e009a,0x00000000}},	//   _jbg_, _епил, _पाहत_, --, 
   {{0x2002162b,0x3aeb0019,0x60c4162c,0x207b0070}},	// [d60] maki_, مبلی_, _ihim, _לאקא, 
   {{0x2002162d,0xdb060035,0xa6e90023,0x00000000}},	//   laki_, _szkó, _khươ, --, 
   {{0xceb3162e,0x4ddb00d1,0xe853009c,0x442f019c}},	//   _איז_, _לחיו, کنند, _obg_, 
   {{0x38cb0399,0xc604047c,0xdca603dc,0xda1e00b0}},	//   مانی_, रण्य_, _хами, _पावत_, 
   {{0x629a0090,0x60c4162f,0x00000000,0x00000000}},	//   ynto, _mhim, --, --, 
   {{0x442f1630,0xd6d900dd,0x20021631,0x00000000}},	//   _abg_, іті_, haki_, --, 
   {{0x20020e32,0xe9a31632,0x442f1633,0x00000000}},	//   kaki_, _зарп, _bbg_, --, 
   {{0x20021634,0x399b00a7,0x2bc300c9,0x2a6a008a}},	//   jaki_, _הילד, _शरमा, _hobb_, 
   {{0x20020c05,0x6b841635,0x98a300d9,0x2fc002a5}},	//   daki_, nzig, _чите, _nzig_, 
   {{0x2a6a1636,0xb05b030f,0x27e61637,0x60c41638}},	//   _jobb_, mmäi, lcon_, _ahim, 
   {{0x2bb906ea,0xa6e90029,0x249700c5,0xbbb91516}},	//   _आर्थ, _chươ, _کنند_, _आर्क, 
   {{0x442f02ae,0x20021639,0x60c4163a,0x63a201cf}},	//   _gbg_, gaki_, _chim, _txon, 
   {{0x6b840b32,0x60c400e5,0x291a163b,0x60d6163c}},	//   jzig, _dhim, hupa_, _diym, 
   {{0x291a163d,0x6b84163e,0xd35700d1,0xf8dc0299}},	//   kupa_, dzig, _מידי_, यदाय, 
   {{0x2002163f,0x68e90097,0x3a3a1640,0x60c400c3}},	//   baki_, _čedo, depp_, _fhim, 
   {{0x30a400e4,0x60c400b3,0x60d60241,0x20020083}},	//   _прыв, _ghim, _giym, caki_, 
   {{0x3f9e01f0,0xcb3400fd,0x7c2f1641,0x27e60664}},	// [d70] ştur_, нетъ, _vbcr, dcon_, 
   {{0x291a1642,0x6d41003e,0x1ab40a10,0x321e0210}},	//   fupa_, ælas, ебуя, ngty_, 
   {{0x29071643,0x291a1644,0xf8b11372,0x6b84052b}},	//   éna_, gupa_, نکر_, azig, 
   {{0x386906b6,0x6a730384,0x9f0400d7,0x00000000}},	//   ðar_, _sıfı, _تویو, --, 
   {{0x7c2d1645,0x649700b3,0x36691646,0x00000000}},	//   mfar, nţie, жало_, --, 
   {{0x55c3005e,0x442f1647,0x20021648,0x7c2d1649}},	//   налғ, _sbg_, zaki_, lfar, 
   {{0xa934164a,0x200200d7,0x291a164b,0xa3ca009a}},	//   _перш, yaki_, cupa_, ळेस_, 
   {{0x7c2d164c,0x2002019c,0x00000000,0x00000000}},	//   nfar, xaki_, --, --, 
   {{0x2002164d,0x27ff0175,0x72c50176,0x7c2d0c20}},	//   vaki_, _ieun_, мбиз, ifar, 
   {{0x60c4164e,0xa6e90029,0x2002164f,0x27ff0175}},	//   _shim, _phươ, waki_, _heun_, 
   {{0x20021650,0xa0a61651,0x27ff005f,0x26c50026}},	//   taki_, данд, _keun_, _ihlo_, 
   {{0x66031652,0x60d61653,0x39430126,0x205601a2}},	//   lank, _qiym, _msjs_, фтор, 
   {{0x20020121,0x644902bf,0x7c2d1654,0x64591655}},	//   raki_, mdei, dfar, _inwi, 
   {{0x442d02ec,0xa6e900f7,0x66031656,0x20021657}},	//   lfe_, _thươ, nank, saki_, 
   {{0x20021658,0x6d58015e,0x60c41659,0x2a6a165a}},	//   paki_, _švab, _thim, _robb_, 
   {{0x6449165b,0x6b84165c,0x442d165d,0x7c2d165e}},	//   ndei, tzig, nfe_, gfar, 
   {{0x649700d9,0x3e7400b0,0x06e30033,0x442d165f}},	// [d80] cţie, _läti_, নীতি, ife_, 
   {{0xfbc302c0,0x291a1660,0x3a23019b,0x62810023}},	//   тбуо, tupa_, _ccjp_, nhlo, 
   {{0x66031661,0x22470300,0x3a3a0d6b,0x6e3c01d2}},	//   dank, _mank_, repp_, merb, 
   {{0x291a1662,0x7d1c1663,0x22471664,0x7c2d1665}},	//   rupa_, murs, _lank_, cfar, 
   {{0x073a1666,0xc6f70769,0x660300a9,0x44e30126}},	//   تساب_, дніх_, fank, _añ_, 
   {{0x26c50b1a,0x66031667,0x44fa0b03,0xea000023}},	//   _chlo_, gank, tū_, _đặn_, 
   {{0x442d1668,0x69dc0c7c,0x644901d5,0x7d1c1669}},	//   ffe_, _igre, fdei, nurs, 
   {{0x3ae4022b,0x6e3c166a,0x27ff166b,0x4422039f}},	//   _köp_, herb, _geun_, ük_, 
   {{0x2247166c,0x7ae2007a,0xb5fc00a4,0x2b40011c}},	//   _bank_, íoth, _loġi, nwic_, 
   {{0x66030372,0x64491086,0x22470027,0x386602ae}},	//   cank, adei, _cank_, ljor_, 
   {{0x2247166d,0x765a166e,0x7c2d0156,0x7f440369}},	//   _dank_, _inty, yfar, _asiq, 
   {{0x7d1c166f,0x1c1d0527,0x386612e6,0x62811670}},	//   durs, _फाइल_, njor_, ahlo, 
   {{0x69dc1671,0x6e3c1672,0x22470082,0x76481673}},	//   _ogre, ferb, _fank_, _kady, 
   {{0x62811674,0x69dc1675,0x7e7e0118,0x2ee00d62}},	//   chlo, _ngre, _clpp, _duif_, 
   {{0x76481676,0xf1aa00d4,0x7d1c1677,0xc34800e7}},	//   _mady, _باشه_, gurs, _hổ_, 
   {{0x66031678,0x69dc1679,0x6e3c02a3,0x2247167a}},	//   zank, _agre, aerb, _zank_, 
   {{0x3ec7167b,0x66030727,0x386612be,0x7c2d1649}},	// [d90] _особ, yank, djor_, rfar, 
   {{0x27ff018c,0x7648167c,0x68fc0156,0x7a38167d}},	//   _seun_, _nady, _bwrd, мпур_, 
   {{0x6f1d0068,0x4815167e,0x644900f8,0x3e660054}},	//   lusc, емес, ydei, _nôty_, 
   {{0x6d45167f,0x66031680,0x765a1681,0x38660034}},	//   _isha, wank, _anty, gjor_, 
   {{0x764813cd,0xc34800e7,0x7bdd02dc,0x785e00b3}},	//   _bady, _nổ_, _igsu, _săvâ, 
   {{0x68fc00f8,0x645900a1,0x00000000,0x00000000}},	//   _fwrd, _snwi, --, --, 
   {{0x27ff1682,0xf09f0379,0x224700d1,0x64490a1d}},	//   _teun_, knà_, _rank_, tdei, 
   {{0x93451683,0x6603030b,0xc348001b,0x61ea1684}},	//   ение, sank, _bổ_, _affl, 
   {{0xc3480029,0x442d1685,0xa3ca00a2,0x7d1c1686}},	//   _cổ_, rfe_, ळेल_, zurs, 
   {{0x27291056,0x660309c7,0x76480300,0xda0f1687}},	//   mún_, qank, _gady, ाणित_, 
   {{0x6d451688,0x27290038,0x386d00b0,0x442d1689}},	//   _nsha, lún_, _koer_, pfe_, 
   {{0x386d0369,0x6e3c168a,0x628100cf,0x6601168b}},	//   _joer_, werb, shlo, _helk, 
   {{0x6601168c,0x6d45168d,0xda0f00a2,0xada302f1}},	//   _kelk, _asha, ाणात_, ҳарл, 
   {{0x7d1c0a6d,0x386d0876,0x249f003e,0x6e3c168e}},	//   turs, _loer_, lnum_, uerb, 
   {{0x387f0749,0x6da3168f,0x66011690,0x7afd1691}},	//   _olur_, гира, _melk, _awst, 
   {{0x249f010d,0x6e3c1692,0x7f4402cd,0x66010019}},	//   nnum_, serb, _tsiq, _lelk, 
   {{0x6d451693,0xc34800e7,0x249f003e,0xb09b07e4}},	// [da0] _esha, _xổ_, inum_, _מיקר, 
   {{0x6d4500e5,0x387f1694,0x32051695,0x2d8c0126}},	//   _fsha, _alur_, naly_, údes_, 
   {{0x76481696,0x387f1697,0x386d1698,0x249f008c}},	//   _rady, _blur_, _boer_, knum_, 
   {{0xd706065b,0x76480c36,0x3ae40679,0xa2c10299}},	//   езди, _sady, _töp_, _रीस्, 
   {{0x2729128a,0x6136006b,0x66011699,0x3205169a}},	//   gún_, _külö, _belk, kaly_, 
   {{0x660108d7,0x32050180,0xc3480023,0x387f169b}},	//   _celk, jaly_, _rổ_, _elur_, 
   {{0xc348001b,0x2ca0169c,0xfaa3104e,0x249f008c}},	//   _sổ_, onid_, _саро, fnum_, 
   {{0x249f008c,0x5454169d,0x660100b0,0x95530fce}},	//   gnum_, твит, _eelk, اخوا, 
   {{0xb05b014e,0xc7a3169e,0x6601169f,0x764807fc}},	//   lläg, _битк, _felk, _tady, 
   {{0x2c7c0634,0x32050379,0x2ca0007a,0x717816a0}},	//   _oído_, galy_, hnid_, дбор_, 
   {{0xb05b022b,0x2b910228,0xbbbe0f7a,0x5a170070}},	//   nläg, môcť_, ्धुक, עקטן_, 
   {{0xc3480029,0xbebb024a,0x6f1d16a1,0x69c30035}},	//   _tổ_, ntëv, tusc, żneg, 
   {{0x442616a2,0xb05b01c4,0xfebb0038,0x660116a3}},	//   _ico_, hläg, كاست_, _yelk, 
   {{0x6f1d16a4,0xa01b0380,0xb05b02ae,0x7c2616a5}},	//   rusc, chön, kläg, _ackr, 
   {{0xac950cb4,0x8d7716a6,0x4c95017b,0x00000000}},	//   вавш, راسا, вивс, --, 
   {{0xdcb8048a,0x6f1d1217,0xb05b02ae,0x6d45039b}},	//   ещу_, pusc, dläg, _vsha, 
   {{0x649700d9,0x386d000b,0x38730cdf,0xfaf016a7}},	// [db0] nţia, _roer_, ққат, مثل_, 
   {{0x6d450e0c,0x6f0d16a8,0x3b0916a9,0xdb26009c}},	//   _tsha, _ivac, rsaq_, ئولی, 
   {{0x3b0900a4,0x6d4516aa,0x44260042,0x98b30352}},	//   ssaq_, _usha, _oco_, žeča_, 
   {{0x442601c1,0x6f0d015e,0x66010088,0x487808af}},	//   _nco_, _kvac, _selk, нсія_, 
   {{0xf745095b,0x386d0318,0x66010088,0xb05b16ab}},	//   тело, _voer_, _pelk, lmäs, 
   {{0x272916ac,0x693506d4,0xe9d30444,0x386d040b}},	//   rún_, _ингу, _مغز_, _woer_, 
   {{0x660116ad,0x320516ae,0x386d0876,0x44260226}},	//   _velk, valy_, _toer_, _bco_, 
   {{0x660116af,0x6f0d044e,0x3e740502,0x58d416b0}},	//   _welk, _ovac, _hätt_, _бост, 
   {{0x249f008c,0x320516b1,0xd84202d9,0x69c80098}},	//   rnum_, taly_, áčů_, _úder, 
   {{0xb05b02ae,0x249f16b2,0x442616b3,0x00000000}},	//   kmäs, snum_, _eco_, --, 
   {{0x320516b4,0xb05b16b5,0x6f0d16b6,0x3e740219}},	//   raly_, kläd, _avac, _mätt_, 
   {{0x3e74022b,0xdee616b7,0x320516b8,0x64970243}},	//   _lätt_, коми, saly_, rģis, 
   {{0x443f16b9,0xab5b010e,0x320516ba,0xcdc50259}},	//   meu_, _szün, paly_, ғатқ, 
   {{0x6da616bb,0x443f16bc,0x644b16bd,0x63a40009}},	//   вига, leu_, _hagi, _žing, 
   {{0x644b16be,0x6f0d16bf,0x27ed0502,0x2907020f}},	//   _kagi, _evac, _ofen_, ânal_, 
   {{0x443f16c0,0x7f8600eb,0x7cdc00a1,0x6f960038}},	//   neu_, _للبن, _cōra, _للعض, 
   {{0x644b16c1,0x443f16c2,0x7c2b0014,0xeb9716c3}},	// [dc0] _magi, ieu_, ògra, вит_, 
   {{0x644b16c4,0x443f16c5,0xaa7b003e,0x4ce600a3}},	//   _lagi, heu_, _stýr, _ижоб, 
   {{0x443f0096,0x6f0d16c6,0xb05b1279,0x00000000}},	//   keu_, _zvac, mmär, --, 
   {{0x644b16c7,0x63a4008c,0xb05b16c8,0x7f56024a}},	//   _nagi, _þing, rläg, _kryq, 
   {{0x443f16c9,0x27e016ca,0xb05b0219,0xbebb0034}},	//   deu_, žino_, släg, rtëv, 
   {{0x7bc611c8,0x7c2416cb,0xca761249,0xbebb024a}},	//   _izku, lgir, _румы, stëv, 
   {{0x644b16cc,0x92de00cc,0xc5d500cc,0x443f16cd}},	//   _bagi, _তবে_, _স্বপ, feu_, 
   {{0x7c2416ce,0x38c8040f,0x443f00d3,0x00000000}},	//   ngir, _سازی_, geu_, --, 
   {{0xb05b16cf,0x938a16d0,0x66e616d1,0x82d816d2}},	//   kmär, ьска_, _роза, ндис_, 
   {{0x78a216d3,0x6f0d035f,0x7c2416d4,0x649700b3}},	//   lnov, _rvac, hgir, rţia, 
   {{0x443f16d5,0x7c24009e,0x644b16d6,0x442603c5}},	//   beu_, kgir, _fagi, _tco_, 
   {{0x443f16d7,0x78a216d8,0x044616d9,0xa19301fc}},	//   ceu_, nnov, _једн, раюч, 
   {{0x6440027e,0x9f5902ae,0x82a600d3,0x78a200de}},	//   memi, kaså_, _ишке, inov, 
   {{0x644016da,0x644b16db,0x6497002e,0x4ea416dc}},	//   lemi, _zagi, nţin, арса, 
   {{0x3e740750,0xdd94022c,0x644b0b31,0x7bc601ca}},	//   _rätt_, аары, _yagi, _azku, 
   {{0x644016dd,0x3e740750,0x7c2416de,0x6abd16df}},	//   nemi, _sätt_, ggir, ्ग्र, 
   {{0x4ea716e0,0x5a3516e1,0xb05b16e2,0xbebb024a}},	// [dd0] _арна, лнат, smäs, ftët, 
   {{0x443f16e3,0x644016e4,0xdce70035,0x9b440019}},	//   zeu_, hemi, zyję, ؤنلو, 
   {{0x391516e5,0x7bc601f1,0x291e0219,0x83fd010e}},	//   умер, _ezku, _åtal_, rkőz, 
   {{0x2bae0fec,0x443f022c,0x28f80a10,0x78a216e6}},	//   _झुका, xeu_, тець_, gnov, 
   {{0x644b16e7,0x443f16e8,0x3e740219,0x291a02a3}},	//   _ragi, veu_, _tätt_, arpa_, 
   {{0x644b16e9,0xe5a516ea,0x00000000,0x00000000}},	//   _sagi, лили, --, --, 
   {{0x644b16eb,0x443f16ec,0x78a216ed,0x27ee02d9}},	//   _pagi, teu_, bnov, émní_, 
   {{0x644016ee,0x69c716ef,0x332d0405,0xddde03a0}},	//   gemi, _izje, ttex_, _enpň, 
   {{0x443f16f0,0x2cb9016a,0x67d40a10,0xbebb024a}},	//   reu_, _mksd_, _воту, ntës, 
   {{0x443f16f1,0x7c2416f2,0x644b16f3,0x36d516f4}},	//   seu_, zgir, _wagi, _созр, 
   {{0x644b16f5,0xab5b006b,0xe4e702fb,0x443f16f6}},	//   _tagi, _szül, _різн, peu_, 
   {{0xa3550fdc,0xc87900b3,0xbebb0034,0xa3ea0299}},	//   _مختص, _fişe_, ktës, _मलय_, 
   {{0xbebb00e5,0xed5703dc,0x6d570095,0x7c24010c}},	//   jtës, қот_, _arxa, vgir, 
   {{0xdee316f7,0x78a2133e,0x539a035c,0x10a3004e}},	//   сори, znov, _אינו, _қиын, 
   {{0x78a216f8,0x649700d9,0x7c2416f9,0x25eb00b0}},	//   ynov, nţio, tgir, _चलनी_, 
   {{0xb05b007e,0xdd8f0038,0x78a216fa,0xbebb0034}},	//   smär, سوق_, xnov, ftës, 
   {{0x7c240218,0xb05b014e,0x78a216fb,0x5aca16fc}},	// [de0] rgir, pmär, vnov, елам_, 
   {{0x7c2416fd,0xddb60195,0x644016fe,0x66e60283}},	//   sgir, _محجب, zemi, ҳода, 
   {{0x644016ff,0x7c2403dd,0xdce801dd,0x78a21700}},	//   yemi, pgir, ēlēt, tnov, 
   {{0xe3a700c5,0xd70a0f6b,0x6440009e,0x66e61701}},	//   _هر_, енде_, xemi, года, 
   {{0xb8eb04b7,0x78a211bc,0x2bba00eb,0x7bc61702}},	//   _री_, rnov, _ساحة_, _uzku, 
   {{0x09e313cc,0xbebb021e,0xc7a3121f,0x00000000}},	//   _горн, ltër, щичк, --, 
   {{0x64400c05,0xafdb03a9,0x3a2a02fe,0x649700b3}},	//   temi, ndør, _icbp_, rţin, 
   {{0x649700d9,0x78a2014b,0xe3140165,0x00000000}},	//   sţin, čovs, амињ, --, 
   {{0x6d580b91,0xb5fc008a,0xf2061703,0x88b300d7}},	//   _šval, _anġe, ляно, _اینچ, 
   {{0x7ae61704,0x86c60038,0x67220009,0x6440107d}},	//   _mukt, _صيان, muoj, semi, 
   {{0x27e902ee,0x64401705,0x3cf80228,0x649700d9}},	//   žane_, pemi, jprv_, cţio, 
   {{0xf993042c,0x649700d9,0x1fdf02e6,0x44ea01f5}},	//   מרת_, nţil, नखेड, _iù_, 
   {{0x6722012d,0x44ea1706,0xf487006b,0x26de1707}},	//   nuoj, _hù_, _حالی, _kito_, 
   {{0x81d41708,0xc7b302a1,0x660a0ab1,0xb05b1709}},	//   _колх, מבר_, nafk, fläc, 
   {{0x629a170a,0x7ae6170b,0x6ca7170c,0xc27b0070}},	//   mito, _aukt, граж, _ארגי, 
   {{0x7ae6170d,0x26de170e,0x1f75170f,0x44ea00e7}},	//   _bukt, _lito_, _влия, _mù_, 
   {{0x4bc5022c,0x3a381027,0x26de0c7c,0x3a2a0097}},	// [df0] рөнг, _bbrp_, _oito_, _bcbp_, 
   {{0x44ea0518,0x195911c5,0x26de148f,0x7ae61710}},	//   _où_, казы_, _nito_, _dukt, 
   {{0x60cd1711,0x81b60086,0xbebb0034,0x2aa81712}},	//   _kham, চের_, stës, утто_, 
   {{0x89340084,0xa56500d4,0x629a1713,0x200b1714}},	//   إعلا, یگان, hito, naci_, 
   {{0x629a1715,0xe758004f,0x66051716,0xd6291717}},	//   kito, лиці_, апла, воле_, 
   {{0x629a1718,0x87040088,0x6b8d00ef,0x44ea00e7}},	//   jito, сяце, mzag, _bù_, 
   {{0x26de0268,0x44ea1719,0x6f1d01c4,0x200b00bc}},	//   _dito_, _cù_, hrsc, kaci_, 
   {{0x44ea0029,0x200b171a,0x7ae6011c,0x26de0183}},	//   _dù_, jaci_, _yukt, _eito_, 
   {{0x200b00f1,0x6b8d171b,0x26de0180,0x6283026e}},	//   daci_, nzag, _fito_, _plno, 
   {{0x6595171c,0x68e700e5,0x26de0490,0x60cd09a7}},	//   _казу, _kujd, _gito_, _aham, 
   {{0x7643171d,0x60cd00a1,0x4254012d,0x6f1d171e}},	//   meny, _bham, стыт, ersc, 
   {{0x7643171f,0x60cd1720,0x236002fe,0x200b1721}},	//   leny, _cham, _šije_, gaci_, 
   {{0x60cd1722,0x6b8d015e,0xdee61723,0x224900b3}},	//   _dham, jzag, роги, _апли_, 
   {{0x78a904ab,0x76430547,0x62881724,0x6b8d044d}},	//   _ljev, neny, chdo, dzag, 
   {{0x200b04d1,0x75231725,0x78bb0a8b,0x6722012d}},	//   baci_, nunz, _okuv, zuoj, 
   {{0x76431726,0x200b1727,0x60cd1728,0x3207023a}},	//   heny, caci_, _gham, _heny_, 
   {{0x76431729,0x4e1a0088,0x60d7035c,0x7523172a}},	// [e00] keny, _июня_, _דוקא_, hunz, 
   {{0x75230199,0x61e300e2,0xef1f010e,0xda79004f}},	//   kunz, _jgnl, zzük_, ляє_, 
   {{0x2bb80262,0x26de0c3d,0x7643172b,0xfe3700c7}},	//   _आडवा, _rito_, deny, _דריי_, 
   {{0x26de048a,0x628801ee,0x629a172c,0x60cd172d}},	//   _sito_, zhdo, zito, _xham, 
   {{0x78a902a8,0x26de172e,0x629a172f,0x87031730}},	//   _djev, _pito_, yito, ояще, 
   {{0x75231731,0x629a1732,0x76431733,0x6722012d}},	//   funz, xito, geny, ruoj, 
   {{0x6d581734,0x629a1735,0x321800ab,0x6722134f}},	//   _švaj, vito, órym_, suoj, 
   {{0x7c360679,0x26de0053,0x629a1736,0x6b9b0f23}},	//   nfyr, _wito_, wito, _žugi, 
   {{0x629a1737,0x26de1738,0x76431739,0x3207173a}},	//   tito, _tito_, beny, _beny_, 
   {{0x3207173b,0xab5b006b,0x200b00f4,0x7643016a}},	//   _ceny_, _szük, waci_, ceny, 
   {{0x60cd173c,0x68e012fb,0x200b173d,0x6b8d173e}},	//   _pham, _kimd, taci_, zzag, 
   {{0x629a173f,0x859b00d1,0x6f0402b8,0x6d410241}},	//   sito, _בשבו, _bwic, çlam, 
   {{0x4fc70afc,0x32071740,0x3eb81741,0x2d9e1742}},	//   рсна, _feny_, fort_, úten_, 
   {{0x200b0ab4,0x6f1d1743,0x68e000a3,0x61e302a5}},	//   saci_, rrsc, _limd, _ggnl, 
   {{0xa3ea047b,0x7059040c,0x60cd1744,0xbc071745}},	//   _मला_, _байр_, _tham, ичай, 
   {{0x320c0dd2,0x60cd0bab,0x3d180d4f,0x6b8d01f1}},	//   lady_, _uham, _फिरे_, tzag, 
   {{0x2486023b,0xa3ca00a2,0xdb5400f0,0x76431746}},	// [e10] _mlom_, ळेच_, овты, yeny, 
   {{0x78a90f30,0x78bb13b0,0x6286024a,0xdb260116}},	//   _sjev, _skuv, ëkoh, صومی, 
   {{0x78a903e5,0xbebb00e5,0x99671747,0x27e402a2}},	//   _pjev, rrëd, штал, _bgmn_, 
   {{0x320c05f0,0x76431748,0x660800b4,0x2547039f}},	//   hady_, weny, _aedk, _ről_, 
   {{0x320c1749,0x78a902c7,0x629810de,0xa01b0380}},	//   kady_, _vjev, _omvo, rhöh, 
   {{0x7523174a,0x7bda00a7,0x320c174b,0x2486174c}},	//   tunz, _תקשו, jady_, _alom_, 
   {{0x7643174d,0x2486174e,0x320700a9,0x6608174f}},	//   reny, _blom_, _reny_, _dedk, 
   {{0x76431750,0x68e0012d,0x78bb0199,0x752308dc}},	//   seny, _gimd, _ukuv, runz, 
   {{0x75231751,0x320c0180,0x76431752,0xb3d200c9}},	//   sunz, fady_, peny, देलख, 
   {{0xf67400eb,0x75230199,0x2547010e,0x53a51753}},	//   _والخ, punz, _től_, _қалб, 
   {{0xd00a1754,0x3eb81755,0xb80b00b0,0x555500d7}},	//   лене_, vort_, _हजाम_, _دپار, 
   {{0x3eb802f2,0xb7bd002e,0x200900b3,0x42c800d3}},	//   wort_, _acţi, _ceai_, лгөн_, 
   {{0xd12e040f,0x32070489,0x42d500dd,0x320c0379}},	//   ومی_, _teny_, _ліку, bady_, 
   {{0x201e1756,0x200900a1,0x24861757,0x00000000}},	//   şti_, _eeai_, _zlom_, --, 
   {{0x22451758,0x2d7e0397,0xb05b0844,0x3eb81759}},	//   melk_, _oćeš_, mlän, rort_, 
   {{0x27e00688,0xb05b175a,0x6e3b0082,0x3eb8175b}},	//   žini_, llän, đuba, sort_, 
   {{0x3eb8175c,0x7c36175d,0xcb67175e,0x6f04007c}},	// [e20] port_, rfyr, бате_, _uwic, 
   {{0x34d300ab,0xb05b00a8,0xa96a175f,0x68e01760}},	//   दगुद, nlän, лиза_, _simd, 
   {{0x6608008b,0xb05b128d,0x7aed040c,0x6281040b}},	//   _redk, ilän, aqat, iklo, 
   {{0x0aea0038,0x00000000,0x00000000,0x00000000}},	//   _مرسي_, --, --, --, 
   {{0x68fb0abd,0xb05b02ae,0x628100fc,0x00000000}},	//   _čude, klän, kklo, --, 
   {{0xfd650029,0x2486090e,0x62810082,0x00000000}},	//   _nguồ, _slom_, jklo, --, 
   {{0x9986057f,0x27e902f5,0xb05b014e,0x320c00a9}},	//   _الأو, žana_, dlän, vady_, 
   {{0xa2f41761,0x00000000,0x00000000,0x00000000}},	//   опич, --, --, --, 
   {{0x320c05f0,0xc44500d4,0xd20a011f,0xf3ef0038}},	//   tady_, زیون_, лэнд_, رأي_, 
   {{0x273200d9,0x9f520369,0xbae50033,0xe5a61762}},	//   mân_, _leyó_, _পৌঁছ, _лизи, 
   {{0x273200f3,0x320c1763,0x3abb035c,0xd257012d}},	//   lân_, rady_, רמינ, сцы_, 
   {{0x320c1764,0x629d0107,0x628108a3,0x00000000}},	//   sady_, ésor, aklo, --, 
   {{0x320c1765,0x937a1766,0xdb0f019c,0x27320216}},	//   pady_, _حصار_, _excê, nân_, 
   {{0x62811767,0xacf91768,0xddde0237,0xfe7901a2}},	//   cklo, ингу_, _enpō, рӯи_, 
   {{0x40351769,0x273200f8,0x00000000,0x00000000}},	//   _дейс, hân_, --, --, 
   {{0xce3300c5,0xa0a400ce,0x7f4d02cd,0xd011006b}},	//   _کودک, _најд, _tsaq, _کلک_, 
   {{0x3a75176a,0xf09f022c,0x00000000,0x00000000}},	// [e30] олар, mià_, --, --, 
   {{0x9e07176b,0x2eb4007e,0xf09f03a1,0x7aed02f1}},	//   _учил, ंकृत, lià_, rqat, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x50c9176c,0xed8800d3,0xb0c9176d,0x17fb0038}},	//   रतिष, _ысык_, रतिग, ارضة_, 
   {{0x2ca9176e,0x7aed00a3,0x6281176f,0x6a7b0216}},	//   mnad_, qqat, yklo, _bîft, 
   {{0x45191770,0xf09f0036,0x2ca9076d,0x00000000}},	//   ация_, hià_, lnad_, --, 
   {{0x20c900a2,0x22450243,0x00000000,0x00000000}},	//   रताध, velk_, --, --, 
   {{0x2ca9007e,0x236002fe,0x833902a0,0xf1c302d9}},	//   nnad_, _šija_, ачот_, _liší_, 
   {{0x2d8c1771,0xb05b0c98,0xf09f022c,0x649700b3}},	//   údez_, tlän, dià_, nţii, 
   {{0x2ca90156,0xe29902a6,0x00000000,0x00000000}},	//   hnad_, рао_, --, --, 
   {{0xe046080b,0xb05b1772,0x62811773,0xc66800ce}},	//   онни, rlän, rklo, _уште_, 
   {{0x61fc07fa,0xb05b1774,0x00000000,0x00000000}},	//   ırla, slän, --, --, 
   {{0x62811775,0xb05b1562,0x443d02a5,0x3f841776}},	//   pklo, plän, _ibw_, ámu_, 
   {{0x7c2f1777,0x3f8c0035,0x248d1778,0x2eb41779}},	//   _accr, ądu_, lhem_, ंकेत, 
   {{0xe7fc031e,0x1d0a177a,0x3f840032,0xf09f00b9}},	//   उँमा_, реби_, šmu_, bià_, 
   {{0x90c3177b,0x248d177c,0x9f5206df,0xf09f022c}},	//   _обще, nhem_, _deyò_, cià_, 
   {{0xab2a177d,0xdca300cf,0x8af70095,0x2d910036}},	// [e40] роза_, фати, _şəra, azze_, 
   {{0xa01b177e,0x443d177f,0x4a430165,0x00000000}},	//   nkön, _lbw_, мнув, --, 
   {{0xdb060219,0x249f1780,0x57ea1781,0x443d0298}},	//   _nykö, kium_, адем_, _obw_, 
   {{0x442f0042,0xab2a1782,0xd7f0007a,0xa01b1279}},	//   _ncg_, _кома_, ركت_, hkön, 
   {{0x05260086,0x249f1783,0x649700b3,0xa01b1784}},	//   _মনের_, dium_, cţii, kkön, 
   {{0x057603b1,0x63a400e4,0x442f01be,0x16a702f1}},	//   قاعد, _žino, _acg_, овчи_, 
   {{0x443d1785,0x442f052b,0x2907020f,0x38cb00d7}},	//   _bbw_, _bcg_, ânat_, _چاقی_, 
   {{0x69ce1786,0x442f1787,0x248d1788,0x684300b3}},	//   _izbe, _ccg_, ghem_, _онса, 
   {{0xb6a61789,0x684300e4,0xd7ef0038,0xe3af0019}},	//   _диал, _інфа, _شكل_, ہری_, 
   {{0xa5f702a6,0x2ca0059e,0xb5fc008a,0xc217004f}},	//   _међу_, hiid_, _inġo, оєю_, 
   {{0x2b420065,0xe3af015f,0xdb0f178a,0xf09f00b9}},	//   _lpkc_, فری_, _excè, tià_, 
   {{0x248d178b,0x27e00062,0x6e3e0065,0x442f016a}},	//   chem_, žinu_, _abpb, _gcg_, 
   {{0x98b3090e,0x2ca002a5,0xf09f03a1,0x2ca90611}},	//   žeća_, diid_, rià_, vnad_, 
   {{0x6d5e016a,0x6263013b,0x69ce01ff,0x9f520237}},	//   _brpa, _овча, _ozbe, _peyò_, 
   {{0x2d85063b,0x66cd0187,0xb05b0a52,0x628a00b3}},	//   ále_, núka, lläm, _ilfo, 
   {{0x51840f5a,0xbca50038,0x6d5e00ca,0x6722178c}},	//   _муқа, أمري, _drpa, kroj, 
   {{0x2d85034c,0x7de7005e,0x6d5e011d,0x2a78178d}},	// [e50] šle_, _мінд, _erpa, _borb_, 
   {{0x249f178e,0x248d0ab4,0x2a78178f,0xa9c71790}},	//   zium_, zhem_, _corb_, осек, 
   {{0x984b1617,0xdcef01dd,0x2ca90946,0x5f74009c}},	//   ияда_, ēdēt, pnad_, _فایر, 
   {{0x63ad003e,0xb05b02ae,0x64970474,0x2289020b}},	//   _þang, kläm, pţii, _múka_, 
   {{0x69ce1791,0xae1f0b3e,0x648e01f5,0x6f160175}},	//   _ezbe, _बयान_, _mùid, _xvyc, 
   {{0x442f1792,0x7bda00a7,0x5b7a00df,0x00000000}},	//   _scg_, _לקרו, _הרשא, --, 
   {{0x442f0183,0xa8a71793,0x20020035,0xb5fc008a}},	//   _pcg_, _драк, ybki_, _inġl, 
   {{0x672203ef,0xddc70032,0x1309017b,0x00000000}},	//   broj, rejň, бний_, --, 
   {{0x248d1794,0xf5590296,0xec790108,0x7c2d1795}},	//   rhem_, _گلاب_, _độc_, igar, 
   {{0x248d00e5,0x7c2d0156,0xc879027e,0x8af000ad}},	//   shem_, hgar, _hoş_, dvəl, 
   {{0x63ad1796,0x7c2d1797,0x648e00a1,0x6b890083}},	//   _žand, kgar, _bùid, _żegl, 
   {{0x2eb60b6c,0x628a0019,0xdb0f057d,0x7c2d1798}},	//   ृत्त, _elfo, _excé, jgar, 
   {{0xe28e0925,0x44f100ce,0x6d5e1799,0xb4b700a2}},	//   _за_, _há_, _srpa, चकी_, 
   {{0x442d14a4,0x7c2d179a,0x44f110d4,0x6449179b}},	//   lge_, egar, _ká_, leei, 
   {{0x44f1179c,0x2ca000b4,0x648e01be,0x6722179d}},	//   _já_, tiid_, _fùid, zroj, 
   {{0x7c2d179e,0x768f004f,0xb5fc007b,0xc006179f}},	//   ggar, _høyd, _anġl, _эпик, 
   {{0x44f117a0,0x442d17a1,0x20d200eb,0x2ca000b0}},	// [e60] _lá_, ige_, ráid_, riid_, 
   {{0x7c2d01c5,0x394302a2,0x20d20038,0x6d5e17a2}},	//   agar, _bpjs_, sáid_, _trpa, 
   {{0x44f117a3,0xd7fa07f9,0xc8790540,0x8e7b00d1}},	//   _ná_, бул_, _boş_, _הניה, 
   {{0xc87917a4,0x9f590126,0x26c70604,0x00000000}},	//   _coş_, casó_, elno_, --, 
   {{0x27e00088,0x442d00a7,0x6d5c17a5,0xf0930070}},	//   äin_, dge_, lvra, ענד_, 
   {{0xa96a17a6,0x44f117a7,0x672217a8,0x442d17a9}},	//   _лига_, _bá_, rroj, ege_, 
   {{0x44f117aa,0x6d5c17ab,0x69ce02f1,0xa4d817ac}},	//   _cá_, nvra, _uzbe, одку_, 
   {{0x44f117ad,0x442d17ae,0x7bc602a5,0xb4c8072d}},	//   _dá_, gge_, _kyku, ोगे_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7c2d17af,0xaabe17b0,0x44f117b1,0x442d17b2}},	//   zgar, ्तिक, _fá_, age_, 
   {{0x44f10084,0x7c2d17b3,0x044617b4,0x768f00fc}},	//   _gá_, ygar, _нежн, _døyd, 
   {{0xc87900ad,0x66cd0228,0x78a200da,0x849606a7}},	//   _xoş_, núkn, niov, _عجائ, 
   {{0xaabe1280,0xb05b00c8,0x623417b5,0xa01b0502}},	//   ्ताक, lläk, _желу, fhör, 
   {{0x68fc00e0,0x1df80b58,0x2ee50380,0xddc502d9}},	//   _otrd, зеры_, ölf_, _zahř, 
   {{0x291c006b,0xd23b00a7,0xdb1d00bc,0x44f10023}},	//   ával_, _הגול, _vysí, _xá_, 
   {{0x7c2d17b6,0x5d541628,0xd1380028,0xb4fb027a}},	//   ugar, экст, mtą_, מפלי, 
   {{0x7c2d17b7,0x649700b3,0x768f00dd,0x291802a3}},	// [e70] rgar, cţiu, _høye, _avra_, 
   {{0x7c2d17b8,0x442d17b9,0x6ce700dd,0x1eea009c}},	//   sgar, zge_, _німе, _گویی_, 
   {{0xd138012d,0x69f2004e,0x4c9500a3,0x442d00fb}},	//   ntą_, түст, _жинс, yge_, 
   {{0x44f117ba,0x6d45084c,0x78a202a3,0xd1380009}},	//   _rá_, _ipha, giov, itą_, 
   {{0x29180886,0x2d8300e4,0xb8f400a5,0x44f1008c}},	//   _evra_, lyje_, _सी_, _sá_, 
   {{0xd138012d,0x44f117bb,0x320e0054,0x61ea011c}},	//   ktą_, _pá_, _nefy_, _ngfl, 
   {{0x442d01bb,0x2d83012d,0xe61017bc,0x3f8217bd}},	//   tge_, nyje_, اشه_, zyku_, 
   {{0x44f117be,0x290117bf,0x442d17c0,0x78a20254}},	//   _vá_, mpha_, uge_, ciov, 
   {{0x26c7014b,0x44f10023,0xe78400b3,0xafdb0bf7}},	//   plno_, _wá_, _пуфо, nfød, 
   {{0x44f117c1,0x6d4517c2,0x442d01c5,0x644917c3}},	//   _tá_, _opha, sge_, seei, 
   {{0x6d45023b,0xbebb0034,0x442d02ae,0x7ae717c4}},	//   _npha, trën, pge_, _mijt, 
   {{0xbe250086,0x6724015e,0x7fd6004e,0x8fa617c5}},	//   ম্মদ_, šije, дігі, даме, 
   {{0x6d450daf,0x320e01a7,0x3ea313c0,0x7afd17c6}},	//   _apha, _fefy_, fijt_, _ntst, 
   {{0xdd92015f,0xafdb00fb,0x6497020f,0x6d5c0202}},	//   پور_, dfød, rţiu, tvra, 
   {{0x7afd17c7,0xed5717c8,0xe810000d,0xa01b074b}},	//   _atst, мор_, ारमा_, rhör, 
   {{0x69da03b7,0x78a20068,0x291c0032,0x5f2a0148}},	//   _útei, xiov, ávam_, _доим_, 
   {{0x60c417c9,0x7ae717ca,0xab5b010e,0xa01b02ae}},	// [e80] _ikim, _bijt, _szür, phör, 
   {{0x7bc617cb,0xab5b0019,0x68ee17cc,0x00000000}},	//   _vyku, _gyüm, _pubd, --, 
   {{0xceb30137,0xbebb024a,0x994a091d,0x6abe0502}},	//   _ביז_, ytëz, تلال_, ropf, 
   {{0x672b17cd,0x7aef020f,0xcb6a17ce,0xb4b700bc}},	//   fugj, _fuct, _даме_, चको_, 
   {{0x78a217cf,0x7bc6027e,0x60c4095a,0x9b0301d8}},	//   riov, _uyku, _mkim, _изяд, 
   {{0xd13817d0,0xa92617d1,0x68ee01ff,0x6b840027}},	//   ytą_, _одгл, _tubd, myig, 
   {{0x98a617d2,0x320e023a,0x68fc0121,0x2507010e}},	//   _живе, _refy_, _utrd, ورٹی_, 
   {{0x3d11034d,0xb05b02ae,0x60c417d3,0x399b00d1}},	//   _तबसे_, rläk, _nkim, _וילד, 
   {{0x6b8417d4,0xb05b02ae,0x320e0379,0xa2ac0299}},	//   nyig, släk, _pefy_, ीकल्, 
   {{0x60c417d5,0x325417d6,0xa01b0502,0x32050ff2}},	//   _akim, хвор, rköm, gbly_, 
   {{0x60f803bd,0xb05b0080,0x403517d7,0x6b840610}},	//   яння_, lläi, ненс, hyig, 
   {{0xd13817d8,0x60d602bf,0x2d830028,0xa50717d9}},	//   rtą_, _chym, vyje_, _цеца_, 
   {{0xd13817da,0x320e0379,0x64970474,0x00000000}},	//   stą_, _tefy_, rţit, --, 
   {{0x60c417db,0x2bd517dc,0x2d83012d,0xd1380009}},	//   _ekim, _दरबा, tyje_, ptą_, 
   {{0x7aef17dd,0x68fb16ef,0x6d5817de,0x7ae701c8}},	//   _suct, _čudo, _švar, _rijt, 
   {{0x96140086,0x2d83012d,0xdfd500f0,0xbf35004f}},	//   সলিম_, ryje_, _пойы, _знищ, 
   {{0x3f4f0405,0x7ebf00bc,0x3ea302b0,0x92c20033}},	// [e90] _użu_, tápě, pijt_, ্দী_, 
   {{0x2d830009,0xdddc00d2,0x6f0d0199,0x2fc90102}},	//   pyje_, skrš, _iwac, _iyag_, 
   {{0xb05b0080,0x6b8401b8,0xdeb20259,0x00000000}},	//   eläi, ayig, _сұры, --, 
   {{0x3869128a,0xc8790749,0x6f0d17df,0xa715004e}},	//   ñar_, _kişi_, _kwac, емді, 
   {{0x59d41422,0x7afd05a7,0x366917e0,0xfc3f010e}},	//   _थरथर, _utst, зало_, _amíg_, 
   {{0x644217e1,0xaa450088,0x6f0d0727,0x628802b0}},	//   _aboi, ävää_, _mwac, jkdo, 
   {{0xa2c200b0,0xaabe16df,0xafdb017b,0x00000000}},	//   रकन्, ्तरक, rdøy, --, 
   {{0xa3ba0a44,0x3ea10108,0x2fc90574,0xf9920486}},	//   _आँख_, _lmht_, _oyag_, _ערן_, 
   {{0x27ed17e2,0x644200a1,0x60d617e3,0x00000000}},	//   _igen_, _dboi, _rhym, --, 
   {{0xe1f80161,0x00000000,0x00000000,0x00000000}},	//   үгө_, --, --, --, 
   {{0x68e9006a,0x216917e4,0x6f0d17e5,0x320517e6}},	//   _kied, чини_, _awac, rbly_, 
   {{0x20560200,0x22800237,0x6f0d02b8,0xc8790241}},	//   хтор, _bòks_, _bwac, _bişi_, 
   {{0x68e917e7,0x6f0d02a5,0x443f0447,0x6497020f}},	//   _mied, _cwac, mfu_, bţir, 
   {{0x52390137,0x443f17e8,0x68e917e9,0x645917ea}},	//   _זײַנ, lfu_, _lied, _hawi, 
   {{0xfaff01ee,0x9d431088,0x64591694,0x27ed012e}},	//   _atë_, лерд, _kawi, _ogen_, 
   {{0x68e917eb,0x63a4012d,0x60c40010,0x645917ec}},	//   _nied, _žini, _ukim, _jawi, 
   {{0x6d410c05,0x645917ed,0x443f0053,0x645b0080}},	// [ea0] çlar, _mawi, ifu_, idui, 
   {{0x27ed04bb,0x6b84016c,0x248f0090,0x00000000}},	//   _agen_, ryig, _llgm_, --, 
   {{0x68e917ee,0xd7fa17ef,0x35c400a5,0xdb1d014b}},	//   _bied, пул_, _लुढ़, _vysá, 
   {{0x7e7e05ac,0x645900ab,0xb5fc007b,0x00000000}},	//   _hopp, _nawi, _inġi, --, 
   {{0x7e7e17f0,0x175400c8,0x17c801a2,0xd7070168}},	//   _kopp, твля, фҳаи_, енче_, 
   {{0x27ed17f1,0x443f17f2,0x7e7e17f3,0x645906e4}},	//   _egen_, efu_, _jopp, _aawi, 
   {{0x80d100cc,0x7e7e17f4,0x443f17f5,0x6abe17f6}},	//   _সংস্, _mopp, ffu_, ्तीर, 
   {{0xd49717f7,0x7e7e17f8,0x645917f9,0x63ad17fa}},	//   ерь_, _lopp, _cawi, _žana, 
   {{0x645917fb,0x82a617fc,0x645d0054,0x7e7e17fd}},	//   _dawi, ешне, ôsia, _oopp, 
   {{0x68e900e0,0x443f17fe,0x3d1100c2,0x07a30846}},	//   _zied, afu_, _तबले_, _саун, 
   {{0x7d0900ef,0x13ea00bf,0x3ce1009a,0x644201be}},	//   ćesk, _емей_, _कळले_, _tboi, 
   {{0x645917ff,0x765a0065,0x6abe0e0d,0x6f0d0118}},	//   _gawi, _haty, ्तुर, _pwac, 
   {{0x765a1800,0x6d580082,0x768f004f,0x00000000}},	//   _katy, _švap, _høya, --, 
   {{0x6459006a,0xa6e700e7,0x7e7e0e8b,0xdc030ed0}},	//   _zawi, _nhữ, _copp, rčík, 
   {{0xb81011bd,0x7e7e1801,0x765a1802,0x20d20038}},	//   ाराम_, _dopp, _maty, máin_, 
   {{0x765a1803,0x6ca41804,0x20d20038,0x6f0d007c}},	//   _laty, груж, láin_, _twac, 
   {{0x68e91805,0xeeb900cf,0xfaf30019,0x7e7e1806}},	// [eb0] _ried, _олиш_, اثر_, _fopp, 
   {{0x765a1807,0x68e91808,0x645b00b3,0x20d20038}},	//   _naty, _sied, zdui, náin_, 
   {{0x68e91809,0x394703a1,0x4815170f,0x5e9c00d1}},	//   _pied, ïns_, вмес, _מבזק, 
   {{0x20d2057f,0x26c5026e,0xe0df06df,0x7e7e02a3}},	//   háin_, _sklo_, nmò_, _zopp, 
   {{0x64591436,0x68e9180a,0x765a180b,0x20d90038}},	//   _rawi, _vied, _baty, méid_, 
   {{0x68e9180c,0x645909e8,0x945d00ab,0xe5a5180d}},	//   _wied, _sawi, końc, кили, 
   {{0x68e9030f,0x6459180e,0x443f180f,0x20d20038}},	//   _tied, _pawi, tfu_, dáin_, 
   {{0x67241810,0x27ed055f,0x20d9007a,0x929d0083}},	//   šija, _ugen_, néid_, dpła, 
   {{0xe29911db,0x645b1811,0x443f1812,0x23db00c9}},	//   дап_, rdui, rfu_, मेंद, 
   {{0x273b055a,0x64590010,0x09e50086,0x443f1813}},	//   mên_, _wawi, _প্যা, sfu_, 
   {{0x273b055a,0x81c9100b,0x20120cbf,0x64591814}},	//   lên_, লেন_, _peyi_, _tawi, 
   {{0x387f0518,0x7e0a0081,0x7e7e1815,0xa3ba1615}},	//   _jour_, वर्ग_, _sopp, _आँच_, 
   {{0x273b1816,0xa4d402fb,0x80d10086,0x087600c7}},	//   nên_, _соці, _সংশ্, דערט_, 
   {{0x9f9e03b7,0x20d203b3,0xe0df02a3,0x387f0237}},	//   _ação_, cáin_, amò_, _lour_, 
   {{0x273b078a,0xada303dd,0x71640038,0x2d8c0032}},	//   hên_, аарл, _مايك, áde_, 
   {{0x273b055a,0x09b00086,0x1f661817,0xeaed058c}},	//   kên_, _করলা, _аким, जदूत_, 
   {{0x7e7e0c17,0xf4120137,0x273b0218,0x5a44004e}},	// [ec0] _topp, יפן_, jên_, лмағ, 
   {{0x273b0218,0x386d01e8,0xdee61818,0x3ceb0027}},	//   dên_, _aner_, _шопи, _eicv_, 
   {{0xceb902d9,0x386d1819,0x64950ed0,0x00000000}},	//   éře_, _bner_, _káid, --, 
   {{0x273b0218,0x387f026a,0x765a181a,0x20d9007a}},	//   fên_, _cour_, _saty, céid_, 
   {{0x765a012d,0x69d50019,0xb8f90a34,0x929d0035}},	//   _paty, _ezze, _ठी_, zpła, 
   {{0x6f020c05,0x649500eb,0x9634181b,0x648e01be}},	//   _çocu, _láid, ункц, _cùin, 
   {{0x64b300d9,0xfaa3181c,0xc60b0086,0x387f181d}},	//   răin, _таро, _রাখা_, _four_, 
   {{0x273b0218,0xb4cc00a2,0x00000000,0x00000000}},	//   bên_, ळते_, --, --, 
   {{0x20d20038,0x273b010c,0xd2500038,0xa6e6181e}},	//   táin_, cên_, منة_, _ажал, 
   {{0x7c2900e0,0x38bc00da,0x69da00da,0x42740229}},	//   _ķerm, víry_, _útes, угос, 
   {{0x387f181f,0x63ad010d,0x20d20038,0xe1341820}},	//   _your_, _þann, ráin_, ынны, 
   {{0x20d20084,0x63a400e4,0x2ebd0ffc,0x66181821}},	//   sáin_, _žinu, ोत्त, lavk, 
   {{0xe0df01d8,0x20d2007a,0x909800fd,0x64950354}},	//   rmò_, máil_, твят_, _dáid, 
   {{0x44f81822,0x395802fe,0x6fe901dd,0x66181823}},	//   _ké_, _osrs_, _rīcī, navk, 
   {{0x273b078a,0x44f81824,0x395800ef,0x9c830098}},	//   zên_, _jé_, _nsrs_, áčov, 
   {{0x273b1825,0x44f8057f,0x80d10033,0x23661826}},	//   yên_, _mé_, _সূর্, _kroj_, 
   {{0x20191827,0x44f81828,0x1af41829,0x273b0218}},	// [ed0] masi_, _lé_, иптя, xên_, 
   {{0x273b055a,0x20d20084,0x7e5500dd,0x44f80038}},	//   vên_, háil_, _своє, _oé_, 
   {{0x387f182a,0x6618026e,0x20d900eb,0x69c808bb}},	//   _pour_, davk, péid_, _ødel, 
   {{0x273b078a,0xdb1d00c8,0xb4cc009a,0x5c0400fd}},	//   tên_, _pysä, ळतो_, _вяра, 
   {{0xfeb8182b,0x9cd60cec,0x20d200eb,0x2366023b}},	//   _سایت_, _תורה_, dáil_, _nroj_, 
   {{0x273b1816,0x44f8182c,0x2ca902bf,0x201902f1}},	//   rên_, _bé_, liad_, hasi_, 
   {{0x2019182d,0x273b078a,0x44f80084,0x888300c5}},	//   kasi_, sên_, _cé_, _پیشن, 
   {{0x236600f1,0x20d20084,0x44f8182e,0x2ca902bf}},	//   _broj_, gáil_, _dé_, niad_, 
   {{0x661811b1,0x69da00bc,0xb5fc01f2,0x273b010c}},	//   bavk, _úter, _anġu, qên_, 
   {{0x2019002e,0x44f8182f,0x6f1d1830,0x2ca900f8}},	//   easi_, _fé_, dssc, hiad_, 
   {{0x20191831,0xa29f0077,0x44f8005f,0x2366007b}},	//   fasi_, गोष्, _gé_, _eroj_, 
   {{0x20191832,0x68f51833,0x20d200eb,0x27e90a1a}},	//   gasi_, _muzd, cáil_, žanu_, 
   {{0x32451834,0x2ca902f0,0x44f81835,0xb05b02ae}},	//   _белг, diad_, _zé_, poän, 
   {{0xed5a16d9,0x248d031e,0xf20706ba,0x44f817cc}},	//   ног_, lkem_, _рядо, _yé_, 
   {{0x20191836,0x2ca902bf,0x68f500d2,0x29030415}},	//   basi_, fiad_, _nuzd, _ntja_, 
   {{0x6abe0cb8,0x2ca902bf,0x1bea0b68,0x20191837}},	//   ्त्र, giad_, едби_, casi_, 
   {{0xab661838,0xb05b0219,0xab271839,0xeb97183a}},	// [ee0] ывал, rlät, лота_, гит_, 
   {{0x248d0077,0x68f5183b,0xed5a0398,0x2bc703a1}},	//   hkem_, _buzd, _зоо_, улуп_, 
   {{0xb05b01c4,0x248d183c,0x648e00a1,0xdca6183d}},	//   plät, kkem_, _bùil, _бани, 
   {{0x44f8183e,0xb05b183f,0x648e01be,0x39580352}},	//   _ré_, llär, _cùil, _vsrs_, 
   {{0x44f81840,0x7643016a,0x23690097,0x91ca03ce}},	//   _sé_, ffny, _šajn_, _सुनै, 
   {{0x44f81841,0x4ab8000c,0x20191842,0x248d01c8}},	//   _pé_, _आदिव, zasi_, ekem_, 
   {{0x20191843,0x20d20084,0xc879009e,0x2b401844}},	//   yasi_, táil_, _pişt_, ltic_, 
   {{0x6f040d26,0x44f8001b,0x23661845,0x768f00fc}},	//   _otic, _vé_, _proj_, _høyl, 
   {{0x201909c2,0x3636024f,0xe80a02f8,0x20d20084}},	//   vasi_, _مراس, _ह्या_, ráil_, 
   {{0x44f81846,0x20191847,0xfaff024a,0x20d200eb}},	//   _té_, wasi_, _orën_, sáil_, 
   {{0xc879078a,0x6f040628,0x32630009,0xe3af0a5a}},	//   _tişt_, _atic, стыв, قری_, 
   {{0x68e21848,0x6f040036,0x6f1d1849,0x248d184a}},	//   nmod, _btic, tssc, ckem_, 
   {{0xb4c005fd,0xb4c202f8,0x2366024a,0x68e2019b}},	//   ंकी_, ृती_, _uroj_, imod, 
   {{0x25630c05,0x2ca9056b,0x3eaa0380,0x6f1d1176}},	//   _yıl_, wiad_, gibt_, rssc, 
   {{0x2019120c,0x6f0409e6,0x69ce0075,0xdd94013e}},	//   pasi_, _etic, _nybe, бары, 
   {{0xb05b1709,0x2b4000ef,0x201900a3,0x2b4b03dd}},	//   rläs, ftic_, qasi_, _ppcc_, 
   {{0x2ca9184b,0x68f5184c,0xb05b03d8,0xddde0118}},	// [ef0] riad_, _suzd, släs, _lapň, 
   {{0x69ce0691,0x2ca90156,0x8f9c00c7,0x68f50032}},	//   _bybe, siad_, _ריזי, _puzd, 
   {{0x81e60033,0xb9b50d4b,0x2ca9184d,0x248d184e}},	//   যুর_, جماع, piad_, ykem_, 
   {{0x69ce02c9,0x21370070,0x7648184f,0x00000000}},	//   _dybe, רטאל_, _abdy, --, 
   {{0x65681850,0x2b401851,0xdc360137,0x648e00a1}},	//   _ardh, ctic_, _דארט_, _cùim, 
   {{0x7aee01c4,0x83fd0019,0xab6601dd,0x8af000ad}},	//   _gibt, zdőd, _daļē, rvət, 
   {{0x248d1852,0xd6180038,0x291c00bc,0x68e2019c}},	//   tkem_, اتها_, ávat_, bmod, 
   {{0x03251853,0xc4850a66,0x06b102d9,0x693400d9}},	//   адин, рлик, _řídí_, _ынсу, 
   {{0x656800e5,0xc6140086,0x67d4004f,0x248d1854}},	//   _erdh, _সারা_, _готу, rkem_, 
   {{0x78ab03a9,0x64870327,0x248d1855,0x2d9c039f}},	//   ligv, _añit, skem_, _üveg_, 
   {{0xe0da1856,0x26c71857,0x39411858,0x6f041859}},	//   кво_, mono_, nths_, _stic, 
   {{0x6e250014,0x26c7185a,0xafe600a3,0x78ab0d62}},	//   _adhb, lono_, ионл, nigv, 
   {{0xe28e185b,0x7fd6005e,0xa3e9185c,0x7d050038}},	//   _да_, ріні, _मणि_, _aths, 
   {{0x91e5185d,0x26c7185e,0x539a00a7,0x2b400082}},	//   _коле, nono_, _בינו, vtic_, 
   {{0xb05b0844,0x26c700fd,0x5fd8009a,0x68e200f3}},	//   rlär, iono_, _ठरवल, ymod, 
   {{0x26c7185f,0xdd8f0c72,0x2b40002c,0x62831860}},	//   hono_, ذوق_, ttic_, _hono, 
   {{0x6f041861,0x26c71862,0x68e215f2,0x78ab02c9}},	// [f00] _utic, kono_, vmod, digv, 
   {{0x26c7012d,0x2b401863,0xa01b1864,0x62831865}},	//   jono_, rtic_, sköt, _jono, 
   {{0x2b401866,0xd83a011f,0x26c70093,0x8c4608a5}},	//   stic_, вэл_, dono_, _кене, 
   {{0x69ce0076,0xa01b1867,0x2d9514c1,0xb5fc00c3}},	//   _vybe, lkör, _ырыс, _maġe, 
   {{0x26c71868,0xbebb00e5,0x4733004f,0x15e802e6}},	//   fono_, rrëv, жніс, टेनर_, 
   {{0x62831869,0x68e2050f,0x69ce186a,0xafdb01e8}},	//   _nono, smod, _tybe, dføl, 
   {{0xa01b0219,0xa3e302e6,0x68e2186b,0x768f00fc}},	//   ljöe, फेस_, pmod, _gøym, 
   {{0xd706170f,0x2606051f,0x776900b4,0xfaa6186c}},	//   _взаи, _स्री_, _frex, _саҳо, 
   {{0x6283186d,0xf74900d4,0xa2c200a2,0x26c7186e}},	//   _bono, _مجله_, रकल्, bono_, 
   {{0x6283186f,0x26c71870,0xe5a600a3,0x20d902be}},	//   _cono, cono_, _кизи, déia_, 
   {{0x62831871,0xd48f1872,0x7c261873,0x99f70056}},	//   _dono, _др_, _odkr, יזיה_, 
   {{0xdcee012d,0x62830379,0x75d3009c,0xb97b00d1}},	//   mybė, _eono, _بيما, דנטי, 
   {{0x44261874,0x62831875,0xe3b2024f,0xbfa81876}},	//   _ido_, _fono, _برا_, атре_, 
   {{0x62831877,0x00000000,0x00000000,0x00000000}},	//   _gono, --, --, --, 
   {{0x44261878,0x57d302a2,0xdcee0009,0x6ca7012d}},	//   _kdo_, _तर्ह, nybė, араж, 
   {{0x30150165,0x26c71879,0x80d10086,0x27e0014b}},	//   _удир, zono_, _সংক্, žiny_, 
   {{0x60cd187a,0x26c7187b,0x6d480241,0x4426095a}},	// [f10] _ikam, yono_, çdar, _mdo_, 
   {{0x9967187c,0xdcee0009,0x3b0900ad,0x442602be}},	//   ител, kybė, rpaq_, _ldo_, 
   {{0xd366182b,0x161a006a,0x26c70141,0x442610d4}},	//   _که_, _नज़र_, vono_, _odo_, 
   {{0x77690496,0xa3cc017d,0x44260053,0xb4c0031e}},	//   _prex, _शुभ_, _ndo_, ंको_, 
   {{0x26c7187d,0x60cd187e,0x36d5187f,0xc7b9039f}},	//   tono_, _mkam, бодр, _idők_, 
   {{0xc9871880,0x44261881,0x6b8d1882,0x2bb40179}},	//   _куби, _ado_, myag, ंपरा, 
   {{0x09e5100b,0x99850084,0x1a6800c5,0x60cd1883}},	//   _প্রা, _الزو, _خیلی_, _okam, 
   {{0xa8a4013d,0x442600e5,0x26c71884,0xe459005b}},	//   _друк, _cdo_, sono_, ужи_, 
   {{0x6b8d1885,0x26c71886,0x44261887,0x78a91888}},	//   nyag, pono_, _ddo_, _imev, 
   {{0x60cd1889,0x44260414,0x81c200cc,0xafdb03a9}},	//   _akam, _edo_, ্ধন_, rføl, 
   {{0x6283188a,0xa01b02ae,0xb5a7188b,0xa202012d}},	//   _vono, vkör, _трай, япэд, 
   {{0x656e057f,0x6283188c,0x160b188d,0xafdb004f}},	//   _ábha, _wono, _स्तर_, pføl, 
   {{0x23290a43,0x628305f0,0xafdb01cc,0x80d10086}},	//   _соли_, _tono, lføj, _সংখ্, 
   {{0x629a188e,0xb05b0219,0x60cd0226,0x78bb02ae}},	//   chto, släp, _ekam, _ljuv, 
   {{0x7c960ca9,0x753c01c4,0x69a700b5,0xa01b188f}},	//   брац, _ärzt, _टेली, rkör, 
   {{0xa9240228,0x20d91890,0xdca31891,0xa01b1892}},	//   _úžit, péia_, паси, skör, 
   {{0xc9f600eb,0x09e50086,0xa01b0f71,0xbc1900f0}},	// [f20] مساع, _প্লা, pkör, рісі_, 
   {{0xe8101893,0x2bac009a,0x78a90548,0xa01b0c98}},	//   ार्थ_, _घेणा, _amev, lköp, 
   {{0x81c9100b,0x443d1894,0x997c0243,0x6b8d01b8}},	//   লের_, _ocw_, sāža_, ayag, 
   {{0xa01b014e,0x443d1895,0xdcee0009,0xe81a1896}},	//   nköp, _ncw_, vybė, ازات_, 
   {{0x20020df4,0x649c007a,0x26de0175,0xb8651897}},	//   icki_, _héig, _phto_, تالو, 
   {{0xa01b030f,0xdcee012d,0xb4c200b0,0x38600082}},	//   hköp, tybė, ृत्_, žir_, 
   {{0x25e31898,0x2bac009a,0xeae40d0d,0xdcfc0028}},	//   टेली_, _घेता, कगीत_, tyrę, 
   {{0x69dc06e0,0x44261899,0xdcee0009,0x8366189a}},	//   _izre, _qdo_, rybė, مدخل, 
   {{0x4426050a,0x57fb00fe,0x649c00eb,0xa01b0219}},	//   _vdo_, _תלמו, _léig, dköp, 
   {{0x60cd189b,0x6d5e189c,0x32180187,0xe810031e}},	//   _skam, _ospa, úry_, ारका_, 
   {{0x4426189d,0x637a00f0,0x672201dd,0xa055004f}},	//   _tdo_, _әсер_, lsoj, овні, 
   {{0x55770137,0x661a0e0f,0x629a189e,0x442602eb}},	//   _לעבן_, _hetk, shto, _udo_, 
   {{0xc8830218,0x7e2b012d,0x2d8c0453,0x09c5009a}},	//   _hişê_, ліва_, øden_, _वड्य, 
   {{0x69dc015e,0x2486023b,0xa19413cb,0x2002055f}},	//   _ozre, _hoom_, _малч, acki_, 
   {{0x248601c1,0x321e072b,0xdd94189f,0x6495007a}},	//   _koom_, maty_, пары, _máin, 
   {{0x60cd18a0,0x6b8d18a1,0x321e174b,0x672218a2}},	//   _ukam, tyag, laty_, ksoj, 
   {{0x6d5e18a3,0xfbd30133,0x69dc00e2,0x6f1600f8}},	// [f30] _espa, ستر_, _azre, _gwyc, 
   {{0x661a18a4,0xbebb024a,0x6b8d007c,0x321e18a5}},	//   _netk, rrës, ryag, naty_, 
   {{0x2bd50b79,0x6f160035,0x2907024a,0x7e990296}},	//   _दरका, _zwyc, ëna_, _منکر_, 
   {{0x2486023b,0x290701dd,0x66cd04f4,0xd7d50267}},	//   _noom_, īna_, júkr, ожењ, 
   {{0xf1cf0262,0x201b016a,0x41cf031e,0x321e18a6}},	//   _सुनन, _meqi_, _सुनस, katy_, 
   {{0x661a00d2,0xda7b012d,0x57a9009a,0x7bdd18a7}},	//   _cetk, _сям_, _कधीह, _izsu, 
   {{0x78bb0611,0x7d020032,0xe810009a,0x24860df7}},	//   _tjuv, _čosk, ारखा_, _boom_, 
   {{0x629803a9,0x6722006d,0x661a10de,0x44890e2c}},	//   _alvo, bsoj, _eetk, рбин_, 
   {{0x20d918a8,0x321e0180,0x254e00ad,0x64950038}},	//   téin_, faty_, _cəlb_, _fáin, 
   {{0x312518a9,0x52a900c8,0x81bd0033,0x114900d9}},	//   одог, рвом_, _আরব_, апой_, 
   {{0x2486006f,0x649c0354,0x6f1618aa,0x00000000}},	//   _foom_, _béid, _swyc, --, 
   {{0xa91107d5,0x649c007a,0x24860106,0x00000000}},	//   डीएफ_, _réig, _goom_, --, 
   {{0x661a096f,0x321e18ab,0x2d8512b7,0xa01b03d8}},	//   _yetk, baty_, älen_, rköp, 
   {{0x216918ac,0x644918ad,0xfc3f022c,0xddde00b3}},	//   _вики_, lfei, _ací_, _nopţ, 
   {{0x649c057f,0x71a518ae,0xed5a18af,0x6724003d}},	//   _féid, _файз, шов_, ġiji, 
   {{0x248618b0,0x2fc00201,0x644911a5,0x672400d2}},	//   _xoom_, _txig_, nfei, šiji, 
   {{0x6d5e00ab,0xbb4318b1,0x8b260080,0xbbb40110}},	// [f40] _wspa, метк, юдае, ंपेक, 
   {{0x649c00eb,0x1ae318b2,0x62810574,0x00000000}},	//   _téig, доум, njlo, --, 
   {{0x661a18b3,0xa01b0219,0xa96700fd,0x00000000}},	//   _retk, ljöa, жиха_, --, 
   {{0x661a18b4,0x50ca00ab,0x20ca031e,0x672200c8}},	//   _setk, रविष, रविध, tsoj, 
   {{0x661a0412,0x248600a7,0xe8e00023,0x67560491}},	//   _petk, _room_, hiệt_, تخار, 
   {{0x2a6302fe,0x248618b5,0x6b8b0219,0x649c02be}},	//   _gajb_, _soom_, ägge, _méie, 
   {{0xd49a18b6,0x248618b7,0x661a18b8,0x69dc01dd}},	//   ири_, _poom_, _vetk, _uzre, 
   {{0xb19800e7,0x734a00d9,0x672d18b9,0xe9d7004f}},	//   _ngưỡ, ачов_, šaja, _єкт_, 
   {{0x61ef0095,0x649c0038,0x68fc18ba,0x160b0fc0}},	//   əklə, _réid, _hurd, _स्वर_, 
   {{0x68fc18bb,0x386618bc,0x649500e1,0x00000000}},	//   _kurd, ldor_, _háil, --, 
   {{0xe45a02fb,0x2486023b,0x7f4418bd,0x321e18be}},	//   _вже_, _toom_, _aqiq, raty_, 
   {{0x386618bf,0x68fc18c0,0x290a02fe,0x92ca0086}},	//   ndor_, _murd, _mtba_, লগে_, 
   {{0x610100e0,0x91ca02e6,0x270c0033,0x321e18c1}},	//   _vēla, _सुरै, _হয়তো_, paty_, 
   {{0x81c90086,0x76580053,0x809f0035,0xbbb4009a}},	//   লেই_, nevy, खोजे, ंपैक, 
   {{0xbd6818c2,0x009500b3,0x00000000,0x00000000}},	//   орте_, _никэ, --, --, 
   {{0x90c4081b,0x321c0054,0x90e7009c,0x649502be}},	//   _обје, _hevy_, _بستن, _náil, 
   {{0x1eab00eb,0x7bc10035,0x386618c3,0xe0d00e0e}},	// [f50] _نادي_, _ślub, ddor_, _جزو_, 
   {{0x1b040033,0x68fc18c4,0x291803c6,0x229b009e}},	//   _লিখে_, _burd, _bwra_, _têke_, 
   {{0xad2700d4,0x27890161,0xa907015f,0xe9f8004f}},	//   _برخو, өрдү_, زبان, інці_, 
   {{0xe8f818c5,0x649500eb,0x68fc18c6,0xfe4300f6}},	//   ілі_, _cáil, _durd, _эмүү, 
   {{0xb9020081,0xcb4400ce,0x7d0200ef,0x6d4718c7}},	//   _नी_, _охри, _čosi, ltja, 
   {{0x7afd18c8,0x9662004e,0x8afa00d1,0x24670023}},	//   _iust, екше, _להשי, _ốm_, 
   {{0xceb40137,0x6d4718c9,0x855700d6,0x649500eb}},	//   ויס_, ntja, تیار_, _fáil, 
   {{0x7af50a9f,0x81c20033,0x00000000,0x00000000}},	//   _hizt, ্ধা_, --, --, 
   {{0x644918ca,0xe3b100eb,0x68fc123c,0x765818cb}},	//   rfei, عرب_, _zurd, bevy, 
   {{0x7afd18cc,0x644918cd,0x68fc18ce,0xe29902a6}},	//   _must, sfei, _yurd, сао_, 
   {{0x68fc0496,0xc6920225,0x76b20035,0x7af500b4}},	//   _xurd, _ראב_, słyc, _mizt, 
   {{0x7b090032,0x7af501cf,0x69d5021e,0x00000000}},	//   _kľud, _lizt, _myze, --, 
   {{0x7afd00e4,0xb4c900a2,0x3f8f003d,0xbf9b02aa}},	//   _nust, ोती_, _żgur_, scên, 
   {{0x91fc01dd,0x649c0534,0x249f0096,0x00000000}},	//   ndāl, _géib, lhum_, --, 
   {{0x7c96013d,0x649500eb,0xe7eb0fc0,0x00000000}},	//   прац, _láim, जेता_, --, 
   {{0x7afd18cf,0x249f00ce,0xa3e2007e,0x7af500e0}},	//   _bust, nhum_, _धरम_, _aizt, 
   {{0x7af518d0,0x7afd18d1,0x649c0354,0xdca318d2}},	// [f60] _bizt, _cust, _héic, хати, 
   {{0x5cf600b3,0x7afd18d3,0x00000000,0x00000000}},	//   _няму, _dust, --, --, 
   {{0x7afd01f1,0x68fc18d4,0x7af500b4,0xc6c600f0}},	//   _eust, _qurd, _dizt, үйек, 
   {{0x7afd18d5,0x20d218d6,0x68fc14a4,0x69d518d7}},	//   _fust, máis_, _vurd, _dyze, 
   {{0x7afd18d8,0x68fc02e7,0x672d0112,0x386618d9}},	//   _gust, _wurd, šajn, rdor_, 
   {{0x68fc18da,0x35d416b7,0x648e00a1,0x2d8703dd}},	//   _turd, молё, _lùit, _ànec_, 
   {{0x7afd18db,0x321c18dc,0x64950038,0x290a18dd}},	//   _zust, _revy_, _táil, _utba_, 
   {{0x2ca006e4,0x7de70019,0xf74618de,0x957c0035}},	//   nhid_, lésé, _небо, _rząd, 
   {{0x7afd09a1,0xa786189a,0x00000000,0x00000000}},	//   _xust, _عشرو, --, --, 
   {{0xa3d202f1,0xcb1300d1,0x61010243,0x7de7039f}},	//   моқч, עלת_, _cēlo, nésé, 
   {{0xa3cc0081,0xfbc40086,0x59be18df,0x648e01fd}},	//   _शुर_, ্ধিত, ्थिर, _bùit, 
   {{0x64a30009,0x7bc300b3,0x20d218e0,0x249f18e1}},	//   _паха, şnui, dáis_, chum_, 
   {{0xcb1b02e6,0x8143009c,0x7e650175,0x7de70175}},	//   _पौंड_, ونین, _pahp, késé, 
   {{0x6d4718e2,0x26ce0054,0x6f0f0326,0x7afb019c}},	//   ttja, nofo_, rpcc, _éuti, 
   {{0x71f70133,0x7de70019,0x7afd18e3,0x20d20369}},	//   _عروس_, désé, _sust, gáis_, 
   {{0x6d4718e4,0x628a18e5,0x768f004f,0x9f4001d6}},	//   rtja, _hofo, _høyt, _egiñ_, 
   {{0x6d4703f1,0xc6220086,0x20090369,0x7af501f1}},	// [f70] stja, _নানা_, _ifai_, _pizt, 
   {{0xbd020126,0x6d4718e6,0x26ce0054,0x8f9c00d1}},	//   ñéca, ptja, jofo_, _ליחי, 
   {{0xb5fc0405,0x628a18e7,0x20d218e8,0x2ca000a1}},	//   _paġn, _mofo, cáis_, bhid_, 
   {{0xddde1861,0x69d50187,0x2ca018e9,0x20d20038}},	//   _uopš, _vyze, chid_, láir_, 
   {{0xf74518ea,0x26ce06c2,0x7afd01a4,0x00000000}},	//   фело, fofo_, _uust, --, 
   {{0x628a18eb,0x20d200eb,0x64420068,0x768f017b}},	//   _nofo, náir_, _acoi, _nøyt, 
   {{0x249f0090,0x24e918ec,0x00000000,0x00000000}},	//   thum_, омки_, --, --, 
   {{0x9f650228,0x649500eb,0x130918ed,0xc21f00a5}},	//   _štýl_, _táim, оний_, _मजहब_, 
   {{0xf77f01b8,0x628a18ee,0x6f0d0199,0x80c90086}},	//   _çç_, _bofo, _ntac, রগঞ্, 
   {{0xd0480095,0x20d20369,0xe3b61193,0xaabf0ed5}},	//   əməy, yáis_, ьбы_, ्विक, 
   {{0x249f0574,0x648e01c5,0x610101dd,0x5bba00ae}},	//   phum_, _cùis, _vēlo, _इश्व, 
   {{0x644200eb,0x7de70019,0xe2f9004e,0xf4850116}},	//   _gcoi, zésé, _деді_, _تائی, 
   {{0xe3ae0845,0x628a18ef,0x10a318f0,0xa01b18f1}},	//   _рб_, _fofo, тиян, mjöl, 
   {{0x12fa00a7,0xa3e218f2,0x20d2060f,0x443f18f3}},	//   _והסב, _धरत_, táis_, lgu_, 
   {{0x2ca00014,0x9d43021f,0x443f05b5,0x768f004f}},	//   thid_, керд, ogu_, _høys, 
   {{0x443f18f4,0x2ca002cd,0x672904b3,0x20d200eb}},	//   ngu_, uhid_, _ovej, ráis_, 
   {{0x7de70019,0xaec618b2,0x236d055f,0x9f440088}},	// [f80] tésé, _обил, nvej_, ämä_, 
   {{0x2ca018f5,0xed5a18f6,0x6b8b0219,0x629d0034}},	//   shid_, _доо_, ägga, ësoh, 
   {{0x443f0938,0x610800bc,0xfe14031e,0xd7fa002e}},	//   kgu_, _těle, _त्यस_, оул_, 
   {{0x648e01f5,0x236d0566,0x00000000,0x00000000}},	//   _lùir, kvej_, --, --, 
   {{0x7c2418f7,0x2b4918f8,0x67290082,0xfbdf010c}},	//   mair, ctac_, _cvej, _ecêb_, 
   {{0x7c2418f9,0x64420084,0x443f18fa,0x2458001b}},	//   lair, _scoi, egu_, _ẩm_, 
   {{0x26ce0180,0xa01b008c,0x3d1200a2,0x645b18fb}},	//   rofo_, fjöl, धीचे_, feui, 
   {{0x7c2418fc,0x628a02f2,0x66df009e,0x443f18fd}},	//   nair, _sofo, rêka, ggu_, 
   {{0x648e01fd,0x63ad18fe,0x26ce045a,0x64420108}},	//   _bùir, _žanr, pofo_, _vcoi, 
   {{0x7c2418ff,0x628a00c3,0x648e0465,0x6f0d00a3}},	//   hair, _qofo, _cùir, _rtac, 
   {{0x3a371900,0x7c241901,0x60cf00d9,0x6f0d1902}},	//   ורים_, kair, tocm, _stac, 
   {{0x78a21903,0x628a019b,0x645b1904,0x9f3500f0}},	//   nhov, _wofo, ceui, немі, 
   {{0x7c241905,0xe2860c67,0x23e21223,0xb4ca0f8c}},	//   dair, _олди, _परिद, लकी_, 
   {{0x44241906,0x768f02fb,0x78a2059e,0x00000000}},	//   lam_, _høyr, hhov, --, 
   {{0x20c70a2b,0xa2cb072f,0x7c241907,0xa01b02ae}},	//   _осиг, सकर्, fair, ljöm, 
   {{0x44241908,0x64401909,0x7c240a92,0xa3e2190a}},	//   nam_, ngmi, gair, _धरा_, 
   {{0x3a750c67,0x4424190b,0x7b090032,0x6f0d190c}},	// [f90] нлар, iam_, _sľub, _utac, 
   {{0x5a34190d,0x2b49190e,0x81c90086,0xe7d200a5}},	//   кнут, rtac_, লেও_, _तड़प, 
   {{0x4424190f,0x6729090e,0x443f1910,0x38351911}},	//   kam_, _svej, ygu_, енер, 
   {{0x7c241912,0xe80a0f65,0xdbd9003e,0xd0f90070}},	//   cair, हुला_, _fæði, פּער, 
   {{0xfe70010e,0x00000000,0x00000000,0x00000000}},	//   _صدی_, --, --, --, 
   {{0x81c90086,0x45191913,0xa01b010e,0xb4c90299}},	//   লেট_, пция_, gköz, ोत्_, 
   {{0x44241914,0x645b1915,0xddde0035,0x32f60083}},	//   fam_, teui, _zapł, _płyn_, 
   {{0x78a208fc,0xfdf800a7,0x443f1916,0x69c7008a}},	//   chov, וצות_, ugu_, _ixje, 
   {{0x610100e0,0x254e0095,0x645b1917,0x00000000}},	//   _vēlm, _həll_, reui, --, 
   {{0x443f02bf,0x236d055f,0xf1bf0032,0x2d1f00a5}},	//   sgu_, rvej_, ášok_, _बबूल_, 
   {{0x236d055f,0xa06a1918,0x00000000,0x00000000}},	//   svej_, пана_, --, --, 
   {{0x7ea20379,0x20050035,0x236d02c9,0xd11b0299}},	//   _môpe, ślin_, pvej_, भीषण_, 
   {{0x442f1919,0x9f4c07fa,0x7c2400e0,0x47d10033}},	//   _idg_, _ölüm_, vair, _তৃতী, 
   {{0x78a2026e,0xade400c2,0xa3b80038,0xdbd901d5}},	//   zhov, _गरदन_, _تامر_, _ræði, 
   {{0x7c24191a,0xc69200fe,0x649c0354,0x69c700e5}},	//   tair, נאל_, _méin, _nxje, 
   {{0x23ce000d,0x649c00eb,0xa01b0019,0x442f191b}},	//   _हुँद, _léin, zköz, _jdg_, 
   {{0x7c24191c,0xfa3607cb,0x69cb027e,0x442f191d}},	// [fa0] rair, فراد, şgel, _mdg_, 
   {{0x7c24191e,0x4a43088a,0xd00f009c,0xa9a6191f}},	//   sair, лнув, _پلی_, низд, 
   {{0x442f1920,0xf2960070,0x7c241921,0x00000000}},	//   _odg_, עכער_, pair, --, 
   {{0xafdb155b,0x44241922,0xb05b0380,0x442f095a}},	//   mfør, xam_, mnäc, _ndg_, 
   {{0xa01b0019,0x78a21923,0x69c70126,0xafdb08bb}},	//   tköz, rhov, _exje, lfør, 
   {{0x44241924,0x78a21925,0x60c40082,0xfaff021e}},	//   wam_, shov, _ljim, _erës_, 
   {{0xb7bd002e,0x78a2014e,0x442f1926,0xafdb1927}},	//   _reţe, phov, _bdg_, nfør, 
   {{0x442f04fe,0xb4ca04b7,0x2a6a008a,0x18670176}},	//   _cdg_, लके_, _habb_, _паси_, 
   {{0xe7370676,0x64400077,0x98a31928,0x442f00b9}},	//   _пет_, rgmi, _сите, _ddg_, 
   {{0x44241929,0x649c00e1,0x929402a6,0xafdb00fc}},	//   sam_, _géin, таоц, kfør, 
   {{0x442f0aaf,0xa2a60fc0,0x648e00a1,0xd36f03dd}},	//   _fdg_, टोग्, _fùip, _өч_, 
   {{0x4424192a,0xafdb09a8,0x395814e2,0x442f03c6}},	//   qam_, dfør, _mprs_, _gdg_, 
   {{0x6108031e,0xa01b02ae,0x2d8c0f03,0xb5fc00c3}},	//   _děla, ljök, äden_, _raġj, 
   {{0x6234049b,0xd36f009c,0xd4910210,0x94b00249}},	//   _реку, _دهه_, _rùi_, _जगुआ, 
   {{0xafdb192b,0x6ee002ae,0xa3c60790,0x7c2f0027}},	//   gfør, möbl, _उखड_, _pdcr, 
   {{0x11db0056,0x629a192c,0x768f004f,0x225e012b}},	//   _מחוב, lkto, _løyp, letk_, 
   {{0x213e192d,0x6fb9004f,0x00000000,0x00000000}},	// [fb0] luth_, _ігор_, --, --, 
   {{0x629a192e,0x60dd098d,0xa9c70a84,0x2efa040b}},	//   nkto, llsm, нсек, _gipf_, 
   {{0x649c0107,0xdeb2004e,0xb8120033,0x2bd100bd}},	//   _réin, _тұры, _হয়ত_, _थुरा, 
   {{0xb4ca0351,0x4c95192f,0x89341930,0x66df009e}},	//   लको_, _римс, اعلا, têko, 
   {{0x36690978,0x649c0038,0x442f1931,0x00000000}},	//   дало_, _péin, _rdg_, --, 
   {{0x442f1932,0x6e2702c7,0xd1380009,0x629a039b}},	//   _sdg_, najb, krą_, jkto, 
   {{0x6abf1933,0x64a51934,0x5692122f,0x442f1935}},	//   ्वीर, кака, рајт, _pdg_, 
   {{0x629a1936,0x291101d6,0x25ba1937,0xd1381938}},	//   ekto, _itza_, úpla_, drą_, 
   {{0x03220ee9,0x290301b5,0xc482022c,0x27ff0574}},	//   адын, _huja_, рлык, _igun_, 
   {{0x29031939,0x60d602ae,0x649c007a,0x60c4040b}},	//   _kuja_, _skym, _héil, _sjim, 
   {{0xa0a603dc,0x10a600dd,0x2903021e,0xbbde00ae}},	//   ванд, винн, _juja_, _मर्क, 
   {{0x92c300cc,0x2efa00ef,0x442f193a,0x2903193b}},	//   ্ষে_, _sipf_, _udg_, _muja_, 
   {{0x6265193c,0x6f63012d,0x68fb1484,0x68e9193d}},	//   _авла, авяз, _miud, _mhed, 
   {{0x764311f7,0xed5a193e,0x68fb0009,0x200b02a3}},	//   ngny, мог_, _liud, acci_, 
   {{0x2a6a02f6,0x63a9193f,0x29031940,0x60c40118}},	//   _rabb_, lzen, _nuja_, _tjim, 
   {{0xafdb08bb,0x3958016c,0x6fb60038,0x6cc301ff}},	//   rfør, _rprs_, _لمعا, айса, 
   {{0x63a91941,0x1eca0176,0xafdb14a4,0xab27149f}},	// [fc0] nzen, _олии_, sfør, кота_, 
   {{0x68e91942,0x63a901c8,0x27ff011c,0xafdb004f}},	//   _ahed, izen, _agun_, pfør, 
   {{0x6cc61943,0x68e900a1,0x29030165,0x68fb0009}},	//   _айна, _bhed, _cuja_, _biud, 
   {{0x68fb1944,0x779400d4,0x649c0038,0x6f040548}},	//   _ciud, هیزا, _céil, _kuic, 
   {{0x68e3010c,0x63a901c8,0x649c0038,0x68e91945}},	//   înda, jzen, _déil, _dhed, 
   {{0x63a91946,0x27ff0414,0x6d4e040b,0x533400f0}},	//   dzen, _egun_, otba, ңейт, 
   {{0xd9e604d7,0x68461947,0x649c00eb,0x2d981948}},	//   _करित_, _инва, _féil, nyre_, 
   {{0x68fb0141,0x68e91949,0x7afc194a,0x3eb8007a}},	//   _giud, _ghed, _hirt, hirt_, 
   {{0x69dc014e,0x7afc194b,0xbebb0034,0x6d4e194c}},	//   _hyre, _kirt, rrëz, htba, 
   {{0x7afc00a4,0xd9e60a34,0xd1380009,0x6d4e194d}},	//   _jirt, _करात_, trą_, ktba, 
   {{0x2d980034,0x63a900b4,0x7afc194e,0x00000000}},	//   jyre_, azen, _mirt, --, 
   {{0x6f0400eb,0x213e006c,0x2366194f,0x69dc1950}},	//   _buic, ruth_, _tsoj_, _myre, 
   {{0x63a90da6,0x7afc0a75,0xb4be1951,0x6d4e064e}},	//   czen, _oirt, ँची_, etba, 
   {{0x3eb8010c,0x6f041952,0x717400d7,0xf77300df}},	//   girt_, _duic, _مهتا, בקש_, 
   {{0x5c071953,0x69dc0075,0xb5fc003d,0x6e270082}},	//   вяза, _nyre, _baġi, rajb, 
   {{0x7afc0084,0x3eb80094,0x672d00e0,0x2fc9006d}},	//   _airt, airt_, šaji, _txag_, 
   {{0x649c00eb,0x29031954,0x68e90156,0x7afc1955}},	// [fd0] _réil, _suja_, _rhed, _birt, 
   {{0x29031956,0x6abf0a34,0x68fb0809,0x64950038}},	//   _puja_, ्वेर, _siud, _háit, 
   {{0x68e91957,0xdd9503fd,0x2d8c01e8,0x69dc1958}},	//   _phed, _саны, ødet_, _cyre, 
   {{0x69dc1959,0xf8d100cc,0x7afc195a,0x08d4017b}},	//   _dyre, িষ্ঠ, _eirt, ація, 
   {{0xab84195b,0x68fb195c,0x6f040068,0x3a23195d}},	//   _курк, _viud, _xuic, _tejp_, 
   {{0xf770195e,0x64950084,0x4aa713ec,0x69dc03a9}},	//   غان_, _láit, _गतिव, _fyre, 
   {{0x68e9195f,0x20d91960,0xe82701a2,0x6fd502e6}},	//   _thed, néis_, _афзо, _युसू, 
   {{0x200500ab,0x63a91961,0x7d051962,0xe8940009}},	//   ślij_, tzen, _muhs, _кась, 
   {{0x638302f1,0x63a91963,0xe8941964,0x610802d9}},	//   рҳла, uzen, _тать, _bělo, 
   {{0x63a91965,0x45451966,0x42c603dd,0x6908010e}},	//   rzen, _منطق, лгын_, _ördö, 
   {{0x63a91967,0x20d90126,0x7f4d0036,0x386d059e}},	//   szen, jéis_, _aqaq, _kaer_, 
   {{0x20d91968,0x237507cf,0x7f4d008a,0x386d1969}},	//   déis_, _ماتح, _bqaq, _jaer_, 
   {{0x6f0400a7,0x386d196a,0x7bdd0175,0x7d0502be}},	//   _quic, _maer_, _nysu, _auhs, 
   {{0x2d9800e5,0x66e300a2,0x386d0876,0x6d4e196b}},	//   tyre_, गतिक_, _laer_, ttba, 
   {{0xada31428,0x5187196c,0x09be00cc,0x6da3196d}},	//   барл, _шуда, _অর্থ, бира, 
   {{0x7afc196e,0x7d05023e,0x09e20033,0x6f04196f}},	//   _sirt, _duhs, _বললা, _tuic, 
   {{0x2d9e020b,0x7afc1970,0x09be1971,0x3eb8024a}},	// [fe0] šte_, _pirt, ्थ्य, pirt_, 
   {{0x0e661972,0x649c00eb,0x20d91973,0x9a6a031b}},	//   _скон, _réim, béis_, عمال_, 
   {{0x20d90bf1,0x7afc1974,0xddde01dd,0x649c007a}},	//   céis_, _virt, _sapņ, _séim, 
   {{0x7afc1975,0x386d1976,0x20d90038,0x69dc1977}},	//   _wirt, _caer_, léir_, _vyre, 
   {{0x7afc1978,0x386d1979,0x3ce0004f,0x7c260243}},	//   _tirt, _daer_, mliv_, _iekr, 
   {{0x356a0161,0x7afc0038,0x20d90038,0x387f0175}},	//   ерин_, _uirt, néir_, _enur_, 
   {{0x2aa4006b,0x64950084,0x7c26105b,0x386d00f3}},	//   _több_, _náis, _kekr, _faer_, 
   {{0xa01b197a,0x386d017c,0x8334197b,0xb4de009a}},	//   ljöv, _gaer_, аних, णते_, 
   {{0x649500eb,0x5c370070,0x00000000,0x00000000}},	//   _ráit, ארפן_, --, --, 
   {{0x4154197c,0x59b80bb9,0x326604fb,0xa5da0038}},	//   авос, _आधार, утив, _كبار_, 
   {{0x6e2501f0,0x4ea703dc,0xdd1200ad,0x7c2610f3}},	//   _rehb, ҳрва, _rüşv, _oekr, 
   {{0x7c2602f5,0x93e600cf,0x629d024a,0x7d05197d}},	//   _nekr, _йўлл, ësor, _ruhs, 
   {{0xe29a00e4,0x44260054,0xe0df02a3,0x91fc01dd}},	//   _пад_, _ieo_, rlò_, edāt, 
   {{0x20d9197e,0x4426197f,0x4ea71980,0x7c2601cf}},	//   téis_, _heo_, урма, _aekr, 
   {{0x44261981,0x254e00ad,0x6e251982,0x00000000}},	//   _keo_, _bəli_, _vehb, --, 
   {{0x4426090b,0x649500eb,0x6e25008a,0x20d91983}},	//   _jeo_, _háir, _wehb, réis_, 
   {{0x7c261984,0x20d91985,0x2d8c055f,0x44260108}},	// [ff0] _dekr, séis_, øder_, _meo_, 
   {{0x44261986,0x20d91987,0x39a7049b,0x7bdd0098}},	//   _leo_, péis_, лшев, _vysu, 
   {{0x64950038,0x7c2601f2,0x386d00b9,0xb5fc01f2}},	//   _máir, _fekr, _paer_, _kaġu, 
   {{0x4426004c,0x7c2601a9,0xb4c0000d,0xddde031e}},	//   _neo_, _gekr, ूको_, _např, 
   {{0xd3660817,0xddd706d0,0x2ca900eb,0x97d81988}},	//   _به_, _yaxş, mhad_, льшу_, 
   {{0x9a871989,0xca4900d4,0xd1260195,0x6495007a}},	//   _сумл, _جلسه_, _وم_, _náir, 
   {{0x4426198a,0x1ddb07d5,0x7c260216,0x35a5198b}},	//   _beo_, _मुमत, _yekr, райг, 
   {{0x4426015c,0xa4230033,0xf1cf198c,0x387f198d}},	//   _ceo_, ফল্য_, _सुगन, _unur_, 
   {{0x4426198e,0xd05d0095,0x730505b2,0x6495007a}},	//   _deo_, _üzər, јпоз, _báir, 
   {{0x649500e1,0x4426198f,0xe2990267,0x7eab0502}},	//   _páis, _eeo_, тао_, _hüpf, 
   {{0x00860b46,0x44261990,0x91e51991,0x332d1992}},	//   ално, _feo_, роне, ssex_, 
   {{0x672d1993,0x44261994,0x64950183,0x93590701}},	//   šaju, _geo_, _váis, _арку_, 
   {{0x81bd00cc,0x249f1995,0x20d9007a,0x248d00ca}},	//   _আরও_, mkum_, téir_, mjem_, 
   {{0xe2961996,0x249f1997,0x64950038,0x03a201a2}},	//   _ваш_, lkum_, _gáir, _фишо, 
   {{0x4426084c,0x20d900eb,0x3ce01950,0xb60600da}},	//   _yeo_, réir_, tliv_, _uváž, 
   {{0x44261998,0x64ba0405,0x2ca91999,0x249f003e}},	//   _xeo_, nċip, ghad_, nkum_, 
  
   {{0x3b07199a,0x644b199b,0x3b8602f1,0x2d8512b7}},	// [1000] ието_, _mcgi, шлаг, äler_, 
   {{0x3ce0199c,0x248d01e8,0x249f199d,0x3f8f02be}},	//   sliv_, hjem_, hkum_, _àgua_, 
   {{0x249f003e,0x7c2601f0,0x6459199e,0x186a1853}},	//   kkum_, _tekr, _obwi, кажи_, 
   {{0x315600c7,0x6d5e003d,0x2ca90014,0x248d0405}},	//   ייען_, _ippa, chad_, jjem_, 
   {{0x4426199f,0x91fc00e0,0x00000000,0x00000000}},	//   _reo_, ndār, --, --, 
   {{0x442619a0,0x645919a1,0xfaa6065b,0x1dbc02e6}},	//   _seo_, _abwi, _таго, ोपपत, 
   {{0x442619a2,0x26c00372,0xfc3f020b,0x00000000}},	//   _peo_, đio_, _ulíc_, --, 
   {{0xd766006b,0x44260415,0x2ca019a3,0x248d021e}},	//   _پارٹ, _qeo_, nkid_, gjem_, 
   {{0x442619a4,0x64950084,0xb5fc003d,0xf2c601a2}},	//   _veo_, _páir, _raġu, исон, 
   {{0x6d5e19a5,0x68e219a6,0x66e619a7,0xd257017b}},	//   _oppa, llod, _тоза, ацю_, 
   {{0x44260489,0x64a619a8,0x691300a4,0x6ecd00bd}},	//   _teo_, _кажа, _għed, _सदबु, 
   {{0xd83f0356,0x644b012b,0xd130010e,0x00000000}},	//   _účtu_, _gcgi, _ہمت_, --, 
   {{0x64950084,0x6d5e19a9,0xb05b0080,0x58f70147}},	//   _táir, _appa, snäo, ימטע_, 
   {{0x68e20149,0xd0650095,0x291a016a,0x539b00d1}},	//   hlod, _əsər, kppa_, _בידו, 
   {{0x3cf300a2,0xfc3f0126,0x2ca901c5,0x611300b3}},	//   ंगले_, _alía_, thad_, _căld, 
   {{0x20d20183,0x76b20083,0x0ca819aa,0xbd44007a}},	//   záiz_, pływ, атуи_, تنفي, 
   {{0x2ca919ab,0x5a3519ac,0x90a70019,0xb603014b}},	// [1010] rhad_, йнат, _محکم, áško, 
   {{0x66df0218,0xda780088,0x9b5801a2,0x2ca919ad}},	//   pêki, иях_, рифт_, shad_, 
   {{0xceb20138,0x83fd0019,0x249f19ae,0xfc3f0126}},	//   _זיי_, ndőr, ykum_, _elía_, 
   {{0x68e219af,0x00000000,0x00000000,0x00000000}},	//   glod, --, --, --, 
   {{0x7c2d19b0,0x69ce0d07,0x291a19b1,0xa01b02ae}},	//   maar, _exbe, appa_, ljös, 
   {{0x7c2d19b2,0xe5a51427,0x7b3d107c,0x00000000}},	//   laar, йили, _căuş, --, 
   {{0x248d008b,0xd57501f7,0x6d9e007b,0x637209c7}},	//   tjem_, суль, _għaġ, yınç, 
   {{0x7c2d19b3,0xc48519b4,0x6495007a,0x250a009c}},	//   naar, слик, _cáip, دروی_, 
   {{0xf773040f,0x248d19b5,0x657a02bf,0x249f19b6}},	//   _باز_, rjem_, _erth, rkum_, 
   {{0x249f19b7,0xd5bb00b3,0x777b00b4,0x00000000}},	//   skum_, _исе_, _irux, --, 
   {{0x7c2d19b8,0x6f1619b9,0x00000000,0x00000000}},	//   kaar, _styc, --, --, 
   {{0x7c2d19ba,0x645919bb,0x6f1600b4,0x00000000}},	//   jaar, _ubwi, _ptyc, --, 
   {{0x527304c5,0x7fd6005e,0x442d19bc,0xe28e049b}},	//   _ҳуқу, сіні, mae_, _еа_, 
   {{0x442d19bd,0x644919be,0xc7d6008d,0xd8390118}},	//   lae_, lgei, מורי_, _blōk_, 
   {{0x0d9908ad,0xf1cf0662,0x628319bf,0x7c2d19c0}},	//   атты_, _सुचन, _inno, faar, 
   {{0x7c2d19c1,0x644919c2,0xdd8f143f,0x442d0548}},	//   gaar, ngei, روق_, nae_, 
   {{0x09b500cc,0x2ca000e2,0x442d0183,0xbebb00e5}},	// [1020] _জুলা, rkid_, iae_, rsër, 
   {{0x442d19c3,0xe3a7006b,0x2ca019c4,0xe7db00aa}},	//   hae_, _ہر_, skid_, _बड़प, 
   {{0x7c2d12f4,0x442d19c5,0x9e7b00c7,0x6d5e19c6}},	//   baar, kae_, _ענטפ, _uppa, 
   {{0x6c8619c7,0x6e2e19c8,0x777b19c9,0xe3a70e61}},	//   _الحم, labb, _brux, _فر_, 
   {{0x62830511,0xb8d004cc,0xddd502d9,0x66e603e8}},	//   _onno, _ओत_, dezř, бода, 
   {{0xcd29086b,0x569303dc,0x6e2e19ca,0xa01b0219}},	//   _حسین_, зашт, nabb, njör, 
   {{0x64950038,0x2b4019cb,0xb9960038,0x7ea20054}},	//   _páip, lric_, _الزب, _rôpl, 
   {{0x628319cc,0x6e2e19cd,0x5fc8031e,0x290a012b}},	//   _anno, habb, रपाल, _iuba_, 
   {{0xdc9b0137,0x213e02bf,0x78a2014b,0x657a0156}},	//   טיקל, wrth_, mkov, _wrth, 
   {{0x290a1575,0x78a219ce,0x02c502f1,0x6e2e19cf}},	//   _kuba_, lkov, оқчи_, jabb, 
   {{0xd48f19d0,0x290a0077,0x442d0268,0x867b00a7}},	//   _ер_, _juba_, bae_, _תרבו, 
   {{0x7d1c014b,0x628301a3,0x232a19d1,0x2fc619d2}},	//   dprs, _enno, _боди_, _žoga_, 
   {{0x7c2d19d3,0x2bd80ede,0x439419d4,0x6e2e19d5}},	//   vaar, _भुला, _фалс, fabb, 
   {{0x291819d6,0x7c2d16af,0xae14051f,0x6e2e19d7}},	//   _otra_, waar, तुलन_, gabb, 
   {{0x7c2d19d8,0x6ca719d9,0x8af006d0,0xb05b0088}},	//   taar, браж, ktəb, nnäk, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7c2d19da,0x78a2026e,0x291819db,0x6e2e19dc}},	// [1030] raar, dkov, _atra_, babb, 
   {{0x7c2d19dd,0xff500038,0x442d19de,0x290a19df}},	//   saar, _أخي_, zae_, _buba_, 
   {{0x290a19e0,0x7c2d19e1,0x78a219e2,0x291806a5}},	//   _cuba_, paar, fkov, _ctra_, 
   {{0x6d4719e3,0xec6b170f,0x290a0474,0xfc3f02d9}},	//   muja, _срок_, _duba_, _zlín_, 
   {{0x6d550414,0x442d025b,0x660519e4,0x6d4719e5}},	//   ltza, vae_, опла, luja, 
   {{0x442d19e6,0x290719e7,0x2bc6031e,0x6d5519e8}},	//   wae_, ínas_, लपरा, otza, 
   {{0x6d550414,0x6d47008b,0x290a19e9,0x78a2014b}},	//   ntza, nuja, _guba_, bkov, 
   {{0x6e2e19ea,0x78a219eb,0x6d550a9f,0x67d519ec}},	//   zabb, ckov, itza, _добу, 
   {{0x442d19ed,0x6d4719ee,0x9868006b,0x78a90379}},	//   rae_, huja, _دینے_, _ilev, 
   {{0xadf9000f,0x27ed0a9f,0x644919ef,0x60cd19f0}},	//   ंधान_, _izen_, sgei, _ajam, 
   {{0x6e2e19f1,0x208a19f2,0x6113020f,0x71b50080}},	//   vabb, айни_, _sălb, ющих, 
   {{0x25d607f5,0x6d470187,0x3eba016a,0x50b601fc}},	//   _ווען_, duja, _smpt_, існу, 
   {{0x78a919f3,0x6e2e19f4,0x60cd19f5,0xa85600d1}},	//   _mlev, tabb, _djam, חירה_, 
   {{0x78a919f6,0x78a2026e,0x6113020f,0x6b8d00b4}},	//   _llev, zkov, _călc, dxag, 
   {{0x78a906d6,0xde0302fb,0x6e2e19f7,0xfc3f0183}},	//   _olev, дпри, rabb, _clío_, 
   {{0x290a19f8,0x8b260cf8,0x6e2e010e,0x2b4019f9}},	//   _ruba_, ждае, sabb, tric_, 
   {{0x78a219fa,0x290a19fb,0x3eba1415,0x7eab01f0}},	// [1040] vkov, _suba_, _tmpt_, _süpe, 
   {{0xa01b0219,0x61e3003e,0x78bb19fc,0x29180175}},	//   ljöp, _kynl, _amuv, _ptra_, 
   {{0x78a21194,0x78a90022,0x386619fd,0x2d78034c}},	//   tkov, _blev, teor_, _uče_, 
   {{0x290a0199,0x80370070,0x588303a1,0xb7e619fe}},	//   _vuba_, ַנצע_, дыша, ожек, 
   {{0x78a21194,0x61e302c9,0x8af000ad,0x236f018e}},	//   rkov, _lynl, rtəb, _nsgj_, 
   {{0x290a19ff,0x7b0903f9,0x649c00eb,0x65610175}},	//   _tuba_, _džud, _léit, _bplh, 
   {{0x98a61a00,0x78a21a01,0x27ed1a02,0x78a91a03}},	//   _диве, pkov, _ezen_, _flev, 
   {{0xf74603dc,0x32070379,0x74a900f0,0x78a900f6}},	//   _мебо, _agny_, йсың_, _glev, 
   {{0xccf302a1,0xf366004f,0x00000000,0x00000000}},	//   וכה_, ітин, --, --, 
   {{0x2904018e,0x60cd1a04,0xc1780028,0x78a902d9}},	//   _hima_, _sjam, tvė_, _zlev, 
   {{0x61e302f0,0x29041a05,0x52aa0790,0x649c007a}},	//   _cynl, _kima_, _छतीस, _béit, 
   {{0x29041a06,0x649c0354,0x61e303c6,0x00000000}},	//   _jima_, _céit, _dynl, --, 
   {{0x24861a07,0x29041a08,0x78fb027a,0x7e670144}},	//   _inom_, _mima_, יפטו, tejp, 
   {{0x26dc034c,0x6d471a09,0x6f1d01d2,0x00000000}},	//   novo_, tuja, rpsc, --, 
   {{0xdcbb1a0a,0x61e30156,0x361b0070,0x60cd084c}},	//   аща_, _gynl, שולד, _tjam, 
   {{0x5b1513d5,0x29041a0b,0x62981a0c,0x6d5502ba}},	//   змат, _nima_, _hovo, rtza, 
   {{0x629817cb,0x24860062,0x63a00ed0,0x6d551a0d}},	// [1050] _kovo, _mnom_, nymn, stza, 
   {{0x78a9000d,0x78bb0097,0x60dd1a0e,0xd3080023}},	//   _slev, _smuv, losm, _nệm_, 
   {{0x248604d1,0x29041a0f,0x89d900eb,0x26dc1a10}},	//   _onom_, _bima_, حوار_, dovo_, 
   {{0xf771057f,0x29040ec6,0x6f0d0010,0x62981a11}},	//   فات_, _cima_, _kuac, _lovo, 
   {{0x7c220503,0xf21b0035,0x78a902d9,0x0a6b0267}},	//   ñore, पुड़_, _vlev, _крви_, 
   {{0xd6db1a12,0x24861a13,0x6f0d00e7,0x29041a14}},	//   ште_, _anom_, _muac, _eima_, 
   {{0x6f0d009f,0x78a900ef,0x95cb01a2,0xa954004f}},	//   _luac, _tlev, шуда_, _окрі, 
   {{0x78bb0199,0x78a91a15,0x29040036,0x27ed01ca}},	//   _umuv, _ulev, _gima_, _tzen_, 
   {{0x6f0d0084,0x649c00eb,0x61e30310,0xf7700189}},	//   _nuac, _réit, _synl, _لال_, 
   {{0xd2a90088,0x649c0afb,0x62981a16,0x2486009c}},	//   ское_, _béis, _covo, _enom_, 
   {{0x62981a17,0x21691a18,0x2b490126,0x672900c3}},	//   _dovo, щини_, huac_, _hwej, 
   {{0x20090068,0x67291a19,0x6f0d161c,0x92cb0086}},	//   _cgai_, _kwej, _buac, লতে_, 
   {{0x61fe0076,0x7ea21606,0x2d850c17,0x09b80c73}},	//   _úpln, _hôpi, ålen_, _आध्य, 
   {{0x6f0d0348,0xe3b00a24,0x59bd00e6,0x523900c7}},	//   _duac, _جرم_, ्पार, _הײַנ, 
   {{0xb7bd00d9,0xf3f900d9,0x10a61a1a,0x91e21a1b}},	//   _deţi, deţi_, _никн, _поше, 
   {{0x649c00eb,0x6ab400a5,0x5f761a1c,0xac0a019c}},	//   _héir, ंफ्र, _فاخر, снаа_, 
   {{0x6b631a1d,0x69c30068,0x62980532,0x00000000}},	// [1060] нкта, únen, _yovo, --, 
   {{0x6d410084,0x2cab01e5,0x0f7b0225,0x29041a1e}},	//   álac, _elcd_, _פריל, _sima_, 
   {{0xfe9b00c7,0x5886013e,0x29041a1f,0x5e9b00d1}},	//   _היימ, зыла, _pima_, _הביק, 
   {{0x649c0084,0xe96a01a2,0x67291a20,0xa2bb1a21}},	//   _léir, _қабл_, _bwej, षोत्, 
   {{0x7c24047a,0x66e61a22,0xc7a30398,0x7eab01a4}},	//   mbir, пода, ницк, _hüpa, 
   {{0x7c240626,0xb603014b,0xf3f900d9,0x672900c3}},	//   lbir, _otáč, ceţi_, _dwej, 
   {{0x2904003a,0x6298015e,0x7d061a23,0x00000000}},	//   _tima_, _rovo, _kiks, --, 
   {{0x26dc0571,0x7c241a24,0x649c0387,0x6298056f}},	//   sovo_, nbir, _réis, _sovo, 
   {{0x62981a25,0x7d061a26,0xe6460d27,0xf7431a27}},	//   _povo, _miks, _неап, _пето, 
   {{0x2cfa051f,0x7d061a28,0x649c1a29,0x0bb700d1}},	//   ्दुल_, _liks, _céir, פלים_, 
   {{0xb7bd00d9,0x62980180,0x649c00e1,0x00000000}},	//   _reţi, _vovo, _déir, --, 
   {{0x7d061a2a,0x62981a2b,0x24860495,0x75d30038}},	//   _niks, _wovo, _unom_, _ثيما, 
   {{0x7c241a2c,0x62981a2d,0xdfdb0093,0x6f0d1502}},	//   dbir, _tovo, сън_, _quac, 
   {{0xd24f00b1,0x7c2402a5,0xdb230019,0x649c00e1}},	//   _منه_, ebir, ہوری, _géir, 
   {{0x7d060243,0x51861a2e,0xa2d908dd,0xf3f90474}},	//   _biks, _хула, नकर्, veţi_, 
   {{0x7c241a2f,0x6f0d1a30,0x2a7f0241,0x4c941a31}},	//   gbir, _tuac, _şub_, нисс, 
   {{0x2d8c1a32,0x3a7500cf,0x7d061a33,0xf3f9002e}},	// [1070] äder_, млар, _diks, teţi_, 
   {{0x0dcb1a34,0xa5771a35,0x7c2401a3,0x67291a36}},	//   _гуми_, ščić, abir, _rwej, 
   {{0x7c241a37,0xa9071a38,0xf3f9020f,0xa3de0110}},	//   bbir, سبان, reţi_, _दुस_, 
   {{0xe9f8004f,0x7ea20054,0x6ef202c9,0x58d40176}},	//   їнці_, _rôpi, ræbe, нохт, 
   {{0x3b640021,0x691300a4,0x2d571a39,0xf3f90474}},	//   _първ, _għen, lçe_, peţi_, 
   {{0x6447012d,0x451909fd,0x00000000,0x00000000}},	//   ėjim, оция_, --, --, 
   {{0x672400e0,0x2d571a3a,0x7c2f1a3b,0x00000000}},	//   ģija, nçe_, _kecr, --, 
   {{0xc95200a7,0x8af00248,0x6729052b,0x00000000}},	//   _שמן_, ntən, _twej, --, 
   {{0x2d5701f0,0x649c007a,0x7eb00080,0xb60300da}},	//   hçe_, _péir, _häpe, _stáč, 
   {{0x2d57027e,0x21a51a3c,0x99910604,0x957c0083}},	//   kçe_, диом, _zdzš_, _cząs, 
   {{0x3ce90300,0x904600d4,0xa06a00b3,0x00000000}},	//   klav_, ونده, оана_, --, 
   {{0xcea9162e,0x7c241a3d,0xb603020b,0xa8790070}},	//   _די_, xbir, _vtáč, קאָר, 
   {{0x7d061a3e,0x7c24009e,0x5f270176,0x00000000}},	//   _riks, vbir, моям_, --, 
   {{0x7d061a3f,0x442f1a40,0xc332027a,0x1d0a1a41}},	//   _siks, _heg_, _יוד_, жеви_, 
   {{0xfce61a42,0x7d0600c5,0x38600532,0x8af00248}},	//   дово, _piks, ŵiri_, ftən, 
   {{0x442f1a43,0x3ce91a44,0x2cfa0790,0x7c2f1a45}},	//   _jeg_, glav_, ्देल_, _cecr, 
   {{0x442f1a46,0x7c241a47,0x0c26004e,0x7c2f1a48}},	// [1080] _meg_, rbir, змұн, _decr, 
   {{0xa9a602f1,0x7c2411a9,0x7d0603a0,0x4a4303b7}},	//   мизд, sbir, _wiks, кнув, 
   {{0xa96a03b1,0x7d061a49,0xd910009c,0x00000000}},	//   تمام_, _tiks, ایر_, --, 
   {{0x442f06df,0x53ad0586,0x7c2f1a4a,0x3ce91a4b}},	//   _neg_, टनाश, _gecr, clav_, 
   {{0xd7f71a4c,0x69d51a4d,0xafdb0566,0x291c0528}},	//   муш_, _exze, lgør, ūva_, 
   {{0x442f0077,0xd7f9017b,0x64d61a4e,0x7c2f02a5}},	//   _aeg_, чує_, डक्श, _zecr, 
   {{0x442f1a4f,0xafdb0c85,0x443d008a,0x98560283}},	//   _beg_, ngør, _bdw_, _оташ, 
   {{0x442f006f,0xb05b0080,0x00000000,0x00000000}},	//   _ceg_, nnät, --, --, 
   {{0x442f1a50,0xfc3f003e,0x443d0090,0xd7080033}},	//   _deg_, _slík_, _ddw_, রীড়া_, 
   {{0x3958006d,0x6722011f,0x00000000,0x00000000}},	//   _kqrs_, mpoj, --, --, 
   {{0x6722002a,0x44240065,0x442f03c5,0x691301f2}},	//   lpoj, pbm_, _feg_, _nħel, 
   {{0x3f861a51,0x3cfa0035,0x2d57009e,0x2a78011c}},	//   _šoua_, ्दों_, vçe_, _larb_, 
   {{0xceeb17ba,0x5f941a52,0x7c2f1a53,0x26ce01d8}},	//   قرآن_, вият, _recr, onfo_, 
   {{0x442f012e,0x7c2f1a54,0x2d570241,0x2d810604}},	//   _zeg_, _secr, tçe_, _prhe_, 
   {{0x26ce1a55,0x9d180978,0xafdb055f,0x443d00f8}},	//   info_, дост_, ggør, _ydw_, 
   {{0x9f5500dd,0x2d571a56,0x2cb20156,0xec681a57}},	//   _звич, rçe_, ghyd_, мрук_, 
   {{0x7c220634,0x7c2f01dd,0xd1380028,0x7e77015c}},	// [1090] ñora, _vecr, lsą_, _taxp, 
   {{0x2d5704a8,0x8af00248,0xe9ab007a,0x48be0033}},	//   pçe_, stən, يدان_, ইকোর, 
   {{0x7c2f0908,0x2a781a58,0x3d250118,0x6913007b}},	//   _tecr, _darb_, _dèwò_, _għel, 
   {{0x2cb202bf,0x628a012b,0x2019010e,0x2a7800a1}},	//   chyd_, _lnfo, ncsi_, _earb_, 
   {{0x442f1a59,0xb8d70262,0x2366023b,0xe76b0071}},	//   _reg_, _छत_, _npoj_, تحان_, 
   {{0x442f0b0c,0x99670995,0xd1380028,0xddd5010e}},	//   _seg_, _отбл, ksą_, lező, 
   {{0x26c901b4,0xb05b17f8,0x00000000,0x00000000}},	//   đao_, nnäs, --, --, 
   {{0x628a1a5a,0x2ca902ae,0x66e50216,0x00000000}},	//   _anfo, nkad_, _bîkî, --, 
   {{0x442f1a5b,0xe3b10038,0x29110027,0x05df00c2}},	//   _veg_, طرة_, _huza_, _पुरब, 
   {{0x442f1a5c,0x291102b8,0x312505e6,0x75380175}},	//   _weg_, _kuza_, ндог, bsvz, 
   {{0x442f1a5d,0x2a630065,0x2f140219,0xc87906a2}},	//   _teg_, _mbjb_, _säg_, _kaş_, 
   {{0x8cc100aa,0x6e3e00ef,0x628a1a5e,0x442f00b9}},	//   रोमो, _sdpb, _enfo, _ueg_, 
   {{0xc00000cc,0xe3ae1a5f,0x6d411a60,0x2ca907fc}},	//   ূর্ণ_, _сб_, álan, dkad_, 
   {{0x539a1a61,0x2f14022b,0xafdb02c9,0xc8790218}},	//   _מינו, _väg_, tgør, _laş_, 
   {{0x2174004e,0x98a700bc,0x2911016c,0x9f6302d9}},	//   _ауыр, éně_, _nuza_, ěvák_, 
   {{0xfce60a43,0xfce30082,0xfe780028,0xde030176}},	//   хобо, госо, žį_, упси, 
   {{0xbb431a62,0xcb671a63,0x60c61a64,0x60d700d1}},	// [10a0] летк, нате_, mikm, _רופא_, 
   {{0xd9bd00aa,0x691300c3,0x60c61a65,0x29111a66}},	//   ्पूट, _iħej, likm, _buza_, 
   {{0xc8791a67,0xdca61a68,0xc8661a69,0x98a60c19}},	//   _baş_, _зани, етли, ниже, 
   {{0x60c60730,0x2ca9014e,0x6d4e1a6a,0x48be0033}},	//   nikm, ckad_, muba, ইক্র, 
   {{0x6d4e1a6b,0xb05b1a6c,0x7c361a6d,0xc87900ad}},	//   luba, onär, mayr, _daş_, 
   {{0x26ce1a6e,0x7e7c02fe,0xb05b1a6f,0x691300c3}},	//   unfo_, ndrp, nnär, _mħej, 
   {{0x23660588,0x2911090e,0x3ab300f0,0x550600b3}},	//   _spoj_, _guza_, _сәтт, нчиа, 
   {{0x6d5c1a70,0x672200c8,0x39470183,0xb05b0502}},	//   itra, ppoj, ánse_, hnär, 
   {{0x6d4e1a71,0x29111a72,0x68e200b0,0x6913008a}},	//   huba, _zuza_, mood, _nħej, 
   {{0x6d4e1a73,0x8af00095,0x66e90218,0x68e21a74}},	//   kuba, xtəl, rêkê, lood, 
   {{0xe3af040f,0x6d5c044e,0xc87903c0,0x6d4e1a75}},	//   لری_, jtra, _yaş_, juba, 
   {{0xe61f0029,0x6d5c1a76,0x68e21a77,0xd1380009}},	//   _đôi_, dtra, nood, rsą_, 
   {{0xb4be1a78,0xdefb0088,0x82a61a79,0x6d5c0c53}},	//   ुची_, зыв_, _падж, etra, 
   {{0x6d5c1a7a,0xbb1b010c,0x628a00d1,0xe2970726}},	//   ftra, _brîn, _unfo, _пач_, 
   {{0x6d5c1a7b,0x6d4e1a7c,0x6e351a7d,0xc27b00a7}},	//   gtra, guba, razb, _מרגי, 
   {{0xdef80405,0x8af00095,0x67200372,0x29111a7e}},	//   ċċa_, stəl, _otmj, _ruza_, 
   {{0x68e21a7f,0x29110062,0x6d5c1a80,0x2ca91a81}},	// [10b0] dood, _suza_, atra, rkad_, 
   {{0x6d4e1a82,0x2ca91a83,0x6b7400d3,0x9b44009c}},	//   buba, skad_, ылуу, انلو, 
   {{0xc9841a84,0x7c361a85,0xc8790218,0x6720011c}},	//   луци, bayr, _paş_, _atmj, 
   {{0xcd9600d1,0x61ea0118,0x7afe0ff2,0x00000000}},	//   _סדרת_, _myfl, ampt, --, 
   {{0x4c9a042c,0xd763009c,0xe6950080,0x00000000}},	//   _חברו, انتی, киды, --, 
   {{0xc7a21a86,0xc66802a6,0x64460313,0x29111a87}},	//   ришк, ешће_, ókin, _tuza_, 
   {{0xc879027e,0x68e208b0,0x20e109ec,0xd57506b3}},	//   _taş_, bood, नवाध, туль, 
   {{0xc48500a3,0x00000000,0x00000000,0x00000000}},	//   тлик, --, --, --, 
   {{0xa3de0262,0x6d4e1a88,0x77550cf8,0x67d41a89}},	//   _दुआ_, zuba, _шкаф, _боту, 
   {{0x6d4e1a8a,0xd7f30259,0x8cc10083,0x00000000}},	//   yuba, _азғы, रोतो, --, 
   {{0x26c71a8b,0x61ea02f0,0x60c61a8c,0x7c360102}},	//   mino_, _cyfl, tikm, yayr, 
   {{0xf485006b,0x6d5c1a8d,0x2b491a8e,0x3cf9040b}},	//   _جائی, vtra, krac_, _nhsv_, 
   {{0x7fd6005e,0x3f84031e,0xb05b0219,0x6d5c193d}},	//   тіні, ímu_, tnär, wtra, 
   {{0x6d5c1a8f,0x26c71a90,0x2b491a91,0x6d4e1a92}},	//   ttra, nino_, drac_, tuba, 
   {{0xed571a93,0x61ea02bf,0xb05b02ae,0x00000000}},	//   кор_, _gyfl, rnär, --, 
   {{0x6d4e1a94,0x26c71a95,0x6d5c1a96,0xf8db0299}},	//   ruba, hino_, rtra, यकोप, 
   {{0x26c71a97,0x6d4e1a98,0x387d00f8,0x8af000ad}},	// [10c0] kino_, suba, ddwr_, stəm, 
   {{0x26c71a99,0x7c360626,0x0f370070,0x00000000}},	//   jino_, sayr, _שריט_, --, 
   {{0xa3de000d,0x68e21a9a,0x3864084c,0xda650038}},	//   _दुई_, tood, _pbmr_, طالي, 
   {{0xd3080023,0xd9430e8f,0xca66040c,0xdca61a9b}},	//   _hệt_, реци, _etkа, _рами, 
   {{0x60c41a9c,0x00000000,0x00000000,0x00000000}},	//   _mmim, --, --, --, 
   {{0x26c713c6,0x65680065,0x68e21a9d,0xb05b0a1b}},	//   gino_, _ppdh, sood, hnäp, 
   {{0xceb30056,0xd30800e7,0xd5af0195,0xd04800ad}},	//   שיו_, _mệt_, يفه_, şməy, 
   {{0x98a31a9e,0xb4be10ae,0x00000000,0x00000000}},	//   _кисе, ुचे_, --, --, 
   {{0x26c71a9f,0x6ef202c9,0x98a31aa0,0xd4670bad}},	//   bino_, væbn, _тите, тиње_, 
   {{0x26c71aa1,0x60c40054,0x5f950176,0x00000000}},	//   cino_, _amim, ҳимт, --, 
   {{0x40351aa2,0xa3e702e6,0x3a3700d1,0x78a01aa3}},	//   ленс, _मुठ_, כרים_, _komv, 
   {{0x30a71aa4,0x93461aa5,0x6abf0586,0x03c5004e}},	//   тров, _анде, _एग्र, _өсім, 
   {{0x2d8c0c29,0x78a00532,0x644201cf,0x2d9e1aa6}},	//   åden_, _momv, _idoi, äten_, 
   {{0x41dd143e,0x60c401a3,0x00000000,0x00000000}},	//   _नुकस, _emim, --, --, 
   {{0x7b091aa7,0xd3080023,0x2d850038,0xeda41aa8}},	//   _džul, _dệt_, íle_, ашто, 
   {{0x78a01aa9,0x629a0571,0xf0470158,0x60d60034}},	//   _nomv, ljto, _рэко, _gjym, 
   {{0x09bd05d0,0x1be300aa,0x0bf51aaa,0x59d51aab}},	// [10d0] ्प्य, _कुशल_, упаю, _दशहर, 
   {{0x26c70068,0x3d951aac,0xdd03008f,0x6d481aad}},	//   xino_, _биор, ırıc, ádac, 
   {{0x26c71aae,0x81e40086,0x78a01aaf,0x6cd50eea}},	//   vino_, পের_, _bomv, _مقدا, 
   {{0x26c71ab0,0x6442007a,0x3cf60110,0x57b51ab1}},	//   wino_, _ndoi, ्षणे_, лбет, 
   {{0x78a00864,0x3ea1007e,0xff5f009e,0x7b090009}},	//   _domv, _koht_, ntî_, _užuo, 
   {{0x64420496,0x00000000,0x00000000,0x00000000}},	//   _adoi, --, --, --, 
   {{0x26c71ab2,0xfc3f0354,0x3ea1040c,0x00000000}},	//   rino_, _flít_, _moht_, --, 
   {{0xf773039f,0xff5f009e,0xe6f20210,0x00000000}},	//   _پار_, ktî_, _vườ, --, 
   {{0x26c71ab3,0x13091ab4,0xdce500e0,0xa0a61ab5}},	//   pino_, нний_, _arhī, ҳанд, 
   {{0xd7f81ab6,0x6b6701dd,0x78a00532,0x68fb052b}},	//   _рус_, mīgā, _zomv, _hhud, 
   {{0xa0a61ab7,0x24550071,0x68fb1ab8,0x27fa00ab}},	//   ганд, _مناس, _khud, ępne_, 
   {{0xff5f010c,0x5fc500b0,0xd3080108,0x00000000}},	//   ftî_, _लेहल, _sệt_, --, 
   {{0x7ae51ab9,0x27ed0118,0x68fb095a,0x6b670243}},	//   koht, _jyen_, _mhud, nīgā, 
   {{0x290d0226,0x7ae500c8,0x63a91aba,0x63bb095a}},	//   _liea_, joht, myen, mzun, 
   {{0xdefa032e,0x27ed158b,0x270f00c6,0xc87901f0}},	//   дың_, _lyen_, ादुर_, _ekşi_, 
   {{0xeb9a12e1,0x7b091612,0x60c41abb,0x27ed0126}},	//   ниб_, _džum, _umim, _oyen_, 
   {{0x63bb1abc,0x8b26012d,0x27ed1abd,0xf4120070}},	// [10e0] nzun, удзе, _nyen_, מפן_, 
   {{0xfeba00c5,0x68e90589,0x63bb1abe,0x68fb1abf}},	//   _ساخت_, _aked, izun, _ahud, 
   {{0x27ed05d5,0x09f61730,0x78a0019b,0x8cc10249}},	//   _ayen_, учая, _pomv, रोहो, 
   {{0xd7fa1ac0,0x270f0081,0x68fb1ac1,0x7e7e1ac2}},	//   нул_, ादूर_, _chud, _happ, 
   {{0x7e7e1ac3,0x96ea1619,0x68fb01e5,0x3d1a0d2e}},	//   _kapp, нька_, _dhud, _मंडे_, 
   {{0x7e7e0405,0xddc71ac4,0x68e9084c,0x78a0019b}},	//   _japp, lejš, _eked, _womv, 
   {{0x7e7e1ac5,0x7b091799,0xd639004f,0x1c1e0ba3}},	//   _mapp, _ožuj, тячі_, युअल_, 
   {{0xddc71ac6,0x3a3a1ac7,0x63bb0502,0x00000000}},	//   nejš, lapp_, fzun, --, 
   {{0xa3de0509,0x63a91ac8,0xff5f0216,0xa3e701a4}},	//   _दुख_, gyen, xtî_, _मुद_, 
   {{0x7e7e1ac9,0xf1261aca,0x77c71acb,0x2258035d}},	//   _napp, льмо, _слуг_, ürk_, 
   {{0xc610017d,0x6b8400c2,0x63a9040b,0xa5261acc}},	//   ाशीय_, hvig, ayen, _смед, 
   {{0x657a011c,0x7e7e1acd,0x63a91ace,0x6f160354}},	//   _isth, _aapp, byen, _buyc, 
   {{0x7e7e02a2,0xdb041acf,0xa29408af,0x4fc71ad0}},	//   _bapp, nzió, _валі, усна, 
   {{0xff5f078a,0x7e7e1ad1,0x00000000,0x00000000}},	//   rtî_, _capp, --, --, 
   {{0xff5f055a,0x7e7e1ad2,0xccfb0886,0x291c0098}},	//   stî_, _dapp, ећа_, íval_, 
   {{0x61f51ad3,0x00000000,0x00000000,0x00000000}},	//   üzle, --, --, --, 
   {{0x5a351ad4,0x7afc00a1,0x00000000,0x00000000}},	// [10f0] инат, _bhrt, --, --, 
   {{0x68e91ad5,0x68fb0104,0x290d07d7,0x6113020f}},	//   _sked, _shud, _siea_, _săli, 
   {{0xdd95005e,0x657a0201,0x4975004e,0x7ae51ad6}},	//   _таны, _nsth, рлес, roht, 
   {{0xf7710523,0x7e7e1ad7,0xddc71ad8,0x4bc5013e}},	//   قات_, _zapp, cejš, _көзг, 
   {{0x69dc06a5,0x2ab60566,0x4e191ad9,0x00000000}},	//   _exre, _sæbe_, _दलाई_, --, 
   {{0x6b6700e0,0xe4630585,0x89370296,0x63bb1ada}},	//   rīgā, şmüş, _معرا, vzun, 
   {{0x7d0f006b,0x5e5800c7,0x290d0415,0x68fb1adb}},	//   _kics, טיגע_, _tiea_, _thud, 
   {{0x63bb1adc,0x58d500dd,0x68fb1add,0x3f8900f8}},	//   tzun, _тобт, _uhud, _orau_, 
   {{0x3f89006d,0x7c2d1ade,0xe2990097,0x27ed0108}},	//   _nrau_, ibar, вап_, _uyen_, 
   {{0x7c2d00cf,0x52a91adf,0x63a91ae0,0x387f1ae1}},	//   hbar, твом_, ryen, _haur_, 
   {{0x63a91ae2,0x7c2d1ae3,0x7e7e1ae4,0x3f8901f1}},	//   syen, kbar, _rapp, _arau_, 
   {{0x7e7e1ae5,0x7c2d00ab,0xf8b5034d,0x3f891ae6}},	//   _sapp, jbar, ंसिय, _brau_, 
   {{0x442d1ae7,0x7e7e1ae8,0xddc71ae9,0x387f1aea}},	//   mbe_, _papp, vejš, _maur_, 
   {{0x442d1aeb,0xf306010c,0x387f1aec,0x7b090082}},	//   lbe_, şûrê_, _laur_, _džuk, 
   {{0x3f89002e,0x3c420019,0xddc70217,0x7c2d1aed}},	//   _erau_, _lévő_, tejš, fbar, 
   {{0x442d0cd7,0x3f890321,0xed5703b7,0x387f0175}},	//   nbe_, _frau_, јот_, _naur_, 
   {{0x3f891aee,0x7e7e1aef,0xddc702ee,0x7a400bdb}},	// [1100] _grau_, _tapp, rejš, játí, 
   {{0x6b841af0,0x62811af1,0xaa461af2,0x00000000}},	//   rvig, ndlo, режл, --, 
   {{0x6e3c0075,0x7c2d1af3,0x2d850cac,0x7d0f0557}},	//   marb, bbar, ålet_, _fics, 
   {{0x442d1af4,0x6e3c1af5,0x57a602f1,0x387f01dd}},	//   jbe_, larb, ишла, _caur_, 
   {{0x7d041af6,0x442d1af7,0xdddc0019,0x387f1af8}},	//   mmis, dbe_, merő, _daur_, 
   {{0x7d041af9,0x6b8b01cc,0x442d1afa,0x6e3c1afb}},	//   lmis, ægge, ebe_, narb, 
   {{0x38560093,0xb5a303a1,0x387f107c,0x00000000}},	//   _възс, жрый, _faur_, --, 
   {{0x387f02ba,0xa3e70262,0x6e3c1afc,0x48e31afd}},	//   _gaur_, _मुह_, harb, _досв, 
   {{0x7d041afe,0x291801f1,0x649c0183,0x38661aff}},	//   imis, _hura_, _méix, mfor_, 
   {{0x29181b00,0x7c2d1b01,0xf2061b02,0x6d4118b9}},	//   _kura_, zbar, ияно, šlai, 
   {{0x6e3c1b03,0x442d1b04,0x29181b05,0x7b0900ef}},	//   darb, bbe_, _jura_, _džuh, 
   {{0x38661b06,0x29181b07,0x7c2d1b08,0xd57700a7}},	//   nfor_, _mura_, xbar, _כתבה_, 
   {{0x2918003d,0x7d04007e,0x6e3c1b09,0x6d481b0a}},	//   _lura_, dmis, farb, ádan, 
   {{0xa1581b0b,0x6e3c1b0c,0x7d041b0d,0x3f890034}},	//   _баку_, garb, emis, _vrau_, 
   {{0x7d0f1b0e,0x02fb07e4,0x29181b0f,0x7d040b41}},	//   _pics, _שלומ, _nura_, fmis, 
   {{0x7d041b10,0xb0351b11,0x7c2d1b12,0xc0351b11}},	//   gmis, _униш, ubar, _униј, 
   {{0x7c2d1b13,0x29181b14,0x2fcf014e,0x649c0042}},	// [1110] rbar, _aura_, _ägg_, _déix, 
   {{0x442d1b15,0x7c2d1b16,0x19ab1b17,0x387f005f}},	//   zbe_, sbar, ктеп_, _saur_, 
   {{0x29181b18,0x7c2d1b19,0x442d1b1a,0x3a381b1b}},	//   _cura_, pbar, ybe_, _derp_, 
   {{0x38690679,0x7c9500eb,0x9b6b02f1,0x6d551b1c}},	//   ýar_, _الحص, _ишга_, muza, 
   {{0x3cf404d7,0x29180eae,0x2b4400b9,0x7bd801f0}},	//   ंतरे_, _eura_, _мэрг, şvur, 
   {{0x29181b1d,0x442d0237,0x1fd90033,0x69c30068}},	//   _fura_, wbe_, _সরাস, únes, 
   {{0x20d20039,0x27fa00ab,0x29181b1e,0x6a22006b}},	//   lšie_, ępna_, _gura_, _رہنم, 
   {{0x442d01c4,0x3a3800ca,0x6e3c1b1f,0x9dd800d1}},	//   ube_, _zerp_, zarb, יווק_, 
   {{0x6e3c1b20,0x7c220634,0x6d551b21,0x29181b22}},	//   yarb, ñori, huza, _zura_, 
   {{0x442d1b23,0x6d551b24,0x62810102,0x29181b25}},	//   sbe_, kuza, udlo, _yura_, 
   {{0x62811b26,0x7d041b27,0x20d20228,0x29180183}},	//   rdlo, ymis, hšie_, _xura_, 
   {{0x6d550068,0x349406d4,0x6e3c010c,0x24190080}},	//   duza, _махр, warb, _соды_, 
   {{0x20d20039,0x6e3c1b28,0xa0a61753,0xfbc7017d}},	//   jšie_, tarb, _ҳайд, _रेलम, 
   {{0xed5a1b29,0x249f1b2a,0x6d551b2b,0x6da61b2c}},	//   лог_, ljum_, fuza, бига, 
   {{0x7d040077,0xa0a61b2d,0x6e3c1b2e,0x6d551b2f}},	//   tmis, _гайд, rarb, guza, 
   {{0x6e3c1b30,0x3a381b31,0xceb400ad,0x6d4e1b32}},	//   sarb, _serp_, _atət_, rrba, 
   {{0x7e75173b,0x29181b33,0x6a160b7e,0x22470640}},	// [1120] bezp, _sura_, مبار, _kdnk_, 
   {{0x3f8f03b7,0x6d551b34,0x7d041b35,0x2b400474}},	//   _água_, buza, smis, rsic_, 
   {{0x8fc500d4,0x5d8600eb,0x249f003e,0xd23a0070}},	//   _هزین, _الجل, kjum_, רגעל, 
   {{0xb4c60790,0x3a380b22,0x20d2020b,0x29181b36}},	//   _उगे_, _werp_, bšie_, _vura_, 
   {{0x26c8005e,0x38661b37,0xdd8f0444,0xa3e71b38}},	//   аған_, rfor_, _قوی_, _मुल_, 
   {{0xe9440296,0x00000000,0x00000000,0x00000000}},	//   _ورزی, --, --, --, 
   {{0x05861b39,0x237d00e2,0xaadd00a2,0x249f01d5}},	//   сулм, _aswj_, _मदतक, fjum_, 
   {{0x249f01d5,0x00000000,0x00000000,0x00000000}},	//   gjum_, --, --, --, 
   {{0x64a61b3a,0x6d551b3b,0x644f1b3c,0x00000000}},	//   _қада, zuza, ócia, --, 
   {{0x2561006b,0xe6431b3d,0x224700b4,0x290601d6}},	//   ból_, _неуп, _cdnk_, lmoa_, 
   {{0xf09f00d3,0x764802bf,0xf4861753,0xd6cf149e}},	//   tjà_, _iddy, _гулн, _ثقل_, 
   {{0x2ca01b3e,0x26ce1b3f,0x6d550027,0x00000000}},	//   jjid_, lifo_, vuza, --, 
   {{0x33f6105a,0xc7b40070,0x2ca01032,0x7e7501d6}},	//   _اساس, קבֿ_, djid_, tezp, 
   {{0x20d20187,0x6d551b40,0x3d9500c8,0x3d1100c9}},	//   všie_, tuza, оигр, _दूजे_, 
   {{0x3b1100a3,0x00000000,0x00000000,0x00000000}},	//   _rizq_, --, --, --, 
   {{0x6ca41b41,0x6d551b42,0x8cf50c8b,0x26ce1b43}},	//   пруж, ruza, ізац, hifo_, 
   {{0xab870141,0x7b141a68,0x76481308,0x5b1419fe}},	// [1130] щувк, здух, _oddy, змут, 
   {{0x20d20228,0x705504f2,0x6d550610,0x249f0035}},	//   ršie_, _انکا, puza, zjum_, 
   {{0xceb207e4,0x69c80588,0x2d87039b,0x249f01d5}},	//   _חיי_, _žder, _éne_, yjum_, 
   {{0x764802bf,0x20d20187,0x515b035c,0x8af00248}},	//   _addy, pšie_, רכאו, ftəs, 
   {{0xf74500d9,0x291e0183,0x6561023e,0x75280243}},	//   цело, _étan_, _sqlh, _atdz, 
   {{0x2561006b,0x79820035,0xf7701b44,0x7f3c0070}},	//   tól_, łowa, عان_, נעוו, 
   {{0x79a4004e,0x04590038,0x00000000,0x00000000}},	//   _ерте, للغة_, --, --, 
   {{0xc3251b45,0x2561006b,0x03251b46,0x7eab00b0}},	//   омик, ról_, один, _küps, 
   {{0x7b0900ef,0x249f008c,0x386d1b47,0xd299004f}},	//   _džuv, rjum_, _iber_, атні_, 
   {{0x02c502fb,0x68eb039b,0x42c91b48,0x63a60219}},	//   ійно, logd, ргон_, äkna, 
   {{0xe0da1b49,0x21691b4a,0xd4e702fb,0x2bd00527}},	//   иво_, шини_, _люди, _सेना, 
   {{0xd00a1b4b,0x237d01a0,0x60cf0151,0x672900c3}},	//   иене_, _tswj_, gicm, _ktej, 
   {{0x443f1b4c,0x332b069b,0x6d450946,0xe9ff0108}},	//   mau_, _сцен_, _avha, _trặc_, 
   {{0x443f1b4d,0x645b1b4e,0x67291b4f,0x9983008a}},	//   lau_, lgui, _mtej, _bejż_, 
   {{0x2d8c1b50,0x386d1b51,0x62831b52,0xa1560267}},	//   íde_, _ober_, _iano, _дају_, 
   {{0x443f1b53,0x628305f0,0xed5a07f9,0x3f860082}},	//   nau_, _hano, лоҳ_, _šouu_, 
   {{0x5aca12d2,0x62831b54,0xeab20019,0x7eb000c8}},	// [1140] алам_, _kano, وٹر_, _läpi, 
   {{0x386d02e7,0x443f1b55,0x2ca0156e,0x62831b56}},	//   _aber_, hau_, sjid_, _jano, 
   {{0x443f1b57,0xdca60577,0xb05b014e,0x6d410019}},	//   kau_, _дани, miär, álat, 
   {{0x186a1b58,0x443f1b59,0xb05b06ce,0x61ee06ce}},	//   ради_, jau_, chäd, übli, 
   {{0x443f1b5a,0x27e01b5b,0xd70a1b5c,0x4733004f}},	//   dau_, çin_, анде_, дніс, 
   {{0x62831b5d,0x29060a9f,0x386d011d,0x9f610019}},	//   _nano, smoa_, _eber_, ését_, 
   {{0x68eb1b5e,0x443f0156,0xe1e7195e,0x7c240036}},	//   bogd, fau_, _آس_, ocir, 
   {{0x443f02bf,0x20050095,0x26ce00b4,0x636a0bad}},	//   gau_, əlif_, sifo_, арог_, 
   {{0x62831b5f,0x7c2400ca,0x6913008a,0x8af000ad}},	//   _bano, icir, _għeq, qtəs, 
   {{0x62830090,0x78a204cb,0x645b0deb,0x386d0032}},	//   _cano, ljov, agui, _zber_, 
   {{0x443f1b60,0xe29a00f7,0x69c11b61,0x8af000ad}},	//   bau_, _chưa_, _žlez, ntəq, 
   {{0x78a21b62,0x62830415,0xbb1b009e,0x00000000}},	//   njov, _eano, _krît, --, 
   {{0x62831b63,0x64401b64,0xe3b21b65,0x5fc500bc}},	//   _fano, mami, _ترا_, _लेखल, 
   {{0x62831b66,0x7c261b67,0x92571b68,0xfbdf0090}},	//   _gano, _afkr, _дашт_, _ddêl_, 
   {{0xeca70843,0x9c8300bc,0x64400548,0x442602a5}},	//   ојан, íčov, oami, _kfo_, 
   {{0x6aaa01c4,0x44240096,0xac941b69,0x00000000}},	//   öffn, ncm_, масш, --, 
   {{0x62831b6a,0xdfd1030e,0x26cc1b6b,0x00000000}},	// [1150] _yano, _سيد_, _omdo_, --, 
   {{0x64401b6c,0x4424001b,0x443f1b6d,0xba98004f}},	//   hami, hcm_, zau_, овує_, 
   {{0xceb207f5,0x64401b6e,0x6729000d,0xe2a6010d}},	//   _ניט_, kami, _stej, _áður_, 
   {{0x5d7a00c7,0xbb1b010c,0x443f023b,0x2d811b6f}},	//   _פארק, _brît, xau_, _ishe_, 
   {{0x64401b70,0x443f012d,0x7b640cf8,0x60cd1b71}},	//   dami, vau_, _отре, _mmam, 
   {{0x8af006d0,0x442600a9,0x443f1b72,0x7c3d12ed}},	//   stər, _afo_, wau_, _hesr, 
   {{0x443f1b73,0x628300a9,0x7c3d1b6b,0x60cd1b74}},	//   tau_, _rano, _kesr, _omam, 
   {{0x64401b75,0x62831b76,0x44261b77,0x16190035}},	//   gami, _sano, _cfo_, दशहर_, 
   {{0x443f02f0,0x7c3d1b78,0x20d20228,0x4426084c}},	//   rau_, _mesr, jšia_, _dfo_, 
   {{0x443f1b79,0x78a9051e,0x60cd1b7a,0x628300a3}},	//   sau_, _hoev, _amam, _qano, 
   {{0x62831b7b,0x443f1b7c,0x64401b7d,0x78a91b7e}},	//   _vano, pau_, bami, _koev, 
   {{0x62831b7f,0xe1f800d3,0x44240548,0x00000000}},	//   _wano, өгө_, ccm_, --, 
   {{0x62831b80,0xa29500dd,0x7c241b81,0x78bb031e}},	//   _tano, _наді, vcir, _mluv, 
   {{0x78bb08f4,0x443d0218,0xe29a00e7,0x2bef00b0}},	//   _lluv, _hew_, _thưa_, _आड़ू_, 
   {{0xde031b82,0x443d0300,0x6da61b83,0x7c3d0588}},	//   епри, _kew_, чива, _besr, 
   {{0xdca31b84,0x61fc01f0,0x8b260810,0xc5f200d1}},	//   наси, ürle, здае, גדל_, 
   {{0xeb971b85,0x6d4101d5,0x945d0083,0x5f46152c}},	// [1160] пит_, álar, lińs, _عندل, 
   {{0x443d1b86,0x09e61a9e,0x7c241b87,0x7c3d01a4}},	//   _lew_, позн, scir, _eesr, 
   {{0x64401b88,0x78a20126,0x78a901d2,0x00000000}},	//   yami, tjov, _boev, --, 
   {{0x443d0052,0x6e3e0175,0x64401b89,0x60cd0065}},	//   _new_, _hepb, xami, _xmam, 
   {{0x64401b8a,0x8af00095,0x6b8900ca,0x7d1e1b8b}},	//   vami, stəq, _šegv, _hups, 
   {{0xab27048a,0x64401b8c,0xd9460161,0x7d1e0532}},	//   _хора_, wami, _неги, _kups, 
   {{0x64401b8d,0x09e31b8e,0xeab71b8f,0x44240183}},	//   tami, _зорн, _эйр_, tcm_, 
   {{0x443d016a,0x78bb1b90,0x89db00d1,0x00000000}},	//   _cew_, _gluv, _החלי, --, 
   {{0x64401b91,0xe737030f,0x68e31b92,0x443d17e3}},	//   rami, _нет_, énde, _dew_, 
   {{0xbebb0034,0xa01b1618,0x6e3e039b,0x78a9039b}},	//   hpër, rdöm, _nepb, _zoev, 
   {{0x443d00a7,0x705517bc,0x7d1e01a4,0x00000000}},	//   _few_, وندا, _nups, --, 
   {{0x443d1b93,0xdfd5012d,0x644001ff,0x69c100c2}},	//   _gew_, домы, qami, _ülee, 
   {{0x2d8c02c9,0xdcb10023,0x00000000,0x00000000}},	//   æden_, ểm_, --, --, 
   {{0x7bc41b94,0x20d21b95,0x7c3d1b96,0x00000000}},	//   dziu, ršia_, _sesr, --, 
   {{0x443d1b97,0xdd941b98,0x290400ca,0x9cf508af}},	//   _yew_, нары, _ohma_, дзві, 
   {{0x60cd1b99,0x443d0216,0x20d20032,0x62881b9a}},	//   _umam, _xew_, pšia_, lddo, 
   {{0x2bc70aac,0x5b1503dc,0x9f54012d,0xfbd31897}},	// [1170] _रेखा, дмат, _звыч, رتر_, 
   {{0x7b090571,0x62881b9b,0x2d81023b,0xf8b50299}},	//   _ažur, nddo, _tshe_, ंस्प, 
   {{0x2d8c0533,0x60dd1b9c,0x2d9e02ae,0x7bc4107c}},	//   ådet_, onsm, ätet_, aziu, 
   {{0x6d550b1d,0x31570070,0x60dd1b9d,0x29041b9e}},	//   mrza, ליבן_, nnsm, _chma_, 
   {{0x7b0900ef,0x62980af8,0x443d03c6,0x2bc81b9f}},	//   _džur, _onvo, _rew_, _еуро_, 
   {{0x443d003d,0x6b8d02b8,0x00000000,0x00000000}},	//   _sew_, mvag, --, --, 
   {{0x58d502fb,0x78a90265,0x6f170126,0x7c221ba0}},	//   _жовт, _toev, _mixc, žore, 
   {{0xe3b91ba1,0x6add02e6,0x6288017c,0x6d48007a}},	//   жби_, _मदुर, eddo, ádai, 
   {{0xa3e707cc,0xf7700040,0x27ff1ba2,0x62881ba3}},	//   _मुख_, _مال_, _uzun_, fddo, 
   {{0x443d1ba4,0x25e802c3,0xfc3f1ba5,0x04fd0033}},	//   _wew_, _चुकी_, _leí_, ঁদের_, 
   {{0x76431ba6,0x443d00f3,0x41b411e7,0x6d550035}},	//   many, _tew_, есят, jrza, 
   {{0x62981ba7,0x6d551993,0x76431ba8,0x644b01cc}},	//   _envo, drza, lany, _udgi, 
   {{0x7d1e003a,0x6d550083,0x945d0083,0x00000000}},	//   _sups, erza, sińs, --, 
   {{0x76431ba9,0xe299002e,0xa3d3059e,0x7bc40034}},	//   nany, _фак_, _हेय_, vziu, 
   {{0x9fa01baa,0x00000000,0x00000000,0x00000000}},	//   _méér_, --, --, --, 
   {{0x76431bab,0xc10600eb,0x7bc400b4,0x00000000}},	//   hany, _توبي, tziu, --, 
   {{0x76431bac,0xbb431bad,0xbebb024a,0x6d4700b0}},	// [1180] kany, кетк, rpër, asja, 
   {{0x76430f80,0x290400a3,0x0f5700d1,0xae22017d}},	//   jany, _shma_, _קיים_, _मलिन_, 
   {{0x76431bae,0x673b00d4,0x7e7c1baf,0x5e9b00d1}},	//   dany, _awuj, merp, _וביק, 
   {{0x6d5c1bb0,0x673b016c,0x395a1bb1,0xbebb021e}},	//   mura, _bwuj, rups_, qpër, 
   {{0x76431bb2,0x6d5c12e6,0x628802f0,0xb90609e2}},	//   fany, lura, yddo, _पद_, 
   {{0x395a1bb3,0x76431bb4,0x3ced044e,0x07a302a6}},	//   pups_, gany, čeve_, таљн, 
   {{0x6d5c1bb5,0xf9831bb6,0x7e7c040b,0x00000000}},	//   nura, _игро, ierp, --, 
   {{0x2ebb075a,0x7e7c1bb7,0x7b090613,0x764302a5}},	//   _उत्त, herp, _užur, aany, 
   {{0x76431bb8,0x13f41bb9,0x00000000,0x00000000}},	//   bany, эзия, --, --, 
   {{0xd25000c5,0x7643024d,0xeb9100c7,0x7e7c017b}},	//   دند_, cany, אָט_, jerp, 
   {{0x628802bf,0x7e7c1bba,0x24861bbb,0x20d2035f}},	//   rddo, derp, _taom_, ršin_, 
   {{0x6d5c1bbc,0x67200548,0x04930038,0x9fa001d2}},	//   dura, _kumj, _للمح, _zéér_, 
   {{0x6f17016a,0xfc3f0126,0x60dd1bbd,0x20d20082}},	//   _pixc, _reí_, rnsm, pšin_, 
   {{0x6d5c0010,0x62981bbe,0x7e7c1bbf,0x6d471bc0}},	//   fura, _unvo, gerp, tsja, 
   {{0xf1a202e6,0x9f99040b,0x291e0096,0x00000000}},	//   _ओपिन, _dáár_, _étah_, --, 
   {{0x76431bc1,0x6d471bc2,0x20c20038,0xfe7703a1}},	//   zany, rsja, _cóid_, чүү_, 
   {{0x76431bc3,0x2d9e02f2,0x2d8c03a9,0x6d471bc4}},	// [1190] yany, äter_, åder_, ssja, 
   {{0x6d5c1bc3,0x9af500eb,0xf3880108,0x673b016c}},	//   bura, ركات, _mợ_, _rwuj, 
   {{0x76431bc5,0x6d5c1bc6,0x6b8d1bc7,0xc9840a10}},	//   vany, cura, svag, куци, 
   {{0x2bd01bc8,0x76431bc9,0xe0df01d8,0x69c502eb}},	//   _सेवा, wany, nnò_, rzhe, 
   {{0x7d0d1bca,0x76431bcb,0xf388001b,0xd629124e}},	//   mmas, tany, _nợ_, поле_, 
   {{0x7d0d1bcc,0xddde1bcd,0x66051bce,0x7dc30104}},	//   lmas, _hapš, нпла, _fеst, 
   {{0x76431bcf,0x492301a2,0x00000000,0x00000000}},	//   rany, _рӯзҳ, --, --, 
   {{0x7d0d1bd0,0x76431bd1,0xb3851bd2,0x23351a57}},	//   nmas, sany, елил, нхор, 
   {{0x76431bd3,0x7d0d1bd4,0x3755009c,0x76751bd5}},	//   pany, imas, _سپاس, _плаф, 
   {{0x1306030f,0x6d5c1bd6,0x25680218,0x7d0d1bd7}},	//   нный_, yura, bûl_, hmas, 
   {{0xe4a71bd8,0xd12e015d,0x7d0d1bd9,0xe1f9012d}},	//   _ордо, یمی_, kmas, яго_, 
   {{0x76410105,0xf9920137,0x2ec8130c,0x3cfb0035}},	//   _hely, ארט_, रफ्त, ्षों_, 
   {{0x42cd0086,0x6d5c1bda,0x76411bdb,0xbebb0034}},	//   রকৌশ, wura, _kely, rqën, 
   {{0x91e50ee8,0x6d5c1bdc,0xe0df0036,0x3ebe003e}},	//   _поле, tura, anò_, ótt_, 
   {{0x76411bdd,0xa3d302e6,0x7c361bde,0xc5f20070}},	//   _mely, _हेत_, tbyr, ָדן_, 
   {{0x7d0d1bdf,0x76411be0,0x7af502a5,0x7f5d0106}},	//   gmas, _lely, _akzt, busq, 
   {{0x6d5c1be1,0x245a027e,0x6b890613,0x75210034}},	// [11a0] sura, lümü_, _šegr, _lulz, 
   {{0x160f0827,0xb05b1709,0x7d0d1be2,0xea871be3}},	//   ाधार_, nhän, amas, нбул_, 
   {{0x6d5c1be4,0x8c460ca6,0x67200242,0x245a06a2}},	//   qura, _пене, _sumj, nümü_, 
   {{0x7eb0007e,0x22451be5,0x20d2044e,0x00000000}},	//   _täps, halk_, kšim_, --, 
   {{0x20d2008b,0xa2b4031e,0x2b49020f,0x22451be6}},	//   jšim_, ेसम्, csac_, kalk_, 
   {{0x09bf0033,0x76410090,0x0cc30033,0xf3880210}},	//   _আশরা, _cely, ্কৃত, _rợ_, 
   {{0xf388001b,0xceb300d1,0x7641017c,0x1ae31be7}},	//   _sợ_, ריו_, _dely, _сорм, 
   {{0x752100e9,0xd3a60eba,0x69c100c2,0x33740176}},	//   _dulz, ероп, _ülea, вгир, 
   {{0xa34300f6,0x22451be8,0xb05b0502,0x76411be9}},	//   лээл, falk_, fhän, _fely, 
   {{0xf3880029,0x76411bea,0x7d0d15c3,0x7f5d016a}},	//   _vợ_, _gely, zmas, vusq, 
   {{0x6d1f0394,0x1dcf0262,0x7d0d1beb,0x3ce00343}},	//   _मूंग_, _हेंत, ymas, kniv_, 
   {{0x254c00bc,0x7d0d00ad,0x6add1bec,0x61f80ed0}},	//   měl_, xmas, _मद्र, _vyvl, 
   {{0xe29a1bed,0xb05b01c4,0xe0df01d8,0x5f940093}},	//   _над_, bhän, rnò_, гият, 
   {{0x64420387,0x245a0241,0xb60600de,0x00000000}},	//   _heoi, bümü_, _etáž, --, 
   {{0x7d0d12fb,0x31850259,0x20c20354,0x00000000}},	//   tmas, _атың, _dóib_, --, 
   {{0xdc880a10,0xccf802a6,0x628a1bee,0x00000000}},	//   нсул_, ећу_, _hafo, --, 
   {{0x7d0d134c,0x628a1bef,0xddde00ca,0x7e2b128b}},	// [11b0] rmas, _kafo, _vapš, _ніна_, 
   {{0x64421bf0,0x628a0508,0x00000000,0x00000000}},	//   _leoi, _jafo, --, --, 
   {{0x76411bf1,0xd99900eb,0x628a1bf2,0x2d930068}},	//   _rely, بنات_, _mafo, _urxe_, 
   {{0x76411bf3,0x628a1bf4,0x64420387,0x254c00bc}},	//   _sely, _lafo, _neoi, děl_, 
   {{0x167300cf,0x81bc01dd,0x7eb01bf5,0x245a0213}},	//   лқар, ucēj, _käpp, zümü_, 
   {{0x75211bf6,0x20d2044e,0x69d500a2,0xf653006b}},	//   _pulz, všim_, _येथी, ائش_, 
   {{0x35a51bf7,0x644200eb,0x22451bf8,0x76410028}},	//   тайг, _beoi, valk_, _vely, 
   {{0xe7d21bf9,0x64420038,0x3af402ae,0x7eb01bfa}},	//   _देवप, _ceoi, läpp_, _läpp, 
   {{0x628a1bfb,0xe3b100eb,0x13090eba,0x69d5009a}},	//   _bafo, شرة_, мний_, _येती, 
   {{0x628a0156,0x7eb00341,0xb2250258,0xb6060098}},	//   _cafo, _näpp, ъмол, _stáž, 
   {{0xd5bb00cf,0x91e51bfc,0x628a1bfd,0xb05b0f03}},	//   _эса_, тоне, _dafo, rhän, 
   {{0x64420d44,0xe3b011b7,0x20d2090e,0xe5080038}},	//   _geoi, _گرم_, pšim_, _كيلو_, 
   {{0xb05b022b,0xbb1b0216,0x628a019b,0x2ca900c2}},	//   mhäl, _asîm, _fafo, djad_, 
   {{0x798200ab,0x628a0156,0x00000000,0x00000000}},	//   łowi, _gafo, --, --, 
   {{0xbea30843,0x20040228,0x8af000ad,0x20c20354}},	//   шарк, ťmi_, frən, _cóic_, 
   {{0x248d1bfe,0xa3e51126,0x1fb61bff,0x1d071c00}},	//   ndem_, _नशा_, _асор, веси_, 
   {{0x2c070299,0x236d006f,0x628a1b7a,0x248d0527}},	// [11c0] _शरणं_, ntej_, _yafo, idem_, 
   {{0x1d260e65,0x63a60219,0x3ce0006d,0x6d481c01}},	//   _имом, äkni, sniv_, ádas, 
   {{0xc96605e0,0xae5700d1,0xbea31c02,0x41c10299}},	//   твей, _בסיס_, _таэк, शनिस, 
   {{0x799500ab,0x38cb1c03,0xd7fa01d7,0x290f012b}},	//   _drzw, وانی_, мул_, gmga_, 
   {{0x6d5a012d,0xf093008d,0xe7d2009a,0x23d00035}},	//   štad, ינא_, _देशप, _तेंद, 
   {{0x248d003d,0x254c00bc,0x6442007a,0x7ccc0248}},	//   edem_, těl_, _seoi, rşru, 
   {{0xe9a31c04,0x628a1c05,0xa9a31c06,0x3ab300f0}},	//   _карп, _rafo, _кирд, _тәтт, 
   {{0xb8660a24,0x628a1c07,0x2a071c08,0x00000000}},	//   _جاسو, _safo, _респ_, --, 
   {{0x2c6d0019,0x628a1c09,0xaa82003e,0x69e7020f}},	//   lódó_, _pafo, _þýsk, ăreţ, 
   {{0x68e21c0a,0x00000000,0x00000000,0x00000000}},	//   lnod, --, --, --, 
   {{0x9f4f008c,0x64421c0b,0x628a00a3,0xc8b600b0}},	//   _ágú_, _teoi, _vafo, _अकाट, 
   {{0xe3ba1c0c,0x9f35004e,0x68e200f8,0x628a0532}},	//   _обе_, лемі, nnod, _wafo, 
   {{0x35a8000f,0x628a1c0d,0x68e20183,0x2ca90352}},	//   _कपड़, _tafo, inod, vjad_, 
   {{0x6b841c0e,0x290f00a3,0x7a4801dd,0x00000000}},	//   dwig, zmga_, nūtē, --, 
   {{0x1df81c0f,0x910702f1,0x2ca900b0,0x20d20a1a}},	//   веры_, _ичид, tjad_, kših_, 
   {{0x20d202ee,0xa3d601a4,0x2d9c00de,0x00000000}},	//   jših_, _सधा_, _švec_, --, 
   {{0x3a751c10,0x68e20076,0x2ca91c11,0x7eb01c12}},	// [11d0] ллар, dnod, rjad_, _täpp, 
   {{0x5a341b46,0x3f8900ef,0x248d1c13,0x68e20354}},	//   инут, _isau_, zdem_, enod, 
   {{0x68e31056,0x68e202bf,0xceb2042c,0xe7030023}},	//   éndo, fnod, _היי_, _nướ, 
   {{0x68e2017c,0x5c0700f6,0x6b84007c,0x00000000}},	//   gnod, _аяга, bwig, --, 
   {{0x27e91c14,0xe9ff00e7,0x20c202aa,0xdcb10023}},	//   çan_, _trắc_, _jóia_, ểu_, 
   {{0x7d1d1c15,0x7c2d1c16,0xfbdf03c6,0xe7030108}},	//   _hiss, lcar, _ddêt_, _bướ, 
   {{0xc9841891,0x45191c17,0x68e21c18,0xb05b01c4}},	//   _кути, нция_, bnod, thäl, 
   {{0x7c2d1c19,0x7d1d003d,0xdb1e014b,0xc4851c1a}},	//   ncar, _jiss, _švéd, улик, 
   {{0x7d1d1c1b,0x248d1c1c,0xb05b1709,0x7c2d0028}},	//   _miss, rdem_, rhäl, icar, 
   {{0x248d105b,0x236d1c1d,0xd24302f1,0x27e00038}},	//   sdem_, rtej_, шмоқ, úine_, 
   {{0x291e026d,0x236d1c1e,0x7c2d0216,0x3f8900f3}},	//   _état_, stej_, kcar, _asau_, 
   {{0x7c2d1c1f,0xd5ba00c7,0x7dc300a3,0x6b840326}},	//   jcar, _אזעל, _rеsp, ywig, 
   {{0xe28e1c20,0x7c2d1c21,0x442d1c22,0x442f0379}},	//   _ла_, dcar, mce_, _ifg_, 
   {{0x442d1c23,0x7d1d1c24,0x35d800a5,0x66f51c25}},	//   lce_, _aiss, _भेड़, ेतिक_, 
   {{0x62811c26,0x7d1d1c27,0x3f891c28,0x5de60093}},	//   melo, _biss, _esau_, ужва, 
   {{0x442d1c29,0x62811c2a,0x777b0068,0x6b9b1c2b}},	//   nce_, lelo, _opux, _šuga, 
   {{0x68e2090e,0x60c41c2c,0x20d2044e,0xcefd010c}},	// [11e0] vnod, _ilim, vših_, îşên_, 
   {{0xc3320056,0x7bc006d0,0x62811c2d,0xdd0404be}},	//   צוב_, _ümum, nelo, ırır, 
   {{0x442d000d,0x2d9615b3,0x7d1d1c2e,0x68e21c2f}},	//   kce_, _српс, _fiss, tnod, 
   {{0x62811c30,0x7c2d1c31,0x5ca61c32,0x7d1d1c33}},	//   helo, ccar, _симб, _giss, 
   {{0x62811c34,0x442d1c35,0x60c41c36,0x6d4e1c37}},	//   kelo, dce_, _mlim, lsba, 
   {{0x62811c38,0x6d5c1c39,0x442f02f1,0x60c41c3a}},	//   jelo, orra, _afg_, _llim, 
   {{0x62811c3b,0xf1a70038,0x7aeb039f,0x00000000}},	//   delo, _اء_, égte, --, 
   {{0x442f1c3c,0x6f1e00ab,0x6d4e1c3d,0x44b41c3e}},	//   _cfg_, _lipc, isba, рбис, 
   {{0x62811c3f,0xb4e405f6,0x6d5c01c4,0x8af000ad}},	//   felo, _नदी_, hrra, hrəm, 
   {{0x60c41c40,0x6281051e,0x442d1c41,0x26c7031e}},	//   _alim, gelo, ace_, chno_, 
   {{0x60c41b6b,0x442d031e,0x645d001d,0xd48f1c42}},	//   _blim, bce_, ósic, _лр_, 
   {{0x38661c43,0x442d0141,0x2bef0086,0x6d4e03fa}},	//   ngor_, cce_, চেয়ে_, dsba, 
   {{0xb4c004bd,0x2d9e0f5b,0x6d5c1c44,0x8af000ad}},	//   ँसी_, åten_, erra, stəy, 
   {{0x7d1d0077,0x62341c45,0x3866017c,0x2f04003e}},	//   _siss, _теку, hgor_, sögn_, 
   {{0x7d1d1c46,0x60c40405,0x40350bf8,0x7c2d064e}},	//   _piss, _flim, _кейс, tcar, 
   {{0x60c41c47,0x3f89023b,0x7d1d00a3,0xd13817d0}},	//   _glim, _tsau_, _qiss, mpą_, 
   {{0x7d1d1c48,0x6d5c1c49,0x6d4e1c4a,0xafdb02c9}},	// [11f0] _viss, arra, asba, dbøg, 
   {{0x7d1d1c4b,0x442d1c4c,0x7c2d1c4d,0xacbb010c}},	//   _wiss, zce_, scar, _siûd, 
   {{0x7d1d1c4e,0x442d1c4f,0x60c400c8,0x7c2d1c50}},	//   _tiss, yce_, _ylim, pcar, 
   {{0x62811c51,0x69c1007e,0x6d5a0097,0x386602ae}},	//   zelo, _ülem, štac, ggor_, 
   {{0x442d01e2,0x07a51c52,0x36691c53,0xa3d31c54}},	//   vce_, ралн, вало_, _हें_, 
   {{0x05551c55,0x442d1c56,0x38691c57,0x62811c58}},	//   атия, wce_, żar_, xelo, 
   {{0x62811c59,0x442d0484,0x49930e13,0x3eb3008a}},	//   velo, tce_, _دیار, _moxt_, 
   {{0x62811c5a,0xed64026e,0x47351a18,0x442d1c5b}},	//   welo, leží_, _внас, uce_, 
   {{0x442d1c5c,0x62811c5d,0xe7300491,0x64491c5e}},	//   rce_, telo, _فصل_, raei, 
   {{0x442d1c5f,0x60c41c60,0x27ff0460,0xd7f8002e}},	//   sce_, _slim, _iyun_, _сус_, 
   {{0x62811c61,0x442f1c62,0x442d0e25,0x26c51c63}},	//   relo, _tfg_, pce_, _illo_, 
   {{0x62811c64,0x65630165,0x27ff01e5,0x272b055f}},	//   selo, munh, _kyun_, _køn_, 
   {{0x7bcd1c65,0x62811c66,0x68e9024a,0x9db900f0}},	//   jzau, pelo, _mjed, қыру_, 
   {{0xed5a16d9,0x6d4e1c67,0x59b5119b,0x7bcd1c68}},	//   ког_, tsba, ंहार, dzau, 
   {{0x68fb1c69,0x63bb1c6a,0x272b0c85,0x6d5c1c6b}},	//   _okud, lyun, _løn_, urra, 
   {{0xdcfc03ef,0x60c41c6c,0x27ff03c0,0x2247064e}},	//   tvrđ, _ulim, _oyun_, _henk_, 
   {{0x63bb1c6d,0x63a91c6e,0x26c503da,0x6d4e1c6f}},	// [1200] nyun, nxen, _ollo_, ssba, 
   {{0xc87906d0,0x68e91c70,0xed4615dd,0x63a91c71}},	//   _abş_, _ajed, _кноп, ixen, 
   {{0xada600cf,0x63bb08a1,0x27ff1c72,0x290d00ca}},	//   _танл, hyun, _ayun_, _bhea_, 
   {{0x290d03da,0xe73a03dc,0x26c50141,0x27ff0e34}},	//   _chea_, вед_, _allo_, _byun_, 
   {{0x16340141,0x68e9027c,0x18670804,0x386601f2}},	//   беля, _djed, рачи_, rgor_, 
   {{0x68fb1c73,0x22470696,0xd70707a4,0x8b191087}},	//   _ekud, _nenk_, анче_, _бюст_, 
   {{0x656309a1,0x20d20032,0x290d00a1,0x68e902c9}},	//   gunh, lšiu_, _fhea_, _fjed, 
   {{0x26c515c4,0x5fa600a2,0xb4c012e3,0x290d016a}},	//   _ello_, खमाल, ँसे_, _ghea_, 
   {{0x63bb0019,0x22471c74,0x20d2020b,0x2ef8040b}},	//   gyun, _benk_, nšiu_, korf_, 
   {{0x291f002e,0xb273058b,0x9f4f0212,0x68e90f69}},	//   _ziua_, ольш, _âgé_, _zjed, 
   {{0x22471c75,0x26dc1c76,0xadf2185c,0x2ef801c4}},	//   _denk_, mivo_, _आँगन_, dorf_, 
   {{0x64a316b0,0x26dc1c77,0x76481c78,0xddc500bc}},	//   _маха, livo_, _hedy, _schů, 
   {{0x76481c79,0xdc2e0095,0x20d20228,0xa294012d}},	//   _kedy, _sığo, jšiu_, _галі, 
   {{0x764800ab,0x75280727,0x22471c7a,0x7b100380}},	//   _jedy, _kudz, _genk_, läuf, 
   {{0xe3e8100b,0x75281c7b,0xec6b1c7c,0x9c471c7d}},	//   _পরিব, _judz, крак_, ихал, 
   {{0xc05b02fb,0x75280727,0x7bcd1c7e,0x25de007e}},	//   _рік_, _mudz, tzau, _कइनी_, 
   {{0x7528006a,0x2bba0035,0x2d9a1c7f,0x0ca800d9}},	// [1210] _ludz, jącą_, _erpe_, штри_, 
   {{0x68e91c80,0x68fb1c81,0x69c100b0,0x764800d7}},	//   _sjed, _skud, _ülek, _nedy, 
   {{0x272b03a9,0xc8ab0141,0x2484003d,0x63a40068}},	//   _søn_, къде_, kemm_, _áinf, 
   {{0xf77117c1,0x00000000,0x00000000,0x00000000}},	//   كات_, --, --, --, 
   {{0x2bde10a6,0x68e900e5,0x752800e0,0x2bcb0afc}},	//   _नेपा, _vjed, _audz, _руно_, 
   {{0x65631c82,0x20d20082,0x75281c83,0xdc3c01f2}},	//   tunh, lšit_, _budz, _iġġo, 
   {{0x68e902a8,0xa8a71c84,0x785713b4,0x290d1c85}},	//   _tjed, _крак, _نیاز_, _thea_, 
   {{0x68e903ef,0x65631c86,0x224706df,0x68fb03c3}},	//   _ujed, runh, _senk_, _ukud, 
   {{0x764800f3,0x00000000,0x00000000,0x00000000}},	//   _fedy, --, --, --, 
   {{0x63a90496,0x68f900a4,0x65631c87,0x2120085b}},	//   rxen, lowd, punh, _siih_, 
   {{0x63bb134a,0x386d0372,0x95c81c88,0x22470237}},	//   syun, _kcer_, _куца_, _venk_, 
   {{0x297a0111,0x67211c89,0x397a00a7,0x60dd1c8a}},	//   נטרא, _hilj, נטרנ, gism, 
   {{0x443f1c8b,0x6d45012b,0x20050095,0x22471c8c}},	//   mbu_, _awha, əlik_, _tenk_, 
   {{0x443f1c8d,0x6d450102,0x7d18039f,0x75280175}},	//   lbu_, _bwha, _évsz, _yudz, 
   {{0xdca61c8e,0x2d951184,0x01351c8f,0x719600d4}},	//   бави, ортс, _اعتد, _هنوز_, 
   {{0x443f1c90,0x67211c91,0x6da6004e,0xa96a1c92}},	//   nbu_, _lilj, _ғима, ғида_, 
   {{0x1d071c93,0x63a41c94,0x443f1c95,0x2d840098}},	// [1220] сети_, _àint, ibu_, ňme_, 
   {{0x443f00cf,0x2d9a1993,0x2907010c,0x8e860038}},	//   hbu_, _trpe_, înan_, _الده, 
   {{0x499a1c0f,0x76481c96,0xef17002e,0x6d4503c6}},	//   ытая_, _redy, _ымь_, _gwha, 
   {{0x76481c97,0x443f007b,0x75281c98,0x20d21b95}},	//   _sedy, jbu_, _rudz, pšiu_, 
   {{0x7d041c99,0x4b550093,0x75281c9a,0xc0530070}},	//   mlis, _мърт, _sudz, לזא_, 
   {{0x7d041c9b,0xf1ca000d,0x386d02cd,0x60dd1c9c}},	//   llis, ानमन, _ecer_, zism, 
   {{0x26dc1c9d,0x67211c9e,0x2d981c9f,0x60dd1ca0}},	//   rivo_, _dilj, nvre_, yism, 
   {{0x7d041ca1,0x60dd1ca2,0x76480156,0x2d980107}},	//   nlis, xism, _wedy, ivre_, 
   {{0x47c600ce,0x26dc1ca3,0xf7430d11,0x7d041ca4}},	//   _убав, pivo_, _нето, ilis, 
   {{0x660102fb,0x60dd016a,0x41541ca5,0x7648011c}},	//   _fylk, wism, овос, _uedy, 
   {{0x443f1ca6,0x8afb00c7,0xff5f03c6,0x63a41ca7}},	//   bbu_, רהיי, wrî_, _šind, 
   {{0x7d0400cf,0x7c260175,0x60dd1ca8,0x00000000}},	//   jlis, _ngkr, uism, --, 
   {{0x44261ca9,0xe6c4010d,0x7d040187,0x6d5a0187}},	//   _igo_, _þjóð, dlis, átan, 
   {{0x7d160228,0x60dd076b,0xff5f0216,0x7d041caa}},	//   emys, sism, rrî_, elis, 
   {{0x6d5a00f1,0x7d041cab,0x44261cac,0x91fc01dd}},	//   štan, flis, _kgo_, zgāj, 
   {{0xd9041cad,0x7d041cae,0xa2d40ed5,0x9c391caf}},	//   _سی_, glis, योर्, рпат_, 
   {{0x2d8c01cc,0x63a40183,0x88bd0035,0x44260210}},	// [1230] æder_, _áind, _liśc, _mgo_, 
   {{0x7d041cb0,0x443f1cb1,0x2d980151,0x61ff039f}},	//   alis, zbu_, bvre_, _ízlé, 
   {{0x7d041cb2,0x443f1cb3,0x44261cb4,0x6d3416d0}},	//   blis, ybu_, _ogo_, _неэф, 
   {{0x44261cb5,0x2d810415,0x67211cb6,0x20d20097}},	//   _ngo_, _iphe_, _silj, lšir_, 
   {{0xd3661cb7,0x672908f4,0x443f026e,0xdbe30183}},	//   _ته_, _quej, vbu_, _téño, 
   {{0xe5a51cb8,0xa3be0bb6,0x3ce900b3,0x91fc01dd}},	//   жики, ीनन_, lnav_, rgāj, 
   {{0x67211cb9,0x44260102,0x5fe002e6,0x0319009c}},	//   _vilj, _bgo_, _पेनल, یتخت_, 
   {{0x2d81084c,0x44260354,0x443f1cba,0x00000000}},	//   _mphe_, _cgo_, ubu_, --, 
   {{0x443f1cbb,0x7b1001c4,0x44260126,0xb05b0380}},	//   rbu_, bäud, _dgo_, nhäu, 
   {{0x66010da6,0x443f1cbc,0x7d161cbd,0xa7b800d3}},	//   _tylk, sbu_, zmys, _улуу_, 
   {{0x00861cbe,0x7d041cbf,0x75220054,0xd04f00ad}},	//   олно, ylis, _fioz, licə, 
   {{0x2eb41cc0,0xc952008d,0x7d0400a3,0xafa21cc1}},	//   ुस्त, ומט_, xlis, дқиқ, 
   {{0xfc460187,0xbebb024a,0x7d041cc2,0x64590096}},	//   šíka_, jqës, vlis, _idwi, 
   {{0x61451b02,0x7d04008a,0x644b0610,0x752201d6}},	//   _дека, wlis, _hegi, _zioz, 
   {{0x7d041cc3,0x644b1cc4,0xdddc0a1a,0x7e2302a0}},	//   tlis, _kegi, ferš, ддрж, 
   {{0x0ce80086,0xb05b161f,0xdca302f1,0x7d041cc5}},	//   পত্ত, lkän, маси, ulis, 
   {{0x7d041cc6,0xeb970088,0x644b1cc7,0xcb6a1cc8}},	// [1240] rlis, оит_, _megi, разе_, 
   {{0xda6600eb,0xb05b1cc9,0x7d1602d9,0xda650038}},	//   تاري, nkän, smys, كامي, 
   {{0x1d0a1cca,0x645900ab,0xdddc1826,0xe9da0267}},	//   _вени_, _odwi, berš, јке_, 
   {{0x644b1ccb,0xa8a3021c,0xe8fa0d3d,0x6459045a}},	//   _negi, дршк, шле_, _ndwi, 
   {{0xb05b02ae,0x44260106,0x163402a3,0x00000000}},	//   phäv, _rgo_, пеля, --, 
   {{0x8f9b1ccc,0xd94603dc,0xe0df01d8,0xbf9b0147}},	//   ייני, _меги, ziò_, יינש, 
   {{0x2bde072e,0xb05b014e,0xe5a30267,0x91fc0243}},	//   _नेता, dkän, дији, rgāk, 
   {{0x644b186a,0x18671ccd,0x75cb0259,0xd37a019c}},	//   _cegi, _маси_, штің_, ачо_, 
   {{0x644b1cce,0xe0df0036,0xe7371ccf,0x00000000}},	//   _degi, viò_, _мет_, --, 
   {{0x29061cd0,0x8af00095,0x64591cd1,0x3ce0007e}},	//   lloa_, qsəd, _edwi, hiiv_, 
   {{0x27300029,0x644b1cd2,0x29061cd3,0x7522019c}},	//   _hàn_, _fegi, oloa_, _tioz, 
   {{0x6ab70c59,0x44261cd4,0xbebb024a,0x644b1cd5}},	//   _आक्र, _ugo_, yqës, _gegi, 
   {{0x6d5a09b2,0x69c1007e,0x3ce90352,0x290600b4}},	//   štal, _ülev, vnav_, iloa_, 
   {{0xdefb0e14,0x2005002a,0x27300029,0x2bd5031e}},	//   рым_, āli_, _màn_, _ठेगा, 
   {{0x27301cd6,0x62881cd7,0xc8bc1615,0xdd9801a2}},	//   _làn_, medo, ्घाट, ошт_, 
   {{0x62881cd8,0x5ce7017b,0x00000000,0x00000000}},	//   ledo, іюва, --, --, 
   {{0x60c01cd9,0x27300023,0x3ce9010c,0x00000000}},	// [1250] ömme, _nàn_, rnav_, --, 
   {{0x62881cda,0x29061cdb,0x3ce90339,0xb4c7072d}},	//   nedo, eloa_, snav_, _उत्_, 
   {{0xdc3f026e,0x19ab00d3,0xb05b02eb,0x00000000}},	//   líčk, штап_, shäu, --, 
   {{0xd04f06d0,0x27301cdc,0x26f51cdd,0xb05b0380}},	//   ticə, _bàn_, ेत्र_, chät, 
   {{0xf7451cde,0x23d9010f,0xdc3f05a8,0x6d55010e}},	//   чело, _बेंद, níčk, lsza, 
   {{0x27301cdf,0x644b1ce0,0x62880eae,0x6b8d1ce1}},	//   _dàn_, _segi, jedo, mwag, 
   {{0x62881ce2,0x6b8d0b32,0xb05b02ae,0x00000000}},	//   dedo, lwag, vkän, --, 
   {{0xe7870e65,0x28f8004f,0x00000000,0x00000000}},	//   _музо, _десь_, --, --, 
   {{0x644b1ce3,0x6b8d1ce4,0xf41f0088,0xdc3f014b}},	//   _vegi, nwag, ää_, jíčk, 
   {{0x62881ce5,0x04fd0086,0x644b02a5,0x425508b8}},	//   gedo, ুদের_, _wegi, чтит, 
   {{0x644b1ce6,0xb05b161f,0xe2990e65,0x6b8d1ce7}},	//   _tegi, rkän, _ҳал_, hwag, 
   {{0x6b8d1ce8,0xb05b02ae,0x69c101a4,0x00000000}},	//   kwag, skän, _üleu, --, 
   {{0xa3d300a2,0xe2991ce9,0x2004008c,0x7643006d}},	//   _हेच_, _гал_, æmi_, obny, 
   {{0x6d5a07c7,0x2cb901be,0x62881cea,0xb05b161d}},	//   štam, _aosd_, cedo, lkäl, 
   {{0x2d9e0076,0x6da31c93,0x764302cd,0x6d550019}},	//   íte_, нира, ibny, gsza, 
   {{0xd7bd009a,0x2cb901be,0xb05b17f8,0xdc3f0098}},	//   ्नाच, _cosd_, nkäl, bíčk, 
   {{0xab660ff6,0x673b023b,0x6b8d1ceb,0x00000000}},	// [1260] явал, _ntuj, gwag, --, 
   {{0x0e661cec,0x3f921a71,0x80aa0ead,0xcff700d1}},	//   _экон, _isyu_, टावे, _מצפה_, 
   {{0x98b0034c,0x2730001b,0x3ebb00a7,0xdebb00a7}},	//   šači_, _sàn_, _הציב, _המיל, 
   {{0x77621ced,0x6b8d1cee,0x186a1cef,0xeb9f01e8}},	//   trox, bwag, сади_, _frø_, 
   {{0xfc3f1cf0,0x65630380,0x47331cf1,0x6b8d0610}},	//   _unía_, ernh, еніс, cwag, 
   {{0x62881cf2,0x996400bc,0x2b401cf3,0x27300108}},	//   xedo, může_, mpic_, _vàn_, 
   {{0xb0cc0c73,0x673b0080,0xdc3f00da,0x9d000033}},	//   ासाग, _etuj, zíčk, ্দীন_, 
   {{0x628802bf,0x273000e7,0x77621cf4,0x6f02007a}},	//   wedo, _tàn_, prox, _íocf, 
   {{0x7643039f,0x656300a1,0x00000000,0x00000000}},	//   bbny, arnh, --, --, 
   {{0xb6c8006b,0x7afe1cf5,0x68e21cf6,0x86ea0038}},	//   _بارے_, nopt, liod, _اعرف_, 
   {{0x6d5a00f1,0x6b8d1cf7,0x69c100b0,0xe3af0444}},	//   štaj, zwag, _ület, نری_, 
   {{0xeafa058f,0x68e21cf8,0x62881cf9,0x2347009c}},	//   ्तुत_, niod, sedo, _کلوپ_, 
   {{0x62881cfa,0x98a70112,0xa4b700d1,0x3eba00b9}},	//   pedo, šići_, _מלאה_, _bopt_, 
   {{0x628800e5,0x6d551cfb,0x3eba00b3,0xe2971cfc}},	//   qedo, tsza, _copt_, _нач_, 
   {{0xf29703e1,0x3ebe14b1,0x200c00ad,0x6b8d1cfd}},	//   _זכור_, ötta_, ədim_, wwag, 
   {{0x6d551cfe,0x6b8d1cff,0xfbde00a2,0x2bde1d00}},	//   rsza, twag, _नेहम, _नेहा, 
   {{0x6d55006b,0x68e21d01,0xa3be00bd,0xbab91d02}},	// [1270] ssza, diod, ीनि_, огах_, 
   {{0x6b8d1d03,0x88bd0035,0xb05b0380,0x6d551d04}},	//   rwag, _ciśn, chär, psza, 
   {{0xc178012d,0x673b02cd,0x2cb901be,0xceb20147}},	//   ntė_, _stuj, _tosd_, _סיט_, 
   {{0xa3be05fd,0xc178012d,0x2ee3012e,0xec6b1d05}},	//   ीना_, itė_, lijf_, _урок_, 
   {{0x60cd009c,0x3a38016c,0x66cf00fc,0xab841d06}},	//   _mlam, _ffrp_, _løke, _пурк, 
   {{0x60cd1d07,0x25de000d,0x7afe1d08,0xc7a203a1}},	//   _llam, _केही_, copt, тишк, 
   {{0x60cd1d09,0xf6500133,0xb05b00c8,0x00000000}},	//   _olam, ائه_, tkäl, --, 
   {{0x68e2002e,0x2ee301c8,0x387f1d0a,0xe894012d}},	//   ciod, hijf_, _ubur_, _пась, 
   {{0xc1780009,0x673b1d0b,0x78a91d0c,0x00000000}},	//   etė_, _utuj, _inev, --, 
   {{0x78bb1d0d,0x69c1007e,0x66cf00dd,0x130600c8}},	//   _houv, _üles, _bøke, мный_, 
   {{0x78bb1d0e,0x208a1d0f,0xf38000f0,0x60cd1d10}},	//   _kouv, ойни_, _ұғым, _blam, 
   {{0xafe602fb,0xd00a02a0,0x15e31d11,0x78bb10cc}},	//   домл, жеме_, _केयर_, _jouv, 
   {{0x78bb1d12,0x60cd1d13,0x92b50038,0x00000000}},	//   _mouv, _dlam, _يحتا, --, 
   {{0x78bb1d14,0x60cd007e,0xafdb1341,0x68e21d15}},	//   _louv, _elam, mbøl, ziod, 
   {{0x99980082,0x60cd1d16,0x78a91a0d,0x00000000}},	//   _serž_, _flam, _onev, --, 
   {{0x78bb1d17,0x7afe0237,0x68e20068,0xb05b1d18}},	//   _nouv, wopt, xiod, shär, 
   {{0xb05b01c4,0x32070090,0xa2d40659,0x00000000}},	// [1280] phär, _hyny_, योक्, --, 
   {{0x273b00b3,0x60cd1d19,0x78a9107c,0xd9460ca4}},	//   _mână_, _zlam, _anev, дежи, 
   {{0x2d9c0019,0xdce9027e,0x78bb1d1a,0x2b400144}},	//   _éve_, _çoğu, _bouv, spic_, 
   {{0x5883058b,0x78bb026d,0x60cd0065,0x52bc00bd}},	//   выша, _couv, _xlam, _ोत्स, 
   {{0x78bb0300,0xba560093,0xd5af009c,0x711b0070}},	//   _douv, _отвъ, یفه_, קונפ, 
   {{0x68e21d1b,0xc1780009,0x78a91d1c,0x46a31d1d}},	//   siod, ytė_, _enev, качв, 
   {{0x26190c46,0x06c20033,0xdddc00da,0x00000000}},	//   येली_, ্চলি, berť, --, 
   {{0x78bb1d1e,0x6abc008c,0x78a904cb,0x23c9009a}},	//   _gouv, _horf, _gnev, िनंद, 
   {{0x66cf00dd,0x69c100c2,0x60cd01fd,0x00000000}},	//   _søke, _üler, _rlam, --, 
   {{0x60cd1d1f,0xc17a004f,0xf7d7008d,0x6abc00f6}},	//   _slam, оїм_, _חומש_, _jorf, 
   {{0xa50a0a10,0xb05b12b7,0xa2d41d20,0x00000000}},	//   _дежа_, skäm, योग्, --, 
   {{0x224907c7,0xc178012d,0x30a70a74,0xd4c60038}},	//   _đake_, rtė_, фров, _تغطي, 
   {{0x351b00c7,0xc178012d,0x60cd0511,0x60c00219}},	//   _וואנ, stė_, _vlam, ömma, 
   {{0x39411d21,0x32070156,0x213c0023,0xdd95022c}},	//   yphs_, _fyny_, _ttvh_, нагы, 
   {{0x63a21d22,0x67281d23,0x27fa00ab,0x60cd0364}},	//   _hron, _midj, ępny_, _tlam, 
   {{0x60cd1d24,0x629a1d25,0x6ee900d0,0x51831d26}},	//   _ulam, ldto, džbe, _руша, 
   {{0x5b151d27,0x63a200c5,0x62981d28,0x6abc1d29}},	// [1290] емат, _jron, _kavo, _borf, 
   {{0x78bb1d2a,0x629800cf,0x6abc0156,0x672802fe}},	//   _souv, _javo, _corf, _nidj, 
   {{0x78bb1d2b,0x25de02f8,0x78a9008b,0x21291780}},	//   _pouv, _केली_, _pnev, _kiah_, 
   {{0x62981d2c,0x20090633,0x63a20a77,0x7d090405}},	//   _lavo, _kyai_, _oron, ċess, 
   {{0x6abc1d2d,0x21290065,0x67280300,0x7f4d00a4}},	//   _forf, _miah_, _bidj, _jwaq, 
   {{0x6abc02bf,0xda7e020b,0x7f4d00a4,0x2d870151}},	//   _gorf, íďte_, _mwaq, _ânes_, 
   {{0x63a21d2e,0xd5b11c8f,0x2d91016c,0x7ae50175}},	//   _aron, افع_, nwze_, miht, 
   {{0x273b002e,0xe3b91d2f,0x21290065,0x7ae51d30}},	//   _până_, зби_, _niah_, liht, 
   {{0x03251d31,0x65930095,0x20091d32,0x32071d33}},	//   ндин, _məhə, _nyai_, _syny_, 
   {{0x7dee0019,0x629800fd,0x3f4d1d34,0xe3c300d3}},	//   nősé, _cavo, džu_, ерүү, 
   {{0x62981d35,0x21290065,0x69c50a98,0x46ac0e6e}},	//   _davo, _biah_, nyhe, चारह, 
   {{0x0ef8047c,0xf9da00c7,0x629a1d36,0x21290096}},	//   ंक्स_, פֿיל, adto, _ciah_, 
   {{0x63a21d37,0x2129170d,0xada300a3,0xafdb0566}},	//   _gron, _diah_, қатл, lbøj, 
   {{0x248d050a,0xe3b000d6,0x6d420082,0xe29916d2}},	//   leem_, _خرم_, _čoab, _хак_, 
   {{0x57bd0351,0xdd921d38,0x00000000,0x00000000}},	//   ्नुह, دوز_, --, --, 
   {{0x248d0691,0x91fc01dd,0x659300ad,0xeafa00b0}},	//   neem_, rgāt, _cəhə, ्त्त_, 
   {{0x6abc1d39,0xc4d200c7,0x2cab0126,0x62980027}},	// [12a0] _porf, אגן_, _dncd_, _yavo, 
   {{0x248d006f,0x629800a3,0x19f60bae,0x00000000}},	//   heem_, _xavo, нџер, --, 
   {{0x672802fe,0xa84a0038,0x6abc1d3a,0x2cab0237}},	//   _ridj, كلام_, _vorf, _fncd_, 
   {{0x67281d3b,0xab2a0176,0x00000000,0x00000000}},	//   _sidj, _нома_, --, --, 
   {{0x66e61d3c,0x1c1c1d3d,0x6abc1d3e,0x248d1d3f}},	//   нода, पेशल_, _torf, deem_, 
   {{0x6d411d40,0x3cff0242,0x69c51d41,0x659300ad}},	//   ílag, čuve_, byhe, _zəhə, 
   {{0x67281d42,0x248d006d,0x62981d43,0xa2c30e07}},	//   _vidj, feem_, _ravo, ाउन्, 
   {{0x62981d44,0x67281d45,0x692c020f,0x6911042a}},	//   _savo, _widj, _eşec, låen, 
   {{0x62981d46,0xf31801a2,0xe3b20195,0xa6860478}},	//   _pavo, моиш_, ارع_, _плад, 
   {{0x2129033e,0x00000000,0x00000000,0x00000000}},	//   _siah_, --, --, --, 
   {{0x200902cd,0x629800a9,0x21290065,0x63a200d1}},	//   _syai_, _vavo, _piah_, _wron, 
   {{0x63a20124,0x6298019b,0x3cfa0035,0x00000000}},	//   _tron, _wavo, ंवों_, --, 
   {{0x09dd09d3,0xbfa81d47,0x62981d48,0x240a00cf}},	//   _मध्य, нтре_, _tavo, _энди_, 
   {{0x63ad032f,0x61eb0019,0xb3e90038,0x659300ad}},	//   _šang, állá, _تعمل_, _səhə, 
   {{0xe29b00c7,0x7ae50121,0xe2971329,0x51861d49}},	//   _זשור, viht, _чај_, _чула, 
   {{0xb05b00c8,0x2f1602c9,0xfd13189a,0x7f4d003d}},	//   kkäi, væge_, اجس_, _twaq, 
   {{0x3a751d4a,0x7dee006b,0xe7e00f63,0x2d9e0eca}},	// [12b0] клар, tősé, _खेला_, åter_, 
   {{0x69111d4b,0x3a741d4c,0x63bd03a9,0x257a0034}},	//   gåen, ллур, øsni, kël_, 
   {{0x1df90088,0x7ae51d4d,0x291d0027,0xb05b1279}},	//   _цены_, riht, tmwa_, tkäh, 
   {{0xf7711b44,0xa9070411,0x248d0201,0x69c50326}},	//   لات_, ربان, xeem_, ryhe, 
   {{0x7d0d1d4e,0x57bd00bc,0xadfc0035,0x257a0326}},	//   mlas, ्नेह, _एडऑन_, eël_, 
   {{0x7d0d1d4f,0x00000000,0x00000000,0x00000000}},	//   llas, --, --, --, 
   {{0x6d5a03ef,0x1af41d50,0x257a00e5,0x8aa40093}},	//   štav, _спря, gël_, _сряд, 
   {{0x7d0d1d51,0xa3be0110,0x00000000,0x00000000}},	//   nlas, ीनं_, --, --, 
   {{0x58d411db,0x3f8901a0,0x07351d52,0x248d1d53}},	//   _сотт, _npau_, _резю, reem_, 
   {{0x7d0d1d54,0x248d18b5,0xc3c800eb,0x257a0034}},	//   hlas, seem_, عظيم_, bël_, 
   {{0xa06a1d55,0x3de100cc,0x7d0d1d56,0x860200d4}},	//   мана_, _মুসল, klas, _پژوه, 
   {{0xa2a11d57,0x34950477,0xf99200d1,0xca75040c}},	//   _कोर्, _јадр, ברט_, _nizо, 
   {{0xe28e1d58,0x64491d59,0x7d0d1d5a,0x2d8c003d}},	//   _ка_, mbei, dlas, ħdem_, 
   {{0xa3da1d5b,0x200c01dd,0x64491d5c,0x20c20038}},	//   _डेट_, ādi_, lbei, _cóir_, 
   {{0xfc3f0032,0xe0da1d5d,0x644901d6,0x443d1d5e}},	//   _kníh_, _овк_, obei, _kfw_, 
   {{0x64491d5f,0x443d016a,0xa0a30cdf,0x753c0019}},	//   nbei, _jfw_, _ваъд, _érze, 
   {{0x69111d60,0x1d071d61,0x442f016a,0x60dd0034}},	// [12c0] tåen, тети_, _mgg_, ërme, 
   {{0x6281007b,0x4a431438,0x7d0d00b0,0x692c0474}},	//   nflo, инув, alas, _aşea, 
   {{0x7d0d1d62,0x00000000,0x00000000,0x00000000}},	//   blas, --, --, --, 
   {{0xf74613e6,0x442f14e2,0xc8631d63,0x8af00248}},	//   ведо, _ngg_, атши, msəm, 
   {{0xd7ef0084,0x7d041d64,0x09290038,0xe7371d65}},	//   يكم_, mois, رسمي_, веч_, 
   {{0x7d041d66,0xa2a11d67,0x6d5a0187,0x442f1d68}},	//   lois, _कोल्, štau, _agg_, 
   {{0x6d5c03d8,0x1ae30cf8,0x442f17c3,0x09e61d69}},	//   nsra, _торм, _bgg_, _ровн, 
   {{0x7d041d6a,0x224907c7,0xd3a61d6b,0x69c300c8}},	//   nois, _đaka_, вроп, änee, 
   {{0x613e00e0,0x62810844,0x623412de,0x64a30bae}},	//   _mīle, fflo, лепу, рања, 
   {{0x7d0d1d6c,0x02a61d6d,0x7d041d6e,0x91b80165}},	//   zlas, трим, hois, егот_, 
   {{0xf48400c5,0x7d04030f,0x7d0d00cf,0xd48f1d6f}},	//   _ماشی, kois, ylas, _кр_, 
   {{0x6d5c1d70,0x63ad0082,0x6ee90372,0x7d040080}},	//   dsra, _šane, džba, jois, 
   {{0x7d041d71,0xb4c00e7d,0xfbdf040b,0x6d5c1d72}},	//   dois, ुसी_, _leêr_, esra, 
   {{0x752b0068,0x76580010,0xf1a60c1d,0x69c102be}},	//   _zigz, navy, _арин, _àleg, 
   {{0x2fcd00f1,0x7d0d1d73,0x3cff1d74,0x6d5c03c5}},	//   šeg_, tlas, लवले_, gsra, 
   {{0x656a0038,0x48bd0086,0x9d181d75,0x8c3b0380}},	//   irfh, _আগ্র, вост_, _maßg, 
   {{0x7d0d1d76,0xe7bd0086,0x5c070141,0x20c200eb}},	// [12d0] rlas, _অধ্য, тява, _tóir_, 
   {{0x7d0d1d77,0x76581d78,0xf09f03dd,0x00000000}},	//   slas, javy, ldà_, --, 
   {{0x7d0d1d79,0x7d041d7a,0x6f0200eb,0x1a9401ff}},	//   plas, bois, _íoca, рахў, 
   {{0x7d0d00cf,0x48e10086,0xf09f1d7b,0x658a00ad}},	//   qlas, যক্র, ndà_, _məhd, 
   {{0x973500d6,0x62811d7c,0xf0940147,0x00000000}},	//   اکرا, yflo, ינף_, --, 
   {{0x442f0175,0xfc3f02d9,0x00000000,0x00000000}},	//   _sgg_, _sníh_, --, --, 
   {{0xceb41a61,0x940d00ad,0x2486019c,0xa5091d7d}},	//   ייס_, ənən_, _bbom_, нека_, 
   {{0x39460082,0x26190eda,0x8a181d7e,0x00000000}},	//   ćost_, येगी_, _росс_, --, 
   {{0x64491d7f,0x57f51d80,0x27e000eb,0x76580927}},	//   rbei, _спат, úint_, bavy, 
   {{0x3ce901c1,0xf09f022c,0x64491d81,0x7d04025b}},	//   hiav_, edà_, sbei, zois, 
   {{0x62811d82,0x312603a1,0x693700ca,0x7d040548}},	//   rflo, лдог, _oćem, yois, 
   {{0x6281003e,0x20c20038,0x3f6a1d83,0x27391d84}},	//   sflo, _cóip_, нимо_, _kèn_, 
   {{0x7d041d71,0x6e290095,0x273906df,0xe3ae0097}},	//   vois, əmbə, _jèn_, _уб_, 
   {{0xe2961d85,0x249f1d86,0x249d01a0,0xfc3f00f6}},	//   _баш_, ldum_, _hawm_, _afí_, 
   {{0xa0a61d87,0x7d040088,0x249d01c1,0x69110310}},	//   _байд, tois, _kawm_, tåel, 
   {{0x249f010d,0x7b1001c4,0x6d5c1d88,0x72420019}},	//   ndum_, räum, rsra, _پھیل, 
   {{0xcb671ac0,0x237f1d89,0xca860635,0x8fa60528}},	// [12e0] лате_, ntuj_, лгай, _сапе, 
   {{0xda650084,0x249d0e0c,0x6d5a0496,0x8f9b00a7}},	//   لامي, _lawm_, átas, _טיפי, 
   {{0x7d041d8a,0xbebb0034,0xfce61d8b,0x15e30299}},	//   pois, yqëz, _боно, _केलर_, 
   {{0x249d006d,0x237f1d8c,0x27391d8d,0x7658025b}},	//   _nawm_, ktuj_, _bèn_, wavy, 
   {{0x76581d8e,0x249f1d8f,0xc6e600f0,0x4b5500fd}},	//   tavy, ddum_, лікп, _въст, 
   {{0xb8cb1d90,0x3b0a0088,0x2ca0007e,0x4e7a00c7}},	//   _को_, _чего_, ldid_, גאַצ, 
   {{0x45d41d91,0x2ca000c2,0xa2d70110,0x76581d92}},	//   ройс, odid_, यसन्, ravy, 
   {{0x2ca01d93,0x249d006f,0x76581d94,0x2ed11d95}},	//   ndid_, _cawm_, savy, _हत्त, 
   {{0xc6761169,0xe6461d96,0x667600b8,0x249d0201}},	//   _مطاب, _безп, _مدار, _dawm_, 
   {{0x63ad026e,0x2ca01d97,0x4b7b0070,0x2d9a01cf}},	//   _šanc, hdid_, עטיג, _ospe_, 
   {{0x249d006d,0xf0b51d98,0x50f50176,0x7f441d99}},	//   _fawm_, айнь, изот, _atiq, 
   {{0x249d006d,0x273900c5,0x2ca000e2,0x00000000}},	//   _gawm_, _yèn_, jdid_, --, 
   {{0xf09f00d3,0x2d9a0118,0x9f351d9a,0x2ca01d9b}},	//   rdà_, _aspe_, регі, ddid_, 
   {{0x11d60040,0x539b042c,0x249d006d,0x8c3b0502}},	//   _متعد, _ניוו, _zawm_, _maße, 
   {{0x7f441d9c,0x1df80504,0x249d006f,0x02b1009a}},	//   _etiq, геры_, _yawm_, जारभ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4a551d9d,0xba5500ff,0x6d471d9e,0xaa55065b}},	// [12f0] икас, ивај, spja, иваш, 
   {{0xb05b01c4,0x3ce9006d,0x27391d9f,0x658a00ad}},	//   rkäu, siav_, _rèn_, _məhb, 
   {{0x6d5a1da0,0x249f0213,0x27390300,0x66cf0566}},	//   štar, ydum_, _sèn_, _søko, 
   {{0x6d451da1,0x237f0035,0x5c0700fd,0x27391da2}},	//   _itha, ytuj_, _бяга, _pèn_, 
   {{0xc98402f1,0x0a6b1da3,0x249d0201,0xff5f010c}},	//   _қури, _први_, _rawm_, nsî_, 
   {{0x249d023b,0x65c500a3,0xb6a500a3,0xe7361da4}},	//   _sawm_, ибла, рикл, шеш_, 
   {{0xa56400eb,0xb05b00c8,0x249f00ad,0xb925007a}},	//   مدين, nkäs, tdum_, _نفسي, 
   {{0x386000eb,0xdb06011c,0x6d451da5,0xff5f0216}},	//   óirt_, _arkè, _mtha, ksî_, 
   {{0x249f05b7,0x6d45012b,0x7d1d011c,0xb05b1da6}},	//   rdum_, _ltha, _mhss, hkäs, 
   {{0x237f00ab,0x6d451da7,0x68eb1da8,0xa2e509d9}},	//   rtuj_, _otha, ligd, роод, 
   {{0x249d01c1,0x2a7600a7,0x6d45030b,0x25b90629}},	//   _tawm_, בעתך_, _ntha, _جهاد_, 
   {{0x68eb0b1f,0x20561da9,0x25de00bc,0x60261daa}},	//   nigd, штор, _केटी_, идна, 
   {{0x6d451dab,0x10a3021f,0x443f1dac,0x60dd024a}},	//   _atha, циян, mcu_, ërma, 
   {{0x443f1dad,0x7d1d01be,0x68eb0008,0x8e7600d3}},	//   lcu_, _ahss, higd, шумч, 
   {{0x5046005e,0xa01b0019,0xddc31dae,0x68eb0008}},	//   _кейб, lföl, обри, kigd, 
   {{0x1c461daf,0x6d451db0,0x645b0502,0x00000000}},	//   рнам, _dtha, naui, --, 
   {{0x6d451db1,0x6f07015e,0x68eb1db2,0x2ca0007e}},	// [1300] _etha, bojc, digd, rdid_, 
   {{0x60c41db3,0x645b02be,0xc3320486,0xb05b01a4}},	//   _hoim, haui, קוב_, skät, 
   {{0x2d9a1db4,0x29060415,0x00000000,0x00000000}},	//   _uspe_, tooa_, --, --, 
   {{0x270e0aac,0xa9671db5,0xdca61db6,0x200c0095}},	//   ित्र_, рица_, _тами, ədir_, 
   {{0xbc19004e,0x60c41db7,0x443f1db8,0x02b500c9}},	//   _бірі_, _moim, dcu_, _अचंभ, 
   {{0x658a06d0,0x60c41db9,0x236d1dba,0x3f8200e2}},	//   _rəhb, _loim, drej_, itku_, 
   {{0x6d4501be,0x2906018e,0x00000000,0x00000000}},	//   _xtha, pooa_, --, --, 
   {{0x399b0111,0x798e011c,0x63ad1dbb,0x386400b3}},	//   _בילד, _ipbw, _šana, _udmr_, 
   {{0xdb060a13,0xe6171dbc,0xff5f0216,0xe73a1dbd}},	//   _arké, лдә_, xsî_, _рез_, 
   {{0x78a21dbe,0xf2c61dbf,0xdce70083,0x443f1dc0}},	//   ldov, рсин, mują, acu_, 
   {{0x3a370056,0x6f07003a,0x60c40149,0x78a01dc1}},	//   ירים_, vojc, _boim, _kamv, 
   {{0x60c40a9a,0x69de01f1,0x236d1dc2,0xd4671dc3}},	//   _coim, izpe, brej_, _вице_, 
   {{0x77f41a4e,0x60c41dc4,0x6d45008a,0xdce70035}},	//   _अशोक_, _doim, _stha, nują, 
   {{0x0eeb00af,0x28dd00b0,0xb05b0080,0x6ee900da}},	//   тьми_, _मतभि, tkäs, ržbo, 
   {{0x3f821dc5,0xeda41dc6,0xdef81dc7,0xd2f80019}},	//   atku_, ошто, рыя_, _لکھا_, 
   {{0x78a21dc8,0xdce700ab,0x60d61dc9,0xb05b1dca}},	//   jdov, kują, _glym, rkäs, 
   {{0x78a201d8,0xab3811b9,0x68eb1dcb,0x6d5a0613}},	// [1310] ddov, ипту_, vigd, štap, 
   {{0x6e950084,0x60c40532,0x49cb177d,0x443f1dcc}},	//   _الدا, _zoim, куем_, zcu_, 
   {{0x6d451dcd,0x68eb10de,0x2b490212,0x60c40532}},	//   _utha, tigd, spac_, _yoim, 
   {{0xa3c71dce,0x271f00e6,0xcd340c30,0x00000000}},	//   _उथल_, यग्र_, _گریب, --, 
   {{0x443f034c,0x2d83012e,0x07a51dcf,0x60c01dd0}},	//   vcu_, ltje_, салн, ömmi, 
   {{0x6b9d0068,0x64420379,0x236d0ab4,0x98bc01dd}},	//   _issg, _afoi, vrej_, īvā_, 
   {{0x2d831dd1,0xe299005e,0x443f1dd2,0x645b0be0}},	//   ntje_, қан_, tcu_, taui, 
   {{0xfdf800a7,0x66cf01cc,0x947908af,0x2d8302b0}},	//   ימוש_, _køkk, уску_, itje_, 
   {{0x60c4006e,0x68e91dd3,0x130906d4,0x443f1dd4}},	//   _roim, _imed, лний_, rcu_, 
   {{0x443f0012,0xd7f81dd5,0x236d1dd6,0xa01b1dd7}},	//   scu_, _тус_, rrej_, rföl, 
   {{0xa0a61dd8,0x66cf01cc,0x60d61dd9,0x2d831dda}},	//   банд, _løkk, _plym, jtje_, 
   {{0x236d02ee,0x26c51ddb,0xa01b0219,0x90c80148}},	//   prej_, _holo_, pföl, рғиз_, 
   {{0x60c40088,0x6f1e0183,0x66cf00dd,0x68e9084c}},	//   _voim, _phpc, _nøkk, _mmed, 
   {{0x64591ddc,0x3f821ddd,0x78a21c77,0x291f006d}},	//   _hewi, rtku_, zdov, _lhua_, 
   {{0x60c41dde,0x64590da2,0x68e90219,0x63ab016a}},	//   _toim, _kewi, _omed, _hrgn, 
   {{0xeb9a1ddf,0x26c51de0,0xb05b09eb,0xcd2a1de1}},	//   либ_, _lolo_, skär, ужбе_, 
   {{0x63bb09a1,0x2d83012e,0x5baa0009,0x212002a3}},	// [1320] nxun, atje_, ыкам_, _ihih_, 
   {{0x68fb1de2,0x64591de3,0xf4121a61,0x68e91de4}},	//   _ajud, _lewi, לפן_, _amed, 
   {{0x68fb014e,0x2722001b,0xdb041de5,0x63a40183}},	//   _bjud, _hưng_, nvié, _áinv, 
   {{0x291f1de6,0x645902bf,0x26c50054,0xd7fa1de7}},	//   _chua_, _newi, _aolo_, лул_, 
   {{0x26c50039,0x96ea1de8,0x68fb023e,0xe9670240}},	//   _bolo_, лька_, _djud, _қатл_, 
   {{0xdce70035,0x78a00532,0x68fb052b,0x68e91de9}},	//   rują, _wamv, _ejud, _emed, 
   {{0x6b841dea,0x64591deb,0x2722001b,0xdce70035}},	//   ltig, _bewi, _lưng_, sują, 
   {{0x63ab02a2,0xdce70035,0xd4971dec,0x64590175}},	//   _brgn, pują, брь_, _cewi, 
   {{0x68e300e5,0x645902bf,0xd2500084,0x26c500a9}},	//   ënde, _dewi, ونة_, _folo_, 
   {{0x6b841ded,0x68e90352,0x63ab1dee,0x00000000}},	//   itig, _zmed, _drgn, --, 
   {{0x6b841def,0xd9fa00bc,0xd3d700d7,0xe4a60165}},	//   htig, ्थित_, لبیا_, _грло, 
   {{0x64591df0,0x6b841df1,0x2ed10a34,0x63bb0068}},	//   _gewi, ktig, हस्त, bxun, 
   {{0xdfd80141,0x765a1df2,0x272200e7,0x6b84039b}},	//   бър_, _kety, _cưng_, jtig, 
   {{0xd9fa1df3,0x27220023,0x6459009e,0x66cf076b}},	//   ्थात_, _dưng_, _zewi, _røkk, 
   {{0x765a1df4,0x6b840511,0x691804b3,0xfd1f0023}},	//   _mety, etig, víen, _phì_, 
   {{0x2d830b32,0x6b841df5,0x628801da,0x753a0027}},	//   rtje_, ftig, lfdo, _mutz, 
   {{0x6b841df6,0x2d831df7,0x3ea11df8,0x6c5400d3}},	// [1330] gtig, stje_, _taht_, якту, 
   {{0x68e91df9,0x765a1dfa,0xf41a0033,0x63bd02ae}},	//   _smed, _nety, _ডলার_, äsni, 
   {{0xfd1f00f7,0x753a02ec,0x6b841dfb,0x291f0201}},	//   _thì_, _nutz, atig, _phua_, 
   {{0x26c51dfc,0x291f006f,0x48150caa,0xa3b800bc}},	//   _solo_, _qhua_, омес, ङमा_, 
   {{0x66040824,0x765a0dcb,0x6c7a00c7,0x26c51dfd}},	//   şikl, _bety, _דארפ, _polo_, 
   {{0x35c904b6,0x321c00de,0x64591dfe,0x00000000}},	//   игло_, _ozvy_, _sewi, --, 
   {{0x765a01ee,0x26c51dff,0x291f1e00,0xd05d0095}},	//   _dety, _volo_, _thua_, sisə, 
   {{0x93451e01,0x6459010c,0xf99207e4,0x68e91e02}},	//   оние, _qewi, _קרן_, _umed, 
   {{0x26c51e03,0xdcfc00e0,0x03a51e04,0x76b900d9}},	//   _tolo_, ntrā, ципо, _клар_, 
   {{0xdddc0019,0x21201e05,0x765a01da,0x79850026}},	//   zerű, _shih_, _gety, othw, 
   {{0x63bb0183,0x64591e06,0x27220023,0x7985019b}},	//   sxun, _tewi, _sưng_, nthw, 
   {{0x297a00c7,0x79850156,0x63ab0588,0x7b100380}},	//   סטרא, ithw, _trgn, läut, 
   {{0xa3bb11b7,0x9405009c,0x63ab0036,0x79500118}},	//   _حاضر_, _بوشه, _urgn, _kòwò, 
   {{0x673b095a,0x63a91e07,0x217500b3,0x161d1e08}},	//   _muuj, mven, _дуир, _फरार_, 
   {{0x63a91e09,0x6da31e0a,0xed5a1c3e,0xada31e0b}},	//   lven, мира, роб_, марл, 
   {{0x63a91e0c,0x161e00c9,0x272200e7,0xb4c702e6}},	//   oven, येटर_, _tưng_, _ईको_, 
   {{0xab6600dd,0x63a41e0d,0x6b841e0e,0x798500f8}},	// [1340] ювал, _áint, utig, ethw, 
   {{0x6b841e0f,0x63a91e10,0x00000000,0x00000000}},	//   rtig, iven, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x765a1e11,0xac760019,0x274a05b2,0x6d4e0657}},	//   _sety, _بادش, ачко_, mpba, 
   {{0x765a1e12,0x63a9012e,0x6b840104,0xd7061e13}},	//   _pety, jven, qtig, озди, 
   {{0x356a1e14,0x63a91e15,0x645d008c,0x2d8503a1}},	//   арин_, dven, ðsin, àleg_, 
   {{0xd54700ce,0xa9671e16,0xe6da0262,0x63a91e17}},	//   опје_, _мира_, _भतीज, even, 
   {{0x94aa0da9,0x387f0038,0x7d1600fb,0x67e6040c}},	//   ртка_, _gcur_, nlys, _hаjm, 
   {{0xdb0400b9,0x63a91e18,0x00000000,0x00000000}},	//   nviï, gven, --, --, 
   {{0x63a41e19,0xd56400d9,0x7d1600f8,0x6f02007a}},	//   _šins, _еӂип, hlys, _íoch, 
   {{0xdb040183,0x7d161e1a,0x6d4e01d2,0x60dd1e1b}},	//   nxiñ, klys, jpba, thsm, 
   {{0x63a91216,0x40350235,0x00000000,0x00000000}},	//   bven, яемс, --, --, 
   {{0x4ea717ac,0x63a9002e,0x7522007c,0x66cf00fc}},	//   орва, cven, _ihoz, _søki, 
   {{0xe2971e1c,0xe7f200c9,0x7d1617c6,0x00000000}},	//   _мач_, _आइना_, elys, --, 
   {{0x78170c59,0x7b1001c4,0x75220026,0xddc50241}},	//   _तर्क_, häus, _khoz, _dehş, 
   {{0xd5a4082c,0x63a40183,0xdcee01dd,0x69c300b0}},	//   _یہ_, _áins, tubā, änem, 
   {{0x28ab1615,0x79850226,0x6d4e123b,0x00000000}},	// [1350] _घोषि, wthw, apba, --, 
   {{0x7e990019,0x387f1e1d,0x395803c6,0x00000000}},	//   _اندر_, _scur_, _bwrs_, --, 
   {{0xdcfc002a,0x39580156,0x0e9a00d1,0x658a00ad}},	//   strā, _cwrs_, _השתל, _səhn, 
   {{0x236603ef,0xe5a5196c,0x79851e1e,0x6ee91e1f}},	//   _ovoj_, ҷики, rthw, džbi, 
   {{0x7d0d1e20,0xba7700eb,0x66dd1e21,0xf68000d8}},	//   moas, _واست, _lèke, ěžně_, 
   {{0x7d0d1e22,0x63a91e23,0x60dd024a,0x752201f1}},	//   loas, vven, ërmj, _ahoz, 
   {{0x39580156,0x6f060216,0x546903a1,0x00000000}},	//   _gwrs_, lîbû, байм_, --, 
   {{0x7d0d1e24,0x2ec81e25,0x75221e26,0xb4d500c2}},	//   noas, _रक्त, _choz, हसे_, 
   {{0x63a9026a,0xf3f900b3,0x6f06009e,0x225c0604}},	//   uven, faţa_, nîbû, _bevk_, 
   {{0x67211e27,0x225c0604,0x23660ed9,0x2b4b0210}},	//   _uhlj, _cevk_, _dvoj_, _mtcc_, 
   {{0x66dd011c,0xa0a61e28,0x7d0d0080,0x00000000}},	//   _cèke, панд, koas, --, 
   {{0x21060aac,0x2b4b012b,0x7d0d00b3,0x00000000}},	//   रवेश_, _otcc_, joas, --, 
   {{0x087600c7,0xe45600c7,0x2d9c0068,0xdfd20195}},	//   הערט_, _זינט_, _ávez_, ريس_, 
   {{0x75291e29,0x6f06010c,0x00000000,0x00000000}},	//   lmez, dîbû, --, --, 
   {{0x2cf9190a,0x412a1e2a,0x7d0d020f,0x7d16076b}},	//   ्कूल_, _локо_, foas, tlys, 
   {{0x0b461e2b,0x201e06d0,0x2b5901f2,0xb05b0080}},	//   знан, ətin_, _bwsc_, ljän, 
   {{0x7d16050f,0xfc030e43,0x2b5903c6,0xfce3058e}},	// [1360] rlys, епто, _cwsc_, хото, 
   {{0x7d161e2c,0x6d4e1e2d,0xdb0400b4,0x00000000}},	//   slys, ppba, txiñ, --, 
   {{0x7d160fd6,0x2d930183,0xbe3b00d1,0xdb040183}},	//   plys, _gpxe_, _לעית, uxiñ, 
   {{0x7d0d1e2e,0x68431e2f,0x6f0e0888,0xc18c0070}},	//   coas, енца, lobc, שטאָ, 
   {{0xdc370137,0x68e31e30,0x00000000,0x00000000}},	//   _מאכט_, ënda, --, --, 
   {{0x75221e31,0x7b100380,0x66e303bd,0x658a0248}},	//   _shoz, räus, ноча, _fəhl, 
   {{0x23660c88,0x8af00095,0xceb300d1,0x39e700fd}},	//   _svoj_, ssəs, תיו_, _едро_, 
   {{0x18a31e32,0x68130035,0x15ba00f0,0xd37a09f9}},	//   _пасм, _będą, _қызы_, бчо_, 
   {{0x66dd023e,0x225c0604,0x20050241,0x00000000}},	//   _sèke, _pevk_, ğlik_, --, 
   {{0xfc3f0183,0xe5a61e33,0x66dd011c,0x20050213}},	//   _maía_, _низи, _pèke, şlik_, 
   {{0x74161372,0x7d0d025b,0x00000000,0x00000000}},	//   _کوشا, yoas, --, --, 
   {{0x693703e5,0x23661e34,0x09f700d1,0x55bb00d1}},	//   _kćer, _tvoj_, למים_, _למבו, 
   {{0x7d0d1e35,0xa3cd1489,0xbff80bf8,0xdfd800fd}},	//   voas, रहण_, зеях_, пър_, 
   {{0x63a20199,0xdefb001c,0x3d95028a,0xdd9500d3}},	//   _ison, сым_, мигр, магы, 
   {{0x7d0d1e36,0x629a1e37,0xbbc5021a,0xec6b1e38}},	//   toas, meto, लङ्क, йрак_, 
   {{0x7aee01c8,0xc8ab00a5,0xfc3f0587,0x51fb00d1}},	//   _ambt, _घोंट, _baía_, _להוצ, 
   {{0x7d0d002e,0x9ccb03aa,0xfc3f0169,0x3f9d01e5}},	// [1370] roas, _ғына_, _caía_, _èwu_, 
   {{0x63a21e39,0x7d0d1e3a,0x7f4d1e3b,0x6f06009e}},	//   _mson, soas, _itaq, rîbû, 
   {{0x63a202a2,0x7d0d1e3c,0x7529021e,0x69da01a4}},	//   _lson, poas, ymez, _ütel, 
   {{0x3ce01e3d,0x63a21e3e,0x629a1e3f,0x00000000}},	//   chiv_, _oson, heto, --, 
   {{0x6d4a00e5,0xdcfc00d9,0x63a20298,0xd3661e40}},	//   _çfar, stră, _nson, _جه_, 
   {{0x629a1e41,0x658a06d0,0x2ca91e42,0x7b100502}},	//   jeto, _təhl, ldad_, säur, 
   {{0x63a21e43,0x65920267,0x7f4d00a4,0xa9a408ba}},	//   _ason, вају, _ltaq, _пиёд, 
   {{0x2ca91e44,0x7f4d0095,0xddde0118,0x00000000}},	//   ndad_, _otaq, _depň, --, 
   {{0x75290405,0x290f0730,0xb05b022b,0x629a0122}},	//   rmez, moga_, tjän, feto, 
   {{0x2bdf031e,0xe3ca0126,0x658a00ad,0x69c802be}},	//   पैया, _soñó_, _zəhm, _àdec, 
   {{0x7f4d0b85,0x63a21e45,0x93ca010e,0xdb24010e}},	//   _ataq, _eson, مایہ_, ésén, 
   {{0x290f1e46,0x386d011c,0x6aa70604,0x00000000}},	//   noga_, _jder_, _lajf, --, 
   {{0x2ca91e47,0x27200054,0x03a500d9,0x290f00b9}},	//   ddad_, lòna_, _цило, ioga_, 
   {{0x2ca90369,0xe29600d3,0x629a1e48,0x290f1e49}},	//   edad_, _жаш_, ceto, hoga_, 
   {{0x386d02e7,0x290f0112,0x6f0e0076,0xa0a608a5}},	//   _oder_, koga_, robc, _жайд, 
   {{0x386d024a,0x7f4d008a,0xb05b0080,0xb5fc01f2}},	//   _nder_, _ftaq, njäl, _weġg, 
   {{0x6aa70082,0x394d0352,0x290f01ff,0xdb0600da}},	// [1380] _bajf, _česa_, doga_, _arká, 
   {{0x386d00e2,0xb05b183f,0x63a61e4a,0x7d090352}},	//   _ader_, hjäl, ækni, česa, 
   {{0xe8200081,0x888608a7,0x290f1e4b,0x62830126}},	//   _बरहा_, длеж, foga_, _mcno, 
   {{0xa3bf00a5,0xa3cd1e4c,0x61ee0183,0x27200379}},	//   ीहा_, रहा_, úbli, dòna_, 
   {{0x8cdb07d5,0x66e61e4d,0x629a1e4e,0xd70a00b3}},	//   नसरो, мода, yeto, онде_, 
   {{0x473300dd,0x386d1e4f,0x629a0183,0xb5fc01f2}},	//   вніс, _eder_, xeto, _leġe, 
   {{0xe8200081,0x290f1e50,0x69d8192b,0x66cf0664}},	//   _बरवा_, boga_, øved, _røkt, 
   {{0x32db009e,0x3eba0065,0x629a1e51,0x66cf017b}},	//   _rêya_, _lnpt_, weto, _søkt, 
   {{0xd90d182b,0x629a1e52,0xa68602f1,0x22490241}},	//   _این_, teto, _олад, _şaka_, 
   {{0xb6cb0105,0x68e200da,0xd62a1e53,0x45d609f9}},	//   _والے_, lhod, _дозе_, _оцет, 
   {{0x94861e54,0x629a1e55,0x658a06d0,0x02a3012d}},	//   _жылд, reto, _məhk, трым, 
   {{0x63a21e56,0x75490019,0x386d00e2,0x68e2019c}},	//   _tson, őszö, _xder_, nhod, 
   {{0x3eba016a,0x26cc1e57,0x04431c52,0x63a21e58}},	//   _bnpt_, _kodo_, _речн, _uson, 
   {{0xe1ef125e,0x7ce30077,0x3eba0183,0xfc3f001d}},	//   اسی_, _kõrg, _cnpt_, _caín_, 
   {{0x9f341e59,0xdc3a0c05,0xc32700eb,0x290f1e5a}},	//   тері, _açık, _تكون_, yoga_, 
   {{0xe7ab0228,0x66dd011c,0x68e200da,0x6aa71e5b}},	//   _ďaľš, _mèka, jhod, _sajf, 
   {{0x2ca91e5c,0x68e20412,0x290f1e5d,0x00000000}},	// [1390] rdad_, dhod, voga_, --, 
   {{0x26cc1e5e,0x60cd1e5f,0xcf270195,0x27e60175}},	//   _nodo_, _hoam, _تربي, dzon_, 
   {{0x290f1e60,0x2ca90102,0x7ce300b0,0xb05b0080}},	//   toga_, pdad_, _nõrg, yjäl, 
   {{0xf8690038,0x2fe4027e,0x00000000,0x00000000}},	//   سمتي_, _örgü_, --, --, 
   {{0x26cc1e61,0x6aa71e62,0x60cd07d7,0xf7f41372}},	//   _bodo_, _tajf, _moam, پسند, 
   {{0x26cc033c,0x290f1e63,0x6f02007a,0x60cd0175}},	//   _codo_, soga_, _íoct, _loam, 
   {{0x04451e64,0x27e60379,0x68e20604,0x62831e65}},	//   нейн, azon_, bhod, _rcno, 
   {{0x68e2173b,0x27e6027e,0x60cd0054,0x2f16003e}},	//   chod, bzon_, _noam, lægt_, 
   {{0x248d0588,0xe3b10ce0,0x7d030068,0x92f501fc}},	//   rfem_, ارب_, _ínsu, ечні, 
   {{0xd17500f0,0x26cc1e66,0xb05b1e67,0x248d0a35}},	//   нымы, _godo_, själ, sfem_, 
   {{0x78a900b0,0xcb120486,0x80a90bf1,0x6738020b}},	//   _kaev, רלי_, গান্, žajú, 
   {{0x26c702f5,0x98b800e0,0xfc3f0068,0xe454012d}},	//   ljno_, _kurā_, _saín_, _акцы, 
   {{0x95220105,0x60cd002e,0x78a906e8,0xb05b00c8}},	//   _حکوم, _doam, _maev, nkäy, 
   {{0x68e208d7,0x78a91e68,0x6da60240,0xd36e1e69}},	//   zhod, _laev, нига, _اهو_, 
   {{0x7d09090b,0x60cd1e6a,0x3eba0023,0x27e6010e}},	//   česn, _foam, _vnpt_, zzon_, 
   {{0xdca31e6b,0x76930540,0x64491e6c,0x62811e6d}},	//   ласи, lıyı, ncei, lglo, 
   {{0xeb970dc0,0xac071e6e,0x68e21e6f,0x683601f0}},	// [13a0] нит_, ента_, vhod, _müdü, 
   {{0x09e61e70,0x4e1100bc,0x76930585,0x00000000}},	//   нозн, _दुवै_, nıyı, --, 
   {{0xae5b0056,0xd910006b,0x68e20dd0,0x26cc1e71}},	//   _מכיר, لیس_, thod, _rodo_, 
   {{0xa01b022b,0x38600084,0x26cc0009,0x68e200bc}},	//   mför, úir_, _sodo_, uhod, 
   {{0xa01b014e,0x26cc1e72,0x68e21e73,0x6d4a019c}},	//   lför, _podo_, rhod, _éfab, 
   {{0xb5a61e74,0x644b055f,0x27e61e75,0x56941e76}},	//   ерий, _afgi, rzon_, такт, 
   {{0x68e20ca5,0xa01b1e77,0x26cc02ee,0xab27186c}},	//   phod, nför, _vodo_, _чора_, 
   {{0x7ce300b0,0xd37a1e78,0x69340eb7,0x7cfb0080}},	//   _võrg, пчо_, _شکار, märä, 
   {{0x26cc0e2e,0x29041e79,0x22860258,0x68e00104}},	//   _todo_, _ijma_, нунг, _ilmd, 
   {{0x60cd1e7a,0xa01b014e,0x026a0088,0x62810219}},	//   _soam, kför, чший_, gglo, 
   {{0x73d903a1,0xb5fc01f2,0x00000000,0x00000000}},	//   здөр_, _weġb, --, --, 
   {{0xa01b014e,0xfbe000a5,0x644903dd,0x443d052b}},	//   dför, फनाम, ccei, _ggw_, 
   {{0x60cd0180,0x673a0180,0xddcc00bc,0x4e161e7b}},	//   _voam, _kitj, _čišt, _दुबई_, 
   {{0x661a1e7c,0x673a00c3,0x00000000,0x00000000}},	//   _kytk, _jitj, --, --, 
   {{0xdd941088,0x673a0161,0x60cd1e7d,0xa01b0219}},	//   лары, _mitj, _toam, gför, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2f1602c9,0xb05b0080,0x00000000,0x00000000}},	// [13b0] tægt_, hjäk, --, --, 
   {{0xff500038,0x78a900bd,0x673a1e7e,0x00000000}},	//   _اخي_, _saev, _nitj, --, 
   {{0x317e1e7f,0x661a0080,0x78a91e80,0x6d5e00f3}},	//   nutz_, _nytk, _paev, _gwpa, 
   {{0x6ee20228,0x00000000,0x00000000,0x00000000}},	//   _vôbe, --, --, --, 
   {{0x07a514ec,0x317e01c4,0x7ce3007e,0xc7a50093}},	//   талн, hutz_, _võrd, тилк, 
   {{0xcf9400c7,0x7e6702c7,0x24860054,0x6b8d1e81}},	//   רטס_, najp, _acom_, mtag, 
   {{0x6b8d0525,0xceb4042c,0x673a0194,0xa39e0218}},	//   ltag, טיס_, _ditj, _pêşî_, 
   {{0xdb06074b,0x62811e82,0x248601be,0x673a02b0}},	//   _erkä, wglo, _ccom_, _eitj, 
   {{0x6b8d1e83,0x47351e84,0x479411b7,0x644918d1}},	//   ntag, _анас, _مجلس, rcei, 
   {{0x57f41e85,0x64491e86,0x291d0149,0x6b8d1e87}},	//   _спут, scei, llwa_, itag, 
   {{0x05740109,0xc0e6021d,0x291d1e88,0x69c50034}},	//   _ماند, вонк, olwa_, nxhe, 
   {{0xe3751472,0x63ad0bfc,0xa01b0219,0x6b8d1e89}},	//   _алды, _šanu, vför, ktag, 
   {{0xa85600a7,0x660405b7,0x2129023e,0x332701d2}},	//   כירה_, şikt, _dhah_, _thnx_, 
   {{0xe1f109e8,0x6b8d1e8a,0x249f1e8b,0x658a06d0}},	//   _پست_, dtag, leum_, _səhi, 
   {{0x213b1e8c,0x8d630886,0x92580038,0x0d9911ec}},	//   _fiqh_, ивре, _أشهر_, нтты_, 
   {{0xa01b1e8d,0x00000000,0x00000000,0x00000000}},	//   rför, --, --, --, 
   {{0xa01b022b,0xcb671e8e,0x6b8d1e8f,0xaa460d3b}},	// [13c0] sför, кате_, gtag, везл, 
   {{0xa01b0219,0x249f1e90,0x00000000,0x00000000}},	//   pför, heum_, --, --, 
   {{0xfaa31e91,0xef1f010e,0x673a01d2,0xa96700fd}},	//   рахо, ztük_, _ritj, виха_, 
   {{0x673a1e92,0x080a009c,0x1b4a00a3,0x249f0096}},	//   _sitj, وزشي_, _озми_, jeum_, 
   {{0x673a1e93,0x2ca0007e,0x27290228,0x18671e94}},	//   _pitj, meid_, kúnd_, тачи_, 
   {{0x2ca01e95,0x98b8011c,0xc1780009,0x66dd0118}},	//   leid_, _bură_, yrė_, _dèko, 
   {{0x5fa9000f,0x888413b4,0x4420012d,0xb0e207d5}},	//   _चैनल, _میان, _ši_, _पतंग, 
   {{0x4420001b,0x2ca000b0,0x249f0096,0xef1f010e}},	//   _ơi_, neid_, geum_, ttük_, 
   {{0xccf30056,0x2b4600eb,0x673a003d,0x07a31e96}},	//   יכה_, íoch_, _titj, _катн, 
   {{0x2ca01e97,0x21291e98,0x2d9a03a9,0x673a12b6}},	//   heid_, _shah_, _oppe_, _uitj, 
   {{0x60f91e99,0x2ca01e9a,0x6b8d01ca,0xf2c300f0}},	//   ення_, keid_, ztag, рсын, 
   {{0x6b8d1e9b,0xdb0400c8,0x249f1e9c,0x64a61329}},	//   ytag, lviä, ceum_, _јада, 
   {{0x442000e7,0x44321e9d,0x2ca000b0,0x996200bc}},	//   _ái_, _ày_, deid_, _níže_, 
   {{0x4426037d,0x2d471e9e,0x6b8d1e9f,0x6d4304c6}},	//   _izo_, _põe_, vtag, _énak, 
   {{0x44260054,0x00000000,0x00000000,0x00000000}},	//   _hzo_, --, --, --, 
   {{0x6b8d1ea0,0x2009006d,0x2ca000bd,0x5c741271}},	//   ttag, _txai_, geid_, илст, 
   {{0xbab90278,0x6b8d1ea1,0x00000000,0x00000000}},	// [13d0] нгах_, utag, --, --, 
   {{0x6b8d1ea2,0x7a40026e,0xbb1900eb,0x249f1ea3}},	//   rtag, vští, رياض_, zeum_, 
   {{0x6b8d1ea4,0x2ca01ea5,0x291d07d7,0x49751ea6}},	//   stag, beid_, tlwa_, улес, 
   {{0xf7711ea7,0x2ca000a1,0x98ad00ab,0x60dd012d}},	//   مات_, ceid_, _mieć_, nksm, 
   {{0xd7f50f6b,0x6d451ea8,0xb05b1624,0x44260bcf}},	//   ызды, _huha, rjäh, _nzo_, 
   {{0x6d451ea9,0x6f151eaa,0xb3850f5a,0xd6db06ba}},	//   _kuha, nozc, ҳлил, ьте_, 
   {{0x44260489,0x6d451eab,0x29881eac,0xa8a71ead}},	//   _azo_, _juha, _исто_, _ирак, 
   {{0xf3f900d9,0x60dd02b0,0xd92800b3,0x15b81eae}},	//   laţi_, jksm, _ацул_, тышы_, 
   {{0x249f005f,0xe7960116,0x58d400a3,0x42d51eaf}},	//   reum_, _مالک, _тотт, гіну, 
   {{0x63ad00f1,0xdb0400ce,0x2fd902bf,0xf3f900b3}},	//   _šans, rviç, dysg_, naţi_, 
   {{0x44260547,0xf8c70466,0x658a00ad,0x00000000}},	//   _ezo_, _रचाय, _səhv, --, 
   {{0xcea90a33,0xf4871b11,0x455a00d1,0x61fc007a}},	//   _מי_, _јужн, _נכנס, úrla, 
   {{0x645b1eb0,0x7f441eb1,0x7760006d,0x8e7602f1}},	//   mbui, _quiq, _xwmx, лувч, 
   {{0x6d451eb2,0x201e00e0,0xf3f900b3,0x645b1eb3}},	//   _buha, āti_, jaţi_, lbui, 
   {{0xfce61eb4,0x2ca0007e,0xe2960141,0xf3f900b3}},	//   гово, teid_, _сащ_, daţi_, 
   {{0x6d451eb5,0xee370a10,0x645b01d2,0x6cc603a1}},	//   _duha, унс_, nbui, ыйба, 
   {{0x2ca01eb6,0x0c261e53,0x6d451eb7,0xa01b1eb8}},	// [13e0] reid_, уман, _euha, ngöl, 
   {{0x2ca00077,0xf3f900b3,0x6d450054,0xb602019c}},	//   seid_, gaţi_, _fuha, _àágu, 
   {{0x3f821eb9,0x6d45024d,0x2d9a014e,0x2ca01eba}},	//   luku_, _guha, _uppe_, peid_, 
   {{0x7d7b0111,0xa3e300ab,0x645b039b,0x00000000}},	//   _אנטו, नना_, jbui, --, 
   {{0x7d041ebb,0x6d451ebc,0x3f821ebd,0x69c31ebe}},	//   mnis, _zuha, nuku_, äner, 
   {{0xf3f9002e,0x7d041ebf,0x236d0032,0x645b040b}},	//   caţi_, lnis, dsej_, ebui, 
   {{0x3f820204,0x224e00b4,0xe5100249,0xdcfc0121}},	//   huku_, _rffk_, ावलि_, hurč, 
   {{0x33741ec0,0x3f821ec1,0x7d04107d,0x44260372}},	//   агир, kuku_, nnis, _pzo_, 
   {{0xd70a01d0,0x7d041ec2,0x3f821ec3,0xb5c6004e}},	//   _знае_, inis, juku_, _әйел, 
   {{0x7d041ec4,0x78a21ec5,0x92b60038,0x3f821ec6}},	//   hnis, leov, احظا, duku_, 
   {{0x7d041ec7,0x6f150098,0xe3b20296,0x645b02a5}},	//   knis, vozc, _گرا_, bbui, 
   {{0x338619aa,0x6d451ec8,0x3f821ec9,0x2ba51eca}},	//   _букв, _ruha, fuku_, _ऑनला, 
   {{0x6d451ecb,0x3f821ecc,0x60dd1ecd,0x644202dc}},	//   _suha, guku_, rksm, _igoi, 
   {{0x6d451ece,0x7d041ecf,0x62341ed0,0xf1a61ed1}},	//   _puha, enis, _келу, _брин, 
   {{0x59a4006a,0x7d041ed2,0xf3f9020f,0x6f1518c1}},	//   _गैलर, fnis, vaţi_, rozc, 
   {{0x3f821ed3,0x6d451ed4,0xd9041c03,0xdb040ff2}},	//   buku_, _vuha, _ری_, bwië, 
   {{0xf3f900d9,0x78a21ed5,0xdbc601c4,0x69d801e8}},	// [13f0] taţi_, deov, röße, øven, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7d0402f2,0x658a0095,0xad270274,0xf3f900d9}},	//   bnis, _məhs, _مرحو, raţi_, 
   {{0xe82000b0,0x3ea31bf6,0x64421ed6,0xf3f900b3}},	//   _बरखा_, lejt_, _ngoi, saţi_, 
   {{0x62981425,0x2d910a9f,0xd5b80339,0x96651ed7}},	//   _obvo, ltze_, _arā_, акле, 
   {{0x4b7a0070,0x64421ed8,0x2d9101d6,0x00000000}},	//   _באשו, _agoi, otze_, --, 
   {{0x2d831175,0x2d9101f1,0x645b1a77,0x3f821ed9}},	//   nuje_, ntze_, tbui, zuku_, 
   {{0x09e11933,0x67d51eda,0x6298045a,0x2d9101cf}},	//   पनीय, _кобу, _abvo, itze_, 
   {{0x2d830a41,0xb4d50a44,0xe7871edb,0x645b1edc}},	//   huje_, _सकी_, _љубо, rbui, 
   {{0x3ae4022b,0x64421edd,0x3f82034c,0xa3c60d0d}},	//   _köpa_, _egoi, vuku_, _उपर_, 
   {{0x41061ede,0x20c6040c,0x7d041edf,0x03c70259}},	//   изов, айнм, ynis, _әсем, 
   {{0xf5300038,0xdddc0604,0x00000000,0x00000000}},	//   _فإن_, jgrš, --, --, 
   {{0x7d040d26,0x8c3b0502,0x00000000,0x00000000}},	//   vnis, _maßs, --, --, 
   {{0x3f8202f5,0x2d831ee0,0xc8e20035,0xef1700d9}},	//   ruku_, fuje_, _खत्म_, имя_, 
   {{0x7d041ee1,0x3f821ee2,0x6da615dd,0xacf61b11}},	//   tnis, suku_, шива, ачај, 
   {{0x3f821ee3,0x26f204cc,0x7ce300b0,0xdb0f00b9}},	//   puku_, _अग्र_, _põra, _arcà, 
  
   {{0x7d040ea5,0x5a660df3,0x8fa61ee4,0x2d9100b4}},	// [1400] rnis, икаб, _тапе, atze_, 
   {{0x2d831ee5,0xeb971ee6,0x658a00ad,0xba26012d}},	//   buje_, риф_, _məhr, адзк, 
   {{0x7e7b00a7,0xc8661ee7,0xed5a1ee8,0xb5fc008a}},	//   _באיז, атли, _шон_, _reġo, 
   {{0x7c96011f,0x00000000,0x00000000,0x00000000}},	//   _троц, --, --, --, 
   {{0x27e0057f,0xc60e017d,0x78a200df,0x4b5500fd}},	//   áin_, िथ्य_, reov, _гъст, 
   {{0x78a21ee9,0x6442004c,0x6b841eea,0x00000000}},	//   seov, _sgoi, muig, --, 
   {{0x35671472,0x5f0907d5,0x6b8400a1,0x27e01eeb}},	//   арын_, _सदस्_, luig, šin_, 
   {{0xd9431eec,0x63b90090,0x658a00ad,0x00000000}},	//   _фети, _brwn, _bəhr, --, 
   {{0x667600c5,0xb4d600a2,0x26161bec,0x1afb0033}},	//   _ندار, _हवी_, _पुरी_, ্তরে_, 
   {{0x4ac91eed,0x2d83016c,0x00000000,0x00000000}},	//   रायव, yuje_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2d830076,0x29061cd3,0xd5fb00d1,0x6b84018e}},	//   vuje_, nnoa_, _בפבר, kuig, 
   {{0x658a06d0,0x893700c7,0x61ff0095,0x2d830035}},	//   _təhs, ירטע_, _əylə, wuje_, 
   {{0xdefb00e4,0x539b0486,0x6b841eee,0x00000000}},	//   тым_, _סיוו, duig, --, 
   {{0x27290038,0x3ea3024a,0x69d801e8,0xcf8e009c}},	//   núna_, rejt_, øvel, وژی_, 
   {{0x3ea31eef,0x2d9101f1,0x2c78017b,0x00000000}},	//   sejt_, rtze_, ийсь_, --, 
   {{0x3a751617,0x3ea300e5,0x6f950038,0x6b840151}},	// [1410] йлар, pejt_, _الخض, guig, 
   {{0x3ce9006f,0xdd8700d9,0xed4e010e,0x00000000}},	//   shav_, _кымп, بھی_, --, 
   {{0xc9871ef0,0xf9f90038,0x29871ef1,0x3ce9004f}},	//   рузи, دفاع_, рызг, phav_, 
   {{0xb4d509e2,0x6d5701f1,0x6b8401da,0xa3c600bc}},	//   _सके_, _itxa, buig, उमा_, 
   {{0x6d48014b,0xb05b0080,0x00000000,0x00000000}},	//   ídav, ljäs, --, --, 
   {{0x9a841ef2,0x29061a14,0x00000000,0x00000000}},	//   _мусл, anoa_, --, --, 
   {{0x7ae70065,0x25ac0108,0x00000000,0x00000000}},	//   _iljt, _csdl_, --, --, 
   {{0xe91900dd,0x79850bcf,0x00000000,0x00000000}},	//   _собі_, muhw, --, --, 
   {{0xdd0202c7,0xa8250444,0x658a00ad,0xdb0f02d9}},	//   šuću, _اکان, _qəhr, _zrcá, 
   {{0x6d5701ca,0x00000000,0x00000000,0x00000000}},	//   _otxa, --, --, --, 
   {{0x6d5701a0,0x6b8401c8,0xd9f91126,0x00000000}},	//   _ntxa, zuig, ्पित_, --, 
   {{0x628801da,0x21a50148,0x658a0248,0x00000000}},	//   agdo, _ҳикм, _təhr, --, 
   {{0x6d5701ca,0xfe7a012d,0x5eb10033,0x63b9016c}},	//   _atxa, лёвы_, ঞানে, _urwn, 
   {{0x63a91ef3,0xd9f91a4e,0x00000000,0x00000000}},	//   mwen, ्पात_, --, --, 
   {{0x63a91ef4,0x8db5004f,0x79850175,0x80b00033}},	//   lwen, ості, juhw, টাব্, 
   {{0x6b841ef5,0xb4d51ef6,0x1c46011f,0x307a0038}},	//   tuig, _सको_, снам, _صحبة_, 
   {{0x60c41ef7,0x63a91ef8,0x3ce0017e,0x6d5701f1}},	// [1420] _inim, nwen, rkiv_, _etxa, 
   {{0xff2601d7,0x4bd90080,0x00000000,0x00000000}},	//   _ымпо, шься_, --, --, 
   {{0x63a91ef9,0xbed700c7,0x60d6027e,0x79850175}},	//   hwen, _הויז_, _koym, guhw, 
   {{0xb4d60bf0,0x6d5c0b01,0x63a91efa,0xe89400dd}},	//   _हवे_, mpra, kwen, іаль, 
   {{0x29061efb,0xa77301fc,0xbcb700d1,0x628802c9}},	//   rnoa_, зліч, _הפכו_, ygdo, 
   {{0x6ffc00e0,0xef1f01f0,0x63a91efc,0xc3480108}},	//   mācī, ltür_, dwen, _bổn_, 
   {{0x60c403ef,0x6d5c0cd7,0x6d4302be,0xc7af010e}},	//   _onim, npra, _énat, وڑے_, 
   {{0xdbdd0228,0x98bc01dd,0x98a60613,0x63a91efd}},	//   zšír, īvē_, dmoć_, fwen, 
   {{0x96961efe,0x63a91eff,0x7e6e01dd,0xb7f21f00}},	//   _греш, gwen, kabp, _आइटम_, 
   {{0x68e20019,0x69c10183,0x6d5c1f01,0x59dc1f02}},	//   lkod, _álec, kpra, _यथार, 
   {{0xba9b0070,0x658a00ad,0x5a9b0070,0x62881f03}},	//   נסטי, _təhq, נשטא, rgdo, 
   {{0xa1930451,0x63a901a1,0x6d5c1f04,0x68e21f05}},	//   чаюч, bwen, dpra, nkod, 
   {{0x7afe010d,0x5f941b4b,0x53a30fc8,0xb05b02ae}},	//   kipt, пият, _нацб, fjär, 
   {{0xb5fc0405,0x7afe024a,0x60c41f06,0xdef800f0}},	//   _reġj, jipt, _enim, быс_, 
   {{0x6d5c1b10,0x68e21f07,0x0dc81f08,0xab5b1f09}},	//   gpra, kkod, бути_, _krüg, 
   {{0x9986006a,0x657c14a4,0x2d730b91,0x25e0034d}},	//   łoś_, _århu, rće_, _कथनी_, 
   {{0x8b580038,0x2d730082,0x09e1009a,0x8af9013b}},	// [1430] مجلس_, sće_, पन्य, анас_, 
   {{0x2d731f0a,0x3a75004e,0x39eb021d,0x6e990009}},	//   pće_, ілер, льен_, _твор_, 
   {{0x7f3c00c7,0x69de0dec,0x63a91f0b,0x2a7801a7}},	//   _געזו, gype, zwen, _ddrb_, 
   {{0x63a91f0c,0x9bc70238,0xad270399,0x3869010d}},	//   ywen, _лёгк, _درخو, úar_, 
   {{0x63a9010c,0x395800b9,0xd6c301ff,0x00000000}},	//   xwen, _etrs_, зилқ, --, 
   {{0xab5b02f2,0xe7391f0d,0xb5791ca5,0x201e0474}},	//   _prüf, шел_, ащих_, ştig_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x68e21f0e,0x63a91f0f,0x280400bc,0x00000000}},	//   ckod, twen, ásná_, --, 
   {{0x63a90b32,0x25a0020f,0x00000000,0x00000000}},	//   uwen, ăila_, --, --, 
   {{0x60c400f1,0x81d400cc,0x68e9000d,0x63a91f10}},	//   _snim, _সেই_, _hled, rwen, 
   {{0x63a90149,0x68e91f11,0x545502c4,0x68fb02a2}},	//   swen, _kled, _двет, _kmud, 
   {{0x6d5c008b,0x60d60095,0x68e9011c,0x00000000}},	//   vpra, _qoym, _jled, --, 
   {{0xb05b014e,0xfc3f1f12,0x68fb1f13,0x2b591f14}},	//   tjär, _maís_, _mmud, _ntsc_, 
   {{0x6d5c1f15,0x68e21f16,0x539a0486,0x68e900f8}},	//   tpra, zkod, _כינו, _lled, 
   {{0x82370a24,0x290d0068,0x2b590096,0x98a40009}},	//   _ارشا, _ojea_, _atsc_, _gimė_, 
   {{0x39581f17,0x2a6a00e2,0xb05b1f18,0xac0a00a3}},	//   _rtrs_, _sebb_, sjär, анба_, 
   {{0xa11300eb,0x2a78016a,0xa2cd1f19,0x394a1f1a}},	// [1440] _تويت, _pdrb_, ताप्, _subs_, 
   {{0x68fb1f1b,0x6d5c1f1c,0x68e9001d,0x290d00b4}},	//   _amud, ppra, _aled, _ajea_, 
   {{0x8c461f1d,0x7afe1f1e,0x6f1c1f1f,0xdcfc00b3}},	//   _мене, ript, morc, gură, 
   {{0x69de1f20,0x319a0070,0xc7c600c8,0xab5b0380}},	//   rype, יבענ, жски, _brüd, 
   {{0x7d090588,0x68e9011c,0x69de0098,0x26c50534}},	//   čest, _dled, sype, _bnlo_, 
   {{0x7afe078e,0x68e21f21,0x6f1c0954,0x394a0293}},	//   qipt, skod, norc, _tubs_, 
   {{0xbb430934,0xc448017a,0xa2cd1f22,0xab5b00b0}},	//   _церк, میان_, तान्, _prüg, 
   {{0xd4971f23,0x151700eb,0xd250009c,0x00000000}},	//   орь_, يزية_, کند_, --, 
   {{0x394400f4,0x6f1c0db8,0x6b961f24,0x00000000}},	//   _iims_, korc, ntyg, --, 
   {{0xb5fc003d,0xe5a61f25,0xa3140083,0x00000000}},	//   _leġi, _мизи, डवेज_, --, 
   {{0x7ce300b0,0x3f821f26,0x6104039f,0xdcfc0243}},	//   _sõrm, erku_, zőle, ntrē, 
   {{0x69c80151,0x00000000,0x00000000,0x00000000}},	//   _àdeu, --, --, --, 
   {{0x6f1c1f27,0x7afc0604,0x00000000,0x00000000}},	//   forc, _omrt, --, --, 
   {{0x6f1c003a,0x63a2084c,0x3cfd0299,0x415401d8}},	//   gorc, _ipon, रोने_, _евкс, 
   {{0x3eb30095,0x2b4b01d8,0xdb0d02aa,0x273200b3}},	//   _vaxt_, _succ_, lvaç, mând_, 
   {{0x1fa71f28,0x9f6b02a6,0x8b670038,0x3b551f29}},	//   _дрог, _кроз_, قائم, зкар, 
   {{0x200c06d0,0x6f1c1f2a,0x2d680474,0x00000000}},	// [1450] şdir_, borc, aşe_, --, 
   {{0x68fb1f2b,0x63a21f2c,0x6f1c1f2d,0xf43b00a7}},	//   _smud, _mpon, corc, שתמש, 
   {{0xdcf50035,0xa2b200bc,0x99990d75,0x68e91f2e}},	//   erzą, _असन्, скет_, _pled, 
   {{0x63a21f2f,0x394403dd,0xaac91f30,0xc23700d1}},	//   _opon, _cims_, राहक, קראו_, 
   {{0x995400bc,0x37ab1f31,0x39440b41,0xdcfc0474}},	//   _výše_, ртен_, _dims_, sură, 
   {{0x2ca91f32,0x26e30086,0xb34502aa,0x68e900f8}},	//   lead_, কোনো_, _liçã, _wled, 
   {{0x63a21f33,0x68e9105b,0x39440237,0xfc3f019c}},	//   _apon, _tled, _fims_, _taís_, 
   {{0x68fb1f34,0x2ca91f35,0xaac91f36,0xe918004f}},	//   _umud, nead_, रावक, _досі_, 
   {{0xe2990a31,0x291d1f37,0x629a02a5,0x39951950}},	//   бап_, mowa_, ffto, lås_, 
   {{0x2ca91f38,0x291d1f39,0x386d0d2d,0x273200b3}},	//   head_, lowa_, _heer_, gând_, 
   {{0x386d1f3a,0x63a21f3b,0x7d08014b,0x39951f3c}},	//   _keer_, _epon, édsk, nås_, 
   {{0x23751b65,0x7cf10075,0x291d1f3d,0xd59a00d1}},	//   _فاتح, _hårf, nowa_, _לבעל, 
   {{0x386d1f3e,0xb5fc0405,0x7ce300c2,0x2d831f3f}},	//   _meer_, _reġi, _tõrj, erje_, 
   {{0x386d1f40,0x291d1f41,0x273200d9,0x248d1f42}},	//   _leer_, howa_, când_, lgem_, 
   {{0xa928026e,0xed5a0cdf,0x291d1f43,0x63bb003e}},	//   ližš, соб_, kowa_, lvun, 
   {{0x2ca901be,0x7afc00d8,0x6f1c001d,0x386d0318}},	//   gead_, _smrt, sorc, _neer_, 
   {{0xfc3f0496,0x291d00ab,0x2d831f44,0x3b860e31}},	// [1460] _saír_, dowa_, arje_, ялаг, 
   {{0xe81f0c06,0x6b96014e,0x8b2300c8,0x7cea003e}},	//   _बड़ा_, rtyg, едуе, _dýra, 
   {{0x39950430,0x6edb00d1,0x66dd011c,0x61e11e3a}},	//   gås_, _החיפ, _lèks, nyll, 
   {{0x2fc0017e,0x3eaa0380,0x273200b3,0x3e5700bc}},	//   _krig_, lebt_, zând_, pětí_, 
   {{0x4cbb0056,0x2d981f45,0xdcfc002a,0x2d8a1f46}},	//   _הזכו, ltre_, strē, lube_, 
   {{0x6d461f47,0xb4b40262,0x6b841f48,0x7997006d}},	//   _hika, _छोड़_, mrig, btxw, 
   {{0x6d461f49,0x2d981f4a,0x291d1f4b,0x2d8a1f4c}},	//   _kika, ntre_, bowa_, nube_, 
   {{0x94aa1f4d,0x6eeb06d0,0x6d4603f6,0x2d981f4e}},	//   стка_, _müba, _jika, itre_, 
   {{0x6d461f4f,0x6b841f50,0x2fc0006f,0x273200b3}},	//   _mika, nrig, _nrig_, tând_, 
   {{0x386d0b32,0x61e11f51,0x248d02a0,0xdb0d02a0}},	//   _zeer_, fyll, agem_, rvaç, 
   {{0x6b841f52,0x273200d9,0x2d8a1f53,0x64a61f54}},	//   hrig, rând_, jube_, _нажа, 
   {{0x2fc002bf,0xc058004e,0x9f4e014b,0xdb0f022c}},	//   _brig_, зір_, žným_, _escè, 
   {{0x613f002a,0x3869003e,0x273200d9,0x63a21f55}},	//   _jūli, ðari_, pând_, _upon, 
   {{0x44261f56,0x6d46030f,0x6136003e,0x61e11f57}},	//   _iyo_, _aika, jálf, byll, 
   {{0x6d461f58,0x44261f59,0x06fd031e,0x6b841f5a}},	//   _bika, _hyo_, _říká_, erig, 
   {{0x6d461f5b,0x44260547,0x2d8300e5,0x2fc01f5c}},	//   _cika, _kyo_, rrje_, _frig_, 
   {{0x2d9c14f9,0x6d461f5d,0x57c600a2,0x2ca912eb}},	// [1470] _även_, _dika, लमोह, read_, 
   {{0x7cea0076,0x3995105d,0xf1b01f5e,0x386d0876}},	//   _výra, tås_, _जनान, _seer_, 
   {{0x6d461f5f,0x291d1f60,0x75221f61,0xab5b0380}},	//   _fika, towa_, _okoz, _brüc, 
   {{0xf7710523,0x3995022b,0xddde031e,0x6d460bc1}},	//   نات_, rås_, _nepř, _gika, 
   {{0x291d1f62,0x7997006d,0x44261f63,0x611200e0}},	//   rowa_, stxw, _nyo_, nāla, 
   {{0x386d01b2,0x291d1f64,0x6d461f65,0xd24600eb}},	//   _weer_, sowa_, _zika, _لن_, 
   {{0xc9841f66,0x44261f67,0x672102ee,0x752200ef}},	//   _пути, _ayo_, _vklj, _bkoz, 
   {{0x7d0d1f68,0x44261f69,0x61120243,0x61e10080}},	//   nnas, _byo_, kāla, vyll, 
   {{0x248d1f6a,0x4426024d,0xdb1d1f6b,0x61e10156}},	//   rgem_, _cyo_, _arsé, wyll, 
   {{0x672100f1,0x7cf11f6c,0x7d0d02bf,0x61e11f6d}},	//   _uklj, _hård, hnas, tyll, 
   {{0x3dc1006d,0x7d0d1f6e,0x44260298,0x6147023e}},	//   _nrhw_, knas, _eyo_, dèlè, 
   {{0x61e11f6f,0x7d0d00ef,0x63a4020f,0x66dd1e21}},	//   ryll, jnas, _ţine, _tèks, 
   {{0x61e102f0,0x6d461f70,0xdb0f1f71,0xe28e1f72}},	//   syll, _rika, _escé, _иа_, 
   {{0x2d981f73,0x6d461f74,0x75291f75,0x2d8a1f76}},	//   ttre_, _sika, llez, tube_, 
   {{0x31161f77,0x6b841f78,0x5f271f79,0x7d0d003e}},	//   _офис, wrig, форм_, fnas, 
   {{0xd1321f7a,0x2d981f7b,0x7d0d008c,0xdca302f1}},	//   _جمع_, rtre_, gnas, каси, 
   {{0xeb971f7c,0xddc71f7d,0x0b4600dd,0x4426006d}},	// [1480] мит_, rajš, днан, _xyo_, 
   {{0x6d460c3d,0xa01b1f7e,0x7c26014b,0x7d0d1f7f}},	//   _wika, rgöt, _vykr, anas, 
   {{0x6d461f80,0x644b01d8,0x810200a5,0x7c260035}},	//   _tika, _oggi, _लगाओ_, _wykr, 
   {{0x6b841f81,0xa3bf031e,0x644b00d4,0x186702a6}},	//   prig, ुमा_, _nggi, даци_, 
   {{0x75290b91,0xa01b02ae,0x7d041f82,0x753b01d2}},	//   dlez, lgör, miis, dmuz, 
   {{0x644b048a,0x7d041f83,0x75291f84,0x752202ee}},	//   _aggi, liis, elez, _skoz, 
   {{0x7ae30088,0xa01b1f85,0x4426011d,0xdcf50035}},	//   önte, ngör, _syo_, erzę, 
   {{0x75291f86,0x2902014e,0x44261f87,0x7cf11d4b}},	//   glez, _öka_, _pyo_, _gård, 
   {{0x38661f88,0xdb040068,0xddde02d9,0x60cb00a1}},	//   mbor_, lviñ, _vepř, _ògmi, 
   {{0x6d5e02f5,0x65c60141,0x7d0400bd,0x644b1f89}},	//   _otpa, _обза, hiis, _eggi, 
   {{0x7d041f8a,0x7cf10dcb,0xe8df00e7,0x75291f8b}},	//   kiis, _håre, _hiền_, blez, 
   {{0x44261f8c,0x7cf10fd6,0xf5031f8d,0x75290036}},	//   _tyo_, _kåre, _изхо, clez, 
   {{0x7d041f8e,0x6d5e1f8f,0x7ce3007e,0x44260204}},	//   diis, _atpa, _kõrv, _uyo_, 
   {{0xe8df001b,0x3f991f90,0x69c10082,0x3f8b0384}},	//   _miền_, rtsu_, _šlem, rucu_, 
   {{0xc3480029,0x7d0401b8,0xdd941f91,0xe8df001b}},	//   _nổi_, fiis, кары, _liền_, 
   {{0x7d041f92,0x30a70aa3,0x40351f93,0x201e00b3}},	//   giis, _цркв, _пейс, ştia_, 
   {{0xfd44012d,0x6148023e,0x00000000,0x00000000}},	// [1490] тэрн, sèlè, --, --, 
   {{0x7d0d1f94,0x4ac9000f,0x0dcb0141,0xc98702f1}},	//   snas, राइव, _думи_, дуди, 
   {{0xceb200c7,0x212b00f8,0x5a4400b3,0x7d041f95}},	//   _גיי_, olch_, вэца, biis, 
   {{0x61360126,0x7aee1f96,0x7cf100fb,0xa8151f97}},	//   rálg, _elbt, _båre, ндеш, 
   {{0x7cf1022b,0xa875005e,0x7864004e,0xc7ab1f98}},	//   _vård, _үлгі, ткіз, تدال_, 
   {{0x6d580107,0x6b8d0548,0x6d4a02a3,0x7ac41f99}},	//   _évac, muag, _èfac, _иссе, 
   {{0x752901d2,0x260200c9,0xa954128b,0x69d800fb}},	//   tlez, _वेदी_, _аксі, øvet, 
   {{0x7cf10f96,0x7e7500b4,0x672a1a77,0x00000000}},	//   _hårb, hazp, alfj, --, 
   {{0x6136014b,0x752902b0,0x68e400c8,0x387f00c3}},	//   nále, rlez, öide, _idur_, 
   {{0x752902d9,0xaad21f9a,0x00000000,0x00000000}},	//   slez, सायक, --, --, 
   {{0x91e51e13,0x290f1f9b,0x00000000,0x00000000}},	//   хоне, onga_, --, --, 
   {{0x290f1f9c,0x387f00c3,0x2732020f,0x68f90213}},	//   nnga_, _jdur_, mâna_, _çadı, 
   {{0x290f1f9d,0x7d041f9e,0x13a700d4,0x6b8d0369}},	//   inga_, viis, _آنتی_, juag, 
   {{0x6136026e,0x7e7501ca,0x3cfd1d00,0x386600da}},	//   dále, gazp, रोसे_, zbor_, 
   {{0x7d041f9f,0xdca61311,0x6da31270,0x290f012b}},	//   tiis, нави, лира, knga_, 
   {{0x7cea08d7,0xe05800d4,0xa2cd1898,0xa01b1fa0}},	//   _výro, _زیست_, ताव्, rgör, 
   {{0x7d041fa1,0x61361fa2,0x6b8d02a3,0xbb4a0274}},	// [14a0] riis, ráld, guag, سلان_, 
   {{0x7d041fa3,0x2cb90183,0xa01b02ae,0x387f1fa4}},	//   siis, _easd_, pgör, _adur_, 
   {{0x6d5e150d,0x88861fa5,0x7cf11fa6,0xf969004f}},	//   _utpa, ележ, _såre, дрій_, 
   {{0xdd2f031e,0x395100ca,0xdb040068,0x2cb901f5}},	//   pěšn, _duzs_, rviñ, _gasd_, 
   {{0x3c7700d1,0x5fc30466,0x387f193d,0x3eba0326}},	//   _אתכם_, शियल, _ddur_, _kapt_, 
   {{0x290f1fa7,0x7cf114cf,0xa82400d4,0x3866012c}},	//   anga_, _våre, _یکشن, sbor_, 
   {{0x186a01a2,0x212b0156,0x77620183,0x940a00ad}},	//   _нави_, ylch_, spox, əbə_, 
   {{0xe8df00f7,0xd9431fa8,0x7cf101e8,0x7e7501cf}},	//   _tiền_, _беси, _tåre, zazp, 
   {{0xc6c3004e,0x7ce300c2,0x290601cf,0x00000000}},	//   _өйтк, _tõrv, mioa_, --, 
   {{0x13f300c8,0xdb9700c7,0x290601f1,0x877b0486}},	//   узья, עדיט_, lioa_, _מאמי, 
   {{0xb05b02ae,0x6136014b,0xc1780028,0xe6d9003e}},	//   ndäg, zále, usė_, _þráð, 
   {{0x26de00ca,0x6b8d016a,0x29061fa9,0x00000000}},	//   _hoto_, yuag, nioa_, --, 
   {{0xa30b0105,0x201e0218,0xa2e61faa,0xe8df001b}},	//   _کرنے_, ştin_, _подд, _hiển_, 
   {{0x26de0053,0x9f351fab,0x61361fac,0x290601d6}},	//   _joto_, тегі, vále, hioa_, 
   {{0x3eba1fad,0xf1a300d9,0x7e751fae,0xa2cd1faf}},	//   _dapt_, _брын, razp, तार्, 
   {{0x6b8d1fb0,0x0ccf0086,0x7cf10075,0x61360098}},	//   tuag, রস্ত, _sårb, tále, 
   {{0x60cd024d,0x3eba002e,0x26cc0a9f,0x27e606df}},	// [14b0] _inam, _fapt_, _ondo_, jyon_, 
   {{0x26de1fb1,0x6b8d1fb2,0x3ce90121,0x28c60249}},	//   _noto_, ruag, skav_, _रोबि, 
   {{0xab5b02f2,0x290f0495,0x7b0b01dd,0xef1400d3}},	//   _grün, tnga_, kļuv, _сүрө, 
   {{0xa95400dd,0x6c7900c7,0x2cb90126,0x290f0548}},	//   укці, _קאָפ, _uasd_, unga_, 
   {{0x27e6006b,0x60cd0053,0x26de1fb3,0x69d81494}},	//   gyon_, _mnam, _boto_, øver, 
   {{0xe8df0029,0x26de033c,0xb6a51fb4,0x60df008a}},	//   _biển_, _coto_, тикл, _loqm, 
   {{0x9f59009e,0x5b14081b,0x387f016a,0x27e606e4}},	//   îyên_, _смрт, _tdur_, ayon_, 
   {{0x81c80033,0x387f1fb5,0x60cd0547,0xe8df0210}},	//   োনা_, _udur_, _nnam, _diển_, 
   {{0x249f1fb6,0xe78402c0,0xf6990886,0x1fcb009a}},	//   rfum_, _бухо, _овај_, ामोड, 
   {{0x60cd1fb7,0x78bb1fb8,0xa2e5022c,0x26de0139}},	//   _anam, _hauv, тоод, _goto_, 
   {{0x67231fb9,0x60cd0126,0xe4e7004f,0x60df0508}},	//   monj, _bnam, _підн, _boqm, 
   {{0x60cd00a1,0x65610149,0xd00a02a0,0x3eba020f}},	//   _cnam, _itlh, деме_, _sapt_, 
   {{0x3ae4014e,0x78bb026a,0xe2991fba,0xfe7800d3}},	//   _köpt_, _mauv, _жал_, нүп_, 
   {{0x29060414,0x0204005e,0x60cd1fbb,0x67230c49}},	//   zioa_, _өзін, _enam, nonj, 
   {{0x27e61fbc,0x7c961fbd,0xc692008d,0xeab20019}},	//   zyon_, крац, יאם_, یٹر_, 
   {{0x67231fbe,0xfbe700e7,0x645b1fbf,0x78bb1fc0}},	//   honj, _thể_, ncui, _nauv, 
   {{0x3eba1fc1,0x1c4612d6,0x00000000,0x00000000}},	// [14c0] _tapt_, тнам, --, --, 
   {{0x67231fc2,0x00000000,0x00000000,0x00000000}},	//   jonj, --, --, --, 
   {{0x26de1fc3,0x67231fc4,0x65610149,0xd9461fc5}},	//   _roto_, donj, _ntlh, вежи, 
   {{0xe78600e4,0xa9671fc6,0x27e60300,0x480a1fc7}},	//   вуко, тица_, tyon_, меен_, 
   {{0xa2b202f8,0x26de1fc8,0x26c8004e,0x29060a9f}},	//   _असल्, _poto_, нған_, rioa_, 
   {{0x67231fc9,0x7bc6007b,0x29060a9f,0x27e61fca}},	//   gonj, _irku, sioa_, ryon_, 
   {{0x27e61fcb,0x66e303b7,0x290601f1,0x78bb0151}},	//   syon_, роја, pioa_, _fauv, 
   {{0x399c03a1,0x6abc1fcc,0x75390237,0x95c71fcd}},	//   mís_, _harf, _chwz, туша_, 
   {{0x26de0076,0x29040405,0x6abc1fce,0x78a2032f}},	//   _toto_, _imma_, _karf, mfov, 
   {{0x78bb090e,0x60cd1fcf,0x78a203ac,0x672300b3}},	//   _zauv, _snam, lfov, conj, 
   {{0x399c07a9,0x6abc1fd0,0x68e01fd1,0x6d5a003e}},	//   nís_, _marf, _komd, ítal, 
   {{0x7bc61fd2,0x645b1fd3,0xab5b1fd4,0x6abc03c6}},	//   _orku, ccui, _brül, _larf, 
   {{0x399c00eb,0x7bd6006d,0x53b6153d,0x68e3019c}},	//   hís_, jxyu, _अनिश, êndi, 
   {{0x3d951fd5,0xdd9503a1,0x28a402e6,0xa19403a1}},	//   лигр, лагы, _गॉसि, _бакч, 
   {{0x5e5802fb,0x7bc61fd6,0x5b150cdf,0xdef800e4}},	//   тися_, _arku, ҳмат, тыя_, 
   {{0x518300a3,0x8c64049b,0x60cd1fd7,0x399c1fd8}},	//   _туша, итуд, _unam, dís_, 
   {{0x6abc1fd9,0x6d581fda,0x2129002c,0x7bc60604}},	// [14d0] _barf, _évan, _ikah_, _crku, 
   {{0x290406d0,0x78bb026d,0xe8df0029,0x6136010d}},	//   _amma_, _sauv, _miễn_, mála, 
   {{0xce331fdb,0xd366009c,0x61360019,0x67231fdc}},	//   _خودک, _گه_, lála, vonj, 
   {{0xfc64048a,0xfc3f05b9,0x68e00534,0x2d911fdd}},	//   _върн, _maíz_, _comd, muze_, 
   {{0xd3660133,0x61360019,0x78bb030f,0x07a51fde}},	//   _ده_, nála, _vauv, уалн, 
   {{0x6abc1fdf,0xddce1fe0,0xb38501a2,0xa5b90267}},	//   _garf, labš, қлол, ећих_, 
   {{0x67231fe1,0x613600eb,0x399c1fe2,0x78bb1fe3}},	//   ronj, hála, cís_, _tauv, 
   {{0xe3b91fe4,0x260200a2,0x69c7085b,0x38c2010e}},	//   еби_, _वेळी_, _irje, térő_, 
   {{0x67231fe5,0xecc50033,0x527503a1,0xdb040080}},	//   ponj, _একাড, луну, rviö, 
   {{0xe8df00f7,0x61e802bf,0x645b1fe6,0x2d911fe7}},	//   _diễn_, fydl, scui, kuze_, 
   {{0x04951fe8,0x394d09a2,0x13a70296,0xb1461fe9}},	//   _ملاح, _kies_, رنگی_, лнол, 
   {{0xa6e2010d,0x201e027e,0x8f841cc1,0x9f840176}},	//   _öðru, ştim_, ақил, аҳид, 
   {{0x394d1fea,0x61361feb,0xdcfc01dd,0x7bcb02ae}},	//   _mies_, gála, strī, ågul, 
   {{0x272903da,0xe2991fec,0x69c71fed,0xe8d015c8}},	//   múns_, _чак_, _orje, _सच्च, 
   {{0x52390137,0xd33600d1,0x26ca0183,0x2d911fee}},	//   _אײַנ, _גרסה_, _óboe_, guze_, 
   {{0x399c1fef,0x394d0405,0xa3b71615,0x6abc1ff0}},	//   vís_, _nies_, _चना_, _sarf, 
   {{0x2d8a00ef,0x69c71ff1,0x68e01ff2,0x5f2a0165}},	// [14e0] srbe_, _arje, _romd, _поим_, 
   {{0x80a00509,0xa3d4006a,0x7cf1014e,0x2d911ff3}},	//   ग्रे, हमत_, _våra, buze_, 
   {{0x6abc1ff4,0x8cbf00aa,0x7ce3007e,0x80d8009a}},	//   _varf, _लोको, _võrr, यापे, 
   {{0x399c1ff5,0x7cf10219,0xdb0f022c,0x394d00b9}},	//   rís_, _tåra, _escà, _cies_, 
   {{0xb8dc1ff6,0x394d1ff7,0x66e61ff8,0x7bc61ff9}},	//   _अस_, _dies_, лода, _urku, 
   {{0xd5ba1ffa,0xf36600a3,0x394d00fc,0x399c1ffb}},	//   еси_, қтин, _eies_, pís_, 
   {{0x69c702c7,0x68e00104,0xdb23010e,0xc7b9039f}},	//   _grje, _tomd, _óráj, _eső_, 
   {{0x2904086d,0xfc3f0503,0x62830156,0xc44800d4}},	//   _umma_, _raíz_, _adno, نیان_, 
   {{0x272909a1,0xd2500084,0x12e6004e,0x9cd700d1}},	//   gúns_, ينة_, гінг, רופה_, 
   {{0x7cf80496,0x61e8014e,0xe8df001b,0x61360019}},	//   _fírg, tydl, _viễn_, vála, 
   {{0x62341ffc,0x7cf800b9,0xc4861ffd,0xd1c70176}},	//   рену, _gírg, _блек, гуяд_, 
   {{0x2d91024d,0x61361ffe,0xe8df00e7,0x62830237}},	//   vuze_, tála, _tiễn_, _edno, 
   {{0x8cbf006a,0x41b000bd,0xe47b0070,0x2d91019b}},	//   _लोगो, _जनकस, _טראכ, wuze_, 
   {{0x43831930,0x613600eb,0xef1f04be,0xb3bb00d1}},	//   _الوق, rála, mrük_, _נמוכ, 
   {{0x61361fff,0x6d58026d,0x9f4402d9,0xa19400b9}},	//   máln, _éval, ámá_, _тайч, 
   {{0x69c700e5,0x557700c7,0x6136010e,0xf193010e}},	//   _rrje, טעלן_, láln, _اُٹھ, 
   {{0xe8df00f7,0x3a752000,0x1bd40093,0xa3e40c46}},	// [14f0] _hiện_, илар, ботя, नहि_, 
   {{0x6136135a,0xe8df0029,0x2fc92001,0x69c70372}},	//   náln, _kiện_, _irag_, _prje, 
   {{0xc3330056,0x28c62002,0x08550080,0x00000000}},	//   צוע_, _रोहि, авею, --, 
   {{0x80d80a34,0x2fc9018c,0x69c72003,0xd7f10038}},	//   याये, _krag_, _vrje, يكا_, 
   {{0x394d2004,0xdb0f0503,0x1be700cf,0x61362005}},	//   _vies_, _escá, _сўнг, káln, 
   {{0x6b8d2006,0x6d4f2007,0x394d02eb,0x2fc900a1}},	//   mrag, _hica, _wies_, _mrag_, 
   {{0x6d4f0da2,0x25ac012b,0x7e770369,0xf773009c}},	//   _kica, _cpdl_, _mexp, _گاز_, 
   {{0x56940a27,0x2bc90fec,0x6d570287,0x63852008}},	//   _ҳафт, रिपा, _muxa, агиа, 
   {{0x2fc9006d,0x28f800c8,0xe69500b3,0x613600da}},	//   _nrag_, _сеть_, _визы, fáln, 
   {{0x6d4f01a0,0x42552009,0x6136200a,0xe8df00e7}},	//   _lica, штит, gáln, _biện_, 
   {{0x7cf8006b,0x6b8d200b,0xa06a200c,0x2fc90144}},	//   _híre, hrag, кана_, _arag_, 
   {{0x6d4f200d,0xe8df0029,0xe046200e,0x6b8d200f}},	//   _nica, _diện_, инни, krag, 
   {{0xf3672010,0x61360483,0x611201dd,0x2fc900a1}},	//   _стен, báln, nāli, _crag_, 
   {{0x32451834,0x7d0600e2,0x7cf80038,0x3f670176}},	//   _келг, _smks, _míre, риро_, 
   {{0x6d4f0f74,0x2d9e2011,0x6d570042,0xed5a02c0}},	//   _bica, îte_, _cuxa, тоб_, 
   {{0x6b8d2012,0xb4e300a2,0xa2cd00a2,0x3fe6004f}},	//   frag, _नको_, ताक्, _вжив, 
   {{0x6d4f2013,0x6b8d2014,0x61360019,0x7cf10fd6}},	// [1500] _dica, grag, lálo, _tårn, 
   {{0x6d570068,0xff7b00c7,0x7bc400b3,0x442f0566}},	//   _fuxa, _שטימ, rviu, _myg_, 
   {{0x6d4f00ce,0x6136115d,0x442f0009,0x2a7a02be}},	//   _fica, nálo, _lyg_, rapb_, 
   {{0xdbdc0076,0x3ead003a,0x2c5c00ab,0x98a62015}},	//   lšíc, đete_, _bądź_, риде, 
   {{0xc7a30b68,0x38692016,0x78b00028,0x5746058e}},	//   жичк, ñara_, _įkvė, андб, 
   {{0x7cf80084,0x7e7c04f4,0x6d442017,0x613d0019}},	//   _díre, narp, lmia, méle, 
   {{0x7cf8007a,0x442f2018,0xd5b00038,0x6d4f0610}},	//   _tírd, _ayg_, سفة_, _yica, 
   {{0x442f055f,0x7d162019,0x6d4302a3,0x7e7c201a}},	//   _byg_, nnys, _ènat, harp, 
   {{0x2bc9048e,0x61360076,0xfbc902d9,0x27200054}},	//   रिया, táln, रियम, zòny_, 
   {{0xdbdc026e,0xa2cd0249,0xb5f200f0,0x6eeb201b}},	//   jšíc, ताग्, _мүлі, _tübi, 
   {{0x6136201c,0x7e770065,0xdbdc0098,0x7e7c201d}},	//   ráln, _rexp, dšíc, darp, 
   {{0xb356086b,0x03a6065b,0xab5b02f2,0xe8df0029}},	//   _پیدا_, _видо, _früh, _viện_, 
   {{0x6d4f1782,0x7cf109a8,0x7e62010c,0x7e770175}},	//   _rica, _dårl, _şopa, _pexp, 
   {{0x6b8d201e,0xe8df0029,0x6d57114e,0x7e7c201f}},	//   vrag, _tiện_, _puxa, garp, 
   {{0x13b61e25,0xab5b2020,0x395801be,0x61362021}},	//   _अनुभ, _trük, _nurs_, cálo, 
   {{0x6136010e,0x00000000,0x00000000,0x00000000}},	//   náll, --, --, --, 
   {{0xa2cb009a,0x2fc90096,0xdbdc00da,0xdd2f02d9}},	// [1510] _थोड्, _urag_, bšíc, _těžb, 
   {{0x6b8d2022,0xf9c709a6,0x6d4f2023,0xaa672024}},	//   rrag, ищен, _wica, ртак, 
   {{0x39582025,0x6d4f2026,0x6b8d2027,0x7cf80534}},	//   _curs_, _tica, srag, _dírb, 
   {{0x39582028,0x611201dd,0xe0df0379,0x58872029}},	//   _durs_, tāli, njò_, рыжа, 
   {{0x7d0d00ab,0x2366023b,0x49a6004e,0x00000000}},	//   mias, _ntoj_, _қырғ, --, 
   {{0x3958202a,0x442f202b,0x7cf8007a,0x611201dd}},	//   _furs_, _ryg_, _víre, rāli, 
   {{0xa50903b7,0x442f202c,0x3958056f,0xfc3f0534}},	//   лека_, _syg_, _gurs_, _mbím_, 
   {{0x7d0d0528,0x6136010e,0x201e00d9,0x92c30033}},	//   nias, gáll, ştii_, _একে_, 
   {{0x57f502a0,0x44391bde,0x24860121,0xe3b10038}},	//   _упат, ås_, _ddom_, سرة_, 
   {{0x81e200cc,0x7d0d202d,0x61360b85,0x6d4400ab}},	//   _নেই_, hias, tálo, zmia, 
   {{0x7e7c008c,0x6d440156,0xdbdc0032,0x2b5900b9}},	//   varp, ymia, všíc, _lusc_, 
   {{0x5f050351,0x61360483,0x387d0156,0x3f6a02a6}},	//   होस्_, rálo, nawr_, лимо_, 
   {{0x7e7c202e,0x442f02f1,0x320b0035,0xdbdc11bb}},	//   tarp, _uyg_, ńcy_, tšíc, 
   {{0x613d202f,0x752902b0,0x3f5d0108,0xc8f42030}},	//   véle, loez, _dìu_, _आत्म_, 
   {{0x61462031,0xdbdc026e,0x7e7c2032,0x6d442033}},	//   _лека, ršíc, rarp, tmia, 
   {{0x3d0800a2,0x2b590068,0x7e7c03c5,0x4bda00c8}},	//   _सगळे_, _busc_, sarp, льзя_, 
   {{0x6d442034,0xdbdc026e,0x4aaa2035,0x2bca0a31}},	// [1520] rmia, pšíc, лкан_, ылап_, 
   {{0x3f8204d1,0x6d442036,0xeb9803dc,0xaad20484}},	//   msku_, smia, лиғ_, साइक, 
   {{0x7cf80952,0xc8792037,0x2b59008a,0x387d00f8}},	//   _círc, _beş_, _eusc_, fawr_, 
   {{0x273200d9,0x2b5902a3,0x7c962038,0x3f820083}},	//   mâni_, _fusc_, _уроц, osku_, 
   {{0x3f822039,0x09e00086,0x6136203a,0x02b702ab}},	//   nsku_, _যেখা, váll, _असून, 
   {{0xb8ef0d95,0x3ce0203b,0xe3e80019,0x3f82203c}},	//   _वो_, ljiv_, یکشن_, isku_, 
   {{0xceb300a7,0x9f4f004f,0x368900f0,0x395802b0}},	//   פיה_, _ågå_, рсін_, _uurs_, 
   {{0xdb1d014e,0x18a3203d,0x3ce0090e,0xc879009e}},	//   _ersä, _насм, njiv_, _geş_, 
   {{0x3f8203ef,0x2418058b,0xe73a03b7,0xbee8009a}},	//   jsku_, ропы_, _беа_, _ऐकून_, 
   {{0x3f820062,0x4ace00aa,0x7d0d203e,0x3f5d00e7}},	//   dsku_, _होमव, zias, _rìu_, 
   {{0xd2500a7c,0x752902a5,0x00000000,0x00000000}},	//   بند_, boez, --, --, 
   {{0x3a370056,0x463b00c7,0x6136010e,0xca3700d1}},	//   מרים_, _געבע, lálj, מניה_, 
   {{0x39460647,0x00000000,0x00000000,0x00000000}},	//   imos_, --, --, --, 
   {{0x61360019,0xdefb004e,0xdb1d0165,0x28cf203f}},	//   nálj, уым_, _essê, _सोनि, 
   {{0xc27b07f5,0x2b5900ef,0x7d0d2040,0x00000000}},	//   _גרוי, _susc_, tias, --, 
   {{0xdb060019,0x3f822041,0xe21700df,0x00000000}},	//   _eskü, bsku_, _לקוח_, --, 
   {{0xc8790218,0x212b2042,0x6eeb00ad,0xa2cd009a}},	// [1530] _reş_, moch_, _sübu, ताच्, 
   {{0x629a2043,0x7d0d2044,0xda670084,0xbb1b010c}},	//   ngto, sias, صائي, _evîn, 
   {{0xb9b52045,0x9962026e,0x7d0d00a9,0x2b59019b}},	//   تماع, _píše_, pias, _wusc_, 
   {{0x212b2046,0x319b0147,0x00000000,0x00000000}},	//   noch_, רבאנ, --, --, 
   {{0x656800e5,0x7d1d01c8,0x6fc90299,0x00000000}},	//   _atdh, _ijss, िटिं, --, 
   {{0x212b2047,0x3cef009a,0x85b90038,0x52b70299}},	//   hoch_, _इकडे_, لابس_, _असेस, 
   {{0x2d832048,0x212b0187,0x19942049,0x057900eb}},	//   nsje_, koch_, _наря, جمعة_, 
   {{0x2d8301c8,0x212b0032,0x6ab702aa,0xe919004f}},	//   isje_, joch_, lexf, _тобі_, 
   {{0x212b204a,0x290f204b,0x7ae7006d,0xd7fb02f1}},	//   doch_, miga_, _kojt, _сув_, 
   {{0x290f204c,0xf6f5015d,0xdb1d014e,0x13090088}},	//   liga_, _بزرگ, _ursä, рной_, 
   {{0xf7480084,0x7ae70588,0x2d8302b0,0x61460c10}},	//   _اللي_, _mojt, jsje_, жена, 
   {{0x3f8202f5,0x290f204d,0xa4f700d4,0x7ae7024a}},	//   tsku_, niga_, _دکتر_, _lojt, 
   {{0x3f84035e,0x61360019,0x2d8302b0,0x6ef000c2}},	//   ému_, lálk, esje_, _häbi, 
   {{0x3f82204e,0x290f204f,0x71590024,0x68f801dd}},	//   rsku_, higa_, _крис_, īvdi, 
   {{0xdd92024f,0xddc315d3,0x6cc62050,0x212b0032}},	//   ظور_, мбри, ойва, boch_, 
   {{0x3f8214f0,0x4c6a2051,0x212b2052,0x611201dd}},	//   psku_, риан_, coch_, tālu, 
   {{0x290f2053,0x6ef0007e,0x7ae72054,0x2d8302b0}},	// [1540] diga_, _läbi, _bojt, asje_, 
   {{0x2d9100ab,0xdcfc00e0,0x80d800a2,0x60c42055}},	//   brze_, turē, यावे, _haim, 
   {{0x60c42056,0xfce62057,0x3eb82058,0x409300d4}},	//   _kaim, _доно, mert_, _علیر, 
   {{0xeb9a2059,0x2d98205a,0x290f205b,0x3eb8205c}},	//   _ким_, mure_, giga_, lert_, 
   {{0x3946205d,0x60c4205e,0xdb040511,0x394000e0}},	//   rmos_, _maim, ntië, ķis_, 
   {{0x39461408,0x60c4205f,0x6b842060,0x3eb82061}},	//   smos_, _laim, msig, nert_, 
   {{0x2d982062,0x290f2063,0x6b842064,0x7769192d}},	//   nure_, biga_, lsig, _etex, 
   {{0x443d02f2,0x3eb801c4,0x60d602a5,0xdb1d0106}},	//   _bzw_, hert_, _nnym, _assè, 
   {{0x6b842065,0x3eb82066,0xa686032c,0x14a60b6c}},	//   nsig, kert_, _млад, क्षण, 
   {{0x61360019,0xe73a2067,0x2d982068,0x212b01c4}},	//   lálh, _тез_, kure_, woch_, 
   {{0xd62a0088,0x3eb82069,0x60c4206a,0x629a206b}},	//   _тоже_, dert_, _baim, rgto, 
   {{0x60c40465,0x613d008c,0x61360019,0xdb1d022c}},	//   _caim, féla, nálh, _essè, 
   {{0x60c4206c,0x6b841993,0x3eb8206d,0x212b206e}},	//   _daim, jsig, fert_, roch_, 
   {{0x6b84055f,0x2d8302b0,0x3eb801b9,0x69ce206f}},	//   dsig, tsje_, gert_, _orbe, 
   {{0x290f2070,0x7ae72071,0x41e62072,0x2d982073}},	//   yiga_, _rojt, _філа, gure_, 
   {{0x290f2074,0x6b842075,0xac592076,0x2d832077}},	//   xiga_, fsig, сааф_, rsje_, 
   {{0x2002006a,0x6b842078,0x69de2079,0x290f207a}},	// [1550] czki_, gsig, expe, viga_, 
   {{0x3eb800f6,0xdb040107,0x2d980610,0x290f0b15}},	//   cert_, ntiè, bure_, wiga_, 
   {{0x290f1e38,0x6d35207b,0x7ae7207c,0x80b000cc}},	//   tiga_, _неоф, _vojt, য়ার্, 
   {{0x52b7207d,0x6b840126,0x02b701a4,0x7cf80068}},	//   _अस्स, bsig, _अस्न, _tíra, 
   {{0x290f207e,0x69ce207f,0x3f992080,0x628a0032}},	//   riga_, _erbe, nusu_, _odfo, 
   {{0x290f2081,0xb05b2082,0x00000000,0x00000000}},	//   siga_, ddäm, --, --, 
   {{0x3f992083,0x290f086d,0x2bc90d1d,0xb8870200}},	//   husu_, piga_, रिवा, _муай, 
   {{0xd5ae00eb,0x6136014b,0x7bcf0082,0x3f992084}},	//   افي_, rálk, _krcu, kusu_, 
   {{0x2d982085,0x48fa00c7,0x1309004f,0x3f990097}},	//   zure_, _פּלא, йний_, jusu_, 
   {{0x61362086,0x60c42087,0x613d2088,0x68e92089}},	//   máli, _saim, véla, _hoed, 
   {{0x3eb8208a,0x2d98208b,0x60c4208c,0xc6a402f1}},	//   vert_, xure_, _paim, _юрти, 
   {{0x3ea1208d,0x6b84208e,0x3eb802f2,0x443d0035}},	//   _acht_, ysig, wert_, _tzw_, 
   {{0xe28e208f,0x26c502f8,0x68e90d62,0x3eb82090}},	//   _па_, _kalo_, _moed, tert_, 
   {{0x2d982091,0x60c42092,0xdb0f2093,0x3eb80380}},	//   ture_, _waim, _escú, uert_, 
   {{0x26c52094,0x62812095,0x60c42096,0x57b800ab}},	//   _malo_, malo, _taim, _इन्ह, 
   {{0x3ea12097,0xab660504,0x3eb802fb,0xfce32098}},	//   _echt_, звал, sert_, носо, 
   {{0x2d982099,0x2fc0209a,0x3f9906a2,0x64590204}},	// [1560] sure_, _usig_, cusu_, _mgwi, 
   {{0x2d980141,0x6b84209b,0x26c5187e,0x798507d7}},	//   pure_, rsig, _nalo_, fshw, 
   {{0x68fb209c,0x68e9209d,0x14bd1276,0xdb040126}},	//   _blud, _boed, ्याण, ntié, 
   {{0x62810364,0x7e7e209e,0x68e9209f,0x6d5e20a0}},	//   halo, _hepp, _coed, _iupa, 
   {{0x7e7e008c,0x68e2003d,0xe73a20a1,0x68e90156}},	//   _kepp, rjod, бед_, _doed, 
   {{0x6d5e20a2,0x6281044e,0xf1db00ae,0x7e7e20a3}},	//   _kupa, jalo, यमान, _jepp, 
   {{0x628120a4,0xbb4320a5,0x69da0228,0x7e7e20a6}},	//   dalo, _черк, _štef, _mepp, 
   {{0x68e920a7,0x7e7e20a8,0x6d5e20a9,0x68fb20aa}},	//   _goed, _lepp, _mupa, _glud, 
   {{0x6d5e20ab,0x26c5145a,0x613620ac,0x38660183}},	//   _lupa, _falo_, cáli, mcor_, 
   {{0x628120ad,0xe3af20ae,0x26c520af,0x98b8012d}},	//   galo, اري_, _galo_, _kurį_, 
   {{0xd48f20b0,0xb5ca1766,0xdceb0b1d,0xa50a20b0}},	//   _пр_, _دوام_, _žiča, _лежа_, 
   {{0x64a603dc,0x3f9920b1,0x386620b2,0x63a400b3}},	//   _хада, tusu_, ncor_, _ţinu, 
   {{0x6d5e20b3,0x7e7e01d8,0xe50520b4,0x255501dd}},	//   _aupa, _bepp, _تبلي, _tālr_, 
   {{0x628a01cc,0x6d5e0720,0x7e7e20b5,0x3f9920b6}},	//   _udfo, _bupa, _cepp, rusu_, 
   {{0xa2a100a2,0x1df80b58,0x3f9920b7,0x7e7e20b8}},	//   _खात्, перы_, susu_, _depp, 
   {{0x291c20b9,0x3f9920ba,0x6d5e00de,0x00000000}},	//   éval_, pusu_, _dupa, --, 
   {{0x201e20bb,0x68e902f0,0xd0080886,0x6d5e002c}},	// [1570] ştir_, _roed, _неће_, _eupa, 
   {{0x68fb00e0,0x79850364,0x7cf80019,0x6d5e0415}},	//   _slud, tshw, _hírl, _fupa, 
   {{0x68fb20bc,0x68e920bd,0xed5802a0,0x6d5e20be}},	//   _plud, _poed, _ноќ_, _gupa, 
   {{0xf99000b8,0x613620bf,0x7e7e20c0,0x7985023e}},	//   ابل_, táli, _zepp, rshw, 
   {{0x2b9315c0,0x26c50149,0x68e9051e,0x37ab20c1}},	//   _سیاس, _palo_, _voed, стен_, 
   {{0x68e90b1f,0x613620c2,0x26c50415,0x62810183}},	//   _woed, ráli, _qalo_, xalo, 
   {{0x628120c3,0x26c520c4,0x68e920c5,0x7cf80126}},	//   valo, _valo_, _toed, _oírl, 
   {{0x628120c6,0x26c520c7,0x69da0097,0x68fb027e}},	//   walo, _walo_, _šteg, _ulud, 
   {{0xa2a10239,0x26c520c8,0x25a701c8,0x6e3702ae}},	//   _खाद्, _talo_, stnl_, _lyxb, 
   {{0x21cc02d9,0x7bcd20c9,0x657a00f3,0x6136039f}},	//   _běh_, ivau, _fwth, nálv, 
   {{0x387f20ca,0x63a4020f,0x7e7e20cb,0x22020175}},	//   _keur_, _ţint, _repp, _réhé_, 
   {{0x6d5e20cc,0xdb04060f,0x7e7e20cd,0xe5070038}},	//   _rupa, rtié, _sepp, _عباي, 
   {{0x6d5e20ce,0x387f20cf,0x73e4004f,0xe8df0023}},	//   _supa, _meur_, _поїз, _nhọn_, 
   {{0x387f0518,0x63a920d0,0x628120d1,0x56b50147}},	//   _leur_, mten, qalo, ופֿן_, 
   {{0x6da30d47,0xdca602f1,0xce4a00f0,0xada300a3}},	//   кира, мави, ізбе_, карл, 
   {{0x249f010d,0x205620d2,0x7cf820d3,0x387f20d4}},	//   ngum_, _отпр, _víro, _neur_, 
   {{0xe8df00f7,0x0fc311db,0x7e7e20d5,0x0aea1628}},	// [1580] _chọn_, _айын, _tepp, одай_, 
   {{0x63a920d6,0x6d5e20d7,0xc31f0033,0xf1b1017d}},	//   iten, _tupa, _নীতি_, _जहान, 
   {{0x63a920d8,0x80a50466,0x9965004e,0x18a620d9}},	//   hten, _कामे, етіл, даем, 
   {{0x63a920da,0x00000000,0x00000000,0x00000000}},	//   kten, --, --, --, 
   {{0x387f20db,0x2ca0012b,0xd6b400fd,0x6d4600c2}},	//   _deur_, mgid_, ейлъ, _ihka, 
   {{0x386620dc,0x6136008c,0xdcfc0009,0x2ca000c2}},	//   scor_, málu, turė, lgid_, 
   {{0xfaa30013,0x63a9002e,0x941806d0,0xceb300a7}},	//   _шаро, eten, ərə_, דיו_, 
   {{0x387f20dd,0x2ca020de,0x63a920df,0x6128008f}},	//   _geur_, ngid_, ften, nıld, 
   {{0x63a920e0,0x77910296,0x2ca000b0,0x69e300b3}},	//   gten, _مینا, igid_, ăteş, 
   {{0x69c80183,0x7cf11950,0x2732020f,0x387f039b}},	//   _ádes, _hårt, râns_, _zeur_, 
   {{0x6128027e,0x611520e1,0x2b5820e2,0x00000000}},	//   kıld, едну, _mirc_, --, 
   {{0x63a920e3,0x1e7200f0,0x160700ae,0x00000000}},	//   bten, ңғыс, _वेटर_, --, 
   {{0x63a920e4,0xa2940c8b,0x7cf10219,0x1fb40cfe}},	//   cten, _залі, _mårt, ксёр, 
   {{0x442620e5,0x2fd21bde,0xf09f0054,0x7cf80534}},	//   _ixo_, _dryg_, sgà_, _dírm, 
   {{0x6d46016a,0x9e34177d,0x81d40283,0x527520e6}},	//   _bhka, верч, _чойх, _чучу, 
   {{0x2b5820e7,0xa2d600a5,0x2ca0095a,0x6d460104}},	//   _airc_, बाक्, ggid_, _chka, 
   {{0x2b5800ca,0x8aa720e8,0x6d461e1b,0x2fd203c6}},	// [1590] _birc_, дред, _dhka, _gryg_, 
   {{0x2d8505b9,0x7bcd0341,0xab94004f,0x00000000}},	//   áles_, rvau, тифі, --, 
   {{0x63a920e9,0x387f026a,0x6f1516a3,0x7bcd0080}},	//   zten, _peur_, mizc, svau, 
   {{0x63a920ea,0xf77100b1,0x09b10086,0x2b58012b}},	//   yten, هات_, ছিলা, _eirc_, 
   {{0x2b580183,0x6d4d20eb,0x387f039b,0x6442045a}},	//   _firc_, mmaa, _veur_, _nzoi, 
   {{0xd24620ec,0x6d4d20ed,0x61360019,0xb6a202f1}},	//   _من_, lmaa, lált, гишл, 
   {{0x63a920ee,0x4426019c,0xa8a71f0d,0x00000000}},	//   wten, _axo_, _орак, --, 
   {{0x6d4d20ef,0x61360019,0xe3c80023,0xc98414b7}},	//   nmaa, nált, _bự_, _јури, 
   {{0x752200ef,0xe3b60b58,0x249f20f0,0x7cf10c17}},	//   _djoz, ебы_, rgum_, _hårs, 
   {{0xe3c80029,0x644200ef,0x8af00095,0x6d4d018e}},	//   _dự_, _dzoi, qqət, hmaa, 
   {{0xa0a603dc,0x44260e34,0x6d4d12b6,0x612806a2}},	//   нанд, _exo_, kmaa, yıld, 
   {{0xcea90052,0xc879009e,0x248400b9,0x61280248}},	//   _לי_, _goşt_, camm_, xıld, 
   {{0x6d4d0b1f,0xd3c400f0,0x613603b3,0xdb1d20f1}},	//   dmaa, _ақыл_, dált, _assí, 
   {{0x6d4601ee,0x656120f2,0x6d4d11da,0x201e020f}},	//   _shka, _kulh, emaa, ăti_, 
   {{0x656103b7,0xe81600ab,0x612805b7,0x613608b2}},	//   _julh, _देना_, tıld, fált, 
   {{0x656100ce,0x6d4d20f3,0x6b9620f4,0xa0a303dc}},	//   _mulh, gmaa, tryg, _баъд, 
   {{0x612807fa,0xf1c9001b,0x2ca020f5,0x0c2620f6}},	// [15a0] rıld, _hạ_, rgid_, хман, 
   {{0x6d4d0341,0x6b960566,0x20ac072d,0x61280241}},	//   amaa, rryg, ट्रध, sıld, 
   {{0x753b026e,0x499a20f7,0x612805b7,0x91fc0243}},	//   kluz, ятая_, pıld, ecāj, 
   {{0x6d4d0339,0x6d4600c8,0x57a60d47,0xf1c90023}},	//   cmaa, _uhka, ешка, _mạ_, 
   {{0xf1c9001b,0xe73a1daa,0x69c302c9,0x7cf10946}},	//   _lạ_, пед_, æner, _vårt, 
   {{0x7bc602f5,0xe5c61853,0x8f9b00c7,0x66e31628}},	//   _isku, есио, פיצי, лоча, 
   {{0xe3c800f7,0x7cf10430,0xfc3f0183,0xf1c900e7}},	//   _sự_, _tårt, _icía_, _nạ_, 
   {{0x2d9804ef,0x6561023e,0xe8b506a2,0x273b0023}},	//   irre_, _dulh, mışı, hênh_, 
   {{0xd90d0399,0xe8b5091f,0x248420f8,0x00000000}},	//   _بین_, lışı, ramm_, --, 
   {{0xf1c900e7,0x55e6004f,0x23d201a4,0xe81600bd}},	//   _bạ_, _позб, तिबद, _देया_, 
   {{0xe8b50785,0x7d0420f9,0x7aee0082,0x61362086}},	//   nışı, khis, _mobt, jáls, 
   {{0xe3c800f7,0x78a220fa,0x7d0420fb,0xf1c900e7}},	//   _tự_, ngov, jhis, _dạ_, 
   {{0x66f40081,0x04570084,0x7d0420fc,0x656120fd}},	//   _अवाक_, _كلمة_, dhis, _zulh, 
   {{0x3ea50019,0x1ee700d4,0xe8b5027e,0xbb1b0216}},	//   ült_, روزی_, kışı, _xwîd, 
   {{0x7bc600e5,0x6d4d20fe,0xf1c90108,0x6abe011c}},	//   _asku, tmaa, _gạ_, depf, 
   {{0x7d0420ff,0x23b7143e,0xa8a60218,0xd904009c}},	//   ghis, _अहमद, şkêş_, _طی_, 
   {{0x6d4d2100,0x61361930,0x7aee084c,0x628e0035}},	// [15b0] rmaa, rált, _bobt, óbow, 
   {{0x6d4d2101,0xadf500e4,0x0a682102,0xab18004f}},	//   smaa, _апош, ерци_, нієї_, 
   {{0x7bc60414,0x7d040014,0xf1c900e7,0x6d4d10f3}},	//   _esku, bhis, _xạ_, pmaa, 
   {{0x7d042103,0x38c90019,0x7cf12104,0xf0940070}},	//   chis, بائی_, _vårs, ָנס_, 
   {{0xa2a1055d,0x656120cb,0xb6a52105,0x00000000}},	//   _खाल्, _sulh, вилл, --, 
   {{0x7aee011f,0x00000000,0x00000000,0x00000000}},	//   _gobt, --, --, --, 
   {{0xb8b3032e,0x50b10ede,0x656100e2,0x2bc903a2}},	//   _бөлі, जभाष, _qulh, रिका, 
   {{0x69c7056e,0x78a200ef,0x09e70033,0x00000000}},	//   _isje, cgov, পনদা, --, 
   {{0x3f8b00ab,0xd4680038,0x753b2106,0x77551acb}},	//   jscu_, رحيم_, rluz, _акаф, 
   {{0x466b2107,0x77900019,0xdcfc01dd,0x69d50035}},	//   _храм_, _ایوا, turī, _krze, 
   {{0x7d042108,0x3f8b2109,0x65940176,0x412a210a}},	//   yhis, escu_, _баху, доно_, 
   {{0x69d50d9d,0xdddc0097,0x7d04210b,0xf1c90108}},	//   _mrze, jarš, xhis, _vạ_, 
   {{0xc95200c7,0x03a500d9,0xdddc0144,0xab5b00bd}},	//   ימט_, _рило, darš, _asüm, 
   {{0x69c702b1,0x78a202f5,0x69d50035,0xf1c900e7}},	//   _osje, zgov, _orze, _tạ_, 
   {{0x7d04210c,0x386d210d,0x98ad008a,0x7d16210e}},	//   this, _ofer_, _gieħ_, tiys, 
   {{0x6283210f,0x7aee022c,0xad39004f,0x6ef900a1}},	//   _heno, _sobt, ечує_, _lìbh, 
   {{0x62832110,0x7aee0201,0x7d042111,0x6b631d63}},	// [15c0] _keno, _pobt, rhis, икта, 
   {{0x7d042112,0x62832113,0x386d2114,0x799e0548}},	//   shis, _jeno, _afer_, tupw, 
   {{0x62831622,0x7d040364,0x1d0a01d0,0x7cf81c62}},	//   _meno, phis, _жени_, _líri, 
   {{0xe8b5091f,0x69d50035,0x290002aa,0x00000000}},	//   rışı, _drze, óia_, --, 
   {{0x98a32115,0x69d52116,0x66e62117,0x56941a31}},	//   риче, _erze, кода, галт, 
   {{0x62832118,0x47330769,0xa3d52119,0x799e018e}},	//   _neno, аніс, हिन_, pupw, 
   {{0x27e0002e,0x69d500ab,0x0583004e,0x69d802c9}},	//   ţin_, _grze, ауым, æved, 
   {{0x3f4f01f2,0xaae000bc,0x00000000,0x00000000}},	//   _jżur_, नावक, --, --, 
   {{0x6283211a,0x7d0300d9,0x366a00a3,0x7cf8019c}},	//   _beno, _înse, _жазо_, _círi, 
   {{0x80a50077,0x7cf80038,0xe6c50038,0x613d211b}},	//   _काहे, _díri, _متمي, méli, 
   {{0x26de0056,0xe816143e,0x31c30093,0xe4c600a3}},	//   _into_, _देता_, асяв, _аёлн, 
   {{0x2906211c,0x7cf80038,0x628308a3,0x00000000}},	//   nhoa_, _fíri, _eeno, --, 
   {{0x26cc211d,0x4394211e,0x2906211f,0xef1f2120}},	//   _kado_, _салс, ihoa_, ssüm_, 
   {{0x62832121,0x04430925,0xe571010e,0x80a52122}},	//   _geno, _течн, _خطے_, _कावे, 
   {{0x62882123,0xdddc026e,0x29060149,0x26cc0102}},	//   mado, tarš, khoa_, _mado_, 
   {{0x26cc0b85,0x6d580036,0x3ead00d8,0x00000000}},	//   _lado_, _èval, řet_, --, 
   {{0x63a01191,0x7c842124,0x0fe40161,0x2b4a0014}},	// [15d0] numn, русе, _көрү, _bhbc_, 
   {{0x69d52125,0x62882126,0x26cc0496,0x613d026a}},	//   _prze, nado, _nado_, déli, 
   {{0x60cd2127,0x612807fa,0x63a0015e,0xc9872128}},	//   _kaam, lıla, humn, тузи, 
   {{0x63a02129,0x60cd212a,0x26de212b,0x3873212c}},	//   kumn, _jaam, _anto_, рқат, 
   {{0xb8cb0ede,0x26cc086d,0x60cd212d,0x6d5d212e}},	//   _खा_, _bado_, _maam, _iisa, 
   {{0x6288212f,0x69d5006a,0xa3d61615,0x6d5d2130}},	//   jado, _trze, ाटन_, _hisa, 
   {{0x26cc0e2e,0x7cf82131,0x69c702c7,0xdb0402aa}},	//   _dado_, _síri, _usje, stiã, 
   {{0x23ab01cc,0x29062132,0x62832133,0xbcfb2134}},	//   tøj_, choa_, _seno, _diég, 
   {{0x6b8d0316,0x6d5d2135,0x62831b79,0x63a00121}},	//   nsag, _misa, _peno, gumn, 
   {{0x6d5d05d2,0x61280092,0x26cc2136,0xd1750f82}},	//   _lisa, dıla, _gado_, лымы, 
   {{0x60cd2137,0x62830228,0x05960274,0x7c3d0f96}},	//   _baam, _veno, _مانگ, _lysr, 
   {{0x6d5d0704,0x60cd03da,0x63a00870,0xd5fa0070}},	//   _nisa, _caam, bumn, _אפער, 
   {{0xe2992138,0x61280241,0x60cd0eb1,0x80a5072d}},	//   _зал_, gıla, _daam, _कारे, 
   {{0x62882139,0x6da6213a,0x339200eb,0x6d5d213b}},	//   cado, лига, _الوز, _aisa, 
   {{0x6d5d0bc1,0x60cd01b8,0x78a900d2,0xb17600e7}},	//   _bisa, _faam, _ocev, _trượ, 
   {{0x6d5d213c,0xa0a603dc,0x60cd0539,0x61280761}},	//   _cisa, _саид, _gaam, bıla, 
   {{0x6128213d,0x6d5d213e,0x6b8d213f,0xff660216}},	// [15e0] cıla, _disa, gsag, _şîfa_, 
   {{0x78a9033c,0x4aa70161,0x2bc91464,0x4e362140}},	//   _acev, лкун_, रिजा, _معجز, 
   {{0x6d5d00a9,0x2d9515c5,0x60cd2141,0x2906084c}},	//   _fisa, _кряс, _yaam, thoa_, 
   {{0x613d2142,0x6d5d2143,0xfce603dc,0x26cc2144}},	//   téli, _gisa, _сомо, _sado_, 
   {{0x62882145,0xbcfb2146,0x01370070,0x443d052b}},	//   yado, _diéd, אָגט_, _nyw_, 
   {{0x62882147,0x6d5d2148,0x613d2149,0xbcfb0212}},	//   xado, _zisa, réli, _piég, 
   {{0xe1e7214a,0x61280749,0x7d03002e,0x26cc1054}},	//   _اس_, zıla, _însc, _vado_, 
   {{0x80d407bd,0x26cc0096,0x443d02bf,0x6288214b}},	//   _बोले, _wado_, _byw_, wado, 
   {{0x62880b85,0x2904214c,0x60cd088f,0x28e113ec}},	//   tado, _ilma_, _raam, फारि, 
   {{0x60cd214d,0xc87904be,0x443d00f8,0xadf600c9}},	//   _saam, _inşa_, _dyw_, ीनान_, 
   {{0x63a0090e,0x2258214e,0x38690571,0x60cd214f}},	//   sumn, ärk_, žare_, _paam, 
   {{0x612803c0,0x6b8d026a,0x443d0156,0x29040175}},	//   tıla, ysag, _fyw_, _jlma_, 
   {{0x62882150,0x60cd2151,0x33f616a7,0x6b4b0502}},	//   pado, _vaam, _حساس, lüge, 
   {{0x61280824,0x6d5d2152,0x60cd17f2,0x628801ff}},	//   rıla, _sisa, _waam, qado, 
   {{0x60cd177f,0xbcfb026a,0x69da10d4,0x6b4b01c4}},	//   _taam, _liée, _šten, nüge, 
   {{0x61280c05,0x6b8d2153,0x2fc9006d,0x6d5d2154}},	//   pıla, tsag, _tsag_, _qisa, 
   {{0x6d5d2155,0x5b152156,0x443d006d,0x6e95002e}},	// [15f0] _visa, амат, _xyw_, _кипу, 
   {{0x6d5d2157,0xa3d52158,0x6b8d2159,0x91a80e7d}},	//   _wisa, हित_, rsag, _कमाई, 
   {{0x6b8d215a,0x6d5d215b,0xba47128b,0x06cd0086}},	//   ssag, _tisa, ухай, লামি, 
   {{0xc9130086,0xd7d502a0,0xe816109f,0x6b8d215c}},	//   িক্ত_, ижењ, _देहा_, psag, 
   {{0xdb040a47,0x37e51284,0x2129039b,0x75dc0474}},	//   stiá, ролг, _mjah_, _lăză, 
   {{0x6b4b02f2,0x443d00f8,0x2904215d,0x00000000}},	//   füge, _ryw_, _elma_, --, 
   {{0x6ead000d,0x5a440904,0xba74006b,0x256a0465}},	//   _जानु, _гэта, _چاہت, _cùl_, 
   {{0xb46502b9,0x2d9e1a51,0x195800f0,0xe816215e}},	//   шкил, šteg_, _басы_, _देवा_, 
   {{0xf77000c5,0xab5b00b0,0x67d400b3,0x320c0032}},	//   _فال_, _psüh, _лоту, ezdy_, 
   {{0x2129215f,0x82f52160,0x981408cb,0x57f40267}},	//   _ajah_, рчиц, _طبقا, _упут, 
   {{0x394d023b,0xf8c90fc0,0x2486023a,0xc8830216}},	//   _khes_, _रसाय, _feom_, _goşê_, 
   {{0x33d50769,0x248602a3,0xa3d50035,0x628e12aa}},	//   _вікт, _geom_, हिद_, óbor, 
   {{0x95541fdb,0x212902fe,0x036800f0,0xa93600d1}},	//   _اخلا, _djah_, _биік_, שטרה_, 
   {{0xe29907a4,0xa85600a7,0x394d114e,0x23d203ce}},	//   _рак_, יירה_, _lhes_, तिरद, 
   {{0x21a52161,0x2cb901be,0x71a5040c,0x764e0098}},	//   _тийм, _bbsd_, _тайз, _úbyt, 
   {{0x25ed0bd3,0xa3c90035,0xb05b2162,0x395f2163}},	//   _अपनी_, _ऊना_, rdär, _nius_, 
   {{0xed57088e,0x4aaa2164,0x81cc0086,0xcb672165}},	// [1600] рот_, ккан_, রমণ_, иате_, 
   {{0x316711a5,0x0d862166,0x1e962167,0x00000000}},	//   _kunz_, _клон, _трир, --, 
   {{0x395f120c,0x6f1c2168,0xbcfb0175,0x7e9b00d1}},	//   _bius_, mirc, _diéb, _בסיו, 
   {{0x613d0ada,0x6f1c0036,0x394d0090,0x00000000}},	//   bélu, lirc, _ches_, --, 
   {{0x67d42169,0x7d03107c,0x395f022c,0x394d011c}},	//   солу, _însa, _dius_, _dhes_, 
   {{0x97130451,0x7cf8216a,0x6f1c216b,0xb8fd0299}},	//   оміц, _víru, nirc, _थो_, 
   {{0x4420002e,0x95ca216c,0x24860054,0x395f216d}},	//   _ţi_, тула_, _peom_, _fius_, 
   {{0x395f0036,0xc44800d7,0x00000000,0x00000000}},	//   _gius_, هیان_, --, --, 
   {{0xdcef090e,0x6f1c0380,0x14a700c9,0x00000000}},	//   žeće, kirc, _गारण, --, 
   {{0x2129216e,0x00000000,0x00000000,0x00000000}},	//   _sjah_, --, --, --, 
   {{0x8ad90070,0xd627216f,0x98af01dd,0xf1a32170}},	//   אַרפ, _кофе_, logā_, орян, 
   {{0x67382171,0x25be095a,0x656801f5,0x23660028}},	//   lovj, _iptl_, _iudh, _tuoj_, 
   {{0x65682172,0x44320210,0x9f590151,0x8535010e}},	//   _hudh, _ây_, lysé_, _اونچ, 
   {{0x65682173,0x31670036,0xe7f9029c,0x3160040c}},	//   _kudh, _funz_, ्नता_, _eiiz_, 
   {{0x51862174,0xe29702a6,0x656800d4,0x31670231}},	//   _тула, _тај_, _judh, _gunz_, 
   {{0x65682175,0x6f1c0387,0x00000000,0x00000000}},	//   _mudh, airc, --, --, 
   {{0x186900cf,0x2d5815dd,0x395f022c,0x656801be}},	// [1610] қали_, рить_, _rius_, _ludh, 
   {{0x67380eae,0x21390034,0x656812b6,0xaaac0fc0}},	//   jovj, losh_, _oudh, _चाणक, 
   {{0x67382176,0x656801e5,0x9c830144,0x7c29129a}},	//   dovj, _nudh, _ščuk, _žerd, 
   {{0xa3d605f6,0xbcfb10fd,0x21390034,0x00000000}},	//   ाटा_, _diéc, nosh_, --, 
   {{0x395f022c,0x37ab03fd,0xb0aa0035,0x2d910035}},	//   _vius_, ттен_, _कासग, lsze_, 
   {{0x65682177,0x16a9141d,0x67382178,0xa3d5119b}},	//   _budh, увки_, govj, हिस_, 
   {{0x394d2179,0xdcfb1615,0xc5d503bd,0x2139024a}},	//   _thes_, _एकाध_, сіль, kosh_, 
   {{0x2ca9217a,0xbb1b0218,0x28cf12e3,0x7af5217b}},	//   ngad_, _xwîn, _सोचि, _hozt, 
   {{0x291d217c,0x2139217d,0x261700bc,0x6f1c0241}},	//   miwa_, dosh_, _भेरी_, yirc, 
   {{0x291d2083,0xddde1c77,0x7305217e,0x656802cd}},	//   liwa_, _lepš, споз, _fudh, 
   {{0xdb0402a0,0x6568217f,0x7af52180,0x2d910035}},	//   stiç, _gudh, _mozt, jsze_, 
   {{0x291d2181,0x21392182,0x14ca00d7,0x00000000}},	//   niwa_, gosh_, _مهمی_, --, 
   {{0xc50c00c7,0x9fd60033,0xb05b0080,0xa2d2102c}},	//   _בלאָ, সঙ্গ, seän, _भोक्, 
   {{0x65682183,0x291d2184,0x644b052a,0x84e500a5}},	//   _yudh, hiwa_, _izgi, कावट_, 
   {{0x291d2083,0x6b500750,0x78bb2185,0x7d0600e0}},	//   kiwa_, lägg, _obuv, _plks, 
   {{0x2ca9014e,0x291d0010,0x3c6600e4,0x38600082}},	//   ggad_, jiwa_, скаг, žiri_, 
   {{0x09b211bd,0x6128213d,0x291d0010,0x7af52186}},	// [1620] ीब्य, nılm, diwa_, _bozt, 
   {{0x2ca90102,0x78bb016c,0xbcfb0212,0xee390176}},	//   agad_, _abuv, _piéc, унӣ_, 
   {{0x8db600dd,0x291d0053,0x613d0126,0x6d4f00a1}},	//   _успі, fiwa_, céls, _fhca, 
   {{0x98a62187,0x6128027e,0x291d2188,0x6d4f01be}},	//   сиде, kılm, giwa_, _ghca, 
   {{0x656801e5,0xc7a32189,0x31b10019,0x6d44218a}},	//   _sudh, зичк, ház_, mlia, 
   {{0x61280095,0x6d44218b,0xd37a02f1,0x05d3009a}},	//   dılm, llia, қчи_, थिंब, 
   {{0x386904d1,0x6d4402bf,0x6738218c,0x291d0010}},	//   žara_, olia, rovj, biwa_, 
   {{0x539810df,0x69ce218d,0x6d44007a,0x67380082}},	//   авия_, _isbe, nlia, sovj, 
   {{0x2d851056,0x6738027c,0x442f0042,0x6d44218e}},	//   ález_, povj, _cxg_, ilia, 
   {{0x6d44218f,0x35c40f5a,0x03a6035b,0x65681372}},	//   hlia, _мазҳ, _ҳидо, _tudh, 
   {{0xe3af1cad,0x6d44012d,0x69da008b,0x21392190}},	//   وری_, klia, _štej, tosh_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2d91006a,0xff660218,0xb0aa000f,0x6d440156}},	//   wsze_, şîne_, _कारग, dlia, 
   {{0xa3d52191,0x291d2192,0x69dc2193,0x65620054}},	//   हिर_, ziwa_, _orre, _hioh, 
   {{0x7af52194,0x8cda00a2,0x2d852195,0x291d2196}},	//   _rozt, _पोहो, èle_, yiwa_, 
   {{0x6d44048a,0x2d912197,0xbc7911e6,0x50672198}},	//   glia, rsze_, рбах_, _утка, 
   {{0x69dc2199,0x7af5219a,0x2ca9219b,0x6562023a}},	// [1630] _arre, _pozt, rgad_, _mioh, 
   {{0x2d9100ab,0xaa67219c,0x6d44219d,0x69dc219e}},	//   psze_, стак, alia, _brre, 
   {{0x291d219f,0x612803c0,0x7d0300b3,0x628a0415}},	//   tiwa_, zılm, _înso, _mefo, 
   {{0x612807fa,0x628a21a0,0x6ca70cb4,0xe894004f}},	//   yılm, _lefo, _урож, заць, 
   {{0x69dc21a1,0x629821a2,0x291d21a3,0x7d0d21a4}},	//   _erre, _odvo, riwa_, mhas, 
   {{0x7d0d006b,0x291d21a5,0xab5b0019,0xdb0d0038}},	//   lhas, siwa_, _csüt, otaí, 
   {{0x24e9048a,0xceb4042c,0x442f0042,0xdb0d0038}},	//   имки_, פיק_, _sxg_, ntaí, 
   {{0x612805b7,0x7d1f02f1,0x6abc0082,0x77690126}},	//   tılm, niqs, _zbrf, _tuex, 
   {{0x628a21a6,0x130921a7,0x248d019c,0x00000000}},	//   _befo, иний_, raem_, --, 
   {{0x61280824,0x422521a8,0xe29908bd,0x569421a9}},	//   rılm, ждов, јан_, _наут, 
   {{0x90c6030f,0x7d0d21aa,0x60c600e0,0x6d440156}},	//   обне, khas, tekm, ylia, 
   {{0xf9920056,0x7bcf21ab,0x612821ac,0x69da21ad}},	//   ורט_, _oscu, pılm, _štek, 
   {{0x7529002e,0x7d0d00d4,0x6b50074b,0x60c6027e}},	//   mnez, dhas, läge, rekm, 
   {{0x26c721ae,0xa3d60dc4,0x628a21af,0x753b21b0}},	//   neno_, ाटर_, _gefo, louz, 
   {{0x628121b1,0x7bcf002e,0x6d4421b2,0x752921b3}},	//   mblo, _ascu, tlia, onez, 
   {{0x7d0d21b4,0x628121b5,0x26c721b6,0x6d4421b7}},	//   ghas, lblo, heno_, ulia, 
   {{0x8c4321b8,0x26c721b9,0x6d5621ba,0x8eba00d9}},	// [1640] дете, keno_, rmya, _кынт_, 
   {{0xb0aa15ba,0xac08004e,0x7bcf0126,0x98ad0032}},	//   _काँग, анға_, _dscu, _cieľ_, 
   {{0x7d0d21bb,0x26c721bc,0x49ca21bd,0xa3d5120f}},	//   bhas, deno_, рлен_, हिँ_, 
   {{0xdb0400eb,0x31ba00c7,0xd7fa002e,0x00000000}},	//   ntiú, יזענ, иул_, --, 
   {{0x765f06d0,0x26c721be,0x752921bf,0x628121c0}},	//   əyyə, feno_, dnez, kblo, 
   {{0x7d040088,0x26c702a3,0x69ce0226,0x752921c1}},	//   lkis, geno_, _tsbe, enez, 
   {{0xb0aa21c2,0xaa4311db,0x69dc21c3,0x20aa04cc}},	//   _कांग, _жерл, _urre, _कांध, 
   {{0x7d0421c4,0x628a21c5,0x99750283,0xa3d521c6}},	//   nkis, _sefo, _хурш, हिं_, 
   {{0x26c721c7,0x394621c8,0x628a0118,0xd9430267}},	//   beno_, mlos_, _pefo, _цети, 
   {{0x3946128a,0x26c721c9,0xb2b7011f,0x20d70023}},	//   llos_, ceno_, ольф_, _ủi_, 
   {{0xd48f21ca,0x7d0421cb,0xdb040369,0xb5ca00d7}},	//   _ор_, kkis, guié, _خوام_, 
   {{0x394602f2,0x657a010e,0x3860032f,0x7d0d21cc}},	//   nlos_, _itth, žiru_, xhas, 
   {{0x628a0026,0x628121cd,0x7d0d21ce,0x7d04039b}},	//   _tefo, bblo, vhas, dkis, 
   {{0x62980112,0xbcfb001d,0x628121cf,0xdb0421d0}},	//   _udvo, _cién, cblo, quiè, 
   {{0x7d0d21d1,0xf27b0056,0x394600e4,0x61fc0219}},	//   thas, _דרוש, klos_, ärld, 
   {{0xdb0400eb,0x26c71293,0x3946006d,0x80a521d2}},	//   ctiú, zeno_, jlos_, _काटे, 
   {{0x7d0d21d3,0x39460880,0xdb0d00eb,0x26c7044d}},	// [1650] rhas, dlos_, staí, yeno_, 
   {{0x657a0019,0x7d0d21d4,0x26c70042,0x3946060f}},	//   _otth, shas, xeno_, elos_, 
   {{0xceb21a61,0x7d04006d,0x7d0d21d5,0xaaac00bc}},	//   _איי_, bkis, phas, _चारक, 
   {{0x6b50014e,0x394621d6,0x7d0421d7,0x26c721d8}},	//   väge, glos_, ckis, weno_, 
   {{0x657a0640,0x26c721d9,0x66e521da,0x60dc00c7}},	//   _atth, teno_, зола, יקאנ, 
   {{0x628101cc,0x39460183,0xff7c0070,0x00000000}},	//   xblo, alos_, סטומ, --, 
   {{0x26c70112,0x80ac02f8,0x394621db,0x27e90474}},	//   reno_, _झाले, blos_, ţan_, 
   {{0x394621dc,0x6136006b,0x6b5001c4,0x6281039b}},	//   clos_, bály, räge, wblo, 
   {{0x628121dd,0x26c721de,0x753b0183,0x6b501096}},	//   tblo, peno_, rouz, säge, 
   {{0x13090b34,0x753b02d9,0xcfd10033,0x77f900c9}},	//   сной_, souz, ামান, ्नीक_, 
   {{0x753b090e,0x7d040533,0xbcfb0126,0x614621df}},	//   pouz, ykis, _rién, зена, 
   {{0xbcfb0369,0x00000000,0x00000000,0x00000000}},	//   _sién, --, --, --, 
   {{0xb4d702e6,0x628121e0,0x4aac009a,0xbcfb0126}},	//   ायी_, pblo, _चालव, _pién, 
   {{0x3f9e026e,0x657a0327,0xe7f31dce,0x63a9095a}},	//   čtu_, _ytth, _आपना_, muen, 
   {{0x7d0421e1,0xdb040107,0xbcfb0369,0x32420176}},	//   tkis, quié, _vién, _пешг, 
   {{0x2571008c,0x61fc02ae,0x41b20038,0xa01b01d5}},	//   _mál_, ärle, _أمير, mbön, 
   {{0xeb9a0623,0x7d0421e2,0x21220026,0xfbdf019c}},	// [1660] сиз_, rkis, mikh_, _crê_, 
   {{0x7d0421e3,0xa3dc06ea,0x60d621e4,0xe8160035}},	//   skis, डित_, _haym, _देगा_, 
   {{0x9d461f28,0xfbdf010c,0x60d6027e,0xa3d200bc}},	//   _неод, _erê_, _kaym, _हैन_, 
   {{0x7ae7024a,0x6136010e,0xaa57007a,0x00000000}},	//   _enjt, tály, سلنا_, --, 
   {{0x394621e5,0xe8160d0d,0x2efa01c4,0xf74621e6}},	//   rlos_, _देखा_, _kopf_, педо, 
   {{0x6136010e,0x1769004e,0x394621e7,0x60d60104}},	//   rály, іріп_, slos_, _laym, 
   {{0x25710183,0x394621e8,0x00000000,0x00000000}},	//   _cál_, plos_, --, --, 
   {{0x399b00a7,0x2571031e,0x63a904ef,0xd3a621e9}},	//   _לילד, _dál_, fuen, проп, 
   {{0x63a921ea,0x2a6a016a,0x07a302a0,0x6b9621eb}},	//   guen, _kgbb_, _патн, nsyg, 
   {{0xa3ab006a,0x877b035c,0x957c0083,0xff660216}},	//   गढ़_, _לאמי, _prąd, _şîna_, 
   {{0x290621ec,0xbcfb0151,0xa3b80249,0x00000000}},	//   okoa_, _biél, _चहक_, --, 
   {{0x63a921ed,0x29061efb,0x974700ca,0x60d621ee}},	//   buen, nkoa_, rićš, _caym, 
   {{0x63a9127e,0xbcfb21ef,0xe8df0023,0xdbf102d9}},	//   cuen, _diél, _nhờn_, tříc, 
   {{0x290f021e,0x957c0083,0x7d1d020b,0x00000000}},	//   zhga_, _trąd, _smss, --, 
   {{0x2d9e02f5,0x29060088,0xb2bb00d1,0x00000000}},	//   šten_, kkoa_, _המור, --, 
   {{0x614402a0,0x00000000,0x00000000,0x00000000}},	//   _пеја, --, --, --, 
   {{0xa3d5006a,0x3c5800d9,0xe8df0108,0x00000000}},	// [1670] हिए_, зитэ_, _chờn_, --, 
   {{0x290600b4,0x00000000,0x00000000,0x00000000}},	//   ekoa_, --, --, --, 
   {{0x2a780175,0x63a901ca,0x60d60585,0x5d550e9a}},	//   _dfrb_, zuen, _yaym, _окот, 
   {{0x25e004b7,0x5fb10366,0x00000000,0x00000000}},	//   किनी_, _जमाल, --, --, 
   {{0x257121f0,0x61360183,0x333e01d6,0x63a901cf}},	//   _sál_, rálx, kotx_, xuen, 
   {{0x290f0c67,0xb90421f1,0x857921f2,0x290601d6}},	//   shga_, _भो_, осит_, akoa_, 
   {{0x69da11c8,0x20020035,0x00000000,0x00000000}},	//   _štev, zyki_, --, --, 
   {{0x58d421f3,0x63a90a9f,0xb4d70c06,0x6b4b01c4}},	//   _пост, tuen, ाये_, zügl, 
   {{0x2be00d1d,0x195821f4,0x68e921f5,0x29070009}},	//   निया, _хаты_, _ined, ūnas_, 
   {{0x68fb21f6,0x63a921f7,0x68e90228,0x212200e2}},	//   _houd, ruen, _hned, wikh_, 
   {{0x68fb21f8,0x80d70086,0x10a621f9,0x60d621fa}},	//   _koud, ধান্, минн, _paym, 
   {{0x200200ab,0x68fb21fb,0x63a90126,0x60d60287}},	//   tyki_, _joud, puen, _qaym, 
   {{0x212219e0,0xe29921fc,0x63a921fd,0x68fb21fe}},	//   rikh_, _дал_, quen, _moud, 
   {{0x672321ff,0x290602ba,0xbcfb0696,0x20020083}},	//   ninj, zkoa_, _diém, ryki_, 
   {{0xdd1c026e,0x644f015e,0x60d62200,0x68e92201}},	//   _vážn, škić, _taym, _oned, 
   {{0xdb0d01c4,0x68fb2202,0x2d840098,0x7bc3020f}},	//   traß, _noud, ďme_, ănun, 
   {{0xab662203,0x21200574,0x2efa0502,0xe3b9010e}},	// [1680] двал, _imih_, _topf_, ntű_, 
   {{0x290d2204,0x68e92205,0x68fb008a,0x67232206}},	//   _alea_, _aned, _aoud, jinj, 
   {{0x68fb1c9f,0x68e9007b,0x3ebe00c2,0x6b960566}},	//   _boud, _bned, õttu_, ssyg, 
   {{0xc7c62207,0x660300ab,0x68fb0107,0xb4d7031e}},	//   дски, dynk, _coud, ायो_, 
   {{0x4c3600e4,0x68fb2208,0x29062209,0xe73a0a36}},	//   _цэнт, _doud, rkoa_, оед_, 
   {{0x291f0065,0x290601f1,0x68e9220a,0xdddc0083}},	//   _emua_, skoa_, _ened, karż, 
   {{0x8a06093e,0x68fb0212,0x7afc00b4,0xdd1d00da}},	//   _ўзбе, _foud, _iort, lášs, 
   {{0x25a0220b,0x7afc220c,0x68fb220d,0xe81f0c14}},	//   čil_, _hort, _goud, _मेवा_, 
   {{0x6723220e,0x644e0035,0x96ba220f,0x00000000}},	//   binj, ębio, _мужу_, --, 
   {{0x672304d1,0x68fb0b32,0x21200574,0x00000000}},	//   cinj, _zoud, _amih_, --, 
   {{0x36060629,0xbcfb10fd,0x2d9e02d9,0x66e30d3d}},	//   _تواف, _diéj, átel_, _јоха, 
   {{0x7afc02ba,0x249d018e,0x7bc6039b,0x261709d3}},	//   _lort, _gdwm_, _opku, _भेटी_, 
   {{0x7afc018c,0x2d9e02ef,0x7d03107c,0x611400b3}},	//   _oort, štel_, _însi, тдяу, 
   {{0x7afc1dfd,0x2120002c,0x05c202e6,0x15f21126}},	//   _nort, _emih_, _शहाब, _अपार_, 
   {{0xa3d60f01,0x7bc601dd,0x64550083,0xdb0d019c}},	//   ाटक_, _apku, ęzie, ltaç, 
   {{0x50670925,0x6b500219,0x6ca42210,0xa115009c}},	//   _отпа, väga, круж, _سوخت, 
   {{0xdb0d03b7,0x3b552211,0x7afc05a1,0x68fb2212}},	// [1690] ntaç, екар, _bort, _roud, 
   {{0x291f2213,0x68fb2214,0xdb0d0165,0x68e92215}},	//   _smua_, _soud, itaç, _sned, 
   {{0x68fb2216,0x7afc2217,0x8c420241,0x00000000}},	//   _poud, _dort, öğre, --, 
   {{0x2d8301c8,0xe7f30083,0x38352218,0x6ebb1507}},	//   mpje_, _आपदा_, ннер, श्रु, 
   {{0x672303ef,0x69da00f1,0x68fb026a,0x31b8010e}},	//   tinj, _štet, _voud, héz_, 
   {{0x7afc2219,0xe73300b8,0x68fb10de,0x6b5002ae}},	//   _gort, خصص_, _woud, lägn, 
   {{0x672311c8,0xe81f221a,0x2367024a,0x68fb03a0}},	//   rinj, _मेरा_, _rinj_, _toud, 
   {{0x67d5221b,0x6723221c,0x7afc0a9f,0x68e90156}},	//   _побу, sinj, _zort, _uned, 
   {{0x77680183,0x7afc040c,0x386d221d,0x75d300ad}},	//   _fidx, _yort, _iger_, _məzə, 
   {{0x7afc221e,0xcb1200c7,0xfbd200a7,0x21200065}},	//   _xort, ָלט_, נתי_, _smih_, 
   {{0x7648221f,0x7d0f0019,0xe1262220,0x7c290082}},	//   _gydy, _olcs, емни, _žerl, 
   {{0x75d306d0,0x70aa2221,0xbcfb0a13,0xe8df0023}},	//   _nəzə, कलेल, _diék, _khốn_, 
   {{0xa3d50081,0x31692222,0x13f40093,0x2d8302b0}},	//   हिओ_, _diaz_, _изця, epje_, 
   {{0x2d9e0062,0x63bb2223,0x69c702c7,0x00000000}},	//   štem_, mtun, _opje, --, 
   {{0x63bb2224,0x2f14022b,0x9db9004e,0xed5a2225}},	//   ltun, _lägg_, мыту_, зов_, 
   {{0x7afc2226,0xc5f200c7,0x629c00da,0x621a00d1}},	//   _sort, נדן_, órov, _מוצק, 
   {{0x60c40199,0xe81f2227,0xa3d52228,0x2d83039b}},	// [16a0] _ibim, _मेला_, हिट_, apje_, 
   {{0x7afc003d,0x63bb2229,0x386d222a,0x2907010c}},	//   _qort, itun, _ager_, ênan_, 
   {{0x63bb222b,0x7afc0f08,0xfbdf0023,0x3944011c}},	//   htun, _vort, _uyên_, _pkms_, 
   {{0x63bb222c,0x764802bf,0x7afc222d,0xe8fa0028}},	//   ktun, _rydy, _wort, яле_, 
   {{0x6d46222e,0x67d4222f,0xe8df0023,0x69d52230}},	//   _ikka, толу, _chốn_, _esze, 
   {{0x6b842231,0x98c50243,0x63bb2232,0x8f9b2233}},	//   mpig, ītās_, dtun, ליני, 
   {{0x60c42234,0xceb300c7,0x63bb2235,0xdb040212}},	//   _obim, טיג_, etun, vriè, 
   {{0x63bb2236,0x75d30095,0xa3dc0c02,0x6b84025b}},	//   ftun, _xəzə, डिल_, opig, 
   {{0x63bb2237,0xd4e30088,0xdb040107,0x61e32238}},	//   gtun, ующи, triè, _arnl, 
   {{0xdb0d2239,0x0bb700d1,0x2d830034,0x6b84223a}},	//   rtaç, עלים_, ypje_, ipig, 
   {{0x6d46223b,0xdb04026d,0x95ca223c,0xdb0d02a0}},	//   _okka, rriè, _хлеб_, staç, 
   {{0x7c290097,0xdb0d0165,0xdcdf0366,0x26ce084c}},	//   _žerm, ptaç, _पोंछ, lefo_, 
   {{0xa3e4000d,0xdb040183,0x5067002e,0x00000000}},	//   _पछि_, ntió, этоа, --, 
   {{0x545302fb,0x6d46223d,0xdef8223e,0x60c40547}},	//   _світ, _akka, ныс_, _ebim, 
   {{0x0dc811ab,0x7c870267,0xac95134b,0x7203010e}},	//   нути_, еузе, кавш, _مووم, 
   {{0x2b58223f,0x2d8302b0,0x26ce2240,0x75d300ad}},	//   _ahrc_, rpje_, hefo_, _qəzə, 
   {{0x8aa72241,0x69c72242,0xfaa70445,0x6b8406e4}},	// [16b0] еред, _spje, ешен, gpig, 
   {{0x60dd2243,0x2fc92244,0x6d460547,0xef1103a1}},	//   ldsm, _ipag_, _ekka, _түгө, 
   {{0xf99306ab,0x63bb20e9,0x27e4011c,0x7dc40019}},	//   ابط_, ztun, _armn_, _یقین, 
   {{0x60dd2245,0x2fc9011d,0x2d8100a0,0x63bb071d}},	//   ndsm, _kpag_, _ithe_, ytun, 
   {{0xb8c92246,0x69d500ab,0x60dd2247,0x26ce084c}},	//   _गए_, _wsze, idsm, fefo_, 
   {{0x6d4d2248,0x2f140219,0x752201b8,0xd2462249}},	//   llaa, _vägg_, _amoz, _نن_, 
   {{0xa3b300a2,0x98c7224a,0x6d46003e,0x6d4d040b}},	//   जून_, _псал, _ykka, olaa, 
   {{0x63bb224b,0x386d01cc,0x60dd055f,0x6d4d224c}},	//   ttun, _uger_, jdsm, nlaa, 
   {{0x76b9005e,0x63bb0088,0x7d0300b3,0x7c290121}},	//   _олар_, utun, _însu, _žerj, 
   {{0x613d006b,0x63bb0305,0x7522224d,0x2d9e00bc}},	//   mély, rtun, _emoz, átek_, 
   {{0x63bb224e,0x6d4d224f,0x3f80002e,0x2d810201}},	//   stun, klaa, _stiu_, _nthe_, 
   {{0x2d9e2250,0xbcfb02aa,0x6d4d01d2,0x00000000}},	//   štek_, _fiéi, jlaa, --, 
   {{0x889a00a7,0x6d4d2251,0x2f14014e,0x2d812252}},	//   וברי, dlaa, _läge_, _athe_, 
   {{0x4ed52253,0xdb04026d,0x656b2254,0x63a92255}},	//   люст, prié, _high, mren, 
   {{0x63a92256,0x656b2257,0x3f6708d6,0x60c400a1}},	//   lren, _kigh, тиро_, _tbim, 
   {{0x6d4d2258,0x63a92259,0x657c010e,0x61280585}},	//   glaa, oren, _érhe, rıls, 
   {{0x656b225a,0x26c50036,0xeb97225b,0x63a9225c}},	// [16c0] _migh, _oblo_, кит_, nren, 
   {{0x6d4d225d,0x613d0019,0x656b225e,0x6b84225f}},	//   alaa, dély, _ligh, rpig, 
   {{0x2be00081,0x63a92260,0x644b012d,0x656b0a69}},	//   निहा, hren, _lygi, _oigh, 
   {{0x63a9090b,0xfbab190a,0x656b2261,0x6b842256}},	//   kren, _चमचम, _nigh, ppig, 
   {{0x68430b58,0x26ce07d7,0x18670fa7,0x613d039f}},	//   анца, tefo_, ваци_, gély, 
   {{0x656b02d0,0x6d442262,0xd09a00ad,0xfaa60080}},	//   _aigh, loia, rçək, _шаго, 
   {{0xdb04128a,0x63a92263,0x28dd0fcf,0x2be00fc0}},	//   stió, eren, _नोकि, निवा, 
   {{0x6d442264,0x7d03020f,0x26ce0379,0x644b03c6}},	//   noia, _înst, sefo_, _bygi, 
   {{0x63a92265,0xdb040183,0x7e7e023e,0x00000000}},	//   gren, ltiñ, _ofpp, --, 
   {{0xbcfb0183,0x86ea0038,0x14ae009a,0xd2500499}},	//   _viéi, _تعرف_, _टाकण, ینک_, 
   {{0xdb040496,0x63a92266,0x656b00d1,0x60cf0183}},	//   ntiñ, aren, _figh, tecm, 
   {{0x94260088,0xdb040183,0x6913027e,0x6d44019c}},	//   _имее, itiñ, _içec, joia, 
   {{0xc3c4004e,0x60dd2267,0x6d442268,0x63a92269}},	//   _сөйл, rdsm, doia, cren, 
   {{0x4ea401ff,0xdb25039f,0x00000000,0x00000000}},	//   ирса, épül, --, --, 
   {{0x7e281222,0x6d4d226a,0x6e94226b,0x2749009e}},	//   віта_, tlaa, рису, _hînî_, 
   {{0xe7f300a2,0x6d44226c,0x1bd500fd,0xd1c70176}},	//   _आपला_, goia, лобя, _рушд_, 
   {{0xdc550316,0x6d4d01a9,0x2d7800ef,0x69da226d}},	// [16d0] увањ, rlaa, _učen_, _štep, 
   {{0x6d4d09a2,0xf1b617f6,0x20040502,0xb05b0080}},	//   slaa, _अमान, ämie_, seäs, 
   {{0x6d4d226e,0x7b64005e,0x2d81019b,0x63a9226f}},	//   plaa, ртте, _uthe_, zren, 
   {{0xe0df2270,0x7d16014b,0xa3d2007e,0x2be00299}},	//   ndò_, chys, _हईं_, निशा, 
   {{0x656b0056,0xfd561490,0x7d0d2271,0x4993010e}},	//   _righ, _תשרי_, mkas, _چیئر, 
   {{0x656b2272,0xe8df0108,0x00000000,0x00000000}},	//   _sigh, _phồn_, --, --, 
   {{0x99672273,0xdb0421dc,0x656b2274,0xbcfb023e}},	//   _атал, quiá, _pigh, _diév, 
   {{0x693c07c7,0x2749010c,0x2578010e,0x00000000}},	//   včeg, _bînî_, _dél_, --, 
   {{0xe299001c,0x63a92275,0x38352276,0x7d0d2277}},	//   нап_, uren, _снар, ikas, 
   {{0xe1f9030f,0x63a92278,0x656b2279,0x25780019}},	//   его_, rren, _wigh, _fél_, 
   {{0x7d0d227a,0xaaab0586,0x257808a0,0x656b227b}},	//   kkas, _चयनक, _gél_, _tigh, 
   {{0x386905ae,0x64550095,0x656b1430,0x6d4401d6}},	//   žaru_, əzin, _uigh, xoia, 
   {{0x03a5227c,0x53a5227d,0x7d0d227e,0x6d44227f}},	//   _сило, _салб, dkas, voia, 
   {{0x75292280,0xfd650108,0x7d0d059e,0x00000000}},	//   liez, _truồ, ekas, --, 
   {{0xc0e62281,0xdd1d00bc,0xdb040165,0xe7da0035}},	//   _бойк, lářs, luiç, _मैनप, 
   {{0x7d0d2282,0x7e7c0369,0x75292283,0x9f4000b9}},	//   gkas, scrp, niez, _triï_, 
   {{0x0aea2284,0x6eac00ab,0xdb040165,0x6d442285}},	// [16e0] ндай_, _जयपु, nuiç, roia, 
   {{0x7d0d0088,0x8a3a00c8,0x6d442286,0x945d0035}},	//   akas, няет_, soia, leńs, 
   {{0x88860141,0x6d442287,0x75292288,0x7d162289}},	//   глеж, poia, kiez, phys, 
   {{0xdb0403da,0x8884004e,0x25aa004f,0x2bac0c46}},	//   rtiñ, рғал, _åbli_, _चिपा, 
   {{0xa3d22125,0xdb04228a,0x6ac90086,0x2578005f}},	//   _हैं_, stiñ, রয়ো, _sél_, 
   {{0xaa460ca9,0xdd1d00bc,0x3ce0228b,0x25780175}},	//   _бегл, dářs, ldiv_, _pél_, 
   {{0x645d010d,0xceb300a7,0xe5c621a9,0xbcfb00d7}},	//   ýsin, ציה_, усло, _dhéf, 
   {{0x752901ca,0xfaa60258,0xd946228c,0x257801d5}},	//   giez, _шаҳо, _себи, _vél_, 
   {{0x28dd000f,0xdb040165,0x46b60625,0x257801c8}},	//   _नोटि, guiç, _محاس, _wél_, 
   {{0x3946228d,0x2578228e,0x9bbb00c7,0x5186228f}},	//   loos_, _tél_, עציפ, лума, 
   {{0xaac62290,0x80de00cc,0xd25000c5,0x7d0d2291}},	//   र्यक, যান্, تند_, ykas, 
   {{0xdb0402a0,0x26de2292,0x75292293,0xdd1d02d9}},	//   buiç, _hato_, ciez, bářs, 
   {{0xa3b305fd,0xc2e600cf,0x26de2294,0x7d0d2295}},	//   जूद_, _бўйи, _kato_, vkas, 
   {{0x4ea71b17,0x26de18ef,0x52762296,0x1ee7009c}},	//   ырма, _jato_, _суду, دوسی_, 
   {{0xc27b07f5,0xdd950161,0x7d0d2297,0x627b042c}},	//   _ארוי, рабы, tkas, _אנונ, 
   {{0x629a2298,0xf1a900ab,0x26de2299,0x257100d2}},	//   lato, _कितन, _lato_, _ušle_, 
   {{0x3946229a,0xdfd500f0,0x00000000,0x00000000}},	// [16f0] doos_, _топы, --, --, 
   {{0x212b02e7,0x7d0d229b,0x6d480218,0x60df040c}},	//   lich_, skas, îdar, _haqm, 
   {{0x98750c09,0x00000000,0x00000000,0x00000000}},	//   алец, --, --, --, 
   {{0x629a229c,0x212b01c5,0x26de0054,0xaa64229d}},	//   hato, nich_, _aato_, стук, 
   {{0x26de229e,0xbcfb229f,0x752922a0,0xab5b00f6}},	//   _bato_, _diét, viez, _aqüe, 
   {{0x7ceb0750,0x212b22a1,0x945d00ab,0xd62911c3}},	//   _förä, hich_, zeńs, коле_, 
   {{0x212b006a,0x26de22a2,0x629a2265,0xbcfb0042}},	//   kich_, _dato_, dato, _chég, 
   {{0x212b08fc,0xdb0403b7,0x19590235,0x77900116}},	//   jich_, tuiç, _рабы_, _کیوا, 
   {{0x212b01fd,0x26de02a0,0x629a22a3,0x80de0086}},	//   dich_, _fato_, fato, যাম্, 
   {{0x032522a4,0x26de22a5,0x13090088,0x7644010c}},	//   рдон, _gato_, тной_, şiya, 
   {{0x752922a6,0xcb1400a7,0xe1f6002e,0xdce60243}},	//   piez, מלץ_, агэ_, _likā, 
   {{0x212b22a7,0x9567048a,0x75ca06d0,0x6146192f}},	//   gich_, _създ, _qəze, рема, 
   {{0x248d22a8,0x5edf0086,0x33871416,0x2fdb008a}},	//   mbem_, মানে, _суев, _csqg_, 
   {{0x629a22a9,0xb05b0f03,0x91e522aa,0x6d5d22ab}},	//   cato, pfän, _воке, _ahsa, 
   {{0xde030dc0,0x78bb03f5,0x212b0237,0xb05b0380}},	//   опри, _ocuv, bich_, lfäl, 
   {{0xac8622ac,0x212b0187,0x3946006d,0x25dd00b0}},	//   ргал, cich_, xoos_, _कईनी_, 
   {{0x998d22ad,0x8b2622ae,0x4c6a22af,0xbea622b0}},	// [1700] _ćeš_, адае, тиан_, _капк, 
   {{0x6d5d22b1,0xdb040080,0x8d760e0e,0x00000000}},	//   _ehsa, htiö, _پادا, --, 
   {{0xa2bd00c6,0xbcfb0212,0x6b5000c2,0x394622b2}},	//   _शान्, _piét, nägi, toos_, 
   {{0x629a22b3,0xfce60c67,0x26de22b4,0x4973012d}},	//   zato, _томо, _sato_, іліс, 
   {{0x26c8032e,0x629a22b5,0xbcfb10fd,0x394622b6}},	//   лған_, yato, _dhéd, roos_, 
   {{0x3946006d,0x212b188e,0x38af0241,0x2d5700b9}},	//   soos_, zich_, törü_, nçen_, 
   {{0xfaa322b7,0x26de00a9,0xa9a300f0,0x80d7009a}},	//   _фасо, _vato_, _мирд, _बसले, 
   {{0x629a00c5,0xd94322b8,0x44f422b9,0x69ce04c6}},	//   wato, _деси, спис, _ipbe, 
   {{0x26de22ba,0x212b22bb,0x2fc00201,0x629a22bc}},	//   _tato_, vich_, _nqig_, tato, 
   {{0x68e022bd,0x69dc0082,0x29040548,0x6fad0299}},	//   _hamd, _ksre, _homa_, _जिबू, 
   {{0x290422be,0xbcfb22bf,0x212b22c0,0xd25a00fd}},	//   _koma_, _miér, tich_, ъци_, 
   {{0x68e222c1,0x29040caf,0x644600c2,0x61b60083}},	//   ndod, _joma_, ükis, _अमीष, 
   {{0x212b22c2,0x2f14022b,0xa3dc0b6c,0x68e20036}},	//   rich_, _säga_, डिओ_, idod, 
   {{0x290422c3,0x212b01c5,0x69dc008b,0x69ce22c4}},	//   _loma_, sich_, _osre, _opbe, 
   {{0x2d85051e,0x4d2702a0,0x709522c5,0x68e208b0}},	//   ële_, аќаа, _лайф, kdod, 
   {{0x5c7522c6,0x2f140077,0x290422c7,0x629822c8}},	//   слат, _väga_, _noma_, _hevo, 
   {{0x212911e9,0x68e202bf,0x69dc22c9,0x645c00ad}},	// [1710] _imah_, ddod, _asre, əric, 
   {{0xf1da006a,0x4ea70acd,0x2129011c,0x2d780121}},	//   _बनान, _триа, _hmah_, _očeh_, 
   {{0x2904030b,0x257100ca,0xceb20070,0xda7800d9}},	//   _boma_, _ošla_, _ציט_, ряу_, 
   {{0x290422ca,0xc8790092,0x68e00156,0xdb160019}},	//   _coma_, _başa_, _camd, rtyá, 
   {{0x27e922cb,0x68e022cc,0xe0df03dd,0x00000000}},	//   ían_, _damd, llòs_, --, 
   {{0x629822cd,0x81cd00cc,0x7bdd0056,0xc724004f}},	//   _nevo, রিত_, _issu, одій, 
   {{0x63a222ce,0xe7f3006a,0xf96b14c1,0x212900d4}},	//   _avon, _आपका_, _арай_, _omah_, 
   {{0xce380a33,0x25a922cf,0xd5b800a5,0x693c00ca}},	//   יאות_, čal_, _इमरज, rčec, 
   {{0x629822d0,0xe78422d1,0xa3d20262,0x64a522d2}},	//   _bevo, _духо, हौल_, _ғала, 
   {{0xf7700084,0xc2e9006b,0x212922d3,0x629822d4}},	//   _قال_, اعظم_, _amah_, _cevo, 
   {{0x7c3b010d,0x395f006d,0xa2e502f1,0x629822d5}},	//   _þurf, _khus_, _ҳолд, _devo, 
   {{0xa3d20f63,0x443d006d,0x628e008c,0x9f840e65}},	//   _हैक_, _txw_, ðbor, оҳид, 
   {{0xe28e1a9e,0x4385057f,0x63850267,0x212900b9}},	//   _на_, _التق, _угла, _dmah_, 
   {{0x62981f3a,0xe7fa00a2,0x21290574,0xe29922d6}},	//   _gevo, ्हता_, _emah_, _сак_, 
   {{0x63a20e24,0x7bdd22d7,0xa3b31c54,0xdb0d22d8}},	//   _zvon, _assu, जूर_, guaí, 
   {{0x31a30749,0x61430f2e,0x2bac0299,0x628122d9}},	//   mız_, _неща, _चिदा, lclo, 
   {{0x290422da,0xed5700ce,0x68e022db,0x5aca02f1}},	// [1720] _roma_, сот_, _ramd, ллам_, 
   {{0x290422dc,0x628122dd,0x394d011c,0x68e022de}},	//   _soma_, nclo, _akes_, _samd, 
   {{0x31a322df,0x7bdd0a8b,0x588622e0,0x290422e1}},	//   nız_, _essu, была, _poma_, 
   {{0xd83a1dbc,0x395f22e2,0x75ca0095,0x61fc0a25}},	//   лэл_, _chus_, _nəza, ärli, 
   {{0xe1e7086b,0x68e222e3,0xc79616d0,0x765a162a}},	//   _کس_, rdod, ёрды, _szty, 
   {{0x2904019b,0x9976123f,0xdb04001d,0x612f05d5}},	//   _woma_, _гуаш, briá, _kòlè, 
   {{0x63a2010d,0x69dc08b1,0x6d41010d,0x3ce205ae}},	//   _svon, _usre, élag, _kakv_, 
   {{0x186a08e4,0x75ca0095,0x7644027e,0x7d060f3d}},	//   _баби_, _cəza, şiyo, _joks, 
   {{0x7d0600e4,0xa3b3034d,0x68fd01be,0x00000000}},	//   _moks, जूल_, _òsda, --, 
   {{0x628122e4,0x7d0622e5,0xfc3f001d,0xaab3031e}},	//   gclo, _loks, _odín_, ुभएक, 
   {{0x60f922e6,0x14ca0088,0x8afb008d,0x2d9e0151}},	//   ання_, _были_, אליז, âtel_, 
   {{0x63a20089,0x7d0622e7,0x657a01be,0xeb050299}},	//   _tvon, _noks, _iuth, _शक्त_, 
   {{0x25710062,0x629822e8,0x321e0035,0x4ad8034d}},	//   _ušla_, _tevo, szty_, ड़ाव, 
   {{0x657a22e9,0x543b00c7,0x612f05d5,0x2bb7034d}},	//   _kuth, _געדא, _bòlè, इंसा, 
   {{0x91860e61,0xdd94001c,0x5186022c,0x3ce2040b}},	//   _اجتم, засы, _уула, _bakv_, 
   {{0x212922ea,0x657a0727,0x40350afc,0x5d5507f4}},	//   _umah_, _muth, _мейс, ікат, 
   {{0x2d582241,0x657a22eb,0x60cd22ec,0xba99004f}},	// [1730] сить_, _luth, _ibam, иває_, 
   {{0x3f890165,0x2dd517d7,0x657a03c5,0x9f530083}},	//   _itau_, _джор, _outh, ądów_, 
   {{0x395f006d,0x657a023e,0x2d9e22ed,0xbcfb0175}},	//   _phus_, _nuth, šter_, _chéc, 
   {{0x26cc22ee,0x7644027e,0xfbd0010e,0x98bd0083}},	//   _abdo_, ğiyl, بتہ_, kową_, 
   {{0x7bc422ef,0x2b931fdb,0x657a0056,0x60cd22f0}},	//   ctiu, _ریاس, _auth, _mbam, 
   {{0x6b8d22f1,0xdb23161f,0x31a3008f,0x657a22f2}},	//   mpag, örän, yız_, _buth, 
   {{0x451922f3,0x60cd22f4,0x6b8d22f5,0x7d0601f0}},	//   иция_, _obam, lpag, _yoks, 
   {{0x69c522f6,0xc984058e,0x6b8d22f7,0x75ca0095}},	//   mthe, _хури, opag, _qəza, 
   {{0x31d10c14,0x3f890e0c,0x4ac622f8,0x69c522f9}},	//   तब्ध, _ntau_, र्वव, lthe, 
   {{0x657a22fa,0x693c1425,0x60cd22fb,0x69c522fc}},	//   _futh, nčen, _abam, othe, 
   {{0x3f8922fd,0x657a22fe,0x69c522ff,0xc5d92300}},	//   _atau_, _guth, nthe, _خواص_, 
   {{0xe56e02fb,0x69c50adb,0x291d1f87,0x27ed2301}},	//   _із_, ithe, nhwa_, _kren_, 
   {{0x31a303c0,0x505a0d3b,0xb05b0502,0x62832302}},	//   sız_, ршня_, nfäh, _tfno, 
   {{0x6b8d2303,0xe3b02304,0x69c52305,0x693c0254}},	//   dpag, _سره_, kthe, jčen, 
   {{0x693c014b,0x78a92306,0xec9a1571,0x291d0415}},	//   dčen, _odev, итај_, khwa_, 
   {{0x2d78015e,0x27ed2307,0x78a90d4e,0xa01b2308}},	//   _očev_, _oren_, _ndev, rbör, 
   {{0x7d0609a8,0x6b8d1a71,0xdee62309,0xa01b230a}},	// [1740] _voks, gpag, _допи, sbör, 
   {{0x78a90012,0x249f01a0,0x7bc4230b,0xab5b0380}},	//   _adev, haum_, rtiu, _spür, 
   {{0x7bc4230c,0xe9da230d,0xed5a230e,0xaac60662}},	//   stiu, рке_, _вон_, र्षक, 
   {{0x6b8d230f,0x657a2310,0x7bc416cd,0x57ea0f7d}},	//   bpag, _ruth, ptiu, идем_, 
   {{0x2ca02311,0x657a2312,0x27ed2313,0x3f890640}},	//   maid_, _suth, _cren_, _xtau_, 
   {{0xfdfe1422,0x6d562314,0x657a2315,0x69c50e16}},	//   _उपास_, llya, _puth, bthe, 
   {{0x27ed2316,0xd5b000eb,0x657a2317,0x69c52318}},	//   _eren_, رفة_, _quth, cthe, 
   {{0x291d2319,0x4ac600ab,0x2ca0231a,0x98bd0035}},	//   chwa_, र्रव, naid_, tową_, 
   {{0xdddc01b4,0x27ed231b,0x2be0009a,0x657a011c}},	//   jbrž, _gren_, निटा, _wuth, 
   {{0xbcfb00eb,0xdb0d0183,0x98bd0083,0x28c80249}},	//   _mhéa, traé, rową_, रभवि, 
   {{0x3f8900d9,0xdcfc0009,0x2ca000b0,0x6b500c98}},	//   _stau_, sprę, kaid_, lägs, 
   {{0x645c0264,0x2ca0007e,0x249f02be,0x00000000}},	//   ərin, jaid_, caum_, --, 
   {{0xb4d6190a,0xc05b005e,0xb4b6100d,0x5f94231c}},	//   ाजी_, рін_, जली_, мият, 
   {{0xa3d70509,0xf651006b,0x6d5a010c,0x764d0248}},	//   ाबर_, _آئے_, îtan, şaye, 
   {{0x6b8d231d,0x69c501f5,0xf1c300bc,0x656207d7}},	//   wpag, xthe, _vaší_, _khoh, 
   {{0xbcfb00eb,0x2ca0231e,0x60cd007c,0x81cd0033}},	//   _bhéa, gaid_, _ubam, রিশ_, 
   {{0xbcfb0084,0x0ca80093,0x7c3b090e,0x6b8d231f}},	// [1750] _chéa, ютри_, _žurb, upag, 
   {{0xbcfb057f,0x6b8d2320,0x81cd0086,0x249f2321}},	//   _dhéa, rpag, রির_, zaum_, 
   {{0xa2bd119b,0x291d2322,0x13d30086,0x6b8d2323}},	//   _शास्, thwa_, ়িয়, spag, 
   {{0xa2ca1276,0xbcfb0084,0x2ca02324,0x69c52325}},	//   त्त्, _fhéa, caid_, rthe, 
   {{0x6cfa00d1,0xbcfb007a,0x693c10d4,0x6b8d023e}},	//   _הפרס, _ghéa, pčen, qpag, 
   {{0x291d2326,0x2486023a,0x6562016c,0xb05b0502}},	//   shwa_, _afom_, _ahoh, rfäh, 
   {{0x6ecd000c,0xb05b0380,0xa8a71d6b,0x249f019c}},	//   द्यु, sfäh, _мрак, taum_, 
   {{0x27ed2327,0xd4d902fb,0x65622328,0xdb042329}},	//   _tren_, ські_, _choh, triç, 
   {{0x27ed232a,0x249f0f08,0x481502f1,0xe3b10038}},	//   _uren_, raum_, _эмас, ررة_, 
   {{0x249f0201,0x6b5002ae,0xb225232b,0xdb0402be}},	//   saum_, lägr, змол, rriç, 
   {{0xdb0d1056,0x656200a1,0x06760070,0x00000000}},	//   ntañ, _fhoh, _זײער_, --, 
   {{0x24840183,0xdb0d10f3,0xfbac0466,0x00000000}},	//   ccmm_, kraï, _चिलम, --, 
   {{0x2ca00077,0x656900fb,0x2056232c,0x645d00c2}},	//   vaid_, mmeh, ятор, üsid, 
   {{0x65620065,0x6569232d,0xd343010e,0x6826040c}},	//   _zhoh, lmeh, _تفتی, _bаdj, 
   {{0xdb0d026a,0x551f0667,0xbcfb0038,0x6569023a}},	//   traî, _बताए_, _shéa, omeh, 
   {{0x3b8612dc,0xec7a232e,0x753b02a3,0x65691624}},	//   злаг, спа_, nnuz, nmeh, 
   {{0x1d07232f,0x6d56011d,0x25dd0035,0x98af0028}},	// [1760] чети_, rlya, _कैसी_, logė_, 
   {{0x2ca02330,0x6b50014e,0x7c3b2331,0x63a62332}},	//   said_, vägs, _žurc, ákni, 
   {{0x2ca02333,0x6d560102,0x6d4d023a,0x49ca0e1b}},	//   paid_, plya, boaa, слен_, 
   {{0xbcfb00eb,0xa9672334,0x00000000,0x00000000}},	//   _théa, пиха_, --, --, 
   {{0xdb040876,0x24c30033,0x80ce09d3,0x00000000}},	//   nsië, ্যাহ, ध्ये, --, 
   {{0x6562189e,0x45d42335,0xa9a62336,0xdbc700b0}},	//   _shoh, докс, _нигд, tööt, 
   {{0xc1da000f,0xdb04014e,0x7c2400d9,0x65620026}},	//   _बनेग, rriä, lzir, _phoh, 
   {{0xdce42337,0x48e32338,0xb4d610ae,0x7d042339}},	//   kmič, _посв, ाजे_, njis, 
   {{0xd9430593,0x7c24233a,0xa2bd1451,0x00000000}},	//   _чети, nzir, _शाश्, --, 
   {{0x645c06d0,0xdce4209c,0x78a201a7,0x98bd0035}},	//   əril, dmič, laov, dowę_, 
   {{0x6562233b,0x867500e4,0x00000000,0x00000000}},	//   _thoh, _жыцц, --, --, 
   {{0x78a205f0,0x2d5701f0,0xbcfb002c,0x3a3700d1}},	//   naov, rçek_, _ahén, לרים_, 
   {{0x50640886,0x75ca0095,0x0f7300a3,0x2d780604}},	//   етра, _məzm, нғир, _očes_, 
   {{0x70770274,0x78a20054,0x69c1017b,0x941e035d}},	//   _کاغذ, haov, _åleg, ığıy, 
   {{0x78a2090f,0x975707e4,0x9f4402d9,0xbcfb233c}},	//   kaov, פילו_, ímá_, _dhén, 
   {{0xd23b0052,0x7d0401ee,0x9ce400b3,0x91bb00df}},	//   _לגול, gjis, нцул, _המהי, 
   {{0x2b5102fe,0x6f01010e,0xdb0d02aa,0x4bc203a1}},	// [1770] _pkzc_, ölcs, nuaç, көрг, 
   {{0x501c00d1,0x4424233d,0x3b541c7d,0xdb0d00f6}},	//   _לוחו, izm_, екур, rraï, 
   {{0xceb207f5,0xdb04026a,0x99d91a1c,0x89d90296}},	//   _ביי_, isiè, تواء_, توار_, 
   {{0x7c240a1a,0xb4d600aa,0xa3ac009a,0xdb0d007a}},	//   bzir, ाजो_, गळा_, mraí, 
   {{0xdb0d0c9a,0x66e5233e,0xc615233f,0xa8780038}},	//   stañ, дола, तन्य_, أحمر_, 
   {{0x8ae402fb,0x3ea32340,0xdb0d0165,0x3ce900b0}},	//   _післ, najt_, duaç, ldav_, 
   {{0x65692341,0xdb0d0038,0x2d860372,0x78a22342}},	//   tmeh, nraí, _čoek_, baov, 
   {{0xfdf800a7,0x7ae72343,0x3ce900b0,0xa2ca0bed}},	//   לצות_, _hajt, ndav_, त्स्, 
   {{0x65692344,0x0477006b,0x7ae7008b,0xdb0d2345}},	//   rmeh, _ہلاک_, _kajt, hraí, 
   {{0x394f00e0,0x65692346,0xdb160126,0x27e01240}},	//   logs_, smeh, tuyé, çine_, 
   {{0x7ae72347,0x7d1d2348,0x645c0095,0x216a2349}},	//   _majt, _olss, ərim, жини_, 
   {{0xcea90052,0x7ae7234a,0x8fa6234b,0x6fb200a5}},	//   _כי_, _lajt, маме, _जिदं, 
   {{0xd9aa017d,0xbcfb026a,0xe7f01d00,0x25a0090e}},	//   _चट्ट, _phén, चिया_, ćile_, 
   {{0x69d5012e,0xdce40b21,0xff5f0218,0xdb040326}},	//   _opze, rmič, stîn_, rsië, 
   {{0xdb0d0084,0xc10600eb,0x63bb234c,0xdce4234d}},	//   graí, _يوتي, luun, smič, 
   {{0x7c2401f1,0x2f1400c2,0x7c3b234e,0x8d551934}},	//   tzir, _mägi_, _žura, етуч, 
   {{0x3ce60039,0x63bb234f,0x7d042350,0x7d1600da}},	// [1780] ľov_, nuun, rjis, rkys, 
   {{0x3ce60228,0x7d162351,0xd9101c03,0x7ae70144}},	//   žov_, skys, گیر_, _cajt, 
   {{0x78a200a9,0x3ce92352,0x7ae72353,0xdb0d007a}},	//   taov, bdav_, _dajt, craí, 
   {{0xdb0d008c,0x3cf90183,0x693c0032,0x63bb2354}},	//   stað, _gnsv_, mček, kuun, 
   {{0x98a30834,0x87da17ba,0x97da0eea,0xdb0400eb}},	//   тиче, تباس_, تظار_, iriú, 
   {{0x63bb2355,0x758a004f,0x78a20054,0x66e30267}},	//   duun, осив_, saov, воља, 
   {{0x60c4090b,0x693c0032,0x78a20054,0x6b8401ff}},	//   _ocim, nček, paov, lqig, 
   {{0xdb0d03b7,0x7ae71f7d,0x63bb2356,0x38ca010e}},	//   tuaç, _zajt, fuun, _گاڑی_, 
   {{0x7ae7006d,0x693c02d9,0x33742357,0x63bb2358}},	//   _yajt, yčej, нгир, guun, 
   {{0x764d0824,0x60c403b7,0x59d2188d,0x78a00219}},	//   şaya, _acim, _सहार, _hemv, 
   {{0xe1352359,0xdb04235a,0x81d60033,0x65c3235b}},	//   енны, friú, সিভ_, _абха, 
   {{0x26dc235c,0xdb040107,0x92be0086,0x63bb0539}},	//   levo_, ssiè, ঁজে_, buun, 
   {{0x78a008a1,0xc1780009,0xdb0d02aa,0x3f800474}},	//   _memv, tvės_, quaç, _cuiu_, 
   {{0xdef8005e,0xdb0d235d,0x26dc02a3,0x78a00566}},	//   мыс_, traí, nevo_, _lemv, 
   {{0x7ae70019,0x3ea3235e,0x7d1d0102,0xdb040038}},	//   _rajt, rajt_, _plss, briú, 
   {{0x7ae7235f,0xa2ca2360,0x3ea32361,0xacbb078a}},	//   _sajt, त्र्, sajt_, _amûr, 
   {{0x7ae72362,0x60dd08b0,0xc1790009,0x3f672363}},	// [1790] _pajt, mesm, svės_, _отоб, 
   {{0x60dd2364,0x26dc2365,0xbcfb2366,0xc87900d9}},	//   lesm, jevo_, _théo, _iaşi_, 
   {{0x7ae72367,0x26dc2368,0x7ac40093,0x394f02ae}},	//   _vajt, devo_, ъсте, togs_, 
   {{0x25f42369,0x60dd236a,0x2561003e,0xaa6403a1}},	//   ्मनी_, nesm, kóla_, ттук, 
   {{0x7ae7236b,0x06e80033,0x394f236c,0x00000000}},	//   _tajt, পানি, rogs_, --, 
   {{0x2b000586,0x7c200241,0x00000000,0x00000000}},	//   राणु_, _ümra, --, --, 
   {{0x60dd236d,0x6aa5236e,0x62880369,0x9f4000a1}},	//   kesm, mahf, dcdo, _criù_, 
   {{0x63bb236f,0x3ea12370,0xfba32369,0x6aa50065}},	//   tuun, _leht_, _ओबाम, lahf, 
   {{0x2fc9006d,0x68fb2371,0x36d50fb9,0x2d8500bc}},	//   _nqag_, _inud, _поар, ílej_, 
   {{0x291f023b,0x26dc00fd,0x60c42372,0xa2052373}},	//   _hlua_, cevo_, _scim, епод, 
   {{0x68e919e0,0x68fb2374,0x63bb2375,0x00000000}},	//   _kaed, _knud, suun, --, 
   {{0xaacf1276,0x4acf05d0,0x290d00ca,0x628a2376}},	//   स्तक, स्तव, _joea_, _effo, 
   {{0x7c3b2377,0x290d0364,0x6aa50065,0x653a00c7}},	//   _žurn, _moea_, kahf, _צענד, 
   {{0x63a92378,0xbcfb023e,0xfd1f0036,0x2d812085}},	//   msen, _dhém, _alì_, _buhe_, 
   {{0x63a92379,0x52390070,0x60dd237a,0x6fb2009a}},	//   lsen, _מײַנ, besm, _जिवं, 
   {{0xfce3237b,0x693c0187,0x60c40ab4,0x1d071f99}},	//   лосо, rček, _ucim, неси_, 
   {{0x63a90df7,0x6b4b010e,0xab66237c,0x78a001d2}},	// [17a0] nsen, lügy, евал, _remv, 
   {{0x3ea102ec,0x63a9237d,0x68fb147e,0x291f01d6}},	//   _geht_, isen, _anud, _alua_, 
   {{0x81cd0086,0x26dc237e,0x25710082,0x291f011c}},	//   রিক_, vevo_, _ešli_, _blua_, 
   {{0xc7c6237f,0x63a92380,0x80de0086,0x291f00b9}},	//   ески, ksen, যাক্, _clua_, 
   {{0xb05b0219,0x26dc2381,0x63a92382,0x6459095a}},	//   lfär, tevo_, jsen, _nywi, 
   {{0x63a914a9,0x290d0118,0x36d40846,0x60dd2383}},	//   dsen, _eoea_, токр, zesm, 
   {{0xd91015c0,0x26dc2384,0x68e90938,0x78a0008b}},	//   _پیش_, revo_, _faed, _temv, 
   {{0x628a00ef,0x26dc02fe,0xd90d0c30,0x44f4021c}},	//   _sffo, sevo_, _ویل_, тпис, 
   {{0x64592385,0x26dc00fd,0x65790226,0x63a92386}},	//   _cywi, pevo_, _diwh, gsen, 
   {{0x21202387,0x6d1c031e,0x2bd100b0,0x290d025b}},	//   _alih_, नसँग_, हऽता, _zoea_, 
   {{0x225801cc,0x63a92388,0x5f9402f1,0x75d30195}},	//   ærk_, asen, ғист, _ميلا, 
   {{0x2d812389,0xb05b02ae,0x3ea10502,0x8c43009e}},	//   _ruhe_, dfär, _seht_, êşke, 
   {{0x2d81238a,0x64590156,0xc879020f,0x777a238b}},	//   _suhe_, _gywi, _paşi_, _kitx, 
   {{0xb05b0a25,0x60dd238c,0x2d811279,0x00000000}},	//   ffär, sesm, _puhe_, --, 
   {{0xa01b0019,0x1df8134f,0x2ca20118,0x777a01ca}},	//   nböz, неры_, _bekd_, _mitx, 
   {{0x81cd00cc,0xbcfb026a,0x21200352,0x2d8c0684}},	//   রিখ_, _thém, _glih_, ídea_, 
   {{0x7ff70038,0x5c75238d,0x80de0033,0x2d810027}},	// [17b0] _أسعا, тлат, যাখ্, _wuhe_, 
   {{0x79a70f6b,0x2120090e,0x68fb238e,0x291f007a}},	//   ерде, _zlih_, _snud, _slua_, 
   {{0xc33300a7,0x291f0201,0x290d07fc,0xdb04238f}},	//   נוע_, _plua_, _poea_, guiñ, 
   {{0x9f5205d5,0x777a01d6,0x75ca0248,0x61fe0151}},	//   _aryè_, _aitx, _gəzi, _àplu, 
   {{0x25710112,0x672300e5,0x777a0a9f,0x7afc00a1}},	//   _ušli_, thnj, _bitx, _fnrt, 
   {{0x45d50ec6,0x63a90657,0x6126003e,0x7bcd2390}},	//   вцит, vsen, _gólf, mtau, 
   {{0x7d0f010e,0xb8950038,0x5a4400b3,0x66180032}},	//   _kocs, _للأع, _бэта, _čaká, 
   {{0x63a92391,0x6723024a,0x68fb00ad,0x7d0f2392}},	//   tsen, shnj, _unud, _jocs, 
   {{0x777a2393,0x25a00112,0xab5b00f6,0xe2992394}},	//   _fitx, ćila_, _aqüi, мап_, 
   {{0x765a00e5,0x777a01ca,0x82f519fe,0x00000000}},	//   _fyty, _gitx, тчиц, --, 
   {{0x63a92395,0x7bcd00c8,0x3362011f,0x6fa400b0}},	//   ssen, htau, рвэг, _कबहू, 
   {{0x63a92276,0xbcfb01e5,0xa2bd088c,0x7bcd02eb}},	//   psen, _dhék, _शाक्, ktau, 
   {{0xa3e510a6,0x61e10156,0xab5b02be,0x7429007a}},	//   _पनि_, swll, _eqüi, _تكشف_, 
   {{0xb464004f,0x81bc01dd,0xb05b0c98,0x539a00d1}},	//   _скіл, izēj, tfär, _חיסו, 
   {{0x7d0f2396,0xed5a2397,0xdca62398,0x693c0864}},	//   _bocs, дов_, кави, mčev, 
   {{0xb05b0a25,0x25f41f5e,0x693c203b,0x316900c3}},	//   rfär, ्मती_, lčev, _ghaz_, 
   {{0x75ca06d0,0xed570316,0xb05b1096,0x7bcd2399}},	// [17c0] _vəzi, тот_, sfär, gtau, 
   {{0x693c239a,0x81bc00e0,0x387f01f1,0x27f80121}},	//   nčev, dzēj, _agur_, _črn_, 
   {{0x18a6239b,0x7d0f239c,0xb05b0a1b,0x99f5004f}},	//   ваем, _focs, ngän, ляці, 
   {{0xdcfe239d,0x6721239e,0xe995009c,0x00000000}},	//   _kupč, _allj, اهنگ, --, 
   {{0x2ba9093a,0x693c0082,0xdb040183,0x765a00c8}},	//   _चौपा, kčev, suiñ, _syty, 
   {{0xcf9300c7,0x387f01cf,0x80de0033,0xdcef0474}},	//   סטו_, _egur_, যাট্, _tică, 
   {{0x644e0095,0xdb0403da,0x19b900c8,0xe9a302a6}},	//   əbiy, quiñ, _путь_, _васп, 
   {{0xaa43239f,0x291c01dd,0x765a00da,0x186a05ef}},	//   _тесл, īvas_, _vyty, _жаби_, 
   {{0xf36623a0,0x765a0083,0x00000000,0x00000000}},	//   ктон, _wyty, --, --, 
   {{0x518602b9,0xd76400d4,0x764d010e,0x81d60033}},	//   кума, _صنای, ényé, সিস_, 
   {{0x69130c05,0xaad409e5,0x6d460613,0x54c600b3}},	//   _içer, ठ्यक, _ojka, _абеб, 
   {{0x7bcd0009,0xf48323a1,0x00000000,0x00000000}},	//   ytau, _кушн, --, --, 
   {{0x69c402e6,0xc058004f,0x693c0144,0x46c9036e}},	//   ांडी, вір_, bčev, _रामह, 
   {{0x82330274,0x545301fc,0xdb23027e,0x81cd0033}},	//   اریا, _твіт, örün, রিজ_, 
   {{0x5faf0081,0x752223a2,0xd37b027a,0x2e270104}},	//   _झटकल, _kloz, _קרוט, _nеft_, 
   {{0x7bcd0088,0xaac60df2,0xdb21027e,0x00000000}},	//   ttau, र्घक, ştür, --, 
   {{0x2d58030f,0x8aa70665,0x213923a3,0x7522018e}},	// [17d0] тить_, вред, mish_, _mloz, 
   {{0xd5a4082c,0x7bcd23a4,0xdd1100e0,0xbcfb0038}},	//   _وہ_, rtau, _kļūd, _mhéi, 
   {{0x9a84022c,0x7bcd23a5,0x9f4901f0,0xdcfe00d0}},	//   руул, stau, _araç_, _zupč, 
   {{0x213923a6,0x9f4903dd,0xc8b400f0,0x7bcd23a7}},	//   nish_, _braç_, асшы, ptau, 
   {{0x2ca900c2,0x75ca00ad,0x00000000,0x00000000}},	//   maad_, _məzu, --, --, 
   {{0x7522009e,0x2ca900bd,0x213900a3,0xd2460195}},	//   _aloz, laad_, hish_, _هن_, 
   {{0xa4930a24,0x44290228,0x213901ff,0x693c203b}},	//   لیات, _ťa_, kish_, včev, 
   {{0x2ca923a8,0xa3e923a9,0x13e9123f,0x29f30097}},	//   naad_, едиа_, емий_, _ića_, 
   {{0xbcfb0084,0xdb0d02a0,0x291d23aa,0xd3a400f0}},	//   _chéi, graç, mkwa_, алық, 
   {{0x21390102,0xdcfe0304,0x2ca9039b,0x20191b95}},	//   eish_, _rupč, haad_, dysi_, 
   {{0xc6920137,0x693c0688,0xbbd0031e,0x4615031b}},	//   _האב_, rčev, _सङ्क, _حوار, 
   {{0xbcfb00eb,0x0d8600cf,0xa2d307d5,0xdb0d0165}},	//   _fhéi, ғлан, _बॉर्, braç, 
   {{0x2ca908b0,0xb4df0d2e,0xb05b128d,0xf5390032}},	//   daad_, दजी_, sgän, miť_, 
   {{0x248d23ab,0xf5390187,0x752223ac,0x2d8c09c6}},	//   lcem_, liť_, _zloz, ídeo_, 
   {{0x63bb00e0,0x2f140219,0xd20303a1,0xa30a010e}},	//   lrun, _sägs_, _түнк, _سروے_, 
   {{0xf5390187,0x248d21bc,0x67380e67,0xed5a01a2}},	//   niť_, ncem_, zivj, хоб_, 
   {{0xb7be00cc,0x0b4623ad,0xa2ca0299,0x61260169}},	// [17e0] _ইন্ট, гнан, त्क्, _cóle, 
   {{0x81d60086,0x5eae0033,0x63bb23ae,0x4f9b0147}},	//   সির_, ঞ্জে, irun, _רביצ, 
   {{0x63bb02ec,0x2ca909c7,0x248f0183,0x09f616d0}},	//   hrun, baad_, _ofgm_, ычая, 
   {{0xf5390228,0xb95a0038,0x63a423af,0x248d23b0}},	//   jiť_, رجاء_, _çing, jcem_, 
   {{0xe73a0a43,0xf5390187,0x6d4423b1,0xb8dc0f8e}},	//   нед_, diť_, mnia, _आय_, 
   {{0x6d4417d8,0x6d5600cf,0x213923b2,0xfc3f0068}},	//   lnia, loya, zish_, _edís_, 
   {{0x63bb02f2,0x25a0090b,0x75c9004e,0x6ed607d5}},	//   erun, ćilo_, втың_, म्यु, 
   {{0x6d4423b3,0x6d5602f1,0xdb0d0165,0x7aee23b4}},	//   nnia, noya, traç, _habt, 
   {{0x63bb23b5,0xd90d006b,0x6d4423b6,0x7aee0495}},	//   grun, _تین_, inia, _kabt, 
   {{0x7c3b23b7,0x6d440938,0xdb0d0165,0x6d5600a3}},	//   _žurk, hnia, rraç, hoya, 
   {{0xf5390187,0x2d9823b8,0x2ca9018e,0x6d5623b9}},	//   biť_, jpre_, yaad_, koya, 
   {{0x6d44006f,0x7aee23ba,0x46130dec,0xfc3f0369}},	//   jnia, _labt, _دومر, _leía_, 
   {{0x213923bb,0x6d4423bc,0x63bb23bd,0x29370070}},	//   rish_, dnia, crun, ראכן_, 
   {{0x69dc23be,0x7aee0201,0xa29400e4,0x2ca91a77}},	//   _opre, _nabt, _такі, waad_, 
   {{0x693c23bf,0x213900a3,0x6d440156,0x65600038}},	//   nčes, pish_, fnia, olmh, 
   {{0x6d5623c0,0x213902f1,0x5c070093,0x6b860026}},	//   goya, qish_, ляза, _bukg, 
   {{0x2ca9228d,0x9f400126,0x69ce007b,0x81c60033}},	// [17f0] raad_, _crió_, _aqbe, _উনি_, 
   {{0x61f8090e,0xf5390039,0x63a223c1,0x2ca923c2}},	//   _krvl, ziť_, _mwon, saad_, 
   {{0x6d4423c3,0x7aee01a0,0x69dc1e31,0x6d5623c4}},	//   bnia, _dabt, _cpre, boya, 
   {{0x2ba912e3,0x57f523c5,0x9f400126,0x6d560126}},	//   _चौथा, ипет, _frió_, coya, 
   {{0xf5390039,0x6b86011c,0x7d0d23c6,0xac180259}},	//   viť_, _gukg, mjas, _бояу_, 
   {{0x7d0d23c7,0xc5f900cc,0xbcfb1cf0,0xf7960038}},	//   ljas, _অথবা_, _chév, جنوب_, 
   {{0xf5390187,0x2ba9000d,0x7c2d23c8,0x63a223c9}},	//   tiť_, _चौता, lzar, _awon, 
   {{0xdb0423ca,0x63a223cb,0xe78700b3,0xb605010e}},	//   brió, _bwon, _бужо, _aláí, 
   {{0x7c2d23cc,0xf5390187,0xf57600eb,0x693c0082}},	//   nzar, riť_, جميع_, rčet, 
   {{0xadf717dc,0x63bb23cd,0x6d4423ce,0xc6a403b7}},	//   ुमान_, rrun, znia, _грци, 
   {{0x6d4402bf,0xf5390187,0x248d23cf,0x6d5623d0}},	//   ynia, piť_, pcem_, yoya, 
   {{0x63bb23d1,0x61f8015e,0x81d60086,0x25f202e6}},	//   prun, _drvl, সিং_, ंटरी_, 
   {{0x53a523d2,0xe28e23d3,0x6d4423d4,0x6d5623d5}},	//   _талб, _ма_, vnia, voya, 
   {{0x6d4423b1,0x26c723d6,0x823500d4,0x08760070}},	//   wnia, ngno_, _پرتا, יערט_, 
   {{0xada623d7,0x7aee003d,0x442d23d8,0x7bdd23d9}},	//   рабл, _rabt, lze_, _apsu, 
   {{0x7aee1415,0xef86196d,0x06af0086,0x7d0d23da}},	//   _sabt, _клип, চ্চি, gjas, 
  
   {{0x69dc23db,0x2d9823dc,0x6d4423dd,0xafe623de}},	// [1800] _spre, spre_, rnia, _топл, 
   {{0x6aa700ef,0x2561003e,0x442d23df,0x69dc23e0}},	//   _cejf, fólk_, ize_, _ppre, 
   {{0x09e60445,0xfc3f04b3,0x7d0d00ef,0x888623e1}},	//   роен, _veía_, bjas, алеж, 
   {{0x442d06ff,0xdb04070b,0x290023e2,0x753b0053}},	//   kze_, trió, ñia_, jiuz, 
   {{0x7aee23e3,0x442d23e4,0x06af0086,0x7c2d0035}},	//   _tabt, jze_, চ্ছি, czar, 
   {{0x442d23e5,0x5804004e,0x6996004f,0xdb041771}},	//   dze_, _қозғ, _врах, rrió, 
   {{0xe1e723e6,0x69dc0228,0x6136015e,0x693c00ef}},	//   _بس_, _upre, ršlj, učes, 
   {{0x7c3b090b,0x628323e7,0xa96a05b4,0x752923e8}},	//   _žuri, _agno, _риба_, ghez, 
   {{0x39461056,0x4306004f,0x00000000,0x00000000}},	//   mnos_, аїна, --, --, 
   {{0xdb040183,0x394623e9,0xf3660477,0x00000000}},	//   oriñ, lnos_, јтин, --, 
   {{0x798023ea,0x442d052b,0x7c2d0ad8,0x80ab0033}},	//   _kimw, aze_, zzar, _কাব্, 
   {{0x752923eb,0x394623ec,0x63a223ed,0xdb040068}},	//   chez, nnos_, _twon, iriñ, 
   {{0x442d0da6,0x63a223ee,0x506723ef,0x394623f0}},	//   cze_, _uwon, ртна, inos_, 
   {{0xdced026e,0x6d4823f1,0x394600f8,0x63bd23f2}},	//   rmač, édan, hnos_, ásne, 
   {{0xfd880013,0xa69700a7,0xeca7081b,0x623303dc}},	//   иёти_, שכלה_, ијан, _мешу, 
   {{0x7c2d23f3,0xdb0403da,0x80c100a2,0x39460019}},	//   tzar, driñ, _वाटे, jnos_, 
   {{0x29e8002e,0x7bc423f4,0x67da01dd,0x957c0083}},	// [1810] _aşa_, guiu, nājā, _brąz, 
   {{0x7d0d23f5,0x394623f6,0xa91d00ca,0xf8ef034d}},	//   sjas, enos_, _miže, _घोड़ा_, 
   {{0x442d23f7,0x7c2d23f8,0x79800199,0xdb0423f9}},	//   zze_, szar, _bimw, griñ, 
   {{0x394623fa,0x442d23fb,0x645d00b0,0x798003c6}},	//   gnos_, yze_, üsik, _cimw, 
   {{0x6126008c,0xa91d00d0,0x6d5d0ae3,0x693c0082}},	//   _jóla, _niže, _iksa, tčer, 
   {{0x66e50ca9,0x394623fc,0x6d5d012b,0xdb040042}},	//   сока, anos_, _hksa, briñ, 
   {{0x7ae523fd,0x7afa003e,0xa3a91e7b,0x753b044d}},	//   meht, _ótta, गीन_, tiuz, 
   {{0x442d23fe,0x7ae51066,0x69c523ff,0x60cd016c}},	//   tze_, leht, muhe, _ncam, 
   {{0x8508032e,0x3d080081,0xc9520a33,0x442d2400}},	//   рдың_, हाते_, _זמן_, uze_, 
   {{0x442d0964,0x78a92401,0x27ed042a,0x798002b8}},	//   rze_, _heev, _isen_, _zimw, 
   {{0x442d2402,0x568c00c7,0x752902eb,0x78a900c2}},	//   sze_, _סטאַ, phez, _keev, 
   {{0x61262403,0x2d6802f2,0x7ae5024a,0x764e010c}},	//   _bóla, eßen_, heht, şiyê, 
   {{0x249f019c,0x78a92404,0x3f810027,0x69c52405}},	//   mbum_, _meev, _bihu_, huhe, 
   {{0x6d5d2406,0x6126158d,0x539a0056,0x249f2407}},	//   _aksa, _dóla, _עיצו, lbum_, 
   {{0xe16400d4,0xfbdf019c,0xada31c42,0x39460028}},	//   _وضعی, _apê_, засл, ynos_, 
   {{0x2ba9000f,0x4c862408,0x61362409,0x61fc059b}},	//   _चौहा, слав, kšli, ærle, 
   {{0x79800199,0x394602fe,0x3f89240a,0xf38800e7}},	// [1820] _rimw, vnos_, _guau_, _lợn_, 
   {{0x6ac600eb,0x6d5d240b,0xdb04240c,0xbc1900f0}},	//   إقام, _eksa, isiç, шісі_, 
   {{0x69c5078a,0x1efb00c7,0x27ed05d5,0x78a9240d}},	//   guhe, _עלטע, _asen_, _beev, 
   {{0x1d0a240e,0xdb04240f,0x984a0d3b,0x78a9023b}},	//   _семи_, rriñ, ляла_, _ceev, 
   {{0x39462123,0xaab80a24,0x7bc42410,0x2ca000c2}},	//   rnos_, _نگار_, quiu, mbid_, 
   {{0x39462411,0x96f80a10,0xe9aa009c,0x254c00bc}},	//   snos_, рект_, _مدرن_, děla_, 
   {{0x2d820053,0x78a92412,0x29e8020f,0xa91d0243}},	//   _kike_, _feev, _uşa_, _siže, 
   {{0x77860088,0xf8b000d4,0x2ca00326,0x2d82025b}},	//   _глаз, _آکا_, nbid_, _jike_, 
   {{0xc7a32413,0x4acf2414,0x2d8200d1,0xccf30486}},	//   _нитк, स्कव, _mike_, לכה_, 
   {{0x2d822415,0xaaa80598,0x78a902b0,0x60cd2416}},	//   _like_, गरिक, _zeev, _scam, 
   {{0xd5b902fb,0x712700eb,0x23a900a5,0xe7f008d2}},	//   _всі_, مرحل, चीबद, चिका_, 
   {{0x59c92417,0x81bc002a,0xa1592418,0x61262419}},	//   ांतर, dzēt, раму_, _póla, 
   {{0xa2d3241a,0xd8d70070,0xf09f00f6,0x00000000}},	//   _बॉक्, זוכט_, rbà_, --, 
   {{0x437400c5,0x6e94241b,0x4ac707d5,0x2d680380}},	//   _بهتر, зиру, _लाइव, ußen_, 
   {{0xd0470095,0x2d82241c,0xe18900e7,0x9cf502c8}},	//   _əməl, _bike_, _hẳn_, озві, 
   {{0xbcfb0574,0x2d821f57,0x6144022d,0x00000000}},	//   _ahér, _cike_, _неја, --, 
   {{0x2d821816,0x78a9241d,0xe50900a5,0x7ae5241e}},	// [1830] _dike_, _reev, वाति_, teht, 
   {{0x9a8705e0,0x69c5241f,0xbcfb2420,0x2d82019c}},	//   суал, tuhe, _chér, _eike_, 
   {{0x78a90201,0x2ba90262,0x81d60086,0x7ae52421}},	//   _peev, _चौरा, সিক_, reht, 
   {{0x69c52422,0x5c072423,0xf3880023,0x2d82016c}},	//   ruhe, _ляга, _rợn_, _gike_, 
   {{0xf7712424,0x212914e2,0x693c0304,0x78a92425}},	//   وات_, _mlah_, rčep, _veev, 
   {{0x69c500c8,0x2d820082,0x25a500f8,0x21292426}},	//   puhe, _zike_, _pwll_, _llah_, 
   {{0x78a92427,0xf5920d4b,0x69c50034,0x46150038}},	//   _teev, ولوج, quhe, توغر, 
   {{0x58d40648,0xe3b92428,0x254c00bc,0x27ed0026}},	//   _ност, аби_, těla_, _tsen_, 
   {{0x981700c5,0x395f0a9f,0x27ed04ff,0x00000000}},	//   _ابزا, _ikus_, _usen_, --, 
   {{0x21292429,0xdb160088,0x15ab00fd,0xaacc00bc}},	//   _alah_, styö, _бъди_, ालयक, 
   {{0x9f4901c4,0x81bc01dd,0x21290139,0x00000000}},	//   _spaß_, dzēs, _blah_, --, 
   {{0x6f050108,0x00000000,0x00000000,0x00000000}},	//   _anhc, --, --, --, 
   {{0x2d82242a,0x394d242b,0x28d1048e,0xd24e009c}},	//   _rike_, _mjes_, _हानि, فنی_, 
   {{0xe2991aaa,0x321e242c,0x2129242d,0x2d821ca0}},	//   _так_, byty_, _elah_, _sike_, 
   {{0x395f242e,0xad3a004f,0x2ca00354,0x8e831fde}},	//   _okus_, ачає_, tbid_, дгре, 
   {{0x4d660965,0x6da602f1,0xc5f200d1,0x644a0242}},	//   ікав, йиҳа, ודל_, šmiš, 
   {{0x6f17242f,0x25a00704,0x2ca0090c,0xcb050035}},	// [1840] _foxc, ćili_, rbid_, रांड_, 
   {{0x5ec10086,0x98a600ca,0x395f059e,0x00000000}},	//   শ্বে, rhoč_, _akus_, --, 
   {{0xa3a90bf5,0x80b100ab,0x2d822430,0x7f5c2431}},	//   गीत_, _अजमे, _tike_, morq, 
   {{0x6d410107,0x7f5c0036,0x69cb0c46,0xdd0f0241}},	//   élat, lorq, _हमरी, mışs, 
   {{0x394d00ef,0xbcfb0107,0x7d060028,0x321e0083}},	//   _djes_, _thér, _inks, zyty_, 
   {{0xd5ba2432,0x394d2433,0xab2a0886,0x27e9022c}},	//   аси_, _ejes_, _тога_, çana_, 
   {{0x386d2434,0xc8830218,0x76a900dd,0x7f5c0183}},	//   _ezer_, _paşê_, стів_, iorq, 
   {{0xb6030032,0x00000000,0x00000000,0x00000000}},	//   úšal, --, --, --, 
   {{0x25a90062,0x73fa0086,0x78a22435,0x7bd60102}},	//   ćala_, েন্ট_, mbov, ntyu, 
   {{0x2129105b,0x1fd00033,0x395f02d9,0xd3700195}},	//   _slah_, িবাস, _zkus_, عهد_, 
   {{0xaacf00e6,0x92582436,0x28d10586,0x612602be}},	//   स्टक, сант_, _हामि, _cólo, 
   {{0x69c30352,0x7bd607fc,0xd13b0176,0x321e138c}},	//   šneg, ktyu, рхо_, ryty_, 
   {{0xb97b0111,0x212900ef,0xf8b30486,0xb0340080}},	//   ינטי, _vlah_, ושר_, дняш, 
   {{0x7d06012d,0x321e0032,0x25450243,0x00000000}},	//   _anks, pyty_, vēli_, --, 
   {{0x212910b6,0xdef800e4,0x612611d1,0xdd941bb9}},	//   _tlah_, цыя_, _gólo, дасы, 
   {{0x212911e9,0x4add0299,0x254501dd,0x69c100fc}},	//   _ulah_, न्नव, tēli_, _ålei, 
   {{0x61260183,0xb7c50086,0xbcfb023e,0xa91d0121}},	// [1850] _móll, _এন্ট, _dhép, _niža, 
   {{0x395f23f2,0xdea1010e,0x99d70038,0x539b2437}},	//   _skus_, _سیری, قتصا, יימו, 
   {{0x386d0855,0x4c9500b3,0xdb0d0054,0x394d021e}},	//   _szer_, _нинс, ssaï, _pjes_, 
   {{0xdb0d0038,0x254c00d8,0x00000000,0x00000000}},	//   msaí, dělo_, --, --, 
   {{0x3d08000f,0x07a51d65,0x8cd8007e,0x395f00da}},	//   हारे_, чалн, मभरो, _vkus_, 
   {{0x3eba00e2,0x37070080,0x00000000,0x00000000}},	//   _xdpt_, ючев, --, --, 
   {{0x7af500b4,0x394d01d2,0xf6250eba,0x98a600de}},	//   _iazt, _tjes_, ядко, choď_, 
   {{0x395f003a,0x61260068,0x7af52438,0x67d50e65}},	//   _ukus_, _cóll, _hazt, _нобу, 
   {{0x7f5c0369,0x61262439,0x59c9009a,0x69d701d6}},	//   yorq, _sólo, ांवर, ltxe, 
   {{0xfbd2042c,0x27ff243a,0x6126243b,0x395d00d1}},	//   עתי_, _irun_, _pólo, lows_, 
   {{0x644d00e4,0x7af5243c,0x69d701ca,0xeccb0083}},	//   _žaid, _mazt, ntxe, िलाफ, 
   {{0x70c600a2,0x7af501cf,0x69d700b4,0x61fc017b}},	//   वलेल, _lazt, itxe, ærla, 
   {{0x7f5c0106,0xd12f243d,0x00000000,0x00000000}},	//   torq, امُ_, --, --, 
   {{0x2d96243e,0xe7e304bd,0x395d243f,0x78a2020b}},	//   зрас, _गहना_, hows_, zbov, 
   {{0x80ab100b,0x78bb0062,0x69d70201,0x78a20098}},	//   _কার্, _oduv, jtxe, ybov, 
   {{0x80da0086,0x7af500b4,0xc5f2027a,0x91ba00d1}},	//   _বোর্, _aazt, עדן_, _המקי, 
   {{0xc1db07d5,0x3b182440,0x7af50a9f,0xe8df00e7}},	// [1860] _बहुग, _porq_, _bazt, _ngựa_, 
   {{0x61360082,0x59d000c9,0xd9e00033,0xa91d0604}},	//   ršlu, _हमदर, ণিসম, _riža, 
   {{0x273000f7,0xe9da2441,0xed5a0afc,0xdb0d007a}},	//   _hàng_, ске_, _гон_, csaí, 
   {{0xd9100274,0xa91d2442,0xdb04007a,0x78a202d9}},	//   خیر_, _piža, nsiú, ubov, 
   {{0x78a22443,0x27ff01f5,0xdb04007a,0xa09b027a}},	//   rbov, _crun_, isiú, ציסט, 
   {{0x7af50414,0x273000e7,0x28d100a5,0x7bc4022c}},	//   _gazt, _màng_, _हाथि, mriu, 
   {{0x09e306ee,0x2730001b,0x98a62444,0xa5d70038}},	//   _порн, _làng_, _ниве, كبير_, 
   {{0x53982445,0x27ff02ae,0x00000000,0x00000000}},	//   овия_, _frun_, --, --, 
   {{0x27300029,0x83f802be,0x27ff2446,0x7af502a5}},	//   _nàng_, цепс_, _grun_, _yazt, 
   {{0x59d0006a,0xaacc2447,0x798e2448,0x96661913}},	//   _हमार, ालिक, _kubw, _екзе, 
   {{0xc4862449,0x2000244a,0x00000000,0x00000000}},	//   _елек, _arii_, --, --, 
   {{0xa91d00ca,0x27300023,0x798e244b,0xbb1b0151}},	//   _ližn, _bàng_, _mubw, _huît, 
   {{0xc05b244c,0xb4e8007e,0x27300029,0x61260098}},	//   сін_, मजी_, _càng_, _gólm, 
   {{0x2730001b,0x7bc40009,0xa91d244d,0x00000000}},	//   _dàng_, driu, _nižn, --, 
   {{0x7bc4007e,0x7af5008b,0x798e0199,0x00000000}},	//   eriu, _razt, _nubw, --, 
   {{0x7bc40036,0x8d741897,0x00000000,0x00000000}},	//   friu, فاقا, --, --, 
   {{0x6c54244e,0xc1580056,0x31ae0086,0x705500d4}},	// [1870] екту, _משהו_, _কমিশ, _زندا, 
   {{0x798e0539,0x60dd244f,0x00000000,0x00000000}},	//   _bubw, lfsm, --, --, 
   {{0x79a41730,0xa2cf1230,0x69c8017b,0x00000000}},	//   ерче, _दास्, _ådel, --, 
   {{0xba7411e3,0x6562016c,0x637403dd,0x7bc42450}},	//   رالت, _nkoh, lànd, briu, 
   {{0x7bc400d3,0x6d4d00b0,0x6cfa00d1,0x637400b9}},	//   criu, mnaa, _ופרס, càng, 
   {{0x6d5f0508,0x65622451,0x6d4d2452,0x0f1b009a}},	//   loqa, _akoh, lnaa, _नकोस_, 
   {{0x25a9090b,0x6d4d14b9,0xc5d501fc,0x798e02a5}},	//   ćalo_, onaa, філь, _gubw, 
   {{0x6d4d2453,0x27ff00ef,0x63bd014b,0x62982454}},	//   nnaa, _trun_, ásno, _afvo, 
   {{0x47d50084,0x68eb0df4,0x27ff2455,0x6ece00a2}},	//   _زيار, megd, _urun_, _तालु, 
   {{0x273000e7,0x68eb1aaf,0x798e016c,0x20fa0108}},	//   _ràng_, legd, _yubw, _ỏi_, 
   {{0x6d4d2456,0x69c50156,0x27300023,0x60dd2457}},	//   knaa, nrhe, _sàng_, ffsm, 
   {{0xd7d12458,0x254500e0,0xe7d1017d,0x68eb090e}},	//   _समाच, tēlu_, _समाप, negd, 
   {{0x6d4d2459,0x69c501c4,0x6b9d0026,0x644e010c}},	//   dnaa, hrhe, _ntsg, şbir, 
   {{0x6569245a,0x27300029,0x6d4d245b,0xef83012d}},	//   lleh, _vàng_, enaa, кляп, 
   {{0x8e55032e,0x4ac707d5,0xa91d0a1a,0xa3a91e7b}},	//   етті, _लाजव, _nižo, गीर_, 
   {{0x6d4d245c,0x273000e7,0x1d07245d,0x798e007c}},	//   gnaa, _tàng_, меси_, _rubw, 
   {{0x63ad010c,0x3b86245e,0x8c43245f,0x6b87012e}},	// [1880] _çand, длаг, вете, _bijg, 
   {{0x6d4d2460,0xdcfd00e0,0x65690149,0xfaa32461}},	//   anaa, _visā, hleh, вафо, 
   {{0x2eaa00a2,0xfe720038,0x68eb0082,0x200501dd}},	//   करीत, _جدة_, fegd, ālie_, 
   {{0xeb9f03a9,0x7bc40158,0x2d57003d,0x00000000}},	//   _brød_, priu, għed_, --, 
   {{0x69c50af8,0x9f4900f6,0x6d44095a,0x798e0027}},	//   arhe, _graó_, miia, _wubw, 
   {{0xa91d0352,0x6569084c,0x6aae0034,0x81e40033}},	//   _fižo, eleh, _uebf, নিত_, 
   {{0xdce4014b,0x80cf031e,0xa3b00154,0xb05b1096}},	//   hlič, _थाले, टीन_, ngär, 
   {{0x6ba5014e,0xdce4008b,0x6d4400ef,0x65692462}},	//   _åtgä, klič, niia, gleh, 
   {{0xf8632463,0x7c242464,0xd8d70137,0xa3a9009a}},	//   _авто, nyir, _קומט_, गील_, 
   {{0x6126010d,0xdce4014b,0x52140cf8,0x00000000}},	//   _fólk, dlič, едот, --, 
   {{0x65690626,0xa2cf0667,0x7c240199,0x6d44018e}},	//   bleh, _दार्, hyir, kiia, 
   {{0xf3880029,0x65620027,0x03a60398,0x60dd0502}},	//   _lợi_, _ukoh, _жидо, ufsm, 
   {{0xdce4026e,0x60dd008c,0x28d109e2,0x6374022c}},	//   glič, rfsm, _हासि, tànd, 
   {{0x442400ab,0x636f03a9,0x272b004f,0x68eb02b0}},	//   mym_, lønn, _lønn_, zegd, 
   {{0x1df811c5,0x44242465,0x6d4d2466,0x200d00d9}},	//   меры_, lym_, tnaa, ţei_, 
   {{0xdce422d4,0x6d4d11e9,0xa91d2467,0x65602468}},	//   blič, unaa, _rižo, nomh, 
   {{0x44242469,0x6d4d013c,0x4ea7246a,0x313402c0}},	// [1890] nym_, rnaa, _орна, _шеър, 
   {{0xdb1606df,0x65600038,0x6d4d12b6,0xb05b0219}},	//   nsyè, homh, snaa, sgäs, 
   {{0x442400de,0x6d4d123b,0x637400f6,0x636f0566}},	//   hym_, pnaa, càne, kønn, 
   {{0x636f00dd,0x7c240199,0x44240377,0x6b9d012b}},	//   jønn, byir, kym_, _ttsg, 
   {{0x68eb246b,0x6b8701c8,0x25ac00f3,0xa7fd039f}},	//   regd, _tijg, _awdl_, _gyűl, 
   {{0x442402bf,0x7d1d0019,0x00000000,0x00000000}},	//   dym_, _hoss, --, --, 
   {{0x65690364,0xf388001b,0x7d1d246c,0xacbb0212}},	//   tleh, _gợi_, _koss, _flût, 
   {{0x7d1d030f,0x00000000,0x00000000,0x00000000}},	//   _joss, --, --, --, 
   {{0x7d1d246d,0xa3c10b79,0x6569246e,0x13e600c8}},	//   _moss, ौंध_, rleh, емый_, 
   {{0x6569246f,0x69c1004f,0xdce42470,0x657b06e4}},	//   sleh, _åles, vlič, smuh, 
   {{0xcb12042c,0x216a2471,0x7bcd02aa,0x79891a77}},	//   אלי_, зини_, huau, _kiew, 
   {{0x7d1d0316,0xdce4008b,0x44241089,0xbcfb0175}},	//   _noss, tlič, bym_, _skén, 
   {{0xb427195e,0x442400ab,0xdce4034c,0x394f2472}},	//   _تعاو, cym_, ulič, ings_, 
   {{0x75290019,0x7989018c,0xdce41194,0x7bcd00c2}},	//   lkez, _liew, rlič, duau, 
   {{0xdd92024f,0x61462473,0xfce60073,0x6e9316a7}},	//   اور_, _пека, ново, الفا, 
   {{0x798900ab,0x7d1d2474,0xdce419e2,0x5ec10033}},	//   _niew, _coss, plič, শ্লে, 
   {{0x7d1d2475,0xf38800e7,0x7d1602c9,0x2bca09d9}},	// [18a0] _doss, _sợi_, rjys, ялап_, 
   {{0xbfa20218,0x272b017b,0x637400f6,0x6560018e}},	//   _şêwa, _sønn_, mànc, zomh, 
   {{0x7d1d2476,0x3cfb109f,0x3f920010,0x7c242477}},	//   _foss, _लोके_, _huyu_, syir, 
   {{0x69c30503,0x59d208d2,0xed5a2478,0x6126063d}},	//   ánea, दंबर, _хом_, _bóli, 
   {{0x6f1e2479,0xa7fd010e,0x7989247a,0x61260684}},	//   _kopc, _szűr, _diew, _cóli, 
   {{0xa847247b,0x57f302a6,0x44240098,0x254c02d9}},	//   علوم_, упшт, vym_, měli_, 
   {{0x4424006a,0x6126247c,0x3f92033e,0x6560247d}},	//   wym_, _eóli, _luyu_, tomh, 
   {{0x6126247e,0x4424247f,0x7d1d2480,0x7529010e}},	//   _fóli, tym_, _xoss, gkez, 
   {{0x39462481,0x849700eb,0x636f017b,0x3f92016c}},	//   mios_, رئيس_, rønn, _nuyu_, 
   {{0x656005ce,0x39460028,0xa91d02ee,0x2eaa00a2}},	//   somh, lios_, _nižj, करोत, 
   {{0x041e0086,0x6ed721f1,0x44242482,0xd94301d7}},	//   _বেশী_, _बाबु, sym_, _реӂи, 
   {{0x39462483,0x6374022c,0x2a6a2484,0x75292485}},	//   nios_, fànc, _mybb_, ckez, 
   {{0x7d1d2486,0x5f942487,0xb8032488,0x3cfb00c9}},	//   _ross, лият, लियम_, _लोगे_, 
   {{0x254c00bc,0x539b035c,0x6f1e2489,0x3cf9040b}},	//   děli_, _ציוו, _copc, _sasv_, 
   {{0x7d1d248a,0x3946012d,0xdd95021f,0x80a2248b}},	//   _poss, kios_, табы, _क्वे, 
   {{0x9d1814ec,0xe7f1009a,0xe8031f9a,0xa91d00de}},	//   ност_, _आईला_, लिमा_, _pižm, 
   {{0x3946248c,0xeb9302b4,0xdb0d02a0,0x70bf0790}},	// [18b0] dios_, اظر_, nsaç, ्लील, 
   {{0xdb0d248d,0x7989248e,0x7bcd0065,0xa91d0144}},	//   trañ, _siew, ruau, _vižm, 
   {{0xa2d809d3,0xa7fd0019,0x3946248f,0x75ca00ad}},	//   _मान्, _gyűj, fios_, _təzy, 
   {{0x39462490,0x6126003e,0x3f922491,0x260409d8}},	//   gios_, _póli, _yuyu_, विनी_, 
   {{0x79890056,0x2ca92492,0x7c672493,0x00000000}},	//   _view, mbad_, _ساحل, --, 
   {{0x2d8b0033,0x2ca90495,0x6d580218,0x36691b85}},	//   _hice_, lbad_, _êvar, мало_, 
   {{0x7529006b,0x369400f0,0xb98500f0,0xc6a42494}},	//   tkez, ушіс, _атақ, урчи, 
   {{0x39460e2e,0x2ca92495,0x00000000,0x00000000}},	//   cios_, nbad_, --, --, 
   {{0x80a208b4,0x75292496,0x2d932497,0x442b2498}},	//   _क्षे, rkez, _luxe_, ác_, 
   {{0x2d8b00f1,0x3eb30056,0x69ca02a0,0xdce5008a}},	//   _lice_, _next_, áfeg, _fuhħ, 
   {{0x68fb2499,0x6f1e249a,0xa0a61478,0x2d8b249b}},	//   _kaud, _ropc, канд, _oice_, 
   {{0x2eaa0c64,0x637403a1,0x3f9200e2,0x68fb1916}},	//   कर्त, tànc, _puyu_, _jaud, 
   {{0x2004249c,0x68fb249d,0x291f006d,0x2d930d7e}},	//   ími_, _maud, _moua_, _auxe_, 
   {{0x2d8b0094,0xf1d10161,0x80a21489,0x3946249e}},	//   _aice_, _көмө, _क्रे, zios_, 
   {{0x2d8b249f,0x63bb24a0,0x7ed624a1,0x00000000}},	//   _bice_, lsun, _یزدا, --, 
   {{0x291f002e,0x68fb24a2,0x39460496,0x57d106ea}},	//   _noua_, _naud, xios_, _समूह, 
   {{0x63bb24a3,0x39461fc3,0xac86011f,0x6f1e24a4}},	// [18c0] nsun, vios_, тгал, _topc, 
   {{0x6f1e027c,0x5fb700a7,0x81e40086,0x2d930183}},	//   _uopc, _שהיא_, নির_, _fuxe_, 
   {{0x39460634,0x68fb24a5,0x2ca924a6,0xfe751dbc}},	//   tios_, _baud, bbad_, _бүр_, 
   {{0x3eb824a7,0xc7c624a8,0x1e5700d1,0x621a0070}},	//   lart_, вски, _ישיר_, וועק, 
   {{0x394624a9,0x68fb24aa,0x291f0012,0x2d8024ab}},	//   rios_, _daud, _doua_, mmie_, 
   {{0x394600e4,0x63bb24ac,0xfaa324ad,0x2d8b00d9}},	//   sios_, dsun, _варо, _zice_, 
   {{0x39461a6e,0x68fb026a,0x7afc24ae,0x48fd02e6}},	//   pios_, _faud, _iart, _रोको_, 
   {{0x7afc24af,0x29dc128a,0x68fb24b0,0x3eb8004c}},	//   _hart, mía_, _gaud, hart_, 
   {{0x29dc248d,0x63bb24b1,0x3eb824b2,0x1c0515c8}},	//   lía_, gsun, kart_, रियल_, 
   {{0x68fb24b3,0x7afc0a9f,0x77630183,0xa6c707a4}},	//   _zaud, _jart, conx, _алфа_, 
   {{0x29dc128a,0x7c3a06d0,0x68fb00f4,0xdb040503}},	//   nía_, _ətra, _yaud, lsió, 
   {{0x7afc01ee,0x64a624b4,0x2d930068,0x68e200f8}},	//   _lart, _рада, _ruxe_, nfod, 
   {{0xdb04128a,0xb4ae11ff,0x29dc24b5,0x3eb8050f}},	//   nsió, करी_, hía_, fart_, 
   {{0x0ccb0e36,0x63a224b6,0x3eb824b7,0x2d8b031e}},	//   िल्म, _iton, gart_, _sice_, 
   {{0x29dc04b3,0x2ca901d2,0x39440054,0xdb040151}},	//   jía_, tbad_, _omms_, mpiè, 
   {{0x29dc1056,0xa3e600a2,0x7afc24b8,0x3eb3010c}},	//   día_, _पहा_, _aart, _wext_, 
   {{0x3eb324b9,0x3eb805ac,0x25a9003a,0x2ca924ba}},	// [18d0] _text_, bart_, ćali_, rbad_, 
   {{0x29dc128a,0x7afc24bb,0xe4e2141c,0x69de24bc}},	//   fía_, _cart, क्ति_, ftpe, 
   {{0x29dc0a5e,0x2d8b03ef,0x612624bd,0x68e200f8}},	//   gía_, _tice_, _vólv, ffod, 
   {{0x63a224be,0x7afc24bf,0x23c209ef,0xe85924c0}},	//   _oton, _eart, _शिंद, наеш_, 
   {{0xb8db0394,0x69dc24c1,0x63a224c2,0x68fb24c3}},	//   _आज_, _eqre, _nton, _vaud, 
   {{0x7afc24c4,0x29dc128a,0x2abc02d9,0x61ea039b}},	//   _gart, bía_, rábí_, _opfl, 
   {{0x29dc128a,0x63a224c5,0x3a84012d,0x74d70035}},	//   cía_, _aton, _вытв, _यादृ, 
   {{0x63bb24c6,0x7afc24c7,0x394401f2,0x7995018e}},	//   tsun, _zart, _gmms_, _iuzw, 
   {{0xa85524c8,0x0ed307d5,0x25be01c4,0x63bb24c9}},	//   _скач, _तांड, _evtl_, usun, 
   {{0x63bb24ca,0x386d24cb,0x98ad0082,0x316905d5}},	//   rsun, _iyer_, _mleč_, _akaz_, 
   {{0x63bb24cc,0x3eb824cd,0x63a224ce,0xe8df00e7}},	//   ssun, vart_, _eton, _ngừa_, 
   {{0x7fd624cf,0x8fa60dea,0x349524d0,0x672100ca}},	//   лігі, ламе, _садр, _holj, 
   {{0xa2e51088,0x672124d1,0xb14324d2,0x63740054}},	//   _болд, _kolj, снял, sàna, 
   {{0x386d198f,0xdbd10380,0x6126010e,0x08760070}},	//   _myer_, _süße, _rólu, טערט_, 
   {{0xa2d81b38,0x29dc24d3,0xe4f924d4,0xf38800e7}},	//   _मात्, xía_, ्यपि_, _vợt_, 
   {{0x7afc24d5,0x29dc128a,0x5c160088,0xfc3f0327}},	//   _sart, vía_, льзу, _reír_, 
   {{0x3eb80151,0x386d24d6,0x2d8024d7,0xed570e65}},	// [18e0] part_, _nyer_, rmie_, уот_, 
   {{0x7afc00e5,0x29dc0503,0x2d800032,0x0eaa012d}},	//   _qart, tía_, smie_, _якой_, 
   {{0x7afc09d5,0x386d24d8,0x9d4624d9,0xbf9b0165}},	//   _vart, _ayer_, _бенд, nvên, 
   {{0x29dc128e,0x7afc24da,0x61fc0422,0x386d01e8}},	//   ría_, _wart, ærli, _byer_, 
   {{0x7afc24db,0x684624dc,0x6d460824,0x29dc1056}},	//   _tart, ында, _imka, sía_, 
   {{0xa2d824dd,0xdb04127e,0x29dc24de,0xbcfb24df}},	//   _माध्, rsió, pía_, _akéh, 
   {{0xf41f0df8,0x672100d0,0xe9a3012d,0x63a224e0}},	//   ään_, _dolj, _гасп, _ston, 
   {{0xb4ae0f01,0x60c4047a,0x80d600a2,0x186a24e1}},	//   करे_, _ndim, _भाषे, _заби_, 
   {{0x6721235e,0x14d5058c,0xb7f100b0,0xb6a600a3}},	//   _folj, _धारण, _आईएम_, _бизл, 
   {{0xa3b504d7,0x60c424e2,0x23650e67,0x70bf059e}},	//   _जबर_, _adim, golj_, ्ल्ल, 
   {{0xe693057f,0x415524e3,0x6d46008a,0x611524e4}},	//   _المد, ивос, _omka, адну, 
   {{0x672102fe,0x6ed70f8c,0x6b8e24e5,0x63a20539}},	//   _zolj, _बाहु, _libg, _tton, 
   {{0x63a224e6,0x60c424e7,0x5ede0033,0xc05824e8}},	//   _uton, _ddim, য়নে, гір_, 
   {{0xdef824e9,0x88bd00ab,0x6d46044d,0x2fc00352}},	//   лыс_, _kośc, _amka, _dvig_, 
   {{0x2bc71451,0xd2b724ea,0x2fc0042a,0xa3b002e6}},	//   _लिहा, _גלות_, _evig_, टीर_, 
   {{0x798200ab,0x31690144,0x7995016c,0x00000000}},	//   jmow, _ukaz_, _ruzw, --, 
   {{0x7522050a,0xdb040068,0xdd9300f0,0x8aa724eb}},	// [18f0] _mooz, esiñ, рағы, гред, 
   {{0xf09f022c,0x9b440038,0x20090212,0x386d040b}},	//   lcà_, منقو, _irai_, _ryer_, 
   {{0xeb9f0c85,0xdb580088,0x386d00e2,0x6b8e0090}},	//   _grøn_, уют_, _syer_, _dibg, 
   {{0x2009236e,0xb4ae01a4,0x9a8403dd,0x752224ec}},	//   _krai_, करो_, суул, _nooz, 
   {{0xdcef0083,0x00000000,0x00000000,0x00000000}},	//   _chcą, --, --, --, 
   {{0x8cad00bc,0x386d02d7,0x637d011c,0x00000000}},	//   जरको, _vyer_, mèng, --, 
   {{0x236502ee,0x7bcd003e,0x61ed0ab4,0xe73600fd}},	//   volj_, lrau, _ćalo, рещ_, 
   {{0x2009012d,0xf8b900c2,0xa52524ed,0x00000000}},	//   _orai_, _उजिय, рмид, --, 
   {{0x36d524ee,0xa3b024ef,0xe3b624f0,0x7bcd24f1}},	//   _возр, टील_, абы_, nrau, 
   {{0x27ed24f2,0x7bcd24f3,0x00000000,0x00000000}},	//   _ipen_, irau, --, --, 
   {{0x88bd00ab,0x7bcd24f4,0xb59500d3,0x72790283}},	//   _gośc, hrau, _тиеш, ъсис_, 
   {{0x291d16aa,0x7bcd24f5,0x00860b46,0x200924f6}},	//   njwa_, krau, илно, _brai_, 
   {{0x656b0026,0x2739023e,0x23650ab4,0x68e9009c}},	//   _ikgh, _cèng_, polj_, _mbed, 
   {{0x82a5030f,0x7bcd24f7,0x200924f8,0x56b500c7}},	//   _такж, drau, _drai_, יפֿן_, 
   {{0xdefa146e,0x63a924f9,0xa0a624fa,0x99d70086}},	//   ның_, lpen, _кайд, সবুক, 
   {{0xf38800f7,0x27ed24fb,0x63a924fc,0x200900b4}},	//   _hợp_, _open_, open, _frai_, 
   {{0x63a924fd,0x7bcd24fe,0xfc0300d3,0x4d63004f}},	// [1900] npen, grau, опто, ікув, 
   {{0x68e924ff,0x09e607a4,0x63a91fa9,0xb4ab003e}},	//   _abed, иозн, ipen, íþjó, 
   {{0xa2d807d5,0xe9da2500,0xfce62501,0x27ed01d2}},	//   _मास्, тке_, _коно, _apen_, 
   {{0x7bcd2502,0xa3e60a09,0x57a600d3,0x88e600c8}},	//   brau, _पहल_, ашка, ржде, 
   {{0x798200ab,0x76002503,0x63a901c8,0x6d562504}},	//   rmow, kázá, jpen, mnya, 
   {{0x6d56016a,0x88bd0083,0x68e91240,0x637403dd}},	//   lnya, _pośc, _ebed, vàno, 
   {{0xd5b70335,0x6d562505,0x291d0226,0x63a92506}},	//   асы_, onya, bjwa_, epen, 
   {{0x6d562507,0xa91d2508,0x25a1020b,0x00000000}},	//   nnya, _bižu, íhla_, --, 
   {{0x63a92509,0x07a31cc1,0xc7a30ec6,0x27e9250a}},	//   gpen, _матн, _митк, çant_, 
   {{0x2739011c,0x7522052b,0x00000000,0x00000000}},	//   _rèng_, _wooz, --, --, 
   {{0x6d56250b,0x752200ef,0xfa97008d,0x7bcd01dd}},	//   knya, _tooz, ידיש_, zrau, 
   {{0x948600d3,0x9d210033,0x2bc7250c,0x70220033}},	//   _кылд, _নগ্ন_, _लिला, _পেইজ_, 
   {{0xc05b032e,0xe53b0056,0xb4c4072e,0x637d00f6}},	//   тін_, _בתאר, ौली_, fènd, 
   {{0x2009026d,0x6d56250d,0x637d01e5,0xf09f00f6}},	//   _vrai_, enya, gènd, scà_, 
   {{0x937b008d,0x00000000,0x00000000,0x00000000}},	//   _שטות, --, --, --, 
   {{0x7bcd250e,0x20090029,0xc0cb250f,0x6d562510}},	//   trau, _trai_, _руке_, gnya, 
   {{0xe4f92511,0x2d9c039f,0x00000000,0x00000000}},	// [1910] ्यति_, _éven_, --, --, 
   {{0x6d560364,0xfaa72512,0x7bcd2513,0xdced00ca}},	//   anya, ршан, rrau, mlač, 
   {{0x81e40086,0x63a90a9f,0xceb2035c,0x0b882128}},	//   নিক_, zpen, _מיי_, рсти_, 
   {{0x27390107,0x637d2514,0x63a92515,0x7bcd2516}},	//   _mène_, mène, ypen, prau, 
   {{0x98e40038,0xb6a52517,0x6d4d2518,0x9ac7010e}},	//   تكنو, билл, miaa, _نگاہ_, 
   {{0x7c2d011c,0x9b450290,0x6aa90241,0xb7672519}},	//   myar, _طنزو, _şeff, штей, 
   {{0x80c200cc,0x7c2d251a,0x291d0415,0x760000d8}},	//   ষ্ট্, lyar, pjwa_, vázá, 
   {{0x58d4251b,0x68e90267,0x63a9251c,0x1e5800d1}},	//   _мост, _ubed, tpen, ישור_, 
   {{0x7c2d099d,0xe2991472,0x63a9251d,0xb7f104cc}},	//   nyar, лап_, upen, _आईटम_, 
   {{0xf5e700dd,0x63a9251e,0x56940258,0xdced251f}},	//   _відм, rpen, _дафт, dlač, 
   {{0xa2d81f30,0x7c2d2520,0x412a00b9,0x22492521}},	//   _मार्, hyar, гоно_, упни_, 
   {{0x04950038,0x645e0035,0x61e100b9,0x00000000}},	//   _الإح, _śpie, rtll, --, 
   {{0xdced035f,0x7c2d02b8,0x65690054,0x753b018e}},	//   jmađ, jyar, moeh, mhuz, 
   {{0x442d2522,0x3ea302f1,0xdced00ad,0x65692523}},	//   mye_, зирг, tmağ, loeh, 
   {{0x442d2524,0x6d5602cd,0x637d2525,0x6da60200}},	//   lye_, tnya, rènd, сиба, 
   {{0x6d4d2526,0xe0da0886,0xdced2527,0x6da62528}},	//   giaa, _сви_, rmağ, _қима, 
   {{0x442d2529,0x7c2d006b,0xec7a252a,0x443f252b}},	// [1920] nye_, gyar, упа_, nzu_, 
   {{0x8a3a0088,0x442d252c,0x2ca002a4,0x443f01cf}},	//   ляет_, iye_, scid_, izu_, 
   {{0xb4f9119b,0xd91000c5,0xdce400d0,0x442d024a}},	//   ्याय_, ویس_, jlić, hye_, 
   {{0x7c2d23ea,0x6d4d0b32,0x442d252d,0xf969017b}},	//   byar, ciaa, kye_, арій_, 
   {{0xa2d8252e,0x291203c0,0x442d0ac9,0x2bba0038}},	//   _माल्, ıya_, jye_, _حاجة_, 
   {{0x442d252f,0x7d042530,0x443f2531,0x290007bb}},	//   dye_, ldis, dzu_, žia_, 
   {{0xe7f40e36,0x442d052b,0x7bd62532,0xdce4015e}},	//   _इनका_, eye_, luyu, glić, 
   {{0x7d042533,0x442d0cd7,0xdce40097,0x6abe0082}},	//   ndis, fye_, koič, lapf, 
   {{0x442d2534,0x7d042535,0x78a2014b,0xf3662536}},	//   gye_, idis, mcov, йтон, 
   {{0xdced0112,0x7d040088,0x78a2014b,0xd6d200b8}},	//   vlač, hdis, lcov, _رقص_, 
   {{0x442d2537,0x6569011c,0x31b2009e,0x00000000}},	//   aye_, boeh, dûzî_, --, 
   {{0x78a20076,0x442d2538,0xd25705c6,0x753b0010}},	//   ncov, bye_, сць_, chuz, 
   {{0x7d042539,0x5067253a,0x443f00ab,0xd9c500bd}},	//   ddis, стна, czu_, _लट्ट, 
   {{0x6d5a253b,0x7bd6253c,0xa85700d1,0x623400b3}},	//   étan, duyu, מיכה_, _мелу, 
   {{0xdced034c,0x6d4d253d,0x8d770629,0x2d9a0474}},	//   slač, tiaa, مارا, _cupe_, 
   {{0xdced02ee,0x7d04253e,0x78a2253f,0xbd6b0080}},	//   plač, gdis, jcov, урге_, 
   {{0xac182540,0x6d4d2541,0x7bd62542,0x78a20377}},	// [1930] боту_, riaa, guyu, dcov, 
   {{0x7c2d2543,0x6d4d2544,0xfb840235,0x64402545}},	//   ryar, siaa, пыхн, izmi, 
   {{0x7c2d2546,0x637d00d3,0x7d042547,0x442d0300}},	//   syar, lènc, bdis, zye_, 
   {{0x273000f7,0x26de1056,0x7bd6002c,0xcebc0095}},	//   _hành_, _acto_, buyu, _şəxs_, 
   {{0x26de0226,0x81e40086,0x637d022c,0xb90100c9}},	//   _bcto_, নিট_, nènc, _दा_, 
   {{0xe73617d2,0x442d2548,0x443f0460,0xdce4044e}},	//   жеш_, vye_, vzu_, tlić, 
   {{0xf77000c5,0x78a22549,0x442d254a,0xca24254b}},	//   راه_, bcov, wye_, _ефти, 
   {{0x442d0cd7,0x443f0a9f,0x273000e7,0xdce4254c}},	//   tye_, tzu_, _lành_, rlić, 
   {{0x442d254d,0xdce40b91,0x753b039f,0x00000000}},	//   uye_, slić, rhuz, --, 
   {{0xa1c50593,0x443f254e,0x442d254f,0x637d00d3}},	//   обод, rzu_, rye_, dènc, 
   {{0x442d2550,0x2d570529,0xe7842551,0x5f1d048e}},	//   sye_, għek_, _хуто, मान्_, 
   {{0x3eba2552,0x442d06df,0x208a2553,0x6abe2554}},	//   _sept_, pye_, ийни_, zapf, 
   {{0x41c5034d,0x637d03a1,0xe8df0023,0x7d042555}},	//   _विकस, gènc, _ngửa_, vdis, 
   {{0xee3a07f9,0x6d5d2556,0x78bb2557,0x3f8100a1}},	//   анг_, _ajsa, _leuv, _chhu_, 
   {{0x27300029,0x78bb026a,0x6da30e65,0x272b0453}},	//   _dành_, _oeuv, диса, _høns_, 
   {{0x78bb2558,0x0d991c0f,0x2fcd02ee,0x7d042559}},	//   _neuv, стры_, šega_, udis, 
   {{0x637d00d3,0x78a2014b,0xac071cfc,0x6abe1ce7}},	// [1940] cènc, vcov, онта_, tapf, 
   {{0x7bd6255a,0x91ed1f02,0x2d9a255b,0x63a4007a}},	//   ruyu, _जहाज_, _tupe_, _éine, 
   {{0x6abe02b8,0x3e830212,0x09e30080,0x78bb0151}},	//   rapf, rété_, дохн, _beuv, 
   {{0x7d0409c7,0x1d0a255c,0x69c3255d,0x7cda03a1}},	//   qdis, _теми_, ânea, _өмүр_, 
   {{0x78a214e7,0x26c8004e,0x7af7255e,0x386000ad}},	//   rcov, йған_, bext, çir_, 
   {{0x78a2255f,0x00000000,0x00000000,0x00000000}},	//   scov, --, --, --, 
   {{0xa3dc09ef,0x3f4d00ef,0x78a223f2,0xae0d109f}},	//   तून_, džul_, pcov, हियन_, 
   {{0x6374022c,0x03c60205,0x7bc40009,0x64400502}},	//   màni, осом, osiu, tzmi, 
   {{0x7bc42560,0x741400eb,0x64400112,0x539700e4}},	//   nsiu, سودا, uzmi, овыя_, 
   {{0x29042561,0x799c024d,0x637d03a1,0x27e62562}},	//   _hama_, _kurw, vènc, mton_, 
   {{0x29041bb2,0x6abc01f2,0x2ef80326,0x27300023}},	//   _kama_, _merf, derf_, _rành_, 
   {{0x09cf00cc,0x29062563,0x637d00d3,0x273000e7}},	//   _রহমা, ndoa_, tènc, _sành_, 
   {{0x29042564,0x64400065,0x6abc02e5,0x7413007a}},	//   _mama_, qzmi, _oerf, _يوما, 
   {{0x290411f7,0x637d0161,0x6abc2565,0x26dc0528}},	//   _lama_, rènc, _nerf, ngvo_, 
   {{0xdcbb2566,0x637d00d3,0xce940141,0x6e942567}},	//   ища_, sènc, даръ, диру, 
   {{0x5c992568,0xa3ae2569,0x27e6256a,0x6e280219}},	//   ская_, _ओझा_, kton_, ädba, 
   {{0x6abc256b,0xdfdb0141,0x27e6024a,0x7bc4137f}},	// [1950] _berf, _тъй_, jton_, gsiu, 
   {{0x6abc256c,0x60dd256d,0x6e2a0034,0x27e600ca}},	//   _cerf, lgsm, ëmbë, dton_, 
   {{0x6abc1b37,0x78bb026d,0x637403a1,0x7bc400b0}},	//   _derf, _peuv, gàni, asiu, 
   {{0x7af7256e,0x2904256f,0x69d704fe,0x27e62570}},	//   sext, _cama_, ruxe, fton_, 
   {{0x01e000cc,0x2d892571,0x6abc2572,0x78bb0151}},	//   ববিদ, mmae_, _ferf, _veuv, 
   {{0x69d70042,0xb6a52573,0x27390118,0xdb04019c}},	//   puxe, чикл, _bèna_, rpiã, 
   {{0x27e60df8,0x672803ef,0x6b9d2237,0x6374022c}},	//   aton_, _dodj, _husg, càni, 
   {{0xe3b92574,0x29042575,0x2ee11e9f,0x6b9d2576}},	//   бби_, _gama_, _lchf_, _kusg, 
   {{0x27ff0366,0x1c0e017d,0x395f0175,0xc6e7128b}},	//   _usun_, सियल_, _ijus_, _міжп, 
   {{0x29042577,0x466b117c,0x6b9d0ada,0x69c52578}},	//   _zama_, _крем_, _musg, oshe, 
   {{0x69c52579,0xe8030aac,0x2904257a,0x6b95009e}},	//   nshe, लिका_, _yama_, _mizg, 
   {{0x69c5257b,0x6723257c,0x21290126,0x2ef8000b}},	//   ishe, ljnj, _coah_, werf_, 
   {{0x88bd00ab,0x2ee10226,0x200f257d,0x24640034}},	//   _rośl, _bchf_, _ágil_, rëmë_, 
   {{0x69c7027c,0x395f014e,0x2d9c010e,0x69c5257e}},	//   _ovje, _ljus_, _évek_, kshe, 
   {{0x6b9d02ec,0x69c5257f,0x6b402580,0x88bd0083}},	//   _ausg, jshe, _högg, _pośl, 
   {{0x69c51b77,0x6abc0218,0x2bc70d7c,0x6b9501dd}},	//   dshe, _serf, _लिखा, _aizg, 
   {{0x29042581,0x2ef82582,0x27e61f14,0x6b9500a3}},	// [1960] _rama_, perf_, xton_, _bizg, 
   {{0x799c2583,0x7bc42584,0x637403a1,0x69c50034}},	//   _purw, rsiu, tàni, fshe, 
   {{0x6abc2585,0x7bc42586,0x4ae202f8,0x672814f0}},	//   _verf, ssiu, _पाठव, _rodj, 
   {{0x69c70e67,0x0edc031e,0x27e62587,0x6374022c}},	//   _dvje, _बाँड, tton_, ràni, 
   {{0x67282588,0x290402f5,0x29062589,0x6abc1b79}},	//   _podj, _vama_, rdoa_, _terf, 
   {{0x395f05d5,0x7d06258a,0x2904258b,0x28d8258c}},	//   _ejus_, _haks, _wama_, _डाकि, 
   {{0x2904258d,0x7d06258e,0x27e6258f,0x672821d9}},	//   _tama_, _kaks, ston_, _vodj, 
   {{0x7d062590,0x27e62591,0xda5b0486,0x34941b2c}},	//   _jaks, pton_, _הכלל, майр, 
   {{0x69c72592,0x0edc00e6,0x00000000,0x00000000}},	//   _zvje, _बांड, --, --, 
   {{0x883b00a7,0x637d06df,0x63ab0175,0x394d2593}},	//   _התמו, tèna, _dtgn, _zmes_, 
   {{0x7643006a,0x26cc02bf,0xa3b009ec,0x325300d9}},	//   czny, _iddo_, टीज_, евэр, 
   {{0xf487017a,0x867b0070,0x27390118,0x60dd0243}},	//   _کامی, _פראו, _jènn_, ugsm, 
   {{0xfc3f033c,0x60dd2594,0xcfa70080,0x637d011c}},	//   _afín_, rgsm, яшни, sèna, 
   {{0x3da72595,0x7d0607fc,0x69c52596,0x6b9d01be}},	//   зраб, _aaks, yshe, _rusg, 
   {{0x6b952597,0x9e14004f,0x21290096,0x2bda0299}},	//   _rizg, ндрі, _toah_, यूसा, 
   {{0x6b9502f1,0x6b9d1b03,0x69c50b41,0x00000000}},	//   _sizg, _pusg, vshe, --, 
   {{0x69c702b1,0x60cd0f73,0x2d8904c6,0x7d062598}},	// [1970] _svje, _idam, rmae_, _daks, 
   {{0x69c50194,0x394d007b,0x23d415ba,0x69c3019c}},	//   tshe, _smes_, _दिनद, âneo, 
   {{0x6aa52599,0xa3dc02e6,0xf9f9091d,0x394d02be}},	//   rchf, तूत_, تفاع_, _pmes_, 
   {{0x69c5259a,0xac19259b,0xe9d00625,0x26cc259c}},	//   rshe, _дому_, اغل_, _addo_, 
   {{0x394d0352,0x69c5259d,0xfc6400fd,0x69da00fc}},	//   _vmes_, sshe, _зърн, _åten, 
   {{0xe29a00e7,0x69c5259e,0xa2d800bc,0x69c70144}},	//   _ngư_, pshe, _माग्, _tvje, 
   {{0x69c702b1,0xba7700d6,0x60cd00cf,0x945d0035}},	//   _uvje, _راست, _odam, kańc, 
   {{0x60cd259f,0xbe3c00d1,0x26cc02a5,0x76430035}},	//   _ndam, מעות, _eddo_, rzny, 
   {{0xb4ad119f,0x387f25a0,0x67d425a1,0x395d006d}},	//   _कभी_, _uzur_, _поту, mnws_, 
   {{0x60cd25a2,0x644d012d,0xd75b0109,0x81c900c8}},	//   _adam, _žais, _اجرا_, огов_, 
   {{0x7764022c,0x61e8012b,0x6ed7055d,0x00000000}},	//   éixe, gtdl, _बाजु, --, 
   {{0x33d50259,0x00000000,0x00000000,0x00000000}},	//   _жікт, --, --, --, 
   {{0x7d060bc3,0xa2e51088,0x6b40014e,0x60cd25a3}},	//   _raks, _жолд, _höge, _ddam, 
   {{0x6d4f25a4,0x4f9500b3,0x60cd12ed,0x00000000}},	//   _amca, ерсу, _edam, --, 
   {{0x7d0625a5,0x2d9e026d,0x4df500dd,0x2d9616b0}},	//   _paks, ête_, нятт, драс, 
   {{0x395d006d,0x6b4025a6,0xd2dd0249,0x00000000}},	//   jnws_, _möge, _माँझ, --, 
   {{0x9b060a43,0x7d0600fc,0xed5725a7,0x5ed30086}},	// [1980] мзад, _vaks, фот_, দ্ধে, 
   {{0x5fd300a5,0x9f480080,0x4c830165,0x27390118}},	//   _तितल, öhän_, тлув, _sènn_, 
   {{0x7d0625a8,0x0d8600b9,0x6374022c,0x48e625a9}},	//   _taks, _олон, mànt, доев, 
   {{0x395d006d,0x637425aa,0xa3ae00c9,0x00000000}},	//   gnws_, lànt, _ओझल_, --, 
   {{0xf74625ab,0xc7a319e4,0x07fa16a7,0x07a325ac}},	//   медо, вичк, تراع_, вачн, 
   {{0xeb9f155b,0xb86525ad,0xf1c00032,0x6b4002eb}},	//   _prøv_, رانو, úšky_, _böge, 
   {{0x8a030fa7,0x395d0201,0xdbe60216,0x752b107c}},	//   _изре, bnws_, _bêça, _bogz, 
   {{0x490600a5,0x3ce000bd,0x00000000,0x00000000}},	//   _सोचो_, ngiv_, --, --, 
   {{0x671e0f01,0x1418007a,0x00000000,0x00000000}},	//   पादक_, سيدة_, --, --, 
   {{0xf7721930,0x778300b3,0x6b4002ae,0x00000000}},	//   _شاء_, _алуз, _högb, --, 
   {{0x2fc925ae,0x945d0083,0x00000000,0x00000000}},	//   _svag_, tańc, --, --, 
   {{0x92be00cc,0x914b0c8b,0xae0d00b0,0xd2570810}},	//   ইলে_, ічна_, हिसन_, ьцы_, 
   {{0x4420055a,0xb4da00a5,0xf41f0080,0x6b400380}},	//   _çi_, ़ली_, äät_, _zöge, 
   {{0x5f9425af,0x6b4001d5,0x09e50033,0x00000000}},	//   кият, _lögb, নবতা, --, 
   {{0xf2060141,0x752b045a,0x7f9425b0,0x7bd6023e}},	//   _цяло, _yogz, тарх, eryu, 
   {{0x9d181a52,0x60cd0532,0x2c0b009a,0xe0df00b9}},	//   мост_, _udam, हटलं_, riòs_, 
   {{0x63ad25b1,0x2139016a,0x395d006d,0x7b151a57}},	// [1990] _çant, mksh_, vnws_, ндах, 
   {{0xdb0d003e,0x637400b9,0x00000000,0x00000000}},	//   gsað, cànt, --, --, 
   {{0x69c80566,0x00000000,0x00000000,0x00000000}},	//   _ædel, --, --, --, 
   {{0xa2d8047b,0x656201ee,0x6d4f00ef,0xbb24078a}},	//   _माझ्, _njoh, _umca, vnîş, 
   {{0x7ac71853,0xdce401f0,0x2ca900ca,0xdbe6009e}},	//   _осве, lliğ, mcad_, _rêça, 
   {{0x6d910187,0x395d006d,0xd70625b2,0x254c00d8}},	//   _sťah, snws_, енше_, měly_, 
   {{0x58d525b3,0xdce401f0,0x2d9925b4,0xd5b10038}},	//   _повт, nliğ, _kise_, دفع_, 
   {{0x6b400380,0xd6181036,0x00000000,0x00000000}},	//   _vöge, بتها_, --, --, 
   {{0x2d9925b5,0x47d50084,0x6d5a026d,0x6562016a}},	//   _mise_, _سيار, étai, _djoh, 
   {{0x422525b6,0x2d9925b7,0xdce4027e,0xc48200d3}},	//   едов, _lise_, kliğ, ылык, 
   {{0x78a425b8,0x4ae21080,0x443900e0,0x2d990107}},	//   žive, _पासव, šs_, _oise_, 
   {{0x2d9925b9,0xa06a0267,0x00000000,0x00000000}},	//   _nise_, зама_, --, --, 
   {{0xff5f010c,0x4fa30cdf,0x98a401dd,0xa2d702e6}},	//   rsîn_, лияв, _jomā_, _मयप्, 
   {{0xa35700c5,0x2d9925ba,0xd37b00b3,0xcad50033}},	//   _تخصص, _aise_, _ьче_, স্তফ, 
   {{0x2d9925bb,0x3e870d2f,0x637400b9,0x637d011c}},	//   _bise_, ейро_, rànt, nènm, 
   {{0x628302f5,0x7159004e,0x2d9901be,0xa1c200fd}},	//   _izno, _орыс_, _cise_, _сбъд, 
   {{0x2d9925bc,0xe7da00cc,0x4f961c52,0xbea60846}},	// [19a0] _dise_, _ধন্য, _проу, _папк, 
   {{0xfaa325bd,0x2d990326,0x2d9e0165,0xdce40e03}},	//   гафо, _eise_, ítes_, bliğ, 
   {{0xdebb00fe,0x53360137,0x2d9925be,0x5ebb00d1}},	//   _ממיל, ענען_, _fise_, _מזיק, 
   {{0xe1ff00ab,0xeb9a25bf,0x597600d4,0x97c625c0}},	//   łów_, _ним_, رداز, ейде, 
   {{0x6d5625c1,0x4e96009c,0x6d4425c2,0x3f9a25c3}},	//   miya, _تشکر, mhia, _kipu_, 
   {{0x6d5625c4,0xa5a40035,0x56780235,0x6d44012b}},	//   liya, _चंदौ, мбля_, lhia, 
   {{0xceb30056,0x6b6325c5,0x7c24040c,0x2d990610}},	//   ניה_, _скра, lxir, _yise_, 
   {{0x6d5625c6,0x60c625c7,0x69de0204,0x6d4425c8}},	//   niya, jakm, mupe, nhia, 
   {{0xe3af040f,0x60c60870,0x69de25c9,0x12e601fc}},	//   یری_, dakm, lupe, нінг, 
   {{0xfd1f0029,0x3f9a25ca,0x68e225cb,0x637d023e}},	//   _nhìn_, _nipu_, lgod, lènj, 
   {{0x6d440da2,0xb5f2004e,0x00c900d3,0xf41f00c2}},	//   khia, _сүйі, үлүк_, äär_, 
   {{0x68e225cc,0x88bd00ab,0xdced00d2,0x84660093}},	//   ngod, _dośw, mlać, _пъле, 
   {{0x6d5625cd,0x54330133,0x69de25ce,0xb4bc031e}},	//   diya, _مرور, hupe, अरी_, 
   {{0x69de25cf,0xae0d0081,0x2d9925d0,0x15f42002}},	//   kupe, हिलन_, _sise_, _आहार_, 
   {{0x2d9904d1,0x63a225d1,0x6d5625d2,0xf8d000a2}},	//   _pise_, _huon, fiya, हणाय, 
   {{0x63a225d3,0x6d5625d4,0x6d4410df,0xdce401f0}},	//   _kuon, giya, ghia, rliğ, 
   {{0x2ca90534,0x63a200c8,0x68e225d5,0x65601197}},	// [19b0] rcad_, _juon, dgod, inmh, 
   {{0x63a21642,0x5f9502a6,0x69de045a,0x6d44023a}},	//   _muon, _шипт, fupe, ahia, 
   {{0x63a225d6,0x6d5625d7,0xda6700eb,0xaa671753}},	//   _luon, biya, رائي, хтак, 
   {{0x6d4425d8,0x637d0cd7,0xacbb026a,0x6d5625d9}},	//   chia, vènm, _coût, ciya, 
   {{0x7c8425da,0x63a225db,0x66e525dc,0x7d0d003e}},	//   _буре, _nuon, вола, mdas, 
   {{0x7d0d25dd,0x68e20183,0xf72b012d,0x61f81a77}},	//   ldas, agod, яцей_, _opvl, 
   {{0xae1405fd,0x7bdf0327,0xc179012d,0x77640068}},	//   डियन_, luqu, ntės_, éixa, 
   {{0x63a225de,0x7d0d25df,0xacbb026a,0xc1790009}},	//   _buon, ndas, _goût, itės_, 
   {{0x6b400219,0x63a200e7,0xa3dc02e6,0x78a400ca}},	//   _höga, _cuon, तूल_, živc, 
   {{0x6d5625e0,0x63a225e1,0x88bd0035,0x7d0d00c8}},	//   ziya, _duon, _pośw, hdas, 
   {{0x216a25e2,0x6d5625e3,0x614602c4,0x7d1d0326}},	//   дини_, yiya, вена, _onss, 
   {{0x26c725e4,0x8fa625e5,0x7afe25e6,0x6d5625e7}},	//   lano_, каме, zept, xiya, 
   {{0xf9920137,0xa3a802f8,0x7d0d25e8,0x6d5625c1}},	//   ירט_, _खूप_, ddas, viya, 
   {{0x26c725e9,0x752922ad,0x60c625ea,0xd24e009c}},	//   nano_, ljez, sakm, _ژنو_, 
   {{0x6d5625eb,0x6d4402bf,0x50b625ec,0x26c725ed}},	//   tiya, thia, _испу, iano_, 
   {{0x26c725ee,0x75290727,0x7d0d25ef,0x26121295}},	//   hano_, njez, gdas, थिती_, 
   {{0x26c725f0,0x6d44120c,0x7afe002e,0x644902f2}},	// [19c0] kano_, rhia, tept, nzei, 
   {{0x6d4401a0,0x6d5625f1,0x60c425f2,0x69de00da}},	//   shia, siya, _heim, tupe, 
   {{0x60c40f24,0x3ed900c7,0x644901c4,0x7d0d0800}},	//   _keim, _אַרא, hzei, bdas, 
   {{0x69de25f3,0x7afe25f4,0x798925f5,0x6d5600a3}},	//   rupe, sept, _chew, qiya, 
   {{0xb90a25f6,0x26c725f7,0x798900c5,0x87e300c8}},	//   _मा_, fano_, _dhew, ающе, 
   {{0x6a860161,0x3d1601ec,0x68e225f8,0x60c425f9}},	//   _алга, _पोते_, sgod, _leim, 
   {{0x2d9c006b,0x63a225fa,0x248000e0,0x98a4020f}},	//   _éves_, _suon, _šim_, _comă_, 
   {{0x6b9c0090,0x644901c4,0x63a2084c,0x00000000}},	//   _hirg, fzei, _puon, --, 
   {{0x26c725fb,0x07a60f3d,0x46ea004e,0x6b9c25fc}},	//   bano_, _разн, _одан_, _kirg, 
   {{0xdced00f1,0x394603b7,0x63a225fd,0x7d0d0019}},	//   plać, lhos_, _vuon, zdas, 
   {{0x53d400a2,0x7d0d15aa,0x6b9c25fe,0x60c425ff}},	//   _दिवश, ydas, _mirg, _beim, 
   {{0x394600ce,0x63a22600,0x518702a6,0xdb0f03dd}},	//   nhos_, _tuon, ђуна, _etcè, 
   {{0x93460119,0x14d70111,0x60c42601,0x2ba702e6}},	//   _инде, _יואל_, _deim, _कंधा, 
   {{0x69d307d5,0x5333122f,0x6b9c2602,0x00000000}},	//   _डिली, _вешт, _nirg, --, 
   {{0x2fc02603,0xa3a82604,0x139b00d1,0x60c42605}},	//   _ewig_, _खंड_, _קבוע, _feim, 
   {{0x60c42606,0xe7d207d5,0xc1790009,0xd7d20fc0}},	//   _geim, _सिंप, rtės_, _सिंच, 
   {{0x7d0d2607,0x6b9c2608,0x2bda0c14,0xdd942609}},	// [19d0] rdas, _birg, यंगा, раты, 
   {{0x26c7040a,0x7d0d0626,0x7cde00d9,0x7989260a}},	//   xano_, sdas, tărâ, _shew, 
   {{0x26c7260b,0xfaa401a2,0x6b9c260c,0x995c02d9}},	//   vano_, ршун, _dirg, líř_, 
   {{0x26c7260d,0x7d0d260e,0x6b9c0534,0x6d5a260f}},	//   wano_, qdas, _eirg, état, 
   {{0x26c72610,0xb6a300a3,0x7bdf00ad,0x75290372}},	//   tano_, қиқл, ququ, vjez, 
   {{0x38690529,0xa03c00a7,0x6b9c2611,0x394600ca}},	//   ħar_, ועדפ, _girg, ahos_, 
   {{0x78a403ef,0xa3a80e36,0x79892612,0xa2b8031e}},	//   živa, _खूब_, _thew, ोरन्, 
   {{0xf3ff2613,0x26c72614,0x39462615,0xb4ad02f8}},	//   ção_, sano_, chos_, कडे_, 
   {{0x26c72616,0xd176004e,0xf8ae0019,0xc952008d}},	//   pano_, ғыны, _رکن_, _המן_, 
   {{0x644902ec,0x60c42617,0x753b031e,0x7ae50574}},	//   rzei, _seim, skuz, nght, 
   {{0x64492618,0x7ae52619,0x7bcd261a,0x2fc00ff2}},	//   szei, ight, hsau, _swig_, 
   {{0x26c5261b,0xe4cb00d4,0x6d1202e6,0x00000000}},	//   _helo_, _آبان_, _ढोंग_, --, 
   {{0xb4df00a2,0xdb0f0634,0xfd1f00e7,0x25a5261c}},	//   तली_, _etcé, _chìm_, _hull_, 
   {{0x25a50529,0xe8e000bc,0x26c50062,0x200900e2}},	//   _kull_, _पञ्च, _jelo_, _dsai_, 
   {{0x60c4261d,0x16090239,0x68e907c7,0x2009261e}},	//   _teim, विटर_, _oced, _esai_, 
   {{0x2d8b1175,0x26c5261f,0x6b9c2620,0x61e12621}},	//   _chce_, _lelo_, _sirg, mull, 
   {{0x61e12622,0xac860f88,0x7bcd0920,0x21202623}},	// [19e0] lull, угал, gsau, _inih_, 
   {{0x68e90587,0xec772624,0x61e10183,0xaf062625}},	//   _aced, упу_, oull, _спол, 
   {{0x61e12626,0x290d0415,0x637d0c32,0x212000bc}},	//   null, _baea_, gèni, _knih_, 
   {{0xfaa31cc1,0x68e92627,0x6b40003e,0x290d03c6}},	//   _ҳаро, _cced, _gögn, _caea_, 
   {{0x6b9c2628,0x26c52629,0x7e7e262a,0x290d0415}},	//   _tirg, _belo_, _hypp, _daea_, 
   {{0x61e101ee,0x26c5262b,0xfaa3262c,0x6b9c01be}},	//   kull, _celo_, _гаро, _uirg, 
   {{0x212003ef,0x26c5262d,0x39460626,0x637d022c}},	//   _onih_, _delo_, phos_, cèni, 
   {{0x9d22100b,0x61e1262e,0xa534262f,0x290d03c6}},	//   _নতুন_, dull, рнич, _gaea_, 
   {{0x786608ef,0x26c52630,0x77862631,0x6fa00466}},	//   _сказ, _felo_, _блаз, _गंगू, 
   {{0x25a52632,0x26c52633,0x61e12634,0x29260ab4}},	//   _full_, _gelo_, full, štač_, 
   {{0x61e12635,0xa5c4004e,0x521300b3,0x25a52636}},	//   gull, _төле, бдэт, _gull_, 
   {{0x26c511c8,0x613f021e,0x64a62637,0xa1592638}},	//   _zelo_, _gëll, _сада, таму_, 
   {{0x543600b8,0x26c52639,0x2d80263a,0x26120865}},	//   _حرار, _yelo_, dlie_, थिवी_, 
   {{0x26c50183,0xa2940fb6,0x9294263b,0x2d80263c}},	//   _xelo_, _калі, _калц, elie_, 
   {{0x1df8058b,0x61e1263d,0x25a50183,0x23d400bc}},	//   леры_, cull, _xull_, _दिँद, 
   {{0x2d8009f0,0x7bcd263e,0x7e7e0b48,0x27390118}},	//   glie_, tsau, _dypp, _vèni_, 
   {{0x2009263f,0x5c990b58,0x3b552640,0x6fd90790}},	// [19f0] _usai_, ткая_, акар, _भटिं, 
   {{0x7bcd2641,0x3ea1012b,0x6d5a2642,0x7ae500d1}},	//   rsau, _ught_, étar, ught, 
   {{0x2d800bc6,0x26c52639,0x63a402a3,0x9b682643}},	//   blie_, _relo_, _èinf, ушта_, 
   {{0x26c5044e,0x98c700eb,0x25a52644,0x78a42645}},	//   _selo_, اغان, _rull_, živn, 
   {{0xf77117c1,0x26c52646,0x25a50141,0x61e12647}},	//   يات_, _pelo_, _sull_, zull, 
   {{0x61e124d6,0x7bda00d1,0xaae2031e,0x45d51da4}},	//   yull, _בקשו, _पाएक, ацит, 
   {{0x6b4002ec,0x26c52648,0xb0b507d5,0x65c2170f}},	//   _mögl, _velo_, ंडाग, обща, 
   {{0xb4df2649,0x613f00e5,0x61e1264a,0x25a500d3}},	//   तले_, _qëll, vull, _vull_, 
   {{0xa3e50ede,0x9345171c,0xa3dc0081,0x26c5264b}},	//   बंध_, иние, तंग_, _telo_, 
   {{0x61e1264c,0xe299264d,0x63a9024a,0x25a5264e}},	//   tull, кап_, rqen, _tull_, 
   {{0xe126264f,0x00000000,0x00000000,0x00000000}},	//   амни, --, --, --, 
   {{0xa3e507d5,0x00000000,0x00000000,0x00000000}},	//   बंद_, --, --, --, 
   {{0x22590035,0x7fd500f0,0x316903a0,0x8fa60a26}},	//   ńsk_, йірі, _djaz_, раге, 
   {{0x61e12650,0xfe462651,0x3f9e2652,0x8f762653}},	//   pull, анго, ötu_, румі, 
   {{0x3f8400e0,0x427900c7,0xed5a1730,0x7d0f2654}},	//   ēmu_, _באַג, вов_, _bacs, 
   {{0x20562655,0xdca32656,0x21200604,0x637d011c}},	//   _втор, жати, _unih_, gènv, 
   {{0x0c261eda,0xe4f801a4,0x6da40259,0x7d0f03c6}},	// [1a00] шман, ्जति_, риға, _dacs, 
   {{0x973c0613,0x7e7e2657,0x7d0f0534,0x6ab62658}},	//   _kiće, _typp, _eacs, рсах, 
   {{0x6edb00a7,0xa3e52659,0x2d800151,0xf1ab0eda}},	//   _בחיפ, बूत_, plie_, _घूमन, 
   {{0xaae202f8,0x387f0d07,0xdb06024a,0xd94602a6}},	//   _पाकक, _byur_, _kukë, једи, 
   {{0x7d04265a,0xfaa6265b,0xd7060161,0x88bd0035}},	//   meis, _ваго, изди, _pośr, 
   {{0x7d040931,0x26120b26,0xed590228,0x73d808ba}},	//   leis, थिली_, ďže_, қдор_, 
   {{0x96b900d3,0x645d003e,0x1c0e02e6,0x356a1a3c}},	//   уучу_, úsin, सिकल_, крин_, 
   {{0x7d040088,0x2b5803e2,0x00000000,0x00000000}},	//   neis, _hmrc_, --, --, 
   {{0xc34a0141,0xa4140086,0xf36601a2,0x66e61571}},	//   вяне_, িহ্য_, итон, _воза, 
   {{0x7d04265c,0x79820056,0x973c265d,0x60d6265e}},	//   heis, llow, _biće, _adym, 
   {{0x7d041838,0x6b400219,0x6d460080,0x00000000}},	//   keis, _rögl, _olka, --, 
   {{0x92570080,0x8556010e,0xdb060034,0x7d040080}},	//   рают_, _خیبر_, _bukë, jeis, 
   {{0x7522265f,0x7d042660,0x3202031e,0x661a0082}},	//   _inoz, deis, ňky_, _hrtk, 
   {{0x6d462661,0xc05800dd,0x973c00ca,0x79820415}},	//   _alka, рію_, _fiće, hlow, 
   {{0xd37802f5,0x7d042662,0x79820083,0x637d00b9}},	//   moć_, feis, klow, gènu, 
   {{0x929b0056,0x7c872663,0x7d042664,0xe29b2665}},	//   _ביות, аузе, geis, _בשור, 
   {{0xdfd100eb,0xfaa72666,0x30340cdf,0x69d8014b}},	// [1a10] _عيد_, ашен, _меъё, áven, 
   {{0x6d462667,0xd3780571,0x98b80339,0x7c200372}},	//   _elka, noć_, _ērā_, _šmrc, 
   {{0x3f8300f1,0x387f08a1,0x98bf05ae,0x75220532}},	//   mlju_, _syur_, _smuđ_, _onoz, 
   {{0xae1a00a7,0x3e160070,0xfcab0296,0x79822668}},	//   _עורכ, _פֿיל_, _جادو_, glow, 
   {{0xd3780b43,0x1b0f0086,0xf8072669,0x00000000}},	//   koć_, সাবে_, рчен, --, 
   {{0xd2460040,0x75220027,0xdb230444,0x7982266a}},	//   _فن_, _anoz, _بوسی, alow, 
   {{0x6eba0299,0x69de0082,0x79820035,0x00000000}},	//   ्रतु, crpe, blow, --, 
   {{0x89380f89,0x3ce9059e,0xa52500a3,0x637d01e5}},	//   _кпсс_, ngav_, смид, hènt, 
   {{0x973c0097,0x52e200c9,0x46150eb7,0x2eb70659}},	//   _siće, पलूस, _گوار, _अभूत, 
   {{0x973c090e,0x27ff00d7,0x75220604,0x7d04266b}},	//   _piće, _ipun_, _enoz, zeis, 
   {{0x3f830372,0x7d040548,0x00000000,0x00000000}},	//   dlju_, yeis, --, --, 
   {{0x752200ef,0x973c0082,0x9f42011c,0xdb06021e}},	//   _gnoz, _viće, muké_, _pukë, 
   {{0x44290518,0x7d04266c,0xd3a70d47,0x057400eb}},	//   _ça_, veis, _треп, _بالد, 
   {{0x63bb0b92,0x02391f7a,0x7d0402f2,0x59a70a34}},	//   mpun, _مثبت_, weis, गदार, 
   {{0x7d04266d,0x68fb266e,0x63bb266f,0x6ade0086}},	//   teis, _obud, lpun, ন্ডো, 
   {{0x90c6088a,0x2b5800ca,0xed571cc1,0x27ff0474}},	//   _убие, _smrc_, бос_, _opun_, 
   {{0x3f8308b1,0x63bb2670,0x4fea02f1,0x637d023e}},	// [1a20] blju_, npun, _ёмон_, bènt, 
   {{0x7d041eab,0x68fb02a5,0x637d2671,0x00000000}},	//   seis, _abud, cènt, --, 
   {{0x993a0769,0xe9da2672,0x7d0408fe,0x6b400219}},	//   ляду_, уке_, peis, _högk, 
   {{0x63bb2673,0x6d4602f1,0x68fb00a1,0x7982019b}},	//   kpun, _ulka, _cbud, ulow, 
   {{0xe73a0676,0x7982040b,0xacf7010e,0x6fcb0a0e}},	//   лед_, rlow, _اسپت, तीपू, 
   {{0x63bb2674,0x97a5004e,0x78250038,0x00000000}},	//   dpun, іріл, تعمل, --, 
   {{0xceb3035c,0x8f9b027a,0xa96a2675,0xd6d92676}},	//   ליג_, ניצי, _бива_, рті_, 
   {{0x63bb0c0c,0x73d800a3,0xdb06011c,0x93b4017b}},	//   fpun, адир_, _sukè, обиц, 
   {{0x63bb2677,0x684603a1,0x2906025b,0x00000000}},	//   gpun, _унаа, meoa_, --, 
   {{0xdb042678,0x27e602dc,0x68fb2679,0x1b0f0033}},	//   mpió, muon_, _zbud, সাথে_, 
   {{0x3f8302f5,0x63bb01ca,0x2e1805d5,0x9f4200d7}},	//   vlju_, apun, _nčf_, cuké_, 
   {{0x73e600e4,0xddcb003d,0x938800f0,0x1a9b0070}},	//   _годз, ġiżl, ысқа_, טייע, 
   {{0x637d022c,0x27e602dc,0x3f830a1a,0xc05b00f0}},	//   tènt, nuon_, tlju_, уін_, 
   {{0xc90500c9,0x2e1805d5,0x26ce0379,0xf1f71372}},	//   _रस्म_, _bčf_, nafo_, جعیت_, 
   {{0x20000118,0x7e281003,0x290601d6,0x637d267a}},	//   _epii_, біта_, keoa_, rènt, 
   {{0x52830084,0x78a40f30,0x27e6267b,0x6b4002ae}},	//   _عليك, živj, kuon_, _högh, 
   {{0xfd4f0029,0x3f83032f,0x26ce00a9,0x29060a9f}},	// [1a30] _khiế, plju_, kafo_, deoa_, 
   {{0x27e6267c,0x00000000,0x00000000,0x00000000}},	//   duon_, --, --, --, 
   {{0x27ff002e,0x3ce9267d,0xc987267e,0x00000000}},	//   _spun_, pgav_, буди, --, 
   {{0x63bb267f,0x224a020b,0x00000000,0x00000000}},	//   ypun, úbky_, --, --, 
   {{0x6aa900b3,0x27300054,0x6d4d2680,0xdd9801d7}},	//   _şefu, _hàny_, mhaa, _ышь_, 
   {{0x70b52681,0xfd4f00e7,0x6d5f2682,0xdced02c7}},	//   ंडुल, _nhiế, liqa, mlađ, 
   {{0x27ff0065,0xc5d5004f,0x00000000,0x00000000}},	//   _wpun_, ціль, --, --, 
   {{0x63bb02f5,0x68fb2683,0x6d4d2684,0x261a007e}},	//   tpun, _ubud, nhaa, _मछरी_, 
   {{0x69da0750,0x63bb00c8,0x7c2d2685,0x383400b3}},	//   _åter, upun, nxar, _ентр, 
   {{0xfd4f00f7,0x6d4d2686,0x63bb2687,0xe1f908a7}},	//   _chiế, hhaa, rpun, аго_, 
   {{0x63bb2688,0xdced0b1d,0x6d4d2689,0x6f0700bc}},	//   spun, hlađ, khaa, dejc, 
   {{0xdced268a,0x63bb268b,0xd24e009c,0x00000000}},	//   klađ, ppun, خچه_, --, 
   {{0x6d4d268c,0x2329268d,0x297a0147,0x00000000}},	//   dhaa, _воли_, שטרא, --, 
   {{0x6da6268e,0x6569268f,0x973c0082,0x63ab011d}},	//   жива, lneh, _kića, _iugn, 
   {{0xad5a2690,0x63ab2691,0xa3e50262,0x41760a24}},	//   арах_, _hugn, बूर_, _وابس, 
   {{0x63a32692,0x65692693,0x6d4d2694,0x6d4300d9}},	//   _hinn, nneh, ghaa, _înal, 
   {{0x63a32695,0x443f2696,0x442d0496,0xfd1f00e7}},	// [1a40] _kinn, nyu_, nxe_, _nhìu_, 
   {{0x261a0f63,0x63a32697,0x62830c6a,0x63ab02a3}},	//   _मछली_, _jinn, _kyno, _mugn, 
   {{0x63ab014e,0x2d8c2698,0x9a6a00eb,0xdce42699}},	//   _lugn, ïdes_, جمال_, lnič, 
   {{0x63a3269a,0x6d4d0b32,0x443f269b,0x98a601ba}},	//   _linn, chaa, kyu_, циде, 
   {{0x186a00cf,0xd70a0161,0x63ab011d,0xc8cc031e}},	//   шади_, инде_, _nugn, ारबट, 
   {{0x1754269c,0xd04e0095,0x501b042c,0x6d44269d}},	//   явля, ükəs, יונו, lkia, 
   {{0xd94624d9,0x26ce269e,0x5693269f,0x628302fb}},	//   _деви, rafo_, машт, _nyno, 
   {{0x6d4400e4,0x63ab26a0,0x7d1626a1,0xdb040634}},	//   nkia, _bugn, ndys, mpiñ, 
   {{0x63a31f3a,0xdce404d1,0x443f26a2,0xfd4f001b}},	//   _binn, jnič, gyu_, _phiế, 
   {{0x63a30544,0x63ab26a3,0x6d5f00a3,0x321c26a4}},	//   _cinn, _dugn, ziqa, _prvy_, 
   {{0x442d0496,0x62830156,0x6d4400c8,0x63a326a5}},	//   axe_, _cyno, kkia, _dinn, 
   {{0x63a3010d,0x62830156,0x80b502e6,0x443f011d}},	//   _einn, _dyno, ंडें, byu_, 
   {{0x63a326a6,0xfd4f00f7,0x61e10183,0x63ab0036}},	//   _finn, _thiế, arll, _gugn, 
   {{0xdced0a1a,0xf4870296,0x26cc0121,0x93770038}},	//   vlađ, _بامی, _jedo_, _وصور_, 
   {{0x26cc26a7,0x6d5f26a8,0x6d4d2680,0x628300f8}},	//   _medo_, tiqa, thaa, _gyno, 
   {{0x91b700d6,0x63a326a9,0x7c2d01f1,0x61e80495}},	//   _بطور_, _zinn, txar, mudl, 
   {{0x6d4d26aa,0x6d5f26ab,0x61e826ac,0xdce400da}},	// [1a50] rhaa, riqa, ludl, cnič, 
   {{0xce950141,0x26cc02fe,0x6d5f00a3,0x656926a4}},	//   _напъ, _nedo_, siqa, zneh, 
   {{0x60cd1146,0xdced034c,0x2fc907fc,0x61e802dc}},	//   _keam, slađ, _hwag_, nudl, 
   {{0x6d5f02f1,0x6d4400e1,0x644026ad,0x889500b3}},	//   qiqa, ckia, kymi, пиех, 
   {{0x26cc26ae,0x880700d6,0x2be20c46,0x6d5d26af}},	//   _bedo_, تظام, _पिया, _imsa, 
   {{0x60cd0557,0x26cc26b0,0x973c00ca,0xe73626b1}},	//   _leam, _cedo_, _pića, зеш_, 
   {{0x63a326b2,0x63ab0915,0x656926b3,0x61e826b4}},	//   _rinn, _sugn, tneh, judl, 
   {{0x60cd24ae,0x442d0860,0x63ab26b5,0x61e826b6}},	//   _neam, txe_, _pugn, dudl, 
   {{0x656926b7,0xb4bb119f,0xb4ab1615,0x442d0165}},	//   rneh, _अभी_, _खली_, uxe_, 
   {{0x442d0496,0xdce426b8,0x6d9326b9,0x6d440a9f}},	//   rxe_, vnič, lçad, zkia, 
   {{0x63a326ba,0x6d4426bb,0x60cd26bc,0x6d5d09ad}},	//   _vinn, ykia, _beam, _omsa, 
   {{0xdce400f1,0x6d9326bd,0x216a26be,0x63ab26bf}},	//   tnič, nçad, сими_, _tugn, 
   {{0x60cd26c0,0xe81e0fec,0x4acb0c46,0x823500d4}},	//   _deam, पिया_, िराव, زرگا, 
   {{0x61e826c1,0x63a30465,0x987a00d1,0x00000000}},	//   budl, _uinn, מארט, --, 
   {{0x614626c2,0x23c5010c,0x60cd1bf0,0x00000000}},	//   _нека, bêjî_, _feam, --, 
   {{0x60cd26c3,0xdce4127b,0x2d9526c4,0x6d440009}},	//   _geam, pnič, друс, ukia, 
   {{0x6d4426c5,0x2fc900f8,0x7d1626c6,0x00000000}},	// [1a60] rkia, _gwag_, rdys, --, 
   {{0x78a900fd,0x8eea004f,0xbcfb0118,0x6d4426c7}},	//   _agev, _умов_, _améd, skia, 
   {{0x7ae326c8,0x644026c9,0x00000000,0x00000000}},	//   ónta, zymi, --, --, 
   {{0x4c6a1be7,0xdb0426ca,0x7e73010c,0x26cc26cb}},	//   _гимн_, rpiñ, şepê, _sedo_, 
   {{0x2d821a43,0x26cc26cc,0xdb040183,0x0c23012d}},	//   _ikke_, _pedo_, spiñ, _змян, 
   {{0x6d9302aa,0x6440020b,0xeb9726cd,0x00000000}},	//   açad, vymi, _ния_, --, 
   {{0x78ad02f5,0x26cc26ce,0x6440186a,0xdb0f010e}},	//   žava, _vedo_, wymi, _utcá, 
   {{0x644026cf,0xe5a30267,0x6d930212,0x26cc011c}},	//   tymi, нији, rçag, _wedo_, 
   {{0x7bd626d0,0x60cd26d1,0x26cc0144,0x00000000}},	//   nsyu, _ream, _tedo_, --, 
   {{0x60cd26d2,0x656000a4,0x61e802dc,0x394626d3}},	//   _seam, simh, tudl, lkos_, 
   {{0x62870529,0x7bd602cd,0x60cd007e,0x6728003d}},	//   żjon, hsyu, _peam, _indj, 
   {{0x3946012d,0xf8cc26d4,0x673a0026,0x7bd606e4}},	//   nkos_, ारिय, _hotj, ksyu, 
   {{0x61e826d5,0x60cd26d6,0x23c5009e,0x673a07d7}},	//   sudl, _veam, rêjî_, _kotj, 
   {{0x973c0ab4,0x2d8202a5,0x673a021e,0x909800fd}},	//   _mićo, _akke_, _jotj, явят_, 
   {{0xf8cc0c59,0x6fd900a2,0x673a07d7,0xfe700038}},	//   ाराय, _भटकं, _motj, هدف_, 
   {{0x2d5826d7,0x6b40008c,0x2fc90102,0x673a039b}},	//   пись_, _mögu, _twag_, _lotj, 
   {{0x67280e67,0xb0c30827,0x6b40008c,0x84ea0a34}},	// [1a70] _ondj, _व्यग, _lögu, _टाईट_, 
   {{0xe1ab0366,0x2aab02a6,0x2d8226d8,0x7b141a57}},	//   _घूँघ, стао_, _ekke_, ндух, 
   {{0x7f3c00a7,0x62860035,0x442b0023,0x3946040b}},	//   _לעזו, ękow, ̣c_, fkos_, 
   {{0x67280097,0xbcfb0a22,0x394626d9,0x6d5d26da}},	//   _andj, _ejér, gkos_, _umsa, 
   {{0x248626db,0x6d9326dc,0x673a0364,0xe73926dd}},	//   _nyom_, rçad, _botj, жел_, 
   {{0x2be217dc,0x66e526de,0x00000000,0x00000000}},	//   _पिता, фока, --, --, 
   {{0x673a02c7,0x248610fd,0xe51e0f6f,0xf8ae0019}},	//   _dotj, _ayom_, _मोहि_, اکہ_, 
   {{0x25de04cc,0xe3b926df,0xf99313b4,0x6b40008c}},	//   _गिरी_, оби_, _سبز_, _dögu, 
   {{0x395f26e0,0x25a626e1,0x394d0616,0x2d89011c}},	//   _imus_, _diol_, _iles_, ilae_, 
   {{0x673a0ab4,0x212926e2,0xc24526e3,0xaadd009a}},	//   _gotj, _anah_, днок, मणिक, 
   {{0x779013b4,0x69d70183,0x6b9b0036,0x25a626e4}},	//   _حیوا, nsxe, _èugu, _fiol_, 
   {{0x69d802a0,0x6b40014e,0x2ec610b0,0x77630183}},	//   ávei, _högt, वर्त, linx, 
   {{0x657c039f,0x00000000,0x00000000,0x00000000}},	//   _írha, --, --, --, 
   {{0x394d26e5,0x6265005b,0x77630068,0x21290175}},	//   _lles_, _овла, ninx, _enah_, 
   {{0x8fa31431,0xdef9012d,0x945d0083,0x00000000}},	//   таре, чыў_, pańs, --, 
   {{0xa1870093,0x00000000,0x00000000,0x00000000}},	//   _обща_, --, --, --, 
   {{0x24860201,0x316026e6,0x00000000,0x00000000}},	// [1a80] _xyom_, _imiz_, --, --, 
   {{0x394d002e,0x7bd6005c,0x2d890226,0xa3e500aa}},	//   _ales_, rsyu, alae_, _फिन_, 
   {{0x6b5201cc,0x973c0082,0x6cc626e7,0x5de608b8}},	//   _lægg, _sićo, _ойна, _южна, 
   {{0x3946012d,0x395f0068,0x9cb6009c,0x394d26e8}},	//   ukos_, _cmus_, _زمست, _cles_, 
   {{0x394626e9,0x6b40008c,0x77630183,0x00000000}},	//   rkos_, _sögu, finx, --, 
   {{0xd5ba036a,0x394d0c1f,0x569426ea,0x394626eb}},	//   оси_, _eles_, налт, skos_, 
   {{0x394d013c,0x09d80086,0xfbb00033,0xda650038}},	//   _fles_, _সহকা, _ছবিত, _كافي, 
   {{0xb4e80586,0x2d800036,0x00000000,0x00000000}},	//   बले_, noie_, --, --, 
   {{0xd90d1fdb,0x25a60e83,0xdc1100ad,0x00000000}},	//   _دین_, _viol_, _məğl, --, 
   {{0x25f60035,0x628f0035,0x764326ec,0x31600508}},	//   _एमपी_, ęcon, byny, _amiz_, 
   {{0x6b40022b,0x212902cd,0x25a60183,0x3b180106}},	//   _högs, _pnah_, _tiol_, _marq_, 
   {{0x056626ed,0x78a400da,0x2d4702be,0x00000000}},	//   _ювен, živu, _põem_, --, 
   {{0x6d43002e,0x59ce00a2,0x104b004f,0x63a40036}},	//   _înai, हीतर, іями_, _èino, 
   {{0x2bb511bd,0x00000000,0x00000000,0x00000000}},	//   _अंबा, --, --, --, 
   {{0x3da700e4,0x27e626ee,0x2d890226,0x6f17023e}},	//   драб, hron_, tlae_, _vaxc, 
   {{0xa3e50081,0x21f8005f,0x98a40237,0x21290096}},	//   बूक_, méh_, _anmč_, _unah_, 
   {{0x6f170126,0x1eab0038,0x301426ef,0x27e60104}},	// [1a90] _taxc, _وادي_, _адыр, jron_, 
   {{0x27e626f0,0x7f5926f1,0xa3e626f2,0x6ec0009a}},	//   dron_, _хаос_, _बटन_, वडणु, 
   {{0x27e608f4,0x21f811e9,0xab8426f3,0x27e000eb}},	//   eron_, néh_, тутк, áinn_, 
   {{0x26de02dc,0x0e9a00d1,0xab5b0241,0x00000000}},	//   _adto_, _משתל, _stüd, --, 
   {{0x7d0d26f4,0x78ad090b,0x21f80574,0xf21000a5}},	//   meas, žavo, héh_, ़बड़_, 
   {{0xf773030e,0xae0300a2,0x7d0d26f5,0x76430088}},	//   خاص_, _लहान_, leas, tyny, 
   {{0x776326f6,0x27e626f7,0x6a1401a2,0xfbb508b3}},	//   rinx, aron_, _имру, _अंडम, 
   {{0x764326f8,0x7d0d26f9,0x394d0175,0x21f80096}},	//   ryny, neas, _ules_, déh_, 
   {{0x764300c8,0x9985010e,0xf8b2027a,0x31600237}},	//   syny, _élő_, _תשמ_, _rmiz_, 
   {{0x7d0d26fa,0x6b40022b,0x6b5202c9,0x7c2000ca}},	//   heas, _högr, _vægg, _šmrk, 
   {{0x26c702ee,0x7d0d0088,0xe1f6049b,0x6d4f26fb}},	//   mbno_, keas, нгэ_, _olca, 
   {{0x361a00a7,0x261100ca,0x7d0d26fc,0xdb07021e}},	//   _מועד, _išo_, jeas, _bijë, 
   {{0x2d8026fd,0xdb060483,0x7d0d26fe,0xab6406a2}},	//   voie_, _luká, deas, lmüş, 
   {{0x6d4f0edb,0x6b40008c,0x21f8005f,0x3eac192b}},	//   _alca, _lögr, béh_, ødt_, 
   {{0x2365022b,0x7d0d0387,0x2d961dbd,0x6b52192b}},	//   milj_, feas, ерас, _jæge, 
   {{0x27e626ff,0x1de109ef,0xf11a003f,0x7d0d2700}},	//   yron_, _फिरत, _رغبت_, geas, 
   {{0x6b5201cc,0xec772701,0x63ad02a3,0xed572702}},	// [1aa0] _læge, епт_, _èand, хот_, 
   {{0x27e62703,0x2d800036,0x236502ae,0x06e50033}},	//   vron_, soie_, nilj_, প্তি, 
   {{0x2d730571,0x7d0d2704,0xdb07011c,0xeef700d1}},	//   mćen_, beas, _mijè, _אמיר_, 
   {{0x27e62705,0xb4de00bd,0x6d4f00a1,0xdb062706}},	//   tron_, _तये_, _glca, _duká, 
   {{0x58832707,0x27e62708,0x00000000,0x00000000}},	//   лыша, uron_, --, --, 
   {{0x7bc42709,0xf0930137,0x27e6270a,0x27e0270b}},	//   mpiu, אנד_, rron_, šino_, 
   {{0x27e6270c,0x387200d9,0x06cf0033,0xe1e703b8}},	//   sron_, _ţară_, _রাশি, _حس_, 
   {{0xe9a3005e,0x69dc2259,0xdb1d0118,0x27e6270d}},	//   _басп, _ivre, _atsè, pron_, 
   {{0xb60300e0,0x888100d4,0x7bc40065,0xd7ca007a}},	//   āšan, _پیون, npiu, _رواه_, 
   {{0xb5f2004e,0x973c0082,0x26de012b,0x7783270e}},	//   _бүкі, _mićk, _udto_, _блуз, 
   {{0xdb07270f,0x2fc00090,0x00000000,0x00000000}},	//   _dijè, _atig_, --, --, 
   {{0x613f00e5,0x2902014e,0x399502ae,0xd04600ad}},	//   _pëlq, _ökad_, påse_, lakə, 
   {{0x65620102,0x23650ab4,0xe53b00d1,0x2bb509ef}},	//   _imoh, bilj_, _מתאר, _अंधा, 
   {{0x4ea72710,0x6d480218,0xdb070034,0x69dc0121}},	//   ерба, êdan, _vijë, _ovre, 
   {{0x3ea52711,0x7d0d2712,0xdcfd00c3,0xd24f2713}},	//   ält_, teas, _jisħ, _сц_, 
   {{0xdb06026e,0x2bb511ff,0x3ceb00c9,0x6ab90e07}},	//   _ruká, _अंदा, टलें_, इड्र, 
   {{0x69dc1ad1,0x65620364,0xe7cf0035,0x7d0d2714}},	// [1ab0] _avre, _mmoh, _सौंप, reas, 
   {{0x2009016a,0x7d0d2715,0x64c402d9,0x00000000}},	//   _ipai_, seas, lčič, --, 
   {{0x7d0d2716,0x26c70352,0xdcfd2717,0x69dc0604}},	//   peas, vbno_, _eksā, _cvre, 
   {{0x3f832718,0x64c410ea,0x21392719,0xb7bd107c}},	//   loju_, nčič, njsh_, _arţa, 
   {{0xb909271a,0x69dc271b,0x399e02d9,0xa2b800bc}},	//   _मय_, _evre, _růst_, ोरञ्, 
   {{0x65620364,0x3f830450,0x00000000,0x00000000}},	//   _amoh, noju_, --, --, 
   {{0xc8f5048a,0xda050fec,0xf77017ba,0xc4470116}},	//   _извъ, _रहित_, حان_, کیشن_, 
   {{0xb8b2004e,0xab6406a2,0x7c2000ca,0xdb0f011c}},	//   _көші, rmüş, _šmri, _sucè, 
   {{0x290f271c,0x3f83271d,0x2365032f,0x00000000}},	//   mega_, koju_, tilj_, --, 
   {{0x69c5271e,0x290f271f,0x65622720,0x628a0b48}},	//   ophe, lega_, _emoh, _byfo, 
   {{0x2fc02245,0x628a0156,0xa3e502e6,0x2d730082}},	//   _stig_, _cyfo, बूज_, vćen_, 
   {{0x290f11c8,0x291d2721,0x628a0156,0x50460886}},	//   nega_, ndwa_, _dyfo, вемб, 
   {{0x6594011f,0x61e82722,0x628a2723,0x307602aa}},	//   _сацу, ardl, _eyfo, тунс, 
   {{0x290f2724,0xdf1502fb,0x3f8308e3,0x5f0600fd}},	//   hega_, льсь, goju_, ъзга, 
   {{0x290f11c8,0x5ed400cc,0x628a00f8,0x200901cf}},	//   kega_, _তাদে, _gyfo, _epai_, 
   {{0x290f2725,0x7c290372,0xd026040c,0x00000000}},	//   jega_, _šera, _амий, --, 
   {{0xc4d20137,0x290f0077,0x6da3213a,0x291d0a8b}},	// [1ac0] יגן_, dega_, рита, ddwa_, 
   {{0x7bc40528,0x6d9300b9,0x00000000,0x00000000}},	//   rpiu, rçaa, --, --, 
   {{0xab5b02f2,0xe8fa00e4,0xa9a60093,0xed5a183a}},	//   _stüc, дле_, вижд, _жон_, 
   {{0x290f2726,0xd7e60965,0x81bc01dd,0x09e30267}},	//   gega_, віко, lvēc, роцн, 
   {{0xa41c00cc,0x798202a5,0xe7b32727,0x00000000}},	//   _তথ্য_, roow, لمند, --, 
   {{0x6d932728,0xbcfb000d,0x69d8063b,0x69c50201}},	//   nçan, _jmén, áves, bphe, 
   {{0x6f030c05,0x69dc14f0,0x69c50465,0x290f2729}},	//   _önce, _uvre, cphe, bega_, 
   {{0x290f090b,0x1514272a,0x38c80a5a,0xd94308ac}},	//   cega_, удия, _ساری_, _кеси, 
   {{0xa8872273,0x98a318ac,0xdb0f0068,0x4917009a}},	//   _айта_, _вите, _sucé, _नसतो_, 
   {{0x5fdc02c3,0x2bb500a5,0xdcfd007b,0x00000000}},	//   _बिजल, _अंसा, _tisħ, --, 
   {{0xe737272b,0x3f83272c,0xb5f200f0,0x00000000}},	//   _шеф_, voju_, _түйі, --, 
   {{0xbcfb026a,0x27e9052a,0x628a0098,0xdb07009e}},	//   _amén, šane_, _vyfo, _nijî, 
   {{0x6d562279,0x5064272d,0xc0ab0740,0x3f832409}},	//   dhya, атра, بادل_, toju_, 
   {{0x442602dc,0x973c0588,0x628a272e,0x643b0070}},	//   _iro_, _bići, _tyfo, _קעגנ, 
   {{0x3f83272f,0xdb070218,0x1df813f2,0x290f2730}},	//   roju_, _bijî, керы_, yega_, 
   {{0x44262731,0x63ad01d8,0x6e2502c7,0xf1a42732}},	//   _kro_, _èanc, _vrhb, _крын, 
   {{0x290f2733,0xdb07010c,0x27e00f4c,0x4426023e}},	// [1ad0] vega_, _dijî, šinj_, _jro_, 
   {{0x44262734,0x69c52735,0x3b542736,0x207c2737}},	//   _mro_, tphe, акур, _קאזא, 
   {{0x290f2738,0x7c260380,0x66e500a3,0x7866040c}},	//   tega_, _erkr, ҳола, _nаvb, 
   {{0x44262739,0xa6cf0033,0x00000000,0x00000000}},	//   _oro_, _রাইট, --, --, 
   {{0x290f273a,0x6d4d273b,0x69c5273c,0x4426273d}},	//   rega_, mkaa, sphe, _nro_, 
   {{0x290f05d2,0x77840100,0x6d4d273e,0xdced044e}},	//   sega_, аліз, lkaa, inač, 
   {{0x4426273f,0x290f1bf8,0x6446004f,0x69d80304}},	//   _aro_, pega_, økin, šver, 
   {{0xdb0d127e,0x6d4d2740,0x7d1d2741,0x6b8500a3}},	//   mpañ, nkaa, _jass, lohg, 
   {{0x7d1d0df7,0x44262742,0x38600038,0x7d1b0183}},	//   _mass, _cro_, úirt_, _óusu, 
   {{0x7d1d2743,0x96ca047c,0xdced003a,0x95cb00cf}},	//   _lass, _स्पॉ, dnač, _жуда_, 
   {{0x6d4d2740,0x44262744,0xfb1600c7,0x6146152f}},	//   kkaa, _ero_, אַכט_, гена, 
   {{0x442600f8,0x6d4d2745,0x7bc100d8,0x00000000}},	//   _fro_, jkaa, _člun, --, 
   {{0x44262746,0x6d4d2747,0x65690088,0x79890053}},	//   _gro_, dkaa, mieh, _mkew, 
   {{0x973c0613,0x06e50086,0x65692748,0x645b0548}},	//   _pići, প্রি, lieh, mzui, 
   {{0x7d1d2749,0xfce62540,0xfbdf010c,0x6d560532}},	//   _bass, лово, _avê_, thya, 
   {{0x7d1d274a,0x6d4d274b,0xbacd0033,0xe6d010b0}},	//   _cass, gkaa, _লাগছ, _सज्ज, 
   {{0x5f7600d4,0xdce400ca,0x2b0200b0,0x0c26012d}},	// [1ae0] _مادر, hnić, _रउआँ_, ыман, 
   {{0x6d56024d,0x7d1d0226,0x7989044d,0x6d9306a2}},	//   shya, _eass, _akew, lçal, 
   {{0x7d1d274c,0x6d4d040b,0x6e461853,0xdce40613}},	//   _fass, bkaa, _сенз, jnić, 
   {{0x3940003e,0x6d93274d,0x799b018e,0xfe7511ec}},	//   ðis_, nçal, _chuw, _түс_, 
   {{0x6f1e0105,0x799b00c5,0x48e3274e,0x6569042a}},	//   _kapc, _dhuw, сочв, dieh, 
   {{0x779100d6,0x7c240711,0x7d1d14d8,0xa77308ab}},	//   قیقا, mvir, _zass, бліч, 
   {{0xdced19eb,0x4426274f,0x1c1c048e,0x63a40036}},	//   znač, _sro_, निकल_, _èini, 
   {{0x442610a6,0x69de2750,0x74142751,0x645b01c8}},	//   _pro_, mspe, لوبا, fzui, 
   {{0x7c242752,0x136a04a0,0x69de2753,0x06f6024f}},	//   nvir, ешни_, lspe, _مساج, 
   {{0xa3e5119f,0xbcfb026d,0xe3bf03da,0x07a602a6}},	//   _फिर_, _amél, íña_, _сазн, 
   {{0xe1352754,0x69de2755,0xa2940965,0x92942756}},	//   анны, nspe, рані, ранц, 
   {{0x25f30081,0x44262757,0x69de00eb,0x65690228}},	//   ्झरी_, _tro_, ispe, cieh, 
   {{0x442602ee,0x644600b0,0x50670009,0x60d60208}},	//   _uro_, äkid, утна, _deym, 
   {{0x2b8f02f2,0x7d1d2758,0x69de2759,0x7c290df4}},	//   rück_, _sass, kspe, _šero, 
   {{0x7d04275a,0xd904006b,0x6d4d275b,0x8d770629}},	//   ffis, _ٹی_, tkaa, هارا, 
   {{0x629800f1,0x69de0c29,0x7d1d275c,0x9d18275d}},	//   _izvo, dspe, _qass, лост_, 
   {{0x81b600cc,0x7d1d275e,0xdd94275f,0x69de2760}},	// [1af0] _ছবি_, _vass, саты, espe, 
   {{0x7d1d2761,0x656902f2,0x6d4d2544,0xda7b012d}},	//   _wass, zieh, skaa, няе_, 
   {{0x7d1d2762,0x69de2763,0x6d4d2764,0xae362765}},	//   _tass, gspe, pkaa, _күрт_, 
   {{0xa3e5051f,0x973c032f,0xe0e70033,0xdce40035}},	//   _फिल_, _miću, গ্রহ_, knię, 
   {{0x6d932766,0x69de00b3,0xdb0d033c,0x5fb50299}},	//   nçam, aspe, spañ, ंदिल, 
   {{0x6d5800e4,0xb8ec07d5,0x99d70fd0,0x645b00a3}},	//   _įvai, _श्_, _مترا, vzui, 
   {{0xb8db00cc,0x65692767,0xf8c9026a,0xeef800d1}},	//   _আজ_, tieh, _créé_, אמור_, 
   {{0xdce4034c,0x79a403b7,0x7bdf2768,0x2d4702be}},	//   rnić, _груе, osqu, _iões_, 
   {{0x8508004e,0xdb0f2769,0x6569042a,0xdce4276a}},	//   удың_, _lucí, rieh, snić, 
   {{0xe787276b,0x7bdf0165,0x60d6276c,0x645b01c8}},	//   _субо, isqu, _seym, rzui, 
   {{0x60d60218,0xdb0e0218,0x291f00b0,0x7d04276d}},	//   _peym, _bibê, _kaua_, yfis, 
   {{0x6026021d,0x291f0369,0x0eee01a4,0xc4f80038}},	//   адма, _jaua_, जल्स_, _معها_, 
   {{0xb4c308dd,0xdb0e078a,0x291f0053,0x6d930540}},	//   ्री_, _dibê, _maua_, rçal, 
   {{0x2d8b031e,0x69de276e,0x25af0082,0x644600c8}},	//   _akce_, yspe, _higl_, äkie, 
   {{0x7d04276f,0xbea60f4e,0x23bb0218,0x6d9303a1}},	//   tfis, равк, _hêj_, pçal, 
   {{0x7c2400e4,0x27e006e0,0x69de0343,0xccc60079}},	//   tvir, šini_, vspe, рбай, 
   {{0xdee62770,0xab6623e1,0x7d04008c,0x69de2771}},	// [1b00] _копи, авал, rfis, wspe, 
   {{0x68fb2772,0x69de2773,0x21200065,0xb4c30c64}},	//   _acud, tspe, _haih_, ्रु_, 
   {{0xbd8a0040,0x7c242774,0x399c00eb,0x69de2775}},	//   _لندن_, svir, híse_, uspe, 
   {{0x6d4300d9,0x68fb00a1,0x63a402a3,0xc7c62776}},	//   _înap, _ccud, _èinv, аски, 
   {{0x779413b4,0x27e0161c,0xdb0d01d5,0xdb0f0474}},	//   میرا, éin_, ppað, _ducâ, 
   {{0x69de2777,0xd70703a1,0x7bc60080,0x00000000}},	//   pspe, инче_, _itku, --, 
   {{0x25af0082,0xdb0e024a,0xcb67002e,0x7f9b0216}},	//   _bigl_, _libë, _таре_, qîqe, 
   {{0x27e90bc3,0xa534122f,0x399c0038,0x291f01ca}},	//   šana_, снич, físe_, _gaua_, 
   {{0x973c00d2,0xd497049b,0x8cd701a4,0x00000000}},	//   _siću, ирь_, बरतो, --, 
   {{0x3944022c,0x316b0035,0x733801a2,0xb3542778}},	//   _homs_, wicz_, узор_, скош, 
   {{0xe81e2369,0x26dc2779,0x44e80086,0x7c29003d}},	//   पिका_, mavo_, ক্ষক_, _ġerm, 
   {{0x7bc602f5,0x26dc277a,0x2b061779,0x8c480540}},	//   _otku, lavo_, स्तु_, _kağı, 
   {{0xb4d21aab,0x7afc00d2,0x1b1d0033,0x64a6277b}},	//   वरी_, _ocrt, নাতে_, _тада, 
   {{0x2005003d,0x26dc277c,0xdb0e021e,0x6d93277d}},	//   ċli_, navo_, _dibë, rçam, 
   {{0x139b042c,0x539b00a7,0x629800d2,0x2b430455}},	//   _שבוע, _שיוו, _uzvo, _rojc_, 
   {{0x3944277e,0x3a2d277f,0xac1903a1,0x26dc2780}},	//   _noms_, _čep_, лобу_, havo_, 
   {{0x291f01a4,0x26dc2781,0x60dd2782,0x316901cf}},	// [1b10] _raua_, kavo_, masm, _imaz_, 
   {{0x7bdf026d,0x26dc2783,0x2ef52784,0x68fb00fd}},	//   rsqu, javo_, _узор, _scud, 
   {{0x26dc012d,0x79a7187f,0x6f150369,0x1ddb0249}},	//   davo_, арде, mezc, _बबित, 
   {{0x39442785,0x8c48091f,0xdb0e06df,0x6f152786}},	//   _coms_, _bağı, _libè, lezc, 
   {{0xdc350138,0x27ff0151,0xec350147,0x26dc0528}},	//   _האָט_, _qqun_, _האָר_, favo_, 
   {{0x8c480824,0x6f152787,0x6dbc008b,0xf3fe0086}},	//   _dağı, nezc, _očal, ্টার_, 
   {{0x6b52055f,0x291f2788,0x19ab0f82,0xb34502aa}},	//   _mægl, _taua_, _атап_, _loçã, 
   {{0xb4c30cbd,0xe3bf03da,0x741500eb,0x69c72789}},	//   ्रे_, íño_, موعا, _itje, 
   {{0x69c70f30,0x212004bb,0x26dc008b,0xb3450165}},	//   _htje, _raih_, bavo_, _noçã, 
   {{0xda0e1230,0x26dc01d8,0x4374004f,0x36d4278a}},	//   _सहमत_, cavo_, жуют, _моур, 
   {{0xe69500eb,0x6f150bf1,0xdb0e011c,0xf1d100d3}},	//   _الاد, dezc, _dibè, чөлө, 
   {{0x6721278b,0x8c4807fa,0xf65202a1,0x04c917bc}},	//   _halj, _yağı, _מצב_, _صوتي_, 
   {{0x6721278c,0x63bb0104,0x21670176,0x98790070}},	//   _kalj, qqun, сияи_, ראָט, 
   {{0x2002278d,0x69c7027c,0x6721016a,0x00000000}},	//   rtki_, _otje, _jalj, --, 
   {{0xed5a129d,0x2002278e,0x60dd278f,0x6b6f0009}},	//   гов_, stki_, basm, _mėgė, 
   {{0x26dc2790,0x7afc02fe,0xc21200d1,0x2d680241}},	//   zavo_, _scrt, _זהה_, mşek_, 
   {{0xdca302f1,0x39442791,0x7cf20104,0x6fb20083}},	// [1b20] зати, _roms_, _dаrа, _इंटू, 
   {{0x394409a2,0xb05b014e,0xef1a0886,0x67212792}},	//   _soms_, rbät, _смо_, _nalj, 
   {{0x26010496,0x26dc0009,0x3f8a2793,0xfe752794}},	//   jóo_, vavo_, mobu_, _дүр_, 
   {{0xd91000d6,0xb4c32795,0x69c30038,0x3f8a00da}},	//   بیر_, ्रो_, ínea, lobu_, 
   {{0x7d162796,0xdb0e026a,0x6d46011c,0x2be20cd6}},	//   meys, _libé, _ioka, _पिटा, 
   {{0xa09b0137,0x06d800cc,0x6d462797,0x7d162798}},	//   ניסט, _সাহি, _hoka, leys, 
   {{0x6d462799,0x60c404ef,0x3944279a,0x6dbc0032}},	//   _koka, _ofim, _toms_, _očam, 
   {{0x6d46279b,0x7d16279c,0x26dc279d,0x8c480248}},	//   _joka, neys, savo_, _tağı, 
   {{0x6721024a,0x61e3040c,0x26dc0afc,0x00000000}},	//   _falj, _avnl, pavo_, --, 
   {{0x69c10518,0x8c1b00a7,0x26010183,0x60c405d5}},	//   _élec, נויי, bóo_, _afim, 
   {{0x60c90496,0x611513f2,0x71792336,0x60dd0a9f}},	//   ñemo, одну, ибор_, tasm, 
   {{0x27e00062,0xdb0e0a0f,0x6d46279e,0xd13b279f}},	//   šinu_, _dibé, _noka, ухо_, 
   {{0xc05827a0,0x60dd27a1,0xd4671853,0x7d16027e}},	//   бір_, rasm, _лице_, deys, 
   {{0x3f8a27a2,0x6d462240,0xc05803bd,0x2bdb08c6}},	//   gobu_, _aoka, сію_, मीफा, 
   {{0x6d4627a3,0x6f1508f4,0x75220379,0xdb0e011c}},	//   _boka, rezc, _kaoz, _gibé, 
   {{0x22ae0264,0x2b94128d,0x75220054,0x00000000}},	//   mək_, bäck_, _jaoz, --, 
   {{0x6d930518,0x69c700fb,0x7ff70038,0x752200ca}},	// [1b30] nçai, _stje, _اسعا, _maoz, 
   {{0x6d4601a7,0x75220379,0x8aa70165,0x00000000}},	//   _eoka, _laoz, бред, --, 
   {{0xc8b516d0,0x2bb5009a,0x26010183,0x98b927a4}},	//   ослы, _अंका, xóo_, алет_, 
   {{0x6dbc0062,0x75220187,0x7d1609c7,0x00000000}},	//   _očaj, _naoz, ceys, --, 
   {{0x672114ba,0x261b0081,0xf80700d9,0xf7450080}},	//   _palj, _मनही_, счен, жело, 
   {{0x2fc9012b,0xdb070126,0x27e9203b,0x7bcd27a5}},	//   _mtag_, _fijá, šano_, mpau, 
   {{0x672102f5,0x69c70f30,0x672304d1,0x7c2902fe}},	//   _valj, _utje, rdnj, _šerh, 
   {{0x672123ae,0x22ae0095,0xdb0e211b,0x195800b3}},	//   _walj, dək_, _ribé, _ласы_, 
   {{0xe3b627a6,0x7bcd27a7,0x672127a8,0x27e000eb}},	//   обы_, npau, _talj, áint_, 
   {{0x1957005e,0x98ad0228,0x43690afc,0x798b27a9}},	//   _тағы_, _hneď_, раон_, logw, 
   {{0x44270399,0x2fc901d2,0xd0640248,0x7d160ad9}},	//   _گراف, _atag_, ərəs, yeys, 
   {{0xe4350296,0x164803a1,0x00000000,0x00000000}},	//   _وفاد, _учуп_, --, --, 
   {{0x6d4627aa,0x2bb52360,0x7bcd27ab,0x656b27ac}},	//   _roka, _अंगा, jpau, _imgh, 
   {{0x6d4627ad,0xbf9b03b7,0x83fd0019,0x2b940219}},	//   _soka, stên, rződ, räck_, 
   {{0x22ae0264,0xdb0e055a,0x3f8a026e,0x614603dc}},	//   cək_, _bibî, robu_, _мека, 
   {{0xed570104,0xb05b02ae,0x68e900d7,0x2b940502}},	//   оос_, rbär, _nded, päck_, 
   {{0x6d4627ae,0xdb0e078a,0x0b4603dc,0x7d1627af}},	// [1b40] _voka, _dibî, онан, reys, 
   {{0x6d4627b0,0x68e927b1,0x786601ff,0x290d0474}},	//   _woka, _aded, _dаvl, _abea_, 
   {{0x32050056,0x6d4627b2,0x1d0a03a1,0xc8ca27b3}},	//   ntly_, _toka, _кени_, لوان_, 
   {{0xc27a0070,0x25ef009a,0x798b27b4,0x00000000}},	//   ברעי, ींनी_, gogw, --, 
   {{0x88162751,0x68e927b5,0x6dbc0228,0x3ce0006d}},	//   تباط, _dded, _očak, maiv_, 
   {{0x05ea27b6,0xe3a704bc,0x75220054,0x68e90216}},	//   афии_, _زر_, _saoz, _eded, 
   {{0xd6d927b7,0xda0e07cc,0xd5b727b8,0x7522023a}},	//   сті_, _सहित_, осы_, _paoz, 
   {{0x7c291993,0xca640148,0x00000000,0x00000000}},	//   _šeri, _деҳқ, --, --, 
   {{0x8d5b0070,0x00000000,0x00000000,0x00000000}},	//   יכקי, --, --, --, 
   {{0xc7b9010e,0x3ce00201,0x46a6012d,0xd7640296}},	//   _erős_, haiv_, _дазв, _عنای, 
   {{0x2c060086,0x2b9401c4,0x20120237,0x7522023a}},	//   রিয়ে_, räch_, _apyi_, _taoz, 
   {{0x81bc0bc3,0x22ae06d0,0x6dbc0242,0x9cfc0033}},	//   lvēk, rək_, _ečak, ঁজুন_, 
   {{0x22ae0248,0x320500df,0x69c802be,0x00000000}},	//   sək_, atly_, _édef, --, 
   {{0x6d9327b9,0xdefb27ba,0x7c3b00b9,0x389b0147}},	//   nçav, шым_, _àuri, ייכנ, 
   {{0xd25000eb,0x320527bb,0x6d580009,0x20120118}},	//   _سنة_, ctly_, _įvar, _epyi_, 
   {{0x395d006d,0x6ecb0fc0,0x8d77010e,0x7bcd115b}},	//   xhws_, _त्रु, زازا, tpau, 
   {{0x4c9400c8,0x0cab27bc,0x2fc90175,0x9b59035b}},	// [1b50] дитс, ртви_, _utag_, биат_, 
   {{0x7bcd27bd,0x399c003e,0x88d70033,0x00000000}},	//   rpau, vísa_, _হাইক, --, 
   {{0x391516a0,0x7bcd012d,0x0a681da4,0x998702d9}},	//   змер, spau, орци_, ínů_, 
   {{0x28f827be,0x9b45009c,0x7bcd0080,0x628e0083}},	//   жець_, _کنسو, ppau, żbow, 
   {{0x798b27bf,0xdd3a00d1,0x5d3a00d1,0x3d3a00d1}},	//   rogw, _הערכ, _התרא, _הגרס, 
   {{0x9a87217e,0x798b016c,0x70b708dd,0xc87904a8}},	//   _дубл, sogw, ःशुल, _neşe_, 
   {{0xd90f006b,0x6446033d,0xe6190176,0xb9010033}},	//   _لیا_, äkin, ёди_, _দা_, 
   {{0xea0000e7,0xab5b0502,0x6d9302be,0x78660104}},	//   _hiếp_, _stüh, açav, _mаvj, 
   {{0x657e026a,0xb7d5009c,0xea000023,0xf3f10038}},	//   épha, _رقاب, _kiếp_, رأة_, 
   {{0x0cb80ed3,0xdce40241,0x6d5a0243,0x00000000}},	//   _अल्म, kniğ, ītai, --, 
   {{0x23290258,0x00000000,0x00000000,0x00000000}},	//   _ҳоли_, --, --, --, 
   {{0x9f42031e,0xe29927c0,0xf8cb017d,0x320500df}},	//   mské_, _қай_, ाडिय, rtly_, 
   {{0x9f42037f,0x44290c7c,0x659a008d,0x23290962}},	//   lské_, _éa_, _פינק, _голи_, 
   {{0x442f0508,0x00000000,0x00000000,0x00000000}},	//   _irg_, --, --, --, 
   {{0x9f42035e,0x6da627c1,0x2bb5000f,0x442f02a2}},	//   nské_, зива, _अंजा, _hrg_, 
   {{0x442f0870,0xf8b900e7,0xc692027a,0x657b27c2}},	//   _krg_, _ngũ_, גאל_, nnuh, 
   {{0x27e927c3,0xaaba08cb,0xf3f900b3,0x81a501c9}},	// [1b60] šanj_, مدار_, nuţ_, _تحول, 
   {{0x8b2317fc,0xed160035,0xdb1d0216,0x8b26012d}},	//   ндуе, _łódź_, _husê, ядзе, 
   {{0x9f42014b,0x7c2f27c4,0xbed70225,0x69da0038}},	//   jské_, _ercr, _מויז_, صباح_, 
   {{0xa6d80086,0x9f420356,0xf99227b3,0x00000000}},	//   _সাইট, dské_, ربا_, --, 
   {{0x181800c5,0x98a627c5,0x28cb27c6,0x00000000}},	//   تراک_, чиде, ाड़ि, --, 
   {{0xbb4a0084,0x7bcb2772,0x569427c7,0x00000000}},	//   _الآن_, ígue, малт, --, 
   {{0x442f03d8,0x6d93010c,0xfaa60148,0xdb0f019c}},	//   _arg_, rçav, _хаво, _sucç, 
   {{0x6d4427c8,0x442f085f,0xd90d0a24,0xceb3042c}},	//   njia, _brg_, _نیم_, עיה_, 
   {{0x9f59022b,0x68e201a7,0x00000000,0x00000000}},	//   ltså_, maod, --, --, 
   {{0x442f08a1,0x325427c9,0x68e20364,0xdb1d0165}},	//   _drg_, двор, laod, _ausê, 
   {{0x442f0285,0x6d5602a5,0x27e627ca,0x98bf008a}},	//   _erg_, kkya, lson_, _qmuħ_, 
   {{0x26de06e4,0x463b00c7,0x68e227cb,0x55bb0486}},	//   _heto_, _לעבע, naod, _המאו, 
   {{0x26de00e5,0x24aa0086,0x62830369,0xbf9b019c}},	//   _keto_, _গ্রহ, _exno, stêm, 
   {{0x27e60518,0xd37000c5,0xbf9b0107,0x23270080}},	//   ison_, _جهت_, ptêm, _ночи_, 
   {{0x2cb9016a,0x80dc0086,0x6b5b0218,0x26de27cc}},	//   _pgsd_, _ভার্, _nîga, _meto_, 
   {{0x26de27cd,0x5d9900e4,0x6d44021e,0xebd900fd}},	//   _leto_, ікаў_, gjia, ждаш_, 
   {{0x68e227ce,0x27e60ab4,0x7bc00212,0x61fa27cf}},	// [1b70] daod, json_, _émul, lutl, 
   {{0x6d5f0c67,0x8aa70cd9,0x6d5627d0,0x32130083}},	//   shqa, пред, akya, łbyś_, 
   {{0x98bf00d9,0x61fa27d1,0x6b5b0218,0xdd91029a}},	//   _nouă_, nutl, _cîga, _لود_, 
   {{0x1a68040f,0x9f42026e,0xdb0627d2,0x0dba0019}},	//   سیقی_, vské_, _zukü, _گئیں_, 
   {{0x26de27d3,0xea0000f7,0xbcfb0068,0x7d0d27d4}},	//   _beto_, _tiếp_, _alég, mfas, 
   {{0x9f420076,0x7c2d27d5,0xe7360eb0,0x61fa0364}},	//   tské_, mvar, деш_, kutl, 
   {{0x442f27d6,0x26de0065,0xa3df02ab,0x6286010c}},	//   _srg_, _deto_, धीन_, şkoj, 
   {{0x7d0d27d7,0x98bf002e,0x9f42063b,0xd4d90769}},	//   nfas, _două_, rské_, цькі_, 
   {{0xb4bd02f8,0x7c2d27d8,0xdc0b0086,0xbcfb0019}},	//   _आली_, nvar, রিকস_, _elég, 
   {{0x04ff0086,0xdb1d0219,0x9f4200bc,0xa774012d}},	//   ্যের_, _utsä, pské_, _злуч, 
   {{0x6d5d27d9,0x61fa124a,0x7c2d27da,0xbcfb011c}},	//   _olsa, gutl, hvar, _kléd, 
   {{0x442f0688,0xdb060068,0x6560161c,0x7d0d039b}},	//   _trg_, _yukó, chmh, jfas, 
   {{0x442f27db,0x7d0d27dc,0x995c0ed0,0x7c2d0604}},	//   _urg_, dfas, níš_, jvar, 
   {{0xdfcf0084,0x442d27dd,0x61fa27de,0x6d5d27df}},	//   شيف_, mve_, butl, _alsa, 
   {{0x7d0d27e0,0x7c2d0009,0x78bb0539,0x00000000}},	//   ffas, evar, _oguv, --, 
   {{0x752927e1,0x78bb086d,0x6da327e2,0x6d56012b}},	//   ndez, _nguv, виса, ukya, 
   {{0x7c2d27e3,0x442d27e4,0xdced27e5,0x8eba00b3}},	// [1b80] gvar, nve_, znać, _мынт_, 
   {{0xa3df0586,0xeb9f00dd,0x995c014b,0xda660038}},	//   धीय_, _spør_, díš_, واضي, 
   {{0x442d27e6,0x7c2d27e7,0x69c1010e,0xdb1d01e5}},	//   hve_, avar, _élel, _musè, 
   {{0x98a027e8,0x6f1c27e9,0x26de27ea,0xfbc627eb}},	//   žič_, lerc, _seto_, _обмо, 
   {{0xa3f80086,0x442d00e5,0x8b660274,0x75290036}},	//   _অন্য_, jve_, _قاسم, ddez, 
   {{0x27e60673,0xdb07010c,0x644600b0,0x442d27ec}},	//   rson_, _mijû, äkim, dve_, 
   {{0xe1e70105,0x442d27ed,0x26de27ee,0x27e627ef}},	//   _جس_, eve_, _veto_, sson_, 
   {{0x6f1c27f0,0xfaa303dc,0x98a600d3,0xbcfb011c}},	//   herc, _расо, _жибе, _gléd, 
   {{0x26de27f1,0xea0000e7,0x15ea09ef,0x33270175}},	//   _teto_, _khắp_, _टिकर_, _banx_, 
   {{0x6d9327f2,0x68e027f3,0x61fa27f4,0xbf9b0218}},	//   nçar, _hemd, tutl, rtêk, 
   {{0x442d27f5,0x68e00e34,0x7d0d27f6,0xf7430b68}},	//   ave_, _kemd, yfas, _шефо, 
   {{0x442d27f7,0x68e000ef,0x394627f8,0xf8de04cc}},	//   bve_, _jemd, njos_, मरिय, 
   {{0x394602aa,0x6f1c27f9,0x672827fa,0x00000000}},	//   ijos_, ferc, _kadj, --, 
   {{0x6f1c27fb,0x61fa27fc,0x399527fd,0xdb070216}},	//   gerc, putl, låst_, _dijû, 
   {{0x672800e5,0x7d0d132f,0x6e9427fe,0xbf9b019c}},	//   _madj, tfas, виру, ntêi, 
   {{0xbcfb27ff,0x67282800,0xfe7703a1,0x2fc003dd}},	//   _amér, _ladj, зүү_, _fuig_, 
   {{0x7d0d2801,0x6f1c2802,0xdd942803,0xe81e12e3}},	// [1b90] rfas, berc, таты, _मैला_, 
   {{0x6f1c2804,0x672811ed,0x38662805,0x7d0d2806}},	//   cerc, _nadj, dzor_, sfas, 
   {{0x442d2807,0x2bdf1779,0x25a600b4,0x69dc03c6}},	//   zve_, _पौरा, _ohol_, _cwre, 
   {{0xb4bd02f8,0x8aa41c8e,0x63b82808,0xdb1d2809}},	//   _आले_, труд, _livn, _musé, 
   {{0xe739280a,0x27e9280b,0xdd91006b,0xc879010c}},	//   зел_, éan_, _لوگ_, _beşa_, 
   {{0x25a60019,0x2129085b,0x442d280c,0x2904008a}},	//   _ahol_, _laah_, vve_, _ecma_, 
   {{0xf7700625,0x995c0076,0x7ae5280d,0xe61113b4}},	//   جان_, síš_, maht, اشت_, 
   {{0x442d280e,0x6f1c0076,0x6934280f,0x94252810}},	//   tve_, zerc, _инсу, емие, 
   {{0x442d2811,0x291d2812,0x75290019,0x96ca047c}},	//   uve_, mewa_, rdez, _स्कॉ, 
   {{0x291d086d,0x1b1d00cc,0x6298018c,0x13092813}},	//   lewa_, নাকে_, _byvo, чной_, 
   {{0x63b8044e,0x442d2814,0x6f1c1240,0x395f2815}},	//   _divn, sve_, verc, _klus_, 
   {{0x2fc003a1,0x291d0204,0x2129002c,0x61460afc}},	//   _puig_, newa_, _caah_, хема, 
   {{0x25ad2816,0x394d0691,0xdbd71eab,0x442d0034}},	//   mmel_, _moes_, _jäät, qve_, 
   {{0x7ae51415,0x291d187e,0x63b82817,0x2bb20118}},	//   jaht, hewa_, _givn, _gņch_, 
   {{0x291d2818,0x38662819,0x62980028,0xdbd700c2}},	//   kewa_, zzor_, _gyvo, _läät, 
   {{0xa0a6281a,0x2fc01272,0xb4bd009a,0x2129011c}},	//   _пайд, _tuig_, _आलो_, _gaah_, 
   {{0xac8605d9,0x291d281b,0x2bdb031e,0xbcfb023e}},	// [1ba0] хгал, dewa_, मीला, _bléb, 
   {{0x395f281c,0xe6250029,0x6b5202c9,0x31720098}},	//   _alus_, _đông_, _nægt, _hmyz_, 
   {{0x6728281d,0x68e0281e,0xfce6281f,0x212902a2}},	//   _radj, _pemd, _поно, _yaah_, 
   {{0x8c462820,0x672802ee,0xab5b0380,0x02b60070}},	//   _земе, _sadj, _stüt, גלעך_, 
   {{0x394d2821,0x67282822,0xea000023,0x2d802823}},	//   _does_, _padj, _thắp_, mnie_, 
   {{0x2d80006a,0x69dc02aa,0x395f2824,0x96f82825}},	//   lnie_, _twre, _elus_, фект_, 
   {{0xfaa3196c,0x56932826,0x395f003d,0x2d801c96}},	//   _баро, лашт, _flus_, onie_, 
   {{0x291d0666,0x248603da,0xa5341297,0x2d802827}},	//   cewa_, _pxom_, тнич, nnie_, 
   {{0x63b82828,0x21290054,0x2d802829,0x2bb20118}},	//   _pivn, _raah_, inie_, _pņch_, 
   {{0x7c3b20ac,0x2d80282a,0x3f850a1a,0xd62a02a0}},	//   _áure, hnie_, čluk_, _нозе_, 
   {{0x7d060750,0x3f91282b,0xd2571d98,0x63b80201}},	//   _ocks, vozu_, еця_, _vivn, 
   {{0x25d909e8,0xea0000f7,0x7c26282c,0x629805a8}},	//   _آهنگ_, _nhập_, _oskr, _vyvo, 
   {{0x2d80006a,0xe5a31918,0x00000000,0x00000000}},	//   dnie_, _сици, --, --, 
   {{0x4426282d,0x2d8000ab,0x21291694,0x291d282e}},	//   _iso_, enie_, _waah_, zewa_, 
   {{0xbe88282f,0x59b02830,0x3da72831,0x31600036}},	//   есте_, जगार, ераб, _fliz_, 
   {{0x2d802832,0x44262833,0x2d922834,0xdd940079}},	//   gnie_, _kso_, goye_, гасы, 
   {{0x44260097,0x7ae514b9,0xbcfb0096,0x60cd01a7}},	// [1bb0] _jso_, taht, _aléc, _ifam, 
   {{0x6d5a078e,0x2d800035,0x6e250226,0x63ad0036}},	//   ëtar, anie_, _tshb, _èant, 
   {{0xf7711fdb,0x395f2376,0x6e2500cf,0x2d92024d}},	//   یات_, _plus_, _ushb, boye_, 
   {{0xdbd7030f,0x442602ba,0x2d8000ab,0xd879247b}},	//   _päät, _oso_, cnie_, ومات_, 
   {{0xb8e90081,0xbcfb1056,0x7ae5030f,0x291d2835}},	//   _ईल_, _eléc, paht, rewa_, 
   {{0x394d018c,0x291d2836,0x6d4f01f0,0xbcfb0212}},	//   _woes_, sewa_, _hoca, _fléc, 
   {{0x44262837,0x291d21a3,0x6d4f2838,0x6b52055f}},	//   _aso_, pewa_, _koca, _vægt, 
   {{0x741503b1,0x1da7093a,0x44262839,0xdb08039f}},	//   نوعا, _कीमत, _bso_, ülöt, 
   {{0xc9840e65,0x26cc0026,0x42d5012d,0xe4c80195}},	//   _сури, _ffdo_, кіну, ربين_, 
   {{0x2d80283a,0x6b52003e,0x98740009,0xdd020082}},	//   znie_, _hægr, _слуц, _čučk, 
   {{0x4426283b,0x96ca047c,0x36d40088,0x3160035f}},	//   _eso_, _स्टॉ, _сохр, _pliz_, 
   {{0x27e90bc3,0x2902014e,0x6dbc100c,0x6aba0313}},	//   šanu_, _ökat_, _očar, _útfe, 
   {{0xd24e00d6,0x44260144,0xdb150216,0x2d920106}},	//   منی_, _gso_, _rizî, voye_, 
   {{0x7bc00165,0x3ebe004f,0x2d801af1,0x636400b9}},	//   _émui, øtt_, wnie_, _cònd, 
   {{0x6d4f283c,0xdee3283d,0x2d80006a,0xfce60152}},	//   _boca, роси, tnie_, ково, 
   {{0x2bc3283e,0xc5f200c7,0xab640241,0x2b140e6e}},	//   _वंशा, ידל_, zlüğ, न्नु_, 
   {{0x2d80283f,0x2d92007c,0x81bc0243,0x00000000}},	// [1bc0] rnie_, roye_, svēt, --, 
   {{0x998d2840,0xab5b0380,0x2d800035,0x6d4f0354}},	//   _češ_, _stür, snie_, _eoca, 
   {{0x6d4f0084,0x6dbc02ee,0xea0000e7,0xeb9702a6}},	//   _foca, _včas, _thập_, њих_, 
   {{0x6d4f1f57,0x00000000,0x00000000,0x00000000}},	//   _goca, --, --, --, 
   {{0xf7460316,0x7c260062,0x6e932841,0x00000000}},	//   кедо, _uskr, _ملیا, --, 
   {{0x7d042842,0x6d4f00e9,0x636403a0,0x7c242843}},	//   lgis, _zoca, _kòne, mwir, 
   {{0x27ed0056,0x752b0082,0xab6401f0,0x439400f0}},	//   _even_, _bagz, rlüğ, ғанс, 
   {{0x59b40a31,0x6d4f2844,0x00000000,0x00000000}},	//   _сөзс, _xoca, --, --, 
   {{0x7c240380,0x27ed0304,0x7bd6012b,0xfbdf009e}},	//   nwir, _gven_, npyu, _xwê_, 
   {{0x4426008b,0x60cd02a3,0xe8f901a2,0x80dc0033}},	//   _vso_, _sfam, _олӣ_, _ভাগ্, 
   {{0x21790b58,0xd5af2845,0x7c242846,0xa2660093}},	//   ейны_, _вс_, hwir, тъпл, 
   {{0x442601c1,0x7c242847,0x925700c8,0xd5e90038}},	//   _tso_, kwir, тают_, _أعلن_, 
   {{0x656201ff,0x250b010e,0x81bc0243,0x7520025b}},	//   _iloh, _آرمی_, tvēs, memz, 
   {{0x65622848,0x69c102a3,0x7c24044d,0x64a30bad}},	//   _hloh, _èleg, dwir, _тача, 
   {{0xd378090e,0xf1a72849,0xbcfb0107,0x3135284a}},	//   mić_, _ирин, _aléa, _бейр, 
   {{0x798200ab,0x7d04284b,0x9f59026e,0x2d5502c9}},	//   jnow, ggis, musí_, _nået_, 
   {{0x6c54284c,0x7c24030b,0x65620372,0x9f59001d}},	// [1bd0] акту, gwir, _mloh, lusí_, 
   {{0x7d04284d,0x76580080,0x3179284e,0xf0e30083}},	//   agis, kyvy, lisz_, _ख़ुद_, 
   {{0x3f83090e,0xdb050084,0x27ed284f,0x65622850}},	//   mnju_, gmhá, _sven_, _oloh, 
   {{0xd3780519,0x6d4f00ef,0x7c24024d,0x9f420356}},	//   hić_, _uoca, bwir, mská_, 
   {{0xd37803ef,0x9f4205a8,0xbcfb0038,0x4424006d}},	//   kić_, lská_, _gléa, jwm_, 
   {{0xd37800f1,0x65622851,0x66e203dc,0x490800a5}},	//   jić_, _aloh, боша, _हाथो_, 
   {{0xd37800f1,0x9f420076,0x2d5501cc,0x95c5009c}},	//   dić_, nská_, _fået_, ديبه, 
   {{0xdb1d08d7,0x2d5501cc,0xb8b3004e,0x661a0640}},	//   _musí, _gået_, _көлі, _dptk, 
   {{0x3f830eae,0x65622852,0xe70500d7,0x00000000}},	//   knju_, _dloh, _مسای, --, 
   {{0xd3780519,0x2902014e,0x656224b8,0x3f83044e}},	//   gić_, _ökar_, _eloh, jnju_, 
   {{0x3f8300f1,0xdb1c0218,0x9f420377,0xc0e62853}},	//   dnju_, _birê, jská_, лонк, 
   {{0x741200d4,0x9f42014b,0xd4350a7c,0x7c240218}},	//   جویا, dská_, _معتب, ywir, 
   {{0xdb1c078a,0xd3782854,0xa3df22f8,0x7d041bcc}},	//   _dirê, bić_, धीश_, vgis, 
   {{0xd37800ab,0x2d992855,0x3f830372,0x23261cc1}},	//   cić_, _akse_, gnju_, _боши_, 
   {{0x31790035,0xa3df1d57,0x79820035,0x81bd01dd}},	//   bisz_, धीर_, ynow, rvēr, 
   {{0xdb1c078a,0x2d960b58,0x7c242856,0x81bd01dd}},	//   _girê, ургс, twir, svēr, 
   {{0x09cc00a2,0x3f831a35,0x9db9004e,0x6da31ab6}},	// [1be0] ाऱ्य, bnju_, тыру_, сита, 
   {{0x7c242857,0xfbcd0086,0xdb1d11c9,0x98a401dd}},	//   rwir, _লিখত, _fusí, _namā_, 
   {{0xe8fa2858,0x20022859,0x7c24285a,0xed5a285b}},	//   еле_, luki_, swir, _зон_, 
   {{0xd378285c,0x786a0019,0x88e600c8,0xd7ea00f0}},	//   zić_, _növé, ужде, емде_, 
   {{0x2002285d,0xe3c800e7,0x4424006d,0x7982285e}},	//   nuki_, _mực_, xwm_, rnow, 
   {{0xe3c80029,0xdb1c00e5,0x79820083,0x2d5500fb}},	//   _lực_, _mirë, snow, _fåes_, 
   {{0xd37800f1,0x6b63285f,0xd6d92860,0xb90a00cc}},	//   vić_, _укра, тті_, _মা_, 
   {{0x7bc62861,0x3f830d26,0x1db402f8,0xd37800ab}},	//   _kuku, znju_, ंगित, wić_, 
   {{0xd37802f5,0x7bc62862,0xe64403c0,0xa3df00a2}},	//   tić_, _juku, ılığ, धील_, 
   {{0x20022863,0x7bc62864,0x44240156,0x52142865}},	//   duki_, _muku, rwm_, адот, 
   {{0xd37802f5,0x7bc62866,0x3f832867,0xe3c80023}},	//   rić_, _luku, vnju_, _bực_, 
   {{0x40351c0f,0xe3c80029,0x9f42026e,0xf1ab00c5}},	//   аемс, _cực_, vská_, عاده_, 
   {{0x3f83003a,0x7bc62868,0x69c1026a,0xf59300eb}},	//   tnju_, _nuku, _élev, _النج, 
   {{0x9f42026e,0x317900ab,0x00000000,0x00000000}},	//   tská_, sisz_, --, --, 
   {{0x3179006a,0x3f830112,0x539b027a,0x7bc62869}},	//   pisz_, rnju_, _ריוו, _auku, 
   {{0x7bc6286a,0x3f83090b,0x9f42026e,0x27e00098}},	//   _buku, snju_, rská_, šiny_, 
   {{0x7bc6286b,0x3f831799,0x6b7500f0,0xab75286c}},	// [1bf0] _cuku, pnju_, алау, агаш, 
   {{0x7bc6286d,0x9f4202d9,0x332e00c3,0xa3e608dd}},	//   _duku, pská_, _jafx_, यीय_, 
   {{0xfaa711f9,0x2b141d11,0x0b88286e,0x8aa7286f}},	//   ушан, न्धु_, усти_, урад, 
   {{0xdc34026e,0x3835016e,0x2d9900c2,0xa3ab00aa}},	//   _zúča, инер, _ukse_, _कीन_, 
   {{0x7bc62870,0x3b0a00b9,0x6d4d2871,0x00000000}},	//   _guku, _fcbq_, mjaa, --, 
   {{0x6d4d2872,0x29060a9f,0x2b140527,0x28d51e7b}},	//   ljaa, agoa_, न्दु_, _ड्रि, 
   {{0x7bc601c4,0xd0560095,0xf1c900e7,0xcf5800a7}},	//   _zuku, _deyə, _mạc_, רבות_, 
   {{0x6d4d177f,0xf1c90029,0x69d501ca,0xdb1d02aa}},	//   njaa, _lạc_, _itze, _fusã, 
   {{0x7bc60508,0x68eb1ae0,0x7ae72873,0xe3c800e7}},	//   _xuku, magd, _kejt, _rực_, 
   {{0x69c72874,0x68eb042a,0xdced0384,0x466b004f}},	//   _kuje, lagd, ynağ, _прем_, 
   {{0x216a2875,0x67231db4,0x7ae72876,0x75d100e0}},	//   вини_, menj, _mejt, _bāze, 
   {{0x69c703ed,0x672302ee,0xdc340187,0x68eb0c3d}},	//   _muje, lenj, _súča, nagd, 
   {{0x66032877,0xe3c80029,0xf1c9001b,0xb4d100a2}},	//   lunk, _vực_, _bạc_, वडी_, 
   {{0x7bc62878,0xdee32879,0x6723287a,0x2002287b}},	//   _ruku, жори, nenj, ruki_, 
   {{0x7bc6287c,0x13da00cc,0x200204bb,0x6603287d}},	//   _suku, _দিয়, suki_, nunk, 
   {{0x7bc6287e,0x6723287f,0x6446014e,0x6d4d2880}},	//   _puku, henj, åkig, gjaa, 
  
   {{0x672307a1,0x64490496,0x69d502ba,0x66032881}},	// [1c00] kenj, nxei, _atze, hunk, 
   {{0x66032882,0xaaba0a24,0x65692883,0x7bc62884}},	//   kunk, ندار_, hheh, _vuku, 
   {{0x7ae72885,0x69c704d1,0x672306e0,0x6da62886}},	//   _dejt, _cuje, denj, _вина, 
   {{0x7bc62887,0xe3c8001b,0xdb0f2888,0xd7fa012d}},	//   _tuku, _lựa_, _bucó, вук_, 
   {{0x29062889,0x3860288a,0x65690548,0x7bc6288b}},	//   rgoa_, áir_, dheh, _uuku, 
   {{0x6723288c,0x78a900ef,0x3f98288d,0x7ae7288e}},	//   genj, _dzev, noru_, _gejt, 
   {{0x25fd288f,0x9f590107,0xb4d1009a,0xa2c402ff}},	//   रंगी_, ursé_, वडू_, रशस्, 
   {{0x3f98031e,0xdb1c2890,0xa6e9001b,0x7ae72891}},	//   horu_, _sirè, _ngươ, _zejt, 
   {{0x67232892,0xdb072893,0x69c700ef,0xe3c800e7}},	//   benj, _gijó, _zuje, _bựa_, 
   {{0x4aaa2894,0x672300f1,0x69c02895,0x60c42896}},	//   _कराव, cenj, _hime, _agim, 
   {{0x69c1006b,0x69c02897,0xe3c800e7,0xc1b90148}},	//   _élet, _kime, _dựa_, ллох_, 
   {{0x50672898,0xf1c900e7,0x69c02899,0x2c5e00e0}},	//   атга, _sạc_, _jime, _kādā_, 
   {{0x938a0141,0x8ca20b79,0x69c0289a,0xb4c203c1}},	//   _иска_, _खरगो, _mime, ंशी_, 
   {{0x69c0289b,0x3f98090b,0x09d70086,0x6d4d012e}},	//   _lime, goru_, _হিসা, wjaa, 
   {{0x7ae7289c,0xdef800e4,0xa187134f,0x9ce7289d}},	//   _rejt, шыя_, _выпл, ицал, 
   {{0x69c0289e,0x672300d2,0x69c7007c,0x7ae7289f}},	//   _nime, zenj, _ruje, _sejt, 
   {{0x69c728a0,0x6d4d28a1,0x660328a2,0x672328a3}},	// [1c10] _suje, rjaa, zunk, yenj, 
   {{0x69c028a4,0x6d4d28a5,0xaad2059e,0x69c700b9}},	//   _aime, sjaa, दुलक, _puje, 
   {{0x69c028a6,0x672328a7,0xdb0f00b9,0xc879020f}},	//   _bime, venj, _bucò, _ieşi_, 
   {{0x98a9090e,0xdb0f0126,0x69c700ca,0xc9841137}},	//   žač_, _pucó, _vuje, оучи, 
   {{0x7ae70039,0x67230121,0xe8f828a8,0x68eb0c3d}},	//   _tejt, tenj, рлі_, ragd, 
   {{0x2fc901c1,0x69c728a9,0x660328aa,0xa7a90235}},	//   _muag_, _tuje, tunk, ыкла_, 
   {{0x6723090b,0x2fc901c1,0xdb1c0218,0x65690364}},	//   renj, _luag_, _kirî, theh, 
   {{0x67230571,0x660328ab,0x99850084,0x799b28ac}},	//   senj, runk, _الرو, _ukuw, 
   {{0x681a00e0,0x672328ad,0x660328ae,0xdb1c28af}},	//   gādā, penj, sunk, _mirî, 
   {{0x69c01c6c,0x656928b0,0x68e901b8,0xb4e60035}},	//   _zime, sheh, _heed, _बड़ी_, 
   {{0xb635024f,0x657b28b1,0x644600c8,0x68e900c2}},	//   _دفاع, piuh, äkir, _keed, 
   {{0x68e90379,0x65690226,0xdb1c0151,0x3f980083}},	//   _jeed, qheh, _viré, woru_, 
   {{0x3438017a,0x68e928b2,0x2fc901a0,0xe3c800e7}},	//   _پسند_, _meed, _cuag_, _tựa_, 
   {{0x50d80c94,0x98a008b1,0x68e928b3,0xdb1c0212}},	//   _भ्रष, žić_, _leed, _tiré, 
   {{0xdb1c010c,0xc87900d9,0xbcfb0212,0xdee600a3}},	//   _birî, _deşi_, _elém, _қони, 
   {{0xbf9b02a0,0x68e900a7,0x3f9828b4,0xc6920070}},	//   quên, _need, soru_, פאן_, 
   {{0x69c028b5,0x26c500ef,0x3f9828b6,0x7ff628b7}},	// [1c20] _rime, _oglo_, poru_, _اسبا, 
   {{0x69c01fc8,0x290d00d9,0x2b4300f6,0x6d4b02ae}},	//   _sime, _acea_, _cnjc_, ögar, 
   {{0xcf570052,0xe80a0081,0x69c019c2,0x0f5700c7}},	//   _הבית_, हूना_, _pime, _היים_, 
   {{0xdb1c055a,0xb4e60b3e,0x2fc9023b,0xea000023}},	//   _girî, _बजे_, _yuag_, _nhấp_, 
   {{0x69c028b8,0x68e928b9,0x00000000,0x00000000}},	//   _vime, _deed, --, --, 
   {{0xaa4628ba,0xb4c202e6,0x681a0243,0x98a40028}},	//   _легл, ्ड्_, vādā, _namą_, 
   {{0x69c028bb,0x68e928bc,0x6b6328bd,0x1b7b00c7}},	//   _time, _feed, _экра, _עטלע, 
   {{0xf3f800cf,0xea00001b,0xbcfb0126,0xf8b813c3}},	//   аниш_, _chấp_, _aléj, _көл_, 
   {{0x78661e16,0x7c290097,0xb4c200bc,0x00000000}},	//   _указ, _šerz, ्डौ_, --, 
   {{0x681a002a,0x2fc928be,0x68e901d2,0x00000000}},	//   rādā, _ruag_, _zeed, --, 
   {{0x6b9b00c7,0xcb9b07e4,0x21320175,0xbcfb023e}},	//   רשיד, רסיט, _bayh_, _slém, 
   {{0x2fc901a0,0xe5720411,0xbcfb011c,0x216728bf}},	//   _puag_, _عطا_, _plém, стог, 
   {{0x2fc9006d,0xf8ba0fc0,0x91ca00c6,0x00000000}},	//   _quag_, ेशिय, _संवै, --, 
   {{0x2fc9006f,0x995c02d9,0x25ef009a,0x00000000}},	//   _vuag_, jíž_, ींची_, --, 
   {{0xf1c90029,0x995c02d9,0xdbd109c7,0x234b0eb7}},	//   _hạn_, díž_, _küçe, _حسنی_, 
   {{0x2fc928c0,0x0dc828c1,0xf1c90108,0x00000000}},	//   _tuag_, сури_, _kạn_, --, 
   {{0x68e928c2,0xd05d06d0,0x636d28c3,0x00000000}},	// [1c30] _reed, yasə, _dúnf, --, 
   {{0xf1c900e7,0x68e928c4,0xdb1c010c,0x00000000}},	//   _mạn_, _seed, _wirî, --, 
   {{0x9d1900d9,0x6aba01d5,0x79990326,0x68e928c5}},	//   _конт_, _útfl, toww, _peed, 
   {{0xbcfb00bc,0x9f520118,0x8ed81c03,0xad271c03}},	//   _mlék, _avyè_, _پذیر_, _اردو, 
   {{0x26060f63,0xf1c9001b,0xbae80086,0x31690588}},	//   सूसी_, _nạn_, _পারছ, _mlaz_, 
   {{0xe7391e54,0x7c2f048a,0x45d525b3,0xaded00a5}},	//   рек_, _iscr, оцит, _जबान_, 
   {{0x636d21dc,0x68e900b0,0x27e001dd,0x00000000}},	//   _húng, _teed, ģina_, --, 
   {{0xf1c90124,0xf7730f1c,0xf1cf031e,0x160b0035}},	//   _bạn_, _کار_, _संबन, संबर_, 
   {{0x25fd0d4f,0xf1c90023,0x7c3b00ca,0x6d5a0151}},	//   रूजी_, _cạn_, _šurj, êtai, 
   {{0x6d9328c6,0x3205014b,0x437406ba,0xf2c500d3}},	//   lħad, tuly_, зуют, өсүн, 
   {{0xea00001b,0x2d890e34,0xe12628c7,0x31690604}},	//   _thấp_, knae_, омни, _blaz_, 
   {{0x261303b7,0x24190088,0x10a621f9,0x61fc28c8}},	//   mão_, _воды_, жимн, árla, 
   {{0x261303b7,0xafe302f1,0x442928c9,0x00000000}},	//   lão_, моял, _èa_, --, 
   {{0x88ba00a7,0x5334147d,0xfe4628ca,0xbcfb0096}},	//   יזרי, _нечт, онго, _flék, 
   {{0x3ebe28cb,0x443d28cc,0x26130165,0x3eac0453}},	//   ätt_, _hrw_, não_, ådt_, 
   {{0x2d8902a2,0x9f420228,0x3cf600c2,0xf1c90023}},	//   gnae_, nskú_, ेलें_, _hạo_, 
   {{0x26130165,0x636d007a,0xdca328cd,0x00000000}},	// [1c40] hão_, _cúng, дати, --, 
   {{0x443d033c,0x8a3a0080,0x636d0354,0x670e2002}},	//   _mrw_, ияет_, _dúng, _साधक_, 
   {{0x442f02a2,0x26130165,0x2d9e0107,0xf1c900e7}},	//   _lsg_, jão_, îtes_, _mạo_, 
   {{0x261303b7,0x8c46156b,0x443d01b8,0x9f42020b}},	//   dão_, _деме, _orw_, jskú_, 
   {{0x274a00be,0x6d4628ce,0x443d28cf,0x00000000}},	//   ичко_, _inka, _nrw_, --, 
   {{0x29d700c3,0x261302aa,0xf1c90108,0xa09b027a}},	//   _bħad_, fão_, _rạn_, סיסט, 
   {{0x261302a0,0xf1c9001b,0xfaa300a3,0x356a28d0}},	//   gão_, _sạn_, _жаро, ирин_, 
   {{0x545428d1,0xf1c90108,0x69de0080,0x442f28d2}},	//   звит, _pạn_, mppe, _bsg_, 
   {{0x68e228d3,0xf1c900e7,0x186728d4,0xe947009c}},	//   mbod, _bạo_, _дати_, _ظرفی, 
   {{0x2d6801f0,0x26130165,0xf1c90023,0x68e2004f}},	//   rşey_, bão_, _vạn_, lbod, 
   {{0x261302a0,0x31690a95,0x29d7003d,0xf1c900e7}},	//   cão_, _plaz_, _għad_, _dạo_, 
   {{0xdb1d02f2,0x443d0199,0x68e21176,0x2b5800a1}},	//   _zusä, _frw_, nbod, _lorc_, 
   {{0x60c90082,0xdb1c007a,0x6b5b009e,0x26060299}},	//   žemo, _airí, _mîgr, सूरी_, 
   {{0x6d4628d5,0x533428d6,0xf1c900e7,0x59ca00bd}},	//   _anka, _хект, _gạo_, िदार, 
   {{0xdb1c0183,0x9e340a10,0xcdd80267,0xbcfb00d8}},	//   _cirí, мерч, жњу_, _ulék, 
   {{0x316904d1,0xdb1c0503,0x200202fe,0xd65700d1}},	//   _ulaz_, _dirí, brki_, חילת_, 
   {{0x261302a0,0x636d0068,0x2004022c,0x2d8928d7}},	// [1c50] zão_, _fúnd, àmit_, rnae_, 
   {{0xfaa728d8,0x6d4628d9,0x8aa71a27,0x628b044e}},	//   ошен, _enka, оред, šloš, 
   {{0x261303b7,0x2d5c0042,0x539b00d1,0x00000000}},	//   xão_, _cíes_, סיבו, --, 
   {{0xa2da17f6,0x261302aa,0x2d5c00f6,0x98b91da4}},	//   पुत्, vão_, _díes_, блет_, 
   {{0xf74528da,0xb8d302e6,0x9cd60486,0x9f420032}},	//   зело, _ऑर_, _מורה_, vskú_, 
   {{0x26130316,0x7d0d28db,0x7c2d28dc,0x6fdc008d}},	//   tão_, lgas, mwar, סקוס, 
   {{0xf993024f,0xf1c602e6,0x3c2d00ca,0x9f420032}},	//   _قبر_, _रंगन, _hžv_, tskú_, 
   {{0x261300ce,0x7d0d28dd,0x442f28de,0x2ba900bd}},	//   rão_, ngas, _psg_, कतवा, 
   {{0x261300ce,0xa3e60081,0x7c2d28df,0x68fb07fc}},	//   são_, यील_, nwar, _idud, 
   {{0x261302a0,0x31b6058c,0x6d930405,0x326303dc}},	//   pão_, ृद्ध, nħab, деоҳ, 
   {{0xe29928e0,0x7c2d28e1,0x7d0d28e2,0x636d0038}},	//   сан_, hwar, kgas, _rúnd, 
   {{0x22580219,0xf8cb02e6,0x798b0149,0x3a31010e}},	//   ärka_, िशिय, nngw, _mszp_, 
   {{0xf1c900f7,0xdb1c0183,0x7c2d010c,0x5552010e}},	//   _tạo_, _sirí, jwar, _سپور, 
   {{0x442d28e3,0x7c2d28e4,0x752928e5,0xdc3a0095}},	//   mwe_, dwar, leez, xçıv, 
   {{0x442d28e6,0xf2d200c7,0x68fb0613,0x2ca700ad}},	//   lwe_, _טעג_, _odud, əndi_, 
   {{0x7d0d28e7,0xdb1c28e8,0xfe4601a2,0x442d0035}},	//   ggas, _virí, онҳо, owe_, 
   {{0x7c2d0405,0x442d28e9,0x2b581116,0xed5728ea}},	// [1c60] gwar, nwe_, _porc_, чот_, 
   {{0x7d0d28eb,0x636d04ef,0xf1c90023,0x442d0326}},	//   agas, _fúne, _lạm_, iwe_, 
   {{0xa92628ec,0x442d28ed,0xdb1c02aa,0x68e2243f}},	//   здел, hwe_, _pirâ, tbod, 
   {{0x442d28ee,0x6d4628ef,0xc7c61b11,0xfc3f01d5}},	//   kwe_, _unka, пски, _frí_, 
   {{0x07a628f0,0x684628f1,0x442d099d,0x68e228f2}},	//   падн, янда, jwe_, rbod, 
   {{0xe3a71f7a,0x501b00a7,0x21200ab1,0x1b030086}},	//   _سر_, מונו, _lbih_, র্বে_, 
   {{0x442d018c,0xbcfb0038,0x752901a3,0x00000000}},	//   ewe_, _sléi, feez, --, 
   {{0x69ce00d9,0x75290298,0xbcfb007a,0x6b9e28f3}},	//   _iube, geez, _pléi, lopg, 
   {{0x442d28f4,0x69dc00a1,0x00000000,0x00000000}},	//   gwe_, _htre, --, --, 
   {{0x69ce28f5,0xb4ac000d,0x27f7000d,0x212028f6}},	//   _kube, _गरी_, ření_, _abih_, 
   {{0x52130afc,0xcfc40086,0x442d28f7,0xe3b80540}},	//   ндэт, ্ঠান, awe_, rmı_, 
   {{0x442d28f8,0x798200ab,0x69ce28f9,0xe3b8027e}},	//   bwe_, niow, _mube, smı_, 
   {{0x43461c8e,0x69ce28fa,0x7c2d010c,0x30a728fb}},	//   _недв, _lube, xwar, яров, 
   {{0x69dc28fc,0x69ce02a5,0x00000000,0x00000000}},	//   _otre, _oube, --, --, 
   {{0xd78800f7,0x212028fd,0x69ce0503,0x798b0156}},	//   yển_, _fbih_, _nube, yngw, 
   {{0xbcfb28fe,0x7c2d28ff,0x7aee01d6,0x7d0d0679}},	//   _llév, twar, _aebt, ugas, 
   {{0x7d0d2900,0x2d5815dd,0x69ce0f92,0x7c2d01c8}},	// [1c70] rgas, чить_, _aube, uwar, 
   {{0x212b2901,0x69ce2902,0x65a5010e,0x2019006d}},	//   lech_, _bube, róhi, mtsi_, 
   {{0x69ce2903,0x442d2904,0x200b00d2,0x7c2d2905}},	//   _cube, zwe_, luci_, swar, 
   {{0xfc3f2906,0x212b2907,0x69ce2908,0x442d2909}},	//   _trí_, nech_, _dube, ywe_, 
   {{0xf770040f,0x442d078a,0x2019290a,0x200b044e}},	//   گان_, xwe_, ntsi_, nuci_, 
   {{0x7bdd290b,0xf09400c7,0xb6a51cc1,0xdb1c019c}},	//   _itsu, ענס_, милл, _virã, 
   {{0xf7700071,0xa3c21951,0x69ce290c,0x442d0876}},	//   دان_, ्दन_, _gube, wwe_, 
   {{0x442d2538,0x798200ab,0x7bc70126,0x1a680296}},	//   twe_, ciow, _hiju, _عینی_, 
   {{0x442d290d,0x200b1993,0x212b031e,0x69ce290e}},	//   uwe_, juci_, dech_, _zube, 
   {{0xe1f928d1,0x442d290f,0x7bcf2910,0xdb1c0019}},	//   ого_, rwe_, _mucu, _kirá, 
   {{0x7bcf2911,0x442d2912,0x3f831d34,0xf1c9001b}},	//   _lucu, swe_, diju_, _tạm_, 
   {{0x7bdd2913,0xdb1c033c,0x5ec50033,0x442d2914}},	//   _otsu, _mirá, ্রাই, pwe_, 
   {{0x7bdd01c1,0x200b00d2,0xbf9b02a0,0x7bcf2915}},	//   _ntsu, guci_, rrên, _nucu, 
   {{0x3f8303ef,0xdb1c0126,0x1b030033,0x7bc7095a}},	//   giju_, _oirá, র্তে_, _niju, 
   {{0x7bcf0518,0xada62916,0xad5a0ccb,0xddd40032}},	//   _aucu, давл, орах_, ňažn, 
   {{0x7bcf0012,0xc6920070,0x2019006f,0x29f80032}},	//   _bucu, דאל_, btsi_, vča_, 
   {{0x3f83265d,0x7bc72917,0x7bcf0a13,0x672102ef}},	// [1c80] biju_, _biju, _cucu, _oblj, 
   {{0x09e62918,0x7bcf016c,0x7bc70096,0x290f0664}},	//   дожн, _ducu, _ciju, egga_, 
   {{0x7bc7067c,0x7bdd07d7,0x69ce0248,0x6b9e2919}},	//   _diju, _etsu, _qube, ropg, 
   {{0x7aee291a,0xdb1c033c,0x6b9e02c9,0x7bcf01be}},	//   _webt, _dirá, sopg, _fucu, 
   {{0xb4ac000d,0x7bc7015e,0x7bcf0199,0x2baf1df3}},	//   _गरे_, _fiju, _gucu, _जीवा, 
   {{0x212b08dd,0x63a30175,0x5b3500d9,0x7afc0604}},	//   zech_, _nknn, _пэсу, _udrt, 
   {{0x69dc291b,0x200b291c,0xdb1c0068,0x8b03031e}},	//   _utre, zuci_, _girá, _úřad, 
   {{0xd82608bd,0x636400b9,0x6d56007c,0x00000000}},	//   _одби, _iòni, njya, --, 
   {{0xf8b20262,0x212b02d9,0x7bc7016c,0x7641017c}},	//   _जरिय, vech_, _yiju, _erly, 
   {{0xd37011fe,0x200b090b,0x212b017c,0x00000000}},	//   اهد_, vuci_, wech_, --, 
   {{0x3f830062,0x212b031e,0x69c8010e,0x63a8291d}},	//   viju_, tech_, _édes, rldn, 
   {{0x80fb0e0d,0x6364022c,0xe7f50035,0x7c261b67}},	//   ्लेख_, _mòni, ुंचा_, _opkr, 
   {{0x3f830571,0x212b291e,0x7522291f,0xbcfb011c}},	//   tiju_, rech_, _iboz, _mlét, 
   {{0x200b003a,0xa2940904,0x44260053,0xf487009c}},	//   ruci_, _палі, _ipo_, _تامی, 
   {{0x290f2920,0x7bcf2921,0x200b04c6,0x212b253f}},	//   ygga_, _sucu, suci_, pech_, 
   {{0x7bcf2922,0x7bc70010,0x44260226,0xa2da2923}},	//   _pucu, _siju, _kpo_, पुर्, 
   {{0x60cd02b8,0x9f4205a8,0x75221302,0x4426008a}},	// [1c90] _igam, lský_, _mboz, _jpo_, 
   {{0x44262924,0x79802925,0x7bcf04a8,0x00000000}},	//   _mpo_, _ammw, _vucu, --, 
   {{0x9f42063b,0xdeb2005e,0x60cd2926,0x7bc71050}},	//   nský_, _бұры, _kgam, _viju, 
   {{0x4adf1b38,0x3949128a,0x442600c5,0xdb1c0019}},	//   _प्रव, ñas_, _opo_, _virá, 
   {{0x44262927,0x636d00eb,0x60cd2928,0xba7411b7}},	//   _npo_, _lúna, _mgam, _یافت, 
   {{0xbcfb03b7,0x6d5d2929,0x7522292a,0xe736292b}},	//   _elét, _hosa, _aboz, ееш_, 
   {{0x4426292c,0x6d5d292d,0x386907d1,0x9f42014b}},	//   _apo_, _kosa, šar_, jský_, 
   {{0x60cd292e,0x6d5d292f,0x9f42014b,0x77ad0042}},	//   _ngam, _josa, dský_, púxo, 
   {{0x6d5d2930,0x64422931,0x4426016a,0x63a30065}},	//   _mosa, _croi, _cpo_, _pknn, 
   {{0x64421183,0x60cd1bd1,0x6d5d2932,0xf1c9001b}},	//   _droi, _agam, _losa, _hại_, 
   {{0x44262933,0x80c207d5,0x636d0038,0x64422934}},	//   _epo_, रेने, _cúna, _eroi, 
   {{0x64422935,0x6d5d2936,0x44262937,0x27ed0300}},	//   _froi, _nosa, _fpo_, _kwen_, 
   {{0xf1c90029,0x27ed06df,0x65691111,0x00000000}},	//   _mại_, _jwen_, mkeh, --, 
   {{0xf1c900f7,0x27ed0cbf,0xa3c0047c,0x443f2938}},	//   _lại_, _mwen_, ंगण_, mvu_, 
   {{0x6d5d2939,0x60cd0068,0x443f293a,0x27ed06df}},	//   _bosa, _fgam, lvu_, _lwen_, 
   {{0x6d5d293b,0x753b293c,0xed57293d,0xf65200c7}},	//   _cosa, nduz, нос_, נצן_, 
   {{0x6d5d293e,0x443f0298,0xf1ac0f6f,0xf1ca0023}},	// [1ca0] _dosa, nvu_, _टीएन, _nại_, 
   {{0x5ba701d7,0x99710083,0x909b00d1,0xbcfb01d5}},	//   екум_, jął_, _מספק, _slét, 
   {{0x6d5d07d7,0x0906293f,0x443f2940,0xdce400ef}},	//   _fosa, епен, hvu_, lkič, 
   {{0x443f02f5,0x7e61022b,0x69c9085b,0xebe62941}},	//   kvu_, älpe, _ciee, _помп, 
   {{0x69c919e1,0x63a12942,0x18672943,0x9f4202d9}},	//   _diee, koln, наци_, zský_, 
   {{0x6d5d0204,0xf1ca0023,0x44262944,0x27ed0118}},	//   _zosa, _dại_, _rpo_, _dwen_, 
   {{0xe5c62945,0x443f0e26,0x27ed01be,0x6d5d2946}},	//   нсио, evu_, _ewen_, _yosa, 
   {{0x9f420076,0xd5b72947,0xdb1c0908,0x636d2948}},	//   vský_, нсы_, _birç, _rúna, 
   {{0x70af0b3e,0xbcfb023e,0xe4522949,0x443f0231}},	//   _घरेल, _klér, اضع_, gvu_, 
   {{0x8883294a,0x9f42026e,0xbf9b026a,0x60cd294b}},	//   _служ, tský_, trêm, _sgam, 
   {{0xa2940965,0x66e30258,0x25710098,0xc0cb00f0}},	//   тані, _соха, _sále_, зуге_, 
   {{0x3202294c,0x6442294d,0x9f420254,0x673a294e}},	//   čky_, _troi, rský_, _hatj, 
   {{0x386603a1,0x4426294f,0x63a12950,0x644200b4}},	//   nyor_, _upo_, boln, _uroi, 
   {{0x6d5d2951,0x533303dc,0xbf9b0212,0x9f4211bb}},	//   _sosa, _бешт, prêm, pský_, 
   {{0x673a2952,0x644700e0,0x1c0300b0,0x1dac02e6}},	//   _matj, ājie, _लिहल_, चतंत, 
   {{0x8d84022c,0x60cd2520,0xbcfb2953,0x6d5d0026}},	//   гууд, _ugam, _alér, _qosa, 
   {{0x6d5d2954,0xfbd30071,0xbcfb011c,0x63860212}},	// [1cb0] _vosa, اتر_, _roéd, _génè, 
   {{0x673a1f0a,0xf1bf0183,0x6d5d0204,0xe1cf00aa}},	//   _natj, lmá_, _wosa, _सूँघ, 
   {{0x6d5d0084,0x69c9002a,0x61fa2955,0x443f05a8}},	//   _tosa, _piee, nstl, zvu_, 
   {{0xbcfb006b,0x27ed06df,0xfaa428ca,0xd70e0bb9}},	//   _elér, _pwen_, ушун, _साउथ_, 
   {{0xa3c20351,0xa3c02956,0x673a2957,0x29d70405}},	//   ्दा_, ंगा_, _batj, _għan_, 
   {{0xdb050038,0x25a62958,0x61fa2959,0x00000000}},	//   rmhó, _akol_, kstl, --, 
   {{0xc8830216,0x63a1295a,0x21040028,0xab94004f}},	//   _beşê_, voln, lčių_, _сирі, 
   {{0xf1ca00f7,0x63a100ab,0x67240f23,0xdb1c009e}},	//   _tại_, woln, đija, _pirç, 
   {{0x02c90239,0x210400e4,0xe89400dd,0x656902f2}},	//   रश्न, nčių_, _бать, rkeh, 
   {{0x443f295b,0x6569295c,0x934216d0,0x21040009}},	//   rvu_, skeh, анье, ičių_, 
   {{0x779006bc,0x443f295d,0x395f0300,0xc0e609e4}},	//   _دیوا, svu_, _kous_, конк, 
   {{0x395f05d5,0x63a1010e,0x63860151,0x00000000}},	//   _jous_, soln, _pénè, --, 
   {{0x63a111c8,0xb0a513ab,0x61e4044e,0x2d820065}},	//   poln, _गुदग, _čile, _rmke_, 
   {{0x25ad295e,0xa28300d4,0x25bf00d9,0xafe300a3}},	//   llel_, _میخو, lmul_, рорл, 
   {{0xbea61e6e,0xe3c800e7,0xdce4015e,0x21040009}},	//   тавк, _cựu_, skič, ečių_, 
   {{0x395f295f,0x386600a3,0x41b60019,0x2fd200a3}},	//   _nous_, yyor_, _جمعر, _tuyg_, 
   {{0x91bb00d1,0xccc62960,0x29d70248,0x00000000}},	// [1cc0] _קמפי, тбай, _aça_, --, 
   {{0x395f00a1,0x0e662961,0x25ad0415,0x394d2962}},	//   _aous_, _акон, hlel_, _anes_, 
   {{0xc332042c,0x395f2963,0x673a2964,0x00000000}},	//   שוב_, _bous_, _ratj, --, 
   {{0x395f2965,0x272200bc,0x38662966,0x02b60070}},	//   _cous_, _oční_, tyor_, דלעך_, 
   {{0x395f2967,0x394d08fc,0x2614072f,0x2d920065}},	//   _dous_, _dnes_, नूनी_, mnye_, 
   {{0x394d2968,0xbf9b026a,0x2d9202cd,0x38662969}},	//   _enes_, quêt, lnye_, ryor_, 
   {{0xe9d718ae,0x6aa301c4,0x2bd8296a,0x395f296b}},	//   _акс_, ünft, _भंडा, _fous_, 
   {{0x2d92296c,0x316001f1,0x2ef80380,0x395f296d}},	//   nnye_, _noiz_, harf_, _gous_, 
   {{0x2d920065,0xd0e3296e,0x47c6012d,0xdcc500bc}},	//   inye_, _क्षण_, _абав, लेपछ, 
   {{0x27e605f0,0x2d9200e2,0x316000b4,0x6376020f}},	//   mpon_, hnye_, _aoiz_, _mâng, 
   {{0x27e6296f,0xcb1300a7,0xc2240a24,0x2d92030c}},	//   lpon_, בלת_, اکتو, knye_, 
   {{0x25a60c36,0x2bd800ae,0x7af7009e,0x395f00b9}},	//   _ukol_, _भूभा, zaxt, _xous_, 
   {{0x44320237,0x27e62970,0x2d920065,0xf1bf09c6}},	//   _èy_, npon_, dnye_, rmá_, 
   {{0x29d70405,0x27e607fc,0x69c101e5,0x0f720259}},	//   _bħal_, ipon_, _èlev, йғыр, 
   {{0x316000a3,0x636d0038,0xc3330486,0x260600bc}},	//   _foiz_, _múnl, _כוס_, सूची_, 
   {{0x51872971,0x316001ca,0x9f590151,0x00000000}},	//   _шула, _goiz_, issé_, --, 
   {{0x0dc82972,0x5bb913f2,0x64440bfc,0xc05b004f}},	// [1cd0] тури_, елая_, _šiij, _цій_, 
   {{0x395f2973,0x6b7400d3,0x2d922974,0x25712975}},	//   _sous_, алуу, anye_, _mála_, 
   {{0x29d72976,0x395f2977,0xe8cb1281,0x2104012d}},	//   _għal_, _pous_, िश्च, sčių_, 
   {{0x3a380379,0x67d52978,0x69c80036,0x26de0354}},	//   _dsrp_, году, _èdel, _afto_, 
   {{0x395f182a,0x6d4f2979,0xb80a02e6,0xd825297a}},	//   _vous_, _inca, हंगम_, удли, 
   {{0xa3b20262,0xf1ca001b,0x4639002e,0x394d00f8}},	//   _झील_, _hạt_, ечия_, _wnes_, 
   {{0x395f1164,0x637600b3,0x25bf020f,0x00000000}},	//   _tous_, _mând, tmul_, --, 
   {{0x224902f5,0x394d00d3,0x845903b7,0x7af501cf}},	//   _čak_, _unes_, ерот_, _hezt, 
   {{0x69d5297b,0x6d4f02cd,0x321e001d,0x7af500b4}},	//   _huze, _mnca, etty_, _kezt, 
   {{0x25bf002e,0x25ad014b,0x69d5297c,0xa7b80161}},	//   smul_, slel_, _kuze, _алуу_, 
   {{0x7515057f,0xa18a1297,0x6d4f01e5,0x64a2004e}},	//   _مواض, ебна_, _onca, _қаша, 
   {{0x69d5297d,0xdb1c010c,0xd00a297e,0x9f5e00bc}},	//   _muze, _birû, неме_, čtí_, 
   {{0x69d5297f,0xaac3000d,0x2d892980,0xe44e0cf8}},	//   _luze, वेतक, diae_, _уж_, 
   {{0x6d4f2981,0xdb1c010c,0xe2990cfe,0x77ad0183}},	//   _anca, _dirû, _пал_, fúxi, 
   {{0xa3c2000f,0x2d922982,0xdb1d068b,0x6376020f}},	//   ्दर_, tnye_, _lusó, _sâng, 
   {{0x261400a2,0xcd36010e,0x7e6102ae,0x00000000}},	//   नंती_, درآب, älpa, --, 
   {{0x1c462983,0xcdc500f0,0x69d504c7,0xf1ca0108}},	// [1ce0] ынам, ратқ, _auze, _dạt_, 
   {{0x6d4f2984,0x637600d9,0x69d52985,0x2d920065}},	//   _enca, _gând, _buze, snye_, 
   {{0xd9461ad1,0x2d920065,0x68e40126,0x3f8a007c}},	//   лежи, pnye_, ñido, mibu_, 
   {{0x2d890068,0xed572986,0x99900228,0x257802b0}},	//   ciae_, _бою_, ťaži_, _zélf_, 
   {{0x77611c62,0xe7862987,0x69e00121,0x58d7017b}},	//   _bolx, луко, _žveč, удія_, 
   {{0x27e6005f,0xfaa61628,0x69d52988,0x07a32989}},	//   rpon_, _баго, _fuze, бачн, 
   {{0x27e6298a,0xe1e70019,0x2a3501d7,0x69d5298b}},	//   spon_, _دس_, _кэтр, _guze, 
   {{0x6a83040c,0x3f8a095a,0x636d007a,0x78b1003e}},	//   _улса, hibu_, _dúnm, ðkvæ, 
   {{0xa3c202f8,0x7bce298c,0x69d50414,0x3494298d}},	//   ्दल_, _kibu, _zuze, рапр, 
   {{0x3f8a086d,0x69c20d62,0x41e608af,0x7bce018e}},	//   jibu_, lmoe, ліма, _jibu, 
   {{0x6b7b1490,0x637600d9,0x80c202e6,0x2d5c04ff}},	//   גרינ, _rând, रेसे, _díez_, 
   {{0x8446298e,0x7bce298f,0xdb1c0587,0x69c210f3}},	//   _مختل, _libu, _cirú, nmoe, 
   {{0x69c2016a,0x200000a1,0x200b0212,0x645d00fb}},	//   imoe, _cvii_, urci_, øsit, 
   {{0x447b07f5,0x7bce0199,0xf4870116,0x841700d1}},	//   _אנדע, _nibu, _حامی, _עקוב_, 
   {{0x29040062,0x63760474,0x63030038,0x00000000}},	//   _odma_, _vând, _طويل, --, 
   {{0x3d0f02e6,0x7bce095a,0x69d5016c,0x656202be}},	//   िलें_, _aibu, _ruze, _jooh, 
   {{0x7bce23cb,0x3f8a0447,0x69d52990,0x6562011c}},	// [1cf0] _bibu, bibu_, _suze, _mooh, 
   {{0x59d90190,0x34d11223,0x2d890139,0x6376107c}},	//   _बंदर, _हल्द, siae_, _fâne, 
   {{0x5a351186,0x6fdd0033,0xf1ca0108,0x2d8902c5}},	//   рнет, _বিয়ে, _tạt_, piae_, 
   {{0xe9ab0444,0x69c20b22,0xe0df0036,0x2bb700b0}},	//   ردان_, gmoe, ncò_, _अठवा, 
   {{0x68f9006a,0xda010081,0x2129067c,0xf80711a8}},	//   rawd, _लटकत_, _mbah_, учен, 
   {{0xf7451e2b,0x7bce1272,0x68f90156,0x2904023e}},	//   реко, _gibu, sawd, _edma_, 
   {{0x7f3c00c7,0x29040175,0x62fa0033,0x21292991}},	//   געוו, _fdma_, ংলায়_, _obah_, 
   {{0xdb150183,0x656200ca,0x7bce2992,0x3f8a0298}},	//   _tizó, _cooh, _zibu, zibu_, 
   {{0x798b0102,0x7bce02b8,0xb0c702e6,0x320b0035}},	//   migw, _yibu, रेमग, ącym_, 
   {{0x25a01af7,0x42252521,0x21292993,0x671c17dc}},	//   čila_, адов, _abah_, _नायक_, 
   {{0xe2992994,0x45d52995,0xe3b600d9,0x00000000}},	//   тан_, _тоес, рбэ_, --, 
   {{0x69d803b7,0xe04600a3,0x798b2996,0xa06a0267}},	//   ívei, анми, nigw, вама_, 
   {{0x3f8a086d,0x671c00b5,0x00000000,0x00000000}},	//   tibu_, _नामक_, --, --, 
   {{0xb4c1143e,0x2129011c,0xa3c22997,0x798b02b8}},	//   ंधी_, _ebah_, ्दः_, higw, 
   {{0x3f8a086d,0x7bce2998,0x0fc300dd,0xc0e62999}},	//   ribu_, _ribu, ійсн, _койк, 
   {{0x3f8a299a,0xb04a18ae,0x257105a8,0x4aa900a5}},	//   sibu_, _азиз_, _málo_, _कड़व, 
   {{0x3b86299b,0x798b299c,0x9c870032,0x7bce0096}},	// [1d00] алаг, digw, vočí, _pibu, 
   {{0xfbdf0124,0x6ffb008d,0x1db8009a,0x29d7008a}},	//   _trên_, _שפיג, _आठवत, _għak_, 
   {{0x69c201a9,0xe8fa299d,0x7bce299e,0xca560477}},	//   tmoe, вле_, _vibu, штањ, 
   {{0xc8ca0133,0x636d001d,0xfd120038,0x7bce0610}},	//   نوان_, _búnk, _بجد_, _wibu, 
   {{0x7bce1272,0x69c2299f,0x97c628d8,0x656229a0}},	//   _tibu, rmoe, айде, _rooh, 
   {{0x6562016a,0x637600d9,0x69c229a1,0x00000000}},	//   _sooh, _mânc, smoe, --, 
   {{0x9c87026e,0xbcfb011c,0x29040096,0xd6d9017b}},	//   počí, _moén, _tdma_, уті_, 
   {{0xfaa602c0,0x290429a2,0xa4f80499,0x3426121f}},	//   _баҳо, _udma_, اکار_, афов, 
   {{0xf3f7021f,0x68ed0042,0xf1d00299,0xa3e70267}},	//   аныш_, ñade, _संजन, адња_, 
   {{0xf3660ecb,0x6562016a,0x7655010e,0x00000000}},	//   ртин, _wooh, ógyí, --, 
   {{0x1b0300cc,0x0bb700a7,0xa2a60299,0x81de0bf1}},	//   র্কে_, שלים_, _घुश्, দীন_, 
   {{0x672d00d0,0x51f71193,0xa1941623,0x00000000}},	//   đaje, шнюю_, жаюч, --, 
   {{0x63760165,0x04140086,0x4907009a,0x50640e27}},	//   _cânc, _তৈরী_, हणतो_, отра, 
   {{0x93fb0056,0x798b29a3,0x257802d9,0x00000000}},	//   _ילדי, zigw, _déle_, --, 
   {{0x63a829a4,0x798b29a5,0x00000000,0x00000000}},	//   modn, yigw, --, --, 
   {{0x21290666,0x63a829a6,0x2baf0b79,0x2578010e}},	//   _ubah_, lodn, _जीजा, _féle_, 
   {{0x91bc00d1,0x00000000,0x00000000,0x00000000}},	// [1d10] _במהי, --, --, --, 
   {{0x8ae702fb,0x09de0086,0x3f1529a7,0x63a800ef}},	//   ріал, _ডিজা, _удос, nodn, 
   {{0xcfe200cc,0x69da0019,0x1fe20033,0x798b1a20}},	//   _বিএন, _étel, _বিএস, tigw, 
   {{0x63a829a8,0xac95058e,0x2bd924a1,0x00000000}},	//   hodn, _гамш, _ماسک_, --, 
   {{0x8d5a0056,0x66e529a9,0xf1d002e6,0x00000000}},	//   _עכשי, бола, _संघन, --, 
   {{0xcc3a0137,0xdc3a0137,0xf1ca0023,0x80380070}},	//   _געשט, _געשר, _lạp_, ינדע_, 
   {{0x798b0010,0xb9e4017b,0xa3c000c9,0x644601d5}},	//   pigw, _міти, ंगई_, ækin, 
   {{0xf1ca00e7,0x7bc529aa,0xe299004e,0xddd5039f}},	//   _nạp_, lmhu, ғам_, nyző, 
   {{0x79890053,0xe80e0366,0x26131011,0x636d0118}},	//   _imew, _सिया_, _धमकी_, _húni, 
   {{0xf773125e,0x63a829ab,0xc6a7122f,0x83390080}},	//   _بار_, godn, _креи, учит_, 
   {{0x216a00cf,0x636d0019,0x61461271,0x82a529ac}},	//   гини_, _júni, бена, санж, 
   {{0xdb050219,0x249d01a0,0x636d1771,0xf1ca0023}},	//   llhä, _txwm_, _múni, _cạp_, 
   {{0x63a80e24,0x232929ad,0x7989025b,0x00000000}},	//   bodn, _боли_, _mmew, --, 
   {{0x2bdb05fd,0x5334093d,0xdee329ae,0x442f00e2}},	//   _बढ़ा, _мечт, зори, _ipg_, 
   {{0x22580f03,0x31b2039f,0xdb050151,0x1d0a29af}},	//   ärkt_, házi_, cohé, леви_, 
   {{0xf1d029b0,0xa1930843,0x1c030077,0x442f00e2}},	//   _सूचन, _најч, _लिखल_, _kpg_, 
   {{0xd1172233,0x00000000,0x00000000,0x00000000}},	// [1d20] _הקפה_, --, --, --, 
   {{0xf3f9100b,0x79890053,0x636d003e,0x799b025b}},	//   _আমার_, _amew, _búni, _ajuw, 
   {{0x6e4609e8,0x200229b1,0x2571003e,0x7c3d01f2}},	//   _انجم, lski_, _páll_, _essr, 
   {{0x9f4906b6,0x442f0242,0xed5a03a1,0xf8fa0038}},	//   _hvað_, _opg_, _сом_, اءات_, 
   {{0xbf9b0212,0x6cc603a1,0x657b29b2,0x443d074a}},	//   prêt, _ыйма, dhuh, _nsw_, 
   {{0x6d4402ba,0x3940012d,0x7c2429b3,0x20020102}},	//   ldia, žis_, mtir, iski_, 
   {{0x644b29b4,0x7c2429b5,0x65be024a,0x8afb042c}},	//   _argi, ltir, hëhe, _תהלי, 
   {{0x25a029b6,0x63a800ab,0xb99600eb,0x657b29b7}},	//   čilo_, wodn, _الرب, ghuh, 
   {{0x7c2429b8,0x69c00088,0x6d4429b9,0xb4d81567}},	//   ntir, _ihme, idia, _ाली_, 
   {{0x2002034c,0x68e201d2,0x2d850183,0x7afe29ba}},	//   dski_, lcod, élez_, napt, 
   {{0x7c2400cf,0x442f29bb,0xe13529bc,0xdb1c09ce}},	//   htir, _epg_, онны, _chré, 
   {{0x7afe00d7,0x5a9b00c7,0x442f0183,0x63a829bd}},	//   hapt, רשטא, _fpg_, sodn, 
   {{0x6d4402f0,0x63a800f1,0x7afe29be,0x644b1a35}},	//   ddia, podn, kapt, _grgi, 
   {{0x60d60019,0x6d4429bf,0x7c2429c0,0x7c3d00b4}},	//   _egym, edia, dtir, _rssr, 
   {{0x41e61896,0xf1ca001b,0xdb1c0038,0xa293017b}},	//   _استف, _tạp_, _ghré, _наші, 
   {{0x161902f8,0xd01109ed,0x200229c1,0x636d29c2}},	//   नंतर_, _قلب_, bski_, _rúni, 
   {{0xac1929c3,0x7c2407fc,0x442f019c,0xe52029c4}},	// [1d30] розу_, gtir, _xpg_, _यानि_, 
   {{0x69c029c5,0x6d440379,0x636d114a,0x2efa040b}},	//   _ahme, adia, _púni, _gepf_, 
   {{0x6d4429c6,0x7c2429c7,0xce590ec6,0x7a350038}},	//   bdia, atir, _танц_, تفاص, 
   {{0xac1929c8,0x68e229c9,0x7c2429ca,0x69c00098}},	//   _кому_, gcod, btir, _chme, 
   {{0x7c240183,0x7afe29cb,0x44240065,0xe8f81afd}},	//   ctir, bapt, jtm_, слі_, 
   {{0x69c029cc,0x7afe29cd,0xd7c829ce,0x442f0d90}},	//   _ehme, capt, مونه_, _rpg_, 
   {{0x442f0089,0x657b29cf,0x443d29d0,0x00000000}},	//   _spg_, thuh, _ssw_, --, 
   {{0x240929d1,0x68e229d2,0x442f0090,0x79890548}},	//   ании_, ccod, _ppg_, _umew, 
   {{0x75ca00ab,0xdced0ab4,0x00000000,0x00000000}},	//   _języ, jkač, --, --, 
   {{0x657b0010,0x645b0183,0x644b00ca,0x020529d3}},	//   shuh, rxui, _vrgi, озон, 
   {{0x200200ab,0xcb120a33,0x644402fe,0x7c2401f1}},	//   wski_, ולי_, _šiit, ztir, 
   {{0x200202f5,0x68fb026d,0x443d006f,0x7c2400cf}},	//   tski_, _jeud, _tsw_, ytir, 
   {{0x442f0068,0x443d01c4,0x7afe02f1,0xbee500a2}},	//   _upg_, _usw_, yapt, कडून_, 
   {{0x94740740,0x68fb01c5,0x65be024a,0xdb1c0038}},	//   _عدنا, _leud, rëhe, _thré, 
   {{0xfc3f127e,0xdce40bad,0x00000000,0x00000000}},	//   _así_, nkić, --, --, 
   {{0x2002265d,0x7c2429d4,0x75290093,0x291f006f}},	//   pski_, ttir, nfez, _ncua_, 
   {{0xab6629d5,0x644929d6,0x21200574,0x7afe29d7}},	// [1d40] овал, nvei, _icih_, tapt, 
   {{0x6d4429d8,0x2fd7009c,0x25780096,0x75e70241}},	//   sdia, _گوید_, _méla_, _kızd, 
   {{0x7afe29d9,0xdce4053d,0x68e201d2,0x68fb29da}},	//   rapt, jkić, tcod, _beud, 
   {{0x671c00b0,0x68fb0465,0x2d9629db,0x7afe29dc}},	//   _नाहक_, _ceud, _фрос, sapt, 
   {{0x68fb29dd,0x68ed0503,0x183600b1,0x68e229de}},	//   _deud, ñada, تراح, rcod, 
   {{0x68e229df,0x69d829e0,0x644929e1,0xbb56007a}},	//   scod, íves, dvei, _بنسب, 
   {{0x7afc00b3,0x699600d9,0x21200096,0xd95a0267}},	//   _iert, _драх, _ocih_, _краљ_, 
   {{0x186a00cf,0x7ae90082,0x68fb29e2,0x22a40176}},	//   _каби_, _đeti, _geud, ҷумҳ, 
   {{0x7afc29e3,0x69dc29e4,0x6603006d,0x00000000}},	//   _kert, _hure, asnk, --, 
   {{0x69dc29e5,0x442400e2,0x394629e6,0x68fb01f1}},	//   _kure, rtm_, ldos_, _zeud, 
   {{0xc4e629e7,0x394629e8,0x644902be,0x00000000}},	//   _джей, odos_, avei, --, 
   {{0x69dc29e9,0x39462450,0x7afc01ca,0x21200118}},	//   _mure, ndos_, _lert, _ccih_, 
   {{0x81ba0086,0x394629ea,0x84960019,0x434629eb}},	//   _অংশ_, idos_, _بجائ, _медв, 
   {{0x69dc09a1,0x25a90f4c,0x67380e67,0xdb1c0183}},	//   _oure, čale_, nevj, _miró, 
   {{0xccfb02a6,0xed8b29ec,0x645d0080,0x00000000}},	//   ића_, асак_, äsiv, --, 
   {{0xdb1c0183,0x394401dd,0x7afc29ed,0xfc3f11bb}},	//   _oiró, _nams_, _aert, _psí_, 
   {{0x7afc0d82,0x0bd500eb,0x2139024a,0xef6700fd}},	// [1d50] _bert, سياح, mesh_, _дъно, 
   {{0x69dc29ee,0x7afc0c04,0x201929ef,0x67380a9d}},	//   _bure, _cert, musi_, jevj, 
   {{0x20190d55,0x7afc29f0,0xea00001b,0x68fb0126}},	//   lusi_, _dert, _đảo_, _peud, 
   {{0x69dc29f1,0x3f9104d1,0xe9d800e4,0x777a01f1}},	//   _dure, lizu_, ікі_, _altx, 
   {{0x69dc29f2,0x66e50ed8,0x201929f3,0xa3ca00a2}},	//   _eure, пола, nusi_, लगा_, 
   {{0x7afc29f4,0x39460b85,0x213900e5,0xa3de29f5}},	//   _gert, ados_, hesh_, _दूध_, 
   {{0x7bdd29f6,0x69dc0a9f,0x7c3901f0,0xf7700fd0}},	//   _husu, _gure, şarı, خان_, 
   {{0x7bdd29f7,0x201929f8,0x7afc29f9,0x23670082}},	//   _kusu, kusi_, _zert, _sonj_, 
   {{0x201929fa,0x7bdd29fb,0x69dc29f9,0x752929fc}},	//   jusi_, _jusu, _zure, rfez, 
   {{0x644929fd,0x7bdd29fe,0x2571008c,0x201929ff}},	//   rvei, _musu, _máli_, dusi_, 
   {{0xcb1207f5,0x64492a00,0x7ae50014,0xa91d012d}},	//   עלט_, svei, icht, _amži, 
   {{0x291d2a01,0x20192a02,0xcf89008d,0x241900c8}},	//   ngwa_, fusi_, _גט_, _годы_, 
   {{0x7bdd141e,0x20192a03,0x316901ca,0x4375074f}},	//   _nusu, gusi_, _doaz_, _нукт, 
   {{0xdb1c01be,0x636d007a,0x7bd52a04,0x39460028}},	//   _chrì, _cúnt, _nizu, zdos_, 
   {{0xed5a2a05,0x272f03c0,0x3ebe05a7,0x291d0364}},	//   бов_, mını_, ått_, kgwa_, 
   {{0x7afc11a4,0x20192a06,0x7bdd2a07,0xa0a62a08}},	//   _sert, busi_, _busu, _найд, 
   {{0x7afc2a09,0xdca311b5,0x7bdd00b3,0x7bd52a0a}},	// [1d60] _pert, еати, _cusu, _bizu, 
   {{0xef860a8e,0x272f0540,0x7afc078a,0x39442a0b}},	//   _хлоп, nını_, _qert, _sams_, 
   {{0x7afc2a0c,0x19ba15dd,0x7bdd0068,0x7bd50a9f}},	//   _vert, будь_, _eusu, _dizu, 
   {{0x7ae5057f,0x7afc2a0d,0x7bdd2a0e,0xdb1c0c2a}},	//   acht, _wert, _fusu, _piró, 
   {{0x7afc11f7,0x2d922a0f,0x672d00d2,0x25ad0318}},	//   _tert, miye_, đajn, doel_, 
   {{0x69dc2a10,0xa3c2000d,0x2d922a11,0x636d0042}},	//   _ture, ्दछ_, liye_, _xúnt, 
   {{0x6d462a12,0x272f0092,0xfaa32a13,0x25ad033e}},	//   _kaka, dını_, _заро, foel_, 
   {{0x6d462a14,0x2d922a15,0x7ec70019,0xdb1c2a16}},	//   _jaka, niye_, lépé, _tiró, 
   {{0x6d462a17,0x7bdd00cf,0x6618014b,0xb4c807d5}},	//   _maka, _xusu, suvk, ोखे_, 
   {{0x6d462524,0x68432a18,0x20192a19,0x29d70405}},	//   _laka, _януа, vusi_, _għas_, 
   {{0x2d922a1a,0x213900e5,0x25ad2a1b,0x69c80036}},	//   kiye_, tesh_, boel_, _èdes, 
   {{0x6d462a1c,0x20192a1d,0x63640118,0x071c00c2}},	//   _naka, tusi_, _jònz, _नाँव_, 
   {{0x2d9201f0,0x2139024a,0x2d801ec3,0x645d2a1e}},	//   diye_, resh_, dhie_, äsit, 
   {{0x20192a1f,0x6d4606e4,0x1be300a5,0x2139024a}},	//   rusi_, _aaka, _कंबल_, sesh_, 
   {{0x7bdd2a20,0x4ea42a21,0x20192a22,0x213900e5}},	//   _susu, ерта, susi_, pesh_, 
   {{0x20192a23,0x6d4619e0,0x2d92024d,0xe3b807fa}},	//   pusi_, _caka, giye_, llı_, 
   {{0x071c1ff6,0x6d462a24,0x5c990238,0xea000029}},	// [1d70] _नांव_, _daka, цкая_, _đạo_, 
   {{0xe3b80718,0x7ae501c4,0xad271372,0x0bb406ba}},	//   nlı_, ucht, _کردو, ебую, 
   {{0x7bd52a25,0x6d462a26,0x68ed1056,0x2d922a27}},	//   _vizu, _faka, ñado, biye_, 
   {{0x44260068,0x7ae501c4,0x64420088,0x2d922a28}},	//   _oqo_, scht, _osoi, ciye_, 
   {{0x25ad01a9,0xe3b801f0,0x44262a29,0xb90500a5}},	//   voel_, klı_, _nqo_, _नल_, 
   {{0xe80e034d,0x32050098,0xe3b80761,0x7ec70096}},	//   _सिरा_, ysly_, jlı_, cépé, 
   {{0x6d462a2a,0x25ad2a2b,0xda34012d,0xe3b800ad}},	//   _yaka, toel_, _перы, dlı_, 
   {{0x5ebf0086,0xa3de02e6,0x6d46040c,0x1dbf2a2c}},	//   _আলাই, _दंश_, _xaka, ्षित, 
   {{0xe3b80785,0x272f091f,0x290d2a2d,0x31b2010e}},	//   flı_, tını_, _idea_, zázs_, 
   {{0x2d922a2e,0xe3b62a2f,0x29d7003d,0xd389004f}},	//   ziye_, мбы_, _għar_, ійне_, 
   {{0x272f2a30,0x2d922a31,0x9f5900c8,0x25ad2a32}},	//   rını_, yiye_, issä_, poel_, 
   {{0x272f03b0,0x72070019,0xe3b800ad,0x645d0080}},	//   sını_, _ہفتہ_, alı_, äsis, 
   {{0x6d462a33,0xa01b006b,0xe3ae0904,0xd4691818}},	//   _raka, szön, _аб_, _филе_, 
   {{0x6d462a34,0x2d920199,0xdb1c00eb,0x656b2a35}},	//   _saka, wiye_, _phrí, _hogh, 
   {{0x2d922a36,0x6d462a37,0xa2c901ec,0x1d0a03b7}},	//   tiye_, _paka, हेश्, жеби_, 
   {{0xed5718ae,0x9f5900c8,0xa2a6059e,0xe80e0790}},	//   мос_, essä_, _घुट्, _सिला_, 
   {{0x2d922a38,0x6d462a39,0x61e40f4c,0x656b2a3a}},	// [1d80] riye_, _vaka, _čili, _mogh, 
   {{0x6d462a3b,0x2d922a3c,0x656b2a3d,0x290d2a3e}},	//   _waka, siye_, _logh, _adea_, 
   {{0x6d462a3f,0x2d802a40,0x443f2a41,0x637f2a42}},	//   _taka, phie_, hwu_, _gêne, 
   {{0x3d1804d7,0xe3b805b7,0x443f2a43,0xed5700f0}},	//   _फाटे_, zlı_, kwu_, _жою_, 
   {{0x7d042a44,0xe3b80824,0xd90d00d6,0xb8f600a2}},	//   mais, ylı_, صیل_, _सण_, 
   {{0x7d042a45,0x752201d8,0x656b01be,0x290d011c}},	//   lais, _scoz, _aogh, _edea_, 
   {{0x27ed2a46,0xa3c30a34,0x656b2a47,0xa3c12a48}},	//   _eten_, ्षन_, _bogh, ंतन_, 
   {{0x7d042a49,0x2578026a,0x753b0053,0x656b0b1a}},	//   nais, _vélo_, geuz, _cogh, 
   {{0xe3b803c0,0x656b2a4a,0xa2d02a4b,0xdb0500da}},	//   tlı_, _dogh, डेन्, lohá, 
   {{0x7d042a4c,0x636d00b9,0x67240082,0x656b2619}},	//   hais, _búnq, đijs, _eogh, 
   {{0x7d042a4d,0x656b0a9a,0xa3de2659,0x81bd002a}},	//   kais, _fogh, _दूर_, stēm, 
   {{0xe3b804be,0x7d042a4e,0x2d9e010e,0x64422a4f}},	//   slı_, jais, étel_, _tsoi, 
   {{0x9f5900c8,0xe3b80241,0xdb1c00a1,0x637f08b0}},	//   yssä_, plı_, _ohrà, _sêne, 
   {{0xe3b806d0,0x81bd00e0,0xc05801fc,0xd250247b}},	//   qlı_, otēk, фію_, _منت_, 
   {{0xdfd42a50,0xd90415c0,0x8d7700eb,0x7d041a30}},	//   торы, _پی_, وارا, fais, 
   {{0x7d042a51,0x656b007b,0x7520018e,0x00000000}},	//   gais, _xogh, ngmz, --, 
   {{0x637f078a,0xfbdf2a52,0x7982011c,0xdb1c0465}},	// [1d90] _wêne, _quê_, dhow, _bhrà, 
   {{0x31a403c0,0xa3c31bec,0xdb1c01fd,0x60c02a53}},	//   mıza_, ्षय_, _chrà, ümme, 
   {{0x7d042a54,0xdb1c2a55,0x27ed2a56,0xc91502a6}},	//   bais, _virð, _sten_, едећ, 
   {{0x7d042a57,0x00000000,0x00000000,0x00000000}},	//   cais, --, --, --, 
   {{0x656b0544,0x31a403c0,0x69cb2a58,0xa3c300c9}},	//   _rogh, nıza_, rmge, ्षम_, 
   {{0xf1ca001b,0x656b00eb,0xdb07004f,0xdb1c0465}},	//   _dạy_, _sogh, _skjæ, _ghrà, 
   {{0x81bd002a,0xd90f00d6,0x45d50172,0xbbbd05d0}},	//   rtēj, _نیا_, нцит, ्गीक, 
   {{0x7982006a,0x443f0035,0x81bd01dd,0x290d00b4}},	//   chow, twu_, stēj, _udea_, 
   {{0x27ed02fb,0x656b01d8,0xfbdf2a59,0x753b2a5a}},	//   _uten_, _vogh, _trêu_, reuz, 
   {{0xc48205e0,0x2d8c0212,0xc8a800c2,0x00000000}},	//   ульк, édez_, _छुटट, --, 
   {{0x68e4003a,0x656b0038,0x1ddb00bd,0x753b02be}},	//   žide, _togh, _मंगत, peuz, 
   {{0x92df0086,0xe4510038,0x31a40241,0x00000000}},	//   তরে_, _مضت_, fıza_, --, 
   {{0x600702fb,0x7d042a5b,0x00000000,0x00000000}},	//   нням_, vais, --, --, 
   {{0x7d04018e,0xdb1c0098,0x00000000,0x00000000}},	//   wais, _ohrá, --, --, 
   {{0xf77200fe,0x00000000,0x00000000,0x00000000}},	//   נקל_, --, --, --, 
   {{0x61ee05b9,0x7bc714b3,0xdb1c01fd,0x5d6700d9}},	//   íble, _ahju, _shrà, нисм_, 
   {{0x7d042a5c,0xdee62a5d,0xc19b00d1,0xdb1e0080}},	// [1da0] rais, _попи, _משקי, ympä, 
   {{0x7d042a5e,0x60c42a5f,0x8fa60dec,0xdb1c0038}},	//   sais, _izim, _سمجه, _bhrá, 
   {{0xdb1c0076,0xe9da2a60,0xc33202a1,0x4efb00a7}},	//   _chrá, чке_, רוב_, _מהיו, 
   {{0xfbdf026a,0x4aaf009a,0x307a0070,0x2571003e}},	//   _prêt_, _जुळव, ּאַנ, _máls_, 
   {{0xb8e80d4f,0xdb1c0465,0x75e704a8,0x00000000}},	//   _उर_, _thrà, _rıza, --, 
   {{0x38cb1fdb,0x60c41c36,0xfc3f0042,0x2bd80035}},	//   سانی_, _mzim, _uxía_, _भूचा, 
   {{0xfaa601a2,0xdb1c007a,0xe2870038,0x00000000}},	//   _чаво, _ghrá, _إذ_, --, 
   {{0xfaa600cf,0x046611f0,0x00000000,0x00000000}},	//   _жаҳо, етом, --, --, 
   {{0x60c42192,0x81e70033,0x18a32a61,0x98a31dbd}},	//   _nzim, মীম_, _батм, _бите, 
   {{0x2906084c,0x00000000,0x00000000,0x00000000}},	//   laoa_, --, --, --, 
   {{0x60c42a62,0x637602be,0x00000000,0x00000000}},	//   _azim, _jâni, --, --, 
   {{0xf2c30d18,0x546a0093,0x4a9b00c7,0xc486002e}},	//   ысын, _наем_, לייג, _плек, 
   {{0xc953042c,0x2571010e,0x06d50033,0x74132a63}},	//   אמר_, _vált_, _স্পি, _مونا, 
   {{0xa3c300ea,0x60c400e0,0x25a002ee,0xd5df08dd}},	//   ्षण_, _dzim, čilu_, _पूँज, 
   {{0x60c401a3,0x27e601ff,0x5e5800b3,0x00000000}},	//   _ezim, hqon_, ниря_, --, 
   {{0x3eba017b,0x2906025b,0x212f00a1,0x00000000}},	//   _dypt_, jaoa_, _ùgh_, --, 
   {{0x2ef5048a,0xe802031e,0xdb1c007a,0xafdb00fb}},	// [1db0] _изпр, रीमा_, _shrá, rvøs, 
   {{0xc5f60086,0x200b2a64,0x8aa72a65,0x7e610219}},	//   _ঘটনা_, msci_, нред, älps, 
   {{0xd5df000f,0x321e2a66,0xdd91009c,0x200b0036}},	//   _पूंज, nuty_, _نود_, lsci_, 
   {{0x1a680296,0x39781623,0x27e6039b,0x00000000}},	//   ریقی_, нсію_, fqon_, --, 
   {{0x6d5d2a67,0x200b0036,0x684500a3,0x00000000}},	//   _insa, nsci_, тнла, --, 
   {{0x7c2d01ee,0x39492a68,0x6d4d0511,0x321e1151}},	//   mtar, žas_, ldaa, kuty_, 
   {{0xfbdf03b7,0xe7080133,0xcf5800a7,0x6d5d011d}},	//   _três_, رتون_, תבות_, _knsa, 
   {{0x6d4d2a69,0x49042751,0x7c2d2a6a,0xd4d500e4}},	//   ndaa, _موفق, otar, кіпэ, 
   {{0x200b00d2,0xd7fb03dc,0xd6db2a6b,0x6d5d0102}},	//   jsci_, _хуб_, _ете_, _mnsa, 
   {{0x7c2d2a6c,0x6d4d2a6d,0x69da2a6e,0x637f010c}},	//   itar, hdaa, _éter, _bêna, 
   {{0x7c2d2a6f,0x69c901c1,0x6f070228,0x6d5d2a70}},	//   htar, _khee, dajc, _onsa, 
   {{0x04b500fd,0xafe62a71,0x00000000,0x00000000}},	//   _исля, комл, --, --, 
   {{0x6d4d0547,0x7c2d024a,0x1b0c0033,0x69c901be}},	//   ddaa, jtar, স্টে_, _mhee, 
   {{0x6d5d2a72,0x42550a10,0x6d4d11da,0x65692a73}},	//   _ansa, _атит, edaa, ljeh, 
   {{0x7c2d2a74,0x20192a75,0x637f0212,0xee150009}},	//   etar, arsi_, _gêna, льтэ, 
   {{0x7c2d2a76,0xe8021451,0x65692a77,0x69db011c}},	//   ftar, रीडा_, njeh, _niue, 
   {{0x7c2d2a78,0x1ae62a79,0x61e32a7a,0x6376020f}},	// [1dc0] gtar, возм, _hunl, _sâni, 
   {{0x6d5d2a7b,0xa3c105fd,0x6f0700f1,0x6d4d2a7c}},	//   _ensa, ंति_, cajc, adaa, 
   {{0x442d2a7d,0xbcfb2a7e,0x3f980062,0x6d4d0640}},	//   hte_, _poét, miru_, bdaa, 
   {{0x3f981630,0x69c92a7f,0xa91d0098,0x6376019c}},	//   liru_, _chee, _alžb, _vâni, 
   {{0x69c90201,0x7c2d2a80,0xa3c1100d,0x69db03a1}},	//   _dhee, ctar, ंता_, _diue, 
   {{0x442d2a81,0x3f982a82,0xbb760093,0xa9250032}},	//   dte_, niru_, _румъ, _rožň, 
   {{0x442d26d8,0xe1e7021b,0xb5a62a83,0x00000000}},	//   ete_, _خس_, крий, --, 
   {{0x7bdc2a84,0x657b2a85,0x628816fb,0xfaa32a86}},	//   _hiru, gkuh, vzdo, _тасо, 
   {{0x442d2a87,0x75e701f0,0x37e600dd,0x73d82a88}},	//   gte_, _hızl, _розг, ндир_, 
   {{0x671c119b,0x61e30749,0x2019090b,0x2904078a}},	//   _नाटक_, _bunl, vrsi_, _hema_, 
   {{0x442d2a89,0xf36308a5,0x7bdc2a8a,0xe5262a8b}},	//   ate_, ртын, _miru, _адеп, 
   {{0x442d2a8c,0x7c2d2a8d,0x29042a8e,0xbcfb011c}},	//   bte_, ytar, _jema_, _loér, 
   {{0x442d2a8f,0x7c2d2a90,0x533411ef,0x29042a91}},	//   cte_, xtar, _белт, _mema_, 
   {{0x29042a92,0x7bdc2a93,0x3f982a94,0xdce601dd}},	//   _lema_, _niru, giru_, _rokā, 
   {{0xdced0082,0x91e302a6,0x7c2d0035,0x6d4d000b}},	//   nkać, _које, wtar, tdaa, 
   {{0x7c2d2a95,0x672d0112,0xdd1100ad,0x2000045a}},	//   ttar, đaji, _düşd, _fwii_, 
   {{0x6d4d0265,0x7bdc2a96,0xd1b811b7,0x69c918b5}},	// [1dd0] rdaa, _biru, _جاوا_, _rhee, 
   {{0x09cb0c94,0x2d820e47,0xd9cb2a97,0x7bdc0647}},	//   िष्य, _elke_, िष्ट, _ciru, 
   {{0x442d2a98,0x7bdc2a99,0x69c901a0,0x29042a9a}},	//   zte_, _diru, _phee, _bema_, 
   {{0x7c2d078e,0x6d5d0bc1,0x27e40110,0x6d4d02a5}},	//   ptar, _unsa, _bumn_, qdaa, 
   {{0x2904055a,0x442d2a9b,0x7bdc2a9c,0x69db022c}},	//   _dema_, xte_, _firu, _viue, 
   {{0x442d026e,0x25a6002c,0x7bdc2a9d,0xf1bf2a9e}},	//   vte_, _ajol_, _giru, hlá_, 
   {{0x69c92a9f,0xc79400d4,0x6abc0156,0x442d2aa0}},	//   _thee, جشنب, _gyrf, wte_, 
   {{0x6f0500bc,0x7bdc2aa1,0xa3e709ef,0x78a900f6}},	//   _lehc, _ziru, _मंद_, _txev, 
   {{0x442d2aa2,0xf1bf0039,0x7793006b,0x25a605d5}},	//   ute_, dlá_, _پیغا, _djol_, 
   {{0xe1f92aa3,0x394d0026,0x657b2aa4,0x61e30f3a}},	//   нго_, _haes_, skuh, _punl, 
   {{0x35f52aa5,0x656903e5,0x25a60219,0x29040126}},	//   _спер, pjeh, _fjol_, _yema_, 
   {{0x29042aa6,0x216a05de,0x06d50033,0x3f982aa7}},	//   _xema_, хими_, _স্থি, wiru_, 
   {{0x394d02bf,0x442d024a,0xd09617fc,0xdb150098}},	//   _maes_, qte_, ушны, _ekzé, 
   {{0x749a2aa8,0x649a0137,0x61e32aa9,0x25bf27ea}},	//   _אינפ, _אינה, _tunl, llul_, 
   {{0xe1f1182b,0x20002aaa,0x3f982aab,0x61e3011d}},	//   _است_, _wwii_, riru_, _uunl, 
   {{0x0ce20086,0x2258055f,0x8c462aac,0x7f9400ad}},	//   বর্ত, ærke_, лебе, _müqə, 
   {{0x3f980112,0x64440bfc,0x25bf00b3,0x29042aad}},	// [1de0] piru_, _šiiz, ilul_, _rema_, 
   {{0xdd040e7b,0x29042aae,0x09dc009a,0x69c30212}},	//   ısın, _sema_, यद्य, înen, 
   {{0xdca32aaf,0x75e70095,0x7bdc2ab0,0x29042ab1}},	//   _ғари, _qızl, _viru, _pema_, 
   {{0x394d08b2,0x2578010e,0x888600a3,0xdcf7020f}},	//   _caes_, _téli_, ллеж, ăcăr, 
   {{0x29040053,0xed572ab2,0x9f4000a1,0x2b410216}},	//   _vema_, _соя_, _stiù_, behc_, 
   {{0x6fb4000f,0x7d062ab3,0x29040053,0xc3190086}},	//   ंकिं, _heks, _wema_, ত্তি_, 
   {{0x7d062ab4,0xfbde0183,0x637600b3,0x394d00f8}},	//   _keks, _iiª_, _mânt, _faes_, 
   {{0x782600eb,0xe5c602f3,0x746a0088,0x5e5700c7}},	//   _معطل, ысло, еров_, ריקע_, 
   {{0x644d0082,0xa3e7109f,0x5fb40249,0x49910290}},	//   _šair, _मूद_, ंकाल, _بینر, 
   {{0x7d060bff,0x883b00d1,0x25bf00b3,0x38cb0296}},	//   _leks, _אתמו, alul_, _ساقی_, 
   {{0x4ebf00cc,0xf1bf0032,0x25bf020f,0x877b0070}},	//   _আল্ল, tlá_, blul_, _ראבי, 
   {{0x6fc00a25,0x25bf00b3,0x7d062ab5,0x00000000}},	//   böck, clul_, _neks, --, 
   {{0x33f600b3,0x8cb0109f,0x637f02be,0x63760474}},	//   _счес, _अँगो, _gêno, _sânu, 
   {{0x637600d9,0xf1bf0377,0x1b1a0033,0x00000000}},	//   _cânt, slá_, ন্তে_, --, 
   {{0xa3c317dc,0xa3c1156d,0x7d062ab6,0x3da72ab7}},	//   ्षर_, ंतर_, _beks, граб, 
   {{0xdd941b17,0x9e43014b,0xfc15002e,0x00000000}},	//   басы, žďov, имбэ, --, 
   {{0x7d062ab8,0xbcfb0634,0x6376020f,0x394d0096}},	// [1df0] _deks, _anéc, _fânt, _raes_, 
   {{0x7d06011d,0x395f028e,0x3dc006e4,0x394d09c6}},	//   _eeks, _snus_, aliw_, _saes_, 
   {{0x7d062ab9,0x394d2aba,0x00000000,0x00000000}},	//   _feks, _paes_, --, --, 
   {{0x4dfa0137,0xa9072abb,0x7d062abc,0x00000000}},	//   _שפרא, ابان, _geks, --, 
   {{0xd7050b97,0x1b1a0033,0x00000000,0x00000000}},	//   азли, ন্ধে_, --, --, 
   {{0x257801e5,0x07a50165,0x394d01d2,0x17f8007a}},	//   _mélu_, јакн, _waes_, ارنة_, 
   {{0x6d4f019a,0x25bf00d9,0x7d061093,0x27f8008b}},	//   _kaca, tlul_, _yeks, _črne_, 
   {{0x395f2abd,0x2d892abe,0x6d4f2abf,0x00000000}},	//   _unus_, nhae_, _jaca, --, 
   {{0xb81c0e0d,0x8727195e,0x27f8026e,0x64a52ac0}},	//   _नियम_, _معام, čený_, рапа, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x49b8010e,0x25bf2ac1,0x01661271,0x5ef60299}},	//   _شاہد_, plul_, акно, ्रस्_, 
   {{0x249600c5,0x672d0112,0xe80200c9,0xe2962ac2}},	//   انید_, đaju, रीवा_, раю_, 
   {{0x764e008c,0x7d06008c,0x63762ac3,0xafe619b1}},	//   _ábyr, _reks, _pânt, рогл, 
   {{0x64592ac4,0x6d4f0175,0x248d0201,0x6376020f}},	//   _irwi, _aaca, mzem_, _dâns, 
   {{0xe81c0262,0x7d062ac5,0x3ebe008c,0xfd960009}},	//   _निभा_, _peks, ætt_, ашаю, 
   {{0x6d4f2ac6,0xa1930d3d,0x64590083,0x00000000}},	//   _caca, _мајч, _krwi, --, 
   {{0x7d0600fc,0x81bd01dd,0x195800f0,0x637602be}},	// [1e00] _veks, rtēt, ғалы_, _tânt, 
   {{0x644b00c5,0x6d4f01fd,0x2578008c,0x2d890415}},	//   _msgi, _eaca, _hélt_, ahae_, 
   {{0x7d06076b,0x6d4f0014,0x4a462ac7,0x81e70086}},	//   _teks, _faca, рнев, মীর_, 
   {{0x6d4f2904,0x6e3e0065,0x2d891572,0x323600c7}},	//   _gaca, _ippb, chae_, יטען_, 
   {{0x6d442ac8,0x69da0036,0x7c3d01d6,0xa01b010e}},	//   meia, _ètem, _gpsr, szöv, 
   {{0x248d291c,0x2d8000ab,0x6d4f2ac9,0xab090189}},	//   dzem_, lkie_, _zaca, _متفق_, 
   {{0xfaa32aca,0xeb972acb,0x644b0415,0x6d4f016c}},	//   _даро, _тир_, _asgi, _yaca, 
   {{0x2d800691,0xdb0700fc,0x6d4f0068,0xa3e700c9}},	//   nkie_, _skjø, _xaca, _मूह_, 
   {{0x533411db,0xb71600d4,0x69c200c2,0xa3c30110}},	//   бепт, _نباش, mloe, ्षं_, 
   {{0x443d016a,0x69c22acc,0x6e3e004f,0x66e3019c}},	//   _dpw_, lloe, _oppb, _дофа, 
   {{0x2d800691,0x0cc30b3e,0x443d0065,0xa6961b11}},	//   kkie_, _शर्म, _epw_, _трај, 
   {{0x7c242178,0xdb1c0534,0x00000000,0x00000000}},	//   kuir, _chrú, --, --, 
   {{0x7bce0065,0x6d442acd,0xdb050183,0x248d0035}},	//   _ohbu, deia, rohú, czem_, 
   {{0x6d4f2ace,0xdb05014e,0x7c242acf,0x69c2084c}},	//   _saca, llhö, duir, hloe, 
   {{0x8de82ad0,0x6d4f2ad1,0xf2060093,0x69c201cf}},	//   ифта_, _paca, _тяло, kloe, 
   {{0x69c8002a,0xdb1c0038,0xccf80267,0x7c242ad2}},	//   _ūden, _ghrú, ићу_, fuir, 
   {{0x44242ad3,0x65620076,0x7bce02fe,0x69c30107}},	// [1e10] num_, _mnoh, _bhbu, înem, 
   {{0x6d4f12e6,0x25a91dba,0x68e400da,0xde470535}},	//   _waca, čali_, židl, _پیرو_, 
   {{0x6d4f2ad4,0x44241272,0x5a351d65,0xa91d0228}},	//   _taca, hum_, снет, _dlžn, 
   {{0x2d802ad5,0x79a42ad6,0xac1900dd,0xd5a62ad7}},	//   ckie_, орче, _йому_, _رف_, 
   {{0x765a006a,0x44242ad8,0xbcfb0038,0x7d0d2ad9}},	//   _arty, jum_, _gnéa, maas, 
   {{0xbb85057f,0x44242ada,0x7d0d2adb,0x248d02ee}},	//   _السي, dum_, laas, vzem_, 
   {{0x69c22adc,0x4424002c,0xff1800d1,0x443d2add}},	//   bloe, eum_, בקות_, _spw_, 
   {{0x7d0d2ade,0x4424010d,0x248d03a1,0xa01b01c4}},	//   naas, fum_, tzem_, nzös, 
   {{0x44242adf,0xe3b92ae0,0x00000000,0x00000000}},	//   gum_, лби_, --, --, 
   {{0x64a5032e,0xd7740084,0x248d2ae1,0x2d8001f1}},	//   _қала, _والع, rzem_, zkie_, 
   {{0x7d0d2ae2,0x248d2197,0xdb1c01fd,0x29d701f2}},	//   kaas, szem_, _chrù, _bħax_, 
   {{0x44242ae3,0x7d0d2ae4,0xdb1c01be,0xa06a0bad}},	//   bum_, jaas, _dhrù, гама_, 
   {{0x44242ae5,0x5552006b,0x6e3e0065,0x645d055f}},	//   cum_, _رپور, _sppb, æsid, 
   {{0xa027010d,0x75292ae6,0x644900f8,0x00000000}},	//   _stöð, lgez, mwei, --, 
   {{0x51f51966,0x644901c4,0x7d0d2ae7,0xdb1c00a1}},	//   _استر, lwei, faas, _ghrù, 
   {{0x7d0d2ae8,0x75292ae9,0x7c242aea,0x29d70405}},	//   gaas, ngez, tuir, _għax_, 
   {{0x69c201a9,0x644902f2,0x3b862aeb,0x2d80206b}},	// [1e20] vloe, nwei, благ, rkie_, 
   {{0x2d802aec,0x4f260834,0xdca618ae,0x7c242aed}},	//   skie_, _удоб, _ҳами, ruir, 
   {{0x64492aee,0x7c24090b,0x7d0d2aef,0x6e3e1f7e}},	//   hwei, suir, baas, _uppb, 
   {{0x44242af0,0x7d0d02a5,0x588600f0,0x752902b0}},	//   yum_, caas, йыла, jgez, 
   {{0x7c242af1,0xe80b000f,0xa3e71432,0x44242af2}},	//   quir, _सौदा_, _मूल_, xum_, 
   {{0x64490156,0x9f4000b9,0x00000000,0x00000000}},	//   dwei, _juià_, --, --, 
   {{0x44242af3,0x3f9a0065,0xd5ba2af4,0x69c210de}},	//   wum_, _mmpu_, лси_, ploe, 
   {{0x9f410218,0x75292af5,0x64490380,0x9f8400c8}},	//   _cihê_, ggez, fwei, löä_, 
   {{0x12e6004e,0x64491417,0x39462af6,0x77ca2af7}},	//   йінг, gwei, meos_, _благ_, 
   {{0x44242af8,0x39462af9,0xa3e700a2,0x52141a31}},	//   rum_, leos_, _मूळ_, одот, 
   {{0x7d0d0539,0xb7d70ce0,0x3e5803a0,0x6f0e00f6}},	//   yaas, _اولا_, _nčt_, dabc, 
   {{0x798200ab,0x39462afa,0x4424003e,0x65620088}},	//   nkow, neos_, pum_, _unoh, 
   {{0x543306bc,0x657d02ae,0x7d0d2afb,0x00000000}},	//   _فرور, öshe, vaas, --, 
   {{0x7d0d2afc,0x3e5803a0,0x92580258,0x2d992afd}},	//   waas, _bčt_, _вакт_, _smse_, 
   {{0x7d0d2afe,0x7a1c00d9,0x877b008d,0xdb1c05d5}},	//   taas, nătă, נאלי, _ikrè, 
   {{0x63ba2aff,0x32530093,0xdb170042,0x3f9a00d7}},	//   lotn, _хвър, moxé, _empu_, 
   {{0x79820035,0x2d5800c8,0x7d0d2afb,0xdb990d5c}},	// [1e30] dkow, щить_, raas, авач_, 
   {{0x7d0d2aef,0x5b15004e,0x3e5806df,0x60cd02b8}},	//   saas, імет, _fčt_, _izam, 
   {{0x39460634,0x27f8008b,0xdb170183,0x7d0d0080}},	//   feos_, _črna_, noxé, paas, 
   {{0x41c90425,0xf1c90527,0x63ba2b00,0x61ea2b01}},	//   रतिस, रतिन, hotn, _mufl, 
   {{0x63ba2b02,0xf8b10535,0x00000000,0x00000000}},	//   kotn, ذکر_, --, --, 
   {{0x36190088,0xa09c00c7,0x60cd2b03,0xb09c0070}},	//   ацию_, ניגט, _mzam, ניגר, 
   {{0x752901c8,0x994d0228,0x3946001d,0xf1c9009a}},	//   tgez, môžu_, beos_, रतान, 
   {{0xe5792b04,0x64492b05,0x39460a47,0x60cd2b06}},	//   рзи_, twei, ceos_, _ozam, 
   {{0xe10100cc,0x61ea01c4,0x75292b07,0x60cd2b08}},	//   ্লাহ_, _aufl, rgez, _nzam, 
   {{0x290f2b09,0x64492b0a,0x75292b0b,0x13090080}},	//   laga_, rwei, sgez, шной_, 
   {{0x64492b0c,0x60cd2b0d,0x76ab2b0e,0x7989270f}},	//   swei, _azam, _став_, _klew, 
   {{0x61ea0212,0x98a400a4,0x00000000,0x00000000}},	//   _dufl, _qamħ_, --, --, 
   {{0x637f010c,0x437503a1,0x799b0539,0x798901f2}},	//   _lêni, _мукт, _mmuw, _mlew, 
   {{0x60cd2b0f,0x290f2b10,0xd347009c,0x7989017c}},	//   _dzam, haga_, _ایده_, _llew, 
   {{0xe2962b11,0x290f2b12,0xdee32b13,0x79892b14}},	//   _маш_, kaga_, дори, _olew, 
   {{0xa3c30c59,0xa0a62b15,0x72420019,0x52740283}},	//   ्षक_, _майд, _کھیل, _хушу, 
   {{0x290f2b16,0x9f8400c8,0xada300a3,0xdc6a058e}},	// [1e40] daga_, töä_, фатл, шаад_, 
   {{0x76410022,0x79892b17,0x3f9a016a,0xa2d007d5}},	//   _oply, _alew, _umpu_, डेक्, 
   {{0x7982006a,0x8a06004e,0x290f046d,0x61e40341}},	//   tkow, ізде, faga_, _kiil, 
   {{0x5f460399,0xed5a2b18,0x290f2b19,0x08c61faa}},	//   _انگل, _том_, gaga_, обен, 
   {{0x39462123,0x79822b1a,0x61e42b1b,0x63ba02f1}},	//   reos_, rkow, _miil, yotn, 
   {{0x39461056,0x798200ab,0x39520009,0x79892b1c}},	//   seos_, skow, žys_, _elew, 
   {{0x63ba2b1d,0x39460503,0x290f2b1e,0x637f02aa}},	//   votn, peos_, baga_, _gêni, 
   {{0x6d562b1f,0x61e400c8,0x290f2b20,0x63ba0035}},	//   ndya, _niil, caga_, wotn, 
   {{0x98a32b21,0x60c42b22,0x7c360727,0x61ea002e}},	//   _жите, _nyim, ntyr, _sufl, 
   {{0xd37a2b23,0x63a8016a,0x61e400a1,0xdb170068}},	//   рчи_, undn, _aiil, toxé, 
   {{0x63ba2b24,0x326600dd,0xa3ab02e6,0x60cd23f8}},	//   rotn, ітов, _गदर_, _szam, 
   {{0x63ba2b25,0xdb170068,0x60c40610,0xe5780243}},	//   sotn, roxé, _byim, _puķu_, 
   {{0x63ba008b,0x9f490165,0x490b119b,0x60c40610}},	//   potn, _itaú_, ारतो_, _cyim, 
   {{0x290f2b26,0xa2940965,0x60cd008b,0xdb170183}},	//   zaga_, _налі, _vzam, poxé, 
   {{0x290f2b27,0x3f83003e,0x61e42b28,0x60c401b8}},	//   yaga_, rkju_, _fiil, _eyim, 
   {{0xf1a4005e,0x3f832b29,0x1b040086,0x61e40008}},	//   _орын, skju_, _লাগে_, _giil, 
   {{0x6ebb0509,0x60cd2b2a,0x290f2b2b,0x637f019c}},	// [1e50] _शुरु, _uzam, vaga_, _sêni, 
   {{0x290f2b2c,0x69c024a5,0x637f2b2d,0xddeb009c}},	//   waga_, _akme, _pêni, _پرده_, 
   {{0xdced08b1,0x290f2b2e,0xdb07003e,0xfc3f0108}},	//   ljač, taga_, _skjó, _axít_, 
   {{0xb9e8004e,0xe81c029c,0x00000000,0x00000000}},	//   іміз_, _निशा_, --, --, 
   {{0x290f2b2f,0x64460095,0xa804012d,0xf84b00b3}},	//   raga_, çkil, дзіл, рчей_, 
   {{0x290f2b30,0x637f02a0,0x69c0027e,0x20092b31}},	//   saga_, _têni, _ekme, _mwai_, 
   {{0x64420c1f,0xf96b2b32,0x290f2b33,0x38690474}},	//   _apoi, _край_, paga_, ţar_, 
   {{0xe79500d6,0x76410228,0x799b0c36,0x64420038}},	//   _کارک, _vply, _umuw, _bpoi, 
   {{0xdced14f0,0xd7f80978,0x68e9008a,0x69d90532}},	//   jjač, _дух_, _iged, mmwe, 
   {{0xdced044e,0x69d92b34,0x61e42b35,0x644202be}},	//   djač, lmwe, _siil, _dpoi, 
   {{0x4b7c0137,0x7641014b,0x61e40341,0xbcfb2b36}},	//   יאזו, _uply, _piil, _aném, 
   {{0xe80209e5,0x644f055f,0x42c800d3,0x27ed023e}},	//   रीका_, æcis, өгөн_, _kuen_, 
   {{0x27e52279,0x290d084c,0x61e42b37,0xe5c4012d}},	//   _kiln_, _meea_, _viil, _ўсхо, 
   {{0xdce4090e,0x2d8b02be,0x221500fd,0xdb1c009e}},	//   ljić, _alce_, _ефир, _akrî, 
   {{0x61e42b38,0x63a12b39,0x257100da,0x68e9052b}},	//   _tiil, miln, _sály_, _oged, 
   {{0x68e92b3a,0xdce403f5,0x63a12725,0x6579018e}},	//   _nged, njić, liln, _jowh, 
   {{0x8c432b3b,0x27ed0a9f,0x27f8008b,0x63ad0183}},	// [1e60] нете, _nuen_, _črno_, _íans, 
   {{0xe7ef0262,0x63a11eeb,0x68e905ca,0x753b2b3c}},	//   _चढ़ा_, niln, _aged, hfuz, 
   {{0x7c362379,0x6ac600eb,0x628108f5,0x5eda0033}},	//   styr, أقام, nylo, _ব্রে, 
   {{0xb4ea0081,0x27ed0086,0x290d002e,0x7e6101cc}},	//   _मले_, _buen_, _ceea_, ælpe, 
   {{0x7d042b3d,0xa3cb11c1,0x63a12b3e,0x9f41011c}},	//   mbis, लता_, kiln, _sihé_, 
   {{0x26c5000d,0x27ed02ba,0x69d92b3f,0x68ff0095}},	//   _bylo_, _duen_, amwe, ıqda, 
   {{0x63a12b40,0x6b632b41,0x68ed2b42,0xa3c1007e}},	//   diln, _якра, žada, ूतन_, 
   {{0xb608031e,0x7f8b0095,0x7d042b43,0xe9440116}},	//   jišť, _müqa, nbis, _ترسی, 
   {{0xdb050634,0x7d042b44,0xbcfb0032,0x7ae1009e}},	//   cohó, ibis, _poéz, _ûltr, 
   {{0xfbbe1971,0x63a11bae,0x57fb00a7,0xb5fc00a4}},	//   ्तिम, giln, _ללמו, _arġe, 
   {{0x27ed0414,0x7c2402f1,0x2009095a,0x00000000}},	//   _zuen_, hrir, _swai_, --, 
   {{0xa3e7190a,0x7c242b45,0x320200da,0x63a101be}},	//   _मूक_, krir, ďky_, ailn, 
   {{0x63a12b46,0x53342b47,0x7d040fd3,0xfbbe2b48}},	//   biln, _желт, dbis, ्ताम, 
   {{0x62812b49,0x7c242b4a,0x7d0400c2,0x00000000}},	//   bylo, drir, ebis, --, 
   {{0xdced1993,0x433b00a7,0x777a2b4b,0xe3b30070}},	//   sjač, _העוב, _motx, _אױס_, 
   {{0x7c242b4c,0x7d041a71,0xb6060613,0x3eac00de}},	//   frir, gbis, mošć, _šitý_, 
   {{0x7c242b4d,0xb6061993,0x3b552b4e,0x00000000}},	// [1e70] grir, lošć, мкар, --, 
   {{0x44240a92,0x290d0415,0x2fc70108,0xeb9b039f}},	//   irm_, _seea_, _óng_, حضرت_, 
   {{0xdd9511db,0xb606003a,0x7c242b4f,0xbefb0299}},	//   _жаны, nošć, arir, ्रीन_, 
   {{0x290d0226,0xdb1c007a,0x442400da,0xf1bf02be}},	//   _qeea_, _bhró, krm_, noá_, 
   {{0x27ed2b50,0xdb1724d3,0x62810db7,0x7c240107}},	//   _quen_, loxí, zylo, crir, 
   {{0x777a00d3,0x3dc92b51,0x7d1d0864,0xf7710038}},	//   _cotx, llaw_, _hdss, ضات_, 
   {{0x63a12b52,0x4424008a,0x7d0f010e,0x777a00b4}},	//   viln, erm_, _kecs, _dotx, 
   {{0xb60600d0,0x63a10035,0x3dc90f39,0x4975012d}},	//   došć, wiln, nlaw_, _ўлас, 
   {{0x63a12b53,0x473502f1,0xbcfb0175,0x69c30107}},	//   tiln, _онас, _anék, îneu, 
   {{0x645b2b54,0x62812b55,0x7d0f010e,0x00000000}},	//   rvui, tylo, _lecs, --, 
   {{0x63a102ee,0xb6062b56,0xa91d0a1a,0x3ce60228}},	//   riln, gošć, _alži, ľovi_, 
   {{0xa0a62b57,0x7d0f0226,0x7c24003e,0x777a00b4}},	//   дамд, _necs, yrir, _zotx, 
   {{0x63a12b58,0xbcfb0228,0x3dc902dc,0x31b90098}},	//   piln, _inéh, dlaw_, nézy_, 
   {{0x7c242b59,0x637f02be,0xf8ab0108,0x7df50028}},	//   vrir, _cênt, _đời_, _sąsa, 
   {{0xafe32b5a,0x7d0f010e,0xdb170042,0x25ad0b41}},	//   торл, _becs, goxí, onel_, 
   {{0x25ad2b5b,0x7c242b5c,0x25bf020f,0x637f02be}},	//   nnel_, trir, noul_, _vênu, 
   {{0x7d042b5d,0xdca32b5e,0x629c23f2,0xa01b00c8}},	// [1e80] rbis, вати, úrov, lyön, 
   {{0x25bf0237,0x7c242b5f,0xdcef020f,0x637f02be}},	//   houl_, rrir, _pocă, _tênu, 
   {{0xdb1c01fd,0x68ed0032,0x3dc900f8,0x00000000}},	//   _bhrò, ľadn, blaw_, --, 
   {{0x7c240093,0x3dc92b60,0xdb1c0358,0xda650038}},	//   prir, claw_, _phró, عالي, 
   {{0xb8f60d95,0xdb1c01be,0x25bf2b61,0x6c0300b3}},	//   _हर_, _dhrò, doul_, _изяз, 
   {{0xbcfb0574,0x4b5500fd,0xa634017b,0x00000000}},	//   _anéh, _пъст, енкі, --, 
   {{0x2b580097,0x9f8d003e,0x00000000,0x00000000}},	//   _iarc_, nþá_, --, --, 
   {{0xa5341a68,0x2d9202a2,0xb606090e,0xbf0a009a}},	//   хнич, nhye_, vošć, वरुन_, 
   {{0xa8c302f1,0x29062b62,0x777a2b63,0x00000000}},	//   _айтд, mboa_, _totx, --, 
   {{0xb606090e,0x2b582b64,0x42742b65,0x00000000}},	//   tošć, _jarc_, егос, --, 
   {{0xa2c112e3,0x3218026e,0x2b582b66,0x25bf2b67}},	//   _रुद्, éry_, _marc_, boul_, 
   {{0xe4a611f0,0xc4861745,0x68e400ef,0xb6060a1a}},	//   _орло, _олек, židu, rošć, 
   {{0xa3e705fd,0xbf0a00a2,0xc05824cf,0x10742b68}},	//   _मंच_, वरून_, мір_, вляю, 
   {{0x0efb2b69,0x2b582b6a,0x47cc0086,0x533400d3}},	//   ्रेस_, _narc_, াদকী, _чект, 
   {{0x9e340161,0x3ceb2b6b,0x5e5800b3,0xf1bf02be}},	//   керч, _pgcv_, миря_, poá_, 
   {{0x3dc9012b,0xcdd80267,0x637f040b,0xa1a80259}},	//   ulaw_, дњу_, _fêns, _отыз_, 
   {{0x7d02033c,0x3dc92b6c,0x7d0f2b6d,0x2b58017c}},	// [1e90] ñosa, rlaw_, _vecs, _barc_, 
   {{0xdb1c01f5,0xdb1e023e,0x00000000,0x00000000}},	//   _shrò, nopè, --, --, 
   {{0xb50e00a5,0x7d0f2b6e,0xdb1c01c5,0x25ad2b6f}},	//   सराय_, _tecs, _phrò, ynel_, 
   {{0x645c00e0,0x68ed0228,0x31b92b70,0x00000000}},	//   ārij, ľado, tézy_, --, 
   {{0x68ed026e,0x2b582b71,0x201900c8,0x6cfa0486}},	//   žado, _farc_, nssi_, _מפרס, 
   {{0x7c2d2b72,0xb17b0b48,0x00000000,0x00000000}},	//   muar, lmåd, --, --, 
   {{0x7c2d03f6,0x2bbe0497,0x1995058b,0xbcfb0165}},	//   luar, ्तरा, _завя, _anéi, 
   {{0xc8670093,0x6d4d2b73,0x25ad107c,0x00000000}},	//   _отзи, neaa, unel_, --, 
   {{0x38342b74,0x7c2d2b75,0x25bf00b3,0x68fb0027}},	//   _интр, nuar, roul_, _ifud, 
   {{0x25ad2b76,0xe29902a6,0x25bf0034,0x69cb2b77}},	//   snel_, зао_, soul_, llge, 
   {{0x2d89016a,0x25ad01be,0x7c2d2b78,0x69cb0326}},	//   kkae_, pnel_, huar, olge, 
   {{0x7c2d2b79,0xa3cf017d,0x6026286c,0x865a00df}},	//   kuar, _वीर_, ндма, _מדעי, 
   {{0x656b2b7a,0xbcfb00eb,0x7c2d2b7b,0x04450488}},	//   _ingh, _gnéi, juar, _челн, 
   {{0x7c2d2b7c,0xdb1e024a,0x442d2b7d,0x69cb0380}},	//   duar, ropë, mue_, hlge, 
   {{0x442d2b7e,0x2019216b,0x68fb052b,0x00000000}},	//   lue_, assi_, _ofud, --, 
   {{0xbefb02e6,0x7c2d007a,0x0efb0299,0x68fb01b8}},	//   ्रॉन_, fuar, ्रॉस_, _nfud, 
   {{0x2b582b7f,0x7c2d2b80,0x6aa803a2,0x656b02cd}},	// [1ea0] _parc_, guar, कप्र, _mngh, 
   {{0x2d92024d,0xa3c108b4,0x68fb0539,0x68ed23f2}},	//   shye_, ूति_, _afud, žadl, 
   {{0x3ea62b81,0xa92624a8,0x27ff1e89,0x6376020f}},	//   _чинг, едел, _atun_, _pânz, 
   {{0xb17b014e,0x442d2b82,0xdb050218,0x7c2d2b83}},	//   rmåg, kue_, nihê, buar, 
   {{0xc7c62128,0x7d1601ff,0x6376002e,0x6e2e017e}},	//   нски, mays, _vânz, lubb, 
   {{0x7d162b84,0x656b2b85,0xfaa60f91,0x29062b86}},	//   lays, _angh, _заго, sboa_, 
   {{0xbbbe09d8,0x442d0212,0x6e3c084c,0x21200574}},	//   ्तीक, eue_, ntrb, _odih_, 
   {{0x7d1606e4,0x09e32b87,0xd49a0176,0x2c520118}},	//   nays, _босн, зро_, _kņd_, 
   {{0x442d24bb,0x73d80470,0x98af0028,0x34940afc}},	//   gue_, мдир_, degė_, тапр, 
   {{0x656b0156,0x7d162782,0x96962b88,0x21200118}},	//   _engh, hays, _преш, _adih_, 
   {{0x7c2d2b89,0x7d160080,0xd5af00f0,0xbcfb0212}},	//   zuar, kays, _бс_, _inév, 
   {{0x6e2e2b8a,0xdce605d5,0xdb05009e,0x0efb017d}},	//   dubb, _ankč, gihê, ्र्स_, 
   {{0x5fd2007e,0x7d162b8b,0x7c2d2b8c,0xa2cc0249}},	//   _दीहल, days, xuar, _हरक्, 
   {{0x201901ad,0x21200175,0x7c2d021e,0x00000000}},	//   rssi_, _edih_, vuar, --, 
   {{0x5d672b8d,0x6f1514fd,0x656b02bf,0x6e2e2b8e}},	//   нтаз, razc, _yngh, gubb, 
   {{0x7d160104,0x7c22003d,0x7c2d2b8f,0x40950038}},	//   gays, ġorn, tuar, _للبر, 
   {{0xb81c1c25,0x6d4d2b90,0xdefb14c1,0x00000000}},	// [1eb0] _निगम_, reaa, _нын_, --, 
   {{0x7c2d21c3,0x6e2e2b91,0x3df52675,0xb17b02c9}},	//   ruar, bubb, _изос, småd, 
   {{0x442d0a9f,0x6d4d2b92,0x6db50ecf,0xf778008a}},	//   zue_, peaa, _айну, _jiħu_, 
   {{0x27ff085b,0xa91d008b,0x3c4301dd,0xdeb200f0}},	//   _ptun_, _možg, tīvā_, _тұсы, 
   {{0x7c2d2b93,0xe10c00c7,0x8d8400b3,0x89340038}},	//   quar, פּאָ, _суэд, اعما, 
   {{0x442d2b94,0xb6a502f1,0xa3cf0035,0x39440102}},	//   vue_, килл, _वीं_, _ebms_, 
   {{0xead400c8,0x00000000,0x00000000,0x00000000}},	//   _борь, --, --, --, 
   {{0x442d2b95,0x27ff00b4,0x05652b96,0xa01b0080}},	//   tue_, _ttun_, твин, työl, 
   {{0xe43200eb,0x27ff002c,0x00000000,0x00000000}},	//   لفيد, _utun_, --, --, 
   {{0x442d2b97,0x394f2b98,0xdb1e2b99,0x260e009a}},	//   rue_, legs_, topé, णीही_, 
   {{0x200000d9,0x442d00a7,0x27f80352,0xfbd200d1}},	//   _stii_, sue_, _črni_, שתי_, 
   {{0xdb1e2b9a,0x656b2b9b,0x0f0a0179,0xe4d90038}},	//   ropé, _ungh, वर्स_, _قوات_, 
   {{0x442d2b9c,0x8edf00cc,0x45d400c8,0x21200604}},	//   que_, _ব্লগ, _соцс, _vdih_, 
   {{0x03a511f8,0xdb1c024c,0x00000000,0x00000000}},	//   _шило, _okrá, --, --, 
   {{0x6da607a4,0x7d162b9d,0x7d02033c,0x224701d6}},	//   вива, tays, ñoso, _upnk_, 
   {{0x6e2e2b9e,0x12e800c7,0xdd9208cb,0x320500d1}},	//   rubb, _אַפּ, جور_, mply_, 
   {{0xa91d02f5,0x7d162b9f,0x2bf62ba0,0x67211a35}},	// [1ec0] _možd, rays, тябр, _odlj, 
   {{0x6e2e2ba1,0x7d162ba2,0xaf0a0038,0xb17b0566}},	//   pubb, says, _تقدم_, rmåe, 
   {{0xa3c22ba3,0x7d160212,0x00000000,0x00000000}},	//   ंवत_, pays, --, --, 
   {{0x7d16040c,0x637e02d9,0x7bde011c,0x00000000}},	//   qays, _záně, smpu, --, 
   {{0xe947010e,0x2578020b,0x17a20176,0x00000000}},	//   ئرمی, _gély_, ақаҳ, --, 
   {{0xfaa603dc,0xe81301a4,0x6cb30259,0xa09b2737}},	//   _ҷаҳо, _डबरा_, _төст, וינט, 
   {{0x6ae000cc,0xfaa601a2,0x98b2027e,0x00000000}},	//   _প্রো, _раво, ıyı_, --, 
   {{0x32540176,0x80d30110,0x00000000,0x00000000}},	//   ҳвор, _ठरले, --, --, 
   {{0xdb1c00bc,0x00000000,0x00000000,0x00000000}},	//   _zkrá, --, --, --, 
   {{0xf3662ba4,0x27f9023e,0xa91d0144,0x00000000}},	//   ттин, _ésna_, _požg, --, 
   {{0x79800727,0x66e6220f,0x00000000,0x00000000}},	//   _komw, _рожа, --, --, 
   {{0x316d2ba5,0xfbdf00f8,0x00000000,0x00000000}},	//   ñez_, _apêl_, --, --, 
   {{0x79800727,0x60d60083,0x9476007a,0x00000000}},	//   _momw, _czym, _جداا, --, 
   {{0x9e352ba6,0x547b00a7,0x79800727,0x9f5205d5}},	//   легч, _קטגו, _lomw, _juyè_, 
   {{0x2bec02e6,0xdb0602d9,0x63a82ba7,0x236e018e}},	//   _अंजू_, ámýc, midn, _infj_, 
   {{0xa91d026e,0x7bc70dcb,0x7e6522ed,0x62882ba8}},	//   _kože, _skju, _vrhp, mydo, 
   {{0xdb1c2ba9,0xebd907a4,0x62880009,0xfbd908bd}},	// [1ed0] _skrá, едаш_, lydo, едај_, 
   {{0xa91d02f5,0x4ea72baa,0x8f5502fb,0x61ed00a9}},	//   _može, _арма, _свої, _hial, 
   {{0x61ed2bab,0xa91d015e,0x7980040b,0x00000000}},	//   _kial, _lože, _bomw, --, 
   {{0xaa642bac,0x60cd0547,0xafdb02c9,0x629a01d6}},	//   штук, _kyam, stød, izto, 
   {{0xa3c2047b,0x61ed2bad,0xa91d044e,0x6d5d2bae}},	//   ंवा_, _mial, _nože, _iasa, 
   {{0x75222baf,0x60cd016c,0xab842bb0,0x00000000}},	//   _adoz, _myam, _куск, --, 
   {{0x6d5d2bb1,0xe5a52bb2,0x7bc52bb3,0x27ec00a7}},	//   _kasa, лики, mohu, _didn_, 
   {{0x61ed2bb4,0xe4591853,0x60cd2bb5,0x7bc52bb6}},	//   _nial, ежи_, _oyam, lohu, 
   {{0x60cd2bb7,0xa91d0bad,0x69c90102,0x00000000}},	//   _nyam, _vožd, _ikee, --, 
   {{0x6d5d2bb8,0x2bd902c3,0x490b000d,0x75220a9f}},	//   _lasa, _बीमा, ारको_, _edoz, 
   {{0x61ed2bb9,0x60cd2bba,0x6d5d0054,0x7980030b}},	//   _bial, _ayam, _oasa, _yomw, 
   {{0x6d5d2bbb,0x60cd23cb,0x74b9065b,0x00000000}},	//   _nasa, _byam, _пулс_, --, 
   {{0x44292bbc,0x343900c7,0x0d8602f1,0x7bc50fae}},	//   _ía_, _נײַע, қлан, kohu, 
   {{0x94740071,0x443f2bbd,0x63a805ae,0x6d5d2bbe}},	//   _خدما, mtu_, cidn, _aasa, 
   {{0xa2ca0f01,0x61ed2bbf,0x2258055f,0x62880035}},	//   _सुप्, _fial, ærkt_, cydo, 
   {{0xed572bc0,0x5bbe0cbd,0x61ed2bc1,0x5de62bc2}},	//   лос_, ्त्व, _gial, ужба, 
   {{0x443f2bc3,0xbcfb00b9,0x2004007a,0x3ba40176}},	// [1ee0] ntu_, _anés, ímid_, алаҳ, 
   {{0x443f2bc4,0xa09b0070,0x69c92bc5,0x69db025b}},	//   itu_, _נייט, _akee, _ahue, 
   {{0x443f2bc6,0x6da62bc7,0x69db0038,0xba2600d9}},	//   htu_, _бина, _bhue, удек, 
   {{0x6d5d2bc8,0x644b02c9,0x8d5621f3,0x7d56004f}},	//   _gasa, _opgi, _сточ, _стої, 
   {{0x443f2bc9,0xa2ca036e,0xbcfb033c,0x8eb3009c}},	//   jtu_, _सुन्, _enés, _نمیش, 
   {{0x6d5d138c,0xdb1c055f,0x7c2b0a6d,0x79800727}},	//   _zasa, _skræ, ágre, _womw, 
   {{0x6d5d2bca,0xb8eb000c,0xbb3b00c7,0x56942bcb}},	//   _yasa, _रु_, _רעלי, райт, 
   {{0xa91d00d0,0x6d5d0287,0x7df50009,0x69c900b4}},	//   _pože, _xasa, _sąsk, _gkee, 
   {{0x61ed057f,0x63a8014e,0x20e30367,0x7bdc2bcc}},	//   _rial, tidn, _गणेश_, _khru, 
   {{0x2d822bcd,0x61ed2bce,0xdb052bcf,0xf2062bd0}},	//   _loke_, _sial, tihé, лямо, 
   {{0xf3632bd1,0x443f2bd2,0x3f812bd3,0xd5af0296}},	//   стын, atu_, _rohu_, _کفن_, 
   {{0x443f2bd4,0x62882bd5,0xa91d008b,0x7bc50053}},	//   btu_, rydo, _tože, zohu, 
   {{0x629a2bd6,0x61ed2bd7,0x7bc50053,0x143900d4}},	//   szto, _vial, yohu, _لينک_, 
   {{0x6d5d2bd8,0x60cd17ed,0x98a90083,0xd3700038}},	//   _sasa, _vyam, żać_, _ذهب_, 
   {{0x6d5d2bd9,0xcddb0d37,0x6d442bda,0x2d822bdb}},	//   _pasa, ења_, ffia, _boke_, 
   {{0x2d582bdc,0x6d5d2bdd,0xdb05078a,0x5d5502a0}},	//   лись_, _qasa, gihî, јкат, 
   {{0x6d5d2bde,0x7bdc0094,0x65600038,0xbf9b0216}},	// [1ef0] _vasa, _bhru, idmh, npêk, 
   {{0x6d5d2bdf,0x7bdc0a9a,0x69c92be0,0x9d150086}},	//   _wasa, _chru, _skee, িলেন_, 
   {{0x6d5d2be1,0x443f02ba,0xdeb2005e,0x2d8202a2}},	//   _tasa, ztu_, _дұры, _foke_, 
   {{0x6d5d0a75,0xbcfb2be2,0x64402be3,0x25fb0035}},	//   _uasa, _enér, ktmi, _लंबी_, 
   {{0x443f2be4,0xb8fd15c8,0xe8f82be5,0x9987010e}},	//   xtu_, _डर_, улі_, énő_, 
   {{0x8ae71222,0x7bdc0a75,0xab9500f0,0x321e0035}},	//   _бібл, _ghru, _тигі, ksty_, 
   {{0x69db2be6,0x61fc0183,0x01d60033,0x98a700ca}},	//   _thue, írll, _সংসদ, điđi_, 
   {{0x443f2be7,0x14252be8,0x7c2d2bc1,0x7bdc0356}},	//   ttu_, адим, orar, _zhru, 
   {{0x998400eb,0x443f2be9,0xa91d008b,0x765a00f8}},	//   _القو, utu_, _tožb, _esty, 
   {{0x395f2bea,0x443f2beb,0x25a62bec,0x7d0d10fd}},	//   _haus_, rtu_, _emol_, hbas, 
   {{0x395f2bed,0x65952bee,0xd57520f7,0xe10a15f5}},	//   _kaus_, _кажу, _вуль, кенд_, 
   {{0x9f49008c,0x7c2d2bef,0x6459084c,0x29350070}},	//   _stað_, krar, _tswi, סאָן_, 
   {{0x2d82008b,0x395f2bf0,0x64590548,0x20ba16d0}},	//   _roke_, _maus_, _uswi, тынь_, 
   {{0x395f01a0,0xa2e501bb,0x442d2265,0x765a02bf}},	//   _laus_, _колд, mre_, _ysty, 
   {{0xeab0100b,0xa3c22bf1,0x7c2d01f1,0x2d822bf2}},	//   _কর্ম, ंवर_, erar, _poke_, 
   {{0x442d0141,0x7bdc2bf3,0x7d0d2bf4,0x395f2bf5}},	//   ore_, _shru, gbas, _naus_, 
   {{0x7c2d2bf6,0x6db70112,0x6d442bf7,0xed572bf8}},	// [1f00] grar, pćan, rfia, шот_, 
   {{0x442d2bf9,0x31602bfa,0x8b26004f,0x25a902d9}},	//   ire_, _haiz_, рдже, čaly_, 
   {{0x6f1c04ff,0x442d2bfb,0x7d0d2bfc,0x9d462bfd}},	//   marc, hre_, bbas, _кенд, 
   {{0xd9462bfe,0x442d2bff,0xdb1c014e,0x395f2c00}},	//   реди, kre_, _skrä, _caus_, 
   {{0x7c2d002e,0x395f023b,0x442d2c01,0xed570093}},	//   crar, _daus_, jre_, _тоя_, 
   {{0x442d0bf7,0x0eba00a5,0x7df52c02,0xa50e0551}},	//   dre_, _उखाड, _sąsi, सर्च_, 
   {{0x395f023b,0xe8fa002e,0x660302a0,0x70d3031e}},	//   _faus_, _алб_, опја, _सर्ल, 
   {{0x442d2c03,0x6f1c2c04,0x31600a9f,0x85742c05}},	//   fre_, harc, _naiz_, слих, 
   {{0x57ea1472,0x442d0be0,0x6fc6009a,0x18a62c06}},	//   _адам_, gre_, लकां, _таам, 
   {{0x46a60141,0x07a31eec,0x394604ef,0x883b00a7}},	//   _казв, _даун, lfos_, _בתמו, 
   {{0x442d2c07,0x64402c08,0x6f1c2c09,0x395f006f}},	//   are_, stmi, darc, _yaus_, 
   {{0x442d2c0a,0x044616e1,0xa91d015e,0xa50a2c0b}},	//   bre_, _ведн, _koža, _реда_, 
   {{0x6f1c1115,0x2fc70023,0xdcef01dd,0x9f84003e}},	//   farc, _ưng_, ādīt, töð_, 
   {{0x6f1c1c6e,0x7c2d0012,0xa91d0121,0x53332c0c}},	//   garc, vrar, _moža, _дешт, 
   {{0x31602c0d,0x3da72c0e,0xbe882c0f,0xa3110032}},	//   _faiz_, араб, асте_, äčšo, 
   {{0x527b042c,0xdd982c10,0xb1152c11,0x70591271}},	//   _ינוא, ашу_, _умиш, _баир_, 
   {{0x7d0d2c12,0x7c2d2c13,0xdce6012d,0x395f2c14}},	// [1f10] rbas, urar, _mokė, _raus_, 
   {{0x7c2d01d6,0x395f2c15,0x6f1c2c16,0xd9bf0586}},	//   rrar, _saus_, carc, एक्ट, 
   {{0x395f2c17,0x2bbe0394,0x442d010e,0x7d0d039b}},	//   _paus_, ्तजा, zre_, pbas, 
   {{0x442d2c18,0x395f006d,0x7c2d2c19,0x75e7010e}},	//   yre_, _qaus_, prar, _tűzi, 
   {{0x395f006d,0x9f40022c,0x4dda00d1,0x3b1812ed}},	//   _vaus_, _guió_, _תחרו, _ferq_, 
   {{0x442d2c1a,0x06b20086,0xd874009c,0x9a8711e6}},	//   vre_, য়েছি, تامب, _кубл, 
   {{0xa6c92c1b,0x395f006f,0x442d010c,0xbf9b010c}},	//   ылка_, _taus_, wre_, rpêh, 
   {{0x6f1c2c1c,0xa2c1009a,0xa2ca0425,0xa3cf009a}},	//   zarc, _रुग्, _सुध्, _वीज_, 
   {{0x442d2c1d,0x7f8b06d0,0x291d2c1e,0x31600deb}},	//   ure_, _hüqu, mawa_, _raiz_, 
   {{0x442d0549,0x291d2c1f,0x31600938,0x61f80571}},	//   rre_, lawa_, _saiz_, _buvl, 
   {{0xa2ca00a2,0x442d0019,0x6f1c2c20,0xb17b05ac}},	//   _सुद्, sre_, varc, rmån, 
   {{0x442d20b9,0x291d2c21,0xd00a2c22,0x68ed026e}},	//   pre_, nawa_, леме_, žadu, 
   {{0x6f1c2c23,0x3160192c,0x764302a2,0x7dfc03a0}},	//   tarc, _vaiz_, ltny, _pčso, 
   {{0x291d2c24,0x7643016a,0xafe62c25,0xdb1e2c26}},	//   hawa_, otny, согл, kopá, 
   {{0x291d2c27,0x2d962c28,0x7761010c,0x38660098}},	//   kawa_, брас, _malx, zvor_, 
   {{0x6da31996,0x6f1c2c29,0x2b4a016a,0x7643016a}},	//   писа, sarc, _sbbc_, itny, 
   {{0x249f027c,0x291d2c2a,0xcaf600eb,0xa06a004e}},	// [1f20] nzum_, dawa_, مساب, _сапа_, 
   {{0xa91d2c2b,0xa3dd07d5,0x61e6098d,0x76432c2c}},	//   _roža, _थीम_, lmkl, ktny, 
   {{0xdb070019,0x25ad2c2d,0xb17b14a4,0xa91d0144}},	//   ámár, kiel_, kmål, _soža, 
   {{0x291d2c2e,0x386614f0,0xa91d0e25,0x38cb0116}},	//   gawa_, tvor_, _poža, گامی_, 
   {{0x53c706c9,0x25ad0187,0x6d562c2f,0x39462c30}},	//   रकाश, diel_, meya, rfos_, 
   {{0x6d562c31,0x38cb00d4,0xdb1e0183,0x9b960038}},	//   leya, دامی_, bopá, _الست, 
   {{0x25ad0285,0xdb1c0032,0x00000000,0x00000000}},	//   fiel_, _okrú, --, --, 
   {{0xd9432c32,0x2d8008b0,0x6d562c33,0x25ad2c34}},	//   _неси, njie_, neya, giel_, 
   {{0x76432c35,0xf8dc00b0,0x61f82c36,0x9f41009e}},	//   atny, _बरिय, _suvl, _cihû_, 
   {{0x5c5b00c7,0x6d562c37,0x388e00e0,0x6dac010c}},	//   נדיק, heya, _vērā_, xşan, 
   {{0xa91d0f58,0x25ad12f5,0x6d562c38,0x21790504}},	//   _možn, biel_, keya, айны_, 
   {{0x25ad2c39,0x73d9022c,0xa91d00bc,0x6d56009e}},	//   ciel_, лдөр_, _ložn, jeya, 
   {{0x6d562c3a,0x2d80018c,0x7df50009,0x23e603bd}},	//   deya, djie_, _ląst, _лікв, 
   {{0x291d00ab,0xdbf1031e,0x2ca000ef,0x9294088a}},	//   zawa_, _příl, dzid_, _малц, 
   {{0x291d2c3b,0xfdc400a5,0x6d562c3c,0x00000000}},	//   yawa_, वकूफ, feya, --, 
   {{0x6d56009c,0x2d80021e,0x00000000,0x00000000}},	//   geya, gjie_, --, --, 
   {{0x21291275,0x4dd40038,0x00000000,0x00000000}},	// [1f30] _idah_, ستفس, --, --, 
   {{0xdea4040f,0x291d2b22,0x2009019b,0x25ad2c3d}},	//   _کیفی, wawa_, _itai_, ziel_, 
   {{0x6d562c3e,0x9f8400b0,0x21290574,0x2d850212}},	//   beya, töö_, _kdah_, êles_, 
   {{0x6ab90a34,0x291d0053,0x8f55009c,0xe3b800ad}},	//   _आशीर, uawa_, _انگش, hnı_, 
   {{0xf7700399,0x25ad2c3f,0x2d9901da,0xc9740038}},	//   کان_, viel_, _ilse_, ثالث, 
   {{0x291d2c40,0x25ad038c,0x776100ad,0xdb150237}},	//   sawa_, wiel_, _qalx, _ekzò, 
   {{0x19950009,0x291d095a,0x25ad2c41,0x21290574}},	//   _давя, pawa_, tiel_, _odah_, 
   {{0x20090348,0x76432c42,0x7d1f021e,0x558900d9}},	//   _otai_, rtny, naqs, рбим_, 
   {{0x25ad2c43,0x92e60086,0xb17b0075,0x76432c44}},	//   riel_, যুৎ_, rmål, stny, 
   {{0x42252c45,0xb17b0d17,0x25ad2c46,0x7643016a}},	//   одов, smål, siel_, ptny, 
   {{0x80d100cc,0x6d562c47,0x25ad2c48,0x09b500c7}},	//   সেম্, yeya, piel_, ַפֿט_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x10a32c49,0x6d562c4a,0x69c30218,0x61e62c4b}},	//   диян, veya, îney, rmkl, 
   {{0x6d562c4c,0x21292c4d,0xaab90263,0xe3b32c4e}},	//   weya, _edah_, _आशंक, _عرش_, 
   {{0x59c908dd,0x2d800691,0x394d0065,0xa91d2c4f}},	//   िकार, tjie_, _obes_, _rožn, 
   {{0x753b2c50,0xa01b0080,0xee3700b3,0x00000000}},	//   nguz, työt, юнс_, --, 
   {{0x3b8601ba,0x8c432c51,0x5baa1628,0xae1a00a5}},	// [1f40] олаг, мете, акам_, _फौरन_, 
   {{0xa91d2c52,0x6d5603a0,0x394d0065,0x2d9900d1}},	//   _božo, seya, _abes_, _else_, 
   {{0xe8fa2c53,0x29040415,0x69cb16fa,0xfaa32c54}},	//   але_, _pfma_, foge, мафо, 
   {{0x7d1f00ad,0xfd12007a,0xe3b809c7,0x00000000}},	//   caqs, _تجد_, znı_, --, 
   {{0xa91d008b,0x386d0587,0xbcfb2c55,0x97c62c56}},	//   _tožn, _crer_, _kaén, ойде, 
   {{0x7c242c57,0x7d042c58,0xf09307e4,0x81c20033}},	//   msir, lcis, ונד_, ্গি_, 
   {{0x41ca29b0,0x69cb2c59,0xbf9b0107,0x7c242c5a}},	//   रवास, boge, mpêt, lsir, 
   {{0x69cb2c5b,0x7d042c5c,0x386d0118,0xa2ca0ed5}},	//   coge, ncis, _frer_, _सुष्, 
   {{0x7c242c5d,0xdb1e055f,0xc31e0086,0xb8660296}},	//   nsir, ropæ, _দাবি_, _بازو, 
   {{0x779200c5,0x7c242c5e,0x21290870,0x926a2c5f}},	//   _زیبا, isir, _sdah_, арма_, 
   {{0x20092c60,0xe3b82c61,0x69c30126,0x7dfc0237}},	//   _stai_, rnı_, éneg, _dčsk, 
   {{0x96330fb6,0x7c242c62,0xa1940965,0x79822c63}},	//   _ініц, ksir, даюч, njow, 
   {{0xa2ca000c,0x7c24044e,0x78a2014b,0x48b80086}},	//   _सुर्, jsir, nzov, _জরুর, 
   {{0x442600d0,0xc05800dd,0x69cb02f2,0x09b72c64}},	//   _ivo_, цію_, zoge, _अद्य, 
   {{0x44262c65,0x69cb0298,0xddab00d9,0xdef4021d}},	//   _hvo_, yoge, атал_, дпры, 
   {{0x212902f8,0x7c242c66,0x2bbf2c67,0x7520095a}},	//   _udah_, fsir, ्वभा, namz, 
   {{0x78a20bfc,0x69cb2c68,0x7c242c69,0x4426023e}},	// [1f50] jzov, voge, gsir, _jvo_, 
   {{0x09b3047b,0x69cb0547,0x63ba01c4,0x78a20228}},	//   ंच्य, woge, nntn, dzov, 
   {{0x69cb2c6a,0x59752c6b,0x75202c6c,0x7c240539}},	//   toge, зылу, kamz, asir, 
   {{0x442603ef,0x7d041e0c,0x44240065,0xceb20147}},	//   _ovo_, ccis, ksm_, _טיי_, 
   {{0x18692c6d,0x7d1d03c6,0x6c790070,0x44262c6e}},	//   сали_, _iess, _האָפ, _nvo_, 
   {{0x7d1d2c6f,0x69cb2c70,0x29dc0183,0xbdf81c03}},	//   _hess, soge, ríaa_, _دریا_, 
   {{0x442600a9,0xa2ca1d11,0x98bf00ca,0x29dc2c71}},	//   _avo_, _सुल्, _obuć_, mían_, 
   {{0xc4850fa7,0xf1c00098,0x386d00fc,0xdb1c00fb}},	//   злик, čák_, _trer_, _skrø, 
   {{0x7d1d0e95,0xe3b10040,0x937900eb,0x799b0102}},	//   _mess, فرد_, مصدر_, _iluw, 
   {{0xf8ae00d6,0x29dc08f4,0x798901a9,0x63792b8d}},	//   _حکم_, nían_, _hoew, ссир_, 
   {{0x442602f5,0x799b2c72,0x216a2c73,0x442400ca}},	//   _evo_, _kluw, бини_, asm_, 
   {{0x7d1d199a,0xe610009c,0xbcfb00d4,0xafdb017b}},	//   _ness, _ششم_, _saén, støl, 
   {{0xb4fa00a7,0x764b012d,0x92b50499,0x798908b0}},	//   _הפני, žnyč, تحکا, _moew, 
   {{0x7c24040c,0x6dac027e,0x2245012b,0x9f580248}},	//   vsir, rşam, ptlk_, _özün_, 
   {{0x7d1d02f2,0x29dc0503,0x2d962c74,0x6d4f01be}},	//   _bess, dían_, прас, _bbca, 
   {{0x7c242c75,0x7d1d2c76,0xb88300bc,0x91e32c77}},	//   tsir, _cess, _klíč, _поще, 
   {{0x7d1d2c78,0x7d042c79,0xe3190023,0x6da32107}},	// [1f60] _dess, rcis, _điể, хита, 
   {{0xa01b0088,0x29dc00e9,0x799b0539,0x7d040df7}},	//   pyör, gían_, _aluw, scis, 
   {{0x4efb0056,0x61e42c7a,0x7c242c7b,0xc33200a7}},	//   _להיו, _khil, ssir, תוב_, 
   {{0xd7fa005b,0x7d1d2c7c,0x799b011c,0xdb052c7d}},	//   бук_, _gess, _cluw, rihá, 
   {{0x29dc1056,0x61e40a75,0x799b01e5,0x7989011c}},	//   bían_, _mhil, _dluw, _doew, 
   {{0xc7a3081b,0x29dc0503,0x78a22508,0x07a32c7e}},	//   ничк, cían_, rzov, начн, 
   {{0x442606b6,0x7d1d2c7f,0xdb1e01c4,0x799b2c80}},	//   _svo_, _yess, ropä, _fluw, 
   {{0x2abb00a7,0x44260fa5,0x79890326,0xfaa60283}},	//   _המלא, _pvo_, _goew, _даҳо, 
   {{0x3a3a0405,0x2122023e,0x75202c81,0xa5070267}},	//   lupp_, dakh_, ramz, чења_, 
   {{0xe44f0084,0x61e42c82,0x6f1e090e,0x00000000}},	//   اضي_, _ahil, _nepc, --, 
   {{0x61e40a75,0xaabe00ae,0x7dda0c0c,0x2bbf1a21}},	//   _bhil, ्थिक, eïsm, ्वता, 
   {{0x61e42c83,0x4426003e,0x867b00d1,0xc10800b3}},	//   _chil, _tvo_, _לרבו, зэре_, 
   {{0x7d1d2c84,0xa91d2c85,0x61e41430,0x44260097}},	//   _ress, _božj, _dhil, _uvo_, 
   {{0x7d1d2c86,0xa91d2c87,0x29dc0068,0x6447020f}},	//   _sess, _rožm, xían_, ăjit, 
   {{0x7d1d00ce,0xd3e513b4,0x29dc0634,0x6d980183}},	//   _pess, _تقوی, vían_, _vían, 
   {{0x61e42c88,0xbcfb0042,0x6dac2c89,0x5d6400fd}},	//   _ghil, _gaél, nşah, нтуз, 
   {{0x6ecd2c8a,0x29dc0634,0x6c542c8b,0xa3d00e07}},	// [1f70] _दुरु, tían_, нкту, वकप_, 
   {{0x7d1d08b0,0x69c00242,0x7e6102c9,0xa2a0009a}},	//   _wess, _ajme, ælps, खनप्, 
   {{0x29dc128a,0x7d1d2c8c,0xecf90fb6,0xbb8400eb}},	//   rían_, _tess, _менш_, علمي, 
   {{0x6f1e2c8d,0xbcfb0175,0x4c95040c,0x00000000}},	//   _zepc, _kaém, _жимс, --, 
   {{0xa3cc2c8e,0x6d4d016a,0xa3c1009a,0x00000000}},	//   लवा_, mfaa, ्कम_, --, 
   {{0x2d8b0519,0x6d4d2c8f,0x21222c90,0x7989011c}},	//   _hoce_, lfaa, zakh_, _woew, 
   {{0xb8f42c91,0x6b83008c,0x29dc0183,0x79892c92}},	//   _सु_, öngu, cíao_, _toew, 
   {{0x6d4d2c93,0x24092c94,0x799b02cd,0x2d8b2c95}},	//   nfaa, онии_, _uluw, _joce_, 
   {{0xd4692b65,0xafdb0566,0x93592167,0x00000000}},	//   ципе_, rtøj, орну_, --, 
   {{0x61e42c96,0x2d8b0068,0x69d92c97,0x9f530107}},	//   _shil, _loce_, llwe, _fixé_, 
   {{0x61e42c98,0x95cb1a41,0x2a630175,0x00000000}},	//   _phil, _луда_, _jsjb_, --, 
   {{0x2d8b2c99,0x22a20574,0x6f1e0474,0x00000000}},	//   _noce_, _séké_, _sepc, --, 
   {{0x81c20086,0x69d9084c,0x27ff00c2,0x291f03dd}},	//   ্গল_, ilwe, _juun_, _meua_, 
   {{0x82351fdb,0x67232c9a,0x61e40056,0xe2992c9b}},	//   _قربا, nanj, _whil, _мал_, 
   {{0x020500cf,0x61e42c9c,0x2d8b0112,0x6d4d2c9d}},	//   _ўзин, _thil, _boce_, ffaa, 
   {{0x656905f0,0x67232c9e,0x291f0201,0x68fb2c9f}},	//   ndeh, hanj, _neua_, _ngud, 
   {{0x64492ca0,0x67231af7,0xbfc62ca1,0x2d8b2ca2}},	// [1f80] ntei, kanj, _обик, _doce_, 
   {{0xd9b803a2,0xbf9b009e,0x69d92a5a,0x6d4d01b8}},	//   ेक्ट, spêr, elwe, afaa, 
   {{0x6da6005e,0x236702ee,0x64492ca3,0x6d4d006d}},	//   _жина, _manj_, htei, bfaa, 
   {{0x2d8b2ca4,0x64492ca5,0x3a3a2ca6,0x29dc0068}},	//   _goce_, ktei, rupp_, ríao_, 
   {{0x26030f46,0xdcb9030f,0xc7c62035,0x67232ca7}},	//   _año_, _ещё_, мски, fanj, 
   {{0x31bb1d5b,0x65690d2d,0x29062ca8,0xdce4014b}},	//   _उद्ध, edeh, scoa_, ndič, 
   {{0x6e3c0126,0xc34e00e7,0x45d404e9,0x291f01e5}},	//   nurb, _bổng_, нокс, _feua_, 
   {{0xc34e001b,0x64492ca9,0x21200054,0xafdb0664}},	//   _cổng_, ftei, _neih_, ttøk, 
   {{0x13f40f82,0x29e80095,0x394402aa,0x6db70372}},	//   нзия, _uşaq_, _icms_, pćav, 
   {{0x672302f5,0x96960141,0x6e3c003e,0x68fb00b3}},	//   canj, _ореш, kurb, _zgud, 
   {{0xa2940c8b,0x777a01ca,0xbcfb002c,0xf2c62caa}},	//   хані, _intx, _saém, ьсин, 
   {{0x14af009a,0x40352cab,0x200002a5,0x64490380}},	//   _जेवण, немс, _buii_, btei, 
   {{0x14e2203f,0x2d8b031e,0xdb1c2cac,0x3a2a0126}},	//   _परिण, _roce_, _skrý, _lvbp_, 
   {{0x61ee0187,0x200000a1,0x7c36023a,0x00000000}},	//   _ďale, _duii_, dryr, --, 
   {{0x2bbf2cad,0x2d8b0ab4,0xdb0e00f6,0x6e3c01d5}},	//   ्वसा, _poce_, _imbè, gurb, 
   {{0x23670707,0xa2ad000d,0x7d160326,0x21200175}},	//   _zanj_, ुपर्, gbys, _geih_, 
   {{0x2d8b12b3,0xf1bf026e,0xab7502f1,0x67232cae}},	// [1f90] _voce_, mná_, нгаш, yanj, 
   {{0xf1bf063b,0xa3e40790,0x291f03a1,0x6d4d2caf}},	//   lná_, _भीम_, _seua_, sfaa, 
   {{0x6e3c270f,0x2d8b0036,0xdb1c0098,0x69d9084c}},	//   curb, _toce_, _ukrý, tlwe, 
   {{0xf1bf2cb0,0xa91d0f4c,0x67232cb1,0x777a01f1}},	//   nná_, _koži, wanj, _antx, 
   {{0x672303ef,0xdb0e00d7,0x644911a5,0x31692cb2}},	//   tanj, _ombè, xtei, _maaz_, 
   {{0xf77100eb,0xa3dd00ab,0x23dd03ce,0x66e52cb3}},	//   طات_, _थीं_, _नींद, нола, 
   {{0x67232cb4,0x92c20086,0xe91900dd,0xa91d2cb5}},	//   ranj, ্ধু_, _нові_, _loži, 
   {{0x64492cb6,0xf1bf05a8,0xdb0e011c,0x7afc0372}},	//   ttei, jná_, _ambè, _zgrt, 
   {{0xf1bf08fc,0x656915fb,0x23672cb7,0xa91d03ac}},	//   dná_, rdeh, _panj_, _noži, 
   {{0x64492cb8,0x2fd100ca,0x4374004f,0x38341152}},	//   rtei, jozg_, вуют, _шнур, 
   {{0xc34e0029,0xfbd200a7,0x61462cb9,0xb34511c9}},	//   _tổng_, רתי_, нена, _acçã, 
   {{0x56942cba,0x216a2cbb,0x64492cbc,0x67212cbd}},	//   _шахт, чими_, ptei, _helj, 
   {{0x25bf002e,0x02cf051f,0x7f5c0b7f,0x66012cbe}},	//   mnul_, _सुरभ, terq, _hulk, 
   {{0x66012cbf,0x67210082,0x81bd01dd,0xa2ca2cc0}},	//   _kulk, _jelj, nsēj, _सुक्, 
   {{0x6601030f,0xe2992cc1,0xf1bf026e,0x25bf00b3}},	//   _julk, _хай_, bná_, onul_, 
   {{0x660102f1,0xf1bf014b,0xdd921ea7,0x4d631a69}},	//   _mulk, cná_, دور_, лксв, 
   {{0x7d162cc2,0xbcfb002c,0x45da0070,0x7e65040c}},	// [1fa0] rbys, _maéh, פֿלא, _eshp, 
   {{0xa3c1000f,0x67211ab9,0xf40100cc,0x9e662cc3}},	//   ्कि_, _nelj, _এবার_, _звод, 
   {{0x1b1f0086,0xdb1c0035,0xa91d0144,0x00000000}},	//   _পাশে_, _skró, _zoži, --, 
   {{0x9965004e,0x6da6004f,0x00000000,0x00000000}},	//   ктіл, _чима, --, --, 
   {{0x1b1f00cc,0x67211eeb,0x660101ca,0x69c30212}},	//   _পারে_, _belj, _aulk, énea, 
   {{0x672102ee,0xf1bf05a8,0x764a0219,0xd7ef0038}},	//   _celj, zná_, ttfy, مكن_, 
   {{0x1ae302f1,0x67212cc4,0x66010237,0x6db700ef}},	//   _борм, _delj, _culk, mćar, 
   {{0xa2ca08f1,0x66010009,0x25bf020f,0xf1bf0032}},	//   _सुग्, _dulk, gnul_, xná_, 
   {{0xf1bf143b,0xb7da1a38,0xe73a2cc5,0xdb0e002c}},	//   vná_, _فورا_, _неа_, _ambé, 
   {{0xc45300eb,0xa91d2cc6,0x25bf00b3,0xbcfb0175}},	//   اضيع, _roži, anul_, _paék, 
   {{0xf1bf0076,0x363613b4,0xe7372cc7,0x668105fa}},	//   tná_, _سراس, _чех_, _نیول, 
   {{0x672100d2,0xa91d2cc8,0xf484009c,0x6b8e008a}},	//   _zelj, _poži, _لاتی, _lobg, 
   {{0x55770137,0xf1bf0076,0x66012cc9,0xdb0e0175}},	//   _רעדן_, rná_, _zulk, _embé, 
   {{0xe47b0111,0x53342cca,0xf1bf026e,0xbcfb0175}},	//   _מרדכ, _рект, sná_, _taék, 
   {{0xf1bf026e,0x2fd100ca,0xade700fd,0x00000000}},	//   pná_, rozg_, ецак, --, 
   {{0x13d50086,0xa3e40a34,0xa91d0352,0xcdd802a6}},	//   _হওয়, _भीत_, _toži, ењу_, 
   {{0x41c40ce0,0x7de400f0,0x0dc81a57,0x00000000}},	// [1fb0] _حقيق, уірд, хури_, --, 
   {{0x752202be,0x9f5a0216,0x6d462ccb,0x00000000}},	//   _leoz, _lipê_, _ecka, --, 
   {{0x7cea039f,0x00000000,0x00000000,0x00000000}},	//   töré, --, --, --, 
   {{0xc98425b6,0xdd160032,0x98b90097,0x00000000}},	//   лучи, _päťd, млет_, --, 
   {{0x66012ccc,0x6721257c,0x6ce4004e,0xa3d0031e}},	//   _sulk, _pelj, _біре, वका_, 
   {{0x66012ccd,0x6d5f2cce,0xb17b02ae,0xfbd9120f}},	//   _pulk, leqa, llåd, _बीचम, 
   {{0x67212ccf,0xbbbf0ffc,0x36660093,0x19ab2cd0}},	//   _velj, ्वीक, ващо_, _етап_, 
   {{0x6d5f12ed,0x25bf00b3,0xbcfb0096,0x2d892cd1}},	//   neqa, unul_, _paéh, njae_, 
   {{0x67212cd2,0x9f530161,0x25bf00d9,0x57f52cd3}},	//   _telj, _així_, rnul_, _апат, 
   {{0x66012cd4,0x43752cd5,0xc6a71219,0xe87403b8}},	//   _tulk, туит, _преи, _حافظ, 
   {{0x2d892cd6,0xb2f400c8,0x0cde2830,0x6d5f009e}},	//   kjae_, ляющ, _मर्म, keqa, 
   {{0xe2962cd7,0x7afa2cd8,0xe1960080,0x75c800d8}},	//   таю_, _útte, троэ, těze, 
   {{0x6d5f0640,0x2ca92cd9,0x656b00a1,0x00000000}},	//   deqa, jzad_, _iagh, --, 
   {{0x656b0084,0x2ca902fe,0x7fd5004e,0xe3b30816}},	//   _hagh, dzad_, гісі, _حرص_, 
   {{0x443f2cda,0x6d46012b,0x7e231221,0xff07002e}},	//   luu_, _pcka, идрж, теск_, 
   {{0xdde900d4,0xfce62cdb,0x656b007b,0xa2ca009a}},	//   فرقه_, вобо, _jagh, _सुट्, 
   {{0x656b2cdc,0x443f2cdd,0xab2a1a57,0x00000000}},	// [1fc0] _magh, nuu_, доза_, --, 
   {{0x4e06078c,0x656b009f,0x9f4c00c8,0xb17b017b}},	//   _изоб, _lagh, ödä_, småt, 
   {{0x6a860141,0x3ea62cde,0x443f2cdf,0x91fc01dd}},	//   ължа, _ринг, huu_, lvār, 
   {{0x443f2ce0,0x656b1410,0x290d0068,0x645910f3}},	//   kuu_, _nagh, _cfea_, _opwi, 
   {{0x92bd00cc,0x91fc00e0,0x443f2ce1,0x68430a10}},	//   _আরো_, nvār, juu_, инца, 
   {{0x6d442ce2,0x244b055f,0xafdb01e8,0xeb9f00fb}},	//   lgia, døm_, støv, _støv_, 
   {{0x64590118,0xacbb0212,0xdce60118,0x00000000}},	//   _apwi, _jeûn, _makč, --, 
   {{0x6d442ce3,0xd49a03dc,0x443f0053,0xa91d0a1a}},	//   ngia, дро_, fuu_, _božu, 
   {{0x80e111bd,0x656b2ce4,0x443f0053,0x6d442ce5}},	//   _नरें, _dagh, guu_, igia, 
   {{0x6d442ce6,0xb4e2010f,0xa91d0242,0x69c20082}},	//   hgia, _धरी_, _dožu, lnoe, 
   {{0x752202fe,0x656b2ce7,0xc7d700d1,0xbb3b00d1}},	//   _teoz, _fagh, _יומי_, ועיי, 
   {{0x80d10086,0x443f018e,0x69c200f8,0xc05b017b}},	//   _সৃষ্, buu_, nnoe, міг_, 
   {{0xb17b0219,0xa3c102e6,0x753d039f,0x64a30e27}},	//   vlåd, ्कश_, ósze, _каца, 
   {{0x64402ce8,0x4fc42ce9,0x656b2cea,0xf45700d1}},	//   mumi, асса, _zagh, _סיור_, 
   {{0x64402ceb,0xa3c10bf5,0x93fb035c,0x75e5010e}},	//   lumi, ्कर_, _קלוי, lóza, 
   {{0x6d44048a,0x46b500b0,0x7bde039b,0x00000000}},	//   ggia, _अइसह, elpu, --, 
   {{0x64402cec,0x3b552ced,0x5c752cee,0x2d890183}},	// [1fd0] numi, лкар, ылат, rjae_, 
   {{0xbbbf000c,0x765a0035,0x5b14004f,0xd24d010e}},	//   ्वेक, _opty, имут, _بچی_, 
   {{0x6440086d,0xce950e65,0x6e950024,0x443f24fc}},	//   humi, _санъ, _сину, zuu_, 
   {{0x64402cef,0x99d10086,0x57cb009a,0xac1900b3}},	//   kumi, িষ্ক, िव्ह, _пому_, 
   {{0x7c842aa5,0x6440002a,0x656b2cf0,0x9f5a0118}},	//   _куре, jumi, _ragh, _bipè_, 
   {{0xb605035e,0x64402cf1,0x7d0d2cf2,0x7c2d2cf3}},	//   hláš, dumi, lcas, msar, 
   {{0x656b1410,0x7d0d02a3,0x45d50ec6,0xc6a700fd}},	//   _pagh, ocas, лцит, ърди, 
   {{0x4efc0056,0x443f0088,0xa91d0112,0x64402cf4}},	//   ולוג, tuu_, _požu, fumi, 
   {{0x64402cf5,0xa3c10239,0x656b02a3,0x7bc702a5}},	//   gumi, ्कल_, _vagh, _kjju, 
   {{0x443f2cf6,0x244b03a9,0x7d0d00a1,0xa77402a0}},	//   ruu_, røm_, hcas, _клуч, 
   {{0xe2992cf7,0x656b2cf8,0x6d4400f8,0x443f2cf9}},	//   хан_, _tagh, ygia, suu_, 
   {{0xe570195e,0x64402cfa,0x443f03f0,0x7c2d2cfb}},	//   _وطن_, bumi, puu_, ksar, 
   {{0xad9b2cfc,0x64400f77,0x7c2d02ae,0x7d0d2cfd}},	//   _miúd, cumi, jsar, dcas, 
   {{0x442d2cfe,0x7c2d0c43,0x442f2cff,0x75292d00}},	//   mse_, dsar, _ivg_, laez, 
   {{0x442d2d01,0xd5ac006b,0x442f010e,0x6da62ad6}},	//   lse_, _رہی_, _hvg_, гива, 
   {{0x442d2d02,0x69c3010e,0x7bc701a3,0x5d6700b3}},	//   ose_, énel, _ajju, лисм_, 
   {{0x442d2d03,0x707700eb,0x6d442d04,0x6abe0c3a}},	// [1fe0] nse_, _مميز_, rgia, ्थ्र, 
   {{0x442d2d05,0x442f2d06,0x7d0d0068,0x6d4400f8}},	//   ise_, _mvg_, acas, sgia, 
   {{0x64402d07,0x442d2d08,0x8ad500e4,0xb17b02c9}},	//   zumi, hse_, аюцц, slåe, 
   {{0x442d2d09,0x9f5a06df,0x7d0d02a3,0xafdb01e8}},	//   kse_, _sipè_, ccas, støt, 
   {{0x64e205fd,0x442d2d0a,0x69c22d0b,0xb4e200a5}},	//   _परेश, jse_, rnoe, _धरे_, 
   {{0x38cb0f1c,0x442d2d0c,0xb7d20086,0x64402d0d}},	//   رانی_, dse_, াষ্ট, vumi, 
   {{0xfaa607f9,0x7bcb2a7e,0x499413b4,0xaab82488}},	//   _саво, égue, _پیشر, _आधिक, 
   {{0x64402d0e,0xad9b007a,0xafdb00fb,0x442d2d0f}},	//   tumi, _giúd, ntør, fse_, 
   {{0xd3262d10,0x442d2d11,0xb99300eb,0x48e302c4}},	//   льни, gse_, _القب, _готв, 
   {{0x64402d12,0xf3661cde,0x39462d13,0x32542d14}},	//   rumi, утин, lgos_, авор, 
   {{0x442d2d15,0x7c2d002a,0xafdb03a9,0x66e600c8}},	//   ase_, zsar, ktør, _сожа, 
   {{0x39462d16,0x442f02a3,0xbcfb17f9,0x64402d17}},	//   ngos_, _fvg_, _kaét, pumi, 
   {{0xc5f300a7,0x442d2d18,0x88bd0035,0xdb1e2d19}},	//   _הדף_, cse_, _leśn, nopó, 
   {{0x6ed61898,0x7c2d03fa,0x7d0d2d1a,0x75e500da}},	//   _मुहु, vsar, wcas, nózn, 
   {{0x7c2d0920,0x539b0486,0x98ad0121,0xee842d1b}},	//   wsar, _איגו, _rdeč_, быто, 
   {{0x63ba035e,0x7c2d05f0,0x27ec00e2,0xc27b035c}},	//   litn, tsar, _lhdn_, _טרוי, 
   {{0x7d0d2d1c,0x69c3026d,0x26de016a,0x61ed2d1d}},	// [1ff0] rcas, énem, _lyto_, _ihal, 
   {{0x212b2d1e,0x39462d1f,0x63ba11bc,0x79800300}},	//   lach_, egos_, nitn, _anmw, 
   {{0x7c2d2d20,0x61ed2d21,0xf1ca0cb8,0x5fdc00d1}},	//   ssar, _khal, रवचन, _אחזק, 
   {{0x212b2d22,0x7c2d2d23,0x442d2d24,0x63ba01ff}},	//   nach_, psar, yse_, hitn, 
   {{0x3949002a,0x18692d25,0x63ba120c,0x61ed1232}},	//   ļas_, тали_, kitn, _mhal, 
   {{0x212b0094,0xe7362d26,0x629a012d,0x3946012d}},	//   hach_, аеш_, kyto, agos_, 
   {{0x212b2d27,0x442d2d28,0x8ae401fc,0x69ca0107}},	//   kach_, wse_, _гітл, éfec, 
   {{0x442d2d29,0x629a17da,0x212b0035,0x2bbf1f9a}},	//   tse_, dyto, jach_, ्वका, 
   {{0x212b2d1e,0x291d2d2a,0x442d2d2b,0x752901ca}},	//   dach_, mbwa_, use_, raez, 
   {{0xe7a90351,0x61ed2d2c,0x63ba2d2d,0x7bd70042}},	//   _कतिप, _ahal, gitn, noxu, 
   {{0x61ed2d2e,0x212b2d2f,0xa2e52d30,0x60cd040c}},	//   _bhal, fach_, ронд, _axam, 
   {{0x442d2d31,0x442f0496,0x76432d32,0x61ed2d33}},	//   pse_, _tvg_, muny, _chal, 
   {{0x61ed2d34,0x764301bb,0x15f40e05,0x3f9311bb}},	//   _dhal, luny, _اسلح, _boxu_, 
   {{0x629a2d35,0x63ba0fb5,0x7fd6004e,0x39462d36}},	//   byto, citn, рімі, zgos_, 
   {{0x212b2d37,0x3946012d,0x76432d38,0xc7b200d1}},	//   bach_, ygos_, nuny, קבל_, 
   {{0x61ed2d39,0x3d2000ab,0xd1ba006b,0x4ad909ec}},	//   _ghal, बरें_, _جاتا_, _बुधव, 
  
   {{0x8c462d3a,0x5ba40f5a,0x4b262831,0xafdb01e8}},	// [2000] резе, блағ, имав, rtør, 
   {{0x69db018e,0x109b03e1,0xafdb14a4,0x69c901b8}},	//   _akue, _סביב, stør, _ajee, 
   {{0x32070161,0x34e20964,0x7643085f,0x7f3b00a7}},	//   _juny_, _पर्द, juny, _בעיו, 
   {{0x3946012d,0x3207023e,0x7643033e,0xeae600a2}},	//   ugos_, _muny_, duny, _करीत_, 
   {{0x39462d3b,0x8eb300d4,0xa91d2d3c,0x629a0083}},	//   rgos_, _همیش, _požr, zyto, 
   {{0x81bd002a,0x394608f4,0x76430547,0x212b23bc}},	//   lsēt, sgos_, funy, zach_, 
   {{0x76432d3d,0x56942d3e,0x75e52041,0x798002a5}},	//   guny, сайт, rózn, _tnmw, 
   {{0x63ba2d3f,0x6d5606df,0xe5c602a6,0xd9432d40}},	//   witn, nfya, јско, _меси, 
   {{0x88bd006a,0x2fd8014e,0x77630068,0x29042d41}},	//   _jeśl, korg_, benx, _igma_, 
   {{0x386900e5,0x26de031e,0x76432d42,0x212b0035}},	//   çare_, _tyto_, buny, wach_, 
   {{0x212b2d43,0x61ed2d44,0x76432d45,0x6ed6031e}},	//   tach_, _phal, cuny, _मुलु, 
   {{0x29dc0634,0x96952d46,0x61ed084c,0x629a2d47}},	//   mías_, _уруш, _qhal, ryto, 
   {{0x212b2d48,0x29dc0634,0x67282d49,0xdb0e0054}},	//   rach_, lías_, _kedj, _ombà, 
   {{0x212b2d4a,0x2d822d4b,0x644f00d3,0xd83f063b}},	//   sach_, _anke_, àcie, _účet_, 
   {{0x61ed2d4c,0x67282d4d,0x29dc0634,0x212b2d4e}},	//   _thal, _medj, nías_, pach_, 
   {{0x67280d26,0x61ed0053,0xdda8002e,0xdce601dd}},	//   _ledj, _uhal, атул_, _sakā, 
   {{0x2fd82d4f,0xdce601dd,0x6be50038,0x3f9300b4}},	// [2010] borg_, _pakā, مكرم, _toxu_, 
   {{0x672802a8,0xa3e6141c,0x69db03a9,0x2d822d50}},	//   _nedj, पति_, _skue, _enke_, 
   {{0x68e90019,0x20010102,0x7ff420b4,0x29dc0369}},	//   _szed, _iihi_, _بسيا, jías_, 
   {{0x7643097a,0x29dc0503,0xe61902f1,0xbcfb0a0f}},	//   vuny, días_, қди_, _daér, 
   {{0xe7392d51,0xa3e600c9,0xa2d8047c,0x68e002bf}},	//   гел_, पता_, _नुस्, _cymd, 
   {{0x785a002a,0x76432d52,0x29dc1056,0x8a1700c5}},	//   dāvā, tuny, fías_, _نظرا, 
   {{0xf77000b8,0x29dc08f4,0x77630068,0x69c902b0}},	//   بان_, gías_, renx, _tjee, 
   {{0x76432129,0x2fd8012e,0x6b95019b,0x20090212}},	//   runy, zorg_, _hozg, _ouai_, 
   {{0xbee40351,0x76432d53,0x68e00156,0x69d92d54}},	//   _गर्न_, suny, _gymd, mowe, 
   {{0xe7840a27,0x76430985,0x29dc060f,0x69d92d55}},	//   _мухо, puny, bías_, lowe, 
   {{0x29dc0503,0x6b950a62,0xd575012d,0x70b21c54}},	//   cías_, _mozg, _гуль, ीप्ल, 
   {{0x35f52d56,0x200900e2,0x672800ef,0xdcfd05d5}},	//   _упер, _buai_, _zedj, _ansč, 
   {{0xd24e0399,0x200900e2,0x2fd8003e,0x212901be}},	//   ونی_, _cuai_, torg_, _deah_, 
   {{0x443f2d57,0x20090065,0xf41200a7,0x69d90083}},	//   mru_, _duai_, _צפו_, howe, 
   {{0x23652c9e,0xdee625a1,0x69d90035,0x394d0304}},	//   melj_, сови, kowe, _oces_, 
   {{0x2900012d,0x394d006d,0xdce40112,0xdced0228}},	//   žiai_, _nces_, ndić, adač, 
   {{0x69d900ab,0x20092d58,0x6b952d59,0x3f8c00c2}},	// [2020] dowe, _guai_, _bozg, ödus_, 
   {{0x68e00219,0x31720508,0x00000000,0x00000000}},	//   _rymd, _hayz_, --, --, 
   {{0x29dc0496,0x443f2d5a,0x490600eb,0x67280ab4}},	//   xías_, hru_, مواق, _redj, 
   {{0x5d860084,0x7053086b,0x29dc033c,0x6d980183}},	//   _الحل, _بنیا, vías_, _vías, 
   {{0x6b9500ef,0x67280097,0xdb0e0183,0xc7ba0504}},	//   _fozg, _pedj, _embá, лёк_, 
   {{0x443f2d5b,0x29dc2769,0x236502fe,0x394d002c}},	//   dru_, tías_, jelj_, _eces_, 
   {{0x443f2d5c,0x9f520126,0x386d0241,0x69d90083}},	//   eru_, _huyó_, _eser_, bowe, 
   {{0x29dc127e,0x98a62b88,0x443f2d5d,0x29040008}},	//   rías_, _либе, fru_, _ugma_, 
   {{0x443f2d5e,0x29dc0634,0x6b952d5f,0x9f5a02a3}},	//   gru_, sías_, _yozg, _pipì_, 
   {{0x29dc033c,0x23650144,0x21290096,0x00000000}},	//   pías_, gelj_, _seah_, --, 
   {{0x20090348,0x225800c8,0x4df80d53,0xe71700d1}},	//   _suai_, шины_, ंगाई_, _החבר_, 
   {{0x443f288e,0x25a6011d,0xeae600b0,0xf1a72d60}},	//   bru_, _ulol_, _करैत_, срон, 
   {{0x443f0012,0x20092d61,0x6ac4058c,0xf8a800bd}},	//   cru_, _quai_, वपुर, कनिय, 
   {{0x33f6081b,0x44260727,0x4fc700c8,0x69d92d62}},	//   _учес, _iwo_, ссма, zowe, 
   {{0x3da70845,0x69d90053,0xdced05ae,0x6b952d63}},	//   браб, yowe, rdač, _rozg, 
   {{0xd13100d4,0x200900e2,0xb60600ca,0x64402d64}},	//   _کمک_, _tuai_, mišć, ormi, 
   {{0xdcfd00ef,0xb6060864,0xf1bf0183,0xd011015f}},	// [2030] _posđ, lišć, miá_, _تلخ_, 
   {{0x6ac4141c,0x44262d65,0x66022d66,0x64400038}},	//   वपूर, _mwo_, _liok, irmi, 
   {{0x69d92d67,0x3cde00a2,0xdd9521f4,0x29dc2d68}},	//   towe, _कुठे_, _даны, víar_, 
   {{0x19592d69,0x127b00c7,0x443f2d6a,0x660205b5}},	//   рады_, טאבע, yru_, _niok, 
   {{0xf09f03a1,0x69d92d6b,0x6d5d2d6c,0x3c44011f}},	//   nyà_, rowe, _ibsa, _нэрв, 
   {{0x645c002e,0x01cf0086,0xbcfb011c,0x69d92d6d}},	//   ăril, রতিদ, _abég, sowe, 
   {{0x44262d6e,0x443f0463,0x64400aa7,0x23650352}},	//   _awo_, wru_, ermi, velj_, 
   {{0x44261f69,0x84592d6f,0xb6060308,0x394d16a8}},	//   _bwo_, арот_, dišć, _uces_, 
   {{0x386d0056,0x442602a2,0xf1bf0228,0x64400372}},	//   _user_, _cwo_, diá_, grmi, 
   {{0x443f2d70,0xdb0e003e,0xfe0902e6,0x44260118}},	//   rru_, _embæ, वदास_, _dwo_, 
   {{0x6d5d08d7,0x66020097,0x6d4f2099,0x6b83010e}},	//   _obsa, _fiok, _occa, öngy, 
   {{0xe56e0c67,0x443f2d71,0x659401a2,0x66020036}},	//   _ўз_, pru_, _наху, _giok, 
   {{0x44262d72,0x2365015e,0x25bf00b3,0xeae600bd}},	//   _gwo_, pelj_, miul_, _कर्त_, 
   {{0x6d4f0141,0x25bf00d9,0xbcfb00d7,0x3cdd02fc}},	//   _acca, liul_, _mbéd, _खड़े_, 
   {{0x2d962d73,0xbcfb0175,0x1d0a2d74,0xf1bf09c6}},	//   орас, _saép, иеви_, biá_, 
   {{0x25bf002e,0x3dc90495,0x1d072d75,0x0c260d3d}},	//   niul_, gnaw_, жети_, жман, 
   {{0x249f2d76,0x752b2d77,0x7d060226,0xa06a2d78}},	// [2040] nyum_, _megz, _vgks, _тапа_, 
   {{0x0fc3004e,0x25bf00b3,0x61e60677,0x6d4f0027}},	//   _ойын, hiul_, llkl, _ecca, 
   {{0xed5a00ce,0x3dc9011d,0x00000000,0x00000000}},	//   _кон_, bnaw_, --, --, 
   {{0xe9da2d79,0xd378044e,0x00000000,0x00000000}},	//   шке_, moće_, --, --, 
   {{0x25bf002e,0x25ad00d7,0x999c039f,0x00000000}},	//   diul_, dhel_, évő_, --, 
   {{0x4426024d,0xc7a315f5,0x66022d7a,0x3869019c}},	//   _rwo_, мичк, _siok, çara_, 
   {{0xd3780613,0x81c30033,0x7bce01d2,0x00000000}},	//   noće_, ্তত_, _ijbu, --, 
   {{0x2cbf0613,0x25ad2d7b,0x2d92024d,0x25bf00b3}},	//   _žudi_, ghel_, njye_, giul_, 
   {{0x938a2d7c,0xd37800ca,0xa73a010e,0xf1bf0d57}},	//   асна_, hoće_, _نثار_, viá_, 
   {{0xa3e40262,0x442601c8,0xd3780304,0xb60602c7}},	//   _भीख_, _vwo_, koće_, tišć, 
   {{0x86c600eb,0xf1bf03da,0x25bf2d7d,0xcb1300a7}},	//   _بيان, tiá_, biul_, ולת_, 
   {{0xb6062d7e,0x44260056,0x25bf002e,0x2900012d}},	//   rišć, _two_, ciul_, žiau_, 
   {{0x4426099d,0x25d900d4,0xcf0000ad,0xf1bf0032}},	//   _uwo_, _اهنگ_, əşən_, riá_, 
   {{0x437400d4,0xad9b00e1,0xdb1e0216,0x00000000}},	//   _رهبر, _ciún, sipê, --, 
   {{0x3ea50019,0x6d5d00a1,0xf1bf02be,0x00000000}},	//   ált_, _pbsa, piá_, --, 
   {{0x321e023e,0xdb170042,0x51872d7f,0x463b0070}},	//   mpty_, rixí, _фука, יעלע, 
   {{0x030e0d53,0xad9b2d80,0xa1f9010e,0xc19c00d1}},	// [2050] _सलाह_, _fiún, _پڑھا_, _כשהי, 
   {{0x09d30a0e,0x1fa704e9,0x6ed61f30,0xda7b2d81}},	//   तव्य, _фриг, _मुकु, ияе_, 
   {{0xf0b800d7,0xfd47010e,0xaf010033,0x00000000}},	//   _هایش_, _ویسٹ_, ্রহণ_, --, 
   {{0x249f0065,0x67ed04ef,0x7aed0243,0x2ca02d82}},	//   yyum_, dúja, _ģitā, byid_, 
   {{0xdb1e00b9,0x6d4d1162,0xb17c0070,0x5d7a0147}},	//   kipè, mgaa, יטאר, _פאשק, 
   {{0x81c3100b,0x2d990199,0x6cfa00a7,0x7b642d83}},	//   ্তি_, _hose_, _לפרס, _отсе, 
   {{0x2d992d84,0x67ed0019,0x25bf00b3,0xb902088c}},	//   _kose_, gúja, tiul_, _नु_, 
   {{0x6d4d2d85,0x391503bd,0x2d992d86,0x00000000}},	//   ngaa, _хмар, _jose_, --, 
   {{0x81c300cc,0x25bf002e,0x2d992d87,0x57b51daa}},	//   ্তা_, riul_, _mose_, _ебат, 
   {{0x25ad2d88,0x2d99071f,0x752b194c,0x249f2d89}},	//   shel_, _lose_, _wegz, ryum_, 
   {{0x69cb2d8a,0x95cb2d8b,0x249f2d8c,0x25bf00d9}},	//   onge, _куда_, syum_, piul_, 
   {{0x69cb2d8d,0xbcfb01e5,0x6d4d2d8e,0x2d992d8f}},	//   nnge, _mbéb, jgaa, _nose_, 
   {{0x69cb2d90,0x6d4d01da,0x920b093a,0x26110023}},	//   inge, dgaa, _सूरज_, _háo_, 
   {{0xd9b8000c,0x6d4d2d91,0x2d99011c,0xa4fa00d1}},	//   _अष्ट, egaa, _aose_, _פלסט, 
   {{0x2d99024d,0x59db05d0,0x76430ab1,0x6d4d038c}},	//   _bose_, यकार, nrny, fgaa, 
   {{0x6d4d2d92,0x2d990141,0x764302cd,0xa3b7109f}},	//   ggaa, _cose_, irny, घोर_, 
   {{0xdb1e2d93,0x6ac40598,0x7643016a,0x5baa2d94}},	// [2060] qipë, वप्र, hrny, бкам_, 
   {{0x6d4d2d95,0x65692d96,0x395f2d97,0xa3cb009a}},	//   agaa, heeh, _abus_, रचि_, 
   {{0x2d992d98,0x98b00062,0x2ca00da2,0x9f9b00d1}},	//   _fose_, đači_, syid_, _הסיפ, 
   {{0x5f460019,0x2d9901ca,0xe8fa0229,0x00000000}},	//   _بنگل, _gose_, бле_, --, 
   {{0xa3bd02f8,0xa3cb00a2,0x64492d99,0x7d7b00d1}},	//   ीचा_, रचा_, juei, _הנכו, 
   {{0x261100f7,0xdb1e2d9a,0x644900d3,0x2d990199}},	//   _báo_, kipé, duei, _zose_, 
   {{0x26110029,0x2d99024d,0xd5ba15eb,0x7c3605ac}},	//   _cáo_, _yose_, йси_, lsyr, 
   {{0x7bde2d9b,0x69c30019,0x00000000,0x00000000}},	//   lopu, énet, --, --, 
   {{0x64492d9c,0x76432d9d,0x7c360c17,0xdce40009}},	//   guei, arny, nsyr, keič, 
   {{0x3160085b,0x69c22d9e,0x78a200a3,0x29000028}},	//   _abiz_, lioe, myov, žias_, 
   {{0xe4d615c0,0x6d4d2d9f,0xf2c600a3,0x0edb2da0}},	//   _کتاب, ygaa, ясин, _मुंड, 
   {{0xfbc40086,0x6449022c,0x925700c8,0x69c22da1}},	//   ্তিত, buei, чают_, nioe, 
   {{0x64490518,0x7bde00c8,0x63aa0183,0xad9b0038}},	//   cuei, kopu, _tlfn, _diúl, 
   {{0x225900ab,0x69c200b4,0x00000000,0x00000000}},	//   ńska_, hioe, --, --, 
   {{0x6d4d20fe,0xdb1e00eb,0x69cb15d2,0x649501f2}},	//   tgaa, cipé, ynge, _eżiġ, 
   {{0xdd9408ad,0x91e402a6,0x69c201d6,0x00000000}},	//   насы, _поје, jioe, --, 
   {{0x113c00d1,0x9c190038,0x00000000,0x00000000}},	// [2070] _התחל, زياء_, --, --, 
   {{0x2a6302a2,0x7bde016a,0x6d4d2da2,0x09c5009a}},	//   _ppjb_, gopu, sgaa, लच्य, 
   {{0x2d992da3,0x6d4d2da4,0x671000b0,0x69c200b4}},	//   _tose_, pgaa, ाशनक_, fioe, 
   {{0x69cb2da5,0xdb1e00c8,0x69c22da6,0x26110023}},	//   unge, enpä, gioe, _ráo_, 
   {{0x7bde084c,0x26110023,0xeab00019,0x69cb2da7}},	//   bopu, _sáo_, نٹے_, rnge, 
   {{0x69da2da8,0xdb2300d4,0x66e51753,0xac182da9}},	//   _íten, _سوری, мола, _хору_, 
   {{0xe7302daa,0x69c201d6,0xe919017b,0x00000000}},	//   اصه_, bioe, _мові_, --, 
   {{0x69c22dab,0x395f02dc,0x64492dac,0x387f00fc}},	//   cioe, _ubus_, tuei, _trur_, 
   {{0x387f01ff,0x29000228,0x3a210226,0x798900d1}},	//   _urur_, žiar_, lphp_, _inew, 
   {{0x261100e7,0x799b01d2,0xad9b007a,0xe2a20108}},	//   _táo_, _houw, _siúl, _thử_, 
   {{0x799b0300,0xf6550165,0x7989040b,0x3f9a149a}},	//   _kouw, _цвеќ, _knew, _ropu_, 
   {{0x5ec10086,0x799b2dad,0xdb1e2dae,0x7bde1ea8}},	//   _শুভে, _jouw, ripé, zopu, 
   {{0x64492daf,0x799b01c8,0xad9b02aa,0xafdb017b}},	//   quei, _mouw, _ciúm, rrøn, 
   {{0x69c20a9f,0x02c50161,0x799b2db0,0xbef90110}},	//   zioe, _ойло, _louw, ंधून_, 
   {{0xdb0e0106,0x00000000,0x00000000,0x00000000}},	//   _embû, --, --, --, 
   {{0x69bf0f01,0xd3780613,0xdb1c1259,0x7c36023a}},	//   लोमी, moća_, _imré, tsyr, 
   {{0x7bde2db1,0x5f7603b1,0x61e42db2,0x7e6500a1}},	// [2080] topu, _قادر, _ikil, _ephp, 
   {{0xfaa60e65,0x78a2095a,0x00000000,0x00000000}},	//   мазо, vyov, --, --, 
   {{0x81c300cc,0x7c3602ae,0x799b0b32,0x7bde0590}},	//   ্তর_, ssyr, _bouw, ropu, 
   {{0xdca602f1,0x08c62db3,0x7bde2db4,0x00000000}},	//   _жами, мбен, sopu, --, 
   {{0x69c201f1,0x799b2db5,0x2a6d0082,0x61e40b29}},	//   rioe, _douw, _ćebe_, _mkil, 
   {{0x7a0c00d9,0xd3781a35,0x69c32db6,0x69c22db7}},	//   _aşte, koća_, éner, sioe, 
   {{0x799b0118,0x6b9c2a80,0x69c201cf,0x00000000}},	//   _fouw, _iorg, pioe, --, 
   {{0x6b9c2db8,0x61e42db9,0x320e02a3,0x799b000b}},	//   _horg, _nkil, _rufy_, _gouw, 
   {{0x69c02dba,0x6b9c0850,0xdb1c011c,0xbeeb02e6}},	//   _imme, _korg, _amré, _टर्न_, 
   {{0x61e40010,0xf3660e8f,0x00000000,0x00000000}},	//   _akil, фтин, --, --, 
   {{0x6b9c1649,0xbcfb0038,0x316b0083,0x00000000}},	//   _morg, _mbéa, tecz_, --, 
   {{0x6b9c0a75,0x61f60e0a,0xda64040c,0x00000000}},	//   _lorg, _chyl, _ko叢i_, --, 
   {{0x6b9c018c,0x0cc90086,0x6562016c,0x00000000}},	//   _oorg, _শর্ত, _iboh, --, 
   {{0x6b9c0b0c,0xe4c7009c,0xa5c604f4,0x00000000}},	//   _norg, _تصمی, bjóð, --, 
   {{0x69c02dbb,0x3ced00de,0xa3bd0083,0x00000000}},	//   _omme, _šev_, ीचर_, --, 
   {{0xc5f801dd,0x00000000,0x00000000,0x00000000}},	//   _spēj_, --, --, --, 
   {{0x3cfc01f1,0x6b9c2dbc,0x798902a3,0x799b02b0}},	// [2090] рvv_, _borg, _rnew, _rouw, 
   {{0x69c02dbd,0x799b0237,0x21f20228,0x6b9c2dbe}},	//   _amme, _souw, máha_, _corg, 
   {{0x6562014b,0x6b9c2dbf,0xafdb004f,0xfd10010e}},	//   _oboh, _dorg, nrøm, اجہ_, 
   {{0x9f5a00c8,0x4c951571,0x49b8009c,0x00000000}},	//   _eipä_, _зимс, واند_, --, 
   {{0x6b9c2dc0,0x2d8b027e,0x7e620ab4,0x799b02b0}},	//   _forg, _ince_, _ćopi, _vouw, 
   {{0x69c02dc1,0xdce40c05,0x65622dc2,0x6b9c2dc3}},	//   _emme, ldiğ, _aboh, _gorg, 
   {{0x4ae400e4,0x16a92dc4,0x4ad9034d,0xdcfd0009}},	//   _аўта, явки_, _बँटव, _posė, 
   {{0x6b9c2dc5,0xc8c002f8,0x7bc52dc6,0xdce401f0}},	//   _zorg, _शेवट, lihu, ndiğ, 
   {{0x44392dc7,0x290d02a3,0x6b9c2dc8,0xafdb017b}},	//   és_, _igea_, _yorg, støy, 
   {{0x61e42580,0x7bc52dc9,0x57f400b3,0xd3780613}},	//   _skil, nihu, _апут, toća_, 
   {{0x2d8b173f,0xa0a30188,0x98a4020f,0x969000d7}},	//   _once_, қард, _temă_, _نیوش, 
   {{0x22590035,0xe29a0023,0xa91d0009,0x68e9052b}},	//   ńsko_, _ngưu_, _požy, _kyed, 
   {{0x3209011d,0xa5c6008c,0x6abd09d8,0x7bc52dca}},	//   _diay_, sjóð, ्पुर, kihu, 
   {{0x3cf502e6,0x7bc50548,0x65620098,0xd3780372}},	//   ्धने_, jihu, _zboh, poća_, 
   {{0x645b2dcb,0x24592dcc,0x61f60090,0x68e9052b}},	//   ltui, lèm_, _thyl, _lyed, 
   {{0x657900e2,0x3209001b,0x628300e9,0x61e40548}},	//   _jawh, _giay_, _irno, _ukil, 
   {{0x68e92dcd,0xf39000e7,0x6b9c2dce,0x8c432dcf}},	// [20a0] _nyed, _mảnh_, _porg, лете, 
   {{0x2d8b0042,0x6abd0964,0x290d0bf1,0x7bc50199}},	//   _ence_, ्पूर, _agea_, gihu, 
   {{0x6b9c02f2,0x6da62dd0,0x645b2dd1,0x8ca000b0}},	//   _vorg, _зина, htui, _गॅरो, 
   {{0xe8fa2dd2,0x645b0ff2,0x68e902a5,0x6b9c08b0}},	//   пле_, ktui, _byed, _worg, 
   {{0x6b9c2dd3,0xd7e6012d,0xdb1e2dd4,0x645b02b0}},	//   _torg, ніко, lipí, jtui, 
   {{0x7c242dd5,0x290d0068,0x62832dd6,0x88811cc1}},	//   mpir, _egea_, _orno, шғул, 
   {{0xfa672dd7,0x56941269,0xd9462cdb,0x7c240bdd}},	//   _парк_, тайт, _певи, lpir, 
   {{0xd5b72dd8,0x69c02dd9,0xf3900029,0x657b0495}},	//   есь_, _umme, _cảnh_, gduh, 
   {{0x62832dda,0x7c242ddb,0xb8860356,0x94aa2ddc}},	//   _arno, npir, _blíž, ятка_, 
   {{0xafdb01e8,0x32090175,0x21f200da,0xdb1700ad}},	//   trøm, _siay_, váha_, rixç, 
   {{0x628300f1,0xf8bf010d,0x0bb700d1,0xf36300f0}},	//   _crno, _þér_, גלים_, утын, 
   {{0x645b0876,0x6579008a,0x62832ddd,0x777a00b4}},	//   btui, _gawh, _drno, _hatx, 
   {{0xdce4027e,0x777a01cf,0xf1c02dde,0xaed40176}},	//   vdiğ, _katx, शोधन, ҳорш, 
   {{0x229400eb,0x7c24008b,0x777a00b4,0x81c30033}},	//   _للتس, dpir, _jatx, ্তই_, 
   {{0xfe70006b,0x777a2ddf,0x0edb1d00,0xddab1e74}},	//   یدہ_, _matx, _मुखड, птал_, 
   {{0xdced0082,0x777a01d6,0x7bc5016c,0x00000000}},	//   ndać, _latx, wihu, --, 
   {{0x3cfc2de0,0xdce40c05,0x7bc52de1,0x7c242de2}},	// [20b0] लेले_, rdiğ, tihu, gpir, 
   {{0x657b2de3,0xa91d2de4,0xe1ff2de5,0x777a01d6}},	//   zduh, _inži, lmó_, _natx, 
   {{0xc33300a7,0xdcef00b3,0xa93509f9,0xad9b0354}},	//   רוע_, _bacă, вееш, _liúi, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x777a2de6,0x65792de7,0xf3900023,0xed6002d9}},	//   _batx, _rawh, _rảnh_, ížet_, 
   {{0xf7710198,0xf3900023,0x98a22de8,0x777a00f6}},	//   شات_, _sảnh_, рише, _catx, 
   {{0x067526c4,0xd91500e4,0x39152de9,0x777a00b4}},	//   туля, _адбы, _амбр, _datx, 
   {{0xd6ce0084,0x645b00c8,0xdb0e0118,0xa50900b3}},	//   تقى_, ttui, _albè, мейа_, 
   {{0x777a2dea,0x657b0102,0xad9b007a,0x7a0c0213}},	//   _fatx, rduh, _ciúi, _işta, 
   {{0x645b09a2,0x5ed70086,0x21320065,0x6283011c}},	//   rtui, _ধরনে, _seyh_, _prno, 
   {{0x645b2deb,0x65792dec,0xa91d00ef,0xdb1e02aa}},	//   stui, _tawh, _anži, lipã, 
   {{0x628302fe,0x2012023e,0x645b2a80,0xcec400d8}},	//   _vrno, _puyi_, ptui, hoří_, 
   {{0x75292ded,0x7c24011c,0x98a40009,0x99e80032}},	//   mbez, xpir, _temą_, liňá, 
   {{0x64492dee,0x64460613,0x43452def,0x03a20bae}},	//   mrei, škic, _рекв, _вишо, 
   {{0xed5a2df0,0xd0071ac0,0xdee62540,0x64492df1}},	//   мов_, тере_, тови, lrei, 
   {{0x661c0019,0xd00f006b,0xb602008c,0x75292df2}},	//   _érke, صلہ_, _þátt, nbez, 
   {{0xff260dc0,0x973c08b1,0x64492df3,0xcd0608a5}},	// [20c0] _импо, _hoće, nrei, тпай, 
   {{0x7c242df4,0x64492df5,0xd00f0274,0x442f017c}},	//   rpir, irei, _گلی_, _mwg_, 
   {{0x64492df6,0xf1c62df7,0x442f0201,0x2d9e026a}},	//   hrei, _लगान, _lwg_, êtes_, 
   {{0x6cc61472,0x64492df8,0x18a613f2,0x442f0065}},	//   _айма, krei, каем, _owg_, 
   {{0xb82200cc,0x442f023b,0x777a01f1,0x6e3c0097}},	//   _নিহত_, _nwg_, _patx, lsrb, 
   {{0x64492df9,0xb17b014e,0xbcfb01e5,0x00000000}},	//   drei, llåt, _mbél, --, 
   {{0x973c2dfa,0x163700eb,0x660b2dfb,0x2b582dfc}},	//   _noće, نسية_, _bigk, _icrc_, 
   {{0x64492dfd,0xd01a00cc,0x557401d0,0x442f0065}},	//   frei, তীয়_, угит, _bwg_, 
   {{0x64492dfe,0x660b0326,0xdb0e039f,0xa8062dff}},	//   grei, _digk, _albé, _азал, 
   {{0x6e3e0082,0x442f2e00,0x75c802d9,0x00000000}},	//   _ovpb, _dwg_, tězs, --, 
   {{0xf1f60035,0x69bf02e6,0x26110604,0xcb37027a}},	//   ीगढ़_, लोवी, _cšod_, כניק_, 
   {{0x64492e01,0x973c02fe,0x442f017c,0x00000000}},	//   brei, _doće, _fwg_, --, 
   {{0xc058005e,0xe1ff08f4,0x6e220b1d,0x10742253}},	//   кір_, rmó_, _čoba, аляю, 
   {{0x9f530161,0x2618001b,0x3869024a,0x9f43021e}},	//   _això_, _kéo_, çari_, mojë_, 
   {{0x4ea4278a,0x2fcd0112,0x9f342e02,0x9f43024a}},	//   арта, đeg_, ресі, lojë_, 
   {{0x442f01a0,0x24862e03,0x26180108,0x00000000}},	//   _ywg_, _krom_, _méo_, --, 
   {{0x6abd017d,0x69c3026a,0x9f43024a,0x26182e04}},	// [20d0] ्प्र, ènem, nojë_, _léo_, 
   {{0x8aa72e05,0x75290082,0x7c290218,0x2d9e0212}},	//   кред, zbez, _çerm, êter_, 
   {{0x26180212,0x237c040c,0x5c040080,0x9f43021e}},	//   _néo_, _mavj_, рята, hojë_, 
   {{0xdd9527a6,0x9a8403a1,0x9f43024a,0x21392e06}},	//   _самы, шуул, kojë_, nash_, 
   {{0x2486006d,0xafdb02c9,0x9f430034,0xf7452e07}},	//   _nrom_, gsøg, jojë_, гело, 
   {{0x261800e7,0x442f0201,0xdb070019,0x213900a3}},	//   _béo_, _rwg_, _eljá, hash_, 
   {{0xcf941490,0x24862e08,0xfc3f0a6d,0x442f00a1}},	//   יטס_, _arom_, _hví_, _swg_, 
   {{0x442f0201,0x2486123b,0x21392e09,0xafdb02c9}},	//   _pwg_, _brom_, jash_, bsøg, 
   {{0x752919e0,0x24862e0a,0x58d50f5a,0x9f432e0b}},	//   rbez, _crom_, _соат, rojê_, 
   {{0x64492e0c,0x973c0613,0x75292e0d,0x62810d62}},	//   rrei, _poće, sbez, tvlo, 
   {{0x64492e0e,0x660b012b,0x24862e0f,0x35552e10}},	//   srei, _tigk, _erom_, _مناز, 
   {{0x24860052,0x442f01c1,0x64492e11,0x6446012d}},	//   _from_, _twg_, prei, škia, 
   {{0x3fc800c5,0xf5390228,0x6281000b,0x291f2e12}},	//   ندسی_, mať_, svlo, _mfua_, 
   {{0xf5390228,0x25ad2e13,0x200c2e14,0x00000000}},	//   lať_, lkel_, ödi_, --, 
   {{0xfc3f00b9,0x61ef0d07,0x26180108,0x00000000}},	//   _aví_, blcl, _xéo_, --, 
   {{0x25ad2e15,0xf5390228,0x67380242,0xf1aa007a}},	//   nkel_, nať_, zavj, _ساعه_, 
   {{0xb17b0219,0xac860235,0x5ed70033,0xed3500b3}},	// [20e0] rlåt, ыгал, _ধরণে, рэсэ, 
   {{0xb34603b7,0x9f5e0088,0xb17b0eca,0xdb1e0183}},	//   moçõ, ötä_, blås, fipá, 
   {{0x25ad2e16,0x3ea62e17,0x533600c7,0xf5390228}},	//   kkel_, _синг, רנען_, kať_, 
   {{0x3ea52e18,0xf5390032,0x8c46109a,0xe9e5017b}},	//   älte_, jať_, _йеме, аціо, 
   {{0xe8942cd7,0xf5392e19,0x07a606b3,0xc7c61270}},	//   раль, dať_, ладн, лски, 
   {{0xafdb0022,0x9f43024a,0x61e60844,0x21392e06}},	//   rsøg, vojë_, hokl, zash_, 
   {{0x673811c8,0x61e600ef,0xad9b0587,0xdb07003e}},	//   ravj, kokl, _viúv, _smjö, 
   {{0xd49a2e1a,0x6d562e1b,0x2d802e1c,0x9f43024a}},	//   еро_, ngya, ndie_, tojë_, 
   {{0xa84a0e61,0x5692005e,0x61e600e0,0x2d802e1d}},	//   _سلام_, рақт, dokl, idie_, 
   {{0x9f4300e5,0x958600f0,0x21f202d9,0x248601d2}},	//   rojë_, _әлде, sáhl_, _vrom_, 
   {{0x9f43024a,0x21392e1e,0xe81a0035,0xf5390032}},	//   sojë_, tash_, _फंडा_, bať_, 
   {{0x24862e1f,0x2d80020f,0xf5390032,0x25ad2e20}},	//   _trom_, jdie_, cať_, ckel_, 
   {{0x21392e21,0xc2e300cf,0x5ff50a10,0x73c42841}},	//   rash_, _қўши, изму, _پيغم, 
   {{0x2a660035,0x14d700d1,0x21392e22,0xad9b0354}},	//   łoby_, _גודל_, sash_, _liút, 
   {{0x0ba7004e,0x39440126,0x2139021e,0x00000000}},	//   қшам, _odms_, pash_, --, 
   {{0x6d562e23,0x61e608a1,0x7c292e24,0xafdb0566}},	//   ggya, cokl, _çerk, jrøv, 
   {{0xeb4b2e25,0x48b60033,0x4c942e26,0x00000000}},	// [20f0] ечек_, জপুর, битс, --, 
   {{0x91fd002a,0xf5390187,0x2fca0082,0x2d802e27}},	//   stād, zať_, cibg_, adie_, 
   {{0x3a751088,0x20d41fdb,0x2ca91423,0x25ad2e28}},	//   рлер, _نتیج, syad_, ykel_, 
   {{0x6e2500a1,0x57dd009a,0x00000000,0x00000000}},	//   _ithb, यव्ह, --, --, 
   {{0xf5392e19,0xd5b10108,0xa3d40110,0x3d3a00df}},	//   vať_, _lúc_, सचा_, _בגרס, 
   {{0x225900ab,0x69ca2e29,0x1038035c,0xdd1c0028}},	//   ński_, éfer, נטום_, _iššo, 
   {{0xf5390187,0x25ad007e,0x1a6824a1,0xceb50147}},	//   tať_, tkel_, _میلی_, ייַ_, 
   {{0xa4451cb8,0x00000000,0x00000000,0x00000000}},	//   анид, --, --, --, 
   {{0x69cb2e2a,0x98480141,0xf5390187,0x6446012d}},	//   mige, _бяха_, rať_, škin, 
   {{0x69cb0430,0xf5390187,0x386d1e23,0x81bd01dd}},	//   lige, sať_, _iper_, spēl, 
   {{0x27e72e2b,0xd6d108cb,0x25b0010e,0xf5390032}},	//   monn_, _بقا_, álló_, pať_, 
   {{0x69cb2e2c,0x91e62e2d,0x61e60028,0x00000000}},	//   nige, роме, uokl, --, 
   {{0x6e2500eb,0x753b2e2e,0x80c000bc,0x00000000}},	//   _athb, mauz, _लेखे, --, 
   {{0x753b2e2f,0x69cb01c4,0xdfd20038,0x973c00ca}},	//   lauz, hige, زيز_, _koća, 
   {{0xa91d08d7,0x09b500a2,0x63a3004c,0x6da600c8}},	//   _každ, ंसाठ, _ionn, аива, 
   {{0x63a32e30,0x973c090e,0x27e72e31,0x32da00d1}},	//   _honn, _moća, honn_, _שחקנ, 
   {{0x63a32e32,0x2d80042e,0x69cb2e33,0x6d560274}},	// [2100] _konn, rdie_, dige, rgya, 
   {{0x443f2e34,0x63a32e35,0x9f43010c,0xeab20038}},	//   isu_, _jonn, lojî_, يعا_, 
   {{0x63a32e36,0x69cb2e37,0x973c034c,0x386d2e38}},	//   _monn, fige, _noća, _aper_, 
   {{0x88862e39,0x63a30038,0x69cb2e3a,0xa01b003e}},	//   илеж, _lonn, gige, kvöl, 
   {{0x91fd00e0,0x38cb015f,0x764105a1,0x6eca0659}},	//   ltāc, پانی_, _avly, _हेतु, 
   {{0x63a32e3b,0x98a400bc,0x973c2e3c,0xc66a00c8}},	//   _nonn, _země_, _boća, вшие_, 
   {{0x69cb2e3d,0x29560141,0xafdb03a9,0x443f2e3e}},	//   bige, _възр, prøv, esu_, 
   {{0xd37802f5,0x6d460065,0x18a61988,0xafdb00fc}},	//   moći_, _jdka, _кабм, lrøt, 
   {{0x2616006a,0x63a32e3f,0x443f0102,0xb0c50035}},	//   _पूरी_, _bonn, gsu_, _लेंग, 
   {{0x63a32e40,0x7980024d,0x79822e41,0x64460528}},	//   _conn, _hamw, ldow, škio, 
   {{0x6d4608d7,0x79802e42,0x63a316b3,0xd378034c}},	//   _odka, _kamw, _donn, noći_, 
   {{0x7c2600f1,0x63a30110,0x79822e43,0x31c72049}},	//   _otkr, _eonn, ndow, рсов, 
   {{0x79802e44,0xcfa72e45,0x84630093,0x63a32e46}},	//   _mamw, ашви, _дъще, _fonn, 
   {{0x44262e47,0x63a32e48,0x69cb2e49,0x64421077}},	//   _ito_, _gonn, zige, _ivoi, 
   {{0x7c2626eb,0xc3fb00a7,0x644001e8,0x69cb02b8}},	//   _atkr, _שלוש, lsmi, yige, 
   {{0xa91d090b,0x44262e4a,0x63a32e4b,0x798001a1}},	//   _kaže, _kto_, _zonn, _namw, 
   {{0x63a30298,0x61ed2e4c,0x69cb076d,0xdb1e00c8}},	// [2110] _yonn, _ikal, vige, kipä, 
   {{0x44262e4d,0x69d8026a,0xa91d012d,0x69cb2e4e}},	//   _mto_, éven, _maže, wige, 
   {{0x69cb2e4f,0x79800b31,0x386d00d9,0x61ed2e50}},	//   tige, _bamw, _sper_, _kkal, 
   {{0x44262e51,0x443f2e52,0x64402e53,0x79822e54}},	//   _oto_, ysu_, ksmi, gdow, 
   {{0x44262e55,0xfd9600a7,0x61ed06f2,0xe6cb008c}},	//   _nto_, _הדרך_, _mkal, _íbúð, 
   {{0x64402e56,0x628a2e57,0x67d400d3,0xdb1e00b0}},	//   dsmi, _orfo, оочу, gipä, 
   {{0x44262e58,0x3f8119e0,0x61ed2e59,0x64422e5a}},	//   _ato_, _mahu_, _okal, _avoi, 
   {{0x81bd0bc3,0x63a32e5b,0x973c2e5c,0x27e706df}},	//   spēj, _sonn, _voća, sonn_, 
   {{0x27e70cd7,0x63a32e5d,0x69c90548,0x64402e5e}},	//   ponn_, _ponn, _imee, gsmi, 
   {{0xd7fb030f,0x61ed2e5f,0x44262e60,0x3f8100e2}},	//   _руб_, _akal, _dto_, _nahu_, 
   {{0x443f2e61,0x44262e62,0x63a32e63,0x79802e64}},	//   ssu_, _eto_, _vonn, _yamw, 
   {{0x443f2e65,0x63a301a3,0x95c82e66,0x3f930104}},	//   psu_, _wonn, _куча_, _anxu_, 
   {{0x628a02ec,0x3f812e67,0x973c0062,0x644f19e7}},	//   _erfo, _bahu_, _moćn, ácid, 
   {{0x61ed2e68,0x2326263b,0x64a22e69,0x63ba2e6a}},	//   _ekal, _лоши_, _хаша, chtn, 
   {{0xdfcf00eb,0x65b5014b,0xa91d2e6b,0x69db0126}},	//   ريف_, _záha, _zaže, _ojue, 
   {{0x973c00f1,0x3d28009c,0x3ea502ae,0x2d952163}},	//   _noćn, شتری_, älta_, орус, 
   {{0x6da32e6c,0x3f810242,0x44260126,0x0b462024}},	// [2120] чита, _fahu_, _xto_, йнан, 
   {{0xa3ca094d,0x79802e6d,0x69c92e6e,0xed5901a2}},	//   रोप_, _samw, _amee, лоӣ_, 
   {{0x8e8600eb,0x79800204,0x2bb900a2,0x0a4a00c8}},	//   _الجه, _pamw, _इतरा, узей_, 
   {{0xe9da2e6f,0xe93a1930,0x8d560b2d,0x6d4602c9}},	//   ыке_, اسات_, _уточ, _udka, 
   {{0xa3e70e7d,0x79822e70,0x60000f71,0x515b00d1}},	//   पवा_, rdow, römf, רכנו, 
   {{0xd49a02f1,0x7980092f,0x69c92e71,0x64402032}},	//   ғри_, _wamw, _emee, vsmi, 
   {{0x442603ef,0x2d822e72,0xa91d2e73,0x65b51cf0}},	//   _sto_, _kake_, _saže, _sáha, 
   {{0x64400f96,0xa91d012d,0xd5b700d3,0xa3ca017d}},	//   tsmi, _paže, йсы_, रोन_, 
   {{0x2d820056,0xe5a602f1,0x442602aa,0x64402e74}},	//   _make_, _қиди, _qto_, usmi, 
   {{0xa91d0062,0x61ed2e75,0xd37a1a9e,0x44260097}},	//   _važe, _skal, учи_, _vto_, 
   {{0x9f8d00bc,0xc7b300d1,0xd2f800b3,0xdddc0121}},	//   uží_, _צבע_, ренц_, zvrš, 
   {{0xf2c311db,0xdb1c010d,0x2d820218,0x64402e76}},	//   ясын, _umræ, _nake_, psmi, 
   {{0xafdb03a9,0x673a0088,0xd4f60296,0x30e700f0}},	//   drør, _ketj, _اثاث, сінб, 
   {{0x62340648,0x4394069b,0x82330019,0x673a039b}},	//   _деку, _факс, _کروا, _jetj, 
   {{0x25a62e77,0x673a07d7,0x61ed0b3c,0x3f832e78}},	//   _kool_, _metj, _tkal, rdju_, 
   {{0x673a2e79,0x61ed2e7a,0x7bdc007b,0x21f90098}},	//   _letj, _ukal, _ajru, mého_, 
   {{0x3f812e7b,0x21f90076,0x2d822e7c,0xdb0e00f6}},	// [2130] _tahu_, lého_, _dake_, _albà, 
   {{0x673a0d2d,0x69c90b1f,0x75d300b3,0x2d870083}},	//   _netj, _smee, răzi, śne_, 
   {{0x21f908fc,0x1df916d0,0x973c00ca,0x2d8200df}},	//   ného_, _вены_, _poćn, _fake_, 
   {{0xd37800f1,0x25a601a4,0x2d82007c,0xad9b007a}},	//   moću_, _nool_, _gake_, _dhúc, 
   {{0x973c2e7d,0x21f9014b,0x673a03a9,0xe7390ec6}},	//   _voćn, hého_, _betj, аел_, 
   {{0x21f908d7,0x7c2d24bb,0x2d8223eb,0x661a2e7e}},	//   kého_, mpar, _zake_, _butk, 
   {{0x2d8225d3,0x201300a4,0x660505e0,0xd3780613}},	//   _yake_, _mixi_, опка, noću_, 
   {{0x94252b3b,0x69c92e7f,0x25a600d1,0x21f90098}},	//   омие, _umee, _cool_, dého_, 
   {{0x7c2d2e80,0xe3b92e81,0x57d503b7,0x673a0026}},	//   npar, иби_, _доаѓ, _fetj, 
   {{0xd3780397,0x387f2e82,0x673a040b,0x37f900d9}},	//   koću_, _isur_, _getj, _тезэ_, 
   {{0x395f0bfc,0xd6db134b,0x27e00038,0x65bc0096}},	//   _kcus_, _ста_, éine_, _béhd, 
   {{0x69d92e83,0x2013022c,0x25a6039b,0x387f007b}},	//   nnwe, _aixi_, _gool_, _ksur_, 
   {{0x09a70081,0x201301d6,0x2d822e84,0x64a52e85}},	//   _खवैय, _bixi_, _rake_, _фала, 
   {{0x2d822e86,0x44072e87,0x23bb009e,0x7c2d2e88}},	//   _sake_, _учеб, _bêje_, dpar, 
   {{0x2d822e89,0x442d2e8a,0x76432e8b,0x213b00e2}},	//   _pake_, lpe_, nsny, _feqh_, 
   {{0x6000014e,0x201b2e8c,0x69d901c8,0x7a40039f}},	//   döme, _fuqi_, jnwe, _látá, 
   {{0x90c32e8d,0xfaf8002a,0x442d0cd7,0x7c2d23c2}},	// [2140] _объе, _šī_, npe_, gpar, 
   {{0xdb1c0533,0x442d2e8e,0x7a0c06d0,0xe81d0262}},	//   _områ, ipe_, _işti, _पढ़ा_, 
   {{0x6da605af,0x2d820056,0x65b50254,0x60000f71}},	//   _дина, _take_, _náho, römd, 
   {{0xa96a12e1,0x442d0640,0x673a2e8f,0x2d82006f}},	//   рида_, kpe_, _setj, _uake_, 
   {{0xa3ca00e6,0x661a12ed,0x7c2d00a1,0x673a2e90}},	//   रोड_, _sutk, cpar, _petj, 
   {{0x661a00c8,0xe79302a6,0x25a62e91,0x395f00a1}},	//   _putk, дишњ, _sool_, _ecus_, 
   {{0xd5ba13bd,0x8f9b00fe,0x442d018c,0x673a2e92}},	//   иси_, ייסי, epe_, _vetj, 
   {{0x21f90c7f,0x746a2e93,0x77b400b9,0xe46a0165}},	//   vého_, аров_, _tàxo, ашол_, 
   {{0x764302cd,0x442d011d,0x7c292e94,0x65b500d8}},	//   asny, gpe_, _çert, _táhn, 
   {{0x661a2e95,0x21f905a8,0x83aa0e65,0x31602e96}},	//   _tutk, tého_, ртиб_, _aciz_, 
   {{0x25a62e97,0x7a0c09c7,0x741400d4,0x442d2e98}},	//   _tool_, _aşti, _کوتا, ape_, 
   {{0x21f90076,0xd46a2e99,0x442d023e,0x23bb009e}},	//   rého_, _виде_, bpe_, _rêje_, 
   {{0x38662e9a,0x65b52e9b,0x9f4e014b,0x7c2d2e9c}},	//   ntor_, _záho, šným_, xpar, 
   {{0xa91d012d,0xb4c80551,0x9f5a06df,0x38662e9d}},	//   _maža, ोपी_, _sipò_, itor_, 
   {{0xa91d032f,0x66022e9e,0x20132e9f,0x38662ea0}},	//   _laža, _khok, _vixi_, htor_, 
   {{0xdd940d18,0x65b50356,0xd3780035,0x22510032}},	//   масы, _náhl, leć_, ázke_, 
   {{0xa91d02f5,0xf1bf0038,0x3a2a0c36,0x3866024a}},	// [2150] _naža, mhá_, _atbp_, jtor_, 
   {{0x7c2d2ea1,0x660202a2,0xfa8b2ea2,0xd3780242}},	//   rpar, _lhok, исей_, poću_, 
   {{0x7a400084,0x37d00033,0x7658018e,0x00000000}},	//   _rátá, াকার, juvy, --, 
   {{0xa3ca048e,0xbd6b1c0f,0x195922e0,0x4e7a00c7}},	//   रोत_, _трое_, сады_, _פארצ, 
   {{0xf1b400a7,0x7643016a,0x69d902eb,0x00000000}},	//   וסף_, wsny, rnwe, --, 
   {{0xa91d2ea3,0xec3600d1,0xd3782ea4,0x66022ea5}},	//   _daža, _מאשר_, jeć_, _ahok, 
   {{0x6602018e,0x38662ea6,0x9aa5149e,0xc9772ea7}},	//   _bhok, ator_, _عمرو, _وارث, 
   {{0x66022ea8,0x3179006a,0x795818ae,0xdb07024a}},	//   _chok, jesz_, _миср_, _lojë, 
   {{0x442d2ea9,0x38662eaa,0x7643209d,0x6602009c}},	//   upe_, ctor_, ssny, _dhok, 
   {{0xdb07010c,0x75d300d9,0x65692eab,0x76432eac}},	//   _rojê, văzu, sfeh, psny, 
   {{0x656902f2,0x65151b44,0x00000000,0x00000000}},	//   pfeh, _فوائ, --, --, 
   {{0x442d0bda,0x216a0fac,0xd5b801dd,0x91fd0243}},	//   ppe_, щими_, _stāv_, stān, 
   {{0xd37800ca,0x43952ead,0xbcfb01e5,0x00000000}},	//   beć_, _надс, _mbés, --, 
   {{0x66092eae,0x35d100a5,0x1c1f00b0,0x21f20098}},	//   lmek, _तगड़, _बढ़ल_, váhu_, 
   {{0xa3b820b4,0xbcfb0212,0x59bd02e6,0x02040176}},	//   _ظاهر_, _obés, ्फार, _оҷон, 
   {{0x317900ab,0xf1bf026e,0x9c262eaf,0x38662eb0}},	//   cesz_, chá_, здад, ytor_, 
   {{0x386601ff,0x25bf00e2,0x60002eb1,0x90460038}},	// [2160] xtor_, ihul_, römb, _عنده, 
   {{0x0e662eb2,0xdb070034,0x66090eec,0xa91d2eb3}},	//   _екон, _gojë, hmek, _raža, 
   {{0xa91d00d2,0x66092eb4,0x200a0065,0x00000000}},	//   _saža, kmek, mmbi_, --, 
   {{0x38662eb5,0x25bf0a9d,0xa91d0009,0x9f4a014b}},	//   ttor_, jhul_, _paža, dobé_, 
   {{0xd90d0a24,0x660900c2,0xc18d0070,0x91fd0243}},	//   لیف_, dmek, יטאָ, dtāl, 
   {{0x38662eb6,0x66022eb7,0xa91d0062,0xaa462eb8}},	//   rtor_, _shok, _važa, _негл, 
   {{0x7bce2eb9,0x66022eba,0xd37808e3,0x3e8702d9}},	//   _imbu, _phok, već_, mítá_, 
   {{0xbcfb26ca,0x9adb00a7,0x2ca02ebb,0x38660b30}},	//   _ibér, _החלט, oxid_, ptor_, 
   {{0xa91d003a,0x6d4b0038,0x386600b9,0x00000000}},	//   _kažn, ógai, qtor_, --, 
   {{0xad9b001b,0x644f2ebc,0x00000000,0x00000000}},	//   _nhún, ácia, --, --, 
   {{0x7bce02cd,0x217916d0,0x66022ebd,0xdcfd01dd}},	//   _mmbu, ойны_, _thok, _masā, 
   {{0xa91d044e,0x25bf2ebe,0x80ab0086,0x7bce0042}},	//   _lažn, chul_, _চেষ্, _lmbu, 
   {{0x4420002e,0x2609143e,0xbcfb2ebf,0x00000000}},	//   _îi_, ागरी_, _océa, --, 
   {{0xad9b00f7,0xefc814fc,0x03a32ec0,0xdfdb01d8}},	//   _chún, пуск_, _пичо, съм_, 
   {{0xdb07011c,0xad9b007a,0x00000000,0x00000000}},	//   _gojè, _dhún, --, --, 
   {{0x8d84022c,0x22f700a7,0x9df901fc,0x7bce2ec1}},	//   нууд, _מזון_, інат_, _ambu, 
   {{0x23bb0218,0xa91d012d,0x6285003e,0x6c152ec2}},	// [2170] _hêja_, _bažn, _áhor, ддаф, 
   {{0xbcfb0354,0x91fd0243,0x66092ec3,0xad9b0354}},	//   _ccéa, itām, zmek, _ghún, 
   {{0xa91d00e4,0xfe240080,0xdb070175,0x00000000}},	//   _dažn, _пьян, _kojé, --, 
   {{0x6aaa022b,0x7bce2ec4,0x7af500d8,0x63aa017c}},	//   äffa, _embu, _vyzt, _lofn, 
   {{0x2d992ec5,0xdcfd0243,0x6f072ec6,0x00000000}},	//   _inse_, _fasā, bébé, --, 
   {{0xab842ec7,0xbcfb00eb,0xbcb600d1,0x75f702be}},	//   _пуск, _gcéa, _חפשו_, mãzi, 
   {{0x66092ec8,0x25bf2ec9,0x35a503a1,0x00000000}},	//   tmek, thul_, дайг, --, 
   {{0x6d5f00e2,0x2d892eca,0x75fe024a,0x9f4a2ecb}},	//   ngqa, ndae_, tëza, robé_, 
   {{0x91fd002a,0x394d00d2,0x66092ecc,0x6b870397}},	//   rtāl, _ides_, rmek, _kajg, 
   {{0x63aa0156,0xe3b10038,0x656202be,0x25bf0b41}},	//   _cofn, ئرة_, _ecoh, shul_, 
   {{0x91e62ecd,0x2d990727,0x61ef0534,0x2d89040b}},	//   доне, _onse_, focl, kdae_, 
   {{0x44b52ece,0xa91d0009,0x600002ae,0x00000000}},	//   _обес, _mažo, döma, --, 
   {{0xa91d00d2,0xa3ca0367,0x2d890ff2,0x657b0175}},	//   _lažo, रोह_, ddae_, meuh, 
   {{0x3fcc0086,0x21290054,0x2d992ecf,0x63aa00f8}},	//   লক্ষ, _efah_, _anse_, _gofn, 
   {{0x394d090b,0xa91d0b91,0x248d2ed0,0xdb1e0034}},	//   _odes_, _ražn, lvem_, shpë, 
   {{0xbcfb00eb,0x394d023e,0x217607f4,0x61ef011c}},	//   _scéa, _ndes_, _цукр, cocl, 
   {{0xa91d03ef,0xdcfd002a,0x6446034c,0x5baa2253}},	// [2180] _pažn, _pasā, škiv, окам_, 
   {{0x973c2ed1,0x657b2ed2,0x6b870082,0x394d00b9}},	//   _voćk, heuh, _cajg, _ades_, 
   {{0xa91d02f5,0x657b002c,0x00000000,0x00000000}},	//   _važn, keuh, --, --, 
   {{0xe8fa2ed3,0x394d02be,0x657b033e,0x00000000}},	//   оле_, _cdes_, jeuh, --, 
   {{0x6c7503dc,0x6b872ed4,0x394d0090,0x657b002c}},	//   _пурх, _fajg, _ddes_, deuh, 
   {{0x6d442ed5,0x394d0088,0xc5f82ed6,0x6b8700ef}},	//   laia, _edes_, ुष्य_, _gajg, 
   {{0xd90d006b,0x5a550141,0xba232ec7,0x00000000}},	//   لیہ_, _пъту, _адск, --, 
   {{0x77b400d3,0x6d442ed7,0x973c0a1a,0x1dde2ed8}},	//   _màxi, naia, _moći, नचित, 
   {{0x3329009e,0x186a1234,0x62832ed9,0x00000000}},	//   _şaxa_, _фази_, _asno, --, 
   {{0x6d4401f1,0xa91d08e3,0x69c22eda,0x69b4009a}},	//   haia, _lažl, lhoe, _आवडी, 
   {{0x6d440730,0x973c00d2,0x452a00b3,0x7c242edb}},	//   kaia, _noći, _джен_, hqir, 
   {{0x8506073c,0x225105a8,0xa1940965,0x69c22edc}},	//   _قوان, ázka_, ваюч, nhoe, 
   {{0x6d442edd,0x64b60189,0x3c2400ad,0x4613009c}},	//   daia, _تحار, _növ_, _شوهر, 
   {{0x7bde039b,0x00000000,0x00000000,0x00000000}},	//   jnpu, --, --, --, 
   {{0x05b207d5,0x69c207d7,0x6d441890,0xafdb00fc}},	//   _जवाब, khoe, faia, lsøk, 
   {{0xa91d002a,0x6d442ede,0x973c0082,0x600002ae}},	//   _ražo, gaia, _doći, röma, 
   {{0x26160366,0x2d890326,0x69c22edf,0xafdb0b48}},	// [2190] _पूछी_, rdae_, dhoe, nsøk, 
   {{0x2d890876,0x09d7009a,0x69c20d62,0xe3b80e03}},	//   sdae_, ढच्य, ehoe, nkı_, 
   {{0x6d442ee0,0x248d00bc,0x63a702ae,0xb17b017b}},	//   baia, zvem_, öjni, pnåd, 
   {{0xd5a62ee1,0x6d442ee2,0x6ce700f0,0x69c22ee3}},	//   _صف_, caia, _жіге, ghoe, 
   {{0xe7eb0081,0xe3b801f0,0x394d024a,0x6d4f27c7}},	//   टवला_, kkı_, _vdes_, _idca, 
   {{0x65bc2ee4,0x20220216,0x96652ee5,0xafdb1341}},	//   _réha, _êriş_, екке, dsøk, 
   {{0x65bc1a3b,0x99672ee6,0x00000000,0x00000000}},	//   _séha, _отал, --, --, 
   {{0x394d23b8,0x91fd00e0,0xff1800d1,0xc4852ee7}},	//   _udes_, stāj, וקות_, елик, 
   {{0x6000014e,0xa924026e,0x799b2ee8,0x00000000}},	//   dömn, _úžas, _inuw, --, 
   {{0xf7702ee9,0x42c92eea,0xa3ca2a97,0xb605014b}},	//   _نام_, згон_, रोल_, dnáš, 
   {{0xeb920137,0xe2992eeb,0x7989011c,0x142403a1}},	//   אָר_, чан_, _kaew, ндөм, 
   {{0xdb07010d,0x1df902e6,0xcb120486,0x56b60070}},	//   _hljó, ंतोष_, טלי_, _אפען_, 
   {{0xbcfb2eec,0x6d44019c,0x7989011c,0x33d5128b}},	//   _scén, vaia, _maew, _пікт, 
   {{0x6d440666,0x75292eed,0xb4cb034d,0x973c0372}},	//   waia, lcez, रछी_, _poći, 
   {{0x670f000c,0xa91d003a,0x64492eee,0x527500f6}},	//   ाधिक_, _pažl, lsei, _чулу, 
   {{0x973c00ca,0x443d0574,0x442f2eef,0xdca62ef0}},	//   _voći, _kww_, _ktg_, наби, 
   {{0x64492ef1,0x6d442ef2,0x6b5600eb,0x9f4a03dd}},	// [21a0] nsei, raia, فضائ, lobí_, 
   {{0x7c2b2ef3,0x6d442ef4,0x644901f5,0x442f2ef5}},	//   ígra, saia, isei, _mtg_, 
   {{0xc0a900c5,0x6d441b78,0x69c22ef6,0x443d2ef7}},	//   _فایل_, paia, thoe, _lww_, 
   {{0xdca62ef8,0x186a2ef9,0x394000eb,0x64492efa}},	//   _зами, зади_, úis_, ksei, 
   {{0x69c20511,0x65bc0175,0x201a025b,0xad1b00d1}},	//   rhoe, _béhn, _kipi_, _מוכר, 
   {{0x61e411b1,0x69c22efb,0x64492efc,0xc7a32756}},	//   _ljil, shoe, dsei, личк, 
   {{0x644b05a7,0x442f0844,0xa91d0613,0x69c208b0}},	//   _avgi, _atg_, _zažm, phoe, 
   {{0x38cb00d6,0x9f4a037f,0xa91d008b,0x75fe00e5}},	//   _کافی_, dobí_, _lažj, rëzo, 
   {{0x69c02efd,0x91fd00e0,0x39462efe,0xdb07008c}},	//   _ilme, stāk, maos_, _fljó, 
   {{0xa3ca0da6,0x61e4086d,0x442f085f,0xafdb00dd}},	//   रों_, _ajil, _dtg_, rsøk, 
   {{0xe3b803c0,0x443d0102,0x96962eff,0xa281009c}},	//   rkı_, _eww_, _яраш, لیوو, 
   {{0x644902f2,0x39462f00,0x752902a3,0xe3b8027e}},	//   bsei, naos_, ccez, skı_, 
   {{0x61e42f01,0x201a00ca,0xecd002e6,0x443d039b}},	//   _djil, _bipi_, _सेलफ, _gww_, 
   {{0x6d4f1f87,0x6446008b,0x24860027,0xa91d0144}},	//   _sdca, škis, _isom_, _ražm, 
   {{0x201a0175,0x7c2f039b,0x65bc0151,0xb60500d8}},	//   _dipi_, _stcr, _jého, snáš, 
   {{0x61e4024a,0x39462f02,0x00000000,0x00000000}},	//   _gjil, jaos_, --, --, 
   {{0x6ad900c9,0x39462f03,0xa01b0c98,0x32092f04}},	// [21b0] भप्र, daos_, rvös, _ihay_, 
   {{0x69c02f05,0xdb150183,0x61fd1c33,0x973c00ca}},	//   _alme, _alzá, llsl, _koću, 
   {{0x29040548,0x32090023,0x2a780027,0xb7b50108}},	//   _azma_, _khay_, _cprb_, _lịc, 
   {{0x28d22f06,0x248600ef,0x32090054,0x201a2f07}},	//   _देहि, _osom_, _jhay_, _zipi_, 
   {{0x69c000a1,0x50b30cb8,0x18690171,0x00000000}},	//   _dlme, ुनिष, фали_, --, 
   {{0x2d8b100b,0x9a872f08,0x7989011c,0x69c02f09}},	//   _hace_, _публ, _waew, _elme, 
   {{0x2d8b2f0a,0x973c015e,0x600002ae,0x2904040c}},	//   _kace_, _noću, döml, _ezma_, 
   {{0x2d8b090b,0x442f19e0,0x64492f0b,0x39460126}},	//   _jace_, _ptg_, tsei, caos_, 
   {{0x752901d8,0xa8150470,0xb4cb00aa,0x65bc033e}},	//   rcez, _адаш, रछे_, _téhn, 
   {{0x61f627dc,0x64492f0c,0x320901a7,0x7bc50108}},	//   _skyl, rsei, _ahay_, nhhu, 
   {{0x13090088,0xa2e52f0d,0x32090102,0x920d0035}},	//   ьной_, тонд, _bhay_, सगंज_, 
   {{0x442f2f0e,0x201a06e4,0x32092f0f,0x9f4a23f2}},	//   _ttg_, _sipi_, _chay_, robí_, 
   {{0x9f4a026e,0x644603f9,0x6385011f,0x442f2f10}},	//   sobí_, škir, _агла, _utg_, 
   {{0x2b430352,0x7fd600f0,0x61fd039b,0x00000000}},	//   _nejc_, тімі, alsl, --, 
   {{0x201a2f11,0xdb071102,0x61e42f12,0x68fb1530}},	//   _vipi_, _bojí, _tjil, _lyud, 
   {{0xc69200fe,0xdb070369,0x2d8b2f13,0x291f0108}},	//   סאן_, _cojí, _cace_, _ngua_, 
   {{0x201a2f14,0xab661daa,0x68fb2f15,0x2d8b2f16}},	// [21c0] _tipi_, квал, _nyud, _dace_, 
   {{0x291f2f17,0x2d8b016a,0x6d4b01d5,0xa01b2cd8}},	//   _agua_, _eace_, ógar, svör, 
   {{0x68fb2f18,0xcf570056,0x0f570137,0x2d8b2f19}},	//   _ayud, _בבית_, _ביים_, _face_, 
   {{0x68fb2f1a,0x2d8b02b8,0x7a47010e,0x00000000}},	//   _byud, _gace_, _sétá, --, 
   {{0x2d80002e,0x39462f1b,0x18742f1c,0x63ba017b}},	//   meie_, raos_, угля, yktn, 
   {{0x2d80004f,0x7bc5243f,0x7c362f1d,0x291f09c6}},	//   leie_, chhu, mpyr, _egua_, 
   {{0xfaa32f1e,0x2d8b2f1f,0xc7b80bfc,0x69262f20}},	//   _каро, _yace_, _niđe_, _амба, 
   {{0xa2c50e07,0x5e5700c7,0x2d8b0183,0x69c02f21}},	//   ानन्, דיקע_, _xace_, _ulme, 
   {{0x290400ef,0x68fb2f22,0x65b500de,0x00000000}},	//   _uzma_, _gyud, _náhu, --, 
   {{0x21200065,0x32090104,0x39440657,0x7afc0354}},	//   _agih_, _shay_, _hems_, _kyrt, 
   {{0x2d80018c,0xd7ef00eb,0xe3af091d,0x63ba01d2}},	//   keie_, _بكل_, تري_, rktn, 
   {{0xb6d900c7,0x2486006f,0x9f5f0183,0xa5da2f23}},	//   _אַנט, _tsom_, _árúa_, _غبار_, 
   {{0x2d8b2f24,0x61fd2f25,0x00000000,0x00000000}},	//   _race_, rlsl, --, --, 
   {{0x65bc0175,0x040d0108,0x39442f26,0x00000000}},	//   _méhm, _mườn, _lems_, --, 
   {{0x32090029,0x2d8b2f27,0xdb0e024a,0x040d0023}},	//   _thay_, _pace_, _dobë, _lườn, 
   {{0x3209011d,0x2120011c,0x39440054,0x60b5010e}},	//   _uhay_, _ggih_, _nems_, _ممبئ, 
   {{0x52e21893,0x00000000,0x00000000,0x00000000}},	// [21d0] _पशुस, --, --, --, 
   {{0x1ae70086,0xe1ff2f28,0x2d8b019b,0xad9b0038}},	//   _করবে_, lló_, _wace_, _mhúi, 
   {{0x68fb2f29,0x2d8b2f2a,0xab84021d,0x7afc03c6}},	//   _syud, _tace_, шутк, _cyrt, 
   {{0xe1ff0019,0x7bc502f1,0x68fb011d,0xa91d2f2b}},	//   nló_, shhu, _pyud, _kaži, 
   {{0x040d001b,0x3da400e4,0x7c220038,0x39440186}},	//   _cườn, _трэб, íort, _dems_, 
   {{0xa91d012d,0x69d804fe,0x040d00e7,0x7afc0c17}},	//   _maži, éver, _dườn, _fyrt, 
   {{0xf770214a,0xf96b004e,0x39442f2c,0xdb0e05d5}},	//   تان_, _орай_, _fems_, _nobè, 
   {{0x6e252f2d,0x7f45008a,0xad9b0534,0x291f018e}},	//   _muhb, _lehq, _bhúi, _ugua_, 
   {{0x7afc00e5,0xad9b00eb,0xc7b8044e,0x98680019}},	//   _zyrt, _chúi, _siđe_, _لینے_, 
   {{0x69d92f2e,0x52a91a63,0xd7740499,0xa91d00da}},	//   liwe, евом_, _نامع, _naži, 
   {{0xd575085c,0x61462f2f,0x216a12e1,0xdb0e0034}},	//   _буль, лена, нини_, _robë, 
   {{0x60000219,0x69d92f30,0x9f4a014b,0xe1ff0313}},	//   römm, niwe, dobá_, gló_, 
   {{0x753b2f31,0xe3b3009c,0xad9b0354,0x00000000}},	//   mbuz, _پرش_, _ghúi, --, 
   {{0xfce60200,0xe1ff0369,0x69d9019b,0x43452f32}},	//   қозо, aló_, hiwe, _секв, 
   {{0xe1ff2f33,0x3ebe008c,0x69d92f34,0xe2a800eb}},	//   bló_, átt_, kiwe, _لاين_, 
   {{0x69d90053,0x3f8c2f35,0xdee60283,0x7bd5018e}},	//   jiwe, ždu_, воҳи, _amzu, 
   {{0x645b2f36,0xdca32f37,0x67210352,0x2d802f38}},	// [21e0] nrui, бати, _oglj, reie_, 
   {{0x3ea61790,0x8b262f39,0x69d9040b,0x645b040b}},	//   _биог, удже, eiwe, irui, 
   {{0x7c362f3a,0x645b0038,0x7bcb021e,0xdb1c0502}},	//   spyr, hrui, ëgua, _umrü, 
   {{0x91fd002a,0xa91d1c77,0x645b0b1f,0x08c600d9}},	//   stāv, _zaži, krui, лбен, 
   {{0x6d4601dd,0xd7fa2f3b,0x645b039b,0x00000000}},	//   _ieka, нук_, jrui, --, 
   {{0x91fd002a,0x6d462f3c,0x645b2f3d,0xa63400dd}},	//   ltāt, _heka, drui, анкі, 
   {{0x6d462f3e,0x26050081,0xf1c1026e,0xad9b007a}},	//   _keka, _हीही_, ášky_, _shúi, 
   {{0x54542f3f,0x645b2f40,0x262700ef,0x040d001b}},	//   авит, frui, _gđom_, _tườn, 
   {{0xa2d92f41,0x973c0097,0x89d500f0,0x136a0093}},	//   _फेब्, _anće, _тірш, ншни_, 
   {{0x1ae7100b,0x6d460b07,0x42742f42,0x7c262f43}},	//   _করতে_, _leka, агос, _mukr, 
   {{0xb3450165,0xd3770528,0x75fe0034,0x26ca2be3}},	//   _seçã, учы_, hëzi, _åbo_, 
   {{0x645b2f44,0x04462f45,0xf1a72f46,0x0ecf00c2}},	//   brui, _бедн, урон, _हेगड, 
   {{0x645b2f47,0x10742f48,0xa91d012d,0x6e2502f1}},	//   crui, бляю, _paži, _suhb, 
   {{0xa3e82246,0x69d92f49,0x92942f4a,0x5334021f}},	//   _यदि_, ziwe, _вакц, _тект, 
   {{0xdd9b032e,0x6d462f4b,0x4426086d,0xa91d012d}},	//   нша_, _beka, _huo_, _važi, 
   {{0x6d462f4c,0x4426012d,0x7c262f4d,0x628a007b}},	//   _ceka, _kuo_, _bukr, _isfo, 
   {{0x62982f4e,0x4426058b,0x629e0183,0xa3e82f4f}},	// [21f0] _hrvo, _juo_, _ápob, _यदा_, 
   {{0xf1bf00bc,0x7c260009,0x67ff010c,0xdd9300f0}},	//   lká_, _dukr, rêjk, шағы, 
   {{0x6d462f50,0x3f830097,0x44262f51,0x69d92f52}},	//   _feka, meju_, _luo_, tiwe, 
   {{0xdd950d18,0x75222f53,0x3ebe155b,0x893700eb}},	//   _тамы, _ngoz, øtte_, اعضا, 
   {{0x44260904,0x69d92f54,0x98a52f55,0x18a52f56}},	//   _nuo_, riwe, риле, ралм, 
   {{0x6d462f57,0x65b50076,0x62980019,0xd2461b44}},	//   _zeka, _náhr, _orvo, _ون_, 
   {{0x79820068,0x6d462f58,0x00000000,0x00000000}},	//   beow, _yeka, --, --, 
   {{0x44260c36,0x644202a5,0x7c2602a5,0xf773039f}},	//   _buo_, _bwoi, _yukr, _گار_, 
   {{0x6298030f,0x442604d1,0x05a60088,0x58d515d3}},	//   _arvo, _cuo_, рвый_, _тоат, 
   {{0xf7730e61,0x67210062,0x645b2f59,0xe29902a6}},	//   _دار_, _uglj, rrui, вао_, 
   {{0x629805ae,0x645b2f5a,0xd5ae015f,0x59b91c54}},	//   _crvo, srui, سفی_, _आवार, 
   {{0x6298090b,0x645b0b22,0x947900b3,0x22582f5b}},	//   _drvo, prui, _аску_, árka_, 
   {{0x6d4603ef,0x03a502b9,0x628a2d9c,0x6298012e}},	//   _reka, _вило, _esfo, _ervo, 
   {{0x6d462f5c,0x91fd00e0,0x4ab502e6,0xfd6400f6}},	//   _seka, tuāc, ंहाव, өнгү, 
   {{0x7c262f5d,0xf233009c,0x629e02be,0xf1bf00de}},	//   _sukr, _ابتک, _àpop, bká_, 
   {{0xf1bf08d7,0x65b50187,0x3dc9209a,0x25bf2f5e}},	//   cká_, _záhr, ghaw_, nkul_, 
   {{0x0b462f5f,0xa91d00ca,0xd7c5009a,0xab2a04b6}},	// [2200] инан, _kažu, वसाच, воза_, 
   {{0x67ff078a,0x75fe00e5,0x91fd01dd,0x6d462f60}},	//   bêji, rëzi, grāf, _weka, 
   {{0x3ea602f1,0xa9262f61,0xed5a00d9,0xae1f00a5}},	//   _тинг, адел, _ион_, _मंचन_, 
   {{0x25ad2f62,0xd3780a1a,0x6d46011c,0xda650038}},	//   jjel_, miće_, _ueka, صامي, 
   {{0xd3780d26,0xa9672f63,0xe8942f64,0x83fd010e}},	//   liće_, рича_, саль, ntős, 
   {{0x91fd0bc3,0xd90d00d6,0x75220036,0xf1bf02d9}},	//   ntār, ریل_, _sgoz, zká_, 
   {{0x4426048a,0x4b7b0a33,0x6442006a,0xd37803f5}},	//   _suo_, _שאלו, _swoi, niće_, 
   {{0x44262f65,0x2d92158b,0xbcfb00eb,0xa3d30262}},	//   _puo_, ndye_, _scéi, सोस_, 
   {{0xa91d0082,0x569200f0,0xa4d4012d,0x98bd0083}},	//   _sažv, сақт, сопі, tawą_, 
   {{0x629809c4,0xd37800ca,0xa50702a6,0xa91d0028}},	//   _prvo, kiće_, шења_, _pažv, 
   {{0xe7e30081,0x3f830009,0xf1bf0377,0xd3780a1a}},	//   कचरा_, veju_, tká_, jiće_, 
   {{0x44262f66,0x28db1516,0xd37801b4,0x644200ab}},	//   _tuo_, _मेडि, diće_, _twoi, 
   {{0xe3af017a,0xdb0e01f0,0x75d30038,0x7c29009e}},	//   سری_, _albü, _بينا, _çerx, 
   {{0xf1bf0076,0xd3780588,0x33f32f67,0x245700b3}},	//   ská_, fiće_, _وسوس, _ташь_, 
   {{0x3dc92f68,0x3f832f69,0x2452010e,0x7fd70259}},	//   thaw_, reju_, _انڈس, гіңі, 
   {{0x67ff010c,0x3da42f6a,0x3dc907fc,0x3ead0372}},	//   rêji, оруб, uhaw_, ćet_, 
   {{0x91fd00e0,0x26e20035,0x4c940080,0xa3da00c9}},	// [2210] stās, गपुर_, оитс, _ठगा_, 
   {{0x3dc9006f,0x60c0155b,0xd3780571,0xde6700fd}},	//   shaw_, ømme, biće_, _къмп, 
   {{0x200300f1,0x6e950084,0x3a7511f0,0xad9b0354}},	//   mlji_, _الجا, слер, _bhút, 
   {{0x628600ab,0xdb0e0369,0xfbdf009e,0xaa5804b6}},	//   łkow, _albó, _avêt_, рицу_, 
   {{0x9f51031e,0x260a1567,0x18211489,0x9f58009e}},	//   hozí_, ातनी_, मदेव_, dorê_, 
   {{0x600000c8,0xdb1c00a1,0x26e2009a,0x68190118}},	//   tömi, _flrà, गपूर_, _kňdi, 
   {{0x7c2d00cf,0x200300ef,0x7bc700a4,0x25bf2f6b}},	//   lqar, ilji_, _ilju, tkul_, 
   {{0x59f90088,0x3940008c,0xc7b8090e,0x77bd022c}},	//   _себя_, ðist_, _viđa_, _mèxi, 
   {{0x7bc70412,0x26c10187,0x38600014,0x7c2d2f6c}},	//   _klju, šho_, àirt_, nqar, 
   {{0x25bf2f6d,0x84e5004e,0xd6db2f6e,0x68e40038}},	//   skul_, _қолж, _ите_, úide, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd3782f6f,0xad9b007a,0x930d0241,0x00000000}},	//   viće_, _mhús, _ışık, --, 
   {{0x7bc72f70,0x34ab0038,0x61e603d8,0xe3ae2f71}},	//   _olju, _جداً_, rnkl, _еб_, 
   {{0xd378034c,0x65692f72,0x6d4b003e,0x9f580034}},	//   tiće_, lgeh, ðgan, morë_, 
   {{0xada6237f,0x6da62f73,0x75fe024a,0x63bc2f74}},	//   бавл, бива, rëzv, örne, 
   {{0x65692f75,0x7bc72f76,0xd378034c,0xb14600d9}},	//   ngeh, _alju, riće_, _унил, 
   {{0x0c232f77,0xd37807c7,0x7bc700d0,0x69d80107}},	// [2220] змун, siće_, _blju, èvem, 
   {{0x65bc026d,0x7f8600eb,0xd378034c,0x21f20098}},	//   _véhi, _الدن, piće_, váhy_, 
   {{0xdb0e05d5,0x387f01f1,0x09e62f78,0x1617103d}},	//   _albò, _apur_, божн, दगार_, 
   {{0x27e90038,0xdb1c0219,0x9f58024a,0xfce60eaf}},	//   éann_, _omrö, korë_, _гомо, 
   {{0x28d21276,0xfbd1010e,0x65692c33,0xa2d90a20}},	//   _देखि, ستے_, dgeh, _फेस्, 
   {{0xab27005b,0xfaa61fcd,0x207b027a,0x00000000}},	//   _гора_, _лаго, ראסא, --, 
   {{0x7bde2f79,0x8f9b00a7,0x65692f7a,0x9f58010c}},	//   mipu, טיסי, fgeh, torê_, 
   {{0x7bde0985,0x69cb2260,0x743400d9,0x65690aa7}},	//   lipu, chge, ониф, ggeh, 
   {{0xc34a2f7b,0xdb0e019c,0x387f00a1,0x00000000}},	//   ляне_, _mobí, _gpur_, --, 
   {{0x7bde09e8,0x32540cd9,0xd62a2f7c,0x66e62f7d}},	//   nipu, овор, _боже_, _лоза, 
   {{0xd5af2f7e,0x2003133e,0x38660065,0xc2050083}},	//   _ес_, vlji_, luor_, रतलब_, 
   {{0x645d1056,0x7bde00d4,0x31c700c8,0xba9b035c}},	//   ásic, hipu, ссов, אסטי, 
   {{0x7bde2f7f,0x10742f80,0x2bfa0299,0xf5062f81}},	//   kipu, пляю, ्तां_, _уздо, 
   {{0x75fe0034,0x8f3411f0,0x02a6063f,0xb4e4017d}},	//   rëzu, зерц, _грим, फपी_, 
   {{0x7bde2f82,0x91fd00e0,0x7de50009,0x637700a7}},	//   dipu, trād, lėsi, _הגוף_, 
   {{0x1ae70086,0x7bc7090e,0x7c2d2f83,0x3ebe004f}},	//   _করলে_, _slju, tqar, øtta_, 
   {{0x20030062,0xcf8e00d4,0x22ae0095,0xdb0e0356}},	// [2230] plji_, رژی_, dəki_, _dobí, 
   {{0x6569009e,0x7bde2f84,0x61ed2245,0xad9b00eb}},	//   zgeh, gipu, _hjal, _chúr, 
   {{0x387f2f85,0x7c2d00a3,0x7bc70352,0xc33300d1}},	//   _spur_, sqar, _vlju, פוף_, 
   {{0x39492f86,0x7bde1a77,0x38662f87,0xdb0e107c}},	//   úas_, aipu, fuor_, _bobâ, 
   {{0x7c2d008a,0x27e90503,0x61ed2f88,0xdd9800b3}},	//   qqar, éano_, _mjal, _ушэ_, 
   {{0x7bc71993,0x98482f89,0xad9b0534,0x61ed02f1}},	//   _ulju, сяца_, _thús, _ljal, 
   {{0x61ed2f8a,0x65692f75,0x3ffc0070,0xa01b0380}},	//   _ojal, tgeh, אפגע, rwöh, 
   {{0xe4592338,0x61ed2f8b,0x9f58024a,0x8beb0033}},	//   ажи_, _njal, torë_, _কঠিন_, 
   {{0x65692f75,0x69c92f8c,0x29190212,0xb3c900d9}},	//   rgeh, _ilee, _àsa_, илиз_, 
   {{0xd7fb2f8d,0xa3d3000f,0x61ed2f8e,0x65692f8f}},	//   _суб_, सों_, _ajal, sgeh, 
   {{0xf770125e,0x69c919b8,0x9f58024a,0xdb150216}},	//   _سال_, _klee, sorë_, _sozê, 
   {{0x216a2f90,0x3860044e,0x7bde2f91,0xb1da004f}},	//   шими_, šire_, zipu, рьох_, 
   {{0x61ed2f92,0x69c900ef,0x69db0415,0xdb0e0032}},	//   _djal, _mlee, _mmue, _robí, 
   {{0xee3a2f93,0xd9b62df7,0x61ed1b3e,0x69c22f94}},	//   инг_, _अक्ट, _ejal, zkoe, 
   {{0x61ed2f95,0x80db0086,0x9f582f96,0x98bd0035}},	//   _fjal, _যুদ্, noré_, rawę_, 
   {{0x61ed2f97,0x8066243e,0x22510076,0xd3780704}},	//   _gjal, _движ, ázku_, mića_, 
   {{0x7bde2f98,0xd378003a,0x394f2f99,0x1b4a0176}},	// [2240] tipu, lića_, dags_, изаи_, 
   {{0x69db0bf1,0x69c92f9a,0x61ed0082,0x81ac0033}},	//   _amue, _alee, _zjal, _গতি_, 
   {{0x7bde2f9b,0xd3780062,0x49a4004e,0xdb0e1cf0}},	//   ripu, nića_, зылғ, _tobí, 
   {{0x7bde2f9c,0x0906002e,0x7ae30038,0xa967263b}},	//   sipu, опен, únta, жица_, 
   {{0xd3782f9d,0x69c22f9e,0x91fd00e0,0x7bde00d4}},	//   hića_, rkoe, duāl, pipu, 
   {{0xd378034c,0xa09b035c,0x69c22f9f,0x56940a31}},	//   kića_, יינט, skoe, закт, 
   {{0xeb910137,0xd37801b4,0xa3bf00b0,0x3a2a012b}},	//   _אָן_, jića_, ीसन_, _uubp_, 
   {{0xd37800f1,0x35f700d7,0x00000000,0x00000000}},	//   dića_, يريد_, --, --, 
   {{0xb7e62fa0,0x249d0090,0x61ed00c3,0x7ccd040c}},	//   _джак, _crwm_, _rjal, _kўra, 
   {{0xd3780112,0x61ed2fa1,0x9f580107,0x7de50009}},	//   fića_, _sjal, boré_, rėsi, 
   {{0xd3781993,0x69c90088,0x27fc02fe,0x94a8004e}},	//   gića_, _ylee, movn_, ртқа_, 
   {{0xfec20033,0x2018021e,0x00000000,0x00000000}},	//   োপাধ, emri_, --, --, 
   {{0xa5071a9e,0xc953042c,0x60f813f2,0x7bdc2fa2}},	//   _деца_, ומר_, жняя_, _omru, 
   {{0xd3780112,0xcf2700eb,0x42550019,0x00000000}},	//   bića_, ترحي, _کنٹر, --, 
   {{0xcddb2fa3,0x61ed003e,0xd3780a1a,0x91fd01dd}},	//   ања_, _tjal, cića_, grāc, 
   {{0x61ed00da,0xad9b00e1,0x4ea50259,0xdda800d9}},	//   _ujal, _chúp, орға, отул_, 
   {{0x61fd2fa4,0x7e67006d,0x69c9019b,0xbcfb0173}},	// [2250] mosl, sujp, _rlee, _acér, 
   {{0x69c92fa5,0x7a33008a,0x9f430369,0x91fd01dd}},	//   _slee, _aħta, rojó_, zuāl, 
   {{0x69c92fa6,0x8ae702fb,0xaa9500eb,0x394f2fa7}},	//   _plee, ціал, ثلاث, tags_, 
   {{0x61fd2fa8,0xbcfb0228,0x160a0035,0x9f580216}},	//   nosl, _dcér, _हीलर_, norî_, 
   {{0x69c90af8,0xe7392fa9,0x2129012b,0x394f2faa}},	//   _vlee, бел_, _mgah_, rags_, 
   {{0x290402bf,0x61fd00da,0x00000000,0x00000000}},	//   _dyma_, hosl, --, --, 
   {{0x212908a1,0x6fc20228,0x91fd00e0,0x61fd0e25}},	//   _ogah_, _dôch, tuāl, kosl, 
   {{0xd37800f1,0xd90e006b,0x2d89023e,0x78a62fab}},	//   vića_, ئیے_, neae_, _škve, 
   {{0x478b0088,0x7bc52fac,0xe5a300a3,0x69c8010c}},	//   _всем_, okhu, зиқи, _îdea, 
   {{0xd37814f0,0x63b8006d,0x394d2fad,0x7bc50727}},	//   tića_, _covn, _hees_, nkhu, 
   {{0x88bd0086,0x7bc5109e,0x9f4e0356,0x6b952fae}},	//   _অধিক, ikhu, áním_, _mazg, 
   {{0xd378003a,0x2001085f,0x6b952faf,0x394d1279}},	//   rića_, _akhi_, _lazg, _jees_, 
   {{0x394d2fb0,0xd3780112,0xd9bd0086,0x9f4e02d9}},	//   _mees_, sića_, _আগাম, šním_, 
   {{0x394d2fb1,0x443f134c,0x437507f5,0xdd9211b7}},	//   _lees_, mpu_, _זײַן_, کور_, 
   {{0x443f2fb2,0x6012008c,0xc3320070,0x61fd2fb3}},	//   lpu_, væmd, _אוו_, bosl, 
   {{0xc8bd0f01,0x394d023b,0x63b8053d,0x62832fb4}},	//   ्नाट, _nees_, _zovn, _ipno, 
   {{0x6b950242,0x443f0118,0xdd8f09ed,0xafe62fb5}},	// [2260] _bazg, npu_, دوق_, _ноил, 
   {{0x6000183f,0x3a242fb6,0xa09b008d,0x2c7402ae}},	//   röms, _simp_, _פייט, räd_, 
   {{0x394d2fb7,0xc7b8090e,0x3f8a023e,0x00000000}},	//   _bees_, _rođ_, mebu_, --, 
   {{0xa96a0c67,0x3f8a2fb8,0x394d2fb9,0x62830054}},	//   сида_, lebu_, _cees_, _mpno, 
   {{0x6d441868,0x394d2fba,0x684323ef,0x7bc5006d}},	//   mbia, _dees_, енча, bkhu, 
   {{0x6d44012d,0x3f982fbb,0x6e26011d,0x3f8a00f8}},	//   lbia, ndru_, _hikb, nebu_, 
   {{0x3a240012,0x63b82fbc,0xd9461b85,0x2bc1009a}},	//   _timp_, _rovn, _неви, _शकता, 
   {{0x394d018c,0x6fcb0384,0x3f8a2fbd,0x3a24001d}},	//   _gees_, _müca, hebu_, _uimp_, 
   {{0x443f011d,0x6b951240,0xd49700b3,0x00000000}},	//   gpu_, _yazg, прэ_, --, 
   {{0x3f8a0613,0x60270212,0x260a009a,0x883b00d1}},	//   jebu_, hémè, ातही_, _לתמו, 
   {{0x394d01a0,0x61fd2fbe,0x7d060ff2,0xd6c4009c}},	//   _yees_, tosl, _lyks, _تمای, 
   {{0x394d0201,0x25a60156,0xdceb0352,0x3f9801dd}},	//   _xees_, _unol_, _žičn, edru_, 
   {{0x64a32fbf,0x61fd2fc0,0x77bd022c,0x660207d7}},	//   _паца, rosl, _tèxt, _ikok, 
   {{0xb7bd002e,0x3f8a2fc1,0x61fd00a3,0x00000000}},	//   _puţi, gebu_, sosl, --, 
   {{0xbcfb0183,0x64400511,0xddd02fc2,0xd37800ca}},	//   _acép, lpmi, _šeši, lićo_, 
   {{0x6d442fc3,0x6b95009e,0x00000000,0x00000000}},	//   gbia, _sazg, --, --, 
   {{0x394d2fc4,0x66022fc5,0x6ce4128b,0x6e26040b}},	// [2270] _rees_, _mkok, ніфе, _dikb, 
   {{0xfe6e15c0,0x60cf07fa,0x7dca0098,0xbca40038}},	//   دگی_, ınmı, _výsa, عملي, 
   {{0x6d442fc6,0x394d2fc7,0x6b95027e,0x7b640314}},	//   bbia, _pees_, _vazg, этте, 
   {{0x394d023b,0x3ebe2fc8,0x66022843,0x3eac1341}},	//   _qees_, ätte_, _nkok, ådte_, 
   {{0x394d2fc9,0x315800c7,0x6b950144,0x00000000}},	//   _vees_, ליאן_, _tazg, --, 
   {{0x394d042e,0x98a22fca,0x6d4f2fcb,0x66022fcc}},	//   _wees_, тише, _heca, _akok, 
   {{0x6d4f031d,0x996700b3,0x7c2f0ad9,0x00000000}},	//   _keca, _нтал, _hucr, --, 
   {{0x84592fcd,0x7c272fce,0x6d4f044e,0x3860044e}},	//   орот_, _hijr, _jeca, šira_, 
   {{0x855400d4,0x6f0900bc,0x6add2fcf,0x00000000}},	//   ریور_, řech, _मधुर, --, 
   {{0x6d4f2fd0,0x443f2fd1,0xd24300a3,0x00000000}},	//   _leca, rpu_, нмоқ, --, 
   {{0x7c2f0aa4,0xa18a24d2,0x6d5d0f6a,0x6d4400f8}},	//   _lucr, обна_, _odsa, ybia, 
   {{0x443f0d3e,0x6d4f2fd2,0x798b00f8,0x3f8a2fd3}},	//   ppu_, _neca, negw, webu_, 
   {{0xc4fb00d4,0x6e2600c3,0x66092fd4,0x9554009c}},	//   _اعضا_, _rikb, mlek, _سخنا, 
   {{0x661b2fd5,0x7d062fd6,0x9eaa00a3,0x443d0106}},	//   lmuk, _ryks, овга_, _itw_, 
   {{0x6d4f2eaa,0x442f2fd7,0x7d060088,0x3f8a2fd8}},	//   _beca, _hug_, _syks, rebu_, 
   {{0x44272fd9,0x6d4f2fda,0x7e61008c,0x66092fdb}},	//   _hin_, _ceca, álpa, nlek, 
   {{0x6d442617,0xfce30170,0x442f2b45,0x7c2f00e7}},	// [2280] rbia, вото, _jug_, _cucr, 
   {{0x8bf100cc,0x660907d7,0x7d06012d,0x7c2f0151}},	//   _জীবন_, hlek, _vyks, _ducr, 
   {{0x442f2fdc,0xbcfb023e,0x6eb52158,0x7c2f2fdd}},	//   _lug_, _adéd, _उपयु, _eucr, 
   {{0x44272fde,0x66092fdf,0x661b0065,0x442f00b3}},	//   _lin_, jlek, jmuk, _oug_, 
   {{0xa3bf0827,0x645d014b,0x443d006d,0x442f01a0}},	//   ीसा_, ásil, _ntw_, _nug_, 
   {{0x44272fe0,0xb8d629c4,0x6d4f02be,0x661b08e5}},	//   _nin_, _छप_, _zeca, emuk, 
   {{0x34b80a09,0xd6d000eb,0x443d0045,0x660202a2}},	//   ेन्द, طقة_, _atw_, _pkok, 
   {{0xd5b0057f,0x661b0daa,0x66090b48,0x442f2dc3}},	//   افة_, gmuk, glek, _bug_, 
   {{0x44272fe1,0x442f0561,0x443d0354,0x00000000}},	//   _bin_, _cug_, _ctw_, --, 
   {{0x3946012d,0xa3d800ab,0x66092fe2,0x17832fe3}},	//   lbos_, ठों_, alek, _игум, 
   {{0xbcfb2fe4,0x442f01fd,0x200f0028,0x00000000}},	//   _idée, _eug_, _ūgio_, --, 
   {{0x44272fe5,0x7dc3007e,0xf1a71fcd,0x39460d62}},	//   _ein_, _tõsi, фрон, nbos_, 
   {{0x6d4f257d,0x29f82fab,0x443d016a,0x39461d72}},	//   _reca, mčad_, _gtw_, ibos_, 
   {{0x6d4f2e7b,0x44272fe6,0x9f4300e5,0xa2d90249}},	//   _seca, _gin_, mijë_, _फेक्, 
   {{0x7c2f2fe7,0x7dd10075,0x442f0380,0x9f5800b9}},	//   _sucr, _låse, _zug_, corí_, 
   {{0x44272fe8,0x29f8090e,0x442f01a0,0xa01b0380}},	//   _zin_, nčad_, _yug_, gwör, 
   {{0x44272fe9,0x6d4f2fea,0x62970183,0x00000000}},	// [2290] _yin_, _veca, _áxor, --, 
   {{0x2fc700f7,0x44270029,0x60c0022b,0x66090019}},	//   _ông_, _xin_, ämme, zlek, 
   {{0x386600e2,0x6d4f2feb,0xf09f03dd,0x798b2fec}},	//   eror_, _teca, lvà_, tegw, 
   {{0x6d5d055f,0x6eae031e,0x7f550126,0x38660156}},	//   _udsa, ीहरु, lazq, fror_, 
   {{0xdd3a0056,0x660910ea,0x798b0199,0xe739181b}},	//   _מערכ, vlek, regw, пел_, 
   {{0x2d990149,0xe7392fed,0xe611009c,0xa69508bd}},	//   _hase_, чек_, گشت_, ериј, 
   {{0x44272fee,0x2d992fef,0x27e901b4,0x442f2ff0}},	//   _rin_, _kase_, đan_, _sug_, 
   {{0x44272ff1,0xfc3f00eb,0x9f580187,0x248602a2}},	//   _sin_, _tríd_, vorí_, _bpom_, 
   {{0x66092ff2,0x661b04bb,0x44272ff3,0x998a02d9}},	//   rlek, rmuk, _pin_, _zubů_, 
   {{0xe3b1057f,0xe8bd047c,0x2d992ff4,0x66092ff5}},	//   ارة_, ्नीच, _lase_, slek, 
   {{0x44272ff6,0x66092ff7,0x443d08b0,0x13091193}},	//   _vin_, plek, _wtw_, яной_, 
   {{0x442f2ff8,0x44272ff9,0x7643016a,0xe29611e7}},	//   _tug_, _win_, mpny, хаю_, 
   {{0x44272ffa,0x30752ffb,0x2ec818b4,0x10a32ffc}},	//   _tin_, курс, रन्त, гиян, 
   {{0x44272ffd,0xd0122e10,0x2d990b48,0x00000000}},	//   _uin_, الس_, _aase_, --, 
   {{0xf8bd000d,0x3946012d,0x91e608d1,0x2d992ffe}},	//   ्नुप, ybos_, _поке, _base_, 
   {{0x2d992fff,0xdb1c026a,0xa3cd0083,0x7dca00da}},	//   _case_, _forê, रसव_, _výso, 
   {{0xa3c302f8,0x3dd202f0,0x8fa61d05,0x2d990183}},	// [22a0] _एका_, rhyw_, _запе, _dase_, 
   {{0x61e60998,0xfc3f0084,0x395f3000,0x32023001}},	//   likl, _dtí_, _adus_, loky_, 
   {{0x160f09e2,0x66000548,0x7dd102ae,0xb17b02ae}},	//   ातार_, yomk, _såse, pnåt, 
   {{0x61e63002,0x2d993003,0x7dd11e9f,0x38663004}},	//   nikl, _gase_, _påse, tror_, 
   {{0xe8943005,0xa92702fb,0x3f9a3006,0x98a33007}},	//   таль, ніше_, _kapu_, лице, 
   {{0x2d991425,0x2d803008,0x38663009,0xa3e10299}},	//   _zase_, lfie_, rror_, नोम_, 
   {{0x3f9a2cb5,0xdb1c024a,0x61e6300a,0xd90d0019}},	//   _mapu_, _morë, kikl, میہ_, 
   {{0xceb30056,0x6d56300b,0x3f9a00e0,0x3949008c}},	//   ריה_, naya, _lapu_, ðast_, 
   {{0x61e6300c,0x186703b7,0x9418040c,0x29f80082}},	//   dikl, _пати_, мжит_, rčad_, 
   {{0x6d56300d,0xb34611c9,0x3f9a00ca,0x7dca003e}},	//   haya, diçõ, _napu_, _sýsl, 
   {{0x6d56300e,0xd257004f,0x2ca000b0,0xf773027a}},	//   kaya, нця_, hvid_, _תקע_, 
   {{0x6d5627c8,0xab64027e,0x25bd007b,0x61e60028}},	//   jaya, ldüğ, _gowl_, gikl, 
   {{0x7dca0076,0x6d56300f,0x1ae700cc,0x2ca010b7}},	//   _výsl, daya, _করছে_, jvid_, 
   {{0xb4be02e6,0x2ca0014e,0x6fcb0095,0x20050228}},	//   ीनी_, dvid_, _gücl, ôli_, 
   {{0x2d99158b,0x2d803010,0xdb1c00e5,0x6d5600e2}},	//   _pase_, ffie_, _dorë, faya, 
   {{0xdd941b17,0x6d563011,0x3253048a,0xb34603b7}},	//   ласы, gaya, _свър, biçõ, 
   {{0xdb15026e,0xacf83012,0xa91d16fb,0xbc790cfe}},	// [22b0] _vozí, енту_, _obža, ьбах_, 
   {{0xdb1c3013,0x9f5800b9,0xe7e200bc,0x00000000}},	//   _korè, corà_, कोमा_, --, 
   {{0x6d563014,0x20030009,0x2d993015,0x16200ba3}},	//   baya, moji_, _tase_, मगार_, 
   {{0x6d5600d7,0x20033016,0xaf4b010e,0x9f58019c}},	//   caya, loji_, _بشکل_, porã_, 
   {{0xdb1c023e,0x83fd010e,0x7dda02d9,0xa01b003e}},	//   _lorè, rtőz, růst, rtöf, 
   {{0x61e63017,0x20033018,0x3202023a,0x00000000}},	//   zikl, noji_, zoky_, --, 
   {{0x34c90a09,0x79a40259,0x00000000,0x00000000}},	//   िन्द, _өрте, --, --, 
   {{0x20030053,0x00000000,0x00000000,0x00000000}},	//   hoji_, --, --, --, 
   {{0x61e605ce,0x2003122d,0x99870028,0x3202023a}},	//   vikl, koji_, ūnų_, voky_, 
   {{0xad9b01d5,0xd7591f7a,0x6d563019,0x799b301a}},	//   _skúl, _آلات_, zaya, _hauw, 
   {{0x6d56301b,0x216a1b08,0x27e7008c,0x320200a9}},	//   yaya, мини_, minn_, toky_, 
   {{0xe3b11fdb,0x6d56011c,0x27e7301c,0xb3460165}},	//   ارک_, xaya, linn_, tiçõ, 
   {{0x61e6301d,0x3f9a301e,0x3202301f,0x799b3020}},	//   rikl, _papu_, roky_, _mauw, 
   {{0x200311c8,0x6d563021,0xb34602a0,0x27e73022}},	//   goji_, waya, riçõ, ninn_, 
   {{0x6d563023,0xb34602a0,0xa3d63024,0xdb1c00d7}},	//   taya, siçõ, _सतत_, _gorè, 
   {{0x27e7004c,0x799b3025,0x69cb02b0,0xdce40372}},	//   hinn_, _nauw, jkge, ngić, 
   {{0x6d56170d,0x61e43026,0x27e7008c,0x7e7c203b}},	// [22c0] raya, _imil, kinn_, strp, 
   {{0x6d563027,0x80db3028,0x9f4a060f,0xfaa63029}},	//   saya, _যুক্, robó_, казо, 
   {{0x6d56302a,0x799b302b,0x7c36024a,0x81f70274}},	//   paya, _bauw, sqyr, _سفیر_, 
   {{0x5e570137,0xe8ea302c,0x6d56302d,0x186a302e}},	//   _ביטע_, ммед_, qaya, дади_, 
   {{0xf7720040,0x27e7302f,0x61e43030,0x76410009}},	//   لاغ_, finn_, _mmil, _atly, 
   {{0x27e73031,0xf093035c,0x6a8600a3,0x69cb08a3}},	//   ginn_, ינד_, _илга, akge, 
   {{0xbcfb3032,0xd6cf00b1,0x7dc3007e,0xfc3f033c}},	//   _idéa, يقه_, _tõst, _iría_, 
   {{0x6b9c3033,0xd876006b,0x69cb01c4,0xd37808e3}},	//   _harg, _لائب, ckge, mići_, 
   {{0xb4be3034,0xb4cc11bd,0x6b9c3035,0xd378034c}},	//   ीने_, रने_, _karg, lići_, 
   {{0x61e43036,0x69c03037,0x27e701c5,0x79823038}},	//   _amil, _home, cinn_, lfow, 
   {{0xd6c41fdb,0xa3e30b3e,0xa3c30077,0x6b9c3039}},	//   _حمای, _नगर_, _एकर_, _marg, 
   {{0x6b9c303a,0xdb1c303b,0x38692470,0x80db0bf1}},	//   _larg, _coré, šare_, _যুগ্, 
   {{0xdb151cf0,0xdb1c303c,0xbcfb0054,0xd3780372}},	//   _mozá, _doré, _odéa, hići_, 
   {{0x61e4303d,0xa3e11276,0xbcfb00eb,0x60c0014e}},	//   _emil, नोद_, _ndéa, ämma, 
   {{0x9e0702fb,0x2003303e,0xdd9b004e,0xd37800d2}},	//   вчал, roji_, мша_, jići_, 
   {{0xd3780062,0x973c0242,0x2003303f,0xdb1c033e}},	//   dići_, _inću, soji_, _goré, 
   {{0x78a20df4,0x32092244,0xa3d600a5,0x799b02b0}},	// [22d0] jvov, _ikay_, _सता_, _rauw, 
   {{0x6b9c0e2e,0xd378265d,0xfc3f0634,0x9f580042}},	//   _carg, fići_, _cría_, porá_, 
   {{0x6b9c3040,0x69c03041,0x799b3042,0x65620032}},	//   _darg, _bome, _pauw, _odoh, 
   {{0x27e70380,0x644201ca,0x6b9c01be,0xceb20147}},	//   winn_, _otoi, _earg, _היט_, 
   {{0x27e73043,0x69cb0af8,0xfc3f24de,0x6b9c00fc}},	//   tinn_, rkge, _fría_, _farg, 
   {{0x6b9c3044,0xd378090b,0x628a055f,0x86990ca4}},	//   _garg, bići_, _opfo, етит_, 
   {{0x27e73045,0x69c03046,0x06e317f6,0xa2630108}},	//   rinn_, _fome, _केशव_, _cuố, 
   {{0x27e73047,0x69c03048,0x09ca0086,0x6b9c0104}},	//   sinn_, _gome, লোবা, _zarg, 
   {{0x3f910a9f,0x6b9c027e,0x753b02a3,0xdb1c010c}},	//   kezu_, _yarg, rcuz, _jorî, 
   {{0x69c03049,0x6b9c00b9,0x3a2d00e7,0x03951cc1}},	//   _zome, _xarg, _hiep_, урия, 
   {{0x42261c20,0xdb1c0c7c,0x645b304a,0x3f91304b}},	//   лдов, _poré, ssui, dezu_, 
   {{0x9f4e0076,0x7dca0377,0xa06a304c,0x645b2dbb}},	//   čník_, _výsk, нама_, psui, 
   {{0xc60f072f,0xa91d012d,0x6fcb01c4,0xd37800d2}},	//   ातीय_, _pažy, _küch, zići_, 
   {{0xdee6304d,0x3a2d01c8,0x701901fc,0x83350070}},	//   гоги, _liep_, віст_, _גאַס_, 
   {{0xdb1c304e,0x80a200b0,0xa2630108,0x00000000}},	//   _toré, खिहे, _xuố, --, 
   {{0xd37804d1,0xa01b0019,0x7dd11f3c,0x68fb00ad}},	//   vići_, gtöb, _påsa, _oxud, 
   {{0x3b86304f,0x69c03050,0x5baa2f48,0x6b9c078a}},	// [22e0] ллаг, _rome, нкам_, _parg, 
   {{0x69c03051,0xd3780112,0x5eff00c9,0x7f763052}},	//   _some, tići_, _शुक्_, _суиц, 
   {{0x68fb24d3,0x69c03053,0x6b9c3054,0x63bc0f70}},	//   _axud, _pome, _varg, örni, 
   {{0x6b9c090a,0xd3780112,0x9f5803a1,0x2b470241}},	//   _warg, rići_, forç_, ınca_, 
   {{0x2d923055,0x17540a74,0x3a2d0318,0xd7e60c8b}},	//   meye_, авля, _diep_, ліко, 
   {{0x6fcb02f2,0x78a2014b,0x69c03056,0xd378090e}},	//   _rück, rvov, _wome, pići_, 
   {{0x64423057,0xb4cc0299,0xe8f7004e,0x22400372}},	//   _stoi, रन्_, _ұлт_, _čiko_, 
   {{0x2d922a1a,0xa3d6072f,0xa2a20586,0xa5343058}},	//   neye_, _सतह_, गिस्, шнич, 
   {{0xf7463059,0x7c2e305a,0x601b009e,0xdb1e305b}},	//   _безо, _kibr, lîme, skpä, 
   {{0x7c2e305c,0xdcef0588,0xbcfb0096,0x2d920610}},	//   _jibr, šeće, _odén, heye_, 
   {{0x3f9104d1,0x8646305d,0x058600a3,0x2d92305e}},	//   vezu_, _снеж, _булм, keye_, 
   {{0x7c2e305f,0xf6510105,0x6fcb0380,0x2d9204a8}},	//   _libr, _گئے_, _züch, jeye_, 
   {{0x7c2e0084,0x3f910d26,0xbcfb10f1,0x2d9204a8}},	//   _oibr, tezu_, _adén, deye_, 
   {{0x7c2e0175,0x40341646,0x00000000,0x00000000}},	//   _nibr, серс, --, --, 
   {{0x629800f1,0x8bc70e65,0xddab0a10,0x442e01f2}},	//   _usvo, қсад, нтал_, _iif_, 
   {{0x7c2e00eb,0x442e3060,0xb8860228,0x320907fc}},	//   _aibr, _hif_, _zníž, _ukay_, 
   {{0x442e0529,0x3b553061,0x7c2e01d6,0x3a2d02b0}},	// [22f0] _kif_, икар, _bibr, _riep_, 
   {{0x7c2e0042,0x3a2d039b,0x00000000,0x00000000}},	//   _cibr, _siep_, --, --, 
   {{0x8aa7004e,0x2d9201e3,0x7c2e3062,0xfaa70cfe}},	//   ырад, beye_, _dibr, ышан, 
   {{0xd37800d0,0x2d923063,0x6fcb0502,0xdd91007a}},	//   miću_, ceye_, _süch, _بوح_, 
   {{0xd37801b4,0xbcfb2ee4,0x9984020f,0xdcfd0243}},	//   liću_, _idéo, _simţ_, _masī, 
   {{0xdcfd002a,0x7c2e3064,0xf7710eea,0x6d4d0af8}},	//   _lasī, _gibr, زات_, lbaa, 
   {{0x45d53065,0xd3780112,0x3a2d0023,0x00000000}},	//   ицит, niću_, _tiep_, --, 
   {{0x6d4d0265,0xb88600bc,0x44653066,0x442e3067}},	//   nbaa, _sníž, авив, _aif_, 
   {{0x851f3068,0xd37802fe,0xe4563069,0x6d4d306a}},	//   मेंट_, hiću_, ажы_, ibaa, 
   {{0x2d922a28,0x7c2e08bc,0x6d4d0118,0xd378044e}},	//   zeye_, _xibr, hbaa, kiću_, 
   {{0x629e1ac6,0x6d4d051e,0xd378090e,0x6b60010e}},	//   _špor, kbaa, jiću_, lágí, 
   {{0xd378003a,0x78a9306b,0x442e306c,0x6d4d01c8}},	//   diću_, _krev, _eif_, jbaa, 
   {{0x6d4d12b6,0x2d9203a0,0x7989030b,0x20d508af}},	//   dbaa, veye_, _mbew, бірс, 
   {{0xd3780112,0x2d92007c,0xfe46306d,0x78a90054}},	//   fiću_, weye_, инго, _mrev, 
   {{0xed5a306e,0x2d92306f,0xdbcf0228,0xd37805ae}},	//   ков_, teye_, bľúb, giću_, 
   {{0x3860034c,0x78a93070,0x6d4d15e9,0xfc3f0126}},	//   širi_, _orev, gbaa, _crío_, 
   {{0x2d922a1a,0xd00f006b,0x64493071,0x00000000}},	// [2300] reye_, سلہ_, npei, --, 
   {{0x2d923072,0x7c2e0508,0x79893073,0xd378090e}},	//   seye_, _qibr, _abew, biću_, 
   {{0x7f5c3074,0xeb973075,0xfc3f0503,0x78a93076}},	//   marq, рих_, _frío_, _arev, 
   {{0xa96a00cf,0x22513077,0x3a990b58,0x973c0588}},	//   тида_, ázky_, ытую_, _maće, 
   {{0x78a93078,0x386000eb,0x7c2e3079,0x913b00c7}},	//   _crev, éir_, _tibr, דענק, 
   {{0x78a92593,0x7f5c1d9c,0x600000c8,0xe66608bd}},	//   _drev, narq, tömy, атио, 
   {{0x442e307a,0xd9100444,0x6449039b,0x00000000}},	//   _rif_, _کیش_, epei, --, 
   {{0x69d90c3e,0x7dd800eb,0x442e307b,0x1dbf059e}},	//   chwe, _físe, _sif_, _एकछत, 
   {{0x030b00ab,0xd378015e,0xdb1c240a,0x2e3c008c}},	//   _सुबह_, ziću_, _morí, _líf_, 
   {{0x66e6307c,0x2b5803dd,0x442e307d,0x00000000}},	//   _коза, _jerc_, _qif_, --, 
   {{0xe7370088,0x29f8044e,0x442e307e,0xcb37027a}},	//   _тех_, nčao_, _vif_, יניק_, 
   {{0xd37800f1,0x973c0ab4,0x660b0096,0x92570080}},	//   viću_, _daće, _gkgk, шают_, 
   {{0x9098307f,0x7dd13080,0x107406ba,0x92b60033}},	//   авят_, _såso, оляю, ছনে_, 
   {{0xd3782e7d,0x92173081,0x7f5c1eb1,0x442e084c}},	//   tiću_, _धीरज_, garq, _uif_, 
   {{0x6d4d3082,0x637b008d,0xdb1c010e,0x63bc003e}},	//   tbaa, _סנהד, _borí, örnu, 
   {{0xd378034c,0xcdd80886,0xdb1c02aa,0x6d4d3083}},	//   riću_, ању_, _corí, ubaa, 
   {{0xdce60718,0x6d4d0af8,0x7f5c3084,0xd90400d4}},	// [2310] _bakı, rbaa, barq, _آی_, 
   {{0x6d4d3085,0x3ceb00a2,0xfaa73086,0xd378090e}},	//   sbaa, _घेणे_, ишен, piću_, 
   {{0x69d93087,0x6d4d0b1f,0xfc3f0634,0x78a90183}},	//   thwe, pbaa, _trío_, _srev, 
   {{0xf99300d4,0x7dd8031e,0x6ec400bc,0x80a424a1}},	//   تبط_, _píse, रहरु, _امین, 
   {{0x2d8b006d,0x18a53088,0x98a53089,0xf7451d75}},	//   _ibce_, салм, силе, бело, 
   {{0x69d9308a,0x78a9032f,0xc8842c61,0xe787308b}},	//   shwe, _vrev, dağı_, рудо, 
   {{0x69d90532,0x5a44012d,0x6b60039f,0x00000000}},	//   phwe, _мэта, ságí, --, 
   {{0x78a9308c,0xdce80035,0x29f80352,0x69d90226}},	//   _trev, śląs, nčal_, qhwe, 
   {{0xdce60c05,0xcdb800a7,0x6fcb0095,0x9f8f027e}},	//   _yakı, שפחה_, _hücu, _güç_, 
   {{0xa3e1308d,0x395d308e,0x3cff00ab,0x62811bc7}},	//   नों_, laws_, _रखने_, ttlo, 
   {{0x6449308f,0x2d8b1cb3,0x11d600eb,0x7c25007a}},	//   spei, _obce_, متحد, imhr, 
   {{0x64490dfa,0x9f51010e,0xc8840e03,0xf1c801ff}},	//   ppei, kozó_, bağı_, рқий_, 
   {{0xc884091f,0x53a5002e,0xd469250f,0x7f5c0e43}},	//   cağı_, _галб, _силе_, tarq, 
   {{0x248f0065,0x395d01a0,0xd91a24ea,0x66093090}},	//   _ipgm_, haws_, טורל, loek, 
   {{0x6fd00a25,0xdb1c0068,0x601201d5,0x00000000}},	//   _häck, _porí, næmi, --, 
   {{0xfe4603dc,0x25bf0a0f,0xdce6027e,0xad9b01d5}},	//   инҳо, njul_, _sakı, _ljúf, 
   {{0x2b580019,0x7f5c2033,0x395d023b,0x5b360ce0}},	// [2320] _perc_, parq, daws_, معار, 
   {{0x66093091,0x25bf042a,0x2f560267,0xa01b1da6}},	//   hoek, hjul_, _утис, ltön, 
   {{0x6fd0014e,0x66093092,0x4e1a0274,0xdce60241}},	//   _läck, koek, _متحد_, _vakı, 
   {{0x29f80a1a,0x200a3093,0xc8840213,0x7dd8235d}},	//   rčao_, lobi_, yağı_, _dísc, 
   {{0x1cba02b4,0xc7c6078c,0x06e500cc,0xdce60c05}},	//   _صاحب_, йски, _পুলি, _takı, 
   {{0x200a2018,0x29f800ef,0x69c30218,0x3a383094}},	//   nobi_, pčao_, êner, _turp_, 
   {{0xe0df01d8,0x91fd0243,0x00000000,0x00000000}},	//   zzò_, nsāc, --, --, 
   {{0x6fd00fd4,0xd6d92e02,0xd49a3095,0xc8840213}},	//   _bäck, шті_, гро_, tağı_, 
   {{0x200a044e,0x73d800cf,0xdb1c03dd,0x70b400bc}},	//   kobi_, идир_, _horà, ुहोल, 
   {{0x6fd00219,0x249d0118,0xc88406a2,0x25bf020f}},	//   _däck, _dswm_, rağı_, ajul_, 
   {{0x66090d2d,0x51f900dd,0x200a0352,0xe56a058e}},	//   boek, иною_, dobi_, _биед_, 
   {{0x38600082,0xdb1c00b9,0xc884035d,0x00000000}},	//   širu_, _morà, pağı_, --, 
   {{0x63bc3096,0x91fd01dd,0x2ed102ff,0x00000000}},	//   örns, drāt, सन्त, --, 
   {{0x3fe70033,0x03a300b3,0x2cad00da,0x00000000}},	//   পক্ষ, _ничо, _šedo_, --, 
   {{0xd35b0a33,0xe2460198,0xed8b0470,0x6fd00380}},	//   _גדול, _اختي, лсак_, _mäch, 
   {{0x395d023b,0x6fd00380,0x3ebf0242,0x3d1d00b0}},	//   xaws_, _läch, ćut_, _मरदे_, 
   {{0xf1f800d6,0x71f8155f,0x320b00ab,0x91a90023}},	// [2330] _دعوت_, _دروس_, mocy_, _giá_, 
   {{0x6fd002f2,0x66090b32,0x9f51010e,0xad9b020b}},	//   _näch, zoek, rozó_, _akút, 
   {{0x6fb500d4,0xad270499,0xfbd00038,0x00000000}},	//   _همکا, _گردو, رتك_, --, 
   {{0x7dd10022,0x6fcb01f0,0x7dd80183,0x39153097}},	//   _måsk, _vücu, _vísc, омер, 
   {{0x7dca063b,0x9ccb3098,0x6d5f1530,0x893400eb}},	//   _výst, _сына_, maqa, أعما, 
   {{0x6fd0022b,0x6d5f3099,0x395d006d,0x61ef19f9}},	//   _räck, laqa, saws_, hicl, 
   {{0x7ac4309a,0x6fd012b7,0xf625309b,0x6609309c}},	//   _есте, _säck, одко, toek, 
   {{0xa2d7059e,0xa4450cdf,0x59f90088,0x6d5f01ff}},	//   मनस्, онид, _тебя_, naqa, 
   {{0x22470110,0x6609309d,0x38600038,0x61ef15b7}},	//   _stnk_, roek, áirt_, dicl, 
   {{0xdb1c0fd9,0xd265093d,0x6d5f1db3,0x6609018c}},	//   _horá, окой, haqa, soek, 
   {{0xdb1c309e,0x4425084c,0x6d5f0415,0x2ca9309f}},	//   _korá, rml_, kaqa, hvad_, 
   {{0x6fd0014e,0x249d023b,0x61ef30a0,0x850400d7}},	//   _täck, _tswm_, gicl, _کوهن, 
   {{0xdb1c30a1,0x200a00a3,0x3c3f010c,0x6d5f30a2}},	//   _morá, tobi_, _nîv_, daqa, 
   {{0x34b209e8,0x232930a3,0xb4c700b0,0x25e517dc}},	//   _آموز, _коли_, ैनी_, जोरी_, 
   {{0xa2e500cf,0x443f30a4,0x200a30a5,0x61ef24bc}},	//   _фойд, lqu_, robi_, bicl, 
   {{0x63a330a6,0xdd92298e,0x657b1b75,0xa01b30a7}},	//   _hann, بور_, nguh, ltöl, 
   {{0x63a330a8,0x7bc730a9,0x973c0082,0x443f0856}},	// [2340] _kann, _boju, _laća, nqu_, 
   {{0x63a330aa,0xad9b30ab,0xf1bf0042,0x443f0151}},	//   _jann, _skút, nmán_, iqu_, 
   {{0x63a330ac,0x7bc7090e,0x3f980404,0x6d5f02f1}},	//   _mann, _doju, meru_, baqa, 
   {{0x63a330ad,0xdb1c04ef,0x29f800ca,0x6fd00502}},	//   _lann, _corá, pčam_, _säch, 
   {{0x91a00023,0xdb1c00da,0x00000000,0x00000000}},	//   _chỉ_, _dorá, --, --, 
   {{0x63a330ae,0x466a30af,0x6d44149f,0x3f9830b0}},	//   _nann, арим_, lcia, neru_, 
   {{0xdb1c0038,0xd90d0019,0x3c3f0216,0x00000000}},	//   _forá, نیہ_, _zîv_, --, 
   {{0x6d4430b1,0x26c004d1,0x39420077,0x63a30a58}},	//   ncia, ćio_, _üks_, _aann, 
   {{0x63a330b2,0x224930b3,0x6d4430b4,0x3f9830b5}},	//   _bann, _čaka_, icia, keru_, 
   {{0x69c209a2,0x3f9802f5,0x63a319a9,0x7dd130b6}},	//   ljoe, jeru_, _cann, _påsk, 
   {{0x61ef30b7,0x63a330b8,0x973c0613,0x29f80082}},	//   ticl, _dann, _gaća, jčak_, 
   {{0x69c230b9,0x51f816d0,0x63a31a29,0x6d4430ba}},	//   njoe, жнюю_, _eann, jcia, 
   {{0x63a330bb,0x3f9830bc,0xa3c300a2,0x68e20104}},	//   _fann, feru_, _एकच_, nzod, 
   {{0xa3ce0190,0x3f980097,0x656030bd,0x6d5f0065}},	//   _रवि_, geru_, lamh, waqa, 
   {{0x9f34005e,0xbcfb02a0,0x534302f1,0x24400108}},	//   дері, _idéi, _ўхша, _hòm_, 
   {{0x63a330be,0x24400cd7,0x656000eb,0x7dd80228}},	//   _zann, _kòm_, namh, _písa, 
   {{0x61ed0112,0x3f9830bf,0x63a330c0,0xad9b0187}},	// [2350] _imal, beru_, _yann, _skús, 
   {{0x6d5f09c7,0xdb1c0019,0x7dd8003e,0x68e2019b}},	//   saqa, _sorá, _vísa, dzod, 
   {{0xdd910084,0x5a350d11,0x61ed008b,0x3f810026}},	//   _كود_, чнет, _kmal, _ichu_, 
   {{0x6d440141,0xfe9a00c7,0x6d5f2789,0xf1bf30c1}},	//   ccia, _פירמ, qaqa, zmán_, 
   {{0x6d5d00e0,0x61ed30c2,0x656030c3,0xf74517e0}},	//   _iesa, _mmal, damh, пело, 
   {{0x6d5d30c4,0x05a304cc,0x67d430c5,0x60c014aa}},	//   _hesa, _खोजब, мочу, ämmi, 
   {{0x63a330c6,0x6d5d30c7,0x61ed30c8,0x7c3d30c9}},	//   _rann, _kesa, _omal, _husr, 
   {{0x63a330ca,0x3f9830cb,0x6d5d30cc,0x959930cd}},	//   _sann, zeru_, _jesa, стку_, 
   {{0x6d5d30ce,0x63a330cf,0xb4d50d53,0xf1ba0023}},	//   _mesa, _pann, सने_, _đơ_, 
   {{0x61ed30d0,0x443f30d1,0x6d5d30d2,0x3ea10034}},	//   _amal, rqu_, _lesa, _osht_, 
   {{0x63a330d3,0x443f026d,0x3f980e39,0x7c350118}},	//   _vann, squ_, veru_, _mizr, 
   {{0x63a330d4,0x6d5d30d5,0xdb1c01cc,0x3f9830d6}},	//   _wann, _nesa, _foræ, weru_, 
   {{0x7c3d30d7,0x63a330d8,0x2fda02a2,0x3ea1024a}},	//   _nusr, _tann, _plpg_, _asht_, 
   {{0xf8a509e8,0x61ed30d9,0x69db30da,0x63a30664}},	//   _یک_, _emal, _llue, _uann, 
   {{0x6d5d2e7b,0x7c3d02f2,0x443d032d,0x68e20036}},	//   _besa, _ausr, _huw_, zzod, 
   {{0xf0662756,0x3f9830db,0x1c4630dc,0x7c3530dd}},	//   _екип, seru_, знам, _aizr, 
   {{0x6d5d30de,0xdb1c00e5,0x3f9830df,0x7c3d016a}},	// [2360] _desa, _korç, peru_, _cusr, 
   {{0x6d4430e0,0x69db030f,0xe81b00a5,0x6d5d059e}},	//   scia, _alue, _पीला_, _eesa, 
   {{0x69c2040b,0x160b0a34,0x69c9084c,0xcf5700d1}},	//   tjoe, हकार_, _boee, _מבית_, 
   {{0x6d5d30e1,0x7bde30e2,0x79a327eb,0xf3f10210}},	//   _gesa, shpu, ерше, hị_, 
   {{0x2d82014e,0xb4d500c2,0x9f51009e,0x00000000}},	//   _icke_, सनो_, dizê_, --, 
   {{0x56941504,0x244030e3,0x68e230e4,0x69c230e5}},	//   дакт, _ròm_, rzod, sjoe, 
   {{0x69db30e6,0x6d5d30e7,0x6459007b,0x8f9b027a}},	//   _flue, _yesa, _awwi, מיסי, 
   {{0xe9a330e8,0x7c3d0da2,0x64590175,0x66040032}},	//   _пасп, _yusr, _bwwi, čiko, 
   {{0xdb1c008f,0x2816010e,0xd49a0283,0x656030e9}},	//   _borç, _فورس, ёри_, ramh, 
   {{0x46a630ea,0x656030eb,0x61ed00a7,0xa01b0088}},	//   _назв, samh, _smal, ttöm, 
   {{0xdb05011c,0x644b040c,0x6b67039f,0x244003a0}},	//   gdhè, _etgi, légí, _wòm_, 
   {{0x39461408,0x7ae1010e,0x443d03c6,0x00000000}},	//   ncos_, _ülte, _fuw_, --, 
   {{0xdb1c30ec,0x394621dc,0x7dd800bc,0x9426004e}},	//   _forç, icos_, _písn, _емде, 
   {{0x925700c5,0x3ea1016a,0x38660065,0xa01b003e}},	//   _کشور_, _psht_, isor_, mtök, 
   {{0x6d5d30ed,0x7c3d02f5,0x9f4a0327,0xdb05024a}},	//   _pesa, _susr, cibí_, rdhë, 
   {{0x61ed30ee,0x42fb00a7,0x7c3d30ef,0x6d5d1e1b}},	//   _umal, _להוס, _pusr, _qesa, 
   {{0x6d5d30f0,0x7bdc02a5,0x25a630f1,0xa01b30f2}},	// [2370] _vesa, _blru, _maol_, ntök, 
   {{0x6d5d052b,0x6e992d7c,0x394630f3,0x4ea730f4}},	//   _wesa, _двор_, ecos_, _ерма, 
   {{0xdb5800c8,0xdd0c0035,0x200430f5,0x61fd30f6}},	//   яют_, góło, émie_, onsl, 
   {{0x61fd30f7,0x23c8031e,0x3a240126,0x22580098}},	//   nnsl, ाउँद, _chmp_, árky_, 
   {{0x07a530f8,0x5fd1109f,0x660400ca,0xc7a511d2}},	//   далн, _सकाल, čikl, дилк, 
   {{0x39460126,0x0966009e,0xdb1c02ae,0x443d01d2}},	//   acos_, _çînê_, _borä, _ruw_, 
   {{0x443d011c,0x56921571,0x6446003e,0xa01b0080}},	//   _suw_, вајт, íkin, ttöj, 
   {{0x25a60a75,0x63b80118,0x394630f9,0xcb3400fd}},	//   _caol_, _anvn, ccos_, _чесъ, 
   {{0xf1bf30fa,0xdb1c0165,0x25a60054,0x443d011c}},	//   rmál_, _porç, _daol_, _quw_, 
   {{0x7dd80126,0x395f30fb,0xf1bf003e,0xc2450df6}},	//   _aísl, _heus_, smál_, мнок, 
   {{0x25a602f1,0x395f01c8,0x77630183,0xfc3f0038}},	//   _faol_, _keus_, manx, _luí_, 
   {{0x776308bc,0x25a60a75,0x67210eae,0x61fd30fc}},	//   lanx, _gaol_, _izlj, gnsl, 
   {{0x395f30fd,0x644b0f5b,0x20b50504,0xdb1c2768}},	//   _meus_, _utgi, нёрс, _torç, 
   {{0x7dd80228,0x61fd123b,0xe82008dd,0x395f00a1}},	//   _píso, ansl, यतया_, _leus_, 
   {{0xe7e5007e,0x628801d2,0x83fd039f,0x00000000}},	//   _कतना_, ctdo, lsőo, --, 
   {{0x26130165,0x395f30fe,0xe1f2009c,0x9f9400c8}},	//   mãos_, _neus_, _جست_, _sää_, 
   {{0x39a600e4,0xfc3f0038,0x9f940080,0x00000000}},	// [2380] _jūsų_, _cuí_, _pää_, --, 
   {{0x39a600e4,0x672130ff,0xafdb03a9,0x3ebe02ae}},	//   _mūsų_, _ozlj, spør, ätts_, 
   {{0x395f033e,0xa5bd0028,0x77633100,0x00000000}},	//   _beus_, rmųj, danx, --, 
   {{0xfc3f0369,0x395f00a1,0xbcfb00b9,0xa01b0080}},	//   _fuí_, _ceus_, _adéu, ytök, 
   {{0x395f3101,0x5fd2006a,0x1867169d,0x9f9400c8}},	//   _deus_, _हवाल, дачи_, _tää_, 
   {{0x25a600eb,0x7763022c,0x2d803102,0x7a2300b0}},	//   _saol_, ganx, lgie_, võte, 
   {{0xc7b80029,0xdb1c014e,0x69d800e5,0x61fd3103}},	//   _vnđ_, _borå, ëves, ynsl, 
   {{0x395f3104,0x746a3029,0x2d803105,0x69d801dd}},	//   _geus_, оров_, ngie_, īves, 
   {{0xd49a004f,0x211d2b69,0x38c30028,0x00000000}},	//   іри_, _नरेश_, gūrą_, --, 
   {{0x1b210086,0x77630183,0xf1bf014b,0x2613019c}},	//   _বলতে_, canx, rmám_, fãos_, 
   {{0xc7b3042c,0xdb1c03a9,0x26130165,0xa01b3106}},	//   _שבע_, _forå, gãos_, stök, 
   {{0xdb07010c,0x628801ff,0x22ac00bc,0x3cff007e}},	//   _bajê, rtdo, _věk_, _रखले_, 
   {{0x7dd10750,0x2ca03107,0x61fd03fa,0x9f580369}},	//   _måst, jwid_, rnsl, joró_, 
   {{0x7dd10343,0x752201ca,0x2d80040b,0x00000000}},	//   _låst, _izoz, egie_, --, 
   {{0x40343108,0xfc3f007a,0xa1953109,0xa01b0080}},	//   терс, _suí_, _зайч, ntöi, 
   {{0xdd9411db,0x2d80310a,0xd83800ca,0x6d56310b}},	//   касы, ggie_, _lič_, gbya, 
   {{0x395f00d3,0xfc3f0023,0x7bc50149,0x442c02b0}},	// [2390] _reus_, _quí_, tjhu, omd_, 
   {{0x395f310c,0xd838310d,0x75220548,0x7e7c01f1}},	//   _seus_, _nič_, _mzoz, burp, 
   {{0xe1ff310e,0x395f022c,0x7dd11bde,0x442c02b0}},	//   onó_, _peus_, _båst, imd_, 
   {{0x2011310f,0x66023110,0x9f5800e9,0x7522045a}},	//   lozi_, _njok, boró_, _ozoz, 
   {{0x7b670df8,0x386900eb,0x395f03a1,0x6e2d3111}},	//   _отве, éar_, _veus_, mmab, 
   {{0x48e00086,0x660200c8,0x20113112,0x6e2d3113}},	//   বপূর, _ajok, nozi_, lmab, 
   {{0x77630496,0x395f3114,0x260b05d0,0xe736183d}},	//   ranx, _teus_, ावली_, неш_, 
   {{0x442c0d2d,0xd5b1073c,0xdcef0785,0x201128ac}},	//   emd_, افظ_, _hacı, hozi_, 
   {{0x20112538,0xd8380082,0x6012055f,0x31603115}},	//   kozi_, _fič_, kæmp, _reiz_, 
   {{0x69d9000b,0x28be2f06,0xe1900108,0x72c53116}},	//   lkwe, ्हरि, _cẳng_, ебоз, 
   {{0xd24e0399,0x7dd81ff5,0xb81b0035,0x20113117}},	//   ینی_, _sísm, _पीएम_, dozi_, 
   {{0x7dd8026e,0x6602024a,0x442c1a77,0x7641107c}},	//   _písm, _gjok, amd_, _iuly, 
   {{0x7641140d,0xa3d5170f,0x644f0183,0x20113118}},	//   _huly, _подч, ícid, fozi_, 
   {{0x20113119,0x661b227a,0x4033012d,0x764101a3}},	//   gozi_, lluk, леўс, _kuly, 
   {{0x442702f2,0xdee61b49,0xdb150032,0x236500ca}},	//   _ihn_, хови, _pozý, malj_, 
   {{0x7641311a,0xd24e00eb,0x6da3311b,0x6e2d0495}},	//   _muly, _اني_, лиса, gmab, 
   {{0x2011099d,0xfce3311c,0x91fd00e0,0x921700c7}},	// [23a0] bozi_, гото, ksāj, _אַזױ_, 
   {{0x661b311d,0xfc3f00eb,0x26e50086,0xdb07023e}},	//   hluk, _arís_, _কখনো_, _kajè, 
   {{0x7dd10a40,0x442702a2,0xdb1c0187,0xd83800ca}},	//   _påst, _mhn_, _horú, _rič_, 
   {{0xceb302a1,0x661b032f,0x69d90daa,0xf866063f}},	//   _עיר_, jluk, gkwe, евдо, 
   {{0x661b311e,0xdb07023e,0x6d3b00d1,0x442c311f}},	//   dluk, _lajè, _מתכנ, ymd_, 
   {{0x44273120,0x66023121,0x76413122,0x998d0032}},	//   _nhn_, _sjok, _buly, _vieš_, 
   {{0xfc033123,0x69963124,0x3b0718ae,0xdb153125}},	//   _спро, _прах, _зеро_, _dozó, 
   {{0x661b3126,0x69d93127,0x7bce00b0,0x76410090}},	//   gluk, ckwe, _hobu, _duly, 
   {{0x09e33128,0xb4da0262,0x7bce3129,0xa492009c}},	//   _сотн, ठने_, _kobu, ایتت, 
   {{0x7bce00d9,0x236500ca,0x224e00b4,0xa3d4022c}},	//   _jobu, galj_, _ptfk_, тооч, 
   {{0x7641312a,0x442c012e,0x7bce312b,0x45e400e7}},	//   _guly, rmd_, _mobu, _đượ, 
   {{0x7982312c,0xf1a72651,0x2011312d,0xd26400f0}},	//   ngow, хрон, wozi_, нкүй, 
   {{0x2011312e,0x236507c7,0xe3b200d4,0x9f580036}},	//   tozi_, balj_, _مرغ_, vorò_, 
   {{0x644f2131,0x7bce312f,0xa3d7009a,0x44273130}},	//   ície, _nobu, _सवय_, _ghn_, 
   {{0x20113131,0x6e943132,0xe28f0038,0x79820415}},	//   rozi_, лиру, _هذي_, kgow, 
   {{0x63aa3133,0x8d8400d3,0x20113134,0x3f85007b}},	//   _hafn, лууд, sozi_, żlu_, 
   {{0x7dd83135,0x7bce3136,0x2011095a,0x5f110299}},	// [23b0] _získ, _bobu, pozi_, _दुर्_, 
   {{0x63aa010d,0x64423137,0x7bce3138,0x661b04a8}},	//   _jafn, _muoi, _cobu, zluk, 
   {{0xa03600a7,0x29d7027e,0xbb840038,0x63aa0054}},	//   _שאתה_, _uçak_, المي, _mafn, 
   {{0x65623139,0x9f58008c,0x8aa400f0,0xdb0e019c}},	//   _neoh, lorð_, ыруд, _robô, 
   {{0x7641313a,0x69d9313b,0x661b015e,0x9914004f}},	//   _suly, rkwe, vluk, льші, 
   {{0x62980318,0x69d9313c,0x63aa008c,0x3f83003e}},	//   _opvo, skwe, _nafn, ngju_, 
   {{0x2365032f,0x69d901d2,0x00000000,0x00000000}},	//   valj_, pkwe, --, --, 
   {{0xceb40137,0x7bce313d,0x661b313e,0xf993313f}},	//   ריק_, _zobu, uluk, _حبس_, 
   {{0x661b1630,0x23652f70,0xf8bf014b,0xb6a30200}},	//   rluk, talj_, _šéf_, тиқл, 
   {{0x9aa40019,0x764101a3,0x7dd83140,0xd7670019}},	//   _جمہو, _tuly, _písk, _سائٹ, 
   {{0x386d3141,0xb17b03a9,0xd6db3142,0x91e601a2}},	//   _hver_, rhån, _эта_, воне, 
   {{0x999800e0,0xa06a1eb4,0x2365015e,0xdb1c3143}},	//   _kurš_, мама_, salj_, _corù, 
   {{0x44270666,0x2365015e,0xd1320038,0xb17b02ae}},	//   _thn_, palj_, شمس_, mhål, 
   {{0xb4bf02f8,0x29f80f4c,0xb4cd00a2,0x3f8301d5}},	//   ीही_, nčar_, रही_, ggju_, 
   {{0x248d3144,0x91a000e7,0x6fd901be,0x924901ff}},	//   ltem_, _thì_, _mìch, _ўзиб_, 
   {{0x386d0056,0x7bce2926,0xb17b02ae,0xbcfb0212}},	//   _over_, _sobu, nhål, _adéq, 
   {{0x248d3145,0x9f58003e,0xe7f2093a,0x5baa0d3b}},	// [23c0] ntem_, borð_, _अगला_, мкам_, 
   {{0x7dd83146,0xeafa3147,0x248d3148,0x7bce3149}},	//   _mísi, ورات_, item_, _qobu, 
   {{0x386d0141,0xdb1c00a1,0xb4cd007e,0xed5a314a}},	//   _aver_, _yorù, रहु_, _оон_, 
   {{0xe9da00dd,0x7bce0f32,0x248d314b,0xe8fa314c}},	//   ьке_, _wobu, ktem_, мле_, 
   {{0xe894314d,0x7bce314e,0xa967314f,0x6b8700a1}},	//   уаль, _tobu, тича_, _fcjg, 
   {{0x248d3150,0x65623151,0xbcfb0175,0x25ad2f21}},	//   dtem_, _seoh, _keén, edel_, 
   {{0x386d00a7,0x973c0ab4,0xc8240259,0xc6a61284}},	//   _ever_, _jaći, _ұзақ, трли, 
   {{0x63aa008c,0xa01b010e,0xb4cd0c46,0xab273152}},	//   _safn, ltöt, रहू_, _роса_, 
   {{0x98a30161,0x7c3c078a,0xdb070096,0x18a303a1}},	//   _ките, _kirr, _rajé, _катм, 
   {{0x32020039,0x7c3c0405,0x660d3153,0x25ad3154}},	//   enky_, _jirr, čaka, adel_, 
   {{0x51f907f4,0x7c3c3155,0x386d09df,0x65620175}},	//   енню_, _mirr, _zver_, _teoh, 
   {{0xcb13042c,0x973c0613,0x91a00108,0x64420108}},	//   ילת_, _naći, _phí_, _tuoi, 
   {{0x6abf00a2,0x248d00f6,0x63aa0054,0x7c3c01c5}},	//   _एप्र, ctem_, _tafn, _oirr, 
   {{0xdb1c01e8,0x7c3c3156,0x200500c2,0x9f58009e}},	//   _forø, _nirr, õli_, lirê_, 
   {{0x973c0372,0xb5fc01f2,0x9f58003e,0x443c2af2}},	//   _baći, _ewġe, rorð_, _iiv_, 
   {{0x32530141,0x7c3c00a1,0x443c3157,0x61e60502}},	//   _твър, _airr, _hiv_, chkl, 
   {{0x443c3158,0x7c3c3159,0xbddb0107,0xdb050038}},	// [23d0] _kiv_, _birr, _lièg, rdhí, 
   {{0x3b54315a,0x7c840170,0xe7bd0086,0xac940240}},	//   икур, јуте, _অত্য, рафш, 
   {{0x443c315b,0x2003265d,0x9f58009e,0x248d0019}},	//   _miv_, mnji_, kirê_, ztem_, 
   {{0xe7e511bd,0x443c315c,0x973c01b4,0x00000000}},	//   कसभा_, _liv_, _gaći, --, 
   {{0x851e0790,0x7c3c05c2,0x67d5315d,0xe7360176}},	//   _परगट_, _firr, лоду, қеъ_, 
   {{0x443c315e,0x0e050176,0x7784017b,0xe7291271}},	//   _niv_, _рӯҳо, иліз, нолд_, 
   {{0x6e3d315f,0xb17b02ae,0x9f58009e,0x59670240}},	//   _kisb, thål, firê_, _аъза, 
   {{0x248d006b,0x26c90062,0x069600eb,0x443c006d}},	//   ttem_, ćao_, انية_, _aiv_, 
   {{0x6e3d3160,0xb17b022b,0x25ad2379,0xb4bf00aa}},	//   _misb, rhål, rdel_, ीहे_, 
   {{0x7dd8010d,0x2003090b,0x248d3161,0xb17b014e}},	//   _vísi, jnji_, rtem_, shål, 
   {{0x7d1d022b,0x17f800eb,0x998600ca,0xd7f828c9}},	//   _lyss, _شركة_, lmoš_, _рут_, 
   {{0x64b50fdc,0x6e3d3162,0xdee60258,0x5ed70033}},	//   _محتر, _nisb, қоби, _ডেভে, 
   {{0x443c3163,0x20041890,0x7d1d08b0,0x00000000}},	//   _fiv_, émio_, _nyss, --, 
   {{0x443c01cc,0x75fe00e0,0xa2ab08dd,0x9f58021e}},	//   _giv_, vīzi, _जनप्, mirë_, 
   {{0xdee31f66,0x6e3d3164,0xe81b00a5,0xf3f000eb}},	//   бори, _bisb, _पीछा_, _بأن_, 
   {{0x443c090b,0x52740623,0x7c3c3165,0x6d4f00b4}},	//   _ziv_, _тушу, _sirr, _cfca, 
   {{0x7c3c3166,0xa3d7185c,0x443c006d,0x61e43167}},	// [23e0] _pirr, _सवा_, _yiv_, _ilil, 
   {{0xfc3f00eb,0x61e407d7,0x20030ab4,0x3d040790}},	//   _tsín_, _hlil, cnji_, _रखीं_, 
   {{0x61e4011c,0x7c3c3168,0x9f58021e,0xdce40028}},	//   _klil, _virr, hirë_, maič, 
   {{0x7cda01dd,0xaa5707cf,0x5f460116,0x63a13169}},	//   _pārā, النا_, _جنگل, heln, 
   {{0xb4cd0081,0xd917013d,0x7c3c003d,0x2449316a}},	//   रहो_, льш_, _tirr, _núm_, 
   {{0x6281316b,0x63a1090b,0x61e40026,0xbddb0107}},	//   kulo, jeln, _llil, _pièg, 
   {{0x63a1316c,0xab27316d,0x1ae600c8,0x9f580216}},	//   deln, _бора_, _совм, tirê_, 
   {{0x443c0e0c,0x6e3d02be,0x20031993,0xa01b014e}},	//   _siv_, _xisb, znji_, ntör, 
   {{0x69c0316e,0x443c01a0,0x80a40f63,0x0906143a}},	//   _inme, _piv_, _चैले, _спан, 
   {{0x644f068b,0x61e4316f,0x443c006f,0x27f83170}},	//   ícia, _alil, _qiv_, _örn_, 
   {{0x443c3171,0xa01b3172,0x7bde00e2,0x20030372}},	//   _viv_, ktör, ikpu, vnji_, 
   {{0x15463173,0xa01b0088,0xe13500c8,0x61e400a1}},	//   _седм, ytös, инны, _clil, 
   {{0x2003003a,0x443c01a0,0x6e3d3174,0xc10800b3}},	//   tnji_, _tiv_, _risb, гэре_, 
   {{0x62813175,0x53341617,0x63a1090b,0x7d1d3176}},	//   bulo, _келт, celn, _ryss, 
   {{0x62813177,0x9f3500dd,0x539b00a7,0x7d1d0eca}},	//   culo, реві, _ניהו, _syss, 
   {{0x5d5518b6,0x200304d1,0x7d1d161f,0x7bde12b6}},	//   ркат, snji_, _pyss, ekpu, 
   {{0x6e3d3178,0x8f5500d4,0x20033179,0xad9b003e}},	// [23f0] _visb, _پنجش, pnji_, _hjúk, 
   {{0x69c0317a,0x0a6b0161,0x6d4d02b0,0xefc802f1}},	//   _anme, ерди_, scaa, _буюк_, 
   {{0xac9400cf,0x973c160e,0xa01b00c8,0xdd9503a1}},	//   _қарш, _kaću, stös, _каны, 
   {{0x5fc30b26,0x63a1317b,0xdb07003e,0x7d1d0eba}},	//   शावल, zeln, _snjó, _tyss, 
   {{0x79c90a5a,0x4773004e,0x6281317c,0x973c0304}},	//   _یوسف_, йқау, zulo, _maću, 
   {{0x69c0317d,0x244901d5,0x2d84027e,0x9f4a009e}},	//   _enme, _rúm_, _ömer_, dibû_, 
   {{0x0f5800d1,0xbddb0151,0x4af900fd,0x63a1317e}},	//   ניהם_, _tièd, _ревю_, veln, 
   {{0x660d02ee,0x9f58024a,0x78a90201,0x9f410228}},	//   čako, tirë_, _tsev, _dlhé_, 
   {{0x63a1317f,0xa78711b7,0x78a90df4,0xdb0e0216}},	//   teln, _مشاو, _usev, _nabê, 
   {{0x62813180,0x661926d9,0x9f58021e,0x23d500d9}},	//   tulo, _wkwk, rirë_, рцир, 
   {{0xc7c402f1,0x02063181,0x21290065,0xa2063182}},	//   _усти, изон, _azah_, ипод, 
   {{0x63a13183,0xd9f707d5,0x3a2d0065,0xdb0700bc}},	//   seln, ूचित_, _jhep_, _nají, 
   {{0x7dd8000d,0x63a13184,0x62813185,0x3d0400ab}},	//   _míst, peln, sulo, _रखें_, 
   {{0x7dd8026e,0x0eb300b0,0x2d991ca0,0x9f4a0126}},	//   _líst, ुमंड, _abse_, libú_, 
   {{0x316b006a,0x21763186,0xdb070126,0xfe7916d0}},	//   bacz_, _купр, _bají, лёты_, 
   {{0x260b0827,0x290d0183,0x61e43187,0x3a3f0574}},	//   ावटी_, _oxea_, _ulil, _niup_, 
  
   {{0xf1bf200a,0xa01b197a,0x9f5801e5,0x6b663188}},	// [2400] rmát_, rtör, hiré_, икаа, 
   {{0x6b56058e,0x973c0ab4,0xfbdf0ff2,0x3a2d0096}},	//   ртах, _zaću, _stêr_, _ahep_, 
   {{0xa01b3189,0x0f7b027a,0x00000000,0x00000000}},	//   ptör, _בריל, --, --, 
   {{0x2018318a,0x2d96318b,0x2367318c,0x9f58318d}},	//   lori_, _трос, _lenj_, diré_, 
   {{0xc7c61329,0x3a2d011c,0x9f51318e,0x69c00023}},	//   иски, _dhep_, lizá_, _vnme, 
   {{0xdb07000d,0x2018318f,0x224000c2,0x7dd801d5}},	//   _zají, nori_, _liik_, _vísu, 
   {{0xb76500dd,0xa5f83182,0x46673190,0x9f583191}},	//   стій, леку_, арым_, giré_, 
   {{0xd5b73192,0x9f4a010c,0x20183193,0xba57008d}},	//   ась_, tibû_, hori_, _כסלו_, 
   {{0xad9b008c,0x22470126,0xa4f800d4,0x20183194}},	//   _sjúk, _aunk_, دکار_, kori_, 
   {{0x9f4a0218,0x9f580369,0xf1bf010e,0xdd010372}},	//   ribû_, biré_, ymás_, šuće, 
   {{0x20183195,0x91fd00e0,0xa6ca00eb,0x0bb700a7}},	//   dori_, ksāt, _جوال_, בלים_, 
   {{0x05833196,0xd49a3197,0x7dd82aa3,0xdb1c0d34}},	//   _душм, _арк_, _míss, _horó, 
   {{0x76483198,0x24540189,0x291f006d,0x20183199}},	//   _hudy, _انتس, _xyua_, fori_, 
   {{0xb7f80239,0x76480204,0x7a2300b0,0x53a30176}},	//   ्चिम_, _kudy, võtm, _мачб, 
   {{0x623504a0,0xdb1c240a,0x5f1a0d2e,0xe817258c}},	//   _леку, _moró, _मुद्_, दकता_, 
   {{0x76480532,0x5d780080,0x2367319a,0xfe7902d9}},	//   _mudy, ийся_, _zenj_, čů_, 
   {{0x2018044e,0x409500eb,0x6b75004e,0xdb07014b}},	// [2410] bori_, _الخر, йлау, _vají, 
   {{0x3a3f016a,0xdb0e00d4,0x201806f0,0x321908f7}},	//   _siup_, _kabè, cori_, losy_, 
   {{0x2484012b,0x3a2d0023,0x2bc9319b,0xdb0e0237}},	//   humm_, _phep_, राबा, _jabè, 
   {{0x29d706a2,0x3219319c,0x00000000,0x00000000}},	//   _açar_, nosy_, --, --, 
   {{0x7dd820ac,0xa8a7319d,0xdb0e0542,0x76480083}},	//   _víst, ррек, _labè, _audy, 
   {{0xf7710523,0xab8408c5,0x764800ab,0x61fd319e}},	//   سات_, _муск, _budy, hisl, 
   {{0x9f58078a,0x61fd319f,0x2ca900f8,0x3219023a}},	//   kirî_, kisl, lwad_, kosy_, 
   {{0x61fd31a0,0x644f31a1,0x23670f4c,0x2d8931a2}},	//   jisl, ício, _senj_, ngae_, 
   {{0x442e02fe,0x201831a3,0x799b137f,0x2240007e}},	//   _bhf_, yori_, _ibuw, _riik_, 
   {{0x53c931a4,0xdb0e0118,0x60dd31a5,0xe2851918}},	//   угом_, _babè, dysm, блои, 
   {{0x216a31a6,0x7a23007e,0x321931a7,0x7bd531a8}},	//   лини_, võtj, fosy_, _mozu, 
   {{0x9f580218,0x442e008c,0x78bb31a9,0x3219023a}},	//   girî_, _ehf_, _kruv, gosy_, 
   {{0x63c200bc,0x799b31aa,0x442e31ab,0x672131ac}},	//   ávní, _mbuw, _fhf_, _hylj, 
   {{0xd91a00a7,0xb4e3190a,0x7648085b,0xe8df00e7}},	//   רושל, ननी_, _yudy, _ngọn_, 
   {{0x799b31ad,0x201831ae,0xdee327e2,0xc255195e}},	//   _obuw, rori_, пори, _اختت, 
   {{0xfbdf001b,0xa2c400bd,0x2291010e,0xdb1c0502}},	//   _quên_, िमर्, mák_, _vorü, 
   {{0xbddb026a,0x7bd501f0,0xeb9a31af,0x2ca9012b}},	// [2420] _sièc, _bozu, лиа_, gwad_, 
   {{0xbddb0518,0x9f861991,0xdb0e31b0,0x201802f1}},	//   _pièc, _угод, _habé, qori_, 
   {{0xfe722424,0x1c3900af,0xdb0e1d32,0x6c330038}},	//   _عدد_, рять_, _kabé, أفلا, 
   {{0xed3600b3,0x3eb80864,0x28ea0f82,0xed5a0093}},	//   _гэгэ, mvrt_, лдеп_, _щом_, 
   {{0xdb1c31b1,0xd7fa0161,0x25f607d5,0x6d46012b}},	//   _poró, лук_, एफसी_, _igka, 
   {{0x6e2413fa,0xa09b00fe,0x2291010e,0x2bc931b2}},	//   llib, ריסט, kák_, राणा, 
   {{0x229131b3,0x3eb8008b,0x1be70bae,0x78bb31b4}},	//   ják_, nvrt_, _удри_, _eruv, 
   {{0x545431b5,0x61fd0496,0xfbc90527,0x6e240c36}},	//   овит, xisl, राथम, nlib, 
   {{0x61fd0076,0x7bd531b6,0x6d46011d,0x78bb31b7}},	//   visl, _yozu, _mgka, _gruv, 
   {{0xb27431b8,0xd4970b58,0x76480102,0x13f4004f}},	//   олош, ёры_, _tudy, ізня, 
   {{0x61fd0039,0x9f58010c,0x764807fc,0x175707e4}},	//   tisl, tirî_, _uudy, _הסבר_, 
   {{0xd46a00ce,0x6446003e,0xdb0e0175,0x6d462720}},	//   _биде_, íkis, _cabé, _ngka, 
   {{0x321931b9,0xdb05010c,0xdce6008a,0xdb072c26}},	//   rosy_, gehê, _dekċ, _majá, 
   {{0x321905f0,0x229131ba,0x61fd31bb,0x6d4631bc}},	//   sosy_, bák_, sisl, _agka, 
   {{0x7bd531bd,0x8c000033,0x8234009c,0xdd9b31be}},	//   _rozu, ্তান_, تریا, лша_, 
   {{0x6e2431bf,0xbcfb0019,0x4cd10033,0x7bd531c0}},	//   glib, _idéz, _সেগু, _sozu, 
   {{0x7bd50095,0xe1ff31c1,0x76420548,0x7bf9286f}},	// [2430] _pozu, mió_, _mioy, анар_, 
   {{0xe1ff31c2,0xdb1c26ca,0x6e2401a3,0x6b750259}},	//   lió_, _enrí, alib, ілеу, 
   {{0xe7c700ab,0x7bd502fe,0x752201ff,0x00000000}},	//   लासप, _vozu, _lyoz, --, 
   {{0xe1ff0161,0x78bb31c3,0x3ebe055f,0xddab0890}},	//   nió_, _pruv, ætte_, _стол_, 
   {{0x3ea1016a,0x2bc90035,0x7c8400b3,0x672131c4}},	//   _hpht_, रादा, _нуре, _sylj, 
   {{0x2291010e,0xe7870cb4,0x8bcb00b3,0x67d20bad}},	//   yák_, судо, _сымб_, дољу, 
   {{0xdddc0ab4,0x752231c5,0x998531c6,0x7642040c}},	//   lurš, _ayoz, _ولسو, _bioy, 
   {{0x229131c7,0x91a90023,0xdb0e0216,0xe1ff0126}},	//   vák_, _nhà_, _kabî, jió_, 
   {{0xe1ff31c8,0xb4e300ab,0x13e931c9,0xa5090093}},	//   dió_, नने_, имий_, репа_, 
   {{0x2291309e,0xdb0e31ca,0x2251014b,0xe291007a}},	//   ták_, _sabé, ízko_, وذج_, 
   {{0xd5ae00c5,0x232903dc,0x645b31cb,0xe29931cc}},	//   رفی_, рони_, spui, шан_, 
   {{0xe1ff31cd,0xbba6047c,0x22910776,0x36340038}},	//   gió_, _ऑस्क, rák_, _فرنس, 
   {{0xdb0e010c,0x2291309e,0x6e24009e,0x601b020f}},	//   _nabî, sák_, vlib, tîmp, 
   {{0xa2e51c20,0x3eb80571,0x64590610,0x661b31ce}},	//   _молд, tvrt_, _itwi, louk, 
   {{0xe1ff0086,0xdb1c010d,0x7f4331cf,0x660921a3}},	//   bió_, _norð, держ, onek, 
   {{0xe1ff31d0,0x660931d1,0x644b099d,0x644331d2}},	//   ció_, nnek, _kugi, _hini, 
   {{0x6e24005c,0x656b006b,0x644b0082,0x442531d3}},	// [2440] rlib, _megh, _jugi, oll_, 
   {{0x9f580084,0xdb07006b,0x644b31d4,0x644331d5}},	//   oirí_, _sajá, _mugi, _jini, 
   {{0x442531d6,0x9d4631d7,0x661b31d8,0x644b31d9}},	//   ill_, _менд, kouk, _lugi, 
   {{0xa9260d61,0x66090082,0x661b00c8,0x2bdc031e}},	//   одел, jnek, jouk, _मकवा, 
   {{0xa7aa02f1,0x764200a3,0xdce60604,0x7dd802be}},	//   икда_, _rioy, _kekč, _uísq, 
   {{0x660901f1,0x644331da,0xdb1c003e,0xe1ff010e}},	//   enek, _nini, _forð, zió_, 
   {{0x644b012d,0x98a30009,0x656b02a3,0x64590610}},	//   _augi, _ąją_, _begh, _atwi, 
   {{0xd49a03ea,0x644b31db,0x442531dc,0xe1ff03a1}},	//   аро_, _bugi, ell_, xió_, 
   {{0x644331dd,0xe1ff05b9,0x644b31de,0x656b31df}},	//   _bini, vió_, _cugi, _degh, 
   {{0x644331e0,0xa2f400dd,0x539700c8,0x88bd0083}},	//   _cini, зпоч, овья_, _wyśc, 
   {{0xe1ff08f4,0x661b31e1,0xe3b801f0,0x644331e2}},	//   tió_, bouk, llık_, _dini, 
   {{0x644b31e3,0x64430f08,0x81e30033,0xd5a6009c}},	//   _fugi, _eini, ফোন_, _گلچی, 
   {{0xe1ff08f4,0xe3b801f0,0x644319a9,0x628131e4}},	//   rió_, nlık_, _fini, arlo, 
   {{0xe1ff0161,0x644331e5,0xd25000eb,0xbddb00d3}},	//   sió_, _gini, _كنت_, _cièn, 
   {{0x3a2631e6,0xbddb01e5,0x2ee5003e,0xe1ff318d}},	//   klop_, _dièn, álf_, pió_, 
   {{0x63a831e7,0x644302f1,0x628831e8,0xe3b8027e}},	//   ledn, _zini, mudo, klık_, 
   {{0x62880086,0x7dd800e9,0x25d7027a,0x644301ff}},	// [2450] ludo, _vísp, קומן_, _yini, 
   {{0xa2be05d0,0x9f3508af,0x60c002c9,0x9b270080}},	//   षिप्, _непі, æmme, офел, 
   {{0x62881c2b,0x660931e9,0x2bdc0299,0x67ef0566}},	//   nudo, ynek, _मकरा, _højg, 
   {{0xda7803bd,0x660002d9,0xdb1c0679,0x2bc902d9}},	//   іях_, jimk, _vorð, राहा, 
   {{0x442531ea,0x998d0187,0xad9b010e,0x656b31eb}},	//   yll_, _tiež_, _amúg, _regh, 
   {{0x63a80d26,0x644b31ec,0x656b02a3,0x660901f2}},	//   jedn, _rugi, _segh, wnek, 
   {{0x644b31ed,0xfbd20056,0x644331ee,0x661b31ef}},	//   _sugi, _אתם_, _rini, touk, 
   {{0x2bc9190a,0x644b31f0,0xc6210033,0xb95500fd}},	//   रावा, _pugi, _পূজা_, _хващ, 
   {{0x644331f1,0x656b31f2,0xdb0702be,0x5a440a10}},	//   _pini, _vegh, _enjô, _цэра, 
   {{0x64430104,0x656b31f3,0x682d0032,0x660931f4}},	//   _qini, _wegh, búda, snek, 
   {{0x442531f5,0x39400242,0x04c900d7,0xdce60118}},	//   rll_, žist_, _گوشي_, _rekč, 
   {{0x644b31f6,0x7a31076d,0x644331f7,0xdce600da}},	//   _tugi, båte, _wini, _sekč, 
   {{0x644331f8,0x63a80267,0x7bc701c8,0x64591736}},	//   _tini, bedn, _onju, _utwi, 
   {{0x62881175,0xdfd21036,0x682400b9,0x00000000}},	//   budo, ريز_, tòdi, --, 
   {{0xf1bf0084,0x628821dc,0xe7f30077,0xe3b8027e}},	//   mlán_, cudo, _अतना_, zlık_, 
   {{0x7bc731f9,0x409631fa,0x67ef055f,0x6d4b008b}},	//   _anju, _ерот, _højd, žgan, 
   {{0xdca31c7c,0x3202014b,0x00000000,0x00000000}},	// [2460] нати, miky_, --, --, 
   {{0xa09700fe,0x6600138a,0xdb1c02ae,0x320231fb}},	//   _צדיק_, zimk, _morö, liky_, 
   {{0x3ce6143b,0xf1bf0068,0x4a461aaa,0x34a8176d}},	//   šov_, ilán_, чнев, _कन्द, 
   {{0x8c4631fc,0x320231fd,0x63a800ab,0x628f00ab}},	//   _неме, niky_, zedn, ńcow, 
   {{0xd7c70bf0,0xe8940278,0x2bc9058c,0x39401279}},	//   लांच, фаль, राशा, äis_, 
   {{0xdb0e128a,0xe3b801f0,0x9f5831fe,0x7bc70372}},	//   _habí, rlık_, nirà_, _gnju, 
   {{0xcfb60086,0xfbc909e5,0x3a2631ff,0xa01b12b7}},	//   ঞাপন, रारम, plop_, krön, 
   {{0xf64f00d4,0xceb300d1,0x682d007a,0x9f580379}},	//   دئو_, תיה_, rúda, hirà_, 
   {{0x66003200,0x320213c5,0x00000000,0x00000000}},	//   rimk, diky_, --, --, 
   {{0x62883201,0xb05b0219,0x66003202,0x32543203}},	//   tudo, lväg, simk, мвор, 
   {{0x63a83204,0xa75b00a7,0x3202301f,0x9f583205}},	//   redn, _הדבר, fiky_, dirà_, 
   {{0xdb0e0351,0x6288055f,0xddcb00ef,0x63a821bc}},	//   _nabí, rudo, _žiža, sedn, 
   {{0x68e202f1,0x2fda03c2,0x2465010c,0xbddb011c}},	//   nyod, _bopg_, rêmî_, _dièl, 
   {{0xf1bf3206,0xa01b010e,0x2d9c010e,0x3202023a}},	//   clán_, ltöz, ővel_, aiky_, 
   {{0xa3b504bd,0x245200e7,0x32020032,0xe3b806a2}},	//   _चोट_, _hâm_, biky_, mdı_, 
   {{0xe3b80749,0xdb0e0684,0x3ebe3207,0x61e63208}},	//   ldı_, _cabí, ætta_, ckkl, 
   {{0x61ed3209,0x67ef01cc,0x9f58320a,0x2bc9320b}},	// [2470] _ilal, _høje, birà_, राला, 
   {{0xe3b80749,0x68e2320c,0x61ed0364,0x9f5801d8}},	//   ndı_, dyod, _hlal, cirà_, 
   {{0x2452001b,0xbd0202b0,0xdb0e02be,0x00000000}},	//   _lâm_, _éénm, _fabí, --, 
   {{0x9f58118d,0xa954004f,0x00000000,0x00000000}},	//   mirá_, екці, --, --, 
   {{0x61ed2fc5,0x9f580369,0xbc770032,0x00000000}},	//   _mlal, lirá_, ýšľa, --, 
   {{0xb8d50509,0x7bc7320d,0x61ed320e,0xdb0e1102}},	//   _जन_, _unju, _llal, _zabí, 
   {{0xdce600e0,0x9f582d3b,0xe69200d4,0xb8d400b0}},	//   _iekā, nirá_, نلود, _छै_, 
   {{0x200311e9,0xb9c500eb,0xe459320f,0x61ed023e}},	//   hiji_, _تقري, ожи_, _nlal, 
   {{0xf1bf0bf1,0xdcfd05b7,0x69c93210,0x24520108}},	//   tlán_, _kası, _inee, _câm_, 
   {{0x61ed3211,0x20033212,0x69c90201,0x2452001b}},	//   _alal, jiji_, _hnee, _dâm_, 
   {{0x3202026e,0x61ed3213,0x69db0326,0xf1bf0679}},	//   tiky_, _blal, _koue, rlán_, 
   {{0x471a07f5,0x69db0518,0x9f583214,0xd6d80088}},	//   _וועג, _joue, dirá_, _эту_, 
   {{0x2509182b,0x32023215,0x69db3216,0x2bb20249}},	//   _برای_, riky_, _moue, ीयमा, 
   {{0xdcfd0c05,0xdb0e0b6f,0x69db3217,0xdce600e0}},	//   _nası, _sabí, _loue, _nekā, 
   {{0x9f583218,0x69c93219,0x5043321a,0x3202023a}},	//   rirà_, _onee, терб, piky_, 
   {{0x61ed011c,0x69db321b,0x69c90547,0x2003018e}},	//   _glal, _noue, _nnee, aiji_, 
   {{0x20031462,0xdcfd03c0,0x205602f1,0x245200e7}},	// [2480] biji_, _bası, _ўтир, _xâm_, 
   {{0x9f580503,0x69c9321c,0xe50e00c6,0x68e20548}},	//   birá_, _anee, ापति_, vyod, 
   {{0x9f580634,0x69db321d,0xfc3f033c,0x00000000}},	//   cirá_, _boue, _asís_, --, 
   {{0xa9670b46,0x79a32189,0x27ec0065,0xe3b80540}},	//   дица_, врше, _sldn_, zdı_, 
   {{0xd6cf00d4,0x7a23007e,0xe3b803c0,0xb05b014e}},	//   یقه_, võtt, ydı_, rväg, 
   {{0x6a8600cf,0xb05b014e,0x68e2321e,0x236500ef}},	//   _олга, sväg, ryod, jblj_, 
   {{0x2452321f,0x7a2300b0,0x69db0212,0x7bdc007a}},	//   _sâm_, tõtt, _foue, _ioru, 
   {{0xc88301f0,0x69db3220,0x00000000,0x00000000}},	//   üğü_, _goue, --, --, 
   {{0x7bdc3221,0xdb1c0379,0xe3b800ad,0x9f58019c}},	//   _koru, _eorô, tdı_, zirá_, 
   {{0x61ed0df4,0x88bd00ab,0x32000054,0x7bdc00fc}},	//   _slal, _myśl, _amiy_, _joru, 
   {{0x2003090b,0xe3b80749,0x7bdc0364,0x61ed3222}},	//   viji_, rdı_, _moru, _plal, 
   {{0x245200f7,0x9f580169,0xd25700e4,0xdb1c02ae}},	//   _tâm_, virá_, ьць_, _inrä, 
   {{0x60f8058b,0xdb0e0118,0x7bdc040b,0xd5cf0210}},	//   дняя_, _labà, _ooru, _kềnh_, 
   {{0x9f580a47,0x67ef02c9,0x14d7027a,0x00000000}},	//   tirá_, _tøje, _קוגל_, --, 
   {{0x61ed0364,0xe7e6007e,0xdb1505d5,0xd5cf0108}},	//   _tlal, _कवना_, _gazè, _mềnh_, 
   {{0x2003034c,0x9f583214,0x63b808bb,0x61ed0532}},	//   siji_, rirá_, _havn, _ulal, 
   {{0x69db026a,0x22983223,0x629a0fac,0xad9b003e}},	// [2490] _roue, lék_, ltto, _djúp, 
   {{0x7bdc3224,0xfe71006b,0x69c93225,0x21293226}},	//   _coru, _مگر_, _snee, _iyah_, 
   {{0x7bdc01e2,0x69db3227,0xdb0e0e43,0x2298010e}},	//   _doru, _poue, _cabà, nék_, 
   {{0x7bdc0118,0xdb0e0165,0x629a0080,0xa87500f0}},	//   _eoru, _sabã, itto, елді, 
   {{0x18691d52,0x07a50925,0xd5cf0108,0x2249018e}},	//   чали_, еалн, _bềnh_, _miak_, 
   {{0x63b83228,0x7bdc3229,0xdb0703a1,0x76b300ad}},	//   _navn, _goru, _majú, _həyə, 
   {{0x26c10351,0xd6d119c7,0xb6a5322a,0x229807c5}},	//   ího_, اقع_, хийл, jék_, 
   {{0x22980019,0x7bdc01f0,0x99980009,0x7a312104}},	//   dék_, _zoru, _durų_, båta, 
   {{0x7bdc0792,0x2129322b,0xdb070032,0x629a1761}},	//   _yoru, _nyah_, _najú, etto, 
   {{0xf6e71761,0x629a322c,0x2bd2009a,0x224900b4}},	//   _оцен, ftto, साया, _aiak_, 
   {{0x63b803ef,0x21292998,0xdb15026e,0xdb0e247e}},	//   _davn, _ayah_, _bazé, _kabá, 
   {{0x70cb322d,0xbddb023e,0x2249322e,0x386d0118}},	//   ामूल, _dièk, _ciak_, _kwer_, 
   {{0x629a0088,0x64a500e4,0x25ad322f,0xa43916d0}},	//   atto, _чала, meel_, _езду_, 
   {{0x22983230,0x21293231,0xdb0e02ae,0x63b802c9}},	//   bék_, _dyah_, _inbö, _gavn, 
   {{0x6da63232,0x5f1a0262,0x76b30095,0xada600c8}},	//   нива, _मुख्_, _bəyə, навл, 
   {{0x7bdc22df,0x25ad051e,0xc1ba00b1,0x22493233}},	//   _soru, neel_, _رابط_, _giak_, 
   {{0x7bdc3234,0x76b30095,0x1de1007e,0x248d3235}},	// [24a0] _poru, _dəyə, _नवरत, nuem_, 
   {{0x7bdc06d0,0xa09b0137,0x25ad0d2d,0x1f661afd}},	//   _qoru, _צייט, heel_, _яком, 
   {{0x386d011c,0x79a61b17,0x88bd00ab,0x7bdc008c}},	//   _awer_, ерле, _wyśl, _voru, 
   {{0x60c43236,0xd9100274,0x70770444,0x386d3237}},	//   _krim, لیز_, _تمیز_, _bwer_, 
   {{0x25ad0318,0x21290065,0x7bdc3238,0x2298010e}},	//   deel_, _xyah_, _toru, zék_, 
   {{0x22983239,0xdb0e0054,0xe7c700aa,0x60c42925}},	//   yék_, _tabà, लागप, _mrim, 
   {{0x63b806e0,0x629a01be,0x2cb20156,0xa96a323a}},	//   _ravn, xtto, lwyd_, _нива_, 
   {{0x63b8323b,0x60c4323c,0x2d92323d,0x04662713}},	//   _savn, _orim, ngye_, нтом, 
   {{0x248d26bd,0x22493107,0x2cb202bf,0x60c400d7}},	//   guem_, _riak_, nwyd_, _nrim, 
   {{0x2298006b,0xa87b0056,0xa01b323e,0xdb0e2f09}},	//   ték_, _מאמר, tröm, _zabá, 
   {{0x60c4323f,0x05663240,0x7dd80019,0x7c3e02a3}},	//   _arim, _звен, _dísz, impr, 
   {{0x22983241,0x60c43242,0x20010219,0x629a3243}},	//   rék_, _brim, _smhi_, rtto, 
   {{0x60c43244,0xd5af08cb,0x629a3245,0x66023246}},	//   _crim, _دفن_, stto, _imok, 
   {{0x2cb20156,0x22983247,0x7c3e039b,0x00000000}},	//   dwyd_, pék_, jmpr, --, 
   {{0x443e02ec,0x60c43248,0x6e261032,0x22490175}},	//   mmt_, _erim, _bkkb, _tiak_, 
   {{0x7c3e20ac,0x644a3249,0x442c324a,0x60c4042a}},	//   empr, _hifi, lld_, _frim, 
   {{0x644a324b,0x60c4238e,0x66020415,0x2cb20156}},	// [24b0] _kifi, _grim, _mmok, gwyd_, 
   {{0x62880036,0x644a00a4,0xdb150032,0xdb0e08b2}},	//   ordo, _jifi, _enzý, _sabá, 
   {{0x644a0180,0x442c003e,0x67ef02c9,0x19b9324c}},	//   _mifi, ild_, _nøja, дуль_, 
   {{0x443e0380,0x644a324d,0xf1bf00da,0x81e30033}},	//   hmt_, _lifi, dlák_, ফোর_, 
   {{0x25ad0e47,0x644a003c,0x7ae50080,0x67d51560}},	//   veel_, _oifi, syht, коду, 
   {{0x644a324e,0x660202b8,0x07a5324f,0x6e2d3250}},	//   _nifi, _amok, такн, llab, 
   {{0x79a700e4,0x25ad2425,0x6e2d3251,0x201102a3}},	//   _прае, teel_, olab, inzi_, 
   {{0x6e2d3252,0xa91d009d,0x2bc9031e,0x248d3253}},	//   nlab, _adže, राका, tuem_, 
   {{0x6e2d0056,0x8cc400ab,0x628804b3,0x644a3254}},	//   ilab, रियो, erdo, _bifi, 
   {{0x6e2d0149,0xd6db00d9,0xee0e0299,0xd7f808d1}},	//   hlab, _нте_, _िद्ध_, _пух_, 
   {{0xd24400cf,0x60c404c6,0x6e2d3255,0x6d5d3256}},	//   лмоқ, _srim, klab, _ofsa, 
   {{0xd70d0586,0x442c01c8,0x443e0e16,0x20113257}},	//   िपीठ_, ald_, amt_, enzi_, 
   {{0x248d3258,0xe3ae080b,0x644a00a9,0xdd920296}},	//   quem_, _кб_, _fifi, یوس_, 
   {{0x656903a9,0x7a383259,0x1304004e,0x6e2d325a}},	//   lbeh, míte, _өзім, elab, 
   {{0x91fd00e0,0x6e2d325b,0x442700e2,0x7a380189}},	//   mpān, flab, _ikn_, líte, 
   {{0x6e2d325c,0xa6e9001b,0x6569325d,0x60c41229}},	//   glab, _trươ, nbeh, _trim, 
   {{0x1d071a9e,0x7a38325e,0x4427019a,0x60c4325f}},	// [24c0] вети_, níte, _kkn_, _urim, 
   {{0x2bd20e17,0x6e2d3260,0x2cb20156,0x26c502a3}},	//   साधा, alab, rwyd_, _orlo_, 
   {{0xee3a3261,0x44273107,0xeb973262,0xef1700b3}},	//   _оно_, _mkn_, тих_, _амэ_, 
   {{0x58860b58,0x656901c8,0xa96a00a3,0xa3c83263}},	//   выка, jbeh, фида_, _लोन_, 
   {{0x443e1f7e,0xdce40112,0x442c3264,0x26c501f1}},	//   ymt_, obič, yld_, _arlo_, 
   {{0x65690228,0x66023265,0x62880844,0xc8650038}},	//   ebeh, _smok, yrdo, اطني, 
   {{0x6009044e,0x644a3266,0xa3d53267,0x764b3268}},	//   nžma, _rifi, हान_, _bigy, 
   {{0x44273269,0x644a326a,0x6adb0086,0x54b8326b}},	//   _akn_, _sifi, _যেকো, егия_, 
   {{0x41d6000c,0x4427085f,0x7a380019,0x644a0180}},	//   धानस, _bkn_, gíte, _pifi, 
   {{0x3866326c,0x442c0056,0x52d8017b,0xa8880259}},	//   mpor_, uld_, емою_, _ойға_, 
   {{0x443e0f96,0x764b006b,0x442c326d,0xd5af326e}},	//   rmt_, _figy, rld_, _кс_, 
   {{0x6e2d0183,0x6602326f,0x764b0090,0xe4a63270}},	//   xlab, _umok, _gigy, _арко, 
   {{0x442c0065,0xd3a500f0,0x644a3271,0x25a60175}},	//   pld_, _әріп, _tifi, _ibol_, 
   {{0x44270183,0x6e2d3272,0xf2c621f9,0x6e9500b9}},	//   _gkn_, wlab, _асин, лигу, 
   {{0x6e2d3273,0xd3780035,0xdbdc003e,0x38660175}},	//   tlab, mać_, _ráðl, hpor_, 
   {{0x518714fc,0x228302f1,0x6e2401f1,0xb28300d3}},	//   _рука, _тушг, goib, _тышк, 
   {{0x6e2d3274,0x5d5403a1,0x25a626e2,0x31793275}},	// [24d0] rlab, ркут, _mbol_, masz_, 
   {{0x31790105,0xd37800ab,0x6e2d3276,0xa3d50f8c}},	//   lasz_, nać_, slab, हाय_, 
   {{0xf09f3277,0x16223278,0x78a90228,0x6e243279}},	//   ltà_, मवार_, _spev, boib, 
   {{0xd378327a,0xdb1c010c,0xa01b003e,0x166508ba}},	//   hać_, _karê, fsög, қвим, 
   {{0xd37800ab,0xf09f327b,0xa7a9327c,0x9d14017b}},	//   kać_, ntà_, екла_, _вдяч, 
   {{0xe739245f,0xf09f2d58,0xd3780083,0x7a38327d}},	//   нел_, ità_, jać_, víte, 
   {{0xd378006a,0x9f5108f4,0x317923f8,0x6569243f}},	//   dać_, lizó_, kasz_, tbeh, 
   {{0x26c502f5,0xe3b80095,0xa2d6176d,0x00000000}},	//   _vrlo_, dlıq_, यमन्, --, 
   {{0x9f5104b3,0x75f5031e,0x3915327e,0x78a9014b}},	//   nizó_, _náze, _смар, _upev, 
   {{0x7a380b7e,0x7c25014b,0xd3780035,0x9f41020b}},	//   ríte, nohr, gać_, _dlhú_, 
   {{0x420a177b,0xf09f0141,0x7a38327f,0xa91d0062}},	//   енно_, età_, síte, _udžb, 
   {{0xdb1c009e,0x28c70598,0x7a38010e,0x44271a0d}},	//   _barê, लिपि, píte, _wkn_, 
   {{0x44273280,0xdb1c3281,0x6609123b,0x53a53282}},	//   _tkn_, _carê, miek, _балб, 
   {{0x66093283,0x25bd0156,0xdb1c010c,0xd3780083}},	//   liek, _hawl_, _darê, cać_, 
   {{0x44253284,0x249f3285,0x539a00a7,0x9324009c}},	//   mol_, ltum_, _ניקו, _پرون, 
   {{0x66090bc3,0xe1f200c5,0x25bf3286,0x44253287}},	//   niek, _دست_, ndul_, lol_, 
   {{0xccc63288,0xa3c82002,0x6e243289,0xf09f00f6}},	// [24e0] ыбай, _लोड_, roib, ctà_, 
   {{0x442502f0,0xeb970a10,0x249f328a,0x2d9900a1}},	//   nol_, лиу_, itum_, _ecse_, 
   {{0xdee6328b,0x7f9b00a7,0xdca3328c,0xc986328d}},	//   _сони, _אביז, _қари, гули, 
   {{0x4425328e,0x249f328f,0xd3780035,0xceb30070}},	//   hol_, ktum_, zać_, _פיר_, 
   {{0x44253290,0x7a1c00bc,0xb4bf017d,0xdbd200c2}},	//   kol_, jčte, ुमो_, _küüs, 
   {{0x2ca00c29,0x44253291,0x38663292,0xbddb05d5}},	//   mtid_, jol_, rpor_, _chèf, 
   {{0x2ca03293,0x4425328e,0x38663294,0x09a900cc}},	//   ltid_, dol_, spor_, ওয়া, 
   {{0xd3780da6,0x200a1ba2,0xb05b014e,0x2bd23295}},	//   wać_, hibi_, dvän, सावा, 
   {{0x442502bf,0x2ca003fa,0xc79600b8,0xd37800ab}},	//   fol_, ntid_, _مشاب, tać_, 
   {{0x44253296,0x3a2601a9,0xa158004e,0xe3b800ad}},	//   gol_, loop_, ғару_, tlıq_, 
   {{0xa91d02fe,0x66093297,0xd3780035,0x25bf00a4}},	//   _idža, biek, rać_, bdul_, 
   {{0xf09f048a,0xdb1c0218,0xe3b80095,0xd37800ab}},	//   ttà_, _parê, rlıq_, sać_, 
   {{0x44253298,0x3dc00156,0xf1bf3299,0x6d0301a4}},	//   bol_, ddiw_, rdá_, _रेंग_, 
   {{0x4425329a,0xf09f329b,0xc356048a,0x682d07ca}},	//   col_, rtà_, _съдъ, túdi, 
   {{0x3a260b1f,0xa36f0228,0xf09f329c,0xdb1c010c}},	//   koop_, äčši, stà_, _warê, 
   {{0x270e06d0,0x9f5104b3,0xdeb3004e,0xa3d501a4}},	//   _mən_, tizó_, _құбы, हाथ_, 
   {{0x9f4100e5,0xa91d032f,0x200a329d,0x1ae20086}},	// [24f0] _kohë_, _odža, bibi_, _গেলে_, 
   {{0x320b329e,0x6609329f,0xbcfb0183,0x9f510327}},	//   licy_, ziek, _aféc, rizó_, 
   {{0xddd001f0,0x9e352c54,0xa3d532a0,0x28c700bc}},	//   _çeşi, _венч, हात_, लिभि, 
   {{0xac9532a1,0x320b0035,0x442532a2,0x4c9500a3}},	//   _камш, nicy_, zol_, _кимс, 
   {{0x442532a3,0xa3e505e5,0x2ca000f8,0xdb1c05d5}},	//   yol_, _नवल_, ctid_, _larè, 
   {{0xba770fd0,0x660900ab,0x25bd0156,0x00000000}},	//   _مارت, wiek, _sawl_, --, 
   {{0x660932a4,0x5884005e,0x442532a5,0xec3600a7}},	//   tiek, _қыта, vol_, _כאשר_, 
   {{0x249f32a6,0x442532a7,0x270e0095,0xc48502f1}},	//   ttum_, wol_, _dən_, алик, 
   {{0x442532a8,0x25bf32a9,0xfa34009c,0x443c32aa}},	//   tol_, rdul_, _طرفد, _bhv_, 
   {{0x660932ab,0x249f32ac,0x78bb0ab4,0xdb150054}},	//   siek, rtum_, _isuv, _kazà, 
   {{0x249f32ad,0xddc700e4,0x216a32ae,0xc5d532af}},	//   stum_, gpjū, кини_, _віль, 
   {{0x442532b0,0xb05b022b,0x249f003e,0xdb1c023e}},	//   sol_, rvän, ptum_, _darè, 
   {{0xb05b0219,0x200a32b1,0x0467049b,0xdb1c024a}},	//   svän, tibi_, _стем, _parë, 
   {{0x88bd00ab,0x248d32b2,0x442532b3,0xb4fa00d1}},	//   _wyśw, mrem_, qol_, _בפני, 
   {{0x645b0f46,0x200a32b4,0x527532b5,0xdb1c32b6}},	//   lqui, ribi_, _тулу, _garè, 
   {{0xdd9232b7,0x8e5532b8,0x06af0086,0x245b078a}},	//   تور_, стрі, কিপি, _kêm_, 
   {{0x248d016a,0xb05b0080,0x51f6010e,0x245b040b}},	// [2500] nrem_, nväl, _مسکر, _jêm_, 
   {{0x907b0137,0x2ca032b9,0x307b00a7,0x27220228}},	//   _שטיי, rtid_, _שאינ, nčné_, 
   {{0x2ca032ba,0xdb1502a0,0x78bb06a6,0xdb1c033e}},	//   stid_, _razã, _asuv, _karé, 
   {{0x657b32bb,0x7ae316b5,0xb05b014e,0x705311b7}},	//   jauh, änta, kväl, _دنیا, 
   {{0x684632bc,0x270e0095,0xdb070126,0xdb1c32bd}},	//   анда, _sən_, _bajó, _maré, 
   {{0xdb0732be,0x61e40415,0xb227003e,0x186702a6}},	//   _cajó, _loil, _klæð, шаљи_, 
   {{0x645b0126,0xdb1502aa,0xa01b02ae,0xdb050380}},	//   equi, _vazã, pröv, gehä, 
   {{0xe5c6129d,0x61e432bf,0x786600dd,0x443c32c0}},	//   рско, _noil, _вказ, _shv_, 
   {{0x7a3818f8,0x6aa900ef,0x91830023,0xdb1c01e5}},	//   cíta, _ćefi, _nếu_, _sarè, 
   {{0x69c000a9,0x69c20265,0xdb1c06df,0x53e632c1}},	//   _hame, ldoe, _parè, рциа, 
   {{0x78a232c2,0x869a1b2d,0x4b7b00c7,0xdb0e010c}},	//   ltov, _штат_, כטיג, _rabû, 
   {{0x61e40094,0x248d32c3,0x69c232c4,0xdb1c32c5}},	//   _coil, brem_, ndoe, _caré, 
   {{0x78a20098,0x69c032c6,0xfeb8040f,0x61e432c7}},	//   ntov, _mame, یافت_, _doil, 
   {{0xd7d9009a,0xdb070118,0xb22701d5,0x00000000}},	//   ढायच, _majò, _blæð, --, 
   {{0x69c00012,0x61e41600,0x75f50019,0xdb1c0068}},	//   _oame, _foil, _háza, _faré, 
   {{0x5d550d61,0xdb050750,0x78a20098,0x69c032c8}},	//   скат, nehå, ktov, _name, 
   {{0x78a232c9,0xbddb0107,0x69c200f8,0xdb070118}},	// [2510] jtov, _bièr, ddoe, _najò, 
   {{0x6fb50a5a,0x7a38200a,0xeb9309ed,0x61e432ca}},	//   _امدا, víta, تظر_, _zoil, 
   {{0xdb150187,0x69c032cb,0x645b00e9,0xbddb00b9}},	//   _bazá, _bame, zqui, _dièr, 
   {{0xc9871a63,0x69c02c07,0x645b0126,0x34b60035}},	//   ружи, _came, yqui, _अनूद, 
   {{0xb05b0219,0xf1bf010e,0xf09400c7,0x69c032cc}},	//   kväm, llás_, ַנק_, _dame, 
   {{0x645d1056,0x65620379,0xf1bf0068,0xe8f8012d}},	//   ísim, _afoh, xoán_, шлі_, 
   {{0x69c032cd,0x657b0c36,0x7a3832ce,0xc66802a6}},	//   _fame, tauh, síta, ашње_, 
   {{0x248d32cf,0x69c032d0,0xff18042c,0xdb1c009e}},	//   trem_, _game, יקות_, _karî, 
   {{0x32f70095,0xf1bf0228,0x9f41011c,0x78a200de}},	//   məyə_, hlás_, _dohé_, ctov, 
   {{0x61e41c49,0x69c032d1,0x248d32d2,0xdb1c32d3}},	//   _soil, _zame, rrem_, _saré, 
   {{0x645b32d4,0x61e432d5,0x69c032d6,0xdb1c32d7}},	//   squi, _poil, _yame, _paré, 
   {{0x245b03b7,0xb0c332d8,0xa06a32d9,0x248d32da}},	//   _têm_, शिंग, лама_, prem_, 
   {{0x61e4026d,0x705600eb,0x68fc00ad,0x00000000}},	//   _voil, إنسا, _ərdo, --, 
   {{0x7afe32db,0x76aa06d0,0xe29932dc,0x51f6009c}},	//   yzpt, _həya, _бак_, _گستر, 
   {{0x670d0351,0x229500eb,0x52850038,0x27e502ae}},	//   िपटक_, _العس, _البك, _moln_, 
   {{0x78a20076,0x645932dd,0x51f60109,0xb17b2379}},	//   ytov, _kuwi, _دستر, skår, 
   {{0x22830c05,0x5baa32de,0x78a2026e,0x7ae30219}},	// [2520] lık_, лкам_, xtov, äntn, 
   {{0x69c00ef7,0x3a2d32df,0x62810a1a,0x6459045a}},	//   _same, _akep_, oslo, _muwi, 
   {{0x69c00daf,0x628117f0,0xdcef002a,0x7d09044e}},	//   _pame, nslo, _vecā, _žest, 
   {{0xe8fa32e0,0x5ca632e1,0x657932e2,0x78a232e3}},	//   лле_, _лимб, _newh, ttov, 
   {{0x69c232e4,0x17540251,0x9f41023e,0xb3b71a21}},	//   rdoe, овля, _rohé_, _असंख, 
   {{0x69c02083,0x78a232e5,0xab2a0dfb,0x6283044e}},	//   _wame, rtov, _бога_, _ovno, 
   {{0x69c032e6,0x78a232e7,0x76aa0095,0x46670b58}},	//   _tame, stov, _bəya, брым_, 
   {{0x8a0632e8,0x78a232e9,0x228301f0,0x64590c36}},	//   _узбе, ptov, dık_, _buwi, 
   {{0x628300d2,0x7a38010e,0x6459023e,0x628132ea}},	//   _avno, líto, _cuwi, eslo, 
   {{0x645932eb,0x75f50d12,0x9f4100d7,0x00000000}},	//   _duwi, _váza, _wohé_, --, 
   {{0x02a309a6,0xdb050219,0x22580216,0x7a38039f}},	//   прям, pehå, êrk_, níto, 
   {{0x224032ec,0xa3c800b0,0x6579010c,0x00000000}},	//   _chik_, _लोर_, _gewh, --, 
   {{0x25b700d4,0x224000d7,0x9f410032,0x777a00b4}},	//   _دهند_, _dhik_, _dlhý_, _ketx, 
   {{0x765a32ed,0x26cc0082,0xb4e4009a,0xb4d4009a}},	//   _kuty, _krdo_, नही_, हमी_, 
   {{0xa3d50d0d,0x2283027e,0x0cd100c6,0x777a32ee}},	//   हार_, cık_, सम्म, _metx, 
   {{0xdb1c009e,0x765a01a3,0xf1bf0019,0x7bcb01dd}},	//   _parî, _muty, rlás_, ēgum, 
   {{0xc4b611bd,0xae022030,0x13ac0033,0x00000000}},	// [2530] _अनोख, रोइन_, _কোয়, --, 
   {{0x3a2d018c,0x60cd016c,0x41a5000c,0x26cc32ef}},	//   _skep_, _iram, ग्रस, _ordo_, 
   {{0x1dc432f0,0xbddb06df,0xb4e432f1,0x4ea703a1}},	//   _लोकत, _chèc, नहु_, _урпа, 
   {{0x60cd32f2,0xdb1c32f3,0x777a00b4,0x2bf50110}},	//   _kram, _tarî, _aetx, _इतकं_, 
   {{0x26cc32f4,0x27e50352,0x2283027e,0x32f700ad}},	//   _ardo_, _poln_, zık_, rəyə_, 
   {{0x26cc04d1,0x765a32f5,0x628132f6,0x26c7015e}},	//   _brdo_, _buty, yslo, tvno_, 
   {{0x7bd532f7,0xa91d02fe,0xe73932f8,0xa3dc017d}},	//   _inzu, _idžm, шек_, डान_, 
   {{0x7d0906b6,0x7aea00a8,0x60cd32f9,0x291f023b}},	//   _þess, äfte, _oram, _txua_, 
   {{0xa3d50527,0x79890118,0x777a00b4,0x41dd1281}},	//   हाल_, _idew, _fetx, यानस, 
   {{0x7bc500c5,0x22830c05,0x52a90849,0x981728b7}},	//   ndhu, tık_, авом_, _ابرا, 
   {{0x60cd32fa,0x28c70394,0xe9ff00e7,0x765a0458}},	//   _aram, लिवि, _nhẫn_, _guty, 
   {{0x645932fb,0x75f50254,0x60cd32fc,0x6aa532fd}},	//   _tuwi, _zázn, _bram, ithf, 
   {{0x628132fe,0x64590102,0x316d1f6b,0x04c92841}},	//   sslo, _uuwi, ñeza_, _خوشي_, 
   {{0x628132ff,0x8db500f0,0x62833300,0xae0202e6}},	//   pslo, үсті, _tvno, रोईन_, 
   {{0x60cd3301,0xe299284a,0xd34700d4,0x22403302}},	//   _eram, _тай_, _دیده_, _thik_, 
   {{0x60cd3303,0x7bd502f2,0x660b0065,0x61fd0380}},	//   _fram, _anzu, _jmgk, chsl, 
   {{0x10a3004e,0xac0a32d4,0x442e0054,0x640200d7}},	// [2540] _жиын, анаа_, _ykf_, _رژیم, 
   {{0x7bc53304,0x602600dd,0xa01b02ae,0x91a60019}},	//   gdhu, _єдна, srör, _اچھے_, 
   {{0x75f53305,0x2bce02f8,0x1c3900af,0xa01b0219}},	//   _názo, _होणा, сять_, prör, 
   {{0xa3d50ef0,0x19a900f0,0x26cc0054,0x7bd53306}},	//   हाँ_, йтіп_, _rrdo_, _enzu, 
   {{0x79890156,0x2db700a7,0x7a380019,0x636600bc}},	//   _ddew, _ולכן_, síto, nční, 
   {{0x7a383307,0xdb1c05b9,0x368a00a3,0x2d803308}},	//   píto, _harí, асин_, laie_, 
   {{0x56943309,0xf1ca000c,0x26c30242,0x75fc039f}},	//   чайт, ियान, _šjor_, _léze, 
   {{0x2bce203f,0x442e0844,0x95ca02a6,0x636602d9}},	//   _होता, _skf_, рука_, kční, 
   {{0xdb1c330a,0xa3d51d00,0x75fc0019,0xe9ff00e7}},	//   _marí, हां_, _néze, _hiến_, 
   {{0xe9ff0029,0xdb1c0183,0x26cc0121,0x765a0547}},	//   _kiến_, _larí, _trdo_, _tuty, 
   {{0x6fde0184,0x32190379,0x75f5039f,0x5fde02d9}},	//   मानं, tnsy_, _gázo, मानल, 
   {{0x60cd330b,0x320b035b,0xe9ff0108,0x683f009e}},	//   _pram, рхон_, _miến_, rêde, 
   {{0x107414d3,0x845a0165,0x2bbb00bc,0x4fc72776}},	//   мляю, _трет_, _उसला, осва, 
   {{0x24860304,0xe9ff0023,0x05a600bc,0x442e330c}},	//   _ivom_, _phẫn_, क्रब, _ukf_, 
   {{0x22630228,0xdb1c04ef,0xe2971571,0x15ee00c2}},	//   ľské_, _barí, _дај_, _जवार_, 
   {{0x442c330d,0x2d582241,0xc3330111,0x02fb0486}},	//   lod_, жить_, _קוק_, _כלומ, 
   {{0xa80201f0,0xdb1c0503,0x60cd330e,0x75fc039f}},	// [2550] şıyo, _darí, _uram, _kézb, 
   {{0x442c330f,0xe9ff0029,0x6d5a00ad,0xbddb01f5}},	//   nod_, _biến_, _ştat, _dhèa, 
   {{0x20113310,0xdb1c3311,0x7bc53312,0x9e352cb9}},	//   mizi_, _farí, rdhu, _неоч, 
   {{0x248603ef,0x20113313,0x442c3314,0x6aa50156}},	//   _ovom_, lizi_, hod_, rthf, 
   {{0x442c3315,0x7e620352,0x6e2d3316,0x00000000}},	//   kod_, _čopi, moab, --, 
   {{0xcc760111,0x20113317,0x442c3318,0x7ae302c9}},	//   _מעשה_, nizi_, jod_, ønts, 
   {{0x442c3319,0x69a602e6,0xea630019,0x2486040c}},	//   dod_, _टॉकी, _آپری, _avom_, 
   {{0x7642331a,0x2011331b,0x9f580036,0x7a312be3}},	//   _choy, hizi_, nirò_, gått, 
   {{0x442c02bf,0x2011331c,0x764201e5,0x6fcb009a}},	//   fod_, kizi_, _dhoy, ायां, 
   {{0x442c331d,0x730500fd,0x2011025b,0x24863204}},	//   god_, зпоз, jizi_, _dvom_, 
   {{0x2011331e,0x2329331f,0xdb070098,0x97a400a3}},	//   dizi_, сони_, _objí, _юртл, 
   {{0x27340038,0x00000000,0x00000000,0x00000000}},	//   súnú_, --, --, --, 
   {{0x442c3320,0xa01b02f2,0x455a042c,0x764902a5}},	//   bod_, rsön, _הכנס, mmey, 
   {{0x76493321,0x7fd53322,0x644f022c,0x201101eb}},	//   lmey, місі, ïcid, gizi_, 
   {{0xdb1c3323,0x2d8000b3,0xdee6004f,0xd007251b}},	//   _parí, taie_, чови, чере_, 
   {{0x661b3324,0xe1ff3325,0xee3a3326,0x764901f0}},	//   nnuk, chó_, ёна_, nmey, 
   {{0xdb1c3327,0xd34700d4,0x20111b2f,0xb05b00c8}},	// [2560] _varí, _دیگه_, bizi_, yväi, 
   {{0x2d800107,0x5ebb0033,0x20110474,0x1d19017b}},	//   saie_, _উপরে, cizi_, іють_, 
   {{0x4aaa004e,0x7a380019,0x05bd009a,0x661b0102}},	//   скен_, sítm, ्याब, knuk, 
   {{0x442c3328,0xdb1c02aa,0xa3c800c2,0x7a380098}},	//   zod_, _parâ, _लोई_, mítk, 
   {{0x442c3329,0xed5200d4,0x6443014b,0xdb1c02aa}},	//   yod_, _سپس_, _ohni, _barã, 
   {{0xe9ff0029,0x2609000f,0xdb0e00bc,0x6d3b00d1}},	//   _tiến_, ़ोसी_, _zabý, _לתכנ, 
   {{0x8c431ca5,0x248603ef,0x36330274,0x76420532}},	//   _чере, _svom_, کروس, _phoy, 
   {{0xd49a0fa7,0xceb30056,0x442c00f8,0x6443332a}},	//   бро_, גיה_, wod_, _ahni, 
   {{0x38c809e8,0x442c332b,0x7d04332c,0x2902022b}},	//   _بازی_, tod_, nzis, _åka_, 
   {{0x6e2d0042,0xa2f400dd,0x64430387,0xdb1c0379}},	//   zoab, дпоч, _chni, _karà, 
   {{0x644800e0,0xa195332d,0x2011332e,0x644300a1}},	//   rmdi, манч, vizi_, _dhni, 
   {{0x248604d1,0x442c332f,0x7a38014b,0x79820053}},	//   _tvom_, sod_, dítk, naow, 
   {{0x50673330,0x20113331,0x644300a1,0x683f010c}},	//   ятна, tizi_, _fhni, lêda, 
   {{0x1ae200cc,0xdb0e3332,0x7d043333,0x644301fd}},	//   _গেছে_, _jabó, dzis, _ghni, 
   {{0x20113334,0xc43b00a7,0xbddb023e,0x53333335}},	//   rizi_, _התגי, _dhèn, _пешт, 
   {{0x63ba3336,0x67ef055f,0x753d00ab,0x76aa0095}},	//   letn, _højt, ższe, _rəyl, 
   {{0x629a3337,0x271800ab,0x9f5802a3,0x76aa0248}},	// [2570] luto, धपुर_, rirò_, _səyl, 
   {{0xf0450a24,0xdb1c0379,0x7a380740,0x6e2d084c}},	//   _تعبی, _barà, líth, soab, 
   {{0x3f8303ef,0x629a0e2e,0xdb1c00d3,0x9f580036}},	//   maju_, nuto, _carà, pirò_, 
   {{0x39153338,0x63ba0019,0x7aea0219,0xdb1704fe}},	//   ммер, hetn, äfta, nexé, 
   {{0x629a3339,0x25e0333a,0x7649035d,0x76aa0248}},	//   huto, कानी_, vmey, _dəym, 
   {{0x63ba333b,0x629a333c,0x2ca90219,0xfe70009c}},	//   jetn, kuto, mtad_, _جدی_, 
   {{0x2ca9333d,0x63ba0800,0x7649027e,0xdb1c019c}},	//   ltad_, detn, tmey, _varã, 
   {{0x629a333e,0x3f831a08,0x644300a3,0x7bc7333f}},	//   duto, haju_, _shni, _haju, 
   {{0x3f8300f1,0x2ca93340,0x764901f0,0x7bc73341}},	//   kaju_, ntad_, rmey, _kaju, 
   {{0x3f8300f1,0xdb1c2f33,0x386d3342,0xdb0e0183}},	//   jaju_, _hará, _iter_, _gabó, 
   {{0x3f8300f1,0x7bc70ace,0x629a3343,0x2eac0394}},	//   daju_, _maju, guto, _चहेत, 
   {{0x7bc722d3,0x2ca93344,0xa91d0082,0xe5e5009c}},	//   _laju, ktad_, _adži, _تزئی, 
   {{0xa3c81422,0x63ba0096,0x53a53345,0x3ce00183}},	//   _लोक_, betn, _жалб, xxiv_, 
   {{0xdb0e0068,0x3f831060,0xad9b00f6,0x00000000}},	//   _xabó, gaju_, _llúd, --, 
   {{0xe9ff0029,0x67ef055f,0x3ea30161,0xdb0e00b9}},	//   _nhắn_, _højs, кирг, _labò, 
   {{0xee3a1222,0x51563346,0x600900ef,0x3ce00201}},	//   іна_, _отпу, džmu, txiv_, 
   {{0x3f8303ef,0xbc6a0e61,0x2ca93347,0x7a3800bc}},	// [2580] baju_, زمان_, gtad_, sítk, 
   {{0x3f8303ef,0x60c43348,0x7d043349,0xdb1c03a1}},	//   caju_, _isim, rzis, _parà, 
   {{0x09e60fc8,0xdb1c334a,0x386d009c,0xe9ff001b}},	//   можн, _bará, _ater_, _chắn_, 
   {{0xdb1c334b,0xdb0e26c8,0x25ad01c8,0xad9b0038}},	//   _cará, _sabó, jfel_, _clúd, 
   {{0x7a38334c,0x307a00c7,0xdb0e318d,0x61fd0034}},	//   níti, קאַנ, _pabó, ërli, 
   {{0x60c40010,0x7bc70589,0xdb0e03a0,0x75f5010e}},	//   _msim, _gaju, _dabò, _házh, 
   {{0xa3c81139,0xdb1c334d,0x25ad334e,0x63ba334f}},	//   _लोग_, _fará, ffel_, vetn, 
   {{0xdb1c135a,0x3f8300d2,0x683f078a,0x629a3350}},	//   _gará, zaju_, rêda, vuto, 
   {{0x7bc73351,0x60c43352,0x8cc400bc,0x629a0027}},	//   _yaju, _nsim, रिटो, wuto, 
   {{0xa3d50c8f,0x427402be,0x79800216,0xdb1c3353}},	//   हाग_, нгос, _hemw, _zará, 
   {{0x3f8303ef,0xe215134f,0x629a011d,0x65c61d91}},	//   vaju_, емны, uuto, _обжа, 
   {{0x629a1aa3,0x51f80b58,0x27ec0228,0x63ba25f2}},	//   ruto, днюю_, _hodn_, setn, 
   {{0x3f8300f1,0xbddb011c,0xc5f300d1,0x79800300}},	//   taju_, _dhèl, _בדף_, _memw, 
   {{0x629a3354,0x67ef01cc,0x7a38010e,0xbbc83355}},	//   puto, _højr, síth, रयोक, 
   {{0x3f8303ef,0x60c43356,0x7bc73357,0xa01b02ae}},	//   raju_, _esim, _raju, lsök, 
   {{0x3f8304d1,0x7bc73358,0x2ca93359,0x64580180}},	//   saju_, _saju, ttad_, _hivi, 
   {{0x6458335a,0xe81f335b,0x7bc7335c,0x5c9916d0}},	// [2590] _kivi, _बदला_, _paju, якая_, 
   {{0x2ca9335d,0x2c64014e,0x9f45010e,0x61ed0210}},	//   rtad_, _död_, óló_, _hoal, 
   {{0x3a2f335e,0x2ca9335f,0x62883360,0x386d0a58}},	//   togp_, stad_, nsdo, _ster_, 
   {{0x64583361,0xdb2600c5,0x61ed0194,0x7bc70010}},	//   _livi, رونی, _joal, _waju, 
   {{0x7bc73362,0x61ed3363,0x9f5800eb,0x6d5d0008}},	//   _taju, _moal, mhrá_, _igsa, 
   {{0x645801a7,0x07a204a0,0xf745049b,0xb05b08b5}},	//   _nivi, гашн, нело, lväs, 
   {{0x25ad0012,0x49bb00c5,0x75f50019,0x61ed011c}},	//   tfel_, _وارد_, _házi, _ooal, 
   {{0xcf580052,0xad9b0183,0x64992025,0x628809ad}},	//   ובות_, _flúe, птор_, dsdo, 
   {{0x64583364,0x25ad3365,0x7a3803da,0xa91d0032}},	//   _bivi, rfel_, xíti, _beže, 
   {{0x69cb3366,0x25ad0219,0xc7470038,0x130900c8}},	//   ldge, sfel_, _قضاي, зной_, 
   {{0xa91d008b,0x61ed3367,0x7980030b,0x25ad0380}},	//   _deže, _boal, _yemw, pfel_, 
   {{0x69cb0439,0x25e000a2,0x60c40112,0x6d5d3368}},	//   ndge, काणी_, _psim, _ngsa, 
   {{0xe9ff00f7,0x69c93369,0x645801a7,0xbddb05d5}},	//   _nhận_, _maee, _fivi, _chèm, 
   {{0x7a38336a,0x2c64014e,0x99dd0098,0x2003095a}},	//   ríti, _röd_, _ohňo, ghji_, 
   {{0x6e29014b,0xa3dc0bf5,0x6288336b,0x00000000}},	//   čebn, डार_, csdo, --, 
   {{0x6458336c,0x71a302c0,0xfce6336d,0x60c4336e}},	//   _zivi, _баъз, нобо, _tsim, 
   {{0xdd8f0a7c,0x60c40053,0x6b8500e2,0x28bf0586}},	// [25a0] صول_, _usim, fahg, _शैलि, 
   {{0x61ed0536,0x26c502fb,0x7aea0219,0x38a9336f}},	//   _zoal, _oslo_, äfto, dúr_, 
   {{0xdb1c03b7,0x8f9b00c7,0x69cb02b0,0xb05b3370}},	//   _març, _ציטי, fdge, svät, 
   {{0xa9263371,0x5fde031e,0x491100bd,0xb05b02ae}},	//   ндел, मावल, _देहो_, mvär, 
   {{0x6b850640,0x27fe02a2,0xb05b3372,0x0d2300d3}},	//   bahg, _pltn_, lvär, _бүтү, 
   {{0x656b3373,0x2d82078a,0xfaa63374,0x29061c62}},	//   _afgh, _heke_, _паго, rzoa_, 
   {{0x4df43375,0x320000cf,0x2d823376,0xbb433377}},	//   _इकाई_, _oliy_, _keke_, _берк, 
   {{0x64583378,0xc1ca0a09,0x2d820026,0xd49a3379}},	//   _sivi, ियोग, _jeke_, про_, 
   {{0xdb1c337a,0x765902bf,0x61ed337b,0x64580054}},	//   _barç, _diwy, _roal, _pivi, 
   {{0xa01b0750,0x61ed337c,0x66e62309,0x656b00ca}},	//   rsök, _soal, _поза, _efgh, 
   {{0x64582769,0x61ed020f,0xb05b0080,0x00000000}},	//   _vivi, _poal, yväs, --, 
   {{0x2d82090b,0x6288337d,0xb05b0219,0xa01b02ae}},	//   _neke_, rsdo, dvär, psök, 
   {{0x61ed0489,0x7bdc0511,0x6458337e,0x62880144}},	//   _voal, _onru, _tivi, ssdo, 
   {{0xa91d337f,0xdb1c3380,0xd499004e,0xa3c800aa}},	//   _idžt, _garç, _ірі_, _लोच_, 
   {{0x2d8207d7,0x00000000,0x00000000,0x00000000}},	//   _beke_, --, --, --, 
   {{0xbddb026d,0xe9ff001b,0x7bdc01c4,0xdb1c02ae}},	//   _thèm, _phận_, _anru, _marä, 
   {{0x76aa06d0,0x4c94227c,0x5d553381,0x2d823382}},	// [25b0] _dəyi, литс, ткат, _deke_, 
   {{0xb6030187,0xb60600d0,0xfe711372,0x9c3800b3}},	//   čšin, lešć, _نگر_, епут_, 
   {{0xb05b02ae,0x2249011c,0x201300c3,0xa01b039f}},	//   sväs, _khak_, _imxi_, kröz, 
   {{0x38a93383,0xe9ff00e7,0x98bf008a,0x614901dd}},	//   túr_, _thận_, _jfuħ_, _tūlī, 
   {{0x69cb0f41,0x28f8004f,0x491100c9,0x07a519d1}},	//   rdge, нець_, _देशो_, валн, 
   {{0xe7393384,0x673a08b0,0x69c90175,0x00000000}},	//   мел_, _bytj, _waee, --, 
   {{0x38a90038,0x2d82009e,0x3d15009a,0x200100a1}},	//   súr_, _yeke_, _नेते_, _mlhi_, 
   {{0xa91d1e1f,0x9b5803dc,0xb60608e3,0x660d0228}},	//   _vežb, _чист_, ješć, ďako, 
   {{0xdb1c3385,0xf1bf0228,0xc48203a1,0x395f0175}},	//   _parç, deá_, алык, _igus_, 
   {{0x75f50076,0xf09f00b9,0x33652d60,0x00000000}},	//   _názv, duà_, ъвог, --, 
   {{0xf1dd047b,0xfbd200a7,0x56940e65,0x41dd0425}},	//   यांन, בתי_, _бахт, यांस, 
   {{0x2249158b,0x15153386,0xbddb023e,0x7a38010e}},	//   _chak_, _идея, _dhèk, sítv, 
   {{0x2d823387,0xd9e30086,0x2249011c,0x28c73024}},	//   _reke_, _মতাম, _dhak_, लिटि, 
   {{0x35a7000f,0x2d823388,0xe2993389,0x505911e7}},	//   _गाड़, _seke_, _жак_, ешся_, 
   {{0x2d82338a,0xb05b0219,0x8e8300b3,0x0eb9134f}},	//   _peke_, tvär, игре, нуты_, 
   {{0x25bf338b,0xf1bf00eb,0xcdc5004e,0x395f00a1}},	//   neul_, ceá_, ласқ, _ngus_, 
   {{0xb05b014e,0x25b201f0,0x2d8200fc,0xd24f0038}},	// [25c0] rvär, _öyle_, _veke_, _بني_, 
   {{0x395f338c,0x2d82338d,0x0e66338e,0xb05b338f}},	//   _agus_, _weke_, _икон, svär, 
   {{0x395f0ab1,0x76aa0095,0x387f12e6,0xb05b0219}},	//   _bgus_, _təyi, _awur_, pvär, 
   {{0x20183390,0xb33c0405,0x75f50098,0x60d63391}},	//   liri_, ngħa, _zázv, _krym, 
   {{0x186715f5,0x25bf3392,0xf1aa109f,0x8b660411}},	//   вачи_, deul_, _कानन, _لازم, 
   {{0xe9ff0029,0xf1e40262,0x6d462b25,0x20183393}},	//   _phản_, गाड़_, _izka, niri_, 
   {{0x1ae31e13,0xcac731a4,0x2ca00d2d,0x25bf020f}},	//   _корм, _игре_, luid_, feul_, 
   {{0x20183394,0x7c3e1af5,0x25bf3395,0xbddb0118}},	//   hiri_, llpr, geul_, _chèh, 
   {{0x20183396,0x69d3026e,0xb60607c7,0x2ca03397}},	//   kiri_, ádež, vešć, nuid_, 
   {{0x20183398,0x9f5a00f6,0xe9ff0023,0x00000000}},	//   jiri_, _alpí_, _thản_, --, 
   {{0x25bf3399,0x60d60054,0x2bf7027a,0x2ca0339a}},	//   beul_, _arym, דמין_, huid_, 
   {{0x7a380b85,0xdb15014b,0x2ca0007e,0x25bf00b3}},	//   pítu, _nazý, kuid_, ceul_, 
   {{0x2018339b,0x6602339c,0x3eba339d,0xf1bf007a}},	//   firi_, _ilok, _appt_, reá_, 
   {{0xdb1702a0,0x66020194,0x3eba02a2,0x59c9049f}},	//   nexã, _hlok, _bppt_, _रसभर, 
   {{0x6602339e,0xbe88339f,0x6d460a9f,0x0d670093}},	//   _klok, ксте_, _azka, възм, 
   {{0x443e33a0,0xa91d334f,0x60d600e5,0xd35700a7}},	//   llt_, _leža, _frym, _בשוק_, 
   {{0x201833a1,0x60d61123,0x32190180,0xebd933a2}},	// [25d0] biri_, _grym, misy_, ндаш_, 
   {{0x321933a3,0x201833a4,0x25bf00d9,0x6b7400f6}},	//   lisy_, ciri_, zeul_, илуу, 
   {{0x443e33a5,0x999908ad,0xfb152f23,0xf1aa0a09}},	//   ilt_, екет_, دواج, _कामन, 
   {{0x443e02f2,0x321933a6,0x7c3e08a3,0x0a94017b}},	//   hlt_, nisy_, alpr, рацю, 
   {{0x69342408,0xa91d33a7,0xdb1c078a,0x0c840235}},	//   анцу, _beža, _karû, _высм, 
   {{0x660233a8,0x7e6502a2,0x16a933a9,0x3eba0096}},	//   _alok, _kuhp, евки_, _yppt_, 
   {{0x7a38006b,0x2be00d1d,0x25bf33aa,0xc98700d9}},	//   gíts, नारा, teul_, _аузи, 
   {{0x201833ab,0xe51400bd,0x154533ac,0xdb1e33ad}},	//   ziri_, _तेहि_, лейм, depè, 
   {{0x629a33ae,0x89370740,0x644a00eb,0x17c70cdf}},	//   erto, _شعرا, _bhfi, _аҳли_, 
   {{0x6602030f,0x3fce0086,0x25bf00b3,0xede00e49}},	//   _elok, _রক্ষ, seul_, _पच्छ, 
   {{0x660233af,0x7a382ef3,0x201833b0,0xb33c003d}},	//   _flok, mítr, viri_, tgħa, 
   {{0x2018030b,0x443e33b1,0x75242331,0x673c00fc}},	//   wiri_, alt_, _žize, _ørja, 
   {{0x25e006ea,0x201833b2,0x657b0db6,0x629a039b}},	//   कारी_, tiri_, mbuh, arto, 
   {{0x5ebb00cc,0x6fde00ab,0x049200eb,0xf1dd031e}},	//   _উপজে, माइं, _الوح, याउन, 
   {{0x201833b3,0x657b090b,0x44270065,0x539a00d1}},	//   riri_, obuh, _ijn_, _טיסו, 
   {{0x201833b4,0x657b012b,0x60d633b5,0x61fd33b6}},	//   siri_, nbuh, _trym, cksl, 
   {{0x271f07cc,0x248d33b7,0xfce319e4,0x9c2633b8}},	// [25e0] यपुर_, nsem_, бото, гдад, 
   {{0xdb150183,0x2018024a,0x6d460356,0xb05b0380}},	//   _nazó, qiri_, _vzka, nwäl, 
   {{0xa91d2cb7,0x657b06e4,0x9eaa2965,0xda650038}},	//   _reža, kbuh, _явна_, لاني, 
   {{0x3f8a33b9,0x533600c7,0x248d33ba,0x6e9b00d1}},	//   labu_, אנען_, ksem_, _אבטח, 
   {{0x443e33bb,0x81ce0086,0x461400d4,0xddc40035}},	//   ylt_, রাপ_, یوتر, rmiń, 
   {{0x67d433bc,0x660233bd,0x3f8a025b,0xbcfb02be}},	//   року, _slok, nabu_, _efés, 
   {{0x660233be,0x25e000c6,0x7bce0102,0xfc0333bf}},	//   _plok, काली_, _iabu, _упро, 
   {{0x442700ef,0x7bce33c0,0x3f8a33c1,0x629a0228}},	//   _ajn_, _habu, habu_, vrto, 
   {{0xa91d27e8,0x7a3833c2,0x248d010e,0x32191ca8}},	//   _teža, síts, gsem_, visy_, 
   {{0x443e33c3,0x78a233c4,0x4394122f,0x3f8a0548}},	//   ult_, muov, јанс, jabu_, 
   {{0x7bce33c5,0x321933c6,0x81ce0033,0xdb150054}},	//   _mabu, tisy_, রান_, _hazò, 
   {{0x7bce33c7,0xd7e2009a,0x25e0009a,0x4427008a}},	//   _labu, पावच, काळी_, _ejn_, 
   {{0x78a201d8,0x61fd33c8,0x321901a7,0x44f7021b}},	//   nuov, rksl, risy_, _مروج_, 
   {{0x7bce33c9,0xbcfb0183,0x629a0352,0x32190180}},	//   _nabu, _ofér, prto, sisy_, 
   {{0x32191763,0xa91d33ca,0x78a212af,0x6562084c}},	//   pisy_, _nežn, huov, _kgoh, 
   {{0x7bce06e4,0x2bc700a5,0x78a233cb,0x51870197}},	//   _aabu, रजभा, kuov, _сука, 
   {{0x3f8a086d,0x7bce33cc,0x69c2155b,0xdb0502ae}},	// [25f0] babu_, _babu, deoe, nehö, 
   {{0x5d54062a,0x26e402fc,0xa91d0187,0x3f15017b}},	//   скут, _कपूर_, _bežn, _вдос, 
   {{0xdb1533cd,0x5e470038,0x7bce0caf,0x656200a3}},	//   _razó, _مضحك, _dabu, _ogoh, 
   {{0xdb15001d,0x248d33ce,0xa91d0352,0x656233cf}},	//   _sazó, ysem_, _dežn, _ngoh, 
   {{0xa3d4059e,0x225902d9,0x00000000,0x00000000}},	//   हया_, írky_, --, --, 
   {{0xb8cd0b3e,0x248d008b,0x969533d0,0xa6951b11}},	//   _कम_, vsem_, ариш, ариј, 
   {{0x69c2123b,0x00000000,0x00000000,0x00000000}},	//   beoe, --, --, --, 
   {{0x7bce33d1,0x6b870ab4,0x5b140650,0x78a21102}},	//   _zabu, _hejg, _умст, buov, 
   {{0x81ce100b,0xccf20137,0xdb0501c4,0x7bce2834}},	//   রাম_, ַכט_, gehö, _yabu, 
   {{0x3ea300e5,0x248d33d2,0x00000000,0x00000000}},	//   kujt_, rsem_, --, --, 
   {{0x248d33d3,0x232933d4,0xfbcf0086,0x422633d5}},	//   ssem_, тони_, রাপত, идов, 
   {{0xdb0533d6,0xc049035c,0x3f8a0937,0xc10600eb}},	//   behö, _חז_, wabu_, لوجي, 
   {{0x3f8a33d7,0x7d0d0a1a,0xa91d0243,0x00000000}},	//   tabu_, jzas, _mežo, --, 
   {{0x2bd504d7,0x7d0d27b0,0x2480078a,0x661b012d}},	//   _डोला, dzas, _çima_, liuk, 
   {{0x539a00a7,0x3f8a33d8,0x7bce33d9,0xa22500d4}},	//   _סיקו, rabu_, _rabu, _گروه, 
   {{0x7bce33da,0x3f8a0053,0x75f5014b,0xa91d33db}},	//   _sabu, sabu_, _zázr, _režn, 
   {{0xed5a00ce,0x91e407f9,0x3b862756,0x6b87003d}},	// [2600] тоа_, _воқе, илаг, _bejg, 
   {{0x7bce00cf,0x4f9633dc,0x2d9c0218,0x644133dd}},	//   _qabu, _триу, şve_, nlli, 
   {{0x4aaa33de,0xbf9b0111,0x644133df,0x661b33e0}},	//   ткен_, _בייש, illi, kiuk, 
   {{0x7bce33e1,0xbcfb0019,0xe8fa33e2,0x66090a9d}},	//   _wabu, _igén, кле_, jhek, 
   {{0x7fe90f94,0xe7e21951,0x7d0d0083,0x660900d7}},	//   _شریف_, पालप, czas, dhek, 
   {{0xdb170068,0x4813004f,0x9b891372,0x69c201cf}},	//   sexá, оміс, _مخفف_, seoe, 
   {{0x36871b17,0xe5c633e3,0x290033e4,0xddc400e0}},	//   асын_, аспо, šia_, rmiņ, 
   {{0xa01b33e5,0x64410088,0x8881006b,0x75fc010e}},	//   nsör, elli, _کیون, _kézi, 
   {{0x07a633e6,0x186a004f,0x75fc0118,0x37e60ca4}},	//   _вазн, _рази_, _jézi, _коаг, 
   {{0xe9ff00f7,0xf36633e7,0x690803c0,0x6441012b}},	//   _phần_, штин, ırdı, glli, 
   {{0x7bd900c7,0x326600ff,0xbcfb33e8,0x533433e9}},	//   אַרק, јтов, _ngén, сент, 
   {{0x9f5800eb,0x660933ea,0x644133eb,0xd5b011b7}},	//   bhrú_, chek, alli, _رفت_, 
   {{0x600202aa,0xbcfb10fd,0xba57027a,0xa3d402be}},	//   _cômo, _agén, יסטו_, _голч, 
   {{0xe9ff0029,0x2005008c,0x3317009c,0xfe7309ed}},	//   _thần_, óli_, ازید_, قدر_, 
   {{0x2286198b,0x543900c7,0x798b33ec,0x22940195}},	//   _тулг, _געװא, yagw, _البس, 
   {{0x443c00ca,0x2cb20326,0x683f010c,0x75fc0212}},	//   _hkv_, ftyd_, rêdi, _bézi, 
   {{0x6b87024a,0x7c8733ed,0xacf82540,0x2cb20ff2}},	// [2610] _pejg, рубе, анту_, gtyd_, 
   {{0x60cd33ee,0x81ce0086,0x3ea30034,0x798b28ee}},	//   _isam, রাণ_, pujt_, wagw, 
   {{0xa91d0082,0x5975223e,0xdce70585,0xf09f03dd}},	//   _pežo, былу, ılıd, lrà_, 
   {{0xa2d72488,0x60cd33ef,0xdb050574,0x00000000}},	//   यित्, _ksam, nghé, --, 
   {{0x98c733f0,0xe9ff001b,0x26cc0183,0x644133f1}},	//   рсел, _nhấn_, _asdo_, ylli, 
   {{0x60cd06f2,0x8d5a00d1,0xa7a900d3,0x798b33f2}},	//   _msam, _תכשי, укка_, sagw, 
   {{0x660933f3,0xa91d015e,0xfeca0070,0x661b33f4}},	//   thek, _težo, ָמפּ, tiuk, 
   {{0xc48533f5,0x5bc70ede,0x60cd33f6,0x9f580038}},	//   блик, _रघुव, _osam, thrú_, 
   {{0x999f026e,0xe9ff00e7,0x661b02f3,0x644133f7}},	//   _chuť_, _chấn_, riuk, tlli, 
   {{0x75f50d5f,0xf09f23a9,0x660933f8,0xf7700038}},	//   _vázq, drà_, shek, _قام_, 
   {{0xd7f82cd7,0x60cd33f9,0x660933fa,0x7c22026a}},	//   _тут_, _asam, phek, éori, 
   {{0x60cd0065,0x7bc5024a,0xe1f80200,0x644133fb}},	//   _bsam, hehu, рҳи_, slli, 
   {{0x7bc533fc,0x798912b6,0x60cd33fd,0xf09f00f6}},	//   kehu, _meew, _csam, grà_, 
   {{0x438500eb,0x183500c7,0x7989052b,0x81ce0086}},	//   _الثق, מאָל_, _leew, রাধ_, 
   {{0x60cd33fe,0xf09f022c,0x249f16fa,0x7bc501e8}},	//   _esam, arà_, lrum_, dehu, 
   {{0x4d6633ff,0x249f3400,0xf09f022c,0x629c0243}},	//   скав, orum_, brà_, šroc, 
   {{0x61e43401,0x1b150086,0x4d4a02a6,0xa01b0219}},	// [2620] _inil, _তুলে_, упан_, rsör, 
   {{0xf1bf00eb,0x7bc53402,0x2cb20876,0xa01b02ae}},	//   nnán_, gehu, rtyd_, ssör, 
   {{0x249f3403,0x61e407fc,0x201a0096,0x34c4072e}},	//   hrum_, _knil, _impi_, _वन्द, 
   {{0x61f600cf,0xbddb00d4,0x994a0038,0x26cc0415}},	//   _joyl, _dhès, هلال_, _rsdo_, 
   {{0x2d803404,0x98a30e06,0x249f3405,0x60cd3406}},	//   mbie_, зиче, jrum_, _xsam, 
   {{0x249f3407,0xdb1e32ce,0x2bb700bc,0x7bc53408}},	//   drum_, lepí, _věcí_, cehu, 
   {{0xfaa33409,0x66740116,0x05240033,0xdb0e0080}},	//   _наро, زگار, _পরের_, äjän, 
   {{0xe5c632f8,0x2be015c8,0xe9ff00e7,0x61e40415}},	//   сско, नाका, _phấn_, _nnil, 
   {{0x8cdb017d,0x2a6a0065,0xb906340a,0x201a0126}},	//   नियो, _hubb_, _узак, _ompi_, 
   {{0xf09f0093,0x2ca0340b,0x64a601a2,0x7989340c}},	//   vrà_, irid_, _ҳада, _zeew, 
   {{0x61f616a3,0x60cd052b,0x798901a3,0x00000000}},	//   _boyl, _ssam, _yeew, --, 
   {{0x64a6340d,0xf09f340e,0x201a01d8,0x02a800a5}},	//   _гада, trà_, _ampi_, _कमीन, 
   {{0x41aa340f,0x33940009,0x2ca00065,0x44fa17bc}},	//   _कारस, _далё, jrid_, _حراج_, 
   {{0x3e6e000d,0xf09f3410,0x6e3d0065,0x61e40156}},	//   _být_, rrà_, _sksb, _enil, 
   {{0xa3d5031e,0x7bc500fb,0xa3c53411,0x32b7007a}},	//   ाएर_, vehu, उजर_, _هدية_, 
   {{0x60cd0194,0xf09f01d8,0xa91d0352,0x201a02a5}},	//   _tsam, prà_, _dežj, _empi_, 
   {{0x32090a49,0x7bc53412,0x00000000,0x00000000}},	// [2630] _ilay_, tehu, --, --, 
   {{0x7b673413,0xbddb2195,0x79893414,0xdcfd0028}},	//   стае, _chèr, _seew, _nesą, 
   {{0x2ca0007e,0xb9950fd0,0xbddb01e5,0x998c00ca}},	//   arid_, قلاب, _dhèr, _šoša_, 
   {{0x80cc0086,0xdb1c003e,0x7bc50657,0x249f3415}},	//   ামর্, _farþ, sehu, yrum_, 
   {{0xb05b0228,0x320906c2,0x7bc53416,0x75fc010e}},	//   dväz, _mlay_, pehu, _jézu, 
   {{0x249f3417,0xbddb0107,0x86993418,0x4cba0070}},	//   vrum_, _thès, атит_, _דזשו, 
   {{0x41aa0f7a,0x2d8b02a2,0x32093419,0x59d4059e}},	//   _कालस, _kece_, _olay_, _ठोकर, 
   {{0xf1d9000f,0xb05b01c4,0x32ee00ad,0xa91d1a01}},	//   _बोलन, swäh, cəyi_, _ježk, 
   {{0xdb1e00d9,0xc7ab009c,0x24091a57,0x00000000}},	//   cepâ, _مدال_, инии_, --, 
   {{0x3209341a,0x61e4341b,0x249f341c,0x2d8b0304}},	//   _alay_, _snil, rrum_, _lece_, 
   {{0xf1bf341d,0x249f341e,0x320900f6,0x81ce0033}},	//   rnán_, srum_, _blay_, রাস_, 
   {{0x2d8b090b,0xcad600a7,0x201a0640,0xa91d0604}},	//   _nece_, קורת_, _smpi_, _nežk, 
   {{0xa06a341f,0x628e010e,0x05743420,0xb5c800d7}},	//   рага_, ábor, _راند, _دونم_, 
   {{0xee3f0228,0x3a2d0372,0x00000000,0x00000000}},	//   _aký_, _ljep_, --, --, 
   {{0x32090118,0x0f040299,0x2486039b,0x9e053421}},	//   _flay_, रनेस_, _zwom_, रसंघ_, 
   {{0x3d1505d2,0x2d8b3422,0x2bac00bc,0x00000000}},	//   _नइखे_, _cece_, _चाहा, --, 
   {{0x2d8b02a6,0xbddb026a,0xee3708ab,0xdb1e069a}},	// [2640] _dece_, _chèq, іну_, repí, 
   {{0xeb9a3423,0xa91d0352,0x41aa0586,0x2ca0059e}},	//   риж_, _težj, _काँस, rrid_, 
   {{0x2d8b00fd,0xf1bf010e,0x6ac608cb,0x298a0398}},	//   _fece_, knál_, تقام, асло_, 
   {{0xa3d5006a,0x3a3f04e4,0xfce63424,0x2d8b05b7}},	//   ाएँ_, _ckup_, _домо, _gece_, 
   {{0x3a2d021e,0x00000000,0x00000000,0x00000000}},	//   _djep_, --, --, --, 
   {{0x2d8b00d9,0x7aea02ae,0xec341c03,0xdb1e02be}},	//   _zece_, äfts, _روزگ, repâ, 
   {{0x491a000d,0x6fad000f,0xdb1c00e5,0x02a808b4}},	//   _मेरो_, _जासू, _mbrë, _कमेन, 
   {{0x16370084,0x7ae1006b,0xd5b72bdc,0xf1bf2e9b}},	//   يسية_, _álta, ось_, gnál_, 
   {{0xa3d5006a,0x79820621,0x6fca00a2,0x69dd001d}},	//   ाएं_, mbow, ाजां, _ósea, 
   {{0x22400019,0x25da01a4,0x78a22fb3,0x96ba0afc}},	//   _akik_, _खोरी_, mrov, _вуду_, 
   {{0x32093425,0xe73a004f,0x2a64025b,0x48f400bc}},	//   _play_, _теж_, _kimb_, ्नको_, 
   {{0x6010022b,0x80ac0d53,0x78a2014b,0x00000000}},	//   _jämf, _जमशे, orov, --, 
   {{0xd2580904,0x2d8b3426,0xf99307e4,0xddcd0083}},	//   юць_, _rece_, ורר_, ymał, 
   {{0xb4d60e17,0x2d8b0082,0x600b00b0,0x78a20028}},	//   ाटी_, _sece_, _sümb, irov, 
   {{0x28d1000c,0x65790107,0x2d8b00da,0xed8b02a6}},	//   _दैनि, _éché, _pece_, исак_, 
   {{0xdb1c02f2,0xb5fc008a,0x5c753427,0x1277007a}},	//   _darü, _buġi, злат, _بحوث_, 
   {{0x2d8b04d1,0x31690019,0x78a20bfc,0x69c6003e}},	// [2650] _vece_, _igaz_, jrov, _ókey, 
   {{0xdb1c3428,0x26de3429,0x9f58008c,0x5fb2009a}},	//   _naró, _orto_, skrá_, _जायल, 
   {{0x3f9104d3,0xa91d02ee,0x81ce0086,0x78a2342a}},	//   mazu_, _težk, রার_, erov, 
   {{0x3f910062,0x2a64342b,0xdb1c0369,0x78a200da}},	//   lazu_, _cimb_, _aaró, frov, 
   {{0x78a2026e,0xdb1c2a16,0xdb150165,0x26de342c}},	//   grov, _baró, _razõ, _arto_, 
   {{0xf7710523,0xdb1c03da,0xa3da190a,0x3f91053d}},	//   رات_, _caró, _ढोल_, nazu_, 
   {{0x78a20180,0x1ab41d3c,0x3a2d0175,0x7bd5020f}},	//   arov, _обря, _tjep_, _iazu, 
   {{0xc4850e51,0xa91d342d,0xdce40035,0x7bd5342e}},	//   плик, _leži, ecię, _hazu, 
   {{0x629c0496,0x442e0082,0xf1bf342f,0xdb1c3430}},	//   áron, _bjf_, rnál_, _abrè, 
   {{0xa91d3431,0xf1bf010e,0x22403432,0x4374004f}},	//   _neži, snál_, _skik_, муют, 
   {{0x7bd53433,0x09be0033,0x3f9101ca,0xf770009c}},	//   _mazu, _ইফতা, dazu_, _شال_, 
   {{0xdb1c0035,0x06c30086,0x386d3434,0xad9b3435}},	//   _zaró, ্মদি, _kuer_, _flúi, 
   {{0xa91d239a,0xad9b0038,0x799b3436,0x0ef602e6}},	//   _beži, _glúi, _mduw, ीन्स_, 
   {{0x60020379,0x316900b4,0xdb1c05d5,0x25ad00bd}},	//   _kômi, _egaz_, _marò, lgel_, 
   {{0xdee33437,0x6d4f0369,0x6e2f0175,0x25ad00f8}},	//   нори, _azca, _bjcb, ogel_, 
   {{0x799b00c5,0x386d018c,0x75fc011c,0xe9ff0108}},	//   _nduw, _ouer_, _hézr, _thẹn_, 
   {{0x7bd53438,0xed573439,0x602600b3,0x00000000}},	// [2660] _bazu, зот_, _ндиа, --, 
   {{0x7bd50012,0x2a640640,0x799b343a,0x60c4016c}},	//   _cazu, _simb_, _aduw, _ipim, 
   {{0xf1bf014b,0x386d343b,0x7bd50380,0xd9100535}},	//   znám_, _auer_, _dazu, چیز_, 
   {{0x38c80116,0x25ad0082,0xdb1c343c,0x6abb090e}},	//   قاتی_, jgel_, _barò, _ćuft, 
   {{0x2d92343d,0xdb1c343e,0xdce40035,0x386d24f6}},	//   maye_, _paró, ycię, _cuer_, 
   {{0x2d92343f,0x25ad3440,0x0ee0058c,0x386d0d09}},	//   laye_, egel_, _पछाड, _duer_, 
   {{0xdb1c0634,0x2a640065,0xb05b0219,0x386d0380}},	//   _varó, _timb_, rväx, _euer_, 
   {{0x78a23250,0x25ad3441,0x2d923442,0x386d0380}},	//   prov, ggel_, naye_, _fuer_, 
   {{0x7bd53443,0xb4d60f8e,0xb05b0219,0x7e663444}},	//   _yazu, ाटे_, pväx, _mikp, 
   {{0x2d920199,0x6d4600e2,0xd77600eb,0x6b8e0372}},	//   haye_, _myka, _رائع, _jebg, 
   {{0x600b06d0,0x60c43445,0x26de3446,0x2d923447}},	//   _nüma, _apim, _urto_, kaye_, 
   {{0xb05b02eb,0xa91d0144,0x00000000,0x00000000}},	//   hwät, _seži, --, --, 
   {{0x2d923448,0x463b0070,0x6d4606cd,0x3f913449}},	//   daye_, _פעדע, _nyka, tazu_, 
   {{0x545300dd,0x644f344a,0x7c3e0096,0x68e0040c}},	//   _звіт, ïcit, jopr, _mrmd, 
   {{0x645a010d,0x69c00187,0x3f91072b,0xa91d344b}},	//   mmti, _obme, razu_, _veži, 
   {{0x443e344c,0x2d92024d,0x7e660065,0x6d460876}},	//   lot_, gaye_, _cikp, _byka, 
   {{0x42380a33,0xa91d02f5,0x7bd5344d,0x443e344e}},	// [2670] _מנהל_, _teži, _pazu, oot_, 
   {{0x443e344f,0xf0920a33,0x442c3450,0x69c00380}},	//   not_, _שני_, nnd_, _abme, 
   {{0x2d923451,0x7bd5002e,0x386d011c,0xbb450148}},	//   baye_, _vazu, _suer_, ффақ, 
   {{0xa2a40586,0x7bd523d0,0x2d9202b8,0xdb1c3452}},	//   _किन्, _wazu, caye_, _parò, 
   {{0xddc40e7b,0x386d03b7,0x89370084,0xa3ac00a2}},	//   lmiş, _quer_, أعضا, गला_, 
   {{0xd3660084,0x443e002a,0x7c3e01d8,0xf74504e9}},	//   _له_, jot_, copr, мело, 
   {{0x443e3453,0x6e2d3454,0xddc405b7,0x69dd001d}},	//   dot_, onab, nmiş, _óseo, 
   {{0x6e2d0298,0x442c3455,0x64481b26,0x386d0107}},	//   nnab, end_, eldi, _tuer_, 
   {{0x69cb3456,0x62980093,0x443e3457,0x442c008c}},	//   mege, _avvo, fot_, fnd_, 
   {{0x443e3458,0x69d93459,0x69cb345a,0x25ad00ca}},	//   got_, ldwe, lege, sgel_, 
   {{0x81d70086,0xdb1c008c,0x2d92345b,0xd1ca00c8}},	//   সান_, _jarð, yaye_, олне_, 
   {{0x69cb345c,0x64480a9f,0x442c345d,0x7ae300c8}},	//   nege, aldi, and_, änty, 
   {{0x200402a0,0x5155345e,0x2d9205d5,0x6e2d0156}},	//   êmio_, етру, vaye_, dnab, 
   {{0x2d92345f,0x81ce0086,0x44213460,0x7e66023e}},	//   waye_, রাই_, _öh_, _sikp, 
   {{0x7c3e0d26,0x7f430088,0x2d923461,0x69cb3462}},	//   vopr, верж, taye_, kege, 
   {{0x6e2d3463,0x76493464,0x69cb3465,0x6b8e00c3}},	//   gnab, nley, jege, _sebg, 
   {{0x7c3e3466,0x2d923467,0x69cb3468,0x60c43469}},	// [2680] topr, raye_, dege, _upim, 
   {{0xa91d0082,0x2d92346a,0x6d46014b,0xdca3346b}},	//   _ježu, saye_, _vyka, тафи, 
   {{0x7649346c,0x62810237,0x600b007e,0x6d460035}},	//   kley, nplo, _kümn, _wyka, 
   {{0x69cb346d,0x6b8e0a9f,0x443e346e,0x3a990504}},	//   gege, _webg, zot_, ятую_, 
   {{0x443e00cf,0x64480c43,0x442c008c,0x2fc100e2}},	//   yot_, yldi, ynd_, _ybhg_, 
   {{0x6e24346f,0x443e3470,0x656b02a3,0x93bc020f}},	//   liib, xot_, _aggh, lnăv, 
   {{0x443e00d8,0xdb1c008c,0x6b633471,0x7d043472}},	//   vot_, _garð, _акра, lyis, 
   {{0xd49a0de6,0xceb30056,0x442c3473,0x35b400a3}},	//   оро_, דיה_, wnd_, хбир, 
   {{0x7d040298,0x64a302a0,0x442c0231,0x26c501a4}},	//   nyis, вања, tnd_, _eplo_, 
   {{0x442c0056,0x9f5a0034,0xb05b0502,0x765b02a5}},	//   und_, _copë_, hwär, amuy, 
   {{0x443e3474,0x442c3475,0x76493476,0x6e243477}},	//   rot_, rnd_, bley, kiib, 
   {{0x20ca047c,0x7d040088,0x84ea070f,0xdb053478}},	//   िबंध, kyis, _وفاق_, nghá, 
   {{0x6e243479,0xdb1e1ece,0x628108b0,0x92be0033}},	//   diib, lepä, aplo, ঁটে_, 
   {{0xa294347a,0xdb1e0165,0x443e02f1,0xddc4008f}},	//   _закі, cepç, qot_, tmiş, 
   {{0x69cb347b,0x81d70033,0xb05b0502,0x15f203a2}},	//   yege, সাব_, fwär, _आचार_, 
   {{0xddc40092,0xc33300a7,0x7640347c,0x600b00b0}},	//   rmiş, _שוק_, nomy, _gümn, 
   {{0x69cb347d,0xd904347e,0xde6400fd,0xdc5505b2}},	// [2690] vege, _ئی_, търп, евањ, 
   {{0x69cb347f,0x9f89003e,0x76490213,0xeb4b0080}},	//   wege, _góðu_, zley, очек_, 
   {{0x69cb3480,0x76403481,0x764901f0,0x6e24052b}},	//   tege, komy, yley, biib, 
   {{0xdb1c008c,0x764000ab,0xd9f924d2,0xdddd0083}},	//   _varð, jomy, янец_, _wisł, 
   {{0xf1c100bd,0x69d9000b,0x7d1600ab,0x5d7a0070}},	//   ष्यन, rdwe, czys, _מארק, 
   {{0x78ab0b1f,0x3e750611,0x9f5a0237,0x00000000}},	//   rugv, _kåt_, _bopè_, --, 
   {{0x76493482,0x69cb29a4,0x00000000,0x00000000}},	//   tley, pege, --, --, 
   {{0xb8d500cc,0x6ec200a5,0x53d700b0,0xad9b3483}},	//   _জন_, _लहसु, _भोजश, _glút, 
   {{0x3e753484,0x76493485,0xe7e0075a,0xf1bf007a}},	//   _låt_, rley, _गोवा_, dfá_, 
   {{0x37072669,0x76493486,0x62813487,0xa93400d9}},	//   _очев, sley, tplo, _реуш, 
   {{0x3e75014e,0x76491041,0xc7d600d1,0x53a50176}},	//   _nåt_, pley, _רועי_, _ҷалб, 
   {{0x62813488,0x7640011c,0x7d160083,0x10a601ff}},	//   rplo, comy, yzys, нимн, 
   {{0x53a5058e,0xdee300a3,0x70ca00bc,0x00000000}},	//   _залб, қоти, िबेल, --, 
   {{0x66091923,0x3e750f5b,0x25bf23bd,0x62811074}},	//   lkek, _båt_, lful_, pplo, 
   {{0x20c3005e,0x64413489,0x6e240298,0x84640093}},	//   _ұйым, moli, tiib, _ръце, 
   {{0x7d04030f,0xee3a00dd,0x6441348a,0xa2a40425}},	//   tyis, їна_, loli, _कित्, 
   {{0xdca3348b,0x44251600,0xa3b6000d,0x25bf0870}},	// [26a0] лати, oil_, ङ्क_, iful_, 
   {{0x7d160da6,0x4425348c,0x6e24348d,0x41c1031e}},	//   rzys, nil_, siib, ष्ठस, 
   {{0xa3b702f8,0x387f348e,0xad9b348f,0x93bc00b3}},	//   _छान_, _atur_, _clús, mnăt, 
   {{0x4425148f,0x387f0175,0x13d80033,0x81ce0033}},	//   hil_, _btur_, তায়, রাক_, 
   {{0x44253490,0x64413491,0x25bf017c,0x7640016c}},	//   kil_, koli, dful_, vomy, 
   {{0x4425079e,0x64413492,0xf09300d1,0x6609177f}},	//   jil_, joli, ננו_, ekek, 
   {{0x64413493,0x0cd01516,0xa3b30366,0x45d4021d}},	//   doli, _हनुम, टलन_, войс, 
   {{0xe7e007d5,0xdb1e00b0,0x44253494,0x9f5a0212}},	//   _गोरा_, repä, eil_, _copé_, 
   {{0x64413495,0xddde00e0,0xf8d412e3,0xdb1e14c0}},	//   foli, _atpū, _धनिय, sepä, 
   {{0x644102bf,0x600b0092,0x76400458,0xdcef01dd}},	//   goli, _cüml, somy, _secī, 
   {{0xa3b6031e,0xdb1c3496,0x03c3004e,0x46a60ab5}},	//   ङ्ग_, _obrí, усым, _чаев, 
   {{0x44250a92,0x66093497,0xad9b00b9,0x3e750566}},	//   ail_, ckek, _llúr, _råt_, 
   {{0xf2c3005e,0xc05b00dd,0x2906095a,0xf1bf007a}},	//   _ұсын, зів_, nyoa_, rfá_, 
   {{0x44253498,0x20d60ca5,0x64413499,0xdb1c26ca}},	//   cil_, džić_, coli, _abrí, 
   {{0x9f34005e,0x80c40086,0xdd95012d,0x28e2349a}},	//   гері, শিষ্, кавы, पिडि, 
   {{0xe7e700a5,0x3e750bff,0x629a349b,0x00000000}},	//   _टोना_, _våt_, msto, --, 
   {{0x61ed349c,0x629a1c60,0xd2f80019,0x9055349d}},	// [26b0] _inal, lsto, _رکھا_, _ивиц, 
   {{0x600b349e,0x61ff0104,0x61ed349f,0x629a26ad}},	//   _kümm, _hoql, _hnal, osto, 
   {{0xd0110105,0x61ed34a0,0xe9d90035,0x76aa00ad}},	//   _ملک_, _knal, _paź_, _təyy, 
   {{0xdbd71066,0x629a34a1,0x7c2500ef,0xe80934a2}},	//   _sääs, isto, sihr, वस्थ_, 
   {{0xdbd706d6,0x442534a3,0xfd9602a1,0x644134a4}},	//   _pääs, yil_, _בדרך_, yoli, 
   {{0x442506d0,0x2ca934a5,0x644134a6,0xb6a534a7}},	//   xil_, mrad_, xoli, викл, 
   {{0x629a00f1,0x25bf34a8,0x442534a9,0x61ed00a3}},	//   jsto, tful_, vil_, _onal, 
   {{0x442534aa,0x78a4003a,0x2d8900f4,0x644134ab}},	//   wil_, šiva, nbae_, woli, 
   {{0x644134ac,0x629a0187,0x6fb200ab,0x25bf34ad}},	//   toli, esto, _जालं, rful_, 
   {{0x61ed34ae,0x69db02ba,0x629a34af,0x2b9c031e}},	//   _anal, _haue, fsto, mácí_, 
   {{0x15b91088,0x442534b0,0x629a34b1,0x2ca9014b}},	//   _жылы_, ril_, gsto, hrad_, 
   {{0x442534b2,0x412a004f,0xdb170068,0xe5e5009c}},	//   sil_, домо_, lexó, _جزئی, 
   {{0x442534b3,0x66060019,0x224234b4,0x69db0380}},	//   pil_, ökke, rokk_, _maue, 
   {{0x7fd5004e,0x64a20f5a,0x442534b5,0x2ca934b6}},	//   лісі, _таша, qil_, drad_, 
   {{0xa06734b7,0x629a34b8,0x7db634b9,0x539a00d1}},	//   тара_, csto, ксац, _חיצו, 
   {{0x645801ee,0xf1bf033c,0x657b00e2,0x69db087d}},	//   _zhvi, lián_, ncuh, _naue, 
   {{0x2ca9265d,0xdc6a058e,0xdd8f0740,0x38bb010c}},	// [26c0] grad_, даад_, زول_, jêr_, 
   {{0x61ed34ba,0x628607c7,0x81ce0033,0x38bb010c}},	//   _znal, ćkov, রাও_, dêr_, 
   {{0x69db01c4,0x61ff01ff,0x93bc020f,0xbf9b2737}},	//   _baue, _yoql, onăr, _קיטש, 
   {{0x3ced015e,0x69db3216,0x2ca900b0,0x38bb03c6}},	//   _ševe_, _caue, brad_, fêr_, 
   {{0x69db25e6,0xa96734bb,0xd7fa00b3,0x629a34bc}},	//   _daue, вица_, дуй_, zsto, 
   {{0xbcfb006b,0x25da1687,0x629a34bd,0xdb210032}},	//   _egés, _खोजी_, ysto, štát, 
   {{0x48ee006a,0x59dd34be,0x5b3500b3,0xf1bf0098}},	//   _आपको_, _नोकर, _бэту, onát_, 
   {{0x7bdc34bf,0xe5c634c0,0x3f9834c1,0x765934c2}},	//   _haru, тско, haru_, _chwy, 
   {{0x260334c3,0x7bdc34c4,0x629a34c5,0x3f9834c6}},	//   _años_, _karu, wsto, karu_, 
   {{0x7bdc0096,0x629a34c7,0x7bde000b,0x61ed0704}},	//   _jaru, tsto, ndpu, _snal, 
   {{0x7bdc34c8,0x81dc0086,0x629a34c9,0xa19534ca}},	//   _maru, ঠান_, usto, ланч, 
   {{0x7bdc34cb,0x3f9334cc,0xa526227f,0xe8df0108}},	//   _laru, _sexu_, _имед, _uyển_, 
   {{0xf1bf070b,0x629a34cd,0x68e202fe,0x3f9834ce}},	//   bián_, ssto, nvod, faru_, 
   {{0x629a050f,0xf1bf0183,0xb4be03ce,0x7bde02ae}},	//   psto, cián_, ँझी_, jdpu, 
   {{0x5f9434cf,0x81ce0033,0xbcfb0a13,0x260301d6}},	//   рист, রাজ_, _ngér, _iñor_, 
   {{0x61ed34d0,0x7bdc34d1,0x2ca902e5,0xdb050f96}},	//   _unal, _aaru, trad_, nghå, 
   {{0x7bdc34d2,0x68e2265d,0x5d550665,0xe3900023}},	// [26d0] _baru, jvod, укат, _điề, 
   {{0x600b0824,0x7bdc34d3,0x69db34d4,0x2ca934d5}},	//   _mümk, _caru, _saue, rrad_, 
   {{0xba740038,0x69db34d6,0xb4ce00aa,0x38bb010c}},	//   لانت, _paue, शबु_, wêr_, 
   {{0xc3330056,0xb05b074b,0x60100219,0x2ca90228}},	//   בוע_, städ, _jämn, prad_, 
   {{0x7bdc34d7,0x76590156,0x80d934d8,0x07a51d75}},	//   _faru, _rhwy, मिटे, галн, 
   {{0x60100750,0x7bdc34d9,0xf1bf0068,0x38bb08b0}},	//   _lämn, _garu, xián_, rêr_, 
   {{0x8cdb09e5,0x20010508,0xf1bf0183,0x60020379}},	//   निको, _mohi_, vián_, _mômp, 
   {{0x7bdc34da,0x6010014e,0xb4ce00a5,0x24590212}},	//   _zaru, _nämn, शबू_, ième_, 
   {{0x291934db,0x7bdc34dc,0x58d434dd,0x24590151}},	//   _åsa_, _yaru, _котт, hème_, 
   {{0x7bdc1c6e,0x6b95003a,0x22490938,0xa2a407d5}},	//   _xaru, _jezg, _akak_, _किश्, 
   {{0x3f9834de,0xf1bf34df,0x6b9534e0,0xa22a26f1}},	//   varu_, rián_, _mezg, ежна_, 
   {{0x6b950216,0x3f9834e1,0x34951d06,0x7999236e}},	//   _lezg, waru_, _бадр, naww, 
   {{0x64a534e2,0x93bc020f,0x425500b3,0xdb1c00e1}},	//   _сала, rnăr, ртэт, _mbrá, 
   {{0x70562e10,0x2a6d0380,0xdb150151,0x00000000}},	//   انسا, _lieb_, _eczé, --, 
   {{0xc05a032e,0xdb1c08d7,0x6da61d52,0x7bdc002c}},	//   дің_, _obrá, лива, _raru, 
   {{0x7bdc34e3,0x2bc6072f,0x394d0126,0x628300ca}},	//   _saru, र्ना, _oyes_, _itno, 
   {{0x1bea03dc,0x3f9834e4,0x629c253f,0x229802d9}},	// [26e0] ндаи_, paru_, árov, _týká_, 
   {{0x2013016a,0xb05b00c8,0xdb1c0354,0xd0f700d1}},	//   _glxi_, ttäe, _abrá, _עמית_, 
   {{0x7bdc34e5,0x81d70086,0x6b95020f,0x09e60650}},	//   _varu, সার_, _dezg, ложн, 
   {{0x7bdc34e6,0xe98434e7,0xe9470274,0x02b60070}},	//   _waru, рқан, گرمی, טלעך_, 
   {{0x69261b17,0x7bdc34e8,0xa3b300a2,0xfaa30e65}},	//   ымда, _taru, टला_, _қато, 
   {{0xd6da152e,0xa2a400a2,0xbddb00d7,0x78a4015e}},	//   ети_, _किल्, _akèh, šivo, 
   {{0x5fb20081,0x96f800d3,0xfd500023,0x394d00d1}},	//   _जाईल, тейт_, _nghẹ, _eyes_, 
   {{0xa5bd0009,0x00000000,0x00000000,0x00000000}},	//   liųj, --, --, --, 
   {{0x27ef000d,0x201829c6,0x75fc039f,0x00000000}},	//   ální_, khri_, _kézz, --, 
   {{0x1cbb0070,0x7a1c0026,0xe7ae009a,0xa5bd0028}},	//   עמיע, pōts, _घाटप, niųj, 
   {{0xa68634e9,0x2bc60e6e,0xfbc60cb8,0xe9ff00e7}},	//   _след, र्या, र्यम, _chặn_, 
   {{0x54e60e61,0xf1bf34ea,0xdb050380,0xa2d524d4}},	//   _مستق, ciál_, pfhö, _बनर्, 
   {{0x93e600a3,0x75d30038,0xbcfb0096,0x00000000}},	//   _бўйл, _دينا, _ngép, --, 
   {{0x2bc606ea,0xddd0044e,0x75fc010e,0x60100502}},	//   र्मा, _češk, _nézz, _dämo, 
   {{0x20010054,0xe1ff010e,0x6b9534eb,0x00000000}},	//   _vohi_, tmód_, _rezg, --, 
   {{0x66020077,0x628802a3,0x6b9534ec,0xfc240033}},	//   _jook, mpdo, _sezg, বকোষ_, 
   {{0x82340a24,0xfbab1829,0x660207d7,0x200100b0}},	// [26f0] _دروا, етей_, _mook, _tohi_, 
   {{0xbd681c0f,0x660234ed,0x6fb200ab,0x60cd34ee}},	//   урсе_, _look, _जाएं, _ipam, 
   {{0xdddc090e,0x49750c09,0xf09f00b9,0x625d0175}},	//   sprš, алес, lsà_, géog, 
   {{0xfde90fcf,0x660202a5,0x2bc61503,0x394d34ef}},	//   _ऑफिस_, _nook, र्बा, _pyes_, 
   {{0x26cc0102,0x02d1176d,0x200c02ae,0x6b9534f0}},	//   _apdo_, _तन्न, ödig_, _tezg, 
   {{0x60cd34f1,0x601034f2,0x799934f3,0xd70502f1}},	//   _mpam, _näml, saww, изли, 
   {{0x660234f4,0xe57100eb,0xc98702f1,0x00000000}},	//   _book, يطة_, _бузи, --, 
   {{0x7aea01cc,0x60cd34f5,0x660234f6,0x79990065}},	//   æfte, _opam, _cook, qaww, 
   {{0xf1bf0076,0xc7d90093,0x628808b0,0x6602138c}},	//   riál_, _имах_, epdo, _dook, 
   {{0x68e901f2,0x291d095a,0x4ac90110,0x72c534f7}},	//   _ired, mzwa_, _रहाव, абоз, 
   {{0xfbd200a7,0x60cd34f8,0x244b34f9,0x85b9049b}},	//   חתי_, _apam, dømt_, _алес_, 
   {{0x0166307f,0x998f0009,0xb34500f6,0x660201b8}},	//   икно, mogų_, _alçà, _gook, 
   {{0xe0d70141,0x201802cd,0x291d34fa,0xf1bf0032}},	//   авя_, thri_, nzwa_, ciám_, 
   {{0x6e260065,0x6602052b,0x68e9023e,0x7bc501d2}},	//   _smkb, _zook, _mred, jfhu, 
   {{0x44d60da6,0x249f01d5,0x2d9634fb,0x9e66011c}},	//   _zł_, lsum_, ирас, لارن, 
   {{0x0d8634fc,0xed5a03ea,0x3ced015e,0x7e6f0369}},	//   рлан, воб_, _ševa_, _cicp, 
   {{0x8fa634fd,0x249f34fe,0x601034ff,0x5ba40259}},	// [2700] _капе, nsum_, _hämm, йлағ, 
   {{0x69c90298,0x515b00d1,0x60103500,0x00000000}},	//   _abee, _בכפו, _kämm, --, 
   {{0xf1eb0f63,0xdef90904,0xf778003d,0x69c901b8}},	//   _जोड़_, _быў_, _naħa_, _bbee, 
   {{0x68e90c17,0xb05b014e,0x249f02cd,0xda6500eb}},	//   _bred, ptäc, ksum_, ماني, 
   {{0x68e92c07,0x66023501,0x60100088,0x80c40086}},	//   _cred, _rook, _lämm, শিক্, 
   {{0xb8ce3502,0x44273503,0x66023504,0x9986253f}},	//   _कि_, _nmn_, _sook, dnoť_, 
   {{0x68e918d0,0xfaa33505,0x7aa318ae,0x2bc605d0}},	//   _ered, _маро, _мирз, र्णा, 
   {{0x68e90533,0x2d802479,0x28da0077,0x3e7c031e}},	//   _fred, ncie_, _मैथि, _mít_, 
   {{0x68e93506,0xfbc61f22,0x3e7c3507,0x2bc60425}},	//   _gred, र्थम, _lít_, र्था, 
   {{0x5fb20081,0xe3b80fc1,0x66020110,0x44270e34}},	//   _जागल, lnız_, _wook, _cmn_, 
   {{0x2d803508,0x68e900f9,0x660200c2,0x3e7c0108}},	//   kcie_, _zred, _took, _nít_, 
   {{0x2bc60c64,0x2ca00077,0x2d800035,0xe4e6004f}},	//   र्ता, ksid_, jcie_, _вікн, 
   {{0x601002ae,0x44273509,0x25a6015c,0x00000000}},	//   _täml, _fmn_, _idol_, --, 
   {{0x44270110,0x2d8000ab,0x24860008,0x2ca000b0}},	//   _gmn_, ecie_, _itom_, dsid_, 
   {{0x6448350a,0xf09f350b,0x442c350c,0x6d4f03c6}},	//   modi, ssà_, mid_, _syca, 
   {{0xfe7700d3,0xef190035,0x131700d1,0x5187350d}},	//   лүү_, ąż_, _כחול_, _тука, 
   {{0x60cd350e,0x442c350f,0xddc40243,0x00000000}},	// [2710] _upam, oid_, kliņ, --, 
   {{0x64483510,0x442c3511,0x46a70366,0x7e770126}},	//   nodi, nid_, _गिलह, _tuxp, 
   {{0x2bc63512,0x25a63513,0x7e6401e5,0x2ca001a4}},	//   र्धा, _odol_, bmip, asid_, 
   {{0x68e93514,0x2d8002a3,0x7e64023e,0x00000000}},	//   _pred, ccie_, cmip, --, 
   {{0x442c3515,0x2ca03516,0xb9c400eb,0x2486006d}},	//   kid_, csid_, تقني, _ntom_, 
   {{0x68e93517,0x6e2d3518,0xe7393519,0xc7c7286c}},	//   _vred, liab, лел_, рсди, 
   {{0x2486351a,0x7d0d351b,0x2d99351c,0x68e9351d}},	//   _atom_, lyas, _kese_, _wred, 
   {{0x249f050a,0x68e90dcb,0x442c351e,0xdb160038}},	//   tsum_, _tred, eid_, _ócái, 
   {{0x2d99351f,0x7d0d3520,0x442c3521,0x39150200}},	//   _mese_, nyas, fid_, _умар, 
   {{0x6e2d3522,0x249f3523,0x2d993524,0xf8ae00d4}},	//   hiab, rsum_, _lese_, _سکه_, 
   {{0x249f3525,0x8c1a00a7,0x2d800035,0x2486011c}},	//   ssum_, רותי, ycie_, _etom_, 
   {{0x2d993526,0x442c3527,0x28ae031e,0xc8790241}},	//   _nese_, aid_, _घिमि, _kuş_, 
   {{0xddc6090b,0x44270ab1,0x442c3528,0x661b0548}},	//   _nikš, _tmn_, bid_, mhuk, 
   {{0x7d0d13ef,0x60100080,0x3e7c3529,0x6448352a}},	//   dyas, _tämm, _pít_, codi, 
   {{0x2d99352b,0x81bf00cc,0xddc6012d,0x81cd0086}},	//   _bese_, ীয়_, _aikš, রয়_, 
   {{0x2d990634,0x2ca0352c,0xdb170165,0xf2d200c7}},	//   _cese_, tsid_, nexõ, _זעה_, 
   {{0x2d99352d,0x7fd61222,0x2d80352e,0x7d0d0019}},	// [2720] _dese_, _ліні, rcie_, gyas, 
   {{0xe7e700b0,0x80ad0c64,0x78a40098,0x2ca0352f}},	//   _टोला_, _जिते, šivk, rsid_, 
   {{0x2ca000b0,0x661b3530,0xb5fd00ef,0x6e2d08f9}},	//   ssid_, khuk, zmša, biab, 
   {{0x442c2836,0x6e2d3531,0x753d0035,0x2d990876}},	//   zid_, ciab, ższy, _gese_, 
   {{0xdb1e0019,0xe3b8027e,0x28f83532,0x91bb00d1}},	//   lepü, ygı_, рель_, רמני, 
   {{0xf09300d1,0xc8793533,0x00000000,0x00000000}},	//   לנד_, _duş_, --, --, 
   {{0x24863534,0x09e6338e,0x07a31221,0x2d993535}},	//   _stom_, _ловн, чајн, _yese_, 
   {{0x442c3536,0xd5ba2ffb,0x3f9a07c7,0xf1bf010e}},	//   wid_, уск_, _lepu_, riák_, 
   {{0x38cb11b7,0xa3b300a2,0x693400d7,0x00000000}},	//   _مالی_, टलं_, _بکار, --, 
   {{0x3e41012d,0x6e2d2264,0x2a6602aa,0x79820035}},	//   mėte_, ziab, lmob_, lcow, 
   {{0x442c3537,0x64483538,0x95ca00dd,0x4bfb035c}},	//   rid_, rodi, _була_, אליס, 
   {{0x64483539,0x442c05d2,0x661b086d,0xdb1e0035}},	//   sodi, sid_, chuk, lepó, 
   {{0x2486353a,0x2d9902a3,0x6b9e1b10,0x442c353b}},	//   _utom_, _rese_, kapg, pid_, 
   {{0x3f9a353c,0x7d0d353d,0x442c008a,0x09cc0033}},	//   _cepu_, vyas, qid_, _রোমা, 
   {{0x2d99353e,0x877b02a1,0x59c8047c,0x5333324f}},	//   _pese_, ראלי, रभार, _нешт, 
   {{0x7d0d353f,0x313500f0,0x3eac3540,0x2d99021e}},	//   tyas, _мейр, ádta_, _qese_, 
   {{0x2d993541,0x6e2d3542,0x443c09c7,0xdb993543}},	// [2730] _vese_, riab, _kjv_, ивач_, 
   {{0x224b3544,0x6e2d050a,0x7d0d3545,0x2d993546}},	//   lock_, siab, ryas, _wese_, 
   {{0x7d0d3547,0x2d993548,0x6a73008a,0x78a20098}},	//   syas, _tese_, _aħfr, esov, 
   {{0x224b0118,0x443c0242,0xddc601dd,0xbf05017d}},	//   nock_, _ljv_, _tikš, रहीन_, 
   {{0x26de01cf,0x2bc602e6,0x6e3d3549,0x7d0d354a}},	//   _asto_, र्हा, _ijsb, qyas, 
   {{0x1869354b,0x6d5d01dd,0x09a2010c,0x00000000}},	//   шали_, _izsa, _çînî_, --, 
   {{0x661b354c,0xb05b0088,0x2a66023b,0xe3ae0033}},	//   thuk, ytän, bmob_, কভাব, 
   {{0xc485354d,0x7bd7354e,0x9a840104,0x0609354f}},	//   олик, lexu, _хурл, рник_, 
   {{0x2bc61280,0x26de0f46,0xe3b11966,0xe61600dd}},	//   र्वा, _esto_, ورد_, ідь_, 
   {{0x661b3550,0x42c901a2,0x799b0326,0x7bd73551}},	//   shuk, агон_, _heuw, nexu, 
   {{0xb05b0088,0xd7f8001b,0x26de0102,0x661b0532}},	//   ttän, _khăn_, _gsto_, phuk, 
   {{0xb6860019,0x00000000,0x00000000,0x00000000}},	//   _بھول_, --, --, --, 
   {{0x03a533d4,0xb05b08b5,0x53a53552,0x799b0096}},	//   _дило, rtän, _далб, _meuw, 
   {{0xb05b3553,0x799b20ca,0x00000000,0x00000000}},	//   stän, _leuw, --, --, 
   {{0xdee33335,0x3f6a07d9,0x248d02aa,0x7bd70474}},	//   мори, риво_, lpem_, dexu, 
   {{0x224b192d,0xe1ff0634,0xd7f80023,0x799b3554}},	//   cock_, lmón_, _nhăn_, _neuw, 
   {{0xad6600c5,0x3f9a3555,0x8f760451,0x248d0065}},	// [2740] زاره, _tepu_, _муні, npem_, 
   {{0x61e63556,0x80d70035,0xb05b00c8,0x60c401f2}},	//   ldkl, यबरे, ntäl, _iqim, 
   {{0x61e40268,0x799b0149,0xfe460e9a,0x00000000}},	//   _kail, _beuw, _мноо, --, 
   {{0xd7f800e7,0x8884004e,0xdcfd0009,0x78a23557}},	//   _chăn_, зғал, _nesė, tsov, 
   {{0xe8943558,0x68463559,0x2d92355a,0x63ba02c9}},	//   чаль, онда, mbye_, ygtn, 
   {{0x76aa17ef,0xacd90137,0x2cb202bf,0x78a2355b}},	//   атив_, _פֿרי, mryd_, rsov, 
   {{0xa01b00c8,0x26de0036,0x7bce00a4,0x00000000}},	//   mpöt, _qsto_, _ibbu, --, 
   {{0x78ad03ef,0x6b9c355c,0x2bc60a68,0x2bd800a5}},	//   šava, _herg, र्रा, ड़वा, 
   {{0x07a60161,0x6b9c007e,0x7aee008b,0xdb070118}},	//   _маан, _kerg, _hrbt, _adjè, 
   {{0x136a355d,0x3eb800e5,0x6b9c355e,0x61f60054}},	//   ишни_, kurt_, _jerg, _anyl, 
   {{0x61e4355f,0x26de0372,0x6b9c3560,0x4b7b0070}},	//   _bail, _usto_, _merg, יטיג, 
   {{0x61e43561,0x201a3562,0x6b9c3563,0x00000000}},	//   _cail, _alpi_, _lerg, --, 
   {{0x660f00a8,0x61e43564,0x6b9c017c,0x7bce02a5}},	//   öcke, _dail, _oerg, _obbu, 
   {{0xcbd500cc,0x3eb83565,0x6b9c3566,0x104b18ec}},	//   _হচ্ছ, furt_, _nerg, рями_, 
   {{0x61e41974,0x93cb0019,0x3ea5010e,0x3eb80c2e}},	//   _fail, _خانہ_, élt_, gurt_, 
   {{0x3ead08fc,0x61e43567,0x7bce003d,0x2cb200f8}},	//   čet_, _gail, _abbu, fryd_, 
   {{0x6b9c3568,0xc05b02fb,0x40353569,0x6fb60444}},	// [2750] _berg, _він_, _неис, _کمپا, 
   {{0xa2a40e49,0x6b9c356a,0x61e40a9f,0x3eb80380}},	//   _किञ्, _cerg, _zail, burt_, 
   {{0x23c2000f,0x6b9c356b,0x0a6b0e65,0xb05b00c8}},	//   _शानद, _derg, арди_, ntäm, 
   {{0x6b9c10f3,0x69c00118,0x248d0183,0x2cb200f8}},	//   _eerg, _ccme, ypem_, bryd_, 
   {{0x6b9c356c,0x6d5d00ec,0xd945356d,0x00000000}},	//   _ferg, _uzsa, џели, --, 
   {{0x3abb09e8,0x6b9c356e,0xa6951b11,0x66e502f1}},	//   _پاسخ_, _gerg, приј, зока, 
   {{0x1995356f,0x9f410096,0x09c20033,0x799b0175}},	//   _навя, _bahé_, োয়া, _teuw, 
   {{0x6b9c0a9f,0xd6ce00eb,0xbcfb3570,0x6b8500f8}},	//   _zerg, اقي_, _izéb, lchg, 
   {{0x69d93571,0x6d4301c4,0x6b9c00a3,0x3a2d00b9}},	//   mewe, ßnah, _yerg, _imep_, 
   {{0x69d93572,0x94223573,0x6b9c0183,0x69cb3574}},	//   lewe, емье, _xerg, lfge, 
   {{0x81e500cc,0xef2000ab,0xb05b0219,0x3209023a}},	//   নান_, ążki_, rtäl, _boay_, 
   {{0xb05b0750,0x61463575,0x69d93576,0x00000000}},	//   stäl, зема, newe, --, 
   {{0xd175001c,0x61e608b0,0x61e43577,0xf99200d1}},	//   дыры, rdkl, _vail, ערך_, 
   {{0x61e4044d,0xb4d7042b,0xe3b3009c,0xa06a1e38}},	//   _wail, ाबी_, _آرش_, сага_, 
   {{0x61e43578,0x6aba00bc,0x00000000,0x00000000}},	//   _tail, _उमेर, --, --, 
   {{0x2cb2018c,0x69d901d2,0xac863579,0xbc760038}},	//   tryd_, jewe, згал, كهرب, 
   {{0x6b9c357a,0x69d9357b,0x5baa0235,0x3eb8357c}},	// [2760] _perg, dewe, йкам_, surt_, 
   {{0xdce600e0,0xef1a0267,0x27e5040b,0x3eb8357d}},	//   _iekļ, _гмо_, _naln_, purt_, 
   {{0x6b9c357e,0x9f9700a7,0x2cb202ae,0x69d9019b}},	//   _verg, _מדיה_, sryd_, fewe, 
   {{0x6b9c15fb,0x69d90bf3,0xe8fa2eb8,0x63a1357f}},	//   _werg, gewe, йле_, haln, 
   {{0x6b9c3580,0xc5c30086,0x3a3f05a1,0xb4ca00b0}},	//   _terg, ্যাপ, _djup_, _ऊहे_, 
   {{0xfaa63581,0xac0a00cf,0xb05b00c8,0x7e7e3582}},	//   _наго, _унга_, ytäm, _kupp, 
   {{0x8c1b00a7,0x7c2e3583,0x69d93584,0xbb4300c8}},	//   _פולי, _imbr, bewe, _зерк, 
   {{0x44f41033,0xbb3b042c,0x09e33585,0xd5e20108}},	//   дпис, _העלי, _посн, _khỏ, 
   {{0x63a1090e,0x81e50086,0x7e7e19b1,0x32090574}},	//   faln, নাম_, _lupp, _roay_, 
   {{0xd48f0ecf,0xb05b030f,0x2281003e,0x32090db4}},	//   _үр_, ttäm, _bók_, _soay_, 
   {{0x31603586,0xe1d902fb,0xd5af1918,0x95ca0504}},	//   _aziz_, одні_, _пс_, _глеб_, 
   {{0xa1940965,0x250b0274,0x63a100b0,0xb05b00c8}},	//   наюч, _گرمی_, aaln, rtäm, 
   {{0xd6250084,0xf1a40009,0xb05b3587,0x0cd70086}},	//   _تعلي, эрэн, stäm, _সপ্ত, 
   {{0x63a13588,0xb4e802e6,0x3e410028,0x00000000}},	//   caln, मटी_, dėta_, --, 
   {{0x628a33fc,0x316012ed,0xddab0ecf,0x69d90548}},	//   _utfo, _eziz_, йтал_, yewe, 
   {{0x433b00d1,0xd25117bc,0x7e7e0657,0x66e73589}},	//   _לעוב, _جنب_, _dupp, léká, 
   {{0x442e0379,0x69d9358a,0xb05b358b,0x5d550115}},	// [2770] _kmf_, vewe, ntäk, фкат, 
   {{0x7055009c,0x69d9358c,0xf77800c3,0xaded00b0}},	//   _زنجا, wewe, _daħk_, _चोरन_, 
   {{0x69d90218,0x442e032f,0x34d9000d,0xd7f8001b}},	//   tewe, _mmf_, _भन्द, _chăm_, 
   {{0x63a1358d,0xf1bf358e,0x7c2e358f,0x6b850380}},	//   zaln, ngá_, _embr, schg, 
   {{0x37e53590,0x7e7e01d8,0x69cb34c7,0x7c2e039b}},	//   долг, _zupp, rfge, _fmbr, 
   {{0x69d90727,0xacfa00a7,0x78ad032f,0x9be43591}},	//   sewe, _והשכ, šavo, _піск, 
   {{0x63a111c8,0xb05b0088,0x69d93592,0xb7c80038}},	//   valn, ttäj, pewe, سبوك_, 
   {{0x6010022b,0x26c70688,0x63a10035,0x00000000}},	//   _hämt, rtno_, waln, --, 
   {{0xe8ff010c,0x26c702ee,0xf2b60033,0xb4d700c9}},	//   _çû_, stno_, _জনগণ, ाबे_, 
   {{0x60100219,0x52a9268e,0xb05b00c8,0x26c70242}},	//   _jämt, овом_, stäj, ptno_, 
   {{0x387f17ab,0x56940886,0xfbcf048e,0x04ef0033}},	//   _huur_, _захт, स्यम, য়নের_, 
   {{0x63a13593,0x387f3594,0x600b00c2,0x15151761}},	//   saln, _kuur_, _sümp, _одея, 
   {{0x7e7e3595,0x63a13596,0xe44e3597,0xa5bd012d}},	//   _supp, paln, _аж_, siųs, 
   {{0x2281008c,0x387f0318,0x7e7e3598,0x2bcf1f9a}},	//   _tók_, _muur_, _pupp, स्मा, 
   {{0x41c60035,0x79893599,0x387f0175,0x93450afc}},	//   _वापस, _ofew, _luur_, _юнке, 
   {{0x25bf359a,0x625d011c,0x8e550259,0x00000000}},	//   ngul_, néol, етуі, --, 
   {{0xdca3359b,0xed5703b7,0x387f095a,0x7e7e359c}},	// [2780] кати, дот_, _nuur_, _wupp, 
   {{0x7e7e359d,0x8d6300c8,0x4d63004f,0xbcfb039f}},	//   _tupp, твуе, ткув, _széc, 
   {{0x78a9048a,0x78ad1c2b,0x0e661c45,0xb9e600dd}},	//   _avev, šavl, _окон, діли, 
   {{0xd3780112,0x387f359e,0x81e50033,0xb05b0080}},	//   meće_, _buur_, নাথ_, ytäk, 
   {{0xd37811b1,0x02da0497,0x41c60249,0xb4d700c9}},	//   leće_, _बन्न, _वानस, ाबो_, 
   {{0x387f0318,0xd7f8001b,0x368a004f,0x6d4600c3}},	//   _duur_, _thăm_, осин_, _ixka, 
   {{0x6a830a31,0xd37807c7,0x81e50033,0xd5ba359f}},	//   _алса, neće_, নাত_, осп_, 
   {{0x973c02f5,0x3ced00ca,0xd5b0010e,0xd6d9017b}},	//   _neće, _ševi_, اہش_, яті_, 
   {{0xe3ce0029,0x47c60886,0x6010161f,0x442e35a0}},	//   _dựng_, _обав, _jäms, _pmf_, 
   {{0x78630a10,0x25bf020f,0x7c3e35a1,0x3cfb0225}},	//   _акуз, agul_, nnpr, קלינ, 
   {{0x0bb70056,0xd37822ad,0x225900c8,0xe2f8004f}},	//   ולים_, jeće_, зины_, чені_, 
   {{0xd37802f5,0x442e0920,0x26180175,0x00000000}},	//   deće_, _wmf_, _kéom_, --, 
   {{0xf1bf0126,0x00000000,0x00000000,0x00000000}},	//   rgá_, --, --, --, 
   {{0xdb1c35a2,0x656202f1,0x442e35a3,0x7c3e01d2}},	//   _acrí, _izoh, _umf_, jnpr, 
   {{0xe6dc35a4,0x768701f0,0x660b006d,0x443e35a5}},	//   _मनोज, _kıya, _yogk, mnt_, 
   {{0x645a02bf,0xf1d0001b,0x601001c4,0x7c3e00b4}},	//   llti, _hạng_, _sämt, enpr, 
   {{0x443e01c5,0x2d5809e7,0xf4bc0086,0x9cc800c8}},	// [2790] ont_, дить_, _অনুব, дыха_, 
   {{0x443e35a6,0xdefb35a7,0x3dc0011d,0x2bbb0038}},	//   nnt_, _дым_, agiw_, تارة_, 
   {{0x443e35a8,0xf1d00029,0x387f007e,0x645a35a9}},	//   int_, _mạng_, _suur_, ilti, 
   {{0x443e02f2,0x321935aa,0xdb1c0038,0x387f35ab}},	//   hnt_, nksy_, _gcrí, _puur_, 
   {{0x7e6d35ac,0x625d0151,0xa3be35ad,0x497400d7}},	//   mmap, véol, इला_, ندهآ, 
   {{0xb9070d95,0xd36620b4,0x81d30086,0x7e6d35ae}},	//   _बन_, _مه_, _হোম_, lmap, 
   {{0x7ac418b6,0x2aa8020f,0x6562016c,0x443e35af}},	//   _исте, _отто_, _azoh, dnt_, 
   {{0x443e35b0,0xceb42aa8,0x387f35b1,0xb05b14aa}},	//   ent_, דיק_, _tuur_, stäh, 
   {{0x2bcf2290,0x2ca91041,0xa9542e02,0x25bf35b2}},	//   स्था, nsad_, _акті, rgul_, 
   {{0xd378003a,0x443e35b3,0x69320019,0x7305122f}},	//   zeće_, gnt_, _حکمر, епоз, 
   {{0xf1d0001b,0x973c00ca,0xc6a41098,0x656201cf}},	//   _dạng_, _peće, _арчи, _ezoh, 
   {{0x2bcf0b79,0x443e35b4,0x2ca935b5,0xfbcf176d}},	//   स्ता, ant_, ksad_, स्तम, 
   {{0x973c04d1,0xa155048a,0xd378034c,0x443e0387}},	//   _veće, върш, veće_, bnt_, 
   {{0xdb1c0084,0x201e35b6,0x62840f4c,0x6606003e}},	//   _scrí, óti_, _čiov, ökkv, 
   {{0xd378265d,0x60100219,0x00000000,0x00000000}},	//   teće_, _säms, --, --, 
   {{0x201835b7,0x7e6d0f3a,0x7c3e35b8,0x2ca902ae}},	//   skri_, gmap, wnpr, fsad_, 
   {{0xd3780112,0x15f20262,0x2b58011c,0xfe4335b9}},	// [27a0] reće_, _अफसर_, _syrc_, унто, 
   {{0xaf9a0088,0x24820228,0xd3781c2b,0x25af1d0b}},	//   _этих_, íkmi_, seće_, _ldgl_, 
   {{0x3f9835ba,0x2bc60f8e,0x7c3e35bb,0xe803296a}},	//   mbru_, र्गा, rnpr, लाना_, 
   {{0xda650038,0x2d9635bc,0x39460080,0x0f370070}},	//   ناني, _ярос, ннег, _טריט_, 
   {{0x443e35bd,0x64431fe0,0x00000000,0x00000000}},	//   ynt_, _ojni, --, --, 
   {{0xb05b030f,0x6e24012b,0x2bc6061f,0xf6e600d9}},	//   ttäi, lhib, र्खा, ецин, 
   {{0x8c4335be,0xd6d735bf,0x765b35c0,0x443e08bb}},	//   _сере, еты_, fluy, vnt_, 
   {{0x443e35c1,0xa3d22ed8,0x2bd800c9,0xfaf700d1}},	//   wnt_, ह्न_, ड़का, _אצלי_, 
   {{0x7d040068,0x290200e5,0x2bc70667,0xd94335c2}},	//   nxis, _çka_, _लामा, _бети, 
   {{0xe8d700a7,0x443e35c3,0x69c210f3,0xb05b08b5}},	//   _אומר_, unt_, lgoe, ltäv, 
   {{0xa19535c4,0x443e35c5,0x7bde040b,0xf1d00210}},	//   канч, rnt_, iepu, _vạng_, 
   {{0x765b15c4,0x2bc70081,0x69c235c6,0xb05b00c8}},	//   cluy, _लाभा, ngoe, ntäv, 
   {{0x6e240010,0x7bde35c7,0xf1d00023,0x6606003e}},	//   dhib, kepu, _tạng_, ökku, 
   {{0xb05b0088,0x6010014e,0xb80335c8,0xe8030035}},	//   htäv, _sämr, लायम_, लाया_, 
   {{0x69c21a77,0xdb1c0534,0x00000000,0x00000000}},	//   kgoe, _mbró, --, --, 
   {{0x6e2435c9,0x09d50086,0x2ca9219b,0x6abe007c}},	//   ghib, _সোনা, tsad_, dupf, 
   {{0xd904125e,0x7e6d35ca,0xe803031e,0x2ca9011d}},	// [27b0] _ای_, rmap, लामा_, usad_, 
   {{0x2ca902fe,0x2bd80035,0x7bde35cb,0x2d890054}},	//   rsad_, ड़गा, gepu, scae_, 
   {{0x2ca935cc,0xa3d22158,0x69c201c8,0x1eab0038}},	//   ssad_, ह्य_, fgoe, _عادي_, 
   {{0x6e2435cd,0x625d0175,0xddc40474,0x00000000}},	//   chib, déok, rmiţ, --, 
   {{0x260417dc,0x601035ce,0x2ca900a3,0x9f5a0237}},	//   वानी_, _kämp, qsad_, _anpè_, 
   {{0x7bde0012,0xec350137,0xa3d200a2,0xe7870531}},	//   cepu, _יאָר_, ह्म_, худо, 
   {{0xf4c200cc,0x765b0241,0x625d0175,0x9985007a}},	//   ্টোব, tluy, géok, _للزو, 
   {{0x601035cf,0x00000000,0x00000000,0x00000000}},	//   _lämp, --, --, --, 
   {{0xe1ff0035,0x9f5a0118,0x5a441099,0x68e2011c}},	//   lmów_, _enpè_, _сэра, cwod, 
   {{0xa93402a0,0x6e240352,0x2496009c,0x28da35d0}},	//   _сеуш, zhib, کنید_, _मैटि, 
   {{0x232935d1,0x2bc635d2,0xfbc60fc0,0x00000000}},	//   фони_, र्टा, र्टम, --, 
   {{0x65951cbe,0x7aea055f,0x22161137,0x80cb0033}},	//   _раду, æfti, тфор, িবন্, 
   {{0x78640379,0xc24335d3,0xbcfb010e,0x661b018e}},	//   lòva, рняк, _szén, mkuk, 
   {{0xc0e31acc,0x00000000,0x00000000,0x00000000}},	//   јорк, --, --, --, 
   {{0x8fa32f2f,0x6e2435d4,0x60100fd4,0xb05b00c8}},	//   расе, thib, _dämp, ytäv, 
   {{0x63a335d5,0x68e202bf,0x7bd501c4,0xfe4335d6}},	//   _henn, ywod, _abzu, ансо, 
   {{0x644135d7,0x7bde35d8,0x6e2435d9,0x628335da}},	// [27c0] onli, tepu, rhib, _huno, 
   {{0x7d040218,0x62830383,0x644135db,0xd378034c}},	//   rxis, _kuno, nnli, leća_, 
   {{0x81e5100b,0x260407d5,0x63a335dc,0xb05b030f}},	//   নার_, वामी_, _menn, ttäv, 
   {{0x63a335dd,0x7bde35de,0x628335df,0x644101c4}},	//   _lenn, sepu, _muno, hnli, 
   {{0xe3a70456,0x69c235e0,0x92cd0086,0x628335e1}},	//   _پر_, rgoe, রিয়_, _luno, 
   {{0x63a335e2,0x64410b32,0xb05b0088,0x8d77010e}},	//   _nenn, jnli, stäv, _جاپا, 
   {{0x29000012,0x973c00d2,0xc5eb0086,0x4ab900d9}},	//   ţia_, _beća, কানা_, _путя_, 
   {{0xd37802a8,0x644135e3,0x661b0c3d,0xbb4335e4}},	//   jeća_, enli, gkuk, _теск, 
   {{0x70dc02f8,0xd37803ef,0x63a335e5,0x6283011d}},	//   यबोल, deća_, _benn, _auno, 
   {{0x63a335e6,0xe7c900ab,0x2bc6031e,0x628335e7}},	//   _cenn, _रायप, र्चा, _buno, 
   {{0x63a3017e,0x62830012,0x427529a7,0x601000c2}},	//   _denn, _cuno, лгос, _rämp, 
   {{0x62831acd,0x644135e8,0x9f410098,0x058335e9}},	//   _duno, anli, _nahá_, _кушм, 
   {{0xc05b02fb,0x63a335ea,0xa3d400d3,0xe7c91779}},	//   дів_, _fenn, _болч, _रामप, 
   {{0x63a335eb,0x442535ec,0xe44f0296,0x628300b4}},	//   _genn, chl_, _وضو_, _funo, 
   {{0x628335ed,0x63a835ee,0x645800e0,0x9f4135ef}},	//   _guno, madn, _ikvi, _bahá_, 
   {{0x78ad003a,0x337700a7,0xf365004f,0x2bc62122}},	//   šavi, _בתוך_, _стін, र्घा, 
   {{0x63a30298,0x39490035,0x61ed011d,0xde58004f}},	// [27d0] _yenn, żasz_, _iaal, таті_, 
   {{0x61ed35f0,0xddc435f1,0x27fe016a,0x63a821de}},	//   _haal, rmiš, _nntn_, nadn, 
   {{0x61ed35f2,0xfe6e13b4,0x9be435f3,0x00000000}},	//   _kaal, تگی_, шітк, --, 
   {{0x61ed02a5,0x63a82b70,0xc33300a7,0x3a260102}},	//   _jaal, hadn, סוף_, ghop_, 
   {{0x61ed35f4,0x394900ce,0x660902a8,0x7e7d35f5}},	//   _maal, ças_, vjek, _iisp, 
   {{0xd37800f1,0xa3d22681,0x973c10fc,0xab9400dd}},	//   zeća_, _हॉल_, _seća, _вирі, 
   {{0x63a335f6,0x4ae402f1,0x973c05ae,0x644114a4}},	//   _renn, _кўта, _peća, vnli, 
   {{0x61ed35f7,0x2bcf0865,0x7e7d003d,0x3a2602b0}},	//   _naal, स्रा, _jisp, chop_, 
   {{0x69cc026e,0x7e7d35f8,0x62831ae0,0xd378034c}},	//   ílež, _misp, _suno, veća_, 
   {{0x7bc535f9,0x628335fa,0x660935fb,0x63a835fc}},	//   nghu, _puno, sjek, gadn, 
   {{0x63a335fd,0xc5d502fb,0x61ed0298,0xbcfb0019}},	//   _venn, _біль, _baal, _szél, 
   {{0x63a305f2,0x7e7d35fe,0x260435ff,0x63a800ef}},	//   _wenn, _nisp, वाणी_, aadn, 
   {{0x61ed02b0,0x04c80038,0x63a33600,0xf48402a0}},	//   _daal, _لوني_, _tenn, _кујн, 
   {{0x62833601,0xf7780405,0x34b200d4,0x63a80175}},	//   _tuno, _taħt_, _اموز, cadn, 
   {{0xb05b0003,0x61ed01f0,0x6d5d1240,0x7e7d3602}},	//   kräf, _faal, _aysa, _bisp, 
   {{0xc6920137,0x61ed01a3,0x69c9006f,0xfce63603}},	//   מאל_, _gaal, _ncee, лобо, 
   {{0x4d66012d,0xdd8f0625,0x26043604,0xb05b2693}},	// [27e0] укав, سول_, वाती_, ttät, 
   {{0x69c9002e,0x309b0a33,0x61ed0547,0xab2a183d}},	//   _acee, _רשימ, _zaal, ноза_, 
   {{0x61ed0539,0x68e93605,0xb05b12b7,0x00000000}},	//   _yaal, _ased, rtät, --, 
   {{0xb05b02f2,0x63a8008b,0xebe3004e,0x7e7d00f6}},	//   stät, zadn, _қосп, _gisp, 
   {{0x522d00c7,0x27fe0175,0xd5e20108,0x0936007a}},	//   וואַ, _pntn_, _nhó, دراج, 
   {{0x8a06005e,0xcaa600eb,0x3a263606,0xdd3b0070}},	//   _өзге, _مصري, shop_, _װעלכ, 
   {{0x63a81c76,0x0b593607,0xd5e20108,0x6fd60299}},	//   vadn, _арты_, _phò, म्यू, 
   {{0xd49a03dc,0xa28100ab,0xe4e600dd,0x34b402c0}},	//   нро_, łość_, гіон, абиё, 
   {{0x61ed2764,0x394602a6,0x2ba80662,0xe0070790}},	//   _raal, _снаг, गरपा, शामद_, 
   {{0x03b500f0,0x2507010e,0x00000000,0x00000000}},	//   ақшы_, ارٹی_, --, --, 
   {{0x26040239,0x61ed3608,0xb05b0219,0xcc570070}},	//   वादी_, _paal, ktär, רביי_, 
   {{0x63a81ea3,0x64a63505,0xf8c80e7d,0x2d82002c}},	//   sadn, _бада, _रमाय, _ngke_, 
   {{0x7e7d0851,0x61ed3609,0x68e90065,0xf1bf360a}},	//   _risp, _vaal, _xsed, bhán_, 
   {{0x4394360b,0x61ed360c,0xf1bf0084,0x7e7d06df}},	//   _такс, _waal, chán_, _sisp, 
   {{0x61ed360d,0x7e7d078a,0x3e410009,0x248600c8}},	//   _taal, _pisp, lėti_, _huom_, 
   {{0x92b30fd0,0x95e200aa,0x00000000,0x00000000}},	//   _احوا, _खसोट_, --, --, 
   {{0x7e7d002a,0x3e41012d,0xc047347e,0x00000000}},	// [27f0] _visp, nėti_, _مخدو, --, 
   {{0x25a60156,0xb05b0219,0x6d5d05a8,0x7e7d040b}},	//   _leol_, dräg, _vysa, _wisp, 
   {{0xb05b360e,0x78bc00e0,0x7e7d360f,0xe8030fc0}},	//   träf, _ārva, _tisp, लासा_, 
   {{0x973c0fd3,0x3e41012d,0x2bc7009a,0x2d8200b4}},	//   _pećn, kėti_, _लावा, _ggke_, 
   {{0xe945009c,0x05260033,0xae950108,0x00000000}},	//   جرای, মপুর_, _kẹos, --, 
   {{0x3e4100e4,0x25a9008b,0x973c0097,0x201301d6}},	//   dėti_, _žal_, _većn, _joxi_, 
   {{0xbddb0118,0x00000000,0x00000000,0x00000000}},	//   _skèy, --, --, --, 
   {{0x25a60a92,0x9b5800b3,0x22493610,0x24862a59}},	//   _ceol_, _сист_, _njak_, _buom_, 
   {{0x387e3611,0xf1bf0038,0x68e93612,0x25a60175}},	//   _fitr_, thán_, _used, _deol_, 
   {{0x39143613,0x395f0096,0x893800d9,0x00000000}},	//   _умур, _iyus_, _спус_, --, 
   {{0x2a6d3614,0x69cc000d,0x2a7f00e2,0x63bc008c}},	//   _kheb_, _हामी, _kiub_, órna, 
   {{0xd57530cd,0x2001012b,0x25a63615,0xa4d5004f}},	//   _куль, _anhi_, _geol_, _воді, 
   {{0x64a53616,0xddde107c,0x00000000,0x00000000}},	//   _тала, _lupţ, --, --, 
   {{0xa06a3617,0x8fa33618,0xfaf801dd,0x00000000}},	//   тага_, жаре, _šīm_, --, 
   {{0xdee63619,0x25a60e34,0xb05b00c8,0xbea60cfe}},	//   шови, _yeol_, ttär, рабк, 
   {{0x644f026a,0x2249024a,0x9ac700c3,0x3dd9017c}},	//   écif, _gjak_, _miċħ, _cbsw_, 
  
   {{0x6fd600dd,0xc0e622b0,0xb05b03d8,0xa2a12002}},	// [2800] _кінц, _топк, rtär, कीर्, 
   {{0x2a6d019b,0xb05b1df5,0xef1a361a,0xd00f007a}},	//   _aheb_, stär, _амо_, _يلي_, 
   {{0x395f07fc,0xe6d403ce,0xca7600f0,0x79a602aa}},	//   _ayus_, _दहेज, ауды, арле, 
   {{0xb05b02e7,0xe984004e,0x2efa04ff,0x2a6d361b}},	//   träg, сқан, _irpf_, _cheb_, 
   {{0x2604141c,0x386c0098,0xb05b02ae,0xda65007a}},	//   वासी_, _phdr_, bräd, حالي, 
   {{0xdca319d4,0x25a600eb,0x68431219,0x9856002e}},	//   _фари, _seol_, онча, штеш, 
   {{0x973c0112,0x387e361c,0x00000000,0x00000000}},	//   _većo, _vitr_, --, --, 
   {{0xb05b1091,0x6b63017b,0x387e0210,0x00000000}},	//   präg, _єкта, _witr_, --, 
   {{0x87da040f,0x6f1c00f8,0x81ac0033,0x00000000}},	//   _لباس_, hyrc, খলা_, --, 
   {{0xbcfb0019,0x3e410009,0xa923020b,0x00000000}},	//   _szék, rėti_, úžen, --, 
   {{0x233800e4,0x05ea00b3,0xb6cb010e,0x00000000}},	//   упны_, _афли_, _لانے_, --, 
   {{0xd25800dd,0xd377361d,0x25dd361e,0x3e410028}},	//   иця_, шчы_, _कॉपी_, pėti_, 
   {{0x0494361f,0x660210d4,0x625d0151,0x6abe02eb}},	//   _التح, _inok, déot, hrpf, 
   {{0x251b027a,0x04db0147,0x443a3620,0x2604009a}},	//   _בודא, _סקול, _öp_, वावी_, 
   {{0x6f1c02bf,0xbe883621,0x66023622,0x63670093}},	//   gyrc, исте_, _knok, _кръг_, 
   {{0x30a73623,0xdd983624,0x2249044e,0x9e0403a1}},	//   _кров, ишу_, _ujak_, очул, 
   {{0xb05b014e,0x8bd92971,0x786d02aa,0x629a3625}},	// [2810] träd, лмас_, lúve, lpto, 
   {{0x2bb8007a,0x00000000,0x00000000,0x00000000}},	//   لامة_, --, --, --, 
   {{0x19b93626,0x66021051,0xb05b1df5,0x00000000}},	//   гуль_, _onok, rräd, --, 
   {{0x2a6d023b,0x4975112d,0x660202a5,0x9f43021e}},	//   _qheb_, блес, _nnok, hejë_, 
   {{0x26de2139,0x8cf4012d,0xe803009a,0x26180574}},	//   _apto_, _дзяц, लाला_, _léos_, 
   {{0x66023627,0x1d1600d1,0xb8ff1f22,0x00000000}},	//   _anok, _הקשר_, _तह_, --, 
   {{0x2a7f0640,0x6dbb0083,0x00000000,0x00000000}},	//   _tiub_, ałał, --, --, 
   {{0xb8cd00cc,0x3dc91041,0x26de2016,0x1c0503ce}},	//   _কম_, ngaw_, _dpto_, रावल_, 
   {{0x638302f1,0x81d60033,0xe4590cda,0x629a08a3}},	//   оҳла, _সফল_, лжи_, epto, 
   {{0x981400c5,0x9b440105,0x68fb02ba,0x66023628}},	//   _وبلا, _انہو, _irud, _enok, 
   {{0x68fb014b,0xe7193629,0x26180096,0x00000000}},	//   _hrud, _حيات_, _péot_, --, 
   {{0x68fb362a,0xa44400d3,0x625d0151,0xb40601ff}},	//   _krud, йнөд, déos, _қўчқ, 
   {{0x2604362b,0x291d362c,0x850500d4,0xfbe80218}},	//   वारी_, nywa_, _دوشن, lkêş_, 
   {{0x3cfe00bc,0xc2c8009c,0xe3b80241,0x656b01f2}},	//   _čtv_, دبیل_, lkın_, _izgh, 
   {{0x66f9176c,0xfbcd0033,0x66f7362d,0xd7f10108}},	//   ्मिक_, রজাত, ंटिक_, _mã_, 
   {{0x0d861796,0x68fb1aa9,0xe3b802a4,0x442701d2}},	//   слан, _orud, nkın_, _hln_, 
   {{0x61e6362e,0x6fb100aa,0x0c26362f,0x00000000}},	// [2820] mekl, _जयचं, бман, --, 
   {{0x69db08f4,0x4427286b,0x61e63630,0x3b0a1876}},	//   _abue, _jln_, lekl, лезо_, 
   {{0xfc3f0161,0x6d4f05a4,0x25ad3631,0x60c6105b}},	//   _avís_, _exca, kael_, lukm, 
   {{0x68fb050f,0x80cb00cc,0x61e63632,0xb3460165}},	//   _brud, িবর্, nekl, leçõ, 
   {{0x25ad0156,0xddcd3633,0x656f0228,0x7e643634}},	//   dael_, llaş, ýchl, mlip, 
   {{0xe4470816,0xbc1900f0,0x66022032,0x629a1247}},	//   _رض_, _кісі_, _snok, ypto, 
   {{0xddcd0092,0x61e601f0,0x2604042b,0x00000000}},	//   nlaş, kekl, वाली_, --, 
   {{0x61e60e67,0x7e640c36,0x46a600a3,0x291d0083}},	//   jekl, nlip, _ҳажв, bywa_, 
   {{0xa9260088,0x44273635,0x61e63636,0x998d0082}},	//   _удал, _bln_, dekl, _umeš_, 
   {{0xddcd01f0,0xb346019c,0xe824010e,0xa2b404ac}},	//   klaş, jeçõ, _بذری, обоч, 
   {{0x5c5b00c7,0x2bf700d1,0x7bdc3637,0x04fa0033}},	//   רדיק, זמין_, _mbru, েনের_, 
   {{0xad9b03b7,0x260400a2,0x5b7b035c,0xc0cb3638}},	//   _anún, वाळी_, טריא, луге_, 
   {{0x661d08b5,0x629a0d57,0xdb07021e,0x44273639}},	//   öske, spto, _pejë, _fln_, 
   {{0xa2c01503,0x973c00ca,0x7f94363a,0x70a9017d}},	//   _विप्, _nećk, зарх, _कबील, 
   {{0x443e363b,0x543b00c7,0x7c3e363c,0x644f026a}},	//   mit_, _געגא, dipr, écie, 
   {{0x645a363d,0x7bdc363e,0x61e6363f,0x7e6429b7}},	//   loti, _abru, cekl, glip, 
   {{0x973c2873,0x7bdc00a1,0x64483640,0x443e3641}},	// [2830] _bećk, _bbru, ondi, oit_, 
   {{0x645a3642,0x628a3643,0x7afc016a,0x64483644}},	//   noti, _kufo, _brrt, nndi, 
   {{0x64483645,0x443e0096,0x68fb0242,0xdb6b02be}},	//   indi, iit_, _srud, урал_, 
   {{0x443e3646,0xc1b7109f,0x1df90088,0x7e643647}},	//   hit_, _अयोग, _темы_, clip, 
   {{0x443e3648,0x645a3649,0x65620027,0x89a8017b}},	//   kit_, koti, _nyoh, сків_, 
   {{0x629809c4,0x443e364a,0x63aa010d,0x645a364b}},	//   _otvo, jit_, _nefn, joti, 
   {{0xa3be0fec,0x443e364c,0x645a364d,0x65620495}},	//   ेलन_, dit_, doti, _ayoh, 
   {{0xe619364e,0x6448029d,0x68fb364f,0x6e2d3650}},	//   рди_, endi, _trud, nhab, 
   {{0x4427075a,0x25ad3651,0x645a145e,0x64483652}},	//   _pln_, rael_, foti, fndi, 
   {{0x443e3653,0xddcd213d,0x63aa02bf,0xe705009c}},	//   git_, ylaş, _cefn, _وسای, 
   {{0x63aa02f0,0x27e73654,0x6e2d3655,0xdb1c00eb}},	//   _defn, menn_, khab, _scrú, 
   {{0x69cb031d,0x27e73656,0x60c62546,0x64480010}},	//   ngge, lenn_, tukm, andi, 
   {{0xe3ae3657,0x645a3658,0x61e63659,0xdb070126}},	//   _об_, boti, rekl, _dejé, 
   {{0x442c365a,0x61e6365b,0x645a365c,0x27e7365d}},	//   chd_, sekl, coti, nenn_, 
   {{0xa3d2006a,0x26c7365e,0x61e6365f,0xb34602aa}},	//   _हॉट_, nuno_, pekl, reçõ, 
   {{0x22b500e0,0xddcd0785,0x27e73660,0x76493661}},	//   māk_, rlaş, henn_, nney, 
   {{0x7e640fba,0x22b500e0,0x81d30086,0x27e706df}},	// [2840] rlip, lāk_, _হোক_, kenn_, 
   {{0xebe33662,0x27e73663,0xddcd0e03,0x7e643664}},	//   моуп, jenn_, plaş, slip, 
   {{0x27e705d5,0xd24f0274,0x22b500e0,0x0aea03fd}},	//   denn_, _سنی_, nāk_, рдей_, 
   {{0xe8fa3665,0x443e3666,0x6e2d0364,0xddcd002e}},	//   иле_, zit_, chab, rmaţ, 
   {{0x3ead00f1,0x64483667,0x645a00cf,0x28f83668}},	//   ćete_, yndi, yoti, сель_, 
   {{0x443e3669,0x973c00ef,0x27e700a1,0xfaa6366a}},	//   xit_, _heći, genn_, _маго, 
   {{0xdcf60092,0x26c7366b,0x368703aa,0xe5c6366c}},	//   mayı, guno_, осын_, оспо, 
   {{0xdcf60824,0x443e366d,0x76490102,0x22a7010e}},	//   layı, wit_, gney, dők_, 
   {{0x443e366e,0x629803ef,0x645a366f,0x27e703a0}},	//   tit_, _stvo, toti, benn_, 
   {{0x186a048a,0x47c30ec4,0xd378090b,0x64483670}},	//   _тази_, _обув, leći_, undi, 
   {{0x443e0c2e,0x2bcf0551,0x1bfb00c7,0x26c71e5e}},	//   rit_, स्टा, בליב, cuno_, 
   {{0x443e3671,0x95c715b9,0xd378090b,0xa2c0009a}},	//   sit_, _душа_, neći_, _विठ्, 
   {{0x443e3672,0xda7b0056,0x51843673,0xbcfb0096}},	//   pit_, ינטר, дура, _ayén, 
   {{0x7640012d,0x22b500e0,0xc05b3674,0x443e2e1e}},	//   limy, bāk_, рім_, qit_, 
   {{0x69cb155b,0x6e2d3675,0x973c053d,0x539b042c}},	//   ygge, thab, _beći, _דיוו, 
   {{0x2bdd0a34,0xd3780062,0x27e70237,0x6e24011d}},	//   न्ना, jeći_, zenn_, gkib, 
   {{0xd37802f5,0x6e2d3676,0xacf83677,0x26c700b4}},	// [2850] deći_, rhab, онту_, zuno_, 
   {{0x6e2d3678,0x26c73679,0x1c050262,0xad9b0165}},	//   shab, yuno_, राइल_, _inúm, 
   {{0x2c000081,0xce5902be,0x7649367a,0x7640367b}},	//   राजू_, _ганц_, yney, kimy, 
   {{0x76490216,0x26c70548,0x656f0032,0x7640016c}},	//   xney, vuno_, ýchk, jimy, 
   {{0x8cc20838,0x22b500e0,0x22a70019,0x27e7367c}},	//   _लियो, zāk_, zők_, tenn_, 
   {{0xf807367d,0x26c70156,0x00000000,0x00000000}},	//   ючен, tuno_, --, --, 
   {{0xd3780571,0x27e7367e,0x2a660f3a,0x5ed90033}},	//   beći_, renn_, blob_, ডিকে, 
   {{0x0609367f,0x22a7010e,0x22b50243,0x76400027}},	//   сник_, vők_, vāk_, gimy, 
   {{0x27e73680,0xe4d600eb,0x443c0126,0x76493681}},	//   penn_, كويت_, _bmv_, rney, 
   {{0x22a70019,0x26c71041,0x870700eb,0x22b501dd}},	//   tők_, puno_, _وبال, tāk_, 
   {{0x2bdd0f8e,0xfbdd049c,0x625d0212,0x28f80a10}},	//   न्या, न्यम, téop, _леӂь_, 
   {{0x22b50bc3,0x2c6d3077,0x26f90c06,0xe8030484}},	//   rāk_, _vždy_, ्मीर_, लाका_, 
   {{0x48fe072e,0x22b501dd,0xdcf6035d,0x00000000}},	//   लियो_, sāk_, yayı, --, 
   {{0xd3780d26,0xb4fa0486,0x2bc73682,0x9f4c1fac}},	//   zeći_, _לפני, _लागा, ždí_, 
   {{0x64413683,0x973c034c,0x0e6a00eb,0xf1d402e6}},	//   mili, _peći, مصري_, _थापन, 
   {{0xe1ff1056,0xa2c00b3e,0x79893684,0xddcd00ef}},	//   llón_, _वित्, _ngew, tmaš, 
   {{0x973c02f5,0x52db119b,0xd378090b,0x6e243685}},	// [2860] _veći, _बहुस, veći_, rkib, 
   {{0x6e243686,0xddcd0bfc,0x798902a5,0x61f63687}},	//   skib, rmaš, _agew, _hayl, 
   {{0x61f63688,0xd3780062,0xdcf60540,0x6297033c}},	//   _kayl, teći_, rayı, _éxod, 
   {{0x64413689,0x98a0368a,0x78a9045a,0x2242004f}},	//   hili, šič_, _bwev, nikk_, 
   {{0x6441368b,0x201a368c,0xd37804d1,0x61f6368d}},	//   kili, _kopi_, reći_, _mayl, 
   {{0xd378090b,0x4425368e,0x64410053,0xb05b01c4}},	//   seći_, jkl_, jili, hrän, 
   {{0x6441368f,0xd378090e,0x442500e2,0x443c3690}},	//   dili, peći_, dkl_, _rmv_, 
   {{0xa3d91cc0,0x61f63691,0x64413692,0xfaa61cc1}},	//   ड्स_, _nayl, eili, _маҳо, 
   {{0xbcfb3693,0x76403694,0xe1ff001d,0x786d0032}},	//   _nyél, rimy, flón_, súva, 
   {{0x39490068,0x682f0a1f,0x76403695,0x3a26206b}},	//   úase_, _rødg, simy, lkop_, 
   {{0x644f0518,0x46a305af,0x61f60495,0x224200dd}},	//   écia, _захв, _bayl, fikk_, 
   {{0xb05b022b,0x7ae101c4,0x2242017b,0x3a2608a3}},	//   grän, _älte, gikk_, nkop_, 
   {{0x21672cd7,0x2baf00ab,0xe1ff3696,0x682f0bf7}},	//   ятог, टरमा, blón_, _fødd, 
   {{0x201a00f8,0xe1ff033c,0x80df0033,0xbddb011c}},	//   _copi_, clón_, মিল্, _njèr, 
   {{0x629c063b,0xf1c600a2,0xb05b2162,0x61f632b1}},	//   írod, _वाचन, brän, _fayl, 
   {{0x61f63697,0x00000000,0x00000000,0x00000000}},	//   _gayl, --, --, --, 
   {{0x32092bbb,0xbcfb006b,0x91bc00a7,0xc1bc00a7}},	// [2870] _inay_, _azér, _המחי, _המחש, 
   {{0x682f02c9,0x32090108,0x628602be,0x201a017c}},	//   _køde, _hnay_, _éhor, _gopi_, 
   {{0x682f14a4,0x998900bc,0x61f63698,0xdb0e010c}},	//   _jøde, íkům_, _yayl, _hebê, 
   {{0x682f01cc,0x3a260c36,0x64410961,0x78a90237}},	//   _møde, gkop_, zili, _pwev, 
   {{0xa3be0582,0xbcfb0019,0xd37800d2,0x64413699}},	//   ेला_, _ezér, meću_, yili, 
   {{0xd378032f,0x66e5369a,0xdb0e0216,0x00000000}},	//   leću_, дока, _mebê, --, 
   {{0xe81e190a,0x3209027e,0x6441107d,0x682f1341}},	//   _बकरा_, _onay_, vili, _rødd, 
   {{0xc7440084,0x644102f0,0xdb07031e,0x63a400ef}},	//   عضوي, wili, _její, _đina, 
   {{0x3d000c15,0x8508005e,0x280800bc,0xdb07240a}},	//   रिये_, здың_, átní_, _mejí, 
   {{0x61f6369b,0xe7b513b4,0x3209369c,0x0325369d}},	//   _sayl, _آماد, _anay_, ддон, 
   {{0x61f60749,0xb05b1772,0x3a2d369e,0x1b1f0086}},	//   _payl, trän, _klep_, _যেতে_, 
   {{0x6441369f,0xd378268a,0x2bdd1f22,0xdb0e0165}},	//   sili, jeću_, न्ता, _bebê, 
   {{0x644136a0,0xd37801b4,0xb05b0a52,0x2242004f}},	//   pili, deću_, rrän, rikk_, 
   {{0x682f0c85,0x224200dd,0x232936a1,0xdee600c8}},	//   _føde, sikk_, _моли_, моги, 
   {{0x61f636a2,0xa0670176,0x682f0566,0x00000000}},	//   _tayl, фара_, _kødb, --, 
   {{0x7bc301d5,0x9f4300d8,0x00000000,0x00000000}},	//   ónun, cejí_, --, --, 
   {{0x2240001a,0x201a36a3,0xac8636a4,0xdb0e0ff2}},	// [2880] _imik_, _topi_, дгал, _gebê, 
   {{0x25dd1d95,0x32090054,0x3a2d36a5,0x93bc020f}},	//   क्ती_, _znay_, _alep_, lhăr, 
   {{0x2bdd031e,0x63bc0d68,0x3e4800b3,0x5f46009c}},	//   न्धा, órni, eşte_, _آنجل, 
   {{0xfaf800e0,0x3a2d0175,0x1d0a03dd,0xb9e3017b}},	//   _šīs_, _clep_, _деми_, віши, 
   {{0x2bc736a6,0x249d006d,0x089736a7,0x3a2636a8}},	//   _लाचा, _ntwm_, وضوع_, rkop_, 
   {{0x0ee20a09,0x2bdd21c2,0x68ed0165,0x9f4302d9}},	//   _पहाड, न्दा, çada, zejí_, 
   {{0xdb830a65,0x7c2e0036,0x3a2636a9,0xe8030249}},	//   _агри, _ilbr, pkop_, लाजा_, 
   {{0x26c036aa,0x2487003c,0x44f436ab,0xe5c618b2}},	//   čio_, _ainm_, епис, фско, 
   {{0x83fc056e,0x25af0036,0x682f0453,0x25bd0090}},	//   hođe, _degl_, _søde, _ddwl_, 
   {{0x83fc02a8,0xd378034c,0x224036ac,0x00000000}},	//   kođe, zeću_, _amik_, --, 
   {{0xd6cf0071,0x9726009c,0x78a20242,0x00000000}},	//   _نقل_, _تفاو, lpov, --, 
   {{0xc7b802f5,0x64a636ad,0xd251347e,0x7afa003e}},	//   _dođe_, _жада, انح_, _áttu, 
   {{0xd378090e,0xe803009a,0x7c2e36ae,0x5f940a65}},	//   veću_, लाचा_, _olbr, ӂист, 
   {{0x656f01c4,0xdb0e0218,0x9f4302d9,0x00000000}},	//   üche, _vebê, sejí_, --, 
   {{0x83fc00f1,0xd3780082,0x442e00b4,0x2d8b01fd}},	//   gođe, teću_, _ilf_, _pgce_, 
   {{0x41e71222,0x5c990b58,0x3209012b,0xddc40083}},	//   _ціка, зкая_, _unay_, enił, 
   {{0x5c750088,0x78a22e7d,0xd378090b,0x7bde36af}},	// [2890] елат, jpov, reću_, ffpu, 
   {{0x78a20076,0x83fc04d1,0x9f4c026e,0x6f030183}},	//   dpov, bođe, ždá_, _ánco, 
   {{0xb5fd03f5,0x00000000,0x00000000,0x00000000}},	//   loše, --, --, --, 
   {{0xdb1c26ca,0xd37b0070,0x8c490241,0x2cc40213}},	//   _acró, קראט, _başö, ürdü_, 
   {{0x5d8536b0,0xb5fd00d0,0x682f1341,0x00000000}},	//   _سلسل, noše, _rødb, --, 
   {{0x46f5004f,0x2c050035,0xb05b0080,0x25af36b1}},	//   ечит, राओं_, ttäy, _segl_, 
   {{0xa2c02122,0x7b6436b2,0x661d1cc9,0xf4140033}},	//   _विष्, _атте, ösko, িসার_, 
   {{0x248f0065,0x442e264e,0xbcfb3230,0x3a3f023e}},	//   _pugm_, _alf_, _nyék, _umup_, 
   {{0xb5fd0bad,0xc48502f1,0x26042a48,0xdb1c06df}},	//   joše, нлик, वाजी_, _adrè, 
   {{0xa2c008b3,0xb5fd2467,0x7af50035,0xc7b8044e}},	//   _विश्, doše, _kszt, _pođe_, 
   {{0x31692120,0x25af0b48,0x4374017b,0x33f403a1}},	//   _ayaz_, _tegl_, куют, тчыс, 
   {{0x83fc03ef,0xc7b80d26,0x3495081b,0xe60e0200}},	//   vođe, _vođe_, _задр, _ёд_, 
   {{0x660b182b,0x659402a6,0xb5fd0097,0x2bff00c9}},	//   _ingk, _рачу, goše, ईयां_, 
   {{0x26c70141,0x7af50019,0x95cc0095,0x31690237}},	//   orno_, _oszt, _çərç, _dyaz_, 
   {{0xdee336b3,0xbcfb0019,0x260400a2,0xe29a00e7}},	//   лори, _szép, वाची_, _trưa_, 
   {{0x26120a09,0x83fc0062,0x9f5836b4,0xd7df00b0}},	//   थायी_, rođe, ndré_, प्तच, 
   {{0x61e402ba,0x660b0ab1,0x7af50019,0xed5736b5}},	// [28a0] _ibil, _mngk, _aszt, еот_, 
   {{0x799b02a5,0x660b0175,0x6b560cb4,0xa7fc0241}},	//   _afuw, _lngk, нтех, _akın, 
   {{0x4fd707f5,0xe7c90366,0x7fd70137,0x660b36b6}},	//   _אויב_, _राजप, _אויס_, _ongk, 
   {{0x6ad00035,0x660b011c,0x78a200ca,0xdca6022c}},	//   _हमीर, _nngk, tpov, _пами, 
   {{0x61e4086d,0x67d436b7,0xe984005e,0x2bdd36b8}},	//   _mbil, волу, тқан, न्हा, 
   {{0x660b2e9a,0x25dd1d5b,0x7c2e0243,0xa2c03421}},	//   _angk, क्सी_, _ulbr, _विल्, 
   {{0x61e403ef,0x78a20d26,0x442e0226,0x799b02a5}},	//   _obil, spov, _rlf_, _ffuw, 
   {{0x78a200ca,0x7d090183,0xdb0e05d5,0x442e357d}},	//   ppov, _áesc, _rebè, _slf_, 
   {{0x545436b9,0x69c0008a,0x00000000,0x00000000}},	//   квит, _idme, --, --, 
   {{0x660b15da,0xccf300a7,0x26c736ba,0x88bb00d1}},	//   _engk, רכז_, brno_, _מזמי, 
   {{0x6fd7007e,0xdb0e23fc,0x31690065,0x61e400c3}},	//   _बाबू, _bebé, _syaz_, _bbil, 
   {{0x5ab707f5,0x29040604,0x625d0175,0x00000000}},	//   עלכע_, _krma_, léoz, --, 
   {{0x442e155b,0x64a30b38,0xdb0e033c,0xa4d436bb}},	//   _tlf_, _бача, _debé, _ролі, 
   {{0x61e40149,0xb5fd0688,0xdb07010e,0x63ad14b5}},	//   _ebil, roše, _lejá, _đang, 
   {{0xa3d936bc,0x9e070c16,0xb5fd0d02,0x69c036bd}},	//   _डॉट_, нчал, soše, _odme, 
   {{0xdb0e023e,0x28d136be,0x00000000,0x00000000}},	//   _gebé, _समलि, --, --, 
   {{0xf1bf0483,0x8bc736bf,0x7642045a,0xb05b02ae}},	// [28b0] nkám_, есед, _mmoy, nräk, 
   {{0x69c036c0,0x61e436c1,0x61fd36c2,0xf1bf0032}},	//   _adme, _zbil, ldsl, chár_, 
   {{0x8f3500b3,0xb5fd0372,0xdb07010e,0x66f30248}},	//   _ренц, nošc, _bejá, _təkə, 
   {{0x61fd27d5,0x61ef36c3,0x68ed36c4,0x00000000}},	//   ndsl, necl, çado, --, 
   {{0xd36600c5,0x7e6d36c5,0xdb0704b3,0x61fd36c6}},	//   _چه_, mlap, _dejá, idsl, 
   {{0xd36600c5,0x7e6d36c7,0x2904090e,0x76420532}},	//   _نه_, llap, _drma_, _amoy, 
   {{0x6c540bf8,0x8f9c00c7,0xcc5400fd,0x316c0083}},	//   _скру, ליגי, _свръ, ędzi_, 
   {{0x24992126,0x59d802e6,0x7e6d0019,0x60dd36c8}},	//   ísmo_, _डायर, nlap, ktsm, 
   {{0x9f4a03a1,0x25dd0239,0xe895012d,0x78bb0548}},	//   rebé_, क्षी_, _разь, _uvuv, 
   {{0x7e6d36c9,0x61e402a3,0x195700f0,0x764236ca}},	//   hlap, _sbil, _жағы_, _emoy, 
   {{0x6fdf07d5,0xe6c700eb,0x26dc0377,0x13a708b6}},	//   _पॉइं, _ستاي, ctvo_, ونکی_, 
   {{0x660b1021,0xa69600fe,0x60dd36cb,0x61e4008a}},	//   _ungk, _סכנה_, ftsm, _qbil, 
   {{0x463a0137,0xdb0e009e,0x628e0098,0x7e6d36cc}},	//   _קענע, _nebî, íbor, dlap, 
   {{0x6a782dab,0x25dd2158,0xb5fd00ef,0x701908af}},	//   mífe, क्री_, bošc, ніст_, 
   {{0x998f012d,0x61e436cd,0x644336ce,0x3ea10054}},	//   nigų_, _tbil, _imni, _ctht_, 
   {{0x61e4003a,0xe8d10394,0x7e6d13cd,0xa7fc027e}},	//   _ubil, _समूच, glap, _akıl, 
   {{0x0d8636cf,0xc7b80304,0x6a781c62,0x3e5a02d9}},	// [28c0] тлан, _lođa_, nífe, jďte_, 
   {{0xe0b70cec,0x9f5a0034,0xbbcc00bc,0x00000000}},	//   _שליט_, _japë_, ालेक, --, 
   {{0x3ea61b68,0xe9da36d0,0x3daa0080,0x6fd700aa}},	//   _шинг, дке_, _окно_, _बातू, 
   {{0x98a636d1,0x831a00c7,0x60c90097,0xceb80009}},	//   виде, וועז, šeme, šęs_, 
   {{0x83fc00ef,0xb17b0a1f,0x00000000,0x00000000}},	//   hođa, leår, --, --, 
   {{0x26ce001d,0xf1bf0098,0x6b9c019c,0x913b0225}},	//   tufo_, vkám_, _ufrg, וענק, 
   {{0xddcd00d9,0xd6d700f0,0x27ee00f8,0xcf9300d1}},	//   noaş, вты_, refn_, סטה_, 
   {{0x35f41eb4,0xd49a01a2,0xf1bf0098,0xceb30486}},	//   упир, мро_, tkám_, ביה_, 
   {{0x29040012,0xd9100274,0xba5500fd,0x61ef36d2}},	//   _urma_, _دیش_, _стръ, vecl, 
   {{0x1e1f36a6,0xa84a04f2,0x7e6d36d3,0x7e64045a}},	//   _यक्ष_, _غلام_, zlap, hoip, 
   {{0x83fc0112,0x1db21c54,0x0bb70486,0xf1bf2706}},	//   gođa, जरात, כלים_, skám_, 
   {{0x27e90519,0x76420204,0x60dd0611,0x6443027e}},	//   đane_, _umoy, ttsm, _emni, 
   {{0x6a780183,0x61fd36d4,0x041e0033,0xdb05007a}},	//   cífe, rdsl, যোগী_, rbhé, 
   {{0xdb05003e,0x69b407d5,0xb5fd0243,0x60dd0dd8}},	//   rahú, आरडी, moša, rtsm, 
   {{0x7e6d36d5,0x442c36d6,0x69d300b0,0xf487009c}},	//   tlap, mkd_, _डाली, _شاهی, 
   {{0x2d8f055f,0x64430035,0xfda40267,0x442c0096}},	//   øge_, _zmni, ијум, lkd_, 
   {{0x23b6000f,0x3d0d00ab,0xd7d200b0,0xb5fd00e0}},	// [28d0] _आजाद, समें_, _सांच, noša, 
   {{0x7e6d36d7,0x644836d8,0x628d0054,0xdb0e010c}},	//   slap, nidi, _hiao, _vebî, 
   {{0x68e90141,0xef1400d3,0xe0df02a3,0x6138039f}},	//   _sped, _күрө, ltò_, _túlé, 
   {{0x6e36026e,0xe1ff36d9,0xb5fd01dd,0x2c7402ae}},	//   chyb, ndó_, koša, räda_, 
   {{0x6e2d0053,0xe0df36da,0xb5fd01dd,0x89a8004f}},	//   mkab, ntò_, joša, тків_, 
   {{0xb5fd00e0,0x00000000,0x00000000,0x00000000}},	//   doša, --, --, --, 
   {{0x644836db,0x366936dc,0x81cb0086,0x81b90086}},	//   didi, нако_, র্য_, _চান_, 
   {{0x83fc02f5,0x6e2d36dd,0xc7b8003a,0x64430065}},	//   vođa, nkab, _vođa_, _smni, 
   {{0x644805f0,0x9f4300c8,0x629c03da,0xb5fd0243}},	//   fidi, lejä_, íron, goša, 
   {{0x644836de,0x628d00a1,0x6a780183,0xe5762609}},	//   gidi, _aiao, rífe, ызы_, 
   {{0x6e2d36df,0xe2861f72,0x84580093,0x05130033}},	//   kkab, ллои, ърът_, িনের_, 
   {{0x83fc01b4,0xa0a62ffc,0x628d36e0,0x82361c03}},	//   rođa, ламд, _ciao, اردا, 
   {{0x644836e1,0x7d09090b,0x628d36e2,0xa5c60183}},	//   bidi, _šesn, _diao, spóñ, 
   {{0xddc4031e,0x9f430088,0x9f5a0096,0x661b36e3}},	//   dliš, kejä_, _hapé_, ljuk, 
   {{0x75290019,0xd5b7072f,0x3ebe008c,0xe1ff0126}},	//   lyez, _इजाज, étt_, bdó_, 
   {{0x661b1630,0x6e2d2282,0x81cb0086,0x76490102}},	//   njuk, gkab, র্ব_, niey, 
   {{0x752936e4,0x753b36e5,0xec7a36e6,0x7e640126}},	// [28e0] nyez, nzuz, епа_, roip, 
   {{0x661b14b9,0xbc6a1896,0x1c0e1274,0x00000000}},	//   hjuk, رمان_, साइल_, --, 
   {{0x49ca36e7,0x6e2d04cd,0xae1c00aa,0x7e6436e8}},	//   елен_, bkab, _पचपन_, poip, 
   {{0x644836e9,0xb05b0219,0x9f5a05d5,0xddc40604}},	//   zidi, tsäg, _rapè_, bliš, 
   {{0x28f80c39,0xad9b0187,0x627c0035,0x644836ea}},	//   тель_, _vnút, _głoś, yidi, 
   {{0x7d0436eb,0xb8dc007e,0xb5fd00e0,0xdb150218}},	//   mvis, _आब_, voša, _mezê, 
   {{0xa3d70827,0xddc401dd,0xfaa30477,0xdb150216}},	//   िलन_, rniņ, _гасо, _lezê, 
   {{0xb5fd002a,0xceb300a7,0x644802bf,0xb05b0219}},	//   toša, זיה_, widi, psäg, 
   {{0x81cb00cc,0x7d040533,0x3ce036ec,0x7529010e}},	//   র্ড_, nvis, ntiv_, gyez, 
   {{0xb5fd00e0,0x2a660c3d,0xbddb00b9,0x5c370070}},	//   roša, loob_, _amèl, ָרטן_, 
   {{0xd7930084,0xe2152cee,0xb5fd36ed,0xddc40376}},	//   _المخ, амны, mošn, zliš, 
   {{0xb5fd36ee,0x644836ef,0x2a66050a,0x7d040844}},	//   lošn, sidi, noob_, kvis, 
   {{0x644836f0,0xa2c00f8e,0xe1ff36f1,0xc5f300a7}},	//   pidi, _विक्, rdó_, _לדף_, 
   {{0xb5fd00ef,0xe0df01d8,0x2a66006f,0x682f0453}},	//   nošn, rtò_, hoob_, _nødl, 
   {{0xd9040456,0xf8d136f2,0x27fe02f1,0x9f342e02}},	//   _کی_, _सम्प, _matn_, бері, 
   {{0xddc40097,0x3ceb00b9,0x7d0436f3,0x00000000}},	//   tliš, _ppcv_, fvis, --, 
   {{0xdb0e0503,0xbcfb1a3b,0x5bcb0267,0x661d0080}},	// [28f0] _debí, _nyét, ећег_, öski, 
   {{0xad9b0c1f,0x6e2d01cc,0x224b36f4,0x63ba36f5}},	//   _saúd, skab, lick_, natn, 
   {{0x81cb0086,0x7d0436f6,0x09bc0086,0x1a650019}},	//   র্ণ_, avis, _ইউজা, لیسی_, 
   {{0x98a9265d,0xdb07014e,0x7d040126,0x63ba36f7}},	//   šač_, _rejä, bvis, hatn, 
   {{0x212b36f8,0x61ff00a4,0x3ce000d9,0x30840499}},	//   nych_, _maql, ctiv_, _خلیف, 
   {{0x63ba0fd3,0x2ca900d4,0xb5fd00ef,0xfbcc0086}},	//   jatn, mpad_, gošn, র্বত, 
   {{0xac5801a2,0x75d5009c,0x2ca936f9,0xc7c400c8}},	//   _сарф_, ليغا, lpad_, ссчи, 
   {{0x0609196d,0x212b0187,0x248e01f2,0x81cb0033}},	//   тник_, kych_, _aifm_, র্ত_, 
   {{0xe6161e54,0x680b002a,0x63ba36fa,0xb5fd02fe}},	//   рды_, _pēdē, fatn, bošn, 
   {{0x212b36fb,0x661b0164,0x13090088,0x63ba36fc}},	//   dych_, sjuk, вной_, gatn, 
   {{0x35f515dd,0x7529094c,0x9f4c0228,0x63791cc1}},	//   _впер, syez, ždú_, ъсир_, 
   {{0x224b36fd,0x7d0436fe,0x2ca9040b,0x00000000}},	//   gick_, yvis, kpad_, --, 
   {{0x63ba36ff,0xd1761088,0x25ad3700,0xae0005d2}},	//   batn, рыны, mbel_, _लोगन_, 
   {{0x7d040fc9,0x98a002f5,0x645d3701,0x63ba3702}},	//   vvis, šić_, ésid, catn, 
   {{0xc4470105,0x6fd70586,0xdfcf00eb,0x71a63703}},	//   _لیکن_, _बारू, ظيف_, _кайз, 
   {{0x7d043704,0xada603dd,0x3ce00405,0x31260093}},	//   tvis, раал, ttiv_, _вдиг, 
   {{0x212b006a,0x1c463705,0x683400a1,0x68fb052b}},	// [2900] cych_, анам, _làda, _nsud, 
   {{0x629e1408,0x69db15c4,0xafe603a1,0x3ce03706}},	//   _époc, _acue, _тоол, rtiv_, 
   {{0x68fb3707,0x25ad3708,0x7d0426ad,0x3ce03709}},	//   _asud, kbel_, svis, stiv_, 
   {{0x09e6370a,0x7d04370b,0x25ad01c8,0x3f940d16}},	//   родн, pvis, jbel_, şbuğ_, 
   {{0x63ba370c,0xb5fd370d,0x9f5803a1,0x25ad0082}},	//   yatn, tošn, ldrà_, dbel_, 
   {{0x5694370e,0xd90d0274,0x69db001d,0x25ad370f}},	//   бакт, عیل_, _ecue, ebel_, 
   {{0x63ba00f1,0x212b00ab,0x9f583710,0x27fe0c86}},	//   vatn, zych_, ndrà_, _vatn_, 
   {{0x27e903ef,0x2c0a02f8,0x63ba1191,0xddcd0613}},	//   đana_, _होतं_, watn, zmaž, 
   {{0x63ba1175,0x15e200a2,0x088a004e,0x3d0900c9}},	//   tatn, क्षर_, _абай_, सिये_, 
   {{0x61ff00cf,0x3cf90d53,0x212b014b,0x683400a1}},	//   _saql, _उनसे_, vych_, _fàda, 
   {{0x212b0da6,0x25ad3711,0x14c20110,0x9f51021e}},	//   wych_, bbel_, _शिकण, rezë_, 
   {{0x2ca93712,0x212b3713,0x05861b9f,0x63ba3714}},	//   ypad_, tych_, _кулм, satn, 
   {{0x224b3715,0x63ba3716,0x925800fd,0x320500d8}},	//   rick_, patn, раят_, ěly_, 
   {{0x212b3717,0xf1a704cc,0x104b1ca5,0x32020032}},	//   rych_, _क्रन, тями_, adky_, 
   {{0xc05802fb,0xe29700ce,0x3e6b0f5a,0x645d3718}},	//   рія_, _кај_, вшан_, ésie, 
   {{0xdd9409d9,0xdda800d9,0x2ca93719,0x63b8371a}},	//   жаты, итул_, tpad_, _hevn, 
   {{0xdb050084,0xb5fd371b,0x63b8078a,0x387e0054}},	// [2910] rbhí, došl, _kevn, _ohtr_, 
   {{0x6298371c,0x63b8004f,0x2ca9371d,0x0ba71820}},	//   _kuvo, _jevn, rpad_, ршам, 
   {{0xb9950038,0xdb15010e,0xddc40083,0x6298371e}},	//   ملاب, _kezé, nniś, _juvo, 
   {{0x63b8031e,0x629802f1,0x2ca90219,0x3a240df7}},	//   _levn, _muvo, ppad_, _comp_, 
   {{0x2001371f,0xe1ff3720,0xa3b63024,0xb05b0502}},	//   _kahi_, llós_, जरा_, sräu, 
   {{0x9f5804b3,0x63b800dd,0x81dd0086,0x7bdc0038}},	//   ldrá_, _nevn, ড়ি_, _gcru, 
   {{0x26c1294c,0x2001002c,0x62983721,0xad9b0165}},	//   ého_, _mahi_, _nuvo, _gaúc, 
   {{0xa2c02369,0x9f580a22,0x26c914f0,0x20011a71}},	//   _विज्, ndrá_, čao_, _lahi_, 
   {{0x81dd00cc,0x68fb0704,0x25ad3722,0xa445186c}},	//   ড়া_, _usud, rbel_, йнид, 
   {{0xc6e70b0c,0x20010414,0x62980009,0x224901ca}},	//   _відп, _nahi_, _buvo, _amak_, 
   {{0x2a7f023b,0xd6db0886,0xe36500af,0x9f5a0036}},	//   _khub_, _шта_, скни, _capì_, 
   {{0x69d93723,0xf59500eb,0x81cb0086,0xb21b02c9}},	//   ngwe, _الإج, র্স_, smæn, 
   {{0x20013724,0x66ea00ad,0xdb1500da,0x5fdc03a2}},	//   _bahi_, _təkc, _dezé, _बादल, 
   {{0x8fa33725,0x22493726,0xa8790070,0xb21b01d5}},	//   заре, _emak_, טאָר, lmæl, 
   {{0xdb1c014b,0xb05b0219,0x20010d16,0x629800a3}},	//   _odrá, vrät, _dahi_, _guvo, 
   {{0x2a7f006d,0xb05b1df5,0x7bc73727,0xdb0e00da}},	//   _nhub_, tsäc, _adju, _nebá, 
   {{0x629801c4,0x20010379,0x3a243728,0xb05b02ae}},	// [2920] _zuvo, _fahi_, _romp_, trät, 
   {{0xd37e1993,0xddcd0083,0x69d9039b,0xb05b1df5}},	//   šćem_, gnał, egwe, rsäc, 
   {{0xb05b3729,0x5f062f89,0x3a24372a,0x9f5a0118}},	//   rrät, _узна, _pomp_, _enpò_, 
   {{0xb05b014e,0xd6da01a2,0xfce6372b,0x9acb010e}},	//   srät, ҳти_, _ломо, ادلہ_, 
   {{0xa3d70f8e,0xb05b0219,0xe918372c,0xc7b80082}},	//   िला_, prät, ролі_, _peđ_, 
   {{0xdca30013,0x6c360a24,0xd6da372d,0xc5e50033}},	//   _хари, _افسا, гти_, _খোলা_, 
   {{0xb5fd03ef,0x68e2372e,0x63b8372f,0x6e260219}},	//   pošl, stod, _revn, _kokb, 
   {{0xb8ce100b,0x60c40112,0x63b81db4,0xf1bf010e}},	//   _কি_, _ovim, _sevn, nkát_, 
   {{0x63b83077,0x62982fc2,0xdb050585,0x00000000}},	//   _pevn, _suvo, zahü, --, 
   {{0x96ba3730,0x22493731,0x682f00fb,0x9f58020b}},	//   _буду_, _smak_, _nødh, zdrá_, 
   {{0xe69600eb,0x88810444,0xd5af3732,0x629800a3}},	//   _الصد, _تیون, _нс_, _quvo, 
   {{0xe7170056,0x80dd00cc,0x3cf9000d,0xddcd0083}},	//   _לחבר_, যবস্, _उनले_, znał, 
   {{0x914b26f1,0xdb15010e,0x20010175,0x645d014a}},	//   учна_, _vezé, _pahi_, ésic, 
   {{0xf1db00f4,0x25de1e25,0xdb1c055f,0x234800d4}},	//   _भावन, _गाडी_, _idræ, _پستی_, 
   {{0x81cb0033,0x9f34004f,0x80ce009a,0x8f343733}},	//   র্ষ_, пері, _तिथे, перц, 
   {{0x6602007e,0x224900d0,0x2001025b,0x6a7800e9}},	//   _jaok, _umak_, _wahi_, dífo, 
   {{0x20013734,0x61ed1041,0x6e26011c,0x66020226}},	// [2930] _tahi_, _ibal, _dokb, _maok, 
   {{0xb606265d,0x44e2008c,0x81cb0086,0x66023735}},	//   lašć, ið_, র্শ_, _laok, 
   {{0x999900d3,0xaab5004f,0x2a7f0387,0x3d950a36}},	//   акет_, ійді, _phub_, _минр, 
   {{0x2a7f0201,0x66023736,0x497500d9,0x998d3737}},	//   _qhub_, _naok, олес, _aleš_, 
   {{0x61ed3738,0x4ac50081,0x7bc3010d,0xd8253739}},	//   _mbal, _लटकव, ónus, ждли, 
   {{0x16a92463,0xbcfb026a,0x23d402e6,0x7bc704c6}},	//   авки_, _exéc, _दागद, _udju, 
   {{0xe739373a,0x4639373b,0x6602373c,0xb21b003e}},	//   рей_, ичия_, _baok, tmæl, 
   {{0xe7f500ab,0x25de00a2,0x79e70019,0xb5fd0fb5}},	//   _इसका_, _गाणी_, _دورہ_, mošk, 
   {{0x998d0d9d,0x66020054,0x8459373d,0xd83805d5}},	//   _fleš_, _daok, ирот_, _flč_, 
   {{0x61ed0f47,0x72c500d9,0x81b90033,0xb21b373e}},	//   _abal, обоз, _চাষ_, smæl, 
   {{0x60c402f5,0xfbd2042c,0x7c270082,0x61ed01a3}},	//   _svim, ותי_, _mojr, _bbal, 
   {{0x7c27024a,0x7b20032f,0xe5ef00c8,0x290d02c5}},	//   _lojr, _ušuš, äkää, _krea_, 
   {{0x644f026d,0xe44e373f,0x25de02e6,0xb1433740}},	//   écis, _жж_, _गाती_, днял, 
   {{0xb5fd03ac,0x61ed3741,0xdfd20038,0x1617009a}},	//   košk, _ebal, بيس_, थावर_, 
   {{0xb5fd04d1,0x81b90086,0xa3a91503,0x44272d1a}},	//   jošk, _চার_, गुण_, _ion_, 
   {{0x44273742,0xee373743,0x78a9031e,0x6d0502e6}},	//   _hon_, онс_, _otev, रिंग_, 
   {{0x44273744,0x9c2604a0,0xec4a0088,0x60c4095a}},	// [2940] _kon_, одад, азал_, _uvim, 
   {{0x44273745,0xb05b02ae,0x61ed3746,0xee390176}},	//   _jon_, lsän, _zbal, анӣ_, 
   {{0x44271164,0xdb15010c,0x290d3747,0x78a90054}},	//   _mon_, _wezî, _area_, _atev, 
   {{0x44273748,0x290d3749,0x38c80116,0x8f7b00d1}},	//   _lon_, _brea_, ماتی_, _כניק, 
   {{0x290d2d58,0xa88a24e9,0xe9f7005e,0x4427374a}},	//   _crea_, айда_, інші_, _oon_, 
   {{0x4427374b,0xb8f20cb8,0x764b02bf,0x6602374c}},	//   _non_, _वि_, _amgy, _saok, 
   {{0xab2a0021,0xb5fd00ef,0xd8380864,0xd6d00038}},	//   _това_, cošk, _vlč_, رقة_, 
   {{0x44271049,0x290d0183,0x25bf374d,0xcf9300d1}},	//   _aon_, _frea_, gaul_, וטו_, 
   {{0x4427374e,0xe4e602fb,0x25eb05d2,0x290d00b3}},	//   _bon_, ційн, _अउरी_, _grea_, 
   {{0x4427374f,0x44e2010d,0x61ed3750,0x6602095a}},	//   _con_, rð_, _sbal, _waok, 
   {{0x44270056,0x2be22649,0xd25100c5,0xe7f7190a}},	//   _don_, _पाना, فند_, ंजरा_, 
   {{0x787f009e,0x92580080,0x9f4514d9,0xe80200bc}},	//   rêve, жают_, ýlí_, लयका_, 
   {{0x44273751,0xc21800dd,0xb60600d2,0x8556009c}},	//   _fon_, ією_, rašć, _بخاط, 
   {{0x44273752,0x9f4c063b,0xdb1e02aa,0xddcd0083}},	//   _gon_, ždý_, rapê, znań, 
   {{0x764b02bf,0x62353668,0xb6060b91,0x61ed00a1}},	//   _ymgy, _неку, pašć, _tbal, 
   {{0x44273753,0x61ed3754,0xc7b800d0,0x4d9905e0}},	//   _zon_, _ubal, _dođi_, скаю_, 
   {{0x44273755,0x2d8f02e7,0x9f580218,0xe04b00d4}},	// [2950] _yon_, äge_, nerê_, _نشده_, 
   {{0xfbab3756,0x645a3757,0xae14017d,0xdb170042}},	//   ртай_, nnti, डाउन_, saxí, 
   {{0xdb1c0218,0xc7b80082,0xdefb3758,0x1df9021d}},	//   _herê, _gođi_, _тып_, _лены_, 
   {{0xb5fd11c8,0x290d002e,0xf9c702fb,0x9f58010c}},	//   rošk, _prea_, іщен, kerê_, 
   {{0xf9902daa,0x25bf00ef,0x00000000,0x00000000}},	//   نبه_, vaul_, --, --, 
   {{0x290d002e,0x2be2009a,0xb5fd3759,0x7e6d375a}},	//   _vrea_, _पाया, pošk, loap, 
   {{0x443e375b,0x2b57009c,0x4427375c,0x00000000}},	//   dht_, _بیاد_, _ron_, --, 
   {{0x44270656,0x682f155b,0x443e01c4,0x645a375d}},	//   _son_, _nødv, eht_, enti, 
   {{0x9f58009e,0x60c902c7,0x3d0e00bd,0x25bf375e}},	//   gerê_, šemj, ठिये_, raul_, 
   {{0x443e0052,0x442702f1,0x7e6d0379,0x00000000}},	//   ght_, _qon_, hoap, --, 
   {{0x4427375f,0xa82200d4,0xdb0e01c4,0x25bf3760}},	//   _von_, _سکون, _gebä, paul_, 
   {{0x9f580218,0x645a3761,0xfc3f288a,0xc04900a7}},	//   berê_, anti, _stíl_, _גז_, 
   {{0x44273762,0x443e0557,0x645a0201,0xb05b0c98}},	//   _ton_, bht_, bnti, rsän, 
   {{0x443e3763,0x25bd0218,0x9f5a00fd,0xc7b800ca}},	//   cht_, _hewl_, _papà_, _pođi_, 
   {{0xe7ed148e,0x25bd0102,0xfbd20019,0xdb1e021e}},	//   च्या_, _kewl_, ہتا_, rapë, 
   {{0x9f4b010e,0xc7b8032f,0xdb1c010c,0x00000000}},	//   áját_, _vođi_, _ferê, --, 
   {{0x2bca08a5,0x629c0098,0xb5fd3764,0xdb1c3765}},	// [2960] йлап_, írov, goši, _gerê, 
   {{0x62963766,0x628401be,0x9f58021e,0x00000000}},	//   _hiyo, _hhio, nerë_, --, 
   {{0xeb972918,0x62963767,0x4f9b00d1,0x9f58010c}},	//   чих_, _kiyo, _לביצ, zerê_, 
   {{0x6296059c,0x9f583768,0xdb1c024a,0x83fc0097}},	//   _jiyo, yerê_, _herë, rođi, 
   {{0x645a3769,0x62840094,0x6296376a,0x6e240548}},	//   ynti, _mhio, _miyo, mjib, 
   {{0x9f583768,0x186704fb,0xdb1e0175,0x6d44018e}},	//   verê_, пачи_, hapé, mzia, 
   {{0x81d400cc,0x8f9b035c,0xf1be031e,0xe3c30086}},	//   স্য_, זיצי, ्णान, ্ভাব, 
   {{0x9f58009e,0x6296376b,0x645a35b8,0x6e360009}},	//   terê_, _niyo, wnti, nkyb, 
   {{0x6d44048a,0x682f192b,0xa4f8015f,0xdb1e02be}},	//   nzia, _rødv, تکار_, dapé, 
   {{0x7bde376c,0x81b90086,0x533411ce,0x644f0107}},	//   ngpu, _চাই_, деот, écip, 
   {{0x6296376d,0xddcd031e,0x6284004c,0xe41a0228}},	//   _biyo, hlaš, _bhio, _kľúč, 
   {{0x443e078e,0x6284376e,0x6d44376f,0xdb1e3770}},	//   sht_, _chio, kzia, rapè, 
   {{0x62963771,0x62843772,0x6d44023b,0x2c660054}},	//   _diyo, _dhio, jzia, sôdy_, 
   {{0x6d44006a,0xc9530056,0xc05b0448,0x9f580034}},	//   dzia, תמש_, сім_, cerë_, 
   {{0x6284003c,0x7e6d3773,0x9f5a0634,0xb17b055f}},	//   _fhio, toap, _papá_, dgåe, 
   {{0x33770056,0x62843774,0x443c00e7,0xdb1e0107}},	//   _מתוך_, _ghio, _hlv_, capé, 
   {{0x7e6d002e,0x8d7700eb,0xdb1c03dd,0x69c200b4}},	// [2970] roap, سارا, _herè, daoe, 
   {{0x62963775,0x9f4a009e,0xdb1c0118,0x7e6d020f}},	//   _ziyo, nebû_, _kerè, soap, 
   {{0x3cf9119f,0x62963776,0x682f02c9,0xdb1c0237}},	//   _उनके_, _yiyo, _mødt, _jerè, 
   {{0xdb0e0218,0xddcd3777,0xdb1c00b9,0x629601ff}},	//   _hebû, blaš, _merè, _xiyo, 
   {{0x8c3b02ec,0x9984031e,0x443c1895,0xc7b80613}},	//   _auße, _domů_, _olv_, _lođu_, 
   {{0x7d0d3778,0x66ea0095,0xddc4015e,0xe8f8012d}},	//   mvas, _təkl, moiš, ялі_, 
   {{0x7d0d3779,0x261900c9,0x69c202be,0x00000000}},	//   lvas, भाली_, baoe, --, 
   {{0x443c00c8,0xbddb0118,0x80b30033,0x69c202be}},	//   _alv_, _imès, _জিন্, caoe, 
   {{0xc9873270,0x799b012b,0x58d4377a,0x7d0d377b}},	//   _хуви, _iguw, _потт, nvas, 
   {{0x629600cf,0x6284377c,0xdb0e009e,0xdb1c0118}},	//   _siyo, _shio, _nebû, _berè, 
   {{0xb05b022b,0x6fd700a2,0x7d0d06a6,0x6d44377d}},	//   rsäl, _बाजू, hvas, zzia, 
   {{0xc7b804d1,0x63ad078a,0x1c0a00a2,0x5eac0086}},	//   _dođu_, _şand, _होईल_, _ছিলে, 
   {{0xdb1c00e5,0xdb1e0634,0xd0120019,0x443c377e}},	//   _perë, rapé, پلز_, _flv_, 
   {{0x40950715,0x6609377f,0xddcd2e7d,0xdfd20038}},	//   ерст, ldek, vlaš, ضير_, 
   {{0xdee33780,0x6284009f,0xdb1c3781,0x26c70a1a}},	//   кори, _thio, _verë, nsno_, 
   {{0x6d440a9f,0xa3a90c59,0x799b3782,0x4425019b}},	//   tzia, गुर_, _nguw, ljl_, 
   {{0x6e24016a,0x7d0d18c7,0xb17b0f96,0xfd6500f6}},	// [2980] rjib, gvas, tgåe, ентү, 
   {{0x6d443783,0x660900c8,0x3eba02aa,0x2fc30ab4}},	//   rzia, hdek, _twpt_, cajg_, 
   {{0x7d0921bc,0xdb1c3784,0x25de00b5,0xf09307e4}},	//   _šest, _keré, _गाली_, _שנת_, 
   {{0x8c480095,0xa2d53785,0xceb3042c,0xddcd01dd}},	//   _başç, _भिन्, _שיר_, plaš, 
   {{0x81cb0086,0x201a016a,0x66090547,0x81d40086}},	//   র্ক_, _knpi_, ddek, স্থ_, 
   {{0x76aa3786,0x9f5806df,0x645d0107,0xfbd50033}},	//   отив_, terè_, ésil, স্বত, 
   {{0x64410673,0x8c3b01c4,0x61e40082,0x443c0226}},	//   dhli, _fußb, _ocil, _rlv_, 
   {{0x60c9090e,0x81d40086,0x682f0566,0x9f5801e5}},	//   šemi, স্ত_, _bøds, geré_, 
   {{0x998d026e,0x69c000e0,0x7d090183,0x6ad30086}},	//   _pleť_, _ieme, _áest, _সহযো, 
   {{0x69c03787,0x29043788,0x682f08bb,0x61e43789}},	//   _heme, _isma_, _døds, _acil, 
   {{0x69c0378a,0xbbd7035c,0x3946001d,0x78a0016c}},	//   _keme, וויץ_, lzos_, _humv, 
   {{0x69c0378b,0x51871b68,0x78a019bb,0x682f08bb}},	//   _jeme, дуга, _kumv, _føds, 
   {{0x69c01630,0x3946378c,0x656f01c4,0xdb1e0216}},	//   _meme, nzos_, ücht, xapî, 
   {{0x6441378d,0xdb0e378e,0x69c0378f,0x78a03790}},	//   chli, _qebû, _leme, _mumv, 
   {{0xfe73195e,0x32670093,0x9f4102a3,0xdb0e010c}},	//   ندر_, _отив, _xchè_, _vebû, 
   {{0x27e903ef,0x69c03791,0xdb15026e,0xe508001b}},	//   đani_, _neme, _nezá, _kỷ_, 
   {{0xa2da09d3,0x61fd3792,0xddc40b04,0x682f01e8}},	// [2990] पूर्, mesl, bliž, _mødr, 
   {{0x69c01c62,0x320907fc,0x6609027e,0x4ea700f0}},	//   _aeme, _haay_, zdek, _орма, 
   {{0x69c03793,0x29040985,0x3ce93794,0x7d0d3795}},	//   _beme, _asma_, stav_, svas, 
   {{0xfe350137,0x61fd3796,0xdb053797,0x6f0500a3}},	//   _נאָך_, nesl, nché, _ishc, 
   {{0x69c013d7,0xadd6042c,0x9f580216,0x2904012b}},	//   _deme, _אורח_, nerî_, _csma_, 
   {{0xa3b000c2,0x682f00fb,0x013800d1,0x61fd00da}},	//   टुम_, _røds, ורדת_, hesl, 
   {{0x69c03798,0x7bc53799,0x66090d2d,0xb5fd0242}},	//   _feme, mahu, tdek, košt, 
   {{0x69c0379a,0x7bc5379b,0x9f580216,0x3209012b}},	//   _geme, lahu, kerî_, _naay_, 
   {{0x6441379c,0x2904379d,0x00000000,0x00000000}},	//   thli, _gsma_, --, --, 
   {{0xc984379e,0x69c0379f,0x7bc50bc1,0x61e40038}},	//   _руси, _zeme, nahu, _scil, 
   {{0x69c032fa,0x35b51afd,0x32090237,0xdb1c37a0}},	//   _yeme, _збер, _baay_, _peré, 
   {{0xcb120137,0x61fd01a9,0x6a78118d,0x683400d3}},	//   אלט_, gesl, tífi, _ràdi, 
   {{0x7bc52282,0xdb1c010c,0x78a0006d,0x9f58010c}},	//   kahu, _nerî, _xumv, gerî_, 
   {{0xf8b200a7,0x3a2d12b6,0x7bc537a1,0x15f90110}},	//   רשם_, _loep_, jahu, ्यकर_, 
   {{0xdb1c247e,0x3a3f37a2,0x61fd37a3,0x7bc537a4}},	//   _teré, _olup_, besl, dahu, 
   {{0x61e4015e,0xdb1c010c,0x9f58009e,0x2be2009a}},	//   _ucil, _berî, berî_, _पाहा, 
   {{0xc6920cec,0x69c037a5,0x7afb1b90,0x224037a6}},	// [29a0] ראן_, _reme, _ćuta, _ilik_, 
   {{0x7bc537a7,0x6cd30038,0xdb1c009e,0x09d8009a}},	//   gahu, اقلا, _derî, डल्य, 
   {{0x69c037a8,0x3a2d040b,0x06b40033,0x229a0243}},	//   _peme, _boep_, _টিভি, _kūka_, 
   {{0x4ad100a2,0xc9861768,0x9fb80033,0xdb1c009e}},	//   _हिरव, нули, _জায়গ, _ferî, 
   {{0xa3cf3512,0xdb1c078a,0x7bc537a9,0x69c00034}},	//   षणा_, _gerî, bahu, _veme, 
   {{0x26dc37aa,0x394637ab,0x7bc537ac,0x7bce055f}},	//   tuvo_, rzos_, cahu, _udbu, 
   {{0x81cb00cc,0x8c1b0137,0x316c00ab,0xcb6737ad}},	//   র্ট_, _צולי, ędzy_, _заре_, 
   {{0x3a3f0704,0xb21b02c9,0x7c2e37ae,0x9b1700d1}},	//   _glup_, mlæg, _hobr, _אחלה_, 
   {{0xdb1c078a,0x7c2e37af,0xb21b02c9,0x61fd1240}},	//   _xerî, _kobr, llæg, vesl, 
   {{0xb05b022b,0x224037b0,0xb806006b,0x73380e8f}},	//   rsäk, _alik_, _سکتے_, дзор_, 
   {{0x1de10c15,0x224037b1,0x9f580218,0xb21b37b2}},	//   _फालत, _blik_, werî_, nlæg, 
   {{0xe5080029,0x60dd03f0,0x22400096,0xb0a500a5}},	//   _tỷ_, tusm, _clik_, _गंदग, 
   {{0xdb0537b3,0x61fd37b4,0x7bc537b5,0x3ea106a6}},	//   rché, resl, yahu, _suht_, 
   {{0x7c2e37b6,0x32090102,0x224037b7,0xdb050534}},	//   _nobr, _waay_, _elik_, sché, 
   {{0xb5fd00d2,0xe1930161,0x9f58009e,0xddc40035}},	//   pošt, _өлкө, serî_, bliż, 
   {{0x442e37b8,0xa2d5000d,0xb21b055f,0xdb1e0369}},	//   _hof_, _भित्, dlæg, gapí, 
   {{0x7bc537b9,0x5c7504c5,0x5c9913f2,0x3a2d15e9}},	// [29b0] tahu, влат, дкая_, _roep_, 
   {{0xddeb00c5,0x3a2d01c8,0xe1ff30da,0x7c2e37ba}},	//   _کرده_, _soep_, leó_, _cobr, 
   {{0x7bc537bb,0x442e37bc,0x3a2d12b6,0xfbe20249}},	//   rahu, _mof_, _poep_, _पारम, 
   {{0x7bc50a41,0x442e37bd,0xe1ff0126,0xdb1c009e}},	//   sahu, _lof_, neó_, _terî, 
   {{0x26cc02fe,0x7bc537be,0xbddb03a1,0x8d8401a2}},	//   _avdo_, pahu, _elèc, _бурд, 
   {{0x81cb00cc,0xbddb37bf,0x7d090183,0x28d221d2}},	//   র্চ_, _flèc, _áesq, _सिरि, 
   {{0x1c0a37c0,0x3a2d0876,0xaa5937c1,0x6e2f0144}},	//   _होटल_, _toep_, _живу_, _kocb, 
   {{0x7c2e0c7f,0x60cd05ae,0xb9070033,0xe1ff0126}},	//   _zobr, _ovam, _বন_, jeó_, 
   {{0xe1ff0019,0xe81e0262,0x26cc02a2,0x98f40040}},	//   deó_, पाशा_, _evdo_, _مثلا, 
   {{0x224000fc,0x442e00f8,0xddcd0035,0x9f580036}},	//   _slik_, _cof_, niał, ferì_, 
   {{0xb21b37c2,0x60cd00b0,0xe81e02e6,0x22400035}},	//   klæd, _avam, पारा_, _plik_, 
   {{0x6b9a003e,0x27e90b91,0x81cb0033,0x6e2f00a1}},	//   _útge, đanu_, র্ঘ_, _nocb, 
   {{0xf1bf0019,0x7e69090e,0xa50937c3,0xdd0102d9}},	//   pján_, čepl, _цела_, čtět, 
   {{0xd47900c7,0x60cd0372,0x03a201a2,0x65940267}},	//   _קאַל, _dvam, _кишо, _сачу, 
   {{0xe45600c7,0x660b012b,0xd46637c4,0x60cd0a6d}},	//   _ביסט_, _kagk, _шише_, _evam, 
   {{0xb17b014e,0x22400693,0x28d202ff,0xb21b0566}},	//   mgån, _ulik_, _सिलि, glæd, 
   {{0xed571ba1,0x660b37c5,0x7c2e37c6,0xdca337c7}},	// [29c0] вот_, _magk, _pobr, иати, 
   {{0x14d400a2,0x1c1c00b0,0x660b0c17,0x21370070}},	//   _दिसण, नाइल_, _lagk, _סטיל_, 
   {{0x9f480088,0xb17b02ae,0x8b961f79,0x403b029e}},	//   ähän_, ngån, трач, _חגיג, 
   {{0x660b03eb,0xb21b37c8,0xd8380864,0x7c2e017c}},	//   _nagk, rlæg, _miče_, _wobr, 
   {{0x61f600e5,0xd838044e,0x7d090183,0x09e337c9}},	//   _mbyl, _liče_, _áesp, рочн, 
   {{0xddcd00ab,0x9873012d,0x7c2e044e,0x7d0402b8}},	//   ciał, аліц, _uobr, mwis, 
   {{0x442000f7,0x7d0437ca,0x660b37cb,0x5a960cdf}},	//   _đi_, lwis, _bagk, _араф, 
   {{0x26192cad,0xb17b0219,0x442e37cc,0xddcd00da}},	//   भागी_, dgån, _sof_, plať, 
   {{0x18a637cd,0x2ca60084,0x57ea37ce,0x660b37cf}},	//   _разм, íodh_, _одам_, _dagk, 
   {{0xdb1c0126,0x6a780d57,0x683400b9,0xd83800de}},	//   _lerí, rífu, _pàdu, _biče_, 
   {{0x60cd37d0,0x9f580126,0xe1ff0369,0x442e01d2}},	//   _svam, ferí_, teó_, _vof_, 
   {{0x7d0437d1,0xddcd0035,0x44eb017b,0x80d735ad}},	//   kwis, ział, bø_, _बिदे, 
   {{0x442e37d2,0x6600095a,0x628f039b,0x76420104}},	//   _tof_, memk, rmco, _iloy, 
   {{0x76420415,0xb21b0566,0xe1ff0126,0x244003a0}},	//   _hloy, gmær, seó_, _fòma_, 
   {{0x9f530068,0x4ea4286c,0x6738010e,0x925937d3}},	//   _raxó_, ирта, nyvj, _пакт_, 
   {{0x6d0e11bd,0xd258002e,0xddcd0035,0x1287009c}},	//   सिंग_, _аць_, wiał, _جمعی_, 
   {{0xd9041cad,0x2d58030f,0x22590310,0xebc70886}},	// [29d0] _بی_, вить_, misk_, вљен, 
   {{0x764237d4,0x22590430,0x5fb72488,0x660037d5}},	//   _lloy, lisk_, _अभिल, hemk, 
   {{0xddcd00ab,0x9f35004e,0x0ba437d6,0x98b801dd}},	//   riał, _сені, ршум, _ārā_, 
   {{0x22590310,0x629e026a,0x66000352,0xddcd0035}},	//   nisk_, _épou, jemk, siał, 
   {{0x4dda0056,0xdb1c37d7,0x62560121,0x660b0175}},	//   _אחרו, _cerâ, dšol, _ragk, 
   {{0xd36629ce,0x764237d8,0x00000000,0x00000000}},	//   _هه_, _aloy, --, --, 
   {{0x660b146f,0x225905ac,0xf0940070,0x00000000}},	//   _pagk, kisk_, בנס_, --, 
   {{0xd83802fe,0xf5091444,0xda0b00b0,0xdb07039f}},	//   _riče_, енил_, _सोचत_, _bejö, 
   {{0x22592379,0x03a50978,0x9f580032,0xa97800f0}},	//   disk_, липо, verí_, _айту_, 
   {{0x2c1c0035,0x58870b34,0x76420118,0xb17b02ae}},	//   नाएं_, _рыба, _eloy, tgån, 
   {{0x22590310,0xc73500d6,0x660b37d9,0x7d0437da}},	//   fisk_, _حفاظ, _tagk, zwis, 
   {{0x22590310,0x764200f3,0xb17b0219,0xd838090e}},	//   gisk_, _gloy, rgån, _viče_, 
   {{0x51560afc,0x7fd6128b,0x515502be,0xb21b0566}},	//   утну, ліві, атру, tmær, 
   {{0xdb1c128a,0x25ad37db,0xc5e300a5,0xb17b02ae}},	//   _serí, lcel_, _गाँठ_, pgån, 
   {{0xdb1c37dc,0x22592379,0xb21b0566,0x644337dd}},	//   _perí, bisk_, rmær, _ilni, 
   {{0x25ad37de,0x6d4106d0,0x7d0437df,0x22590035}},	//   ncel_, _əlav, twis, cisk_, 
   {{0xdb1c37e0,0x00000000,0x00000000,0x00000000}},	// [29e0] _verí, --, --, --, 
   {{0x7d0437e1,0x66000076,0xc00637e2,0x629e03a1}},	//   rwis, zemk, _спок, _èpoc, 
   {{0xdb1c37e3,0x91a937e4,0x28c6047c,0x41b8007e}},	//   _terí, _hoá_, रीनि, _आभास, 
   {{0x66ea06d0,0x9f58245d,0x32020379,0xfe4237e5}},	//   _məkt, merà_, neky_, _اکسی, 
   {{0x9f5801d8,0xc7b80304,0xbddb023e,0xed3600d9}},	//   lerà_, _anđa_, _klèn, _сэнэ, 
   {{0xdcfd00e0,0xe89401fc,0x6d4800ad,0x80d735d0}},	//   _uzsā, шаль, _ədal, _बिसे, 
   {{0xdc671a57,0xf1ba0029,0x9f5801d8,0x660000b4}},	//   _сард_, _đơn_, nerà_, temk, 
   {{0x963437e6,0x7e64007e,0xb05b0219,0x7c3e000b}},	//   рниц, nnip, lsät, lkpr, 
   {{0x80a037e7,0x3d170b79,0x896615a7,0x888637e8}},	//   _गंगे, निये_, _скаж, _блаж, 
   {{0x261900a2,0x54540093,0x7c3e2a73,0xb05b37e9}},	//   _मोठी_, рвот, nkpr, nsät, 
   {{0x22590310,0xa3e502f8,0xb89300eb,0x7e641a0d}},	//   tisk_, _फार_, _اللع, knip, 
   {{0x9f5837ea,0xdb050165,0xbb3b0070,0xe5a637eb}},	//   derà_, lchã, געטי, _сиди, 
   {{0x22590310,0xf1bf0019,0xbddb023e,0xe3af00d4}},	//   risk_, lják_, _blèn, غری_, 
   {{0x22590310,0xbddb023e,0xdb1e0126,0x439400d3}},	//   sisk_, _clèn, zapá, _калс, 
   {{0x645a37ec,0x225937ed,0x33170740,0x2139024a}},	//   miti, pisk_, _مزيد_, sysh_, 
   {{0x443e37ee,0x442c0219,0x7e64137f,0x31660097}},	//   lkt_, ljd_, gnip, _žoze_, 
   {{0xdc550aa3,0xad9b0068,0x26c10019,0x628d0379}},	// [29f0] авањ, _naút, ához_, _ihao, 
   {{0xe7e011bd,0x645a37ef,0x2ca9008a,0xb05b014e}},	//   _नागप, niti, rqad_, gsät, 
   {{0x443e37f0,0xdb0e01c4,0x628d0149,0x629f114e}},	//   ikt_, _gebü, _khao, _épos, 
   {{0x645a37f1,0xdb1c03b7,0x39151219,0x200337f2}},	//   hiti, _serã, имер, leji_, 
   {{0x628d1232,0xfc3f0038,0x9f580126,0xb5fd00ca}},	//   _mhao, _dtír_, merá_, jnša, 
   {{0x443e0536,0x645a37f3,0x201137f4,0x7c3e1096}},	//   jkt_, jiti, ndzi_, ckpr, 
   {{0xfc3f1056,0x645a37f5,0xdb1c02a0,0xaa9500dd}},	//   _guía_, diti, _verã, _вивч, 
   {{0xceb41a61,0x6e2d37f6,0xe61900cf,0x443e13fe}},	//   זיק_, njab, тди_, ekt_, 
   {{0x645a37f7,0x7bc70982,0x87e703b1,0xdb1c02a0}},	//   fiti, _keju, _مثال, _terã, 
   {{0x69cb37f8,0x7bc737f9,0xdb1c0068,0x25ad37fa}},	//   lage, _jeju, _herá, scel_, 
   {{0x38ab01e8,0x20030356,0x9f58022c,0x7bd50532}},	//   _hør_, deji_, xerà_, _mdzu, 
   {{0x628d1600,0x69cb37fb,0x7bc72fea,0x443e012e}},	//   _chao, nage, _leju, akt_, 
   {{0x645a37fc,0x628d11a1,0x9f580c1f,0x3202014b}},	//   biti, _dhao, derá_, reky_, 
   {{0x443e37fd,0x69cb37fe,0x9f583721,0x261937ff}},	//   ckt_, hage, terà_, _मोती_, 
   {{0x69cb3800,0x38ab03a9,0x628d0014,0x2fca0082}},	//   kage, _lør_, _fhao, rabg_, 
   {{0x628d0094,0x9f583801,0xfe432669,0x6da300b3}},	//   _ghao, gerá_, онсо, жита, 
   {{0xb05b0a52,0x7afc3802,0x6486003e,0x753b3803}},	// [2a00] tsät, _sprt, iðin, nyuz, 
   {{0x9f583804,0x7bc70126,0x765b0495,0x68e200c8}},	//   perà_, _ceju, hiuy, vuod, 
   {{0xb05b074b,0x9f583805,0xf1da1cdd,0x7bc700b3}},	//   rsät, berá_, _भयान, _deju, 
   {{0x9f580e2e,0x38ab1b37,0xdb1c0503,0xfce63806}},	//   cerá_, _bør_, _cerá, _комо, 
   {{0x76493807,0x39403808,0x645a3809,0x443e380a}},	//   dhey, áis_, yiti, ykt_, 
   {{0x645a380b,0x26dc380c,0xf1bf0019,0x60c4380d}},	//   xiti, trvo_, tják_, _mwim, 
   {{0x69cb380e,0x12e00086,0x394036d7,0x683d023e}},	//   bage, _বন্দ, šis_, _mèdh, 
   {{0x38ab1b37,0x26193355,0x69cb380f,0xf1bf010e}},	//   _før_, _मोदी_, cage, rják_, 
   {{0x38ab0022,0x645a3810,0xb8db0086,0xd94304b6}},	//   _gør_, titi, _আয়_, _дети, 
   {{0x628d009f,0x9f580228,0x443e01dd,0x7e6902c7}},	//   _shao, zerá_, ukt_, čepi, 
   {{0x443e3811,0x63a300e2,0x6d4d0547,0xd5af3812}},	//   rkt_, _dgnn, zzaa, _мс_, 
   {{0x443e0177,0x645a3813,0x64483814,0xdb1c0068}},	//   skt_, siti, shdi, _xerá, 
   {{0x645a0ad1,0x9f5802a0,0xc05b00dd,0x68e4004c}},	//   piti, verá_, вів_, àidh, 
   {{0x69cb3815,0xc05b3816,0xdb1e022c,0x44f03817}},	//   zage, тім_, capç, mà_, 
   {{0x628d11a1,0x69cb3818,0x9f58118d,0x44f03819}},	//   _thao, yage, terá_, là_, 
   {{0x7bc70730,0xf8a60827,0xb05b00c8,0x2003044d}},	//   _seju, खदाय, tsäs, seji_, 
   {{0x7bc7381a,0xdb05143b,0x629f026a,0x6e2d381b}},	// [2a10] _peju, dchá, _époq, rjab, 
   {{0xdb1c128a,0x6d4d0b32,0x69cb381c,0x38ab01e8}},	//   _será, rzaa, wage, _rør_, 
   {{0x69cb381d,0x38ab00fc,0xb05b17f8,0x6d4d381e}},	//   tage, _sør_, ssäs, szaa, 
   {{0xceb20138,0x44f00379,0xbddb03a0,0x00000000}},	//   _מיט_, kà_, _klèm, --, 
   {{0xdb1c381f,0xe9d80b57,0x81d40086,0x798000f8}},	//   _verá, ркі_, স্ক_, _cymw, 
   {{0x44f03820,0xdb050038,0x81ad0033,0x7bd53821}},	//   dà_, achá, গরি_, _udzu, 
   {{0xdb1c28e8,0x61ed3822,0xdd26009e,0xb9e7004f}},	//   _terá, _ocal, _kêşa, _візи, 
   {{0x38ab03a9,0x683d03a1,0x6aa01792,0x81cc0086}},	//   _tør_, _mèdi, _gimf, _লাভ_, 
   {{0x6486010d,0xf80700dd,0x79800156,0x76493823}},	//   rðin, _вчен, _gymw, rhey, 
   {{0xe0df01d8,0x61ed2953,0x7649018e,0xddcd0352}},	//   drò_, _acal, shey, jlaž, 
   {{0x78a90033,0x9f5800d3,0xe0df02a3,0x60c43824}},	//   _huev, merç_, erò_, _swim, 
   {{0x78a13825,0xbddb0054,0x66ea00ad,0x44f003dd}},	//   _hilv, _blèm, _təkr, bà_, 
   {{0xd1760335,0x78a93826,0x25bf1275,0xf6741930}},	//   сыны, _juev, mbul_, _بالخ, 
   {{0x78a905b9,0x25bf3827,0x7e7d3828,0xf1bf02aa}},	//   _muev, lbul_, _aksp, abá_, 
   {{0xddcb2e7d,0x7ae5007e,0xf1bf010e,0x61ed008a}},	//   _šiša, juht, bbá_, _fcal, 
   {{0x25bf0c05,0x290d3829,0xdb1c010c,0xf8a500d4}},	//   nbul_, _osea_, _herç, _يک_, 
   {{0x78a934c3,0x7c35382a,0xddcd0304,0x925a0499}},	// [2a20] _nuev, _bozr, blaž, _لشکر_, 
   {{0xeb9a0623,0xdd8f04bc,0x09d000a2,0x3212382b}},	//   гиз_, رول_, हण्य, _hayy_, 
   {{0xdb1c382c,0x25bf382d,0xb09b00a7,0x6441382e}},	//   _merç, kbul_, _תייר, ikli, 
   {{0xd910017a,0x6441239e,0xdb1e00c2,0x0dba007a}},	//   ویز_, hkli, vapä, _حادث_, 
   {{0x6441382f,0x78a9033c,0xd7fa3830,0x78a1098d}},	//   kkli, _cuev, гуй_, _bilv, 
   {{0x78a10bc3,0x44f03831,0xaad100c9,0x78a90036}},	//   _cilv, và_, _हिचक, _duev, 
   {{0x6441014e,0x290d0126,0x26193832,0x6aa00354}},	//   dkli, _esea_, _मोही_, _timf, 
   {{0x44f03833,0xc8e0000f,0x44b400dd,0xbb3b00c7}},	//   tà_, _निपट, обис, _געלי, 
   {{0xdb1c3834,0x7afb0b91,0xd49a0176,0x3ebf0304}},	//   _berç, _ćuti, лро_, ćuti_, 
   {{0x44f03835,0x15ea0586,0xe0df01d8,0x9f5a022c}},	//   rà_, _टावर_, vrò_, _japó_, 
   {{0x6d4106d0,0x92953836,0xd7640019,0x44f03837}},	//   _əlaq, жанц, _بنای, sà_, 
   {{0x78a1012e,0x6441018c,0x3ea200ab,0xe0df00fd}},	//   _zilv, akli, _nikt_, trò_, 
   {{0xdb1c0088,0x64410b41,0x867b0ab9,0xf596007a}},	//   _herä, bkli, _גראו, _الشج, 
   {{0x64413838,0xdb1c3839,0xe0df01d8,0x61ed0035}},	//   ckli, _gerç, rrò_, _wcal, 
   {{0x62350a43,0x7c351d8c,0xc0580c8b,0xce6b383a}},	//   _меку, _rozr, сія_, град_, 
   {{0x4caa0086,0xbddb011c,0xe0df02a3,0xddcd00ca}},	//   _চৌধু, _ilèk, prò_, slaž, 
   {{0x7c350039,0x7cd900d4,0x3ea2383b,0xdd94383c}},	// [2a30] _pozr, شواز_, _dikt_, заты, 
   {{0x4d981838,0x9f5a240a,0x25bf018e,0x00000000}},	//   скую_, _capó_, zbul_, --, 
   {{0x25a602a0,0x78a90042,0x5f950165,0xa91d0144}},	//   _ogol_, _suev, _финт, _izži, 
   {{0x6441342a,0x7e99383d,0x7d0e1279,0x00000000}},	//   zkli, _خنجر_, änsä, --, 
   {{0x78a1383e,0x78a9318d,0xbcfb145a,0x7c8715d3}},	//   _pilv, _quev, _exér, _гуве, 
   {{0x8aa70676,0xdb1c022b,0xe7390ca6,0x25b30249}},	//   _град, _berä, иел_, ीर्ण, 
   {{0x81d4100b,0xa6b40086,0x387e0175,0x78a1383f}},	//   স্ট_, _টিউট, _dktr_, _vilv, 
   {{0xdb1c3840,0x62560098,0xd8380604,0xb05b0502}},	//   _serç, lšov, _fičo_, lpäd, 
   {{0x78a13841,0xdb1c3842,0x89370e05,0xe9d90035}},	//   _tilv, _perç, _اعزا, _idź_, 
   {{0xf9901666,0x22493843,0x25bf3844,0x2619190a}},	//   _سبق_, _alak_, sbul_, _मोरी_, 
   {{0x64413845,0xdb1c3846,0x224910fd,0xb21b055f}},	//   rkli, _gerä, _blak_, rlæn, 
   {{0x81e200cc,0x64413847,0x28e01276,0x22490574}},	//   ন্ন_, skli, _निमि, _clak_, 
   {{0xdb1c03b7,0xa2d51f19,0xbddb03a0,0x22490352}},	//   _terç, _भिक्, _elèk, _dlak_, 
   {{0x22493848,0x3ea231b7,0xbddb023e,0x2d823849}},	//   _elak_, _sikt_, _flèk, _ryke_, 
   {{0x032500dd,0x8fa3384a,0x2d820eba,0x4fa300fd}},	//   _єдин, даре, _syke_, дирв, 
   {{0x00e6384b,0x1e86128b,0x3f840243,0x00000000}},	//   _джин, ілам, āmu_, --, 
   {{0x3ea2014e,0x30760176,0x00000000,0x00000000}},	// [2a40] _vikt_, _муос, --, --, 
   {{0x6286384c,0x2a6d0175,0x2a7f0175,0xc8e000c9}},	//   llko, _ajeb_, _akub_, _निबट, 
   {{0x6da616e1,0x2beb37e7,0xe7ed00a2,0x3ea2384d}},	//   _мина, _चारू_, च्छा_, _tikt_, 
   {{0x387e02a2,0xdb1c1bde,0x2d8200b9,0x66fc0243}},	//   _sktr_, _nerå, _tyke_, nākš, 
   {{0xa3e9047b,0xa96a0e65,0x9f5a0126,0x15e3384e}},	//   यला_, шида_, _tapó_, _गाजर_, 
   {{0xd6da384f,0xdb1c0088,0xa3e5034d,0x201300b4}},	//   ати_, _perä, _फाग_, _xaxi_, 
   {{0x27e00c05,0x81e20086,0xdca33850,0x2a7f011c}},	//   ğin_, ন্য_, _цари, _fkub_, 
   {{0xa5343851,0x27e03852,0x91e604bd,0xdb1c02f2}},	//   знич, şin_, _कागज_, _verä, 
   {{0x746a0879,0xd4062595,0x69c23853,0xe46a02aa}},	//   иров_, ояни, mboe, ишол_, 
   {{0x81e20086,0xb35400dd,0xdb1c00c8,0x69c23854}},	//   ন্ম_, зкош, _terä, lboe, 
   {{0x28c60c94,0x683d00f6,0x68e2039b,0x68e4007a}},	//   रीरि, _cèdu, lrod, áidf, 
   {{0x64a63855,0x69c20b32,0x68e2095a,0x00000000}},	//   _дада, nboe, orod, --, 
   {{0x22493856,0x1a9b0137,0x2beb00a2,0x6256014b}},	//   _vlak_, ייטע, _चालू_, yšov, 
   {{0x9f5a06df,0x628600bd,0x741400d7,0x60db0450}},	//   _rapò_, alko, _روبا, šumo, 
   {{0xd8383857,0x644a016a,0x69c201da,0x2ca301c8}},	//   _moč_, _ilfi, kboe, _rijd_, 
   {{0x68e23858,0xa91d00bc,0x2cb90345,0x5f943859}},	//   krod, _lyža, _ptsd_, фист, 
   {{0xa3ae00a5,0x5d5501d0,0xfbab00af,0x6b9a01d5}},	// [2a50] _कला_, чкат, атей_, _útgj, 
   {{0x64dd02f8,0x68e2385a,0xd838008b,0x83fc0613}},	//   _मिसळ, drod, _noč_, biđe, 
   {{0x62561194,0x69c2040b,0x00000000,0x00000000}},	//   ršov, fboe, --, --, 
   {{0xc3330137,0x69c20b1f,0x5a352cdb,0x68e2017c}},	//   ווע_, gboe, янет, frod, 
   {{0x2ca30536,0x68e200ab,0xb5fd034c,0x6256014b}},	//   _tijd_, grod, niše, pšov, 
   {{0xd7fb385b,0x7d0d385c,0x38b000a1,0x9f580036}},	//   руд_, mwas, _dàr_, ffrè_, 
   {{0xe739385d,0x44290029,0x7d0d385e,0x3ffc0137}},	//   сей_, _đa_, lwas, יפגע, 
   {{0xb0dc04d7,0xc95b02f1,0xdb170068,0xecdf0035}},	//   _बिलग, _кўз_, saxó, _फटाफ, 
   {{0xdb0502ec,0x81e200cc,0x7d0d385f,0x83fc2cd9}},	//   schä, ন্ড_, nwas, ziđe, 
   {{0x28e01cdd,0xb5fd015e,0xd8380082,0x7d0d06e4}},	//   _निति, diše, _goč_, iwas, 
   {{0x59cf0239,0x7d0d3860,0x3ce901a0,0x5884012d}},	//   _हजार, hwas, huav_, _цыта, 
   {{0x7d0d0547,0x83fc003a,0x80b30086,0xdb120019}},	//   kwas, viđe, _জিজ্, égév, 
   {{0x216703dc,0x6f1e0ab4,0xa567009c,0x271c0023}},	//   зияи_, _srpc, _بدان, _ảnh_, 
   {{0x3af50219,0xdb150380,0x66093861,0xa3e508f1}},	//   kåp_, _bezü, leek, _फाट_, 
   {{0x44273862,0xdb1c010c,0x00000000,0x00000000}},	//   _inn_, _derû, --, --, 
   {{0x6f1e00d0,0x7c273863,0x66093864,0x442701be}},	//   _vrpc, _anjr, neek, _hnn_, 
   {{0x7d0d0ae3,0x28e0017d,0x78bb0027,0x6abb0604}},	// [2a60] gwas, _निधि, _ntuv, _čufa, 
   {{0x69db0126,0x8b960d47,0x8cdd0586,0xac83125b}},	//   _adue, преч, _पिरो, егул, 
   {{0x0b590504,0x69c210f3,0x103b00d1,0x291f3865}},	//   орцы_, tboe, _הגיע, _arua_, 
   {{0xdca6338e,0x20183866,0x200a3867,0x442700a1}},	//   _нами, ldri_, lebi_, _lnn_, 
   {{0x44273868,0x291f00eb,0x69c212b6,0xb05b007e}},	//   _onn_, _crua_, rboe, späe, 
   {{0x68e23869,0x69db0183,0x69c20511,0xb17b0bff}},	//   rrod, _edue, sboe, pgåv, 
   {{0xa91d026e,0x1c02047c,0x7bdc34c4,0x78bb386a}},	//   _vyža, _रॉयल_, _idru, _etuv, 
   {{0x4427386b,0x81e2100b,0x200a1b3e,0xbddb011c}},	//   _ann_, ন্ত_, hebi_, _dlèw, 
   {{0x7bce386c,0x48e3386d,0x291f024a,0xb17b017b}},	//   _kebu, _потв, _grua_, ngåt, 
   {{0xb5fd0519,0x7bce2991,0x200a08e3,0xaae0017d}},	//   više, _jebu, jebi_, _पटाक, 
   {{0xf366386e,0x7bce07d7,0x2120023e,0x67bb00d1}},	//   ятин, _mebu, _arih_, _המבק, 
   {{0x44270c86,0x7bce386f,0x3ce9006d,0xdb1c0218}},	//   _enn_, _lebu, yuav_, _serû, 
   {{0x3ce9006f,0x81cc0033,0x7d0d009e,0x958600d3}},	//   xuav_, _লাশ_, xwas, _элде, 
   {{0x7bce3870,0xb5fd07d1,0x29040054,0xc058012d}},	//   _nebu, riše, _mpma_, піс_, 
   {{0x54330a24,0xff040fac,0x81e20086,0x8c3b0380}},	//   _سرور, нятн, ন্ধ_, _mußt, 
   {{0x7d0d3871,0xb5fd203b,0x00000000,0x00000000}},	//   twas, piše, --, --, 
   {{0x7bce3872,0x9c393873,0xdcef01dd,0x200a027e}},	// [2a70] _bebu, опат_, _izcī, bebi_, 
   {{0x81e200cc,0xfbab3874,0x200a0165,0x66093875}},	//   ন্দ_, стай_, cebi_, zeek, 
   {{0x78bb0343,0x3ce9023b,0x7ac400d9,0x2b47039f}},	//   _stuv, suav_, есче, ánc_, 
   {{0xdb15026e,0xfd1f001b,0xa3dc0527,0x291f02a3}},	//   _sezó, _trì_, तृत_, _prua_, 
   {{0x9f5105b9,0x7e6d3876,0x7bce044d,0xdb150126}},	//   pezó_, mnap, _febu, _pezó, 
   {{0x7bce3877,0x66093878,0x6fbf02e6,0xdb150300}},	//   _gebu, week, ्रिं, _dezò, 
   {{0x66090a8b,0xac9417d2,0xe73600fd,0x6d4000c2}},	//   teek, _чарш, дещ_, _ümar, 
   {{0x7bdc1ae9,0x7e6d3879,0xb5fd00ef,0xdb260116}},	//   _zdru, nnap, dišc, _توفی, 
   {{0x5fbf000d,0x66090af8,0x14dd00a2,0x81cc0086}},	//   ्राल, reek, _मिळण, _লাল_, 
   {{0x68e4057f,0x6609387a,0x7e6d387b,0xb4ad009a}},	//   áide, seek, hnap, _कढी_, 
   {{0x7e6d1a77,0x91e6387c,0x21200065,0x420a387d}},	//   knap, моне, _srih_, онно_, 
   {{0xd9ff0bf5,0x9f580126,0x68e40098,0x7bc5007a}},	//   ोजित_, perú_, šide, hbhu, 
   {{0x7e6d387e,0x68eb02dc,0x290f0026,0xd4350038}},	//   dnap, nugd, nwga_, _يعتب, 
   {{0xe8000cb8,0xa91d014b,0x67210a1a,0xd49b387f}},	//   ल्पा_, _lyžo, _krlj, _уре_, 
   {{0xa0a33880,0x7bce3881,0x10a33882,0x00000000}},	//   тард, _rebu, тирн, --, 
   {{0x7bce3883,0x67210112,0x7ae500d2,0x7bdc00bc}},	//   _sebu, _mrlj, drht, _sdru, 
   {{0x7bce02a2,0x62843884,0x2bb20366,0x6296040c}},	// [2a80] _pebu, _ikio, _जलदा, _ihyo, 
   {{0x1daa0790,0x7bce0248,0x67210372,0x8b6a0093}},	//   _कलकत, _qebu, _orlj, оизв_, 
   {{0x28e00586,0x3cea00a5,0x7bce010c,0x00000000}},	//   _निहि, _चमके_, _vebu, --, 
   {{0x1bf00262,0x7bce3885,0x53360070,0x00000000}},	//   _चावल_, _webu, ונען_, --, 
   {{0x7bce3886,0x83fc00ef,0xb17b0343,0x644f01dd}},	//   _tebu, hiđa, lgår, īcij, 
   {{0x7bdc02f5,0x59cc000d,0x6721090e,0x7e643887}},	//   _udru, ारहर, _brlj, liip, 
   {{0xb17b0430,0x2bc429b0,0x68e4007a,0x28e01446}},	//   ngår, _ल्या, áidb, _निवि, 
   {{0x44203888,0x67210571,0x15143889,0x7c3c2278}},	//   _şi_, _drlj, едия, _horr, 
   {{0x7c3c388a,0x6d44388b,0xd838034c,0x68e400ca}},	//   _korr, nyia, _liči_, šidb, 
   {{0xdb1c03a9,0x62840053,0x7c3c01f1,0x6721044e}},	//   _berø, _akio, _jorr, _frlj, 
   {{0x67210613,0xbddb0237,0x00000000,0x00000000}},	//   _grlj, _klèt, --, --, 
   {{0x81e20086,0x63ad388c,0xb17b0343,0xb5fd0d9d}},	//   ন্স_, _şant, dgår, rišc, 
   {{0xa1940451,0x62960102,0xbddb011c,0x7c3c0326}},	//   каюч, _dhyo, _mlèt, _oorr, 
   {{0x7c3c388d,0x628400b4,0x78a8107c,0x00000000}},	//   _norr, _ekio, _jidv, --, 
   {{0xe800148e,0x9f5f0c05,0x7522026e,0xb5fd003a}},	//   ल्या_, _ürün_, _hroz, liša, 
   {{0x443c0c1a,0x7e640102,0xe3b804a8,0x00000000}},	//   _hov_, giip, lcı_, --, 
   {{0x443c388e,0x660200c5,0x4fc7388f,0x7c3c3890}},	// [2a90] _kov_, _mbok, _осна, _borr, 
   {{0x7c3c3891,0xe3b805b7,0x6f05001b,0xbddb0118}},	//   _corr, ncı_, _tphc, _alèt, 
   {{0x443c3892,0x7c3c3893,0x60cd016a,0xda7b01a2}},	//   _mov_, _dorr, _hwam, ояд_, 
   {{0x60cd3894,0x443c3895,0x625600ef,0x75223896}},	//   _kwam, _lov_, nšop, _oroz, 
   {{0x7c3c35fd,0xa80301f0,0x6e3d012b,0x6721044e}},	//   _forr, _çıkt, _iosb, _srlj, 
   {{0x672104d1,0x60cd3897,0x7c3c3898,0x66023899}},	//   _prlj, _mwam, _gorr, _abok, 
   {{0x3949389a,0xddc402ee,0x60cd01a3,0x98bf008f}},	//   šas_, lniš, _lwam, ırım_, 
   {{0x83fc090b,0x75220a1a,0x7c3c1128,0xddc4389b}},	//   viđa, _broz, _zorr, oniš, 
   {{0x75222259,0xd7fb389c,0x6e3d021e,0xc8f400fd}},	//   _croz, _муж_, _mosb, _изтъ, 
   {{0x443c1124,0x20cd389d,0x67210112,0xdd220218}},	//   _cov_, dži_, _trlj, hîşt, 
   {{0x443c389e,0x60cd389f,0x798908a1,0x63ad38a0}},	//   _dov_, _awam, _hyew, _şans, 
   {{0x23bf05f6,0xd8380613,0x60cd2834,0xd57515a7}},	//   _श्रद, _riči_, _bwam, _пуль, 
   {{0x752238a1,0x1bf00081,0xddc4133e,0xc56b0411}},	//   _groz, _चालल_, jniš, _بحال_, 
   {{0x6aa938a2,0xddc416ef,0x653a00c7,0x44f90300}},	//   _lief, dniš, _מענד, mè_, 
   {{0x44f90cd7,0xfe780161,0x6619115a,0x1e9638a3}},	//   lè_, дүн_, _kawk, ерар, 
   {{0x661b38a4,0xb17b0c29,0x62840548,0x443c006f}},	//   nduk, rgår, _ukio, _zov_, 
   {{0xfce338a5,0x60cd01a3,0x44f906df,0x1d070665}},	// [2aa0] лото, _gwam, nè_, нети_, 
   {{0x443c01c1,0x7e7b034c,0x7d1b003d,0x31570070}},	//   _xov_, čupa, _ġust, _ניין_, 
   {{0x7c3c38a6,0x6d4438a7,0x798903a0,0x6aa938a8}},	//   _vorr, syia, _ayew, _bief, 
   {{0xddc411c8,0x7ae338a9,0x661b1a35,0x2bb2072f}},	//   bniš, ánta, jduk, _जलवा, 
   {{0x28f838aa,0x6aa90511,0x44f906df,0x7c3c38ab}},	//   фель_, _dief, jè_, _torr, 
   {{0x752438ac,0x98a338ad,0x661b08f9,0x76492bc3}},	//   _šizo, гиче, eduk, ekey, 
   {{0x443c01c1,0x09e602fb,0x798938ae,0x201a27e8}},	//   _rov_, _повн, _eyew, _mapi_, 
   {{0x752238af,0x443c38b0,0xfaa31628,0x661b0495}},	//   _proz, _sov_, _басо, gduk, 
   {{0x443c01a0,0xc8ca20b4,0x09cc0790,0xbddb023e}},	//   _pov_, _روان_, ारीय, _klèr, 
   {{0xa2b40081,0x60cd38b1,0x61f624bc,0x07a61afd}},	//   _ईंद्, _rwam, _acyl, _зазн, 
   {{0x443c38b2,0xddc4008b,0xcf120086,0x3946010e}},	//   _vov_, zniš, হমুদ_, lyos_, 
   {{0xb5fd38b3,0x764938b4,0x752238b5,0x201a07fc}},	//   lišn, ckey, _troz, _aapi_, 
   {{0x81a900cc,0x443c38b6,0x26190f63,0x39460019}},	//   খুন_, _tov_, _मोटी_, nyos_, 
   {{0x201a38b7,0xb5fd38b8,0xc5692e10,0x229238b9}},	//   _capi_, unšv, _تحمل_, ráka_, 
   {{0x141b00d1,0x6e3d38ba,0xddd40613,0x00000000}},	//   _מוגב, _posb, _šaša, --, 
   {{0x6d1c07d5,0xddc41af7,0xbddb00b9,0x60cd38bb}},	//   निंग_, tniš, _alèr, _twam, 
   {{0x30a70091,0x313524d9,0x22ac00bc,0x2a660082}},	// [2ab0] _пров, _репр, _věku_, diob_, 
   {{0xb5fd04d1,0xddc4008b,0x7989016a,0x63ba38bc}},	//   jišn, rniš, _ryew, nctn, 
   {{0xb5fd02f5,0xddc40112,0x5b241c0f,0xcfb600a7}},	//   dišn, sniš, льца, _בלתי_, 
   {{0x44f906df,0xd8380864,0xddc40813,0x3cea009a}},	//   yè_, _miču_, pniš, _चमचे_, 
   {{0xca7438bd,0x201a38be,0x00000000,0x00000000}},	//   دالغ, _yapi_, --, --, 
   {{0x6bd40a67,0xd94238bf,0x201a00b4,0x661900a1}},	//   _متفر, реши, _xapi_, _sawk, 
   {{0x6aa901c4,0xd838015e,0x79c900eb,0x394606e4}},	//   _tief, _niču_, _يوسف_, ayos_, 
   {{0x9a8403dd,0x44f906df,0x3946011c,0x7bd700da}},	//   _буул, tè_, byos_, laxu, 
   {{0x764938c0,0xb5fd05ae,0x3d17009a,0x661b38c1}},	//   rkey, bišn, निटे_, rduk, 
   {{0xd8380082,0x44f903a0,0x7bd70210,0x03a502a6}},	//   _biču_, rè_, naxu, кипо, 
   {{0x201a2e67,0x3a3f06df,0x44f90300,0x3a2d05ac}},	//   _rapi_, _koup_, sè_, _knep_, 
   {{0x216a38c2,0x201a38c3,0x44f938c4,0x3ce90d17}},	//   дими_, _sapi_, pè_, krav_, 
   {{0xd1760d18,0x212400eb,0x6486008c,0x9f5801d5}},	//   тыны, ímh_, gðis, rfrí_, 
   {{0x3a3f21d0,0xb05b0c98,0xa506314f,0x00000000}},	//   _loup_, spän, _реша_, --, 
   {{0xe1ff38c5,0xfc3f145a,0x627a0e65,0x7bd700b4}},	//   mión_, _luís_, _осиё_, daxu, 
   {{0x201a0010,0x224b38c6,0x3dc90495,0x33760486}},	//   _wapi_, ckck_, gbaw_, _בעצם_, 
   {{0x201a3200,0xbea338c7,0xe7f2009a,0xe7d10c46}},	// [2ac0] _tapi_, ратк, _घाला_, हराप, 
   {{0xe1ff0f97,0xf1a700bc,0x3eab0027,0x224000b4}},	//   nión_, _गणतन, _eict_, _hoik_, 
   {{0xb5fd0062,0x3a3f0237,0x8fa60165,0x00000000}},	//   višn, _boup_, _јане, --, 
   {{0x3a3f026d,0xc3320486,0x9f5800b9,0x00000000}},	//   _coup_, יוב_, mfrà_, --, 
   {{0x99dd0118,0xc7b80613,0x3ea038c8,0xee3700b3}},	//   _alňs, _lađe_, mmit_, _рня_, 
   {{0xdb1c006b,0x3ea038c9,0xb7d80038,0x39460102}},	//   _kerü, lmit_, روبا_, ryos_, 
   {{0xc7b80062,0xb5fd032f,0x7c2e38ca,0x81d90033}},	//   _nađe_, rišn, _inbr, ালত_, 
   {{0xeb971ca5,0x9f580126,0x692600b3,0x5eea00bc}},	//   _рис_, leró_, _имба, _छिन्_, 
   {{0x4a750f6b,0x00000000,0x00000000,0x00000000}},	//   _сырт, --, --, --, 
   {{0xe1ff38cb,0x9f580327,0xb5fd23f2,0x3ea00034}},	//   gión_, neró_, bišo, hmit_, 
   {{0x22520876,0x3a3f01d2,0x25bd0090,0x00000000}},	//   _blyk_, _youp_, _ffwl_, --, 
   {{0xdb1c38cc,0xacbb0107,0x550603a1,0x3ea038cd}},	//   _heró, _brûl, _ачка, jmit_, 
   {{0xe1ff0496,0x81cc0086,0x7c2e11da,0x00000000}},	//   bión_, _লাখ_, _onbr, --, 
   {{0xe1ff38ce,0x545338cf,0xd838090b,0x14d70137}},	//   ción_, _квіт, _tiču_, _יודל_, 
   {{0x3eab02a2,0x9f5804b3,0x5c750176,0x00000000}},	//   _pict_, deró_, ҳлат, --, 
   {{0x320f006b,0x02a40238,0x5bcb102c,0x7c2e38d0}},	//   _úgy_, _крым, िर्व, _anbr, 
   {{0x3c49009e,0x5c7538d1,0xcc990267,0x3eab016c}},	// [2ad0] _nîvê_, глат, евац_, _vict_, 
   {{0x7ae338d2,0x3a2d38d3,0x3a3f38d4,0x4d981193}},	//   ánto, _snep_, _soup_, ткую_, 
   {{0x629f00fd,0xe81d07d5,0x3ea000a7,0x201138d5}},	//   _èpos, _योगा_, bmit_, mezi_, 
   {{0x3ce902ee,0x201138d6,0x7c2e01d6,0x3ce61ca7}},	//   prav_, lezi_, _enbr, šova_, 
   {{0x26de38d7,0x9f5806a5,0x99d400d7,0x628f023e}},	//   _avto_, beró_, شتنا, ilco, 
   {{0x201138d8,0xe1ff1056,0x81d90033,0x9f5800f6}},	//   nezi_, xión_, ালি_, ceró_, 
   {{0x27e9091f,0x8aa708a5,0xead40ccb,0x2a640054}},	//   ğan_, _арад, _вось, _fmmb_, 
   {{0x27e93852,0x1dd30081,0x442e0626,0x3a2d1572}},	//   şan_, तरित, _anf_, _unep_, 
   {{0xe1ff1cf0,0x2a640141,0x442e38d9,0xe8001493}},	//   tión_, _търг, _bnf_, ल्हा_, 
   {{0x69d938da,0x3ea000e5,0x42c903a1,0x20110808}},	//   lawe, zmit_, нгон_, jezi_, 
   {{0x7bd538db,0x25af02cd,0x32460a31,0x9f5801d8}},	//   _mezu, _tggl_, генг, herò_, 
   {{0xe1ff128e,0x69d9086d,0xddd6026e,0xdb0538dc}},	//   sión_, nawe, chyň, lchó, 
   {{0x648601d5,0x2240040b,0x2fd80083,0x00000000}},	//   rðir, _voik_, targ_, --, 
   {{0x201138dd,0xdb1c0068,0x9f5809bd,0x69d938de}},	//   gezi_, _xeró, derò_, hawe, 
   {{0x69d938df,0x2d8f01c4,0x37d80033,0x9f580369}},	//   kawe, ügen_, _সামর, veró_, 
   {{0x69d938e0,0xdb050038,0x229938e1,0x3ea00f44}},	//   jawe, hchó, téke_, umit_, 
   {{0x3ea038e2,0x628638e3,0x7bd538e4,0x69d938e5}},	// [2ae0] rmit_, moko, _bezu, dawe, 
   {{0x628638e6,0x09cc0e17,0xdb1c0019,0x3ea038e7}},	//   loko, ार्य, _terü, smit_, 
   {{0x27230749,0x7bd538e8,0xdb1c03dd,0x8cb00083}},	//   _nın_, _dezu, _aerò, _अंको, 
   {{0x248538e9,0x69d938ea,0x9f4100e9,0x80cb109f}},	//   holm_, gawe, _echó_, तीके, 
   {{0x1ae036bc,0x186a25dc,0x9f5838eb,0x09e338ec}},	//   _पटकथ, нади_, peró_, сочн, 
   {{0x628638ed,0x7bd538ee,0x98732072,0x26dc02fe}},	//   hoko, _gezu, бліц, tsvo_, 
   {{0xeb9738ef,0x628638f0,0xdb1c033c,0x69d938f1}},	//   _бир_, koko, _veró, bawe, 
   {{0x60c438f2,0x61e42223,0x2bc0048e,0x201121b3}},	//   _otim, _ndil, शुरा, zezi_, 
   {{0x20112bba,0xb21b01e8,0x29560093,0x60c402b8}},	//   yezi_, klær, _съвр, _ntim, 
   {{0xe64404be,0x59cc00bc,0xb7b50210,0x20110474}},	//   ılış, ारकर, _hạn, xezi_, 
   {{0x60c438f3,0x439438f4,0x628638f5,0x201138f6}},	//   _atim, ранс, foko, vezi_, 
   {{0x201138f7,0xe45206bc,0x628638f8,0x61e400a1}},	//   wezi_, _گفتگ, goko, _cdil, 
   {{0x201138f9,0x61e40156,0x9f41023e,0xb7b50023}},	//   tezi_, _ddil, _idhé_, _mạn, 
   {{0x61e438fa,0x9f5801d8,0x27170095,0xf5930038}},	//   _edil, verò_, _sənə_, _الهج, 
   {{0x201138fb,0xa91d0254,0x69d938fc,0xda040179}},	//   rezi_, _vyži, yawe, रभात_, 
   {{0x7bd538fd,0x628638fe,0x7642016a,0x9f5802a3}},	//   _sezu, coko, _jooy, terò_, 
   {{0xdb0501c4,0x32090102,0xe6d11432,0x7bd50034}},	// [2af0] schü, _ibay_, _सब्ज, _pezu, 
   {{0x69c038ff,0x69d90010,0x9f5801d8,0x2129009c}},	//   _afme, wawe, rerò_, _irah_, 
   {{0x7bd50f23,0x5b1500dc,0x8af90fcc,0x69d93900}},	//   _vezu, рмет, тнес_, tawe, 
   {{0x7f3a00c7,0x2129024a,0x7d1600f8,0xd0110019}},	//   _סערו, _krah_, bwys, _الگ_, 
   {{0x69d93901,0x6728023e,0xe0df3902,0x65ab0248}},	//   rawe, _ardj, nsò_, _möhü, 
   {{0xe8002290,0xb34601f0,0x67280ab4,0x635300ad}},	//   ल्ला_, _kaçı, _brdj, sənə, 
   {{0xe7393903,0x62863904,0x76423905,0x39b90a65}},	//   тей_, yoko, _booy, _албэ_, 
   {{0x8aa43906,0x21290397,0xb5fd0009,0xb346027e}},	//   _груд, _orah_, mišk, _maçı, 
   {{0xb5fd3907,0xf1c800bc,0x76423908,0x543524eb}},	//   lišk, ndář_, _dooy, ахну, 
   {{0x62863909,0x3209390a,0x588700f0,0x290d019c}},	//   woko, _abay_, _сыба, _ipea_, 
   {{0x6286390b,0x212909c2,0xb5fd3907,0xe29a0886}},	//   toko, _arah_, nišk, као_, 
   {{0x51561d06,0x69ac00aa,0x5694390c,0x5435039f}},	//   атгу, ुँची, _лахт, ارکر, 
   {{0x6286390d,0x2129023e,0x2d8f0380,0xb5fd0352}},	//   roko, _crah_, ügel_, hišk, 
   {{0x9f58008c,0x25bf390e,0xb5fd012d,0x7e660065}},	//   ferð_, lcul_, kišk, _smkp, 
   {{0x6286390f,0x9f58008c,0xb5fd3910,0x764202a5}},	//   poko, gerð_, jišk, _yooy, 
   {{0x25bf04bb,0x13da0086,0x64433911,0x21290379}},	//   ncul_, _দায়, _honi, _frah_, 
   {{0x64433912,0x21291e27,0xb21b00dd,0x60c4190c}},	// [2b00] _koni, _grah_, plær, _utim, 
   {{0x64433913,0x7d16018c,0x26c50026,0xddd50243}},	//   _joni, rwys, _otlo_, ābša, 
   {{0x64433914,0xb5fd012d,0xc7b80ab4,0xe9da3915}},	//   _moni, gišk, _nađa_, вке_, 
   {{0xa9263916,0x62872867,0x6aa20c28,0xdb1e0080}},	//   идел, čkog, umof, kapö, 
   {{0xd37803ef,0x672807c7,0x76423917,0x2ba73918}},	//   maće_, _srdj, _rooy, केबा, 
   {{0xdb1c010d,0x76420110,0x64433919,0x6aa2391a}},	//   _ferð, _sooy, _noni, smof, 
   {{0xdb1c010d,0x290d0a9f,0xd9af009a,0xd7f800a3}},	//   _gerð, _epea_, टशॉट, вуқ_, 
   {{0x9634391b,0x7e760626,0xddcd020f,0x960a012d}},	//   сниц, nnyp, mnaţ, тэка_, 
   {{0xd90e1fdb,0xd49a391c,0x26c50415,0x3ce2011c}},	//   _آیت_, кро_, _etlo_, _jvkv_, 
   {{0x656f391d,0x7642391e,0x32090102,0x66e6391f}},	//   úcha, _wooy, _sbay_, _вожа, 
   {{0xc5e800cc,0x0bb70056,0x6f0900ab,0xc7b8015e}},	//   ক্ষা_, ילים_, łecz, _gađa_, 
   {{0xd378265d,0x4394212c,0x2129203b,0x9f58003e}},	//   jaće_, _қайс, _prah_, verð_, 
   {{0xdfdb0141,0x64433920,0xd37800d0,0x316801a2}},	//   къв_, _foni, daće_, ашро_, 
   {{0x64433921,0x64a33922,0xd48f004f,0xe0df0036}},	//   _goni, _дача, _єр_, rsò_, 
   {{0x09d70086,0xe0df13cb,0x6e670bf8,0xdfd500f0}},	//   _হাসা, ssò_, атаж, _қоны, 
   {{0xb5fd012d,0x443e0219,0xd3780097,0x877b0070}},	//   višk, ljt_, gaće_, דאלי, 
   {{0x656d0187,0x64433923,0x2129008b,0x2d8f055f}},	// [2b10] _ľahk, _yoni, _urah_, æge_, 
   {{0xa8020e03,0xb5fd012d,0x270e0095,0x8bc70258}},	//   çıla, tišk, _kənd_, рсад, 
   {{0xfbab11ec,0xd3780f23,0x95ff0033,0x6aa302b0}},	//   ттай_, baće_, ্যতম_, ïnfo, 
   {{0xdb1c06b6,0xb5fd3907,0xc7b8090b,0xd3780082}},	//   _verð, rišk, _rađa_, caće_, 
   {{0x645a030c,0x634a06d0,0xb5fd012d,0x692500a3}},	//   khti, lənd, sišk, смла, 
   {{0x8934006b,0x1ed80274,0x7e6d0cfe,0xb5fd0028}},	//   تعما, _حبیب_, liap, pišk, 
   {{0x81e200cc,0x6d4d3924,0x36693925,0x7d0f023e}},	//   ন্ট_, lyaa, лако_, _hpcs, 
   {{0x64433926,0xe6193927,0x80b800cc,0x44293928}},	//   _soni, уди_, _অবস্, _şa_, 
   {{0x64433929,0xb5fd0c1b,0x25bf00d9,0xd54900c8}},	//   _poni, niši, rcul_, уппе_, 
   {{0x628d187e,0x25bf222f,0x6d4d02a5,0x2ab7008a}},	//   _akao, scul_, iyaa, _aħbi_, 
   {{0xd7950084,0x6443392a,0x7e6d21d8,0x62580183}},	//   _الاخ, _voni, kiap, _nãoc, 
   {{0xc049392b,0x64430536,0x425623de,0x2299200a}},	//   _אז_, _woni, стот, téka_, 
   {{0xd378003a,0x2ba700a2,0x6443392c,0xc29900d9}},	//   vaće_, केता, _toni, ртэц_, 
   {{0x645a392d,0xa076005e,0x10a6002e,0x2299392e}},	//   chti, сымш, сигн, réka_, 
   {{0xd3782cd9,0x934500d9,0xddc40474,0x00000000}},	//   taće_, _ынке, ghiş, --, 
   {{0x765b392f,0x6d4d018e,0x7e6d3930,0x00000000}},	//   nhuy, fyaa, giap, --, 
   {{0xd37801b4,0x6da33931,0x101605e0,0x6d4d3932}},	// [2b20] raće_, зита, _льня, gyaa, 
   {{0x3ce03933,0xd378032f,0xb3d50033,0x00000000}},	//   rsiv_, saće_, _দাঁড়, --, 
   {{0x6d4d3934,0xff260c19,0xeafa009c,0xd3781c2b}},	//   ayaa, _умно, طرات_, paće_, 
   {{0xeb9715dd,0x6d4d01b8,0xddcd00d9,0xb5fd0242}},	//   щих_, byaa, rnaţ, biši, 
   {{0xdd92195e,0x2d840107,0x645a00c8,0x00000000}},	//   _روس_, _âme_, yhti, --, 
   {{0x799b044d,0x99dd0098,0xb90000c9,0x6e240067}},	//   _dzuw, _voňa, _दब_, ldib, 
   {{0x6b633935,0x368a1cb8,0x09d70086,0x04200086}},	//   _екра, лсин_, _হারা, বামী_, 
   {{0x6e243936,0xdb1c014e,0x645d00e5,0xceb300a7}},	//   ndib, _berö, ësin, היה_, 
   {{0x7d043937,0xb05b00c8,0xfaa31cc1,0x3eba0474}},	//   ntis, späi, _хато, _lupt_, 
   {{0x7bde3938,0xe7f204bd,0x634a06d0,0x7d043939}},	//   napu, _घाटा_, yənd, itis, 
   {{0x7d04393a,0x539800dd,0x9f45008f,0xe9ff0023}},	//   htis, рвня_, ülü_, _xoắn_, 
   {{0x645a393b,0x7d040f2d,0x7ae30634,0xf363393c}},	//   shti, ktis, ánti, ятын, 
   {{0x7bde393d,0x68e2393e,0xc05b004f,0x6e24393f}},	//   kapu, nsod, гів_, ddib, 
   {{0x80b80086,0x634a0095,0x7bde3940,0x612e0054}},	//   _অবশ্, tənd, japu, _sôlô, 
   {{0x6fda0c8f,0x7e6d3071,0xe3b80384,0x612e0054}},	//   _बजरं, tiap, ndım_, _pôlô, 
   {{0xdceb143b,0x7d043941,0x6e243942,0x3d14007e}},	//   žičk, ftis, gdib, _नईखे_, 
   {{0x32d2009e,0x68e20121,0x7d043943,0x0dc81d06}},	// [2b30] bûyî_, jsod, gtis, суси_, 
   {{0x7e6d19e0,0xb5fd090e,0x68e23944,0x5ba73945}},	//   siap, riši, dsod, брез, 
   {{0x6d4d03f6,0x6e242244,0xb5fd0097,0x200400ad}},	//   syaa, bdib, mišv, əmi_, 
   {{0xb5fd1a44,0x27fe0242,0xac1800f0,0x5a353946}},	//   piši, _actn_, _қосу_, юнет, 
   {{0xab620824,0x645815c4,0xe9d80904,0x7d043947}},	//   _çünk, _olvi, скі_, ctis, 
   {{0xdb1e0054,0xe9d90083,0x00000000,0x00000000}},	//   tapô, _weź_, --, --, 
   {{0x70b50035,0x765b3948,0x00000000,0x00000000}},	//   ंदुल, thuy, --, --, 
   {{0x245b0518,0x248e0379,0x79960083,0x656f3949}},	//   _même_, _akfm_, żywa, úcho, 
   {{0x1fa618b4,0xe4590925,0x69db00f8,0x29190118}},	//   _खण्ड, ижи_, _ieue, _èsa_, 
   {{0xdb1c394a,0x69db033e,0x7c25394b,0x765b016c}},	//   _verö, _heue, ndhr, shuy, 
   {{0x2c0b00bd,0x69db002c,0x765b007c,0x00000000}},	//   स्यं_, _keue, phuy, --, 
   {{0x7bde394c,0xa3b50527,0x7d0419b6,0x7de60019}},	//   zapu, _झलक_, ytis, _késő, 
   {{0x7bde394d,0xe820000d,0xdb1c0054,0x69db394e}},	//   yapu, _यसमा_, _herô, _meue, 
   {{0x9f58026a,0x660914d2,0x69db394f,0xddcd0ab4}},	//   lgré_, lfek, _leue, vnaš, 
   {{0xe29a3950,0x1faa2918,0x7bde2b92,0x75293951}},	//   _как_, ркви_, vapu, lvez, 
   {{0x69db02ec,0x7bde2b03,0x6e242259,0xe1ff0035}},	//   _neue, wapu, udib, diów_, 
   {{0x7bde2a85,0x0eb6000f,0xd3780112,0x1c460115}},	// [2b40] tapu, _आंकड, maća_, онам, 
   {{0x765902bf,0x212000c5,0x6e243952,0x8b963953}},	//   _llwy, _isih_, sdib, ореч, 
   {{0x8fa63954,0x3bd500c8,0x69db3955,0x9f0617bc}},	//   _фане, яютс, _beue, _بوجو, 
   {{0x20183956,0x212002cd,0x634a0095,0x7ff6015f}},	//   leri_, _ksih_, lənc, _اسکا, 
   {{0x69c20496,0x7bde3957,0xcaa500eb,0xdca60161}},	//   rcoe, papu, أصلي, _мами, 
   {{0x20183958,0xab2a0d43,0x75290019,0x212012c7}},	//   neri_, _кога_, dvez, _msih_, 
   {{0xf8bf0b32,0x66090f96,0x68e23959,0x69db01c4}},	//   _één_, ffek, ssod, _feue, 
   {{0x7bdc395a,0x68e2395b,0xe3b8091f,0x2018395c}},	//   _heru, psod, rdım_, heri_, 
   {{0x7bdc395d,0xd3780e67,0xdb210080,0xbddb0237}},	//   _keru, daća_, ätös, _plèz, 
   {{0x201802f5,0xddc41c77,0x344a142c,0x29060548}},	//   jeri_, jniž, рчин_, mtoa_, 
   {{0x7bdc2e7b,0x765902bf,0x2120395e,0xdb0501c4}},	//   _meru, _flwy, _asih_, schö, 
   {{0x7bdc395f,0xbddb0107,0x7529203b,0x29063887}},	//   _leru, _poèm, bvez, otoa_, 
   {{0xe5343960,0x29063961,0xddcd00bc,0xe3af0019}},	//   _хель, ntoa_, chař, ٹری_, 
   {{0x20181ba8,0xe3af0019,0x270e0095,0x9597027a}},	//   geri_, عری_, _gənc_, _וכדו_, 
   {{0x6abc02cd,0xcddb0843,0x212000d7,0xff04134f}},	//   _nurf, иња_, _esih_, мятн, 
   {{0x7bdc3962,0x290601d6,0x2018052b,0x00000000}},	//   _aeru, ktoa_, aeri_, --, 
   {{0x7bdc3963,0x20183964,0x69db033e,0xb5fd1a35}},	// [2b50] _beru, beri_, _reue, mišt, 
   {{0xb5fd02f5,0x20183965,0x7bdc3966,0x69db3967}},	//   lišt, ceri_, _ceru, _seue, 
   {{0x7bdc3968,0x20013969,0x69db396a,0x6abc007a}},	//   _deru, _ichi_, _peue, _curf, 
   {{0x61fd1950,0x78bb06a6,0x3219023a,0x81d90086}},	//   ngsl, _puuv, nesy_, ালক_, 
   {{0x3ea9030f,0x61fd1e86,0x7bdc396b,0x69db022c}},	//   mmat_, igsl, _feru, _veue, 
   {{0x7bdc0bf3,0x3ea9396c,0xb5fd008b,0xeafb0499}},	//   _geru, lmat_, hišt, _پرست_, 
   {{0x7bc5396d,0x69db01c4,0x645d0034,0x7d190585}},	//   mchu, _teue, ësim, şası, 
   {{0xe9df06b6,0xb5fd0e25,0x9a8400f6,0x2249396e}},	//   _þú_, jišt, _жуул, _noak_, 
   {{0x1958058b,0x7bdc396f,0x1c0b000d,0x1a6800d4}},	//   _даты_, _yeru, स्थल_, _بینی_, 
   {{0x20012083,0x7529006b,0x7bc53970,0x7bdc0042}},	//   _nchi_, rvez, nchu, _xeru, 
   {{0x3ea92998,0x7ae5024a,0x44250415,0xb5fd02fe}},	//   kmat_, nsht, rdl_, fišt, 
   {{0x6721015e,0x20183971,0x7bc53772,0x6446010c}},	//   _islj, weri_, hchu, êkir, 
   {{0x20183972,0x3ea90938,0xd3780112,0x55ba00d1}},	//   teri_, dmat_, raća_, _המנו, 
   {{0x394000c8,0xb5fd3973,0x2a7f0352,0x7bc500da}},	//   äisi_, rišu, _ljub_, jchu, 
   {{0x7bdc3974,0x20183975,0x43750137,0x634a00ad}},	//   _reru, reri_, _מײַן_, rənc, 
   {{0x7bdc3976,0x3ea93977,0xb5fd015e,0xf1bf001d}},	//   _seru, gmat_, cišt, ldán_, 
   {{0x7bdc27a5,0x20183978,0x6abc3979,0x0d9a0009}},	// [2b60] _peru, peri_, _surf, ствы_, 
   {{0xf1bf397a,0x8fa6397b,0x2a7f0175,0x20180034}},	//   ndán_, _напе, _ajub_, qeri_, 
   {{0x7bdc397c,0x2ba70c14,0x68f901c8,0x1c020035}},	//   _veru, केला, euwd, र्गल_, 
   {{0xfc3f03da,0x7bdc397d,0x290600c8,0xda650195}},	//   _xuíz_, _weru, ttoa_, واني, 
   {{0x7bdc0348,0xa9a6286c,0x3a26000b,0xf918009c}},	//   _teru, чидд, rdop_, تراژ_, 
   {{0x7bc5397e,0xb5fd0704,0x2a7f397f,0x6e260c36}},	//   cchu, zišt, _ejub_, _hakb, 
   {{0x29063980,0x98a4020f,0xc66a0080,0x7ae53981}},	//   stoa_, _armă_, йшие_, csht, 
   {{0xb86600d6,0xa5343982,0x6e260035,0xddc40035}},	//   _کارو, днич, _jakb, jniż, 
   {{0xb5fd2365,0xfc3f1771,0x6e263983,0x32190032}},	//   višt, _ruíz_, _makb, vesy_, 
   {{0x3ea900cf,0x6e263984,0x83860259,0xe9ff0210}},	//   zmat_, _lakb, зыме, _toản_, 
   {{0xb5fd282b,0x04fe0086,0x3ea93985,0x22490054}},	//   tišt, ্টের_, ymat_, _poak_, 
   {{0x20013986,0x76bb00d1,0x3ea900a3,0x00000000}},	//   _schi_, _המאפ, xmat_, --, 
   {{0xb5fd02f5,0x321933c6,0x7bc53987,0x61fd09ad}},	//   rišt, resy_, ychu, rgsl, 
   {{0x04200086,0xb5fd0242,0x32190180,0x75220a4c}},	//   বাহী_, sišt, sesy_, _isoz, 
   {{0xb5fd031e,0xe9ff001b,0x6e263988,0x98a60097}},	//   pišt, _loạn_, _bakb, jvoč_, 
   {{0x5f943989,0x644a398a,0x5eb42010,0x3ea9398b}},	//   хист, _hofi, ейст, umat_, 
   {{0x7bc50204,0x628f0187,0x644a398c,0x61ed0204}},	// [2b70] tchu, moco, _kofi, _idal, 
   {{0x5ba7062a,0x60cd398d,0x628f2953,0x20012504}},	//   през, _itam, loco, _uchi_, 
   {{0xead9005e,0x7bc5398e,0x644a0026,0x66020082}},	//   імді_, rchu, _mofi, _ocok, 
   {{0x7bc5398f,0x7ae500e5,0x6e263990,0xfaf0070f}},	//   schu, rsht, _gakb, اثل_, 
   {{0xa95400dd,0x08c4004e,0x0e0201a2,0x61ed3991}},	//   нкці, ебін, _шӯро, _mdal, 
   {{0xf77009e8,0x60cd2f53,0x644a3992,0x7ae5024a}},	//   گاه_, _mtam, _nofi, psht, 
   {{0x16a93993,0x628f3994,0x61ed3995,0xaa6702f1}},	//   овки_, koco, _odal, _етак, 
   {{0x61ed3996,0x7c273997,0x60cd3998,0x2a7f3999}},	//   _ndal, _hajr, _otam, _ujub_, 
   {{0x68e400eb,0x60cd01eb,0x644a399a,0x7c27399b}},	//   áidt, _ntam, _bofi, _kajr, 
   {{0x61ed399c,0x644a399d,0x55ff0033,0x68e9399e}},	//   _adal, _cofi, ্যেক_, _ived, 
   {{0x60cd399f,0x1c020964,0x672104a1,0x628f39a0}},	//   _atam, र्टल_, _uslj, foco, 
   {{0x628f0068,0x68e936a4,0x76960216,0x00000000}},	//   goco, _kved, rûyê, --, 
   {{0x98a400d9,0x61ed39a1,0x6e2639a2,0x644a39a3}},	//   _urmă_, _ddal, _rakb, _fofi, 
   {{0x764b006b,0x7c2739a4,0x661b39a5,0x61ed39a6}},	//   _hogy, _najr, leuk, _edal, 
   {{0x628f39a7,0x28dd2569,0x92e800eb,0xe1ff39a8}},	//   boco, नीति, _فريق_, giós_, 
   {{0x442739a9,0x644a39aa,0x661b39ab,0xf1bf11d1}},	//   _han_, _zofi, neuk, ndál_, 
   {{0x4427238e,0x7c2739ac,0x644a39ad,0xfce30088}},	// [2b80] _kan_, _bajr, _yofi, кото, 
   {{0xee3903dc,0x442700a7,0x61ed1ea3,0xb05b219b}},	//   онӣ_, _jan_, _zdal, spär, 
   {{0x4427349b,0x6e2639ae,0xe1ff39af,0xa05700c7}},	//   _man_, _takb, ciós_, _חסיד_, 
   {{0x442739b0,0xe1ff00ab,0x7c2701ca,0x49a40259}},	//   _lan_, chód_, _eajr, нылғ, 
   {{0x09e311a8,0x44270023,0xe3e30086,0x7c270537}},	//   точн, _oan_, _মানব, _fajr, 
   {{0x442739b1,0x68e90082,0x69c90026,0xb8e601a4}},	//   _nan_, _dved, _efee, _ईं_, 
   {{0xc87f009e,0xeb970fac,0x644a39b2,0x69c901a3}},	//   îşan_, _жир_, _rofi, _ffee, 
   {{0x442739b3,0x661b0053,0x7c270035,0x764b00f3}},	//   _aan_, geuk, _zajr, _cogy, 
   {{0x442739b4,0x948611db,0x628f39b5,0xe7cf3604}},	//   _ban_, дынд, voco, _स्वप, 
   {{0x442739b6,0xddd626a4,0x00000000,0x00000000}},	//   _can_, skyň, --, --, 
   {{0x442739b7,0x764b0019,0x68e92645,0xd3700038}},	//   _dan_, _fogy, _zved, اهج_, 
   {{0xc7b839b8,0x442739b9,0x925800c8,0x6602045a}},	//   _nađi_, _ean_, дают_, _ucok, 
   {{0xe8050c15,0x644a0248,0x7522016c,0xe1ff39ba}},	//   _रामा_, _tofi, _usoz, rgó_, 
   {{0x442739bb,0xa3df21c6,0xd4c50038,0x245b009e}},	//   _gan_, तरण_, _أغني, _têma_, 
   {{0x764b39bc,0x2bdd009a,0x3f853063,0x00000000}},	//   _yogy, यरसा, çlu_, --, 
   {{0x61ed39bd,0x442739be,0x7c2700d4,0x2cb8161c}},	//   _udal, _zan_, _sajr, _aird_, 
   {{0x442739bf,0x60cd27c8,0xce940093,0xe1ff39c0}},	// [2b90] _yan_, _utam, татъ, biór_, 
   {{0x442739c1,0x69c9012e,0x4cc80086,0x2299010e}},	//   _xan_, _sfee, _লিখু, déki_, 
   {{0x68e939c2,0x2ef400b3,0xa3df02e6,0x7c2739c3}},	//   _sved, _изэр, तरत_, _vajr, 
   {{0x5ba400d9,0xdd912300,0xdb0e039f,0x37d80033}},	//   труз, _موج_, áján, _সাগর, 
   {{0xe6ed0187,0xcce700eb,0xbd94004e,0x7c2702f1}},	//   _väčš, _تسجي, _ақтө, _tajr, 
   {{0x07a5032c,0xa15800d1,0x00000000,0x00000000}},	//   налн, ובדה_, --, --, 
   {{0x442739c4,0x3eb939c5,0x661b39c6,0x2bae0484}},	//   _ran_, _kist_, teuk, झेदा, 
   {{0x442739c7,0x2d9900c8,0x1c10009a,0x66c70241}},	//   _san_, _kyse_, ठ्ठल_, _cıka, 
   {{0x68e9063b,0x3eb939c8,0xe5790088,0x442717e3}},	//   _uved, _mist_, язи_, _pan_, 
   {{0x3eb939c9,0x442739ca,0x98ad0082,0x00000000}},	//   _list_, _qan_, _kreč_, --, 
   {{0x442739cb,0xe29a39cc,0x2d9901e8,0x3eb9011d}},	//   _van_, зан_, _lyse_, _oist_, 
   {{0x4427055a,0x00000000,0x00000000,0x00000000}},	//   _wan_, --, --, --, 
   {{0xdb1c022b,0x442739cd,0x634a00ad,0x00000000}},	//   _ifrå, _tan_, lənl, --, 
   {{0x442739ce,0x3eb900a1,0x6d4039cf,0x00000000}},	//   _uan_, _aist_, _àmai, --, 
   {{0x3eb939d0,0x66c7027e,0x6d4b02ae,0x32290080}},	//   _bist_, _yıka, ägan, ötyä_, 
   {{0x3eb939d1,0x2d9903c6,0x00000000,0x00000000}},	//   _cist_, _byse_, --, --, 
   {{0x61e639d2,0x0d8639d3,0x626b00bc,0x6e9339d4}},	// [2ba0] makl, хлан, třov, القا, 
   {{0x61e639d5,0xa3df109f,0x9f41010c,0x3eb939d6}},	//   lakl, तरि_, _mehê_, _eist_, 
   {{0x09d700cc,0xb3460165,0x20c600e7,0x629602a5}},	//   _হাজা, maçõ, _hôi_, _kkyo, 
   {{0x2cb802e7,0xb34602a0,0x320239d7,0x61e639d8}},	//   _wird_, laçõ, ngky_, nakl, 
   {{0xb4de00b0,0x626b02d9,0xa3df0c97,0x00000000}},	//   _तबे_, přov, तरा_, --, 
   {{0xd6da39d9,0xeee700c5,0x20c6001b,0xb3460165}},	//   пти_, _تغیی, _môi_, naçõ, 
   {{0x4c9302b9,0xf0930111,0x61e639da,0x20c600e7}},	//   _сиёс, אנג_, kakl, _lôi_, 
   {{0x96341fde,0x3eb9010c,0x3546122b,0x7e64025b}},	//   тниц, _xist_, ехов, nhip, 
   {{0x06e0051f,0x61e62d76,0x7afe39db,0x20c60023}},	//   _गौरव_, dakl, lupt, _nôi_, 
   {{0x54543065,0x6d560065,0x629639dc,0xdb1c024a}},	//   твот, iyya, _akyo, _ngrë, 
   {{0x7afe39dd,0xb34602aa,0xd37a39de,0x66c70241}},	//   nupt, daçõ, ячи_, _tıka, 
   {{0x20c600e7,0xa75b0486,0xbddb0118,0x634a00ad}},	//   _bôi_, _מדבר, _inèg, səno, 
   {{0x7e64023e,0x3eb932ba,0x20c60023,0xc68f010e}},	//   dhip, _rist_, _côi_, _اِن_, 
   {{0x3eb902fb,0xb34639df,0x634a0095,0x7afe39e0}},	//   _sist_, gaçõ, lənm, kupt, 
   {{0x61f40219,0x5f9539e1,0xe812009a,0x78ba0502}},	//   ådlö, тивт, ढ्या_, _mitv, 
   {{0x78ba39e2,0x61e601f0,0x439b00a7,0x7e6439e3}},	//   _litv, cakl, _מבוג, ghip, 
   {{0x3eb939e4,0x8d770c72,0x442c0156,0x6702009a}},	// [2bb0] _vist_, رارا, odd_, रंडक_, 
   {{0x645a39e5,0xb34603b7,0xe8050a34,0x3eb9012e}},	//   nkti, caçõ, _राधा_, _wist_, 
   {{0x442c39e6,0x443c0082,0x2d990876,0x7afe39e7}},	//   idd_, _mnv_, _wyse_, gupt, 
   {{0x7e640727,0x59750161,0x7d09020f,0x443c039b}},	//   chip, кылу, _ţesu, _lnv_, 
   {{0x6e3d01c4,0x26de39e8,0x20c60023,0x88c8004f}},	//   _insb, _awto_, _xôi_, елів_, 
   {{0xa3bc130c,0x2003033e,0xc7b800ef,0x443c00ef}},	//   _अलग_, ngji_, _lađu_, _nnv_, 
   {{0x7d0d39e9,0xddcd00d9,0x81e70033,0xdb1c01e5}},	//   ltas, ciaţ, _পান_, _ngrè, 
   {{0xb34600ce,0x442c02f0,0x443c39ea,0xc7b8034c}},	//   zaçõ, edd_, _anv_, _nađu_, 
   {{0x12bd00cc,0x443c39eb,0xc48539ec,0x2c64014e}},	//   _আবেদ, _bnv_, клик, _född_, 
   {{0x7d0d39ed,0x61e60065,0x629d0326,0x443c39ee}},	//   itas, wakl, elso, _cnv_, 
   {{0x61e639ef,0x7d0d39f0,0x20c600e7,0xb3460165}},	//   takl, htas, _sôi_, vaçõ, 
   {{0x27e739f1,0x799b016a,0x7d0d39f2,0x443c39f3}},	//   lann_, _kyuw, ktas, _env_, 
   {{0x61e639f4,0x6e2d052b,0xb34603b7,0x443c39f5}},	//   rakl, ddab, taçõ, _fnv_, 
   {{0x27e70084,0x7d0d01cc,0x10a636b9,0x61e639f6}},	//   nann_, dtas, тигн, sakl, 
   {{0xb34603b7,0xdee339f7,0xafe30073,0xa284009c}},	//   raçõ, иори, росл, _میدو, 
   {{0x20c600f7,0x27e739f8,0xdcf402fe,0x6d440a9f}},	//   _tôi_, hann_, žačk, txia, 
   {{0x7d0d29b7,0x614639f9,0x799b00c5,0xdbdf003e}},	// [2bc0] gtas, _репа, _nyuw, tíði, 
   {{0x61e425f2,0xe3b80785,0x3f9a1763,0x27e70300}},	//   _heil, mdır_, _typu_, jann_, 
   {{0xbddb39fa,0x27e739fb,0x09e639fc,0x61e439fd}},	//   _poèt, dann_, воен, _keil, 
   {{0x6aa939fe,0x60c41ef3,0x7afe39ff,0x6abb3a00}},	//   _chef, _kuim, rupt, _ciuf, 
   {{0x442c1b5a,0x7d0d3a01,0xe3b80092,0x27e73a02}},	//   ydd_, ctas, ndır_, fann_, 
   {{0xcee915c0,0x27e73a03,0x61e43a04,0x60c43a05}},	//   _ترین_, gann_, _leil, _muim, 
   {{0x8a060d5c,0xb8c90d4f,0xa7fc05b7,0x60c4007a}},	//   _изве, _गी_, _alıc, _luim, 
   {{0xfaa63a06,0x61e43a07,0x442c02bf,0x765b0495}},	//   _рабо, _neil, wdd_, gkuy, 
   {{0xd37814f0,0x27e73a08,0x47e10086,0x09061b11}},	//   maći_, bann_, _নারী, _шпан, 
   {{0x78ba051e,0xdb1c026a,0x27e70358,0x6b9c3a09}},	//   _uitv, _agré, cann_, _kyrg, 
   {{0x442c02f0,0x61e43a0a,0x7d0d3a0b,0x2c1407d5}},	//   rdd_, _beil, ztas, न्यू_, 
   {{0xd37808b1,0x7d0d3a0c,0x442a008b,0x645a3a0d}},	//   naći_, ytas, žb_, skti, 
   {{0x61e43a0e,0x60c411a1,0x39463a0f,0xd2510019}},	//   _deil, _cuim, nxos_, لنگ_, 
   {{0xe5a31d98,0xa2ca121a,0x645d024a,0x39463a10}},	//   _тичи, _संप्, ësit, ixos_, 
   {{0x61e43a11,0x260f1489,0x2003024a,0x3ce800a5}},	//   _feil, थ्वी_, rgji_, _चौबे_, 
   {{0x60c43a12,0x7d0d357d,0x61e43a13,0x27e73828}},	//   _fuim, ttas, _geil, zann_, 
   {{0x16df12e3,0x60c43a14,0xd3780372,0xf1c40098}},	// [2bd0] _नब्ब, _guim, daći_, ášť_, 
   {{0x7d0d3a15,0xbbdd047c,0x61e43a16,0x6aa93a17}},	//   rtas, यरेक, _zeil, _shef, 
   {{0x27e73a18,0xddc600ab,0x39460068,0x6aa9084c}},	//   vann_, _dokł, exos_, _phef, 
   {{0x27e73a19,0x66e502f1,0xa2ca121a,0x99d40195}},	//   wann_, ҳока, _संन्, لتها, 
   {{0xe9d800e4,0x27e73a1a,0xee3f0187,0xa3e300aa}},	//   ткі_, tann_, _iný_, _फजल_, 
   {{0xfa230086,0xd7093a1b,0x6b9c3a1c,0x00000000}},	//   ফাইল_, енке_, _fyrg, --, 
   {{0x27e73a1d,0x12bd0086,0xe3b8008f,0x6aa93a1e}},	//   rann_, _আব্দ, zdır_, _thef, 
   {{0x27e73a1f,0xddcd002a,0x06093a20,0xf6250ec6}},	//   sann_, skaņ, хник_, удио, 
   {{0xe616004e,0x27e73a21,0x61e43a22,0x3a3f012b}},	//   уды_, pann_, _reil, _inup_, 
   {{0x60c4051e,0x61e43a23,0x9f43009e,0xe3e30033}},	//   _ruim, _seil, vajî_, _মাহব, 
   {{0x91e63a24,0x60c43a25,0x212911d0,0x6569010e}},	//   лоне, _suim, _asah_, szeh, 
   {{0xe3b800ad,0x22990096,0x00000000,0x00000000}},	//   tdır_, déks_, --, --, 
   {{0x61e43a26,0x645d01ee,0x290f00a3,0x3a2d0379}},	//   _veil, ësis, ntga_, _maep_, 
   {{0xe3b80749,0x26c53a27,0x61e4194c,0x99dd00d8}},	//   rdır_, _kulo_, _weil, _koňs, 
   {{0x61e43a28,0x21290065,0x99750083,0x4c8608ba}},	//   _teil, _esah_, nęło_, ҳлав, 
   {{0xa2062cdd,0x26c53a29,0x2baa00b0,0x6fd40154}},	//   _спид, _mulo_, _करबा, _ब्रू, 
   {{0x0eb909d5,0x20760f5a,0x4c863a2a,0x224003a0}},	// [2be0] туры_, _бунё, глав, _inik_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd37803f5,0xfaa60267,0x2240206b,0x00000000}},	//   taći_, гажо, _knik_, --, 
   {{0x1efb035c,0xc9860cda,0x2cb00028,0x198a0176}},	//   _אלטע, лули, _žodį_, нбеи_, 
   {{0xed573a2b,0xf992031b,0xd3780613,0x00000000}},	//   _боя_, حبا_, raći_, --, 
   {{0x3ea03a2c,0x66c70c05,0xf772006b,0xf72a123f}},	//   llit_, _tıkl, یاں_, еций_, 
   {{0x26c53a2d,0xb8eb0d1d,0xd3780397,0x224001cf}},	//   _culo_, _रू_, paći_, _onik_, 
   {{0x7c2e15c4,0x36870f82,0x26c50c36,0x3ea0003e}},	//   _habr, лсын_, _dulo_, nlit_, 
   {{0x59863a2e,0x634a06d0,0x7c2e3a2f,0xca750009}},	//   _слаб, məni, _kabr, _туры, 
   {{0x634a0095,0x7c2e3a30,0xd91b008d,0x245200b3}},	//   ləni, _jabr, _אומל, _câmp_, 
   {{0x7c2e3a31,0x3ea03a32,0x26c53a33,0x36060625}},	//   _mabr, klit_, _gulo_, _مواف, 
   {{0x7c2e3a34,0xa2950769,0x21b500dd,0xdbdf003e}},	//   _labr, рамі, ийня, _líðu, 
   {{0x667b00c7,0x463b0070,0x3ea03a35,0x26c501ca}},	//   _אטאק, _רעדע, dlit_, _zulo_, 
   {{0xe1ff033c,0x53343a36,0x3e6700b0,0x22403a37}},	//   chón_, _вект, _mõte_, _enik_, 
   {{0xe7f71516,0x442e014e,0x634a0095,0x316b3a38}},	//   ीलता_, _iaf_, kəni, szcz_, 
   {{0x3ea03a39,0x442e3a3a,0xddcd2c1c,0x2bdd1f22}},	//   glit_, _haf_, snaž, यर्थ, 
   {{0x3cee006a,0x21293a3b,0x634a06d0,0x442e3a3c}},	// [2bf0] ेंगे_, _usah_, dəni, _kaf_, 
   {{0x442e3a3d,0x3ea00a4b,0x9f4300bc,0x3a3f02c9}},	//   _jaf_, alit_, lají_, _snup_, 
   {{0x2baa02f8,0x442e3a3e,0x3ea03a3f,0x0ba728f0}},	//   _करणा, _maf_, blit_, ушам, 
   {{0x27e50bfc,0x9f4300bc,0x442e3a40,0x7c2e00a1}},	//   _seln_, nají_, _laf_, _eabr, 
   {{0x7c2e3a41,0xd3780112,0xc77303a1,0x00000000}},	//   _fabr, maću_, өткө, --, 
   {{0x7c2e0474,0x46f53108,0x442e3a42,0x26c53a43}},	//   _gabr, ачит, _naf_, _pulo_, 
   {{0xf771105a,0x36693a44,0x270e0095,0x18660093}},	//   غات_, како_, _yəni_, ращи_, 
   {{0x7c2e1293,0xbb840084,0x2baa02f8,0x7ae300d9}},	//   _zabr, _الفي, _करता, ântu, 
   {{0x81eb0086,0x9f43031e,0x98b93a45,0xa4d60267}},	//   মলা_, dají_, _алат_, адњу_, 
   {{0xd3781612,0x26c53a46,0x7c2e0068,0xf8b920b4}},	//   haću_, _tulo_, _xabr, _شهاب_, 
   {{0xd3780a1a,0x03a50846,0x53a53a47,0x383400d9}},	//   kaću_, рино, ранб, _ынфр, 
   {{0x67b80198,0xcb1200d1,0xd3780082,0x00000000}},	//   _صالح_, חלט_, jaću_, --, 
   {{0x442e0379,0xd378090e,0x04451d7d,0x00000000}},	//   _faf_, daću_, _велн, --, 
   {{0x442e3a48,0x05a800dd,0x270e0095,0xad9b0038}},	//   _gaf_, _свій_, _səni_, _gcúi, 
   {{0x7c2e0082,0x634a0095,0x3ea03a49,0xa2a7009a}},	//   _rabr, yəni, tlit_, _टीव्, 
   {{0x442e3a4a,0xdbdf010d,0x3f8c003d,0x3ea03a4b}},	//   _zaf_, _síðu, ħdu_, ulit_, 
  
   {{0x7c2e3a4c,0x3ea0008c,0x645c3a4d,0x37e60033}},	// [2c00] _pabr, rlit_, örig, _নাসর, 
   {{0xa7fc0749,0x3ea03a4e,0x2baa00b0,0x7c2e3a4f}},	//   _alın, slit_, _करदा, _qabr, 
   {{0x62870076,0xf1a9009c,0x634a0095,0xd3780a1a}},	//   čkov, _لایه_, təni, baću_, 
   {{0xeb973a50,0x2c64014e,0x62863a51,0x3e7f0080}},	//   ших_, _döda_, nnko, rätä_, 
   {{0xd82618ae,0x7c2e3a52,0x634a00ad,0x93bc00b3}},	//   идди, _tabr, rəni, ndăr, 
   {{0x7d043884,0xceb40095,0x2c640219,0x187301fc}},	//   muis, lmə_, _föda_, огія, 
   {{0x7d043a53,0xa2ca03c1,0x81e70033,0x00000000}},	//   luis, _संध्, _পাস_, --, 
   {{0x2bd20e7d,0x95d700fd,0xceb40248,0x634a0248}},	//   दुरा, адът_, nmə_, qəni, 
   {{0x9f43031e,0x7d043a54,0x00000000,0x00000000}},	//   vají_, nuis, --, --, 
   {{0x442e3a55,0x62863a56,0xb80600d4,0x6e2401c4}},	//   _qaf_, enko, _خبره, heib, 
   {{0x7d043a57,0x439408bd,0x9f4a009e,0x22920098}},	//   huis, санс, sabê_, láky_, 
   {{0x7d043a58,0x442e3a59,0x62860bf7,0x00000000}},	//   kuis, _waf_, gnko, --, 
   {{0x442e1691,0x7d043a5a,0x61f602bf,0xd378044e}},	//   _taf_, juis, _ddyl, vaću_, 
   {{0x03770274,0x7d043a5b,0x251b008d,0x99860032}},	//   احیت_, duis, _סווא, rgoň_, 
   {{0xf0b400dd,0xc2e602f1,0x1df916d0,0xd3780ab4}},	//   ійсь, _тўли, левы_, taću_, 
   {{0x2c64014e,0x5f943a5c,0xdce601f0,0xcdd80bad}},	//   _röda_, цист, _aykı, ињу_, 
   {{0x7d043a5d,0xd90413b4,0xa2ca1779,0xd378044e}},	// [2c10] guis, _تی_, _सूत्, raću_, 
   {{0x38a93a5e,0x80dd0033,0xd3780f23,0x2292024c}},	//   kúra_, _বিপ্, saću_, dáky_, 
   {{0x5b153a5f,0x7642052b,0x00000000,0x00000000}},	//   смет, _onoy, --, --, 
   {{0x7d0402a3,0xe8f500eb,0x3d0702e6,0x00000000}},	//   buis, مستخ, िंदे_, --, 
   {{0x3cfe006a,0x8d841c3e,0x7d043a60,0xb7c302be}},	//   _लिये_, _дурд, cuis, çãoz, 
   {{0x2bcb0a43,0xf1bf010e,0x26d90098,0x7642040c}},	//   _шумо_, ldás_, _čsob_, _anoy, 
   {{0xda351c0f,0x99863a61,0x62860035,0x9f430379}},	//   _левы, rdoš_, ynko, najà_, 
   {{0x7c253a62,0xf1bf039f,0x229200da,0x80dd0033}},	//   lehr, ndás_, báky_, _বিন্, 
   {{0x95990504,0x2aff0790,0x78bd0036,0x673a0ff2}},	//   ытку_, शंकु_, _èsvo, _ertj, 
   {{0xb465030f,0x98650019,0xe3c300b9,0x81bf0033}},	//   скол, _دیتے_, өрүү, েরা_, 
   {{0x6e243a63,0x673a039b,0x36d40892,0x60d618aa}},	//   yeib, _grtj, _дохр, _stym, 
   {{0x99800039,0x201a0065,0x628601f1,0x17683a64}},	//   žiť_, _sbpi_, unko, _труп_, 
   {{0xf65200a7,0xd5480fce,0x7c250380,0x62860bfe}},	//   _מצא_, _نجوم_, kehr, rnko, 
   {{0x1c0305d2,0x753600c7,0x75293a65,0x66093a66}},	//   _लागल_, _לאנד_, mwez, lgek, 
   {{0x44253a67,0x64433a68,0xa1c4005e,0xceb40095}},	//   mel_, _inni, _мұнд, tmə_, 
   {{0x7d040445,0xf1d1017d,0x7529095a,0x00000000}},	//   tuis, थुआन, owez, --, 
   {{0x75290b32,0x6e243a69,0x291f006f,0xceb40095}},	// [2c20] nwez, reib, _npua_, rmə_, 
   {{0x2292014b,0xa3ab215e,0x7c250380,0xc006197c}},	//   váky_, _खरा_, gehr, _упок, 
   {{0x291f0088,0x7d043a6a,0x20180657,0x7529016c}},	//   _apua_, suis, mfri_, hwez, 
   {{0x75293a6b,0x44253a6c,0x7d043a6d,0x2292014b}},	//   kwez, hel_, puis, táky_, 
   {{0x44253a6e,0x64430088,0xfaa60f5a,0x2baa02c3}},	//   kel_, _onni, _ҳаво, _करवा, 
   {{0xbb4609e7,0xd90d00d6,0x38a93a6f,0x2292014b}},	//   _легк, ئیل_, túra_, ráky_, 
   {{0xe80e1422,0xf1bf0228,0xf1c810b0,0xd7f900f0}},	//   _साठा_, ndár_, रखान, руі_, 
   {{0x44250265,0x66093a70,0x673a0372,0x64433a71}},	//   eel_, ggek, _vrtj, _anni, 
   {{0x44253a72,0x896620e1,0xc966012d,0xd90d0535}},	//   fel_, _укаж, _увай, _لین_, 
   {{0x44253a73,0x29063a74,0xe8d700d1,0x00000000}},	//   gel_, muoa_, _לומר_, --, 
   {{0xf7433a75,0x21200574,0x2906084c,0x9f4a00d7}},	//   _нефо, _apih_, luoa_, babé_, 
   {{0x32670bce,0x64433a76,0x2120016a,0x466900dd}},	//   стов, _enni, _bpih_, _крім_, 
   {{0x44253a77,0x2018003d,0x9f4100b9,0x7529016c}},	//   bel_, ffri_, _vehí_, cwez, 
   {{0x44253a78,0x27ee003e,0xe81b02ab,0x20180e79}},	//   cel_, nafn_, प्पा_, gfri_, 
   {{0x447b00d1,0x29060415,0x00000000,0x00000000}},	//   _תנוע, huoa_, --, --, 
   {{0x7c250380,0x62870098,0x2906025b,0x00000000}},	//   wehr, čkos, kuoa_, --, 
   {{0xdc5502a6,0xa7fc027e,0x463b00c7,0xdb1c022c}},	// [2c30] овањ, _alım, נעמע, _agrà, 
   {{0x61ef01be,0x8bc73a79,0xba3d00bc,0x66090532}},	//   lacl, ссад, _lhůt, zgek, 
   {{0x50d4006b,0x212b02bf,0xfbab0028,0x99d700eb}},	//   _وزیر, lwch_, утай_, متشا, 
   {{0x44253a7a,0x61ef3a7b,0x00000000,0x00000000}},	//   zel_, nacl, --, --, 
   {{0x44253a7c,0x212b0156,0x75290216,0xa2bc0070}},	//   yel_, nwch_, xwez, אמאט, 
   {{0xb901007e,0xf9902f67,0x7e6d2eef,0x00000000}},	//   _दऽ_, ربن_, lhap, --, 
   {{0x44253a7d,0x2bdf0eda,0xb8d005f6,0x66090a58}},	//   vel_, _प्या, _टी_, tgek, 
   {{0x44253a7e,0x0f7c00a7,0x7e6d3a7f,0x75293a80}},	//   wel_, טרול, nhap, twez, 
   {{0x44253a81,0x61ef0183,0x66092ff7,0x201813db}},	//   tel_, dacl, rgek, yfri_, 
   {{0x66091013,0x212b0156,0x752901c8,0x44251be5}},	//   sgek, dwch_, rwez, uel_, 
   {{0x44253a82,0x7e6d3a83,0x224a0165,0x634a0248}},	//   rel_, khap, апни_, dəns, 
   {{0x44253a84,0xd6ab2ee1,0x2f3805d5,0x7e6d0175}},	//   sel_, _صدام_, _rčg_, jhap, 
   {{0xa4f70a24,0x7e6d00d7,0x212b00f8,0x00000000}},	//   _اکبر_, dhap, gwch_, --, 
   {{0x6443008c,0x44253a85,0x7bc73a86,0x316c0083}},	//   _unni, qel_, _ngju, ądz_, 
   {{0x1fb53a87,0xe81b009a,0xae7a07f4,0x749a0225}},	//   зстр, प्या_, асах_, _דיספ, 
   {{0x00ca0962,0xf1bf0183,0x7bd502b0,0xaaa800c2}},	//   _клик_, meán_, _afzu, _छींक, 
   {{0x63a302bf,0xec7a3a88,0xf1bf00eb,0x1bea03dc}},	// [2c40] _hynn, апа_, leán_, идаи_, 
   {{0x0c233a89,0x63a33a8a,0x6721003a,0x3e6700b0}},	//   ммун, _kynn, _oplj, _võta_, 
   {{0x49ca16e1,0x7e6d01e5,0xddc4020f,0x5b26007a}},	//   ален_, bhap, ghiţ, تفال, 
   {{0x7e6d3a8b,0x09e303b7,0x63a33a8c,0x29060149}},	//   chap, доцн, _mynn, tuoa_, 
   {{0xb5fd0032,0x67d43a8d,0x522d0147,0x00000000}},	//   chši, полу, טואַ, --, 
   {{0x6e36012d,0x3a26016a,0x29060026,0x00000000}},	//   ldyb, seop_, ruoa_, --, 
   {{0x2906084c,0x7d163a8e,0x61ef0248,0x63a30657}},	//   suoa_, ltys, yacl, _nynn, 
   {{0x6e363a8f,0xf1bf00eb,0x7bc7024a,0x27ee008c}},	//   ndyb, deán_, _zgju, safn_, 
   {{0xceb3042c,0x7d163a90,0x7afa04f4,0x00000000}},	//   ויה_, ntys, _ættb, --, 
   {{0x31e300a2,0x33743a91,0x63a30156,0xc8660038}},	//   पर्ध, згор, _bynn, _بطري, 
   {{0x63a302f0,0x61ef3a92,0xe3b8027e,0x7e6400c8}},	//   _cynn, tacl, ldız_, kkip, 
   {{0x212b0156,0x63b5014b,0x63a300f8,0x00000000}},	//   twch_, ýzna, _dynn, --, 
   {{0xa2ca04d7,0x26cc3a93,0x61ef0de2,0x00000000}},	//   _सूर्, _hudo_, racl, --, 
   {{0x80dd00cc,0x26cc024a,0x212b0156,0x61ef02a3}},	//   _বিদ্, _kudo_, rwch_, sacl, 
   {{0x63a302f0,0x8f343a94,0x7e6d07d7,0x64580036}},	//   _gynn, мерц, thap, _iovi, 
   {{0x64583a95,0xa19507f4,0x60dd1bbd,0x975700df}},	//   _hovi, _найч, ppsm, חילו_, 
   {{0x64583a96,0x7e6d3a97,0x7bf93a98,0xa3b600bc}},	// [2c50] _kovi, rhap, йнар_, चेर_, 
   {{0x6458032f,0x61ed3a99,0x7e6d3a9a,0xc8a900c9}},	//   _jovi, _heal, shap, _चींट, 
   {{0x64583a9b,0x7e6d1c28,0x61ed0ab1,0x26cc3a9c}},	//   _movi, phap, _keal, _nudo_, 
   {{0x64583a9d,0x60cd0010,0xf1af0586,0x7e643a9e}},	//   _lovi, _kuam, _घरान, ckip, 
   {{0xcfbd0086,0x6d4b014e,0x60cd3a9f,0xa3ca031e}},	//   _অভিন, ågad, _juam, लखा_, 
   {{0x60cd02f1,0x61ed3aa0,0x629d3aa1,0x26cc0539}},	//   _muam, _leal, hoso, _budo_, 
   {{0x26cc05ae,0x25a90688,0x7522045a,0xad9b0038}},	//   _cudo_, _šal_, _apoz, _gcúr, 
   {{0x26cc0369,0x7c353aa2,0xdb1c0019,0x629d08b2}},	//   _dudo_, _hazr, _ugrá, joso, 
   {{0x63a33aa3,0x656000f8,0x69c901d6,0xf8f400b3}},	//   _synn, gymh, _igee, _оптэ, 
   {{0x26cc3aa4,0xf1bf0038,0x13090080,0x00000000}},	//   _fudo_, teán_, бной_, --, 
   {{0x61ed3aa5,0x7c353aa6,0x64583aa7,0xbddb00f6}},	//   _beal, _mazr, _dovi, _anèm, 
   {{0xf1bf00eb,0x61ed3aa8,0x7d1600c8,0x60cd3aa9}},	//   reán_, _ceal, ytys, _buam, 
   {{0xf1bf00eb,0x61ed3aaa,0x64580126,0x15452631}},	//   seán_, _deal, _fovi, _хелм, 
   {{0x653a00c7,0x7c353aab,0x63a33aac,0x09a90035}},	//   _לענד, _nazr, _tynn, _औरैय, 
   {{0x61ed3aad,0xbbaa1574,0x1faa11b9,0x69c902a5}},	//   _feal, _करेक, скви_, _ogee, 
   {{0x61ed0094,0x644600e0,0x64583aae,0x69c902a5}},	//   _geal, ēkie, _zovi, _ngee, 
   {{0xf1bf00eb,0x60cd00e2,0x7d16039b,0x6e360566}},	// [2c60] neál_, _guam, utys, rdyb, 
   {{0x7e643aaf,0xeb9a0161,0x69c901b8,0x61ed3ab0}},	//   skip, биз_, _agee, _zeal, 
   {{0xe8052221,0x6d4b014e,0x7d163769,0x8b26004f}},	//   _राजा_, ägar, stys, ядже, 
   {{0x765900ab,0x60cd006d,0x0ae90038,0xdce40ab4}},	//   _nowy, _yuam, تركي_, jzić, 
   {{0x7c350065,0x63a60035,0x00000000,0x00000000}},	//   _fazr, ękni, --, --, 
   {{0xb8f41e4c,0x26cc08f4,0xa3ab009a,0x2bdb2830}},	//   _सं_, _pudo_, _खरं_, मुदा, 
   {{0xd6d73338,0x75221467,0x629d3ab1,0x25c10095}},	//   пты_, _spoz, yoso, ərlə_, 
   {{0x80dd00cc,0xfaa300dd,0xb17b01e8,0x629d0068}},	//   _বিস্, _засо, dbån, xoso, 
   {{0x64583ab2,0xd49a197b,0x68e90156,0xb5fd01dd}},	//   _povi, йро_, _gwed, ukša, 
   {{0x26cc00ce,0x7d043ab3,0xb5fd01dd,0x61ed3ab4}},	//   _tudo_, iris, rkša, _seal, 
   {{0x60cd0730,0x61ed05d2,0xe61a0cc2,0x7d043ab5}},	//   _suam, _peal, _где_, hris, 
   {{0x7d043ab6,0xad9b0068,0xbddb0300,0x60cd0118}},	//   kris, _ocúp, _enèj, _puam, 
   {{0x68e9055a,0x629d3ab7,0xf4870c30,0xe5340fac}},	//   _xwed, roso, _کانی, _цель, 
   {{0x629d3ab8,0x7d043ab9,0x61e0008f,0x55bb0486}},	//   soso, dris, ımla, _המדו, 
   {{0xda0d05fd,0x25af3aba,0x60c500b0,0x61ed3abb}},	//   _हालत_, _zzgl_, _vihm, _teal, 
   {{0x7d043abc,0x7c35034c,0x60cd3abd,0x816b1918}},	//   fris, _sazr, _tuam, _гроб_, 
   {{0xe7cc0081,0x22490187,0x823420b4,0x786f004f}},	// [2c70] ाशाप, _inak_, _سريا, _høve, 
   {{0xdfd10038,0xdb1c02ae,0x00000000,0x00000000}},	//   _جيد_, _ogrä, --, --, 
   {{0xaac70a7c,0x7d043abe,0xde59004f,0x78bd0036}},	//   ستان, aris, _дані_, _èsvi, 
   {{0x7d180084,0x68e90c3d,0x37e60086,0x386c0054}},	//   éasá, _pwed, _নাগর, _aldr_, 
   {{0x20d300c9,0x3ea90219,0x2616007e,0x786f01e8}},	//   _धूमध, mlat_, _भउजी_, _løve, 
   {{0x3ea93abf,0xc7a500dd,0x013800a7,0x07a50925}},	//   llat_, милк, פרות_, малн, 
   {{0xe80e0366,0xb8f40c15,0x12c70086,0x76593ac0}},	//   _सारा_, _सू_, _শব্দ, _powy, 
   {{0xd87709e8,0x645c3ac1,0x386c008a,0x7afa01d5}},	//   _کارب, örin, _eldr_, _ætta, 
   {{0xbddb0237,0xdce40ab4,0xddcd0009,0xc7c70165}},	//   _anèk, rzić, kiaž, _есеи, 
   {{0x22493ac2,0x2a6d3ac3,0x25a603a0,0x9f51009e}},	//   _anak_, _hleb_, _dyol_, razê_, 
   {{0xa22a3ac4,0x04ff0033,0x2a6d0542,0x80dd0033}},	//   ожна_, ্বের_, _kleb_, _বিষ্, 
   {{0x7d04008c,0x2a6d016a,0x1fc50086,0x38b200b3}},	//   yris, _jleb_, ্রাস, râre_, 
   {{0x3ea93ac5,0x66c7027e,0xbbaa0a0e,0x13a700d7}},	//   dlat_, _fıkr, _कर्क, تنگی_, 
   {{0x80dd100b,0x22493ac6,0x63850cd9,0x7d043ac7}},	//   _বিশ্, _enak_, _огла, vris, 
   {{0xe29f008c,0x4f953ac8,0x8fa33ac9,0x3ea93aca}},	//   boð_, ерту, варе, flat_, 
   {{0xe1ff23f2,0xecea2c77,0xe058009c,0x00000000}},	//   lkón_, ждал_, _کیست_, --, 
   {{0x32d30029,0xe80e119b,0xbea33acb,0xd12f009c}},	// [2c80] _hãy_, _साला_, татк, _نمي_, 
   {{0x645700b9,0x3ea900f6,0x3cf9019c,0x3ac80248}},	//   _òxid, alat_, _dvsv_, _aşpa_, 
   {{0x3ea93acc,0x00000000,0x00000000,0x00000000}},	//   blat_, --, --, --, 
   {{0x7d040c04,0x224900e2,0x3ea9022c,0x2a6d0175}},	//   pris, _xnak_, clat_, _cleb_, 
   {{0x20d41eab,0xaac5009c,0xbdfb0296,0x2bdf058c}},	//   _jäi_, رتمن, _برپا_, _प्वा, 
   {{0xd6da03b9,0xbddb011c,0x2a6d0175,0x18673acd}},	//   оти_, _anèh, _eleb_, мачи_, 
   {{0xdca31829,0xf79300e4,0x32d30023,0x45d40afc}},	//   _рари, кашэ, _nãy_, нойс, 
   {{0xa3c308b3,0xa53439f7,0x786f0f95,0x00000000}},	//   ्शन_, енич, _røve, --, 
   {{0x64c83ace,0x26c6095a,0x6d4000de,0x00000000}},	//   रदेश, _vioo_, _šmaj, --, 
   {{0x68e2023a,0x2249202b,0x838600f0,0x09030cfe}},	//   mpod, _snak_, дыме, _шпун, 
   {{0xd37a00dd,0x2249011c,0x00000000,0x00000000}},	//   ючи_, _pnak_, --, --, 
   {{0x05660012,0x32d30023,0x475900b3,0xb5fd0028}},	//   _овен, _dãy_, _эруя_, nkšl, 
   {{0x3ea90c67,0xa2ca000c,0x0fe300d3,0xd8380144}},	//   vlat_, _संक्, көнү, _kač_, 
   {{0xdbf307fa,0x9f430228,0x961d01dd,0x29060183}},	//   _işçi, majú_, miņa, iroa_, 
   {{0xc0580fb6,0x442c3acf,0xd838044e,0x490800a5}},	//   фія_, med_, _mač_, _समझो_, 
   {{0x442c3ad0,0x3ea93ad1,0xd8380118,0x29060379}},	//   led_, ulat_, _chčz_, kroa_, 
   {{0x442c0156,0xdfd517fc,0xc05b00f0,0x9f430032}},	// [2c90] oed_, _попы, _дін_, najú_, 
   {{0x3ea9031e,0xb5fd01dd,0x29063ad2,0xa1f9010e}},	//   slat_, ekšl, droa_, _بڑھا_, 
   {{0x2a6d006d,0x9f433ad3,0x5ba70f67,0x29063071}},	//   _pleb_, hajú_, фраз, eroa_, 
   {{0x442c3ad4,0xdd140039,0x9f430228,0x2299014b}},	//   hed_, _súťa, kajú_, téky_, 
   {{0x26de0093,0x442c3ad5,0xf1a50586,0x6e2d001d}},	//   _atto_, ked_, _गुमन, meab, 
   {{0x442c3ad6,0x7d0d0666,0x9f430228,0x6e2d0358}},	//   jed_, muas, dajú_, leab, 
   {{0x442c0052,0x7d0d3ad7,0xc7a23ad8,0x46a52831}},	//   ded_, luas, лишк, накв, 
   {{0xbb4800c5,0x2a7f023e,0x290600b4,0x628f039b}},	//   _تلفن_, _umub_, broa_, jnco, 
   {{0x442c3ad9,0x2bc30c14,0x79a7081b,0x7d0d00e1}},	//   fed_, _वृता, _црве, nuas, 
   {{0xe4510084,0x442c3ada,0x291a00b3,0x628f1f57}},	//   اضة_, ged_, ăpat_, enco, 
   {{0xe2860a2b,0x4e0f031e,0x7d0d3adb,0x69c40028}},	//   елни, िलाई_, huas, žiet, 
   {{0x7d0d04bb,0x644a3adc,0x9f430032,0x442c00c2}},	//   kuas, _enfi, bajú_, aed_, 
   {{0x764b006b,0x442c3add,0x3e6e003e,0xf477004e}},	//   _ingy, bed_, _nýta_, _жөні_, 
   {{0x2bdf09ec,0x442c2821,0xa06a3ade,0x7d0d0065}},	//   _प्ला, ced_, чага_, duas, 
   {{0x3ea00eb1,0x6258019c,0x00000000,0x00000000}},	//   toit_, _mãoz, --, --, 
   {{0xbea304e9,0x6e2d3adf,0x7d0d0053,0xdb0e0175}},	//   гаск, geab, fuas, _uzbé, 
   {{0x62863ae0,0x7d0d3ae1,0x3ea03ae2,0x3d07109f}},	// [2ca0] miko, guas, roit_, िंगे_, 
   {{0x62863ae3,0x69db3ae4,0xc19b0486,0xeb9a3ae5}},	//   liko, _afue, _משפי, пиз_, 
   {{0x9f430228,0x961d00e0,0xb5fd01dd,0x09ba3ae6}},	//   zajú_, ziņa, ekšm, ेश्य, 
   {{0xfce63ae7,0x62863ae8,0x442c3ae9,0x29063aea}},	//   _помо, niko, zed_, troa_, 
   {{0xa967252a,0xd83802ee,0x442c00a7,0xb21b34f9}},	//   ница_, _pač_, yed_, onær, 
   {{0x9f430187,0x62863aeb,0x29060a9f,0x442c00a7}},	//   vajú_, hiko, rroa_, xed_, 
   {{0x62863aec,0xab273aed,0x442c0056,0x7bce0495}},	//   kiko, _пора_, ved_, _igbu, 
   {{0x442c3aee,0x62863aef,0x9f430032,0x68e20695}},	//   wed_, jiko, tajú_, ppod, 
   {{0x442c0052,0xdb1c007a,0xf09f00b9,0x00000000}},	//   ted_, _ngrú, dràn_, --, 
   {{0x6aa201a9,0x9980012d,0x9f430228,0x764b3af0}},	//   loof, žių_, rajú_, _engy, 
   {{0x442c3af1,0x62863af2,0xdb1c0068,0xe1f90161}},	//   red_, fiko, _agrú, үгү_, 
   {{0x442c3af3,0x62863af4,0x99890228,0x934600f0}},	//   sed_, giko, žať_, _үнде, 
   {{0x2418004e,0x442c00a7,0x7bdc0034,0xf4861a41}},	//   _жолы_, ped_, _ofru, _пукн, 
   {{0x741300d4,0x6aa23af5,0xc0583af6,0x41a500bc}},	//   _موها, hoof, ніс_, _गुणस, 
   {{0x53343af7,0x62860b31,0xc90d031e,0x6e2d3af8}},	//   _рейт, biko, _सम्म_, teab, 
   {{0x7d0d3af9,0x7bce012b,0x7bdc3afa,0x62863afb}},	//   tuas, _agbu, _afru, ciko, 
   {{0x6e2d3afc,0x9f4a019c,0xbbeb0038,0x6aa2039b}},	// [2cb0] reab, rabá_, كرام_, doof, 
   {{0x6e2d3afd,0xf8b80023,0x2129002c,0xed04010e}},	//   seab, _nhĩ_, _ipah_, اولپ, 
   {{0x68fb003a,0x7d0d025b,0x7afc203b,0x394400df}},	//   _svud, suas, _cvrt, _arms_, 
   {{0x7d0d0666,0x636b010e,0x212900e7,0xd7f100e7}},	//   puas, lönö, _kpah_, _sẽ_, 
   {{0x7d0d0036,0xb5fd0028,0x5fd51503,0x625802be}},	//   quas, ukšm, _दलाल, _pãoz, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62863afe,0xdb1505d5,0x394400b9,0xa6951571}},	//   yiko, _egzò, _erms_, криј, 
   {{0x62863aff,0x212903bc,0x6edc0352,0xbddb0237}},	//   xiko, _opah_, _učbe, _enèv, 
   {{0x58d500dd,0x69c43b00,0x62862b92,0x383500b3}},	//   _розт, žier, viko, _инар, 
   {{0x446534c0,0x2bb80394,0x58d40925,0x290f3b01}},	//   твов, _अरमा, _софт, muga_, 
   {{0xe29a31d7,0x62863b02,0xfbd20056,0x63aa02bf}},	//   дан_, tiko, יתי_, _cyfn, 
   {{0x20013b03,0x63aa017c,0x00000000,0x00000000}},	//   _adhi_, _dyfn, --, --, 
   {{0x62863b04,0xa56400eb,0x290f3b05,0x291d07d7}},	//   riko, _مدون, nuga_, ntwa_, 
   {{0x291d0053,0x9f51010c,0x290f059e,0xe8040083}},	//   itwa_, razî_, iuga_, रणया_, 
   {{0x8fa63b06,0x63aa0156,0xb21b092c,0x290f3b07}},	//   таве, _gyfn, rnær, huga_, 
   {{0x7bdc3b08,0x291d06df,0x290f00b0,0xb1460a10}},	//   _sfru, ktwa_, kuga_, _анил, 
   {{0xc5f21a61,0x21760258,0x290f3b09,0x6f1c00de}},	// [2cc0] ידן_, _шукр, juga_, strc, 
   {{0x1f663b0a,0x20040009,0xf0ba0535,0xa2d800bc}},	//   _аком, ėmis_, _تابش_, _नंम्, 
   {{0x78a33b0b,0x00000000,0x00000000,0x00000000}},	//   donv, --, --, --, 
   {{0x290f0547,0x00000000,0x00000000,0x00000000}},	//   fuga_, --, --, --, 
   {{0xfe7508a5,0x6aa23b0c,0x78a33b0d,0x290f3b0e}},	//   _сүт_, roof, fonv, guga_, 
   {{0x7afc3b0f,0xa3c30fec,0xa7fc0540,0x67280065}},	//   _tvrt, ्शा_, _alır, _ppdj, 
   {{0x7c3c1049,0x6d46090e,0x7afc0a1a,0x3944019c}},	//   _iarr, _hrka, _uvrt, _wrms_, 
   {{0x290f355a,0x6d4602fe,0x7c3c2b8f,0x963418b2}},	//   buga_, _krka, _harr, униц, 
   {{0x7c3c3b10,0x291d0035,0x08c63b11,0xe60f009c}},	//   _karr, ctwa_, _абан, زشي_, 
   {{0x7c3c0414,0x6d460097,0x25e207d5,0xdb1c01c5}},	//   _jarr, _mrka, _ट्री_, _sgrù, 
   {{0x7c3c3a97,0xd7a91615,0xd25113b4,0x64a303b7}},	//   _marr, _चुपच, مند_, раќа, 
   {{0x7c3c02ba,0x6d463b12,0xa77b0070,0x00000000}},	//   _larr, _orka, _קראפ, --, 
   {{0x955300d4,0x51843b13,0x316d033c,0xaf3400d7}},	//   _نخوا, аура, áez_, یرفت, 
   {{0x8cd60262,0x9f58010c,0x8c080086,0x3e7500dd}},	//   _बढ़ो, marê_, র্তন_, _måte_, 
   {{0x5433195e,0x443c023b,0xdef8016e,0x6d463b14}},	//   _ضرور, _iav_, кыт_, _arka, 
   {{0x443e3b15,0x443c3b16,0x3cfe000f,0x6d46090e}},	//   ldt_, _hav_, _लिखे_, _brka, 
   {{0x80dd00cc,0x443c01a0,0x21291415,0x6d46034c}},	// [2cd0] _বিক্, _kav_, _upah_, _crka, 
   {{0x443e3b17,0x7c3c3037,0x290f099d,0x443c2f5d}},	//   ndt_, _carr, vuga_, _jav_, 
   {{0x7c3c0161,0x443c3b18,0x6d463b19,0x443e3b1a}},	//   _darr, _mav_, _erka, idt_, 
   {{0x443c3b1b,0x7c3c11a1,0x9984012d,0x9f58010c}},	//   _lav_, _earr, _namų_, karê_, 
   {{0x9f580218,0x7c3c3b1c,0xe8df00e7,0x443c01ff}},	//   jarê_, _farr, _trọn_, _oav_, 
   {{0x443c3b1d,0x7c3c1218,0x9f58009e,0x443e012e}},	//   _nav_, _garr, darê_, jdt_, 
   {{0x6e3d00a3,0x6d460228,0x291d3b1e,0x290f3b1f}},	//   _kasb, _zrka, stwa_, suga_, 
   {{0x443e012e,0x7e6d3b20,0x7c3c3b21,0xc1e32a2c}},	//   edt_, nkap, _zarr, _क्लब_, 
   {{0x6e3d3b22,0x9a8400cf,0x7c3c3b23,0xb8b30259}},	//   _masb, _турл, _yarr, _көкі, 
   {{0x443c006f,0x649d00d3,0x7c3c3b24,0x62840387}},	//   _cav_, nèix, _xarr, _smio, 
   {{0x443c01a0,0x46152daa,0x7e6d3b25,0xf77003b8}},	//   _dav_, _موار, kkap, _وام_, 
   {{0x6e3d3b26,0xe0c900c7,0x6d032369,0x9f58078a}},	//   _nasb, _זײ_, _लिंग_, barê_, 
   {{0x81ac0086,0x321e0035,0x443e0183,0xfbc3031e}},	//   কেন_, ęty_, bdt_, वेतम, 
   {{0x409513f1,0x443c3b27,0x6602014b,0x2c7602c9}},	//   арст, _gav_, _zdok, _kæde_, 
   {{0x6e3d3b28,0x65690102,0x6d460604,0x9f58021e}},	//   _basb, lyeh, _srka, marë_, 
   {{0x7e6d3b29,0x7c3c3b2a,0x44270065,0x6aa90097}},	//   gkap, _sarr, _hbn_, _nkef, 
   {{0x0c26156b,0x443c01a0,0x61463b2b,0x6e3d085b}},	// [2ce0] лман, _yav_, _сепа, _dasb, 
   {{0x443c0e0c,0x7c3c007b,0x786f01e8,0x6e3d0465}},	//   _xav_, _qarr, _søvn, _easb, 
   {{0x7c3e3b2c,0x61f63b2d,0x7c3c3b2e,0x6e3d0082}},	//   rdpr, _keyl, _varr, _fasb, 
   {{0x6d4607c7,0x9f58010c,0x998d00ab,0xe3c50086}},	//   _trka, yarê_, _oceń_, _এভাব, 
   {{0x7c3c3b2f,0x6abb01be,0x442703c8,0x58860028}},	//   _tarr, _dhuf, _obn_, лыка, 
   {{0x61f606a2,0x44273b30,0x60d60102,0x6e24098d}},	//   _leyl, _nbn_, _muym, lfib, 
   {{0x6d442ddc,0x9f583b31,0xbddb00f6,0xfbb80f7a}},	//   lvia, darë_, _inèr, _अरिम, 
   {{0x7ae3334c,0x443c3b32,0xfaa63b33,0x9b9300eb}},	//   ínte, _sav_, _сабо, _الفت, 
   {{0x443c3b34,0x6d4400d3,0xd94319fe,0x65940009}},	//   _pav_, nvia, _лети, рапу, 
   {{0xd5c00509,0x19b93b35,0x443c023b,0x443e064e}},	//   शेषज, _русь_, _qav_, udt_, 
   {{0x443e3b36,0x26d8078a,0x5fa40081,0x7e6d06e4}},	//   rdt_, _îro_, _खुलल, ykap, 
   {{0x201a01f2,0x673a0e67,0x61f604a8,0xd7f80023}},	//   _acpi_, _istj, _ceyl, _xoăn_, 
   {{0x443c3b37,0x6d440187,0x9f51014b,0x6e3d03c5}},	//   _tav_, jvia, razí_, _rasb, 
   {{0x443c3b38,0x60d60384,0x6d440032,0x83660038}},	//   _uav_, _duym, dvia, _مدبل, 
   {{0xb4c00179,0xb4c200a5,0x7e6d3b39,0x80d50586}},	//   ंगी_, ्दी_, tkap, _यूरे, 
   {{0xe80e0838,0x6e3d00c3,0x4ea700d3,0x76403b3a}},	//   _साझा_, _qasb, урга, ndmy, 
   {{0xb80435ff,0x6e3d3b3b,0x5d5502c4,0x38bb0326}},	// [2cf0] रणाम_, _vasb, шкат, lêre_, 
   {{0x7e6d3b3c,0x9ed90d38,0x673a00b0,0x6e3d10de}},	//   skap, _имот_, _ostj, _wasb, 
   {{0x6e3d00e2,0x649d00d3,0x38bb3b3d,0xdd9400f0}},	//   _tasb, rèix, nêre_, _ғары, 
   {{0x61f600ad,0xb4c23b3e,0xbddb00f6,0x81f30033}},	//   _xeyl, ्दु_, _enèr, _ঝাঁপ_, 
   {{0x38bb010c,0x673a008a,0xa3ab031e,0xc27c0070}},	//   hêre_, _astj, _कुन_, ערדי, 
   {{0x1bd43b3f,0x7d0d3b40,0x41c70ba3,0x00000000}},	//   _горя, mras, रेयस, --, 
   {{0x38bb010c,0x9f580034,0x44270604,0x1a650535}},	//   jêre_, varë_, _rbn_, _پیشی_, 
   {{0x9a871aa8,0x00000000,0x00000000,0x00000000}},	//   _сугл, --, --, --, 
   {{0xb4c23b41,0x9f5800e5,0x7d0d3b42,0xb4c03024}},	//   ्दू_, tarë_, nras, ंगू_, 
   {{0x03253b43,0xddc40009,0x61f63b44,0x38bb08b0}},	//   адон, nkiš, _seyl, fêre_, 
   {{0x7d0d00cf,0xe1ff00ab,0x3a3f3b45,0xe70b021b}},	//   hras, nków_, _kaup_, _ستان_, 
   {{0x80dd100b,0x614602f3,0x216a00dd,0x58853b46}},	//   _বিজ্, аема, вими_, _сыға, 
   {{0xe2973b47,0x9f583b48,0x201a0042,0x61e90183}},	//   рая_, maré_, _pcpi_, ñela, 
   {{0x7d0d3b49,0xd46616d9,0x442700e2,0x6d4401d8}},	//   dras, _више_, _ubn_, vvia, 
   {{0x26cf3b4a,0x6e240036,0x7d0d3b4b,0x61f63b4c}},	//   _kigo_, tfib, eras, _teyl, 
   {{0xddc93b4d,0x26cf3b4e,0xe1ff0035,0x29000009}},	//   _šošt, _jigo_, dków_, šiai_, 
   {{0x7d0d3b4f,0xac86041a,0x291f006d,0x26cf0126}},	// [2d00] gras, агал, _nqua_, _migo_, 
   {{0xd12f00d6,0x26cf3b50,0x0eb800a2,0x6d443b51}},	//   _کمی_, _ligo_, _आठवड, rvia, 
   {{0x2abc0bf1,0x7d0d3b52,0xdddd0019,0x64411f96}},	//   híbe_, aras, _első, idli, 
   {{0x9f580369,0x6441016a,0x6da6004f,0x00000000}},	//   jaré_, hdli, _вима, --, 
   {{0x44e90b85,0x7d0d3b53,0x22403b54,0x290002a0}},	//   _nº_, cras, _maik_, éia_, 
   {{0x20183b55,0x26cf02a2,0x37060fac,0x7afe0065}},	//   ngri_, _aigo_, ачив, pspt, 
   {{0x26cf3b56,0x291f02a3,0x9f5800b9,0xb17b3b57}},	//   _bigo_, _equa_, faré_, lbåt, 
   {{0x22403b58,0x644102f2,0xeb9700dd,0x26cf035f}},	//   _naik_, edli, _тис_, _cigo_, 
   {{0x26cf1408,0xd5b73b59,0x644101d2,0x00000000}},	//   _digo_, ись_, fdli, --, 
   {{0xb4c0006a,0x53462960,0xb4c226f2,0x2bc300b0}},	//   ंगे_, ахма, ्दे_, वेवा, 
   {{0x22402e7b,0x2252085f,0x3e75014e,0x3946012d}},	//   _baik_, _bnyk_, _låta_, lvos_, 
   {{0xc5f000cc,0x38bb0326,0x7d0d3b5a,0xe81c0299}},	//   _টাকা_, rêre_, yras, _नाडा_, 
   {{0x22400065,0x39460068,0xd5b02f67,0xe1ff0083}},	//   _daik_, nvos_, _عفت_, zków_, 
   {{0x83f819aa,0x27fc01e8,0x7d0d3b5b,0x20cf008a}},	//   _секс_, navn_, vras, _eżin_, 
   {{0x06fd00bc,0x22403b5c,0x3eb200fc,0xcf150033}},	//   žívá_, _faik_, flyt_, াব্দ_, 
   {{0x27fc0c85,0x2c19009a,0x2a640237,0x00000000}},	//   havn_, _पाहू_, _nomb_, --, 
   {{0xddc4034c,0x61fd00a3,0x61ef0065,0xdb1c0035}},	// [2d10] tkiš, masl, mbcl, _ogró, 
   {{0xe1ff0035,0x61fd12ed,0x9f583b5d,0xa3aa3b5e}},	//   tków_, lasl, marî_, _खडा_, 
   {{0x1da73b5f,0x9e353b60,0x9f580216,0x3a3f0118}},	//   _कुरत, _ленч, larî_, _paup_, 
   {{0x7d0d3b61,0xde590769,0xa3e60c94,0xdb1c033c}},	//   pras, _самі_, युत_, _agró, 
   {{0x39491056,0x0dcb00ce,0x26cf3b62,0x64413b63}},	//   ías_, _јуни_, _rigo_, ydli, 
   {{0x26cf3b64,0xb4c2031e,0xb4c00ee0,0x00000000}},	//   _sigo_, ्दो_, ंगो_, --, 
   {{0xb4c20351,0x61fd02ba,0x261b00a2,0x9f583b65}},	//   ्दै_, kasl, _यादी_, taré_, 
   {{0x9a8403dd,0x9f580218,0x3ea902f1,0x20180864}},	//   _дуул, karî_, noat_, zgri_, 
   {{0x26cf24d3,0xc4852164,0x88070a67,0x9f583b66}},	//   _vigo_, йлик, _نظام, raré_, 
   {{0x9f583b67,0x26c40036,0x26cf095a,0x66d50604}},	//   darî_, ammo_, _wigo_, _aške, 
   {{0x42ca01bb,0x64413b68,0x4425084c,0x22403b69}},	//   лгон_, rdli, rfl_, _paik_, 
   {{0x272133cd,0x6f153b6a,0x7d020028,0x00000000}},	//   món_, duzc, šosi, --, 
   {{0x27213b6b,0xa5091b49,0x5a9a0147,0x9f58009e}},	//   lón_, _села_, רשרא, garî_, 
   {{0x645c3b6c,0xafe300a3,0x0d2203a1,0x00000000}},	//   örit, зорл, үүнү, --, 
   {{0x272109a1,0xdee63b6d,0x224000e2,0xb21b055f}},	//   nón_, соби, _taik_, dhæf, 
   {{0x61fd0bad,0x9f58009e,0x27210183,0x39460028}},	//   casl, barî_, ión_, yvos_, 
   {{0xed573b6e,0x27213b6f,0x00000000,0x00000000}},	// [2d20] бот_, hón_, --, --, 
   {{0xa3ab3b70,0x27213b71,0xb17b05a1,0x290f056f}},	//   कअप_, kón_, rbåt, drga_, 
   {{0x27213b72,0xdb1c00f6,0x5f46030e,0xfbc3109f}},	//   jón_, _agrò, _انجل, वेलम, 
   {{0x27213b73,0xa3c9009a,0x82d60070,0xef220083}},	//   dón_, लेय_, צונג_, ążę_, 
   {{0x186a0c67,0x1958032e,0xceb40095,0x92e30086}},	//   лади_, ралы_, mlə_, _ফটো_, 
   {{0xfce33b74,0x27213b75,0x6e361bcc,0x39463b76}},	//   _хоро, fón_, leyb, rvos_, 
   {{0x27211056,0x39463b77,0x9f58009e,0xa3c902ab}},	//   gón_, svos_, zarî_, लेम_, 
   {{0x9f580218,0xceb40095,0x20cf00c3,0x27fc02c5}},	//   yarî_, nlə_, _ażil_, savn_, 
   {{0x2d803b78,0xf8b8021f,0x7e663b79,0xb5fd00e0}},	//   nzie_, _көк_, _mokp, ekšs, 
   {{0xd6d2073c,0xb8653b7a,0x27210503,0x61fd016a}},	//   _فقط_, _والو, bón_, wasl, 
   {{0x27210b6f,0xceb40095,0xd5b200d4,0x9f58009e}},	//   cón_, klə_, _کفش_, warî_, 
   {{0x9c8700bc,0x38bb010c,0x9f58009e,0x29000028}},	//   _kočá, mêra_, tarî_, šiau_, 
   {{0x61e40068,0x64a63b7b,0xa3c903ce,0xb5fd0028}},	//   _dfil, _лада, लेब_, rkšt, 
   {{0x2d800da6,0x61e43b7c,0x61fd3b7d,0x994c0032}},	//   dzie_, _efil, sasl, _vôňa_, 
   {{0x93fb00fe,0x4fc43b7e,0x61fd3b7f,0x61e40156}},	//   _גלוי, зста, pasl, _ffil, 
   {{0xa19510df,0x5f940fcc,0x00000000,0x00000000}},	//   _майч, чист, --, --, 
   {{0x2721128a,0x925702b9,0x2d58269c,0x32093b80}},	// [2d30] zón_, _вақт_, бить_, _iday_, 
   {{0x27210126,0xf21f034d,0x6f153b81,0xaae70038}},	//   yón_, _भाड़_, puzc, مسؤو, 
   {{0x272103da,0xb5fd008b,0xb21b003e,0xddcf020f}},	//   xón_, ljše, rhæf, _focş, 
   {{0x2721001d,0x7d16012b,0xdb1f04f4,0x290f3b82}},	//   vón_, buys, _ávís, trga_, 
   {{0xae1a0137,0xd5a60a5a,0xb5fd0352,0x786f00fc}},	//   _דורכ, _آف_, njše, _høvi, 
   {{0xd7fb28c1,0x2721070b,0x628f020f,0x00000000}},	//   ууд_, tón_, hico, --, 
   {{0x3209002c,0x628f3b83,0x7b640a31,0x9b6b01ff}},	//   _oday_, kico, _етте, _ёшга_, 
   {{0x27213b84,0x628f044e,0x32093b85,0xb5fd01dd}},	//   rón_, jico, _nday_, ekšr, 
   {{0x2721070b,0x00000000,0x00000000,0x00000000}},	//   són_, --, --, --, 
   {{0x27210634,0x61e43b86,0xe5760235,0x730500dd}},	//   pón_, _sfil, юзы_, опоз, 
   {{0x628f1408,0xe7ef00a2,0x32093688,0x68e90082}},	//   fico, _घ्या_, _bday_, _hted, 
   {{0x628f3b87,0xf1bf0126,0xe2972989,0x00000000}},	//   gico, rfán_, жаю_, --, 
   {{0xd17526ef,0x51ba0028,0x21750176,0x2a3a0070}},	//   пыры, рыня_, пурр, בערמ, 
   {{0x68e90204,0x201e2e14,0x661b2eef,0x753b0027}},	//   _mted, üti_, lguk, mwuz, 
   {{0xceb40095,0x64433b88,0x7e663b89,0xbbb8109f}},	//   tlə_, _iani, _pokp, _अरेक, 
   {{0x64433b8a,0xee3a0843,0xfdea3b8b,0x2d8001d6}},	//   _hani, јна_, рдак_, tzie_, 
   {{0x64433b8c,0xa3c3034d,0x7fd60100,0xceb406d0}},	// [2d40] _kani, ्शक_, _міні, rlə_, 
   {{0xa3bd0394,0x2d800dfe,0x6fde02e6,0xab2a3b8d}},	//   _आरा_, rzie_, _मलिं, иоза_, 
   {{0xe9da3b8e,0x6a863b8f,0x7e66011c,0x68e93b90}},	//   аке_, олжа, _tokp, _ated, 
   {{0x64433b91,0x4aaa13c3,0x9c8700bc,0x394d0090}},	//   _lani, шкен_, _počá, _bres_, 
   {{0x81ac00cc,0x394d3b92,0xa3c9009a,0xdb0700bc}},	//   কের_, _cres_, लेत_, _vyjá, 
   {{0x64433b93,0xb9023b94,0xd90d00d4,0x3a2d0068}},	//   _nani, _नं_, ایل_, _ebep_, 
   {{0x394d3b95,0xe3a7017a,0x8b230aa3,0xd6d735bf}},	//   _eres_, _آر_, _одре, оты_, 
   {{0x628f380b,0x64433b96,0x395d006d,0x661b3b97}},	//   xico, _aani, bxws_, gguk, 
   {{0x7d043b98,0x64433b99,0xd49a3b9a,0x261b0790}},	//   nsis, _bani, иро_, _यारी_, 
   {{0x64433b9b,0x7d043b9c,0xe46a3b9d,0xa25b02aa}},	//   _cani, isis, ршил_, rmôm, 
   {{0x628f3b9e,0x64470054,0x7d043b9f,0x00000000}},	//   tico, ôjia, hsis, --, 
   {{0x7d043ba0,0xd377012d,0x95ca1efe,0xdb213ba1}},	//   ksis, ючы_, _кула_, étét, 
   {{0x628f3ba2,0x64433ba3,0x66000ab1,0xe1ff3ba4}},	//   rico, _fani, mamk, raó_, 
   {{0x628f3ba5,0x64433ba6,0xdfd80093,0x3e6e00de}},	//   sico, _gani, жът_, _mýtu_, 
   {{0x628f3ba7,0x81ac0086,0x44e03ba8,0x7d043ba9}},	//   pico, কেল_, _hò_, esis, 
   {{0x44e00cd7,0x66003baa,0x7c2e3bab,0x2a7d006d}},	//   _kò_, namk, _abbr, xhwb_, 
   {{0xd904086b,0x7d040268,0x442e00ca,0xdddd0035}},	// [2d50] _جی_, gsis, _kbf_, _posł, 
   {{0x44e03bac,0x64433bad,0x66001233,0xfc330038}},	//   _mò_, _xani, hamk, بحر_, 
   {{0x44e03bae,0x68e93baf,0x66003bb0,0x442e0640}},	//   _lò_, _sted, kamk, _mbf_, 
   {{0x66003bb1,0x7c2e3bb2,0x787d0237,0x00000000}},	//   jamk, _ebbr, _mève, --, 
   {{0x6600085f,0x44e00300,0x628d045a,0x81cd0033}},	//   damk, _nò_, _mmao, শুর_, 
   {{0xbca500eb,0x68e90228,0x3e7c00bc,0x48ab031a}},	//   _رمزي, _vted, _víte_, штем_, 
   {{0xf77100b8,0x6443090b,0x68e900ab,0xb902007e}},	//   عات_, _rani, _wted, _नू_, 
   {{0x394d3bb3,0x44e03bb4,0x6d4f090e,0x442e3bb5}},	//   _tres_, _bò_, _krca, _abf_, 
   {{0x64433bb6,0x44e03bb7,0x798200ab,0x6d4f012b}},	//   _pani, _cò_, czow, _jrca, 
   {{0x629d3bb8,0xc4822f48,0x64433bb9,0x44e03bba}},	//   éron, ельк, _qani, _dò_, 
   {{0xf1a90138,0x2292012d,0xa3ab12e3,0x324603b6}},	//   _עס_, eška_, _कुश_, пенг, 
   {{0x64432e67,0xe29a3bbb,0x44e006df,0x2eb5049f}},	//   _wani, сам_, _fò_, ंतोत, 
   {{0x64433bbc,0xbbb8000d,0xa7fc027e,0x44e000e7}},	//   _tani, _अर्क, _alıy, _gò_, 
   {{0xf09f1c71,0x628d0379,0x15420ec6,0x6443018e}},	//   dràs_, _emao, _чешм, _uani, 
   {{0xa06a005e,0x1fb53bbd,0xa0a30104,0x44e00cba}},	//   _ғана_, дстр, хард, _zò_, 
   {{0x3e6e008c,0x7d043bbe,0x6d4f3bbf,0x71a63bc0}},	//   _nýtt_, tsis, _brca, _найз, 
   {{0x320200a9,0xed573bc1,0x44e002a3,0x6d4f00a1}},	// [2d60] maky_, пот_, _xò_, _crca, 
   {{0x7d043bc2,0x32023001,0x99dd0228,0xe058009c}},	//   rsis, laky_, _raňa, _بیست_, 
   {{0x2baf00a5,0xbddb023e,0x645d010c,0x6d4f0241}},	//   _जुदा, _kaèl, êsiy, _erca, 
   {{0x32023215,0x81ac0086,0xfaa33bc3,0x7d043bc4}},	//   naky_, কেঃ_, нахо, psis, 
   {{0x2fda0065,0x6d4f00ca,0x9f58022c,0xbddb011c}},	//   _kgpg_, _grca, larà_, _maèl, 
   {{0x79820035,0x44e03bc5,0x66003bc6,0x3202023a}},	//   rzow, _rò_, wamk, haky_, 
   {{0x44e03bc7,0xa3ab00b5,0x9f5803a1,0x66003bc8}},	//   _sò_, _कुल_, narà_, tamk, 
   {{0x44e03bc9,0x3202014b,0x7e6402a2,0x45d41b2d}},	//   _pò_, jaky_, njip, мойс, 
   {{0xa3c9000c,0x9f5a0096,0x1dbe021a,0x787d0118}},	//   लेस_, _depé_, ्धित, _sève, 
   {{0x628d11a1,0xa3e602e6,0x2292008b,0x66003bca}},	//   _smao, युं_, vška_, samk, 
   {{0xd25113b4,0x44e00118,0x32020379,0x9f5803dd}},	//   نند_, _wò_, faky_, jarà_, 
   {{0x9f5803a1,0x44e01d9f,0xa75b00d1,0x11d90038}},	//   darà_, _tò_, _לדבר, توحة_, 
   {{0xc05b00dd,0x442e3bcb,0x41c70035,0x29060097}},	//   бів_, _tbf_, रेंस, nsoa_, 
   {{0x98bf090e,0x26de3bcc,0x29060026,0x9f3500f0}},	//   _vruć_, _kuto_, isoa_, мегі, 
   {{0xb5fd0412,0x64583bcd,0x6d4f00d2,0x9f5803a1}},	//   ljša, _invi, _srca, garà_, 
   {{0x81ac0086,0x26de0458,0x02a400e4,0x628d0532}},	//   কেই_, _muto_, _прым, _umao, 
   {{0x2d58030f,0x26de3bce,0xb5fd008b,0x442c3bcf}},	// [2d70] пить_, _luto_, njša, ofd_, 
   {{0x64481aed,0x9f5803a1,0xf09f022c,0x6d4f0613}},	//   nddi, barà_, rràs_, _vrca, 
   {{0x20033bd0,0x9f5803a1,0x64480156,0x29060226}},	//   maji_, carà_, iddi, esoa_, 
   {{0x2ea802f8,0x6d4f090b,0x629d004f,0x20033bd1}},	//   ककृत, _trca, nnso, laji_, 
   {{0x9f58248c,0x6d4f00b3,0x6458243f,0x60d701d6}},	//   mará_, _urca, _onvi, _kixm, 
   {{0x26de3bd2,0x9f581a6e,0x660b02cd,0x20033bd3}},	//   _buto_, lará_, _sdgk, naji_, 
   {{0xa6c913e6,0x6d4d3bd4,0x61e60219,0x47d00086}},	//   олка_, lvaa, yckl, _স্বী, 
   {{0x9f581a6e,0x24e9366a,0x442c01c8,0xa3c226f2}},	//   nará_, омии_, efd_, ्धन_, 
   {{0x6d4d3bd5,0x20033bd6,0x32020180,0x9f582134}},	//   nvaa, kaji_, vaky_, iará_, 
   {{0x20030010,0xd90d0019,0x629d0c0c,0x2b43008a}},	//   jaji_, _میچ_, enso, _ksjc_, 
   {{0x32020180,0x9f58022c,0x3e7c003e,0x06d70033}},	//   taky_, xarà_, _líta_, _সবকি, 
   {{0x64583bd7,0x9f583bd8,0x66d50009,0xa3c902e6}},	//   _envi, jará_, _iško, लेष_, 
   {{0x9f5824a9,0x5155049b,0x32020180,0x26de0a1a}},	//   dará_, нтру, raky_, _zuto_, 
   {{0x9f5803a1,0x20033bd9,0x320213c5,0x6e2d01c8}},	//   tarà_, gaji_, saky_, efab, 
   {{0x4aad0081,0xa3c904b7,0x75293bda,0x6d4d3bdb}},	//   टकाव, लेश_, ltez, evaa, 
   {{0x9f583bdc,0x76493bdd,0x22920121,0x6d4d040b}},	//   gará_, ndey, mško_, fvaa, 
   {{0x75292d5e,0xdb0e031e,0x9f5803a1,0x60d7011c}},	// [2d80] ntez, _vybí, sarà_, _fixm, 
   {{0x69db3281,0x7e7d00a1,0xfbd202b4,0x9f58022c}},	//   _ague, _elsp, نتا_, parà_, 
   {{0xaec60099,0x9f58248c,0x22923bbf,0x68fb011c}},	//   _обол, bará_, nško_, _awud, 
   {{0x9f582142,0x29063bde,0x99dd026e,0xed5a3bdf}},	//   cará_, tsoa_, _daňo, _дом_, 
   {{0x64481b5a,0x764915f3,0xa9670843,0x61fb0a6d}},	//   yddi, ddey, мица_, ðuli, 
   {{0x290609a1,0xd6ea1a9e,0x3ead0121,0x69c00352}},	//   rsoa_, офил_, čete_, _vzme, 
   {{0x29063be0,0x7bdc3be1,0x00000000,0x00000000}},	//   ssoa_, _igru, --, --, 
   {{0x2003086d,0xc956030f,0x26de0727,0x00000000}},	//   zaji_, _отзы, _vuto_, --, 
   {{0x6f1c3be2,0x26de011c,0x66d50028,0x00000000}},	//   hurc, _wuto_, _iškl, --, 
   {{0x9f583be3,0x26de031e,0x162000a2,0xb4b83263}},	//   zará_, _tuto_, _यावर_, चते_, 
   {{0xd62a1da4,0x64483be4,0xa3c9009a,0x7bdc00ca}},	//   _може_, rddi, लेल_, _mgru, 
   {{0x6f1c02f2,0x20030053,0xae1d03ce,0x9f580587}},	//   durc, waji_, _फाइन_, xará_, 
   {{0x20033be5,0x9f5824a9,0x752900b3,0x629d1226}},	//   taji_, vará_, ctez, rnso, 
   {{0xddcd11b1,0x656f01c4,0x7bdc00d4,0x443a3be6}},	//   jkaš, äche, _ngru, _úp_, 
   {{0x9f581408,0x26c63be7,0xb4ca009a,0xf41307e4}},	//   tará_, _khoo_, लगी_, _ספק_, 
   {{0x4ea43065,0x7bdc3be8,0x6d4d12fd,0x20033be9}},	//   вруа, _agru, tvaa, saji_, 
   {{0x9f582f17,0xdd94058b,0x200323d0,0x20c709f9}},	// [2d90] rará_, ваты, paji_, _осог, 
   {{0x31560056,0x6d4d3bea,0x9f5824a9,0x60c50102}},	//   _ניתן_, rvaa, sará_, _uhhm, 
   {{0x9f582126,0x6f1c00b3,0x75293beb,0x6d4d3bec}},	//   pará_, curc, ztez, svaa, 
   {{0xb4ca0c14,0x387e0036,0x6d4d02b0,0x7f4500a3}},	//   लगु_, _altr_, pvaa, _ishq, 
   {{0x22493bed,0x801806bc,0x3a240183,0xd90f0a5a}},	//   _maak_, _عزیز_, _dcmp_, شیا_, 
   {{0x68e01f01,0x2b4303dd,0x2249039b,0xb4b80110}},	//   _dumd, _tsjc_, _laak_, चतो_, 
   {{0x7afc0156,0x200100c2,0x38c90019,0x7c30039f}},	//   _gwrt, _mehi_, _ہائی_, ékrő, 
   {{0x26c63bee,0x06093346,0x75293bef,0x75453bf0}},	//   _choo_, чник_, ttez, ениз, 
   {{0xf5480029,0x76493bf1,0x2a7f0008,0x75290183}},	//   _cụ_, rdey, _ilub_, utez, 
   {{0x27280218,0x75293bf2,0x2a7f01c1,0x33652918}},	//   bûn_, rtez, _hlub_, евог, 
   {{0xa3c90c06,0xe8d600a7,0x291d2e5f,0xf7700296}},	//   लें_, _נוער_, luwa_, _پال_, 
   {{0xbbdc000f,0x25a0203b,0x22921a44,0x7529020f}},	//   _बल्क, _žile_, rško_, ptez, 
   {{0xb5fd0082,0x70ab0035,0x20013bf3,0x26cd216b}},	//   ljšo, चकूल, _behi_, mmeo_, 
   {{0xd11c190a,0x2a6d3bf4,0x38a90032,0x6f1c3bf5}},	//   भूषण_, _loeb_, túry_, turc, 
   {{0xc7b207f5,0x2baf00b5,0x2a7f06d0,0x291d3bf6}},	//   ָבן_, _जुला, _olub_, huwa_, 
   {{0x291d1bb2,0x9f5c3bf7,0x68330e7b,0xb21b02c9}},	//   kuwa_, _því_, lıdı, lhæn, 
   {{0xafe62c54,0xf8af0a34,0xec7a0200,0x20010054}},	// [2da0] _попл, टवाय, ппа_, _fehi_, 
   {{0x64572126,0x2249012e,0x291d3530,0xb21b055f}},	//   _óxid, _zaak_, duwa_, nhæn, 
   {{0xddcd14f0,0x3ce500a5,0x386c0183,0x2249016a}},	//   rkaš, _झूठे_, _rodr_, _yaak_, 
   {{0x09e63bf8,0x2a7f3bf9,0x39440045,0x7d163bfa}},	//   ходн, _club_, _psms_, prys, 
   {{0x291d3bfb,0x6386005f,0x3ea03bfc,0xe2970070}},	//   guwa_, _kéné, mnit_, עכנט_, 
   {{0x6d463bfd,0x3b0a152e,0x3ea03bfe,0x272800f3}},	//   _iska, _него_, lnit_, tûn_, 
   {{0x3ea0024a,0x26c6006d,0xdca33bff,0x63863c00}},	//   onit_, _phoo_, _сари, _méné, 
   {{0x3ea016b5,0x291d3c01,0x940500ad,0x27280216}},	//   nnit_, buwa_, milə_, rûn_, 
   {{0x22490691,0x3ea03c02,0xb21b055f,0xe9a30a31}},	//   _raak_, init_, fhæn, _батп, 
   {{0xf54800f7,0x2249018c,0x638610fd,0x3ea03c03}},	//   _vụ_, _saak_, _néné, hnit_, 
   {{0x7ae92e7d,0x26c63c04,0x22493c05,0xd764009c}},	//   _četk, _thoo_, _paak_, _جنای, 
   {{0x6d463c06,0x09d400cc,0xf54800e7,0x877b0070}},	//   _oska, _হ্যা, _tụ_, _מאבי, 
   {{0x22490b32,0x6386026d,0x20010226,0x3ea002d9}},	//   _vaak_, _béné, _pehi_, dnit_, 
   {{0x6386023e,0xf1c70035,0x7c3e042a,0x66023c07}},	//   _céné, रेगन, jepr, _heok, 
   {{0x443e0034,0x6d463c08,0x9f34019e,0x22490b1f}},	//   met_, _aska, лері, _taak_, 
   {{0x644a3c09,0x2001011c,0x291d052b,0x626728b7}},	//   _hafi, _wehi_, yuwa_, _سابق, 
   {{0xdb0e026e,0x7c3e0304,0x61ed3c0a,0x66020415}},	// [2db0] _rybá, fepr, _ifal, _meok, 
   {{0x63860518,0x64840014,0x644a023a,0x4cb80235}},	//   _géné, _dòig, _jafi, елую_, 
   {{0x6d460414,0x7f4500e5,0xa3c232f0,0x291d019b}},	//   _eska, _ushq, ्धि_, wuwa_, 
   {{0x443e3c0b,0x644a3c0c,0xd99900eb,0x291d3c0d}},	//   het_, _lafi, ونات_, tuwa_, 
   {{0x443e3c0e,0xd9453c0f,0x61ed0053,0x27ec0065}},	//   ket_, тели, _mfal, _bfdn_, 
   {{0x443e3c10,0xa3c2075a,0xe7393c11,0x291d3c12}},	//   jet_, ्धा_, дек_, ruwa_, 
   {{0x443e3c13,0x291d3c14,0x66020082,0x94240095}},	//   det_, suwa_, _beok, _ötən_, 
   {{0x81ac0086,0x291d3c15,0x6d460326,0x443e0080}},	//   কেট_, puwa_, _yska, eet_, 
   {{0x443e3c16,0x644a3c17,0x26cd2f94,0xe5710038}},	//   fet_, _bafi, rmeo_, شطة_, 
   {{0x443e08c2,0xf9900629,0x61ed3c18,0x3ea03c19}},	//   get_, _طبق_, _afal, znit_, 
   {{0x03a50099,0x644a3c1a,0x6602023a,0x68330540}},	//   тино, _dafi, _feok, rıdı, 
   {{0x7c3e00ab,0x68330540,0x63860107,0xe1ff01d5}},	//   zepr, sıdı, _séné, sjón_, 
   {{0x443e3c1b,0x644a3c1c,0xb14305e0,0x63860107}},	//   bet_, _fafi, анял, _péné, 
   {{0x764b006b,0x61ed02bf,0x644a3c1d,0x648400a1}},	//   _hagy, _efal, _gafi, _ròig, 
   {{0x764b3c1e,0xdee63c1f,0x7c3e2426,0x63861390}},	//   _kagy, тоби, vepr, _véné, 
   {{0x644a3c20,0x940500ad,0x00000000,0x00000000}},	//   _zafi, vilə_, --, --, 
   {{0x764b0105,0x7c3e3c21,0x3ea03c22,0x1d0705b4}},	// [2dc0] _magy, tepr, rnit_, кети_, 
   {{0x3ea03c23,0x711b00c7,0xac831628,0x2bc617dc}},	//   snit_, _קויפ, агул, _वरदा, 
   {{0x290d0012,0x7c3e0087,0x6d4600ab,0xa3d10586}},	//   _avea_, repr, _wska, वधि_, 
   {{0x764b0105,0x443e3c24,0x7c3e3c25,0x940500ad}},	//   _nagy, zet_, sepr, rilə_, 
   {{0x443e3c26,0x94050095,0x6d463c27,0x3d19034d}},	//   yet_, silə_, _uska, _पिये_, 
   {{0x66023c28,0x443e3c29,0x68ed3c2a,0x270c00d8}},	//   _seok, xet_, íada, těn_, 
   {{0x443e0310,0x644a3c2b,0x764b3c2c,0x569400d3}},	//   vet_, _rafi, _bagy, лакт, 
   {{0x443e3c2d,0x6e243c2e,0x644a3c2f,0x442703a1}},	//   wet_, ngib, _safi, _acn_, 
   {{0x7ae900f1,0x443e0c2e,0x48e602fb,0xd9433c30}},	//   _četi, tet_, _розв, _кети, 
   {{0x443e3c31,0x442700f6,0x61ed0036,0x644a3c32}},	//   uet_, _ccn_, _sfal, _qafi, 
   {{0x443e3c33,0x8c1b0137,0x261b00a2,0xd6cf237b}},	//   ret_, וויי, _याची_, _вт_, 
   {{0x443e3c27,0x92580088,0x644a187e,0xa3e60598}},	//   set_, вают_, _wafi, युज_, 
   {{0x644a00a9,0x3e750219,0xf1c40098,0x44270b41}},	//   _tafi, _mått_, _ruší_, _fcn_, 
   {{0x443e01ee,0x1c1e04bd,0x843800eb,0x74140019}},	//   qet_, _पागल_, _أكثر_, _صوبا, 
   {{0xf2c73c34,0x7f94011f,0x61fb0679,0x66c5010e}},	//   _исин, аарх, ðuls, lóka, 
   {{0x3e75014e,0x6e243c35,0x61ed0053,0x2ebf1276}},	//   _nått_, ggib, _ufal, ्षेत, 
   {{0x51870c8b,0x5d5512d2,0x6aa21377,0xfd7400d9}},	// [2dd0] _шука, ыкат, dnof, алтэ, 
   {{0x1acb0c94,0x041400cc,0x673a3c36,0x6e24052b}},	//   िष्ठ, ত্রী_, _optj, agib, 
   {{0x290d1070,0x76400080,0xc61a0033,0x787d0237}},	//   _svea_, kemy, থ্যা_, _sèvo, 
   {{0xb21b055f,0xdea1010e,0x7520018e,0x6aa2040b}},	//   skæf, _ایری, kumz, gnof, 
   {{0x76403c37,0x66ea0035,0x0d6400fd,0x7d1f01ff}},	//   demy, _ręka, _кърм, quqs, 
   {{0xfaf3024f,0xb4ac031e,0x66d50009,0x17c900a3}},	//   _نثر_, कको_, _iški, нгли_, 
   {{0x3e7505a1,0x4427140c,0xe7393c38,0x764b3c39}},	//   _fått_, _rcn_, хей_, _pagy, 
   {{0x3e7503a8,0x9f513c3a,0x7bc70caf,0x7d0d13ba}},	//   _gått_, lazó_, _izju, osas, 
   {{0x764b3c3b,0x955500eb,0xdd1203c0,0x673a0415}},	//   _vagy, اخبا, _müşt, _eptj, 
   {{0x764b02a5,0x22920352,0x7c253c3c,0x9f510369}},	//   _wagy, mški_, nghr, nazó_, 
   {{0x22920304,0x7c25007a,0x6d440083,0x7d0d023e}},	//   lški_, ighr, zwia, hsas, 
   {{0xad9b3c3d,0x7d0d3c3e,0x95551ea7,0x6d443