\name{getAvgAcc}
\alias{getAvgAcc}
\title{
Get the average accuracies of a classification ensemble
}
\description{
The \code{avgTestAcc} function returns the average test accuracy (\%CC) and average train accuracy of an ensemble of classifiers as generated by the function \code{\link{cfBuild}}.
}
\usage{
getAvgAcc(ensObj)
}
\arguments{
  \item{ensObj}{The classification ensemble (in the form of an R list) as generated by \code{\link{cfBuild}}}
}
\value{
The \code{avgTestAcc} function returns a list with two named (\code{Test} and \code{Train}) numerical values, equal to the average overall test accuracy (\%CC) and the average overall train accuracy of the ensemble. The attributes of the list can be accessed by executing the \link{attributes} command.
}
\seealso{
  \code{\link{getAcc}}
}
\examples{
\dontrun{
data(iris)

irisClass <- iris[,5]
irisData  <- iris[,-5]

ens <- cfBuild(inputData = irisData, inputClass = irisClass, bootNum = 100, 
               ensNum = 100, parallel = TRUE, cpus = 4, type = "SOCK")

attributes(getAvgAcc(ens))

# Get the average test and train accuracies within the ensemble
getAvgAcc(ens)

# Get the average test accuracy 
getAvgAcc(ens)$Test

# Get the average train accuracy
getAvgAcc(ens)$Train
}
}
\keyword{array}
