% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{cja_auth_with}
\alias{cja_auth_with}
\alias{cja_auth_path}
\alias{cja_auth_name}
\title{Set authorization options}
\usage{
cja_auth_with(type)

cja_auth_path(path)

cja_auth_name(name)
}
\arguments{
\item{type}{The authorization type: 'oauth' or 'jwt'}

\item{path}{The location for the cached authorization token. It should be a
directory, rather than a filename. If this option is not set, the current
working directory is used instead. If the location does not exist, it will
be created the first time a token is cached.}

\item{name}{The filename, such as \code{cja_auth.rds} for the cached authorization
token file. The file is stored as an RDS file, but there is no requirement
for the \code{.rds} file extension. \code{.rds} is not appended automatically.}
}
\value{
The option value, invisibly
}
\description{
\strong{Get} or \strong{set} various authorization options. If called without an argument, then
these functions return the current setting for the requested option (which can be
\code{NULL} if the option has not been set). To clear the setting, pass \code{NULL} as an
argument.

\code{cja_auth_with} sets the type of authorization for the session. This is used
as the default by \code{cja_auth()} when no specific option is given.

\code{cja_auth_path} sets the file path for the cached authorization token. It
should be a directory, rather than a filename. If this option is not set, the
current working directory is used instead.

\code{cja_auth_name} sets the file name for the cached authorization token. If this
option is not set, the default filename is \code{cja_auth.rds}
}
\seealso{
\code{\link[=cja_auth]{cja_auth()}}
}
\concept{options}
