% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/civis_future.R
\name{civis_platform}
\alias{civis_platform}
\title{Evaluate an expression in Civis Platform}
\usage{
civis_platform(...)
}
\arguments{
\item{...}{Arguments to \code{\link{CivisFuture}} and then \code{\link{scripts_post_containers}}}
}
\value{
The result of evaluating \code{expr}.
}
\description{
This is used as with the \code{\link{future}} API as an argument to \code{\link{plan}}.
}
\examples{
\dontrun{

 plan(civis_platform)

 # Specify required resources, image, and tag.
 fut <- future({2 + 2},
   required_resources = list(cpu = 1024, memory = 2048),
   docker_image_name = "civisanalytics/datascience-r",
   docker_image_tag = "3")

 # Evaluate the future later
 fut <- future({2 + 2}, lazy = TRUE)
 run(fut)

 # check if a future has resolved
 resolved(fut)

 # block until the future resolves, and return the value or throw error
 value(fut)

 # cancel the job
 cancel(fut)

 # grab the run logs
 fetch_logs(fut)

 # handle errors
 fut <- future({stop("Error!")})
 e <- tryCatch(value(fut), error = function(e) e)
 get_error(e)
}

}
