% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{imports_patch_files_csv}
\alias{imports_patch_files_csv}
\title{Update some attributes of this CSV Import}
\usage{
imports_patch_files_csv(
  id,
  name = NULL,
  source = NULL,
  destination = NULL,
  first_row_is_header = NULL,
  column_delimiter = NULL,
  escaped = NULL,
  compression = NULL,
  existing_table_rows = NULL,
  max_errors = NULL,
  table_columns = NULL,
  loosen_types = NULL,
  execution = NULL,
  redshift_destination_options = NULL
)
}
\arguments{
\item{id}{integer required. The ID for the import.}

\item{name}{string optional. The name of the import.}

\item{source}{list optional. A list containing the following elements: 
\itemize{
\item fileIds array, The file ID(s) to import, if importing Civis file(s).
\item storagePath list . A list containing the following elements: 
\itemize{
\item storageHostId integer, The ID of the source storage host.
\item credentialId integer, The ID of the credentials for the source storage host.
\item filePaths array, The file or directory path(s) within the bucket from which to import.  E.g. the file_path for "s3://mybucket/files/all/" would be "/files/all/"If specifying a directory path, the job will import every file found under that path. All files must have the same column layout and file format (e.g., compression, columnDelimiter, etc.).
}
}}

\item{destination}{list optional. A list containing the following elements: 
\itemize{
\item schema string, The destination schema name.
\item table string, The destination table name.
\item remoteHostId integer, The ID of the destination database host.
\item credentialId integer, The ID of the credentials for the destination database.
\item primaryKeys array, A list of column(s) which together uniquely identify a row in the destination table.These columns must not contain NULL values. If the import mode is "upsert", this field is required;see the Civis Helpdesk article on "Advanced CSV Imports via the Civis API" for more information.
\item lastModifiedKeys array, A list of the columns indicating a record has been updated.If the destination table does not exist, and the import mode is "upsert", this field is required.
}}

\item{first_row_is_header}{boolean optional. A boolean value indicating whether or not the first row of the source file is a header row.}

\item{column_delimiter}{string optional. The column delimiter for the file. Valid arguments are "comma", "tab", and "pipe". Defaults to "comma".}

\item{escaped}{boolean optional. A boolean value indicating whether or not the source file has quotes escaped with a backslash.Defaults to false.}

\item{compression}{string optional. The type of compression of the source file. Valid arguments are "gzip" and "none". Defaults to "none".}

\item{existing_table_rows}{string optional. The behavior if a destination table with the requested name already exists.  One of "fail", "truncate", "append", "drop", or "upsert".Defaults to "fail".}

\item{max_errors}{integer optional. The maximum number of rows with errors to ignore before failing. This option is not supported for Postgres databases.}

\item{table_columns}{array optional. An array containing the following fields: 
\itemize{
\item name string, The column name.
\item sqlType string, The SQL type of the column.
}}

\item{loosen_types}{boolean optional. If true, SQL types with precisions/lengths will have these values increased to accommodate data growth in future loads. Type loosening only occurs on table creation. Defaults to false.}

\item{execution}{string optional. In upsert mode, controls the movement of data in upsert mode. If set to "delayed", the data will be moved after a brief delay. If set to "immediate", the data will be moved immediately. In non-upsert modes, controls the speed at which detailed column stats appear in the data catalogue. Defaults to "delayed", to accommodate concurrent upserts to the same table and speedier non-upsert imports.}

\item{redshift_destination_options}{list optional. A list containing the following elements: 
\itemize{
\item diststyle string, The diststyle to use for the table. One of "even", "all", or "key".
\item distkey string, Distkey for this table in Redshift
\item sortkeys array, Sortkeys for this table in Redshift. Please provide a maximum of two.
}}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for the import.}
\item{name}{string, The name of the import.}
\item{source}{list, A list containing the following elements: 
\itemize{
\item fileIds array, The file ID(s) to import, if importing Civis file(s).
\item storagePath list . A list containing the following elements: 
\itemize{
\item storageHostId integer, The ID of the source storage host.
\item credentialId integer, The ID of the credentials for the source storage host.
\item filePaths array, The file or directory path(s) within the bucket from which to import.  E.g. the file_path for "s3://mybucket/files/all/" would be "/files/all/"If specifying a directory path, the job will import every file found under that path. All files must have the same column layout and file format (e.g., compression, columnDelimiter, etc.).
}
}}
\item{destination}{list, A list containing the following elements: 
\itemize{
\item schema string, The destination schema name.
\item table string, The destination table name.
\item remoteHostId integer, The ID of the destination database host.
\item credentialId integer, The ID of the credentials for the destination database.
\item primaryKeys array, A list of column(s) which together uniquely identify a row in the destination table.These columns must not contain NULL values. If the import mode is "upsert", this field is required;see the Civis Helpdesk article on "Advanced CSV Imports via the Civis API" for more information.
\item lastModifiedKeys array, A list of the columns indicating a record has been updated.If the destination table does not exist, and the import mode is "upsert", this field is required.
}}
\item{firstRowIsHeader}{boolean, A boolean value indicating whether or not the first row of the source file is a header row.}
\item{columnDelimiter}{string, The column delimiter for the file. Valid arguments are "comma", "tab", and "pipe". Defaults to "comma".}
\item{escaped}{boolean, A boolean value indicating whether or not the source file has quotes escaped with a backslash.Defaults to false.}
\item{compression}{string, The type of compression of the source file. Valid arguments are "gzip" and "none". Defaults to "none".}
\item{existingTableRows}{string, The behavior if a destination table with the requested name already exists.  One of "fail", "truncate", "append", "drop", or "upsert".Defaults to "fail".}
\item{maxErrors}{integer, The maximum number of rows with errors to ignore before failing. This option is not supported for Postgres databases.}
\item{tableColumns}{array, An array containing the following fields: 
\itemize{
\item name string, The column name.
\item sqlType string, The SQL type of the column.
}}
\item{loosenTypes}{boolean, If true, SQL types with precisions/lengths will have these values increased to accommodate data growth in future loads. Type loosening only occurs on table creation. Defaults to false.}
\item{execution}{string, In upsert mode, controls the movement of data in upsert mode. If set to "delayed", the data will be moved after a brief delay. If set to "immediate", the data will be moved immediately. In non-upsert modes, controls the speed at which detailed column stats appear in the data catalogue. Defaults to "delayed", to accommodate concurrent upserts to the same table and speedier non-upsert imports.}
\item{redshiftDestinationOptions}{list, A list containing the following elements: 
\itemize{
\item diststyle string, The diststyle to use for the table. One of "even", "all", or "key".
\item distkey string, Distkey for this table in Redshift
\item sortkeys array, Sortkeys for this table in Redshift. Please provide a maximum of two.
}}
\item{hidden}{boolean, The hidden status of the item.}
}
\description{
Update some attributes of this CSV Import
}
