% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cito.R
\docType{package}
\name{cito}
\alias{cito}
\title{'cito': Building and training neural networks}
\description{
Building and training custom neural networks in the typical R syntax. The 'torch' package is used for numerical calculations, which allows for training on CPU as well as on a graphics card.
The main function is \code{\link{dnn}} which trains a custom deep neural network.
}
\section{Installation}{


in order to install cito please follow these steps:

\code{install.packages("cito")}

\code{library(torch)}

\code{install_torch(reinstall = TRUE)}

\code{library(cito)}
}

\section{cito functions}{

\itemize{
\item \code{\link{dnn}}: train deep neural network
\item \code{\link{continue_training}}: continues training of an existing cito dnn model for additional epochs
\item \code{\link{PDP}}: plot the partial dependency plot for a specific feature
\item \code{\link{ALE}}: plot the accumulated local effect plot for a specific feature
}
}

\examples{

vignette("Introduction_to_cito", "cito")

}
