% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_visualization.R
\name{ssm_append}
\alias{ssm_append}
\title{Combine SSM tables}
\usage{
ssm_append(.ssm_table, ..., caption = NULL, render = TRUE)
}
\arguments{
\item{.ssm_table}{A data frame from the \code{ssm_table()} function to be the
first row(s) of the combined table.}

\item{...}{One or more additional data frames from the \code{ssm_table()}
function to be appended to \code{.ssm_table} in the order of input.}

\item{caption}{A string to be displayed above the table if rendered.}

\item{render}{A logical indicating whether the table should be displayed in
the RStudio viewer or web browser (default = TRUE).}
}
\value{
A tibble containing the information for the HTML table. As a
side-effect, may also output the HTML table to the web viewer.
}
\description{
Combine SSM tables by appending them as rows.
}
\examples{
data("jz2017")
res1 <- ssm_analyze(jz2017, PA:NO, octants())
res2 <- ssm_analyze(jz2017, PA:NO, octants(), grouping = Gender)
tab1 <- ssm_table(res1, render = FALSE)
tab2 <- ssm_table(res2, render = FALSE)
ssm_append(tab1, tab2)
}
\seealso{
Other ssm functions: \code{\link{ssm_analyze}},
  \code{\link{ssm_plot}}, \code{\link{ssm_table}}

Other table functions: \code{\link{html_render}},
  \code{\link{ssm_table}}
}
\concept{ssm functions}
\concept{table functions}
