% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThrSelection.R
\name{ThrSelection}
\alias{ThrSelection}
\title{Threshold selection}
\usage{
ThrSelection(
  Data,
  drc,
  h = 30,
  b = 0.35,
  thetaGrid,
  EVIestimator = "ML",
  useKernel = TRUE,
  concent = 10,
  bw = 30,
  numCores = 2
)
}
\arguments{
\item{Data}{Response variable}

\item{drc}{Directional covariate}

\item{h}{Bandwidth value}

\item{b}{Parameter used in the automatic procedure for selection of local
number of exceedances}

\item{thetaGrid}{Grid values at which the estimation is performed}

\item{EVIestimator}{It can be either "ML" or "Mom"}

\item{useKernel}{Logical. If TRUE (default), use kernel to assign weights
depending on the directional distance.}

\item{concent}{Concentration parameter value for von Mises kernel}

\item{bw}{Bandwidth parameter value for smoothing the sample path of the
selected threshold}

\item{numCores}{Number of CPU cores to be used}
}
\value{
List containing the selected threshold and selected number of local
  exceedances at each direction in the grid.
}
\description{
This function selects a moving threshold for circular data using an automatic
procedure for selecting the local number of exceedances
}
\details{
See Konzen, E., Neves, C., and Jonathan, P. (2021). Modeling nonstationary extremes of storm severity: Comparing parametric and semiparametric inference. Environmetrics, 32(4), e2667.
}
\examples{
data(HsSP)
data(drc)
timeRange <- 54.5

idx <- order(drc)
drc <- drc[idx]
Data <- HsSP[idx]
set.seed(1234)
Data <- Data + runif(length(Data), -1e-4, 1e-4)

thetaVec <- 1:360

\donttest{

thrResultMom <- ThrSelection(Data=Data, drc=drc, h=60, b=0.35, thetaGrid=thetaVec,
                             EVIestimator="Mom", useKernel=T, concent=10, bw=30,
                             numCores=2)$thr
thrResultML <- ThrSelection(Data=Data, drc=drc, h=60, b=0.35, thetaGrid=thetaVec,
                            EVIestimator="ML", useKernel=T, concent=10, bw=30,
                            numCores=2)$thr
}


## See also examples in vignettes:
# vignette("localMethods", package = "circularEV")
# vignette("splineML", package = "circularEV")

}
\seealso{
\code{\link{PlotData}} and \code{\link{PolarPlotData}} to see how
the threshold can be visualised.
}
