% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccBoxplot}
\alias{ccBoxplot}
\title{Draw boxplots}
\usage{
ccBoxplot(
  value,
  pos,
  outline = TRUE,
  box_width = 0.6,
  col = NA,
  border = "black",
  lwd = par("lwd"),
  lty = par("lty"),
  cex = par("cex"),
  pch = 1,
  pt.col = par("col")
)
}
\arguments{
\item{value}{A numeric vector, a matrix or a list. If it is a matrix, boxplots are made by columns (each column is a box).}

\item{pos}{Positions of the boxes.}

\item{outline}{Whether to draw outliers.}

\item{box_width}{Width of boxes.}

\item{col}{Filled color of boxes.}

\item{border}{Color for the border as well as the quantile lines.}

\item{lwd}{Line width.}

\item{lty}{Line style}

\item{cex}{Point size.}

\item{pch}{Point type.}

\item{pt.col}{Point color.}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.boxplot]{circlize::circos.boxplot} while drawing.
}
\examples{
library(circlizePlus)
cc <- ccPlot(sectors = letters[1:4], xlim = c(0, 10))
track <- ccTrack(ylim = c(0, 1))
cell <- ccCell(sector.index = "a") + ccBoxplot(value = replicate(runif(10),
n = 10, simplify = FALSE), pos = 1:10 - 0.5, col = 1:10)
track <- track + cell
cc + track
}
