% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{cimis_compass_to_degrees}
\alias{cimis_compass_to_degrees}
\title{Compass Direction To Degrees}
\usage{
cimis_compass_to_degrees(x)
}
\arguments{
\item{x}{A vector of compass directions, i.e. the data item labels
"DayWindNnw", "DayWindSse", etc. Recognized directions are
North-northeast (NNE), East-northeast (ENE), East-southeast (ESE),
South-southeast (SSE), South-southwest (SSW), West-southwest (WSW),
West-northwest (WNW), and North-northwest (NNW).}
}
\value{
A numeric vector of degrees corresponding to the middle azimuth
of the corresponding compass direction.
}
\description{
Convert the Compass direction labels to degrees.
}
\examples{
cimis_compass_to_degrees("day-wind-nne")
cimis_compass_to_degrees(c("SSE", "SSW", "wsw", "Wnw", "nnw"))

}
\seealso{
\code{\link[=cimis_degrees_to_compass]{cimis_degrees_to_compass()}}
}
