% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_comp.R
\name{view_comp}
\alias{view_comp}
\title{View composite of images}
\usage{
view_comp(
  img,
  ncol = NULL,
  nrow = NULL,
  legend = NULL,
  title = NULL,
  legend_height = 0.3,
  title_height = 0.1,
  title_fsize = 5,
  newpage = is.null(fname),
  fname = NULL,
  ...
)
}
\arguments{
\item{img}{Character vector of paths to images to include. They will be
arranged by row.}

\item{ncol, nrow}{Control the layout of the composite image. \code{NULL} (default)
will use approximately same numbers of rows and columns.}

\item{legend}{File path to a legend image to add, or \code{NULL} (default)
to not add a legend.}

\item{title}{A length-one character vector to use as the title, or \code{NULL}
(default) to not add a title.}

\item{legend_height, title_height}{Heights of the legend and title, if
applicable. Specified relative to all the plots, so \code{.1} would
mean the height is a tenth of the height of all the plots. Default:
\code{.1} for the title and \code{.3} for the legend.}

\item{title_fsize}{Multiplier for font size. Default: \code{5}}

\item{newpage}{Call \code{grid::grid.newpage} before rendering?
Default: \code{is.null(fname)}.}

\item{fname}{If \code{NULL} (default), print the result. Otherwise, save to
a PNG file at this location. Will override \code{newpage} to \code{FALSE}.}

\item{...}{Additional arguments to \code{gridExtra::arrangeGrob}. The
arguments \code{grobs} and \code{layout_matrix} should be avoided because
they are determined based on \code{img}. adjusting \code{widths} may be useful,
e.g. to make the subcortex subplot be less wide than the cortex subplot.}
}
\value{
The composite plot
}
\description{
Create a single image which displays multiple image files. Tailored to support
composite layouts of plots from \code{\link{view_xifti}}.
}
\details{
Requires the following packages: \code{png}, \code{grid}, \code{gridExtra}

How it works: the non-legend images (plots) are composited in a call to
\code{grid::arrangeGrob}. If a title or legend exists, it's added to the top and
bottom, respectively, of the plots after with another call to \code{grid::arangeGrob}.
}
