% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_xifti.R
\name{apply_xifti}
\alias{apply_xifti}
\title{Apply a function along the rows or columns of a \code{"xifti"}}
\usage{
apply_xifti(xifti, margin = c(1, 2), FUN, ...)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{margin}{The dimension along which to apply \code{FUN}: 1 for rows (default)
and 2 for columns.}

\item{FUN}{The function. It should take in a numeric vector and return a
length-N numeric vector.}

\item{...}{Additional arguments to \code{FUN}}
}
\value{
A \code{"xifti"} if \code{margin == 1}, or a numeric matrix if
\code{margin == 2}
}
\description{
Apply a many-to-N function (e.g. mean) to the rows or columns of a
\code{"xifti"}. If applied row-wise, a \code{"xifti"} with N data column(s)
is returned. (If the \code{"xifti"} had the dlabel intent, and values that
are not labels are created, then it is converted to dscalar.) If applied
column-wise, a numeric matrix with N rows is returned.

For univariate functions, use \code{\link{transform_xifti}} instead.
}
\seealso{
Other manipulating xifti: 
\code{\link{add_surf}()},
\code{\link{apply_parc}()},
\code{\link{combine_xifti}()},
\code{\link{convert_to_dlabel}()},
\code{\link{merge_xifti}()},
\code{\link{move_to_mwall}()},
\code{\link{move_to_submask}()},
\code{\link{newdata_xifti}()},
\code{\link{remap_cifti}()},
\code{\link{remove_xifti}()},
\code{\link{resample_cifti}()},
\code{\link{resample_cifti_from_template}()},
\code{\link{scale_xifti}()},
\code{\link{select_xifti}()},
\code{\link{set_names_xifti}()},
\code{\link{smooth_cifti}()},
\code{\link{transform_xifti}()}
}
\concept{manipulating xifti}
