% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_csv_chunkwise}
\alias{read_csv_chunkwise}
\alias{read_csv2_chunkwise}
\alias{read_table_chunkwise}
\alias{read_laf_chunkwise}
\title{Read chunkwise data from text files}
\usage{
read_csv_chunkwise(file, chunk_size = 10000L, header = TRUE, sep = ",",
  dec = ".", ...)

read_csv2_chunkwise(file, chunk_size = 10000L, header = TRUE, sep = ";",
  dec = ",", ...)

read_table_chunkwise(file, chunk_size = 10000L, header = TRUE,
  sep = "\\t", dec = ".", ...)

read_laf_chunkwise(laf, chunk_size = 10000L)
}
\arguments{
\item{file}{path of texst file}

\item{chunk_size}{size of the chunks te be read}

\item{header}{Does the csv file have a header with column names?}

\item{sep}{field separator to be used}

\item{dec}{decimal separator to be used}

\item{...}{not used

\code{read_laf_chunkwise} reads chunkwise from a LaF object created with \code{laf_open}.
It offers more control over
data specification.}

\item{laf}{laf object created using LaF}
}
\description{
read_csv_chunk will open a connection to a text file. Subsequent dplyr verbs and commands
are recorded until \code{collect}, \code{\link{write_csv_chunkwise}} is called. In that case
the recorded commands will be executed chunk by chunk. This
}
\details{
read_csv_chunkwise can be best combined with
\code{\link{write_csv_chunkwise}} or
\code{\link{insert_chunkwise_into}} (see example)
}
\examples{
# create csv file for demo purpose
in_file <- file.path(tempdir(), "in.csv")
write.csv(women, in_file, row.names = FALSE, quote = FALSE)

#
women_chunked <-
  read_chunkwise(in_file) \%>\%  #open chunkwise connection
  mutate(ratio = weight/height) \%>\%
  filter(ratio > 2) \%>\%
  select(height, ratio) \%>\%
  inner_join(data.frame(height=63:66)) # you can join with data.frames!

# no processing done until
out_file <- file.path(tempdir(), "processed.csv")
women_chunked \%>\%
  write_chunkwise(file=out_file)

head(women_chunked) # works (without processing all data...)

iris_file <- file.path(tempdir(), "iris.csv")
write.csv(iris, iris_file, row.names = FALSE, quote= FALSE)

iris_chunked <-
  read_chunkwise(iris_file, chunk_size = 49) \%>\% # 49 for demo purpose
  group_by(Species) \%>\%
  summarise(sepal_length = mean(Sepal.Length), n=n()) # note that mean is per chunk

}
