% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{chunker methods}
\alias{chunker methods}
\alias{next_chunk}
\alias{next_chunk,chunker-method}
\alias{next_chunk,chunker-methods}
\alias{get_table}
\alias{get_table,chunker-method}
\alias{get_dataframe,}
\alias{chunker-methods}
\alias{get_colnames}
\alias{get_colnames,chunker-method}
\alias{get_completed}
\alias{get_completed,chunker-method}
\alias{get_completed,chunker-methods}
\alias{get_total}
\alias{get_total,chunker-method}
\alias{get_total,chunker-methods}
\alias{get_type}
\alias{get_type,chunker-method}
\alias{get_type,chunker-methods}
\alias{get_attr}
\alias{get_attr,chunker-method}
\alias{get_attr,chunker-methods}
\title{Manipulation methods for chunker objects}
\usage{
next_chunk(obj)

\S4method{next_chunk}{chunker}(obj)

get_table(obj)

\S4method{get_table}{chunker}(obj)

get_colnames(obj)

\S4method{get_colnames}{chunker}(obj)

get_completed(obj)

\S4method{get_completed}{chunker}(obj)

get_total(obj)

\S4method{get_total}{chunker}(obj)

get_type(obj)

\S4method{get_type}{chunker}(obj)

get_attr(obj)

\S4method{get_attr}{chunker}(obj)
}
\arguments{
\item{obj}{object of class chunker}
}
\description{
chunker objects can be manipulated with the following methods:
\enumerate{
\item{\bold{next_chunk}}{: allows to read the next chunk of a chunker object}
\item{\bold{get_table}}{: retrieve the current data chunk contained in the object}
}

In addition, the following information can be retrieved from chunker objects:
\enumerate{
\item{\bold{get_completed}}{: get the number of rows already read}
\item{\bold{get_colnames}}{: get column names of the chunker object}
}
}
\details{
See \code{\link{chunker}} for examples.
}
