% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platemodel.R
\docType{class}
\name{platemodel-class}
\alias{platemodel-class}
\alias{platemodel}
\alias{initialize,platemodel-method}
\title{Class of objects representing plate tectonic models}
\usage{
\S4method{initialize}{platemodel}(.Object, path = NULL, rotation = NULL, polygons = NULL)
}
\arguments{
\item{.Object}{Constructor argument (not needed).}

\item{path}{(\code{character}) Path to a .mod unique plate model object.}

\item{rotation}{(\code{character}) If \code{path} is \code{NULL}, the path to the rotation file-part of the model.}

\item{polygons}{(\code{character}) If \code{path} is \code{NULL}, the path to the plate polygon file-part of the model.}
}
\value{
A \code{platemodel} class object.
}
\description{
Meta-object containing paths to a unique plate tectonic model
}
\examples{
# extract provided archive
a <- fetch(dat="paleomap", var="model", 
  datadir=system.file("extdata", package="chronosphere"))
# manually attach
model <- platemodel(file.path(tempdir(), 
  "paleomap_model_v19o_r1c/paleomap_model_v19o_r1c.mod"))
model
}
