% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RasterArray-raster.R
\name{crop,RasterArray-method}
\alias{crop,RasterArray-method}
\title{Crop a RasterArray object}
\usage{
\S4method{crop}{RasterArray}(x, y, ...)
}
\arguments{
\item{x}{a \code{RasterArray} class object.}

\item{y}{an xtent object, or any object from which an Extent object can be extracted (see Details)}

\item{...}{arguments passed to the \code{\link[raster]{crop}} function.}
}
\value{
A cropped \code{RasterArray} class object.
}
\description{
The method is inherited from the \code{RasterStack} class.
}
\examples{
data(dems)
# crop to Australia
ext <- extent(c(                
  xmin = 106.58,
  xmax = 157.82,
  ymin = -45.23,
  ymax = 1.14 
)) 
# cropping all DEMS (Australia drifted in)
au<- crop(dems, ext)

}
