% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chronochrt_geom_imagelabels.R
\name{geom_chronochRtImage}
\alias{geom_chronochRtImage}
\title{Add image labels to plot}
\usage{
geom_chronochRtImage(mapping = NULL, data = NULL, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{layer}}. These are often aesthetics, used to set an aesthetic to a fixed value, like \code{height = 1}.}
}
\value{
Layer of a ggplot2 object.
}
\description{
Plot images in a ggplot2 object. Supported file types are: \code{.png},
\code{.jpg}, \code{.tif}, \code{.bmp.}, \code{.svg} (see
\code{\link[magick]{image_read}} for further details).
}
\details{
The images are provided by their paths (local files or URLs) via the
aesthetic \code{image_path}. Rows with invalid file paths are silently
dropped, invalid URLs will throw an error.

The absolute size in cm of the images can be specified via the aesthetics
\code{height} and \code{width}. If only one is specified, the image is scaled
under preservation of its aspect ratio. If both are given, the image might
appear distorted. See examples for further details.
}
\section{Aesthetics}{
 \code{geom_ChronochRtImage()} understands the following
  aesthetics (required aesthetics are in bold): \itemize{ \item
  \strong{\code{image_path}} \item \strong{\code{x}} \item \strong{\code{y}}
  \item \code{group} \item \code{height} \item \code{width} } See Details
  for how these aesthetics work.
}

\examples{

library(ggplot2)

# Create example data
data <- data.frame(x = c(2, 4), y = c(2, 4),
                   image_path = "https://www.r-project.org/logo/Rlogo.png",
                   height = c(1,2), width = c(3,0.5))

q <- ggplot(data) + lims(x = c(0, 6), y = c(0, 6))

# Without size specifications
q + geom_chronochRtImage(aes(image_path = image_path, x = x, y = y))

# Scale images to individual heights/widths by specifying one of them:
q + geom_chronochRtImage(aes(image_path = image_path, x = x, y = y, height = height))

# Scale images to uniform height/width (i.e. independent of input data):
q + geom_chronochRtImage(aes(image_path = image_path, x = x, y = y, height = 1))

# Specifying height and width might result in distorted images:
q + geom_chronochRtImage(aes(image_path = image_path, x = x, y = y, height = height, width = width))
}
\author{
This geom is a modified version of the \code{geom_custom()} from \href{https://github.com/baptiste}{Baptiste Auguié}'s \href{https://cran.r-project.org/package=egg}{egg package}.
}
