test_that("Creating and adding", {

  expect_equal(object = add_chron(region = "Atlantis",
                                  name = c("Atlas", "II", "Poseidon", "I", "a", "b", "c", "d", "Zeus", "Thanos", "a1", "a2"),
                                  start = c("-2500/-2000", "-750_-500", -1500, -1500, -400, -350, -150, 100, -200, -400, -1500, "-1100/-1000"),
                                  end = c(-1500, -200, -200, "-750_-500", -350, -250, 100, 300, 500, 300, "-1100/-1000", "-750_-500"),
                                  level = c(1, 2, 1, 2, 2, 2, 2, 2, 1, 1, 3, 3),
                                  add = c(FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE),
                                  new_table = TRUE),
               expected = test_reference)
  expect_equal(object = add_chron(test_reference,
                                  region = "Atlantis",
                                  name = "Gaia",
                                  start = 100,
                                  end = 0,
                                  level = 1,
                                  add = FALSE,
                                  new_table = FALSE),
               expected = test_reference2)
  expect_equal(object = add_chron(test_reference,
                                  region = "Atlantis",
                                  name = "Gaia",
                                  start = 100,
                                  end = "0/100",
                                  level = 1,
                                  add = FALSE,
                                  new_table = FALSE),
               expected = test_reference3)
  expect_error(object = add_chron(not_existent,
                                  region = "Atlantis",
                                  name = c("Atlas", "II", "Poseidon", "I", "a", "b", "c", "d", "Zeus", "Thanos", "a1", "a2"),
                                  start = c("-2500/-2000", -750, -1500, -1500, -400, -350, -150, 100, -200, -400, -1500, -1000),
                                  end = c(-1500, -200, -200, -750, -350, -250, 100, 300, 500, 300, -1000, -750),
                                  level = c(1, 2, 1, 2, 2, 2, 2, 2, 1, 1, 3, 3),
                                  add = c(FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE),
                                  new_table = FALSE),
               regexp = "object *")
  expect_error(object = add_chron(region = "Atlantis",
                                  name = c("Atlas", "II", "Poseidon", "I", "a", "b", "c", "d", "Zeus", "Thanos", "a1", "a2"),
                                  start = c("-2500/-2000", -750, -1500, -1500, -400, -350, -150, 100, -200, -400, -1500, -1000),
                                  end = c(-1500, -200, -200, -750, -350, -250, 100, 300, 500, 300, -1000, -750),
                                  level = c(1, 2, 1, 2, 2, 2, 2, 2, 1, 1, 3, 3),
                                  add = c(FALSE, "XXX", FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE),
                                  new_table = TRUE),
               regexp = "One *")
  expect_error(object = add_chron(region = "Atlantis",
                                  name = c("Atlas", "II", "Poseidon", "I", "a", "b", "c", "d", "Zeus", "Thanos", "a1", "a2"),
                                  start = c("-2500/-2000", -750, -1500, -1500, -400, -350, -150, 100, -200, -400, -1500, -1000),
                                  end = c(-1500, -200, -200, -750, -350, -250, 100, 300, 500, 300, -1000, -750),
                                  level = c(1, "D", 1, 2, 2, 2, 2, 2, 1, 1, 3, 3),
                                  add = c(FALSE, "XXX", FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE),
                                  new_table = TRUE),
               regexp = "One *")
  expect_error(object = add_chron(region = "Atlantis",
                                  name = c("Atlas", "II", "Poseidon", "I", "a", "b", "c", "d", "Zeus", "Thanos", "a1", "a2"),
                                  start = c(-2500, -750, -1500, -1500, -400, -350, -150, 100, -200, -400, -1500, -1000),
                                  end = c("-1500/-1000", -200, -200, -750, -350, -250, 100, 300, 500, 300, -1000, -750),
                                  level = c(1, 2, 1, 2, 2, 2, 2, 2, 1, 1, 3, 3),
                                  add = c(FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE),
                                  new_table = FALSE),
               regexp = "The argument *")
  expect_error(object = add_chron(region = "Atlantis",
                                  name = c("Atlas", "II", "Poseidon", "I", "a", "b", "c", "d", "Zeus", "Thanos", "a1", "a2"),
                                  start = c("-2500/-2000", -750, -1500, -1500, -400, -350, -150, 100, -200, -400, -1500, -1000),
                                  end = c(-1500, -200, -200, -750, -350, -250, 100, 300, 500, 300, -1000, -750),
                                  level = c(1.5, 2.3, 1, 2, 2, 2, 2, 2, 1, 1, 3, 3),
                                  add = c(FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE),
                                  new_table = TRUE),
               regexp = "Wrong input *")

})
