% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainclouds.R
\name{make_raincloud}
\alias{make_raincloud}
\title{Create a raincloud plot from a data frame through ggplotly}
\usage{
make_raincloud(
  dt,
  value,
  groups = NULL,
  adjust = 0.5,
  include_boxplot = TRUE,
  include_mean = FALSE,
  include_median = TRUE,
  force_all_jitter_obs = FALSE,
  ggtheme = "minimal",
  x_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = "plasma",
  static = FALSE
)
}
\arguments{
\item{dt}{data.frame containing the data to plot.}

\item{value}{Name of the column to use as values on the y axis of the plot.}

\item{groups}{Name of the column containing the different groups.}

\item{adjust}{Width of the kernel bins. The smaller the value, the higher the resolution of the density. For full details, see ?ggplot2::stat_density.}

\item{include_boxplot}{Include a boxplot over the raincloud. Default is TRUE.}

\item{include_mean}{Mark the median of each distribution. Default is TRUE.}

\item{include_median}{Mark the mean of each distribution. Default is FALSE.}

\item{force_all_jitter_obs}{When the data has more than 1000 observations, the function will sample 1000 observations in order to keep the object reasonably small. If you need to override it, set this value to TRUE.}

\item{ggtheme}{ggplot2 theme function to apply. Default is ggplot2::theme_minimal.}

\item{x_axis_label}{Label for the x axis.}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified or insufficient for the number of colors required.}

\item{static}{If TRUE, the output will be static ggplot chart instead of an interactive ggplotly chart. Default is FALSE.}
}
\value{
A plotly-ized version of a ggplot raincloud plot.
}
\description{
Create a raincloud plot from a data frame through ggplotly
}
\examples{
make_raincloud(dt = iris, value = 'Sepal.Width')
make_raincloud(dt = iris, value = 'Sepal.Width', adjust = 1)
make_raincloud(dt = iris, value = 'Petal.Length', groups = 'Species', static = TRUE, adjust = 1)
make_raincloud(dt = iris, value = 'Sepal.Length', groups = 'Species', adjust = 1)
}
