## -----------------------------------------------------------------------------
# Contributors: to add your helper to this table, add one row per helper in the
# following `tribble()` call. If you've authored a chores extension that includes
# multiple helpers, include a row for each helper.
quartochunk_code <-
'prompt_new(
  "quartochunk",
  "replace",
  "https://gist.githubusercontent.com/hfrick/1ca8fc2cb2a4409b743e8120c6cc2223/raw/a9703edfbd4e83839af0278c33add1b33e243d02/quartochunk-replace.md"
)'

revealjs_theming_code <-
'prompt_new(
  "revealjstheming",
  "replace",
  "https://gist.githubusercontent.com/EmilHvitfeldt/c2a3f8f294aec242144a9e135db2e2a3/raw/79298f9f5178a558e2c3422d745e7393fd483396/revealjs-scss-theming-prompt.md"
)'

news_code <-
'prompt_new(
  "news",
  "replace",
  "https://gist.githubusercontent.com/simonpcouch/8dbb3cd1fd79f9525bc1476d6fa7b668/raw/aec0da47f8edaf6cd758d7731e5ca5da0b981eb9/news-replace.md"
)'

gallery <- 
  tibble::tribble(
    ~Description, ~Role, ~Interface, ~Author, ~`Use it via...`,
    "[Convert erroring code to use cli](https://simonpcouch.github.io/chores/reference/cli_helper.html)", "cli", "replace", "Simon Couch", "library(chores)",
    "[Convert unit tests to testthat 3e](https://simonpcouch.github.io/chores/reference/testthat_helper.html)", "testthat", "replace", "Simon Couch", "library(chores)",
    "[Template function documentation with roxygen](https://simonpcouch.github.io/chores/reference/roxygen_helper.html)", "roxygen", "prefix", "Simon Couch", "library(chores)",
    "[Transition to Quarto-style chunk headers](https://gist.github.com/hfrick/1ca8fc2cb2a4409b743e8120c6cc2223)", "quartochunk", "replace", "Hannah Frick", quartochunk_code,
    "[Format NEWS files](https://gist.github.com/simonpcouch/8dbb3cd1fd79f9525bc1476d6fa7b668)", "news", "replace", "Hadley Wickham", news_code,
    "[Add or modify revealjs scss theming](https://gist.github.com/EmilHvitfeldt/c2a3f8f294aec242144a9e135db2e2a3)", "revealjstheming", "replace", "Emil Hansen", revealjs_theming_code,
    "[A ggplot2 assistant](https://github.com/frankiethull/ggpal2)", "ggplot2", "replace", "Frank Hull", "pak::pak(\"frankiethull/ggpal2\")\nlibrary(ggpal2)"
  ) 

gallery$`Use it via...` <- paste0("```\n", gallery$`Use it via...`, "\n```")

library(gt)

gt(gallery) %>%
  fmt_markdown(c(Description, `Use it via...`)) %>%
  opt_interactive(use_search = TRUE) %>%
  cols_width(c(Description, `Use it via...`) ~ px(220))

