% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-date.R
\name{chk_date}
\alias{chk_date}
\alias{vld_date}
\title{Check Date}
\usage{
chk_date(x, x_name = NULL)

vld_date(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks non-missing Date scalar using

\code{inherits(x, "Date") && length(x) == 1L && !anyNA(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_date}: Validate Date
}}

\examples{
# chk_date
chk_date(Sys.Date())
try(chk_date(1))
# vld_date
vld_date(Sys.Date())
vld_date(Sys.time())
vld_date(1)
}
\seealso{
Other chk_scalars: 
\code{\link{chk_date_time}()},
\code{\link{chk_number}()},
\code{\link{chk_scalar}()},
\code{\link{chk_string}()},
\code{\link{chk_tz}()},
\code{\link{chk_whole_number}()}
}
\concept{chk_scalars}
