% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patch_daily_temperatures.R
\name{patch_daily_temperatures}
\alias{patch_daily_temperatures}
\title{Patch gaps in daily weather records}
\usage{
patch_daily_temperatures(
  weather,
  patch_weather,
  vars = c("Tmin", "Tmax"),
  max_mean_bias = NA,
  max_stdev_bias = NA
)
}
\arguments{
\item{weather}{chillR-compatible weather record to be patched}

\item{patch_weather}{list of chillR-compatible weather records to be used for
patching holes in weather. They are used sequentially, until all have been used
or until there are no holes left.}

\item{vars}{vector of column names to be considered in patching. Defaults to
c("Tmin","Tmax"), the most common variables in chillR applications.}

\item{max_mean_bias}{maximum mean bias of auxiliary data compared to the original
dataset (applied to all variables in vars). If this threshold is exceeded, the
respective variable from that particular dataset will not be used. Defaults to NA,
meaning no records are excluded.}

\item{max_stdev_bias}{maximum standard deviation of the bias in the auxiliary
data compared to the original dataset (applied to all variables in vars). If this
threshold is exceeded, the respective variable from that particular dataset will not
be used. Defaults to NA, meaning no records are excluded.}
}
\value{
list of two elements: weather (the patched weather record, with additional
columns specifying the data source for each value) and statistics (containing
data.frames for each element of patch_weather that indicate the mean bias, the
number of values that were filled from this source and the number of missing records
that remained after exhausting this auxiliary data source.)
}
\description{
This function is deprecated. Better use \code{\link{patch_daily_temps}}!
}
\details{
This function uses auxiliary data sources to fill gaps in daily weather data.
It can accommodate multiple sources of auxiliary information, which are used
in the user-specified sequence. There have to be some overlapping records for
this to work, because without bias correction, this procedure could produce
erroneous records. Bias correction is done by computing the mean difference
between main and auxiliary data for each variable and adjusting for it in
filling the gaps. You can specify a maximum mean bias and a maximum standard
deviation of the bias to exclude unsuitable records that aren't similar
enough to the original data.
}
\examples{

gap_weather<-KA_weather[1:100,]
gap_weather[c(3,4,7:15,20,22:25,27:28,35:45,55,67,70:75,80:88,95:97),"Tmin"]<-NA
gap_weather[c(10:25,30,36:44,50,57,65,70:80,86,91:94),"Tmax"]<-NA
p1<-KA_weather[65:95,]
p1$Tmin<-p1$Tmin-2
p2<-KA_weather[c(15:40,60:80),]
p2$Tmax<-p2$Tmax+3
p3<-KA_weather[12:35,]
p3$Tmax<-p3$Tmax-2
p4<-KA_weather
p4$Tmax<-p4$Tmax+0.5
patch_weather<-list(stat1=p1,st2=p2,home=p3,last=p4)

patched<-patch_daily_temperatures(gap_weather,patch_weather,max_mean_bias=1)


}
\author{
Eike Luedeling
}
\keyword{gap-filling}
\keyword{temperature}
