% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bloom_prediction2.R
\name{bloom_prediction2}
\alias{bloom_prediction2}
\title{Bloom prediction from chilling and forcing requirements, assumed to be
fulfilled strictly in sequence - version 2}
\usage{
bloom_prediction2(
  HourChillTable,
  Chill_req,
  Heat_req,
  permutations = FALSE,
  Chill_model = "Chill_Portions",
  Heat_model = "GDH",
  Start_JDay = 305,
  infocol = NULL
)
}
\arguments{
\item{HourChillTable}{a data frame resulting from the chilling_hourtable
function.}

\item{Chill_req}{numeric vector indicating one or multiple chilling
requirements of the particular growth stage (in the unit specified by
"Chill_model")}

\item{Heat_req}{numeric vector indicating one or multiple heat requirements
of the particular growth stage (in Growing Degree Hours)}

\item{permutations}{boolean parameter indicating whether all possible
combinations of the supplied chilling and heat requirements should be used.
Defaults to FALSE, which means that the function matches chilling and heat
requirements according to their positions in the Chill_req and Heat_req
vectors and only predicts stage occurrence dates for these combinations.}

\item{Chill_model}{character string specifying the chill model to use. This
has to correspond to the name of the column in HourChillTable that contains
the chill accumulation (default is "Chill_Portions" for units of the Dynamic
Model).}

\item{Heat_model}{character string specifying the heat model to use. This
has to correspond to the name of the column in HourChillTable that contains
the heat accumulation (e.g "GDH").}

\item{Start_JDay}{numeric parameter indicating the day when chill
accumulation is supposed to start}

\item{infocol}{a vector of length length(Chill_req) which contains additional
information for each element of the vector. This is preserved and included
in the output. This only works when permutation=FALSE, and is meant to
facilitate recognition of particular phenological events in the output.}
}
\value{
data frame containing the predicted Julian dates of chilling requirement
fulfillment and timing of the phenological stage. Columns are Season, Creq, Hreq,
Creq_full (day when the chilling requirement is fulfilled) and Pheno_date
(the predicted date of the phenological event).
}
\description{
This is a pretty rudimentary function to predict phenological dates from
chilling and forcing requirements and hourly chilling and forcing data. Note
that there are enormous uncertainties in these predictions, which are hardly
ever acknowledged. So please use this function with caution.
}
\details{
This function is an update to the bloom_prediction function, which was
quite slow and didn't allow testing multiple chilling and heat requirements.
In this updated version, chilling and heat requirements can be supplied
as vectors, which are interpreted in sequence, with each pair of Chill_req
and Heat_req values matched according to their position in the vectors.
Through the permutations argument, it is also possible to compute stage
occurrence dates for all possible combinations of the requirements
specified by the Chill_req and Heat_req vectors.

The model allows specifying any numeric column as the chill and heat columns,
indicated by the Chill_model and Heat_model parameters.
}
\examples{

hourtemps <- stack_hourly_temps(fix_weather(KA_weather[which(KA_weather$Year > 2008), ]),
                                latitude = 50.4)

CT <- chilling_hourtable(hourtemps, Start_JDay = 305)

bloom_prediction2(CT, c(30, 40, 50), c(1000, 1500, 2000))
bloom_prediction2(CT, c(30, 40, 50), c(1000, 1500, 2000), permutations = TRUE)


}
\references{
Model references:

Dynamic Model:

Erez A, Fishman S, Linsley-Noakes GC, Allan P (1990) The dynamic model for
rest completion in peach buds. Acta Hortic 276, 165-174

Fishman S, Erez A, Couvillon GA (1987a) The temperature dependence of
dormancy breaking in plants - computer simulation of processes studied under
controlled temperatures. J Theor Biol 126(3), 309-321

Fishman S, Erez A, Couvillon GA (1987b) The temperature dependence of
dormancy breaking in plants - mathematical analysis of a two-step model
involving a cooperative transition. J Theor Biol 124(4), 473-483

Growing Degree Hours:

Anderson JL, Richardson EA, Kesner CD (1986) Validation of chill unit and
flower bud phenology models for 'Montmorency' sour cherry. Acta Hortic 184,
71-78
}
\author{
Eike Luedeling
}
\keyword{bloom}
\keyword{prediction}
