% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempResponse_hourtable.R
\name{tempResponse_hourtable}
\alias{tempResponse_hourtable}
\title{Add metric accumulation to table of hourly temperatures}
\usage{
tempResponse_hourtable(hourtemps, Start_JDay, models = c(Chill_Portions =
  Dynamic_Model, GDH = GDH_model))
}
\arguments{
\item{hourtemps}{a dataframe of stacked hourly temperatures (e.g. produced
by stack_hourly_temps). This data frame must have a column for Year, a
column for JDay (Julian date, or day of the year), a column for Hour and a
column for Temp (hourly temperature).}

\item{Start_JDay}{the start date (in Julian date, or day of the year) of the
calculation for the four metrics. The count is restarted on this date every
year.}

\item{models}{named list of models that should be applied to the hourly
temperature data. These should be functions that take as input a vector of
hourly temperatures. This defaults to c(Chill_Portions = Dynamic_Model, GDH
= GDH_model), which refer to the Dynamic chill model and the Growing Degree
Hours model functions contained in chillR.}
}
\value{
data frame consisting of all the columns of the THourly input data
frame, plus one additional column for each model, which contains the
cumulative number of model metrics since the last Start_JDay).
}
\description{
This function calculates cumulative values for temperature response metrics
for every hour of an hourly temperature record. The count is
restarted on a specified date each year. The function is a generalized
version of chilling_hourtable, which only worked with three predefined
chilling one predefined heat metrics.
}
\note{
After doing extensive model comparisons, and reviewing a lot of
relevant literature, I do not recommend using the Chilling Hours or Utah
Models, especially in warm climates! The Dynamic Model (Chill Portions),
though far from perfect, seems much more reliable.
}
\examples{

weather<-fix_weather(KA_weather[which(KA_weather$Year>2008),])

hourtemps<-stack_hourly_temps(weather,latitude=50.4)

cht<-chilling_hourtable(hourtemps,20)

}
\references{
Model references:


Dynamic Model:

Erez A, Fishman S, Linsley-Noakes GC, Allan P (1990) The dynamic model for
rest completion in peach buds. Acta Hortic 276, 165-174

Fishman S, Erez A, Couvillon GA (1987a) The temperature dependence of
dormancy breaking in plants - computer simulation of processes studied under
controlled temperatures. J Theor Biol 126(3), 309-321

Fishman S, Erez A, Couvillon GA (1987b) The temperature dependence of
dormancy breaking in plants - mathematical analysis of a two-step model
involving a cooperative transition. J Theor Biol 124(4), 473-483

Growing Degree Hours:

Anderson JL, Richardson EA, Kesner CD (1986) Validation of chill unit and
flower bud phenology models for 'Montmorency' sour cherry. Acta Hortic 184,
71-78

Review on chilling models in a climate change context:

Luedeling E, 2012. Climate change impacts on winter chill for temperate
fruit and nut production: a review. Scientia Horticulturae 144, 218-229
}
\author{
Eike Luedeling
}
\keyword{and}
\keyword{calculation}
\keyword{chill}
\keyword{heat}
