% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aet05.R
\docType{data}
\name{aet05_main}
\alias{aet05_main}
\alias{aet05_pre}
\alias{aet05_post}
\alias{aet05}
\title{\code{AET05} Table 1 (Default) Adverse Event Rate Adjusted for Patient-Years at Risk - First Occurrence.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
aet05_main(
  adam_db,
  dataset = "adsaftte",
  arm_var = "ACTARM",
  lbl_overall = NULL,
  ...
)

aet05_pre(adam_db, dataset = "adsaftte", ...)

aet05_post(tlg, prune_0 = FALSE, ...)

aet05
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{dataset}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{arm_var}{(\code{string}) the arm variable used for arm splitting.}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{...}{Further arguments passed to \code{tern::control_incidence_rate()}.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The \code{AET05} table produces the standard adverse event rate adjusted for patient-years at risk summary
considering first occurrence.
}
\details{
\itemize{
\item Total patient-years at risk is the sum over all patients of the time intervals (in years).
\item Split columns by arm, typically \code{ACTARM}.
\item Split rows by parameter code.
\item \code{AVAL} is patient-years at risk.
\item \code{N_EVENTS} is the number of adverse events observed.
\item The table allows confidence level to be adjusted, default is 95\%.
\item Keep zero count rows by default.
}
}
\section{Functions}{
\itemize{
\item \code{aet05_main()}: Main TLG function

\item \code{aet05_pre()}: Preprocessing

\item \code{aet05_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain table named as \code{dataset} with the columns \code{"PARAMCD"}, \code{"PARAM"},
\code{"AVAL"}, and \code{"CNSR"}.
}
}
\examples{
library(dplyr)
library(dunlin)

proc_data <- log_filter(syn_data, PARAMCD == "AETTE1", "adsaftte")

run(aet05, proc_data)

run(aet05, proc_data, conf_level = 0.90, conf_type = "exact")
}
\keyword{datasets}
