% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext01.R
\docType{data}
\name{ext01_main}
\alias{ext01_main}
\alias{ext01_pre}
\alias{ext01_post}
\alias{ext01}
\title{\code{EXT01} Exposure Summary Table.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
ext01_main(
  adam_db,
  arm_var = "ACTARM",
  lbl_overall = NULL,
  summaryvars = "AVAL",
  row_split_var = "PARCAT2",
  page_var = NULL,
  map = NULL,
  ...
)

ext01_pre(adam_db, ...)

ext01_post(tlg, prune_0 = TRUE, ...)

ext01
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{summaryvars}{(\code{character}) variables to be analyzed. The label attribute of the corresponding column in \code{adex}
table of \code{adam_db} is used as label.}

\item{row_split_var}{(\code{character}) additional row split variables.}

\item{page_var}{(\code{string}) variable name prior to which the row split is by page.}

\item{map}{(\code{data.frame}) of mapping for split rows.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The \code{EXT01} table provides an overview of the of the exposure of the
patients in terms of Total dose administered or missed, and treatment duration.
}
\details{
\itemize{
\item Default Exposure table
\item The \code{n} row provides the number of non-missing values. The percentages for categorical variables is based on \code{n}.
The percentages for \verb{Total number of patients with at least one dose modification} are based on the number of
patients in the corresponding analysis population given by \code{N}.
\item Split columns by arm, typically \code{ACTARM}.
\item Does not include a total column by default.
\item Sorted by alphabetic order of the \code{PARAM} value. Transform to factor and re-level for custom order.
\item \code{ANL01FL} is not relevant subset.
}
}
\section{Functions}{
\itemize{
\item \code{ext01_main()}: Main TLG function

\item \code{ext01_pre()}: Preprocessing

\item \code{ext01_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adex} table with columns specified in \code{summaryvars}.
}
}
\examples{
run(ext01, syn_data)

run(ext01, syn_data, summaryvars = c("AVAL", "AVALCAT1"), prune_0 = FALSE)

levels(syn_data$adex$AVALCAT1) <- c(levels(syn_data$adex$AVALCAT1), "12 months")
map <- data.frame(
  PARAMCD = "TDURD",
  AVALCAT1 = c("< 1 month", "1 to <3 months", ">=6 months", "3 to <6 months", "12 months")
)
run(ext01, syn_data, summaryvars = c("AVAL", "AVALCAT1"), prune_0 = FALSE, map = map)
}
\keyword{datasets}
