% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chevron_tlg-S4class.R
\docType{class}
\name{chevron_tlg-class}
\alias{chevron_tlg-class}
\alias{.chevron_tlg}
\alias{chevron_t-class}
\alias{.chevron_t}
\alias{chevron_table}
\alias{chevron_l-class}
\alias{.chevron_l}
\alias{chevron_listing}
\alias{chevron_g-class}
\alias{.chevron_g}
\alias{chevron_graph}
\alias{chevron_simple-class}
\alias{.chevron_simple}
\alias{chevron_simple}
\alias{chevron_t}
\alias{chevron_l}
\alias{chevron_g}
\title{\code{chevron_t}}
\usage{
chevron_t(
  main = function(adam_db, ...) build_table(basic_table(), adam_db[[1]]),
  preprocess = function(adam_db, ...) adam_db,
  postprocess = report_null,
  ...
)

chevron_l(
  main = function(adam_db, ...) data.frame(),
  preprocess = function(adam_db, ...) adam_db,
  postprocess = function(tlg, ...) tlg,
  ...
)

chevron_g(
  main = function(adam_db, ...) ggplot2::ggplot(),
  preprocess = function(adam_db, ...) adam_db,
  postprocess = function(tlg, ...) tlg,
  ...
)

chevron_simple()
}
\arguments{
\item{main}{(\code{function}) returning a \code{tlg}, with \code{adam_db} as first argument. Typically one of the \verb{_main} function
of \code{chevron}.}

\item{preprocess}{(\code{function}) returning a pre-processed \code{list} of \code{data.frames}, with \code{adam_db} as first argument.
Typically one of the \verb{_pre} function of \code{chevron}.}

\item{postprocess}{(\code{function}) returning a post-processed \code{tlg}, with \code{tlg} as first argument.}

\item{...}{not used}
}
\value{
a \code{chevron_t} class object.

a \code{chevron_l} class object.

a \code{chevron_g} class object.

a \code{chevron_simple} class object.
}
\description{
\code{chevron_t}, a subclass of \linkS4class{chevron_tlg} with specific validation criteria to handle table creation

\code{chevron_l}, a subclass of \linkS4class{chevron_tlg} with specific validation criteria to handle listing creation

\code{chevron_g}, a subclass of \linkS4class{chevron_tlg} with specific validation criteria to handle graph creation

\code{chevron_simple}, a subclass of \linkS4class{chevron_tlg}, where main function is a simple call
}
\section{Slots}{

\describe{
\item{\code{main}}{(\code{function}) returning a \code{tlg}. Typically one of the \verb{*_main} function from \code{chevron}.}

\item{\code{preprocess}}{(\code{function}) returning a pre-processed \code{list} of \code{data.frames} amenable to \code{tlg} creation. Typically
one of the \verb{*_pre} function from \code{chevron}.}

\item{\code{postprocess}}{(\code{function}) returning a post-processed \code{tlg}. Typically one of the \verb{*_post} function from
\code{chevron}.}
}}

\note{
To ensure the correct execution of the workflow, additional validation criteria are:
\itemize{
\item the first argument of the \code{main} function must be \code{adam_db}, the input \code{list} of \code{data.frames} to pre-process. The
\code{...} argument is mandatory.
\item the first argument of the \code{preprocess} function must be \code{adam_db}, the input \code{list} of \code{data.frames} to create
\code{tlg} output. The \code{...} argument is mandatory.
\item the first argument of the \code{postprocess} function must be \code{tlg}, the input \code{TableTree} object to post-process. The
\code{...} argument is mandatory.
}
}
\examples{
chevron_t_obj <- chevron_t()
chevron_t_obj <- chevron_t(postprocess = function(tlg, indent, ...) {
  rtables::table_inset(tlg) <- indent
  tlg
})

chevron_l_obj <- chevron_l()

chevron_g_obj <- chevron_g()
chevron_g_obj <- chevron_g(
  postprocess = function(tlg, title, ...) tlg + ggplot2::labs(main = title)
)

chevron_simple_obj <- chevron_simple()
}
