% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chest_glm.R
\name{chest_glm}
\alias{chest_glm}
\title{Assessing confounding effects using Generalized Linear regression models}
\usage{
chest_glm(
  crude,
  xlist,
  data,
  var_lab = "Variables",
  est_lab = "OR (95\% CI)",
  change_lab = "Change, \%",
  digits = "\%.2f",
  digits_change = "\%.1f",
  family = "binomial",
  method = "glm.fit",
  maxit = 25,
  epsilon = 1e-08,
  na_omit = FALSE,
  hrzl_lines = gpar(col = "#444444"),
  text_size = 1,
  xlab_size = 1,
  xtick_size = 1,
  xlab = NULL,
  indicate = FALSE,
  plus = "  + ",
  ...
)
}
\arguments{
\item{crude}{An object of \emph{formula} for initial model, generally crude model.
However, any other variables can also be included here as the initial model.}

\item{xlist}{A \emph{vector} of characters with all variable names of potential confounders.}

\item{data}{\emph{Data frame}.}

\item{var_lab}{\emph{Character} string for the column name of variables in the graph.}

\item{est_lab}{\emph{Character} string for the column name of effect estimates.}

\item{change_lab}{\emph{Character} string for the column name of "Changes".}

\item{digits}{Set the display format for number in the graph other than the \emph{"Change"} column. Default: "\%.2f"}

\item{digits_change}{Set the format for the \emph{"Change"} column. Default: "\%.1f"}

\item{family}{Description of the error distribution. Default is "binomial".}

\item{method}{Method to detect for singularity.}

\item{maxit}{See \code{'glm'}.}

\item{epsilon}{See \code{'glm'}.}

\item{na_omit}{Remove all missing values.}

\item{hrzl_lines}{A \emph{logic} to include or remove horizontal line.}

\item{text_size}{Set text size.}

\item{xlab_size}{Set \code{x} label size.}

\item{xtick_size}{Set \code{x} tick label size.}

\item{xlab}{Add \code{x} label.}

\item{indicate}{indicate progress}

\item{plus}{Change the \code{+} sign before variable names.}

\item{...}{Further optional arguments for forestplot.}
}
\value{
A table with effect estimates and their changes at all steps.
}
\description{
Please note: There is a faster option: \code{'chest_speedglm'}. \code{'chest_glm'}
is used to assess confounding effects using Generalized Linear Models, such as
logistic regression and Poisson regression with \code{'glm'}.
It presents \emph{odds ratios} or \emph{rate ratios} for the association
between exposure and outcome variables by adding other variables (potential
confounders) to the model sequentially. The order of variables to be added is
based on the magnitudes of the changes in effect estimates.
}
\examples{

chest_glm(crude = "Endpoint ~ Diabetes", xlist = c("Age", "Sex", "Married"),
na_omit=TRUE, data = diab_df)

}
\seealso{
\pkg{'forestplot'}

\code{'glm'} \pkg{'stats'}

for effects estimates from all possible models.
}
