% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tzone.R
\name{check_tzone}
\alias{check_tzone}
\alias{check_tz}
\title{Check TimeZone}
\usage{
check_tzone(x, tzone = "UTC", x_name = substitute(x), error = TRUE)

check_tz(x, tz = "UTC", x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{tzone}{A string of the time zone.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}

\item{tz}{A string of the time zone.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks an objects tzone attribute.
}
\examples{
check_tzone(Sys.Date(), error = FALSE)
x <- as.POSIXct("2000-01-02 03:04:55", tz = "Etc/GMT+8")
check_tzone(x, tzone = "PST8PDT", error = FALSE)
}
